function[output] = shutdown_JO(X,Y)

% obtain model parameters
paraEst         =  NestedMLE(X, Y);
para.c0         =  paraEst(1);
para.c1         =  paraEst(2);
para.rho  		=  paraEst(3);
para.sigma      =  paraEst(4);

% Traffic after shutting down the small platform 
 
Xnew = [X(:,1)+ 1.*X(:,3)./2 ...
        X(:,2)+ 1.*X(:,3)./2];

% - calculate SC: with strategic interaction - %

epsilonEq 	   	=  solveEq_JO(para, X);
sigmahat       	=  1 - normcdf(epsilonEq,0,para.sigma);
SC             	=  mean(sum(sigmahat .* X, 2));

para.beta0      = para.c0.*ones(2,1);
para.beta1      = (para.c1-1).*ones(2,1);
para.delta      = - ones(2,1)./(2-1);
epsNew   		=  solveEq(para, Xnew);
sigmaNew 		=  1 - normcdf(epsNew, 0, para.sigma);
SCNew    		=  mean(sum(sigmaNew .* Xnew, 2));

% percentage changes in SC
DSC = (SCNew - SC)/SC*100;

% absolute changes in censorship probability of the remaining two firms
Dsigma = mean((sigmaNew - sigmahat(:,[1,2])));

output = [DSC Dsigma(1) Dsigma(2)];

end


