function[output] = shutdown(X,Y)

% obtain model parameters
paraEst         =  NestedMLE(X, Y);
para.c0         =  paraEst(1);
para.c1         =  paraEst(2);
para.rho  		=  paraEst(3);
para.sigma      =  paraEst(4);

% New traffic after shutting down the small platform 
Xnew            = [X(:,1)+ X(:,3)./2 ...
                   X(:,2)+ X(:,3)./2];

% - calculate SC: with strategic interaction - %
N               =  size(X,2);
para.beta0  	=  ones(N,1).* para.c0; 
para.beta1  	=  ones(N,1).* (para.c1-1);	
para.delta  	=  - ones(N,1).*1./(N-1);

epsilonEq 	   	=  solveEq(para, X);
sigmahat       	=  1 - normcdf(epsilonEq,0,para.sigma);
SC             	=  mean(sum(sigmahat .* X, 2));

N               = size(Xnew,2);
para.beta0  	=  ones(N,1).* para.c0;
para.beta1  	=  ones(N,1).* (para.c1-1);	
para.delta  	=  - ones(N,1)./(N-1);
epsNew   		=  solveEq(para, Xnew);
sigmaNew 		=  1 - normcdf(epsNew, 0, para.sigma);
SCNew    		=  mean(sum(sigmaNew .* Xnew, 2));

% percentage changes in SC
DSC = (SCNew - SC)/SC*100;

% absolute changes in censorship probability of the remaining two firms
Dsigma = mean((sigmaNew - sigmahat(:,[1,2])));

% - calculate SC: w/o strategic interaction - %
N                       = size(X,2);
para.beta0  			=  ones(N,1).* para.c0; 
para.beta1  			=  ones(N,1).* (para.c1-1);	
para.delta  			=  - ones(N,1)./(N-1);
epsilonEq_noInter 		= solveEqNoInter(para, X);
sigmahat_noInter      	= 1 - normcdf(epsilonEq_noInter,0,para.sigma);
SC_noInter            	= mean(sum(sigmahat_noInter .* X, 2));

N                       = size(Xnew,2);
para.beta0  			=  ones(N,1).* para.c0; 
para.beta1  			=  ones(N,1).* (para.c1-1);	
para.delta  			=  - ones(N,1)./(N-1);
epsNew_noInter   	    = solveEqNoInter(para, Xnew);
sigmaNew_noInter 	    = 1 - normcdf(epsNew_noInter, 0, para.sigma);
SCNew_noInter    	    = mean(sum(sigmaNew_noInter .* Xnew, 2));

DSC_noInter = (SCNew_noInter - SC_noInter)/SC_noInter*100;

output = [DSC DSC_noInter Dsigma(1) Dsigma(2)];

end


