function[out] = objFunc_JO(theta,X,Y)
	
	% solve the equilibrium 
    para.c0     = theta(1);
    para.c1     = theta(2);
    para.rho    = theta(3);
    para.sigma  = theta(4);

	% calculate joint choice probabilities
	[epsilonEq,flagS] =  solveEq_JO(para, X);
        if flagS == 0
            out = 1.0e8;
        else
            try
                logL = logLikelihood_JO(Y, epsilonEq,para.rho,para.sigma);
                out  = -logL;
            catch
                out = 1.0e8;
            end
        end	
end