function[out] = objFunc(theta,N,X,Y)
	
	para.beta0     =  ones(N,1).*theta(1);
	para.beta1     =  ones(N,1).*(theta(2)-1);
	para.delta     =  - ones(N,1)./(N-1);
    para.rho       =  theta(3);
    para.sigma     =  theta(4);
	

	% calculate joint choice probabilities
	[epsilonEq,flagS] =  solveEq(para, X);
        if flagS == 0
            out = 1.0e8;
        else
            try
                logL = logLikelihood(Y, epsilonEq,para.rho,para.sigma);
                out  = -logL;
            catch
                out = 1.0e8;
            end
        end	

end