function[output] = merger_JO(X,Y)

% obtain model parameters
paraEst         = NestedMLE(X, Y);
para.c0         = paraEst(1);
para.c1         = paraEst(2);
para.rho  		= paraEst(3);
para.sigma      = paraEst(4);

% Merging medium and small firms
Xmerged = [X(:, 1) X(:, 2) + X(:, 3)];


% - calculate SC: with strategic interaction - % 
epsilonEq 	   	= solveEq_JO(para, X);
sigmahat       	= 1 - normcdf(epsilonEq,0,para.sigma);
SC             	= mean(sum(sigmahat .* X, 2));

para.beta0      = para.c0.*ones(2,1);
para.beta1      = (para.c1-1).*ones(2,1);
para.delta      = - ones(2,1)./(2-1);
epsMerged   	= solveEq(para, Xmerged);
sigmaMerged 	= 1 - normcdf(epsMerged, 0, para.sigma);
SCMerged    	= mean(sum(sigmaMerged .* Xmerged, 2));

% percentage changes in SC
DSC = (SCMerged - SC)/SC*100; 

% absolute changes 
Dsigma = mean((sigmaMerged - sigmahat(:,[1,2])));

output = [DSC Dsigma(1) Dsigma(2)];

end


