function[output] = merger(X,Y)

% obtain model parameters
paraEst         = NestedMLE(X, Y);
para.c0         = paraEst(1);
para.c1         = paraEst(2);
para.rho  		= paraEst(3);
para.sigma      = paraEst(4);

% New traffic after merging medium and small firms
Xmerged = [X(:, 1) X(:, 2) + X(:, 3)];


% - calculate SC: with strategic interaction - % 
N               = size(X,2);
para.beta0  	=  ones(N,1).* para.c0; 
para.beta1  	=  ones(N,1).* (para.c1 - 1);	
para.delta  	=  - ones(N,1)./(N-1);
epsilonEq 	   	= solveEq(para, X);
sigmahat       	= 1 - normcdf(epsilonEq,0,para.sigma);
SC             	= mean(sum(sigmahat .* X, 2));

N               = size(Xmerged,2);
para.beta0  	=  ones(N,1).* para.c0; 
para.beta1  	=  ones(N,1).* (para.c1 - 1);	
para.delta  	=  - ones(N,1)./(N-1);
epsMerged   	= solveEq(para, Xmerged);
sigmaMerged 	= 1 - normcdf(epsMerged, 0, para.sigma);
SCMerged    	= mean(sum(sigmaMerged .* Xmerged, 2));

% percentage changes in SC
DSC = (SCMerged - SC)/SC*100; 

% absolute changes in censorship probability of the remaining two firms
Dsigma = mean((sigmaMerged - sigmahat(:,[1,2])));


% - calculate SC: without strategic interaction %
N                       =  size(X,2);
para.beta0  			=  ones(N,1).* para.c0; 
para.beta1  			=  ones(N,1).* (para.c1 - 1);	
para.delta  			=  - ones(N,1)./(N-1);
epsilonEq_noInter 	   	= solveEqNoInter(para, X);
sigmahat_noInter       	= 1 - normcdf(epsilonEq_noInter,0,para.sigma);
SC_noInter             	= mean(sum(sigmahat_noInter .* X, 2));

N                       = size(Xmerged,2);
para.beta0  			=  ones(N,1).* para.c0; 
para.beta1  			=  ones(N,1).* (para.c1 - 1);	
para.delta  			=  - ones(N,1)./(N-1);
epsMerged_noInter   	= solveEqNoInter(para, Xmerged);
sigmaMerged_noInter 	= 1 - normcdf(epsMerged_noInter, 0, para.sigma);
SCMerged_noInter    	= mean(sum(sigmaMerged_noInter .* Xmerged, 2));

DSC_noInter = (SCMerged_noInter - SC_noInter)/SC_noInter*100;

output = [DSC DSC_noInter Dsigma(1) Dsigma(2)];

end


