function [logL] = logLikelihood(Y, Eps,rho,sigma)

	mu 		   = [0         0       0];
	corrMatrix = [1         rho     rho;
				  rho       1       rho; 
				  rho       rho     1];
	corrMatrix = corrMatrix .* (sigma^2);
    
	logL = 0;
    
	parfor i = 1 : size(Y,1) 
		Sigma = corrMatrix .* [1 	                       (1-2.*Y(i,1)).*(1-2.*Y(i,2)) (1-2.*Y(i,1)).*(1-2.*Y(i,3));
							  (1-2.*Y(i,2)).*(1-2.*Y(i,1))  1 							(1-2.*Y(i,2)).*(1-2.*Y(i,3));
							  (1-2.*Y(i,3)).*(1-2.*Y(i,1)) (1-2.*Y(i,3)).*(1-2.*Y(i,2))  1 							];
		z = mvncdf(Eps(i,:).*(1-2.*Y(i,:)),mu,Sigma);

		logL = logL + log(max(.000001, min(.999999,z)));
	end

end