function [paraHat,fval,flag] = TwoStepMMSE(X, Y)
	%% This function aims to estimate parameters using 2-step Modified MSE (Manski & Tamer, 2002) 
	%% Step 1 - nonparametrically estimate upper and lower bounds (v_i^0, v_i^1);  ...
	%% 			the density weights fX; ... 
	%%			players’ marginal choice probabilities 1􏰂[p_i(x)≥1/2􏰃]; ...
	%% 			
	%% Step 2 - Plug upper and lower bounds into the likelihood function and maximize w.r.t. model parameters

	flag    = 1;
	options = optimset('Display','off','TolX',1e-8,'MaxFunEvals',10000,'MaxIter',10000);

	%display('STEP 1: ESTIMATE UPPER, LOWER BOUNDS AND MARGINAL CHOICE PROBABILITIES')
	N  = size(X, 2);
	n  = size(X, 1);
	h = 0.5*1.06*n^(-1/8); % bandwidth
	vSum0 = zeros(n, N);
	vSum1 = zeros(n, N);
	DELTA = zeros(n, N);

	DX1 =  repmat(X(:,1),1,n) - repmat(X(:,1)',n,1);
    DX2 =  repmat(X(:,2),1,n) - repmat(X(:,2)',n,1);
    DX3	=  repmat(X(:,3),1,n) - repmat(X(:,3)',n,1);

    Ker = K3(DX1./h).*K3(DX2./h).*K3(DX3./h);
    weight = ((1/n/h^2).*Ker'*ones(n,1)).*(Ker'*ones(n,1)>0).*(X(:,1).^2 +X(:,2).^2 + X(:,3).^2 ).^1.5;
    weight = repmat(weight,1,N);
    
    for i = 1: N
    	for j = 1: N
    		v_0 = (((1-Y(:,i)).*Y(:,j))'*Ker)./((1-Y(:,i))'*Ker); 
    		v_0 = v_0';
    		v_0 = (v_0>1) + (v_0<0).*0 + (v_0<=1).*(v_0>=0).*v_0; % lower bound
    		v_1 = ((Y(:,i).*Y(:,j))'*Ker)./(Y(:,i)'*Ker);
    		v_1 = v_1';
    		v_1 = (v_1>1) + (v_1<0).*0 + (v_1<=1).*(v_1>=0).*v_1; % upper bound
    		if j ~= i
    			vSum0(:,i) = vSum0(:,i) + v_0.* X(:,j);
    			vSum1(:,i) = vSum1(:,i) + v_1.* X(:,j);
    		end
    	end
    	p_1  = (Y(:,i)'*Ker)./(ones(1,n)*Ker); 
    	p_1  =  p_1';
    	p_1  = (p_1>1) + (p_1<0).*0 + (p_1<=1).*(p_1>=0).*p_1; % propensity.
    	DELTA(:,i) = (p_1>=0.5);
    end

	%display('STEP2 : ESTIMATE MODEL PARAMETERS')
    rng(0,"twister")
    lb              = [-1  0];
    ub              = [5   4]; 
    nonlcon = @uniEqConstraint;

	[paraHat,fval,flag]  = ga(@(p)MMSEobjFunc(p,X,Y,DELTA,vSum0,vSum1,weight),2,[],[],[],[],lb,ub,nonlcon, options);
     
end