function [paraHat,fval,flag] = NestedMLE_JO(X, Y)
	%% This function aims to estimate parameters using MLE 
	%tic
	options = optimset('Display','off','TolX',1e-8,'MaxFunEvals',10000,'MaxIter',10000);

	% Find the estimator that maximizes the likelihood
    rng default;
    rho_ub   = 0.8;    
	para0	              = [0       1         0.2           1];
	lb					  = [-1 	 -5        0.0           0];
	ub					  = [5       5        rho_ub        5];
    nonlcon = @uniEqConstraint_JO;
	[paraHat,fval,flag]   = fmincon(@(x)objFunc_JO(x,X,Y),para0,[],[],[],[],lb,ub,nonlcon,options);

    %toc
end