function[out] = MMSEobjFunc(param, X,Y, DELTA, vSum0,vSum1,weight)
	N  = size(X, 2);
	n  = size(X, 1);
	thetaHat  =  zeros(n, N);

	beta0     =  ones(N,1).*param(1);
	beta1     =  ones(N,1).*(param(2)-1);
	delta     =  - 1.*ones(N,1)./(N-1);
	

	for k = 1 : N
		thetaHat(:,k) =  DELTA(:,k)       .* (beta0(k).* ones(n,1) + beta1(k).* X(:,k) +delta(k).* vSum0(:,k)>=0) +  ...
						 (1 - DELTA(:,k)) .* (beta0(k).* ones(n,1) + beta1(k).* X(:,k) +delta(k).* vSum1(:,k)>=0);
	end
	L    = ((2.*Y - 1).* weight) .* thetaHat;
	out  = -sum(sum(L))/(n*(n - 1));
end