%% This script plots Figure 9-11 in Appendix B

clear all
clc

% --------------------------------------------------------------- %
% Figure 9: censorship prob. vs  c1
% --------------------------------------------------------------- % 

% model parameters
X 	 	 = [.6 .3 .1];
N        = length(X);
gridSize = 100;
c0grid   = [0.1 -0.1];
c1grid   = linspace(0,2,gridSize);
sigmaEq  = zeros(length(c1grid), N,length(c0grid));

para.delta     =  - ones(N,1)./(N-1);
para.rho       =  0.2;
para.sigma     =  1;

for i = 1: length(c0grid)

    c0 = c0grid(i);

    for j = 1: length(c1grid)

	    c1 =  c1grid(j);
        
        para.beta0     =  ones(N,1).* c0;
        para.beta1     =  ones(N,1).*(c1 - 1);

	    epsilonEq       = solveEq(para, X);
        sigmaEq(j,:,i)  = 1 - normcdf(epsilonEq,0,para.sigma);

    end	
end 

fa = figure('Visible', 'off');
plot(c1grid, sigmaEq(:,1,1),'r-','LineWidth',3,'Color',[.5 .3 .3])
hold on
plot(c1grid, sigmaEq(:,2,1),'r-','LineWidth',2,'Color',[.3 .3 .3])
hold on
plot(c1grid, sigmaEq(:,3,1),'r-.','LineWidth',1,'Color',[.3 .3 .3])
xlim([0,2])
legend(['Platform 1 (x_1 = ' num2str(X(1)) ')'],['Platform 2 (x_2 = ' num2str(X(2)) ')'],['Platform 3 (x_3 = ' num2str(X(3)) ')'], 'Location','SouthEast');
xlabel('Legal Cost per User ($c_1$)','Interpreter','Latex','FontSize',18);
ylabel('Equilibrium Probability of Compliance','Interpreter','Latex','FontSize',18);
set(gca,'fontsize', 16);
print(fa, '-dpdf','../../output/Figure9a.pdf','-bestfit')

fb = figure('Visible', 'off');
plot(c1grid, sigmaEq(:,1,2),'r-','LineWidth',3,'Color',[.5 .3 .3])
hold on
plot(c1grid, sigmaEq(:,2,2),'r-','LineWidth',2,'Color',[.3 .3 .3])
hold on
plot(c1grid, sigmaEq(:,3,2),'r-.','LineWidth',1,'Color',[.3 .3 .3])
xlim([0,2])
legend(['Platform 1 (x_1 = ' num2str(X(1)) ')'],['Platform 2 (x_2 = ' num2str(X(2)) ')'],['Platform 3 (x_3 = ' num2str(X(3)) ')'], 'Location','SouthEast');
xlabel('Legal Cost per User ($c_1$)','Interpreter','Latex','FontSize',18);
ylabel('Equilibrium Probability of Compliance','Interpreter','Latex','FontSize',18);
set(gca,'fontsize', 16);
print(fb, '-dpdf','../../output/Figure9b.pdf','-bestfit')

% --------------------------------------------------------------- %
% Figure 10: censorship prob. (of identical firms) vs. N
% --------------------------------------------------------------- % 

Ngrid    = 2:15; 
c1grid   = [0.5 2];
sigmaEq  = zeros(length(Ngrid),length(c1grid));

para.rho       =  0.2;
para.sigma     =  1;

for i = 1: length(c1grid)

    c1           = c1grid(i);

    for j = 1: length(Ngrid)

	    N           =  Ngrid(j);
        X           =  ones(1,N)./N;
        para.beta0  =  ones(N,1).* 0.1;
        para.beta1  =  ones(N,1).*(c1 - 1);
        para.delta  =  - ones(N,1)./(N-1);
        
	    epsilonEq     = solveEq(para, X);
        sigmaEq(j,i)  =  1 - normcdf(epsilonEq(1),0,para.sigma);

    end	
end

fa = figure('Visible', 'off');
scatter(Ngrid, sigmaEq(:,1),50, 'MarkerFaceColor','black')
xlabel('Number of Platforms ($N$)','Interpreter','Latex','FontSize',14);
ylabel('Equilibrium Probability of Compliance','Interpreter','Latex','FontSize',14);
set(gca,'fontsize', 16);
set(gcf,'position',[10,10,500,400]);
box on
print(fa, '-dpdf','../../output/Figure10a.pdf','-bestfit')

fb = figure('Visible', 'off');
scatter(Ngrid, sigmaEq(:,2),50, 'MarkerFaceColor','black')
xlabel('Number of Platforms ($N$)','Interpreter','Latex','FontSize',14);
ylabel('Equilibrium Probability of Compliance','Interpreter','Latex','FontSize',14);
set(gca,'fontsize', 16);
set(gcf,'position',[10,10,500,400]);
box on
print(fb, '-dpdf','../../output/Figure10b.pdf','-bestfit')


% --------------------------------------------------------------- %
% Figure 11: censorship prob. (of identical firms) vs. rho
% --------------------------------------------------------------- % 

Ngrid    = [3   5]; 
c1grid   = [0.5 2];
gridSize = 10;
rhogrid  = linspace(0,0.9,gridSize);
sigmaEq  = zeros(length(rhogrid), length(Ngrid),length(c1grid));

para.sigma     =  1;

for i = 1: length(c1grid)

    c1           = c1grid(i);
    
    for j = 1:length(Ngrid)

        N           =  Ngrid(j);
        X           =  ones(1,N)./N;
        para.beta0  =  ones(N,1).* 0.1;
        para.beta1  =  ones(N,1).*(c1 - 1);
        para.delta  =  - ones(N,1)./(N-1);
       

        for k = 1: length(rhogrid)
        
            para.rho      = rhogrid(k);
	        epsilonEq     = solveEq(para, X);
            sigmaEq(k,j,i)  =  1 - normcdf(epsilonEq(1),0,para.sigma);

        end
    end	
end

fa = figure('Visible', 'off');
plot(rhogrid, sigmaEq(:,1,1),'r-','LineWidth',3,'Color',[.3 .3 .3])
hold on 
plot(rhogrid, sigmaEq(:,2,1),'r--','LineWidth',3,'Color',[.5 .3 .3])
xlim([0,0.9])
xlabel('Correlation Coefficient ($\rho$)','Interpreter','Latex','FontSize',14);
ylabel('Equilibrium Prob. of Compliance','Interpreter','Latex','FontSize',14);
set(gca,'fontsize',18);
set(gcf,'position',[10,10,500,400])
legend(['N = ' num2str(Ngrid(1))],['N = ' num2str(Ngrid(2))],'Location', 'Southeast')
print(fa, '-dpdf','../../output/Figure11a.pdf','-bestfit')

fb = figure('Visible', 'off');
plot(rhogrid, sigmaEq(:,1,2),'r-','LineWidth',3,'Color',[.3 .3 .3])
hold on 
plot(rhogrid, sigmaEq(:,2,2),'r--','LineWidth',3,'Color',[.5 .3 .3])
xlim([0,0.9])
xlabel('Correlation Coefficient ($\rho$)','Interpreter','Latex','FontSize',14);
ylabel('Equilibrium Prob. of Compliance','Interpreter','Latex','FontSize',14);
set(gca,'fontsize',18);
set(gcf,'position',[10,10,500,400])
legend(['N = ' num2str(Ngrid(1))],['N = ' num2str(Ngrid(2))],'Location', 'Southeast')
print(fb, '-dpdf','../../output/Figure11b.pdf','-bestfit')



