(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10396,        336]
NotebookOptionsPosition[      9374,        294]
NotebookOutlinePosition[      9709,        309]
CellTagsIndexPosition[      9666,        306]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["initial", "Section",
 CellChangeTimes->{{3.436056128311274*^9, 3.436056129053207*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"om", "=", 
   RowBox[{"0.25", " ", 
    RowBox[{"10", "^", "3"}]}]}], ";", 
  RowBox[{"kna", "=", "1."}], ";", 
  RowBox[{"kk", "=", "1."}], ";", 
  RowBox[{"cna", "=", "0.05"}], ";", 
  RowBox[{"ck", "=", 
   RowBox[{"10", "^", 
    RowBox[{"-", "6"}]}]}], ";", 
  RowBox[{"por", "=", "0.5"}], ";", 
  RowBox[{"rho", "=", "0.99716"}], ";"}]], "Input",
 CellChangeTimes->{
  3.4358501026359262`*^9, {3.4358515435128193`*^9, 3.435851546452155*^9}, 
   3.4358542917829123`*^9, {3.436055327506467*^9, 3.4360553570078163`*^9}, {
   3.436055647899006*^9, 3.436055649370269*^9}, {3.4360560045000896`*^9, 
   3.436056011026918*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ion Exchange", "Section",
 CellChangeTimes->{{3.435849955956142*^9, 3.435849959830678*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sna", "=", 
   RowBox[{"om", " ", "kna", " ", 
    RowBox[{"cna", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"kna", " ", "cna"}], "+", 
       RowBox[{"kk", " ", "ck"}]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sk", "=", 
   RowBox[{"om", " ", "kk", " ", 
    RowBox[{"ck", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"kna", " ", "cna"}], "+", 
       RowBox[{"kk", " ", "ck"}]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"stot", "=", 
   RowBox[{"sna", "+", "sk"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rna", "=", 
   RowBox[{"1", "+", 
    RowBox[{"sna", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"10", "^", 
         RowBox[{"-", "3"}]}], "/", "cna"}], "/", "por"}], "/", "rho"}]}]}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rk", "=", 
   RowBox[{"1", "+", 
    RowBox[{"sk", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"10", "^", 
         RowBox[{"-", "3"}]}], "/", "ck"}], "/", "por"}], "/", "rho"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{"sna", ",", "sk", ",", "stot", ",", "rna", ",", "rk"}], 
  "}"}]}], "Input",
 CellChangeTimes->{{3.4358501157036552`*^9, 3.43585021748941*^9}, {
   3.435851559012979*^9, 3.4358515641246443`*^9}, 3.43605539760048*^9, {
   3.436055881109453*^9, 3.436055910879923*^9}, 3.436055981064485*^9, {
   3.436056052653743*^9, 3.436056053703431*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "249.99500009999798`", ",", "0.004999900001999959`", ",", 
   "249.99999999999997`", ",", "11.02828032010903`", ",", 
   "11.028280320109028`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.4358502186717978`*^9, {3.435851565282137*^9, 3.435851569846118*^9}, 
   3.435854294402022*^9, 3.4360553616559467`*^9, 3.4360553989225407`*^9, 
   3.436055654875482*^9, {3.4360558574901667`*^9, 3.436055912165174*^9}, 
   3.4360559599185543`*^9, 3.436056055617866*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["inlet", "Section",
 CellChangeTimes->{{3.4360561378811207`*^9, 3.43605613843503*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"om", "=", 
   RowBox[{"0.25", " ", 
    RowBox[{"10", "^", "3"}]}]}], ";", 
  RowBox[{"kna", "=", "1."}], ";", 
  RowBox[{"kk", "=", "1."}], ";", 
  RowBox[{"cna", "=", "0.05"}], ";", 
  RowBox[{"ck", "=", "0.01"}], ";", 
  RowBox[{"por", "=", "0.5"}], ";", 
  RowBox[{"rho", "=", "0.99716"}], ";"}]], "Input",
 CellChangeTimes->{
  3.4358501026359262`*^9, {3.4358515435128193`*^9, 3.435851546452155*^9}, 
   3.4358542917829123`*^9, {3.436055327506467*^9, 3.4360553570078163`*^9}, {
   3.436055647899006*^9, 3.436055649370269*^9}, {3.4360560045000896`*^9, 
   3.436056011026918*^9}, {3.436056165784999*^9, 3.43605616669204*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ion Exchange", "Section",
 CellChangeTimes->{{3.435849955956142*^9, 3.435849959830678*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sna", "=", 
   RowBox[{"om", " ", "kna", " ", 
    RowBox[{"cna", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"kna", " ", "cna"}], "+", 
       RowBox[{"kk", " ", "ck"}]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sk", "=", 
   RowBox[{"om", " ", "kk", " ", 
    RowBox[{"ck", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"kna", " ", "cna"}], "+", 
       RowBox[{"kk", " ", "ck"}]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"stot", "=", 
   RowBox[{"sna", "+", "sk"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rna", "=", 
   RowBox[{"1", "+", 
    RowBox[{"sna", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"10", "^", 
         RowBox[{"-", "3"}]}], "/", "cna"}], "/", "por"}], "/", "rho"}]}]}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rk", "=", 
   RowBox[{"1", "+", 
    RowBox[{"sk", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"10", "^", 
         RowBox[{"-", "3"}]}], "/", "ck"}], "/", "por"}], "/", "rho"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{"sna", ",", "sk", ",", "stot", ",", "rna", ",", "rk"}], 
  "}"}]}], "Input",
 CellChangeTimes->{{3.4358501157036552`*^9, 3.43585021748941*^9}, {
   3.435851559012979*^9, 3.4358515641246443`*^9}, 3.43605539760048*^9, {
   3.436055881109453*^9, 3.436055910879923*^9}, 3.436055981064485*^9, {
   3.436056052653743*^9, 3.436056053703431*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "208.33333333333331`", ",", "41.666666666666664`", ",", 
   "249.99999999999997`", ",", "9.35706740476286`", ",", 
   "9.35706740476286`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.4358502186717978`*^9, {3.435851565282137*^9, 3.435851569846118*^9}, 
   3.435854294402022*^9, 3.4360553616559467`*^9, 3.4360553989225407`*^9, 
   3.436055654875482*^9, {3.4360558574901667`*^9, 3.436055912165174*^9}, 
   3.4360559599185543`*^9, 3.436056055617866*^9, 3.436056170927998*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Surface Complexation", "Section",
 CellChangeTimes->{{3.4358499446925173`*^9, 3.435849948574526*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sna", "=", 
   RowBox[{"om", " ", "kna", " ", 
    RowBox[{"cna", "/", 
     RowBox[{"(", 
      RowBox[{"1.", "+", 
       RowBox[{"kna", " ", "cna"}], "+", 
       RowBox[{"kk", " ", "ck"}]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sk", "=", 
   RowBox[{"om", " ", "kk", " ", 
    RowBox[{"ck", "/", 
     RowBox[{"(", 
      RowBox[{"1.", "+", 
       RowBox[{"kna", " ", "cna"}], " ", "+", " ", 
       RowBox[{"kk", " ", "ck"}]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sfree", "=", 
   RowBox[{"om", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"kna", " ", "cna"}], " ", "+", " ", 
      RowBox[{"kk", " ", "ck"}]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"stot", "=", 
   RowBox[{"sfree", "+", "sna", "+", "sk"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rna", "=", 
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{
      RowBox[{"sna", "/", "cna"}], "/", "por"}], "/", "rho"}]}]}], ";", 
  RowBox[{"rk", "=", 
   RowBox[{"1", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"sk", "/", "ck"}], "/", "por"}], "/", "rho"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
  "sna", ",", "sk", ",", "sfree", ",", "stot", ",", "rna", ",", "rk"}], 
  "}"}]}], "Input",
 CellChangeTimes->{{3.435849247006633*^9, 3.435849386244465*^9}, {
   3.435849561031958*^9, 3.435849592380639*^9}, {3.435849797387609*^9, 
   3.435849906503188*^9}, 3.435850098178265*^9, {3.435850179337213*^9, 
   3.435850184547346*^9}, {3.435851550276848*^9, 3.4358515558926373`*^9}, {
   3.436056029214589*^9, 3.436056033499332*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Set", "::", "\<\"setraw\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Cannot assign to raw object \\!\\(1\\). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Set/setraw\\\", \
ButtonNote -> \\\"Set::setraw\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.435849908173163*^9, 3.435850186063438*^9, 
  3.4358515712833967`*^9, 3.436056034685478*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "11.904750566904223`", ",", "0.00023809501133808443`", ",", 
   "238.09501133808445`", ",", "250.`", ",", "478.54625403763583`", ",", 
   "477.5462540376357`"}], "}"}]], "Output",
 CellChangeTimes->{{3.4358492945656424`*^9, 3.4358493196762037`*^9}, {
   3.4358493734936*^9, 3.435849387245113*^9}, 3.435849593775386*^9, {
   3.435849798152861*^9, 3.435849833238064*^9}, {3.435849869862609*^9, 
   3.435849908174616*^9}, 3.4358501860669394`*^9, 3.435851571286997*^9, 
   3.436056034688281*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{640, 750},
WindowMargins->{{22, Automatic}, {Automatic, 78}},
FrontEndVersion->"6.0 for Mac OS X x86 (32-bit) (May 21, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 92, 1, 67, "Section"],
Cell[685, 26, 660, 17, 72, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1382, 48, 97, 1, 67, "Section"],
Cell[CellGroupData[{
Cell[1504, 53, 1506, 48, 132, "Input"],
Cell[3013, 103, 496, 10, 31, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3558, 119, 91, 1, 67, "Section"],
Cell[3652, 122, 663, 15, 72, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4352, 142, 97, 1, 67, "Section"],
Cell[CellGroupData[{
Cell[4474, 147, 1506, 48, 132, "Input"],
Cell[5983, 197, 513, 10, 31, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6545, 213, 107, 1, 67, "Section"],
Cell[CellGroupData[{
Cell[6677, 218, 1667, 49, 132, "Input"],
Cell[8347, 269, 463, 9, 23, "Message"],
Cell[8813, 280, 533, 10, 31, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
