# Detach previous packages
# invisible(lapply(paste0('package:', names(sessionInfo()$otherPkgs)), detach, character.only=TRUE, unload=TRUE))
# Remove all variables from memory
# rm(list=ls())
# Load the necessary packages ####
suppressWarnings({
  suppressMessages({
    # For writing the codes with shiny
    library(shiny)
    # For importing Excel data
    # library(readxl)
    # File management
    library(tools)
    library(zip)
    library(fs)
    # For meta-analysis
    library(meta)
    # Replace text
    library(tidyverse)
    library(stringr)
    # For reference screener 
    library(zoo)
    library(tidyr)
    library(XML)
    library(viridis)
    # For DEF
    library(openxlsx)
    library(openxlsx2)
    # For OCR
    library(tesseract)
    library(magick)
    # For sample size calculations (interpretation)
    library(pwr)
    library(gsDesign)
  })
})

# Limit the size of the upload to 40 MB
options(shiny.maxRequestSize = 40*1024^2)
# Scientific notations options
options(scipen=999)
# Set the digits to 2 for meta-analysis
settings.meta(digits=2)
# Format for forest plot
settings.meta("RevMan5")
# Turn off scientific notations
options(scipen=999)

# General functions ####
rbind.missing <- function(x,y) {
  # When two databases with different columns are combined, rbind causes error
  # To avoid this error, create new missing columns in both databases and then combine
  p = colnames(x)
  q = colnames(y)
  r = p[is.na(match(p,q))] # Columns in x missing in y
  s = q[is.na(match(q,p))] # Columns in y missing in x
  # Add columns in y missing in x
  if (length(s)>0){
    t = data.frame(matrix(NA,nrow = nrow(x), ncol = length(s)))
    colnames(t) <- s
    x <- data.frame(cbind(x, t))
  }
  # Add columns in x missing in y
  if (length(r)>0){
    u = data.frame(matrix(NA,nrow = nrow(y), ncol = length(r)))
    colnames(u) <- r
    y <- data.frame(cbind(y, u))
  }
  # Now add the rows
  rbind(x,y)
}
cbind.missing <- function(x,y) {
  # When combining multiple dataframes with differing lengths, cbind causes error
  # To avoid this error, create new rows in the dataframes with fewer rows and then combine
  if (nrow(x) == nrow(y)) {
    data.frame(cbind(x, y))
  } else if (nrow(x) < nrow(y)) {
    x[nrow(x)+(nrow(y) - nrow(x)),]<-NA
    data.frame(cbind(x, y))
  } else {
    y[nrow(y)+(nrow(x) - nrow(y)),]<-NA
    data.frame(cbind(x, y))
  }
}
cbind.columns <- function(list_of_columns) {
  # When combining multiple columns with differing lengths, cbind.dataframe causes error
  # To avoid this error, create new rows in the dataframes with fewer rows and then combine
  # Find the maximum length in a list
  maximum_length <- max(sapply(1:length(list_of_columns), function(x) {length(list_of_columns[[x]])}))
  df <- cbind.data.frame(
    lapply(1:length(list_of_columns), function(x) {c(list_of_columns[[x]], rep(NA, maximum_length - length(list_of_columns[[x]])))})
  )
  colnames(df) <- names(list_of_columns)
  return(df)
}
# Functions to create graphs easily ####
f.ForestPlot<-function(KG, OutcomeType){
  plot.new()
  forest(KG, colgap = ifelse(OutcomeType == "Continuous","5mm","8mm"), digits = 2, digits.se = 2)
  title(main=KG$outclab)
  recordPlot()
}
f.ForestPlot.SA<-function(KG, OutcomeType,a){
  plot.new()
  forest(KG, colgap = ifelse(OutcomeType == "Continuous","5mm","8mm"), digits = 2, digits.se = 2)
  title(main=paste0(KG$outclab,' (',c("Informative Missingness Odds Ratio (IMOR)","Best-worst analysis","Worst-best analysis","Sensitivity analysis")[a],')'))
  recordPlot()
}
f.ForestPlot.SubA<-function(KG, OutcomeType, SubgroupTitle){
  plot.new()
  forest(KG, colgap = ifelse(OutcomeType == "Continuous","5mm","8mm"), digits = 2, digits.se = 2)
  title(main=paste0(KG$outclab,'\n','Moderator: ',SubgroupTitle))
  recordPlot()
}
f.FunnelPlot<-function(KG){
  funnel(
    KG, 
    level = 0.95, 
    contour.levels = c(0.9, 0.95, 0.99),
  )
  legend(x="topright",
         c("0.1 > p > 0.05", "0.05 > p > 0.01", "< 0.01"),
         fill = gray(seq(0.5, 0.9, len=3)),
  )
  title(main=KG$outclab)
  recordPlot()
}
f.BubblePlot<-function(KG1, KG2){
  if (KG2$sm %in% c("OR","RR","IRR","HR","ROM")){
    bubble(KG1,
           ylim = range(exp(KG2$TE), na.rm = TRUE)
    )
  } else {
    bubble(KG1,
           ylim = range(KG2$TE, na.rm = TRUE)
    )
  }
  title(
    main=paste0(KG2$outclab, ' (metaregression)'),
    sub = "Each bubble represents a study. Larger bubbles indicates smaller variance and viceversa"
  )
  recordPlot()
}
f.PlotText <- function(KG) {
  plot.new()
  title(main=KG)
  recordPlot()
}
# Sensitivity analysis ####
f.IMOR <- function(df_Outcome,MA, IMOR_E=1,IMOR_C=1) {
  # Intervention
  r.e <- as.vector(df_Outcome[,7])
  f.e <- as.vector(df_Outcome[,5]-df_Outcome[,7])
  m1.e <- as.vector(df_Outcome[,14])
  m2.e <- as.vector(df_Outcome[,15])
  m3.e <- as.vector(df_Outcome[,16])
  m4.e <- as.vector(df_Outcome[,17])
  m5.e <- as.vector(df_Outcome[,18])
  m6.e <- as.vector(df_Outcome[,19])
  m7.e <- as.vector(df_Outcome[,20])
  m.e <- rowSums(cbind(m1.e,m2.e,m3.e,m4.e,m5.e,m6.e),na.rm = TRUE)
  N.e <- rowSums(cbind(r.e,f.e,m.e),na.rm = TRUE)
  # Control
  r.c <- as.vector(df_Outcome[,8])
  f.c <- as.vector(df_Outcome[,6]-df_Outcome[,8])
  m1.c <- as.vector(df_Outcome[,21])
  m2.c <- as.vector(df_Outcome[,22])
  m3.c <- as.vector(df_Outcome[,23])
  m4.c <- as.vector(df_Outcome[,24])
  m5.c <- as.vector(df_Outcome[,25])
  m6.c <- as.vector(df_Outcome[,26])
  m7.c <- as.vector(df_Outcome[,27])
  m.c <- rowSums(cbind(m1.c,m2.c,m3.c,m4.c,m5.c,m6.c),na.rm = TRUE)
  N.c <- rowSums(cbind(r.c,f.c,m.c),na.rm = TRUE)
  
  IMOR <- data.frame(cbind(r.e,f.e,m1.e,m2.e,m3.e,m4.e,m5.e,m6.e,m.e,N.e,
                           r.c,f.c,m1.c,m2.c,m3.c,m4.c,m5.c,m6.c,m.c,N.c
  ))
  
  # Zero event trials increase by 0.5 for each cell
  IMOR[IMOR$r.e == 0 | IMOR$f.e == 0 | IMOR$r.c == 0 | IMOR$f.c ==0,c(1:2,11:12)] <- 
    lapply(IMOR[IMOR$r.e == 0 | IMOR$f.e == 0 | IMOR$r.c == 0 | IMOR$f.c ==0,c(1:2,11:12)],function(x) {x+0.5})
  
  # If the trial did not state whether the data is missing, m7 should be based on the proportion of drop-outs in remaining trials (in the group) and then distributed as for m6
  # But for this, we need at least one study to report the drop out
  if (sum(is.na(IMOR[,c(3:8, 13:18)])) != 12*nrow(IMOR)) {
    # if drop out is reported only in the intervention assume similar drop-outs in control group and vice versa; otherwise calculate the drop-outs from the respective groups
    if (sum(is.na(IMOR[,c(3:8)])) == 6*nrow(IMOR)) {
      IMOR$m6.c <- ifelse(is.na(IMOR$m6.c),ifelse(m7.c !=0, sum(IMOR$m.c[m7.c == 0],na.rm = TRUE)/sum(IMOR$N.c[m7.c == 0],na.rm = TRUE)*IMOR$N.c,IMOR$m6.c),IMOR$m6.c)
      IMOR$m6.e <- IMOR$m6.c
    } else if (sum(is.na(IMOR[,c(13:18)])) == 6*nrow(IMOR)) {
      IMOR$m6.e <- ifelse(is.na(IMOR$m6.e),ifelse(m7.e !=0, sum(IMOR$m.e[m7.e == 0],na.rm = TRUE)/sum(IMOR$N.e[m7.e == 0],na.rm = TRUE)*IMOR$N.e,IMOR$m6.e),IMOR$m6.e)
      IMOR$m6.c <- IMOR$m6.e
    } else {
      IMOR$m6.e <- ifelse(is.na(IMOR$m6.e),ifelse(m7.e !=0, sum(IMOR$m.e[m7.e == 0],na.rm = TRUE)/sum(IMOR$N.e[m7.e == 0],na.rm = TRUE)*IMOR$N.e,IMOR$m6.e),IMOR$m6.e)
      IMOR$m6.c <- ifelse(is.na(IMOR$m6.c),ifelse(m7.c !=0, sum(IMOR$m.c[m7.c == 0],na.rm = TRUE)/sum(IMOR$N.c[m7.c == 0],na.rm = TRUE)*IMOR$N.c,IMOR$m6.c),IMOR$m6.c)
    }
  }
  
  # Now replace NA with 0
  IMOR[is.na(IMOR)] <- 0
  
  # update the IMOR$m.e and IMOR.m.c and N.e, N.c
  IMOR$m.e <- rowSums(IMOR[,3:8])
  IMOR$m.c <- rowSums(IMOR[,13:18])
  IMOR$N.e <- rowSums(IMOR[,c(1:2,9)])
  IMOR$N.c <- rowSums(IMOR[,c(11:12,19)])
  
  # If the reasons were not stated m6 should be distributed according to the median proportions of m1 to m5 (in the group) 
  # Again the trials where number missing was not stated should be excluded
  # Since we are redistributing the unknown cases to known cases, the proportions should be based on m - m6
  # Means rather than medians: if we choose medians, the proportions can come from different studies and the sum may not be one
  # Because of the formula used, if m6 =0, m1 = m1, m2 = m2, etc
  # How if the only value provided is m6 in all trials, then move m6 to m5 to allow standard IMOR
  if (sum(IMOR[,c(3:7)]) == 0){
    IMOR$m5.e <- IMOR$m6.e
  } else {
    IMOR$m1.e <- IMOR$m1.e + sum(IMOR$m1.e[m7.e == 0],na.rm = TRUE)/(sum(IMOR$m.e[m7.e == 0],na.rm = TRUE)-sum(IMOR$m6.e[m7.e == 0],na.rm = TRUE))*IMOR$m6.e
    IMOR$m2.e <- IMOR$m2.e + sum(IMOR$m2.e[m7.e == 0],na.rm = TRUE)/(sum(IMOR$m.e[m7.e == 0],na.rm = TRUE)-sum(IMOR$m6.e[m7.e == 0],na.rm = TRUE))*IMOR$m6.e
    IMOR$m3.e <- IMOR$m3.e + sum(IMOR$m3.e[m7.e == 0],na.rm = TRUE)/(sum(IMOR$m.e[m7.e == 0],na.rm = TRUE)-sum(IMOR$m6.e[m7.e == 0],na.rm = TRUE))*IMOR$m6.e
    IMOR$m4.e <- IMOR$m4.e + sum(IMOR$m4.e[m7.e == 0],na.rm = TRUE)/(sum(IMOR$m.e[m7.e == 0],na.rm = TRUE)-sum(IMOR$m6.e[m7.e == 0],na.rm = TRUE))*IMOR$m6.e
    IMOR$m5.e <- IMOR$m5.e + sum(IMOR$m5.e[m7.e == 0],na.rm = TRUE)/(sum(IMOR$m.e[m7.e == 0],na.rm = TRUE)-sum(IMOR$m6.e[m7.e == 0],na.rm = TRUE))*IMOR$m6.e
  }
  
  if (sum(IMOR[,c(13:17)]) == 0){
    IMOR$m5.c <- IMOR$m6.c
  } else {
    IMOR$m1.c <- IMOR$m1.c + sum(IMOR$m1.c[m7.c == 0],na.rm = TRUE)/(sum(IMOR$m.c[m7.c == 0],na.rm = TRUE)-sum(IMOR$m6.c[m7.c == 0],na.rm = TRUE))*IMOR$m6.c
    IMOR$m2.c <- IMOR$m2.c + sum(IMOR$m2.c[m7.c == 0],na.rm = TRUE)/(sum(IMOR$m.c[m7.c == 0],na.rm = TRUE)-sum(IMOR$m6.c[m7.c == 0],na.rm = TRUE))*IMOR$m6.c
    IMOR$m3.c <- IMOR$m3.c + sum(IMOR$m3.c[m7.c == 0],na.rm = TRUE)/(sum(IMOR$m.c[m7.c == 0],na.rm = TRUE)-sum(IMOR$m6.c[m7.c == 0],na.rm = TRUE))*IMOR$m6.c
    IMOR$m4.c <- IMOR$m4.c + sum(IMOR$m4.c[m7.c == 0],na.rm = TRUE)/(sum(IMOR$m.c[m7.c == 0],na.rm = TRUE)-sum(IMOR$m6.c[m7.c == 0],na.rm = TRUE))*IMOR$m6.c
    IMOR$m5.c <- IMOR$m5.c + sum(IMOR$m5.c[m7.c == 0],na.rm = TRUE)/(sum(IMOR$m.c[m7.c == 0],na.rm = TRUE)-sum(IMOR$m6.c[m7.c == 0],na.rm = TRUE))*IMOR$m6.c
  }
  # To avoid confusion, drop m6.e, m6.e
  IMOR <- IMOR[,-c(8,18)]
  
  IMOR$p.e <- IMOR$r.e/(IMOR$r.e+IMOR$f.e)
  IMOR$a.e <- IMOR$m.e/IMOR$N.e
  IMOR$m1.a.e <- IMOR$m1.e/IMOR$N.e
  IMOR$m2.a.e <- IMOR$m2.e/IMOR$N.e 
  IMOR$m3.a.e <- IMOR$m3.e/IMOR$N.e 
  IMOR$m4.a.e <- IMOR$m4.e/IMOR$N.e 
  IMOR$m5.a.e <- IMOR$m5.e/IMOR$N.e 
  IMOR$p.c <- IMOR$r.c/(IMOR$r.c+IMOR$f.c)
  IMOR$a.c <- IMOR$m.c/IMOR$N.c
  IMOR$m1.a.c <- IMOR$m1.c/IMOR$N.c 
  IMOR$m2.a.c <- IMOR$m2.c/IMOR$N.c 
  IMOR$m3.a.c <- IMOR$m3.c/IMOR$N.c 
  IMOR$m4.a.c <- IMOR$m4.c/IMOR$N.c 
  IMOR$m5.a.c <- IMOR$m5.c/IMOR$N.c
  
  # At this stage make three more: IMOR_01, IMOR_10 for best case and worst case analysis (for bad outcomes) and IMOR-M where IMOR is used for all missing causes
  IMOR_01 <- IMOR
  IMOR_10 <- IMOR
  IMOR_M <- IMOR
  
  # m1= Missing failure (Intervention): p = 0
  # m2 = Missing success (Intervention): p = 1
  # m3 = Missing unrelated (Intervention): p = p.e
  # m4 = Missing protocol violation (Intervention) (receives Control): p = p.c
  # m5 = Missing other (Intervention): p based on IMOR (user provided)
  
  # Calcuate IMORs for m1 to m4 from p and p from IMOR for m5
  IMOR$m1.p.e <- ifelse(tolower(df_Outcome[1,3])=="worse",1,0)
  IMOR$m2.p.e <- ifelse(tolower(df_Outcome[1,3])=="worse",0,1)
  IMOR$m3.p.e <- IMOR$p.e
  IMOR$m4.p.e <- IMOR$p.c
  
  # IMOR = odds of m1 (m2,m3, m4) by odds of not missing
  # Odds = Risk/(1-Risk)
  IMOR$m1.IMOR.e <- ifelse(IMOR$m1.p.e == 1,1e8,(IMOR$m1.p.e/(1-IMOR$m1.p.e))/(IMOR$p.e/(1-IMOR$p.e)))
  IMOR$m2.IMOR.e <- ifelse(IMOR$m2.p.e == 1,1e8,(IMOR$m2.p.e/(1-IMOR$m2.p.e))/(IMOR$p.e/(1-IMOR$p.e)))
  IMOR$m3.IMOR.e <- ifelse(IMOR$m3.p.e == 1,1e8,(IMOR$m3.p.e/(1-IMOR$m3.p.e))/(IMOR$p.e/(1-IMOR$p.e)))
  IMOR$m4.IMOR.e <- ifelse(IMOR$m4.p.e == 1,1e8,(IMOR$m4.p.e/(1-IMOR$m4.p.e))/(IMOR$p.e/(1-IMOR$p.e)))
  
  # IMOR of m5 directly given, but we still need p for later calculations
  IMOR$m5.IMOR.e <- IMOR_E
  IMOR$m5.p.e <- IMOR$p.e*IMOR$m5.IMOR.e/(IMOR$p.e*IMOR$m5.IMOR.e + 1 - IMOR$p.e)
  
  # m1= Missing failure (Control): p = 0
  # m2 = Missing success (Control): p = 1
  # m3 = Missing unrelated (Control): p = p.c
  # m4 = Missing protocol violation (Control) (receives Intervention): p = p.e
  # m5 = Missing other (Control): p based on IMOR (user provided)
  
  # Calcuate IMORs for m1 to m4 from p and p from IMOR for m5
  IMOR$m1.p.c <- ifelse(tolower(df_Outcome[1,3])=="worse",1,0)
  IMOR$m2.p.c <- ifelse(tolower(df_Outcome[1,3])=="worse",0,1)
  IMOR$m3.p.c <- IMOR$p.c
  IMOR$m4.p.c <- IMOR$p.e
  
  # IMOR = odds of m1 (m2,m3, m4) by odds of not missing
  # Odds = Risk/(1-Risk)
  IMOR$m1.IMOR.c <- ifelse(IMOR$m1.p.c == 1,1e8,(IMOR$m1.p.c/(1-IMOR$m1.p.c))/(IMOR$p.c/(1-IMOR$p.c)))
  IMOR$m2.IMOR.c <- ifelse(IMOR$m2.p.c == 1,1e8,(IMOR$m2.p.c/(1-IMOR$m2.p.c))/(IMOR$p.c/(1-IMOR$p.c)))
  IMOR$m3.IMOR.c <- ifelse(IMOR$m3.p.c == 1,1e8,(IMOR$m3.p.c/(1-IMOR$m3.p.c))/(IMOR$p.c/(1-IMOR$p.c)))
  IMOR$m4.IMOR.c <- ifelse(IMOR$m4.p.c == 1,1e8,(IMOR$m4.p.c/(1-IMOR$m4.p.c))/(IMOR$p.c/(1-IMOR$p.c)))
  
  # IMOR of m5 directly given, but we still need p for later calculations
  IMOR$m5.IMOR.c <- IMOR_C
  IMOR$m5.p.c <- IMOR$p.c*IMOR$m5.IMOR.c/(IMOR$p.c*IMOR$m5.IMOR.c + 1 - IMOR$p.c)
  
  IMOR$p.star.e <- IMOR$p.e*(1-IMOR$a.e) + 
    IMOR$m1.a.e * (IMOR$p.e*IMOR$m1.IMOR.e)/(IMOR$p.e*IMOR$m1.IMOR.e+1-IMOR$p.e) +
    IMOR$m2.a.e * (IMOR$p.e*IMOR$m2.IMOR.e)/(IMOR$p.e*IMOR$m2.IMOR.e+1-IMOR$p.e) +
    IMOR$m3.a.e * (IMOR$p.e*IMOR$m3.IMOR.e)/(IMOR$p.e*IMOR$m3.IMOR.e+1-IMOR$p.e) +
    IMOR$m4.a.e * (IMOR$p.e*IMOR$m4.IMOR.e)/(IMOR$p.e*IMOR$m4.IMOR.e+1-IMOR$p.e) +
    IMOR$m5.a.e * (IMOR$p.e*IMOR$m5.IMOR.e)/(IMOR$p.e*IMOR$m5.IMOR.e+1-IMOR$p.e)
  
  IMOR$p.star.c <- IMOR$p.c*(1-IMOR$a.c) + 
    IMOR$m1.a.c * (IMOR$p.c*IMOR$m1.IMOR.c)/(IMOR$p.c*IMOR$m1.IMOR.c+1-IMOR$p.c) +
    IMOR$m2.a.c * (IMOR$p.c*IMOR$m2.IMOR.c)/(IMOR$p.c*IMOR$m2.IMOR.c+1-IMOR$p.c) +
    IMOR$m3.a.c * (IMOR$p.c*IMOR$m3.IMOR.c)/(IMOR$p.c*IMOR$m3.IMOR.c+1-IMOR$p.c) +
    IMOR$m4.a.c * (IMOR$p.c*IMOR$m4.IMOR.c)/(IMOR$p.c*IMOR$m4.IMOR.c+1-IMOR$p.c) +
    IMOR$m5.a.c * (IMOR$p.c*IMOR$m5.IMOR.c)/(IMOR$p.c*IMOR$m5.IMOR.c+1-IMOR$p.c)
  
  IMOR$var.p.star.e <- IMOR$p.e*(1-IMOR$p.e)/(IMOR$N.e-IMOR$m.e) *
    (1 +
       IMOR$m1.a.e * (IMOR$m1.IMOR.e/(IMOR$p.e * IMOR$m1.IMOR.e + 1-IMOR$p.e)^2-1) +
       IMOR$m2.a.e * (IMOR$m2.IMOR.e/(IMOR$p.e * IMOR$m2.IMOR.e + 1-IMOR$p.e)^2-1) +
       IMOR$m3.a.e * (IMOR$m3.IMOR.e/(IMOR$p.e * IMOR$m3.IMOR.e + 1-IMOR$p.e)^2-1) +
       IMOR$m4.a.e * (IMOR$m4.IMOR.e/(IMOR$p.e * IMOR$m4.IMOR.e + 1-IMOR$p.e)^2-1) +
       IMOR$m5.a.e * (IMOR$m5.IMOR.e/(IMOR$p.e * IMOR$m5.IMOR.e + 1-IMOR$p.e)^2-1)
    )^2 +
    (1/IMOR$N.e) * 
    ((IMOR$p.e - IMOR$p.star.e)^2 +
       IMOR$m1.a.e * ((IMOR$m1.p.e-IMOR$p.star.e)^2-(IMOR$p.e-IMOR$p.star.e)^2) +
       IMOR$m2.a.e * ((IMOR$m2.p.e-IMOR$p.star.e)^2-(IMOR$p.e-IMOR$p.star.e)^2) +
       IMOR$m3.a.e * ((IMOR$m3.p.e-IMOR$p.star.e)^2-(IMOR$p.e-IMOR$p.star.e)^2) +
       IMOR$m4.a.e * ((IMOR$m4.p.e-IMOR$p.star.e)^2-(IMOR$p.e-IMOR$p.star.e)^2) +
       IMOR$m5.a.e * ((IMOR$m5.p.e-IMOR$p.star.e)^2-(IMOR$p.e-IMOR$p.star.e)^2)
    )
  
  IMOR$var.p.star.c <- IMOR$p.c*(1-IMOR$p.c)/(IMOR$N.c-IMOR$m.c) *
    (1 +
       IMOR$m1.a.c * (IMOR$m1.IMOR.c/(IMOR$p.c * IMOR$m1.IMOR.c + 1-IMOR$p.c)^2-1) +
       IMOR$m2.a.c * (IMOR$m2.IMOR.c/(IMOR$p.c * IMOR$m2.IMOR.c + 1-IMOR$p.c)^2-1) +
       IMOR$m3.a.c * (IMOR$m3.IMOR.c/(IMOR$p.c * IMOR$m3.IMOR.c + 1-IMOR$p.c)^2-1) +
       IMOR$m4.a.c * (IMOR$m4.IMOR.c/(IMOR$p.c * IMOR$m4.IMOR.c + 1-IMOR$p.c)^2-1) +
       IMOR$m5.a.c * (IMOR$m5.IMOR.c/(IMOR$p.c * IMOR$m5.IMOR.c + 1-IMOR$p.c)^2-1)
    )^2 +
    (1/IMOR$N.c) * 
    ((IMOR$p.c - IMOR$p.star.c)^2 +
       IMOR$m1.a.c * ((IMOR$m1.p.c-IMOR$p.star.c)^2-(IMOR$p.c-IMOR$p.star.c)^2) +
       IMOR$m2.a.c * ((IMOR$m2.p.c-IMOR$p.star.c)^2-(IMOR$p.c-IMOR$p.star.c)^2) +
       IMOR$m3.a.c * ((IMOR$m3.p.c-IMOR$p.star.c)^2-(IMOR$p.c-IMOR$p.star.c)^2) +
       IMOR$m4.a.c * ((IMOR$m4.p.c-IMOR$p.star.c)^2-(IMOR$p.c-IMOR$p.star.c)^2) +
       IMOR$m5.a.c * ((IMOR$m5.p.c-IMOR$p.star.c)^2-(IMOR$p.c-IMOR$p.star.c)^2)
    )
  
  IMOR$var.p.e <- IMOR$p.e*(1-IMOR$p.e)/(IMOR$N.e-IMOR$m.e)
  IMOR$var.p.c <- IMOR$p.c*(1-IMOR$p.c)/(IMOR$N.c-IMOR$m.c)
  
  IMOR$logOR <- log((IMOR$p.e/(1-IMOR$p.e))/(IMOR$p.c/(1-IMOR$p.c)))
  IMOR$var.logOR <- 
    IMOR$var.p.e/(IMOR$p.e*(1-IMOR$p.e))^2 +
    IMOR$var.p.c/(IMOR$p.c*(1-IMOR$p.c))^2
  
  IMOR$logOR.star <- log((IMOR$p.star.e/(1-IMOR$p.star.e))/(IMOR$p.star.c/(1-IMOR$p.star.c)))
  IMOR$var.logOR.star <- 
    IMOR$var.p.star.e/(IMOR$p.star.e*(1-IMOR$p.star.e))^2 +
    IMOR$var.p.star.c/(IMOR$p.star.c*(1-IMOR$p.star.c))^2
  
  IMOR$logRR <- log(IMOR$p.e/IMOR$p.c)
  IMOR$var.logRR <- 
    IMOR$var.p.e/(IMOR$p.e)^2 +
    IMOR$var.p.c/(IMOR$p.c)^2
  
  IMOR$logRR.star <- log(IMOR$p.star.e/IMOR$p.star.c)
  IMOR$var.logRR.star <- 
    IMOR$var.p.star.e/(IMOR$p.star.e)^2 +
    IMOR$var.p.star.c/(IMOR$p.star.c)^2
  
  # Now IMOR_01
  IMOR_01$m1.p.e <- 0
  IMOR_01$m2.p.e <- 0
  IMOR_01$m3.p.e <- 0
  IMOR_01$m4.p.e <- 0
  IMOR_01$m5.p.e <- 0
  
  # IMOR = odds of m1 (m2,m3, m4) by odds of not missing
  # Odds = Risk/(1-Risk)
  IMOR_01$m1.IMOR.e <- ifelse(IMOR_01$m1.p.e == 1,1e8,(IMOR_01$m1.p.e/(1-IMOR_01$m1.p.e))/(IMOR_01$p.e/(1-IMOR_01$p.e)))
  IMOR_01$m2.IMOR.e <- ifelse(IMOR_01$m2.p.e == 1,1e8,(IMOR_01$m2.p.e/(1-IMOR_01$m2.p.e))/(IMOR_01$p.e/(1-IMOR_01$p.e)))
  IMOR_01$m3.IMOR.e <- ifelse(IMOR_01$m3.p.e == 1,1e8,(IMOR_01$m3.p.e/(1-IMOR_01$m3.p.e))/(IMOR_01$p.e/(1-IMOR_01$p.e)))
  IMOR_01$m4.IMOR.e <- ifelse(IMOR_01$m4.p.e == 1,1e8,(IMOR_01$m4.p.e/(1-IMOR_01$m4.p.e))/(IMOR_01$p.e/(1-IMOR_01$p.e)))
  IMOR_01$m5.IMOR.e <- ifelse(IMOR_01$m5.p.e == 1,1e8,(IMOR_01$m5.p.e/(1-IMOR_01$m5.p.e))/(IMOR_01$p.e/(1-IMOR_01$p.e)))
  
  IMOR_01$m1.p.c <- 1
  IMOR_01$m2.p.c <- 1
  IMOR_01$m3.p.c <- 1
  IMOR_01$m4.p.c <- 1
  IMOR_01$m5.p.c <- 1
  
  IMOR_01$m1.IMOR.c <- ifelse(IMOR_01$m1.p.c == 1,1e8,(IMOR_01$m1.p.c/(1-IMOR_01$m1.p.c))/(IMOR_01$p.c/(1-IMOR_01$p.c)))
  IMOR_01$m2.IMOR.c <- ifelse(IMOR_01$m2.p.c == 1,1e8,(IMOR_01$m2.p.c/(1-IMOR_01$m2.p.c))/(IMOR_01$p.c/(1-IMOR_01$p.c)))
  IMOR_01$m3.IMOR.c <- ifelse(IMOR_01$m3.p.c == 1,1e8,(IMOR_01$m3.p.c/(1-IMOR_01$m3.p.c))/(IMOR_01$p.c/(1-IMOR_01$p.c)))
  IMOR_01$m4.IMOR.c <- ifelse(IMOR_01$m4.p.c == 1,1e8,(IMOR_01$m4.p.c/(1-IMOR_01$m4.p.c))/(IMOR_01$p.c/(1-IMOR_01$p.c)))
  IMOR_01$m5.IMOR.c <- ifelse(IMOR_01$m5.p.c == 1,1e8,(IMOR_01$m5.p.c/(1-IMOR_01$m5.p.c))/(IMOR_01$p.c/(1-IMOR_01$p.c)))
  
  IMOR_01$p.star.e <- IMOR_01$p.e*(1-IMOR_01$a.e) + 
    IMOR_01$m1.a.e * (IMOR_01$p.e*IMOR_01$m1.IMOR.e)/(IMOR_01$p.e*IMOR_01$m1.IMOR.e+1-IMOR_01$p.e) +
    IMOR_01$m2.a.e * (IMOR_01$p.e*IMOR_01$m2.IMOR.e)/(IMOR_01$p.e*IMOR_01$m2.IMOR.e+1-IMOR_01$p.e) +
    IMOR_01$m3.a.e * (IMOR_01$p.e*IMOR_01$m3.IMOR.e)/(IMOR_01$p.e*IMOR_01$m3.IMOR.e+1-IMOR_01$p.e) +
    IMOR_01$m4.a.e * (IMOR_01$p.e*IMOR_01$m4.IMOR.e)/(IMOR_01$p.e*IMOR_01$m4.IMOR.e+1-IMOR_01$p.e) +
    IMOR_01$m5.a.e * (IMOR_01$p.e*IMOR_01$m5.IMOR.e)/(IMOR_01$p.e*IMOR_01$m5.IMOR.e+1-IMOR_01$p.e)
  
  IMOR_01$p.star.c <- IMOR_01$p.c*(1-IMOR_01$a.c) + 
    IMOR_01$m1.a.c * (IMOR_01$p.c*IMOR_01$m1.IMOR.c)/(IMOR_01$p.c*IMOR_01$m1.IMOR.c+1-IMOR_01$p.c) +
    IMOR_01$m2.a.c * (IMOR_01$p.c*IMOR_01$m2.IMOR.c)/(IMOR_01$p.c*IMOR_01$m2.IMOR.c+1-IMOR_01$p.c) +
    IMOR_01$m3.a.c * (IMOR_01$p.c*IMOR_01$m3.IMOR.c)/(IMOR_01$p.c*IMOR_01$m3.IMOR.c+1-IMOR_01$p.c) +
    IMOR_01$m4.a.c * (IMOR_01$p.c*IMOR_01$m4.IMOR.c)/(IMOR_01$p.c*IMOR_01$m4.IMOR.c+1-IMOR_01$p.c) +
    IMOR_01$m5.a.c * (IMOR_01$p.c*IMOR_01$m5.IMOR.c)/(IMOR_01$p.c*IMOR_01$m5.IMOR.c+1-IMOR_01$p.c)
  
  IMOR_01$var.p.star.e <- IMOR_01$p.e*(1-IMOR_01$p.e)/(IMOR_01$N.e-IMOR_01$m.e) *
    (1 +
       IMOR_01$m1.a.e * (IMOR_01$m1.IMOR.e/(IMOR_01$p.e * IMOR_01$m1.IMOR.e + 1-IMOR_01$p.e)^2-1) +
       IMOR_01$m2.a.e * (IMOR_01$m2.IMOR.e/(IMOR_01$p.e * IMOR_01$m2.IMOR.e + 1-IMOR_01$p.e)^2-1) +
       IMOR_01$m3.a.e * (IMOR_01$m3.IMOR.e/(IMOR_01$p.e * IMOR_01$m3.IMOR.e + 1-IMOR_01$p.e)^2-1) +
       IMOR_01$m4.a.e * (IMOR_01$m4.IMOR.e/(IMOR_01$p.e * IMOR_01$m4.IMOR.e + 1-IMOR_01$p.e)^2-1) +
       IMOR_01$m5.a.e * (IMOR_01$m5.IMOR.e/(IMOR_01$p.e * IMOR_01$m5.IMOR.e + 1-IMOR_01$p.e)^2-1)
    )^2 +
    (1/IMOR_01$N.e) * 
    ((IMOR_01$p.e - IMOR_01$p.star.e)^2 +
       IMOR_01$m1.a.e * ((IMOR_01$m1.p.e-IMOR_01$p.star.e)^2-(IMOR_01$p.e-IMOR_01$p.star.e)^2) +
       IMOR_01$m2.a.e * ((IMOR_01$m2.p.e-IMOR_01$p.star.e)^2-(IMOR_01$p.e-IMOR_01$p.star.e)^2) +
       IMOR_01$m3.a.e * ((IMOR_01$m3.p.e-IMOR_01$p.star.e)^2-(IMOR_01$p.e-IMOR_01$p.star.e)^2) +
       IMOR_01$m4.a.e * ((IMOR_01$m4.p.e-IMOR_01$p.star.e)^2-(IMOR_01$p.e-IMOR_01$p.star.e)^2) +
       IMOR_01$m5.a.e * ((IMOR_01$m5.p.e-IMOR_01$p.star.e)^2-(IMOR_01$p.e-IMOR_01$p.star.e)^2)
    )
  
  IMOR_01$var.p.star.c <- IMOR_01$p.c*(1-IMOR_01$p.c)/(IMOR_01$N.c-IMOR_01$m.c) *
    (1 +
       IMOR_01$m1.a.c * (IMOR_01$m1.IMOR.c/(IMOR_01$p.c * IMOR_01$m1.IMOR.c + 1-IMOR_01$p.c)^2-1) +
       IMOR_01$m2.a.c * (IMOR_01$m2.IMOR.c/(IMOR_01$p.c * IMOR_01$m2.IMOR.c + 1-IMOR_01$p.c)^2-1) +
       IMOR_01$m3.a.c * (IMOR_01$m3.IMOR.c/(IMOR_01$p.c * IMOR_01$m3.IMOR.c + 1-IMOR_01$p.c)^2-1) +
       IMOR_01$m4.a.c * (IMOR_01$m4.IMOR.c/(IMOR_01$p.c * IMOR_01$m4.IMOR.c + 1-IMOR_01$p.c)^2-1) +
       IMOR_01$m5.a.c * (IMOR_01$m5.IMOR.c/(IMOR_01$p.c * IMOR_01$m5.IMOR.c + 1-IMOR_01$p.c)^2-1)
    )^2 +
    (1/IMOR_01$N.c) * 
    ((IMOR_01$p.c - IMOR_01$p.star.c)^2 +
       IMOR_01$m1.a.c * ((IMOR_01$m1.p.c-IMOR_01$p.star.c)^2-(IMOR_01$p.c-IMOR_01$p.star.c)^2) +
       IMOR_01$m2.a.c * ((IMOR_01$m2.p.c-IMOR_01$p.star.c)^2-(IMOR_01$p.c-IMOR_01$p.star.c)^2) +
       IMOR_01$m3.a.c * ((IMOR_01$m3.p.c-IMOR_01$p.star.c)^2-(IMOR_01$p.c-IMOR_01$p.star.c)^2) +
       IMOR_01$m4.a.c * ((IMOR_01$m4.p.c-IMOR_01$p.star.c)^2-(IMOR_01$p.c-IMOR_01$p.star.c)^2) +
       IMOR_01$m5.a.c * ((IMOR_01$m5.p.c-IMOR_01$p.star.c)^2-(IMOR_01$p.c-IMOR_01$p.star.c)^2)
    )
  
  IMOR_01$var.p.e <- IMOR_01$p.e*(1-IMOR_01$p.e)/(IMOR_01$N.e-IMOR_01$m.e)
  IMOR_01$var.p.c <- IMOR_01$p.c*(1-IMOR_01$p.c)/(IMOR_01$N.c-IMOR_01$m.c)
  
  IMOR_01$logOR <- log((IMOR_01$p.e/(1-IMOR_01$p.e))/(IMOR_01$p.c/(1-IMOR_01$p.c)))
  IMOR_01$var.logOR <- 
    IMOR_01$var.p.e/(IMOR_01$p.e*(1-IMOR_01$p.e))^2 +
    IMOR_01$var.p.c/(IMOR_01$p.c*(1-IMOR_01$p.c))^2
  
  IMOR_01$logOR.star <- log((IMOR_01$p.star.e/(1-IMOR_01$p.star.e))/(IMOR_01$p.star.c/(1-IMOR_01$p.star.c)))
  IMOR_01$var.logOR.star <- 
    IMOR_01$var.p.star.e/(IMOR_01$p.star.e*(1-IMOR_01$p.star.e))^2 +
    IMOR_01$var.p.star.c/(IMOR_01$p.star.c*(1-IMOR_01$p.star.c))^2
  
  IMOR_01$logRR <- log(IMOR_01$p.e/IMOR_01$p.c)
  IMOR_01$var.logRR <- 
    IMOR_01$var.p.e/(IMOR_01$p.e)^2 +
    IMOR_01$var.p.c/(IMOR_01$p.c)^2
  
  IMOR_01$logRR.star <- log(IMOR_01$p.star.e/IMOR_01$p.star.c)
  IMOR_01$var.logRR.star <- 
    IMOR_01$var.p.star.e/(IMOR_01$p.star.e)^2 +
    IMOR_01$var.p.star.c/(IMOR_01$p.star.c)^2
  
  # Now IMOR_10
  IMOR_10$m1.p.e <- 1
  IMOR_10$m2.p.e <- 1
  IMOR_10$m3.p.e <- 1
  IMOR_10$m4.p.e <- 1
  IMOR_10$m5.p.e <- 1
  
  # IMOR = odds of m1 (m2,m3, m4) by odds of not missing
  # Odds = Risk/(1-Risk)
  IMOR_10$m1.IMOR.e <- ifelse(IMOR_10$m1.p.e == 1,1e8,(IMOR_10$m1.p.e/(1-IMOR_10$m1.p.e))/(IMOR_10$p.e/(1-IMOR_10$p.e)))
  IMOR_10$m2.IMOR.e <- ifelse(IMOR_10$m2.p.e == 1,1e8,(IMOR_10$m2.p.e/(1-IMOR_10$m2.p.e))/(IMOR_10$p.e/(1-IMOR_10$p.e)))
  IMOR_10$m3.IMOR.e <- ifelse(IMOR_10$m3.p.e == 1,1e8,(IMOR_10$m3.p.e/(1-IMOR_10$m3.p.e))/(IMOR_10$p.e/(1-IMOR_10$p.e)))
  IMOR_10$m4.IMOR.e <- ifelse(IMOR_10$m4.p.e == 1,1e8,(IMOR_10$m4.p.e/(1-IMOR_10$m4.p.e))/(IMOR_10$p.e/(1-IMOR_10$p.e)))
  IMOR_10$m5.IMOR.e <- ifelse(IMOR_10$m5.p.e == 1,1e8,(IMOR_10$m5.p.e/(1-IMOR_10$m5.p.e))/(IMOR_10$p.e/(1-IMOR_10$p.e)))
  
  IMOR_10$m1.p.c <- 0
  IMOR_10$m2.p.c <- 0
  IMOR_10$m3.p.c <- 0
  IMOR_10$m4.p.c <- 0
  IMOR_10$m5.p.c <- 0
  
  IMOR_10$m1.IMOR.c <- ifelse(IMOR_10$m1.p.c == 1,1e8,(IMOR_10$m1.p.c/(1-IMOR_10$m1.p.c))/(IMOR_10$p.c/(1-IMOR_10$p.c)))
  IMOR_10$m2.IMOR.c <- ifelse(IMOR_10$m2.p.c == 1,1e8,(IMOR_10$m2.p.c/(1-IMOR_10$m2.p.c))/(IMOR_10$p.c/(1-IMOR_10$p.c)))
  IMOR_10$m3.IMOR.c <- ifelse(IMOR_10$m3.p.c == 1,1e8,(IMOR_10$m3.p.c/(1-IMOR_10$m3.p.c))/(IMOR_10$p.c/(1-IMOR_10$p.c)))
  IMOR_10$m4.IMOR.c <- ifelse(IMOR_10$m4.p.c == 1,1e8,(IMOR_10$m4.p.c/(1-IMOR_10$m4.p.c))/(IMOR_10$p.c/(1-IMOR_10$p.c)))
  IMOR_10$m5.IMOR.c <- ifelse(IMOR_10$m5.p.c == 1,1e8,(IMOR_10$m5.p.c/(1-IMOR_10$m5.p.c))/(IMOR_10$p.c/(1-IMOR_10$p.c)))
  
  IMOR_10$p.star.e <- IMOR_10$p.e*(1-IMOR_10$a.e) + 
    IMOR_10$m1.a.e * (IMOR_10$p.e*IMOR_10$m1.IMOR.e)/(IMOR_10$p.e*IMOR_10$m1.IMOR.e+1-IMOR_10$p.e) +
    IMOR_10$m2.a.e * (IMOR_10$p.e*IMOR_10$m2.IMOR.e)/(IMOR_10$p.e*IMOR_10$m2.IMOR.e+1-IMOR_10$p.e) +
    IMOR_10$m3.a.e * (IMOR_10$p.e*IMOR_10$m3.IMOR.e)/(IMOR_10$p.e*IMOR_10$m3.IMOR.e+1-IMOR_10$p.e) +
    IMOR_10$m4.a.e * (IMOR_10$p.e*IMOR_10$m4.IMOR.e)/(IMOR_10$p.e*IMOR_10$m4.IMOR.e+1-IMOR_10$p.e) +
    IMOR_10$m5.a.e * (IMOR_10$p.e*IMOR_10$m5.IMOR.e)/(IMOR_10$p.e*IMOR_10$m5.IMOR.e+1-IMOR_10$p.e)
  
  IMOR_10$p.star.c <- IMOR_10$p.c*(1-IMOR_10$a.c) + 
    IMOR_10$m1.a.c * (IMOR_10$p.c*IMOR_10$m1.IMOR.c)/(IMOR_10$p.c*IMOR_10$m1.IMOR.c+1-IMOR_10$p.c) +
    IMOR_10$m2.a.c * (IMOR_10$p.c*IMOR_10$m2.IMOR.c)/(IMOR_10$p.c*IMOR_10$m2.IMOR.c+1-IMOR_10$p.c) +
    IMOR_10$m3.a.c * (IMOR_10$p.c*IMOR_10$m3.IMOR.c)/(IMOR_10$p.c*IMOR_10$m3.IMOR.c+1-IMOR_10$p.c) +
    IMOR_10$m4.a.c * (IMOR_10$p.c*IMOR_10$m4.IMOR.c)/(IMOR_10$p.c*IMOR_10$m4.IMOR.c+1-IMOR_10$p.c) +
    IMOR_10$m5.a.c * (IMOR_10$p.c*IMOR_10$m5.IMOR.c)/(IMOR_10$p.c*IMOR_10$m5.IMOR.c+1-IMOR_10$p.c)
  
  IMOR_10$var.p.star.e <- IMOR_10$p.e*(1-IMOR_10$p.e)/(IMOR_10$N.e-IMOR_10$m.e) *
    (1 +
       IMOR_10$m1.a.e * (IMOR_10$m1.IMOR.e/(IMOR_10$p.e * IMOR_10$m1.IMOR.e + 1-IMOR_10$p.e)^2-1) +
       IMOR_10$m2.a.e * (IMOR_10$m2.IMOR.e/(IMOR_10$p.e * IMOR_10$m2.IMOR.e + 1-IMOR_10$p.e)^2-1) +
       IMOR_10$m3.a.e * (IMOR_10$m3.IMOR.e/(IMOR_10$p.e * IMOR_10$m3.IMOR.e + 1-IMOR_10$p.e)^2-1) +
       IMOR_10$m4.a.e * (IMOR_10$m4.IMOR.e/(IMOR_10$p.e * IMOR_10$m4.IMOR.e + 1-IMOR_10$p.e)^2-1) +
       IMOR_10$m5.a.e * (IMOR_10$m5.IMOR.e/(IMOR_10$p.e * IMOR_10$m5.IMOR.e + 1-IMOR_10$p.e)^2-1)
    )^2 +
    (1/IMOR_10$N.e) * 
    ((IMOR_10$p.e - IMOR_10$p.star.e)^2 +
       IMOR_10$m1.a.e * ((IMOR_10$m1.p.e-IMOR_10$p.star.e)^2-(IMOR_10$p.e-IMOR_10$p.star.e)^2) +
       IMOR_10$m2.a.e * ((IMOR_10$m2.p.e-IMOR_10$p.star.e)^2-(IMOR_10$p.e-IMOR_10$p.star.e)^2) +
       IMOR_10$m3.a.e * ((IMOR_10$m3.p.e-IMOR_10$p.star.e)^2-(IMOR_10$p.e-IMOR_10$p.star.e)^2) +
       IMOR_10$m4.a.e * ((IMOR_10$m4.p.e-IMOR_10$p.star.e)^2-(IMOR_10$p.e-IMOR_10$p.star.e)^2) +
       IMOR_10$m5.a.e * ((IMOR_10$m5.p.e-IMOR_10$p.star.e)^2-(IMOR_10$p.e-IMOR_10$p.star.e)^2)
    )
  
  IMOR_10$var.p.star.c <- IMOR_10$p.c*(1-IMOR_10$p.c)/(IMOR_10$N.c-IMOR_10$m.c) *
    (1 +
       IMOR_10$m1.a.c * (IMOR_10$m1.IMOR.c/(IMOR_10$p.c * IMOR_10$m1.IMOR.c + 1-IMOR_10$p.c)^2-1) +
       IMOR_10$m2.a.c * (IMOR_10$m2.IMOR.c/(IMOR_10$p.c * IMOR_10$m2.IMOR.c + 1-IMOR_10$p.c)^2-1) +
       IMOR_10$m3.a.c * (IMOR_10$m3.IMOR.c/(IMOR_10$p.c * IMOR_10$m3.IMOR.c + 1-IMOR_10$p.c)^2-1) +
       IMOR_10$m4.a.c * (IMOR_10$m4.IMOR.c/(IMOR_10$p.c * IMOR_10$m4.IMOR.c + 1-IMOR_10$p.c)^2-1) +
       IMOR_10$m5.a.c * (IMOR_10$m5.IMOR.c/(IMOR_10$p.c * IMOR_10$m5.IMOR.c + 1-IMOR_10$p.c)^2-1)
    )^2 +
    (1/IMOR_10$N.c) * 
    ((IMOR_10$p.c - IMOR_10$p.star.c)^2 +
       IMOR_10$m1.a.c * ((IMOR_10$m1.p.c-IMOR_10$p.star.c)^2-(IMOR_10$p.c-IMOR_10$p.star.c)^2) +
       IMOR_10$m2.a.c * ((IMOR_10$m2.p.c-IMOR_10$p.star.c)^2-(IMOR_10$p.c-IMOR_10$p.star.c)^2) +
       IMOR_10$m3.a.c * ((IMOR_10$m3.p.c-IMOR_10$p.star.c)^2-(IMOR_10$p.c-IMOR_10$p.star.c)^2) +
       IMOR_10$m4.a.c * ((IMOR_10$m4.p.c-IMOR_10$p.star.c)^2-(IMOR_10$p.c-IMOR_10$p.star.c)^2) +
       IMOR_10$m5.a.c * ((IMOR_10$m5.p.c-IMOR_10$p.star.c)^2-(IMOR_10$p.c-IMOR_10$p.star.c)^2)
    )
  
  IMOR_10$var.p.e <- IMOR_10$p.e*(1-IMOR_10$p.e)/(IMOR_10$N.e-IMOR_10$m.e)
  IMOR_10$var.p.c <- IMOR_10$p.c*(1-IMOR_10$p.c)/(IMOR_10$N.c-IMOR_10$m.c)
  
  IMOR_10$logOR <- log((IMOR_10$p.e/(1-IMOR_10$p.e))/(IMOR_10$p.c/(1-IMOR_10$p.c)))
  IMOR_10$var.logOR <- 
    IMOR_10$var.p.e/(IMOR_10$p.e*(1-IMOR_10$p.e))^2 +
    IMOR_10$var.p.c/(IMOR_10$p.c*(1-IMOR_10$p.c))^2
  
  IMOR_10$logOR.star <- log((IMOR_10$p.star.e/(1-IMOR_10$p.star.e))/(IMOR_10$p.star.c/(1-IMOR_10$p.star.c)))
  IMOR_10$var.logOR.star <- 
    IMOR_10$var.p.star.e/(IMOR_10$p.star.e*(1-IMOR_10$p.star.e))^2 +
    IMOR_10$var.p.star.c/(IMOR_10$p.star.c*(1-IMOR_10$p.star.c))^2
  
  IMOR_10$logRR <- log(IMOR_10$p.e/IMOR_10$p.c)
  IMOR_10$var.logRR <- 
    IMOR_10$var.p.e/(IMOR_10$p.e)^2 +
    IMOR_10$var.p.c/(IMOR_10$p.c)^2
  
  IMOR_10$logRR.star <- log(IMOR_10$p.star.e/IMOR_10$p.star.c)
  IMOR_10$var.logRR.star <- 
    IMOR_10$var.p.star.e/(IMOR_10$p.star.e)^2 +
    IMOR_10$var.p.star.c/(IMOR_10$p.star.c)^2
  
  # IMOR for all missing causes (IMOR_M)
  # Here IMOR is given and p has to be calculated
  IMOR_M$m1.IMOR.e <- IMOR_E
  IMOR_M$m2.IMOR.e <- IMOR_E
  IMOR_M$m3.IMOR.e <- IMOR_E
  IMOR_M$m4.IMOR.e <- IMOR_E
  IMOR_M$m5.IMOR.e <- IMOR_E
  IMOR_M$m1.p.e <- IMOR_M$p.e*IMOR_M$m1.IMOR.e/(IMOR_M$p.e*IMOR_M$m1.IMOR.e + 1 - IMOR_M$p.e)
  IMOR_M$m2.p.e <- IMOR_M$p.e*IMOR_M$m2.IMOR.e/(IMOR_M$p.e*IMOR_M$m2.IMOR.e + 1 - IMOR_M$p.e)
  IMOR_M$m3.p.e <- IMOR_M$p.e*IMOR_M$m3.IMOR.e/(IMOR_M$p.e*IMOR_M$m3.IMOR.e + 1 - IMOR_M$p.e)
  IMOR_M$m4.p.e <- IMOR_M$p.e*IMOR_M$m4.IMOR.e/(IMOR_M$p.e*IMOR_M$m4.IMOR.e + 1 - IMOR_M$p.e)
  IMOR_M$m5.p.e <- IMOR_M$p.e*IMOR_M$m5.IMOR.e/(IMOR_M$p.e*IMOR_M$m5.IMOR.e + 1 - IMOR_M$p.e)
  
  IMOR_M$m1.IMOR.c <- IMOR_C
  IMOR_M$m2.IMOR.c <- IMOR_C
  IMOR_M$m3.IMOR.c <- IMOR_C
  IMOR_M$m4.IMOR.c <- IMOR_C
  IMOR_M$m5.IMOR.c <- IMOR_C
  IMOR_M$m1.p.c <- IMOR_M$p.c*IMOR_M$m1.IMOR.c/(IMOR_M$p.c*IMOR_M$m1.IMOR.c + 1 - IMOR_M$p.c)
  IMOR_M$m2.p.c <- IMOR_M$p.c*IMOR_M$m2.IMOR.c/(IMOR_M$p.c*IMOR_M$m2.IMOR.c + 1 - IMOR_M$p.c)
  IMOR_M$m3.p.c <- IMOR_M$p.c*IMOR_M$m3.IMOR.c/(IMOR_M$p.c*IMOR_M$m3.IMOR.c + 1 - IMOR_M$p.c)
  IMOR_M$m4.p.c <- IMOR_M$p.c*IMOR_M$m4.IMOR.c/(IMOR_M$p.c*IMOR_M$m4.IMOR.c + 1 - IMOR_M$p.c)
  IMOR_M$m5.p.c <- IMOR_M$p.c*IMOR_M$m5.IMOR.c/(IMOR_M$p.c*IMOR_M$m5.IMOR.c + 1 - IMOR_M$p.c)
  
  IMOR_M$p.star.e <- IMOR_M$p.e*(1-IMOR_M$a.e) + 
    IMOR_M$m1.a.e * (IMOR_M$p.e*IMOR_M$m1.IMOR.e)/(IMOR_M$p.e*IMOR_M$m1.IMOR.e+1-IMOR_M$p.e) +
    IMOR_M$m2.a.e * (IMOR_M$p.e*IMOR_M$m2.IMOR.e)/(IMOR_M$p.e*IMOR_M$m2.IMOR.e+1-IMOR_M$p.e) +
    IMOR_M$m3.a.e * (IMOR_M$p.e*IMOR_M$m3.IMOR.e)/(IMOR_M$p.e*IMOR_M$m3.IMOR.e+1-IMOR_M$p.e) +
    IMOR_M$m4.a.e * (IMOR_M$p.e*IMOR_M$m4.IMOR.e)/(IMOR_M$p.e*IMOR_M$m4.IMOR.e+1-IMOR_M$p.e) +
    IMOR_M$m5.a.e * (IMOR_M$p.e*IMOR_M$m5.IMOR.e)/(IMOR_M$p.e*IMOR_M$m5.IMOR.e+1-IMOR_M$p.e)
  
  IMOR_M$p.star.c <- IMOR_M$p.c*(1-IMOR_M$a.c) + 
    IMOR_M$m1.a.c * (IMOR_M$p.c*IMOR_M$m1.IMOR.c)/(IMOR_M$p.c*IMOR_M$m1.IMOR.c+1-IMOR_M$p.c) +
    IMOR_M$m2.a.c * (IMOR_M$p.c*IMOR_M$m2.IMOR.c)/(IMOR_M$p.c*IMOR_M$m2.IMOR.c+1-IMOR_M$p.c) +
    IMOR_M$m3.a.c * (IMOR_M$p.c*IMOR_M$m3.IMOR.c)/(IMOR_M$p.c*IMOR_M$m3.IMOR.c+1-IMOR_M$p.c) +
    IMOR_M$m4.a.c * (IMOR_M$p.c*IMOR_M$m4.IMOR.c)/(IMOR_M$p.c*IMOR_M$m4.IMOR.c+1-IMOR_M$p.c) +
    IMOR_M$m5.a.c * (IMOR_M$p.c*IMOR_M$m5.IMOR.c)/(IMOR_M$p.c*IMOR_M$m5.IMOR.c+1-IMOR_M$p.c)
  
  IMOR_M$var.p.star.e <- IMOR_M$p.e*(1-IMOR_M$p.e)/(IMOR_M$N.e-IMOR_M$m.e) *
    (1 +
       IMOR_M$m1.a.e * (IMOR_M$m1.IMOR.e/(IMOR_M$p.e * IMOR_M$m1.IMOR.e + 1-IMOR_M$p.e)^2-1) +
       IMOR_M$m2.a.e * (IMOR_M$m2.IMOR.e/(IMOR_M$p.e * IMOR_M$m2.IMOR.e + 1-IMOR_M$p.e)^2-1) +
       IMOR_M$m3.a.e * (IMOR_M$m3.IMOR.e/(IMOR_M$p.e * IMOR_M$m3.IMOR.e + 1-IMOR_M$p.e)^2-1) +
       IMOR_M$m4.a.e * (IMOR_M$m4.IMOR.e/(IMOR_M$p.e * IMOR_M$m4.IMOR.e + 1-IMOR_M$p.e)^2-1) +
       IMOR_M$m5.a.e * (IMOR_M$m5.IMOR.e/(IMOR_M$p.e * IMOR_M$m5.IMOR.e + 1-IMOR_M$p.e)^2-1)
    )^2 +
    (1/IMOR_M$N.e) * 
    ((IMOR_M$p.e - IMOR_M$p.star.e)^2 +
       IMOR_M$m1.a.e * ((IMOR_M$m1.p.e-IMOR_M$p.star.e)^2-(IMOR_M$p.e-IMOR_M$p.star.e)^2) +
       IMOR_M$m2.a.e * ((IMOR_M$m2.p.e-IMOR_M$p.star.e)^2-(IMOR_M$p.e-IMOR_M$p.star.e)^2) +
       IMOR_M$m3.a.e * ((IMOR_M$m3.p.e-IMOR_M$p.star.e)^2-(IMOR_M$p.e-IMOR_M$p.star.e)^2) +
       IMOR_M$m4.a.e * ((IMOR_M$m4.p.e-IMOR_M$p.star.e)^2-(IMOR_M$p.e-IMOR_M$p.star.e)^2) +
       IMOR_M$m5.a.e * ((IMOR_M$m5.p.e-IMOR_M$p.star.e)^2-(IMOR_M$p.e-IMOR_M$p.star.e)^2)
    )
  
  IMOR_M$var.p.star.c <- IMOR_M$p.c*(1-IMOR_M$p.c)/(IMOR_M$N.c-IMOR_M$m.c) *
    (1 +
       IMOR_M$m1.a.c * (IMOR_M$m1.IMOR.c/(IMOR_M$p.c * IMOR_M$m1.IMOR.c + 1-IMOR_M$p.c)^2-1) +
       IMOR_M$m2.a.c * (IMOR_M$m2.IMOR.c/(IMOR_M$p.c * IMOR_M$m2.IMOR.c + 1-IMOR_M$p.c)^2-1) +
       IMOR_M$m3.a.c * (IMOR_M$m3.IMOR.c/(IMOR_M$p.c * IMOR_M$m3.IMOR.c + 1-IMOR_M$p.c)^2-1) +
       IMOR_M$m4.a.c * (IMOR_M$m4.IMOR.c/(IMOR_M$p.c * IMOR_M$m4.IMOR.c + 1-IMOR_M$p.c)^2-1) +
       IMOR_M$m5.a.c * (IMOR_M$m5.IMOR.c/(IMOR_M$p.c * IMOR_M$m5.IMOR.c + 1-IMOR_M$p.c)^2-1)
    )^2 +
    (1/IMOR_M$N.c) * 
    ((IMOR_M$p.c - IMOR_M$p.star.c)^2 +
       IMOR_M$m1.a.c * ((IMOR_M$m1.p.c-IMOR_M$p.star.c)^2-(IMOR_M$p.c-IMOR_M$p.star.c)^2) +
       IMOR_M$m2.a.c * ((IMOR_M$m2.p.c-IMOR_M$p.star.c)^2-(IMOR_M$p.c-IMOR_M$p.star.c)^2) +
       IMOR_M$m3.a.c * ((IMOR_M$m3.p.c-IMOR_M$p.star.c)^2-(IMOR_M$p.c-IMOR_M$p.star.c)^2) +
       IMOR_M$m4.a.c * ((IMOR_M$m4.p.c-IMOR_M$p.star.c)^2-(IMOR_M$p.c-IMOR_M$p.star.c)^2) +
       IMOR_M$m5.a.c * ((IMOR_M$m5.p.c-IMOR_M$p.star.c)^2-(IMOR_M$p.c-IMOR_M$p.star.c)^2)
    )
  
  IMOR_M$var.p.e <- IMOR_M$p.e*(1-IMOR_M$p.e)/(IMOR_M$N.e-IMOR_M$m.e)
  IMOR_M$var.p.c <- IMOR_M$p.c*(1-IMOR_M$p.c)/(IMOR_M$N.c-IMOR_M$m.c)
  
  IMOR_M$logOR <- log((IMOR_M$p.e/(1-IMOR_M$p.e))/(IMOR_M$p.c/(1-IMOR_M$p.c)))
  IMOR_M$var.logOR <- 
    IMOR_M$var.p.e/(IMOR_M$p.e*(1-IMOR_M$p.e))^2 +
    IMOR_M$var.p.c/(IMOR_M$p.c*(1-IMOR_M$p.c))^2
  
  IMOR_M$logOR.star <- log((IMOR_M$p.star.e/(1-IMOR_M$p.star.e))/(IMOR_M$p.star.c/(1-IMOR_M$p.star.c)))
  IMOR_M$var.logOR.star <- 
    IMOR_M$var.p.star.e/(IMOR_M$p.star.e*(1-IMOR_M$p.star.e))^2 +
    IMOR_M$var.p.star.c/(IMOR_M$p.star.c*(1-IMOR_M$p.star.c))^2
  
  IMOR_M$logRR <- log(IMOR_M$p.e/IMOR_M$p.c)
  IMOR_M$var.logRR <- 
    IMOR_M$var.p.e/(IMOR_M$p.e)^2 +
    IMOR_M$var.p.c/(IMOR_M$p.c)^2
  
  IMOR_M$logRR.star <- log(IMOR_M$p.star.e/IMOR_M$p.star.c)
  IMOR_M$var.logRR.star <- 
    IMOR_M$var.p.star.e/(IMOR_M$p.star.e)^2 +
    IMOR_M$var.p.star.c/(IMOR_M$p.star.c)^2
  
  # Meta-analysis generic inverse variance random-effects meta-analysis
  # Effect measure from the meta-analysis
  EffectMeasure <- MA$sm
  # add the study labels to the front of IMORs
  IMOR <- cbind(Study=as.character(df_Outcome[,4]),IMOR)
  IMOR_01 <- cbind(Study=as.character(df_Outcome[,4]),IMOR_01)
  IMOR_10 <- cbind(Study=as.character(df_Outcome[,4]),IMOR_10)
  IMOR_M <- cbind(Study=as.character(df_Outcome[,4]),IMOR_M)
  
  if (EffectMeasure == "OR" | EffectMeasure == "RR") {
    MA_IMOR <- metagen(
      IMOR[,match(ifelse(EffectMeasure == "OR","logOR.star","logRR.star"),colnames(IMOR))],
      IMOR[,match(ifelse(EffectMeasure == "OR","var.logOR.star","var.logRR.star"),colnames(IMOR))],
      n.e = IMOR$N.e,
      n.c = IMOR$N.c,
      data = IMOR,
      studlab = IMOR$Study,
      text.common = "Fixed effect model",
      text.w.common = "fixed",
      common = MA$common,
      sm = EffectMeasure,
      method.random.ci = MA$method.random.ci,
      method.predict = ifelse(MA$method == "GLMM","HTS","HK"),
      prediction = MA$prediction,
      outclab = MA$outclab,
      label.e = MA$label.e,
      label.c = MA$label.c,
      label.left = MA$label.left,
      label.right = MA$label.right
    )
    MA_IMOR_01 <- metagen(
      IMOR_01[,match(ifelse(EffectMeasure == "OR","logOR.star","logRR.star"),colnames(IMOR_01))],
      IMOR_01[,match(ifelse(EffectMeasure == "OR","var.logOR.star","var.logRR.star"),colnames(IMOR_01))],
      n.e = IMOR_01$N.e,
      n.c = IMOR_01$N.c,
      data = IMOR_01,
      studlab = IMOR_01$Study,
      text.common = "Fixed effect model",
      text.w.common = "fixed",
      common = MA$common,
      sm = EffectMeasure,
      method.random.ci = MA$method.random.ci,
      method.predict = ifelse(MA$method == "GLMM","HTS","HK"),
      prediction = MA$prediction,
      outclab = MA$outclab,
      label.e = MA$label.e,
      label.c = MA$label.c,
      label.left = MA$label.left,
      label.right = MA$label.right
    )
    MA_IMOR_10 <- metagen(
      IMOR_10[,match(ifelse(EffectMeasure == "OR","logOR.star","logRR.star"),colnames(IMOR_10))],
      IMOR_10[,match(ifelse(EffectMeasure == "OR","var.logOR.star","var.logRR.star"),colnames(IMOR_10))],
      n.e = IMOR_10$N.e,
      n.c = IMOR_10$N.c,
      data = IMOR_10,
      studlab = IMOR_10$Study,
      text.common = "Fixed effect model",
      text.w.common = "fixed",
      common = MA$common,
      sm = EffectMeasure,
      method.random.ci = MA$method.random.ci,
      method.predict = ifelse(MA$method == "GLMM","HTS","HK"),
      prediction = MA$prediction,
      outclab = MA$outclab,
      label.e = MA$label.e,
      label.c = MA$label.c,
      label.left = MA$label.left,
      label.right = MA$label.right
    )
    MA_IMOR_M <- metagen(
      IMOR_M[,match(ifelse(EffectMeasure == "OR","logOR.star","logRR.star"),colnames(IMOR_M))],
      IMOR_M[,match(ifelse(EffectMeasure == "OR","var.logOR.star","var.logRR.star"),colnames(IMOR_M))],
      n.e = IMOR_M$N.e,
      n.c = IMOR_M$N.c,
      data = IMOR_M,
      studlab = IMOR_M$Study,
      text.common = "Fixed effect model",
      text.w.common = "fixed",
      common = MA$common,
      sm = EffectMeasure,
      method.random.ci = MA$method.random.ci,
      method.predict = ifelse(MA$method == "GLMM","HTS","HK"),
      prediction = MA$prediction,
      outclab = MA$outclab,
      label.e = MA$label.e,
      label.c = MA$label.c,
      label.left = MA$label.left,
      label.right = MA$label.right
    )
    
  } else {
    MA_IMOR <- as.character("Sensitivity analysis is usually conducted for the effect measure used in the primary analysis only")
    MA_IMOR_01 <- as.character("Sensitivity analysis is usually conducted for the effect measure used in the primary analysis only")
    MA_IMOR_10 <- as.character("Sensitivity analysis is usually conducted for the effect measure used in the primary analysis only")
    MA_IMOR_M <- as.character("Sensitivity analysis is usually conducted for the effect measure used in the primary analysis only")
  }
  
  ifelse(tolower(df_Outcome[1,3]) == "worse",
         return(list("Missing outcome analysis (according to reason)" = MA_IMOR,"Best-worst analysis" = MA_IMOR_01,"Worst-best analysis" = MA_IMOR_10,"Missing outcome analysis (no reasons provided)" = MA_IMOR_M)),
         return(list("Missing outcome analysis (according to reason)" = MA_IMOR,"Best-worst analysis" = MA_IMOR_10,"Worst-best analysis" = MA_IMOR_01,"Missing outcome analysis (no reasons provided)" = MA_IMOR_M))
  )
}
# Functions for reference screener ####
import.pmid <- function(p) {
  p <- data.frame(p)
  colnames(p) <- "initial"
  p$tag <- NA
  p$pmid <- NA
  p$content <- p$initial
  p$content[substr(p$initial,5,5) == "-"] <- substr(p$initial[substr(p$initial,5,5) == "-"],6,nchar(p$initial[substr(p$initial,5,5) == "-"])) 
  p$tag[substr(p$initial,5,5) == "-"] <- substr(p$initial[substr(p$initial,5,5) == "-"],1,4) 
  p$tag = trimws(p$tag)
  p$tag <- na.locf(na.locf(p$tag),fromLast=TRUE)
  p$content <- trimws(p$content)
  p$pmid[p$tag == "PMID"] <- trimws(
    substr(p$initial[p$tag == "PMID"],6,nchar(p$initial[p$tag == "PMID"]))
  )
  p$pmid <- na.locf(na.locf(p$pmid),fromLast=TRUE)
  # For article identifier, keep only the doi
  p$content[
    (
      (p$tag == "AID") & 
        (substr(p$content,
                (nchar(p$content)-4),
                nchar(p$content)
        ) != "[doi]"
        )
    )
  ] <- ""
  p <- p[p$content !="",]
  p$content[p$tag == "AID"] <- paste0("https://doi.org/",
                                      trimws(
                                        substr(p$content[p$tag == "AID"],
                                               1, (nchar(p$content[p$tag == "AID"])-5)
                                        )
                                      )
  )
  # Convert data to wide format
  suppressWarnings(
    suppressMessages(
      q <- pivot_wider(p[,c("pmid","tag","content")], names_from = tag, values_from = content)
    )
  )
  # The output is in the form of a list because of multiple rows for some fields
  # Convert this into one row per reference
  r <- data.frame(matrix(nrow = length(q[[1]]), ncol = 0))
  for (i in 2:length(q)) {
    s <- vector()
    for (j in 1:length(q[[i]])) {
      if (is.null(q[[i]][[j]])) {
        s <- c(s, NA)
      } else {
        if (!is.na(q[[i]][[j]][1])) {
          if (length(q[[i]][[j]][1] > 1)){
            s <- c(s, substr(trimws(paste0(q[[i]][[j]], collapse = "\n")),1,20000))
          } else {
            s <- c(s, trimws(q[[i]][[j]][1]))
          }
        } else {
          s <- c(s, NA)
        }
      }
    }
    r <- data.frame(cbind(r, s))
    colnames(r)[ncol(r)] <- colnames(q)[i]
  }
  # Remove the dots from the column names
  colnames(r) <- str_remove_all(colnames(r),"\\.")
  r
}
import.embase <- function(x) {
  x$AE <- trimws(x$AE)
  x$AE[x$AE == ""] <- trimws(x$AD[x$AE == ""])
  x
}
import.wos <- function(x) {
  # The doi in DL is not correct (insecure link) - Create a secure link from DI
  x$DI <- trimws(x$DI)
  x$DL[x$DI != ""] <- paste0(
    "https://doi.org/",
    x$DI[x$DI != ""]  
  )
  # If author email is missing, get the author address
  x$EM[x$EM == ""] <- x$C3[x$EM == ""]
  # Page numbers have to be calculated. This can be stored in a new field "PGN" (as PG is used for number of pages)
  x$PGN <- ""
  # If start page and end page are the same (or if end page is missing with start page not missing), then only the start page should be mentioned
  x$PGN[
    (
      (x$BP != "") &
        ((x$EP == "") | (x$EP == x$BP))
    )
  ] <- 
    x$BP[
      (
        (x$BP != "") &
          ((x$EP == "") | (x$EP == x$BP))
      )
    ]
  # If start page is present and end page is simply '+' then the end page has to be obtained from start page + number of pages
  x$PGN[
    (
      (x$BP != "") &
        (x$EP == "+")
    )
  ] <-
    paste0(
      x$BP[
        (
          (x$BP != "") &
            (x$EP == "+")
        )
      ],
      "-",
      as.numeric(x$PG[
        (
          (x$BP != "") &
            (x$EP == "+")
        )
      ]) + 
        as.numeric(x$BP[
          (
            (x$BP != "") &
              (x$EP == "+")
          )
        ]) - 1
    )
  # If start page is present and above conditions are not met, it is start page to end page
  x$PGN[
    (
      (x$BP != "") &
        (x$PGN == "")
    )
  ] <-
    paste0(
      x$BP[
        (
          (x$BP != "") &
            (x$PGN == "")
        )
      ],
      "-",
      x$EP[
        (
          (x$BP != "") &
            (x$PGN == "")
        )
      ]
    )
  # If none of the above conditions are met, the page is obtained from "AR"
  x$PGN[
    (x$PGN == "")
  ] <-
    x$AR[
      (x$PGN == "")
    ] 
  # If none of the above conditions are met, the page is obtained from "DL"
  x$PGN[
    (x$PGN == "")
  ] <-
    x$DL[
      (x$PGN == "")
    ] 
  x  
}
import.cochrane <- function(x) {
  x$DOI <- trimws(x$DOI)
  x$DOI[x$DOI != ""] <- paste0(
    "https://doi.org/",
    x$DOI[x$DOI != ""]  
  )
  x
}
import.ictrp <- function(p, x) {
  p <- na.omit(p)
  colnames(p) <- "initial"
  # Identify each record
  p$trial <- NA
  p$tag <- NA
  p$content <- p$initial
  p[!is.na(str_locate(p$initial, "<Trial>")[,1]),2] <- 
    1:length(p[!is.na(str_locate(p$initial, "<Trial>")[,1]),1])
  p$content <- 
    trimws(
      str_remove_all(
        str_remove_all(
          str_remove_all(
            p$content,fixed("<Trial>")
          ), fixed("<Trial/>")
        ), fixed("</Trial>")
      )
    )
  p[,1] <- trimws(p[,1])
  p <- p[p[,1] !="",]
  # Now remove all the data before the first trial and the last row should be removed too
  p <- data.frame(p[(match(1,p$trial):(nrow(p)-1)),])
  p$trial <- na.locf(na.locf(p$trial),fromLast=TRUE)
  # If there is no data, the start and end tags for absent data is denoted differently from the usual start and end tags
  q <- list(
    paste0("<",colnames(xmlToDataFrame(x)), ">"), # Start tags
    paste0("<",colnames(xmlToDataFrame(x)), "/>"), # Start and end tags combined if there is no data
    paste0("</",colnames(xmlToDataFrame(x)), ">"), # End tag if there is data
    colnames(xmlToDataFrame(x)) # Simply the column names
  )            
  for (i in 1:length(q[[1]])) {
    p$tag[str_detect(p$initial,fixed(q[[1]][i]))] <-q[[1]][i] 
    p$tag[str_detect(p$initial,fixed(q[[2]][i]))] <-q[[1]][i] # Even if the start and end tags are combined, for correct transformation, we need the standard start tag
    # Remove the tags from the content
    p$content <- 
      trimws(
        str_remove_all(
          str_remove_all(
            str_remove_all(
              p$content,fixed(q[[1]][i])
            ), fixed(q[[2]][i])
          ), fixed(q[[3]][i])
        )
      )
  }
  p$tag <- na.locf(na.locf(p$tag),fromLast=TRUE)
  # Convert data to wide format 
  suppressWarnings(
    suppressMessages(
      r <- pivot_wider(p[,c("trial","tag","content")], names_from = tag, values_from = content)
    )
  )
  # The output is in the form of a list because of multiple rows for some fields
  # Convert this into one row per reference
  s <- data.frame(matrix(nrow = length(r[[1]]), ncol = 0))
  for (i in 1:length(r)) {
    t <- vector()
    for (j in 1:length(r[[i]])) {
      if (is.null(r[[i]][[j]])) {
        t <- c(t, NA)
      } else {
        if (!is.na(r[[i]][[j]][1])) {
          if (length(r[[i]][[j]][1] > 1)){
            t <- c(t, substr(trimws(paste0(r[[i]][[j]], collapse = "\n")),1,20000))
          } else {
            t <- c(t, trimws(r[[i]][[j]][1]))
          }
        } else {
          t <- c(t, NA)
        }
      }
    }
    s <- data.frame(cbind(s, t))
    colnames(s)[ncol(s)] <- c("Trial", q[[4]])[i]
  }
  # Now change the insecure links to secure links
  s$web_address <- str_replace(s$web_address,
                               "http:",
                               "https:"
  )
  s
}
Author.list.PubMed <- function(x) {
  paste0(trimws(str_split(x,"\n")[[1]]), collapse = ", ")
}
Abstract.PubMed <- function(x) {
  paste0(trimws(str_split(x,"\n")[[1]]), collapse = " ")
}
Author.list.Ovid <- function(x) {
  x <- str_replace_all(x, "\n\n","\n")
  x <- str_replace_all(x, "\\.","")
  paste0(trimws(str_split(x,"\n")[[1]]), collapse = ", ")
}
Author.list.wos <- function(x) {
  x <- str_replace_all(x, "\\,","")
  str_replace_all(x, "\\;",",")
}
Author.list.ICTRP <- function(x) {
  # Remove space character described as &#x20; in XML parsing
  # Keep only the first author when there are multiple authors to manage the combination of names
  y1 <- x[,1]
  y1[is.na(y1)] <- "" 
  y1 <- str_remove_all(y1, "&#x20;")
  y1 <- str_replace_all(y1, "\n", " ")
  y1[((nchar(y1) == 1) & (y1 == ";"))] <- ""
  y1[str_detect(y1,";")] <- 
    substr(y1[str_detect(y1,";")],1,((str_locate(y1[str_detect(y1,";")],";")[,1])-1))
  y2 <- x[,2]
  y2[is.na(y2)] <- "" 
  y2 <- str_remove_all(y2, "&#x20;")
  y2 <- str_replace_all(y2, "\n", " ")
  y2[((nchar(y2) == 1) & (y2 == ";"))] <- ""
  y2[str_detect(y2,";")] <- 
    substr(y2[str_detect(y2,";")],1,((str_locate(y2[str_detect(y2,";")],";")[,1])-1))
  trimws(paste0(y1, " ", y2))  
}
Author.Contact.ICTRP <- function(x) {
  # Remove space character described as &#x20; in XML parsing
  # Keep only the first author when there are multiple authors to manage the combination of names
  y1 <- x[,1]
  y1[is.na(y1)] <- "" 
  y1 <- str_remove_all(y1, "&#x20;")
  y1 <- str_replace_all(y1, "\n", " ")
  y1[((nchar(y1) == 1) & (y1 == ";"))] <- ""
  y1[str_detect(y1,";")] <- 
    substr(y1[str_detect(y1,";")],1,((str_locate(y1[str_detect(y1,";")],";")[,1])-1))
  y2 <- x[,2]
  y2[is.na(y2)] <- "" 
  y2 <- str_remove_all(y2, "&#x20;")
  y2 <- str_replace_all(y2, "\n", " ")
  y2[((nchar(y2) == 1) & (y2 == ";"))] <- ""
  y2[str_detect(y2,";")] <- 
    substr(y2[str_detect(y2,";")],1,((str_locate(y2[str_detect(y2,";")],";")[,1])-1))
  # If email not present get main address
  y1[y1==""] <- y2[y1==""]
  trimws(y1)  
}
keywords.pubmed <- function(x) {
  y = trimws(x)
  if ((y=="") | (is.na(y))) {
    ""
  } else {
    paste0(trimws(str_split(y,"\n")[[1]]), collapse = "; ")    
  }
}
keywords.embase <- function(x) {
  y = trimws(x)
  if ((y=="") | (is.na(y))) {
    ""
  } else {
    y = str_remove_all(
      y,
      "\\[m\\]"
    )
    z = paste0(
      unique(trimws(str_split(y,"\n\n")[[1]])), 
      collapse = "; ")
    str_replace_all(z, ";;",";")
  }
}
keywords.wos <- function(x) {
  x[,1] <- str_to_title(trimws(x[,1]))
  x[,2] <- trimws(x[,2])
  x[,3] <- ""
  x[
    ((x[,1] != "") & (!is.na(x[,1]))) &
      ((x[,2] == "") | (is.na(x[,2])))
    , 3] <- 
    x[
      ((x[,1] != "") & (!is.na(x[,1]))) &
        ((x[,2] == "") | (is.na(x[,2])))
      , 1]
  x[
    ((x[,1] != "") & (!is.na(x[,1]))) &
      ((x[,2] != "") & (!is.na(x[,2])))
    , 3] <- 
    paste0(
      x[
        ((x[,1] != "") & (!is.na(x[,1]))) &
          ((x[,2] != "") & (!is.na(x[,2])))
        , 1], 
      "; ",
      x[
        ((x[,1] != "") & (!is.na(x[,1]))) &
          ((x[,2] != "") & (!is.na(x[,2])))
        , 2]
      
    )
  trimws(x[,3])
}
CTgov.Summary <- function(x) {
  y <- list()
  for (i in 1:7) {
    y[[i]] <- str_replace_all(trimws(x[,i]), "\\|","<br>")
    y[[i]][is.na(y[[i]])] <- ""
    if (i == 7) {
      y[[6]] <- paste0(y[[6]],"<br>",y[[7]])
    }
    y[[i]][y[[i]] == ""] <- "No information"
  }
  z <- paste0("<strong>","Brief summary", "</strong>","<br>", trimws(y[[1]]), "<br>", 
              "<strong>","Study design", "</strong>", "<br>", trimws(y[[2]]), "<br>", 
              "<strong>","Condition", "</strong>", "<br>", trimws(y[[3]]), "<br>", 
              "<strong>","Intervention", "</strong>", "<br>", trimws(y[[4]]), "<br>", 
              "<strong>","Primary outcome", "</strong>", "<br>", trimws(y[[5]]), "<br>", 
              "<strong>","Secondary outcome", "</strong>", "<br>", trimws(y[[6]])
  )
  trimws(str_replace_all(z,"<br><br>","<br>"))
}
ICTRP.Summary <- function(x) {
  # Remove some characters which are errors in XML parsing with some html codes retained
  y <- list()
  for (i in 1:7) {
    y[[i]] <- x[,i]
    y[[i]][is.na(y[[i]])] <- "" 
    y[[i]] <- str_remove_all(y[[i]], "&#x20;")
    y[[i]] <- str_replace_all(y[[i]], "&lt;br&gt;", "<br>")
    y[[i]] <- str_replace_all(y[[i]], "&#x0D;", "<br>")
    y[[i]] <- str_replace_all(y[[i]], "  ", " ")
    y[[i]] <- str_replace_all(y[[i]], "  ", " ")
    y[[i]] <- str_replace_all(y[[i]], "  ", " ")
    y[[i]] <- str_replace_all(y[[i]], "  ", " ")
    y[[i]] <- str_replace_all(y[[i]], "  ", " ")
    y[[i]] <- str_replace_all(y[[i]], "&gt;", ">")
    y[[i]] <- str_replace_all(y[[i]], "&lt;", "<")
    y[[i]][((nchar(y[[i]]) == 1) & (y[[i]] == ";"))] <- ""
    y[[i]][y[[i]] == ""] <- "No information"
  }
  y[[1]] <- str_replace_all(y[[1]], "\n", "<br>")
  
  z <- paste0("<strong>","Study design", "</strong>","<br>", trimws(y[[1]]), "<br>", 
              "<strong>","Inclusion criteria", "</strong>", "<br>", trimws(y[[2]]), "<br>", 
              "<strong>","Exclusion criteria", "</strong>", "<br>", trimws(y[[3]]), "<br>", 
              "<strong>","Condition", "</strong>", "<br>", trimws(y[[4]]), "<br>", 
              "<strong>","Intervention", "</strong>", "<br>", trimws(y[[5]]), "<br>", 
              "<strong>","Primary outcome", "</strong>", "<br>", trimws(y[[6]]), "<br>", 
              "<strong>","Secondary outcome", "</strong>", "<br>", trimws(y[[7]])
  )
  z <- str_replace_all(z, "<br><br>", "<br>")
  z <- str_replace_all(z, "<br><br>", "<br>")
  z <- str_replace_all(z, "<br><br>", "<br>")
  z <- str_replace_all(z, "<br><br>", "<br>")
  z <- str_replace_all(z, "<br><br>", "<br>")
  str_replace_all(z, "<br><br>", "<br>")
}
# Replace hyphen not working well in Cochrane
Replace.hyphen <- function(x) {
  y <- utf8ToInt(x)
  y[match(8208,y)] <- 45
  intToUtf8(y)
}
# Create reference
Create.reference <- function(x) {
  authors <- trimws(x[,1])
  authors[is.na(authors)] <- ""
  authors[authors !=""] <- paste0(authors[authors !=""], ". ")
  article.title <- trimws(x[,2])
  article.title[is.na(article.title)] <- ""
  article.title[article.title !=""] <- paste0(article.title[article.title !=""], ". ")
  journal.title <- trimws(x[,3])
  journal.title[is.na(journal.title)] <- ""
  journal.title[journal.title !=""] <- paste0("<em>", journal.title[journal.title !=""], "</em>", ". ")
  publication.year <- trimws(x[,4])
  publication.year[is.na(publication.year)] <- ""
  publication.year[publication.year !=""] <- paste0(publication.year[publication.year !=""], ";")
  volume <- trimws(x[,5])
  volume[is.na(volume)] <- ""
  issue <- trimws(x[,6])
  issue[is.na(issue)] <- ""
  issue[issue !=""] <- paste0("(", issue[issue !=""], ")")
  pages <- trimws(x[,7])
  pages[is.na(pages)] <- ""
  pages[pages == "no pagination"] <- ""
  pages[pages !=""] <- paste0(pages[pages !=""], ". ")
  article.url <- trimws(x[,8])
  article.url[is.na(article.url)] <- ""
  article.url[article.url != ""] <- paste0("url: ", 
                                           "<a href=", 
                                           '"', article.url[article.url != ""],'" ', 
                                           'target="_blank">',
                                           article.url[article.url != ""],
                                           "</a>"
  )
  reference <- paste0(
    authors, article.title, journal.title,
    publication.year, volume, issue, ":", 
    pages, article.url,
    "."
  )
  reference = str_replace_all(reference, "\\.\\.","\\.")
  reference = str_replace_all(reference, "\\.\\ \\.","\\.")
  reference = str_replace_all(reference, "\\(\\)","")
  reference = str_replace_all(reference, "\\(\\ \\)","")
  reference = str_replace_all(reference, "\\;\\.",".")
  reference = str_replace_all(reference, "\\;\\:",":")
  reference = str_replace_all(reference, "\\:\\.",".")
  reference = str_replace_all(reference, "\n"," ")
  trimws(reference)
}
# Get details of data import
import.references <- function(index.file.full.name, reference.files.full.names) {
  index.file <- read.csv(index.file.full.name,header = TRUE)
  if (str_detect(index.file.full.name, fixed("\\"))) {
    index.file.full.name <- str_replace_all(index.file.full.name, fixed("\\"), "/")
  }
  index.file.path <- substr(index.file.full.name,1,str_locate_all(index.file.full.name, fixed("/"))[[1]][nrow(str_locate_all(index.file.full.name, fixed("/"))[[1]]),1])
  if (str_detect(reference.files.full.names[1], fixed("\\"))) {
    reference.files.full.names <- str_replace_all(reference.files.full.names, fixed("\\"), "/")
  }
  reference.files.path <- substr(reference.files.full.names,1,str_locate_all(reference.files.full.names, fixed("/"))[[1]][nrow(str_locate_all(reference.files.full.names, fixed("/"))[[1]]),1])
  reference.files.path <- reference.files.path[1]
  if(!file.exists(paste0(index.file.path,"References_to_Screen"))){
    dir.create(paste0(index.file.path,"References_to_Screen"))
  } else {  
    unlink(paste0(index.file.path,"References_to_Screen"), recursive = TRUE)
    dir.create(paste0(index.file.path,"References_to_Screen"))
  }
  if(!file.exists(paste0(index.file.path,"FullDetails"))){
    dir.create(paste0(index.file.path,"FullDetails"))
  } else {  
    unlink(paste0(index.file.path,"FullDetails"), recursive = TRUE)
    dir.create(paste0(index.file.path,"FullDetails"))
  }
  import.summary <- data.frame(matrix(nrow =7, ncol = 5))
  colnames(import.summary) <- c("database", "file.names","number.of.files", "file.exists", "file.exists.number")
  import.summary$database <- c(
    "PubMed", "MEDLINE", "EMBASE", "WOS", "Cochrane", "CTgov", "ICTRP" 
  )
  import.list <- list()
  for (i in 1:nrow(import.summary)) {
    import.summary$file.names[i] <- paste0(reference.files.path,
                                           index.file$file.name[index.file$database == import.summary$database[i]], 
                                           collapse = "|")
    import.summary$number.of.files[i] <- length(index.file$file.name[index.file$database == import.summary$database[i]])
    import.list[[i]] <- list(
      import.summary$database[i],
      paste0(reference.files.path, index.file$file.name[index.file$database == import.summary$database[i]]),
      file.exists(paste0(reference.files.path, index.file$file.name[index.file$database == import.summary$database[i]]))
    )
    import.summary$file.exists[i] <- paste0(
      reference.files.path, index.file$file.name[index.file$database == import.summary$database[i]],
      ": ",
      file.exists(paste0(reference.files.path, index.file$file.name[index.file$database == import.summary$database[i]])),
      collapse = "|"
    )
  }
  import.summary$file.exists.number <- str_count(import.summary$file.exists,"TRUE")
  minimum.column.names <- list(
    c("PMID", "AID", "AU", "AD", "TI", "AB", "JT", "DP", "VI", "IP", "PG", "MH"),
    c("UI", "DO", "AU", "IN", "TI", "AB", "JN", "YR", "VO", "IP", "PG", "MH", "KW"),
    c("UI", "CN", "DO", "AU", "AE", "TI", "AB", "JN", "YR", "VO", "IP", "PG", "MH", "DJ", "DU", "OD", "KW"),
    c("UT", "PM", "DL", "AU", "EM", "TI", "AB", "SO", "PY", "VL", "IS", "PGN", "ID", "DE"),
    c("PubMed.ID", "Embase.ID", "CTgov.ID", "ICTRP.ID", "DOI", "Author.s.", "ICTRP.ID", "Title", "Abstract", "Source", "Year", "Volume", "Issue", "Pages", "Keywords"),
    c("NCT.Number", "Study.URL", "Sponsor", "Study.Title", "Brief.Summary", "Study.Design", "Conditions", "Interventions", "Primary.Outcome.Measures", "Secondary.Outcome.Measures", "Other.Outcome.Measures", "First.Posted"),
    c("Internal_Number", "TrialID", "web_address", "Contact_Firstname", "Contact_Lastname", "Contact_Email", "Contact_Address", "Scientific_title", "Study_design", "Inclusion_Criteria", "Exclusion_Criteria", "Condition", "Intervention", "Primary_outcome", "Secondary_outcome", "web_address", "Date_registration3")
  )
  names(minimum.column.names) <- import.summary$database
  
  # Import data
  withProgress(message = 'Importing files...', value = 0, {
    # PubMed
    PubMed <- data.frame()
    incProgress(0/7, detail = "Importing PubMed")
    k = 1
    if (import.summary$number.of.files[k] > 0) {
      import.list[[k]][[4]] <- list()
      import.list[[k]][[5]] <- list()
      import.list[[k]][[6]] <- list()
      import.list[[k]][[7]] <- list()
      for (i in 1:import.summary$number.of.files[k]) {
        if(import.list[[k]][[3]][i] == TRUE) {
          import.list[[k]][[4]][[i]] <- read.delim(import.list[[k]][[2]][i], header = FALSE,sep="\n")
          import.list[[k]][[5]][[i]] <- import.pmid(import.list[[k]][[4]][[i]])
          # Now check whether minimum column names are present
          if (!FALSE %in% !is.na (match(minimum.column.names[[k]], 
                                        colnames(import.list[[k]][[5]][[i]])))) {
            import.list[[k]][[6]][[i]] <- "Successfully imported"
            import.list[[k]][[7]][[i]] <- nrow(import.list[[k]][[5]][[i]])
            PubMed <- rbind.missing(PubMed, import.list[[k]][[5]][[i]])
            # remove any duplicates
            PubMed <- PubMed[match(unique(PubMed$PMID), PubMed$PMID),]
          } else {
            import.list[[k]][[6]][[i]] <- "Import not done because of absence of minimum column names"
            import.list[[k]][[7]][[i]] <- 0
          }
        } else {
          import.list[[k]][[6]][[i]] <- "Import not done because the file is absent"
          import.list[[k]][[7]][[i]] <- 0
        }
      }
    }
    incProgress(1/7, detail = "Importing MEDLINE")
    # MEDLINE
    # Import directly
    MEDLINE <- data.frame()
    k = 2
    if (import.summary$number.of.files[k] > 0) {
      import.list[[k]][[4]] <- list()
      import.list[[k]][[5]] <- list()
      import.list[[k]][[6]] <- list()
      import.list[[k]][[7]] <- list()
      for (i in 1:import.summary$number.of.files[k]) {
        if(import.list[[k]][[3]][i] == TRUE) {
          import.list[[k]][[4]][[i]] <- read.csv(import.list[[k]][[2]][i],skip = 1, header = TRUE)
          import.list[[k]][[5]][[i]] <- import.list[[k]][[4]][[i]]
          if (!FALSE %in% !is.na (match(minimum.column.names[[k]], 
                                        colnames(import.list[[k]][[5]][[i]])))) {
            import.list[[k]][[6]][[i]] <- "Successfully imported"
            import.list[[k]][[7]][[i]] <- nrow(import.list[[k]][[5]][[i]])
            MEDLINE <- rbind.missing(MEDLINE, import.list[[k]][[5]][[i]])
            # remove any duplicates
            MEDLINE <- MEDLINE[match(unique(MEDLINE$UI), MEDLINE$UI),]
          } else {
            import.list[[k]][[6]][[i]] <- "Import not done because of absence of minimum column names"
            import.list[[k]][[7]][[i]] <- 0
          }
        } else {
          import.list[[k]][[6]][[i]] <- "Import not done because the file is absent"
          import.list[[k]][[7]][[i]] <- 0
        }
      }
    }
    incProgress(1/7, detail = "Importing EMBASE")
    # EMBASE
    # Import directly
    EMBASE <- data.frame()
    k = 3
    if (import.summary$number.of.files[k] > 0) {
      import.list[[k]][[4]] <- list()
      import.list[[k]][[5]] <- list()
      import.list[[k]][[6]] <- list()
      import.list[[k]][[7]] <- list()
      for (i in 1:import.summary$number.of.files[k]) {
        if(import.list[[k]][[3]][i] == TRUE) {
          import.list[[k]][[4]][[i]] <- read.csv(import.list[[k]][[2]][i],skip = 1, header = TRUE)
          import.list[[k]][[5]][[i]] <- import.embase(import.list[[k]][[4]][[i]])
          if (!FALSE %in% !is.na (match(minimum.column.names[[k]], 
                                        colnames(import.list[[k]][[5]][[i]])))) {
            import.list[[k]][[6]][[i]] <- "Successfully imported"
            import.list[[k]][[7]][[i]] <- nrow(import.list[[k]][[5]][[i]])
            EMBASE <- rbind.missing(EMBASE, import.list[[k]][[5]][[i]])
            # remove any duplicates
            EMBASE <- EMBASE[match(unique(EMBASE$UI), EMBASE$UI),]
          } else {
            import.list[[k]][[6]][[i]] <- "Import not done because of absence of minimum column names"
            import.list[[k]][[7]][[i]] <- 0
          }
        } else {
          import.list[[k]][[6]][[i]] <- "Import not done because the file is absent"
          import.list[[k]][[7]][[i]] <- 0
        }
      }
    }
    incProgress(1/7, detail = "Importing Web of Science")
    # Web of science (conference proceedings)
    WOS <- data.frame()
    k = 4
    if (import.summary$number.of.files[k] > 0) {
      import.list[[k]][[4]] <- list()
      import.list[[k]][[5]] <- list()
      import.list[[k]][[6]] <- list()
      import.list[[k]][[7]] <- list()
      for (i in 1:import.summary$number.of.files[k]) {
        if(import.list[[k]][[3]][i] == TRUE) {
          import.list[[k]][[4]][[i]] <- read.delim(import.list[[k]][[2]][i], header = TRUE)
          import.list[[k]][[5]][[i]] <- import.wos(import.list[[k]][[4]][[i]])
          if (!FALSE %in% !is.na (match(minimum.column.names[[k]], 
                                        colnames(import.list[[k]][[5]][[i]])))) {
            import.list[[k]][[6]][[i]] <- "Successfully imported"
            import.list[[k]][[7]][[i]] <- nrow(import.list[[k]][[5]][[i]])
            WOS <- rbind.missing(WOS, import.list[[k]][[5]][[i]])
            # remove any duplicates
            WOS <- WOS[match(unique(WOS$UT), WOS$UT),]
          } else {
            import.list[[k]][[6]][[i]] <- "Import not done because of absence of minimum column names"
            import.list[[k]][[7]][[i]] <- 0
          }
        } else {
          import.list[[k]][[6]][[i]] <- "Import not done because the file is absent"
          import.list[[k]][[7]][[i]] <- 0
        }
      }
    }
    incProgress(1/7, detail = "Importing Cochrane")
    # Cochrane
    Cochrane <- data.frame()
    k = 5
    if (import.summary$number.of.files[k] > 0) {
      import.list[[k]][[4]] <- list()
      import.list[[k]][[5]] <- list()
      import.list[[k]][[6]] <- list()
      import.list[[k]][[7]] <- list()
      for (i in 1:import.summary$number.of.files[k]) {
        if(import.list[[k]][[3]][i] == TRUE) {
          import.list[[k]][[4]][[i]] <- read.csv(import.list[[k]][[2]][i], header = TRUE)
          import.list[[k]][[5]][[i]] <- import.cochrane(import.list[[k]][[4]][[i]])
          if (!FALSE %in% !is.na (match(minimum.column.names[[k]], 
                                        colnames(import.list[[k]][[5]][[i]])))) {
            import.list[[k]][[6]][[i]] <- "Successfully imported"
            import.list[[k]][[7]][[i]] <- nrow(import.list[[k]][[5]][[i]])
            Cochrane <- rbind.missing(Cochrane, import.list[[k]][[5]][[i]])
            # remove any duplicates
            Cochrane <- Cochrane[match(unique(Cochrane$CENTRAL.ID), Cochrane$CENTRAL.ID),]
          } else {
            import.list[[k]][[6]][[i]] <- "Import not done because of absence of minimum column names"
            import.list[[k]][[7]][[i]] <- 0
          }
        } else {
          import.list[[k]][[6]][[i]] <- "Import not done because the file is absent"
          import.list[[k]][[7]][[i]] <- 0
        }
      }
    }
    incProgress(1/7, detail = "Importing ClinicalTrials.gov")
    # ClinicalTrials.gov
    CTgov <- data.frame()
    k = 6
    if (import.summary$number.of.files[k] > 0) {
      import.list[[k]][[4]] <- list()
      import.list[[k]][[5]] <- list()
      import.list[[k]][[6]] <- list()
      import.list[[k]][[7]] <- list()
      for (i in 1:import.summary$number.of.files[k]) {
        if(import.list[[k]][[3]][i] == TRUE) {
          import.list[[k]][[4]][[i]] <- read.csv(import.list[[k]][[2]][i], header = TRUE)
          import.list[[k]][[5]][[i]] <- import.list[[k]][[4]][[i]]
          if (!FALSE %in% !is.na (match(minimum.column.names[[k]], 
                                        colnames(import.list[[k]][[5]][[i]])))) {
            import.list[[k]][[6]][[i]] <- "Successfully imported"
            import.list[[k]][[7]][[i]] <- nrow(import.list[[k]][[5]][[i]])
            CTgov <- rbind.missing(CTgov, import.list[[k]][[5]][[i]])
            # remove any duplicates
            CTgov <- CTgov[match(unique(CTgov$NCT.Number), CTgov$NCT.Number),]
          } else {
            import.list[[k]][[6]][[i]] <- "Import not done because of absence of minimum column names"
            import.list[[k]][[7]][[i]] <- 0
          }
        } else {
          import.list[[k]][[6]][[i]] <- "Import not done because the file is absent"
          import.list[[k]][[7]][[i]] <- 0
        }
      }
    }
    incProgress(1/7, detail = "Importing WHO ICTRP")
    # WHO ICTRP
    ICTRP <- data.frame()
    k = 7
    if (import.summary$number.of.files[k] > 0) {
      import.list[[k]][[4]] <- list()
      import.list[[k]][[5]] <- list()
      import.list[[k]][[6]] <- list()
      import.list[[k]][[7]] <- list()
      for (i in 1:import.summary$number.of.files[k]) {
        if(import.list[[k]][[3]][i] == TRUE) {
          import.list[[k]][[4]][[i]] <- read.csv(import.list[[k]][[2]][i], quote = "", blank.lines.skip = TRUE)
          import.list[[k]][[5]][[i]] <- import.ictrp(import.list[[k]][[4]][[i]], import.list[[k]][[2]][i])
          if (!FALSE %in% !is.na (match(minimum.column.names[[k]], 
                                        colnames(import.list[[k]][[5]][[i]])))) {
            import.list[[k]][[6]][[i]] <- "Successfully imported"
            import.list[[k]][[7]][[i]] <- nrow(import.list[[k]][[5]][[i]])
            ICTRP <- rbind.missing(ICTRP, import.list[[k]][[5]][[i]])
            # remove any duplicates
            ICTRP <- ICTRP[match(unique(ICTRP$Internal_Number), ICTRP$Internal_Number),]
          } else {
            import.list[[k]][[6]][[i]] <- "Import not done because of absence of minimum column names"
            import.list[[k]][[7]][[i]] <- 0
          }
        } else {
          import.list[[k]][[6]][[i]] <- "Import not done because the file is absent"
          import.list[[k]][[7]][[i]] <- 0
        }
      }
    }
    # Now make a summary of outcome of each file in index file
    import.summary.2 <- data.frame(matrix(nrow=0,ncol=3))
    colnames(import.summary.2) <- c("file.name", "import.status", "references.imported")
    for (k in 1:7) {
      if (import.summary$number.of.files[k] > 0) {
        for (i in 1:length(import.list[[k]][[2]])){
          import.summary.2 <- rbind(import.summary.2,
                                    c(import.list[[k]][[2]][[i]], 
                                      import.list[[k]][[6]][[i]], 
                                      import.list[[k]][[7]][[i]])
          )
        }
      }
    }
    colnames(import.summary.2) <- c("file.name", "import.status", "references.imported")
    import.summary.2$file.name <- str_remove_all(import.summary.2$file.name,
                                                 reference.files.path)
    import.summary <- cbind.missing(import.summary.2, import.summary)
    import.summary$file.names <- str_remove_all(import.summary$file.names,
                                                reference.files.path)
    import.summary$file.exists <- str_remove_all(import.summary$file.exists,
                                                 reference.files.path)
    
    # Write files to folder
    write.csv(import.summary,paste0(index.file.path, "FullDetails/1_Import_Summary.csv"), row.names = FALSE, na = "")
    for (k in 1:7) {
      if (import.summary$file.exists.number[k] > 0)
        eval(parse(text =
                     paste0(
                       "write.csv(", import.summary$database[k], ",",
                       '"' ,index.file.path, "FullDetails/","3_",k,"_", import.summary$database[k],".csv",'"', ",",
                       "row.names = FALSE,",
                       'na = ""',
                       ")"
                     )
        ))
    }
  })
  # Combine the databases and remove duplicates
  withProgress(message = 'Combining files and removing duplicates...', value = 0, {
    references.file.column.names <- c("database", 
                                      "unique.identifier", 
                                      "pmid", "embase.id", "ctgov.id","ictrp.id", "other.trial.identifier",
                                      "url",
                                      "authors", "authors.contact",
                                      "article.title", "article.abstract",
                                      "journal.name",
                                      "article.publication.year",
                                      "article.volume", "article.issue", "article.pages",
                                      "keywords"
    )
    references.file <- data.frame(matrix(nrow = 0, ncol = 18))
    colnames(references.file) <- references.file.column.names
    incProgress(0/7, detail = "PubMed")
    if (nrow(PubMed)>0) {
      temporary.references.file <-  data.frame(cbind(rep("PubMed",nrow(PubMed)), 
                                                     PubMed$PMID,
                                                     PubMed$PMID,
                                                     rep(NA,nrow(PubMed)),
                                                     rep(NA,nrow(PubMed)),
                                                     rep(NA,nrow(PubMed)),
                                                     rep(NA,nrow(PubMed)),
                                                     if(!is.na(match("AID",colnames(PubMed)))){
                                                       PubMed$AID
                                                     } else {
                                                       rep(NA,nrow(PubMed))
                                                     },
                                                     if(!is.na(match("AU",colnames(PubMed)))){
                                                       sapply(PubMed$AU, Author.list.PubMed)
                                                     } else {
                                                       rep(NA,nrow(PubMed))
                                                     },
                                                     if(!is.na(match("AD",colnames(PubMed)))){
                                                       sapply(PubMed$AD, Author.list.PubMed)
                                                     } else {
                                                       rep(NA,nrow(PubMed))
                                                     },
                                                     if(!is.na(match("TI",colnames(PubMed)))){
                                                       PubMed$TI
                                                     } else {
                                                       rep(NA,nrow(PubMed))
                                                     },
                                                     if(!is.na(match("AB",colnames(PubMed)))){
                                                       sapply(PubMed$AB, Abstract.PubMed)
                                                     } else {
                                                       rep(NA,nrow(PubMed))
                                                     },
                                                     if(!is.na(match("JT",colnames(PubMed)))){
                                                       PubMed$JT
                                                     } else {
                                                       rep(NA,nrow(PubMed))
                                                     },
                                                     if(!is.na(match("DP",colnames(PubMed)))){
                                                       substring(PubMed$DP,1,4)
                                                     } else {
                                                       rep(NA,nrow(PubMed))
                                                     },
                                                     if(!is.na(match("VI",colnames(PubMed)))){
                                                       PubMed$VI
                                                     } else {
                                                       rep(NA,nrow(PubMed))
                                                     },
                                                     if(!is.na(match("IP",colnames(PubMed)))){
                                                       PubMed$IP
                                                     } else {
                                                       rep(NA,nrow(PubMed))
                                                     },
                                                     if(!is.na(match("PG",colnames(PubMed)))){
                                                       PubMed$PG
                                                     } else {
                                                       rep(NA,nrow(PubMed))
                                                     },
                                                     if(!is.na(match("MH",colnames(PubMed)))){
                                                       paste0("<strong>MeSH: </strong>",sapply(PubMed$MH, keywords.pubmed))
                                                     } else {
                                                       rep("",nrow(PubMed))
                                                     }
      )
      )
      colnames(temporary.references.file) <- references.file.column.names
      temporary.references.file$pmid[temporary.references.file$pmid == ""] <- NA
      temporary.references.file <- temporary.references.file[
        ((is.na(temporary.references.file$pmid)) | (is.na(match(temporary.references.file$pmid,references.file$pmid)))),
      ]
      if (nrow(temporary.references.file) > 0) {
        references.file <- rbind(references.file, temporary.references.file)
      }
    }
    incProgress(1/7, detail = "MEDLINE")
    if (nrow(MEDLINE)>0) {
      temporary.references.file <- data.frame(cbind(rep("Ovid MEDLINE",nrow(MEDLINE)),
                                                    MEDLINE$UI, 
                                                    MEDLINE$UI, 
                                                    rep(NA,nrow(MEDLINE)),
                                                    rep(NA,nrow(MEDLINE)),
                                                    rep(NA,nrow(MEDLINE)),
                                                    rep(NA,nrow(MEDLINE)),
                                                    MEDLINE$DO,
                                                    sapply(MEDLINE$AU, Author.list.Ovid),
                                                    str_replace_all(MEDLINE$IN, "\n\n","\n"),
                                                    MEDLINE$TI,
                                                    MEDLINE$AB,
                                                    MEDLINE$JN,
                                                    MEDLINE$YR,
                                                    MEDLINE$VO,
                                                    MEDLINE$IP,
                                                    MEDLINE$PG,
                                                    paste0("<strong>MeSH: </strong>",str_replace_all(MEDLINE$MH, "\n\n","; "),"<br>" ,"<strong>Keywords: </strong>",MEDLINE$KW)
      )
      )
      colnames(temporary.references.file) <- references.file.column.names
      temporary.references.file$pmid[temporary.references.file$pmid == ""] <- NA
      temporary.references.file <- temporary.references.file[
        ((is.na(temporary.references.file$pmid)) | (is.na(match(temporary.references.file$pmid,references.file$pmid)))),
      ]
      if (nrow(temporary.references.file) > 0) {
        references.file <- rbind(references.file, temporary.references.file)
      }
    }
    incProgress(1/7, detail = "EMBASE")
    if (nrow(EMBASE)>0) {
      temporary.references.file <- data.frame(cbind(rep("Ovid EMBASE",nrow(EMBASE)),
                                                    EMBASE$UI, 
                                                    trimws(substring(EMBASE$PM,1,(str_locate(EMBASE$PM,"\\[")[,1]-1))), 
                                                    EMBASE$UI,
                                                    rep(NA,nrow(EMBASE)),
                                                    rep(NA,nrow(EMBASE)),
                                                    EMBASE$CN,
                                                    EMBASE$DO,
                                                    sapply(EMBASE$AU, Author.list.Ovid),
                                                    str_replace_all(EMBASE$AE, "\n\n","\n"),
                                                    EMBASE$TI,
                                                    EMBASE$AB,
                                                    EMBASE$JN,
                                                    EMBASE$YR,
                                                    EMBASE$VO,
                                                    EMBASE$IP,
                                                    EMBASE$PG,
                                                    paste0("<strong>Descriptors: </strong>",
                                                           sapply(
                                                             paste0(
                                                               EMBASE$MH, "\n\n",
                                                               EMBASE$DJ, "\n\n",
                                                               EMBASE$DU, "\n\n",
                                                               EMBASE$OD
                                                             ),
                                                             keywords.embase
                                                           ),
                                                           "<br>" ,"<strong>Keywords: </strong>",
                                                           str_replace_all(EMBASE$KW, "\n\n","; ")
                                                    )
      )
      )
      colnames(temporary.references.file) <- references.file.column.names
      temporary.references.file$pmid[temporary.references.file$pmid == ""] <- NA
      temporary.references.file$embase.id[temporary.references.file$embase.id == ""] <- NA
      temporary.references.file <- temporary.references.file[
        ((is.na(temporary.references.file$pmid)) | (is.na(match(temporary.references.file$pmid,references.file$pmid)))),
      ]
      if (nrow(temporary.references.file) > 0) {
        references.file <- rbind(references.file, temporary.references.file)
      }
    }
    incProgress(1/7, detail = "World of Science")
    if (nrow(WOS)>0) {
      temporary.references.file <- data.frame(cbind(rep("Web of Science",nrow(WOS)),
                                                    WOS$UT, 
                                                    WOS$PM, 
                                                    rep(NA,nrow(WOS)),
                                                    rep(NA,nrow(WOS)),
                                                    rep(NA,nrow(WOS)),
                                                    rep(NA,nrow(WOS)),
                                                    WOS$DL,
                                                    sapply(WOS$AU, Author.list.wos),
                                                    WOS$EM,
                                                    WOS$TI,
                                                    WOS$AB,
                                                    str_to_title(WOS$SO),
                                                    WOS$PY,
                                                    WOS$VL,
                                                    WOS$IS,
                                                    WOS$PGN,
                                                    keywords.wos(
                                                      data.frame(cbind(
                                                        WOS$ID,
                                                        WOS$DE
                                                      ))
                                                    )
      )
      )
      colnames(temporary.references.file) <- references.file.column.names
      temporary.references.file$pmid[temporary.references.file$pmid == ""] <- NA
      temporary.references.file <- temporary.references.file[
        ((is.na(temporary.references.file$pmid)) | (is.na(match(temporary.references.file$pmid,references.file$pmid)))),
      ]
      if (nrow(temporary.references.file) > 0) {
        references.file <- rbind(references.file, temporary.references.file)
      }
    }
    # The trial registry entries are better than Cochrane; so first get these entries
    incProgress(1/7, detail = "ClinicalTrials.gov")
    if (nrow(CTgov)>0) {
      temporary.references.file <- data.frame(cbind(rep("ClinicalTrials.gov",nrow(CTgov)),
                                                    CTgov$NCT.Number, 
                                                    rep(NA,nrow(CTgov)),
                                                    rep(NA,nrow(CTgov)),
                                                    CTgov$NCT.Number, 
                                                    rep(NA,nrow(CTgov)),
                                                    rep(NA,nrow(CTgov)),
                                                    CTgov$Study.URL,
                                                    CTgov$Sponsor,
                                                    rep(NA,nrow(CTgov)),
                                                    CTgov$Study.Title,
                                                    CTgov.Summary(
                                                      data.frame(cbind(
                                                        CTgov$Brief.Summary, 
                                                        CTgov$Study.Design, 
                                                        CTgov$Conditions,
                                                        CTgov$Interventions,
                                                        CTgov$Primary.Outcome.Measures,
                                                        CTgov$Secondary.Outcome.Measures,
                                                        CTgov$Other.Outcome.Measures
                                                      ))
                                                    ),
                                                    CTgov$Study.URL,
                                                    substr(CTgov$First.Posted,1,4),
                                                    rep(NA,nrow(CTgov)),
                                                    rep(NA,nrow(CTgov)),
                                                    rep(NA,nrow(CTgov)),
                                                    rep("",nrow(CTgov))
      )
      )
      colnames(temporary.references.file) <- references.file.column.names
      if (nrow(temporary.references.file) > 0) {
        references.file <- rbind(references.file, temporary.references.file)
      }
    }
    incProgress(1/7, detail = "WHO ICTRP")
    if (nrow(ICTRP)>0) {
      temporary.references.file <- data.frame(cbind(rep("ICTRP",nrow(ICTRP)),
                                                    ICTRP$Internal_Number, 
                                                    rep(NA,nrow(ICTRP)),
                                                    rep(NA,nrow(ICTRP)),
                                                    rep(NA,nrow(ICTRP)),
                                                    ICTRP$TrialID, 
                                                    rep(NA,nrow(ICTRP)),
                                                    ICTRP$web_address,
                                                    Author.list.ICTRP(data.frame(cbind(ICTRP$Contact_Firstname, ICTRP$Contact_Lastname))),
                                                    Author.Contact.ICTRP(data.frame(cbind(ICTRP$Contact_Email, ICTRP$Contact_Address))),
                                                    ICTRP$Scientific_title,
                                                    ICTRP.Summary(
                                                      data.frame(cbind(
                                                        ICTRP$Study_design, 
                                                        ICTRP$Inclusion_Criteria, 
                                                        ICTRP$Exclusion_Criteria,
                                                        ICTRP$Condition,
                                                        ICTRP$Intervention,
                                                        ICTRP$Primary_outcome,
                                                        ICTRP$Secondary_outcome
                                                      ))
                                                    ),
                                                    ICTRP$web_address,
                                                    substr(ICTRP$Date_registration3,1,4),
                                                    rep(NA,nrow(ICTRP)),
                                                    rep(NA,nrow(ICTRP)),
                                                    rep(NA,nrow(ICTRP)),
                                                    rep("",nrow(ICTRP))
      )
      )
      colnames(temporary.references.file) <- references.file.column.names
      temporary.references.file <- temporary.references.file[
        ((is.na(temporary.references.file$other.trial.identifier)) | (is.na(match(temporary.references.file$other.trial.identifier,references.file$ctgov.id)))),
      ]
      if (nrow(temporary.references.file) > 0) {
        references.file <- rbind(references.file, temporary.references.file)
      }
    }
    incProgress(1/7, detail = "Cochrane")
    if (nrow(Cochrane)>0) {
      temporary.references.file <- data.frame(cbind(rep("Cochrane Library",nrow(Cochrane)),
                                                    Cochrane$CENTRAL.ID, 
                                                    str_replace_all(Cochrane$PubMed.ID, "PUBMED ",""), 
                                                    str_replace_all(Cochrane$Embase.ID, "EMBASE ",""), 
                                                    str_replace_all(Cochrane$CTgov.ID, "CTgov ",""), 
                                                    str_replace_all(Cochrane$ICTRP.ID, "ICTRP ",""), 
                                                    rep(NA,nrow(Cochrane)),
                                                    Cochrane$DOI,
                                                    sapply(Cochrane$Author.s.,Author.list.wos),
                                                    str_replace_all(Cochrane$ICTRP.ID, "ICTRP ",""), 
                                                    Cochrane$Title,
                                                    Cochrane$Abstract,
                                                    Cochrane$Source,
                                                    Cochrane$Year,
                                                    Cochrane$Volume,
                                                    Cochrane$Issue,
                                                    sapply(Cochrane$Pages, Replace.hyphen),
                                                    Cochrane$Keywords
      )
      )
      colnames(temporary.references.file) <- references.file.column.names
      temporary.references.file$pmid[temporary.references.file$pmid == ""] <- NA
      temporary.references.file$embase.id[temporary.references.file$embase.id == ""] <- NA
      temporary.references.file$ctgov.id[temporary.references.file$ctgov.id == ""] <- NA
      temporary.references.file$ictrp.id[temporary.references.file$ictrp.id == ""] <- NA
      temporary.references.file <- temporary.references.file[
        ((is.na(temporary.references.file$pmid)) | (is.na(match(temporary.references.file$pmid,references.file$pmid)))),
      ]
      temporary.references.file <- temporary.references.file[
        ((is.na(temporary.references.file$embase.id)) | (is.na(match(temporary.references.file$embase.id,references.file$embase.id)))),
      ]
      temporary.references.file <- temporary.references.file[
        ((is.na(temporary.references.file$ctgov.id)) | (is.na(match(temporary.references.file$ctgov.id,references.file$ctgov.id)))),
      ]
      temporary.references.file <- temporary.references.file[
        ((is.na(temporary.references.file$ictrp.id)) | (is.na(match(temporary.references.file$ictrp.id,references.file$ictrp.id)))),
      ]
      
      if (nrow(temporary.references.file) > 0) {
        references.file <- rbind(references.file, temporary.references.file)
      }
    }
    references.file$keywords[references.file$keywords == ""] <- "None" 
    references.file$article.reference <- Create.reference(
      data.frame(cbind(
        references.file$authors,
        references.file$article.title,
        references.file$journal.name,
        references.file$article.publication.year,
        references.file$article.volume,
        references.file$article.issue,
        references.file$article.pages,
        references.file$url
      ))
    )
    
    # Create copy for download without html codes
    references.file.nohtml <- references.file
    references.file.nohtml[,"article.abstract"] <-
      str_remove_all(
        str_remove_all(
          str_replace_all(references.file.nohtml[,"article.abstract"],
                          "<br>",
                          " "),
          "<strong>"
        ), "</strong>"
      )
    references.file.nohtml[,"keywords"] <- 
      str_remove_all(
        str_remove_all(
          str_replace_all(references.file.nohtml[, "keywords"],
                          "<br>",
                          " "),
          "<strong>"
        ), "</strong>"
      )
    write.csv(references.file.nohtml,paste0(index.file.path,"FullDetails/2_Deduplicated_References.csv"), row.names = FALSE, na = "")
    return(list(index.file.path = index.file.path, 
                references.file = references.file
    ))})
}
highlight.keywords <- function(index.file.path, keywords.file.full.name, references.file){
  keywords.file <- read.csv(keywords.file.full.name,header = TRUE)
  if (ncol(keywords.file) == 2){
    keywords.file$weight <- 1
  } else {
    keywords.file$weight[is.na(keywords.file$weight)] <- 1
  }
  # Number of keywords and colours
  withProgress(message = 'Highlighting key words...', value = 0, {
    concept <- keywords.file$concept[!is.na(keywords.file$concept)]
    concept <- unique(concept[concept != ""])
    concept.weight <- keywords.file$weight[match(concept, keywords.file$concept)]
    # Colour codes
    background <- viridis(length(concept))
    # For generating a suitable font colour, the algorithm from https://stackoverflow.com/questions/1855884/determine-font-color-based-on-background-color was used
    # However, this did not account for transparency (alpha); so revised the threshold based on luminance and transparency
    # Convert viridis colour to RGB
    # Alpha is needed last, so rearrange
    font <- paste0("#",substr(background,4,nchar(background)), substr(background,2,3))
    rgb.font <- col2rgb(font, alpha = TRUE)
    colnames(rgb.font) <- font
    rgb.font <- data.frame(t(rgb.font))
    rgb.font$luminance <- (0.299 * rgb.font$red + 0.587 * rgb.font$green + 0.114 * rgb.font$blue)/255
    # convert alpha to be between 0 and 1, one indicating very transparent
    rgb.font$alpha <- rgb.font$alpha/255
    # Get the basic font colour
    rgb.font$colour.1[rgb.font$luminance > 0.5] <- "black"
    rgb.font$colour.1[rgb.font$luminance <= 0.5] <- "white"
    # Get the font colour based on transparency
    rgb.font$colour.2[rgb.font$alpha > 0.5] <- "black"
    rgb.font$colour.2[rgb.font$alpha <= 0.5] <- "white"
    # If there is a match, choose the font colour
    # If there is a mismatch, choose medium colours
    rgb.font$colour[rgb.font$colour.1 == rgb.font$colour.2] <- rgb.font$colour.1[rgb.font$colour.1 == rgb.font$colour.2]
    rgb.font$colour[
      (rgb.font$colour.1 != rgb.font$colour.2) &
        (rgb.font$alpha <= 0.5)
    ] <- "lightcyan"
    rgb.font$colour[
      (rgb.font$colour.1 != rgb.font$colour.2) &
        (rgb.font$alpha > 0.5)
    ] <- "purple"
    font <- rgb.font$colour    
    colour.scheme <- data.frame(cbind(
      concept, concept.weight, background, font
    ))
    keywords.colours <- data.frame(keywords.file$keywords, keywords.file$concept, keywords.file$weight)
    keywords.colours <- keywords.colours[
      (! is.na(keywords.colours[,2])) &
        (keywords.colours[,2] != ""),
    ]
    keywords.colours <- data.frame(cbind(keywords.colours, 
                                         rep(NA,nrow(keywords.colours)),
                                         rep(NA,nrow(keywords.colours))
    ))
    colnames(keywords.colours) <- c("keywords", "concept", "concept.weight", "background", "font")
    for (i in 1:nrow(colour.scheme)) {
      keywords.colours[
        (keywords.colours$concept == colour.scheme$concept[i])
        ,4:5] <- colour.scheme[i,3:4]
    }
    # Three other variations for each keywords.colours: all lower, all upper, title case
    keywords.colours.new <- keywords.colours
    keywords.colours.new <- rbind(
      keywords.colours.new,
      cbind(
        keywords = str_to_lower(keywords.colours$keywords),
        keywords.colours[,2:5]
      )
    )
    keywords.colours.new <- rbind(
      keywords.colours.new,
      cbind(
        keywords = str_to_upper(keywords.colours$keywords),
        keywords.colours[,2:5]
      )
    )
    keywords.colours.new <- rbind(
      keywords.colours.new,
      cbind(
        keywords = str_to_title(keywords.colours$keywords),
        keywords.colours[,2:5]
      )
    )
    # Now remove the duplicates
    keywords.colours.new <- keywords.colours.new[
      match(unique(keywords.colours.new$keywords),keywords.colours.new$keywords)
      ,]
    
    references.file$article.abstract.highlighted <- references.file$article.abstract
    references.file$article.title.highlighted <- references.file$article.title
    references.file$keywords.highlighted <- references.file$keywords
    references.file$concept.times <- 0
    
    for (i in 1:nrow(keywords.colours.new)) {
      references.file$article.abstract.highlighted <- str_replace_all(references.file$article.abstract.highlighted,
                                                                      fixed(keywords.colours.new$keywords[i],ignore_case = FALSE),
                                                                      paste0(
                                                                        '<span style="background-color:', keywords.colours.new$background[i], 
                                                                        ';color:',keywords.colours.new$font[i],'">'
                                                                        , keywords.colours.new$keywords[i],
                                                                        '</span>'
                                                                      )           
      )
      references.file$article.title.highlighted <- str_replace_all(references.file$article.title.highlighted,
                                                                   fixed(keywords.colours.new$keywords[i],ignore_case = FALSE),
                                                                   paste0(
                                                                     '<span style="background-color:', keywords.colours.new$background[i], 
                                                                     ';color:',keywords.colours.new$font[i],'">'
                                                                     , keywords.colours.new$keywords[i],
                                                                     '</span>'
                                                                   )           
      )
      references.file$keywords.highlighted <- str_replace_all(references.file$keywords.highlighted,
                                                              fixed(keywords.colours.new$keywords[i],ignore_case = FALSE),
                                                              paste0(
                                                                '<span style="background-color:', keywords.colours.new$background[i], 
                                                                ';color:',keywords.colours.new$font[i],'">'
                                                                , keywords.colours.new$keywords[i],
                                                                '</span>'
                                                              )           
      )
      references.file$concept.times <- references.file$concept.times + 
        str_count(
          references.file$article.abstract.highlighted,
          keywords.colours.new$keywords[i]
        ) * as.numeric(keywords.colours.new$concept.weight[i]) + 
        str_count(
          references.file$article.title.highlighted,
          keywords.colours.new$keywords[i]
        ) * as.numeric(keywords.colours.new$concept.weight[i]) + 
        str_count(
          references.file$keywords.highlighted,
          keywords.colours.new$keywords[i]
        ) * as.numeric(keywords.colours.new$concept.weight[i])
      incProgress(1/nrow(keywords.colours.new), detail = paste0(i, " of ", nrow(keywords.colours.new)))
    }
    references.file$concepts.present <- ""
    references.file$concepts.present.true <- ""
    references.file$number.of.concepts <- 0
    for (i in 1:nrow(colour.scheme)) {
      references.file$concepts.present <- paste0(
        if (i>1) {
          paste0(references.file$concepts.present, "; ")
        },
        colour.scheme$concept[i], ": ",
        (
          (str_detect(references.file$article.abstract.highlighted, 
                      paste0('<span style=\\"background-color:', colour.scheme$background[i])
          )) |
            (str_detect(references.file$article.title.highlighted, 
                        paste0('<span style=\\"background-color:', colour.scheme$background[i])
            ))|
            (str_detect(references.file$keywords.highlighted, 
                        paste0('<span style=\\"background-color:', colour.scheme$background[i])
            ))
        )
      )
      references.file$concepts.present.true[
        (references.file$concepts.present.true == "") & 
          (
            (str_detect(references.file$article.abstract.highlighted, 
                        paste0('<span style=\\"background-color:', colour.scheme$background[i])
            )) |
              (str_detect(references.file$article.title.highlighted, 
                          paste0('<span style=\\"background-color:', colour.scheme$background[i])
              ))|
              (str_detect(references.file$keywords.highlighted, 
                          paste0('<span style=\\"background-color:', colour.scheme$background[i])
              ))
          )
      ] <- colour.scheme$concept[i]
      references.file$concepts.present.true[
        (references.file$concepts.present.true != "") &
          (! str_detect(
            references.file$concepts.present.true,
            colour.scheme$concept[i]
          )) & 
          (
            (str_detect(references.file$article.abstract.highlighted, 
                        paste0('<span style=\\"background-color:', colour.scheme$background[i])
            )) |
              (str_detect(references.file$article.title.highlighted, 
                          paste0('<span style=\\"background-color:', colour.scheme$background[i])
              ))|
              (str_detect(references.file$keywords.highlighted, 
                          paste0('<span style=\\"background-color:', colour.scheme$background[i])
              ))
          )
      ] <- paste0(
        references.file$concepts.present.true[
          (references.file$concepts.present.true != "") &
            (! str_detect(
              references.file$concepts.present.true,
              colour.scheme$concept[i]
            )) & 
            (
              (str_detect(references.file$article.abstract.highlighted, 
                          paste0('<span style=\\"background-color:', colour.scheme$background[i])
              )) |
                (str_detect(references.file$article.title.highlighted, 
                            paste0('<span style=\\"background-color:', colour.scheme$background[i])
                ))|
                (str_detect(references.file$keywords.highlighted, 
                            paste0('<span style=\\"background-color:', colour.scheme$background[i])
                ))
            )
        ], "; ",
        colour.scheme$concept[i]
      )
    }
    references.file$concepts.present.true[references.file$concepts.present.true == ""] <- "None"
    references.file$number.of.concepts <- str_count(
      references.file$concepts.present,
      "TRUE"
    )
    references.file$concepts.present.true.highlighted <- references.file$concepts.present.true
    references.file$score <- 0
    for (i in 1:nrow(colour.scheme)) {
      references.file$concepts.present.true.highlighted <- str_replace_all(references.file$concepts.present.true.highlighted,
                                                                           fixed(colour.scheme$concept[i],ignore_case = TRUE),
                                                                           paste0(
                                                                             '<span style="background-color:', colour.scheme$background[i], 
                                                                             ';color:',colour.scheme$font[i],'">'
                                                                             , colour.scheme$concept[i],
                                                                             '</span>'
                                                                           )           
      )
      references.file$score[
        str_detect(
          references.file$concepts.present.true,
          colour.scheme$concept[i]
        )
      ] <- references.file$score[
        str_detect(
          references.file$concepts.present.true,
          colour.scheme$concept[i]
        )
      ] + as.numeric(colour.scheme$concept.weight[i])
      
    }
    references.file <- references.file[with(references.file, order(-score, -concept.times)),]
    references.file$order <- 1:nrow(references.file)
    row.names(references.file) <- 1:nrow(references.file)
  })
  write.csv(references.file,paste0(index.file.path,"References_to_Screen/0_Deduplicated_References_ordered.csv"), row.names = FALSE, na = "")
  # Generate reports
  withProgress(message = 'Creating highlighted files...', value = 0, {
    split.references.file <- list()
    for (i in 1:ceiling(nrow(references.file)/100)){
      split.references.file[[i]] <- list()
      if ((nrow(references.file) > ((i-1)*100)) & (nrow(references.file) >= ((i)*100))) {
        split.references.file[[i]][[1]] <- references.file[(((i-1)*100+1):((i-1)*100+100)),]
      } else if ((nrow(references.file) > ((i-1)*100)) & (nrow(references.file) < ((i)*100))) {
        split.references.file[[i]][[1]] <- references.file[(((i-1)*100+1):nrow(references.file)),]
      }
      split.references.file[[i]][[2]] <-  paste0(index.file.path,"References_to_Screen/References_",i,".csv")
      write.csv(split.references.file[[i]][[1]], split.references.file[[i]][[2]][1], row.names = FALSE, na="")
    }
    # Export data to html format (100 rows per file to avoid errors)
    for (i in 1:ceiling(nrow(references.file)/100)){
      suppressMessages({
        suppressWarnings({
          rmarkdown::render("ImportReferencesReportTemplate.Rmd", 
                            output_file = paste0(index.file.path,"References_to_Screen/References_",i,".html"),
                            params = list(file.name = split.references.file[[i]][[2]][1])
          )
          file.remove(split.references.file[[i]][[2]][1])
          incProgress(1/ceiling(nrow(references.file)/100), detail = paste0(i, " of ", ceiling(nrow(references.file)/100)))
        })
      }) 
    }
  })
}

# Functions to create data extraction form ####
split_into_subsections <- function(df) {
  unique_ordered_sub_sections <- paste0(formatC(1:length(unique(df$sub_section)), width = 4, format = "d", flag = "0"), 
                                        '_', 
                                        unique(df$sub_section))
  df$ordered_sub_section <- unique_ordered_sub_sections[
    match(df$sub_section, unique(df$sub_section))
  ]
  df1 <- split.data.frame(
    df, as.factor(df$ordered_sub_section)
  )
  names(df1) <- unique(df$sub_section)
  list(df1,unique_ordered_sub_sections)
}
create_other_characteristics_text <- function(DEF_Design, Template, Customised_Template) {
  create_text_for_row2_each_row <- function(y) {
    if (substr(Customised_Template$other_characteristics$short_name[y],
               (nchar(Customised_Template$other_characteristics$short_name[y])-14),
               (nchar(Customised_Template$other_characteristics$short_name[y]))
    ) == "_intervention_1") {
      DEF_Design$short_names[
        !is.na(match(DEF_Design$variable,
                     substr(Customised_Template$other_characteristics$short_name[y],
                            1,
                            (nchar(Customised_Template$other_characteristics$short_name)-15)
                     )
        ))
      ]
    } else {
      NA
    }
  }
  other_characteristics <- data.frame(
    DEF_Design[
      ! is.na(
        match(DEF_Design$variable,
              substr(Customised_Template$other_characteristics$short_name,
                     1,
                     (nchar(Customised_Template$other_characteristics$short_name)-15)
              )
        )
      ),
    ]
  )
  create_other_characteristics_text_each_row <- function(y) {
    if (other_characteristics$type_1[y] == "number") {
      c(paste0('Enter the number of ',other_characteristics$variable_value[y]),NA)
    } else if (other_characteristics$type_1[y] == "score") {
      c(paste0('Enter the mean ',other_characteristics$variable_value[y]),NA)
    } else {
      c(paste0('Enter: ',other_characteristics$variable_value[y]),NA)    
    }
  }
  create_validity_text_each_row <- function(y) {
    if (other_characteristics$type_1[y] == "number") {
      rep("whole%_%greaterThanOrEqual%_%0",2)
    } else if (other_characteristics$type_1[y] == "score") {
      rep("decimal",2)
    } else {
      rep("",2)    
    }
  }
  list(
    unlist(lapply(1:nrow(Customised_Template$other_characteristics), create_text_for_row2_each_row)),
    unlist(lapply(1:nrow(other_characteristics), create_other_characteristics_text_each_row)),
    unlist(lapply(1:nrow(other_characteristics), create_validity_text_each_row))
  )
}
create_reference <- function(x) {
  authors <- trimws(x[,1])
  authors[is.na(authors)] <- ""
  authors[authors !=""] <- paste0(authors[authors !=""], ". ")
  article.title <- trimws(x[,2])
  article.title[is.na(article.title)] <- ""
  article.title[article.title !=""] <- paste0(article.title[article.title !=""], ". ")
  journal.title <- trimws(x[,3])
  journal.title[is.na(journal.title)] <- ""
  journal.title[journal.title !=""] <- paste0(journal.title[journal.title !=""], ". ")
  publication.year <- trimws(x[,4])
  publication.year[is.na(publication.year)] <- ""
  publication.year[publication.year !=""] <- paste0(publication.year[publication.year !=""], ";")
  volume <- trimws(x[,5])
  volume[is.na(volume)] <- ""
  issue <- trimws(x[,6])
  issue[is.na(issue)] <- ""
  issue[issue !=""] <- paste0("(", issue[issue !=""], ")")
  pages <- trimws(x[,7])
  pages[is.na(pages)] <- ""
  pages[pages == "no pagination"] <- ""
  pages[pages !=""] <- paste0(pages[pages !=""], ". ")
  article.url <- trimws(x[,8])
  article.url[is.na(article.url)] <- ""
  article.url[article.url != ""] <- paste0(article.url[article.url != ""])
  reference <- paste0(
    authors, article.title, journal.title,
    publication.year, volume, issue, ":", 
    pages, article.url,
    "."
  )
  reference = str_replace_all(reference, "\\.\\.","\\.")
  reference = str_replace_all(reference, "\\.\\ \\.","\\.")
  reference = str_replace_all(reference, "\\(\\)","")
  reference = str_replace_all(reference, "\\(\\ \\)","")
  reference = str_replace_all(reference, "\\;\\.",".")
  reference = str_replace_all(reference, "\\;\\:",":")
  reference = str_replace_all(reference, "\\:\\.",".")
  reference = str_replace_all(reference, "\n"," ")
  trimws(reference)
}
create_reference_id <- function(Searches) {
  create_reference_id_step_one <- function(x) {
    x_1 <- Searches$authors[x]
    x_2 <- Searches$article.publication.year[x]
    if (is.na(x_1)) {
      z <- "Anonymous "
    } else {
      if (str_detect(x_1, ",")) {
        y <- substr(x_1, 1,
                    (str_locate(x_1,",")[1]-1)
        )
      } else {
        y <- x_1
      }
      z <- ifelse(str_detect(y, " "),
                  substr(y, 1,
                         (unlist(str_locate_all(y, " "))[
                           length(unlist(str_locate_all(y, " ")))
                         ])
                  ),
                  y)
    }
    z <- paste0(z, x_2)
    return(z)
  }
  name_year <- as.vector(sapply(1:nrow(Searches), create_reference_id_step_one))
  counts <- as.vector(rep(1,length(name_year)))
  cumulative_counts <- as.vector(ave(
    counts,
    name_year,
    FUN = cumsum
  ))
  total_counts <- as.vector(sapply(1:length(name_year), function(x) length(name_year[name_year == name_year[x]])))
  suffix <- rep("",length(name_year))
  suffix[total_counts > 1] <- paste0(' (',cumulative_counts[total_counts > 1], ')')
  reference_id <- paste0(name_year, suffix)
  return(reference_id)  
}
create_dataextraction_form <- function(DEF_Design, StorageFolder, Import_summary, Searches) {
  withProgress(message = 'Creating data extraction form', value = 0, {
    if (missing(Import_summary)) {
      Import_summary <- data.frame(matrix(nrow = 0, ncol = 9))
      colnames(Import_summary) <- c("file.name", "import.status", "references.imported", "database", "file.names", "number.of.files", "file.exists", "file.exists.number", "references.each.database")
      Searches <- data.frame(matrix(nrow = 0, ncol = 21))
      colnames(Searches) <- c("database", "unique.identifier", "pmid", "embase.id", "ctgov.id", "ictrp.id", "other.trial.identifier", "url", "authors", "authors.contact", "article.title", "article.abstract", "journal.name", "article.publication.year", "article.volume", "article.issue", "article.pages", "keywords", "article.reference", "reference.id", "reference")
    }
    # Load the template
    Template <- read.csv("Template.csv", header = TRUE)
    # Process the files
    incProgress(amount = 0.01, detail = "Phase 1: customising the generic template")
    # Somethings need generic modification
    if (! is.na(match("intervention_1", DEF_Design$variable))) {
      Template$row_4_intervention <- str_replace_all(
        Template$row_4_intervention,
        "%_%intervention_1%_%",
        DEF_Design$variable_value[match("intervention_1", DEF_Design$variable)]
      )
      Template[match("outcome_data_additional_favours_intervention_time_to_event",
                     Template$short_name),] <- str_replace_all(
                       Template[match("outcome_data_additional_favours_intervention_time_to_event",
                                      Template$short_name),],
                       "%_%intervention_1%_%",
                       DEF_Design$variable_value[match("intervention_1", DEF_Design$variable)]
                     )
    }
    if (! is.na(match("intervention_2", DEF_Design$variable))) {
      Template$row_4_intervention <- str_replace_all(
        Template$row_4_intervention,
        "%_%intervention_2%_%",
        DEF_Design$variable_value[match("intervention_2", DEF_Design$variable)]
      )
      Template[match("outcome_data_additional_favours_intervention_time_to_event",
                     Template$short_name),] <- str_replace_all(
                       Template[match("outcome_data_additional_favours_intervention_time_to_event",
                                      Template$short_name),],
                       "%_%intervention_2%_%",
                       DEF_Design$variable_value[match("intervention_2", DEF_Design$variable)]
                     )
      
    }
    # Now split the file into subsections
    Customised_Template <- split_into_subsections(Template)[[1]]
    # Things that do not need modification: basic_details, study_inclusion_exclusion, study_author_details, data_extractor_details_comments, recruitment_period
    # Modify the inclusion and exclusion criteria
    # Keep only the rows which are included in the DEF_Design
    Customised_Template$inclusion_exclusion <- Customised_Template$inclusion_exclusion[
      ! is.na(
        match(Customised_Template$inclusion_exclusion$short_name,
              DEF_Design$variable
        )
      )
      ,]
    # Replace the %_%criterion%_% with corresponding text in DEF_Design
    if (nrow(Customised_Template$inclusion_exclusion) > 0) {
      Customised_Template$inclusion_exclusion$row_2_column_name <-
        str_replace_all(
          Customised_Template$inclusion_exclusion$row_2_column_name,
          paste0('%_%criterion_',
                 formatC(1:nrow(Customised_Template$inclusion_exclusion), width = 3, format = "d", flag = "0"), 
                 '%_%'),
          DEF_Design$short_names[match(
            Customised_Template$inclusion_exclusion$short_name,
            DEF_Design$variable
          )]
        )
      Customised_Template$inclusion_exclusion$row_3_details <-
        str_replace_all(
          Customised_Template$inclusion_exclusion$row_3_details,
          paste0('%_%criterion_',
                 formatC(1:nrow(Customised_Template$inclusion_exclusion), width = 3, format = "d", flag = "0"), 
                 '%_%'),
          DEF_Design$variable_value[match(
            Customised_Template$inclusion_exclusion$short_name,
            DEF_Design$variable
          )]
        )  
    }
    # Things that do not need modification: inclusion_exclusion_general, participant_flow_general, progress_plus_place_of_residence_country, progress_plus_place_of_residence_more_details, progress_plus_race, progress_plus_occupation, progress_plus_gender, progress_plus_religion, progress_plus_education, age
    Customised_Template$other_characteristics <- Customised_Template$other_characteristics[
      ! is.na(
        match(
          substr(Customised_Template$other_characteristics$short_name,
                 1,
                 (nchar(Customised_Template$other_characteristics$short_name)-15)
          ),
          DEF_Design$variable
        )
      )
      ,]
    # Replace the %_%characteristics%_% with corresponding text in DEF_Design
    if (nrow(Customised_Template$other_characteristics) > 0) {
      Customised_Template$other_characteristics$row_2_column_name <- create_other_characteristics_text(DEF_Design, Template, Customised_Template)[[1]]
      Customised_Template$other_characteristics$row_3_details <- create_other_characteristics_text(DEF_Design, Template, Customised_Template)[[2]]
      Customised_Template$other_characteristics$validation <- create_other_characteristics_text(DEF_Design, Template, Customised_Template)[[3]]
    }
    Customised_Template$other_characteristics$study_level_intervention_level <- DEF_Design$outcome_better_worse_other_characteristics_study_level_intervention_level[
      match(
        substr(Customised_Template$other_characteristics$short_name,
               1,
               (nchar(Customised_Template$other_characteristics$short_name)-15)
        ),
        DEF_Design$variable
      )
    ]
    Customised_Template$other_characteristics$section[
      Customised_Template$other_characteristics$study_level_intervention_level == "study_level"
    ] <- "participant_characteristics_3"
    Customised_Template$other_characteristics$row_4_intervention[
      Customised_Template$other_characteristics$study_level_intervention_level == "study_level"
    ] <- ""
    Customised_Template$other_characteristics$keep <- ! (  
      (str_detect(Customised_Template$other_characteristics$short_name, "_intervention_2")) & 
        (Customised_Template$other_characteristics$study_level_intervention_level == "study_level")
    )
    Customised_Template$other_characteristics <- Customised_Template$other_characteristics[
      Customised_Template$other_characteristics$keep, 1:9
    ]
    # Things that do not need modification: follow-up
    # For all rob, it is the same scheme: some generic, some ITT, per-protocol, some objective versus subjective and some at outcome level
    # What tools we keep and what we remove depends upon the data extraction plan, otherwise no text revisions are required
    # Per-protocol effect
    if (!is.na(match("per_protocol", DEF_Design$variable))) {
      if(DEF_Design$variable_value[match("per_protocol", DEF_Design$variable)] == "no") {
        Customised_Template$rob2_PP_objective <- Customised_Template$rob2_PP_objective[NULL,]
        Customised_Template$rob2_PP_subjective <- Customised_Template$rob2_PP_subjective[NULL,]
        Customised_Template$rob2_cluster_PP_objective <- Customised_Template$rob2_cluster_PP_objective[NULL,]
        Customised_Template$rob2_cluster_PP_subjective <- Customised_Template$rob2_cluster_PP_subjective[NULL,]
        Customised_Template$rob2_cross_over_PP_objective <- Customised_Template$rob2_cross_over_PP_objective[NULL,]
        Customised_Template$rob2_cross_over_PP_subjective <- Customised_Template$rob2_cross_over_PP_subjective[NULL,]
        Customised_Template$rob2_PP_outcome <- Customised_Template$rob2_PP_outcome[NULL,]
        Customised_Template$rob2_cluster_PP_outcome <- Customised_Template$rob2_cluster_PP_outcome[NULL,]
        Customised_Template$rob2_cross_over_PP_outcome <- Customised_Template$rob2_cross_over_PP_outcome[NULL,]
        Customised_Template$robins_i_PP_most_outcomes <- Customised_Template$robins_i_PP_most_outcomes[NULL,]
        Customised_Template$robins_i_PP_outcome <- Customised_Template$robins_i_PP_outcome[NULL,]
      }
    }
    # Objective outcomes
    if (is.na(match("objective", DEF_Design$objective_subjective))) {
      Customised_Template$rob2_ITT_objective <- Customised_Template$rob2_ITT_objective[NULL,]
      Customised_Template$rob2_PP_objective <- Customised_Template$rob2_PP_objective[NULL,]
      Customised_Template$rob2_objective <- Customised_Template$rob2_objective[NULL,]
      Customised_Template$rob2_cluster_ITT_objective <- Customised_Template$rob2_cluster_ITT_objective[NULL,]
      Customised_Template$rob2_cluster_PP_objective <- Customised_Template$rob2_cluster_PP_objective[NULL,]
      Customised_Template$rob2_cluster_objective <- Customised_Template$rob2_cluster_objective[NULL,]
      Customised_Template$rob2_cross_over_ITT_objective <- Customised_Template$rob2_cross_over_ITT_objective[NULL,]
      Customised_Template$rob2_cross_over_PP_objective <- Customised_Template$rob2_cross_over_PP_objective[NULL,]
      Customised_Template$rob2_cross_over_objective <- Customised_Template$rob2_cross_over_objective[NULL,]
      Customised_Template$robins_i_objective <- Customised_Template$robins_i_objective[NULL,]
    }
    # Subjective outcomes
    if (is.na(match("subjective", DEF_Design$objective_subjective))) {
      Customised_Template$rob2_ITT_subjective <- Customised_Template$rob2_ITT_subjective[NULL,]
      Customised_Template$rob2_PP_subjective <- Customised_Template$rob2_PP_subjective[NULL,]
      Customised_Template$rob2_subjective <- Customised_Template$rob2_subjective[NULL,]
      Customised_Template$rob2_cluster_ITT_subjective <- Customised_Template$rob2_cluster_ITT_subjective[NULL,]
      Customised_Template$rob2_cluster_PP_subjective <- Customised_Template$rob2_cluster_PP_subjective[NULL,]
      Customised_Template$rob2_cluster_subjective <- Customised_Template$rob2_cluster_subjective[NULL,]
      Customised_Template$rob2_cross_over_ITT_subjective <- Customised_Template$rob2_cross_over_ITT_subjective[NULL,]
      Customised_Template$rob2_cross_over_PP_subjective <- Customised_Template$rob2_cross_over_PP_subjective[NULL,]
      Customised_Template$rob2_cross_over_subjective <- Customised_Template$rob2_cross_over_subjective[NULL,]
      Customised_Template$robins_i_subjective <- Customised_Template$robins_i_subjective[NULL,]
    }
    # ROB2 cluster
    if (!is.na(match("cluster", DEF_Design$variable))) {
      if(DEF_Design$variable_value[match("cluster", DEF_Design$variable)] == "no") {
        Customised_Template$rob2_cluster_generic <- Customised_Template$rob2_cluster_generic[NULL,]
        Customised_Template$rob2_cluster_ITT_objective <- Customised_Template$rob2_cluster_ITT_objective[NULL,]
        Customised_Template$rob2_cluster_PP_objective <- Customised_Template$rob2_cluster_PP_objective[NULL,]
        Customised_Template$rob2_cluster_most_outcomes_1 <- Customised_Template$rob2_cluster_most_outcomes_1[NULL,]
        Customised_Template$rob2_cluster_objective <- Customised_Template$rob2_cluster_objective[NULL,]
        Customised_Template$rob2_cluster_most_outcomes_2 <- Customised_Template$rob2_cluster_most_outcomes_2[NULL,]
        Customised_Template$rob2_cluster_ITT_subjective <- Customised_Template$rob2_cluster_ITT_subjective[NULL,]
        Customised_Template$rob2_cluster_PP_subjective <- Customised_Template$rob2_cluster_PP_subjective[NULL,]
        Customised_Template$rob2_cluster_subjective <- Customised_Template$rob2_cluster_subjective[NULL,]
        Customised_Template$rob2_cluster_ITT_outcome <- Customised_Template$rob2_cluster_ITT_outcome[NULL,]
        Customised_Template$rob2_cluster_PP_outcome <- Customised_Template$rob2_cluster_PP_outcome[NULL,]
        Customised_Template$rob2_cluster_outcome <- Customised_Template$rob2_cluster_outcome[NULL,]
      }
    }
    # ROB2 cross-over
    if (!is.na(match("cross_over", DEF_Design$variable))) {
      if(DEF_Design$variable_value[match("cross_over", DEF_Design$variable)] == "no") {
        Customised_Template$rob2_cross_over_generic <- Customised_Template$rob2_cross_over_generic[NULL,]
        Customised_Template$rob2_cross_over_ITT_objective <- Customised_Template$rob2_cross_over_ITT_objective[NULL,]
        Customised_Template$rob2_cross_over_PP_objective <- Customised_Template$rob2_cross_over_PP_objective[NULL,]
        Customised_Template$rob2_cross_over_most_outcomes_1 <- Customised_Template$rob2_cross_over_most_outcomes_1[NULL,]
        Customised_Template$rob2_cross_over_objective <- Customised_Template$rob2_cross_over_objective[NULL,]
        Customised_Template$rob2_cross_over_most_outcomes_2 <- Customised_Template$rob2_cross_over_most_outcomes_2[NULL,]
        Customised_Template$rob2_cross_over_ITT_subjective <- Customised_Template$rob2_cross_over_ITT_subjective[NULL,]
        Customised_Template$rob2_cross_over_PP_subjective <- Customised_Template$rob2_cross_over_PP_subjective[NULL,]
        Customised_Template$rob2_cross_over_subjective <- Customised_Template$rob2_cross_over_subjective[NULL,]
        Customised_Template$rob2_cross_over_ITT_outcome <- Customised_Template$rob2_cross_over_ITT_outcome[NULL,]
        Customised_Template$rob2_cross_over_PP_outcome <- Customised_Template$rob2_cross_over_PP_outcome[NULL,]
        Customised_Template$rob2_cross_over_outcome <- Customised_Template$rob2_cross_over_outcome[NULL,]
      }
    }
    # ROBINS-I
    if (!is.na(match("non_randomised_studies_intervention", DEF_Design$variable))) {
      if(DEF_Design$variable_value[match("non_randomised_studies_intervention", DEF_Design$variable)] == "no") {
        Customised_Template$robins_i_generic <- Customised_Template$robins_i_generic[NULL,]
        Customised_Template$robins_i_ITT_most_outcomes_1 <- Customised_Template$robins_i_ITT_most_outcomes_1[NULL,]
        Customised_Template$robins_i_objective <- Customised_Template$robins_i_objective[NULL,]
        Customised_Template$robins_i_most_outcomes_2 <- Customised_Template$robins_i_most_outcomes_2[NULL,]
        Customised_Template$robins_i_subjective <- Customised_Template$robins_i_subjective[NULL,]
        Customised_Template$robins_i_ITT_outcome <- Customised_Template$robins_i_ITT_outcome[NULL,]
        Customised_Template$robins_i_PP_outcome <- Customised_Template$robins_i_PP_outcome[NULL,]
        Customised_Template$robins_i_outcome <- Customised_Template$robins_i_outcome[NULL,]
      }
    }
    # None of the remaining sections need modifications except outcomes
    if (is.na(match("binary", DEF_Design$type_1))) {
      Customised_Template$outcome_data_for_analysis_1$row_3_details[
        match("outcome_data_1_intervention_1",Customised_Template$outcome_data_for_analysis_1$short_name)
      ] <- 
        str_remove_all(
          Customised_Template$outcome_data_for_analysis_1$row_3_details[
            match("outcome_data_1_intervention_1",Customised_Template$outcome_data_for_analysis_1$short_name)
          ],
          "Binary outcome: Enter the number of people with outcome; "
        )
      Customised_Template$outcome_data_for_analysis_additional_1 <- Customised_Template$outcome_data_for_analysis_additional_1[
        -c(
          match("outcome_data_additional_percentage_binary_intervention_1",Customised_Template$outcome_data_for_analysis_additional_1$short_name),
          match("outcome_data_additional_percentage_binary_intervention_2",Customised_Template$outcome_data_for_analysis_additional_1$short_name)
        )
        ,]
    }
    if (is.na(match("continuous", DEF_Design$type_1))) {
      Customised_Template$outcome_data_for_analysis_1$row_3_details[
        match("outcome_data_1_intervention_1",Customised_Template$outcome_data_for_analysis_1$short_name)
      ] <- 
        str_remove_all(
          Customised_Template$outcome_data_for_analysis_1$row_3_details[
            match("outcome_data_1_intervention_1",Customised_Template$outcome_data_for_analysis_1$short_name)
          ],
          "Continuous outcome: Enter the mean value; "
        )
      Customised_Template$outcome_data_for_analysis_1 <- Customised_Template$outcome_data_for_analysis_1[
        -c(
          match("outcome_data_2_intervention_1",Customised_Template$outcome_data_for_analysis_1$short_name),
          match("outcome_data_2_intervention_2",Customised_Template$outcome_data_for_analysis_1$short_name),
          match("outcome_data_3",Customised_Template$outcome_data_for_analysis_1$short_name)
        )
        ,]
      Customised_Template$outcome_data_for_analysis_additional_1 <- Customised_Template$outcome_data_for_analysis_additional_1[
        -c(
          match("outcome_data_additional_se_continuous_intervention_1",Customised_Template$outcome_data_for_analysis_additional_1$short_name),
          match("outcome_data_additional_se_continuous_intervention_2",Customised_Template$outcome_data_for_analysis_additional_1$short_name),
          match("outcome_data_additional_median_continuous_intervention_1",Customised_Template$outcome_data_for_analysis_additional_1$short_name),
          match("outcome_data_additional_median_continuous_intervention_2",Customised_Template$outcome_data_for_analysis_additional_1$short_name),
          match("outcome_data_additional_lqr_continuous_intervention_1",Customised_Template$outcome_data_for_analysis_additional_1$short_name),
          match("outcome_data_additional_lqr_continuous_intervention_2",Customised_Template$outcome_data_for_analysis_additional_1$short_name),
          match("outcome_data_additional_uqr_continuous_intervention_1",Customised_Template$outcome_data_for_analysis_additional_1$short_name),
          match("outcome_data_additional_uqr_continuous_intervention_2",Customised_Template$outcome_data_for_analysis_additional_1$short_name),
          match("outcome_data_additional_minimum_continuous_intervention_1",Customised_Template$outcome_data_for_analysis_additional_1$short_name),
          match("outcome_data_additional_minimum_continuous_intervention_2",Customised_Template$outcome_data_for_analysis_additional_1$short_name),
          match("outcome_data_additional_maximum_continuous_intervention_1",Customised_Template$outcome_data_for_analysis_additional_1$short_name),
          match("outcome_data_additional_maximum_continuous_intervention_2",Customised_Template$outcome_data_for_analysis_additional_1$short_name)
        )
        ,]
      Customised_Template$outcome_data_for_analysis_additional_2 <- Customised_Template$outcome_data_for_analysis_additional_2[
        -c(
          match("outcome_data_additional_p_value_continuous",Customised_Template$outcome_data_for_analysis_additional_2$short_name)
        )
        ,]
    }
    if (is.na(match("count", DEF_Design$type_1))) {
      Customised_Template$outcome_data_for_analysis_1$row_3_details[
        match("outcome_data_1_intervention_1",Customised_Template$outcome_data_for_analysis_1$short_name)
      ] <- 
        str_remove_all(
          Customised_Template$outcome_data_for_analysis_1$row_3_details[
            match("outcome_data_1_intervention_1",Customised_Template$outcome_data_for_analysis_1$short_name)
          ],
          "Count outcome: Enter the number of events; "
        )
    }
    if (is.na(match("time-to-event", DEF_Design$type_1))) {
      Customised_Template$outcome_data_for_analysis_1$row_3_details[
        match("outcome_data_1_intervention_1",Customised_Template$outcome_data_for_analysis_1$short_name)
      ] <- 
        str_remove_all(
          Customised_Template$outcome_data_for_analysis_1$row_3_details[
            match("outcome_data_1_intervention_1",Customised_Template$outcome_data_for_analysis_1$short_name)
          ],
          "Time-to-event outcome: Leave this empty"
        )
      Customised_Template$outcome_data_for_analysis_additional_2 <- Customised_Template$outcome_data_for_analysis_additional_2[
        -c(
          match("outcome_data_additional_number_of_events_time_to_event",Customised_Template$outcome_data_for_analysis_additional_2$short_name),
          match("outcome_data_additional_favours_intervention_time_to_event",Customised_Template$outcome_data_for_analysis_additional_2$short_name),
          match("outcome_data_additional_p_value_time_to_event",Customised_Template$outcome_data_for_analysis_additional_2$short_name)
        )
        ,]
    } else {
      Customised_Template$outcome_data_for_analysis_additional_2$validation[
        Customised_Template$outcome_data_for_analysis_additional_2$short_name == "outcome_data_additional_favours_intervention_time_to_event"
      ] <- paste0("list%_%",
                  ifelse(
                    match("intervention_1", DEF_Design$variable),
                    DEF_Design$variable_value[match("intervention_1", DEF_Design$variable)],
                    "intervention_1"
                  ),
                  ", ",
                  ifelse(
                    match("intervention_2", DEF_Design$variable),
                    DEF_Design$variable_value[match("intervention_2", DEF_Design$variable)],
                    "intervention_2"
                  )
      )
      
    }
    # Tidy up the column heading
    Customised_Template$outcome_data_for_analysis_1$row_3_details[
      match("outcome_data_1_intervention_1",Customised_Template$outcome_data_for_analysis_1$short_name)
    ] <- trimws(
      Customised_Template$outcome_data_for_analysis_1$row_3_details[
        match("outcome_data_1_intervention_1",Customised_Template$outcome_data_for_analysis_1$short_name)
      ]
    )
    if (substr(
      Customised_Template$outcome_data_for_analysis_1$row_3_details[
        match("outcome_data_1_intervention_1",Customised_Template$outcome_data_for_analysis_1$short_name)
      ],
      nchar(Customised_Template$outcome_data_for_analysis_1$row_3_details[
        match("outcome_data_1_intervention_1",Customised_Template$outcome_data_for_analysis_1$short_name)
      ]),
      nchar(Customised_Template$outcome_data_for_analysis_1$row_3_details[
        match("outcome_data_1_intervention_1",Customised_Template$outcome_data_for_analysis_1$short_name)
      ])
    ) == ";") {
      Customised_Template$outcome_data_for_analysis_1$row_3_details[
        match("outcome_data_1_intervention_1",Customised_Template$outcome_data_for_analysis_1$short_name)
      ] <- 
        substr(
          Customised_Template$outcome_data_for_analysis_1$row_3_details[
            match("outcome_data_1_intervention_1",Customised_Template$outcome_data_for_analysis_1$short_name)
          ],
          1,
          (nchar(Customised_Template$outcome_data_for_analysis_1$row_3_details[
            match("outcome_data_1_intervention_1",Customised_Template$outcome_data_for_analysis_1$short_name)
          ]) - 1)
        )
    }
    Revised_Template <- do.call("rbind", Customised_Template)
    DEF_Text <- t(Revised_Template[, c("row_1_section_name", "row_2_column_name", "row_3_details", "row_4_intervention")])
    # Load DEF_Template and create conditional formatting styles
    incProgress(amount = 0.09, detail = "Phase 1: preparing the data extraction form sheets")
    DEF <- wb_load("DEF_Template.xlsx")
    DEF$add_dxfs_style(
      name = "style_warning", 
      font_color = wb_color(hex = "#FF9C0006"), 
      bg_fill = wb_color(hex = "#FFFFC7CE")
    )
    DEF$add_dxfs_style(
      name = "style_no_warning", 
      font_color = wb_color(hex = "#FF006100"), 
      bg_fill = wb_color(hex = "#FFC6EFCE")
    )
    DEF$add_dxfs_style(
      name = "style_greyed_out", 
      font_color = wb_color(hex = "#FF808080"), 
      bg_fill = wb_color(hex = "#FFF2F2F2")
    )
    
    # Store loaded information
    DEF$add_worksheet(
      "DEF_Design", visible = "false"
    )
    DEF$add_data(
      sheet = "DEF_Design",
      x = DEF_Design,
      col_names = TRUE,
      dims = wb_dims(1, 1),
      na.strings = ""
    )
    DEF$add_worksheet(
      "Revised_Template", visible = "false"
    )
    DEF$add_data(
      sheet = "Revised_Template",
      x = Revised_Template,
      col_names = TRUE,
      dims = wb_dims(1, 1),
      na.strings = ""
    )
    DEF$add_worksheet(
      "Reference_flow", visible = "false"
    )
    # Reference_flow
    Reference_flow <- cbind.data.frame(
      parameter = c("Number of references from database searches",
                    "Number of deduplicated references",
                    "Number of duplicate references not identified by automated removal",
                    "Number of references from other sources",
                    "Number of references screened",
                    "Number of references for which full text was sought",
                    "Number of references included",
                    "Number of studies included",
                    "Number of references of ongoing studies meeting inclusion criteria",
                    "Number of references excluded"
      ),
      numbers = rep(NA,10)
    )
    if ((nrow(Import_summary) >0) & (!is.na(Import_summary[1,1]))) {
      Import_summary$references.each.database <-
        c(
          sapply(
            1:length(Import_summary$database[Import_summary$database !=""]),
            function (x)
              sum(Import_summary$references.imported[
                match(str_split(
                  Import_summary$file.names,
                  "\\|"
                )[[x]], Import_summary$file.name
                )
              ]
              )
          ),
          rep(NA, length(Import_summary$database[Import_summary$database ==""]))
        )
      Searches$reference <- 
        create_reference(
          data.frame(cbind(
            Searches$authors,
            Searches$article.title,
            Searches$journal.name,
            Searches$article.publication.year,
            Searches$article.volume,
            Searches$article.issue,
            Searches$article.pages,
            Searches$url
          ))
        )
      Searches$reference.id <- create_reference_id(Searches)
      Reference_flow$numbers[Reference_flow$parameter == "Number of references from database searches"] <- 
        sum(Import_summary$references.each.database, na.rm = TRUE)
      Reference_flow$numbers[Reference_flow$parameter == "Number of deduplicated references"] <- nrow(Searches)
    }
    DEF$add_data(
      sheet = "Reference_flow",
      x = Import_summary,
      col_names = TRUE,
      dims = wb_dims(1, 1),
      na.strings = ""
    )
    if (nrow(Import_summary) >0) {
      DEF$add_data(
        sheet = "Reference_flow",
        x = cbind.data.frame(
          1:nrow(Searches),
          Searches$reference.id,
          Searches$reference
        ),
        col_names = TRUE,
        dims = wb_dims(1, 10),
        na.strings = ""
      )
      DEF$add_data(
        sheet = "Reference_flow",
        x = Reference_flow,
        col_names = TRUE,
        dims = wb_dims(1, 13),
        na.strings = ""
      )
    }
    DEF$add_formula(
      sheet = "Reference_flow",
      x = c(
        'COUNTIF(Excluded!D:D,"Unidentified duplicate record")',
        'COUNTA(Screening_First!B:B)-1-N3',
        'N3-N4+N5',
        'N6-COUNTIF(Screening_Summary!L:L,"Excluded")',
        'COUNTIF(FullText_Summary!M:M,"Included")',
        '"To calculate on uploading the document"',
        'COUNTIF(Excluded!D:D,"Ongoing study without interim data")',
        'COUNTIF(FullText_Summary!M:M,"Excluded")-N4'
      ),
      dims = wb_dims(4, 14)
    )
    # Instructions
    instructions <- read_xlsx(DEF,"Instructions",start_row = 1, col_names = FALSE, cols = 1)
    DEF$add_data(
      sheet = "Instructions",
      x = paste0(
        (1:length(
          DEF_Design$additional_text[substr(DEF_Design$variable,1,8) ==
                                       'outcome_'
          ]
        ))+(as.numeric(substr(
          instructions[nrow(instructions)-1,],
          1,
          (str_locate(instructions[nrow(instructions)-1,], "\\.")[1]-1)  
        ))),
        '. ',
        DEF_Design$variable_value[substr(DEF_Design$variable,1,8) ==
                                    'outcome_'
        ],
        ': ',
        DEF_Design$additional_text[substr(DEF_Design$variable,1,8) ==
                                     'outcome_'
        ],
        '.'
      ),
      dims = wb_dims((nrow(instructions)+1), 1),
      na.strings = ""
    )
    DEF$add_fill(
      sheet = "Instructions",
      dims = wb_dims(
        2:(nrow(instructions)+length(
          DEF_Design$additional_text[substr(DEF_Design$variable,1,8) ==
                                       'outcome_'
          ]
        )),
        1),
      color =  wb_color(hex = "#FFEFF9EB")
    )
    DEF$add_fill(
      sheet = "Instructions",
      dims = wb_dims(
        1:(nrow(instructions)+length(
          DEF_Design$additional_text[substr(DEF_Design$variable,1,8) ==
                                       'outcome_'
          ]
        )),
        2),
      color =  wb_color(hex = "#FFF2F2F2")
    )
    DEF$add_fill(
      sheet = "Instructions",
      dims = wb_dims(
        ((nrow(instructions)+length(
          DEF_Design$additional_text[substr(DEF_Design$variable,1,8) ==
                                       'outcome_'
          ]
        ))+1),
        1:2),
      color =  wb_color(hex = "#FFF2F2F2")
    )
    DEF$freeze_pane(
      sheet = "Instructions",
      first_active_row = 2,
      first_active_col = 3
    )
    DEF$protect_worksheet(
      sheet = "Instructions",
      protect = TRUE
    )
    # Screening_First
    DEF$add_data(
      sheet = "Screening_First",
      x = 1:(nrow(Searches)+100),
      dims = wb_dims(2,1),
      na.strings = ""
    )
    DEF$add_data(
      sheet = "Screening_First",
      x = cbind.data.frame(
        Searches$reference.id,
        Searches$reference
      ),
      col_names = FALSE,
      dims = wb_dims(2,2),
      na.strings = ""
    )
    DEF$add_data_validation(
      sheet = "Screening_First",
      dims = wb_dims(2:(nrow(Searches)+101),4),
      type = "list",
      value = '"Included,Excluded"',
      error_title = "Error",
      error = "Select from one of 'Included' or 'Excluded'. If doubtful, select 'Included'"
    )
    DEF$add_fill(
      sheet = "Screening_First",
      dims = wb_dims(2:(nrow(Searches)+101),c(1:3)),
      color =  wb_color(hex = "#FFFFFFCC"),
      every_nth_row = 2
    )
    DEF$add_fill(
      sheet = "Screening_First",
      dims = wb_dims(2:(nrow(Searches)+101),4:5),
      color =  wb_color(hex = "#FFFFCCFF"),
      every_nth_row = 2
    )
    DEF$add_fill(
      sheet = "Screening_First",
      dims = wb_dims(1:(nrow(Searches)+102),6),
      color =  wb_color(hex = "#FFF2F2F2")
    )
    DEF$add_fill(
      sheet = "Screening_First",
      dims = wb_dims((nrow(Searches)+102),1:5),
      color =  wb_color(hex = "#FFF2F2F2")
    )
    DEF$freeze_pane(
      sheet = "Screening_First",
      first_active_row = 2,
      first_active_col = 4
    )
    DEF$protect_worksheet(
      sheet = "Screening_First",
      protect = TRUE
    )
    DEF$clone_worksheet(
      old = "Screening_First",
      new = "Screening_Second"
    )
    DEF$add_fill(
      sheet = "Screening_Second",
      dims = wb_dims(2:(nrow(Searches)+101),c(4:5)),
      color =  wb_color(hex = "#FFCAEDFB"),
      every_nth_row = 2
    )
    DEF$worksheets[[match("Screening_Second", DEF$get_sheet_names())]]$sheetPr <- 
      "<sheetPr><tabColor rgb=\"FF002060\"/></sheetPr>"
    # For adding references from other sources
    DEF$add_fill(
      sheet = "Screening_First",
      dims = wb_dims((nrow(Searches)+1):(nrow(Searches)+101),c(2:3)),
      color =  wb_color(hex = "#FFFFCCFF"),
      every_nth_row = 2
    )
    DEF$add_formula(
      sheet = "Screening_Second",
      x= paste0('IF(Screening_First!B', (nrow(Searches)+2):(nrow(Searches)+101),'="","",Screening_First!B', (nrow(Searches)+2):(nrow(Searches)+101),')'),
      dims = wb_dims((nrow(Searches)+2):(nrow(Searches)+101),2)
    )
    DEF$add_formula(
      sheet = "Screening_Second",
      x= paste0('IF(Screening_First!C', (nrow(Searches)+2):(nrow(Searches)+101),'="","",Screening_First!C', (nrow(Searches)+2):(nrow(Searches)+101),')'),
      dims = wb_dims((nrow(Searches)+2):(nrow(Searches)+101),3)
    )
    # Screening_Summary
    DEF$add_data(
      sheet = "Screening_Summary",
      x = 1:(nrow(Searches)+100),
      dims = wb_dims(2,1),
      na.strings = ""
    )
    DEF$add_data(
      sheet = "Screening_Summary",
      x = cbind.data.frame(
        Searches$reference.id,
        Searches$reference
      ),
      col_names = FALSE,
      dims = wb_dims(2,2),
      na.strings = ""
    )
    DEF$add_formula(
      sheet = "Screening_Summary",
      x= paste0('IF(Screening_First!B', (nrow(Searches)+2):(nrow(Searches)+101),'="","",Screening_First!B', (nrow(Searches)+2):(nrow(Searches)+101),')'),
      dims = wb_dims((nrow(Searches)+2):(nrow(Searches)+101),2)
    )
    DEF$add_formula(
      sheet = "Screening_Summary",
      x= paste0('IF(Screening_First!C', (nrow(Searches)+2):(nrow(Searches)+101),'="","",Screening_First!C', (nrow(Searches)+2):(nrow(Searches)+101),')'),
      dims = wb_dims((nrow(Searches)+2):(nrow(Searches)+101),3)
    )
    DEF$add_formula(
      sheet = "Screening_Summary",
      x = paste0('IF(Screening_First!D', 2:(nrow(Searches)+101),'="","",Screening_First!D', 2:(nrow(Searches)+101),')'),
      dims = wb_dims(2:(nrow(Searches)+101),4)
    )
    DEF$add_formula(
      sheet = "Screening_Summary",
      x = paste0('IF(Screening_Second!D', 2:(nrow(Searches)+101),'="","",Screening_Second!D', 2:(nrow(Searches)+101),')'),
      dims = wb_dims(2:(nrow(Searches)+101),5)
    )
    DEF$add_formula(
      sheet = "Screening_Summary",
      x = paste0('IF(AND($D', 2:(nrow(Searches)+101),'="",$E', 2:(nrow(Searches)+101),'=""),"",
             IF(AND($D', 2:(nrow(Searches)+101),'="Included",$E', 2:(nrow(Searches)+101),'="Included"),
             "Yes","No"))'),
      dims = wb_dims(2:(nrow(Searches)+101),6)
    )
    DEF$add_formula(
      sheet = "Screening_Summary",
      x = paste0('IF(AND($D', 2:(nrow(Searches)+101),'="",$E', 2:(nrow(Searches)+101),'=""),"",
             IF(AND($D', 2:(nrow(Searches)+101),'="Excluded",$E', 2:(nrow(Searches)+101),'="Excluded"),
             "Yes","No"))'),
      dims = wb_dims(2:(nrow(Searches)+101),7)
    )
    DEF$add_formula(
      sheet = "Screening_Summary",
      x = paste0('IF(AND($D', 2:(nrow(Searches)+101),'="",$E', 2:(nrow(Searches)+101),'=""),"",
             IF(OR($F', 2:(nrow(Searches)+101),'="Yes",$G', 2:(nrow(Searches)+101),'="Yes"),"No",
             IF($D', 2:(nrow(Searches)+101),'="Included","Yes","No")))'),
      dims = wb_dims(2:(nrow(Searches)+101),8)
    )
    DEF$add_formula(
      sheet = "Screening_Summary",
      x = paste0('IF(AND($D', 2:(nrow(Searches)+101),'="",$E', 2:(nrow(Searches)+101),'=""),"",
             IF(OR($F', 2:(nrow(Searches)+101),'="Yes",$G', 2:(nrow(Searches)+101),'="Yes"),"No",
             IF($E', 2:(nrow(Searches)+101),'="Included","Yes","No")))'),
      dims = wb_dims(2:(nrow(Searches)+101),9)
    )
    DEF$add_formula(
      sheet = "Screening_Summary",
      x = paste0(
        'IF(AND(H', 2:(nrow(Searches)+101),'="", I', 2:(nrow(Searches)+101),'=""),
    "",
    IF(OR(H', 2:(nrow(Searches)+101),'="Yes", I', 2:(nrow(Searches)+101),'="Yes"),
    "Yes","No")
    )'
      ),
      dims = wb_dims(2:(nrow(Searches)+101),10)
    )
    DEF$add_formula(
      sheet = "Screening_Summary",
      x = paste0(
        'IF(F', 2:(nrow(Searches)+101),'="","",',
        '"Reviewer_1: " & ',
        'Screening_First!E', 2:(nrow(Searches)+101),' & char(10) & ',
        '"Reviewer_2: " & ',
        'Screening_Second!E', 2:(nrow(Searches)+101),
        ')'
      ),
      dims = wb_dims(2:(nrow(Searches)+101),11)
    )
    DEF$add_data_validation(
      sheet = "Screening_Summary",
      dims = wb_dims(2:(nrow(Searches)+101),12),
      type = "list",
      value = '"Included,Excluded"',
      error_title = "Error",
      error = "Select from one of 'Included' or 'Excluded'. If doubtful, select 'Included'"
    )
    DEF$add_conditional_formatting(
      sheet = "Screening_Summary",
      dims = wb_dims(2:(nrow(Searches)+101),10),
      rule = "Yes",
      type = "containsText",
      style = "style_warning"
    )
    DEF$add_conditional_formatting(
      sheet = "Screening_Summary",
      dims = wb_dims(2:(nrow(Searches)+101),10),
      rule = "No",
      type = "containsText",
      style = "style_no_warning"
    )
    DEF$add_fill(
      sheet = "Screening_Summary",
      dims = wb_dims(2:(nrow(Searches)+101),c(1:11)),
      color =  wb_color(hex = "#FFFFFFCC"),
      every_nth_row = 2
    )
    DEF$add_fill(
      sheet = "Screening_Summary",
      dims = wb_dims(2:(nrow(Searches)+101),12),
      color =  wb_color(hex = "#FFFFCC66"),
      every_nth_row = 2
    )
    DEF$add_fill(
      sheet = "Screening_Summary",
      dims = wb_dims(1:(nrow(Searches)+102),13),
      color =  wb_color(hex = "#FFF2F2F2")
    )
    DEF$add_fill(
      sheet = "Screening_Summary",
      dims = wb_dims((nrow(Searches)+102),1:12),
      color =  wb_color(hex = "#FFF2F2F2")
    )
    DEF$freeze_pane(
      sheet = "Screening_Summary",
      first_active_row = 2,
      first_active_col = 3
    )
    DEF$protect_worksheet(
      sheet = "Screening_Summary",
      protect = TRUE
    )
    # FullText_First
    DEF$add_data(
      sheet = "FullText_First",
      x = 1:(nrow(Searches)+100),
      dims = wb_dims(2,1),
      na.strings = ""
    )
    DEF$add_data(
      sheet = "FullText_First",
      x = cbind.data.frame(
        Searches$reference.id,
        Searches$reference
      ),
      col_names = FALSE,
      dims = wb_dims(2,2),
      na.strings = ""
    )
    DEF$add_formula(
      sheet = "FullText_First",
      x= paste0('IF(Screening_First!B', (nrow(Searches)+2):(nrow(Searches)+101),'="","",Screening_First!B', (nrow(Searches)+2):(nrow(Searches)+101),')'),
      dims = wb_dims((nrow(Searches)+2):(nrow(Searches)+101),2)
    )
    DEF$add_formula(
      sheet = "FullText_First",
      x= paste0('IF(Screening_First!C', (nrow(Searches)+2):(nrow(Searches)+101),'="","",Screening_First!C', (nrow(Searches)+2):(nrow(Searches)+101),')'),
      dims = wb_dims((nrow(Searches)+2):(nrow(Searches)+101),3)
    )
    DEF$add_formula(
      sheet = "FullText_First",
      x = paste0('IF(Screening_First!D', 2:(nrow(Searches)+101),'="","",Screening_First!D', 2:(nrow(Searches)+101),')'),
      dims = wb_dims(2:(nrow(Searches)+101),4)
    )
    DEF$add_formula(
      sheet = "FullText_First",
      x = paste0('IF(AND(E', 2:(nrow(Searches)+101),'="",D', 2:(nrow(Searches)+101),'=""),"",IF(E', 2:(nrow(Searches)+101),'="",D', 2:(nrow(Searches)+101),',E', 2:(nrow(Searches)+101),'))'),
      dims = wb_dims(2:(nrow(Searches)+101),8)
    )
    DEF$add_data_validation(
      sheet = "FullText_First",
      dims = wb_dims(2:(nrow(Searches)+101),5),
      type = "list",
      value = '"Included,Excluded"',
      error_title = "Error",
      error = "Select from one of 'Included' or 'Excluded'. If doubtful, select 'Included'"
    )
    DEF$add_data_validation(
      sheet = "FullText_First",
      dims = wb_dims(2:(nrow(Searches)+101),6),
      type = "list",
      value = "Exclusion_List",
      error_title = "Error",
      error = "Select from one of the options from the drop-down menu. If the reason is not in the list, please select 'Other reasons' and provide additional details in the relevant column."
    )
    DEF$add_conditional_formatting(
      sheet = "FullText_First",
      dims = wb_dims(2:(nrow(Searches)+101),4),
      rule = "Excluded",
      type = "containsText",
      style = "style_greyed_out"
    )
    DEF$add_fill(
      sheet = "FullText_First",
      dims = wb_dims(2:(nrow(Searches)+101),c(1:8)),
      color =  wb_color(hex = "#FFFFFFCC"),
      every_nth_row = 2
    )
    DEF$add_fill(
      sheet = "FullText_First",
      dims = wb_dims(2:(nrow(Searches)+101),5:7),
      color =  wb_color(hex = "#FFFFCCFF"),
      every_nth_row = 2
    )
    DEF$add_fill(
      sheet = "FullText_First",
      dims = wb_dims(1:(nrow(Searches)+102),9),
      color =  wb_color(hex = "#FFF2F2F2")
    )
    DEF$add_fill(
      sheet = "FullText_First",
      dims = wb_dims((nrow(Searches)+102),1:8),
      color =  wb_color(hex = "#FFF2F2F2")
    )
    DEF$freeze_pane(
      sheet = "FullText_First",
      first_active_row = 2,
      first_active_col = 3
    )
    DEF$protect_worksheet(
      sheet = "FullText_First",
      protect = TRUE
    )
    DEF$clone_worksheet(
      old = "FullText_First",
      new = "FullText_Second"
    )
    DEF$add_formula(
      sheet = "FullText_Second",
      x = paste0('IF(Screening_Second!D', 2:(nrow(Searches)+101),'="","",Screening_Second!D', 2:(nrow(Searches)+101),')'),
      dims = wb_dims(2:(nrow(Searches)+101),4)
    )
    DEF$add_fill(
      sheet = "FullText_Second",
      dims = wb_dims(2:(nrow(Searches)+101),c(5:7)),
      color =  wb_color(hex = "#FFCAEDFB"),
      every_nth_row = 2
    )
    DEF$worksheets[[match("FullText_Second", DEF$get_sheet_names())]]$sheetPr <- 
      "<sheetPr><tabColor rgb=\"FF002060\"/></sheetPr>"
    # FullText_Summary
    DEF$add_data(
      sheet = "FullText_Summary",
      x = 1:(nrow(Searches)+100),
      dims = wb_dims(2,1),
      na.strings = ""
    )
    DEF$add_data(
      sheet = "FullText_Summary",
      x = cbind.data.frame(
        Searches$reference.id,
        Searches$reference
      ),
      col_names = FALSE,
      dims = wb_dims(2,2),
      na.strings = ""
    )
    DEF$add_formula(
      sheet = "FullText_Summary",
      x= paste0('IF(Screening_First!B', (nrow(Searches)+2):(nrow(Searches)+101),'="","",Screening_First!B', (nrow(Searches)+2):(nrow(Searches)+101),')'),
      dims = wb_dims((nrow(Searches)+2):(nrow(Searches)+101),2)
    )
    DEF$add_formula(
      sheet = "FullText_Summary",
      x= paste0('IF(Screening_First!C', (nrow(Searches)+2):(nrow(Searches)+101),'="","",Screening_First!C', (nrow(Searches)+2):(nrow(Searches)+101),')'),
      dims = wb_dims((nrow(Searches)+2):(nrow(Searches)+101),3)
    )
    DEF$add_formula(
      sheet = "FullText_Summary",
      x = paste0('IF(FullText_First!D', 2:(nrow(Searches)+101),'="","",FullText_First!D', 2:(nrow(Searches)+101),')'),
      dims = wb_dims(2:(nrow(Searches)+101),4)
    )
    DEF$add_formula(
      sheet = "FullText_Summary",
      x = paste0('IF(FullText_Second!D', 2:(nrow(Searches)+101),'="","",FullText_Second!D', 2:(nrow(Searches)+101),')'),
      dims = wb_dims(2:(nrow(Searches)+101),5)
    )
    DEF$add_formula(
      sheet = "FullText_Summary",
      x = paste0('IF(AND($D', 2:(nrow(Searches)+101),'="",$E', 2:(nrow(Searches)+101),'=""),"",
             IF(AND($D', 2:(nrow(Searches)+101),'="Included",$E', 2:(nrow(Searches)+101),'="Included"),
             "Yes","No"))'),
      dims = wb_dims(2:(nrow(Searches)+101),6)
    )
    DEF$add_formula(
      sheet = "FullText_Summary",
      x = paste0('IF(AND($D', 2:(nrow(Searches)+101),'="",$E', 2:(nrow(Searches)+101),'=""),"",
             IF(AND($D', 2:(nrow(Searches)+101),'="Excluded",$E', 2:(nrow(Searches)+101),'="Excluded"),
             "Yes","No"))'),
      dims = wb_dims(2:(nrow(Searches)+101),7)
    )
    DEF$add_formula(
      sheet = "FullText_Summary",
      x = paste0('IF(AND($D', 2:(nrow(Searches)+101),'="",$E', 2:(nrow(Searches)+101),'=""),"",
             IF(OR($F', 2:(nrow(Searches)+101),'="Yes",$G', 2:(nrow(Searches)+101),'="Yes"),"No",
             IF($D', 2:(nrow(Searches)+101),'="Included","Yes","No")))'),
      dims = wb_dims(2:(nrow(Searches)+101),8)
    )
    DEF$add_formula(
      sheet = "FullText_Summary",
      x = paste0('IF(AND($D', 2:(nrow(Searches)+101),'="",$E', 2:(nrow(Searches)+101),'=""),"",
             IF(OR($F', 2:(nrow(Searches)+101),'="Yes",$G', 2:(nrow(Searches)+101),'="Yes"),"No",
             IF($E', 2:(nrow(Searches)+101),'="Included","Yes","No")))'),
      dims = wb_dims(2:(nrow(Searches)+101),9)
    )
    DEF$add_formula(
      sheet = "FullText_Summary",
      x = paste0(
        'IF(AND(H', 2:(nrow(Searches)+101),'="", I', 2:(nrow(Searches)+101),'=""),
    "",
    IF(OR(H', 2:(nrow(Searches)+101),'="Yes", I', 2:(nrow(Searches)+101),'="Yes"),
    "Yes","No")
    )'
      ),
      dims = wb_dims(2:(nrow(Searches)+101),10)
    )
    DEF$add_formula(
      sheet = "FullText_Summary",
      x = paste0('IF(J', 2:(nrow(Searches)+101),'="","",
             "Reviewer_1: " & IF(FullText_First!F', 2:(nrow(Searches)+101),'="","",FullText_First!F', 2:(nrow(Searches)+101),') & CHAR(10) & 
             "Reviewer_2: " & IF(FullText_Second!F', 2:(nrow(Searches)+101),'="","",FullText_Second!F', 2:(nrow(Searches)+101),'))'),
      dims = wb_dims(2:(nrow(Searches)+101),11)
    )
    DEF$add_formula(
      sheet = "FullText_Summary",
      x = paste0('IF(J', 2:(nrow(Searches)+101),'="","",
             "Reviewer_1: " & IF(FullText_First!G', 2:(nrow(Searches)+101),'="","",FullText_First!G', 2:(nrow(Searches)+101),') & CHAR(10) & 
             "Reviewer_2: " & IF(FullText_Second!G', 2:(nrow(Searches)+101),'="","",FullText_Second!G', 2:(nrow(Searches)+101),'))'),
      dims = wb_dims(2:(nrow(Searches)+101),12)
    )
    DEF$add_data_validation(
      sheet = "FullText_Summary",
      dims = wb_dims(2:(nrow(Searches)+101),13),
      type = "list",
      value = '"Included,Excluded"',
      error_title = "Error",
      error = "Select from one of 'Included' or 'Excluded'. If doubtful, select 'Included'"
    )
    DEF$add_data_validation(
      sheet = "FullText_Summary",
      dims = wb_dims(2:(nrow(Searches)+101),14),
      type = "list",
      value = "Exclusion_List",
      error_title = "Error",
      error = "Select from one of the options from the drop-down menu. If the reason is not in the list, please select 'Other reasons' and provide additional details in the relevant column."
    )
    DEF$add_fill(
      sheet = "FullText_Summary",
      dims = wb_dims(2:(nrow(Searches)+101),c(1:12)),
      color =  wb_color(hex = "#FFFFFFCC"),
      every_nth_row = 2
    )
    DEF$add_conditional_formatting(
      sheet = "FullText_Summary",
      dims = wb_dims(2:(nrow(Searches)+101),10),
      rule = "Yes",
      type = "containsText",
      style = "style_warning"
    )
    DEF$add_conditional_formatting(
      sheet = "FullText_Summary",
      dims = wb_dims(2:(nrow(Searches)+101),10),
      rule = "No",
      type = "containsText",
      style = "style_no_warning"
    )
    DEF$add_fill(
      sheet = "FullText_Summary",
      dims = wb_dims(2:(nrow(Searches)+101),13:15),
      color =  wb_color(hex = "#FFFFCC66"),
      every_nth_row = 2
    )
    DEF$add_fill(
      sheet = "FullText_Summary",
      dims = wb_dims(1:(nrow(Searches)+102),16),
      color =  wb_color(hex = "#FFF2F2F2")
    )
    DEF$add_fill(
      sheet = "FullText_Summary",
      dims = wb_dims((nrow(Searches)+102),1:15),
      color =  wb_color(hex = "#FFF2F2F2")
    )
    DEF$freeze_pane(
      sheet = "FullText_Summary",
      first_active_row = 2,
      first_active_col = 3
    )
    DEF$protect_worksheet(
      sheet = "FullText_Summary",
      protect = TRUE
    )
    # Data_Extraction_First
    # Most formatting is done with open xlsx - so only the formula, validation and fills are added here
    DEF$add_data(
      sheet = "BehindScenes",
      x = DEF_Design[substr(DEF_Design$variable,1,8) ==
                       'outcome_', c(2,4:6)],
      col_names = FALSE,
      dims = wb_dims(2,4)
    )
    DEF$add_data(
      sheet = "BehindScenes",
      x = DEF_Design[substr(DEF_Design$variable,1,8) ==
                       'outcome_', 7],
      col_names = FALSE,
      dims = wb_dims(2,20)
    )
    DEF$add_formula(
      sheet = "BehindScenes",
      x = paste0('IFERROR(INDEX($C$2:$C$5,MATCH(E', 2:(length(
        DEF_Design$variable_value[substr(DEF_Design$variable,1,8) ==
                                    'outcome_']
      )+1),',$B$2:$B$5,0)),"")'),
      dims = wb_dims(2,8)
    )
    DEF$add_formula(
      sheet = "BehindScenes",
      x = paste0('IF(FullText_First!H', 2:(nrow(Searches)+101),'="","",FullText_First!H', 2:(nrow(Searches)+101),')'),
      dims = wb_dims(2:(nrow(Searches)+101),9)
    )
    DEF$add_formula(
      sheet = "BehindScenes",
      x= paste0('IF(OR(I', 2:(nrow(Searches)+101),'="",I', 2:(nrow(Searches)+101),'="Excluded"),"",MAX(J$1:J', 1:(nrow(Searches)+100),')+1)'),
      dims = wb_dims(2:(nrow(Searches)+101),10)
    )
    DEF$add_formula(
      sheet = "BehindScenes",
      x = rep(
        'IF(ROW()-1 <= MAX($J:$J),
    INDEX(FullText_First!$A:$A, MATCH(ROW()-1, $J:$J,0)) & "." &  INDEX(FullText_First!$B:$B, MATCH(ROW()-1, $J:$J,0)),
    "")',
        nrow(Searches)+100
      ), 
      dims = wb_dims(2:(nrow(Searches)+101),11)
    )
    DEF$add_formula(
      sheet = "BehindScenes",
      x = paste0('IF(FullText_Second!H', 2:(nrow(Searches)+101),'="","",FullText_Second!H', 2:(nrow(Searches)+101),')'),
      dims = wb_dims(2:(nrow(Searches)+101),12)
    )
    DEF$add_formula(
      sheet = "BehindScenes",
      x= paste0('IF(OR(L', 2:(nrow(Searches)+101),'="",L', 2:(nrow(Searches)+101),'="Excluded"),"",MAX(M$1:M', 1:(nrow(Searches)+100),')+1)'),
      dims = wb_dims(2:(nrow(Searches)+101),13)
    )
    DEF$add_formula(
      sheet = "BehindScenes",
      x = rep(
        'IF(ROW()-1 <= MAX($M:$M),
    INDEX(FullText_Second!$A:$A, MATCH(ROW()-1, $M:$M,0)) & "." &  INDEX(FullText_Second!$B:$B, MATCH(ROW()-1, $M:$M,0)),
    "")',
        nrow(Searches)+100
      ), 
      dims = wb_dims(2:(nrow(Searches)+101),14)
    )
    DEF$add_formula(
      sheet = "BehindScenes",
      x = paste0('IF(FullText_Summary!M', 2:(nrow(Searches)+101),'="","",FullText_Summary!M', 2:(nrow(Searches)+101),')'),
      dims = wb_dims(2:(nrow(Searches)+101),15)
    )
    DEF$add_formula(
      sheet = "BehindScenes",
      x = paste0('IF(OR(O', 2:(nrow(Searches)+101),'="",O', 2:(nrow(Searches)+101),'="Included"),"",MAX(P$1:P', 1:(nrow(Searches)+100),')+1)'),
      dims = wb_dims(2:(nrow(Searches)+101),16)
    )
    column_name <- openxlsx2::int2col(match("outcome_name", Revised_Template$short_name))
    DEF$add_formula(
      sheet = "DataExtractionForm_First",
      x = paste0('IF($',column_name, 5:1004,'="","",INDEX(BehindScenes!$F$2:$F$101,MATCH($',column_name, 5:1004,',BehindScenes!$D$2:$D$101,0)))'),
      dims = wb_dims(5:1004,match("outcome_type_2", Revised_Template$short_name)),
    )
    DEF$add_formula(
      sheet = "DataExtractionForm_First",
      x = paste0('IF($',column_name, 5:1004,'="","",INDEX(BehindScenes!$E$2:$E$101,MATCH($',column_name, 5:1004,',BehindScenes!$D$2:$D$101,0)))'),
      dims = wb_dims(5:1004,match("outcome_type_1", Revised_Template$short_name)),
    )
    DEF$add_formula(
      sheet = "DataExtractionForm_First",
      x = paste0('IF($',column_name, 5:1004,'="","",INDEX(BehindScenes!$T$2:$T$101,MATCH($',column_name, 5:1004,',BehindScenes!$D$2:$D$101,0)))'),
      dims = wb_dims(5:1004,match("outcome_better_worse", Revised_Template$short_name)),
    )
    DEF$add_formula(
      sheet = "DataExtractionForm_First",
      x = paste0('IF($',column_name, 5:1004,'="","",INDEX(BehindScenes!$H$2:$H$101,MATCH($',column_name, 5:1004,',BehindScenes!$D$2:$D$101,0)))'),
      dims = wb_dims(5:1004,match("outcome_specific_instruction", Revised_Template$short_name)),
    )
    DEF$add_formula(
      sheet = "DataExtractionForm_First",
      x = paste0('IF(',column_name, 5:1004,'="","",',column_name, 5:1004,')'),
      dims = wb_dims(5:1004,match("outcome_name_display", Revised_Template$short_name)),
    )
    # Now for the rob_outcome_level_message: this refers to objective or subjective
    column_name <- openxlsx2::int2col(match("outcome_type_2", Revised_Template$short_name))
    DEF$add_formula(
      sheet = "DataExtractionForm_First",
      x = paste0('IF(',column_name, 5:1004,'="","",',column_name, 5:1004,')'),
      dims = wb_dims(5:1004,match("rob_outcome_level_message", Revised_Template$short_name)),
    )
    DEF$add_data_validation(
      sheet = "DataExtractionForm_First",
      dims = wb_dims(5:1004,match("Name of the outcome", Revised_Template$row_2_column_name)),
      type = "list",
      value = 'Outcomes',
      error_title = "Error",
      error = "Select from one of the outcomes in the list."
    )
    DEF$add_data_validation(
      sheet = "DataExtractionForm_First",
      dims = wb_dims(5:1004,match("effect_measure_name", Revised_Template$short_name)),
      type = "list",
      value = 'EffectMeasures_List',
      error_title = "Error",
      error = "Select from one of the effect measures in the list."
    )
    # Find the first locations of first row (to start merge)
    # First row
    FirstRow <- Revised_Template$row_1_section_name[!is.na(Revised_Template$row_1_section_name)]
    FirstRow <- data.frame(first_row_text = FirstRow[FirstRow != ""])
    FirstRow$start_column <- match(FirstRow$first_row_text,
                                   Revised_Template$row_1_section_name
    )
    FirstRow$end_column <- c(FirstRow$start_column[2:nrow(FirstRow)]-1, nrow(Revised_Template))
    # Second row
    SecondRow <- data.frame(Revised_Template[
      !is.na(Revised_Template$row_2_column_name) & 
        (Revised_Template$row_2_column_name != "") & 
        (
          !is.na(match(Revised_Template$section,
                       c("participant_characteristics_2", 
                         "rob2","rob2_cluster", "rob2_cross_over","robins_i",
                         "intervention" 
                       )
          )) |
            !is.na(match(Revised_Template$sub_section,
                         c("intervention_participant_flow_each_outcome",
                           "outcome_data_for_analysis_1", "outcome_data_for_analysis_additional_1"
                         )
            ))
        )
      , c("section", "sub_section", "row_2_column_name")])
    colnames(SecondRow) <- c("section", "sub_section", "second_row_text")
    SecondRow <- SecondRow[
      substr(SecondRow$second_row_text, 1, 20) != "Overall risk of bias" 
      ,]
    SecondRow$start_column <- match(
      paste0(SecondRow$sub_section, "%_%", SecondRow$second_row_text),
      paste0(Revised_Template$sub_section, "%_%", Revised_Template$row_2_column_name)
    )
    SecondRow$end_column[
      !is.na(match(SecondRow$section,
                   c("rob2","rob2_cluster", "rob2_cross_over","robins_i")
      ))
    ] <- 
      SecondRow$start_column[
        !is.na(match(SecondRow$section,
                     c("rob2","rob2_cluster", "rob2_cross_over","robins_i")
        ))
      ] + 2
    SecondRow$end_column[
      is.na(SecondRow$end_column)
    ] <- SecondRow$start_column[
      is.na(SecondRow$end_column)
    ] + 1
    DEF$add_formula(
      sheet = "DataExtractionForm_First", 
      x = create_hyperlink(
        sheet = "DataExtractionForm_First",
        row = 1,
        col = FirstRow$start_column,
        text = FirstRow$first_row_text
      ), 
      dims = wb_dims(5,1)
    )
    DEF$add_conditional_formatting(
      sheet = "DataExtractionForm_First",
      dims = wb_dims(5:1004,
                     match("outcome_type_2", Revised_Template$short_name)
      ),
      type = "notContainsBlanks",
      style = "style_greyed_out"
    )
    DEF$add_conditional_formatting(
      sheet = "DataExtractionForm_First",
      dims = wb_dims(5:1004,
                     match("outcome_type_1", Revised_Template$short_name)
      ),
      type = "notContainsBlanks",
      style = "style_greyed_out"
    )
    DEF$add_conditional_formatting(
      sheet = "DataExtractionForm_First",
      dims = wb_dims(5:1004,
                     match("outcome_specific_instruction", Revised_Template$short_name)
      ),
      type = "notContainsBlanks",
      style = "style_greyed_out"
    )
    DEF$add_conditional_formatting(
      sheet = "DataExtractionForm_First",
      dims = wb_dims(5:1004,
                     match("rob_outcome_level_message", Revised_Template$short_name)
      ),
      type = "notContainsBlanks",
      style = "style_greyed_out"
    )
    DEF$add_conditional_formatting(
      sheet = "DataExtractionForm_First",
      dims = wb_dims(5:1004,
                     match("outcome_name_display", Revised_Template$short_name)
      ),
      type = "notContainsBlanks",
      style = "style_greyed_out"
    )
    DEF$add_fill(
      sheet = "DataExtractionForm_First", 
      dims = wb_dims(1,1:FirstRow$end_column[nrow(FirstRow)]),
      color =  wb_color(hex = "#FF51154A")
    )
    DEF$add_fill(
      sheet = "DataExtractionForm_First", 
      dims = wb_dims(2,1:FirstRow$end_column[nrow(FirstRow)]),
      color =  wb_color(hex = "#FF782170")
    )
    DEF$add_fill(
      sheet = "DataExtractionForm_First", 
      dims = wb_dims(3,1:FirstRow$end_column[nrow(FirstRow)]),
      color =  wb_color(hex = "#FFCC00CC")
    )
    DEF$add_fill(
      sheet = "DataExtractionForm_First", 
      dims = wb_dims(4,1:FirstRow$end_column[nrow(FirstRow)]),
      color =  wb_color(hex = "#FFD86DCD")
    )
    DEF$add_fill(
      sheet = "DataExtractionForm_First", 
      dims = wb_dims(5:1004,1:FirstRow$end_column[nrow(FirstRow)]),
      color =  wb_color(hex = "#FFFFCCFF"),
      every_nth_row = 2
    )
    DEF$add_fill(
      sheet = "DataExtractionForm_First",
      dims = wb_dims(1:1005,(FirstRow$end_column[nrow(FirstRow)]+1)),
      color =  wb_color(hex = "#FFF2F2F2")
    )
    DEF$add_fill(
      sheet = "DataExtractionForm_First",
      dims = wb_dims(1005,1:FirstRow$end_column[nrow(FirstRow)]),
      color =  wb_color(hex = "#FFF2F2F2")
    )
    DEF$set_col_widths(
      sheet = "DataExtractionForm_First", 
      cols = (FirstRow$end_column[nrow(FirstRow)]+1),
      widths = 30
    )
    DEF$freeze_pane(
      sheet = "DataExtractionForm_First",
      first_active_row = 5,
      first_active_col = 3
    )
    DEF$protect_worksheet(
      sheet = "DataExtractionForm_First",
      protect = TRUE
    )
    validation_list <- list()
    for (i in 1:nrow(Revised_Template)) {
      if (trimws(Revised_Template$validation[i]) != "") {
        if (
          (trimws(Revised_Template$validation[i]) == "decimal") |
          (trimws(Revised_Template$validation[i]) == "whole")
        ) {
          validation_list[[i]] <- trimws(Revised_Template$validation[i])
          DEF$add_data_validation(
            sheet = "DataExtractionForm_First",
            dims = wb_dims(5:1004,i),
            type = trimws(Revised_Template$validation[i]),
            operator = "between",
            value = c(-100000000000000,100000000000000),
            error_title = "Error",
            error = paste0("This fields allows only a ", trimws(Revised_Template$validation[i]), " number.") 
          )
        } else {
          validation_list[[i]] <- str_split(
            trimws(Revised_Template$validation[i]),
            "%_%"
          )[[1]]
          if (validation_list[[i]][1] == "list"){
            DEF$add_data_validation(
              sheet = "DataExtractionForm_First",
              dims = wb_dims(5:1004,i),
              type = "list",
              value = paste0('"',
                             str_replace_all(validation_list[[i]][2],", ",","),
                             '"'
              ),
              error_title = "Error",
              error = "Select from one of the options from the drop-down menu."
            )
          } else if (
            (validation_list[[i]][1] == "decimal") |
            (validation_list[[i]][1] == "whole")
          ) {
            if (length(validation_list[[i]]) == 3) {
              DEF$add_data_validation(
                sheet = "DataExtractionForm_First",
                dims = wb_dims(5:1004,i),
                type = validation_list[[i]][1],
                operator = validation_list[[i]][2],
                value = validation_list[[i]][3],
                error_title = "Error",
                error = paste0("This fields allows only a ", validation_list[[i]][1], " number ",
                               validation_list[[i]][2], " ", validation_list[[i]][3]
                ) 
              )
            } else if (length(validation_list[[i]]) == 4) {
              DEF$add_data_validation(
                sheet = "DataExtractionForm_First",
                dims = wb_dims(5:1004,i),
                type = validation_list[[i]][1],
                operator = validation_list[[i]][2],
                value = c(validation_list[[i]][3],validation_list[[i]][4]),
                error_title = "Error",
                error = paste0("This fields allows only a ", validation_list[[i]][1], " number ",
                               validation_list[[i]][2], " ", validation_list[[i]][3], " and ",
                               validation_list[[i]][4]
                ) 
              )
            }
          }
        }
      }
    }
    # DataExtractionForm_Second
    DEF$clone_worksheet(
      old = "DataExtractionForm_First",
      new = "DataExtractionForm_Second"
    )
    DEF$worksheets[[match("DataExtractionForm_Second", DEF$get_sheet_names())]]$sheetPr <- 
      "<sheetPr><tabColor rgb=\"FF002060\"/></sheetPr>"
    DEF$add_formula(
      sheet = "DataExtractionForm_Second", 
      x = create_hyperlink(
        sheet = "DataExtractionForm_Second",
        row = 1,
        col = FirstRow$start_column,
        text = FirstRow$first_row_text
      ), 
      dims = wb_dims(5,1)
    )
    DEF$add_data_validation(
      sheet = "DataExtractionForm_First",
      dims = wb_dims(5:1004,match("Record ID", Revised_Template$row_2_column_name)),
      type = "list",
      value = 'Included_First',
      error_title = "Error",
      error = "Select from one of the records in the list. Only records selected as 'Included' in FullText_First will be included in this list."
    )
    DEF$add_data_validation(
      sheet = "DataExtractionForm_Second",
      dims = wb_dims(5:1004,match("Record ID", Revised_Template$row_2_column_name)),
      type = "list",
      value = 'Included_Second',
      error_title = "Error",
      error = "Select from one of the records in the list. Only records selected as 'Included' in FullText_Second will be included in this list."
    )
    DEF$add_fill(
      sheet = "DataExtractionForm_Second", 
      dims = wb_dims(1,1:FirstRow$end_column[nrow(FirstRow)]),
      color =  wb_color(hex = "#FF002060")
    )
    DEF$add_fill(
      sheet = "DataExtractionForm_Second", 
      dims = wb_dims(2,1:FirstRow$end_column[nrow(FirstRow)]),
      color =  wb_color(hex = "#FF215C98")
    )
    DEF$add_fill(
      sheet = "DataExtractionForm_Second", 
      dims = wb_dims(3,1:FirstRow$end_column[nrow(FirstRow)]),
      color =  wb_color(hex = "#FF4D93D9")
    )
    DEF$add_fill(
      sheet = "DataExtractionForm_Second", 
      dims = wb_dims(4,1:FirstRow$end_column[nrow(FirstRow)]),
      color =  wb_color(hex = "#FF61CBF3")
    )
    DEF$add_fill(
      sheet = "DataExtractionForm_Second", 
      dims = wb_dims(5:1004,1:FirstRow$end_column[nrow(FirstRow)]),
      color =  wb_color(hex = "#FFCAEDFB"),
      every_nth_row = 2
    )
    
    # Excluded
    DEF$add_formula(
      sheet = "Excluded",
      x = rep(
        'IF(ROW()-1 <= MAX(BehindScenes!$P:$P),
             INDEX(FullText_Summary!A:A,
             MATCH(ROW()-1, BehindScenes!$P:$P,0)),"")',
        nrow(Searches)+100
      ), 
      dims = wb_dims(2:(nrow(Searches)+101),1)
    )
    DEF$add_formula(
      sheet = "Excluded",
      x = rep(
        'IF(ROW()-1 <= MAX(BehindScenes!$P:$P),
             INDEX(FullText_Summary!B:B,
             MATCH(ROW()-1, BehindScenes!$P:$P,0)),"")',
        nrow(Searches)+100
      ), 
      dims = wb_dims(2:(nrow(Searches)+101),2)
    )
    DEF$add_formula(
      sheet = "Excluded",
      x = rep(
        'IF(ROW()-1 <= MAX(BehindScenes!$P:$P),
             INDEX(FullText_Summary!C:C,
             MATCH(ROW()-1, BehindScenes!$P:$P,0)),"")',
        nrow(Searches)+100
      ),
      dims = wb_dims(2:(nrow(Searches)+101),3)
    )
    DEF$add_formula(
      sheet = "Excluded",
      x= paste0('IF($A', 2:(nrow(Searches)+101),'="","",
            IF(INDEX(FullText_Summary!N:N,
            MATCH($A', 2:(nrow(Searches)+101),',FullText_Summary!$A:$A,0))="","No reason provided",
            INDEX(FullText_Summary!N:N,
            MATCH($A', 2:(nrow(Searches)+101),',FullText_Summary!$A:$A,0))))'),
      dims = wb_dims(2:(nrow(Searches)+101),4)
    )
    DEF$add_formula(
      sheet = "Excluded",
      x= paste0('IF($A', 2:(nrow(Searches)+101),'="","",
            IF(INDEX(FullText_Summary!O:O,
            MATCH($A', 2:(nrow(Searches)+101),',FullText_Summary!$A:$A,0))="","",
            INDEX(FullText_Summary!O:O,
            MATCH($A', 2:(nrow(Searches)+101),',FullText_Summary!$A:$A,0))))'),
      dims = wb_dims(2:(nrow(Searches)+101),5)
    )
    DEF$add_fill(
      sheet = "Excluded",
      dims = wb_dims(2:(nrow(Searches)+101),1:5),
      color =  wb_color(hex = "#FFFFFFCC"),
      every_nth_row = 2
    )
    DEF$add_fill(
      sheet = "Excluded",
      dims = wb_dims(1:(nrow(Searches)+102),6),
      color =  wb_color(hex = "#FFF2F2F2")
    )
    DEF$add_fill(
      sheet = "Excluded",
      dims = wb_dims((nrow(Searches)+102),1:5),
      color =  wb_color(hex = "#FFF2F2F2")
    )
    DEF$freeze_pane(
      sheet = "Excluded",
      first_active_row = 2,
      first_active_col = 3
    )
    DEF$protect_worksheet(
      sheet = "Excluded",
      protect = TRUE
    )
    # Hide Behind Scenes
    DEF$set_sheet_visibility(match("BehindScenes", DEF$get_sheet_names()), "hidden")  
    # Save workbook
    DEF$set_order(
      match(c("Instructions", 
              "Screening_First", "Screening_Second","Screening_Summary",
              "FullText_First", "FullText_Second", "FullText_Summary",
              "DataExtractionForm_First", "DataExtractionForm_Second",
              "Calculators", "Calculations_Co_reviewer",
              "Excluded",
              "BehindScenes", "DEF_Design", "Revised_Template", "Reference_flow"
      ), 
      DEF$get_sheet_names()
      )
    )
    DEF$save(file = paste0(StorageFolder,"/DataExtractionForm.xlsx"), overwrite = TRUE)
    incProgress(amount = 0.2, detail = "Phase 1 complete. Commencing Phase 2, formatting of form: this will take a while!")
    # Format for all sheets other than DataExtractionForm_First and DataExtractionForm_Second
    DEF_2 <- loadWorkbook(paste0(StorageFolder,"/DataExtractionForm.xlsx"))
    addStyle(
      wb = DEF_2,
      sheet = "Instructions",
      style = createStyle(
        wrapText = TRUE
      ),
      rows = 2:(nrow(instructions)+length(
        DEF_Design$additional_text[substr(DEF_Design$variable,1,8) ==
                                     'outcome_'
        ]
      )),
      cols = 1,
      gridExpand = TRUE,
      stack = TRUE
    )
    setRowHeights(
      wb = DEF_2,
      sheet = "Instructions",
      rows =  ((nrow(instructions)+length(
        DEF_Design$additional_text[substr(DEF_Design$variable,1,8) ==
                                     'outcome_'
        ]
      ))+1),
      heights = 400
    )
    addStyle(
      wb = DEF_2,
      sheet = "Screening_First",
      style = createStyle(
        wrapText = TRUE,
        hidden = TRUE
      ),
      rows = 2:(nrow(Searches)+1),
      cols = c(2:3),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "Screening_First",
      style = createStyle(
        wrapText = TRUE,
        locked = FALSE,
        hidden = FALSE
      ),
      rows = (nrow(Searches)+2):(nrow(Searches)+101),
      cols = c(2:3),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "Screening_First",
      style = createStyle(
        locked = FALSE
      ),
      rows = 2:(nrow(Searches)+101),
      cols = c(4:5),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "Screening_Second",
      style = createStyle(
        wrapText = TRUE,
        hidden = TRUE
      ),
      rows = 2:(nrow(Searches)+101),
      cols = c(2:3),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "Screening_Second",
      style = createStyle(
        locked = FALSE
      ),
      rows = 2:(nrow(Searches)+101),
      cols = c(4:5),
      gridExpand = TRUE,
      stack = TRUE
    )
    setRowHeights(
      wb = DEF_2,
      sheet = "Screening_First",
      rows =  (nrow(Searches)+102),
      heights = 400
    )
    setRowHeights(
      wb = DEF_2,
      sheet = "Screening_Second",
      rows =  (nrow(Searches)+102),
      heights = 400
    )
    addStyle(
      wb = DEF_2,
      sheet = "Screening_Summary",
      style = createStyle(
        wrapText = TRUE,
        hidden = TRUE
      ),
      rows = 2:(nrow(Searches)+101),
      cols = 1:11,
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "Screening_Summary",
      style = createStyle(
        locked = FALSE
      ),
      rows = 2:(nrow(Searches)+101),
      cols = 12,
      gridExpand = TRUE,
      stack = TRUE
    )
    setRowHeights(
      wb = DEF_2,
      sheet = "Screening_Summary",
      rows =  (nrow(Searches)+102),
      heights = 400
    )
    addStyle(
      wb = DEF_2,
      sheet = "FullText_First",
      style = createStyle(
        wrapText = TRUE,
        hidden = TRUE
      ),
      rows = 2:(nrow(Searches)+101),
      cols = c(1:4,8),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "FullText_First",
      style = createStyle(
        wrapText = TRUE,
        locked = FALSE
      ),
      rows = 2:(nrow(Searches)+101),
      cols = c(5:7),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "FullText_Second",
      style = createStyle(
        wrapText = TRUE,
        hidden = TRUE
      ),
      rows = 2:(nrow(Searches)+101),
      cols = c(1:4,8),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "FullText_Second",
      style = createStyle(
        wrapText = TRUE,
        locked = FALSE
      ),
      rows = 2:(nrow(Searches)+101),
      cols = c(5:7),
      gridExpand = TRUE,
      stack = TRUE
    )
    setRowHeights(
      wb = DEF_2,
      sheet = "FullText_First",
      rows =  (nrow(Searches)+102),
      heights = 400
    )
    setRowHeights(
      wb = DEF_2,
      sheet = "FullText_Second",
      rows =  (nrow(Searches)+102),
      heights = 400
    )
    addStyle(
      wb = DEF_2,
      sheet = "FullText_Summary",
      style = createStyle(
        wrapText = TRUE,
        hidden = TRUE
      ),
      rows = 2:(nrow(Searches)+101),
      cols = c(1:12),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "FullText_Summary",
      style = createStyle(
        wrapText = TRUE,
        locked = FALSE
      ),
      rows = 2:(nrow(Searches)+101),
      cols = c(13:15),
      gridExpand = TRUE,
      stack = TRUE
    )
    setRowHeights(
      wb = DEF_2,
      sheet = "FullText_Summary",
      rows = 2:(nrow(Searches)+101),
      heights = 57.6
    )
    setRowHeights(
      wb = DEF_2,
      sheet = "FullText_Summary",
      rows =  (nrow(Searches)+102),
      heights = 400
    )
    addStyle(
      wb = DEF_2,
      sheet = "Excluded",
      style = createStyle(
        wrapText = TRUE,
        hidden = TRUE
      ),
      rows = 2:(nrow(Searches)+101),
      cols = c(1:5),
      gridExpand = TRUE,
      stack = TRUE
    )
    setRowHeights(
      wb = DEF_2,
      sheet = "Excluded",
      rows =  (nrow(Searches)+102),
      heights = 400
    )
    # Create borders
    incProgress(amount = 0.1, detail = "Phase 2: Creating borders")
    addStyle(
      wb = DEF_2,
      sheet = "Instructions",
      style = createStyle(
        border = c("top"),
        borderStyle = "thick"
      ),
      rows = c(1,2,(nrow(instructions)+length(
        DEF_Design$additional_text[substr(DEF_Design$variable,1,8) ==
                                     'outcome_'
        ]
      )+1)),
      cols = c(1),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "Instructions",
      style = createStyle(
        border = c("left"),
        borderStyle = "thick"
      ),
      rows = c(1:(nrow(instructions)+length(
        DEF_Design$additional_text[substr(DEF_Design$variable,1,8) ==
                                     'outcome_'
        ]
      ))),
      cols = c(1:2),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "Screening_First",
      style = createStyle(
        border = c("top"),
        borderStyle = "thick"
      ),
      rows = c(1,2,(nrow(Searches)+101+1)),
      cols = c(1:5),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "Screening_First",
      style = createStyle(
        border = c("left"),
        borderStyle = "thick"
      ),
      rows = c(1:(nrow(Searches)+101)),
      cols = c(1,6),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "Screening_Second",
      style = createStyle(
        border = c("top"),
        borderStyle = "thick"
      ),
      rows = c(1,2,(nrow(Searches)+101+1)),
      cols = c(1:5),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "Screening_Second",
      style = createStyle(
        border = c("left"),
        borderStyle = "thick"
      ),
      rows = c(1:(nrow(Searches)+101)),
      cols = c(1,6),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "Screening_Summary",
      style = createStyle(
        border = c("top"),
        borderStyle = "thick"
      ),
      rows = c(1,2,(nrow(Searches)+101+1)),
      cols = c(1:12),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "Screening_Summary",
      style = createStyle(
        border = c("left"),
        borderStyle = "thick"
      ),
      rows = c(1:(nrow(Searches)+101)),
      cols = c(1,13),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "FullText_First",
      style = createStyle(
        border = c("top"),
        borderStyle = "thick"
      ),
      rows = c(1,2,(nrow(Searches)+101+1)),
      cols = c(1:8),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "FullText_First",
      style = createStyle(
        border = c("left"),
        borderStyle = "thick"
      ),
      rows = c(1:(nrow(Searches)+101)),
      cols = c(1,9),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "FullText_Second",
      style = createStyle(
        border = c("top"),
        borderStyle = "thick"
      ),
      rows = c(1,2,(nrow(Searches)+101+1)),
      cols = c(1:8),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "FullText_Second",
      style = createStyle(
        border = c("left"),
        borderStyle = "thick"
      ),
      rows = c(1:(nrow(Searches)+101)),
      cols = c(1,9),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "FullText_Summary",
      style = createStyle(
        border = c("top"),
        borderStyle = "thick"
      ),
      rows = c(1,2,(nrow(Searches)+101+1)),
      cols = c(1:15),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "FullText_Summary",
      style = createStyle(
        border = c("left"),
        borderStyle = "thick"
      ),
      rows = c(1:(nrow(Searches)+101)),
      cols = c(1,16),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "DataExtractionForm_First",
      style = createStyle(
        border = c("left"),
        borderStyle = "thin"
      ),
      rows = c(1:1004),
      c(SecondRow$start_column),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "DataExtractionForm_Second",
      style = createStyle(
        border = c("left"),
        borderStyle = "thin"
      ),
      rows = c(1:1004),
      c(SecondRow$start_column),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "DataExtractionForm_First",
      style = createStyle(
        border = c("top"),
        borderStyle = "thick"
      ),
      rows = c(1,5,(1004+1)),
      cols = c(1:FirstRow$end_column[nrow(FirstRow)]),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "DataExtractionForm_First",
      style = createStyle(
        border = c("left"),
        borderStyle = "thick"
      ),
      rows = c(1:1004),
      c(FirstRow$start_column, (FirstRow$end_column[nrow(FirstRow)]+1)),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "DataExtractionForm_Second",
      style = createStyle(
        border = c("top"),
        borderStyle = "thick"
      ),
      rows = c(1,5,(1004+1)),
      cols = c(1:FirstRow$end_column[nrow(FirstRow)]),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "DataExtractionForm_Second",
      style = createStyle(
        border = c("left"),
        borderStyle = "thick"
      ),
      rows = c(1:1004),
      c(FirstRow$start_column, (FirstRow$end_column[nrow(FirstRow)]+1)),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "Excluded",
      style = createStyle(
        border = c("top"),
        borderStyle = "thick"
      ),
      rows = c(1,2,(nrow(Searches)+101+1)),
      cols = c(1:5),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "Excluded",
      style = createStyle(
        border = c("left"),
        borderStyle = "thick"
      ),
      rows = c(1:(nrow(Searches)+101)),
      cols = c(1,6),
      gridExpand = TRUE,
      stack = TRUE
    )
    # DataExtractionForm_First and DataExtractionForm_Second
    incProgress(amount = 0.2, detail = "Phase 2: Creating headings and merging cells: this will take a while!")
    writeData(
      wb = DEF_2,
      sheet = "DataExtractionForm_First",
      x = DEF_Text,
      startCol = 1,
      startRow = 1,
      colNames = FALSE,
      rowNames = FALSE
    )
    writeData(
      wb = DEF_2,
      sheet = "DataExtractionForm_Second",
      x = DEF_Text,
      startCol = 1,
      startRow = 1,
      colNames = FALSE,
      rowNames = FALSE
    )
    for (i in 1:nrow(FirstRow)) {
      mergeCells(
        DEF_2,
        "DataExtractionForm_First",
        rows = 1:1,
        cols = c(FirstRow$start_column[i], FirstRow$end_column[i])
      )
      mergeCells(
        DEF_2,
        "DataExtractionForm_Second",
        rows = 1:1,
        cols = c(FirstRow$start_column[i], FirstRow$end_column[i])
      )
    }
    for (i in 1:nrow(SecondRow)) {
      mergeCells(
        DEF_2,
        "DataExtractionForm_First",
        rows = 2:2,
        cols = c(SecondRow$start_column[i], SecondRow$end_column[i])
      )
      mergeCells(
        DEF_2,
        "DataExtractionForm_First",
        rows = 3:3,
        cols = c(SecondRow$start_column[i], SecondRow$end_column[i])
      )
      mergeCells(
        DEF_2,
        "DataExtractionForm_Second",
        rows = 2:2,
        cols = c(SecondRow$start_column[i], SecondRow$end_column[i])
      )
      mergeCells(
        DEF_2,
        "DataExtractionForm_Second",
        rows = 3:3,
        cols = c(SecondRow$start_column[i], SecondRow$end_column[i])
      )
    }
    setColWidths(
      wb = DEF_2,
      sheet = "DataExtractionForm_First",
      cols = c(1,2),
      widths = c(50,30),
      hidden = rep(FALSE, 2),
      ignoreMergedCells = FALSE
    )
    setColWidths(
      wb = DEF_2,
      sheet = "DataExtractionForm_Second",
      cols = c(1,2),
      widths = c(50,30),
      hidden = rep(FALSE, 2),
      ignoreMergedCells = FALSE
    )
    options("openxlsx.minWidth" = 14)
    options("openxlsx.maxWidth" = 70)
    setColWidths(
      wb = DEF_2,
      sheet = "DataExtractionForm_First",
      cols = 3:FirstRow$end_column[nrow(FirstRow)],
      widths = "auto",
      hidden = rep(FALSE, length(3:FirstRow$end_column[nrow(FirstRow)])),
      ignoreMergedCells = FALSE
    )
    setColWidths(
      wb = DEF_2,
      sheet = "DataExtractionForm_Second",
      cols = 3:FirstRow$end_column[nrow(FirstRow)],
      widths = "auto",
      hidden = rep(FALSE, length(3:FirstRow$end_column[nrow(FirstRow)])),
      ignoreMergedCells = FALSE
    )
    setRowHeights(
      wb = DEF_2,
      sheet = "DataExtractionForm_First",
      rows = 1,
      heights = 20
    )
    setRowHeights(
      wb = DEF_2,
      sheet = "DataExtractionForm_First",
      rows = 2:3,
      heights = 50
    )
    setRowHeights(
      wb = DEF_2,
      sheet = "DataExtractionForm_Second",
      rows = 1,
      heights = 20
    )
    setRowHeights(
      wb = DEF_2,
      sheet = "DataExtractionForm_Second",
      rows = 2:3,
      heights = 50
    )
    rows3_4_merge = as.vector(1:nrow(Revised_Template))[Revised_Template$row_4_intervention == ""]
    for (i in 1:length(rows3_4_merge)){
      removeCellMerge(
        DEF_2,
        "DataExtractionForm_First",
        rows = 3:4,
        cols = rows3_4_merge[i]
      )
      mergeCells(
        DEF_2,
        "DataExtractionForm_First",
        rows = 3:4,
        cols = rows3_4_merge[i]
      )
      removeCellMerge(
        DEF_2,
        "DataExtractionForm_Second",
        rows = 3:4,
        cols = rows3_4_merge[i]
      )
      mergeCells(
        DEF_2,
        "DataExtractionForm_Second",
        rows = 3:4,
        cols = rows3_4_merge[i]
      )
    }
    rob_widths = as.vector(1:nrow(Revised_Template))[
      Revised_Template$row_4_intervention == "Classification"
    ]
    for (i in 1:length(rob_widths)){
      setColWidths(
        DEF_2,
        "DataExtractionForm_First",
        widths = 30,
        cols = c(rob_widths[i], rob_widths[i]+1,rob_widths[i]+2) 
      )
      setColWidths(
        DEF_2,
        "DataExtractionForm_Second",
        widths = 30,
        cols = c(rob_widths[i], rob_widths[i]+1,rob_widths[i]+2) 
      )
    }
    intervention_widths = as.vector(1:nrow(Revised_Template))[
      Revised_Template$row_4_intervention == DEF_Design$variable_value[match("intervention_1", DEF_Design$variable)]
    ]
    for (i in 1:length(intervention_widths)){
      setColWidths(
        DEF_2,
        "DataExtractionForm_First",
        widths = 50,
        cols = c(intervention_widths[i],intervention_widths[i]+1) 
      )
      setColWidths(
        DEF_2,
        "DataExtractionForm_Second",
        widths = 50,
        cols = c(intervention_widths[i],intervention_widths[i]+1) 
      )
    }
    removeCellMerge(
      DEF_2,
      "DataExtractionForm_First",
      rows = 1:4,
      cols = 1
    )
    mergeCells(
      DEF_2,
      "DataExtractionForm_First",
      rows = 1:4,
      cols = 1
    )
    removeCellMerge(
      DEF_2,
      "DataExtractionForm_First",
      rows = 1:4,
      cols = match("rob_outcome_level_message", Revised_Template$short_name)
    )
    mergeCells(
      DEF_2,
      "DataExtractionForm_First",
      rows = 2:4,
      cols = match("rob_outcome_level_message", Revised_Template$short_name)
    )
    removeCellMerge(
      DEF_2,
      "DataExtractionForm_Second",
      rows = 1:4,
      cols = 1
    )
    mergeCells(
      DEF_2,
      "DataExtractionForm_Second",
      rows = 1:4,
      cols = 1
    )
    removeCellMerge(
      DEF_2,
      "DataExtractionForm_Second",
      rows = 1:4,
      cols = match("rob_outcome_level_message", Revised_Template$short_name)
    )
    mergeCells(
      DEF_2,
      "DataExtractionForm_Second",
      rows = 2:4,
      cols = match("rob_outcome_level_message", Revised_Template$short_name)
    )
    setColWidths(
      DEF_2,
      "DataExtractionForm_First",
      widths = 30,
      cols = match("Record ID", Revised_Template$row_2_column_name) 
    )
    setColWidths(
      DEF_2,
      "DataExtractionForm_Second",
      widths = 30,
      cols = match("Record ID", Revised_Template$row_2_column_name) 
    )
    setColWidths(
      DEF_2,
      "DataExtractionForm_First",
      widths = 65,
      cols = match("outcome_specific_instruction", Revised_Template$short_name) 
    )
    setColWidths(
      DEF_2,
      "DataExtractionForm_Second",
      widths = 65,
      cols = match("outcome_specific_instruction", Revised_Template$short_name) 
    )
    addStyle(
      wb = DEF_2,
      sheet = "DataExtractionForm_First",
      style = createStyle(
        fontSize = 13,
        fontColour = "white",
        textDecoration = "bold",
        wrapText = TRUE,
        hidden = TRUE
      ),
      rows = 1:2,
      cols = c(1:FirstRow$end_column[nrow(FirstRow)]),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "DataExtractionForm_First",
      style = createStyle(
        fontSize = 12,
        fontColour = "white",
        textDecoration = "bold",
        wrapText = TRUE,
        hidden = TRUE
      ),
      rows = 3,
      cols = c(1:FirstRow$end_column[nrow(FirstRow)]),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "DataExtractionForm_First",
      style = createStyle(
        fontSize = 12,
        textDecoration = "bold",
        wrapText = TRUE,
        hidden = TRUE
      ),
      rows = 4,
      cols = c(1:FirstRow$end_column[nrow(FirstRow)]),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "DataExtractionForm_Second",
      style = createStyle(
        fontSize = 13,
        fontColour = "white",
        textDecoration = "bold",
        wrapText = TRUE,
        hidden = TRUE
      ),
      rows = 1:2,
      cols = c(1:FirstRow$end_column[nrow(FirstRow)]),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "DataExtractionForm_Second",
      style = createStyle(
        fontSize = 12,
        fontColour = "white",
        textDecoration = "bold",
        wrapText = TRUE,
        hidden = TRUE
      ),
      rows = 3,
      cols = c(1:FirstRow$end_column[nrow(FirstRow)]),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "DataExtractionForm_Second",
      style = createStyle(
        fontSize = 12,
        textDecoration = "bold",
        wrapText = TRUE,
        hidden = TRUE
      ),
      rows = 4,
      cols = c(1:FirstRow$end_column[nrow(FirstRow)]),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "DataExtractionForm_First",
      style = createStyle(
        wrapText = TRUE
      ),
      rows = 5:(4+nrow(FirstRow)),
      cols = 1,
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "DataExtractionForm_Second",
      style = createStyle(
        wrapText = TRUE
      ),
      rows = 5:(4+nrow(FirstRow)),
      cols = 1,
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "DataExtractionForm_First",
      style = createStyle(
        locked = FALSE
      ),
      rows = 5:1004,
      cols = 2:FirstRow$end_column[nrow(FirstRow)],
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "DataExtractionForm_Second",
      style = createStyle(
        locked = FALSE
      ),
      rows = 5:1004,
      cols = 2:FirstRow$end_column[nrow(FirstRow)],
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "DataExtractionForm_First",
      style = createStyle(
        locked = TRUE,
        hidden = TRUE
      ),
      rows = 5:1004,
      cols = match(c("outcome_type_2","outcome_type_1","outcome_specific_instruction","outcome_name_display", "rob_outcome_level_message"), Revised_Template$short_name),
      gridExpand = TRUE,
      stack = TRUE
    )
    addStyle(
      wb = DEF_2,
      sheet = "DataExtractionForm_Second",
      style = createStyle(
        locked = TRUE,
        hidden = TRUE
      ),
      rows = 5:1004,
      cols = match(c("outcome_type_2","outcome_type_1","outcome_specific_instruction"), Revised_Template$short_name),
      gridExpand = TRUE,
      stack = TRUE
    )
    setRowHeights(
      wb = DEF_2,
      sheet = "DataExtractionForm_First",
      rows =  1005,
      heights = 400
    )
    setRowHeights(
      wb = DEF_2,
      sheet = "DataExtractionForm_Second",
      rows =  1005,
      heights = 400
    )
    # Save
    incProgress(amount = 0.2, detail = "Phase 2: Creating the file for download. This is the final step!")
    protectWorkbook(
      wb = DEF_2,
      protect = TRUE
    )
    saveWorkbook(
      wb = DEF_2,
      file = paste0(StorageFolder,"/DataExtractionForm.xlsx"),
      overwrite = TRUE,
      returnValue = FALSE
    )
    # Return output
    return(DEF_2)
  })
}
# Functions for extracting data from plots ####
# Calculation of lnHR and its SE from KM curve
# Tierney, J.F., Stewart, L.A., Ghersi, D. et al. Practical methods for incorporating summary time-to-event data into meta-analysis. Trials 8, 16 (2007). 
# https://doi.org/10.1186/1745-6215-8-16

create.numeric.inputs.groups <- function(x){
  y <- ""
  for (i in 1:x) {
    y <- paste0(y,
                ifelse(i >1, "; ", ""),
                'output$PlotExtract_KM_Group_Numbers_', i, '_UI<- renderUI(',
                'numericInput("PlotExtract_KM_Group_Numbers_',i,'","Enter the number of participants in group ', i, ': "',
                ', min = 2, value = NA',
                ')',
                ')'
    )
  }
  return(y)
}
remove.numeric.inputs.groups <- function(x){
  y <- ""
  for (i in 1:x) {
    y <- paste0(y,
                ifelse(i >1, "; ", ""),
                'output$PlotExtract_KM_Group_Numbers_', i, '_UI<- NULL'
    )
  }
  return(y)
}
cbind.missing <- function(x) {
  # upto 4 level of lists
  y1 <- list()
  column_names <- vector()
  for (i in 1:length(x)){
    if (is.list(x[[i]])){
      for (j in 1:length(x[[i]])){
        y1[[length(y1)+1]] <- x[[i]][[j]]
      }
      column_names <- c(column_names, names(x[[i]]))
    } else {
      y1[[length(y1)+1]] <- x[[i]]
      column_names <- c(column_names, names(x[i]))
    }
  }
  names(y1) <- column_names
  column_names <- vector()
  y2 <- list()
  for (i in 1:length(y1)){
    if (is.list(y1[[i]])){
      for (j in 1:length(y1[[i]])){
        y2[[length(y2)+1]] <- y1[[i]][[j]]
      }
      column_names <- c(column_names, names(y1[[i]]))
    } else {
      y2[[length(y2)+1]] <- y1[[i]]
      column_names <- c(column_names, names(y1[i]))
    }
  }
  names(y2) <- column_names
  column_names <- vector()
  y3 <- list()
  for (i in 1:length(y2)){
    if (is.list(y2[[i]])){
      for (j in 1:length(y2[[i]])){
        y3[[length(y3)+1]] <- y2[[i]][[j]]
      }
      column_names <- c(column_names, names(y2[[i]]))
    } else {
      y3[[length(y3)+1]] <- y2[[i]]
      column_names <- c(column_names, names(y2[i]))
    }
  }
  names(y3) <- column_names
  column_names <- vector()
  y4 <- list()
  for (i in 1:length(y3)){
    if (is.list(y3[[i]])){
      for (j in 1:length(y3[[i]])){
        y4[[length(y4)+1]] <- y3[[i]][[j]]
      }
      column_names <- c(column_names, names(y3[[i]]))
    } else {
      y4[[length(y4)+1]] <- y3[[i]]
      column_names <- c(column_names, names(y3[i]))
    }
  }
  z <- vector()
  for (i in 1:length(y4)){
    z <- c(z, length(y4[[i]]))
  }
  z <- max(z)
  for (i in 1:length(y4)){
    y4[[i]] <- c(y4[[i]], rep(NA, (z-length(y4[[i]]))))
  }
  y4 <- data.frame(y4)
  colnames(y4) <- column_names
  return(y4)
}
values.to.pixel <- function(
    x_value, 
    x_min_pixel, x_max_pixel,
    x_min_value, x_max_value)
{
  uniroot(function (
    pixel, 
    x_min_pixel, x_max_pixel,
    x_min_value, x_max_value,
    x_value
  ) 
  {(((pixel - x_min_pixel)/(x_max_pixel - x_min_pixel)) * (x_max_value - x_min_value) +
      + x_min_value) - x_value
  }, 
  c(x_min_pixel, x_max_pixel),
  x_value = x_value,
  x_min_pixel = x_min_pixel,
  x_max_pixel = x_max_pixel,
  x_min_value = x_min_value,
  x_max_value = x_max_value
  )$root
}
check.ascending.descending <- function(x) {
  y <- sort(x)
  z <- sort(x, decreasing = TRUE)
  if (identical(x, y)){
    "ascending"
  } else if (identical(x,z)) {
    "descending"
  } else {
    "no order"
  }
}
KM_min_max_analysis.date <- function(x, units) {
  analysis.date = as.Date(x[1])
  first.patient.recruitment = as.Date(x[2])
  last.patient.recruitment = as.Date(x[3])
  y = as.numeric(analysis.date - last.patient.recruitment)
  if (y < 0){
    y <- 0
  }
  z = as.numeric(analysis.date - first.patient.recruitment)
  if (z < 0){
    z <- 0
  }
  if (missing(units)){
    units <- "months"
  }
  if (units == "days") {
    min.follow_up <- y
    max.follow_up <- z
  } else if (units == "months") {
    min.follow_up <- y*12/365
    max.follow_up <- z*12/365
  } else if (units == "years") {
    min.follow_up <- y/365
    max.follow_up <- z/365
  }
  c(min.follow_up,max.follow_up)
}
KM_min_max_submission.date <- function(x, units) {
  submission.date = as.Date(x[1])
  analysis.date = submission.date - 365/2
  first.patient.recruitment = as.Date(x[2])
  last.patient.recruitment = as.Date(x[3])
  y = as.numeric(analysis.date - last.patient.recruitment)
  if (y < 0){
    y <- 0
  }
  z = as.numeric(analysis.date - first.patient.recruitment)
  if (missing(units)){
    units <- "months"
  }
  if (z < 0){
    z <- 0
  }
  if (units == "days") {
    min.follow_up <- y
    max.follow_up <- z
  } else if (units == "months") {
    min.follow_up <- y*12/365
    max.follow_up <- z*12/365
  } else if (units == "years") {
    min.follow_up <- y/365
    max.follow_up <- z/365
  }
  c(min.follow_up,max.follow_up)
}
KM_Table <- function(points_values, groups, KM_TimePoints, percent) {
  # First three rows relate to obtaining the values
  # The last two rows relate to minimum and maximum follow-up, but not if the values are skipped
  if (length(points_values) > (3 + (groups*length(KM_TimePoints)))){
    min.follow_up <- points_values[(length(points_values)-1)]
    max.follow_up <- points_values[length(points_values)]
  } else {
    min.follow_up <- 0
    max.follow_up <- max(KM_TimePoints)
  }
  points_values <- points_values[4:length(points_values)]
  points_values <- points_values[1:(groups*length(KM_TimePoints))]
  if (missing(percent)) {
    percent <- TRUE
  }
  if (percent == FALSE){
    points_values <- points_values * 100
  }
  x <- list()
  for (i in 1:groups) {
    x[[i]] <- points_values[(1:length(KM_TimePoints)) + (i-1)*length(KM_TimePoints)]
    if (check.ascending.descending(x[[i]]) == "ascending"){
      x[[i]] <- 100 - x[[i]]
    }
    x[[i]] <- c(100, x[[i]])
  }
  names(x) <- paste0("event.free.prop.group.",1:groups)
  y <- list(KM_DataTable = x,
            KM_TimePoints = c(0,KM_TimePoints),
            min.follow_up = min.follow_up,
            max.follow_up = max.follow_up)
}
KM_lnHR <- function(KM_DataTable, KM_TimePoints, min.follow_up, max.follow_up, n.participants) {
  KM_Calculations <- list()
  min.Survival_Proportions <- list()
  for (i in 1:(length(KM_DataTable)-1)) {
    KM_Calculations[[i]] <- cbind(
      time = KM_TimePoints, 
      prop.event_free_intervention = KM_DataTable[[i]],
      n.event_free_intervention = rep(NA, length(KM_DataTable[[i]])),
      n.at.risk_intervention = rep(NA, length(KM_DataTable[[i]])),
      n.events_intervention = rep(NA, length(KM_DataTable[[i]])),
      n.censored_intervention = rep(NA, length(KM_DataTable[[i]])),
      prop.event_free_control= KM_DataTable[[length(KM_DataTable)]],
      n.event_free_control = rep(NA, length(KM_DataTable[[length(KM_DataTable)]])),
      n.at.risk_control = rep(NA, length(KM_DataTable[[length(KM_DataTable)]])),
      n.events_control = rep(NA, length(KM_DataTable[[length(KM_DataTable)]])),
      n.censored_control = rep(NA, length(KM_DataTable[[length(KM_DataTable)]])),
      ln.hr.t= rep(NA, length(KM_DataTable[[length(KM_DataTable)]])),
      inverse.v.t = rep(NA, length(KM_DataTable[[length(KM_DataTable)]])),
      o_e.t = rep(NA, length(KM_DataTable[[length(KM_DataTable)]])),
      v.t = rep(NA, length(KM_DataTable[[length(KM_DataTable)]]))
    )
    if (
      (length(KM_TimePoints) == length(KM_DataTable[[i]])) &
      (length(KM_DataTable[[i]]) == length(KM_DataTable[[1]]))
    ){
      if ((check.ascending.descending(KM_Calculations[[i]][,1]) == "ascending") &
          (check.ascending.descending(KM_Calculations[[i]][,2]) == "descending") & 
          (check.ascending.descending(KM_Calculations[[i]][,7]) == "descending")
      ) {
        KM_File <- data.frame(KM_Calculations[[i]])
        min.Survival_Proportions[[i]] <- c(min(KM_DataTable[[i]]), min(KM_DataTable[[length(KM_DataTable)]]))
        for (j in 1:nrow(KM_File)) {
          if (j == 1) {
            KM_File$n.event_free_intervention[j] <- n.participants[i]
            KM_File$n.at.risk_intervention[j] <- KM_File$n.event_free_intervention[j]
            KM_File$n.events_intervention[j] <- ifelse(
              (
                (KM_File$prop.event_free_intervention[j] == KM_File$prop.event_free_intervention[(j+1)]) | 
                  (KM_File$prop.event_free_intervention[j] == min.Survival_Proportions[[i]][1])
              ), 0.000001, 
              KM_File$n.at.risk_intervention[j] * 
                ((KM_File$prop.event_free_intervention[j] - KM_File$prop.event_free_intervention[(j+1)])/KM_File$prop.event_free_intervention[j])
            )
            KM_File$n.censored_intervention[j] <- 0
            KM_File$n.event_free_control[j] <- n.participants[length(n.participants)]
            KM_File$n.at.risk_control[j] <- KM_File$n.event_free_control[j]
            KM_File$n.events_control[j] <- ifelse(
              (
                (KM_File$prop.event_free_control[j] == KM_File$prop.event_free_control[(j+1)]) | 
                  (KM_File$prop.event_free_control[j] == min.Survival_Proportions[[i]][2])
              ), 0.000001, 
              KM_File$n.at.risk_control[j] * 
                ((KM_File$prop.event_free_control[j] - KM_File$prop.event_free_control[(j+1)])/KM_File$prop.event_free_control[j])
            )
            KM_File$n.censored_control[j] <- 0
          } else if (j == nrow(KM_File)){
            KM_File$n.event_free_intervention[j] <- KM_File$n.event_free_intervention[(j-1)] - KM_File$n.events_intervention[(j-1)] - KM_File$n.censored_intervention[(j-1)]
            KM_File$n.at.risk_intervention[j] <- KM_File$n.event_free_intervention[j]
            KM_File$n.events_intervention[j] <- 0.000001
            KM_File$n.censored_intervention[j] <- 0
            KM_File$n.event_free_control[j] <- KM_File$n.event_free_control[(j-1)] - KM_File$n.events_control[(j-1)] - KM_File$n.censored_control[(j-1)]
            KM_File$n.at.risk_control[j] <- KM_File$n.event_free_control[j]
            KM_File$n.events_control[j] <- 0.000001
            KM_File$n.censored_control[j] <- 0
          } else {
            KM_File$n.event_free_intervention[j] <- KM_File$n.event_free_intervention[(j-1)] - KM_File$n.events_intervention[(j-1)] - KM_File$n.censored_intervention[(j-1)]
            KM_File$n.censored_intervention[j] <- ifelse(
              (
                ((KM_File$time[j] < min.follow_up) | (KM_File$time[j] >= max.follow_up)) |
                  ((KM_File$prop.event_free_intervention[j] == min.Survival_Proportions[[i]][1]) & (KM_File$prop.event_free_control[j] == min.Survival_Proportions[[i]][2]))  
              ), 
              0,
              KM_File$n.event_free_intervention[j] * 0.5 * (KM_File$time[j+1] - KM_File$time[j]) * 
                (1/(max.follow_up - KM_File$time[j]))
            )
            KM_File$n.at.risk_intervention[j] <- KM_File$n.event_free_intervention[j] - KM_File$n.censored_intervention[j]
            KM_File$n.events_intervention[j] <- ifelse(
              (
                (KM_File$prop.event_free_intervention[j] == KM_File$prop.event_free_intervention[(j+1)]) | 
                  (KM_File$prop.event_free_intervention[j] == min.Survival_Proportions[[i]][1])
              ), 0.000001, 
              KM_File$n.at.risk_intervention[j] * 
                ((KM_File$prop.event_free_intervention[j] - KM_File$prop.event_free_intervention[(j+1)])/KM_File$prop.event_free_intervention[j])
            )
            KM_File$n.event_free_control[j] <- KM_File$n.event_free_control[(j-1)] - KM_File$n.events_control[(j-1)] - KM_File$n.censored_control[(j-1)]
            KM_File$n.censored_control[j] <- ifelse(
              (
                ((KM_File$time[j] < min.follow_up) | (KM_File$time[j] >= max.follow_up)) |
                  ((KM_File$prop.event_free_intervention[j] == min.Survival_Proportions[[i]][1]) & (KM_File$prop.event_free_control[j] == min.Survival_Proportions[[i]][2]))  
              ), 
              0,
              KM_File$n.event_free_control[j] * 0.5 * (KM_File$time[j+1] - KM_File$time[j]) * 
                (1/(max.follow_up - KM_File$time[j]))
            )
            KM_File$n.at.risk_control[j] <- KM_File$n.event_free_control[j] - KM_File$n.censored_control[j]
            KM_File$n.events_control[j] <- ifelse(
              (
                (KM_File$prop.event_free_control[j] == KM_File$prop.event_free_control[(j+1)]) | 
                  (KM_File$prop.event_free_control[j] == min.Survival_Proportions[[i]][2])
              ), 0.000001, 
              KM_File$n.at.risk_control[j] * 
                ((KM_File$prop.event_free_control[j] - KM_File$prop.event_free_control[(j+1)])/KM_File$prop.event_free_control[j])
            )
          }
        }
        KM_File$ln.hr.t <- log((KM_File$n.events_intervention/KM_File$n.at.risk_intervention)/(KM_File$n.events_control/KM_File$n.at.risk_control))
        KM_File$inverse.v.t <- (1/KM_File$n.events_intervention) - (1/KM_File$n.at.risk_intervention) + (1/KM_File$n.events_control) - (1/KM_File$n.at.risk_control)
        KM_File$o_e.t <- KM_File$ln.hr.t/KM_File$inverse.v.t
        KM_File$v.t <- 1/KM_File$inverse.v.t
        ln.hr <- sum(KM_File$o_e.t)/sum(KM_File$v.t)
        se.ln.hr <- 1/(sum(KM_File$v.t)^0.5)
      } else {
        KM_File <- "Please check data: proportion event free cannot be more than the previous time point"
        ln.hr <- "Please check data: proportion event free cannot be more than the previous time point"
        se.ln.hr <- "Please chcek data: proportion event free cannot be more than the previous time point"
      }
    } else {
      KM_File <- "Please check data: the number of time points and number of values supplied for intervention and control do not match"
      ln.hr <- "Please check data: the number of time points and number of values supplied for intervention and control do not match"
      se.ln.hr <- "Please check data: the number of time points and number of values supplied for intervention and control do not match"
    }
    KM_Calculations[[i]] <- list(calculations = KM_File,
                                 ln.hr = ln.hr,
                                 se.ln.hr = se.ln.hr,
                                 KM_DataTable = KM_DataTable
    )
  }
  return(KM_Calculations)
}
# Imputation methods for standard deviation
# Reference: Weir CJ, Butcher I, Assi V, Lewis SC, Murray GD, Langhorne P, Brady MC. Dealing with missing standard deviation and mean values in meta-analysis of continuous outcomes: a systematic review. BMC Med Res Methodol. 2018 Mar 7;18(1):25. doi: 10.1186/s12874-018-0483-0. PMID: 29514597; PMCID: PMC5842611.
# Reference: Wiebe N, Vandermeer B, Platt RW, Klassen TP, Moher D, Barrowman NJ. A systematic review identifies a lack of standardization in methods for handling missing variance data. J Clin Epidemiol. 2006 Apr;59(4):342-53. doi: 10.1016/j.jclinepi.2005.08.017. PMID: 16549255.
# Higgins JPT, Li T, Deeks JJ (editors). Chapter 6: Choosing effect measures and computing estimates of effect. 
# In: Higgins JPT, Thomas J, Chandler J, Cumpston M, Li T, Page MJ, Welch VA (editors). 
# Cochrane Handbook for Systematic Reviews of Interventions version 6.4 (updated August 2023). Cochrane, 2023. 
# Available from www.training.cochrane.org/handbook. 

individual.group.se.to.sd <- function(se,n) {
  # Formula from Cochrane Handbook: SD = SE × √𝑁
  se*n^0.5
}
individual.group.ci.to.sd <- function(lower.ci, upper.ci, n, ci, normal.distribution) {
  # Formula and suggested algorithm from Cochrane Handbook: SD = √𝑁 × (upper limit − lower limit)⁄3.92
  # Instead of rounding, the qnorm function is used directly
  if (missing(normal.distribution)) {
    normal.distribution <- FALSE
  }
  if (missing(ci)) {
    ci <- 0.95
  }
  if (
    (n> 100) |
    ((n > 60) & (normal.distribution == TRUE))
  ){
    abs((upper.ci - lower.ci)/
          (qnorm((1-ci)/2)*2)
    )*
      n^0.5 
  } else {
    abs((upper.ci - lower.ci)/
          (qt((1-ci)/2,(n-1))*2)
    )*
      n^0.5
  }
} 

individual.group.quartiles.to.sd <- function(lower.quartile, upper.quartile,
                                             minimum, maximum, n) {
  # Formula from Cochrane: (upper.quartile-lower.quartile) * 1.35 (appropriate for large sample size and normal distribution)
  # Formula from Weir et al based on Wan X, Wang W, Liu J, Tong T. Estimating the sample mean and standard deviation from the sample size, median, range and/or interquartile range. BMC Med Res Methodol. 2014;14:135. doi: 10.1186/1471-2288-14-135. 
  # Formula with minimum and maximum
  # Formula: sd = ((maximum - minimum)/(4*qnorm((n-0.375)/(n+0.25)))) + ((upper.quartile - lower.quartile)/(4*qnorm((0.75*n-0.125)/(n+0.25))))
  # Formula without minimum and maximum
  # Formula: sd = (upper.quartile - lower.quartile)/(2*qnorm((0.75*n-0.125)/(n+0.25)))
  if ((missing(minimum)) | (missing(maximum))) {
    abs((upper.quartile - lower.quartile)/(2*qnorm((0.75*n-0.125)/(n+0.25))))
  } else {
    ((maximum - minimum)/(4*qnorm((n-0.375)/(n+0.25)))) + ((upper.quartile - lower.quartile)/(4*qnorm((0.75*n-0.125)/(n+0.25))))
  }
}
individual.group.range.to.sd <- function(minimum, maximum, n){
  # Formula from Weir et al based on Wan X, Wang W, Liu J, Tong T. Estimating the sample mean and standard deviation from the sample size, median, range and/or interquartile range. BMC Med Res Methodol. 2014;14:135. doi: 10.1186/1471-2288-14-135. 
  # Formula: sd = (maximum - minimum)/(2*qnorm((n-0.375)/(n+0.25)))
  abs((maximum - minimum)/(2*qnorm((n-0.375)/(n+0.25))))
}

# References for meta-analysis
# Package: Meta
# Balduzzi S, Rücker G, Schwarzer G. How to perform a meta-analysis with R: a practical tutorial. Evid Based Ment Health. 2019 Nov;22(4):153-160. doi: 10.1136/ebmental-2019-300117. Epub 2019 Sep 28. PMID: 31563865.

# Methods to convert SMD to odds ratio: https://academic.oup.com/ije/article/41/5/1445/711693
# Methods for imputation of SD
# Methods for calculation of hazard ratio: Parmar et al

# Meta-analysis of rare events
# Dungang Li. Meta-Analysis of Rare Events. 2019. Wiley StatsRef: Statistics Reference Online. DOI: 10.1002/9781118445112.stat08167
# GLMM for sparse events: Stijnen, T., Hamza, T.H. and Özdemir, P. (2010), Random effects meta-analysis of event outcome in the framework of the generalized linear mixed model with applications in sparse data. Statist. Med., 29: 3046-3067. https://doi.org/10.1002/sim.4040

# Funnel plot asymmetry
# Sterne et al. Recommendations for examining and interpreting funnel plot asymmetry in meta-analyses of randomised controlled trials. BMJ 2011; 343 doi: https://doi.org/10.1136/bmj.d4002
# Rücker G, Schwarzer G, Carpenter J. Arcsine test for publication bias in meta-analyses with binary outcomes. Stat Med. 2008 Feb 28;27(5):746-63. doi: 10.1002/sim.2971. PMID: 17592831.

# Metaregression
# Thompson SG, Higgins JP. How should meta-regression analyses be undertaken and interpreted? Stat Med. 2002 Jun 15;21(11):1559-73. doi: 10.1002/sim.1187. PMID: 12111920.

# Dealing with missing data
# Mavridis, D, White, IR. Dealing with missing outcome data in meta-analysis. Res Syn Meth. 2020; 11: 2– 13. https://doi.org/10.1002/jrsm.1349
# Higgins JP, White IR, Wood AM. Imputation methods for missing outcome data in meta‐analysis of clinical trials.Clin Trials.2008;5(3):225‐23. https://journals.sagepub.com/doi/10.1177/1740774508091600
# Mavridis D, White IR, Higgins JPT, Cipriani A, Salanti G. Allowing for uncertainty due to missing continuous outcome data in pairwise and network meta‐analysis. Stat Med 2015;34(5):721‐741. https://doi.org/10.1002/sim.6365

# Variances of product of two independent variables
# Leo A. Goodman (1960) On the Exact Variance of Products, Journal of the American Statistical Association, 55:292, 708-713, DOI: 10.1080/01621459.1960.10483369
# Variance: V(x,y) =  E(x)^2*V(y)+E(y)^2*V(x)+V(x)*V(y) 
# [Equation 2]
# Variances of product of two dependent variables
# https://rdrr.io/github/FabioLugar/mvEvol/src/R/varTransform.R
# Another formula is also available from Leo A.Goodman reference

# Variance of the sum of two random variables (X and Y) = Var(X)+Var(Y)+2*Cov(X,Y)
# Reference: H. Pishro-Nik, "Introduction to probability, statistics, and random processes", available at https://www.probabilitycourse.com, Kappa Research LLC, 2014.

# Defaults and optional
# Effect measures
# Odds ratio for 'binary'
# Rate ratio for 'count' 
# Mean difference for 'continuous' unless the scale indicates different measures
# Hazard ratio for 'time' outcomes
# Optional: risk ratio and risk difference for 'binary', mean difference (when different scales), standardised mean difference (otherwise), ratio of means for 'continuous' outcomes

# Model
# Random-effects model (normal distribution) and fixed-effect model (also presented)
# Hartung and Knapp adjusted analysis for random-effects model
# Prediction interval also presented
# Optional: without Hartung and Knapp adjusted analysis 

# Method
# For binary outcomes: Mantel Haenszel method, but if data = sparse (continuity correction applied), GLMM (exact likelihood) (Ref: Li 2019; Stijnen 2010) ==> if no convergence, GLMM (approximate likelihood)
# For continuous outcomes (SMD): Hedges' g, exact SMD
# For other outcomes: inverse variance method
# Optional: other methods

# Metabias
# Contour enhanced plots offered for any number of trials
# Tests for funnel plot asymmetry
# Minimum 10 studies (Sterne 2011)
# For binary with tau2<0.10, Harbord (Sterne 2011), otherwise Thompson test after arcsine transformation (as per Rucker 2008)
# For non-binary outcomes: Egger
# Optional: other methods

# Sensitivity analysis
# Binary outcomes: best-worst meta-analysis, IMOR (same for intervention and control): any missing or only for missing not at random: using control proportions
# Continuous outcomes: exclude studies in which SD was imputed

# Metaregression
# User selected variables

# Subgroup meta-analysis
# User selected variables
# Only for categorical variables
# Different variances across subgroups

# Future Improvements
# New meta-analysis methods
# Apply box cox transformation to continuous variables (dependent and metaregression)
# Random-effects (non-normal distribution)
# Meta-analysis of ordinal outcomes
# NMA
# Repeated measures
# Correlated outcomes
# Ordinal outcomes
# Allow user to specify whether the categorical variable in subgroup analysis is ordered
# DTAR
# Prognostic
# Meta-analysis of correlations

# More user choice
# Impute method for standard deviation for continuous outcomes
# ImputeMethodSD <- c("Method 1", "Method 2")
# ImputeMissingSD <- c("Maximum of other SD", "Median of other SD", "I will provide values")

# Systematic review related
# Screening trials
# Extracting data from text (after OCR)

# The future
# Link with COMET outputs and outcome taxonomy

# Make the code available
ProgrammeCode <- read.delim("ProgrammeCode.txt", header = FALSE, sep = "\t", dec = ".", quote="")

# Start recording the code (only for meta-analysis of intervention currently)
GenerateCode <- read.delim("Code_Intervention.txt", header = FALSE, sep = "\t", dec = ".", quote="")

# Functions for processing data ####
lnRatio_SE <- function(ratio, lower_CI, upper_CI, confidence_levels) {
  if (missing(confidence_levels)) {
    confidence_levels = 0.95
  }
  ln.ratio <- log(ratio)
  se.ln.ratio <- (log(upper_CI)-log(lower_CI))/abs(2*qnorm(((1-confidence_levels)/2)))
  results <- list(ln.ratio, se.ln.ratio)
  return(results)
}
difference_SE <- function(lower_CI, upper_CI, confidence_levels) {
  if (missing(confidence_levels)) {
    confidence_levels = 0.95
  }
  (upper_CI-lower_CI)/abs(2*qnorm(((1-confidence_levels)/2)))
}
lnHR_SE.from.HR_events <- function(hazard_ratio, observed_events, n_intervention, n_comparator) {
  ln.HR <- log(hazard_ratio)
  se.ln.hr <- (n_intervention + n_comparator)/(observed_events * n_intervention * n_comparator)^0.5 
  results <- list(ln.HR, se.ln.hr)
  return(results)
}
lnHR_SE.from.events_p_favourable <- function(observed_events, log_rank_p, higher_events_better_worse, favourable_intervention_comparator, n_intervention, n_comparator) {
  ln.HR <- 
    ((observed_events * n_intervention * n_comparator)^0.5/(n_intervention + n_comparator) * 
       ifelse(
         (
           ((higher_events_better_worse == "better") & (favourable_intervention_comparator == "comparator")) |
             ((higher_events_better_worse == "worse") & (favourable_intervention_comparator == "intervention"))
         ),1,-1
       )*(qnorm(log_rank_p/2)))/
    (((observed_events * n_intervention * n_comparator)/(n_intervention + n_comparator)^2))
  se.ln.hr <- (n_intervention + n_comparator)/(observed_events * n_intervention * n_comparator)^0.5 
  results <- list(ln.HR, se.ln.hr)
  return(results)
}
KM_min_max_median_recruitment_period <- function(median_follow_up, recruitment_period) {
  min.follow_up <- max(0, median_follow_up - 0.5*recruitment_period)
  max.follow_up <- median_follow_up + 0.5*recruitment_period
  c(min.follow_up,max.follow_up)
}
KM_lnHR_ascending <- function(KM_DataTable, KM_TimePoints, min.follow_up, max.follow_up, n.participants) {
  KM_Calculations <- list()
  min.Survival_Proportions <- list()
  for (i in 1:(length(KM_DataTable)-1)) {
    KM_Calculations[[i]] <- cbind(
      time = KM_TimePoints, 
      prop.event_free_intervention = KM_DataTable[[i]],
      n.event_free_intervention = rep(NA, length(KM_DataTable[[i]])),
      n.at.risk_intervention = rep(NA, length(KM_DataTable[[i]])),
      n.events_intervention = rep(NA, length(KM_DataTable[[i]])),
      n.censored_intervention = rep(NA, length(KM_DataTable[[i]])),
      prop.event_free_control= KM_DataTable[[length(KM_DataTable)]],
      n.event_free_control = rep(NA, length(KM_DataTable[[length(KM_DataTable)]])),
      n.at.risk_control = rep(NA, length(KM_DataTable[[length(KM_DataTable)]])),
      n.events_control = rep(NA, length(KM_DataTable[[length(KM_DataTable)]])),
      n.censored_control = rep(NA, length(KM_DataTable[[length(KM_DataTable)]])),
      ln.hr.t= rep(NA, length(KM_DataTable[[length(KM_DataTable)]])),
      inverse.v.t = rep(NA, length(KM_DataTable[[length(KM_DataTable)]])),
      o_e.t = rep(NA, length(KM_DataTable[[length(KM_DataTable)]])),
      v.t = rep(NA, length(KM_DataTable[[length(KM_DataTable)]]))
    )
    if (
      (length(KM_TimePoints) == length(KM_DataTable[[i]])) &
      (length(KM_DataTable[[i]]) == length(KM_DataTable[[1]]))
    ){
      if ((check.ascending.descending(KM_Calculations[[i]][,1]) == "ascending") &
          (check.ascending.descending(KM_Calculations[[i]][,2]) == "descending") & 
          (check.ascending.descending(KM_Calculations[[i]][,7]) == "descending")
      ) {
        KM_File <- data.frame(KM_Calculations[[i]])
        min.Survival_Proportions[[i]] <- c(min(KM_DataTable[[i]]), min(KM_DataTable[[length(KM_DataTable)]]))
        for (j in 1:nrow(KM_File)) {
          if (j == 1) {
            KM_File$n.event_free_intervention[j] <- n.participants[i]
            KM_File$n.at.risk_intervention[j] <- KM_File$n.event_free_intervention[j]
            KM_File$n.events_intervention[j] <- ifelse(
              (
                (KM_File$prop.event_free_intervention[j] == KM_File$prop.event_free_intervention[(j+1)]) | 
                  (KM_File$prop.event_free_intervention[j] == min.Survival_Proportions[[i]][1])
              ), 0.000001, 
              KM_File$n.at.risk_intervention[j] * 
                ((KM_File$prop.event_free_intervention[j] - KM_File$prop.event_free_intervention[(j+1)])/KM_File$prop.event_free_intervention[j])
            )
            KM_File$n.censored_intervention[j] <- 0
            KM_File$n.event_free_control[j] <- n.participants[length(n.participants)]
            KM_File$n.at.risk_control[j] <- KM_File$n.event_free_control[j]
            KM_File$n.events_control[j] <- ifelse(
              (
                (KM_File$prop.event_free_control[j] == KM_File$prop.event_free_control[(j+1)]) | 
                  (KM_File$prop.event_free_control[j] == min.Survival_Proportions[[i]][2])
              ), 0.000001, 
              KM_File$n.at.risk_control[j] * 
                ((KM_File$prop.event_free_control[j] - KM_File$prop.event_free_control[(j+1)])/KM_File$prop.event_free_control[j])
            )
            KM_File$n.censored_control[j] <- 0
          } else if (j == nrow(KM_File)){
            KM_File$n.event_free_intervention[j] <- KM_File$n.event_free_intervention[(j-1)] - KM_File$n.events_intervention[(j-1)] - KM_File$n.censored_intervention[(j-1)]
            KM_File$n.at.risk_intervention[j] <- KM_File$n.event_free_intervention[j]
            KM_File$n.events_intervention[j] <- 0.000001
            KM_File$n.censored_intervention[j] <- 0
            KM_File$n.event_free_control[j] <- KM_File$n.event_free_control[(j-1)] - KM_File$n.events_control[(j-1)] - KM_File$n.censored_control[(j-1)]
            KM_File$n.at.risk_control[j] <- KM_File$n.event_free_control[j]
            KM_File$n.events_control[j] <- 0.000001
            KM_File$n.censored_control[j] <- 0
          } else {
            KM_File$n.event_free_intervention[j] <- KM_File$n.event_free_intervention[(j-1)] - KM_File$n.events_intervention[(j-1)] - KM_File$n.censored_intervention[(j-1)]
            KM_File$n.censored_intervention[j] <- ifelse(
              (
                ((KM_File$time[j] < min.follow_up) | (KM_File$time[j] >= max.follow_up)) |
                  ((KM_File$prop.event_free_intervention[j] == min.Survival_Proportions[[i]][1]) & (KM_File$prop.event_free_control[j] == min.Survival_Proportions[[i]][2]))  
              ), 
              0,
              KM_File$n.event_free_intervention[j] * 0.5 * (KM_File$time[j+1] - KM_File$time[j]) * 
                (1/(max.follow_up - KM_File$time[j]))
            )
            KM_File$n.at.risk_intervention[j] <- KM_File$n.event_free_intervention[j] - KM_File$n.censored_intervention[j]
            KM_File$n.events_intervention[j] <- ifelse(
              (
                (KM_File$prop.event_free_intervention[j] == KM_File$prop.event_free_intervention[(j+1)]) | 
                  (KM_File$prop.event_free_intervention[j] == min.Survival_Proportions[[i]][1])
              ), 0.000001, 
              KM_File$n.at.risk_intervention[j] * 
                ((KM_File$prop.event_free_intervention[j] - KM_File$prop.event_free_intervention[(j+1)])/KM_File$prop.event_free_intervention[j])
            )
            KM_File$n.event_free_control[j] <- KM_File$n.event_free_control[(j-1)] - KM_File$n.events_control[(j-1)] - KM_File$n.censored_control[(j-1)]
            KM_File$n.censored_control[j] <- ifelse(
              (
                ((KM_File$time[j] < min.follow_up) | (KM_File$time[j] >= max.follow_up)) |
                  ((KM_File$prop.event_free_intervention[j] == min.Survival_Proportions[[i]][1]) & (KM_File$prop.event_free_control[j] == min.Survival_Proportions[[i]][2]))  
              ), 
              0,
              KM_File$n.event_free_control[j] * 0.5 * (KM_File$time[j+1] - KM_File$time[j]) * 
                (1/(max.follow_up - KM_File$time[j]))
            )
            KM_File$n.at.risk_control[j] <- KM_File$n.event_free_control[j] - KM_File$n.censored_control[j]
            KM_File$n.events_control[j] <- ifelse(
              (
                (KM_File$prop.event_free_control[j] == KM_File$prop.event_free_control[(j+1)]) | 
                  (KM_File$prop.event_free_control[j] == min.Survival_Proportions[[i]][2])
              ), 0.000001, 
              KM_File$n.at.risk_control[j] * 
                ((KM_File$prop.event_free_control[j] - KM_File$prop.event_free_control[(j+1)])/KM_File$prop.event_free_control[j])
            )
          }
        }
        KM_File$ln.hr.t <- log((KM_File$n.events_intervention/KM_File$n.at.risk_intervention)/(KM_File$n.events_control/KM_File$n.at.risk_control))
        KM_File$inverse.v.t <- (1/KM_File$n.events_intervention) - (1/KM_File$n.at.risk_intervention) + (1/KM_File$n.events_control) - (1/KM_File$n.at.risk_control)
        KM_File$o_e.t <- KM_File$ln.hr.t/KM_File$inverse.v.t
        KM_File$v.t <- 1/KM_File$inverse.v.t
        ln.hr <- sum(KM_File$o_e.t)/sum(KM_File$v.t)
        se.ln.hr <- 1/(sum(KM_File$v.t)^0.5)
      } else {
        KM_File <- "Please check data: proportion event free cannot be more than the previous time point"
        ln.hr <- "Please check data: proportion event free cannot be more than the previous time point"
        se.ln.hr <- "Please chcek data: proportion event free cannot be more than the previous time point"
      }
    } else {
      KM_File <- "Please check data: the number of time points and number of values supplied for intervention and control do not match"
      ln.hr <- "Please check data: the number of time points and number of values supplied for intervention and control do not match"
      se.ln.hr <- "Please check data: the number of time points and number of values supplied for intervention and control do not match"
    }
    KM_Calculations[[i]] <- list(calculations = KM_File,
                                 ln.hr = ln.hr,
                                 se.ln.hr = se.ln.hr,
                                 KM_DataTable = KM_DataTable
    )
  }
  return(KM_Calculations)
}
KM_Table_Direct_Upload <- function(KM_Table_location) {
  KM_Table <- read.csv(KM_Table_location, header = TRUE, check.names = FALSE)
  # Check column names
  if (FALSE %in% (colnames(KM_Table)[1:3] == c("follow_up", "participants", "time_points"))) {
    error_message <- 'The file uploaded in not in correct format. 
    The column names of first three columns should be exactly "follow_up", "participants", and "time_points".'
  } else if (ncol(KM_Table) < 5) {
    error_message <- 'The file uploaded in not in correct format. 
    There must be at least 2 groups with data.'
  } else if (FALSE %in% (sapply(KM_Table[,1:ncol(KM_Table)], is.numeric))) {
    error_message <- 'The file uploaded in not in correct format. 
    Data contains one or more non-numeric values.The symbol "%" is considered a non-numeric value.'
  } else if (length(KM_Table$participants[!is.na(KM_Table$participants)]) != (ncol(KM_Table) - 3)) {
    error_message <- 'The file uploaded in not in correct format. 
    The number of participants should match the number of groups.'
  } else if (KM_Table$time_points[1] != 0) {
    error_message <- 'The file uploaded in not in correct format. 
    The first time point must be 0.'
  } else if (nrow(KM_Table) < 2) {
    error_message <- 'The file uploaded in not in correct format. 
    There must be at one time point in addition to time point 0.'
  } else if (check.ascending.descending(KM_Table$time_points[!is.na(KM_Table$time_points)]) != "ascending") {
    error_message <- 'The file uploaded in not in correct format. 
    The time points should be in ascending order.'
  } else if (length(unique(sapply(3:ncol(KM_Table), function (x) {length(KM_Table[,x][!is.na(KM_Table[,x])])})))>1) {
    if (length(KM_Table[,3][!is.na(KM_Table[,3])]) < max(sapply(4:ncol(KM_Table), function (x) {length(KM_Table[,x][!is.na(KM_Table[,x])])}))) {
      error_message <- 'The file uploaded in not in correct format. 
    One or more time points is missing.'
    } else {
      error_message <- 'The file uploaded in not in correct format. 
    The proportions of events or no events should be available for each time point.'
    }
    
  } else {
    point_values_ascending <- list()
    for (i in 1:(ncol(KM_Table)-3)) {
      point_values_ascending[[i]] <- check.ascending.descending(KM_Table[, (i+3)])
    }
    point_values_ascending <- as.vector(do.call(rbind, point_values_ascending))
    if (length(unique(point_values_ascending)) > 1) {
      error_message <- 'The file uploaded in not in correct format. 
      The KM curves should be either ascending or descending.
      The proportion with events (in an ascending curve) at a time point should be more than or equal to that at previous time points or 
      the proportion without events (in an descending curve) at a time point should be less than or equal to that at previous time points.'
      KM_curve <- "mixed ascending and descending"
    } else {
      KM_curve <- unique(point_values_ascending)
    }
    if ((KM_curve == "ascending") | (KM_curve == "descending")) {
      if (! is.na(KM_Table$follow_up[1])){
        min.follow_up <- KM_Table$follow_up[1]
      } else {
        min.follow_up <- 0
      }
      if (! is.na(KM_Table$follow_up[2])){
        max.follow_up <- KM_Table$follow_up[2]
      } else {
        max.follow_up <- max(KM_Table$KM_TimePoints) 
      }
      if (max(KM_Table[,4:ncol(KM_Table)]) <= 1) {
        KM_DataTable <- lapply(
          4:ncol(KM_Table),
          function(x) {
            if (KM_curve == "ascending") {
              sort((1 - KM_Table[,x]), decreasing = TRUE)
            } else {
              KM_Table[,x]
            }  
          }
        )
      } else {
        KM_DataTable <- lapply(
          4:ncol(KM_Table),
          function(x) {
            if (KM_curve == "ascending") {
              sort((1 - KM_Table[,x]/100), decreasing = TRUE)
            } else {
              KM_Table[,x]/100
            }  
          }
        )
      }
      KM_Calculations <- list()
      min.Survival_Proportions <- list()
      for (i in 1:(length(KM_DataTable)-1)) {
        KM_Calculations[[i]] <- cbind(
          time = KM_Table$time_points, 
          prop.event_free_intervention = KM_DataTable[[i]],
          n.event_free_intervention = rep(NA, length(KM_DataTable[[i]])),
          n.at.risk_intervention = rep(NA, length(KM_DataTable[[i]])),
          n.events_intervention = rep(NA, length(KM_DataTable[[i]])),
          n.censored_intervention = rep(NA, length(KM_DataTable[[i]])),
          prop.event_free_control= KM_DataTable[[length(KM_DataTable)]],
          n.event_free_control = rep(NA, length(KM_DataTable[[length(KM_DataTable)]])),
          n.at.risk_control = rep(NA, length(KM_DataTable[[length(KM_DataTable)]])),
          n.events_control = rep(NA, length(KM_DataTable[[length(KM_DataTable)]])),
          n.censored_control = rep(NA, length(KM_DataTable[[length(KM_DataTable)]])),
          ln.hr.t= rep(NA, length(KM_DataTable[[length(KM_DataTable)]])),
          inverse.v.t = rep(NA, length(KM_DataTable[[length(KM_DataTable)]])),
          o_e.t = rep(NA, length(KM_DataTable[[length(KM_DataTable)]])),
          v.t = rep(NA, length(KM_DataTable[[length(KM_DataTable)]]))
        )
        KM_File <- data.frame(KM_Calculations[[i]])
        min.Survival_Proportions[[i]] <- c(min(KM_DataTable[[i]]), min(KM_DataTable[[length(KM_DataTable)]]))
        n.participants <- KM_Table$participants[!is.na(KM_Table$participants)]
        for (j in 1:nrow(KM_File)) {
          if (j == 1) {
            KM_File$n.event_free_intervention[j] <- n.participants[i]
            KM_File$n.at.risk_intervention[j] <- KM_File$n.event_free_intervention[j]
            KM_File$n.events_intervention[j] <- ifelse(
              (
                (KM_File$prop.event_free_intervention[j] == KM_File$prop.event_free_intervention[(j+1)]) | 
                  (KM_File$prop.event_free_intervention[j] == min.Survival_Proportions[[i]][1])
              ), 0.000001, 
              KM_File$n.at.risk_intervention[j] * 
                ((KM_File$prop.event_free_intervention[j] - KM_File$prop.event_free_intervention[(j+1)])/KM_File$prop.event_free_intervention[j])
            )
            KM_File$n.censored_intervention[j] <- 0
            KM_File$n.event_free_control[j] <- n.participants[length(n.participants)]
            KM_File$n.at.risk_control[j] <- KM_File$n.event_free_control[j]
            KM_File$n.events_control[j] <- ifelse(
              (
                (KM_File$prop.event_free_control[j] == KM_File$prop.event_free_control[(j+1)]) | 
                  (KM_File$prop.event_free_control[j] == min.Survival_Proportions[[i]][2])
              ), 0.000001, 
              KM_File$n.at.risk_control[j] * 
                ((KM_File$prop.event_free_control[j] - KM_File$prop.event_free_control[(j+1)])/KM_File$prop.event_free_control[j])
            )
            KM_File$n.censored_control[j] <- 0
          } else if (j == nrow(KM_File)){
            KM_File$n.event_free_intervention[j] <- KM_File$n.event_free_intervention[(j-1)] - KM_File$n.events_intervention[(j-1)] - KM_File$n.censored_intervention[(j-1)]
            KM_File$n.at.risk_intervention[j] <- KM_File$n.event_free_intervention[j]
            KM_File$n.events_intervention[j] <- 0.000001
            KM_File$n.censored_intervention[j] <- 0
            KM_File$n.event_free_control[j] <- KM_File$n.event_free_control[(j-1)] - KM_File$n.events_control[(j-1)] - KM_File$n.censored_control[(j-1)]
            KM_File$n.at.risk_control[j] <- KM_File$n.event_free_control[j]
            KM_File$n.events_control[j] <- 0.000001
            KM_File$n.censored_control[j] <- 0
          } else {
            KM_File$n.event_free_intervention[j] <- KM_File$n.event_free_intervention[(j-1)] - KM_File$n.events_intervention[(j-1)] - KM_File$n.censored_intervention[(j-1)]
            KM_File$n.censored_intervention[j] <- ifelse(
              (
                ((KM_File$time[j] < min.follow_up) | (KM_File$time[j] >= max.follow_up)) |
                  ((KM_File$prop.event_free_intervention[j] == min.Survival_Proportions[[i]][1]) & (KM_File$prop.event_free_control[j] == min.Survival_Proportions[[i]][2]))  
              ), 
              0,
              KM_File$n.event_free_intervention[j] * 0.5 * (KM_File$time[j+1] - KM_File$time[j]) * 
                (1/(max.follow_up - KM_File$time[j]))
            )
            KM_File$n.at.risk_intervention[j] <- KM_File$n.event_free_intervention[j] - KM_File$n.censored_intervention[j]
            KM_File$n.events_intervention[j] <- ifelse(
              (
                (KM_File$prop.event_free_intervention[j] == KM_File$prop.event_free_intervention[(j+1)]) | 
                  (KM_File$prop.event_free_intervention[j] == min.Survival_Proportions[[i]][1])
              ), 0.000001, 
              KM_File$n.at.risk_intervention[j] * 
                ((KM_File$prop.event_free_intervention[j] - KM_File$prop.event_free_intervention[(j+1)])/KM_File$prop.event_free_intervention[j])
            )
            KM_File$n.event_free_control[j] <- KM_File$n.event_free_control[(j-1)] - KM_File$n.events_control[(j-1)] - KM_File$n.censored_control[(j-1)]
            KM_File$n.censored_control[j] <- ifelse(
              (
                ((KM_File$time[j] < min.follow_up) | (KM_File$time[j] >= max.follow_up)) |
                  ((KM_File$prop.event_free_intervention[j] == min.Survival_Proportions[[i]][1]) & (KM_File$prop.event_free_control[j] == min.Survival_Proportions[[i]][2]))  
              ), 
              0,
              KM_File$n.event_free_control[j] * 0.5 * (KM_File$time[j+1] - KM_File$time[j]) * 
                (1/(max.follow_up - KM_File$time[j]))
            )
            KM_File$n.at.risk_control[j] <- KM_File$n.event_free_control[j] - KM_File$n.censored_control[j]
            KM_File$n.events_control[j] <- ifelse(
              (
                (KM_File$prop.event_free_control[j] == KM_File$prop.event_free_control[(j+1)]) | 
                  (KM_File$prop.event_free_control[j] == min.Survival_Proportions[[i]][2])
              ), 0.000001, 
              KM_File$n.at.risk_control[j] * 
                ((KM_File$prop.event_free_control[j] - KM_File$prop.event_free_control[(j+1)])/KM_File$prop.event_free_control[j])
            )
          }
        }
        KM_File$ln.hr.t <- log((KM_File$n.events_intervention/KM_File$n.at.risk_intervention)/(KM_File$n.events_control/KM_File$n.at.risk_control))
        KM_File$inverse.v.t <- (1/KM_File$n.events_intervention) - (1/KM_File$n.at.risk_intervention) + (1/KM_File$n.events_control) - (1/KM_File$n.at.risk_control)
        KM_File$o_e.t <- KM_File$ln.hr.t/KM_File$inverse.v.t
        KM_File$v.t <- 1/KM_File$inverse.v.t
        ln.hr <- sum(KM_File$o_e.t)/sum(KM_File$v.t)
        se.ln.hr <- 1/(sum(KM_File$v.t)^0.5)
        KM_Calculations[[i]] <- list(calculations = KM_File,
                                     ln.hr = ln.hr,
                                     se.ln.hr = se.ln.hr,
                                     KM_DataTable = KM_DataTable
        )        
      }
      list("Successfully completed",KM_Calculations)
    } else {
      list(error_message)
    }
  }
}  
lnRateRatio_SE <- function(count_intervention, count_comparator, n_intervention, n_comparator, time_intervention, time_comparator) {
  ln.rate.ratio <- log(
    (count_intervention/(n_intervention*time_intervention))/(count_comparator/(n_comparator*time_comparator))
  )
  se.ln.rate.ratio <- (1/count_intervention+1/count_comparator)^0.5
  results <- list(ln.rate.ratio, se.ln.rate.ratio)
  return(results)
}
binary_percent_to_numbers <- function(percent, n) {
  percent * n
}
lnRatio_SE_from_estimate_p.value <- function(ratio, p_value) {
  ln.ratio <- log(ratio)
  z.score <- qnorm(p_value/2)
  se.ln.ratio <- abs(log(ratio)/z.score)
  results <- list(ln.ratio, se.ln.ratio)
  return(results)
}
difference_SE_from_estimate_p.value <- function(difference, p_value) {
  z.score <- qnorm(p_value/2)
  se.difference <- abs(difference/z.score)
  results <- list(difference, se.difference)
  return(results)
}
# Converting odds ratio to risk ratio
# Grant R L. Converting an odds ratio to a range of plausible relative risks for better communication of research findings BMJ 2014; 348 :f7450 doi:10.1136/bmj.f7450
# Relative risk=odds ratio/(1−p0+(p0×odds ratio))
convert_odds_ratio_to_risk_ratio <- function(odds_ratio, odds_ratio_lower_CI, odds_ratio_upper_CI, baseline_risk){
  risk_ratio <- odds_ratio/(1 - baseline_risk + (baseline_risk * odds_ratio))
  risk_ratio_lower_CI <- odds_ratio_lower_CI/(1 - baseline_risk + (baseline_risk * odds_ratio_lower_CI))
  risk_ratio_upper_CI <- odds_ratio_upper_CI/(1 - baseline_risk + (baseline_risk * odds_ratio_upper_CI))
  list(risk_ratio, risk_ratio_lower_CI, risk_ratio_upper_CI)
}
convert_risk_ratio_to_odds_ratio <- function(risk_ratio, risk_ratio_lower_CI, risk_ratio_upper_CI, baseline_risk){
  f <- function(risk_ratio, odds_ratio, baseline_risk) {(odds_ratio/(1 - baseline_risk + (baseline_risk * odds_ratio))) - risk_ratio}
  odds_ratio <- uniroot(f, c(0, 10^80), tol = 0.0001, risk_ratio = risk_ratio, baseline_risk = baseline_risk)$root
  odds_ratio_lower_CI <- uniroot(f, c(0, 10^80), tol = 0.0001, risk_ratio = risk_ratio_lower_CI, baseline_risk = baseline_risk)$root
  odds_ratio_upper_CI <- uniroot(f, c(0, 10^80), tol = 0.0001, risk_ratio = risk_ratio_upper_CI, baseline_risk = baseline_risk)$root
  list(odds_ratio, odds_ratio_lower_CI, odds_ratio_upper_CI)
}
# Converting odds ratio and risk ratio to SMD
# Cochrane handbook formula:
# 3^0.5/pi * ln (odds ratio)
convert_odds_ratio_to_SMD <- function(odds_ratio, odds_ratio_lower_CI, odds_ratio_upper_CI){
  SMD <-  3^0.5/pi * log(odds_ratio)
  SMD_lower_CI <- 3^0.5/pi * log(odds_ratio_lower_CI)
  SMD_upper_CI <- 3^0.5/pi * log(odds_ratio_upper_CI)
  list(SMD, SMD_lower_CI, SMD_upper_CI)
}
convert_risk_ratio_to_SMD <- function(risk_ratio, risk_ratio_lower_CI, risk_ratio_upper_CI, baseline_risk){
  f <- function(risk_ratio, odds_ratio, baseline_risk) {(odds_ratio/(1 - baseline_risk + (baseline_risk * odds_ratio))) - risk_ratio}
  odds_ratio <- uniroot(f, c(0, 10^80), tol = 0.0001, risk_ratio = risk_ratio, baseline_risk = baseline_risk)$root
  odds_ratio_lower_CI <- uniroot(f, c(0, 10^80), tol = 0.0001, risk_ratio = risk_ratio_lower_CI, baseline_risk = baseline_risk)$root
  odds_ratio_upper_CI <- uniroot(f, c(0, 10^80), tol = 0.0001, risk_ratio = risk_ratio_upper_CI, baseline_risk = baseline_risk)$root
  SMD <-  3^0.5/pi * log(odds_ratio)
  SMD_lower_CI <- 3^0.5/pi * log(odds_ratio_lower_CI)
  SMD_upper_CI <- 3^0.5/pi * log(odds_ratio_upper_CI)
  list(SMD, SMD_lower_CI, SMD_upper_CI)
}
individual.group.means.p.value.to.sd <- function(mean_intervention, mean_comparator, n_intervention, n_comparator, p_value) {
  # Formula from Cochrane Handbook
  # Get T-statistic
  MD <- mean_intervention - mean_comparator
  T_statistic <- qt(p_value/2,(n_intervention + n_comparator - 2))
  se <- abs(MD/T_statistic)
  sd <- se/(1/n_intervention + 1/n_comparator)^0.5
  list(MD, sd)
}
convert_to_same_units <- function(value, multiplication_factor) {
  value * multiplication_factor
}
split_multiple_groups_binary_count <- function(n.events, n.participants, n.groups) {
  list(n.events/n.groups, n.participants/n.groups)
}
split_multiple_groups_continuous <- function(overall_mean, pooled_sd, n.participants, n.groups) {
  # Formula 6.5a combining summary statistics across two groups (Cochrane Handbook v6 chapter 6)
  # since sd should be the same across the groups, this is indicated as sd rather than sd1, sd2 etc
  f = function(pooled_sd, n1, n2, sd, m1, m2) 
  {pooled_sd - 
      (
        ((n1-1)*sd^2 + (n2-1)*(sd^2) + (n1*n2)/(n1+n2)*(m1^2 + m2^2 - 2*m1*m2)) /
          (n1+n2-1)
      )^0.5
  }
  n2 <- n.participants/n.groups
  cumulative_n1 <- n.participants/n.groups
  # First two groups
  sd <- uniroot(f, c(0, 10^80), tol = 0.0001, 
                pooled_sd = pooled_sd, n1 = cumulative_n1, n2 = n2, m1= overall_mean, m2 = overall_mean)$root
  for (i in 3:n.groups) {
    cumulative_n1 <- cumulative_n1 + n2
    sd <- uniroot(f, c(0, 10^80), tol = 0.0001, 
                  pooled_sd = pooled_sd, n1 = cumulative_n1, n2 = n2, m1= overall_mean, m2 = overall_mean)$root
  }
  list(overall_mean, sd, n.participants/n.groups)
}
change_directions_MD_SMD <- function(outcome_data, input_direction) {
  if (! FALSE %in% (colnames(outcome_data) == c(
    "Outcome name", "Type of outcome", "Are more events or higher value better or worse for participants?", 
    "Study", "Intervention (total number of participants)", "Control (total number of participants)", 
    "Parameter1", "Parameter2", "Parameter3", "Parameter4", 
    "Units (Continuous outcomes)", "Scale (Continuous outcomes)")
)) {
    # Split the studies by outcome
    outcome_data_split <- split.data.frame(outcome_data, factor(outcome_data$`Outcome name`))
    Results <- list()
    direction <- list()
    for (i in 1:length(outcome_data_split)) {
      if (nrow(outcome_data_split[[i]])>1) {
        # If the direction is not provided, find the number of studies with better and worse: if equal, use "Worse" as default
        if (missing(input_direction)) {
          if (length(outcome_data_split[[i]]$`Are more events or higher value better or worse for participants?`[
            outcome_data_split[[i]]$`Are more events or higher value better or worse for participants?` == "Better"
          ]) > 0.5 * nrow(outcome_data_split[[i]])
          ) {
            direction[[i]] <- "Better"
          } else {
            direction[[i]] <- "Worse"
          }
        } else {
          direction[[i]] <- input_direction
        }
        if (direction[[i]] == "Better") {
          outcome_data_split[[i]]$Parameter1[
            outcome_data_split[[i]]$`Are more events or higher value better or worse for participants?` == "Worse"
          ] <- ((-1) * (outcome_data_split[[i]]$Parameter1[
            outcome_data_split[[i]]$`Are more events or higher value better or worse for participants?` == "Worse"
          ]))
          if (outcome_data_split[[i]]$`Type of outcome`[1] == "Continuous") {
            outcome_data_split[[i]]$Parameter3[
              outcome_data_split[[i]]$`Are more events or higher value better or worse for participants?` == "Worse"
            ] <- ((-1) * (outcome_data_split[[i]]$Parameter3[
              outcome_data_split[[i]]$`Are more events or higher value better or worse for participants?` == "Worse"
            ]))
          }
          outcome_data_split[[i]]$`Scale (Continuous outcomes)`[
            outcome_data_split[[i]]$`Are more events or higher value better or worse for participants?` == "Worse"
          ] <- paste0(
            outcome_data_split[[i]]$`Scale (Continuous outcomes)`[
              outcome_data_split[[i]]$`Are more events or higher value better or worse for participants?` == "Worse"
            ],
            " (directions reversed)"
          )
          outcome_data_split[[i]]$`Are more events or higher value better or worse for participants?` <- "Better"
        } else {
          outcome_data_split[[i]]$Parameter1[
            outcome_data_split[[i]]$`Are more events or higher value better or worse for participants?` == "Better"
          ] <- ((-1) * (outcome_data_split[[i]]$Parameter1[
            outcome_data_split[[i]]$`Are more events or higher value better or worse for participants?` == "Better"
          ]))
          if (outcome_data_split[[i]]$`Type of outcome`[1] == "Continuous") {
            outcome_data_split[[i]]$Parameter3[
              outcome_data_split[[i]]$`Are more events or higher value better or worse for participants?` == "Better"
            ] <- ((-1) * (outcome_data_split[[i]]$Parameter3[
              outcome_data_split[[i]]$`Are more events or higher value better or worse for participants?` == "Better"
            ]))
          }
          outcome_data_split[[i]]$`Scale (Continuous outcomes)`[
            outcome_data_split[[i]]$`Are more events or higher value better or worse for participants?` == "Better"
          ] <- paste0(
            outcome_data_split[[i]]$`Scale (Continuous outcomes)`[
              outcome_data_split[[i]]$`Are more events or higher value better or worse for participants?` == "Better"
            ],
            " (directions reversed)"
          )
          outcome_data_split[[i]]$`Are more events or higher value better or worse for participants?` <- "Worse"
        }
      }
    }
    outcome_data_revised <- do.call(rbind.data.frame, outcome_data_split)
    output <- list(
      outcome_data_revised,
      "Successful"
    )
  } else {
    output <- list(
      "The column names do not match with those provided in the instructions. 
                   Please upload a file that has the exact column names as the sample file",
      "Unsuccessful"
    )
  }
  return(output)
}
# Adjustments for cluster and cross-over trials
cluster_design_effect <- function(n_intervention, n_control, n_groups_intervention,n_groups_control,icc) {
  average_cluster_size <- (n_intervention + n_control)/(n_groups_intervention + n_groups_control)
  design_effect <- 1 + (average_cluster_size - 1) * icc
  return(design_effect)
}
cluster_binary_adjustment <- function(e_intervention, e_control, n_intervention, n_control, design_effect) {
  list(
    e_intervention/design_effect,
    e_control/design_effect,
    n_intervention/design_effect,
    n_control/design_effect
  )
}
cluster_continuous_adjustment <- function(n_intervention, n_control, design_effect) {
  list(
    n_intervention/design_effect,
    n_control/design_effect
  )
}
cluster_generic_se_adjustment <- function(se, design_effect) {
  se * design_effect^0.5
}
cross_over_sd_within_participant_differences_from_IPD <- function(database_path) {
  database <- data.frame(read.csv(database_path, header = TRUE, na.strings = ""))
  # First column = intervention, second column = control
  database$difference <- as.numeric(database[,1]) - as.numeric(database[,2])
  sd(database$difference)
}
cross_over_sd_within_participant_differences_from_summary <- function(sd_intervention, sd_control, correlation_coefficient) {
  # Source: Higgins JPT, Eldridge S, Li T (editors).
  # Chapter 23: Including variants on randomized trials. 
  # In: Higgins JPT, Thomas J, Chandler J, Cumpston M, Li T, Page MJ, Welch VA (editors). 
  # Cochrane Handbook for Systematic Reviews of Interventions version 6.4 (updated August 2023). Cochrane, 2023. 
  # Available from www.training.cochrane.org/handbook.
  (sd_intervention^2 + sd_control^2 - 
     2 * correlation_coefficient * sd_intervention * sd_control)^0.5
}
cross_over_MD_SE_from_summary_sd_diff <- function(mean_intervention, sd_intervention, mean_control, sd_control, n, sd_within_participant_differences) {
  # Source: Higgins JPT, Eldridge S, Li T (editors).
  # Chapter 23: Including variants on randomized trials. 
  # In: Higgins JPT, Thomas J, Chandler J, Cumpston M, Li T, Page MJ, Welch VA (editors). 
  # Cochrane Handbook for Systematic Reviews of Interventions version 6.4 (updated August 2023). Cochrane, 2023. 
  # Available from www.training.cochrane.org/handbook.
  md <- mean_intervention - mean_control
  se_md <- sd_within_participant_differences/(n)^0.5
  list(md = md, se_md = se_md)
}
cross_over_MD_SE_from_summary_icc <- function(mean_intervention, sd_intervention, mean_control, sd_control, n, correlation_coefficient) {
  # Source: Higgins JPT, Eldridge S, Li T (editors).
  # Chapter 23: Including variants on randomized trials. 
  # In: Higgins JPT, Thomas J, Chandler J, Cumpston M, Li T, Page MJ, Welch VA (editors). 
  # Cochrane Handbook for Systematic Reviews of Interventions version 6.4 (updated August 2023). Cochrane, 2023. 
  # Available from www.training.cochrane.org/handbook.
  md <- mean_intervention - mean_control
  sd_within_participant_differences <- (sd_intervention^2 + sd_control^2 - 
                                          2 * correlation_coefficient * sd_intervention * sd_control)^0.5
  se_md <- sd_within_participant_differences/(n)^0.5
  list(md = md, se_md = se_md)
}
cross_over_correlation_coefficient_from_sd <- function(sd_intervention, sd_control, sd_within_participant_differences) {
  # Source: Higgins JPT, Eldridge S, Li T (editors).
  # Chapter 23: Including variants on randomized trials. 
  # In: Higgins JPT, Thomas J, Chandler J, Cumpston M, Li T, Page MJ, Welch VA (editors). 
  # Cochrane Handbook for Systematic Reviews of Interventions version 6.4 (updated August 2023). Cochrane, 2023. 
  # Available from www.training.cochrane.org/handbook.
  ((sd_intervention)^2 + (sd_control)^2 - (sd_within_participant_differences)^2)/
    (2 * sd_intervention * sd_control)
}
# Functions for processing data
process_data <- function(DEF_path, StorageFolder) {
  # Initial processing ####
  DEF <- wb_load(DEF_path)
  generic_to_outcome_specific <- read.csv("generic_to_outcome_specific.csv", header = TRUE, na.strings = NA)
  outcome_specific_to_generic <- read.csv("outcome_specific_to_generic.csv", header = TRUE, na.strings = c(NA,""))
  rob_tools <- read.csv("rob_tools.csv", header = TRUE, na.strings = NA)
  rob_questions <- read.csv("rob_questions.csv", header = FALSE, na.strings = c(NA,""))
  field_names <- read_xlsx(DEF, "Revised_Template", col_names = TRUE)
  DEF_Design <- read_xlsx(DEF, "DEF_Design", col_names = TRUE)
  # Restrict this to the relevant fields in this review
  generic_to_outcome_specific <- generic_to_outcome_specific[
    ! is.na(match(generic_to_outcome_specific$destination, field_names$short_name))
    ,]
  data_unprocessed_1 <- data.frame(read_xlsx(DEF, "DataExtractionForm_First", col_names = TRUE, na.strings = ""))
  # drop the extra column
  data_unprocessed_1 <- data_unprocessed_1[,1:(ncol(data_unprocessed_1)-1)]
  colnames(data_unprocessed_1) <- field_names$short_name[1:ncol(data_unprocessed_1)]
  # drop the field labels, hyperlinks, and extra column
  data_unprocessed_1 <- data_unprocessed_1[4:nrow(data_unprocessed_1),2:ncol(data_unprocessed_1)]
  data_unprocessed_1[!is.na(data_unprocessed_1) & (data_unprocessed_1 == "NA")] <- NA 
  data_unprocessed_1 <- data_unprocessed_1[!is.na(data_unprocessed_1$study_id),]
  data_part_processed_1 <- data_unprocessed_1
  data_unprocessed_2 <- data.frame(read_xlsx(DEF, "DataExtractionForm_Second", col_names = TRUE, na.strings = ""))
  # drop the extra column
  data_unprocessed_2 <- data_unprocessed_2[,1:(ncol(data_unprocessed_2)-1)]
  colnames(data_unprocessed_2) <- field_names$short_name[1:ncol(data_unprocessed_2)]
  # drop the field labels, hyperlinks, and extra column
  data_unprocessed_2 <- data_unprocessed_2[4:nrow(data_unprocessed_2),2:ncol(data_unprocessed_2)]
  data_unprocessed_2[!is.na(data_unprocessed_2) & (data_unprocessed_2 == "NA")] <- NA 
  data_unprocessed_2 <- data_unprocessed_2[!is.na(data_unprocessed_2$study_id),]
  data_part_processed_2 <- data_unprocessed_2
  if (nrow(data_part_processed_1) > 0) {
    if (! is.na(match("intervention_1", DEF_Design$variable)) & ! is.na(match("intervention_1", DEF_Design$variable))) {
      data_part_processed_1$name_intervention_1 <- DEF_Design$variable_value[
        match("intervention_1", DEF_Design$variable)
      ]
      data_part_processed_1$short_name_intervention_1 <- DEF_Design$short_names[
        match("intervention_1", DEF_Design$variable)
      ]
      data_part_processed_1$name_intervention_2 <- DEF_Design$variable_value[
        match("intervention_2", DEF_Design$variable)
      ]
      data_part_processed_1$short_name_intervention_2 <- DEF_Design$short_names[
        match("intervention_2", DEF_Design$variable)
      ]
      data_part_processed_1$outcome_short_name <- DEF_Design$short_names[
        match(data_part_processed_1$outcome_name, DEF_Design$variable_value)
      ]
      data_part_processed_1$additional_name_intervention_1 <- paste0(
        data_part_processed_1$name_intervention_1, "_", data_part_processed_1$additional_name_intervention_1
      )
      data_part_processed_1$additional_short_name_intervention_1 <- paste0(
        data_part_processed_1$short_name_intervention_1, "_", data_part_processed_1$additional_short_name_intervention_1
      )
      data_part_processed_1$additional_name_intervention_2 <- paste0(
        data_part_processed_1$name_intervention_2, "_", data_part_processed_1$additional_name_intervention_2
      )
      data_part_processed_1$additional_short_name_intervention_2 <- paste0(
        data_part_processed_1$short_name_intervention_2, "_", data_part_processed_1$additional_short_name_intervention_2
      )
    } else {
      data_part_processed_1$name_intervention_1 <- data_part_processed_1$additional_name_intervention_1
      data_part_processed_1$short_name_intervention_1 <- data_part_processed_1$additional_short_name_intervention_1
      data_part_processed_1$name_intervention_2 <- data_part_processed_1$additional_name_intervention_2
      data_part_processed_1$short_name_intervention_2 <- data_part_processed_1$additional_short_name_intervention_2
    }
    data_part_processed_1$outcome_short_name <- DEF_Design$short_names[
      match(data_part_processed_1$outcome_name, DEF_Design$variable_value)
    ]
    data_part_processed_1$outcome_additional_name[
      is.na(data_part_processed_1$outcome_additional_name)
    ] <- data_part_processed_1$outcome_name[
      is.na(data_part_processed_1$outcome_additional_name)
    ]
    data_part_processed_1$outcome_additional_short_name[
      is.na(data_part_processed_1$outcome_additional_short_name)
    ] <- data_part_processed_1$outcome_short_name[
      is.na(data_part_processed_1$outcome_additional_short_name)
    ]
    data_part_processed_1$unique_outcome <- paste0(data_part_processed_1$study_id,'%_%',
                                                   data_part_processed_1$outcome_additional_short_name
    )
    data_part_processed_1 <- data_part_processed_1[
      match(unique(data_part_processed_1$unique_outcome), data_part_processed_1$unique_outcome)
      ,
    ]
  } else {
    data_part_processed_1 <- NULL
  }
  if (nrow(data_part_processed_2) > 0) {
    if (! is.na(match("intervention_1", DEF_Design$variable)) & ! is.na(match("intervention_1", DEF_Design$variable))) {
      data_part_processed_2$name_intervention_1 <- DEF_Design$variable_value[
        match("intervention_1", DEF_Design$variable)
      ]
      data_part_processed_2$short_name_intervention_1 <- DEF_Design$short_names[
        match("intervention_1", DEF_Design$variable)
      ]
      data_part_processed_2$name_intervention_2 <- DEF_Design$variable_value[
        match("intervention_2", DEF_Design$variable)
      ]
      data_part_processed_2$short_name_intervention_2 <- DEF_Design$short_names[
        match("intervention_2", DEF_Design$variable)
      ]
      data_part_processed_2$outcome_short_name <- DEF_Design$short_names[
        match(data_part_processed_2$outcome_name, DEF_Design$variable_value)
      ]
      data_part_processed_2$additional_name_intervention_1 <- paste0(
        data_part_processed_2$name_intervention_1, "_", data_part_processed_2$additional_name_intervention_1
      )
      data_part_processed_2$additional_short_name_intervention_1 <- paste0(
        data_part_processed_2$short_name_intervention_1, "_", data_part_processed_2$additional_short_name_intervention_1
      )
      data_part_processed_2$additional_name_intervention_2 <- paste0(
        data_part_processed_2$name_intervention_2, "_", data_part_processed_2$additional_name_intervention_2
      )
      data_part_processed_2$additional_short_name_intervention_2 <- paste0(
        data_part_processed_2$short_name_intervention_2, "_", data_part_processed_2$additional_short_name_intervention_2
      )
    } else {
      data_part_processed_2$name_intervention_1 <- data_part_processed_2$additional_name_intervention_1
      data_part_processed_2$short_name_intervention_1 <- data_part_processed_2$additional_short_name_intervention_1
      data_part_processed_2$name_intervention_2 <- data_part_processed_2$additional_name_intervention_2
      data_part_processed_2$short_name_intervention_2 <- data_part_processed_2$additional_short_name_intervention_2
    }
    data_part_processed_2$outcome_short_name <- DEF_Design$short_names[
      match(data_part_processed_2$outcome_name, DEF_Design$variable_value)
    ]
    data_part_processed_2$outcome_additional_name[
      is.na(data_part_processed_2$outcome_additional_name)
    ] <- data_part_processed_2$outcome_name[
      is.na(data_part_processed_2$outcome_additional_name)
    ]
    data_part_processed_2$outcome_additional_short_name[
      is.na(data_part_processed_2$outcome_additional_short_name)
    ] <- data_part_processed_2$outcome_short_name[
      is.na(data_part_processed_2$outcome_additional_short_name)
    ]
    data_part_processed_2$unique_outcome <- paste0(data_part_processed_2$study_id,'%_%',
                                                   data_part_processed_2$outcome_additional_short_name
    )
    data_part_processed_2 <- data_part_processed_2[
      match(unique(data_part_processed_2$unique_outcome), data_part_processed_2$unique_outcome)
      ,
    ]
  } else {
    data_part_processed_2 <- NULL
  }
  # Split and combine interventions ####
  split_combine_interventions <- function(study_id_column_name,database, textjoin_column_names, DEF_Design, field_names) {
    database <- data.frame(database)
    study_id_column <- match(study_id_column_name, colnames(database))
    unique_study_list <- sort(unique(database[,study_id_column]))
    combine_multiple_rows_each_study <- function (study_id, textjoin_column_names, database) {
      z <- sapply(
        1:ncol(database), 
        function(x) {
          if (is.na(match(colnames(database)[x], textjoin_column_names))) {
            sort(unique(database[
              (
                (database$study_id == study_id) &
                  (!is.na(database[,x])) &
                  (database[,x] != "")
              ), 
              x]))[1]
          } else {
            paste0(
              unique(database[
                (
                  (database$study_id == study_id) &
                    (!is.na(database[,x])) &
                    (database[,x] != "")
                ), 
                x]), 
              collapse = "; ")
          }
        }
      )
    }
    # First copy generic assessments to outcome-specific
    each_study <- lapply(
      1:length(unique_study_list),
      function(x) {
        combine_multiple_rows_each_study(unique_study_list[x], textjoin_column_names, database)
      }
    )
    each_study <- do.call(rbind.data.frame, each_study)
    colnames(each_study) <- colnames(database)
    generic_assessments_subjective <- 
      cbind.data.frame(
        each_study$study_id,
        each_study[, !is.na(match(colnames(each_study), generic_to_outcome_specific$subjective_source))]
      )
    generic_assessments_objective <- 
      cbind.data.frame(
        each_study$study_id,
        each_study[, !is.na(match(colnames(each_study), generic_to_outcome_specific$objective_source))]
      )
    database$outcome_type_2[
      ! is.na(database$outcome_name)
    ] <- DEF_Design$objective_subjective[
      match(
        database$outcome_name[
          ! is.na(database$outcome_name)
        ],
        DEF_Design$variable_value
      )
    ]
    outcome_level <- database[,! is.na(match(colnames(database),
                                             generic_to_outcome_specific$destination
    ))
    ]
    outcome_level <- outcome_level[generic_to_outcome_specific$destination]
    outcome_level <- cbind.data.frame(
      study_id = database[,study_id_column],
      outcome_level
    )
    for (i in 1:nrow(outcome_level)) {
      if (database$outcome_type_2[i] == "objective") {
        outcome_level[i, is.na(outcome_level[i,])] <- generic_assessments_objective[
          match(outcome_level[i,1], generic_assessments_objective[,1])
          ,is.na(outcome_level[i,])]
      } else {
        outcome_level[i, is.na(outcome_level[i,])] <- generic_assessments_subjective[
          match(outcome_level[i,1], generic_assessments_subjective[,1])
          ,is.na(outcome_level[i,])]
      }
    }
    database_filled <- 
      cbind.data.frame(
        database[
          , is.na(match(colnames(database),
                        generic_to_outcome_specific$destination
          ))
        ],
        outcome_level[,2:ncol(outcome_level)]
      )
    database_filled <- database_filled[colnames(database)]
    database <- database_filled
    old_column_names <- colnames(database)
    new_column_names <- old_column_names[
      (substring(old_column_names,
                 nchar(old_column_names) - 14,
                 nchar(old_column_names)
      ) 
      != "_intervention_2")
    ]
    new_column_names[
      (substring(new_column_names,
                 nchar(new_column_names) - 14,
                 nchar(new_column_names)
      ) == "_intervention_1")
    ] <- substring(new_column_names[
      (substring(new_column_names,
                 nchar(new_column_names) - 14,
                 nchar(new_column_names)
      ) == "_intervention_1")
    ],
    1,
    (nchar(new_column_names[
      (substring(new_column_names,
                 nchar(new_column_names) - 14,
                 nchar(new_column_names)
      ) == "_intervention_1")
    ]) - 15)
    )
    # common fields
    common_fields <- database[,
                              ! is.na(match(old_column_names, new_column_names))
    ]
    intervention_1 <- database[
      , (substring(old_column_names,
                   nchar(old_column_names) - 14,
                   nchar(old_column_names)
      ) 
      == "_intervention_1")
    ]
    colnames(intervention_1) <- str_remove_all(colnames(intervention_1),"_intervention_1")
    intervention_2 <- database[
      , (substring(old_column_names,
                   nchar(old_column_names) - 14,
                   nchar(old_column_names)
      ) 
      == "_intervention_2")
    ]
    colnames(intervention_2) <- str_remove_all(colnames(intervention_2),"_intervention_2")
    # The other characteristics may be missing from intervention_2 if this was at study-level
    missing_columns = setdiff(colnames(intervention_1), colnames(intervention_2))
    missing_columns_df <- data.frame(matrix(nrow = nrow(intervention_2), ncol = length(missing_columns)))
    colnames(missing_columns_df) <- missing_columns
    intervention_2 <- cbind.data.frame(
      intervention_2,
      missing_columns_df
    )
    intervention_1 <- cbind.data.frame(
      common_fields, intervention_1
    )
    intervention_2 <- cbind.data.frame(
      common_fields, intervention_2
    )
    database_long <- rbind.data.frame(
      intervention_1,
      intervention_2
    )
    database_long <- database_long[,match(new_column_names, colnames(database_long))]
    database_long <- database_long[order(database_long[,study_id_column]),]
    # Now combine multiple interventions into single row
    # To get the column order for this, some steps are necessary
    interventions_list <- unique(database_long$additional_short_name)
    column_order <- data.frame(new_column_names)
    column_order$sort_column <- 1:nrow(column_order)
    column_order$sub_section <- field_names$sub_section[
      match(column_order$new_column_names, field_names$short_name)
    ] 
    column_order$section <- field_names$section[
      match(column_order$new_column_names, field_names$short_name)
    ] 
    column_order$sub_section[is.na(column_order$sub_section)] <- field_names$sub_section[
      match(
        paste0(
          column_order$new_column_names[is.na(column_order$sub_section)], "_intervention_1"
        ), 
        field_names$short_name)
    ]
    column_order$section[is.na(column_order$section)] <- field_names$section[
      match(
        paste0(
          column_order$new_column_names[is.na(column_order$section)], "_intervention_1"
        ), 
        field_names$short_name)
    ]
    column_all_interventions <- lapply(
      1:length(interventions_list),
      function(x){
        cbind.data.frame(
          new_column_names = paste0(column_order$new_column_names[
            is.na(match(new_column_names, old_column_names))
          ], "_",interventions_list[x]),
          sort_column = column_order$sort_column[
            is.na(match(new_column_names, old_column_names))
          ] + x/(1000*1000),
          sub_section = column_order$sub_section[
            is.na(match(new_column_names, old_column_names))
          ],
          section = column_order$section[
            is.na(match(new_column_names, old_column_names))
          ]
        )
      }
    )
    column_order <- rbind.data.frame(
      column_order[
        ! is.na(match(new_column_names, old_column_names))
        ,],
      do.call(rbind.data.frame, column_all_interventions)
    )
    column_order <- column_order[order(column_order$sort_column),]
    column_order$outcome_level <- (
      (! is.na(match(column_order$section, "outcome"))) | 
        (! is.na(match(column_order$sub_section, 
                       c("rob_outcome_level",
                         "rob2_ITT_outcome",
                         "rob2_PP_outcome",
                         "rob2_outcome",
                         "rob2_cluster_ITT_outcome",
                         "rob2_cluster_PP_outcome",
                         "rob2_cluster_outcome",
                         "rob2_cross_over_ITT_outcome",
                         "rob2_cross_over_PP_outcome",
                         "rob2_cross_over_outcome",
                         "robins_i_ITT_outcome",
                         "robins_i_PP_outcome",
                         "robins_i_outcome"
                       )
        ))) |
        (column_order$new_column_names == "outcome_short_name")
    )
    data_wide <- tidyr::pivot_wider(
      data = database_long,
      names_from = c("additional_short_name"),
      values_from = new_column_names[is.na(match(new_column_names, old_column_names))]
    )
    data_wide <- data_wide[,order(match(colnames(data_wide), column_order$new_column_names))]
    outcomes_list <- unique(database_long$outcome_additional_short_name)
    intervention_outcome <- column_order[column_order$outcome_level == TRUE, 1:2]
    intervention_outcome_all_outcomes <- lapply(1:length(outcomes_list),
                                                function(x){
                                                  cbind.data.frame(
                                                    new_column_names = paste0(intervention_outcome$new_column_names, "_",outcomes_list[x]),
                                                    sort_column = intervention_outcome$sort_column+x/(1000)
                                                  )
                                                }
    )
    intervention_outcome_final <- do.call(rbind.data.frame,intervention_outcome_all_outcomes)
    # Add the ones which are not outcome specific
    intervention_outcome_final <- rbind.data.frame(
      column_order[column_order$outcome_level == FALSE, 1:2],
      intervention_outcome_final
    )
    intervention_outcome_final <- intervention_outcome_final[order(intervention_outcome_final$sort_column),]
    data_wide_2 <- tidyr::pivot_wider(
      data = data_wide,
      names_from = "outcome_additional_short_name",
      values_from = intervention_outcome$new_column_names
    )
    data_wide_2 <- data.frame(data_wide_2[intervention_outcome_final$new_column_names])
    # now combine the multiple rows
    # Most rows are keep the unique values, the exception is record_id, but to keep this generic in case we want to change, get the "textjoin" columns as part of the function and the remaining are all unique
    each_study <- lapply(
      1:length(unique_study_list),
      function(x) {
        combine_multiple_rows_each_study(unique_study_list[x], textjoin_column_names, data_wide_2)
      }
    )
    rows_combined <- do.call(rbind.data.frame, each_study)
    colnames(rows_combined) <- colnames(data_wide_2)
    return(rows_combined)
  }
  # RoB classification ####
  rob_classification <- function(database, database_unprocessed, database_part_processed) {
    column_names <- colnames(database)
    rob_fields_generic <- field_names[
      (
        (substr(field_names$section,1,3) == "rob") &
          ( 
            (
              (substr(field_names$sub_section, nchar(field_names$sub_section)-7, nchar(field_names$sub_section)) == "_generic") & 
                (substr(field_names$short_name,nchar(field_names$short_name) - 14, nchar(field_names$short_name)) == "_classification")
            ) |
              (
                (field_names$short_name == "robins_i_domain_1") |
                  (field_names$short_name == "robins_i_domain_2") |
                  (field_names$short_name == "robins_i_domain_3")
              )
          )
      )
      ,]
    rob_fields_outcome <- field_names[
      (
        (substr(field_names$section,1,3) == "rob") &
          ( 
            (
              (substr(field_names$sub_section, nchar(field_names$sub_section)-7, nchar(field_names$sub_section)) == "_outcome") & 
                (substr(field_names$short_name,nchar(field_names$short_name) - 14, nchar(field_names$short_name)) == "_classification")
            ) |
              (
                (field_names$section == "robins_i") &
                  (substr(field_names$sub_section, nchar(field_names$sub_section)-7, nchar(field_names$sub_section)) == "_outcome")
              )
          )
      )
      ,]
    rob_fields_outcome <- rob_fields_outcome[
      (substr(rob_fields_outcome$short_name,nchar(rob_fields_outcome$short_name) - 8, nchar(rob_fields_outcome$short_name)) != "_comments") & 
        (substr(rob_fields_outcome$short_name,nchar(rob_fields_outcome$short_name) - 6, nchar(rob_fields_outcome$short_name)) != "_quotes")
      ,]
    outcomes_full_names <- paste0(database_unprocessed$outcome_type_2,"%_%",database_unprocessed$outcome_name)
    outcomes_full_names[! is.na(database_unprocessed$outcome_additional_name)] <- paste0(
      outcomes_full_names[! is.na(database_unprocessed$outcome_additional_name)], "_",
      database_unprocessed$outcome_additional_name[! is.na(database_unprocessed$outcome_additional_name)]
    )
    outcomes_full_names <- unique(outcomes_full_names)
    outcomes_objective_subjective <- as.vector(sapply(
      1:length(outcomes_full_names), 
      function(x) {
        substr(outcomes_full_names[x],1,str_locate(outcomes_full_names[x], "%_%")[1]-1)
      }
    ))
    outcomes_full_names <- str_remove_all(outcomes_full_names, paste0(outcomes_objective_subjective, "%_%"))
    outcomes_list <- unique(database_part_processed$outcome_additional_short_name)
    rob_data_each_outcome <- lapply(1:length(outcomes_list),
                                    function(x) {
                                      rob_fields_outcome$short_name <- paste0(
                                        rob_fields_outcome$short_name, "_", outcomes_list[x]
                                      )
                                      rob_data <- cbind.data.frame(
                                        study_id = database$study_id,
                                        study_type = database$study_type,
                                        outcome_name = rep(outcomes_full_names[x], length(database$study_id)),
                                        outcome_type = rep(outcomes_objective_subjective[x], length(database$study_id)),
                                        database[rob_fields_generic$short_name],
                                        database[rob_fields_outcome$short_name]
                                      )
                                      colnames(rob_data) <- str_remove_all(colnames(rob_data), paste0("_", outcomes_list[x]))
                                      rob_data <- rob_data[c("study_id", "study_type", "outcome_name", "outcome_type",
                                                             sort(colnames(rob_data)[5:ncol(rob_data)]))]
                                      colnames(rob_data) <- c(
                                        "study_id", "study_type", "outcome_name","outcome_type",
                                        paste0(
                                          rob_tools$tool[
                                            match(colnames(rob_data)[5:ncol(rob_data)],
                                                  rob_tools$short_name
                                            )
                                          ],
                                          "_",
                                          rob_tools$question[
                                            match(colnames(rob_data)[5:ncol(rob_data)],
                                                  rob_tools$short_name
                                            )
                                          ]
                                        )
                                      )
                                      # ROB2 domain 1 ####
                                      rob_data$rob2_domain_1[
                                        ((rob_data$rob2_1.2 == "N = No") | 
                                           (rob_data$rob2_1.2 == "PN = Probably No")) |
                                          ((rob_data$rob2_1.3 == "Y = Yes") | 
                                             (rob_data$rob2_1.3 == "PY = Probably Yes"))
                                      ] <- "High risk" 
                                      rob_data$rob2_domain_1[
                                        is.na(rob_data$rob2_domain_1) & 
                                          ((rob_data$rob2_1.2 == "Y = Yes") | 
                                             (rob_data$rob2_1.2 == "PY = Probably Yes")) & 
                                          ((rob_data$rob2_1.1 == "Y = Yes") | 
                                             (rob_data$rob2_1.1 == "PY = Probably Yes") | 
                                             (rob_data$rob2_1.1 == "NI = No Information")) &
                                          ((rob_data$rob2_1.3 == "N = No") | 
                                             (rob_data$rob2_1.3 == "PN = Probably No") | 
                                             (rob_data$rob2_1.3 == "NI = No Information"))
                                      ] <- "Low risk"
                                      rob_data$rob2_domain_1[
                                        is.na(rob_data$rob2_domain_1)
                                      ] <- "Some concerns"
                                      # ROB2 domain 2 (ITT) ####
                                      rob_data$rob2_domain_2_ITT[
                                        ((((rob_data$rob2_2.1_ITT == "N = No") | 
                                             (rob_data$rob2_2.1_ITT == "PN = Probably No")) &
                                            ((rob_data$rob2_2.2_ITT == "N = No") | 
                                               (rob_data$rob2_2.2_ITT == "PN = Probably No"))) |
                                           ((rob_data$rob2_2.3_ITT == "N = No") | 
                                              (rob_data$rob2_2.3_ITT == "PN = Probably No"))) &
                                          ((rob_data$rob2_2.6_ITT == "Y = Yes") | 
                                             (rob_data$rob2_2.6_ITT == "PY = Probably Yes"))
                                      ] <- "Low risk" 
                                      rob_data$rob2_domain_2_ITT[
                                        is.na(rob_data$rob2_domain_2_ITT) &
                                          (
                                            (
                                              ((rob_data$rob2_2.3_ITT == "Y = Yes") | 
                                                 (rob_data$rob2_2.3_ITT == "PY = Probably Yes")) &
                                                ((rob_data$rob2_2.4_ITT == "Y = Yes") | 
                                                   (rob_data$rob2_2.4_ITT == "PY = Probably Yes") | 
                                                   (rob_data$rob2_2.4_ITT == "NI = No Information")) &
                                                ((rob_data$rob2_2.5_ITT == "N = No") | 
                                                   (rob_data$rob2_2.5_ITT == "PN = Probably No") | 
                                                   (rob_data$rob2_2.5_ITT == "NI = No Information"))
                                            ) |
                                              ((rob_data$rob2_2.7_ITT == "Y = Yes") | 
                                                 (rob_data$rob2_2.7_ITT == "PY = Probably Yes") | 
                                                 (rob_data$rob2_2.7_ITT == "NI = No Information"))
                                          )
                                      ] <- "High risk" 
                                      rob_data$rob2_domain_2_ITT[
                                        is.na(rob_data$rob2_domain_2_ITT)
                                      ] <- "Some concerns"
                                      # ROB2 domain 2 (PP) #### 
                                      if (DEF_Design$variable_value[
                                        match("per_protocol", DEF_Design$variable)
                                      ] == "yes") {
                                        ####
                                        rob_data$rob2_domain_2_PP[
                                          (
                                            (
                                              ((rob_data$rob2_2.1_PP == "N = No") | 
                                                 (rob_data$rob2_2.1_PP == "PN = Probably No")) &
                                                ((rob_data$rob2_2.2_PP == "N = No") | 
                                                   (rob_data$rob2_2.2_PP == "PN = Probably No"))
                                            ) | 
                                              ((rob_data$rob2_2.3_PP == "Y = Yes") | 
                                                 (rob_data$rob2_2.3_PP == "PY = Probably Yes") | 
                                                 (rob_data$rob2_2.3_PP == "NA = Not Applicable"))
                                          ) &
                                            ((rob_data$rob2_2.4_PP == "N = No") | 
                                               (rob_data$rob2_2.4_PP == "PN = Probably No") | 
                                               (rob_data$rob2_2.4_PP == "NA = Not Applicable")) &
                                            ((rob_data$rob2_2.5_PP == "N = No") | 
                                               (rob_data$rob2_2.5_PP == "PN = Probably No") | 
                                               (rob_data$rob2_2.5_PP == "NA = Not Applicable"))
                                        ] <- "Low risk"
                                        rob_data$rob2_domain_2_PP[
                                          is.na(rob_data$rob2_domain_2_PP) &
                                            (
                                              ((rob_data$rob2_2.3_PP == "N = No") | 
                                                 (rob_data$rob2_2.3_PP == "PN = Probably No") | 
                                                 (rob_data$rob2_2.3_PP == "NI = No Information")) | 
                                                ((rob_data$rob2_2.4_PP == "Y = Yes") | 
                                                   (rob_data$rob2_2.4_PP == "PY = Probably Yes") | 
                                                   (rob_data$rob2_2.4_PP == "NI = No Information")) |
                                                ((rob_data$rob2_2.5_PP == "Y = Yes") | 
                                                   (rob_data$rob2_2.5_PP == "PY = Probably Yes") | 
                                                   (rob_data$rob2_2.5_PP == "NI = No Information"))
                                            ) &
                                            ((rob_data$rob2_2.6_PP == "N = No") | 
                                               (rob_data$rob2_2.6_PP == "PN = Probably No") | 
                                               (rob_data$rob2_2.6_PP == "NI = No Information"))
                                        ] <- "High risk"
                                        rob_data$rob2_domain_2_PP[
                                          is.na(rob_data$rob2_domain_2_PP)
                                        ] <- "Some concerns"
                                      }
                                      # ROB2 domain 3 ####
                                      rob_data$rob2_domain_3[
                                        ((rob_data$rob2_3.1 == "Y = Yes") | 
                                           (rob_data$rob2_3.1 == "PY = Probably Yes")) |
                                          ((rob_data$rob2_3.2 == "Y = Yes") | 
                                             (rob_data$rob2_3.2 == "PY = Probably Yes")) |
                                          ((rob_data$rob2_3.3 == "N = No") | 
                                             (rob_data$rob2_3.3 == "PN = Probably No"))
                                      ] <- "Low risk"
                                      rob_data$rob2_domain_3[
                                        is.na(rob_data$rob2_domain_3) &
                                          ((rob_data$rob2_3.1 == "N = No") | 
                                             (rob_data$rob2_3.1 == "PN = Probably No") | 
                                             (rob_data$rob2_3.1 == "NI = No Information")) & 
                                          ((rob_data$rob2_3.2 == "N = No") | 
                                             (rob_data$rob2_3.2 == "PN = Probably No")) &
                                          ((rob_data$rob2_3.3 == "Y = Yes") | 
                                             (rob_data$rob2_3.3 == "PY = Probably Yes") | 
                                             (rob_data$rob2_3.3 == "NI = No Information")) &
                                          ((rob_data$rob2_3.4 == "Y = Yes") | 
                                             (rob_data$rob2_3.4 == "PY = Probably Yes") | 
                                             (rob_data$rob2_3.4 == "NI = No Information"))
                                      ] <- "High risk"
                                      rob_data$rob2_domain_3[
                                        is.na(rob_data$rob2_domain_3)
                                      ] <- "Some concerns"
                                      # ROB2 domain 4 ####
                                      rob_data$rob2_domain_4[
                                        ((rob_data$rob2_4.1 == "N = No") | 
                                           (rob_data$rob2_4.1 == "PN = Probably No") | 
                                           (rob_data$rob2_4.1 == "NI = No Information")) & 
                                          ((rob_data$rob2_4.2 == "N = No") | 
                                             (rob_data$rob2_4.2 == "PN = Probably No")) &
                                          (((rob_data$rob2_4.3 == "N = No") | 
                                              (rob_data$rob2_4.3 == "PN = Probably No")) |
                                             (((rob_data$rob2_4.3 == "Y = Yes") | 
                                                 (rob_data$rob2_4.3 == "PY = Probably Yes") | 
                                                 (rob_data$rob2_4.3 == "NI = No Information")) &
                                                ((rob_data$rob2_4.4 == "N = No") | 
                                                   (rob_data$rob2_4.4 == "PN = Probably No"))))
                                      ] <- "Low risk"
                                      rob_data$rob2_domain_4[
                                        is.na(rob_data$rob2_domain_4) &
                                          ((rob_data$rob2_4.1 == "N = No") | 
                                             (rob_data$rob2_4.1 == "PN = Probably No") | 
                                             (rob_data$rob2_4.1 == "NI = No Information")) &
                                          (  
                                            (((rob_data$rob2_4.2 == "N = No") | 
                                                (rob_data$rob2_4.2 == "PN = Probably No")) &
                                               (
                                                 (((rob_data$rob2_4.3 == "Y = Yes") | 
                                                     (rob_data$rob2_4.3 == "PY = Probably Yes") | 
                                                     (rob_data$rob2_4.3 == "NI = No Information")) &
                                                    ((rob_data$rob2_4.4 == "Y = Yes") | 
                                                       (rob_data$rob2_4.4 == "PY = Probably Yes") | 
                                                       (rob_data$rob2_4.4 == "NI = No Information")) &
                                                    ((rob_data$rob2_4.5 == "N = No") | 
                                                       (rob_data$rob2_4.5 == "PN = Probably No"))
                                                 )
                                               )
                                            ) |
                                              (((rob_data$rob2_4.2 == "NI = No Information")) &
                                                 (
                                                   ((rob_data$rob2_4.3 == "N = No") | 
                                                      (rob_data$rob2_4.3 == "PN = Probably No")) |
                                                     (((rob_data$rob2_4.3 == "Y = Yes") | 
                                                         (rob_data$rob2_4.3 == "PY = Probably Yes") | 
                                                         (rob_data$rob2_4.3 == "NI = No Information")) &
                                                        (
                                                          ((rob_data$rob2_4.4 == "N = No") | 
                                                             (rob_data$rob2_4.4 == "PN = Probably No")) |
                                                            (((rob_data$rob2_4.4 == "Y = Yes") | 
                                                                (rob_data$rob2_4.4 == "PY = Probably Yes") | 
                                                                (rob_data$rob2_4.4 == "NI = No Information")) &
                                                               ((rob_data$rob2_4.5 == "N = No") | 
                                                                  (rob_data$rob2_4.5 == "PN = Probably No")))
                                                        )
                                                     )
                                                 )
                                              )
                                          )
                                      ] <- "Some concerns"
                                      rob_data$rob2_domain_4[
                                        is.na(rob_data$rob2_domain_4)
                                      ] <- "High risk"
                                      # ROB2 domain 5 ####
                                      rob_data$rob2_domain_5[
                                        ((rob_data$rob2_5.2 == "Y = Yes") | 
                                           (rob_data$rob2_5.2 == "PY = Probably Yes")) |
                                          ((rob_data$rob2_5.3 == "Y = Yes") | 
                                             (rob_data$rob2_5.3 == "PY = Probably Yes"))
                                      ] <- "High risk" 
                                      rob_data$rob2_domain_5[
                                        is.na(rob_data$rob2_domain_5) & 
                                          ((rob_data$rob2_5.2 == "N = No") | 
                                             (rob_data$rob2_5.2 == "PN = Probably No")) &
                                          ((rob_data$rob2_5.3 == "N = No") | 
                                             (rob_data$rob2_5.3 == "PN = Probably No")) &
                                          ((rob_data$rob2_5.1 == "Y = Yes") | 
                                             (rob_data$rob2_5.1 == "PY = Probably Yes"))
                                      ] <- "Low risk"
                                      rob_data$rob2_domain_5[
                                        is.na(rob_data$rob2_domain_5) 
                                      ] <- "Some concerns"
                                      # ROB2 overall ####
                                      rob_data$rob2_overall <- 
                                        as.character(sapply(1:nrow(rob_data), function(y) {
                                          if (
                                            !is.na(match("High risk", 
                                                         c(
                                                           rob_data$rob2_domain_1[y],
                                                           rob_data$rob2_domain_2_ITT[y],
                                                           if (DEF_Design$variable_value[
                                                             match("per_protocol", DEF_Design$variable)
                                                           ] == "yes") {
                                                             rob_data$rob2_domain_2_PP[y]
                                                           },
                                                           rob_data$rob2_domain_3[y],
                                                           rob_data$rob2_domain_4[y],
                                                           rob_data$rob2_domain_5[y]
                                                         )))
                                          ) {
                                            "High risk of bias"
                                          } else if (
                                            !is.na(match("Some concerns", 
                                                         c(
                                                           rob_data$rob2_domain_1[y],
                                                           rob_data$rob2_domain_2_ITT[y],
                                                           if (DEF_Design$variable_value[
                                                             match("per_protocol", DEF_Design$variable)
                                                           ] == "yes") {
                                                             rob_data$rob2_domain_2_PP[y]
                                                           },
                                                           rob_data$rob2_domain_3[y],
                                                           rob_data$rob2_domain_4[y],
                                                           rob_data$rob2_domain_5[y]
                                                         )))
                                          ) {
                                            "Some concerns"
                                          } else {
                                            "Low risk of bias"
                                          }
                                        }))
                                      # ROB2 cluster ####
                                      if (DEF_Design$variable_value[
                                        match("cluster", DEF_Design$variable)
                                      ] == "yes") {
                                        # ROB2 cluster domain 1 ####
                                        rob_data$rob2_cluster_domain_1[
                                          ((rob_data$rob2_cluster_1a.2 == "N = No") | 
                                             (rob_data$rob2_cluster_1a.2 == "PN = Probably No")) |
                                            ((rob_data$rob2_cluster_1a.3 == "Y = Yes") | 
                                               (rob_data$rob2_cluster_1a.3 == "PY = Probably Yes")) |
                                            ((rob_data$rob2_cluster_1b.2 == "Y = Yes") | 
                                               (rob_data$rob2_cluster_1b.2 == "PY = Probably Yes")) |
                                            (
                                              (rob_data$rob2_cluster_1b.2 == "NI = No Information") & 
                                                ((rob_data$rob2_cluster_1b.3 == "Y = Yes") | 
                                                   (rob_data$rob2_cluster_1b.3 == "PY = Probably Yes"))
                                            )
                                        ] <- "High risk" 
                                        rob_data$rob2_cluster_domain_1[
                                          is.na(rob_data$rob2_cluster_domain_1) & 
                                            ((rob_data$rob2_cluster_1a.2 == "Y = Yes") | 
                                               (rob_data$rob2_cluster_1a.2 == "PY = Probably Yes")) & 
                                            ((rob_data$rob2_cluster_1a.1 == "Y = Yes") | 
                                               (rob_data$rob2_cluster_1a.1 == "PY = Probably Yes") | 
                                               (rob_data$rob2_cluster_1a.1 == "NI = No Information")) &
                                            ((rob_data$rob2_cluster_1a.3 == "N = No") | 
                                               (rob_data$rob2_cluster_1a.3 == "PN = Probably No") | 
                                               (rob_data$rob2_cluster_1a.3 == "NI = No Information")) & 
                                            ((rob_data$rob2_cluster_1b.1 == "Y = Yes") | 
                                               (rob_data$rob2_cluster_1b.1 == "PY = Probably Yes"))
                                        ] <- "Low risk"
                                        rob_data$rob2_cluster_domain_1[
                                          is.na(rob_data$rob2_cluster_domain_1)
                                        ] <- "Some concerns"
                                        # ROB2 cluster domain 2 (ITT) ####
                                        rob_data$rob2_cluster_domain_2_ITT[
                                          (
                                            (
                                              ((rob_data$rob2_cluster_2.1a_ITT == "N = No") | 
                                                 (rob_data$rob2_cluster_2.1a_ITT == "PN = Probably No")) &
                                                ((rob_data$rob2_cluster_2.2_ITT == "N = No") | 
                                                   (rob_data$rob2_cluster_2.2_ITT == "PN = Probably No"))
                                            ) |
                                              (
                                                ((rob_data$rob2_cluster_2.1b_ITT == "N = No") | 
                                                   (rob_data$rob2_cluster_2.1b_ITT == "PN = Probably No")) &
                                                  ((rob_data$rob2_cluster_2.2_ITT == "N = No") | 
                                                     (rob_data$rob2_cluster_2.2_ITT == "PN = Probably No"))
                                              ) |
                                              ((rob_data$rob2_cluster_2.3_ITT == "N = No") | 
                                                 (rob_data$rob2_cluster_2.3_ITT == "PN = Probably No"))
                                          ) &
                                            (
                                              (rob_data$rob2_cluster_2.6_ITT == "Y = Yes") | 
                                                (rob_data$rob2_cluster_2.6_ITT == "PY = Probably Yes")
                                            )
                                        ] <- "Low risk" 
                                        rob_data$rob2_cluster_domain_2_ITT[
                                          is.na(rob_data$rob2_cluster_domain_2_ITT) &
                                            (
                                              (
                                                (
                                                  (rob_data$rob2_cluster_2.1a_ITT == "Y = Yes") | 
                                                    (rob_data$rob2_cluster_2.1a_ITT == "PY = Probably Yes") |
                                                    (rob_data$rob2_cluster_2.1a_ITT == "NI = No Information")
                                                ) &
                                                  (
                                                    (
                                                      (rob_data$rob2_cluster_2.1b_ITT == "Y = Yes") | 
                                                        (rob_data$rob2_cluster_2.1b_ITT == "PY = Probably Yes") | 
                                                        (rob_data$rob2_cluster_2.1b_ITT == "NI = No Information")
                                                    ) |
                                                      (
                                                        (rob_data$rob2_cluster_2.2_ITT == "Y = Yes") | 
                                                          (rob_data$rob2_cluster_2.2_ITT == "PY = Probably Yes")| 
                                                          (rob_data$rob2_cluster_2.2_ITT == "NI = No Information")
                                                      )
                                                  ) &
                                                  ((rob_data$rob2_cluster_2.3_ITT == "Y = Yes") | 
                                                     (rob_data$rob2_cluster_2.3_ITT == "PY = Probably Yes")) &
                                                  ((rob_data$rob2_cluster_2.4_ITT == "Y = Yes") | 
                                                     (rob_data$rob2_cluster_2.4_ITT == "PY = Probably Yes") | 
                                                     (rob_data$rob2_cluster_2.4_ITT == "NI = No Information")) &
                                                  ((rob_data$rob2_cluster_2.5_ITT == "N = No") | 
                                                     (rob_data$rob2_cluster_2.5_ITT == "PN = Probably No") | 
                                                     (rob_data$rob2_cluster_2.5_ITT == "NI = No Information"))
                                              ) |
                                                (
                                                  (rob_data$rob2_cluster_2.7_ITT == "Y = Yes") | 
                                                    (rob_data$rob2_cluster_2.7_ITT == "PY = Probably Yes") | 
                                                    (rob_data$rob2_cluster_2.7_ITT == "NI = No Information")
                                                )
                                            )
                                        ] <- "High risk" 
                                        rob_data$rob2_cluster_domain_2_ITT[
                                          is.na(rob_data$rob2_cluster_domain_2_ITT)
                                        ] <- "Some concerns"
                                        # ROB2 cluster domain 2 (PP) #### 
                                        if (DEF_Design$variable_value[
                                          match("per_protocol", DEF_Design$variable)
                                        ] == "yes") {
                                          ####
                                          rob_data$rob2_cluster_domain_2_PP[
                                            (
                                              (
                                                ((rob_data$rob2_cluster_2.1_PP == "N = No") | 
                                                   (rob_data$rob2_cluster_2.1_PP == "PN = Probably No")) &
                                                  ((rob_data$rob2_cluster_2.2_PP == "N = No") | 
                                                     (rob_data$rob2_cluster_2.2_PP == "PN = Probably No"))
                                              ) | 
                                                ((rob_data$rob2_cluster_2.3_PP == "Y = Yes") | 
                                                   (rob_data$rob2_cluster_2.3_PP == "PY = Probably Yes") | 
                                                   (rob_data$rob2_cluster_2.3_PP == "NA = Not Applicable"))
                                            ) &
                                              ((rob_data$rob2_cluster_2.4_PP == "N = No") | 
                                                 (rob_data$rob2_cluster_2.4_PP == "PN = Probably No") | 
                                                 (rob_data$rob2_cluster_2.4_PP == "NA = Not Applicable")) &
                                              ((rob_data$rob2_cluster_2.5_PP == "N = No") | 
                                                 (rob_data$rob2_cluster_2.5_PP == "PN = Probably No") | 
                                                 (rob_data$rob2_cluster_2.5_PP == "NA = Not Applicable"))
                                          ] <- "Low risk"
                                          rob_data$rob2_cluster_domain_2_PP[
                                            is.na(rob_data$rob2_cluster_domain_2_PP) &
                                              (
                                                ((rob_data$rob2_cluster_2.3_PP == "N = No") | 
                                                   (rob_data$rob2_cluster_2.3_PP == "PN = Probably No") | 
                                                   (rob_data$rob2_cluster_2.3_PP == "NI = No Information")) | 
                                                  ((rob_data$rob2_cluster_2.4_PP == "Y = Yes") | 
                                                     (rob_data$rob2_cluster_2.4_PP == "PY = Probably Yes") | 
                                                     (rob_data$rob2_cluster_2.4_PP == "NI = No Information")) |
                                                  ((rob_data$rob2_cluster_2.5_PP == "Y = Yes") | 
                                                     (rob_data$rob2_cluster_2.5_PP == "PY = Probably Yes") | 
                                                     (rob_data$rob2_cluster_2.5_PP == "NI = No Information"))
                                              ) &
                                              ((rob_data$rob2_cluster_2.6_PP == "N = No") | 
                                                 (rob_data$rob2_cluster_2.6_PP == "PN = Probably No") | 
                                                 (rob_data$rob2_cluster_2.6_PP == "NI = No Information"))
                                          ] <- "High risk"
                                          rob_data$rob2_cluster_domain_2_PP[
                                            is.na(rob_data$rob2_cluster_domain_2_PP)
                                          ] <- "Some concerns"
                                        }
                                        # ROB2 cluster domain 3 ####
                                        rob_data$rob2_cluster_domain_3[
                                          (
                                            ((rob_data$rob2_cluster_3.1a == "Y = Yes") | 
                                               (rob_data$rob2_cluster_3.1a == "PY = Probably Yes")) & 
                                              ((rob_data$rob2_cluster_3.1b == "Y = Yes") | 
                                                 (rob_data$rob2_cluster_3.1b == "PY = Probably Yes"))
                                          )|
                                            (
                                              (rob_data$rob2_cluster_3.2 == "Y = Yes") | 
                                                (rob_data$rob2_cluster_3.2 == "PY = Probably Yes")
                                            ) |
                                            (
                                              (rob_data$rob2_cluster_3.3 == "N = No") | 
                                                (rob_data$rob2_cluster_3.3 == "PN = Probably No")
                                            )
                                        ] <- "Low risk"
                                        rob_data$rob2_cluster_domain_3[
                                          is.na(rob_data$rob2_cluster_domain_3) &
                                            (
                                              (
                                                (rob_data$rob2_cluster_3.1a == "N = No") | 
                                                  (rob_data$rob2_cluster_3.1a == "PN = Probably No") | 
                                                  (rob_data$rob2_cluster_3.1a == "NI = No Information")
                                              ) |
                                                (
                                                  (rob_data$rob2_cluster_3.1b == "N = No") | 
                                                    (rob_data$rob2_cluster_3.1b == "PN = Probably No") | 
                                                    (rob_data$rob2_cluster_3.1b == "NI = No Information")
                                                )
                                            ) & 
                                            (
                                              (rob_data$rob2_cluster_3.2 == "N = No") | 
                                                (rob_data$rob2_cluster_3.2 == "PN = Probably No")
                                            ) &
                                            (
                                              (rob_data$rob2_cluster_3.3 == "Y = Yes") | 
                                                (rob_data$rob2_cluster_3.3 == "PY = Probably Yes") | 
                                                (rob_data$rob2_cluster_3.3 == "NI = No Information")
                                            ) &
                                            (
                                              (rob_data$rob2_cluster_3.4 == "Y = Yes") | 
                                                (rob_data$rob2_cluster_3.4 == "PY = Probably Yes") | 
                                                (rob_data$rob2_cluster_3.4 == "NI = No Information")
                                            )
                                        ] <- "High risk"
                                        rob_data$rob2_cluster_domain_3[
                                          is.na(rob_data$rob2_cluster_domain_3)
                                        ] <- "Some concerns"
                                        # ROB2 cluster domain 4 ####
                                        rob_data$rob2_cluster_domain_4[
                                          ((rob_data$rob2_cluster_4.1 == "N = No") | 
                                             (rob_data$rob2_cluster_4.1 == "PN = Probably No") | 
                                             (rob_data$rob2_cluster_4.1 == "NI = No Information")) & 
                                            ((rob_data$rob2_cluster_4.2 == "N = No") | 
                                               (rob_data$rob2_cluster_4.2 == "PN = Probably No")) &
                                            (
                                              ((rob_data$rob2_cluster_4.3a == "N = No") | 
                                                 (rob_data$rob2_cluster_4.3a == "PN = Probably No")) |
                                                (
                                                  ((rob_data$rob2_cluster_4.3a == "Y = Yes") | 
                                                     (rob_data$rob2_cluster_4.3a == "PY = Probably Yes") | 
                                                     (rob_data$rob2_cluster_4.3a == "NI = No Information")) &
                                                    ((rob_data$rob2_cluster_4.3b == "N = No") | 
                                                       (rob_data$rob2_cluster_4.3b == "PN = Probably No"))
                                                ) |
                                                (
                                                  ((rob_data$rob2_cluster_4.3a == "Y = Yes") | 
                                                     (rob_data$rob2_cluster_4.3a == "PY = Probably Yes") | 
                                                     (rob_data$rob2_cluster_4.3a == "NI = No Information")) &
                                                    ((rob_data$rob2_cluster_4.3b == "Y = Yes") | 
                                                       (rob_data$rob2_cluster_4.3b == "PY = Probably Yes") | 
                                                       (rob_data$rob2_cluster_4.3b == "NI = No Information")) &
                                                    ((rob_data$rob2_cluster_4.4 == "N = No") | 
                                                       (rob_data$rob2_cluster_4.4 == "PN = Probably No"))
                                                )
                                            )
                                        ] <- "Low risk"
                                        rob_data$rob2_cluster_domain_4[
                                          is.na(rob_data$rob2_cluster_domain_4) &
                                            ((rob_data$rob2_cluster_4.1 == "N = No") | 
                                               (rob_data$rob2_cluster_4.1 == "PN = Probably No") | 
                                               (rob_data$rob2_cluster_4.1 == "NI = No Information")) &
                                            (  
                                              (
                                                ((rob_data$rob2_cluster_4.2 == "N = No") | 
                                                   (rob_data$rob2_cluster_4.2 == "PN = Probably No")) &
                                                  (
                                                    (
                                                      ((rob_data$rob2_cluster_4.3a == "Y = Yes") | 
                                                         (rob_data$rob2_cluster_4.3a == "PY = Probably Yes") | 
                                                         (rob_data$rob2_cluster_4.3a == "NI = No Information")) &
                                                        ((rob_data$rob2_cluster_4.3b == "Y = Yes") | 
                                                           (rob_data$rob2_cluster_4.3b == "PY = Probably Yes") | 
                                                           (rob_data$rob2_cluster_4.3b == "NI = No Information")) &
                                                        ((rob_data$rob2_cluster_4.4 == "Y = Yes") | 
                                                           (rob_data$rob2_cluster_4.4 == "PY = Probably Yes") | 
                                                           (rob_data$rob2_cluster_4.4 == "NI = No Information")) &
                                                        ((rob_data$rob2_cluster_4.5 == "N = No") | 
                                                           (rob_data$rob2_cluster_4.5 == "PN = Probably No"))
                                                    )
                                                  )
                                              ) |
                                                (
                                                  ((rob_data$rob2_cluster_4.2 == "NI = No Information")) &
                                                    (
                                                      ((rob_data$rob2_cluster_4.3a == "N = No") | 
                                                         (rob_data$rob2_cluster_4.3a == "PN = Probably No")) |
                                                        (
                                                          ((rob_data$rob2_cluster_4.3a == "Y = Yes") | 
                                                             (rob_data$rob2_cluster_4.3a == "PY = Probably Yes") | 
                                                             (rob_data$rob2_cluster_4.3a == "NI = No Information")) &
                                                            ((rob_data$rob2_cluster_4.3b == "N = No") | 
                                                               (rob_data$rob2_cluster_4.3b == "PN = Probably No"))
                                                        ) |
                                                        (
                                                          ((rob_data$rob2_cluster_4.3a == "Y = Yes") | 
                                                             (rob_data$rob2_cluster_4.3a == "PY = Probably Yes") | 
                                                             (rob_data$rob2_cluster_4.3a == "NI = No Information")) &
                                                            ((rob_data$rob2_cluster_4.3b == "Y = Yes") | 
                                                               (rob_data$rob2_cluster_4.3b == "PY = Probably Yes") | 
                                                               (rob_data$rob2_cluster_4.3b == "NI = No Information")) &
                                                            (
                                                              ((rob_data$rob2_cluster_4.4 == "N = No") | 
                                                                 (rob_data$rob2_cluster_4.4 == "PN = Probably No")) |
                                                                (((rob_data$rob2_cluster_4.4 == "Y = Yes") | 
                                                                    (rob_data$rob2_cluster_4.4 == "PY = Probably Yes") | 
                                                                    (rob_data$rob2_cluster_4.4 == "NI = No Information")) &
                                                                   ((rob_data$rob2_cluster_4.5 == "N = No") | 
                                                                      (rob_data$rob2_cluster_4.5 == "PN = Probably No")))
                                                            )
                                                        )
                                                    )
                                                )
                                            )
                                        ] <- "Some concerns"
                                        rob_data$rob2_cluster_domain_4[
                                          is.na(rob_data$rob2_cluster_domain_4)
                                        ] <- "High risk"
                                        # ROB2 cluster domain 5 ####
                                        rob_data$rob2_cluster_domain_5[
                                          ((rob_data$rob2_cluster_5.2 == "Y = Yes") | 
                                             (rob_data$rob2_cluster_5.2 == "PY = Probably Yes")) |
                                            ((rob_data$rob2_cluster_5.3 == "Y = Yes") | 
                                               (rob_data$rob2_cluster_5.3 == "PY = Probably Yes"))
                                        ] <- "High risk" 
                                        rob_data$rob2_cluster_domain_5[
                                          is.na(rob_data$rob2_cluster_domain_5) & 
                                            ((rob_data$rob2_cluster_5.2 == "N = No") | 
                                               (rob_data$rob2_cluster_5.2 == "PN = Probably No")) &
                                            ((rob_data$rob2_cluster_5.3 == "N = No") | 
                                               (rob_data$rob2_cluster_5.3 == "PN = Probably No")) &
                                            ((rob_data$rob2_cluster_5.1 == "Y = Yes") | 
                                               (rob_data$rob2_cluster_5.1 == "PY = Probably Yes"))
                                        ] <- "Low risk"
                                        rob_data$rob2_cluster_domain_5[
                                          is.na(rob_data$rob2_cluster_domain_5) 
                                        ] <- "Some concerns"
                                        # ROB2 cluster overall ####
                                        rob_data$rob2_cluster_overall <- 
                                          as.character(sapply(1:nrow(rob_data), function(y) {
                                            if (
                                              !is.na(match("High risk", 
                                                           c(
                                                             rob_data$rob2_cluster_domain_1[y],
                                                             rob_data$rob2_cluster_domain_2_ITT[y],
                                                             if (DEF_Design$variable_value[
                                                               match("per_protocol", DEF_Design$variable)
                                                             ] == "yes") {
                                                               rob_data$rob2_cluster_domain_2_PP[y]
                                                             },
                                                             rob_data$rob2_cluster_domain_3[y],
                                                             rob_data$rob2_cluster_domain_4[y],
                                                             rob_data$rob2_cluster_domain_5[y]
                                                           )))
                                            ) {
                                              "High risk of bias"
                                            } else if (
                                              !is.na(match("Some concerns", 
                                                           c(
                                                             rob_data$rob2_cluster_domain_1[y],
                                                             rob_data$rob2_cluster_domain_2_ITT[y],
                                                             if (DEF_Design$variable_value[
                                                               match("per_protocol", DEF_Design$variable)
                                                             ] == "yes") {
                                                               rob_data$rob2_cluster_domain_2_PP[y]
                                                             },
                                                             rob_data$rob2_cluster_domain_3[y],
                                                             rob_data$rob2_cluster_domain_4[y],
                                                             rob_data$rob2_cluster_domain_5[y]
                                                           )))
                                            ) {
                                              "Some concerns"
                                            } else {
                                              "Low risk of bias"
                                            }
                                          }))
                                        
                                        
                                      }
                                      # ROB2 cross_over ####
                                      if (DEF_Design$variable_value[
                                        match("cross_over", DEF_Design$variable)
                                      ] == "yes") {
                                        # ROB2 cross_over domain 1 ####
                                        rob_data$rob2_cross_over_domain_1[
                                          (
                                            ((rob_data$rob2_cross_over_1.2 == "N = No") | 
                                               (rob_data$rob2_cross_over_1.2 == "PN = Probably No")) |
                                              ((rob_data$rob2_cross_over_1.3 == "Y = Yes") | 
                                                 (rob_data$rob2_cross_over_1.3 == "PY = Probably Yes")) |
                                              ((rob_data$rob2_cross_over_S.3 == "N = No") | 
                                                 (rob_data$rob2_cross_over_S.3 == "PN = Probably No"))
                                          )
                                        ] <- "High risk"
                                        rob_data$rob2_cross_over_domain_1[
                                          (
                                            is.na(rob_data$rob2_cross_over_domain_1) & 
                                              ((rob_data$rob2_cross_over_1.2 == "Y = Yes") | 
                                                 (rob_data$rob2_cross_over_1.2 == "PY = Probably Yes")) & 
                                              ((rob_data$rob2_cross_over_1.1 == "Y = Yes") | 
                                                 (rob_data$rob2_cross_over_1.1 == "PY = Probably Yes") | 
                                                 (rob_data$rob2_cross_over_1.1 == "NI = No Information")) &
                                              ((rob_data$rob2_cross_over_1.3 == "N = No") | 
                                                 (rob_data$rob2_cross_over_1.3 == "PN = Probably No") | 
                                                 (rob_data$rob2_cross_over_1.3 == "NI = No Information")) & 
                                              ((rob_data$rob2_cross_over_S.3 == "Y = Yes") | 
                                                 (rob_data$rob2_cross_over_S.3 == "PY = Probably Yes")) & 
                                              (
                                                ((rob_data$rob2_cross_over_S.1 == "Y = Yes") | 
                                                   (rob_data$rob2_cross_over_S.1 == "PY = Probably Yes")) | 
                                                  ((rob_data$rob2_cross_over_S.2 == "Y = Yes") | 
                                                     (rob_data$rob2_cross_over_S.2 == "PY = Probably Yes"))
                                              )
                                          )
                                        ] <- "Low risk"
                                        rob_data$rob2_cross_over_domain_1[
                                          is.na(rob_data$rob2_cross_over_domain_1)
                                        ] <- "Some concerns"
                                        # ROB2 cross_over domain 2 (ITT) ####
                                        rob_data$rob2_cross_over_domain_2_ITT[
                                          ((((rob_data$rob2_cross_over_2.1_ITT == "N = No") | 
                                               (rob_data$rob2_cross_over_2.1_ITT == "PN = Probably No")) &
                                              ((rob_data$rob2_cross_over_2.2_ITT == "N = No") | 
                                                 (rob_data$rob2_cross_over_2.2_ITT == "PN = Probably No"))) |
                                             ((rob_data$rob2_cross_over_2.3_ITT == "N = No") | 
                                                (rob_data$rob2_cross_over_2.3_ITT == "PN = Probably No"))) &
                                            ((rob_data$rob2_cross_over_2.6_ITT == "Y = Yes") | 
                                               (rob_data$rob2_cross_over_2.6_ITT == "PY = Probably Yes"))
                                        ] <- "Low risk" 
                                        rob_data$rob2_cross_over_domain_2_ITT[
                                          is.na(rob_data$rob2_cross_over_domain_2_ITT) &
                                            (
                                              (
                                                ((rob_data$rob2_cross_over_2.3_ITT == "Y = Yes") | 
                                                   (rob_data$rob2_cross_over_2.3_ITT == "PY = Probably Yes")) &
                                                  ((rob_data$rob2_cross_over_2.4_ITT == "Y = Yes") | 
                                                     (rob_data$rob2_cross_over_2.4_ITT == "PY = Probably Yes") | 
                                                     (rob_data$rob2_cross_over_2.4_ITT == "NI = No Information")) &
                                                  ((rob_data$rob2_cross_over_2.5_ITT == "N = No") | 
                                                     (rob_data$rob2_cross_over_2.5_ITT == "PN = Probably No") | 
                                                     (rob_data$rob2_cross_over_2.5_ITT == "NI = No Information"))
                                              ) |
                                                ((rob_data$rob2_cross_over_2.7_ITT == "Y = Yes") | 
                                                   (rob_data$rob2_cross_over_2.7_ITT == "PY = Probably Yes") | 
                                                   (rob_data$rob2_cross_over_2.7_ITT == "NI = No Information"))
                                            )
                                        ] <- "High risk" 
                                        rob_data$rob2_cross_over_domain_2_ITT[
                                          is.na(rob_data$rob2_cross_over_domain_2_ITT)
                                        ] <- "Some concerns"
                                        # ROB2 cross_over domain 2 (PP) #### 
                                        if (DEF_Design$variable_value[
                                          match("per_protocol", DEF_Design$variable)
                                        ] == "yes") {
                                          ####
                                          rob_data$rob2_cross_over_domain_2_PP[
                                            (
                                              (
                                                ((rob_data$rob2_cross_over_2.1_PP == "N = No") | 
                                                   (rob_data$rob2_cross_over_2.1_PP == "PN = Probably No")) &
                                                  ((rob_data$rob2_cross_over_2.2_PP == "N = No") | 
                                                     (rob_data$rob2_cross_over_2.2_PP == "PN = Probably No"))
                                              )| 
                                                ((rob_data$rob2_cross_over_2.3_PP == "Y = Yes") | 
                                                   (rob_data$rob2_cross_over_2.3_PP == "PY = Probably Yes") | 
                                                   (rob_data$rob2_cross_over_2.3_PP == "NA = Not Applicable"))
                                            ) &
                                              ((rob_data$rob2_cross_over_2.4_PP == "N = No") | 
                                                 (rob_data$rob2_cross_over_2.4_PP == "PN = Probably No") | 
                                                 (rob_data$rob2_cross_over_2.4_PP == "NA = Not Applicable")) &
                                              ((rob_data$rob2_cross_over_2.5_PP == "N = No") | 
                                                 (rob_data$rob2_cross_over_2.5_PP == "PN = Probably No") | 
                                                 (rob_data$rob2_cross_over_2.5_PP == "NA = Not Applicable"))
                                          ] <- "Low risk"
                                          rob_data$rob2_cross_over_domain_2_PP[
                                            is.na(rob_data$rob2_cross_over_domain_2_PP) &
                                              (
                                                ((rob_data$rob2_cross_over_2.3_PP == "N = No") | 
                                                   (rob_data$rob2_cross_over_2.3_PP == "PN = Probably No") | 
                                                   (rob_data$rob2_cross_over_2.3_PP == "NI = No Information")) | 
                                                  ((rob_data$rob2_cross_over_2.4_PP == "Y = Yes") | 
                                                     (rob_data$rob2_cross_over_2.4_PP == "PY = Probably Yes") | 
                                                     (rob_data$rob2_cross_over_2.4_PP == "NI = No Information")) |
                                                  ((rob_data$rob2_cross_over_2.5_PP == "Y = Yes") | 
                                                     (rob_data$rob2_cross_over_2.5_PP == "PY = Probably Yes") | 
                                                     (rob_data$rob2_cross_over_2.5_PP == "NI = No Information"))
                                              ) &
                                              ((rob_data$rob2_cross_over_2.6_PP == "N = No") | 
                                                 (rob_data$rob2_cross_over_2.6_PP == "PN = Probably No") | 
                                                 (rob_data$rob2_cross_over_2.6_PP == "NI = No Information"))
                                          ] <- "High risk"
                                          rob_data$rob2_cross_over_domain_2_PP[
                                            is.na(rob_data$rob2_cross_over_domain_2_PP)
                                          ] <- "Some concerns"
                                        }
                                        # ROB2 cross_over domain 3 ####
                                        rob_data$rob2_cross_over_domain_3[
                                          ((rob_data$rob2_cross_over_3.1 == "Y = Yes") | 
                                             (rob_data$rob2_cross_over_3.1 == "PY = Probably Yes")) |
                                            ((rob_data$rob2_cross_over_3.2 == "Y = Yes") | 
                                               (rob_data$rob2_cross_over_3.2 == "PY = Probably Yes")) |
                                            ((rob_data$rob2_cross_over_3.3 == "N = No") | 
                                               (rob_data$rob2_cross_over_3.3 == "PN = Probably No"))
                                        ] <- "Low risk"
                                        rob_data$rob2_cross_over_domain_3[
                                          is.na(rob_data$rob2_cross_over_domain_3) &
                                            ((rob_data$rob2_cross_over_3.1 == "N = No") | 
                                               (rob_data$rob2_cross_over_3.1 == "PN = Probably No") | 
                                               (rob_data$rob2_cross_over_3.1 == "NI = No Information")) & 
                                            ((rob_data$rob2_cross_over_3.2 == "N = No") | 
                                               (rob_data$rob2_cross_over_3.2 == "PN = Probably No")) &
                                            ((rob_data$rob2_cross_over_3.3 == "Y = Yes") | 
                                               (rob_data$rob2_cross_over_3.3 == "PY = Probably Yes") | 
                                               (rob_data$rob2_cross_over_3.3 == "NI = No Information")) &
                                            ((rob_data$rob2_cross_over_3.4 == "Y = Yes") | 
                                               (rob_data$rob2_cross_over_3.4 == "PY = Probably Yes") | 
                                               (rob_data$rob2_cross_over_3.4 == "NI = No Information"))
                                        ] <- "High risk"
                                        rob_data$rob2_cross_over_domain_3[
                                          is.na(rob_data$rob2_cross_over_domain_3)
                                        ] <- "Some concerns"
                                        # ROB2 cross_over domain 4 ####
                                        rob_data$rob2_cross_over_domain_4[
                                          ((rob_data$rob2_cross_over_4.1 == "N = No") | 
                                             (rob_data$rob2_cross_over_4.1 == "PN = Probably No") | 
                                             (rob_data$rob2_cross_over_4.1 == "NI = No Information")) & 
                                            ((rob_data$rob2_cross_over_4.2 == "N = No") | 
                                               (rob_data$rob2_cross_over_4.2 == "PN = Probably No")) &
                                            (((rob_data$rob2_cross_over_4.3 == "N = No") | 
                                                (rob_data$rob2_cross_over_4.3 == "PN = Probably No")) |
                                               (((rob_data$rob2_cross_over_4.3 == "Y = Yes") | 
                                                   (rob_data$rob2_cross_over_4.3 == "PY = Probably Yes") | 
                                                   (rob_data$rob2_cross_over_4.3 == "NI = No Information")) &
                                                  ((rob_data$rob2_cross_over_4.4 == "N = No") | 
                                                     (rob_data$rob2_cross_over_4.4 == "PN = Probably No"))))
                                        ] <- "Low risk"
                                        rob_data$rob2_cross_over_domain_4[
                                          is.na(rob_data$rob2_cross_over_domain_4) &
                                            ((rob_data$rob2_cross_over_4.1 == "N = No") | 
                                               (rob_data$rob2_cross_over_4.1 == "PN = Probably No") | 
                                               (rob_data$rob2_cross_over_4.1 == "NI = No Information")) &
                                            (  
                                              (((rob_data$rob2_cross_over_4.2 == "N = No") | 
                                                  (rob_data$rob2_cross_over_4.2 == "PN = Probably No")) &
                                                 (
                                                   (((rob_data$rob2_cross_over_4.3 == "Y = Yes") | 
                                                       (rob_data$rob2_cross_over_4.3 == "PY = Probably Yes") | 
                                                       (rob_data$rob2_cross_over_4.3 == "NI = No Information")) &
                                                      ((rob_data$rob2_cross_over_4.4 == "Y = Yes") | 
                                                         (rob_data$rob2_cross_over_4.4 == "PY = Probably Yes") | 
                                                         (rob_data$rob2_cross_over_4.4 == "NI = No Information")) &
                                                      ((rob_data$rob2_cross_over_4.5 == "N = No") | 
                                                         (rob_data$rob2_cross_over_4.5 == "PN = Probably No"))
                                                   )
                                                 )
                                              ) |
                                                (((rob_data$rob2_cross_over_4.2 == "NI = No Information")) &
                                                   (
                                                     ((rob_data$rob2_cross_over_4.3 == "N = No") | 
                                                        (rob_data$rob2_cross_over_4.3 == "PN = Probably No")) |
                                                       (((rob_data$rob2_cross_over_4.3 == "Y = Yes") | 
                                                           (rob_data$rob2_cross_over_4.3 == "PY = Probably Yes") | 
                                                           (rob_data$rob2_cross_over_4.3 == "NI = No Information")) &
                                                          (
                                                            ((rob_data$rob2_cross_over_4.4 == "N = No") | 
                                                               (rob_data$rob2_cross_over_4.4 == "PN = Probably No")) |
                                                              (((rob_data$rob2_cross_over_4.4 == "Y = Yes") | 
                                                                  (rob_data$rob2_cross_over_4.4 == "PY = Probably Yes") | 
                                                                  (rob_data$rob2_cross_over_4.4 == "NI = No Information")) &
                                                                 ((rob_data$rob2_cross_over_4.5 == "N = No") | 
                                                                    (rob_data$rob2_cross_over_4.5 == "PN = Probably No")))
                                                          )
                                                       )
                                                   )
                                                )
                                            )
                                        ] <- "Some concerns"
                                        rob_data$rob2_cross_over_domain_4[
                                          is.na(rob_data$rob2_cross_over_domain_4)
                                        ] <- "High risk"
                                        # ROB2 cross_over domain 5 ####
                                        rob_data$rob2_cross_over_domain_5[
                                          ((rob_data$rob2_cross_over_5.2 == "Y = Yes") | 
                                             (rob_data$rob2_cross_over_5.2 == "PY = Probably Yes")) |
                                            ((rob_data$rob2_cross_over_5.3 == "Y = Yes") | 
                                               (rob_data$rob2_cross_over_5.3 == "PY = Probably Yes")) |
                                            ((rob_data$rob2_cross_over_5.4 == "Y = Yes") | 
                                               (rob_data$rob2_cross_over_5.4 == "PY = Probably Yes"))
                                        ] <- "High risk" 
                                        rob_data$rob2_cross_over_domain_5[
                                          is.na(rob_data$rob2_cross_over_domain_5) & 
                                            ((rob_data$rob2_cross_over_5.2 == "N = No") | 
                                               (rob_data$rob2_cross_over_5.2 == "PN = Probably No")) &
                                            ((rob_data$rob2_cross_over_5.3 == "N = No") | 
                                               (rob_data$rob2_cross_over_5.3 == "PN = Probably No")) &
                                            ((rob_data$rob2_cross_over_5.4 == "N = No") | 
                                               (rob_data$rob2_cross_over_5.4 == "PN = Probably No")) &
                                            ((rob_data$rob2_cross_over_5.1 == "Y = Yes") | 
                                               (rob_data$rob2_cross_over_5.1 == "PY = Probably Yes"))
                                        ] <- "Low risk"
                                        rob_data$rob2_cross_over_domain_5[
                                          is.na(rob_data$rob2_cross_over_domain_5) 
                                        ] <- "Some concerns"
                                        # ROB2 cross_over overall ####
                                        rob_data$rob2_cross_over_overall <- 
                                          as.character(sapply(1:nrow(rob_data), function(y) {
                                            if (
                                              !is.na(match("High risk", 
                                                           c(
                                                             rob_data$rob2_cross_over_domain_1[y],
                                                             rob_data$rob2_cross_over_domain_2_ITT[y],
                                                             if (DEF_Design$variable_value[
                                                               match("per_protocol", DEF_Design$variable)
                                                             ] == "yes") {
                                                               rob_data$rob2_cross_over_domain_2_PP[y]
                                                             },
                                                             rob_data$rob2_cross_over_domain_3[y],
                                                             rob_data$rob2_cross_over_domain_4[y],
                                                             rob_data$rob2_cross_over_domain_5[y]
                                                           )))
                                            ) {
                                              "High risk of bias"
                                            } else if (
                                              !is.na(match("Some concerns", 
                                                           c(
                                                             rob_data$rob2_cross_over_domain_1[y],
                                                             rob_data$rob2_cross_over_domain_2_ITT[y],
                                                             if (DEF_Design$variable_value[
                                                               match("per_protocol", DEF_Design$variable)
                                                             ] == "yes") {
                                                               rob_data$rob2_cross_over_domain_2_PP[y]
                                                             },
                                                             rob_data$rob2_cross_over_domain_3[y],
                                                             rob_data$rob2_cross_over_domain_4[y],
                                                             rob_data$rob2_cross_over_domain_5[y]
                                                           )))
                                            ) {
                                              "Some concerns"
                                            } else {
                                              "Low risk of bias"
                                            }
                                          }
                                          ))
                                      }
                                      # ROBINS_I ####
                                      if (DEF_Design$variable_value[
                                        match("non_randomised_studies_intervention", DEF_Design$variable)
                                      ] == "yes") {
                                        # ROBINS_I overall ####
                                        rob_data$robins_i_overall <- 
                                          as.character(sapply(1:nrow(rob_data), function(y) {
                                            if (
                                              !is.na(match("Critical risk of bias", 
                                                           c(
                                                             rob_data$robins_i_domain_1[y],
                                                             rob_data$robins_i_domain_2[y],
                                                             rob_data$robins_i_domain_3[y],
                                                             rob_data$robins_i_domain_4_ITT[y],
                                                             if (DEF_Design$variable_value[
                                                               match("per_protocol", DEF_Design$variable)
                                                             ] == "yes") {
                                                               rob_data$robins_i_domain_4_PP[y]
                                                             },
                                                             rob_data$robins_i_domain_5[y],
                                                             rob_data$robins_i_domain_6[y],
                                                             rob_data$robins_i_domain_7[y]
                                                           )))
                                            ) {
                                              "Critical risk of bias"
                                            } else if (
                                              !is.na(match("Serious risk of bias", 
                                                           c(
                                                             rob_data$robins_i_domain_1[y],
                                                             rob_data$robins_i_domain_2[y],
                                                             rob_data$robins_i_domain_3[y],
                                                             rob_data$robins_i_domain_4_ITT[y],
                                                             if (DEF_Design$variable_value[
                                                               match("per_protocol", DEF_Design$variable)
                                                             ] == "yes") {
                                                               rob_data$robins_i_domain_4_PP[y]
                                                             },
                                                             rob_data$robins_i_domain_5[y],
                                                             rob_data$robins_i_domain_6[y],
                                                             rob_data$robins_i_domain_7[y]
                                                           )))
                                            ) {
                                              "Serious risk of bias"
                                            } else if (
                                              !is.na(match("No information", 
                                                           c(
                                                             rob_data$robins_i_domain_1[y],
                                                             rob_data$robins_i_domain_2[y],
                                                             rob_data$robins_i_domain_3[y],
                                                             rob_data$robins_i_domain_4_ITT[y],
                                                             if (DEF_Design$variable_value[
                                                               match("per_protocol", DEF_Design$variable)
                                                             ] == "yes") {
                                                               rob_data$robins_i_domain_4_PP[y]
                                                             },
                                                             rob_data$robins_i_domain_5[y],
                                                             rob_data$robins_i_domain_6[y],
                                                             rob_data$robins_i_domain_7[y]
                                                           )))
                                            ) {
                                              "No information"
                                            } else if (
                                              !is.na(match("Moderate risk of bias", 
                                                           c(
                                                             rob_data$robins_i_domain_1[y],
                                                             rob_data$robins_i_domain_2[y],
                                                             rob_data$robins_i_domain_3[y],
                                                             rob_data$robins_i_domain_4_ITT[y],
                                                             if (DEF_Design$variable_value[
                                                               match("per_protocol", DEF_Design$variable)
                                                             ] == "yes") {
                                                               rob_data$robins_i_domain_4_PP[y]
                                                             },
                                                             rob_data$robins_i_domain_5[y],
                                                             rob_data$robins_i_domain_6[y],
                                                             rob_data$robins_i_domain_7[y]
                                                           )))
                                            ) {
                                              "Moderate risk of bias"
                                            } else {
                                              "Low risk of bias"
                                            }
                                          }
                                          ))
                                      }
                                      # Return the file ####
                                      return(rob_data)
                                    }
    )
    names(rob_data_each_outcome) <- outcomes_list
    return(rob_data_each_outcome)
  }
  # ROB classification only ####
  rob_classification_only <- function(rob_classification) {
    rob_classification_only <- lapply(
      1:length(rob_classification), 
      function(x) {
        classifications_only <- cbind.data.frame(
          rob_classification[[x]][
            !is.na(match(colnames(rob_classification[[x]]),
                         c(
                           "study_id",
                           "study_type",
                           "outcome_name",
                           "rob2_domain_1",
                           "rob2_domain_2_ITT",
                           if (DEF_Design$variable_value[
                             match("per_protocol", DEF_Design$variable)
                           ] == "yes") {
                             "rob2_domain_2_PP"
                           },
                           "rob2_domain_3",
                           "rob2_domain_4",
                           "rob2_domain_5",
                           "rob2_overall"
                         )
            )
            )
          ],
          if (DEF_Design$variable_value[
            match("cluster", DEF_Design$variable)
          ] == "yes") {
            rob_classification[[x]][
              !is.na(match(colnames(rob_classification[[x]]),
                           c(
                             "rob2_cluster_domain_1",
                             "rob2_cluster_domain_2_ITT",
                             if (DEF_Design$variable_value[
                               match("per_protocol", DEF_Design$variable)
                             ] == "yes") {
                               "rob2_cluster_domain_2_PP"
                             },
                             "rob2_cluster_domain_3",
                             "rob2_cluster_domain_4",
                             "rob2_cluster_domain_5",
                             "rob2_cluster_overall"
                           )
              )
              )
            ] 
          },
          if (DEF_Design$variable_value[
            match("cross_over", DEF_Design$variable)
          ] == "yes") {
            rob_classification[[x]][
              !is.na(match(colnames(rob_classification[[x]]),
                           c(
                             "rob2_cross_over_domain_1",
                             "rob2_cross_over_domain_2_ITT",
                             if (DEF_Design$variable_value[
                               match("per_protocol", DEF_Design$variable)
                             ] == "yes") {
                               "rob2_cross_over_domain_2_PP"
                             },
                             "rob2_cross_over_domain_3",
                             "rob2_cross_over_domain_4",
                             "rob2_cross_over_domain_5",
                             "rob2_cross_over_overall"
                           )
              )
              )
            ] 
          },
          if (DEF_Design$variable_value[
            match("non_randomised_studies_intervention", DEF_Design$variable)
          ] == "yes") {
            rob_classification[[x]][
              !is.na(match(colnames(rob_classification[[x]]),
                           c(
                             "robins_i_domain_1",
                             "robins_i_domain_2",
                             "robins_i_domain_3",
                             "robins_i_domain_4_ITT",
                             if (DEF_Design$variable_value[
                               match("per_protocol", DEF_Design$variable)
                             ] == "yes") {
                               "robins_i_domain_4_PP"
                             },
                             "robins_i_domain_5",
                             "robins_i_domain_6",
                             "robins_i_domain_7",
                             "robins_i_overall"
                           )
              )
              )
            ]
          }
        )
        classifications_only[
          classifications_only$study_type != "Parallel RCT",
          c("rob2_domain_1", "rob2_domain_2_ITT", "rob2_domain_2_PP","rob2_domain_3","rob2_domain_4", "rob2_domain_5", "rob2_overall")
        ] <- NA
        if (DEF_Design$variable_value[
          match("cluster", DEF_Design$variable)
        ] == "yes") {
          classifications_only[
            ((classifications_only$study_type != "Cluster RCT") & (classifications_only$study_type != "Stepped-wedge RCT")),
            c("rob2_cluster_domain_1", "rob2_cluster_domain_2_ITT", 
              if (DEF_Design$variable_value[
                match("per_protocol", DEF_Design$variable)
              ] == "yes") {
                "rob2_cluster_domain_2_PP"
              },
              "rob2_cluster_domain_3","rob2_cluster_domain_4", "rob2_cluster_domain_5", "rob2_cluster_overall")
          ] <- NA
        }
        if (DEF_Design$variable_value[
          match("cross_over", DEF_Design$variable)
        ] == "yes") {
          classifications_only[
            classifications_only$study_type != "Cross-over RCT",
            c("rob2_cross_over_domain_1", "rob2_cross_over_domain_2_ITT", 
              if (DEF_Design$variable_value[
                match("per_protocol", DEF_Design$variable)
              ] == "yes") {
                "rob2_cross_over_domain_2_PP"
              },
              "rob2_cross_over_domain_3","rob2_cross_over_domain_4", "rob2_cross_over_domain_5", "rob2_cross_over_overall")
          ] <- NA
        }
        if (DEF_Design$variable_value[
          match("non_randomised_studies_intervention", DEF_Design$variable)
        ] == "yes") {
          classifications_only[
            classifications_only$study_type != "Non-randomised study of intervention",
            c("robins_i_domain_1", "robins_i_domain_2", "robins_i_domain_3", "robins_i_domain_4_ITT",
              if (DEF_Design$variable_value[
                match("per_protocol", DEF_Design$variable)
              ] == "yes") {
                "robins_i_domain_4_PP"
              },
              "robins_i_domain_5", "robins_i_domain_6", "robins_i_domain_7", "robins_i_overall")
          ] <- NA
        }
        return(classifications_only)
      }
    )
    names(rob_classification_only) <- names(rob_classification)
    return(rob_classification_only)
  }
  # ROB overall only ####
  rob_overall_classification_only <- function(rob_classification_only) {
    rob_overall_classification_only <- lapply(
      1:length(rob_classification_only), 
      function(x) {
        overall <- vector(length = nrow(rob_classification_only[[x]]))
        overall[
          rob_classification_only[[x]]$study_type == "Parallel RCT"
        ] <- rob_classification_only[[x]]$rob2_overall[
          rob_classification_only[[x]]$study_type == "Parallel RCT"
        ]
        overall[
          (
            (rob_classification_only[[x]]$study_type == "Cluster RCT") |
              (rob_classification_only[[x]]$study_type == "Stepped-wedge RCT")
          )
        ] <- rob_classification_only[[x]]$rob2_cluster_overall[
          (
            (rob_classification_only[[x]]$study_type == "Cluster RCT") |
              (rob_classification_only[[x]]$study_type == "Stepped-wedge RCT")
          )
        ]
        overall[
          rob_classification_only[[x]]$study_type == "Cross-over RCT"
        ] <- rob_classification_only[[x]]$rob2_cross_over_overall[
          rob_classification_only[[x]]$study_type == "Cross-over RCT"
        ]
        overall[
          rob_classification_only[[x]]$study_type == "Non-randomised study of intervention"
        ] <- rob_classification_only[[x]]$robins_i_overall[
          rob_classification_only[[x]]$study_type == "Non-randomised study of intervention"
        ]
        overall[
          (overall == "Moderate risk of bias") | (overall == "No information")
        ] <- "Some concerns"
        overall[
          (overall == "Serious risk of bias") | (overall == "Critical risk of bias")
        ] <- "High risk of bias"
        rob_overall_classification_only_each_outcome <- rob_classification_only[[x]][
          !is.na(match(colnames(rob_classification_only[[x]]),
                       c("study_id",
                         "study_type",
                         "outcome_name",
                         "rob2_overall",
                         "rob2_cluster_overall",
                         "rob2_cross_over_overall",
                         "robins_i_overall"
                       )
          ))
        ]
        rob_overall_classification_only_each_outcome <- cbind.data.frame(
          rob_overall_classification_only_each_outcome,
          overall
        )
      }
    )
    names(rob_overall_classification_only) <- names(rob_classification_only)
    return(rob_overall_classification_only)
  }
  # Outcome data preparation ####
  prepare_outcome_data <- function(data_unprocessed, field_names){
    outcome_data_processed <- data_unprocessed[
      ,
      (
        (!is.na(match(
          colnames(data_unprocessed),
          c(
            "study_id", "study_type",
            "additional_name_intervention_1",
            "additional_name_intervention_2")
        ))) |
          (!is.na(match(
            colnames(data_unprocessed),
            field_names$short_name[field_names$section == "follow-up"]
          ))) |
          (!is.na(match(
            colnames(data_unprocessed),
            field_names$short_name[field_names$section == "outcome"]
          ))) |
          (!is.na(match(
            colnames(data_unprocessed),
            field_names$short_name[field_names$sub_section == "intervention_participant_flow"]
          )))
      )
    ]
    # Add Study type to all rows and number of clusters to all rows
    study_type <- cbind.data.frame(study_id = outcome_data_processed$study_id, 
                                   study_type = outcome_data_processed$study_type,
                                   number_of_clusters_1 = outcome_data_processed$outcome_data_additional_number_of_clusters_1,
                                   number_of_clusters_2 = outcome_data_processed$outcome_data_additional_number_of_clusters_2)
    study_type <- study_type[! is.na(study_type$study_type),]
    study_type <- study_type[! duplicated(study_type$study_id),]
    outcome_data_processed$study_type <- study_type$study_type[match(outcome_data_processed$study_id,
                                                                     study_type$study_id)]
    outcome_data_processed$outcome_data_additional_number_of_clusters_1 <- study_type$number_of_clusters_1[match(outcome_data_processed$study_id,
                                                                                                                 study_type$study_id)]
    outcome_data_processed$outcome_data_additional_number_of_clusters_2 <- study_type$number_of_clusters_2[match(outcome_data_processed$study_id,
                                                                                                                 study_type$study_id)]
    # Add additional intervention names, but also create two fields with intervention and comparator for preparing data
    if (! is.na(match("intervention_1", DEF_Design$variable))) {
      outcome_data_processed$unmodified_name_intervention_1 <- DEF_Design$variable_value[match("intervention_1", DEF_Design$variable)]
      outcome_data_processed$unmodified_name_intervention_2 <- DEF_Design$variable_value[match("intervention_2", DEF_Design$variable)]
      outcome_data_processed$additional_name_intervention_1[
        ! is.na(outcome_data_processed$additional_name_intervention_1)
      ] <- paste0(
        DEF_Design$variable_value[match("intervention_1", DEF_Design$variable)],
        "_",
        outcome_data_processed$additional_name_intervention_1[
          ! is.na(outcome_data_processed$additional_name_intervention_1)
        ]
      )
      outcome_data_processed$additional_name_intervention_2[
        ! is.na(outcome_data_processed$additional_name_intervention_2)
      ] <- paste0(
        DEF_Design$variable_value[match("intervention_2", DEF_Design$variable)],
        "_",
        outcome_data_processed$additional_name_intervention_2[
          ! is.na(outcome_data_processed$additional_name_intervention_2)
        ]
      )
    } else {
      outcome_data_processed$unmodified_name_intervention_1 <- "intervention_1"
      outcome_data_processed$unmodified_name_intervention_2 <- "intervention_2"
    }
    # Add additional outcome names but retain the unmodified outcome name for later processing
    outcome_data_processed$unmodified_outcome_name <- outcome_data_processed$outcome_name
    outcome_data_processed$outcome_name[
      !is.na(outcome_data_processed$outcome_additional_name)
    ] <- paste0(
      outcome_data_processed$outcome_name[
        !is.na(outcome_data_processed$outcome_additional_name)
      ],
      "_",
      outcome_data_processed$outcome_additional_name[
        !is.na(outcome_data_processed$outcome_additional_name)
      ]
    )
    outcome_data_processed$outcome_additional_short_name[
      is.na(outcome_data_processed$outcome_additional_name)
    ] <- DEF_Design$short_names[
      match(
        outcome_data_processed$outcome_name[
          is.na(outcome_data_processed$outcome_additional_name)
        ],
        DEF_Design$variable_value
      )
    ]
    # Now the participant flow
    for (i in 2:nrow(outcome_data_processed)) {
      if ((is.na(outcome_data_processed$n_allocated_intervention_1[i])) &
          (! is.na(outcome_data_processed$additional_name_intervention_1[i]))
      ) {
        outcome_data_processed$n_allocated_intervention_1[i] <- outcome_data_processed$n_allocated_intervention_1[i-1]
      }
      if ((is.na(outcome_data_processed$n_allocated_intervention_2[i])) &
          (! is.na(outcome_data_processed$additional_name_intervention_2[i]))
      ) {
        outcome_data_processed$n_allocated_intervention_2[i] <- outcome_data_processed$n_allocated_intervention_2[i-1]
      }
    }
    outcome_data_processed$n_analysed_each_outcome_intervention_1[
      is.na(outcome_data_processed$n_analysed_each_outcome_intervention_1)
    ] <- outcome_data_processed$n_allocated_intervention_1[
      is.na(outcome_data_processed$n_analysed_each_outcome_intervention_1)
    ]
    outcome_data_processed$n_analysed_each_outcome_intervention_2[
      is.na(outcome_data_processed$n_analysed_each_outcome_intervention_2)
    ] <- outcome_data_processed$n_allocated_intervention_2[
      is.na(outcome_data_processed$n_analysed_each_outcome_intervention_2)
    ]
    outcome_data_processed$n_missing_failure_each_outcome_intervention_1[
      is.na(outcome_data_processed$n_missing_failure_each_outcome_intervention_1)
    ] <- outcome_data_processed$n_missing_failure_most_outcomes_intervention_1[
      is.na(outcome_data_processed$n_missing_failure_each_outcome_intervention_1)
    ]
    outcome_data_processed$n_missing_failure_each_outcome_intervention_2[
      is.na(outcome_data_processed$n_missing_failure_each_outcome_intervention_2)
    ] <- outcome_data_processed$n_missing_failure_most_outcomes_intervention_2[
      is.na(outcome_data_processed$n_missing_failure_each_outcome_intervention_2)
    ]
    outcome_data_processed$n_missing_success_each_outcome_intervention_1[
      is.na(outcome_data_processed$n_missing_success_each_outcome_intervention_1)
    ] <- outcome_data_processed$n_missing_success_most_outcomes_intervention_1[
      is.na(outcome_data_processed$n_missing_success_each_outcome_intervention_1)
    ]
    outcome_data_processed$n_missing_success_each_outcome_intervention_2[
      is.na(outcome_data_processed$n_missing_success_each_outcome_intervention_2)
    ] <- outcome_data_processed$n_missing_success_most_outcomes_intervention_2[
      is.na(outcome_data_processed$n_missing_success_each_outcome_intervention_2)
    ]
    outcome_data_processed$n_missing_unrelated_each_outcome_intervention_1[
      is.na(outcome_data_processed$n_missing_unrelated_each_outcome_intervention_1)
    ] <- outcome_data_processed$n_missing_unrelated_most_outcomes_intervention_1[
      is.na(outcome_data_processed$n_missing_unrelated_each_outcome_intervention_1)
    ]
    outcome_data_processed$n_missing_unrelated_each_outcome_intervention_2[
      is.na(outcome_data_processed$n_missing_unrelated_each_outcome_intervention_2)
    ] <- outcome_data_processed$n_missing_unrelated_most_outcomes_intervention_2[
      is.na(outcome_data_processed$n_missing_unrelated_each_outcome_intervention_2)
    ]
    outcome_data_processed$n_missing_protocol_violation_each_outcome_intervention_1[
      is.na(outcome_data_processed$n_missing_protocol_violation_each_outcome_intervention_1)
    ] <- outcome_data_processed$n_missing_protocol_violation_most_outcomes_intervention_1[
      is.na(outcome_data_processed$n_missing_protocol_violation_each_outcome_intervention_1)
    ]
    outcome_data_processed$n_missing_protocol_violation_each_outcome_intervention_2[
      is.na(outcome_data_processed$n_missing_protocol_violation_each_outcome_intervention_2)
    ] <- outcome_data_processed$n_missing_protocol_violation_most_outcomes_intervention_2[
      is.na(outcome_data_processed$n_missing_protocol_violation_each_outcome_intervention_2)
    ]
    outcome_data_processed$n_missing_other_each_outcome_intervention_1[
      is.na(outcome_data_processed$n_missing_other_each_outcome_intervention_1)
    ] <- outcome_data_processed$n_missing_other_most_outcomes_intervention_1[
      is.na(outcome_data_processed$n_missing_other_each_outcome_intervention_1)
    ]
    outcome_data_processed$n_missing_other_each_outcome_intervention_2[
      is.na(outcome_data_processed$n_missing_other_each_outcome_intervention_2)
    ] <- outcome_data_processed$n_missing_other_most_outcomes_intervention_2[
      is.na(outcome_data_processed$n_missing_other_each_outcome_intervention_2)
    ]
    outcome_data_processed$n_missing_reasons_not_stated_each_outcome_intervention_1[
      is.na(outcome_data_processed$n_missing_reasons_not_stated_each_outcome_intervention_1)
    ] <- outcome_data_processed$n_missing_reasons_not_stated_most_outcomes_intervention_1[
      is.na(outcome_data_processed$n_missing_reasons_not_stated_each_outcome_intervention_1)
    ]
    outcome_data_processed$n_missing_reasons_not_stated_each_outcome_intervention_2[
      is.na(outcome_data_processed$n_missing_reasons_not_stated_each_outcome_intervention_2)
    ] <- outcome_data_processed$n_missing_reasons_not_stated_most_outcomes_intervention_2[
      is.na(outcome_data_processed$n_missing_reasons_not_stated_each_outcome_intervention_2)
    ]
    
    # Now follow-up details
    outcome_data_processed$minimum_each_outcome[
      is.na(outcome_data_processed$minimum_each_outcome)
    ] <- outcome_data_processed$minimum_most_outcomes[
      is.na(outcome_data_processed$minimum_each_outcome)
    ]
    outcome_data_processed$maximum_each_outcome[
      is.na(outcome_data_processed$maximum_each_outcome)
    ] <- outcome_data_processed$maximum_most_outcomes[
      is.na(outcome_data_processed$maximum_each_outcome)
    ]
    outcome_data_processed$mean_each_outcome[
      is.na(outcome_data_processed$mean_each_outcome)
    ] <- outcome_data_processed$mean_most_outcomes[
      is.na(outcome_data_processed$mean_each_outcome)
    ]
    outcome_data_processed$median_each_outcome[
      is.na(outcome_data_processed$median_each_outcome)
    ] <- outcome_data_processed$median_most_outcomes[
      is.na(outcome_data_processed$median_each_outcome)
    ]
    outcome_data_processed$minimum_each_intervention_each_outcome_intervention_1[
      is.na(outcome_data_processed$minimum_each_intervention_each_outcome_intervention_1)
    ] <- outcome_data_processed$minimum_each_outcome[
      is.na(outcome_data_processed$minimum_each_intervention_each_outcome_intervention_1)
    ]
    outcome_data_processed$minimum_each_intervention_each_outcome_intervention_2[
      is.na(outcome_data_processed$minimum_each_intervention_each_outcome_intervention_2)
    ] <- outcome_data_processed$minimum_each_outcome[
      is.na(outcome_data_processed$minimum_each_intervention_each_outcome_intervention_2)
    ]
    outcome_data_processed$maximum_each_intervention_each_outcome_intervention_1[
      is.na(outcome_data_processed$maximum_each_intervention_each_outcome_intervention_1)
    ] <- outcome_data_processed$maximum_each_outcome[
      is.na(outcome_data_processed$maximum_each_intervention_each_outcome_intervention_1)
    ]
    outcome_data_processed$maximum_each_intervention_each_outcome_intervention_2[
      is.na(outcome_data_processed$maximum_each_intervention_each_outcome_intervention_2)
    ] <- outcome_data_processed$maximum_each_outcome[
      is.na(outcome_data_processed$maximum_each_intervention_each_outcome_intervention_2)
    ]
    outcome_data_processed$mean_each_intervention_each_outcome_intervention_1[
      is.na(outcome_data_processed$mean_each_intervention_each_outcome_intervention_1)
    ] <- outcome_data_processed$mean_each_outcome[
      is.na(outcome_data_processed$mean_each_intervention_each_outcome_intervention_1)
    ]
    outcome_data_processed$mean_each_intervention_each_outcome_intervention_2[
      is.na(outcome_data_processed$mean_each_intervention_each_outcome_intervention_2)
    ] <- outcome_data_processed$mean_each_outcome[
      is.na(outcome_data_processed$mean_each_intervention_each_outcome_intervention_2)
    ]
    outcome_data_processed$median_each_intervention_each_outcome_intervention_1[
      is.na(outcome_data_processed$median_each_intervention_each_outcome_intervention_1)
    ] <- outcome_data_processed$median_each_outcome[
      is.na(outcome_data_processed$median_each_intervention_each_outcome_intervention_1)
    ]
    outcome_data_processed$median_each_intervention_each_outcome_intervention_2[
      is.na(outcome_data_processed$median_each_intervention_each_outcome_intervention_2)
    ] <- outcome_data_processed$median_each_outcome[
      is.na(outcome_data_processed$median_each_intervention_each_outcome_intervention_2)
    ]
    outcome_data_processed <- outcome_data_processed[
      ,
      (
        (!is.na(match(
          colnames(outcome_data_processed),
          c(
            "study_id", "study_type",
            "additional_name_intervention_1",
            "additional_name_intervention_2",
            "unmodified_name_intervention_1",
            "unmodified_name_intervention_2",
            "unmodified_outcome_name")
        ))) |
          (!is.na(match(
            colnames(outcome_data_processed),
            field_names$short_name[field_names$section == "outcome"]
          )))
      )
    ]
    outcome_data_processed <- outcome_data_processed[
      order(
        outcome_data_processed$outcome_name,
        outcome_data_processed$study_id
      )
      , ]
    return(outcome_data_processed)
  }
  # Pre-analysis data
  prepare_pre_analysis_data <- function(outcome_data_processed) {
    columns_to_include <- c("study_id", "study_type",
                            "unmodified_name_intervention_1", "unmodified_name_intervention_2",
                            "additional_name_intervention_1", "additional_name_intervention_2",
                            "unmodified_outcome_name", "outcome_name", "outcome_type_1", "outcome_type_2", "outcome_definition", "outcome_better_worse",
                            "mean_each_intervention_each_outcome_intervention_1", "mean_each_intervention_each_outcome_intervention_2",
                            "n_analysed_each_outcome_intervention_1", "n_analysed_each_outcome_intervention_2", 
                            "n_missing_failure_each_outcome_intervention_1", "n_missing_failure_each_outcome_intervention_2", 
                            "n_missing_success_each_outcome_intervention_1", "n_missing_success_each_outcome_intervention_2", 
                            "n_missing_unrelated_each_outcome_intervention_1", "n_missing_unrelated_each_outcome_intervention_2", 
                            "n_missing_protocol_violation_each_outcome_intervention_1", "n_missing_protocol_violation_each_outcome_intervention_2", 
                            "n_missing_other_each_outcome_intervention_1", "n_missing_other_each_outcome_intervention_2", 
                            "n_missing_reasons_not_stated_each_outcome_intervention_1", "n_missing_reasons_not_stated_each_outcome_intervention_2", 
                            "outcome_data_1_intervention_1", "outcome_data_1_intervention_2", 
                            "outcome_data_2_intervention_1", "outcome_data_2_intervention_2", 
                            "outcome_data_3", 
                            "effect_measure_name", 
                            "effect_measure_unadjusted", "lci_effect_measure_unadjusted", "uci_effect_measure_unadjusted", "se_effect_measure_unadjusted", 
                            "effect_measure_adjusted", "lci_effect_measure_adjusted", "uci_effect_measure_adjusted", "se_effect_measure_adjusted", 
                            "outcome_data_additional_percentage_binary_intervention_1", "outcome_data_additional_percentage_binary_intervention_2", 
                            "outcome_data_additional_se_continuous_intervention_1", "outcome_data_additional_se_continuous_intervention_2", 
                            "outcome_data_additional_lci_continuous_intervention_1", "outcome_data_additional_lci_continuous_intervention_2", 
                            "outcome_data_additional_uci_continuous_intervention_1", "outcome_data_additional_uci_continuous_intervention_2", 
                            "outcome_data_additional_median_continuous_intervention_1", "outcome_data_additional_median_continuous_intervention_2", 
                            "outcome_data_additional_lqr_continuous_intervention_1", "outcome_data_additional_lqr_continuous_intervention_2", 
                            "outcome_data_additional_uqr_continuous_intervention_1", "outcome_data_additional_uqr_continuous_intervention_2", 
                            "outcome_data_additional_minimum_continuous_intervention_1", "outcome_data_additional_minimum_continuous_intervention_2", 
                            "outcome_data_additional_maximum_continuous_intervention_1", "outcome_data_additional_maximum_continuous_intervention_2", 
                            "outcome_data_additional_p_value_continuous", 
                            "outcome_data_additional_number_of_events_time_to_event", "outcome_data_additional_favours_intervention_time_to_event", "outcome_data_additional_p_value_time_to_event",
                            "outcome_data_additional_number_of_clusters_1", "outcome_data_additional_number_of_clusters_2", 
                            "outcome_data_additional_ICC"
    )
    outcome_data_pre_analysis <- outcome_data_processed[
      ,
      (!is.na(match(
        colnames(outcome_data_processed),
        columns_to_include
      )))
    ]
    outcome_data_pre_analysis <- outcome_data_pre_analysis[,columns_to_include]
  }
  # Now remove the rob for those without outcome data ####
  finalise_rob <- function(outcome_data_processed,rob_classification, rob_classification_only,rob_overall_classification_only) {
    outcomes_list <- names(rob_classification)
    rob_classification <- lapply(
      1:length(rob_classification),
      function(x) {
        rob_classification[[x]][! is.na(match(rob_classification[[x]]$study_id,
                                              outcome_data_processed$study_id[
                                                outcome_data_processed$outcome_additional_short_name == names(rob_classification)[x]
                                              ])),]
      }
    )
    names(rob_classification) <- outcomes_list
    rob_classification_only <- lapply(
      1:length(rob_classification_only),
      function(x) {
        rob_classification_only[[x]][! is.na(match(rob_classification_only[[x]]$study_id,
                                                   outcome_data_processed$study_id[
                                                     outcome_data_processed$outcome_additional_short_name == names(rob_classification)[x]
                                                   ])),]
      }
    )
    names(rob_classification_only)  <- outcomes_list
    rob_overall_classification_only <- lapply(
      1:length(rob_overall_classification_only),
      function(x) {
        rob_overall_classification_only[[x]][! is.na(match(rob_overall_classification_only[[x]]$study_id,
                                                           outcome_data_processed$study_id[
                                                             outcome_data_processed$outcome_additional_short_name == names(rob_classification)[x]
                                                           ])),]
      }
    )
    names(rob_overall_classification_only) <- outcomes_list
    list(rob_classification, rob_classification_only, rob_overall_classification_only)
  }
  # Now do this for each data extraction sheet ####
  if (! is.null(data_part_processed_1)){
    data_wide_1 <- split_combine_interventions(study_id_column_name = "study_id",
                                               database = data_part_processed_1,
                                               textjoin_column_names = "record_id",
                                               DEF_Design = DEF_Design,
                                               field_names = field_names)
    rob_classification_1 <- rob_classification(database = data_wide_1,
                                               database_unprocessed = data_unprocessed_1,
                                               database_part_processed = data_part_processed_1
    )
    rob_classification_only_1 <- rob_classification_only(rob_classification = rob_classification_1)
    rob_overall_classification_only_1 <- rob_overall_classification_only(rob_classification_only = rob_classification_only_1)
    outcome_data_processed_1 <- prepare_outcome_data(data_unprocessed = data_unprocessed_1,
                                                     field_names = field_names)
    outcome_data_pre_analysis_1 <- prepare_pre_analysis_data(outcome_data_processed = outcome_data_processed_1)
    final_rob_1 <- finalise_rob (
      outcome_data_processed = outcome_data_processed_1,
      rob_classification = rob_classification_1,
      rob_classification_only = rob_classification_only_1,
      rob_overall_classification_only = rob_overall_classification_only_1
    )
    rob_classification_1 <- final_rob_1[[1]]
    rob_classification_only_1 <- final_rob_1[[2]]
    rob_overall_classification_only_1 <- final_rob_1[[3]]
  } else {
    data_wide_1 <- NULL
    rob_classification_1 <- NULL
    rob_classification_only_1 <- NULL
    rob_overall_classification_only_1 <- NULL
    outcome_data_processed_1 <- NULL
    outcome_data_pre_analysis_1 <- NULL
  }
  if (! is.null(data_part_processed_2)){
    data_wide_2 <- split_combine_interventions(study_id_column_name = "study_id",
                                               database = data_part_processed_2,
                                               textjoin_column_names = "record_id",
                                               DEF_Design = DEF_Design,
                                               field_names = field_names)
    rob_classification_2 <- rob_classification(database = data_wide_2,
                                               database_unprocessed = data_unprocessed_2,
                                               database_part_processed = data_part_processed_2
    )
    rob_classification_only_2 <- rob_classification_only(rob_classification = rob_classification_2)
    rob_overall_classification_only_2 <- rob_overall_classification_only(rob_classification_only = rob_classification_only_2)
    outcome_data_processed_2 <- prepare_outcome_data(data_unprocessed = data_unprocessed_2,
                                                     field_names = field_names)
    outcome_data_pre_analysis_2 <- prepare_pre_analysis_data(outcome_data_processed = outcome_data_processed_2)
    final_rob_2 <- finalise_rob (
      outcome_data_processed = outcome_data_processed_2,
      rob_classification = rob_classification_2,
      rob_classification_only = rob_classification_only_2,
      rob_overall_classification_only = rob_overall_classification_only_2
    )
    rob_classification_2 <- final_rob_2[[1]]
    rob_classification_only_2 <- final_rob_2[[2]]
    rob_overall_classification_only_2 <- final_rob_2[[3]]
  } else {
    data_wide_2 <- NULL
    rob_classification_2 <- NULL
    rob_classification_only_2 <- NULL
    rob_overall_classification_only_2 <- NULL
    outcome_data_processed_2 <- NULL
    outcome_data_pre_analysis_2 <- NULL
  }
  first <- list(
    unprocessed = data_unprocessed_1,
    processed_data_long = data_part_processed_1,
    processed_data_wide = data_wide_1,
    rob_classification = rob_classification_1,
    rob_classification_only = rob_classification_only_1,
    rob_overall_classification_only = rob_overall_classification_only_1,
    outcome_data = outcome_data_processed_1,
    outcome_data_pre_analysis = outcome_data_pre_analysis_1
  )
  second <- list(
    unprocessed = data_unprocessed_2,
    processed_data_long = data_part_processed_2,
    processed_data_wide = data_wide_2,
    rob_classification = rob_classification_2,
    rob_classification_only = rob_classification_only_2,
    rob_overall_classification_only = rob_overall_classification_only_2,
    outcome_data = outcome_data_processed_2,
    outcome_data_pre_analysis = outcome_data_pre_analysis_2
  )
  # Now process the data to format suitable for meta-analysis ####
  first <- append(
    first,
    outcome_multi_arm_studies(outcome_data_pre_analysis = outcome_data_pre_analysis_1, DEF_Design = DEF_Design)
  )
  second <- append(
    second,
    outcome_multi_arm_studies(outcome_data_pre_analysis = outcome_data_pre_analysis_2, DEF_Design = DEF_Design)
  )
  # Now compare the two data sets ####
  compare_data <- function(first, second, field_names) {
    if ((! is.null(first$unprocessed)) & (! is.null(second$unprocessed))) {
      # Studies list
      studies_both <- unique(
        first$unprocessed$study_id[
          ! is.na(match(
            first$unprocessed$study_id, second$unprocessed$study_id
          ))
        ]
      )
      studies_first_not_second <- unique(
        first$unprocessed$study_id[
          is.na(match(
            first$unprocessed$study_id, second$unprocessed$study_id
          ))
        ]
      )
      studies_second_not_first <- unique(
        second$unprocessed$study_id[
          is.na(match(
            second$unprocessed$study_id, first$unprocessed$study_id
          ))
        ]
      )
      studies_comparison <- data.frame(cbind.columns(
        list(
          studies_both = studies_both, 
          studies_first_not_second = studies_first_not_second, 
          studies_second_not_first = studies_second_not_first
        )
      ))
      if (length(studies_both) >0) {
        # Completed sections - 1 ####
        # Now select only studies which are present in both forms
        DEF1 <- first$unprocessed[
          ! is.na(match(
            first$unprocessed$study_id, studies_both
          )),
          ! is.na(match(
            colnames(first$unprocessed), field_names$short_name[
              ! is.na(match(field_names$section, 
                            c("study_details",
                              "participant_characteristics_1",
                              "participant_characteristics_2",
                              "follow-up",
                              "intervention"
                            )
              ))
            ]
          ))
        ]
        # Add intervention details in front
        DEF1$additional_short_name_intervention_1[
          !is.na(DEF1$additional_short_name_intervention_1)
        ] <- paste0(DEF_Design$variable_value[match("intervention_1", DEF_Design$variable)], "_",
                    DEF1$additional_short_name_intervention_1[
                      !is.na(DEF1$additional_short_name_intervention_1)
                    ]
        )
        DEF1$additional_short_name_intervention_1[
          is.na(DEF1$additional_short_name_intervention_1)
        ] <- DEF_Design$variable_value[match("intervention_1", DEF_Design$variable)]
        DEF1$additional_short_name_intervention_2[
          !is.na(DEF1$additional_short_name_intervention_2)
        ] <- paste0(DEF_Design$variable_value[match("intervention_2", DEF_Design$variable)], "_",
                    DEF1$additional_short_name_intervention_2[
                      !is.na(DEF1$additional_short_name_intervention_2)  
                    ]
        )
        DEF1$additional_short_name_intervention_2[
          is.na(DEF1$additional_short_name_intervention_2)
        ] <- DEF_Design$variable_value[match("intervention_2", DEF_Design$variable)]
        DEF1 <- DEF1[
          ! duplicated(
            paste0(
              DEF1$study_id, "_",
              DEF1$additional_short_name_intervention_1,"_",
              DEF1$additional_short_name_intervention_2
            )
          )
          ,
        ]
        for (j in 1:ncol(DEF1)){
          for (i in 2:nrow(DEF1)) {
            if (is.na(DEF1[i,j])) {
              DEF1[i,j] <- DEF1[(i-1),j]
            }
          }
        }
        DEF2 <- second$unprocessed[
          ! is.na(match(
            second$unprocessed$study_id, studies_both
          )),
          ! is.na(match(
            colnames(second$unprocessed), field_names$short_name[
              ! is.na(match(field_names$section, 
                            c("study_details",
                              "participant_characteristics_1",
                              "participant_characteristics_2",
                              "follow-up",
                              "intervention"
                            )
              ))
            ]
          ))
        ]
        # Add intervention details in front
        DEF2$additional_short_name_intervention_1[
          !is.na(DEF2$additional_short_name_intervention_1)
        ] <- paste0(DEF_Design$variable_value[match("intervention_1", DEF_Design$variable)], "_",
                    DEF2$additional_short_name_intervention_1[
                      !is.na(DEF2$additional_short_name_intervention_1)
                    ]
        )
        DEF2$additional_short_name_intervention_1[
          is.na(DEF2$additional_short_name_intervention_1)
        ] <- DEF_Design$variable_value[match("intervention_1", DEF_Design$variable)]
        DEF2$additional_short_name_intervention_2[
          !is.na(DEF2$additional_short_name_intervention_2)
        ] <- paste0(DEF_Design$variable_value[match("intervention_2", DEF_Design$variable)], "_",
                    DEF2$additional_short_name_intervention_2[
                      !is.na(DEF2$additional_short_name_intervention_2)  
                    ]
        )
        DEF2$additional_short_name_intervention_2[
          is.na(DEF2$additional_short_name_intervention_2)
        ] <- DEF_Design$variable_value[match("intervention_2", DEF_Design$variable)]
        DEF2 <- DEF2[
          ! duplicated(
            paste0(
              DEF2$study_id, "_",
              DEF2$additional_short_name_intervention_1,"_",
              DEF2$additional_short_name_intervention_2
            )
          )
          ,
        ]
        for (j in 1:ncol(DEF2)){
          for (i in 2:nrow(DEF2)) {
            if (is.na(DEF2[i,j])) {
              DEF2[i,j] <- DEF2[(i-1),j]
            }
          }
        }
        # Completed sections - 2 ####
        # Compare data
        # Collect the row 1 to 4 headings
        row_headings <- data.frame(lapply(1:7, function(x) {
          str_remove_all(field_names[[x]],'xml:space="preserve">')
        }
        ))
        colnames(row_headings) <- colnames(field_names)[1:7]
        row_headings$column_number <- 1:nrow(row_headings)
        row_headings$column_name <- int2col(1:nrow(row_headings))
        # Save a copy for rob and outcome
        row_headings_rob <- row_headings
        row_headings_outcome <- row_headings
        row_headings <- row_headings[
          ! is.na(match(row_headings$section, 
                        c("study_details",
                          "participant_characteristics_1",
                          "participant_characteristics_2",
                          "follow-up",
                          "intervention"
                        )
          )),
        ]
        for (j in 4:7){
          for (i in 2:nrow(row_headings)) {
            if (is.na(row_headings[i,j])) {
              row_headings[i,j] <- row_headings[(i-1),j]
            }
          }
        }
        row_headings$row_4_intervention[row_headings$section == "follow-up"] <- NA
        # Completed sections - 3 ####
        # NA to "" to allow comparison of one form having NA
        DEF1[is.na(DEF1)] <- ""
        DEF2[is.na(DEF2)] <- ""
        # compare data - studies may contain different number of rows due to extraction of different interventions, so row to row comparison is not possible
        DEF1_study <- list()
        DEF2_study <- list()
        Differences_study <- list()
        for (i in 1:length(studies_both)) {
          DEF1_study[[i]] <- data.frame(DEF1[DEF1$study_id == studies_both[i],])
          DEF2_study[[i]] <- data.frame(DEF2[DEF2$study_id == studies_both[i],])
          if (nrow(DEF1_study[[i]]) < max(nrow(DEF1_study[[i]]), nrow(DEF2_study[[i]]))) {
            for (i in 1:(max(nrow(DEF1_study[[i]]), nrow(DEF2_study[[i]]))- nrow(DEF1_study[[i]]))) {
              DEF1_study[[i]][nrow(DEF1_study[[i]])+1,] <- ""
              row.names(DEF1_study[[i]])[nrow(DEF1_study[[i]])] <- "missing.row"
            }
            DEF1_study[[i]]$study_id <- studies_both[i]
          }
          if (nrow(DEF2_study[[i]]) < max(nrow(DEF1_study[[i]]), nrow(DEF2_study[[i]]))) {
            for (i in 1:(max(nrow(DEF1_study[[i]]), nrow(DEF2_study[[i]]))- nrow(DEF2_study[[i]]))) {
              DEF2_study[[i]][nrow(DEF2_study[[i]])+1,] <- ""
              row.names(DEF2_study[[i]])[nrow(DEF2_study[[i]])] <- "missing.row"
            }
            DEF2_study[[i]]$study_id <- studies_both[i]
          }
          Differences_study[[i]] <- data.frame(DEF1_study[[i]] == DEF2_study[[i]])
          Differences_study[[i]]$study_id <- studies_both[i]
        }
        DEF1 <- do.call(rbind.data.frame, DEF1_study)
        DEF2 <- do.call(rbind.data.frame, DEF2_study)
        Differences <- do.call(rbind.data.frame, Differences_study)
        # For each row, get the column names with false
        data_differences <- lapply(
          1:nrow(Differences),
          function(x) {
            mismatch_columns <- colnames(Differences)[Differences[x,] == FALSE]
            if (length(mismatch_columns) > 0) {
              mismatch_column_details <- row_headings[match(mismatch_columns, row_headings$short_name), ]
              data_differences_each_row <- cbind.data.frame(
                rep(Differences$study_id[x],length(mismatch_columns)),
                mismatch_column_details[,1:4],
                paste0(mismatch_column_details[,9], row.names(DEF1)[x]),
                paste0(mismatch_column_details[,9], row.names(DEF2)[x]),
                as.vector(unlist(DEF1[x,mismatch_columns])), 
                as.vector(unlist(DEF2[x,mismatch_columns])),
                rep(NA,length(mismatch_columns)), rep(NA,length(mismatch_columns)), rep(NA,length(mismatch_columns))
              )
            }
          }
        )
        data_differences <- do.call(rbind.data.frame, data_differences)
        if (nrow(data_differences) > 0) {
          colnames(data_differences) <- c("study_id",
                                          "Section", "Field", "Field details", "Sub-field", 
                                          "Excel cell - First", "Excel cell - Second", 
                                          "Data - First", "Data - Second",
                                          "Initial comments", "Reply", "Resolution"
          )
        } else {
          data_differences <- data.frame(matrix(ncol=12))
          colnames(data_differences) <- c("study_id",
                                          "Section", "Field", "Field details", "Sub-field", 
                                          "Excel cell - First", "Excel cell - Second", 
                                          "Data - First", "Data - Second",
                                          "Initial comments", "Reply", "Resolution"
          )
          data_differences$study_id = "There are no differences to resolve"
        }
        # Completed sections - 4 ####
        # Now with rob
        # Some outcomes may not be reported by both
        rob_classification_1 <- first$rob_classification
        rob_classification_2 <- second$rob_classification
        rob_classification_only_1 <- first$rob_classification_only
        rob_classification_only_2 <- second$rob_classification_only
        rob_overall_classification_only_1 <- first$rob_overall_classification_only
        rob_overall_classification_only_2 <- second$rob_overall_classification_only
        
        # Outcomes list
        outcomes_both <- sort(names(rob_classification_1)[
          ! is.na(match(
            names(rob_classification_1), names(rob_classification_2)
          ))
        ])
        outcomes_first_not_second <- sort(names(rob_classification_1)[
          is.na(match(
            names(rob_classification_1), names(rob_classification_2)
          ))
        ])
        outcomes_second_not_first <- sort(names(rob_classification_2)[
          is.na(match(
            names(rob_classification_2), names(rob_classification_1)
          ))
        ])
        outcomes_comparisons_studies_included <- data.frame(cbind.columns(
          list(
            outcomes_both = outcomes_both,
            outcomes_first_not_second = outcomes_first_not_second,
            outcomes_second_not_first = outcomes_second_not_first
          )
        ))
        outcomes_missing_studies <- vector()
        rob1 <- list()
        rob2 <- list()
        rob1_classification_only <- list()
        rob2_classification_only <- list()
        rob1_overall_classification_only <- list()
        rob2_overall_classification_only <- list()
        if (length(outcomes_both) >0) {
          # Some outcomes may not contain the same studies
          for (i in 1:length(outcomes_both)) {
            rob1[[i]] <- data.frame(rob_classification_1[names(rob_classification_1) == outcomes_both[i]])
            colnames(rob1[[i]]) <- str_remove_all(colnames(rob1[[i]]),paste0(outcomes_both[i], "."))
            rob1[[i]] <- rob1[[i]][order(rob1[[i]]$study_id), ]
            rob2[[i]] <- data.frame(rob_classification_2[names(rob_classification_2) == outcomes_both[i]])
            colnames(rob2[[i]]) <- str_remove_all(colnames(rob2[[i]]),paste0(outcomes_both[i], "."))
            rob2[[i]] <- rob2[[i]][order(rob2[[i]]$study_id), ]
            rob1_classification_only[[i]] <- data.frame(rob_classification_only_1[names(rob_classification_only_1) == outcomes_both[i]])
            colnames(rob1_classification_only[[i]]) <- str_remove_all(colnames(rob1_classification_only[[i]]),paste0(outcomes_both[i], "."))
            rob2_classification_only[[i]] <- data.frame(rob_classification_only_2[names(rob_classification_only_2) == outcomes_both[i]])
            colnames(rob2_classification_only[[i]]) <- str_remove_all(colnames(rob2_classification_only[[i]]),paste0(outcomes_both[i], "."))
            rob1_overall_classification_only[[i]] <- data.frame(rob_overall_classification_only_1[names(rob_overall_classification_only_1) == outcomes_both[i]])
            colnames(rob1_overall_classification_only[[i]]) <- str_remove_all(colnames(rob1_overall_classification_only[[i]]),paste0(outcomes_both[i], "."))
            rob2_overall_classification_only[[i]] <- data.frame(rob_overall_classification_only_2[names(rob_overall_classification_only_2) == outcomes_both[i]])
            colnames(rob2_overall_classification_only[[i]]) <- str_remove_all(colnames(rob2_overall_classification_only[[i]]),paste0(outcomes_both[i], "."))
            # Now remove the studies which both did not select for extraction
            rob1[[i]] <- rob1[[i]][! is.na(match(rob1[[i]]$study_id,studies_both)),]
            rob2[[i]] <- rob2[[i]][! is.na(match(rob2[[i]]$study_id,studies_both)),]
            rob1_classification_only[[i]] <- rob1_classification_only[[i]][! is.na(match(rob1_classification_only[[i]]$study_id,studies_both)),]
            rob2_classification_only[[i]] <- rob2_classification_only[[i]][! is.na(match(rob2_classification_only[[i]]$study_id,studies_both)),]
            rob1_overall_classification_only[[i]] <- rob1_overall_classification_only[[i]][! is.na(match(rob1_overall_classification_only[[i]]$study_id,studies_both)),]
            rob2_overall_classification_only[[i]] <- rob2_overall_classification_only[[i]][! is.na(match(rob2_overall_classification_only[[i]]$study_id,studies_both)),]
            # There may still be some outcomes not extracted for both studies
            if (! identical(rob1[[i]]$study_id, rob2[[i]]$study_id)) {
              extracted_first_not_second <- rob1[[i]]$study_id[is.na(match(rob1[[i]]$study_id, rob2[[i]]$study_id))]
              if (length(extracted_first_not_second) >0) {
                outcomes_missing_studies <- c(outcomes_missing_studies,
                                              paste0(extracted_first_not_second, ": ", rob1[[i]]$outcome_name[1], " extracted by first reviewer but not by second reviewer")
                )
                rob1[[i]] <- rob1[[i]][is.na(match(rob1[[i]]$study_id, extracted_first_not_second)),]
                rob1_classification_only[[i]] <- rob1_classification_only[[i]][is.na(match(rob1_classification_only[[i]]$study_id, extracted_first_not_second)),]
                rob1_overall_classification_only[[i]] <- rob1_overall_classification_only[[i]][is.na(match(rob1_overall_classification_only[[i]]$study_id, extracted_first_not_second)),]
              }
              extracted_second_not_first <- rob2[[i]]$study_id[is.na(match(rob2[[i]]$study_id, rob1[[i]]$study_id))]
              if (length(extracted_second_not_first) >0) {
                outcomes_missing_studies <- c(outcomes_missing_studies,
                                              paste0(extracted_second_not_first, ": ", rob2[[i]]$outcome_name[1], " extracted by second reviewer but not by first reviewer")
                )
                rob2[[i]] <- rob2[[i]][is.na(match(rob2[[i]]$study_id, extracted_second_not_first)),]
                rob2_classification_only[[i]] <- rob2_classification_only[[i]][is.na(match(rob2_classification_only[[i]]$study_id, extracted_second_not_first)),]
                rob2_overall_classification_only[[i]] <- rob2_overall_classification_only[[i]][is.na(match(rob2_overall_classification_only[[i]]$study_id, extracted_second_not_first)),]
              }
            }
          }
        }
        rob1 <- do.call(rbind.data.frame, rob1)
        rob2 <- do.call(rbind.data.frame, rob2)
        rob1_classification_only <- do.call(rbind.data.frame, rob1_classification_only)
        rob2_classification_only <- do.call(rbind.data.frame, rob2_classification_only)
        rob1_overall_classification_only <- do.call(rbind.data.frame, rob1_overall_classification_only)
        rob2_overall_classification_only <- do.call(rbind.data.frame, rob2_overall_classification_only)
        # Prepare for comparison
        rob1[rob1 == "PY = Probably Yes"] <- "Y = Yes"
        rob1[rob1 == "PN = Probably No"] <- "N = No"
        rob1[is.na(rob1)] <- ""
        rob2[rob2 == "PY = Probably Yes"] <- "Y = Yes"
        rob2[rob2 == "PN = Probably No"] <- "N = No"
        rob2[is.na(rob2)] <- ""
        Differences_classification <- data.frame(rob1 == rob2)
        # The study and outcome details
        Differences_classification$study_id <- rob1$study_id
        Differences_classification$outcome_name <- rob1$outcome_name
        rob1_classification_only[is.na(rob1_classification_only)] <- ""
        rob2_classification_only[is.na(rob2_classification_only)] <- ""
        Differences_classification_only <- data.frame(rob1_classification_only == rob2_classification_only)
        # The robins-i domains are entered directly and covered by Differences file
        Differences_classification_only <- Differences_classification_only[
          , is.na(match(colnames(Differences_classification_only), 
                        c("robins_i_domain_1", "robins_i_domain_2", "robins_i_domain_3",
                          "robins_i_domain_4_ITT", "robins_i_domain_4_PP", "robins_i_domain_5",
                          "robins_i_domain_6", "robins_i_domain_7")
          ))
        ]
        # The study and outcome details
        Differences_classification_only$study_id <- rob1_classification_only$study_id
        Differences_classification_only$outcome_name <- rob1_classification_only$outcome_name
        rob1_overall_classification_only[is.na(rob1_overall_classification_only)] <- ""
        rob2_overall_classification_only[is.na(rob2_overall_classification_only)] <- ""
        Differences_overall_classification_only <- data.frame(rob1_overall_classification_only == rob2_overall_classification_only) 
        # The study and outcome details
        Differences_overall_classification_only$study_id <- rob1_overall_classification_only$study_id
        Differences_overall_classification_only$outcome_name <- rob1_overall_classification_only$outcome_name
        # Completed sections - 5 ####
        # Now go through the differences
        # More complex than baseline
        # To locate the data row, some processing is necessary
        study_outcome_first <- paste0(first$unprocessed$study_id, "_", first$unprocessed$outcome_name)
        study_outcome_first[! is.na(first$unprocessed$outcome_additional_name)] <- paste0(
          study_outcome_first[! is.na(first$unprocessed$outcome_additional_name)], "_",
          first$unprocessed$outcome_additional_name[! is.na(first$unprocessed$outcome_additional_name)]
        )
        study_outcome_second <- paste0(second$unprocessed$study_id, "_", second$unprocessed$outcome_name)
        study_outcome_second[! is.na(second$unprocessed$outcome_additional_name)] <- paste0(
          study_outcome_second[! is.na(second$unprocessed$outcome_additional_name)], "_",
          second$unprocessed$outcome_additional_name[! is.na(second$unprocessed$outcome_additional_name)]
        )
        # Change NA to "" in unprocessed
        first$unprocessed[is.na(first$unprocessed)] = ""
        second$unprocessed[is.na(second$unprocessed)] = ""
        # To get the field details
        row_headings_rob <- row_headings_rob[
          substr(row_headings_rob$section, 1,3) == "rob"
          ,
        ]
        for (j in 4:6){
          for (i in 2:nrow(row_headings_rob)) {
            if (is.na(row_headings_rob[i,j])) {
              row_headings_rob[i,j] <- row_headings_rob[(i-1),j]
            }
          }
        }
        # Completed sections - 6 ####
        # Now get the required details
        if (nrow(Differences_classification) >0) {
          data_differences_rob_classification <- lapply(
            1:nrow(Differences_classification),
            function(x) {
              mismatch_columns <- colnames(Differences_classification)[Differences_classification[x,] == FALSE]
              if (length(mismatch_columns) > 0) {
                # Some classifications may be generic and some may be outcome specific
                # Map the rob_names in rob classifications to the field names; the remaining are calculated and covered in overall risk of bias comparison
                mismatch_columns_present <- mismatch_columns[
                  ! is.na(match(mismatch_columns, outcome_specific_to_generic$rob_classification_name))
                ]
                mismatch_columns_conversions <- data.frame(outcome_specific_to_generic[
                  ! is.na(match(outcome_specific_to_generic$rob_classification_name, mismatch_columns_present)) 
                  ,])
                mismatch_columns_details <- data.frame(
                  study_id = rep(Differences_classification$study_id[x],length(mismatch_columns_present)),
                  rob_name = mismatch_columns_conversions$rob_classification_name,
                  outcome_specific_name = mismatch_columns_conversions$outcome_specific_name,
                  outcome_specific_column = match(mismatch_columns_conversions$outcome_specific_name,field_names$short_name),
                  outcome_specific_row_first = rep(match(
                    paste0(Differences_classification$study_id[x], "_", Differences_classification$outcome_name[x]),
                    study_outcome_first
                  ) + 4 ,length(mismatch_columns_present)),
                  outcome_specific_row_second = rep(match(
                    paste0(Differences_classification$study_id[x], "_", Differences_classification$outcome_name[x]),
                    study_outcome_second
                  ) + 4 ,length(mismatch_columns_present)),
                  generic_name = if (Differences_classification$outcome_type[x] == "subjective") {
                    mismatch_columns_conversions$generic_name_subjective
                  } else {
                    mismatch_columns_conversions$generic_name_objective
                  }
                )
                mismatch_columns_details$generic_column <- match(mismatch_columns_details$generic_name,field_names$short_name)
                mismatch_columns_details$generic_row_first <- rep(match(
                  Differences_classification$study_id[x], first$unprocessed$study_id
                ) + 4 ,length(mismatch_columns_present))
                mismatch_columns_details$generic_row_second <- rep(match(
                  Differences_classification$study_id[x], second$unprocessed$study_id
                ) + 4 ,length(mismatch_columns_present))
                mismatch_columns_details$data_outcome_specific_row_first[! is.na(mismatch_columns_details$outcome_specific_column)] <- t(
                  first$unprocessed[
                    ( unique(mismatch_columns_details$outcome_specific_row_first[! is.na(mismatch_columns_details$outcome_specific_column)])-4)
                    ,(mismatch_columns_details$outcome_specific_column[! is.na(mismatch_columns_details$outcome_specific_column)]-1)]
                )
                mismatch_columns_details$data_outcome_specific_row_second[! is.na(mismatch_columns_details$outcome_specific_column)] <- t(
                  second$unprocessed[
                    ( unique(mismatch_columns_details$outcome_specific_row_second[! is.na(mismatch_columns_details$outcome_specific_column)])-4)
                    ,(mismatch_columns_details$outcome_specific_column[! is.na(mismatch_columns_details$outcome_specific_column)]-1)]
                )
                mismatch_columns_details$data_generic_row_first[! is.na(mismatch_columns_details$generic_column)] <- t(
                  first$unprocessed[
                    ( unique(mismatch_columns_details$generic_row_first[! is.na(mismatch_columns_details$generic_column)])-4)
                    ,(mismatch_columns_details$generic_column[! is.na(mismatch_columns_details$generic_column)]-1)]
                )
                mismatch_columns_details$data_generic_row_second[! is.na(mismatch_columns_details$generic_column)] <- t(
                  second$unprocessed[
                    ( unique(mismatch_columns_details$generic_row_second[! is.na(mismatch_columns_details$generic_column)])-4)
                    ,(mismatch_columns_details$generic_column[! is.na(mismatch_columns_details$generic_column)]-1)]
                )
                # Now get the details of the row names
                mismatch_columns_details <- cbind.data.frame(
                  mismatch_columns_details,
                  row_headings_rob[match(mismatch_columns_details$outcome_specific_name,
                                         row_headings_rob$short_name),4:7],
                  row_headings_rob[match(mismatch_columns_details$generic_name,
                                         row_headings_rob$short_name),4:7]
                  
                )
                colnames(mismatch_columns_details)[(ncol(mismatch_columns_details)-7):(ncol(mismatch_columns_details)-4)] <-
                  paste0(
                    "outcome_specific", "_",
                    colnames(mismatch_columns_details)[(ncol(mismatch_columns_details)-7):(ncol(mismatch_columns_details)-4)]
                  )
                colnames(mismatch_columns_details)[(ncol(mismatch_columns_details)-3):(ncol(mismatch_columns_details))] <-
                  paste0(
                    "generic", "_",
                    colnames(mismatch_columns_details)[(ncol(mismatch_columns_details)-3):(ncol(mismatch_columns_details))]
                  )
                
                # Is the difference due to outcome-specific or generic data or both?
                # For comparison, convert PY to Y and PN to N
                Differences_outcome_specific_generic <- data.frame(
                  outcome_specific_data_first = mismatch_columns_details$data_outcome_specific_row_first,
                  outcome_specific_data_second = mismatch_columns_details$data_outcome_specific_row_second,
                  generic_data_first = mismatch_columns_details$data_generic_row_first,
                  generic_data_second = mismatch_columns_details$data_generic_row_second
                )
                Differences_outcome_specific_generic[Differences_outcome_specific_generic == "PY = Probably Yes"] <- "Y = Yes"
                Differences_outcome_specific_generic[Differences_outcome_specific_generic == "PN = Probably No"] <- "N = No"
                Differences_outcome_specific_generic[is.na(Differences_outcome_specific_generic)] <- ""
                Differences_outcome_specific_generic$outcome_specific_data_different <- 
                  (Differences_outcome_specific_generic$outcome_specific_data_first != Differences_outcome_specific_generic$outcome_specific_data_second)
                Differences_outcome_specific_generic$generic_data_different <- 
                  (Differences_outcome_specific_generic$generic_data_first != Differences_outcome_specific_generic$generic_data_second)
                Differences_outcome_specific_generic$which_data_is_different[
                  (Differences_outcome_specific_generic$outcome_specific_data_different == TRUE) &
                    (Differences_outcome_specific_generic$generic_data_different == TRUE)
                ] <- "Both"
                Differences_outcome_specific_generic$which_data_is_different[
                  (Differences_outcome_specific_generic$outcome_specific_data_different == TRUE) &
                    (Differences_outcome_specific_generic$generic_data_different == FALSE)
                ] <- "Outcome specific"
                Differences_outcome_specific_generic$which_data_is_different[
                  (Differences_outcome_specific_generic$outcome_specific_data_different == FALSE) &
                    (Differences_outcome_specific_generic$generic_data_different == TRUE)
                ] <- "Generic"
                
                # Should quotes and comments be included?
                mismatch_columns_details$outcome_specific_quotes_comments[! is.na(mismatch_columns_details$outcome_specific_column)] <-
                  str_detect(mismatch_columns_details$outcome_specific_name[! is.na(mismatch_columns_details$outcome_specific_column)],
                             "_classification")
                mismatch_columns_details$generic_quotes_comments[! is.na(mismatch_columns_details$generic_column)] <-
                  str_detect(mismatch_columns_details$generic_name[! is.na(mismatch_columns_details$generic_column)],
                             "_classification")
                # Add quotes and comments to the data
                mismatch_columns_details$data_outcome_specific_row_first[
                  (! is.na(mismatch_columns_details$outcome_specific_column)) &
                    (mismatch_columns_details$outcome_specific_quotes_comments == TRUE)
                ] <- paste0(
                  "Classification: ",
                  mismatch_columns_details$data_outcome_specific_row_first[
                    (! is.na(mismatch_columns_details$outcome_specific_column)) &
                      (mismatch_columns_details$outcome_specific_quotes_comments == TRUE)
                  ],
                  "; Quotes: ",
                  t(
                    first$unprocessed[
                      ( unique(mismatch_columns_details$outcome_specific_row_first[
                        (! is.na(mismatch_columns_details$outcome_specific_column)) &
                          (mismatch_columns_details$outcome_specific_quotes_comments == TRUE)
                      ])-4)
                      ,(mismatch_columns_details$outcome_specific_column[
                        (! is.na(mismatch_columns_details$outcome_specific_column)) &
                          (mismatch_columns_details$outcome_specific_quotes_comments == TRUE)
                      ])]
                  ),
                  "; Comments: ",
                  t(
                    first$unprocessed[
                      ( unique(mismatch_columns_details$outcome_specific_row_first[
                        (! is.na(mismatch_columns_details$outcome_specific_column)) &
                          (mismatch_columns_details$outcome_specific_quotes_comments == TRUE)
                      ])-4)
                      ,(mismatch_columns_details$outcome_specific_column[
                        (! is.na(mismatch_columns_details$outcome_specific_column)) &
                          (mismatch_columns_details$outcome_specific_quotes_comments == TRUE)
                      ]+1)]
                  )
                )
                mismatch_columns_details$data_outcome_specific_row_second[
                  (! is.na(mismatch_columns_details$outcome_specific_column)) &
                    (mismatch_columns_details$outcome_specific_quotes_comments == TRUE)
                ] <- paste0(
                  "Classification: ",
                  mismatch_columns_details$data_outcome_specific_row_second[
                    (! is.na(mismatch_columns_details$outcome_specific_column)) &
                      (mismatch_columns_details$outcome_specific_quotes_comments == TRUE)
                  ],
                  "; Quotes: ",
                  t(
                    second$unprocessed[
                      ( unique(mismatch_columns_details$outcome_specific_row_second[
                        (! is.na(mismatch_columns_details$outcome_specific_column)) &
                          (mismatch_columns_details$outcome_specific_quotes_comments == TRUE)
                      ])-4)
                      ,(mismatch_columns_details$outcome_specific_column[
                        (! is.na(mismatch_columns_details$outcome_specific_column)) &
                          (mismatch_columns_details$outcome_specific_quotes_comments == TRUE)
                      ])]
                  ),
                  "; Comments: ",
                  t(
                    second$unprocessed[
                      ( unique(mismatch_columns_details$outcome_specific_row_second[
                        (! is.na(mismatch_columns_details$outcome_specific_column)) &
                          (mismatch_columns_details$outcome_specific_quotes_comments == TRUE)
                      ])-4)
                      ,(mismatch_columns_details$outcome_specific_column[
                        (! is.na(mismatch_columns_details$outcome_specific_column)) &
                          (mismatch_columns_details$outcome_specific_quotes_comments == TRUE)
                      ]+1)]
                  )
                )
                mismatch_columns_details$data_generic_row_first[
                  (! is.na(mismatch_columns_details$generic_column)) &
                    (mismatch_columns_details$generic_quotes_comments == TRUE)
                ] <- paste0(
                  "Classification: ",
                  mismatch_columns_details$data_generic_row_first[
                    (! is.na(mismatch_columns_details$generic_column)) &
                      (mismatch_columns_details$generic_quotes_comments == TRUE)
                  ],
                  "; Quotes: ",
                  t(
                    first$unprocessed[
                      ( unique(mismatch_columns_details$generic_row_first[
                        (! is.na(mismatch_columns_details$generic_column)) &
                          (mismatch_columns_details$generic_quotes_comments == TRUE)
                      ])-4)
                      ,(mismatch_columns_details$generic_column[
                        (! is.na(mismatch_columns_details$generic_column)) &
                          (mismatch_columns_details$generic_quotes_comments == TRUE)
                      ])]
                  ),
                  "; Comments: ",
                  t(
                    first$unprocessed[
                      ( unique(mismatch_columns_details$generic_row_first[
                        (! is.na(mismatch_columns_details$generic_column)) &
                          (mismatch_columns_details$generic_quotes_comments == TRUE)
                      ])-4)
                      ,(mismatch_columns_details$generic_column[
                        (! is.na(mismatch_columns_details$generic_column)) &
                          (mismatch_columns_details$generic_quotes_comments == TRUE)
                      ]+1)]
                  )
                )
                mismatch_columns_details$data_generic_row_second[
                  (! is.na(mismatch_columns_details$generic_column)) &
                    (mismatch_columns_details$generic_quotes_comments == TRUE)
                ] <- paste0(
                  "Classification: ",
                  mismatch_columns_details$data_generic_row_second[
                    (! is.na(mismatch_columns_details$generic_column)) &
                      (mismatch_columns_details$generic_quotes_comments == TRUE)
                  ],
                  "; Quotes: ",
                  t(
                    second$unprocessed[
                      ( unique(mismatch_columns_details$generic_row_second[
                        (! is.na(mismatch_columns_details$generic_column)) &
                          (mismatch_columns_details$generic_quotes_comments == TRUE)
                      ])-4)
                      ,(mismatch_columns_details$generic_column[
                        (! is.na(mismatch_columns_details$generic_column)) &
                          (mismatch_columns_details$generic_quotes_comments == TRUE)
                      ])]
                  ),
                  "; Comments: ",
                  t(
                    second$unprocessed[
                      ( unique(mismatch_columns_details$generic_row_second[
                        (! is.na(mismatch_columns_details$generic_column)) &
                          (mismatch_columns_details$generic_quotes_comments == TRUE)
                      ])-4)
                      ,(mismatch_columns_details$generic_column[
                        (! is.na(mismatch_columns_details$generic_column)) &
                          (mismatch_columns_details$generic_quotes_comments == TRUE)
                      ]+1)]
                  )
                )
                mismatch_columns_details$data_first[
                  Differences_outcome_specific_generic$which_data_is_different == "Outcome specific"
                ] <- mismatch_columns_details$data_outcome_specific_row_first[
                  Differences_outcome_specific_generic$which_data_is_different == "Outcome specific"
                ]
                mismatch_columns_details$data_first[
                  Differences_outcome_specific_generic$which_data_is_different == "Generic"
                ] <- mismatch_columns_details$data_generic_row_first[
                  Differences_outcome_specific_generic$which_data_is_different == "Generic"
                ]
                mismatch_columns_details$data_first[
                  Differences_outcome_specific_generic$which_data_is_different == "Both"
                ] <- paste0(
                  "Generic: ",
                  mismatch_columns_details$data_generic_row_first[
                    Differences_outcome_specific_generic$which_data_is_different == "Both"
                  ], "; Outcome specific: ",
                  mismatch_columns_details$data_outcome_specific_row_first[
                    Differences_outcome_specific_generic$which_data_is_different == "Both"
                  ]
                ) 
                mismatch_columns_details$data_second[
                  Differences_outcome_specific_generic$which_data_is_different == "Outcome specific"
                ] <- mismatch_columns_details$data_outcome_specific_row_second[
                  Differences_outcome_specific_generic$which_data_is_different == "Outcome specific"
                ]
                mismatch_columns_details$data_second[
                  Differences_outcome_specific_generic$which_data_is_different == "Generic"
                ] <- mismatch_columns_details$data_generic_row_second[
                  Differences_outcome_specific_generic$which_data_is_different == "Generic"
                ]
                mismatch_columns_details$data_second[
                  Differences_outcome_specific_generic$which_data_is_different == "Both"
                ] <- paste0(
                  "Generic: ",
                  mismatch_columns_details$data_generic_row_second[
                    Differences_outcome_specific_generic$which_data_is_different == "Both"
                  ], "; Outcome specific: ",
                  mismatch_columns_details$data_outcome_specific_row_second[
                    Differences_outcome_specific_generic$which_data_is_different == "Both"
                  ]
                ) 
                
                # Excel file locations
                mismatch_columns_details$outcome_specific_Excel_locations_first[! is.na(mismatch_columns_details$outcome_specific_column)] <-
                  paste0(int2col(mismatch_columns_details$outcome_specific_column[! is.na(mismatch_columns_details$outcome_specific_column)]), 
                         mismatch_columns_details$outcome_specific_row_first[! is.na(mismatch_columns_details$outcome_specific_column)] 
                  )
                mismatch_columns_details$outcome_specific_Excel_locations_first[
                  (! is.na(mismatch_columns_details$outcome_specific_column)) &
                    (mismatch_columns_details$outcome_specific_quotes_comments == TRUE)
                ] <- paste0(
                  mismatch_columns_details$outcome_specific_Excel_locations_first[
                    (! is.na(mismatch_columns_details$outcome_specific_column)) &
                      (mismatch_columns_details$outcome_specific_quotes_comments == TRUE)
                  ], ":",
                  int2col(mismatch_columns_details$outcome_specific_column[
                    (! is.na(mismatch_columns_details$outcome_specific_column)) &
                      (mismatch_columns_details$outcome_specific_quotes_comments == TRUE)
                  ] + 2), 
                  mismatch_columns_details$outcome_specific_row_first[
                    (! is.na(mismatch_columns_details$outcome_specific_column)) &
                      (mismatch_columns_details$outcome_specific_quotes_comments == TRUE)
                  ] 
                )
                mismatch_columns_details$outcome_specific_Excel_locations_second[! is.na(mismatch_columns_details$outcome_specific_column)] <-
                  paste0(int2col(mismatch_columns_details$outcome_specific_column[! is.na(mismatch_columns_details$outcome_specific_column)]), 
                         mismatch_columns_details$outcome_specific_row_second[! is.na(mismatch_columns_details$outcome_specific_column)] 
                  )
                mismatch_columns_details$outcome_specific_Excel_locations_second[
                  (! is.na(mismatch_columns_details$outcome_specific_column)) &
                    (mismatch_columns_details$outcome_specific_quotes_comments == TRUE)
                ] <- paste0(
                  mismatch_columns_details$outcome_specific_Excel_locations_second[
                    (! is.na(mismatch_columns_details$outcome_specific_column)) &
                      (mismatch_columns_details$outcome_specific_quotes_comments == TRUE)
                  ], ":",
                  int2col(mismatch_columns_details$outcome_specific_column[
                    (! is.na(mismatch_columns_details$outcome_specific_column)) &
                      (mismatch_columns_details$outcome_specific_quotes_comments == TRUE)
                  ]+2), 
                  mismatch_columns_details$outcome_specific_row_second[
                    (! is.na(mismatch_columns_details$outcome_specific_column)) &
                      (mismatch_columns_details$outcome_specific_quotes_comments == TRUE)
                  ] 
                )
                mismatch_columns_details$generic_Excel_locations_first[! is.na(mismatch_columns_details$generic_column)] <-
                  paste0(int2col(mismatch_columns_details$generic_column[! is.na(mismatch_columns_details$generic_column)]), 
                         mismatch_columns_details$generic_row_first[! is.na(mismatch_columns_details$generic_column)] 
                  )
                mismatch_columns_details$generic_Excel_locations_first[
                  (! is.na(mismatch_columns_details$generic_column)) &
                    (mismatch_columns_details$generic_quotes_comments == TRUE)
                ] <- paste0(
                  mismatch_columns_details$generic_Excel_locations_first[
                    (! is.na(mismatch_columns_details$generic_column)) &
                      (mismatch_columns_details$generic_quotes_comments == TRUE)
                  ], ":",
                  int2col(mismatch_columns_details$generic_column[
                    (! is.na(mismatch_columns_details$generic_column)) &
                      (mismatch_columns_details$generic_quotes_comments == TRUE)
                  ] + 2), 
                  mismatch_columns_details$generic_row_first[
                    (! is.na(mismatch_columns_details$generic_column)) &
                      (mismatch_columns_details$generic_quotes_comments == TRUE)
                  ] 
                )
                mismatch_columns_details$generic_Excel_locations_second[! is.na(mismatch_columns_details$generic_column)] <-
                  paste0(int2col(mismatch_columns_details$generic_column[! is.na(mismatch_columns_details$generic_column)]), 
                         mismatch_columns_details$generic_row_second[! is.na(mismatch_columns_details$generic_column)] 
                  )
                mismatch_columns_details$generic_Excel_locations_second[
                  (! is.na(mismatch_columns_details$generic_column)) &
                    (mismatch_columns_details$generic_quotes_comments == TRUE)
                ] <- paste0(
                  mismatch_columns_details$generic_Excel_locations_second[
                    (! is.na(mismatch_columns_details$generic_column)) &
                      (mismatch_columns_details$generic_quotes_comments == TRUE)
                  ], ":",
                  int2col(mismatch_columns_details$generic_column[
                    (! is.na(mismatch_columns_details$generic_column)) &
                      (mismatch_columns_details$generic_quotes_comments == TRUE)
                  ]+2), 
                  mismatch_columns_details$generic_row_second[
                    (! is.na(mismatch_columns_details$generic_column)) &
                      (mismatch_columns_details$generic_quotes_comments == TRUE)
                  ] 
                )
                mismatch_columns_details$Excel_locations_first[
                  Differences_outcome_specific_generic$which_data_is_different == "Outcome specific"
                ] <- mismatch_columns_details$outcome_specific_Excel_locations_first[
                  Differences_outcome_specific_generic$which_data_is_different == "Outcome specific"
                ]
                mismatch_columns_details$Excel_locations_first[
                  Differences_outcome_specific_generic$which_data_is_different == "Generic"
                ] <- mismatch_columns_details$generic_Excel_locations_first[
                  Differences_outcome_specific_generic$which_data_is_different == "Generic"
                ]
                mismatch_columns_details$Excel_locations_first[
                  Differences_outcome_specific_generic$which_data_is_different == "Both"
                ] <- paste0(
                  "Generic: ", 
                  mismatch_columns_details$outcome_specific_Excel_locations_first[
                    Differences_outcome_specific_generic$which_data_is_different == "Both"
                  ], "; Outcome specific: ",
                  mismatch_columns_details$outcome_specific_Excel_locations_first[
                    Differences_outcome_specific_generic$which_data_is_different == "Both"
                  ]
                )
                mismatch_columns_details$Excel_locations_second[
                  Differences_outcome_specific_generic$which_data_is_different == "Outcome specific"
                ] <- mismatch_columns_details$outcome_specific_Excel_locations_second[
                  Differences_outcome_specific_generic$which_data_is_different == "Outcome specific"
                ]
                mismatch_columns_details$Excel_locations_second[
                  Differences_outcome_specific_generic$which_data_is_different == "Generic"
                ] <- mismatch_columns_details$generic_Excel_locations_second[
                  Differences_outcome_specific_generic$which_data_is_different == "Generic"
                ]
                mismatch_columns_details$Excel_locations_second[
                  Differences_outcome_specific_generic$which_data_is_different == "Both"
                ] <- paste0(
                  "Generic: ", 
                  mismatch_columns_details$outcome_specific_Excel_locations_second[
                    Differences_outcome_specific_generic$which_data_is_different == "Both"
                  ], "; Outcome specific: ",
                  mismatch_columns_details$outcome_specific_Excel_locations_second[
                    Differences_outcome_specific_generic$which_data_is_different == "Both"
                  ]
                )
                # Get the correct headings
                mismatch_columns_details$row_1_section_name[
                  Differences_outcome_specific_generic$which_data_is_different == "Outcome specific"
                ] <- mismatch_columns_details$outcome_specific_row_1_section_name[
                  Differences_outcome_specific_generic$which_data_is_different == "Outcome specific"
                ]
                mismatch_columns_details$row_1_section_name[
                  Differences_outcome_specific_generic$which_data_is_different == "Generic"
                ] <- mismatch_columns_details$generic_row_1_section_name[
                  Differences_outcome_specific_generic$which_data_is_different == "Generic"
                ]
                mismatch_columns_details$row_1_section_name[
                  Differences_outcome_specific_generic$which_data_is_different == "Both"
                ] <- paste0(
                  "Generic: ", 
                  mismatch_columns_details$outcome_specific_row_1_section_name[
                    Differences_outcome_specific_generic$which_data_is_different == "Both"
                  ], "; Outcome specific: ",
                  mismatch_columns_details$outcome_specific_row_1_section_name[
                    Differences_outcome_specific_generic$which_data_is_different == "Both"
                  ]
                )
                mismatch_columns_details$row_2_column_name[
                  Differences_outcome_specific_generic$which_data_is_different == "Outcome specific"
                ] <- mismatch_columns_details$outcome_specific_row_2_column_name[
                  Differences_outcome_specific_generic$which_data_is_different == "Outcome specific"
                ]
                mismatch_columns_details$row_2_column_name[
                  Differences_outcome_specific_generic$which_data_is_different == "Generic"
                ] <- mismatch_columns_details$generic_row_2_column_name[
                  Differences_outcome_specific_generic$which_data_is_different == "Generic"
                ]
                mismatch_columns_details$row_2_column_name[
                  Differences_outcome_specific_generic$which_data_is_different == "Both"
                ] <- paste0(
                  "Generic: ", 
                  mismatch_columns_details$outcome_specific_row_2_column_name[
                    Differences_outcome_specific_generic$which_data_is_different == "Both"
                  ], "; Outcome specific: ",
                  mismatch_columns_details$outcome_specific_row_2_column_name[
                    Differences_outcome_specific_generic$which_data_is_different == "Both"
                  ]
                )
                mismatch_columns_details$row_3_details[
                  Differences_outcome_specific_generic$which_data_is_different == "Outcome specific"
                ] <- mismatch_columns_details$outcome_specific_row_3_details[
                  Differences_outcome_specific_generic$which_data_is_different == "Outcome specific"
                ]
                mismatch_columns_details$row_3_details[
                  Differences_outcome_specific_generic$which_data_is_different == "Generic"
                ] <- mismatch_columns_details$generic_row_3_details[
                  Differences_outcome_specific_generic$which_data_is_different == "Generic"
                ]
                mismatch_columns_details$row_3_details[
                  Differences_outcome_specific_generic$which_data_is_different == "Both"
                ] <- paste0(
                  "Generic: ", 
                  mismatch_columns_details$outcome_specific_row_3_details[
                    Differences_outcome_specific_generic$which_data_is_different == "Both"
                  ], "; Outcome specific: ",
                  mismatch_columns_details$outcome_specific_row_3_details[
                    Differences_outcome_specific_generic$which_data_is_different == "Both"
                  ]
                )
                # The details of row 4 are already included in the data
                mismatch_columns_details$row_4_intervention <- NA
                # Now in the standard format
                data_differences_each_row <- cbind.data.frame(
                  paste0(mismatch_columns_details$study_id,": ", Differences_classification$outcome_name[x]),
                  mismatch_columns_details$row_1_section_name,
                  mismatch_columns_details$row_2_column_name,
                  mismatch_columns_details$row_3_details,
                  mismatch_columns_details$row_4_intervention,
                  mismatch_columns_details$Excel_locations_first,
                  mismatch_columns_details$Excel_locations_second,
                  mismatch_columns_details$data_first,
                  mismatch_columns_details$data_second,
                  rep(NA, nrow(mismatch_columns_details)), rep(NA, nrow(mismatch_columns_details)), rep(NA, nrow(mismatch_columns_details))
                )
                return(data_differences_each_row)
              }
            }
          )
          data_differences_rob_classification <- do.call(rbind.data.frame, data_differences_rob_classification)
          if (nrow(data_differences_rob_classification) > 0) {
            colnames(data_differences_rob_classification) <- c("study_id",
                                                               "Section", "Field", "Field details", "Sub-field", 
                                                               "Excel cell - First", "Excel cell - Second", 
                                                               "Data - First", "Data - Second",
                                                               "Initial comments", "Reply", "Resolution"
            )
          }
        } else {
          data_differences_rob_classification <- data.frame(matrix(ncol=12))
          colnames(data_differences_rob_classification) <- c("study_id",
                                                             "Section", "Field", "Field details", "Sub-field", 
                                                             "Excel cell - First", "Excel cell - Second", 
                                                             "Data - First", "Data - Second",
                                                             "Initial comments", "Reply", "Resolution"
          )
          data_differences_rob_classification$study_id = "There are no differences to resolve"
        }
        # Differences classification only
        if (nrow(Differences_classification_only) >0){
          data_differences_rob_classification_only <- lapply(
            1:nrow(Differences_classification_only),
            function(x) {
              mismatch_columns <- colnames(Differences_classification_only)[Differences_classification_only[x,] == FALSE]
              if (length(mismatch_columns) >0) {
                data_differences_each_row <- cbind.data.frame(
                  rep(paste0(Differences_classification_only$study_id[x], ": ", Differences_classification_only$outcome_name[x]),length(mismatch_columns)),
                  mismatch_columns, rep(NA,length(mismatch_columns)), rep(NA,length(mismatch_columns)), rep(NA,length(mismatch_columns)),
                  rep("Not applicable: processed data",length(mismatch_columns)),
                  rep("Not applicable: processed data",length(mismatch_columns)),
                  as.vector(unlist(rob1_classification_only[x,mismatch_columns])), 
                  as.vector(unlist(rob2_classification_only[x,mismatch_columns])),
                  rep(NA,length(mismatch_columns)), rep(NA,length(mismatch_columns)), rep(NA,length(mismatch_columns))
                )
              }
            }
          )
          data_differences_rob_classification_only <- do.call(rbind.data.frame, data_differences_rob_classification_only)
          if (nrow(data_differences_rob_classification_only) > 0) {
            colnames(data_differences_rob_classification_only) <- c("study_id",
                                                                    "Section", "Field", "Field details", "Sub-field", 
                                                                    "Excel cell - First", "Excel cell - Second", 
                                                                    "Data - First", "Data - Second",
                                                                    "Initial comments", "Reply", "Resolution"
            )
          }
        } else {
          data_differences_rob_classification_only <- data.frame(matrix(ncol=12))
          colnames(data_differences_rob_classification_only) <- c("study_id",
                                                                  "Section", "Field", "Field details", "Sub-field", 
                                                                  "Excel cell - First", "Excel cell - Second", 
                                                                  "Data - First", "Data - Second",
                                                                  "Initial comments", "Reply", "Resolution"
          )
          data_differences_rob_classification_only$study_id = "There are no differences to resolve"
        }
        # Differences overall classification only
        if (nrow(Differences_overall_classification_only) >0){
          data_differences_rob_overall_classification_only <- lapply(
            1:nrow(Differences_overall_classification_only),
            function(x) {
              mismatch_columns <- colnames(Differences_overall_classification_only)[Differences_overall_classification_only[x,] == FALSE]
              if (length(mismatch_columns) >0) {
                data_differences_each_row <- cbind.data.frame(
                  rep(paste0(Differences_overall_classification_only$study_id[x], ": ", Differences_overall_classification_only$outcome_name[x]),length(mismatch_columns)),
                  mismatch_columns, rep(NA,length(mismatch_columns)), rep(NA,length(mismatch_columns)), rep(NA,length(mismatch_columns)),
                  rep("Not applicable: processed data",length(mismatch_columns)),
                  rep("Not applicable: processed data",length(mismatch_columns)),
                  as.vector(unlist(rob1_overall_classification_only[x,mismatch_columns])), 
                  as.vector(unlist(rob2_overall_classification_only[x,mismatch_columns])),
                  rep(NA,length(mismatch_columns)), rep(NA,length(mismatch_columns)), rep(NA,length(mismatch_columns))
                )
              }
            }
          )
          data_differences_rob_overall_classification_only <- do.call(rbind.data.frame, data_differences_rob_overall_classification_only)
          if (nrow(data_differences_rob_overall_classification_only) > 0) {
            colnames(data_differences_rob_overall_classification_only) <- c("study_id",
                                                                            "Section", "Field", "Field details", "Sub-field", 
                                                                            "Excel cell - First", "Excel cell - Second", 
                                                                            "Data - First", "Data - Second",
                                                                            "Initial comments", "Reply", "Resolution"
            )
          }
        } else {
          data_differences_rob_overall_classification_only <- data.frame(matrix(ncol=12))
          colnames(data_differences_rob_overall_classification_only) <- c("study_id",
                                                                          "Section", "Field", "Field details", "Sub-field", 
                                                                          "Excel cell - First", "Excel cell - Second", 
                                                                          "Data - First", "Data - Second",
                                                                          "Initial comments", "Reply", "Resolution"
          )
          data_differences_rob_overall_classification_only$study_id = "There are no differences to resolve"
        }
        # Now with outcomes
        # Completed sections - 7 #### 
        outcome1 <- first$outcome_data
        outcome2 <- second$outcome_data
        # Now keep only the studies and outcomes that have both
        outcome1 <- outcome1[
          ! is.na(match(
            paste0(outcome1$study_id, "_",outcome1$outcome_name),
            paste0(outcome2$study_id, "_",outcome2$outcome_name)
          ))
          ,]
        outcome2 <- outcome2[
          ! is.na(match(
            paste0(outcome2$study_id, "_",outcome2$outcome_name),
            paste0(outcome1$study_id, "_",outcome1$outcome_name)
          ))
          ,]
        outcome1 <- outcome1[
          order(paste0(outcome1$study_id, "_",outcome1$outcome_name))
          ,]
        outcome2 <- outcome2[
          order(paste0(outcome2$study_id, "_",outcome2$outcome_name))
          ,]
        outcome1[is.na(outcome1)] <- ""
        outcome2[is.na(outcome2)] <- ""
        Differences_outcome <- data.frame(outcome1 == outcome2)
        # The study and outcome details
        Differences_outcome$study_id <- outcome1$study_id
        Differences_outcome$outcome_name <- outcome1$outcome_name
        row_headings_outcome <- row_headings_outcome[
          row_headings_outcome$section == "outcome"
          ,
        ]
        for (j in 4:6){
          for (i in 2:nrow(row_headings_outcome)) {
            if (is.na(row_headings_outcome[i,j])) {
              row_headings_outcome[i,j] <- row_headings_outcome[(i-1),j]
            }
          }
        }
        # Get outcome column
        outcome_names_unprocessed_first <- first$unprocessed$outcome_name
        outcome_names_unprocessed_first[first$unprocessed$outcome_additional_name!= ""] <-
          paste0(outcome_names_unprocessed_first[first$unprocessed$outcome_additional_name!= ""], "_",
                 first$unprocessed$outcome_additional_name[first$unprocessed$outcome_additional_name!= ""]
          )
        outcome_names_unprocessed_second <- second$unprocessed$outcome_name
        outcome_names_unprocessed_second[second$unprocessed$outcome_additional_name!= ""] <-
          paste0(outcome_names_unprocessed_second[second$unprocessed$outcome_additional_name!= ""], "_",
                 second$unprocessed$outcome_additional_name[second$unprocessed$outcome_additional_name!= ""]
          )
        outcome_row_first <- match(
          paste0(outcome1$study_id,"_", outcome1$outcome_name),
          paste0(first$unprocessed$study_id,"_", outcome_names_unprocessed_first)
        ) + 4
        outcome_row_second <- match(
          paste0(outcome2$study_id,"_", outcome2$outcome_name),
          paste0(second$unprocessed$study_id,"_", outcome_names_unprocessed_second)
        ) + 4
        if (nrow(Differences_outcome) >0) {
          data_differences_outcome <- lapply(
            1:nrow(Differences_outcome),
            function(x) {
              mismatch_columns <- colnames(Differences_outcome)[Differences_outcome[x,] == FALSE]
              if (length(mismatch_columns) > 0) {
                mismatch_column_details <- row_headings_outcome[match(mismatch_columns, row_headings_outcome$short_name), ]
                data_differences_outcome_each_row <- cbind.data.frame(
                  rep(paste0(Differences_outcome$study_id[x], ": ", Differences_outcome$outcome_name[x]),length(mismatch_columns)),
                  mismatch_column_details[,1:4],
                  paste0(mismatch_column_details[,9], outcome_row_first[x]),
                  paste0(mismatch_column_details[,9], outcome_row_second[x]),
                  as.vector(unlist(outcome1[x,mismatch_columns])),
                  as.vector(unlist(outcome2[x,mismatch_columns])),
                  rep(NA,length(mismatch_columns)), rep(NA,length(mismatch_columns)), rep(NA,length(mismatch_columns))
                )
              }
            }
          )
          data_differences_outcome <- do.call(rbind.data.frame, data_differences_outcome)
          if (nrow(data_differences_outcome) > 0) {
            colnames(data_differences_outcome) <- c("study_id",
                                                    "Section", "Field", "Field details", "Sub-field", 
                                                    "Excel cell - First", "Excel cell - Second", 
                                                    "Data - First", "Data - Second",
                                                    "Initial comments", "Reply", "Resolution"
            )
          } else {
            data_differences_outcome <- data.frame(matrix(ncol=12))
            colnames(data_differences_outcome) <- c("study_id",
                                                    "Section", "Field", "Field details", "Sub-field", 
                                                    "Excel cell - First", "Excel cell - Second", 
                                                    "Data - First", "Data - Second",
                                                    "Initial comments", "Reply", "Resolution"
            )
            data_differences_outcome$study_id = "There are no differences to resolve"
          }
        }
        
        # Final file ####
        data_differences <- rbind.data.frame(
          data_differences,
          data_differences_rob_classification,
          data_differences_rob_classification_only,
          data_differences_rob_overall_classification_only,
          data_differences_outcome
        )
      } else {
        data_differences <- 
          data.frame(
            study_id = "There are no studies which have been selected by both the reviewers. 
            Please ensure that the names of the studies match. The study names are case sensitive. Please check for differences in punctuations and spaces between the data extraction forms."
          )
        outcomes_comparisons_studies_included <- 
          data.frame(
            study_id = "There are no studies which have been selected by both the reviewers. 
            Please ensure that the names of the studies match. The study names are case sensitive. Please check for differences in punctuations and spaces between the data extraction forms."
          )
      }
    } else {
      if ((is.null(first$unprocessed)) & (is.null(second$unprocessed))) {
        data_differences <- 
          data.frame(
            study_id = "There is no data to compare"
          )
        studies_comparison <- 
          data.frame(
            study_id = "There is no data to compare"
          )
        outcomes_comparisons_studies_included <- 
          data.frame(
            study_id = "There is no data to compare"
          )
      } else if (is.null(first$unprocessed)) {
        studies_comparison <- 
          data.frame(
            study_id = "There is no data from first reviewer"
          )
        outcomes_comparisons_studies_included <- 
          data.frame(
            study_id = "There is no data from first reviewer"
          )
        data_differences <- 
          data.frame(
            study_id = "There is no data from first reviewer"
          )
      } else {
        studies_comparison <- 
          data.frame(
            study_id = "There is no data from second reviewer"
          )
        outcomes_comparisons_studies_included <- 
          data.frame(
            study_id = "There is no data from second reviewer"
          )
        data_differences <- 
          data.frame(
            study_id = "There is no data from second reviewer"
          )
      }
    }
    comparisons <- list(
      studies_comparison,
      outcomes_comparisons_studies_included,
      data_differences
    )
    return(comparisons)
  }
  compare_data <- compare_data(first = first, second = second, field_names = field_names)
  # Output ####
  output_file <- wb_workbook()
  output_file$add_worksheet("Data_comparison")
  output_file$add_worksheet("First_RoB_domains")
  output_file$add_worksheet("First_RoB_overall")
  output_file$add_worksheet("First_Main_Results")
  output_file$add_worksheet("First_Unadjusted_Results")
  output_file$add_worksheet("First_Adjusted_Results")
  output_file$add_worksheet("First_SA_0.1_Correlation")
  output_file$add_worksheet("First_SA_0.9_Correlation")
  output_file$add_worksheet("Second_RoB_domains")
  output_file$add_worksheet("Second_RoB_overall")
  output_file$add_worksheet("Second_Main_Results")
  output_file$add_worksheet("Second_Unadjusted_Results")
  output_file$add_worksheet("Second_Adjusted_Results")
  output_file$add_worksheet("Second_SA_0.1_Correlation")
  output_file$add_worksheet("Second_SA_0.9_Correlation")
  output_file$add_data(sheet = "Data_comparison", x = compare_data[[1]], start_col = 1, row_names = FALSE, col_names = TRUE, na.strings = "")
  output_file$add_data(sheet = "Data_comparison", x = compare_data[[2]], start_col = 4, row_names = FALSE, col_names = TRUE, na.strings = "")
  output_file$add_data(sheet = "Data_comparison", x = compare_data[[3]], start_col = 7, row_names = FALSE, col_names = TRUE, na.strings = "")
  output_file$add_data(sheet = "First_RoB_domains", x = do.call(rbind.data.frame, first$rob_classification_only), row_names = FALSE, col_names = TRUE, na.strings = "")
  output_file$add_data(sheet = "First_RoB_overall", x = do.call(rbind.data.frame, first$rob_overall_classification_only), row_names = FALSE, col_names = TRUE, na.strings = "")
  output_file$add_data(sheet = "First_Main_Results", x = first$main_results, row_names = FALSE, col_names = TRUE, na.strings = "")
  output_file$add_data(sheet = "First_Unadjusted_Results", x = first$unadjusted_results, row_names = FALSE, col_names = TRUE, na.strings = "")
  output_file$add_data(sheet = "First_Adjusted_Results", x = first$adjusted_results, row_names = FALSE, col_names = TRUE, na.strings = "")
  output_file$add_data(sheet = "First_SA_0.1_Correlation", x = first$sensitivity_0.1_correlation_coefficient, row_names = FALSE, col_names = TRUE, na.strings = "")
  output_file$add_data(sheet = "First_SA_0.9_Correlation", x = first$sensitivity_0.9_correlation_coefficient, row_names = FALSE, col_names = TRUE, na.strings = "")
  output_file$add_data(sheet = "Second_RoB_domains", x = do.call(rbind.data.frame, second$rob_classification_only), row_names = FALSE, col_names = TRUE, na.strings = "")
  output_file$add_data(sheet = "Second_RoB_overall", x = do.call(rbind.data.frame, second$rob_overall_classification_only), row_names = FALSE, col_names = TRUE, na.strings = "")
  output_file$add_data(sheet = "Second_Main_Results", x = second$main_results, row_names = FALSE, col_names = TRUE, na.strings = "")
  output_file$add_data(sheet = "Second_Unadjusted_Results", x = second$unadjusted_results, row_names = FALSE, col_names = TRUE, na.strings = "")
  output_file$add_data(sheet = "Second_Adjusted_Results", x = second$adjusted_results, row_names = FALSE, col_names = TRUE, na.strings = "")
  output_file$add_data(sheet = "Second_SA_0.1_Correlation", x = second$sensitivity_0.1_correlation_coefficient, row_names = FALSE, col_names = TRUE, na.strings = "")
  output_file$add_data(sheet = "Second_SA_0.9_Correlation", x = second$sensitivity_0.9_correlation_coefficient, row_names = FALSE, col_names = TRUE, na.strings = "")
  wb_save(output_file, paste0(StorageFolder, "/Processed.xlsx"))
  return(output_file)
}
outcome_multi_arm_studies <- function(outcome_data_pre_analysis, DEF_Design) {
  # Check column names
  if (missing(DEF_Design)) {
    DEF_Design <- NULL
  }
  Sample_Pre_analysis <- data.frame(read.csv("Sample_Pre_analysis.csv", header = TRUE, na.strings = ""))
  if (! FALSE %in% (colnames(outcome_data_pre_analysis) == colnames(Sample_Pre_analysis))) {
    # Step 1: Deal with multi-armed studies ####
    outcome_data_pre_analysis_multi_arm <- outcome_data_pre_analysis
    outcome_data_pre_analysis_multi_arm$row_number <- 1:nrow(outcome_data_pre_analysis_multi_arm)
    # Convert some fields to numeric
    outcome_data_pre_analysis_multi_arm[
      ,
      setdiff(colnames(outcome_data_pre_analysis_multi_arm),
              c("study_id", "study_type",
                "unmodified_name_intervention_1","unmodified_name_intervention_2",
                "additional_name_intervention_1", "additional_name_intervention_2",
                "unmodified_outcome_name",
                "outcome_name", "outcome_type_1", "outcome_type_2",
                "outcome_definition", "outcome_better_worse",
                "outcome_data_3", "effect_measure_name", 
                "outcome_data_additional_favours_intervention_time_to_event")
      )
    ] <- lapply(outcome_data_pre_analysis_multi_arm[
      ,
      setdiff(colnames(outcome_data_pre_analysis_multi_arm),
              c("study_id", "study_type",
                "unmodified_name_intervention_1","unmodified_name_intervention_2",
                "additional_name_intervention_1", "additional_name_intervention_2",
                "unmodified_outcome_name",
                "outcome_name", "outcome_type_1", "outcome_type_2",
                "outcome_definition", "outcome_better_worse",
                "outcome_data_3", "effect_measure_name", 
                "outcome_data_additional_favours_intervention_time_to_event")
      )
    ], as.numeric)
    outcome_data_pre_analysis_multi_arm$study_outcome <- paste0(
      outcome_data_pre_analysis_multi_arm$study_id, "_",
      outcome_data_pre_analysis_multi_arm$outcome_name
    )
    unique_study_outcome <- data.frame(
      study_outcome = unique(outcome_data_pre_analysis_multi_arm$study_outcome)
    )
    unique_study_outcome$count <- sapply(
      1:nrow(unique_study_outcome),
      function(x){
        length(outcome_data_pre_analysis_multi_arm$study_outcome[
          outcome_data_pre_analysis_multi_arm$study_outcome == unique_study_outcome$study_outcome[x]
        ])
      }
    )
    unique_study_outcome$outcome_type <- sapply(
      1:nrow(unique_study_outcome),
      function(x){
        unique(outcome_data_pre_analysis_multi_arm$outcome_type_1[
          outcome_data_pre_analysis_multi_arm$study_outcome == unique_study_outcome$study_outcome[x]
        ]
        )
      }
    )
    unique_study_outcome <- unique_study_outcome[
      (unique_study_outcome$count > 1)
      ,]
    if (nrow(unique_study_outcome) > 0) {
      outcome_data <- list()
      for (i in 1:nrow(unique_study_outcome)) {
        outcome_data[[i]] <- outcome_data_pre_analysis_multi_arm[
          outcome_data_pre_analysis_multi_arm$study_outcome == unique_study_outcome$study_outcome[i]
          ,]
        # Find out if it is intervention or control group that needs modification
        if (TRUE %in% is.na(outcome_data[[i]]$additional_name_intervention_1)) {
          group_to_be_split <- "intervention_1"
        } else if (TRUE %in% is.na(outcome_data[[i]]$additional_name_intervention_2)) {
          group_to_be_split <- "intervention_2"
        } else {
          group_to_be_split <- NULL
        }
        if (! is.null(group_to_be_split)) {
          number_of_groups <- unique_study_outcome$count[i]
          # For all outcome types, the name of the outcome has to be entered in all rows and the numbers analysed have to split
          if (group_to_be_split == "intervention_1") {
            outcome_data[[i]]$additional_name_intervention_1 <- outcome_data[[i]]$additional_name_intervention_1[1]
            outcome_data[[i]]$n_analysed_each_outcome_intervention_1 <- outcome_data[[i]]$n_analysed_each_outcome_intervention_1[1]
            outcome_data[[i]]$n_analysed_each_outcome_intervention_1 <- outcome_data[[i]]$n_analysed_each_outcome_intervention_1/number_of_groups
          } else {
            outcome_data[[i]]$additional_name_intervention_2 <- outcome_data[[i]]$additional_name_intervention_2[1]
            outcome_data[[i]]$n_analysed_each_outcome_intervention_2 <- outcome_data[[i]]$n_analysed_each_outcome_intervention_2[1]
            outcome_data[[i]]$n_analysed_each_outcome_intervention_2 <- outcome_data[[i]]$n_analysed_each_outcome_intervention_2/number_of_groups
          }
          if (outcome_data[[i]]$outcome_type_1[1] == "continuous") {
            if (group_to_be_split == "intervention_1") {
              # The only thing that needs to be split (in addition to number of participants) is the standard deviation, but the mean should also be copied
              outcome_data[[i]]$outcome_data_1_intervention_1 <- outcome_data[[i]]$outcome_data_1_intervention_1[1]
              if ((! is.na(outcome_data[[i]]$outcome_data_1_intervention_1[1])) & (! is.na(outcome_data[[i]]$outcome_data_2_intervention_1[1]))) {
                outcome_data[[i]]$outcome_data_2_intervention_1 <- 
                  split_multiple_groups_continuous(
                    overall_mean = outcome_data[[i]]$outcome_data_1_intervention_1[1], 
                    pooled_sd = outcome_data[[i]]$outcome_data_2_intervention_1[1], 
                    n.participants = outcome_data[[i]]$n_analysed_each_outcome_intervention_1[1],
                    n.groups = number_of_groups)[[2]]
              }
            } else {
              outcome_data[[i]]$outcome_data_1_intervention_2 <- outcome_data[[i]]$outcome_data_1_intervention_2[1]
              if ((! is.na(outcome_data[[i]]$outcome_data_1_intervention_2[1])) & (! is.na(outcome_data[[i]]$outcome_data_2_intervention_2[1]))) {
                outcome_data[[i]]$outcome_data_2_intervention_2 <- 
                  split_multiple_groups_continuous(
                    overall_mean = outcome_data[[i]]$outcome_data_1_intervention_2[1], 
                    pooled_sd = outcome_data[[i]]$outcome_data_2_intervention_2[1], 
                    n.participants = outcome_data[[i]]$n_analysed_each_outcome_intervention_2[1],
                    n.groups = number_of_groups)[[2]]
              }
            }
          } else if (outcome_data[[i]]$outcome_type_1[1] == "count") {
            # The only thing that needs to be split (in addition to number of participants) is the number of events
            if (group_to_be_split == "intervention_1") {
              outcome_data[[i]]$outcome_data_1_intervention_1 <- outcome_data[[i]]$outcome_data_1_intervention_1[1]/number_of_groups 
            } else {
              outcome_data[[i]]$outcome_data_1_intervention_2 <- outcome_data[[i]]$outcome_data_1_intervention_2[1]/number_of_groups 
            }
          }
          else if (outcome_data[[i]]$outcome_type_1[1] == "binary") {
            # The missing data has to be split along with the number of people with events
            if (group_to_be_split == "intervention_1") {
              outcome_data[[i]]$n_missing_failure_each_outcome_intervention_1 <- outcome_data[[i]]$n_missing_failure_each_outcome_intervention_1[1]/number_of_groups
              outcome_data[[i]]$n_missing_success_each_outcome_intervention_1 <- outcome_data[[i]]$n_missing_success_each_outcome_intervention_1[1]/number_of_groups
              outcome_data[[i]]$n_missing_unrelated_each_outcome_intervention_1 <- outcome_data[[i]]$n_missing_unrelated_each_outcome_intervention_1[1]/number_of_groups
              outcome_data[[i]]$n_missing_protocol_violation_each_outcome_intervention_1 <- outcome_data[[i]]$n_missing_protocol_violation_each_outcome_intervention_1[1]/number_of_groups
              outcome_data[[i]]$n_missing_other_each_outcome_intervention_1 <- outcome_data[[i]]$n_missing_other_each_outcome_intervention_1[1]/number_of_groups
              outcome_data[[i]]$n_missing_reasons_not_stated_each_outcome_intervention_1 <- outcome_data[[i]]$n_missing_reasons_not_stated_each_outcome_intervention_1[1]/number_of_groups
              outcome_data[[i]]$outcome_data_1_intervention_1 <- outcome_data[[i]]$outcome_data_1_intervention_1[1]/number_of_groups
            } else {
              outcome_data[[i]]$n_missing_failure_each_outcome_intervention_2 <- outcome_data[[i]]$n_missing_failure_each_outcome_intervention_2[1]/number_of_groups
              outcome_data[[i]]$n_missing_success_each_outcome_intervention_2 <- outcome_data[[i]]$n_missing_success_each_outcome_intervention_2[1]/number_of_groups
              outcome_data[[i]]$n_missing_unrelated_each_outcome_intervention_2 <- outcome_data[[i]]$n_missing_unrelated_each_outcome_intervention_2[1]/number_of_groups
              outcome_data[[i]]$n_missing_protocol_violation_each_outcome_intervention_2 <- outcome_data[[i]]$n_missing_protocol_violation_each_outcome_intervention_2[1]/number_of_groups
              outcome_data[[i]]$n_missing_other_each_outcome_intervention_2 <- outcome_data[[i]]$n_missing_other_each_outcome_intervention_2[1]/number_of_groups
              outcome_data[[i]]$n_missing_reasons_not_stated_each_outcome_intervention_2 <- outcome_data[[i]]$n_missing_reasons_not_stated_each_outcome_intervention_2[1]/number_of_groups
              outcome_data[[i]]$outcome_data_1_intervention_2 <- outcome_data[[i]]$outcome_data_1_intervention_2[1]/number_of_groups
            }
          }
        }
      }
      outcome_data <- do.call(rbind.data.frame,outcome_data)
      if (nrow(outcome_data) > 0) {
        outcome_data <- outcome_data[order(outcome_data$row_number),]
        # Replace old data with new
        outcome_data_pre_analysis_multi_arm[
          ! is.na(match(outcome_data_pre_analysis_multi_arm$row_number, outcome_data$row_number))
          ,] <- outcome_data
      }
    }
    
    # Step 2: Start creating a new file in the format suitable for analysis ####
    Results_file_Main <- data.frame(read.csv("SampleData_Intervention.csv", header = TRUE, check.names = FALSE, na.strings = ""), check.names = FALSE)
    Results_file_Main <- Results_file_Main[NULL,1:28]
    Results_file_Main[1:nrow(outcome_data_pre_analysis_multi_arm),] <- NA 
    Results_file_Main$`Outcome name` <- outcome_data_pre_analysis_multi_arm$outcome_name
    Results_file_Main$`Type of outcome` <- str_to_title(outcome_data_pre_analysis_multi_arm$outcome_type_1)
    Results_file_Main$`Are more events or higher value better or worse for participants?` <- str_to_title(outcome_data_pre_analysis_multi_arm$outcome_better_worse)
    Results_file_Main$Study <- outcome_data_pre_analysis_multi_arm$study_id
    Results_file_Main$`Intervention (total number of participants)` <- outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1
    Results_file_Main$`Control (total number of participants)` <- outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2
    Results_file_Main$`Missing failure (Intervention)` <- outcome_data_pre_analysis_multi_arm$n_missing_failure_each_outcome_intervention_1
    Results_file_Main$`Missing success (Intervention)` <- outcome_data_pre_analysis_multi_arm$n_missing_success_each_outcome_intervention_1
    Results_file_Main$`Missing unrelated (Intervention)` <- outcome_data_pre_analysis_multi_arm$n_missing_unrelated_each_outcome_intervention_1
    Results_file_Main$`Missing protocol violation (Intervention)` <- outcome_data_pre_analysis_multi_arm$n_missing_protocol_violation_each_outcome_intervention_1
    Results_file_Main$`Missing other (Intervention)` <- outcome_data_pre_analysis_multi_arm$n_missing_other_each_outcome_intervention_1
    Results_file_Main$`Missing reasons not stated (Intervention)` <- outcome_data_pre_analysis_multi_arm$n_missing_reasons_not_stated_each_outcome_intervention_1
    Results_file_Main$`Missing not stated (Intervention)` <- NA
    Results_file_Main$`Missing failure (Control)` <- outcome_data_pre_analysis_multi_arm$n_missing_failure_each_outcome_intervention_2
    Results_file_Main$`Missing success (Control)` <- outcome_data_pre_analysis_multi_arm$n_missing_success_each_outcome_intervention_2
    Results_file_Main$`Missing unrelated (Control)` <- outcome_data_pre_analysis_multi_arm$n_missing_unrelated_each_outcome_intervention_2
    Results_file_Main$`Missing protocol violation (Control)` <- outcome_data_pre_analysis_multi_arm$n_missing_protocol_violation_each_outcome_intervention_2
    Results_file_Main$`Missing other (Control)` <- outcome_data_pre_analysis_multi_arm$n_missing_other_each_outcome_intervention_2
    Results_file_Main$`Missing reasons not stated (Control)` <- outcome_data_pre_analysis_multi_arm$n_missing_reasons_not_stated_each_outcome_intervention_2
    Results_file_Main$`Missing not stated (Control)` <- NA
    Results_file_Unadjusted_for_confounding_cluster_cross_over <- Results_file_Main
    # Step 3: Common conversions ####
    # Unadjusted and adjusted effect estimates to be converted to suitable format
    # First find if a log transformation is required
    outcome_data_pre_analysis_multi_arm$log_transformation_required[
      ! is.na(match(
        outcome_data_pre_analysis_multi_arm$effect_measure_name,
        c("Hazard ratio","Odds ratio","Rate ratio","Ratio of means","Risk ratio")
      ))
    ] <- TRUE
    outcome_data_pre_analysis_multi_arm$log_transformation_required[
      ! is.na(match(
        outcome_data_pre_analysis_multi_arm$effect_measure_name,
        c("Mean difference","Risk difference","Standardised mean difference")
      ))
    ] <- FALSE
    # Remove the adjusted and unadjusted values if the effect measure is missing
    outcome_data_pre_analysis_multi_arm[
      is.na(outcome_data_pre_analysis_multi_arm$effect_measure_name),
      c("effect_measure_adjusted","lci_effect_measure_adjusted","uci_effect_measure_adjusted",
        "effect_measure_unadjusted","lci_effect_measure_unadjusted","uci_effect_measure_unadjusted")
    ] <- NA
    Results_file_Main$Parameter1[
      (outcome_data_pre_analysis_multi_arm$log_transformation_required == FALSE) &
        (! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_adjusted))
    ] <- outcome_data_pre_analysis_multi_arm$effect_measure_adjusted[
      (outcome_data_pre_analysis_multi_arm$log_transformation_required == FALSE) &
        (! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_adjusted))
    ]
    Results_file_Main$Parameter1[
      (outcome_data_pre_analysis_multi_arm$log_transformation_required == TRUE) &
        (! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_adjusted))
    ] <- log(outcome_data_pre_analysis_multi_arm$effect_measure_adjusted[
      (outcome_data_pre_analysis_multi_arm$log_transformation_required == TRUE) &
        (! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_adjusted))
    ])
    Results_file_Main$Parameter2[
      (! is.na(outcome_data_pre_analysis_multi_arm$log_transformation_required)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_adjusted)) & 
        (! is.na(outcome_data_pre_analysis_multi_arm$se_effect_measure_adjusted))
    ] <- outcome_data_pre_analysis_multi_arm$se_effect_measure_adjusted[
      (! is.na(outcome_data_pre_analysis_multi_arm$log_transformation_required)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_adjusted)) & 
        (! is.na(outcome_data_pre_analysis_multi_arm$se_effect_measure_adjusted))
    ]
    Results_file_Main$Parameter2[
      (outcome_data_pre_analysis_multi_arm$log_transformation_required == TRUE) &
        (! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_adjusted)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$lci_effect_measure_adjusted)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$uci_effect_measure_adjusted)) &
        (is.na(Results_file_Main$Parameter2))
    ] <- (log(outcome_data_pre_analysis_multi_arm$uci_effect_measure_adjusted[
      (outcome_data_pre_analysis_multi_arm$log_transformation_required == TRUE) &
        (! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_adjusted)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$lci_effect_measure_adjusted)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$uci_effect_measure_adjusted)) &
        (is.na(Results_file_Main$Parameter2))
    ]) - log(outcome_data_pre_analysis_multi_arm$lci_effect_measure_adjusted[
      (outcome_data_pre_analysis_multi_arm$log_transformation_required == TRUE) &
        (! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_adjusted)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$lci_effect_measure_adjusted)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$uci_effect_measure_adjusted)) &
        (is.na(Results_file_Main$Parameter2))
    ]))/abs(2*qnorm(((1-0.95)/2)))
    Results_file_Main$Parameter2[
      (outcome_data_pre_analysis_multi_arm$log_transformation_required == FALSE) &
        (! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_adjusted)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$lci_effect_measure_adjusted)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$uci_effect_measure_adjusted)) &
        (is.na(Results_file_Main$Parameter2))
    ] <- (outcome_data_pre_analysis_multi_arm$uci_effect_measure_adjusted[
      (outcome_data_pre_analysis_multi_arm$log_transformation_required == FALSE) &
        (! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_adjusted)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$lci_effect_measure_adjusted)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$uci_effect_measure_adjusted)) &
        (is.na(Results_file_Main$Parameter2))
    ] - outcome_data_pre_analysis_multi_arm$lci_effect_measure_adjusted[
      (outcome_data_pre_analysis_multi_arm$log_transformation_required == FALSE) &
        (! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_adjusted)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$lci_effect_measure_adjusted)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$uci_effect_measure_adjusted)) &
        (is.na(Results_file_Main$Parameter2))
    ])/abs(2*qnorm(((1-0.95)/2)))
    # Now remove parameter 1 and 2 if one of them is missing
    Results_file_Main$Parameter1[is.na(Results_file_Main$Parameter2)] <- NA
    Results_file_Main$Parameter2[is.na(Results_file_Main$Parameter1)] <- NA
    # Save this as adjusted results
    Results_file_Adjusted <- Results_file_Main
    # Also note that the results are adjusted
    outcome_data_pre_analysis_multi_arm$adjusted_results <- 
      ((! is.na(Results_file_Main$Parameter1)) & (! is.na(Results_file_Main$Parameter2)))
    Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1[
      (outcome_data_pre_analysis_multi_arm$log_transformation_required == FALSE) &
        (! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_unadjusted))
    ] <- outcome_data_pre_analysis_multi_arm$effect_measure_unadjusted[
      (outcome_data_pre_analysis_multi_arm$log_transformation_required == FALSE) &
        (! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_unadjusted))
    ]
    Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1[
      (outcome_data_pre_analysis_multi_arm$log_transformation_required == TRUE) &
        (! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_unadjusted))
    ] <- log(outcome_data_pre_analysis_multi_arm$effect_measure_unadjusted[
      (outcome_data_pre_analysis_multi_arm$log_transformation_required == TRUE) &
        (! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_unadjusted))
    ])
    Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2[
      (! is.na(outcome_data_pre_analysis_multi_arm$log_transformation_required)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_unadjusted)) & 
        (! is.na(outcome_data_pre_analysis_multi_arm$se_effect_measure_unadjusted))
    ] <- outcome_data_pre_analysis_multi_arm$se_effect_measure_unadjusted[
      (! is.na(outcome_data_pre_analysis_multi_arm$log_transformation_required)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_unadjusted)) & 
        (! is.na(outcome_data_pre_analysis_multi_arm$se_effect_measure_unadjusted))
    ]
    Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2[
      (outcome_data_pre_analysis_multi_arm$log_transformation_required == TRUE) &
        (! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_unadjusted)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$lci_effect_measure_unadjusted)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$uci_effect_measure_unadjusted)) &
        (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2))
    ] <- (log(outcome_data_pre_analysis_multi_arm$uci_effect_measure_unadjusted[
      (outcome_data_pre_analysis_multi_arm$log_transformation_required == TRUE) &
        (! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_unadjusted)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$lci_effect_measure_unadjusted)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$uci_effect_measure_unadjusted)) &
        (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2))
    ]) - log(outcome_data_pre_analysis_multi_arm$lci_effect_measure_unadjusted[
      (outcome_data_pre_analysis_multi_arm$log_transformation_required == TRUE) &
        (! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_unadjusted)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$lci_effect_measure_unadjusted)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$uci_effect_measure_unadjusted)) &
        (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2))
    ]))/abs(2*qnorm(((1-0.95)/2)))
    Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2[
      (outcome_data_pre_analysis_multi_arm$log_transformation_required == FALSE) &
        (! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_unadjusted)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$lci_effect_measure_unadjusted)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$uci_effect_measure_unadjusted)) &
        (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2))
    ] <- (outcome_data_pre_analysis_multi_arm$uci_effect_measure_unadjusted[
      (outcome_data_pre_analysis_multi_arm$log_transformation_required == FALSE) &
        (! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_unadjusted)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$lci_effect_measure_unadjusted)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$uci_effect_measure_unadjusted)) &
        (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2))
    ] - outcome_data_pre_analysis_multi_arm$lci_effect_measure_unadjusted[
      (outcome_data_pre_analysis_multi_arm$log_transformation_required == FALSE) &
        (! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_unadjusted)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$lci_effect_measure_unadjusted)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$uci_effect_measure_unadjusted)) &
        (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2))
    ])/abs(2*qnorm(((1-0.95)/2)))
    # Now remove parameter 1 and 2 if one of them is missing
    Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1[is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2)] <- NA
    Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2[is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)] <- NA  
    
    # However, if only unadjusted was available, this can be used in the main results
    Results_file_Main$Parameter1[
      is.na(Results_file_Main$Parameter1) & ! is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)
    ] <- Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1[
      is.na(Results_file_Main$Parameter1) & ! is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)
    ]
    Results_file_Main$Parameter2[
      is.na(Results_file_Main$Parameter2) & ! is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2)
    ] <- Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2[
      is.na(Results_file_Main$Parameter2) & ! is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2)
    ]
    # Now change the type of outcome
    Results_file_Main$`Type of outcome`[
      (! is.na(Results_file_Main$Parameter1)) &
        (! is.na(Results_file_Main$Parameter2)) &
        (outcome_data_pre_analysis_multi_arm$log_transformation_required == FALSE)
    ] <- "Summary_Difference"
    Results_file_Main$`Type of outcome`[
      (! is.na(Results_file_Main$Parameter1)) &
        (! is.na(Results_file_Main$Parameter2)) &
        (outcome_data_pre_analysis_multi_arm$log_transformation_required == TRUE)
    ] <- "Summary_Ratio"
    Results_file_Unadjusted_for_confounding_cluster_cross_over$`Type of outcome`[
      (! is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) &
        (! is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2)) &
        (outcome_data_pre_analysis_multi_arm$log_transformation_required == FALSE)
    ] <- "Summary_Difference"
    Results_file_Unadjusted_for_confounding_cluster_cross_over$`Type of outcome`[
      (! is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) &
        (! is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2)) &
        (outcome_data_pre_analysis_multi_arm$log_transformation_required == TRUE)
    ] <- "Summary_Ratio"
    # Step 4: Outcome type-specific conversions ####
    # Binary outcomes
    Results_file_Main$Parameter1[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "binary") &
        (is.na(Results_file_Main$Parameter1)) &
        (is.na(Results_file_Main$Parameter2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "binary") &
        (is.na(Results_file_Main$Parameter1)) &
        (is.na(Results_file_Main$Parameter2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ]
    Results_file_Main$Parameter2[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "binary") &
        (is.na(Results_file_Main$Parameter2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "binary") &
        (is.na(Results_file_Main$Parameter2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ]
    # Convert percentages
    Results_file_Main$Parameter1[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "binary") &
        (is.na(Results_file_Main$Parameter1)) &
        (is.na(Results_file_Main$Parameter2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_percentage_binary_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_percentage_binary_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- round(
      outcome_data_pre_analysis_multi_arm$outcome_data_additional_percentage_binary_intervention_1[
        (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "binary") &
          (is.na(Results_file_Main$Parameter1)) &
          (is.na(Results_file_Main$Parameter2)) &
          (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_percentage_binary_intervention_1)) &
          (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_percentage_binary_intervention_2)) &
          (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
          (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
      ] *
        outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1[
          (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "binary") &
            (is.na(Results_file_Main$Parameter1)) &
            (is.na(Results_file_Main$Parameter2)) &
            (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_percentage_binary_intervention_1)) &
            (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_percentage_binary_intervention_2)) &
            (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
            (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
        ]
    )
    Results_file_Main$Parameter2[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "binary") &
        (is.na(Results_file_Main$Parameter2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_percentage_binary_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_percentage_binary_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- round(
      outcome_data_pre_analysis_multi_arm$outcome_data_additional_percentage_binary_intervention_2[
        (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "binary") &
          (is.na(Results_file_Main$Parameter2)) &
          (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_percentage_binary_intervention_1)) &
          (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_percentage_binary_intervention_2)) &
          (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
          (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
      ] *
        outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2[
          (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "binary") &
            (is.na(Results_file_Main$Parameter2)) &
            (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_percentage_binary_intervention_1)) &
            (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_percentage_binary_intervention_2)) &
            (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
            (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
        ]
    )
    # All are unadjusted results, so include this in unadjusted results
    Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "binary") &
        (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) &
        (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "binary") &
        (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) &
        (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ]
    Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "binary") &
        (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "binary") &
        (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ]
    # Convert percentages
    Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "binary") &
        (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) &
        (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_percentage_binary_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_percentage_binary_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- round(
      outcome_data_pre_analysis_multi_arm$outcome_data_additional_percentage_binary_intervention_1[
        (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "binary") &
          (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) &
          (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2)) &
          (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_percentage_binary_intervention_1)) &
          (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_percentage_binary_intervention_2)) &
          (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
          (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
      ] *
        outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1[
          (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "binary") &
            (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) &
            (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2)) &
            (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_percentage_binary_intervention_1)) &
            (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_percentage_binary_intervention_2)) &
            (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
            (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
        ]
    )
    Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "binary") &
        (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_percentage_binary_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_percentage_binary_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- round(
      outcome_data_pre_analysis_multi_arm$outcome_data_additional_percentage_binary_intervention_2[
        (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "binary") &
          (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2)) &
          (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_percentage_binary_intervention_1)) &
          (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_percentage_binary_intervention_2)) &
          (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
          (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
      ] *
        outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2[
          (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "binary") &
            (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2)) &
            (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_percentage_binary_intervention_1)) &
            (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_percentage_binary_intervention_2)) &
            (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
            (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
        ]
    )
    # Continuous outcomes
    # Mean imputation
    Results_file_Main$`Mean or standard deviation imputed (Continuous outcomes)`[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1) &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_median_continuous_intervention_1))&
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_median_continuous_intervention_2))
    ] <- 1
    Results_file_Unadjusted_for_confounding_cluster_cross_over$`Mean or standard deviation imputed (Continuous outcomes)`[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1) &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_median_continuous_intervention_1))&
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_median_continuous_intervention_2))
    ] <- 1
    outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1) &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_median_continuous_intervention_1))&
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_median_continuous_intervention_2))
    ] <- outcome_data_pre_analysis_multi_arm$outcome_data_additional_median_continuous_intervention_1[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1) &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_median_continuous_intervention_1))&
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_median_continuous_intervention_2))
    ]
    outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_median_continuous_intervention_1))&
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_median_continuous_intervention_2))
    ] <- outcome_data_pre_analysis_multi_arm$outcome_data_additional_median_continuous_intervention_2[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_median_continuous_intervention_1))&
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_median_continuous_intervention_2))
    ]
    # SD calculation
    # From SE
    outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_1[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_1) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_se_continuous_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1))
    ] <- outcome_data_pre_analysis_multi_arm$outcome_data_additional_se_continuous_intervention_1[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_1) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_se_continuous_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1))
    ] * outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_1) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_se_continuous_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1))
    ] ^ 0.5
    outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_2[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_2) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_se_continuous_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- outcome_data_pre_analysis_multi_arm$outcome_data_additional_se_continuous_intervention_2[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_2) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_se_continuous_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] * outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_2) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_se_continuous_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] ^ 0.5
    # From CI
    data_for_conversion <- outcome_data_pre_analysis_multi_arm[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_1) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_lci_continuous_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_uci_continuous_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1))
      ,      
    ]
    outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_1[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_1) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_lci_continuous_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_uci_continuous_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1))
    ] <- sapply(
      1:nrow(data_for_conversion),
      function(x) {
        individual.group.ci.to.sd(
          lower.ci = data_for_conversion$outcome_data_additional_lci_continuous_intervention_1[x], 
          upper.ci= data_for_conversion$outcome_data_additional_uci_continuous_intervention_1[x], 
          n = data_for_conversion$n_analysed_each_outcome_intervention_1[x]
        )
      }
    )
    data_for_conversion <- outcome_data_pre_analysis_multi_arm[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_2) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_lci_continuous_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_uci_continuous_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
      ,      
    ]
    outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_2[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_2) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_lci_continuous_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_uci_continuous_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- sapply(
      1:nrow(data_for_conversion),
      function(x) {
        individual.group.ci.to.sd(
          lower.ci = data_for_conversion$outcome_data_additional_lci_continuous_intervention_2[x], 
          upper.ci= data_for_conversion$outcome_data_additional_uci_continuous_intervention_2[x], 
          n = data_for_conversion$n_analysed_each_outcome_intervention_2[x]
        )
      }
    )
    # SD imputation
    # From quartiles
    data_for_conversion <- outcome_data_pre_analysis_multi_arm[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_1) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_lqr_continuous_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_uqr_continuous_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1))
      ,      
    ]
    Results_file_Main$`Mean or standard deviation imputed (Continuous outcomes)`[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_1) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_lqr_continuous_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_uqr_continuous_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1))
    ] <- 1
    Results_file_Unadjusted_for_confounding_cluster_cross_over$`Mean or standard deviation imputed (Continuous outcomes)`[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_1) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_lqr_continuous_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_uqr_continuous_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1))
    ] <- 1
    outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_1[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_1) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_lqr_continuous_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_uqr_continuous_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1))
    ] <- sapply(
      1:nrow(data_for_conversion),
      function(x) {
        if (
          (! is.na(data_for_conversion$outcome_data_additional_minimum_continuous_intervention_1[x])) &
          (! is.na(data_for_conversion$outcome_data_additional_maximum_continuous_intervention_1[x]))
        ){
          individual.group.quartiles.to.sd(
            lower.quartile = data_for_conversion$outcome_data_additional_lqr_continuous_intervention_1[x], 
            upper.quartile = data_for_conversion$outcome_data_additional_uqr_continuous_intervention_1[x],
            minimum = data_for_conversion$outcome_data_additional_minimum_continuous_intervention_1[x], 
            maximum = data_for_conversion$outcome_data_additional_maximum_continuous_intervention_1[x], 
            n = data_for_conversion$n_analysed_each_outcome_intervention_1[x]
          )
        } else {
          individual.group.quartiles.to.sd(
            lower.quartile = data_for_conversion$outcome_data_additional_lqr_continuous_intervention_1[x], 
            upper.quartile = data_for_conversion$outcome_data_additional_uqr_continuous_intervention_1[x],
            n = data_for_conversion$n_analysed_each_outcome_intervention_1[x]
          )
        }
      }
    )
    data_for_conversion <- outcome_data_pre_analysis_multi_arm[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_2) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_lqr_continuous_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_uqr_continuous_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
      ,      
    ]
    Results_file_Main$`Mean or standard deviation imputed (Continuous outcomes)`[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_2) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_lqr_continuous_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_uqr_continuous_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- 1
    Results_file_Unadjusted_for_confounding_cluster_cross_over$`Mean or standard deviation imputed (Continuous outcomes)`[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_2) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_lqr_continuous_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_uqr_continuous_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- 1
    outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_2[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_2) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_lqr_continuous_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_uqr_continuous_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- sapply(
      1:nrow(data_for_conversion),
      function(x) {
        if (
          (! is.na(data_for_conversion$outcome_data_additional_minimum_continuous_intervention_2[x])) &
          (! is.na(data_for_conversion$outcome_data_additional_maximum_continuous_intervention_2[x]))
        ){
          individual.group.quartiles.to.sd(
            lower.quartile = data_for_conversion$outcome_data_additional_lqr_continuous_intervention_2[x], 
            upper.quartile = data_for_conversion$outcome_data_additional_uqr_continuous_intervention_2[x],
            minimum = data_for_conversion$outcome_data_additional_minimum_continuous_intervention_2[x], 
            maximum = data_for_conversion$outcome_data_additional_maximum_continuous_intervention_2[x], 
            n = data_for_conversion$n_analysed_each_outcome_intervention_2[x]
          )
        } else {
          individual.group.quartiles.to.sd(
            lower.quartile = data_for_conversion$outcome_data_additional_lqr_continuous_intervention_2[x], 
            upper.quartile = data_for_conversion$outcome_data_additional_uqr_continuous_intervention_2[x],
            n = data_for_conversion$n_analysed_each_outcome_intervention_2[x]
          )
        }
      }
    )
    # From p-value
    data_for_conversion <- outcome_data_pre_analysis_multi_arm[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        (is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_1) |
           is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_2)
        ) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_p_value_continuous))
      ,      
    ]
    Results_file_Main$`Mean or standard deviation imputed (Continuous outcomes)`[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        (is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_1) |
           is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_2)
        ) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_p_value_continuous))
    ] <- 1
    Results_file_Unadjusted_for_confounding_cluster_cross_over$`Mean or standard deviation imputed (Continuous outcomes)`[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        (is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_1) |
           is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_2)
        ) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_p_value_continuous))
    ] <- 1
    sd_both_groups <- sapply(
      1:nrow(data_for_conversion),
      function(x) {
        individual.group.means.p.value.to.sd(
          mean_intervention = data_for_conversion$outcome_data_1_intervention_1[x], 
          mean_comparator = data_for_conversion$outcome_data_1_intervention_2[x], 
          n_intervention = data_for_conversion$n_analysed_each_outcome_intervention_1[x], 
          n_comparator= data_for_conversion$n_analysed_each_outcome_intervention_2[x], 
          p_value = data_for_conversion$outcome_data_additional_p_value_continuous[x]
        )
      }
    )
    outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_1[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        (is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_1) |
           is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_2)
        ) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_p_value_continuous))
    ] <- sd_both_groups[2,]
    outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_2[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        (is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_1) |
           is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_2)
        ) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_p_value_continuous))
    ] <- sd_both_groups[2,]
    # From range
    data_for_conversion <- outcome_data_pre_analysis_multi_arm[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_1) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_minimum_continuous_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_maximum_continuous_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1))
      ,      
    ]
    Results_file_Main$`Mean or standard deviation imputed (Continuous outcomes)`[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_1) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_minimum_continuous_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_maximum_continuous_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1))
    ] <- 1
    Results_file_Unadjusted_for_confounding_cluster_cross_over$`Mean or standard deviation imputed (Continuous outcomes)`[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_1) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_minimum_continuous_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_maximum_continuous_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1))
    ] <- 1
    outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_1[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_1) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_minimum_continuous_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_maximum_continuous_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1))
    ] <- sapply(
      1:nrow(data_for_conversion),
      function(x) {
        individual.group.range.to.sd(
          minimum = data_for_conversion$outcome_data_additional_minimum_continuous_intervention_1[x], 
          maximum = data_for_conversion$outcome_data_additional_maximum_continuous_intervention_1[x], 
          n = data_for_conversion$n_analysed_each_outcome_intervention_1[x]
        )
      }
    )
    data_for_conversion <- outcome_data_pre_analysis_multi_arm[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_2) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_minimum_continuous_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_maximum_continuous_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
      ,      
    ]
    Results_file_Main$`Mean or standard deviation imputed (Continuous outcomes)`[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_2) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_minimum_continuous_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_maximum_continuous_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- 1
    Results_file_Unadjusted_for_confounding_cluster_cross_over$`Mean or standard deviation imputed (Continuous outcomes)`[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_2) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_minimum_continuous_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_maximum_continuous_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- 1
    outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_2[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_2) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_minimum_continuous_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_maximum_continuous_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- sapply(
      1:nrow(data_for_conversion),
      function(x) {
        individual.group.range.to.sd(
          minimum = data_for_conversion$outcome_data_additional_minimum_continuous_intervention_2[x], 
          maximum = data_for_conversion$outcome_data_additional_maximum_continuous_intervention_2[x], 
          n = data_for_conversion$n_analysed_each_outcome_intervention_2[x]
        )
      }
    )
    # Copy the mean and sd to parameters 1 to 4
    Results_file_Main$Parameter1[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        (is.na(Results_file_Main$Parameter1)) &
        (is.na(Results_file_Main$Parameter2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        (is.na(Results_file_Main$Parameter1)) &
        (is.na(Results_file_Main$Parameter2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ]
    Results_file_Main$Parameter2[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        (is.na(Results_file_Main$Parameter2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_1[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        (is.na(Results_file_Main$Parameter2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ]
    Results_file_Main$Parameter3[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ]
    Results_file_Main$Parameter4[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_2[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ]
    Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) &
        (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) &
        (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ]
    Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_1[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ]
    Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter3[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ]
    Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter4[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_2[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_2_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ]
    # Copy the units and scale
    Results_file_Main$`Units (Continuous outcomes)`[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_3))
    ] <- outcome_data_pre_analysis_multi_arm$outcome_data_3[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_3))
    ]
    Results_file_Main$`Scale (Continuous outcomes)`[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_definition))
    ]<- outcome_data_pre_analysis_multi_arm$outcome_definition[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_definition))
    ]
    Results_file_Unadjusted_for_confounding_cluster_cross_over$`Units (Continuous outcomes)`[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_3))
    ] <- outcome_data_pre_analysis_multi_arm$outcome_data_3[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_3))
    ]
    Results_file_Unadjusted_for_confounding_cluster_cross_over$`Scale (Continuous outcomes)`[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_definition))
    ]<- outcome_data_pre_analysis_multi_arm$outcome_definition[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous") &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_definition))
    ]
    # Change signs if the data direction is different from the default direction
    if (is.null(DEF_Design) == FALSE) {
      outcome_data_pre_analysis_multi_arm$change_direction[
        outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous"
      ] <- ! (DEF_Design$outcome_better_worse_other_characteristics_study_level_intervention_level[
        match(outcome_data_pre_analysis_multi_arm$unmodified_outcome_name[
          outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous"
        ], 
        DEF_Design$variable_value)
      ] == outcome_data_pre_analysis_multi_arm$outcome_better_worse[
        outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous"
      ])
      Results_file_Main$Parameter1[
        (! is.na(Results_file_Main$Parameter1)) &
          (Results_file_Main$`Type of outcome` == "Summary_Difference") &
          (! is.na(outcome_data_pre_analysis_multi_arm$change_direction)) & 
          (outcome_data_pre_analysis_multi_arm$change_direction == TRUE)
      ] <- (-1) * Results_file_Main$Parameter1[
        (! is.na(Results_file_Main$Parameter1)) &
          (Results_file_Main$`Type of outcome` == "Summary_Difference") &
          (! is.na(outcome_data_pre_analysis_multi_arm$change_direction)) & 
          (outcome_data_pre_analysis_multi_arm$change_direction == TRUE)
      ]
      Results_file_Main$`Scale (Continuous outcomes)`[
        (! is.na(Results_file_Main$Parameter1)) &
          (Results_file_Main$`Type of outcome` == "Summary_Difference") &
          (! is.na(outcome_data_pre_analysis_multi_arm$change_direction)) & 
          (outcome_data_pre_analysis_multi_arm$change_direction == TRUE)
      ] <- paste0(
        Results_file_Main$`Scale (Continuous outcomes)`[
          (! is.na(Results_file_Main$Parameter1)) &
            (Results_file_Main$`Type of outcome` == "Summary_Difference") &
            (! is.na(outcome_data_pre_analysis_multi_arm$change_direction)) & 
            (outcome_data_pre_analysis_multi_arm$change_direction == TRUE)
        ],
        " (directions reversed)" 
      )
      Results_file_Main$`Are more events or higher value better or worse for participants?`[
        (! is.na(Results_file_Main$Parameter1)) &
          (Results_file_Main$`Type of outcome` == "Summary_Difference") &
          (! is.na(outcome_data_pre_analysis_multi_arm$change_direction)) & 
          (outcome_data_pre_analysis_multi_arm$change_direction == TRUE)
      ] <- ifelse(
        Results_file_Main$`Are more events or higher value better or worse for participants?`[
          (! is.na(Results_file_Main$Parameter1)) &
            (Results_file_Main$`Type of outcome` == "Summary_Difference") &
            (! is.na(outcome_data_pre_analysis_multi_arm$change_direction)) & 
            (outcome_data_pre_analysis_multi_arm$change_direction == TRUE)
        ] == "Better",
        "Worse",
        "Better"
      )
      Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1[
        (! is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) &
          (Results_file_Unadjusted_for_confounding_cluster_cross_over$`Type of outcome` == "Summary_Difference") &
          (! is.na(outcome_data_pre_analysis_multi_arm$change_direction)) & 
          (outcome_data_pre_analysis_multi_arm$change_direction == TRUE)
      ] <- (-1) * Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1[
        (! is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) &
          (Results_file_Unadjusted_for_confounding_cluster_cross_over$`Type of outcome` == "Summary_Difference") &
          (! is.na(outcome_data_pre_analysis_multi_arm$change_direction)) & 
          (outcome_data_pre_analysis_multi_arm$change_direction == TRUE)
      ]
      Results_file_Unadjusted_for_confounding_cluster_cross_over$`Scale (Continuous outcomes)`[
        (! is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) &
          (Results_file_Unadjusted_for_confounding_cluster_cross_over$`Type of outcome` == "Summary_Difference") &
          (! is.na(outcome_data_pre_analysis_multi_arm$change_direction)) & 
          (outcome_data_pre_analysis_multi_arm$change_direction == TRUE)
      ] <- paste0(
        Results_file_Unadjusted_for_confounding_cluster_cross_over$`Scale (Continuous outcomes)`[
          (! is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) &
            (Results_file_Unadjusted_for_confounding_cluster_cross_over$`Type of outcome` == "Summary_Difference") &
            (! is.na(outcome_data_pre_analysis_multi_arm$change_direction)) & 
            (outcome_data_pre_analysis_multi_arm$change_direction == TRUE)
        ],
        " (directions reversed)" 
      )
      Results_file_Unadjusted_for_confounding_cluster_cross_over$`Are more events or higher value better or worse for participants?`[
        (! is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) &
          (Results_file_Unadjusted_for_confounding_cluster_cross_over$`Type of outcome` == "Summary_Difference") &
          (! is.na(outcome_data_pre_analysis_multi_arm$change_direction)) & 
          (outcome_data_pre_analysis_multi_arm$change_direction == TRUE)
      ] <- ifelse(
        Results_file_Unadjusted_for_confounding_cluster_cross_over$`Are more events or higher value better or worse for participants?`[
          (! is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) &
            (Results_file_Unadjusted_for_confounding_cluster_cross_over$`Type of outcome` == "Summary_Difference") &
            (! is.na(outcome_data_pre_analysis_multi_arm$change_direction)) & 
            (outcome_data_pre_analysis_multi_arm$change_direction == TRUE)
        ] == "Better",
        "Worse",
        "Better"
      )
      Results_file_Adjusted$Parameter1[
        (! is.na(Results_file_Adjusted$Parameter1)) &
          (Results_file_Adjusted$`Type of outcome` == "Summary_Difference") &
          (! is.na(outcome_data_pre_analysis_multi_arm$change_direction)) & 
          (outcome_data_pre_analysis_multi_arm$change_direction == TRUE)
      ] <- (-1) * Results_file_Adjusted$Parameter1[
        (! is.na(Results_file_Adjusted$Parameter1)) &
          (Results_file_Adjusted$`Type of outcome` == "Summary_Difference") &
          (! is.na(outcome_data_pre_analysis_multi_arm$change_direction)) & 
          (outcome_data_pre_analysis_multi_arm$change_direction == TRUE)
      ]
      Results_file_Adjusted$`Scale (Continuous outcomes)`[
        (! is.na(Results_file_Adjusted$Parameter1)) &
          (Results_file_Adjusted$`Type of outcome` == "Summary_Difference") &
          (! is.na(outcome_data_pre_analysis_multi_arm$change_direction)) & 
          (outcome_data_pre_analysis_multi_arm$change_direction == TRUE)
      ] <- paste0(
        Results_file_Adjusted$`Scale (Continuous outcomes)`[
          (! is.na(Results_file_Adjusted$Parameter1)) &
            (Results_file_Adjusted$`Type of outcome` == "Summary_Difference") &
            (! is.na(outcome_data_pre_analysis_multi_arm$change_direction)) & 
            (outcome_data_pre_analysis_multi_arm$change_direction == TRUE)
        ],
        " (directions reversed)" 
      )
      Results_file_Adjusted$`Are more events or higher value better or worse for participants?`[
        (! is.na(Results_file_Adjusted$Parameter1)) &
          (Results_file_Adjusted$`Type of outcome` == "Summary_Difference") &
          (! is.na(outcome_data_pre_analysis_multi_arm$change_direction)) & 
          (outcome_data_pre_analysis_multi_arm$change_direction == TRUE)
      ] <- ifelse(
        Results_file_Adjusted$`Are more events or higher value better or worse for participants?`[
          (! is.na(Results_file_Adjusted$Parameter1)) &
            (Results_file_Adjusted$`Type of outcome` == "Summary_Difference") &
            (! is.na(outcome_data_pre_analysis_multi_arm$change_direction)) & 
            (outcome_data_pre_analysis_multi_arm$change_direction == TRUE)
        ] == "Better",
        "Worse",
        "Better"
      )
      Results_file_Main$Parameter1[
        (! is.na(Results_file_Main$Parameter1)) &
          (! is.na(Results_file_Main$Parameter3)) &
          (Results_file_Main$`Type of outcome` == "Continuous") &
          (! is.na(outcome_data_pre_analysis_multi_arm$change_direction)) & 
          (outcome_data_pre_analysis_multi_arm$change_direction == TRUE)
      ] <- (-1) * Results_file_Main$Parameter1[
        (! is.na(Results_file_Main$Parameter1)) &
          (! is.na(Results_file_Main$Parameter3)) &
          (Results_file_Main$`Type of outcome` == "Continuous") &
          (! is.na(outcome_data_pre_analysis_multi_arm$change_direction)) & 
          (outcome_data_pre_analysis_multi_arm$change_direction == TRUE)
      ]
      Results_file_Main$Parameter3[
        (! is.na(Results_file_Main$Parameter1)) &
          (! is.na(Results_file_Main$Parameter3)) &
          (Results_file_Main$`Type of outcome` == "Continuous") &
          (! is.na(outcome_data_pre_analysis_multi_arm$change_direction)) & 
          (outcome_data_pre_analysis_multi_arm$change_direction == TRUE)
      ] <- (-1) * Results_file_Main$Parameter3[
        (! is.na(Results_file_Main$Parameter1)) &
          (! is.na(Results_file_Main$Parameter3)) &
          (Results_file_Main$`Type of outcome` == "Continuous") &
          (! is.na(outcome_data_pre_analysis_multi_arm$change_direction)) & 
          (outcome_data_pre_analysis_multi_arm$change_direction == TRUE)
      ]
      Results_file_Main$`Scale (Continuous outcomes)`[
        (! is.na(Results_file_Main$Parameter1)) &
          (! is.na(Results_file_Main$Parameter3)) &
          (Results_file_Main$`Type of outcome` == "Continuous") &
          (! is.na(outcome_data_pre_analysis_multi_arm$change_direction)) & 
          (outcome_data_pre_analysis_multi_arm$change_direction == TRUE)
      ] <- paste0(
        Results_file_Main$`Scale (Continuous outcomes)`[
          (! is.na(Results_file_Main$Parameter1)) &
            (! is.na(Results_file_Main$Parameter3)) &
            (Results_file_Main$`Type of outcome` == "Continuous") &
            (! is.na(outcome_data_pre_analysis_multi_arm$change_direction)) & 
            (outcome_data_pre_analysis_multi_arm$change_direction == TRUE)
        ],
        " (directions reversed)" 
      )
      Results_file_Main$`Are more events or higher value better or worse for participants?`[
        (! is.na(Results_file_Main$Parameter1)) &
          (! is.na(Results_file_Main$Parameter3)) &
          (Results_file_Main$`Type of outcome` == "Continuous") &
          (! is.na(outcome_data_pre_analysis_multi_arm$change_direction)) & 
          (outcome_data_pre_analysis_multi_arm$change_direction == TRUE)
      ] <- ifelse(
        Results_file_Main$`Are more events or higher value better or worse for participants?`[
          (! is.na(Results_file_Main$Parameter1)) &
            (! is.na(Results_file_Main$Parameter3)) &
            (Results_file_Main$`Type of outcome` == "Continuous") &
            (! is.na(outcome_data_pre_analysis_multi_arm$change_direction)) & 
            (outcome_data_pre_analysis_multi_arm$change_direction == TRUE)
        ] == "Better",
        "Worse",
        "Better"
      )
      Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1[
        (! is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) &
          (! is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter3)) &
          (Results_file_Unadjusted_for_confounding_cluster_cross_over$`Type of outcome` == "Continuous") &
          (! is.na(outcome_data_pre_analysis_multi_arm$change_direction)) & 
          (outcome_data_pre_analysis_multi_arm$change_direction == TRUE)
      ] <- (-1) * Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1[
        (! is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) &
          (! is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter3)) &
          (Results_file_Unadjusted_for_confounding_cluster_cross_over$`Type of outcome` == "Continuous") &
          (! is.na(outcome_data_pre_analysis_multi_arm$change_direction)) & 
          (outcome_data_pre_analysis_multi_arm$change_direction == TRUE)
      ]
      Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter3[
        (! is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) &
          (! is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter3)) &
          (Results_file_Unadjusted_for_confounding_cluster_cross_over$`Type of outcome` == "Continuous") &
          (! is.na(outcome_data_pre_analysis_multi_arm$change_direction)) & 
          (outcome_data_pre_analysis_multi_arm$change_direction == TRUE)
      ] <- (-1) * Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter3[
        (! is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) &
          (! is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter3)) &
          (Results_file_Unadjusted_for_confounding_cluster_cross_over$`Type of outcome` == "Continuous") &
          (! is.na(outcome_data_pre_analysis_multi_arm$change_direction)) & 
          (outcome_data_pre_analysis_multi_arm$change_direction == TRUE)
      ]
      Results_file_Unadjusted_for_confounding_cluster_cross_over$`Scale (Continuous outcomes)`[
        (! is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) &
          (! is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter3)) &
          (Results_file_Unadjusted_for_confounding_cluster_cross_over$`Type of outcome` == "Continuous") &
          (! is.na(outcome_data_pre_analysis_multi_arm$change_direction)) & 
          (outcome_data_pre_analysis_multi_arm$change_direction == TRUE)
      ] <- paste0(
        Results_file_Unadjusted_for_confounding_cluster_cross_over$`Scale (Continuous outcomes)`[
          (! is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) &
            (! is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter3)) &
            (Results_file_Unadjusted_for_confounding_cluster_cross_over$`Type of outcome` == "Continuous") &
            (! is.na(outcome_data_pre_analysis_multi_arm$change_direction)) & 
            (outcome_data_pre_analysis_multi_arm$change_direction == TRUE)
        ],
        " (directions reversed)" 
      )
      Results_file_Unadjusted_for_confounding_cluster_cross_over$`Are more events or higher value better or worse for participants?`[
        (! is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) &
          (! is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter3)) &
          (Results_file_Unadjusted_for_confounding_cluster_cross_over$`Type of outcome` == "Continuous") &
          (! is.na(outcome_data_pre_analysis_multi_arm$change_direction)) & 
          (outcome_data_pre_analysis_multi_arm$change_direction == TRUE)
      ] <- ifelse(
        Results_file_Unadjusted_for_confounding_cluster_cross_over$`Are more events or higher value better or worse for participants?`[
          (! is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) &
            (! is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter3)) &
            (Results_file_Unadjusted_for_confounding_cluster_cross_over$`Type of outcome` == "Continuous") &
            (! is.na(outcome_data_pre_analysis_multi_arm$change_direction)) & 
            (outcome_data_pre_analysis_multi_arm$change_direction == TRUE)
        ] == "Better",
        "Worse",
        "Better"
      )
    } else {
      outcome_data_pre_analysis_multi_arm$change_direction[
        outcome_data_pre_analysis_multi_arm$outcome_type_1 == "continuous"
      ] <- TRUE
    }
    # Count outcomes
    # Create a subset for data to be converted
    data_for_conversion <- outcome_data_pre_analysis_multi_arm[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "count") &
        ((is.na(Results_file_Main$Parameter1)) | (is.na(Results_file_Main$Parameter2))) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
      ,      
    ]
    estimates <- sapply(
      1:nrow(data_for_conversion),
      function(x) {
        lnRateRatio_SE(
          data_for_conversion$outcome_data_1_intervention_1[x],
          data_for_conversion$outcome_data_1_intervention_2[x],
          data_for_conversion$n_analysed_each_outcome_intervention_1[x],
          data_for_conversion$n_analysed_each_outcome_intervention_2[x],
          ifelse((is.na(data_for_conversion$mean_each_intervention_each_outcome_intervention_1[x]) |
                    is.na(data_for_conversion$mean_each_intervention_each_outcome_intervention_2[x])),
                 1, data_for_conversion$mean_each_intervention_each_outcome_intervention_1[x]),
          ifelse((is.na(data_for_conversion$mean_each_intervention_each_outcome_intervention_1[x]) |
                    is.na(data_for_conversion$mean_each_intervention_each_outcome_intervention_2[x])),
                 1, data_for_conversion$mean_each_intervention_each_outcome_intervention_2[x])
        )
      }
    )
    Results_file_Main$`Type of outcome`[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "count") &
        ((is.na(Results_file_Main$Parameter1)) | (is.na(Results_file_Main$Parameter2))) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- "Summary_Ratio"
    Results_file_Main$Parameter1[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "count") &
        ((is.na(Results_file_Main$Parameter1)) | (is.na(Results_file_Main$Parameter2))) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- estimates[1,]
    Results_file_Main$Parameter2[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "count") &
        ((is.na(Results_file_Main$Parameter1)) | (is.na(Results_file_Main$Parameter2))) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- estimates[2,]
    # All are unadjusted results, so include this in unadjusted results
    # Create a subset for data to be converted
    data_for_conversion <- outcome_data_pre_analysis_multi_arm[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "count") &
        ((is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) | (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2))) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
      ,      
    ]
    estimates <- sapply(
      1:nrow(data_for_conversion),
      function(x) {
        lnRateRatio_SE(
          data_for_conversion$outcome_data_1_intervention_1[x],
          data_for_conversion$outcome_data_1_intervention_2[x],
          data_for_conversion$n_analysed_each_outcome_intervention_1[x],
          data_for_conversion$n_analysed_each_outcome_intervention_2[x],
          ifelse((is.na(data_for_conversion$mean_each_intervention_each_outcome_intervention_1[x]) |
                    is.na(data_for_conversion$mean_each_intervention_each_outcome_intervention_2[x])),
                 1, data_for_conversion$mean_each_intervention_each_outcome_intervention_1[x]),
          ifelse((is.na(data_for_conversion$mean_each_intervention_each_outcome_intervention_1[x]) |
                    is.na(data_for_conversion$mean_each_intervention_each_outcome_intervention_2[x])),
                 1, data_for_conversion$mean_each_intervention_each_outcome_intervention_2[x])
        )
      }
    )
    Results_file_Unadjusted_for_confounding_cluster_cross_over$`Type of outcome`[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "count") &
        ((is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) | (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2))) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- "Summary_Ratio"
    Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "count") &
        ((is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) | (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2))) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- estimates[1,]
    Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "count") &
        ((is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) | (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2))) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_1_intervention_2)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- estimates[2,]
    # Time-to-event outcomes
    # Create a subset for data to be converted
    data_for_conversion <- outcome_data_pre_analysis_multi_arm[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "time-to-event") &
        ((is.na(Results_file_Main$Parameter1)) | (is.na(Results_file_Main$Parameter2))) &
        (! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_unadjusted) | 
           ! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_adjusted)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_number_of_events_time_to_event)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
      ,      
    ]
    estimates <- sapply(
      1:nrow(data_for_conversion),
      function(x) {
        lnHR_SE.from.HR_events(
          ifelse(is.na(data_for_conversion$effect_measure_unadjusted[x]),
                 data_for_conversion$effect_measure_adjusted[x], data_for_conversion$effect_measure_unadjusted[x]),
          data_for_conversion$outcome_data_additional_number_of_events_time_to_event[x], 
          data_for_conversion$n_analysed_each_outcome_intervention_1[x],
          data_for_conversion$n_analysed_each_outcome_intervention_2[x])
      }
    )
    Results_file_Main$`Type of outcome`[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "time-to-event") &
        ((is.na(Results_file_Main$Parameter1)) | (is.na(Results_file_Main$Parameter2))) &
        (! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_unadjusted) | 
           ! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_adjusted)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_number_of_events_time_to_event)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- "Summary_Ratio"
    Results_file_Main$Parameter1[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "time-to-event") &
        ((is.na(Results_file_Main$Parameter1)) | (is.na(Results_file_Main$Parameter2))) &
        (! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_unadjusted) | 
           ! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_adjusted)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_number_of_events_time_to_event)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- estimates[1,]
    Results_file_Main$Parameter2[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "time-to-event") &
        ((is.na(Results_file_Main$Parameter1)) | (is.na(Results_file_Main$Parameter2))) &
        (! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_unadjusted) | 
           ! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_adjusted)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_number_of_events_time_to_event)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- estimates[2,]
    # All are unadjusted results, so include this in unadjusted results
    data_for_conversion <- outcome_data_pre_analysis_multi_arm[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "time-to-event") &
        ((is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) | (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2))) &
        (! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_unadjusted) | 
           ! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_adjusted)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_number_of_events_time_to_event)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
      ,      
    ]
    estimates <- sapply(
      1:nrow(data_for_conversion),
      function(x) {
        lnHR_SE.from.HR_events(
          ifelse(is.na(data_for_conversion$effect_measure_unadjusted[x]),
                 data_for_conversion$effect_measure_adjusted[x], data_for_conversion$effect_measure_unadjusted[x]),
          data_for_conversion$outcome_data_additional_number_of_events_time_to_event[x], 
          data_for_conversion$n_analysed_each_outcome_intervention_1[x],
          data_for_conversion$n_analysed_each_outcome_intervention_2[x])
      }
    )
    Results_file_Unadjusted_for_confounding_cluster_cross_over$`Type of outcome`[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "time-to-event") &
        ((is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) | (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2))) &
        (! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_unadjusted) | 
           ! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_adjusted)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_number_of_events_time_to_event)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- "Summary_Ratio"
    Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "time-to-event") &
        ((is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) | (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2))) &
        (! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_unadjusted) | 
           ! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_adjusted)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_number_of_events_time_to_event)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- estimates[1,]
    Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "time-to-event") &
        ((is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) | (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2))) &
        (! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_unadjusted) | 
           ! is.na(outcome_data_pre_analysis_multi_arm$effect_measure_adjusted)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_number_of_events_time_to_event)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- estimates[2,]
    data_for_conversion <- outcome_data_pre_analysis_multi_arm[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "time-to-event") &
        ((is.na(Results_file_Main$Parameter1)) | (is.na(Results_file_Main$Parameter2))) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_number_of_events_time_to_event)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_favours_intervention_time_to_event)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_p_value_time_to_event)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
      ,      
    ]
    estimates <- sapply(
      1:nrow(data_for_conversion),
      function(x) {
        lnHR_SE.from.events_p_favourable(
          observed_events = data_for_conversion$outcome_data_additional_number_of_events_time_to_event[x],
          log_rank_p = data_for_conversion$outcome_data_additional_p_value_time_to_event[x],
          higher_events_better_worse = data_for_conversion$outcome_better_worse[x],
          favourable_intervention_comparator = ifelse(
            data_for_conversion$unmodified_name_intervention_1[x] == data_for_conversion$unmodified_name_intervention_1,
            "intervention", "comparator"
          ), 
          n_intervention = data_for_conversion$n_analysed_each_outcome_intervention_1[x], 
          n_comparator = data_for_conversion$n_analysed_each_outcome_intervention_1[x]
        )
      }
    )
    Results_file_Main$`Type of outcome`[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "time-to-event") &
        ((is.na(Results_file_Main$Parameter1)) | (is.na(Results_file_Main$Parameter2))) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_number_of_events_time_to_event)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_favours_intervention_time_to_event)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_p_value_time_to_event)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- "Summary_Ratio"
    Results_file_Main$Parameter1[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "time-to-event") &
        ((is.na(Results_file_Main$Parameter1)) | (is.na(Results_file_Main$Parameter2))) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_number_of_events_time_to_event)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_favours_intervention_time_to_event)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_p_value_time_to_event)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- estimates[1,]
    Results_file_Main$Parameter2[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "time-to-event") &
        ((is.na(Results_file_Main$Parameter1)) | (is.na(Results_file_Main$Parameter2))) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_number_of_events_time_to_event)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_favours_intervention_time_to_event)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_p_value_time_to_event)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- estimates[2,]
    data_for_conversion <- outcome_data_pre_analysis_multi_arm[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "time-to-event") &
        ((is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) | (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2))) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_number_of_events_time_to_event)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_favours_intervention_time_to_event)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_p_value_time_to_event)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
      ,      
    ]
    estimates <- sapply(
      1:nrow(data_for_conversion),
      function(x) {
        lnHR_SE.from.events_p_favourable(
          observed_events = data_for_conversion$outcome_data_additional_number_of_events_time_to_event[x],
          log_rank_p = data_for_conversion$outcome_data_additional_p_value_time_to_event[x],
          higher_events_better_worse = data_for_conversion$outcome_better_worse[x],
          favourable_intervention_comparator = ifelse(
            data_for_conversion$unmodified_name_intervention_1[x] == data_for_conversion$unmodified_name_intervention_1,
            "intervention", "comparator"
          ), 
          n_intervention = data_for_conversion$n_analysed_each_outcome_intervention_1[x], 
          n_comparator = data_for_conversion$n_analysed_each_outcome_intervention_1[x]
        )
      }
    )
    Results_file_Unadjusted_for_confounding_cluster_cross_over$`Type of outcome`[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "time-to-event") &
        ((is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) | (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2))) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_number_of_events_time_to_event)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_favours_intervention_time_to_event)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_p_value_time_to_event)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- "Summary_Ratio"
    Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "time-to-event") &
        ((is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) | (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2))) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_number_of_events_time_to_event)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_favours_intervention_time_to_event)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_p_value_time_to_event)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- estimates[1,]
    Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2[
      (outcome_data_pre_analysis_multi_arm$outcome_type_1 == "time-to-event") &
        ((is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) | (is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2))) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_number_of_events_time_to_event)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_favours_intervention_time_to_event)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_p_value_time_to_event)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1)) &
        (! is.na(outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2))
    ] <- estimates[2,]
    # Step 5: Converting data in Results files to numeric format (appropriate fields) ####
    Results_file_Main[
      ,
      setdiff(colnames(Results_file_Main),
              c(
                "Outcome name","Type of outcome",
                "Are more events or higher value better or worse for participants?",
                "Study","Units (Continuous outcomes)","Scale (Continuous outcomes)",
                "Intervention and control details for graphs"
              )
      )
    ] <- lapply(Results_file_Main[
      ,
      setdiff(colnames(Results_file_Main),
              c(
                "Outcome name","Type of outcome",
                "Are more events or higher value better or worse for participants?",
                "Study","Units (Continuous outcomes)","Scale (Continuous outcomes)",
                "Intervention and control details for graphs"
              )
      )
    ], as.numeric)
    Results_file_Unadjusted_for_confounding_cluster_cross_over[
      ,
      setdiff(colnames(Results_file_Unadjusted_for_confounding_cluster_cross_over),
              c(
                "Outcome name","Type of outcome",
                "Are more events or higher value better or worse for participants?",
                "Study","Units (Continuous outcomes)","Scale (Continuous outcomes)",
                "Intervention and control details for graphs"
              )
      )
    ] <- lapply(Results_file_Unadjusted_for_confounding_cluster_cross_over[
      ,
      setdiff(colnames(Results_file_Unadjusted_for_confounding_cluster_cross_over),
              c(
                "Outcome name","Type of outcome",
                "Are more events or higher value better or worse for participants?",
                "Study","Units (Continuous outcomes)","Scale (Continuous outcomes)",
                "Intervention and control details for graphs"
              )
      )
    ], as.numeric)
    Results_file_Adjusted[
      ,
      setdiff(colnames(Results_file_Adjusted),
              c(
                "Outcome name","Type of outcome",
                "Are more events or higher value better or worse for participants?",
                "Study","Units (Continuous outcomes)","Scale (Continuous outcomes)",
                "Intervention and control details for graphs"
              )
      )
    ] <- lapply(Results_file_Adjusted[
      ,
      setdiff(colnames(Results_file_Adjusted),
              c(
                "Outcome name","Type of outcome",
                "Are more events or higher value better or worse for participants?",
                "Study","Units (Continuous outcomes)","Scale (Continuous outcomes)",
                "Intervention and control details for graphs"
              )
      )
    ], as.numeric)
    # Step 6: Change sign if DEF_Design was null ####
    if (is.null(DEF_Design) == TRUE) {
      if (nrow(Results_file_Main) > 0) {
        row.names(Results_file_Main) <- 1:nrow(Results_file_Main)
        data_for_conversion <- Results_file_Main[
          (! is.na(Results_file_Main$`Type of outcome`)) &
            (Results_file_Main$`Type of outcome` == "Continuous")
          ,1:12]
        if (nrow(data_for_conversion) > 1) {
          changed_results <- change_directions_MD_SMD(data_for_conversion)
          if (changed_results[[2]] == "Successful") {
            Results_file_Main[
              Results_file_Main$`Type of outcome` == "Continuous",
              c("Are more events or higher value better or worse for participants?",
                "Parameter1",
                "Parameter3",
                "Scale (Continuous outcomes)"
              )
            ] <- changed_results[[1]][
              order(row.names(changed_results[[1]])),
              c("Are more events or higher value better or worse for participants?",
                "Parameter1",
                "Parameter3",
                "Scale (Continuous outcomes)"
              )
            ]
          }
        }
      }
      if (nrow(Results_file_Unadjusted_for_confounding_cluster_cross_over) > 0) {
        row.names(Results_file_Unadjusted_for_confounding_cluster_cross_over) <- 1:nrow(Results_file_Unadjusted_for_confounding_cluster_cross_over)
        data_for_conversion <- Results_file_Unadjusted_for_confounding_cluster_cross_over[
          (! is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$`Type of outcome`)) &
            (Results_file_Unadjusted_for_confounding_cluster_cross_over$`Type of outcome` == "Continuous")
          ,1:12]
        if (nrow(data_for_conversion) > 1) {
          changed_results <- change_directions_MD_SMD(data_for_conversion)
          if (changed_results[[2]] == "Successful") {
            Results_file_Unadjusted_for_confounding_cluster_cross_over[
              Results_file_Unadjusted_for_confounding_cluster_cross_over$`Type of outcome` == "Continuous",
              c("Are more events or higher value better or worse for participants?",
                "Parameter1",
                "Parameter3",
                "Scale (Continuous outcomes)"
              )
            ] <- changed_results[[1]][
              order(row.names(changed_results[[1]])),
              c("Are more events or higher value better or worse for participants?",
                "Parameter1",
                "Parameter3",
                "Scale (Continuous outcomes)"
              )
            ]
          }
        }
      }
      if (nrow(Results_file_Adjusted) > 0) {
        row.names(Results_file_Adjusted) <- 1:nrow(Results_file_Adjusted)
        data_for_conversion <- Results_file_Adjusted[
          (! is.na(Results_file_Adjusted$`Type of outcome`)) &
            (Results_file_Adjusted$`Type of outcome` == "Continuous")
          ,1:12]
        if (nrow(data_for_conversion) > 1) {
          changed_results <- change_directions_MD_SMD(data_for_conversion)
          if (changed_results[[2]] == "Successful") {
            Results_file_Adjusted[
              Results_file_Adjusted$`Type of outcome` == "Continuous",
              c("Are more events or higher value better or worse for participants?",
                "Parameter1",
                "Parameter3",
                "Scale (Continuous outcomes)"
              )
            ] <- changed_results[[1]][
              order(row.names(changed_results[[1]])),
              c("Are more events or higher value better or worse for participants?",
                "Parameter1",
                "Parameter3",
                "Scale (Continuous outcomes)"
              )
            ]
          }
        }
      }
    }
    # Step 7: Cluster and cross-over trials ####
    # Make a copy of the "Unadjusted" Results
    Results_file_Adjusted_for_cluster_cross_over <- Results_file_Unadjusted_for_confounding_cluster_cross_over
    # Note if ICC is missing for sensitivity analysis
    outcome_data_pre_analysis_multi_arm$ICC_missing <- (
      ((outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") |
         (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT")) & 
        (is.na(outcome_data_pre_analysis_multi_arm$outcome_data_additional_ICC))
    )
    # First cluster trials ####
    data_for_conversion <- outcome_data_pre_analysis_multi_arm[
      outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT"
      ,]
    if (nrow(data_for_conversion) >0 ) {
      # Get the ICC which are missing and impute values: First the median ICC for the outcome, next the ICC for the study, next any ICC, next 0.5
      # Get the ICC which are present
      ICC <- cbind.data.frame(
        outcome_name = as.factor(data_for_conversion$outcome_name),
        study_id = as.factor(data_for_conversion$study_id),
        icc = as.numeric(data_for_conversion$outcome_data_additional_ICC)
      )
      if (TRUE %in% ! is.na(ICC$icc)) {
        # First same outcomes
        for (i in 1:nlevels(ICC$outcome_name)) {
          if (length(ICC$icc[
            (ICC$outcome_name == ICC$outcome_name[i]) &
            (! is.na(ICC$icc))
          ]) > 0) {
            ICC$icc[
              (ICC$outcome_name == ICC$outcome_name[i]) &
                (is.na(ICC$icc))
            ] <- median(ICC$icc[
              (ICC$outcome_name == ICC$outcome_name[i]) &
                (! is.na(ICC$icc))
            ]
            )        
          }
        }
        # Next same studies
        for (i in 1:nlevels(ICC$study_id)) {
          if (length(ICC$icc[
            (ICC$study_id == ICC$study_id[i]) &
            (! is.na(ICC$icc))
          ]) > 0) {
            ICC$icc[
              (ICC$study_id == ICC$study_id[i]) &
                (is.na(ICC$icc))
            ] <- median(ICC$icc[
              (ICC$study_id == ICC$study_id[i]) &
                (! is.na(ICC$icc))
            ]
            )        
          }
        }
        # Next any ICC
        ICC$icc[is.na(ICC$icc)] <- median(ICC$icc[! is.na(ICC$icc)])
      } else {
        ICC$icc <- 0.5
      }
      data_for_conversion$outcome_data_additional_ICC <- ICC$icc
      outcome_data_pre_analysis_multi_arm$outcome_data_additional_ICC[
        outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT"
      ] <- data_for_conversion$outcome_data_additional_ICC
      # Calculate the design effect
      data_for_conversion$design_effect <- 1 + ((
        (data_for_conversion$n_analysed_each_outcome_intervention_1 + 
           data_for_conversion$n_analysed_each_outcome_intervention_2)/
          (data_for_conversion$outcome_data_additional_number_of_clusters_1 + 
             data_for_conversion$outcome_data_additional_number_of_clusters_2)
      ) - 1) * data_for_conversion$outcome_data_additional_ICC
      outcome_data_pre_analysis_multi_arm$design_effect[
        outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT"
      ] <- data_for_conversion$design_effect
      # Now make the appropriate changes
      # For summary differences and ratios it is only the standard error that needs alteration 
      Results_file_Adjusted_for_cluster_cross_over$Parameter2[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          ((Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Summary_Ratio") |
             (Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Summary_Difference"))
      ] <- Results_file_Adjusted_for_cluster_cross_over$Parameter2[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          ((Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Summary_Ratio") |
             (Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Summary_Difference"))
      ] * outcome_data_pre_analysis_multi_arm$design_effect[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          ((Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Summary_Ratio") |
             (Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Summary_Difference"))
      ]^0.5
      # For continuous outcomes, it is only the number of participants that needs alteration
      Results_file_Adjusted_for_cluster_cross_over$`Intervention (total number of participants)`[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Continuous")
      ] <- Results_file_Adjusted_for_cluster_cross_over$`Intervention (total number of participants)`[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Continuous")
      ] / outcome_data_pre_analysis_multi_arm$design_effect[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Continuous")
      ]
      Results_file_Adjusted_for_cluster_cross_over$`Control (total number of participants)`[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Continuous")
      ] <- Results_file_Adjusted_for_cluster_cross_over$`Control (total number of participants)`[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Continuous")
      ] / outcome_data_pre_analysis_multi_arm$design_effect[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Continuous")
      ]
      # For binary outcomes, it is the number of participants and parameters 1 and 2 that need alteration
      Results_file_Adjusted_for_cluster_cross_over$`Intervention (total number of participants)`[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Binary")
      ] <- Results_file_Adjusted_for_cluster_cross_over$`Intervention (total number of participants)`[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Binary")
      ] / outcome_data_pre_analysis_multi_arm$design_effect[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Binary")
      ]
      Results_file_Adjusted_for_cluster_cross_over$`Control (total number of participants)`[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Binary")
      ] <- Results_file_Adjusted_for_cluster_cross_over$`Control (total number of participants)`[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Binary")
      ] / outcome_data_pre_analysis_multi_arm$design_effect[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Binary")
      ]
      Results_file_Adjusted_for_cluster_cross_over$Parameter1[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Binary")
      ] <- Results_file_Adjusted_for_cluster_cross_over$Parameter1[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Binary")
      ] / outcome_data_pre_analysis_multi_arm$design_effect[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Binary")
      ]
      Results_file_Adjusted_for_cluster_cross_over$Parameter2[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Binary")
      ] <- Results_file_Adjusted_for_cluster_cross_over$Parameter2[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Binary")
      ] / outcome_data_pre_analysis_multi_arm$design_effect[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Binary")
      ]
    }
    # Next cross-over trials ####
    data_for_conversion <- outcome_data_pre_analysis_multi_arm[
      outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT"
      ,]
    if (nrow(data_for_conversion) >0) {
      # Get the ICC which are missing and impute values: First the median ICC for the outcome, next the ICC for the study, next any ICC, next 0.5
      # Get the ICC which are present
      ICC <- cbind.data.frame(
        outcome_name = as.factor(data_for_conversion$outcome_name),
        study_id = as.factor(data_for_conversion$study_id),
        icc = as.numeric(data_for_conversion$outcome_data_additional_ICC)
      )
      if (TRUE %in% ! is.na(ICC$icc)) {
        # First same outcomes
        for (i in 1:nlevels(ICC$outcome_name)) {
          if (length(ICC$icc[
            (ICC$outcome_name == ICC$outcome_name[i]) &
            (! is.na(ICC$icc))
          ]) > 0) {
            ICC$icc[
              (ICC$outcome_name == ICC$outcome_name[i]) &
                (is.na(ICC$icc))
            ] <- median(ICC$icc[
              (ICC$outcome_name == ICC$outcome_name[i]) &
                (! is.na(ICC$icc))
            ]
            )        
          }
        }
        # Next same studies
        for (i in 1:nlevels(ICC$study_id)) {
          if (length(ICC$icc[
            (ICC$study_id == ICC$study_id[i]) &
            (! is.na(ICC$icc))
          ]) > 0) {
            ICC$icc[
              (ICC$study_id == ICC$study_id[i]) &
                (is.na(ICC$icc))
            ] <- median(ICC$icc[
              (ICC$study_id == ICC$study_id[i]) &
                (! is.na(ICC$icc))
            ]
            )        
          }
        }
        # Next any ICC
        ICC$icc[is.na(ICC$icc)] <- median(ICC$icc[! is.na(ICC$icc)])
      } else {
        ICC$icc <- 0.5
      }
      data_for_conversion$outcome_data_additional_ICC <- ICC$icc
      outcome_data_pre_analysis_multi_arm$outcome_data_additional_ICC[
        outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT"
      ] <- data_for_conversion$outcome_data_additional_ICC
      
      # The corrections are provided only for continuous outcomes
      Results_file_Adjusted_for_cluster_cross_over$Parameter1[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
          (Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Continuous")
      ] <- Results_file_Adjusted_for_cluster_cross_over$Parameter1[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
          (Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Continuous")
      ] - Results_file_Adjusted_for_cluster_cross_over$Parameter3[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
          (Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Continuous")
      ]
      Results_file_Adjusted_for_cluster_cross_over$Parameter2[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
          (Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Continuous")
      ] <- ((Results_file_Adjusted_for_cluster_cross_over$Parameter2[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
          (Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Continuous")
      ]^2 + Results_file_Adjusted_for_cluster_cross_over$Parameter4[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
          (Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Continuous")
      ]^2 - 2 * outcome_data_pre_analysis_multi_arm$outcome_data_additional_ICC[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
          (Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Continuous")
      ] * Results_file_Adjusted_for_cluster_cross_over$Parameter2[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
          (Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Continuous")
      ] * Results_file_Adjusted_for_cluster_cross_over$Parameter4[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
          (Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Continuous")
      ])/(
        outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1[
          (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
            (Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Continuous")
        ] + outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2[
          (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
            (Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Continuous")
        ]
      ))^0.5
      Results_file_Adjusted_for_cluster_cross_over$Parameter3[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
          (Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Continuous")
      ] <- NA
      Results_file_Adjusted_for_cluster_cross_over$Parameter4[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
          (Results_file_Adjusted_for_cluster_cross_over$`Type of outcome` == "Continuous")
      ] <- NA
    }
    # Now replace the Results_file_Main with the unadjusted results adjusted for cluster or cross over ####
    Results_file_Main[
      ((outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") |
         (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT")) & 
        (is.na(Results_file_Adjusted$Parameter1)) &
        (is.na(Results_file_Adjusted$Parameter2))
      , c(
        "Intervention (total number of participants)", "Control (total number of participants)", 
        "Parameter1", "Parameter2", "Parameter3", "Parameter4"
      )] <- Results_file_Adjusted_for_cluster_cross_over[
        ((outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") |
           (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT")) & 
          (is.na(Results_file_Adjusted$Parameter1)) &
          (is.na(Results_file_Adjusted$Parameter2))
        ,c(
          "Intervention (total number of participants)", "Control (total number of participants)", 
          "Parameter1", "Parameter2", "Parameter3", "Parameter4"
        )]
    # Also additional imputation with ICC or 0.1 and 0.9 ####
    # Start once again from "Unadjusted" Results
    Results_file_Adjusted_for_cluster_cross_over_0.1 <- Results_file_Unadjusted_for_confounding_cluster_cross_over
    # First cluster trials
    data_for_conversion <- outcome_data_pre_analysis_multi_arm[
      outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT"
      ,]
    if (nrow(data_for_conversion) >0 ) {
      data_for_conversion$outcome_data_additional_ICC <- 0.1
      outcome_data_pre_analysis_multi_arm$outcome_data_additional_ICC[
        outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT"
      ] <- data_for_conversion$outcome_data_additional_ICC
      # Calculate the design effect
      data_for_conversion$design_effect <- 1 + ((
        (data_for_conversion$n_analysed_each_outcome_intervention_1 + 
           data_for_conversion$n_analysed_each_outcome_intervention_2)/
          (data_for_conversion$outcome_data_additional_number_of_clusters_1 + 
             data_for_conversion$outcome_data_additional_number_of_clusters_2)
      ) - 1) * data_for_conversion$outcome_data_additional_ICC
      outcome_data_pre_analysis_multi_arm$design_effect[
        outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT"
      ] <- data_for_conversion$design_effect
      # Now make the appropriate changes
      # For summary differences and ratios it is only the standard error that needs alteration 
      Results_file_Adjusted_for_cluster_cross_over_0.1$Parameter2[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          ((Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Summary_Ratio") |
             (Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Summary_Difference"))
      ] <- Results_file_Adjusted_for_cluster_cross_over_0.1$Parameter2[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          ((Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Summary_Ratio") |
             (Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Summary_Difference"))
      ] * outcome_data_pre_analysis_multi_arm$design_effect[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          ((Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Summary_Ratio") |
             (Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Summary_Difference"))
      ]^0.5
      # For continuous outcomes, it is only the number of participants that needs alteration
      Results_file_Adjusted_for_cluster_cross_over_0.1$`Intervention (total number of participants)`[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Continuous")
      ] <- Results_file_Adjusted_for_cluster_cross_over_0.1$`Intervention (total number of participants)`[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Continuous")
      ] / outcome_data_pre_analysis_multi_arm$design_effect[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Continuous")
      ]
      Results_file_Adjusted_for_cluster_cross_over_0.1$`Control (total number of participants)`[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Continuous")
      ] <- Results_file_Adjusted_for_cluster_cross_over_0.1$`Control (total number of participants)`[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Continuous")
      ] / outcome_data_pre_analysis_multi_arm$design_effect[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Continuous")
      ]
      # For binary outcomes, it is the number of participants and parameters 1 and 2 that need alteration
      Results_file_Adjusted_for_cluster_cross_over_0.1$`Intervention (total number of participants)`[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Binary")
      ] <- Results_file_Adjusted_for_cluster_cross_over_0.1$`Intervention (total number of participants)`[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Binary")
      ] / outcome_data_pre_analysis_multi_arm$design_effect[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Binary")
      ]
      Results_file_Adjusted_for_cluster_cross_over_0.1$`Control (total number of participants)`[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Binary")
      ] <- Results_file_Adjusted_for_cluster_cross_over_0.1$`Control (total number of participants)`[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Binary")
      ] / outcome_data_pre_analysis_multi_arm$design_effect[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Binary")
      ]
      Results_file_Adjusted_for_cluster_cross_over_0.1$Parameter1[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Binary")
      ] <- Results_file_Adjusted_for_cluster_cross_over_0.1$Parameter1[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Binary")
      ] / outcome_data_pre_analysis_multi_arm$design_effect[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Binary")
      ]
      Results_file_Adjusted_for_cluster_cross_over_0.1$Parameter2[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Binary")
      ] <- Results_file_Adjusted_for_cluster_cross_over_0.1$Parameter2[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Binary")
      ] / outcome_data_pre_analysis_multi_arm$design_effect[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Binary")
      ]
    }
    # Next cross-over trials
    data_for_conversion <- outcome_data_pre_analysis_multi_arm[
      outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT"
      ,]
    if (nrow(data_for_conversion) >0) {
      data_for_conversion$outcome_data_additional_ICC <- 0.1
      outcome_data_pre_analysis_multi_arm$outcome_data_additional_ICC[
        outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT"
      ] <- data_for_conversion$outcome_data_additional_ICC
      
      # The corrections are provided only for continuous outcomes
      Results_file_Adjusted_for_cluster_cross_over_0.1$Parameter1[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Continuous")
      ] <- Results_file_Adjusted_for_cluster_cross_over_0.1$Parameter1[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Continuous")
      ] - Results_file_Adjusted_for_cluster_cross_over_0.1$Parameter3[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Continuous")
      ]
      Results_file_Adjusted_for_cluster_cross_over_0.1$Parameter2[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Continuous")
      ] <- ((Results_file_Adjusted_for_cluster_cross_over_0.1$Parameter2[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Continuous")
      ]^2 + Results_file_Adjusted_for_cluster_cross_over_0.1$Parameter4[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Continuous")
      ]^2 - 2 * outcome_data_pre_analysis_multi_arm$outcome_data_additional_ICC[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Continuous")
      ] * Results_file_Adjusted_for_cluster_cross_over_0.1$Parameter2[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Continuous")
      ] * Results_file_Adjusted_for_cluster_cross_over_0.1$Parameter4[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Continuous")
      ])/(
        outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1[
          (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
            (Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Continuous")
        ] + outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2[
          (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
            (Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Continuous")
        ]
      ))^0.5
      Results_file_Adjusted_for_cluster_cross_over_0.1$Parameter3[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Continuous")
      ] <- NA
      Results_file_Adjusted_for_cluster_cross_over_0.1$Parameter4[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.1$`Type of outcome` == "Continuous")
      ] <- NA
    }
    # Now replace the Results_file_Main with the only the studies where ICC was imputed
    Results_file_sensitivity_0.1_ICC <- Results_file_Main
    Results_file_sensitivity_0.1_ICC[
      ((outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") |
         (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT")) & 
        (outcome_data_pre_analysis_multi_arm$ICC_missing == TRUE)
      , c(
        "Intervention (total number of participants)", "Control (total number of participants)", 
        "Parameter1", "Parameter2", "Parameter3", "Parameter4"
      )] <- Results_file_Adjusted_for_cluster_cross_over_0.1[
        ((outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") |
           (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT")) & 
          (outcome_data_pre_analysis_multi_arm$ICC_missing == TRUE)
        ,c(
          "Intervention (total number of participants)", "Control (total number of participants)", 
          "Parameter1", "Parameter2", "Parameter3", "Parameter4"
        )]
    # Start once again from "Unadjusted" Results
    Results_file_Adjusted_for_cluster_cross_over_0.9 <- Results_file_Unadjusted_for_confounding_cluster_cross_over
    # First cluster trials 
    data_for_conversion <- outcome_data_pre_analysis_multi_arm[
      outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT"
      ,]
    if (nrow(data_for_conversion) >0 ) {
      data_for_conversion$outcome_data_additional_ICC <- 0.9
      outcome_data_pre_analysis_multi_arm$outcome_data_additional_ICC[
        outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT"
      ] <- data_for_conversion$outcome_data_additional_ICC
      # Calculate the design effect
      data_for_conversion$design_effect <- 1 + ((
        (data_for_conversion$n_analysed_each_outcome_intervention_1 + 
           data_for_conversion$n_analysed_each_outcome_intervention_2)/
          (data_for_conversion$outcome_data_additional_number_of_clusters_1 + 
             data_for_conversion$outcome_data_additional_number_of_clusters_2)
      ) - 1) * data_for_conversion$outcome_data_additional_ICC
      outcome_data_pre_analysis_multi_arm$design_effect[
        outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT"
      ] <- data_for_conversion$design_effect
      # Now make the appropriate changes
      # For summary differences and ratios it is only the standard error that needs alteration 
      Results_file_Adjusted_for_cluster_cross_over_0.9$Parameter2[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          ((Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Summary_Ratio") |
             (Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Summary_Difference"))
      ] <- Results_file_Adjusted_for_cluster_cross_over_0.9$Parameter2[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          ((Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Summary_Ratio") |
             (Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Summary_Difference"))
      ] * outcome_data_pre_analysis_multi_arm$design_effect[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          ((Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Summary_Ratio") |
             (Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Summary_Difference"))
      ]^0.5
      # For continuous outcomes, it is only the number of participants that needs alteration
      Results_file_Adjusted_for_cluster_cross_over_0.9$`Intervention (total number of participants)`[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Continuous")
      ] <- Results_file_Adjusted_for_cluster_cross_over_0.9$`Intervention (total number of participants)`[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Continuous")
      ] / outcome_data_pre_analysis_multi_arm$design_effect[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Continuous")
      ]
      Results_file_Adjusted_for_cluster_cross_over_0.9$`Control (total number of participants)`[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Continuous")
      ] <- Results_file_Adjusted_for_cluster_cross_over_0.9$`Control (total number of participants)`[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Continuous")
      ] / outcome_data_pre_analysis_multi_arm$design_effect[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Continuous")
      ]
      # For binary outcomes, it is the number of participants and parameters 1 and 2 that need alteration
      Results_file_Adjusted_for_cluster_cross_over_0.9$`Intervention (total number of participants)`[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Binary")
      ] <- Results_file_Adjusted_for_cluster_cross_over_0.9$`Intervention (total number of participants)`[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Binary")
      ] / outcome_data_pre_analysis_multi_arm$design_effect[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Binary")
      ]
      Results_file_Adjusted_for_cluster_cross_over_0.9$`Control (total number of participants)`[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Binary")
      ] <- Results_file_Adjusted_for_cluster_cross_over_0.9$`Control (total number of participants)`[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Binary")
      ] / outcome_data_pre_analysis_multi_arm$design_effect[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Binary")
      ]
      Results_file_Adjusted_for_cluster_cross_over_0.9$Parameter1[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Binary")
      ] <- Results_file_Adjusted_for_cluster_cross_over_0.9$Parameter1[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Binary")
      ] / outcome_data_pre_analysis_multi_arm$design_effect[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Binary")
      ]
      Results_file_Adjusted_for_cluster_cross_over_0.9$Parameter2[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Binary")
      ] <- Results_file_Adjusted_for_cluster_cross_over_0.9$Parameter2[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Binary")
      ] / outcome_data_pre_analysis_multi_arm$design_effect[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Binary")
      ]
    }
    # Next cross-over trials 
    data_for_conversion <- outcome_data_pre_analysis_multi_arm[
      outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT"
      ,]
    if (nrow(data_for_conversion) >0) {
      data_for_conversion$outcome_data_additional_ICC <- 0.9
      outcome_data_pre_analysis_multi_arm$outcome_data_additional_ICC[
        outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT"
      ] <- data_for_conversion$outcome_data_additional_ICC
      
      # The corrections are provided only for continuous outcomes
      Results_file_Adjusted_for_cluster_cross_over_0.9$Parameter1[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Continuous")
      ] <- Results_file_Adjusted_for_cluster_cross_over_0.9$Parameter1[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Continuous")
      ] - Results_file_Adjusted_for_cluster_cross_over_0.9$Parameter3[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Continuous")
      ]
      Results_file_Adjusted_for_cluster_cross_over_0.9$Parameter2[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Continuous")
      ] <- ((Results_file_Adjusted_for_cluster_cross_over_0.9$Parameter2[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Continuous")
      ]^2 + Results_file_Adjusted_for_cluster_cross_over_0.9$Parameter4[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Continuous")
      ]^2 - 2 * outcome_data_pre_analysis_multi_arm$outcome_data_additional_ICC[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Continuous")
      ] * Results_file_Adjusted_for_cluster_cross_over_0.9$Parameter2[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Continuous")
      ] * Results_file_Adjusted_for_cluster_cross_over_0.9$Parameter4[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Continuous")
      ])/(
        outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_1[
          (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
            (Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Continuous")
        ] + outcome_data_pre_analysis_multi_arm$n_analysed_each_outcome_intervention_2[
          (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
            (Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Continuous")
        ]
      ))^0.5
      Results_file_Adjusted_for_cluster_cross_over_0.9$Parameter3[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Continuous")
      ] <- NA
      Results_file_Adjusted_for_cluster_cross_over_0.9$Parameter4[
        (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT") &
          (Results_file_Adjusted_for_cluster_cross_over_0.9$`Type of outcome` == "Continuous")
      ] <- NA
    }
    # Now replace the Results_file_Main with the only the studies where ICC was imputed 
    Results_file_sensitivity_0.9_ICC <- Results_file_Main
    Results_file_sensitivity_0.9_ICC[
      ((outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") |
         (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT")) & 
        (outcome_data_pre_analysis_multi_arm$ICC_missing == TRUE)
      , c(
        "Intervention (total number of participants)", "Control (total number of participants)", 
        "Parameter1", "Parameter2", "Parameter3", "Parameter4"
      )] <- Results_file_Adjusted_for_cluster_cross_over_0.9[
        ((outcome_data_pre_analysis_multi_arm$study_type == "Cluster RCT") |
           (outcome_data_pre_analysis_multi_arm$study_type == "Cross-over RCT")) & 
          (outcome_data_pre_analysis_multi_arm$ICC_missing == TRUE)
        ,c(
          "Intervention (total number of participants)", "Control (total number of participants)", 
          "Parameter1", "Parameter2", "Parameter3", "Parameter4"
        )]
    # Step 8: Final processing and output ####
    Results_file_Main <- Results_file_Main[
      (! is.na(Results_file_Main$Parameter1)) & 
        (! is.na(Results_file_Main$Parameter2))
      ,]
    if (nrow(Results_file_Main) > 0) {
      if (nrow(Results_file_Main) < 4) {
        Results_file_Main[
          (nrow(Results_file_Main)+1):4
          ,] <- NA
      }
      Results_file_Main$`Intervention and control details for graphs`[1] <- 
        outcome_data_pre_analysis_multi_arm$unmodified_name_intervention_1[1]
      Results_file_Main$`Intervention and control details for graphs`[2] <- ifelse(
        is.null(DEF_Design) == FALSE,
        DEF_Design$short_names[ match("intervention_1", DEF_Design$variable)],
        outcome_data_pre_analysis_multi_arm$unmodified_name_intervention_1[1]
      )
      Results_file_Main$`Intervention and control details for graphs`[3] <- 
        outcome_data_pre_analysis_multi_arm$unmodified_name_intervention_2[1]
      Results_file_Main$`Intervention and control details for graphs`[4] <- ifelse(
        is.null(DEF_Design) == FALSE,
        DEF_Design$short_names[ match("intervention_2", DEF_Design$variable)],
        outcome_data_pre_analysis_multi_arm$unmodified_name_intervention_2[1]
      )
    }
    
    Results_file_Unadjusted_for_confounding_cluster_cross_over <- Results_file_Unadjusted_for_confounding_cluster_cross_over[
      (! is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter1)) & 
        (! is.na(Results_file_Unadjusted_for_confounding_cluster_cross_over$Parameter2))
      ,]
    if (nrow(Results_file_Unadjusted_for_confounding_cluster_cross_over) > 0) {
      if (nrow(Results_file_Unadjusted_for_confounding_cluster_cross_over) < 4) {
        Results_file_Unadjusted_for_confounding_cluster_cross_over[
          (nrow(Results_file_Unadjusted_for_confounding_cluster_cross_over)+1):4
          ,] <- NA
      }
      Results_file_Unadjusted_for_confounding_cluster_cross_over$`Intervention and control details for graphs`[1] <- 
        outcome_data_pre_analysis_multi_arm$unmodified_name_intervention_1[1]
      Results_file_Unadjusted_for_confounding_cluster_cross_over$`Intervention and control details for graphs`[2] <- ifelse(
        is.null(DEF_Design) == FALSE,
        DEF_Design$short_names[ match("intervention_1", DEF_Design$variable)],
        outcome_data_pre_analysis_multi_arm$unmodified_name_intervention_1[1]
      )
      Results_file_Unadjusted_for_confounding_cluster_cross_over$`Intervention and control details for graphs`[3] <- 
        outcome_data_pre_analysis_multi_arm$unmodified_name_intervention_2[1]
      Results_file_Unadjusted_for_confounding_cluster_cross_over$`Intervention and control details for graphs`[4] <- ifelse(
        is.null(DEF_Design) == FALSE,
        DEF_Design$short_names[ match("intervention_2", DEF_Design$variable)],
        outcome_data_pre_analysis_multi_arm$unmodified_name_intervention_2[1]
      )
    }
    
    Results_file_Adjusted <- Results_file_Adjusted[
      (! is.na(Results_file_Adjusted$Parameter1)) & 
        (! is.na(Results_file_Adjusted$Parameter2))
      ,]
    if (nrow(Results_file_Adjusted) > 0) {
      if (nrow(Results_file_Adjusted) < 4) {
        Results_file_Adjusted[
          (nrow(Results_file_Adjusted)+1):4
          ,] <- NA
      }
      Results_file_Adjusted$`Intervention and control details for graphs`[1] <- 
        outcome_data_pre_analysis_multi_arm$unmodified_name_intervention_1[1]
      Results_file_Adjusted$`Intervention and control details for graphs`[2] <- ifelse(
        is.null(DEF_Design) == FALSE,
        DEF_Design$short_names[ match("intervention_1", DEF_Design$variable)],
        outcome_data_pre_analysis_multi_arm$unmodified_name_intervention_1[1]
      )
      Results_file_Adjusted$`Intervention and control details for graphs`[3] <- 
        outcome_data_pre_analysis_multi_arm$unmodified_name_intervention_2[1]
      Results_file_Adjusted$`Intervention and control details for graphs`[4] <- ifelse(
        is.null(DEF_Design) == FALSE,
        DEF_Design$short_names[ match("intervention_2", DEF_Design$variable)],
        outcome_data_pre_analysis_multi_arm$unmodified_name_intervention_2[1]
      )
      Results_file_sensitivity_0.1_ICC <- Results_file_sensitivity_0.1_ICC[
        (! is.na(Results_file_sensitivity_0.1_ICC$Parameter1)) & 
          (! is.na(Results_file_sensitivity_0.1_ICC$Parameter2))
        ,]
      if (nrow(Results_file_sensitivity_0.1_ICC) > 0) {
        if (nrow(Results_file_sensitivity_0.1_ICC) < 4) {
          Results_file_sensitivity_0.1_ICC[
            (nrow(Results_file_sensitivity_0.1_ICC)+1):4
            ,] <- NA
        }
        Results_file_sensitivity_0.1_ICC$`Intervention and control details for graphs`[1] <- 
          outcome_data_pre_analysis_multi_arm$unmodified_name_intervention_1[1]
        Results_file_sensitivity_0.1_ICC$`Intervention and control details for graphs`[2] <- ifelse(
          is.null(DEF_Design) == FALSE,
          DEF_Design$short_names[ match("intervention_1", DEF_Design$variable)],
          outcome_data_pre_analysis_multi_arm$unmodified_name_intervention_1[1]
        )
        Results_file_sensitivity_0.1_ICC$`Intervention and control details for graphs`[3] <- 
          outcome_data_pre_analysis_multi_arm$unmodified_name_intervention_2[1]
        Results_file_sensitivity_0.1_ICC$`Intervention and control details for graphs`[4] <- ifelse(
          is.null(DEF_Design) == FALSE,
          DEF_Design$short_names[ match("intervention_2", DEF_Design$variable)],
          outcome_data_pre_analysis_multi_arm$unmodified_name_intervention_2[1]
        )
      }
      Results_file_sensitivity_0.9_ICC <- Results_file_sensitivity_0.9_ICC[
        (! is.na(Results_file_sensitivity_0.9_ICC$Parameter1)) & 
          (! is.na(Results_file_sensitivity_0.9_ICC$Parameter2))
        ,]
      if (nrow(Results_file_sensitivity_0.9_ICC) > 0) {
        if (nrow(Results_file_sensitivity_0.9_ICC) < 4) {
          Results_file_sensitivity_0.9_ICC[
            (nrow(Results_file_sensitivity_0.9_ICC)+1):4
            ,] <- NA
        }
        Results_file_sensitivity_0.9_ICC$`Intervention and control details for graphs`[1] <- 
          outcome_data_pre_analysis_multi_arm$unmodified_name_intervention_1[1]
        Results_file_sensitivity_0.9_ICC$`Intervention and control details for graphs`[2] <- ifelse(
          is.null(DEF_Design) == FALSE,
          DEF_Design$short_names[ match("intervention_1", DEF_Design$variable)],
          outcome_data_pre_analysis_multi_arm$unmodified_name_intervention_1[1]
        )
        Results_file_sensitivity_0.9_ICC$`Intervention and control details for graphs`[3] <- 
          outcome_data_pre_analysis_multi_arm$unmodified_name_intervention_2[1]
        Results_file_sensitivity_0.9_ICC$`Intervention and control details for graphs`[4] <- ifelse(
          is.null(DEF_Design) == FALSE,
          DEF_Design$short_names[ match("intervention_2", DEF_Design$variable)],
          outcome_data_pre_analysis_multi_arm$unmodified_name_intervention_2[1]
        )
      }
      
    }
    output <- list(
      main_results = Results_file_Main,
      unadjusted_results = Results_file_Unadjusted_for_confounding_cluster_cross_over,
      adjusted_results = Results_file_Adjusted,
      sensitivity_0.1_correlation_coefficient = Results_file_Adjusted_for_cluster_cross_over_0.1,
      sensitivity_0.9_correlation_coefficient = Results_file_Adjusted_for_cluster_cross_over_0.9,
      completion_status = "Successful"
    )
  } else {
    output <- list(
      main_results = "The column names do not match with those provided in the instructions. 
                   Please upload a file that has the exact column names as the sample file",
      unadjusted_results = "Not applicable",
      adjusted_results = "Not applicable",
      sensitivity_0.1_correlation_coefficient = "Not applicable",
      sensitivity_0.9_correlation_coefficient = "Not applicable",
      completion_status = "Unsuccessful"
    )
  }
  return(output)
}
convert_to_analysable_format <- function(outcome_data_pre_analysis_path, StorageFolder) {
  outcome_data_pre_analysis <- data.frame(read.csv(outcome_data_pre_analysis_path, header = TRUE, na.strings = ""))
  first <- outcome_multi_arm_studies(outcome_data_pre_analysis)
  if (first$completion_status == "Successful") {
    output_file <- wb_workbook()
    output_file$add_worksheet("Main_Results")
    output_file$add_worksheet("Unadjusted_Results")
    output_file$add_worksheet("Adjusted_Results")
    output_file$add_worksheet("SA_0.1_Correlation")
    output_file$add_worksheet("SA_0.9_Correlation")
    output_file$add_data(sheet = "Main_Results", x = first$main_results, row_names = FALSE, col_names = TRUE, na.strings = "")
    output_file$add_data(sheet = "Unadjusted_Results", x = first$unadjusted_results, row_names = FALSE, col_names = TRUE, na.strings = "")
    output_file$add_data(sheet = "Adjusted_Results", x = first$adjusted_results, row_names = FALSE, col_names = TRUE, na.strings = "")
    output_file$add_data(sheet = "SA_0.1_Correlation", x = first$sensitivity_0.1_correlation_coefficient, row_names = FALSE, col_names = TRUE, na.strings = "")
    output_file$add_data(sheet = "SA_0.9_Correlation", x = first$sensitivity_0.9_correlation_coefficient, row_names = FALSE, col_names = TRUE, na.strings = "")
    wb_save(output_file, paste0(StorageFolder, "/Processed.xlsx"))
    output <- list(
      output_file, first$completion_status
    )
  } else {
    output <- list(
      first$main_results, first$completion_status
    )
  }
  return(output)
}
compare_data_no_structure <- function(data_1_path, data_2_path, column_heading) {
  data_1 <- read.csv(data_1_path, header = (column_heading == "yes"), na.strings = c("", " ", "  "))
  data_2 <- read.csv(data_2_path, header = (column_heading == "yes"), na.strings = c("", " ", "  "))
  rows_1 <- nrow(data_1)
  rows_2 <- nrow(data_2)
  max_rows <- max(rows_1, rows_2)
  columns_1 <- ncol(data_1)
  columns_2 <- ncol(data_2)
  max_columns <- max(columns_1, columns_2)
  if (nrow(data_1) < max_rows) {
    additional_rows <- data.frame(matrix(ncol = ncol(data_1), nrow = max_rows - nrow(data_1)))
    colnames(additional_rows) <- colnames(data_1)
    data_1 <- rbind.data.frame(
      data_1,
      additional_rows
    )
  }
  if (ncol(data_1) < max_columns) {
    additional_columns <- data.frame(matrix(ncol = max_columns - ncol(data_1), nrow = nrow(data_1)))
    colnames(additional_columns) <- paste0("additional.",1:ncol(additional_columns))
    data_1 <- cbind.data.frame(
      data_1,
      additional_columns
    )
  }
  if (nrow(data_2) < max_rows) {
    additional_rows <- data.frame(matrix(ncol = ncol(data_2), nrow = max_rows - nrow(data_2)))
    colnames(additional_rows) <- colnames(data_2)
    data_2 <- rbind.data.frame(
      data_2,
      additional_rows
    )
  }
  if (ncol(data_2) < max_columns) {
    additional_columns <- data.frame(matrix(ncol = max_columns - ncol(data_2), nrow = nrow(data_2)))
    colnames(additional_columns) <- paste0("additional.",1:ncol(additional_columns))
    data_2 <- cbind.data.frame(
      data_2,
      additional_columns
    )
  }
  data_1[is.na(data_1)] <- ""
  data_2[is.na(data_2)] <- ""
  column_names <- colnames(data_1)
  colnames(data_1) <- paste0("v_",1:ncol(data_1))
  colnames(data_2) <- paste0("v_",1:ncol(data_2))
  Differences <- data.frame(data_1 == data_2)
  if (nrow(Differences) >0) {
    data_Differences <- lapply(
      1:nrow(Differences),
      function(x) {
        mismatch_columns <- colnames(Differences)[Differences[x,] == FALSE]
        mismatch_columns <- as.numeric(substr(mismatch_columns,3,nchar(mismatch_columns)))
        if (length(mismatch_columns) > 0) {
          data_Differences_each_row <- cbind.data.frame(
            Excel_cell <- paste0(
              int2col(mismatch_columns), 
              if (column_heading == "yes") {
                x +1  
              } else {
                x
              }
            ),
            if (column_heading == "yes") {
              column_names[mismatch_columns]
            } else {
              paste0("column ", mismatch_columns)
            },
            as.vector(unlist(data_1[x,mismatch_columns])),
            as.vector(unlist(data_2[x,mismatch_columns])),
            rep(NA,length(mismatch_columns)), rep(NA,length(mismatch_columns)), rep(NA,length(mismatch_columns))
          )
        }
      }
    )
    data_Differences <- do.call(rbind.data.frame, data_Differences)
    if (nrow(data_Differences) > 0) {
      colnames(data_Differences) <- c("Excel cell", "Column name (if provided)",
                                      "Data - First", "Data - Second",
                                      "Initial comments", "Reply", "Resolution"
      )
    } else {
      data_Differences <- data.frame(matrix(ncol=7))
      colnames(data_Differences) <- c("Excel cell", "Column name (if provided)",
                                      "Data - First", "Data - Second",
                                      "Initial comments", "Reply", "Resolution"
      )
      data_Differences$`Excel cell` = "There are no differences to resolve"
    }
  }
  return(data_Differences)
}
rob_classifications_from_signalling_questions <- function(rob_file_path, rob_tool_name) {
  rob_file <- read.csv(rob_file_path, header = FALSE, na.strings = c("", " ", "  "))
  # Some data frames for calculating risk domains ####
  rob_columns_summary <- data.frame(
    tool_full_name = c(
      "Risk of bias tool: RoB 2 (Randomised controlled trials)",
      "Risk of bias tool: ROB 2 - Cluster (Cluster randomised controlled trials)",
      "Risk of bias tool: ROB 2 - Cross-over (Cross-over randomised controlled trials)",
      "Risk of bias tool: ROBINS-I (Non-randomised studies of intervention)"
    ),
    tool = c("rob2", "rob2_cluster", "rob2_cross_over", "robins_i"),
    columns = c(30,36,34,44)
  )
  rob_answer_conversions <- data.frame(
    letters_only = c("Y","PY","N","PN","NI","NA"),
    words_only = c("Yes", "Probably Yes", "No", "Probably No", "No Information", "Not Applicable"),
    robins_i_1 = c("low", "moderate","no information", "ni", "serious", "critical"),
    robins_i_2 = c("Low risk of bias", "Moderate risk of bias","No Information","No Information", "Serious risk of bias", "Critical risk of bias")
  )
  rob_answer_conversions$letter_words <- paste0(rob_answer_conversions$letters_only, " = ", rob_answer_conversions$words_only)
  rob_answer_conversions$letters_only <- tolower(rob_answer_conversions$letters_only)
  rob_answer_conversions$words_only <- tolower(rob_answer_conversions$words_only)
  
  rob_questions <- read.csv("rob_questions.csv", header = FALSE, na.strings = "")
  
  column_numbers_match <- ncol(rob_file) == rob_columns_summary$columns[match(rob_tool_name, rob_columns_summary$tool_full_name)]
  # If column numbers match ####
  if (column_numbers_match == TRUE) {
    column_names_match <- (!FALSE %in% (
      rob_file[1,1:rob_columns_summary$columns[match(rob_tool_name, rob_columns_summary$tool_full_name)]] ==
        rob_questions[match(rob_tool_name, rob_columns_summary$tool_full_name),
                      1:rob_columns_summary$columns[match(rob_tool_name, rob_columns_summary$tool_full_name)]
        ]
    ))
    if (column_names_match == TRUE) {
      # Process data file ####
      # Replace questions with field code as column names
      colnames(rob_file) <- rob_questions[(match(rob_tool_name, rob_columns_summary$tool_full_name) + 4),
                                          1:rob_columns_summary$columns[match(rob_tool_name, rob_columns_summary$tool_full_name)]
      ]
      # Remove the questions
      rob_file <- rob_file[2:nrow(rob_file),]
      row.names(rob_file) <- 1:nrow(rob_file)
      # Replace NA with ""
      rob_file[is.na(rob_file)] <- ""
      # At this stage change the name to shorter format
      rob_tool_name <- rob_columns_summary$tool[
        match(rob_tool_name, rob_columns_summary$tool_full_name)
      ]
      # Keep only the valid data
      # Easier to write code and probably faster if the files are split as first two columns can be any data
      # For robins-i, for columns 11, 17, 21, 24, 29, 35, 40, and 44, it is robins_i_1 or robins_i_2, else it is letters, words, or letter_words
      # So split robins-i into 3; others into two
      if (rob_tool_name != "robins_i") {
        rob_file_1 <- rob_file[,1:2]
        rob_file_2 <- rob_file[,c(3:ncol(rob_file))]
        rob_file_2 <- lapply(
          1:nrow(rob_file_2),
          function(x) {
            rob_file_2[x,] <- tolower(rob_file_2[x,])
          }
        )
        rob_file_2 <- do.call(rbind.data.frame, rob_file_2)
        colnames(rob_file_2) <- colnames(rob_file)[3:ncol(rob_file)]
        for (i in 1:6) {
          rob_file_2[rob_file_2 == rob_answer_conversions$letters_only[i]] <- rob_answer_conversions$letter_words[i]
          rob_file_2[rob_file_2 == rob_answer_conversions$words_only[i]] <- rob_answer_conversions$letter_words[i]
        }
        rob_data <- cbind.data.frame(
          rob_file_1,
          rob_file_2
        )
        colnames(rob_data) <- colnames(rob_file)
      } else {
        rob_file_1 <- rob_file[,1:2]
        rob_file_2 <- rob_file[,setdiff(c(3:ncol(rob_file)),c(11,17,21,24,29,35,40,44))]
        rob_file_3 <- rob_file[,c(11,17,21,24,29,35,40,44)]
        # For robins-i, the splits are not continuous; retain the column names for future
        rob_file_2_column_names <- colnames(rob_file_2)
        rob_file_3_column_names <- colnames(rob_file_3)
        rob_file_2 <- lapply(
          1:nrow(rob_file_2),
          function(x) {
            rob_file_2[x,] <- tolower(rob_file_2[x,])
          }
        )
        rob_file_2 <- do.call(rbind.data.frame, rob_file_2)
        colnames(rob_file_2) <- rob_file_2_column_names
        for (i in 1:6) {
          rob_file_2[rob_file_2 == rob_answer_conversions$letters_only[i]] <- rob_answer_conversions$letter_words[i]
          rob_file_2[rob_file_2 == rob_answer_conversions$words_only[i]] <- rob_answer_conversions$letter_words[i]
        }
        rob_file_3 <- lapply(
          1:nrow(rob_file_3),
          function(x) {
            rob_file_3[x,] <- tolower(rob_file_3[x,])
          }
        )
        rob_file_3 <- do.call(rbind.data.frame, rob_file_3)
        colnames(rob_file_3) <- rob_file_3_column_names
        for (i in 1:6) {
          rob_file_3[rob_file_3 == rob_answer_conversions$robins_i_1[i]] <- rob_answer_conversions$robins_i_2[i]
        }
        rob_data <- cbind.data.frame(
          rob_file_1,
          rob_file_2,
          rob_file_3
        )
        rob_data <- rob_data[,colnames(rob_file)]
      }
      rob_tools <- read.csv("rob_tools.csv", header = TRUE, na.strings = NA)
      colnames(rob_data) <- 
        c(
          "study_id", "outcome_name",
          paste0(
            rob_tools$tool[
              match(colnames(rob_data)[3:ncol(rob_data)],
                    rob_tools$short_name
              )
            ],
            "_",
            rob_tools$question[
              match(colnames(rob_data)[3:ncol(rob_data)],
                    rob_tools$short_name
              )
            ]
          )
        )
      # ROB classifications ####
      if (rob_tool_name == "rob2") {
        # ROB2 domain 1 ####
        rob_data$rob2_domain_1[
          ((rob_data$rob2_1.2 == "N = No") | 
             (rob_data$rob2_1.2 == "PN = Probably No")) |
            ((rob_data$rob2_1.3 == "Y = Yes") | 
               (rob_data$rob2_1.3 == "PY = Probably Yes"))
        ] <- "High risk" 
        rob_data$rob2_domain_1[
          is.na(rob_data$rob2_domain_1) & 
            ((rob_data$rob2_1.2 == "Y = Yes") | 
               (rob_data$rob2_1.2 == "PY = Probably Yes")) & 
            ((rob_data$rob2_1.1 == "Y = Yes") | 
               (rob_data$rob2_1.1 == "PY = Probably Yes") | 
               (rob_data$rob2_1.1 == "NI = No Information")) &
            ((rob_data$rob2_1.3 == "N = No") | 
               (rob_data$rob2_1.3 == "PN = Probably No") | 
               (rob_data$rob2_1.3 == "NI = No Information"))
        ] <- "Low risk"
        rob_data$rob2_domain_1[
          is.na(rob_data$rob2_domain_1)
        ] <- "Some concerns"
        # ROB2 domain 2 (ITT) ####
        rob_data$rob2_domain_2_ITT[
          ((((rob_data$rob2_2.1_ITT == "N = No") | 
               (rob_data$rob2_2.1_ITT == "PN = Probably No")) &
              ((rob_data$rob2_2.2_ITT == "N = No") | 
                 (rob_data$rob2_2.2_ITT == "PN = Probably No"))) |
             ((rob_data$rob2_2.3_ITT == "N = No") | 
                (rob_data$rob2_2.3_ITT == "PN = Probably No"))) &
            ((rob_data$rob2_2.6_ITT == "Y = Yes") | 
               (rob_data$rob2_2.6_ITT == "PY = Probably Yes"))
        ] <- "Low risk" 
        rob_data$rob2_domain_2_ITT[
          is.na(rob_data$rob2_domain_2_ITT) &
            (
              (
                ((rob_data$rob2_2.3_ITT == "Y = Yes") | 
                   (rob_data$rob2_2.3_ITT == "PY = Probably Yes")) &
                  ((rob_data$rob2_2.4_ITT == "Y = Yes") | 
                     (rob_data$rob2_2.4_ITT == "PY = Probably Yes") | 
                     (rob_data$rob2_2.4_ITT == "NI = No Information")) &
                  ((rob_data$rob2_2.5_ITT == "N = No") | 
                     (rob_data$rob2_2.5_ITT == "PN = Probably No") | 
                     (rob_data$rob2_2.5_ITT == "NI = No Information"))
              ) |
                ((rob_data$rob2_2.7_ITT == "Y = Yes") | 
                   (rob_data$rob2_2.7_ITT == "PY = Probably Yes") | 
                   (rob_data$rob2_2.7_ITT == "NI = No Information"))
            )
        ] <- "High risk" 
        rob_data$rob2_domain_2_ITT[
          is.na(rob_data$rob2_domain_2_ITT)
        ] <- "Some concerns"
        # ROB2 domain 2 (PP) #### 
        rob_data$rob2_domain_2_PP[
          (
            (
              ((rob_data$rob2_2.1_PP == "N = No") | 
                 (rob_data$rob2_2.1_PP == "PN = Probably No")) &
                ((rob_data$rob2_2.2_PP == "N = No") | 
                   (rob_data$rob2_2.2_PP == "PN = Probably No"))
            ) | 
              ((rob_data$rob2_2.3_PP == "Y = Yes") | 
                 (rob_data$rob2_2.3_PP == "PY = Probably Yes") | 
                 (rob_data$rob2_2.3_PP == "NA = Not Applicable"))
          ) &
            ((rob_data$rob2_2.4_PP == "N = No") | 
               (rob_data$rob2_2.4_PP == "PN = Probably No") | 
               (rob_data$rob2_2.4_PP == "NA = Not Applicable")) &
            ((rob_data$rob2_2.5_PP == "N = No") | 
               (rob_data$rob2_2.5_PP == "PN = Probably No") | 
               (rob_data$rob2_2.5_PP == "NA = Not Applicable"))
        ] <- "Low risk"
        rob_data$rob2_domain_2_PP[
          is.na(rob_data$rob2_domain_2_PP) &
            (
              ((rob_data$rob2_2.3_PP == "N = No") | 
                 (rob_data$rob2_2.3_PP == "PN = Probably No") | 
                 (rob_data$rob2_2.3_PP == "NI = No Information")) | 
                ((rob_data$rob2_2.4_PP == "Y = Yes") | 
                   (rob_data$rob2_2.4_PP == "PY = Probably Yes") | 
                   (rob_data$rob2_2.4_PP == "NI = No Information")) |
                ((rob_data$rob2_2.5_PP == "Y = Yes") | 
                   (rob_data$rob2_2.5_PP == "PY = Probably Yes") | 
                   (rob_data$rob2_2.5_PP == "NI = No Information"))
            ) &
            ((rob_data$rob2_2.6_PP == "N = No") | 
               (rob_data$rob2_2.6_PP == "PN = Probably No") | 
               (rob_data$rob2_2.6_PP == "NI = No Information"))
        ] <- "High risk"
        rob_data$rob2_domain_2_PP[
          is.na(rob_data$rob2_domain_2_PP)
        ] <- "Some concerns"
        # ROB2 domain 3 ####
        rob_data$rob2_domain_3[
          ((rob_data$rob2_3.1 == "Y = Yes") | 
             (rob_data$rob2_3.1 == "PY = Probably Yes")) |
            ((rob_data$rob2_3.2 == "Y = Yes") | 
               (rob_data$rob2_3.2 == "PY = Probably Yes")) |
            ((rob_data$rob2_3.3 == "N = No") | 
               (rob_data$rob2_3.3 == "PN = Probably No"))
        ] <- "Low risk"
        rob_data$rob2_domain_3[
          is.na(rob_data$rob2_domain_3) &
            ((rob_data$rob2_3.1 == "N = No") | 
               (rob_data$rob2_3.1 == "PN = Probably No") | 
               (rob_data$rob2_3.1 == "NI = No Information")) & 
            ((rob_data$rob2_3.2 == "N = No") | 
               (rob_data$rob2_3.2 == "PN = Probably No")) &
            ((rob_data$rob2_3.3 == "Y = Yes") | 
               (rob_data$rob2_3.3 == "PY = Probably Yes") | 
               (rob_data$rob2_3.3 == "NI = No Information")) &
            ((rob_data$rob2_3.4 == "Y = Yes") | 
               (rob_data$rob2_3.4 == "PY = Probably Yes") | 
               (rob_data$rob2_3.4 == "NI = No Information"))
        ] <- "High risk"
        rob_data$rob2_domain_3[
          is.na(rob_data$rob2_domain_3)
        ] <- "Some concerns"
        # ROB2 domain 4 ####
        rob_data$rob2_domain_4[
          ((rob_data$rob2_4.1 == "N = No") | 
             (rob_data$rob2_4.1 == "PN = Probably No") | 
             (rob_data$rob2_4.1 == "NI = No Information")) & 
            ((rob_data$rob2_4.2 == "N = No") | 
               (rob_data$rob2_4.2 == "PN = Probably No")) &
            (((rob_data$rob2_4.3 == "N = No") | 
                (rob_data$rob2_4.3 == "PN = Probably No")) |
               (((rob_data$rob2_4.3 == "Y = Yes") | 
                   (rob_data$rob2_4.3 == "PY = Probably Yes") | 
                   (rob_data$rob2_4.3 == "NI = No Information")) &
                  ((rob_data$rob2_4.4 == "N = No") | 
                     (rob_data$rob2_4.4 == "PN = Probably No"))))
        ] <- "Low risk"
        rob_data$rob2_domain_4[
          is.na(rob_data$rob2_domain_4) &
            ((rob_data$rob2_4.1 == "N = No") | 
               (rob_data$rob2_4.1 == "PN = Probably No") | 
               (rob_data$rob2_4.1 == "NI = No Information")) &
            (  
              (((rob_data$rob2_4.2 == "N = No") | 
                  (rob_data$rob2_4.2 == "PN = Probably No")) &
                 (
                   (((rob_data$rob2_4.3 == "Y = Yes") | 
                       (rob_data$rob2_4.3 == "PY = Probably Yes") | 
                       (rob_data$rob2_4.3 == "NI = No Information")) &
                      ((rob_data$rob2_4.4 == "Y = Yes") | 
                         (rob_data$rob2_4.4 == "PY = Probably Yes") | 
                         (rob_data$rob2_4.4 == "NI = No Information")) &
                      ((rob_data$rob2_4.5 == "N = No") | 
                         (rob_data$rob2_4.5 == "PN = Probably No"))
                   )
                 )
              ) |
                (((rob_data$rob2_4.2 == "NI = No Information")) &
                   (
                     ((rob_data$rob2_4.3 == "N = No") | 
                        (rob_data$rob2_4.3 == "PN = Probably No")) |
                       (((rob_data$rob2_4.3 == "Y = Yes") | 
                           (rob_data$rob2_4.3 == "PY = Probably Yes") | 
                           (rob_data$rob2_4.3 == "NI = No Information")) &
                          (
                            ((rob_data$rob2_4.4 == "N = No") | 
                               (rob_data$rob2_4.4 == "PN = Probably No")) |
                              (((rob_data$rob2_4.4 == "Y = Yes") | 
                                  (rob_data$rob2_4.4 == "PY = Probably Yes") | 
                                  (rob_data$rob2_4.4 == "NI = No Information")) &
                                 ((rob_data$rob2_4.5 == "N = No") | 
                                    (rob_data$rob2_4.5 == "PN = Probably No")))
                          )
                       )
                   )
                )
            )
        ] <- "Some concerns"
        rob_data$rob2_domain_4[
          is.na(rob_data$rob2_domain_4)
        ] <- "High risk"
        # ROB2 domain 5 ####
        rob_data$rob2_domain_5[
          ((rob_data$rob2_5.2 == "Y = Yes") | 
             (rob_data$rob2_5.2 == "PY = Probably Yes")) |
            ((rob_data$rob2_5.3 == "Y = Yes") | 
               (rob_data$rob2_5.3 == "PY = Probably Yes"))
        ] <- "High risk" 
        rob_data$rob2_domain_5[
          is.na(rob_data$rob2_domain_5) & 
            ((rob_data$rob2_5.2 == "N = No") | 
               (rob_data$rob2_5.2 == "PN = Probably No")) &
            ((rob_data$rob2_5.3 == "N = No") | 
               (rob_data$rob2_5.3 == "PN = Probably No")) &
            ((rob_data$rob2_5.1 == "Y = Yes") | 
               (rob_data$rob2_5.1 == "PY = Probably Yes"))
        ] <- "Low risk"
        rob_data$rob2_domain_5[
          is.na(rob_data$rob2_domain_5) 
        ] <- "Some concerns"
        # ROB2 overall ####
        rob_data$rob2_overall <- 
          as.character(sapply(1:nrow(rob_data), function(y) {
            if (
              !is.na(match("High risk", 
                           c(
                             rob_data$rob2_domain_1[y],
                             rob_data$rob2_domain_2_ITT[y],
                             rob_data$rob2_domain_2_PP[y],
                             rob_data$rob2_domain_3[y],
                             rob_data$rob2_domain_4[y],
                             rob_data$rob2_domain_5[y]
                           )))
            ) {
              "High risk of bias"
            } else if (
              !is.na(match("Some concerns", 
                           c(
                             rob_data$rob2_domain_1[y],
                             rob_data$rob2_domain_2_ITT[y],
                             rob_data$rob2_domain_2_PP[y],
                             rob_data$rob2_domain_3[y],
                             rob_data$rob2_domain_4[y],
                             rob_data$rob2_domain_5[y]
                           )))
            ) {
              "Some concerns"
            } else {
              "Low risk of bias"
            }
          }))
        rob_data$rob2_overall_no_PP <- 
          as.character(sapply(1:nrow(rob_data), function(y) {
            if (
              !is.na(match("High risk", 
                           c(
                             rob_data$rob2_domain_1[y],
                             rob_data$rob2_domain_2_ITT[y],
                             rob_data$rob2_domain_3[y],
                             rob_data$rob2_domain_4[y],
                             rob_data$rob2_domain_5[y]
                           )))
            ) {
              "High risk of bias"
            } else if (
              !is.na(match("Some concerns", 
                           c(
                             rob_data$rob2_domain_1[y],
                             rob_data$rob2_domain_2_ITT[y],
                             rob_data$rob2_domain_3[y],
                             rob_data$rob2_domain_4[y],
                             rob_data$rob2_domain_5[y]
                           )))
            ) {
              "Some concerns"
            } else {
              "Low risk of bias"
            }
          }))
        # Comments and change column names ####
        rob_data$comments <-
          as.character(sapply(1:nrow(rob_data), function(y) {
            if (! is.na(match("",rob_data[y,]))) {
              # Check whether fields other than per-protocol effect had missing data: per-protocol fields are in columns 13:18
              if (! is.na(match("",rob_data[y,c(1:12,19:30)]))) {
                "One or more signalling questions had incomplete or invalid data. 
              Please check and reupload revised file to obtain correct classifications"
              } else {
                "One or more signalling questions for per-protocol effect was missing.
                If you were planning to obtain per-protocol effect as well in the classifications, 
                please check and reupload revised file to obtain correct classifications"
              }
            } else {
              "All signalling questions were complete."
            }
          }))
        # Change column names
        colnames(rob_data) <- c(
          rob_questions[match(rob_tool_name, rob_columns_summary$tool),
                        1:rob_columns_summary$columns[match(rob_tool_name, rob_columns_summary$tool)]
          ],
          "Risk of bias (domain 1)",
          "Risk of bias (domain 2) (Intention-to-treat effect)",
          "Risk of bias (domain 2) (Per-protocol effect)",
          "Risk of bias (domain 3)",
          "Risk of bias (domain 4)",
          "Risk of bias (domain 5)",
          "Overall risk of bias",
          "Overall risk of bias (without per-protocol effect)",
          "Comments"
        )
        
      } else if (rob_tool_name == "rob2_cluster") {
        # ROB2 cluster ####
        # ROB2 cluster domain 1 ####
        rob_data$rob2_cluster_domain_1[
          ((rob_data$rob2_cluster_1a.2 == "N = No") | 
             (rob_data$rob2_cluster_1a.2 == "PN = Probably No")) |
            ((rob_data$rob2_cluster_1a.3 == "Y = Yes") | 
               (rob_data$rob2_cluster_1a.3 == "PY = Probably Yes")) |
            ((rob_data$rob2_cluster_1b.2 == "Y = Yes") | 
               (rob_data$rob2_cluster_1b.2 == "PY = Probably Yes")) |
            (
              (rob_data$rob2_cluster_1b.2 == "NI = No Information") & 
                ((rob_data$rob2_cluster_1b.3 == "Y = Yes") | 
                   (rob_data$rob2_cluster_1b.3 == "PY = Probably Yes"))
            )
        ] <- "High risk" 
        rob_data$rob2_cluster_domain_1[
          is.na(rob_data$rob2_cluster_domain_1) & 
            ((rob_data$rob2_cluster_1a.2 == "Y = Yes") | 
               (rob_data$rob2_cluster_1a.2 == "PY = Probably Yes")) & 
            ((rob_data$rob2_cluster_1a.1 == "Y = Yes") | 
               (rob_data$rob2_cluster_1a.1 == "PY = Probably Yes") | 
               (rob_data$rob2_cluster_1a.1 == "NI = No Information")) &
            ((rob_data$rob2_cluster_1a.3 == "N = No") | 
               (rob_data$rob2_cluster_1a.3 == "PN = Probably No") | 
               (rob_data$rob2_cluster_1a.3 == "NI = No Information")) & 
            ((rob_data$rob2_cluster_1b.1 == "Y = Yes") | 
               (rob_data$rob2_cluster_1b.1 == "PY = Probably Yes"))
        ] <- "Low risk"
        rob_data$rob2_cluster_domain_1[
          is.na(rob_data$rob2_cluster_domain_1)
        ] <- "Some concerns"
        # ROB2 cluster domain 2 (ITT) ####
        rob_data$rob2_cluster_domain_2_ITT[
          (
            (
              ((rob_data$rob2_cluster_2.1a_ITT == "N = No") | 
                 (rob_data$rob2_cluster_2.1a_ITT == "PN = Probably No")) &
                ((rob_data$rob2_cluster_2.2_ITT == "N = No") | 
                   (rob_data$rob2_cluster_2.2_ITT == "PN = Probably No"))
            ) |
              (
                ((rob_data$rob2_cluster_2.1b_ITT == "N = No") | 
                   (rob_data$rob2_cluster_2.1b_ITT == "PN = Probably No")) &
                  ((rob_data$rob2_cluster_2.2_ITT == "N = No") | 
                     (rob_data$rob2_cluster_2.2_ITT == "PN = Probably No"))
              ) |
              ((rob_data$rob2_cluster_2.3_ITT == "N = No") | 
                 (rob_data$rob2_cluster_2.3_ITT == "PN = Probably No"))
          ) &
            (
              (rob_data$rob2_cluster_2.6_ITT == "Y = Yes") | 
                (rob_data$rob2_cluster_2.6_ITT == "PY = Probably Yes")
            )
        ] <- "Low risk" 
        rob_data$rob2_cluster_domain_2_ITT[
          is.na(rob_data$rob2_cluster_domain_2_ITT) &
            (
              (
                (
                  (rob_data$rob2_cluster_2.1a_ITT == "Y = Yes") | 
                    (rob_data$rob2_cluster_2.1a_ITT == "PY = Probably Yes") |
                    (rob_data$rob2_cluster_2.1a_ITT == "NI = No Information")
                ) &
                  (
                    (
                      (rob_data$rob2_cluster_2.1b_ITT == "Y = Yes") | 
                        (rob_data$rob2_cluster_2.1b_ITT == "PY = Probably Yes") | 
                        (rob_data$rob2_cluster_2.1b_ITT == "NI = No Information")
                    ) |
                      (
                        (rob_data$rob2_cluster_2.2_ITT == "Y = Yes") | 
                          (rob_data$rob2_cluster_2.2_ITT == "PY = Probably Yes")| 
                          (rob_data$rob2_cluster_2.2_ITT == "NI = No Information")
                      )
                  ) &
                  ((rob_data$rob2_cluster_2.3_ITT == "Y = Yes") | 
                     (rob_data$rob2_cluster_2.3_ITT == "PY = Probably Yes")) &
                  ((rob_data$rob2_cluster_2.4_ITT == "Y = Yes") | 
                     (rob_data$rob2_cluster_2.4_ITT == "PY = Probably Yes") | 
                     (rob_data$rob2_cluster_2.4_ITT == "NI = No Information")) &
                  ((rob_data$rob2_cluster_2.5_ITT == "N = No") | 
                     (rob_data$rob2_cluster_2.5_ITT == "PN = Probably No") | 
                     (rob_data$rob2_cluster_2.5_ITT == "NI = No Information"))
              ) |
                (
                  (rob_data$rob2_cluster_2.7_ITT == "Y = Yes") | 
                    (rob_data$rob2_cluster_2.7_ITT == "PY = Probably Yes") | 
                    (rob_data$rob2_cluster_2.7_ITT == "NI = No Information")
                )
            )
        ] <- "High risk" 
        rob_data$rob2_cluster_domain_2_ITT[
          is.na(rob_data$rob2_cluster_domain_2_ITT)
        ] <- "Some concerns"
        # ROB2 cluster domain 2 (PP) #### 
        rob_data$rob2_cluster_domain_2_PP[
          (
            (
              ((rob_data$rob2_cluster_2.1_PP == "N = No") | 
                 (rob_data$rob2_cluster_2.1_PP == "PN = Probably No")) &
                ((rob_data$rob2_cluster_2.2_PP == "N = No") | 
                   (rob_data$rob2_cluster_2.2_PP == "PN = Probably No"))
            ) | 
              ((rob_data$rob2_cluster_2.3_PP == "Y = Yes") | 
                 (rob_data$rob2_cluster_2.3_PP == "PY = Probably Yes") | 
                 (rob_data$rob2_cluster_2.3_PP == "NA = Not Applicable"))
          ) &
            ((rob_data$rob2_cluster_2.4_PP == "N = No") | 
               (rob_data$rob2_cluster_2.4_PP == "PN = Probably No") | 
               (rob_data$rob2_cluster_2.4_PP == "NA = Not Applicable")) &
            ((rob_data$rob2_cluster_2.5_PP == "N = No") | 
               (rob_data$rob2_cluster_2.5_PP == "PN = Probably No") | 
               (rob_data$rob2_cluster_2.5_PP == "NA = Not Applicable"))
        ] <- "Low risk"
        rob_data$rob2_cluster_domain_2_PP[
          is.na(rob_data$rob2_cluster_domain_2_PP) &
            (
              ((rob_data$rob2_cluster_2.3_PP == "N = No") | 
                 (rob_data$rob2_cluster_2.3_PP == "PN = Probably No") | 
                 (rob_data$rob2_cluster_2.3_PP == "NI = No Information")) | 
                ((rob_data$rob2_cluster_2.4_PP == "Y = Yes") | 
                   (rob_data$rob2_cluster_2.4_PP == "PY = Probably Yes") | 
                   (rob_data$rob2_cluster_2.4_PP == "NI = No Information")) |
                ((rob_data$rob2_cluster_2.5_PP == "Y = Yes") | 
                   (rob_data$rob2_cluster_2.5_PP == "PY = Probably Yes") | 
                   (rob_data$rob2_cluster_2.5_PP == "NI = No Information"))
            ) &
            ((rob_data$rob2_cluster_2.6_PP == "N = No") | 
               (rob_data$rob2_cluster_2.6_PP == "PN = Probably No") | 
               (rob_data$rob2_cluster_2.6_PP == "NI = No Information"))
        ] <- "High risk"
        rob_data$rob2_cluster_domain_2_PP[
          is.na(rob_data$rob2_cluster_domain_2_PP)
        ] <- "Some concerns"
        # ROB2 cluster domain 3 ####
        rob_data$rob2_cluster_domain_3[
          (
            ((rob_data$rob2_cluster_3.1a == "Y = Yes") | 
               (rob_data$rob2_cluster_3.1a == "PY = Probably Yes")) & 
              ((rob_data$rob2_cluster_3.1b == "Y = Yes") | 
                 (rob_data$rob2_cluster_3.1b == "PY = Probably Yes"))
          )|
            (
              (rob_data$rob2_cluster_3.2 == "Y = Yes") | 
                (rob_data$rob2_cluster_3.2 == "PY = Probably Yes")
            ) |
            (
              (rob_data$rob2_cluster_3.3 == "N = No") | 
                (rob_data$rob2_cluster_3.3 == "PN = Probably No")
            )
        ] <- "Low risk"
        rob_data$rob2_cluster_domain_3[
          is.na(rob_data$rob2_cluster_domain_3) &
            (
              (
                (rob_data$rob2_cluster_3.1a == "N = No") | 
                  (rob_data$rob2_cluster_3.1a == "PN = Probably No") | 
                  (rob_data$rob2_cluster_3.1a == "NI = No Information")
              ) |
                (
                  (rob_data$rob2_cluster_3.1b == "N = No") | 
                    (rob_data$rob2_cluster_3.1b == "PN = Probably No") | 
                    (rob_data$rob2_cluster_3.1b == "NI = No Information")
                )
            ) & 
            (
              (rob_data$rob2_cluster_3.2 == "N = No") | 
                (rob_data$rob2_cluster_3.2 == "PN = Probably No")
            ) &
            (
              (rob_data$rob2_cluster_3.3 == "Y = Yes") | 
                (rob_data$rob2_cluster_3.3 == "PY = Probably Yes") | 
                (rob_data$rob2_cluster_3.3 == "NI = No Information")
            ) &
            (
              (rob_data$rob2_cluster_3.4 == "Y = Yes") | 
                (rob_data$rob2_cluster_3.4 == "PY = Probably Yes") | 
                (rob_data$rob2_cluster_3.4 == "NI = No Information")
            )
        ] <- "High risk"
        rob_data$rob2_cluster_domain_3[
          is.na(rob_data$rob2_cluster_domain_3)
        ] <- "Some concerns"
        # ROB2 cluster domain 4 ####
        rob_data$rob2_cluster_domain_4[
          ((rob_data$rob2_cluster_4.1 == "N = No") | 
             (rob_data$rob2_cluster_4.1 == "PN = Probably No") | 
             (rob_data$rob2_cluster_4.1 == "NI = No Information")) & 
            ((rob_data$rob2_cluster_4.2 == "N = No") | 
               (rob_data$rob2_cluster_4.2 == "PN = Probably No")) &
            (
              ((rob_data$rob2_cluster_4.3a == "N = No") | 
                 (rob_data$rob2_cluster_4.3a == "PN = Probably No")) |
                (
                  ((rob_data$rob2_cluster_4.3a == "Y = Yes") | 
                     (rob_data$rob2_cluster_4.3a == "PY = Probably Yes") | 
                     (rob_data$rob2_cluster_4.3a == "NI = No Information")) &
                    ((rob_data$rob2_cluster_4.3b == "N = No") | 
                       (rob_data$rob2_cluster_4.3b == "PN = Probably No"))
                ) |
                (
                  ((rob_data$rob2_cluster_4.3a == "Y = Yes") | 
                     (rob_data$rob2_cluster_4.3a == "PY = Probably Yes") | 
                     (rob_data$rob2_cluster_4.3a == "NI = No Information")) &
                    ((rob_data$rob2_cluster_4.3b == "Y = Yes") | 
                       (rob_data$rob2_cluster_4.3b == "PY = Probably Yes") | 
                       (rob_data$rob2_cluster_4.3b == "NI = No Information")) &
                    ((rob_data$rob2_cluster_4.4 == "N = No") | 
                       (rob_data$rob2_cluster_4.4 == "PN = Probably No"))
                )
            )
        ] <- "Low risk"
        rob_data$rob2_cluster_domain_4[
          is.na(rob_data$rob2_cluster_domain_4) &
            ((rob_data$rob2_cluster_4.1 == "N = No") | 
               (rob_data$rob2_cluster_4.1 == "PN = Probably No") | 
               (rob_data$rob2_cluster_4.1 == "NI = No Information")) &
            (  
              (
                ((rob_data$rob2_cluster_4.2 == "N = No") | 
                   (rob_data$rob2_cluster_4.2 == "PN = Probably No")) &
                  (
                    (
                      ((rob_data$rob2_cluster_4.3a == "Y = Yes") | 
                         (rob_data$rob2_cluster_4.3a == "PY = Probably Yes") | 
                         (rob_data$rob2_cluster_4.3a == "NI = No Information")) &
                        ((rob_data$rob2_cluster_4.3b == "Y = Yes") | 
                           (rob_data$rob2_cluster_4.3b == "PY = Probably Yes") | 
                           (rob_data$rob2_cluster_4.3b == "NI = No Information")) &
                        ((rob_data$rob2_cluster_4.4 == "Y = Yes") | 
                           (rob_data$rob2_cluster_4.4 == "PY = Probably Yes") | 
                           (rob_data$rob2_cluster_4.4 == "NI = No Information")) &
                        ((rob_data$rob2_cluster_4.5 == "N = No") | 
                           (rob_data$rob2_cluster_4.5 == "PN = Probably No"))
                    )
                  )
              ) |
                (
                  ((rob_data$rob2_cluster_4.2 == "NI = No Information")) &
                    (
                      ((rob_data$rob2_cluster_4.3a == "N = No") | 
                         (rob_data$rob2_cluster_4.3a == "PN = Probably No")) |
                        (
                          ((rob_data$rob2_cluster_4.3a == "Y = Yes") | 
                             (rob_data$rob2_cluster_4.3a == "PY = Probably Yes") | 
                             (rob_data$rob2_cluster_4.3a == "NI = No Information")) &
                            ((rob_data$rob2_cluster_4.3b == "N = No") | 
                               (rob_data$rob2_cluster_4.3b == "PN = Probably No"))
                        ) |
                        (
                          ((rob_data$rob2_cluster_4.3a == "Y = Yes") | 
                             (rob_data$rob2_cluster_4.3a == "PY = Probably Yes") | 
                             (rob_data$rob2_cluster_4.3a == "NI = No Information")) &
                            ((rob_data$rob2_cluster_4.3b == "Y = Yes") | 
                               (rob_data$rob2_cluster_4.3b == "PY = Probably Yes") | 
                               (rob_data$rob2_cluster_4.3b == "NI = No Information")) &
                            (
                              ((rob_data$rob2_cluster_4.4 == "N = No") | 
                                 (rob_data$rob2_cluster_4.4 == "PN = Probably No")) |
                                (((rob_data$rob2_cluster_4.4 == "Y = Yes") | 
                                    (rob_data$rob2_cluster_4.4 == "PY = Probably Yes") | 
                                    (rob_data$rob2_cluster_4.4 == "NI = No Information")) &
                                   ((rob_data$rob2_cluster_4.5 == "N = No") | 
                                      (rob_data$rob2_cluster_4.5 == "PN = Probably No")))
                            )
                        )
                    )
                )
            )
        ] <- "Some concerns"
        rob_data$rob2_cluster_domain_4[
          is.na(rob_data$rob2_cluster_domain_4)
        ] <- "High risk"
        # ROB2 cluster domain 5 ####
        rob_data$rob2_cluster_domain_5[
          ((rob_data$rob2_cluster_5.2 == "Y = Yes") | 
             (rob_data$rob2_cluster_5.2 == "PY = Probably Yes")) |
            ((rob_data$rob2_cluster_5.3 == "Y = Yes") | 
               (rob_data$rob2_cluster_5.3 == "PY = Probably Yes"))
        ] <- "High risk" 
        rob_data$rob2_cluster_domain_5[
          is.na(rob_data$rob2_cluster_domain_5) & 
            ((rob_data$rob2_cluster_5.2 == "N = No") | 
               (rob_data$rob2_cluster_5.2 == "PN = Probably No")) &
            ((rob_data$rob2_cluster_5.3 == "N = No") | 
               (rob_data$rob2_cluster_5.3 == "PN = Probably No")) &
            ((rob_data$rob2_cluster_5.1 == "Y = Yes") | 
               (rob_data$rob2_cluster_5.1 == "PY = Probably Yes"))
        ] <- "Low risk"
        rob_data$rob2_cluster_domain_5[
          is.na(rob_data$rob2_cluster_domain_5) 
        ] <- "Some concerns"
        # ROB2 cluster overall ####
        rob_data$rob2_cluster_overall <- 
          as.character(sapply(1:nrow(rob_data), function(y) {
            if (
              !is.na(match("High risk", 
                           c(
                             rob_data$rob2_cluster_domain_1[y],
                             rob_data$rob2_cluster_domain_2_ITT[y],
                             rob_data$rob2_cluster_domain_2_PP[y],
                             rob_data$rob2_cluster_domain_3[y],
                             rob_data$rob2_cluster_domain_4[y],
                             rob_data$rob2_cluster_domain_5[y]
                           )))
            ) {
              "High risk of bias"
            } else if (
              !is.na(match("Some concerns", 
                           c(
                             rob_data$rob2_cluster_domain_1[y],
                             rob_data$rob2_cluster_domain_2_ITT[y],
                             rob_data$rob2_cluster_domain_2_PP[y],
                             rob_data$rob2_cluster_domain_3[y],
                             rob_data$rob2_cluster_domain_4[y],
                             rob_data$rob2_cluster_domain_5[y]
                           )))
            ) {
              "Some concerns"
            } else {
              "Low risk of bias"
            }
          }))
        rob_data$rob2_cluster_overall_no_PP <- 
          as.character(sapply(1:nrow(rob_data), function(y) {
            if (
              !is.na(match("High risk", 
                           c(
                             rob_data$rob2_cluster_domain_1[y],
                             rob_data$rob2_cluster_domain_2_ITT[y],
                             rob_data$rob2_cluster_domain_3[y],
                             rob_data$rob2_cluster_domain_4[y],
                             rob_data$rob2_cluster_domain_5[y]
                           )))
            ) {
              "High risk of bias"
            } else if (
              !is.na(match("Some concerns", 
                           c(
                             rob_data$rob2_cluster_domain_1[y],
                             rob_data$rob2_cluster_domain_2_ITT[y],
                             rob_data$rob2_cluster_domain_3[y],
                             rob_data$rob2_cluster_domain_4[y],
                             rob_data$rob2_cluster_domain_5[y]
                           )))
            ) {
              "Some concerns"
            } else {
              "Low risk of bias"
            }
          }))
        # Comments and change column names ####
        rob_data$comments <-
          as.character(sapply(1:nrow(rob_data), function(y) {
            if (! is.na(match("",rob_data[y,]))) {
              # Check whether fields other than per-protocol effect had missing data: per-protocol fields are in columns 17:22
              if (! is.na(match("",rob_data[y,c(1:16,23:36)]))) {
                "One or more signalling questions had incomplete or invalid data. 
              Please check and reupload revised file to obtain correct classifications"
              } else {
                "One or more signalling questions for per-protocol effect was missing.
                If you were planning to obtain per-protocol effect as well in the classifications, 
                please check and reupload revised file to obtain correct classifications"
              }
            } else {
              "All signalling questions were complete."
            }
          }))
        # Change column names
        colnames(rob_data) <- c(
          rob_questions[match(rob_tool_name, rob_columns_summary$tool),
                        1:rob_columns_summary$columns[match(rob_tool_name, rob_columns_summary$tool)]
          ],
          "Risk of bias (domain 1)",
          "Risk of bias (domain 2) (Intention-to-treat effect)",
          "Risk of bias (domain 2) (Per-protocol effect)",
          "Risk of bias (domain 3)",
          "Risk of bias (domain 4)",
          "Risk of bias (domain 5)",
          "Overall risk of bias",
          "Overall risk of bias (without per-protocol effect)",
          "Comments"
        )
      } else if (rob_tool_name == "rob2_cross_over") {
        # ROB2 cross_over domain 1 ####
        rob_data$rob2_cross_over_domain_1[
          (
            ((rob_data$rob2_cross_over_1.2 == "N = No") | 
               (rob_data$rob2_cross_over_1.2 == "PN = Probably No")) |
              ((rob_data$rob2_cross_over_1.3 == "Y = Yes") | 
                 (rob_data$rob2_cross_over_1.3 == "PY = Probably Yes")) |
              ((rob_data$rob2_cross_over_S.3 == "N = No") | 
                 (rob_data$rob2_cross_over_S.3 == "PN = Probably No"))
          )
        ] <- "High risk"
        rob_data$rob2_cross_over_domain_1[
          (
            is.na(rob_data$rob2_cross_over_domain_1) & 
              ((rob_data$rob2_cross_over_1.2 == "Y = Yes") | 
                 (rob_data$rob2_cross_over_1.2 == "PY = Probably Yes")) & 
              ((rob_data$rob2_cross_over_1.1 == "Y = Yes") | 
                 (rob_data$rob2_cross_over_1.1 == "PY = Probably Yes") | 
                 (rob_data$rob2_cross_over_1.1 == "NI = No Information")) &
              ((rob_data$rob2_cross_over_1.3 == "N = No") | 
                 (rob_data$rob2_cross_over_1.3 == "PN = Probably No") | 
                 (rob_data$rob2_cross_over_1.3 == "NI = No Information")) & 
              ((rob_data$rob2_cross_over_S.3 == "Y = Yes") | 
                 (rob_data$rob2_cross_over_S.3 == "PY = Probably Yes")) & 
              (
                ((rob_data$rob2_cross_over_S.1 == "Y = Yes") | 
                   (rob_data$rob2_cross_over_S.1 == "PY = Probably Yes")) | 
                  ((rob_data$rob2_cross_over_S.2 == "Y = Yes") | 
                     (rob_data$rob2_cross_over_S.2 == "PY = Probably Yes"))
              )
          )
        ] <- "Low risk"
        rob_data$rob2_cross_over_domain_1[
          is.na(rob_data$rob2_cross_over_domain_1)
        ] <- "Some concerns"
        # ROB2 cross_over domain 2 (ITT) ####
        rob_data$rob2_cross_over_domain_2_ITT[
          ((((rob_data$rob2_cross_over_2.1_ITT == "N = No") | 
               (rob_data$rob2_cross_over_2.1_ITT == "PN = Probably No")) &
              ((rob_data$rob2_cross_over_2.2_ITT == "N = No") | 
                 (rob_data$rob2_cross_over_2.2_ITT == "PN = Probably No"))) |
             ((rob_data$rob2_cross_over_2.3_ITT == "N = No") | 
                (rob_data$rob2_cross_over_2.3_ITT == "PN = Probably No"))) &
            ((rob_data$rob2_cross_over_2.6_ITT == "Y = Yes") | 
               (rob_data$rob2_cross_over_2.6_ITT == "PY = Probably Yes"))
        ] <- "Low risk" 
        rob_data$rob2_cross_over_domain_2_ITT[
          is.na(rob_data$rob2_cross_over_domain_2_ITT) &
            (
              (
                ((rob_data$rob2_cross_over_2.3_ITT == "Y = Yes") | 
                   (rob_data$rob2_cross_over_2.3_ITT == "PY = Probably Yes")) &
                  ((rob_data$rob2_cross_over_2.4_ITT == "Y = Yes") | 
                     (rob_data$rob2_cross_over_2.4_ITT == "PY = Probably Yes") | 
                     (rob_data$rob2_cross_over_2.4_ITT == "NI = No Information")) &
                  ((rob_data$rob2_cross_over_2.5_ITT == "N = No") | 
                     (rob_data$rob2_cross_over_2.5_ITT == "PN = Probably No") | 
                     (rob_data$rob2_cross_over_2.5_ITT == "NI = No Information"))
              ) |
                ((rob_data$rob2_cross_over_2.7_ITT == "Y = Yes") | 
                   (rob_data$rob2_cross_over_2.7_ITT == "PY = Probably Yes") | 
                   (rob_data$rob2_cross_over_2.7_ITT == "NI = No Information"))
            )
        ] <- "High risk" 
        rob_data$rob2_cross_over_domain_2_ITT[
          is.na(rob_data$rob2_cross_over_domain_2_ITT)
        ] <- "Some concerns"
        # ROB2 cross_over domain 2 (PP) #### 
        rob_data$rob2_cross_over_domain_2_PP[
          (
            (
              ((rob_data$rob2_cross_over_2.1_PP == "N = No") | 
                 (rob_data$rob2_cross_over_2.1_PP == "PN = Probably No")) &
                ((rob_data$rob2_cross_over_2.2_PP == "N = No") | 
                   (rob_data$rob2_cross_over_2.2_PP == "PN = Probably No"))
            )| 
              ((rob_data$rob2_cross_over_2.3_PP == "Y = Yes") | 
                 (rob_data$rob2_cross_over_2.3_PP == "PY = Probably Yes") | 
                 (rob_data$rob2_cross_over_2.3_PP == "NA = Not Applicable"))
          ) &
            ((rob_data$rob2_cross_over_2.4_PP == "N = No") | 
               (rob_data$rob2_cross_over_2.4_PP == "PN = Probably No") | 
               (rob_data$rob2_cross_over_2.4_PP == "NA = Not Applicable")) &
            ((rob_data$rob2_cross_over_2.5_PP == "N = No") | 
               (rob_data$rob2_cross_over_2.5_PP == "PN = Probably No") | 
               (rob_data$rob2_cross_over_2.5_PP == "NA = Not Applicable"))
        ] <- "Low risk"
        rob_data$rob2_cross_over_domain_2_PP[
          is.na(rob_data$rob2_cross_over_domain_2_PP) &
            (
              ((rob_data$rob2_cross_over_2.3_PP == "N = No") | 
                 (rob_data$rob2_cross_over_2.3_PP == "PN = Probably No") | 
                 (rob_data$rob2_cross_over_2.3_PP == "NI = No Information")) | 
                ((rob_data$rob2_cross_over_2.4_PP == "Y = Yes") | 
                   (rob_data$rob2_cross_over_2.4_PP == "PY = Probably Yes") | 
                   (rob_data$rob2_cross_over_2.4_PP == "NI = No Information")) |
                ((rob_data$rob2_cross_over_2.5_PP == "Y = Yes") | 
                   (rob_data$rob2_cross_over_2.5_PP == "PY = Probably Yes") | 
                   (rob_data$rob2_cross_over_2.5_PP == "NI = No Information"))
            ) &
            ((rob_data$rob2_cross_over_2.6_PP == "N = No") | 
               (rob_data$rob2_cross_over_2.6_PP == "PN = Probably No") | 
               (rob_data$rob2_cross_over_2.6_PP == "NI = No Information"))
        ] <- "High risk"
        rob_data$rob2_cross_over_domain_2_PP[
          is.na(rob_data$rob2_cross_over_domain_2_PP)
        ] <- "Some concerns"
        
        # ROB2 cross_over domain 3 ####
        rob_data$rob2_cross_over_domain_3[
          ((rob_data$rob2_cross_over_3.1 == "Y = Yes") | 
             (rob_data$rob2_cross_over_3.1 == "PY = Probably Yes")) |
            ((rob_data$rob2_cross_over_3.2 == "Y = Yes") | 
               (rob_data$rob2_cross_over_3.2 == "PY = Probably Yes")) |
            ((rob_data$rob2_cross_over_3.3 == "N = No") | 
               (rob_data$rob2_cross_over_3.3 == "PN = Probably No"))
        ] <- "Low risk"
        rob_data$rob2_cross_over_domain_3[
          is.na(rob_data$rob2_cross_over_domain_3) &
            ((rob_data$rob2_cross_over_3.1 == "N = No") | 
               (rob_data$rob2_cross_over_3.1 == "PN = Probably No") | 
               (rob_data$rob2_cross_over_3.1 == "NI = No Information")) & 
            ((rob_data$rob2_cross_over_3.2 == "N = No") | 
               (rob_data$rob2_cross_over_3.2 == "PN = Probably No")) &
            ((rob_data$rob2_cross_over_3.3 == "Y = Yes") | 
               (rob_data$rob2_cross_over_3.3 == "PY = Probably Yes") | 
               (rob_data$rob2_cross_over_3.3 == "NI = No Information")) &
            ((rob_data$rob2_cross_over_3.4 == "Y = Yes") | 
               (rob_data$rob2_cross_over_3.4 == "PY = Probably Yes") | 
               (rob_data$rob2_cross_over_3.4 == "NI = No Information"))
        ] <- "High risk"
        rob_data$rob2_cross_over_domain_3[
          is.na(rob_data$rob2_cross_over_domain_3)
        ] <- "Some concerns"
        # ROB2 cross_over domain 4 ####
        rob_data$rob2_cross_over_domain_4[
          ((rob_data$rob2_cross_over_4.1 == "N = No") | 
             (rob_data$rob2_cross_over_4.1 == "PN = Probably No") | 
             (rob_data$rob2_cross_over_4.1 == "NI = No Information")) & 
            ((rob_data$rob2_cross_over_4.2 == "N = No") | 
               (rob_data$rob2_cross_over_4.2 == "PN = Probably No")) &
            (((rob_data$rob2_cross_over_4.3 == "N = No") | 
                (rob_data$rob2_cross_over_4.3 == "PN = Probably No")) |
               (((rob_data$rob2_cross_over_4.3 == "Y = Yes") | 
                   (rob_data$rob2_cross_over_4.3 == "PY = Probably Yes") | 
                   (rob_data$rob2_cross_over_4.3 == "NI = No Information")) &
                  ((rob_data$rob2_cross_over_4.4 == "N = No") | 
                     (rob_data$rob2_cross_over_4.4 == "PN = Probably No"))))
        ] <- "Low risk"
        rob_data$rob2_cross_over_domain_4[
          is.na(rob_data$rob2_cross_over_domain_4) &
            ((rob_data$rob2_cross_over_4.1 == "N = No") | 
               (rob_data$rob2_cross_over_4.1 == "PN = Probably No") | 
               (rob_data$rob2_cross_over_4.1 == "NI = No Information")) &
            (  
              (((rob_data$rob2_cross_over_4.2 == "N = No") | 
                  (rob_data$rob2_cross_over_4.2 == "PN = Probably No")) &
                 (
                   (((rob_data$rob2_cross_over_4.3 == "Y = Yes") | 
                       (rob_data$rob2_cross_over_4.3 == "PY = Probably Yes") | 
                       (rob_data$rob2_cross_over_4.3 == "NI = No Information")) &
                      ((rob_data$rob2_cross_over_4.4 == "Y = Yes") | 
                         (rob_data$rob2_cross_over_4.4 == "PY = Probably Yes") | 
                         (rob_data$rob2_cross_over_4.4 == "NI = No Information")) &
                      ((rob_data$rob2_cross_over_4.5 == "N = No") | 
                         (rob_data$rob2_cross_over_4.5 == "PN = Probably No"))
                   )
                 )
              ) |
                (((rob_data$rob2_cross_over_4.2 == "NI = No Information")) &
                   (
                     ((rob_data$rob2_cross_over_4.3 == "N = No") | 
                        (rob_data$rob2_cross_over_4.3 == "PN = Probably No")) |
                       (((rob_data$rob2_cross_over_4.3 == "Y = Yes") | 
                           (rob_data$rob2_cross_over_4.3 == "PY = Probably Yes") | 
                           (rob_data$rob2_cross_over_4.3 == "NI = No Information")) &
                          (
                            ((rob_data$rob2_cross_over_4.4 == "N = No") | 
                               (rob_data$rob2_cross_over_4.4 == "PN = Probably No")) |
                              (((rob_data$rob2_cross_over_4.4 == "Y = Yes") | 
                                  (rob_data$rob2_cross_over_4.4 == "PY = Probably Yes") | 
                                  (rob_data$rob2_cross_over_4.4 == "NI = No Information")) &
                                 ((rob_data$rob2_cross_over_4.5 == "N = No") | 
                                    (rob_data$rob2_cross_over_4.5 == "PN = Probably No")))
                          )
                       )
                   )
                )
            )
        ] <- "Some concerns"
        rob_data$rob2_cross_over_domain_4[
          is.na(rob_data$rob2_cross_over_domain_4)
        ] <- "High risk"
        # ROB2 cross_over domain 5 ####
        rob_data$rob2_cross_over_domain_5[
          ((rob_data$rob2_cross_over_5.2 == "Y = Yes") | 
             (rob_data$rob2_cross_over_5.2 == "PY = Probably Yes")) |
            ((rob_data$rob2_cross_over_5.3 == "Y = Yes") | 
               (rob_data$rob2_cross_over_5.3 == "PY = Probably Yes")) |
            ((rob_data$rob2_cross_over_5.4 == "Y = Yes") | 
               (rob_data$rob2_cross_over_5.4 == "PY = Probably Yes"))
        ] <- "High risk" 
        rob_data$rob2_cross_over_domain_5[
          is.na(rob_data$rob2_cross_over_domain_5) & 
            ((rob_data$rob2_cross_over_5.2 == "N = No") | 
               (rob_data$rob2_cross_over_5.2 == "PN = Probably No")) &
            ((rob_data$rob2_cross_over_5.3 == "N = No") | 
               (rob_data$rob2_cross_over_5.3 == "PN = Probably No")) &
            ((rob_data$rob2_cross_over_5.4 == "N = No") | 
               (rob_data$rob2_cross_over_5.4 == "PN = Probably No")) &
            ((rob_data$rob2_cross_over_5.1 == "Y = Yes") | 
               (rob_data$rob2_cross_over_5.1 == "PY = Probably Yes"))
        ] <- "Low risk"
        rob_data$rob2_cross_over_domain_5[
          is.na(rob_data$rob2_cross_over_domain_5) 
        ] <- "Some concerns"
        # ROB2 cross_over overall ####
        rob_data$rob2_cross_over_overall <- 
          as.character(sapply(1:nrow(rob_data), function(y) {
            if (
              !is.na(match("High risk", 
                           c(
                             rob_data$rob2_cross_over_domain_1[y],
                             rob_data$rob2_cross_over_domain_2_ITT[y],
                             rob_data$rob2_cross_over_domain_2_PP[y],
                             rob_data$rob2_cross_over_domain_3[y],
                             rob_data$rob2_cross_over_domain_4[y],
                             rob_data$rob2_cross_over_domain_5[y]
                           )))
            ) {
              "High risk of bias"
            } else if (
              !is.na(match("Some concerns", 
                           c(
                             rob_data$rob2_cross_over_domain_1[y],
                             rob_data$rob2_cross_over_domain_2_ITT[y],
                             rob_data$rob2_cross_over_domain_2_PP[y],
                             rob_data$rob2_cross_over_domain_3[y],
                             rob_data$rob2_cross_over_domain_4[y],
                             rob_data$rob2_cross_over_domain_5[y]
                           )))
            ) {
              "Some concerns"
            } else {
              "Low risk of bias"
            }
          }))
        rob_data$rob2_cross_over_overall_no_PP <- 
          as.character(sapply(1:nrow(rob_data), function(y) {
            if (
              !is.na(match("High risk", 
                           c(
                             rob_data$rob2_cross_over_domain_1[y],
                             rob_data$rob2_cross_over_domain_2_ITT[y],
                             rob_data$rob2_cross_over_domain_3[y],
                             rob_data$rob2_cross_over_domain_4[y],
                             rob_data$rob2_cross_over_domain_5[y]
                           )))
            ) {
              "High risk of bias"
            } else if (
              !is.na(match("Some concerns", 
                           c(
                             rob_data$rob2_cross_over_domain_1[y],
                             rob_data$rob2_cross_over_domain_2_ITT[y],
                             rob_data$rob2_cross_over_domain_3[y],
                             rob_data$rob2_cross_over_domain_4[y],
                             rob_data$rob2_cross_over_domain_5[y]
                           )))
            ) {
              "Some concerns"
            } else {
              "Low risk of bias"
            }
          }))
        # Comments and change column names ####
        rob_data$comments <-
          as.character(sapply(1:nrow(rob_data), function(y) {
            if (! is.na(match("",rob_data[y,]))) {
              # Check whether fields other than per-protocol effect had missing data: per-protocol fields are in columns 16:21
              if (! is.na(match("",rob_data[y,c(1:15,22:34)]))) {
                "One or more signalling questions had incomplete or invalid data. 
              Please check and reupload revised file to obtain correct classifications"
              } else {
                "One or more signalling questions for per-protocol effect was missing.
                If you were planning to obtain per-protocol effect as well in the classifications, 
                please check and reupload revised file to obtain correct classifications"
              }
            } else {
              "All signalling questions were complete."
            }
          }))
        # Change column names
        colnames(rob_data) <- c(
          rob_questions[match(rob_tool_name, rob_columns_summary$tool),
                        1:rob_columns_summary$columns[match(rob_tool_name, rob_columns_summary$tool)]
          ],
          "Risk of bias (domain 1)",
          "Risk of bias (domain 2) (Intention-to-treat effect)",
          "Risk of bias (domain 2) (Per-protocol effect)",
          "Risk of bias (domain 3)",
          "Risk of bias (domain 4)",
          "Risk of bias (domain 5)",
          "Overall risk of bias",
          "Overall risk of bias (without per-protocol effect)",
          "Comments"
        )
      } else if (rob_tool_name == "robins_i") {
        # ROBINS_I overall ####
        rob_data$robins_i_overall <- 
          as.character(sapply(1:nrow(rob_data), function(y) {
            if (
              !is.na(match("Critical risk of bias", 
                           c(
                             rob_data$robins_i_domain_1[y],
                             rob_data$robins_i_domain_2[y],
                             rob_data$robins_i_domain_3[y],
                             rob_data$robins_i_domain_4_ITT[y],
                             rob_data$robins_i_domain_4_PP[y],
                             rob_data$robins_i_domain_5[y],
                             rob_data$robins_i_domain_6[y],
                             rob_data$robins_i_domain_7[y]
                           )))
            ) {
              "Critical risk of bias"
            } else if (
              !is.na(match("Serious risk of bias", 
                           c(
                             rob_data$robins_i_domain_1[y],
                             rob_data$robins_i_domain_2[y],
                             rob_data$robins_i_domain_3[y],
                             rob_data$robins_i_domain_4_ITT[y],
                             rob_data$robins_i_domain_4_PP[y],
                             rob_data$robins_i_domain_5[y],
                             rob_data$robins_i_domain_6[y],
                             rob_data$robins_i_domain_7[y]
                           )))
            ) {
              "Serious risk of bias"
            } else if (
              !is.na(match("No information", 
                           c(
                             rob_data$robins_i_domain_1[y],
                             rob_data$robins_i_domain_2[y],
                             rob_data$robins_i_domain_3[y],
                             rob_data$robins_i_domain_4_ITT[y],
                             rob_data$robins_i_domain_4_PP[y],
                             rob_data$robins_i_domain_5[y],
                             rob_data$robins_i_domain_6[y],
                             rob_data$robins_i_domain_7[y]
                           )))
            ) {
              "No information"
            } else if (
              !is.na(match("Moderate risk of bias", 
                           c(
                             rob_data$robins_i_domain_1[y],
                             rob_data$robins_i_domain_2[y],
                             rob_data$robins_i_domain_3[y],
                             rob_data$robins_i_domain_4_ITT[y],
                             rob_data$robins_i_domain_4_PP[y],
                             rob_data$robins_i_domain_5[y],
                             rob_data$robins_i_domain_6[y],
                             rob_data$robins_i_domain_7[y]
                           )))
            ) {
              "Moderate risk of bias"
            } else {
              "Low risk of bias"
            }
          }))
        rob_data$robins_i_overall_no_PP <- 
          as.character(sapply(1:nrow(rob_data), function(y) {
            if (
              !is.na(match("Critical risk of bias", 
                           c(
                             rob_data$robins_i_domain_1[y],
                             rob_data$robins_i_domain_2[y],
                             rob_data$robins_i_domain_3[y],
                             rob_data$robins_i_domain_4_ITT[y],
                             rob_data$robins_i_domain_5[y],
                             rob_data$robins_i_domain_6[y],
                             rob_data$robins_i_domain_7[y]
                           )))
            ) {
              "Critical risk of bias"
            } else if (
              !is.na(match("Serious risk of bias", 
                           c(
                             rob_data$robins_i_domain_1[y],
                             rob_data$robins_i_domain_2[y],
                             rob_data$robins_i_domain_3[y],
                             rob_data$robins_i_domain_4_ITT[y],
                             rob_data$robins_i_domain_5[y],
                             rob_data$robins_i_domain_6[y],
                             rob_data$robins_i_domain_7[y]
                           )))
            ) {
              "Serious risk of bias"
            } else if (
              !is.na(match("No information", 
                           c(
                             rob_data$robins_i_domain_1[y],
                             rob_data$robins_i_domain_2[y],
                             rob_data$robins_i_domain_3[y],
                             rob_data$robins_i_domain_4_ITT[y],
                             rob_data$robins_i_domain_5[y],
                             rob_data$robins_i_domain_6[y],
                             rob_data$robins_i_domain_7[y]
                           )))
            ) {
              "No information"
            } else if (
              !is.na(match("Moderate risk of bias", 
                           c(
                             rob_data$robins_i_domain_1[y],
                             rob_data$robins_i_domain_2[y],
                             rob_data$robins_i_domain_3[y],
                             rob_data$robins_i_domain_4_ITT[y],
                             rob_data$robins_i_domain_5[y],
                             rob_data$robins_i_domain_6[y],
                             rob_data$robins_i_domain_7[y]
                           )))
            ) {
              "Moderate risk of bias"
            } else {
              "Low risk of bias"
            }
          }))
        # Indicate missing data
        rob_data$comments <-
          as.character(sapply(1:nrow(rob_data), function(y) {
            if (! is.na(match("",rob_data[y,]))) {
              # Check whether fields other than per-protocol effect had missing data: per-protocol fields are in columns 25:29
              if (! is.na(match("",rob_data[y,c(1:24,30:44)]))) {
                "One or more signalling questions or domains had incomplete or invalid data. 
              Please check and reupload revised file to obtain correct classifications"
              } else {
                "One or more signalling questions or domains for per-protocol effect was missing.
                If you were planning to obtain per-protocol effect as well in the classifications, 
                please check and reupload revised file to obtain correct classifications"
              }
            } else {
              "All signalling questions and domains were complete."
            }
          }))
        # Change column names
        colnames(rob_data) <- c(
          rob_questions[match(rob_tool_name, rob_columns_summary$tool),
                        1:rob_columns_summary$columns[match(rob_tool_name, rob_columns_summary$tool)]
          ],
          "Overall risk of bias",
          "Overall risk of bias (without per-protocol effect)",
          "Comments"
        )
      }
      output <- list(rob_data,"Successful")
    } else {
      output <- list(
        "The names of the columns do not match that in the instructions. Please upload a file prepared according to the instructions.",
        "Unsucessful"
      )
    }
  } else {
    output <- list(
      "The number of columns does not match that in the instructions. Please upload a file prepared according to the instructions.",
      "Unsucessful"
    )
  }
  return(output)
}
# Functions for interpreting data ####
clinical_interpretation <- function(outcome_name, better_worse, lci, uci, mid, effect_measure, StorageFolder) {
  # Decide colour
  decide_colour <- cbind.data.frame(
    interpretation = c("clinically better", "clinically worse", "no clinically important effect", "no evidence of clinically important effect"),
    colour = c("darkgreen", "darkred", "darkblue", "yellow")
  )
  
  if (missing(effect_measure)) {
    effect_measure <- "Effect measure"
  }
  data <- cbind.data.frame(
    outcome_name = outcome_name,
    lci = lci,
    uci = uci
  )
  data$y <- nrow(data):1
  data$y_max <- data$y+0.1
  data$y_min <- data$y-0.1
  if (str_detect(effect_measure,"ratio") == TRUE) {
    lci = max(lci, 0.001)
    uci = min(uci, 1000)
    transformation <- "log"
    vertical_lines <- c(1, 1-mid, 1+mid)
    upper_limit <- max(lci, 1/lci, uci, 1/uci, (1-mid), 1/(1-mid))*1.5
    lower_limit <- 1/upper_limit
    xticks <- c(0.001,0.01, 0.1, 0.25, 0.5, 0.75, 1, 1.25, 2, 4, 10, 100, 1000)
    xticks <- xticks[((xticks >= lower_limit) & (xticks <= upper_limit))]
    data$peak <- exp((log(data$lci)+log(data$uci))/2)
    if (uci < (1-mid)) {
      interpretation <- ifelse(better_worse == "worse", "clinically better", "clinically worse")
    } else if (lci > (1+mid)) {
      interpretation <- ifelse(better_worse == "worse", "clinically worse", "clinically better")
    } else if ((lci > (1-mid)) & (uci < (1+mid))) {
      interpretation <- "no clinically important effect"
    } else {
      interpretation <- "no evidence of clinically important effect"
    }
  } else {
    transformation <- "identity"
    vertical_lines <- c(0, -mid, mid)
    upper_limit <- max(abs(lci), abs(uci), abs(mid))*1.5
    lower_limit <- -1 * upper_limit
    xticks <- pretty(lower_limit:0, n = 6)
    xticks <- c(xticks, -1*xticks)
    xticks <- sort(unique(xticks), decreasing = FALSE)
    data$peak <- (data$lci+data$uci)/2
    if (uci < (-mid)) {
      interpretation <- ifelse(better_worse == "worse", "clinically better", "clinically worse")
    } else if (lci > mid) {
      interpretation <- ifelse(better_worse == "worse", "clinically worse", "clinically better")
    } else if ((lci > (-mid)) & (uci < mid)) {
      interpretation <- "no clinically important effect"
    } else {
      interpretation <- "no evidence of clinically important effect"
    }
  }
  diamond_colour <- decide_colour$colour[decide_colour$interpretation == interpretation]
  plot_important <- 
    ggplot() +
    xlab(effect_measure) + 
    ylab(outcome_name) + 
    theme(axis.text.y = element_blank(),
          axis.ticks.y = element_blank(),
          legend.position = "none") + 
    scale_x_continuous(limits = c(lower_limit, upper_limit), breaks = xticks, trans = transformation) +
    scale_y_continuous(limits = c(0,nrow(data) + 2), n.breaks = nrow(data) + 2) +
    geom_text(data=data, aes(x = vertical_lines[1], y = (y + 1), label = "No effect", angle = 90)) + 
    geom_text(data=data, aes(x = vertical_lines[2], y = (y + 1), label = ifelse(better_worse == "worse", "Clinically better", "Clinically worse"), angle = 90)) + 
    geom_text(data=data, aes(x = vertical_lines[3], y = (y + 1), label = ifelse(better_worse == "worse", "Clinically worse", "Clinically better"), angle = 90)) + 
    geom_vline(xintercept = vertical_lines[1], color = "darkgrey") +
    geom_vline(xintercept = vertical_lines[2], linetype= "dashed", color=ifelse(better_worse == "worse", "darkgreen", "darkred")) +
    geom_vline(xintercept = vertical_lines[3], linetype= "dashed", color=ifelse(better_worse == "worse", "darkred", "darkgreen")) +
    geom_polygon(
      fill=diamond_colour,
      col = "black",
      aes(x = c(data$uci[1], data$peak[1],data$lci[1],data$peak[1]), 
          y = c(data$y[1],data$y_max[1],data$y[1],data$y_min[1])
      )
    )
  ggsave(paste0(StorageFolder,"/", outcome_name, "_clinically_important.png"), dpi = 300, height = 7, width = 7)
  list(plot_important, interpretation)
}
sample_size_time_to_event <- function(hazard_ratio, number_with_event, total_number) {
  number_of_events_required <-
    nEvents(
      hr = hazard_ratio,
      alpha = 0.05,
      beta = c(0.2, 0.1),
      ratio = 1,
      sided = 2,
      hr0 = 1,
      n = 0,
      tbl = FALSE
    )
  ceiling(number_of_events_required/(number_with_event/total_number))
}
clinical_interpretation_multiple_outcomes <- function(file_location, StorageFolder) {
  mid_file <- read.csv(file_location, header = TRUE, na.strings = c("", " ", "  "))
  if ((ncol(mid_file) == 6) & 
      (!FALSE %in% (colnames(mid_file) == c("outcome_name", "better_worse", "lower_ci", "upper_ci", 
                                            "minimal_important_difference", "effect_measure")))
  ) {
    if (nrow(mid_file) > 0) {
      clinical_interpretation <- sapply(
        1:nrow(mid_file),
        function(x){
          clinical_interpretation_each_outcome <- clinical_interpretation(outcome_name = mid_file$outcome_name[x], 
                                                                          better_worse = mid_file$better_worse[x], 
                                                                          lci = mid_file$lower_ci[x], 
                                                                          uci = mid_file$upper_ci[x], 
                                                                          mid = mid_file$minimal_important_difference[x], 
                                                                          effect_measure = mid_file$effect_measure[x], 
                                                                          StorageFolder)
          return(clinical_interpretation_each_outcome[[2]])
        }
      )
      results <- cbind.data.frame(
        outcome_name = mid_file$outcome_name,
        clinical_interpretation = clinical_interpretation
      )
      write.csv(results, paste0(StorageFolder, "/Clinical_interpretation.csv"), row.names = FALSE, na = "")
      zip::zipr(zipfile = paste0(StorageFolder, "/Clinical_interpretation.zip"), 
                files = c(paste0(StorageFolder,"/", mid_file$outcome_name ,"_clinically_important.png"), paste0(StorageFolder, "/Clinical_interpretation.csv"))
      )
      file.remove(
        c(paste0(StorageFolder,"/", mid_file$outcome_name ,"_clinically_important.png"), paste0(StorageFolder, "/Clinical_interpretation.csv"))
      )
      output <- list(
        message = paste0(results$outcome_name, ": ", results$clinical_interpretation),
        completion_status = "Successful"
      )
    } else {
      output <- list(
        message = 'The file uploaded does not have any data.',
        completion_status = "Unsuccessful"
      )
    }
  } else {
    output <- list(
      message = 'The file uploaded in not in correct format. 
    The column names should be exactly "outcome_name", "better_worse", "lower_ci", "upper_ci", "minimal_important_difference", and "effect_measure"',
      completion_status = "Unsuccessful"
    )
  }
  return(output)
}
rob_me_studies_outcomes <- function(file_location) {
  outcomes_studies_file <- read.csv(file_location, header = TRUE, na.strings = c("", " ", "  "))
  if ((ncol(outcomes_studies_file) == 2) & 
      (!FALSE %in% (colnames(outcomes_studies_file) == c("outcome", "study")))
  ) {
    if (nrow(outcomes_studies_file) > 0) {
      # Create outcome list
      outcomes_list <- unique(outcomes_studies_file$outcome)
      # Create study list
      studies_list <- sort(unique(outcomes_studies_file$study))
      # Find the outcomes reported in each study
      studies_outcomes <- lapply(
        1:length(studies_list), 
        function(x) {
          c(studies_list[x], ! is.na(match(outcomes_list,
                                           outcomes_studies_file$outcome[outcomes_studies_file$study == studies_list[x]]
          )))
        }
      )
      studies_outcomes <- do.call(rbind.data.frame, studies_outcomes)
      colnames(studies_outcomes) <- c("study", outcomes_list)
      studies_outcomes[studies_outcomes == TRUE] <- "+"
      studies_outcomes[studies_outcomes == FALSE] <- "-"
      output <- list(
        results = studies_outcomes,
        completion_status = "Successful"
      )
    } else {
      output <- list(
        message = 'The file uploaded does not have any data.',
        completion_status = "Unsuccessful"
      )
    }
  } else {
    output <- list(
      message = 'The file uploaded in not in correct format. 
    The column names should be exactly "outcome" and "study"',
      completion_status = "Unsuccessful"
    )
  }
  return(output)
}
grade_rob_outcomes <- function(file_location) {
  studies_outcomes_rob_file <- read.csv(file_location, header = TRUE, na.strings = c("", " ", "  "))
  if ((ncol(studies_outcomes_rob_file) == 3) & 
      (!FALSE %in% (colnames(studies_outcomes_rob_file) == c("outcome", "study", "risk_of_bias")))
  ) {
    if (nrow(studies_outcomes_rob_file) > 0) {
      results <- table(studies_outcomes_rob_file$outcome, studies_outcomes_rob_file$risk_of_bias)
      output <- list(
        results = results,
        completion_status = "Successful"
      )
    } else {
      output <- list(
        message = 'The file uploaded does not have any data.',
        completion_status = "Unsuccessful"
      )
    }
  } else {
    output <- list(
      message = 'The file uploaded in not in correct format. 
    The column names should be exactly "outcome", "study", and "risk of bias"',
      completion_status = "Unsuccessful"
    )
  }
  return(output)
}
sample_size_binary_continuous <- function(data_file_location, mid_file_location) {
  data_file <- read.csv(data_file_location, header = TRUE, check.names = FALSE, na.strings = c("", " ", "  "))
  mid_file <- read.csv(mid_file_location, header = TRUE, na.strings = c("", " ", "  "))
  sample_data_file <- read.csv("SampleData_Intervention.csv", header = TRUE, check.names = FALSE, na = c(""," ", "  "))
  if ((ncol(data_file) >= 28) & 
      (!FALSE %in% (colnames(data_file)[1:28] == colnames(sample_data_file)[1:28]))
  ) {
    if (nrow(data_file) > 0) {
      if ((ncol(mid_file) == 2) & 
          (!FALSE %in% (colnames(mid_file) == c("outcome","minimal_important_difference")))
      ) {
        if (nrow(mid_file) > 0) {
          # Keep only the binary and continuous outcomes
          data_file <- data_file[
            (tolower(data_file$`Type of outcome`) == "binary") |
              (tolower(data_file$`Type of outcome`) == "continuous")
            ,]
          # Check whether each binary or continuous outcome has a mid
          outcomes_list <- unique(data_file$`Outcome name`)
          outcomes_mid <- mid_file$minimal_important_difference[
            match(outcomes_list, mid_file$outcome)
          ]
          if (!TRUE %in% is.na(outcomes_mid)) {
            mid_file <- mid_file[! duplicated(mid_file$outcome),]
            mid_file <- mid_file[! is.na(match(mid_file$outcome, outcomes_list)),]
            mid_file$outcome_type <- tolower(data_file$`Type of outcome`[
              match(mid_file$outcome, data_file$`Outcome name`)])
            # Calculate the median proportions in the comparator group for binary outcomes and median of the standard deviations in the comparator group for continuous outcomes and perform the sample size calculations
            mid_file$sample_size_power_80 <- sapply(
              1:nrow(mid_file),
              function(x) {
                if (mid_file$outcome_type[x] == "binary") {
                  risk_comparator <- median(
                    data_file$Parameter2[
                      (data_file$`Outcome name` == mid_file$outcome[x]) &
                        (! is.na(data_file$Parameter2)) &
                        (! is.na(data_file$`Control (total number of participants)`))
                    ]/data_file$`Control (total number of participants)`[
                      (data_file$`Outcome name` == mid_file$outcome[x]) &
                        (! is.na(data_file$Parameter2)) &
                        (! is.na(data_file$`Control (total number of participants)`))
                    ]
                  )
                  risk_intervention <- risk_comparator*(1-mid_file$minimal_important_difference[x])
                  sample_size_each_outcome <- ceiling(pwr.2p.test(h = ES.h(p1 = risk_intervention, p2 = risk_comparator), 
                                                                  sig.level = 0.05, power = 0.8, 
                                                                  alternative ="two.sided")$n)*2
                } else {
                  sd_comparator <- median(
                    data_file$Parameter4[
                      (data_file$`Outcome name` == mid_file$outcome[x]) &
                        (! is.na(data_file$Parameter4))
                    ]
                  )
                  sample_size_each_outcome <- ceiling(pwr.t.test(d = (mid_file$minimal_important_difference[x]/sd_comparator), 
                                                                 sig.level = 0.05, power = 0.8,
                                                                 type = "two.sample",
                                                                 alternative ="two.sided")$n)*2
                }
                return(sample_size_each_outcome)
              }
            )
            mid_file$sample_size_power_90 <- sapply(
              1:nrow(mid_file),
              function(x) {
                if (mid_file$outcome_type[x] == "binary") {
                  risk_comparator <- median(
                    data_file$Parameter2[
                      (data_file$`Outcome name` == mid_file$outcome[x]) &
                        (! is.na(data_file$Parameter2)) &
                        (! is.na(data_file$`Control (total number of participants)`))
                    ]/data_file$`Control (total number of participants)`[
                      (data_file$`Outcome name` == mid_file$outcome[x]) &
                        (! is.na(data_file$Parameter2)) &
                        (! is.na(data_file$`Control (total number of participants)`))
                    ]
                  )
                  risk_intervention <- risk_comparator*(1-mid_file$minimal_important_difference[x])
                  sample_size_each_outcome <- ceiling(pwr.2p.test(h = ES.h(p1 = risk_intervention, p2 = risk_comparator), 
                                                                  sig.level = 0.05, power = 0.9, 
                                                                  alternative ="two.sided")$n)*2
                } else {
                  sd_comparator <- median(
                    data_file$Parameter4[
                      (data_file$`Outcome name` == mid_file$outcome[x]) &
                        (! is.na(data_file$Parameter4))
                    ]
                  )
                  sample_size_each_outcome <- ceiling(pwr.t.test(d = (mid_file$minimal_important_difference[x]/sd_comparator), 
                                                                 sig.level = 0.05, power = 0.9,
                                                                 type = "two.sample",
                                                                 alternative ="two.sided")$n)*2
                }
                return(sample_size_each_outcome)
              }
            )
            mid_file$existing_sample_size <- sapply(
              1:nrow(mid_file),
              function(x) {
                if (mid_file$outcome_type[x] == "binary") {
                  existing_sample_size_each_outcome <- sum(data_file$`Intervention (total number of participants)`[
                    (data_file$`Outcome name` == mid_file$outcome[x]) &
                      (! is.na(data_file$Parameter1)) &
                      (! is.na(data_file$Parameter2)) &
                      (! is.na(data_file$`Intervention (total number of participants)`)) &
                      (! is.na(data_file$`Control (total number of participants)`))
                  ], data_file$`Control (total number of participants)`[
                    (data_file$`Outcome name` == mid_file$outcome[x]) &
                      (! is.na(data_file$Parameter1)) &
                      (! is.na(data_file$Parameter2)) &
                      (! is.na(data_file$`Intervention (total number of participants)`)) &
                      (! is.na(data_file$`Control (total number of participants)`))
                  ] 
                  )
                } else {
                  existing_sample_size_each_outcome <- sum(data_file$`Intervention (total number of participants)`[
                    (data_file$`Outcome name` == mid_file$outcome[x]) &
                      (! is.na(data_file$Parameter1)) &
                      (! is.na(data_file$Parameter3)) &
                      (! is.na(data_file$`Intervention (total number of participants)`)) &
                      (! is.na(data_file$`Control (total number of participants)`))
                  ], data_file$`Control (total number of participants)`[
                    (data_file$`Outcome name` == mid_file$outcome[x]) &
                      (! is.na(data_file$Parameter1)) &
                      (! is.na(data_file$Parameter3)) &
                      (! is.na(data_file$`Intervention (total number of participants)`)) &
                      (! is.na(data_file$`Control (total number of participants)`))
                  ] 
                  )
                }
                return(existing_sample_size_each_outcome)
              }
            )
            output <- list(
              results = mid_file,
              completion_status = "Successful"
            )
          } else {
            output <- list(
              message = 'One or more binary or continuous outcomes do not have minimal important difference. 
              Please ensure that the minimal important difference file contains the minimal important difference for all outcomes.',
              completion_status = "Unsuccessful"
            )  
          }
        } else {
          output <- list(
            message = 'The minimal important difference file uploaded does not have any data.',
            completion_status = "Unsuccessful"
          )
        }
      } else {
        output <- list(
          message = 'The minimal important difference file uploaded in not in correct format. 
    The column names should be exactly "outcome" and "minimal_important_difference".',
          completion_status = "Unsuccessful"
        )
      }  
    } else {
      output <- list(
        message = 'The data file uploaded does not have any data.',
        completion_status = "Unsuccessful"
      )
    }
  } else {
    output <- list(
      message = 'The data file uploaded in not in correct format. 
    The column names should be exactly as in the sample data file that you can download from the left panel.',
      completion_status = "Unsuccessful"
    )
  }
  return(output)
}
grade_large_very_large_effect <- function(lci, uci) {
  if((((lci<0.2) & (uci<0.2)) | ((lci > 5) & (uci > 5)))) {
    "very large effect"
  } else if((((lci<0.5) & (uci<0.5)) | ((lci > 2) & (uci > 2)))) {
    "large effect"
  } else {
    "neither large or very large effect"
  }
}
grade_large_very_large_effect_multiple <- function(file_location) {
  outcomes_estimates_file <- read.csv(file_location, header = TRUE, na.strings = c("", " ", "  "))
  if ((ncol(outcomes_estimates_file) == 3) & 
      (!FALSE %in% (colnames(outcomes_estimates_file) == c("outcome", "lower_confidence_intervals", "upper_confidence_intervals")))
  ) {
    outcomes_estimates_file <- na.omit(outcomes_estimates_file)
    if (nrow(outcomes_estimates_file) > 0) {
      outcomes_estimates_file$assessment <- sapply(
        1:nrow(outcomes_estimates_file), 
        function(x) {
          grade_large_very_large_effect(outcomes_estimates_file$lower_confidence_intervals[x], outcomes_estimates_file$upper_confidence_intervals[x])
        }
      )
      output <- list(
        results = outcomes_estimates_file,
        completion_status = "Successful"
      )
    } else {
      output <- list(
        message = 'The file uploaded does not have any complete data to perform the assessment.',
        completion_status = "Unsuccessful"
      )
    }
  } else {
    output <- list(
      message = 'The file uploaded in not in correct format. 
    The column names should be exactly "outcome", "lower_confidence_intervals" and "upper_confidence_intervals"',
      completion_status = "Unsuccessful"
    )
  }
  return(output)
}
comparator_group_calculations <- function(data_file_location) {
  data_file <- read.csv(data_file_location, header = TRUE, check.names = FALSE, na.strings = c("", " ", "  "))
  if ((ncol(data_file) == 5) & 
      (!FALSE %in% (colnames(data_file) == c("Outcome name", "Type of outcome", "Study", "Parameter1", "Parameter2")))
  ) {
    # Check if there is data
    # Time has only one parameter - Make this 0 to avoid exclusion
    data_file$Parameter2[tolower(data_file$`Type of outcome`) == "time"] <- 0 
    data_file <- na.omit(data_file)
    if (nrow(data_file) > 0) {
      results_file <- data_file[,1:2]
      results_file <- results_file[! duplicated(results_file),]
      results_file$`Type of outcome` <- tolower(results_file$`Type of outcome`)
      results_file$median <- sapply(
        1:nrow(results_file),
        function(x) {
          if (
            (results_file$`Type of outcome`[x] == "binary") |
            (results_file$`Type of outcome`[x] == "count")
          ) {
            results_each_outcome <- median(
              data_file$Parameter1[data_file$`Outcome name` == results_file$`Outcome name`[x]]/
                data_file$Parameter2[data_file$`Outcome name` == results_file$`Outcome name`[x]]
            )
          } else if (results_file$`Type of outcome`[x] == "continuous"){
            results_each_outcome <- median(
              data_file$Parameter1[data_file$`Outcome name` == results_file$`Outcome name`[x]]
            )
          } else {
            results_each_outcome <- median(
              data_file$Parameter1[data_file$`Outcome name` == results_file$`Outcome name`[x]]/100
            )
          }
          return(results_each_outcome)
        }
      )
      results_file$mean <- sapply(
        1:nrow(results_file),
        function(x) {
          if (
            (results_file$`Type of outcome`[x] == "binary") |
            (results_file$`Type of outcome`[x] == "count")
          ) {
            results_each_outcome <- 
              sum(data_file$Parameter1[data_file$`Outcome name` == results_file$`Outcome name`[x]])/
              sum(data_file$Parameter2[data_file$`Outcome name` == results_file$`Outcome name`[x]])
          } else if (results_file$`Type of outcome`[x] == "continuous") {
            # Calculate the sum product
            product <- (data_file$Parameter1[data_file$`Outcome name` == results_file$`Outcome name`[x]]) * 
              (data_file$Parameter2[data_file$`Outcome name` == results_file$`Outcome name`[x]])
            sum_product <- sum(product)
            results_each_outcome <- sum(product)/sum(data_file$Parameter2[data_file$`Outcome name` == results_file$`Outcome name`[x]])
          } else {
            results_each_outcome <- NA
          }
          return(results_each_outcome)
        }
      )
      output <- list(
        results = results_file,
        completion_status = "Successful"
      )
    } else {
      output <- list(
        message = 'The data file uploaded does not have any data to calculate the comparator values.',
        completion_status = "Unsuccessful"
      )
    }
  } else {
    output <- list(
      message = 'The data file uploaded in not in correct format. 
    The column names should be exactly "Outcome name", "Type of outcome", "Study", "Parameter1", and "Parameter2".',
      completion_status = "Unsuccessful"
    )
  }
  return(output)
}
grade_ratio_to_differences <- function(effect_measure, point_estimate, lci, uci, comparator_risk_rate) {
  # Convert odds ratio to risk ratio
  if (effect_measure == "odds ratio") {
    risk_ratios <- convert_odds_ratio_to_risk_ratio(point_estimate, lci, uci, comparator_risk_rate)
    point_estimate_final <- risk_ratios[[1]]
    lci_final <- risk_ratios[[2]]
    uci_final <- risk_ratios[[3]]
  } else {
    point_estimate_final <- point_estimate
    lci_final <- lci
    uci_final <- uci
  }
  baseline <- round(comparator_risk_rate * 1000)
  intervention_point_estimate <- round(point_estimate_final * comparator_risk_rate * 1000)
  if ((effect_measure != "rate ratio") & (intervention_point_estimate > 1000)) {
    intervention_point_estimate <- 1000  
  }
  intervention_lci <- round(lci_final * comparator_risk_rate * 1000)
  if ((effect_measure != "rate ratio") & (intervention_lci > 1000)) {
    intervention_lci <- 1000  
  }
  intervention_uci <- round(uci_final * comparator_risk_rate * 1000)
  if ((effect_measure != "rate ratio") & (intervention_uci > 1000)) {
    intervention_uci <- 1000  
  }
  output <- list(
    comparator_header = paste0(ifelse(((effect_measure == "odds ratio") | (effect_measure == "risk ratio")), "Risk", 
                                      ifelse((effect_measure == "rate ratio"), "Rate","Hazard")),
                               " in comparator group: "),
    comparator = paste0 (baseline, " per 1000 participants"),
    intervention_header = paste0(ifelse(((effect_measure == "odds ratio") | (effect_measure == "risk ratio")), "Risk", 
                                        ifelse((effect_measure == "rate ratio"), "Rate","Hazard")),
                                 " in intervention group: "),
    intervention_1 = paste0(intervention_point_estimate, " per 1000 participants"),
    intervention_2 = paste0("(", intervention_lci, " to ", intervention_uci, ")")
  )
  return(output)
}
grade_ratio_to_differences_multiple <- function(data_file_location) {
  data_file <- read.csv(data_file_location, header = TRUE, check.names = FALSE, na.strings = c("", " ", "  "))
  if ((ncol(data_file) == 6) & 
      (!FALSE %in% (colnames(data_file) == c("outcome_name", "effect_measure", "point_estimate", "lower_confidence_interval", "upper_confidence_interval", "comparator")))
  ) {
    # Check if there is data
    data_file <- na.omit(data_file)
    if (nrow(data_file) > 0) {
      results <- lapply(
        1:nrow(data_file),
        function(x) {
          grade_ratio_to_differences(data_file$effect_measure[x], data_file$point_estimate[x],
                                     data_file$lower_confidence_interval[x], data_file$upper_confidence_interval[x],
                                     data_file$comparator[x])
        }
      )
      results_file <- do.call(rbind.data.frame, results)
      results_file <- cbind.data.frame(
        outcome_name = data_file$outcome_name,
        comparator = results_file$comparator,
        intervention = paste0(results_file$intervention_1,"\n",results_file$intervention_2)
      )
      output <- list(
        results = results_file,
        completion_status = "Successful"
      )
    } else {
      output <- list(
        message = 'The data file uploaded does not have any data to calculate the differences.',
        completion_status = "Unsuccessful"
      )
    }
  } else {
    output <- list(
      message = 'The data file uploaded in not in correct format. 
    The column names should be exactly "outcome_name", "effect_measure", "point_estimate", "lower_confidence_interval", "upper_confidence_interval", and "comparator".',
      completion_status = "Unsuccessful"
    )
  }
  return(output)
}
iceman_effect_modification_consistency <- function(file_location, StorageFolder) {
  effect_modification_file <- read.csv(file_location, header = TRUE, na.strings = c("", " ", "  "))
  if ((ncol(effect_modification_file) == 7) & 
      (!FALSE %in% (colnames(effect_modification_file) == c("outcome_name", "study_name", "subgroup_name", "effect_measure", "point_estimate", "lower_CI", "upper_CI")))
  ) {
    effect_modification_file <- na.omit(effect_modification_file)
    if (nrow(effect_modification_file) > 0) {
      # Create an effect measure look up list
      effect_measure_list <- cbind.data.frame(
        effect_measure = c("odds ratio", "risk ratio", "rate ratio", "hazard ratio", "mean difference", "standardised mean difference"),
        effect_measure_abbreviation = c("OR", "RR", "IRR", "HR", "MD", "SMD")
      )
      # Create an outcome list
      outcome_list <- unique(effect_modification_file$outcome_name)
      results <- lapply(1:length(outcome_list), function(x) {
        each_outcome <- effect_modification_file[effect_modification_file$outcome_name == outcome_list[x],]
        effect_measure <- effect_measure_list$effect_measure_abbreviation[
          effect_measure_list$effect_measure == tolower(each_outcome$effect_measure[1]) 
        ]
        if (length(effect_measure) > 0) {
          log_transformation_required <- str_detect(tolower(each_outcome$effect_measure[1]), "ratio")
          # Create a subgroup list
          subgroup_list <- unique(each_outcome$subgroup_name)
          # Check if there are exactly two subgroups
          if (length(subgroup_list) == 2) {
            # Create a study list
            study_list <- unique(each_outcome$study_name)
            # Check if there are at least two studies
            if (length(study_list) >= 2) {
              # Check that there are exactly two studies for each subgroup
              each_outcome$study_subgroup <- paste0(each_outcome$study_name, "%_%", each_outcome$subgroup_name)
              if (length(unique(each_outcome$study_subgroup)) == nrow(each_outcome)) {
                each_outcome <- each_outcome[order(each_outcome$study_subgroup)]
                if (log_transformation_required == TRUE) {
                  each_outcome$transformed_effect_estimate <- log(each_outcome$point_estimate)
                  each_outcome$se_transformed_effect_estimate <- (log(each_outcome$upper_CI)-log(each_outcome$lower_CI))/abs(2*qnorm(((1-0.95)/2)))
                } else {
                  each_outcome$transformed_effect_estimate <- each_outcome$point_estimate
                  each_outcome$se_transformed_effect_estimate <- (each_outcome$upper_CI-each_outcome$lower_CI)/abs(2*qnorm(((1-0.95)/2)))
                }
                difference_each_outcome <- lapply(1: length(study_list),function(z) {
                  difference_each_study <- 
                    each_outcome$transformed_effect_estimate[
                      each_outcome$study_subgroup == paste0(study_list[z], "%_%", subgroup_list[1])
                    ] - each_outcome$transformed_effect_estimate[
                      each_outcome$study_subgroup == paste0(study_list[z], "%_%", subgroup_list[2])
                    ]
                  se_difference_each_study <- (
                    each_outcome$se_transformed_effect_estimate[
                      each_outcome$study_subgroup == paste0(study_list[z], "%_%", subgroup_list[1])
                    ]^2 + each_outcome$se_transformed_effect_estimate[
                      each_outcome$study_subgroup == paste0(study_list[z], "%_%", subgroup_list[2])
                    ]^2
                  )^0.5
                  results_each_study <- cbind(
                    study = study_list[z],
                    difference = difference_each_study, 
                    se_difference = se_difference_each_study)
                }) 
                difference_each_outcome <- do.call(rbind.data.frame, difference_each_outcome)   
                # Perform meta-analysis
                meta_analysis_each_outcome <- metagen(
                  TE = as.numeric(difference_each_outcome$difference),
                  seTE = as.numeric(difference_each_outcome$se_difference),
                  studlab = difference_each_outcome$study,
                  sm = effect_measure,
                  common = TRUE,
                  random = FALSE,
                  text.common = "Fixed-effect model"
                )
                png(paste0(StorageFolder,'/',outcome_list[x],".png"), width=960, 
                    height=(20 * (10 + nrow(each_outcome))), units="px")
                plot.new()
                forest(meta_analysis_each_outcome, digits = 2, digits.se = 2)
                title(main=paste0(outcome_list[x],": ", ifelse(log_transformation_required == TRUE, "ratio of ", "difference in "), 
                                  each_outcome$effect_measure[1]
                ))
                recordPlot()
                dev.off()
                difference_each_outcome$ma_estimate <- meta_analysis_each_outcome$TE.common
                difference_each_outcome$ma_estimate_lci <- meta_analysis_each_outcome$lower.common
                difference_each_outcome$ma_estimate_uci <- meta_analysis_each_outcome$upper.common
                difference_each_outcome$ma_i2 <- meta_analysis_each_outcome$I2
                difference_each_outcome$ma_heterogeneity_p_value <- meta_analysis_each_outcome$pval.Q
                # Now make the assessment
                output_each_outcome <- paste0("I2 = ", round(meta_analysis_each_outcome$I2 *100), "%", "; ",
                                              "Chi-square test for heterogeneity = ", ifelse(difference_each_outcome$ma_heterogeneity_p_value[1] < 0.001, "p < 0.001", round(difference_each_outcome$ma_heterogeneity_p_value[1], 4)), "; ",
                                              if ((difference_each_outcome$ma_i2[1] < 0.3) & (difference_each_outcome$ma_heterogeneity_p_value[1] > 0.10)) {
                                                "consistent with no evidence of heterogeneity."
                                              } else if (length(unique((as.numeric(difference_each_outcome$difference) < 0))) == 1) {
                                                "consistent with heterogeneity in magnitude."
                                              } else {
                                                "consistent with heterogeneity in direction."
                                              }
                )
              } else {
                output_each_outcome <- "Each study must have exactly two rows (one for each subgroup) to perform this function."
              }
            } else {
              output_each_outcome <- "There must be at two studies to perform this function."
            }
          } else {
            output_each_outcome <- "This function deals only with two subgroups at a time."
          }  
        } else {
          output_each_outcome <- 'The effect measure is unrecognised. The effect measure should be one of "odds ratio", "risk ratio", "rate ratio", "hazard ratio", "mean difference", or "standardised mean difference".'
        }
      })
      results <- do.call(rbind.data.frame, results)
      results <- cbind.data.frame(outcome_name = outcome_list, results)
      colnames(results)[2] <- "interpretation"
      write.csv(results, paste0(StorageFolder, "/Consistency_in_effect_modification.csv"), row.names = FALSE, na = "")
      zip::zipr(zipfile = paste0(StorageFolder, "/Consistency_in_effect_modification.zip"), 
                files = c(paste0(StorageFolder,'/',outcome_list,".png")[file.exists(paste0(StorageFolder,'/',outcome_list,".png"))], paste0(StorageFolder, "/Consistency_in_effect_modification.csv"))
      )
      file.remove(
        c(paste0(StorageFolder,'/',outcome_list,".png")[file.exists(paste0(StorageFolder,'/',outcome_list,".png"))], paste0(StorageFolder, "/Consistency_in_effect_modification.csv"))
      )
      output <- list(
        message = paste0(results$outcome_name, ": ", results$interpretation),
        completion_status = "Successful"
      )
    } else {
      output <- list(
        message = 'The file uploaded does not have any data.',
        completion_status = "Unsuccessful"
      )
    }
  } else {
    output <- list(
      message = 'The file uploaded in not in correct format. 
    The column names should be exactly "outcome_name", "study_name", "subgroup_name", "effect_measure", "point_estimate", "lower_CI", and "upper_CI".',
      completion_status = "Unsuccessful"
    )
  }
  return(output)
}
rob_me_classifications_from_signalling_questions <- function(rob_file_path) {
  rob_file <- read.csv(rob_file_path, header = FALSE, na.strings = c("", " ", "  "))
  if (ncol(rob_file == 9) & 
      ! FALSE %in% (rob_file[1,] == c(
        "outcome", 
        "4.1. Of the studies identified, was there any for which no result was available for inclusion in the meta-analysis, likely because of the P value, magnitude or direction of the result generated (refer to Step 2)?", 
        "4.2. If Y to 4.1: Is it likely that there would be a notable change to the summary effect estimate if the omitted results had been included?", 
        "4.3. Of the studies identified, was there any for which it was unclear whether an eligible result was generated (refer to Step 2)?", 
        "4.4. If Y to 4.3: Is it likely that there would be a notable change to the summary effect estimate if the potentially omitted results had been included?", 
        "4.5 Do circumstances (identified in Step 3) indicate potential for some eligible studies not being identified because of the P value, magnitude or direction of the results generated?", 
        "4.6. If Y to 4.5: Is it likely that studies not identified had results that were eligible for inclusion in the meta-analysis?", 
        "4.7. If Y to 4.1, 4.3 or 4.5: Does the pattern of observed study results suggest that the meta-analysis is likely to be missing results that were systematically different (in terms of P value, magnitude or direction) from those observed?", 
        "4.8. If Y/PY/NI to 4.2, 4.4, 4.6 or 4.7: Did sensitivity analyses suggest that the summary effect estimate was biased due to missing results?"
      )
      )) {
    # Preparations ####
    colnames(rob_file) <- c("outcome","4.1","4.2","4.3", "4.4", "4.5", "4.6", "4.7", "4.8")
    # Remove question row
    rob_file <- rob_file[2:nrow(rob_file),]
    # Replace na with ""
    rob_file[is.na(rob_file)] <- ""
    # Now conversions to full form 
    rob_answer_conversions <- data.frame(
      letters_only = c("Y","PY","N","PN","NI","NA"),
      words_only = c("Yes", "Probably Yes", "No", "Probably No", "No Information", "Not Applicable")
    )
    rob_answer_conversions$letter_words <- paste0(rob_answer_conversions$letters_only, " = ", rob_answer_conversions$words_only)
    rob_answer_conversions$letters_only <- tolower(rob_answer_conversions$letters_only)
    rob_answer_conversions$words_only <- tolower(rob_answer_conversions$words_only)
    rob_data <- lapply(2:ncol(rob_file), function(y) {rob_file[,y] <- tolower(rob_file[,y])})
    rob_data <- do.call(cbind.data.frame, rob_data)
    rob_data <- cbind.data.frame(rob_file[,1], rob_data)
    colnames(rob_data) <- colnames(rob_file)
    for (i in 1:6) {
      rob_data[rob_data == rob_answer_conversions$letters_only[i]] <- rob_answer_conversions$letter_words[i]
      rob_data[rob_data == rob_answer_conversions$words_only[i]] <- rob_answer_conversions$letter_words[i]
    }
    # Classifications ####
    rob_data$classification <- NA
    rob_data$classification[
      (
        (rob_data$`4.1` == "N = No") &
          (rob_data$`4.3` == "N = No") &
          (
            (rob_data$`4.5` == "N = No") |
              (
                ((rob_data$`4.6` == "N = No") |
                   (rob_data$`4.6` == "PN = Probably No")) & 
                  ((rob_data$`4.7` == "N = No") |
                     (rob_data$`4.7` == "PN = Probably No"))
              )
          ) 
      )
    ] <- "Low risk"
    rob_data$classification[
      (
        (is.na(rob_data$classification)) &
          (
            (rob_data$`4.1` == "Y = Yes") |
              (rob_data$`4.3` == "Y = Yes")
          ) &
          ((rob_data$`4.2` == "N = No") |
             (rob_data$`4.2` == "PN = Probably No") |
             (rob_data$`4.2` == "NA = Not Applicable")) &
          ((rob_data$`4.4` == "N = No") |
             (rob_data$`4.4` == "PN = Probably No") |
             (rob_data$`4.4` == "NA = Not Applicable")) &
          (
            (rob_data$`4.5` == "N = No") |
              ((rob_data$`4.6` == "N = No") |
                 (rob_data$`4.6` == "PN = Probably No"))
          ) & 
          ((rob_data$`4.7` == "N = No") |
             (rob_data$`4.7` == "PN = Probably No"))
      ) 
    ] <- "Low risk"
    rob_data$classification[
      ( 
        (is.na(rob_data$classification)) &
          (rob_data$`4.1` == "N = No") &
          (rob_data$`4.3` == "N = No") &
          (rob_data$`4.5` == "Y = Yes") &
          (  
            (
              ((rob_data$`4.6` == "N = No") |
                 (rob_data$`4.6` == "PN = Probably No")) &
                ((rob_data$`4.7` == "Y = Yes") |
                   (rob_data$`4.7` == "PY = Probably Yes")) 
            ) |
              (
                ((rob_data$`4.6` == "Y = Yes") |
                   (rob_data$`4.6` == "PY = Probably Yes")) &
                  ((rob_data$`4.7` == "N = No") |
                     (rob_data$`4.7` == "PN = Probably No"))  
              )
          )
        &
          ((rob_data$`4.8` == "N = No") |
             (rob_data$`4.8` == "PN = Probably No"))
      ) 
    ] <- "Some concerns"
    rob_data$classification[
      ( 
        (is.na(rob_data$classification)) &
          ((rob_data$`4.2` == "N = No") |
             (rob_data$`4.2` == "PN = Probably No") |
             (rob_data$`4.2` == "NA = Not Applicable")) &
          ((rob_data$`4.4` == "N = No") |
             (rob_data$`4.4` == "PN = Probably No") |
             (rob_data$`4.4` == "NA = Not Applicable")) &
          (
            (
              (rob_data$`4.5` == "N = No") &
                ((rob_data$`4.7` == "Y = Yes") |
                   (rob_data$`4.7` == "PY = Probably Yes")) &
                ((rob_data$`4.8` == "N = No") |
                   (rob_data$`4.8` == "PN = Probably No"))
            ) |
              (
                (rob_data$`4.5` == "Y = Yes") &
                  ((rob_data$`4.6` == "N = No") |
                     (rob_data$`4.6` == "PN = Probably No")) &
                  ((rob_data$`4.7` == "Y = Yes") |
                     (rob_data$`4.7` == "PY = Probably Yes")) &
                  ((rob_data$`4.8` == "N = No") |
                     (rob_data$`4.8` == "PN = Probably No"))
              ) |
              (
                (rob_data$`4.5` == "Y = Yes") &
                  ((rob_data$`4.6` == "Y = Yes") |
                     (rob_data$`4.6` == "PY = Probably Yes")) &
                  ((rob_data$`4.7` == "N = No") |
                     (rob_data$`4.7` == "PN = Probably No")) &
                  ((rob_data$`4.8` == "N = No") |
                     (rob_data$`4.8` == "PN = Probably No"))
              )
          )
      ) 
    ] <- "Some concerns"
    rob_data$classification[
      ( 
        (is.na(rob_data$classification)) &
          (
            (rob_data$`4.2` == "NI = No Information") |
              ((rob_data$`4.4` == "Y = Yes") |
                 (rob_data$`4.4` == "PY = Probably Yes") |
                 (rob_data$`4.4` == "NI = No Information"))
          ) &
          (
            (
              (rob_data$`4.5` == "N = No") &
                ((rob_data$`4.7` == "N = No") |
                   (rob_data$`4.7` == "PN = Probably No")) &
                ((rob_data$`4.8` == "N = No") |
                   (rob_data$`4.8` == "PN = Probably No"))
            ) |
              (
                (rob_data$`4.5` == "Y = Yes") &
                  ((rob_data$`4.6` == "N = No") |
                     (rob_data$`4.6` == "PN = Probably No")) &
                  ((rob_data$`4.7` == "N = No") |
                     (rob_data$`4.7` == "PN = Probably No")) &
                  ((rob_data$`4.8` == "N = No") |
                     (rob_data$`4.8` == "PN = Probably No"))
              ) |
              (
                (rob_data$`4.5` == "Y = Yes") &
                  ((rob_data$`4.6` == "Y = Yes") |
                     (rob_data$`4.6` == "PY = Probably Yes")) &
                  ((rob_data$`4.7` == "N = No") |
                     (rob_data$`4.7` == "PN = Probably No")) &
                  ((rob_data$`4.8` == "N = No") |
                     (rob_data$`4.8` == "PN = Probably No"))
              )
          )
      ) 
    ] <- "Some concerns"
    rob_data$classification[
      (is.na(rob_data$classification))
    ] <- "High risk"
    # Comments and output ####
    rob_data$comments <-
      as.character(sapply(1:nrow(rob_data), function(y) {
        if (! is.na(match("",rob_data[y,]))) {
          "One or more signalling questions had incomplete or invalid data. 
              Please check and reupload revised file to obtain correct classifications"
        } else {
          "All signalling questions were complete."
        }
      }))
    output <- list(rob_data,"Successful")  
  } else {
    output <- list(
      "The column names do not match that in the instructions. Please upload a file prepared according to the instructions.",
      "Unsucessful"
    )
  }
  return(output)
}
se_missing_trial_from_ln_odds_ratio_se <- function(missing_trial_n_intervention, missing_trial_n_comparator, ln_odds_ratio, se_ln_odds_ratio, n_intervention, n_comparator) {
  # If missing_trial_n_comparator or n_comparator is missing, the total number of participants is provided
  if(missing(missing_trial_n_comparator)) {
    missing_trial_n_intervention <- missing_trial_n_intervention/2
    missing_trial_n_comparator <- missing_trial_n_intervention/2
  }
  if (missing(n_comparator)) {
    n_intervention <- n_intervention/2
    n_comparator <- n_intervention/2
  }
  # Attempted various algorithms: using multiroot, performing iterations manually # Not accurate
  # Simplest is to do this manually: works reasonably well
  absolute_risks <- data.frame(
    risk_comparator = 1:(10^ceiling(log10(n_comparator)+2)-1)/10^ceiling(log10(n_comparator)+2)
  )
  absolute_risks$events_comparator <- absolute_risks$risk_comparator*n_comparator
  absolute_risks$odds_comparator <- absolute_risks$risk_comparator/(1-absolute_risks$risk_comparator)
  absolute_risks$odds_intervention <- absolute_risks$odds_comparator * exp(ln_odds_ratio)
  absolute_risks$risk_intervention <- absolute_risks$odds_intervention/(1 + absolute_risks$odds_intervention)
  absolute_risks$events_intervention <- absolute_risks$risk_intervention*n_intervention
  absolute_risks <- absolute_risks[absolute_risks$events_intervention >=1,]
  absolute_risks$se_ln_odds_ratio <- suppressWarnings((
    1/absolute_risks$events_intervention + 1/(n_intervention - absolute_risks$events_intervention) +
      1/absolute_risks$events_comparator + 1/(n_comparator - absolute_risks$events_comparator)
  )^0.5)
  absolute_risks <- absolute_risks[! is.nan(absolute_risks$se_ln_odds_ratio),]
  # not clear why but when the n_intervention and n_comparator are equal, the match provides 1-risk in opposite group. With differing numbers correct matches are produced
  if (n_intervention == n_comparator) {
    risk_comparator <- (1 - absolute_risks$risk_intervention[
      which(abs(absolute_risks$se_ln_odds_ratio - se_ln_odds_ratio) == 
              min(abs(absolute_risks$se_ln_odds_ratio - se_ln_odds_ratio)))[1]
    ]
    )
    risk_intervention <- (1 - absolute_risks$risk_comparator[
      which(abs(absolute_risks$se_ln_odds_ratio - se_ln_odds_ratio) == 
              min(abs(absolute_risks$se_ln_odds_ratio - se_ln_odds_ratio)))[1]
    ]
    )
    events_comparator <- n_intervention - absolute_risks$events_intervention[
      which(abs(absolute_risks$se_ln_odds_ratio - se_ln_odds_ratio) == 
              min(abs(absolute_risks$se_ln_odds_ratio - se_ln_odds_ratio)))[1]
    ]
    events_intervention <- n_comparator - absolute_risks$events_comparator[
      which(abs(absolute_risks$se_ln_odds_ratio - se_ln_odds_ratio) == 
              min(abs(absolute_risks$se_ln_odds_ratio - se_ln_odds_ratio)))[1]
    ]
  } else {
    risk_comparator <- absolute_risks$risk_comparator[
      which(abs(absolute_risks$se_ln_odds_ratio - se_ln_odds_ratio) == 
              min(abs(absolute_risks$se_ln_odds_ratio - se_ln_odds_ratio)))[1]
    ]
    risk_intervention <- absolute_risks$risk_intervention[
      which(abs(absolute_risks$se_ln_odds_ratio - se_ln_odds_ratio) == 
              min(abs(absolute_risks$se_ln_odds_ratio - se_ln_odds_ratio)))[1]
    ]
    events_comparator <- absolute_risks$events_comparator[
      which(abs(absolute_risks$se_ln_odds_ratio - se_ln_odds_ratio) == 
              min(abs(absolute_risks$se_ln_odds_ratio - se_ln_odds_ratio)))[1]
    ]
    events_intervention <- absolute_risks$events_intervention[
      which(abs(absolute_risks$se_ln_odds_ratio - se_ln_odds_ratio) == 
              min(abs(absolute_risks$se_ln_odds_ratio - se_ln_odds_ratio)))[1]
    ]
    
  }
  # Since we are looking to swap the odds between intervention and comparator
  missing_trial_events_intervention = risk_comparator*missing_trial_n_intervention
  missing_trial_events_comparator = risk_intervention*missing_trial_n_comparator
  missing_trial_se = (1/missing_trial_events_intervention + 1/(missing_trial_n_intervention - missing_trial_events_intervention) +  1/missing_trial_events_comparator + 1/(missing_trial_n_comparator - missing_trial_events_comparator))^0.5
  return(missing_trial_se)
}
se_missing_trial_from_ln_risk_ratio_se <- function(missing_trial_n_intervention, missing_trial_n_comparator, ln_risk_ratio, se_ln_risk_ratio, n_intervention, n_comparator) {
  # If missing_trial_n_comparator or n_comparator is missing, the total number of participants is provided
  if(missing(missing_trial_n_comparator)) {
    missing_trial_n_intervention <- missing_trial_n_intervention/2
    missing_trial_n_comparator <- missing_trial_n_intervention/2
  }
  if (missing(n_comparator)) {
    n_intervention <- n_intervention/2
    n_comparator <- n_intervention/2
  }
  # Now two equations
  # Modified from: https://training.cochrane.org/handbook/current/statistical-methods-revman5
  # ln_risk_ratio = log((events_intervention/n_intervention)/(events_comparator/n_comparator)) # Eqn 1
  # se_ln_risk_ratio = ((1/events_intervention) + (1/events_comparator) - (1/n_intervention) - (1/n_comparator))^0.5 # Eqn 2
  # Rearranging # Eqn 1
  # ln_risk_ratio = (log(events_intervention) - log(n_intervention)) - (log(events_comparator) - log(n_comparator))
  # ln_risk_ratio = log(events_intervention) - log(n_intervention) - log(events_comparator) + log(n_comparator) # Eqn 3
  # Let
  # x = 1/events_intervention
  # y = 1/events_comparator
  # Substituting in Eqn 3
  # ln_risk_ratio = log(1/x) - log(n_intervention) - log(1/y) + log(n_comparator) # Eqn 4
  # ln_risk_ratio = -log(x) - log(n_intervention) - (-log(y)) + log(n_comparator)
  # ln_risk_ratio = -log(x) - log(n_intervention) + log(y) + log(n_comparator) # Eqn 5
  # Rearranging # Eqn 5 to get log(y)
  # log(y) = ln_risk_ratio + log(x) + log(n_intervention) - log(n_comparator) # Eqn 6
  # Exponential on both sides
  # y = exp(ln_risk_ratio + log(x) + log(n_intervention) - log(n_comparator)) # Eqn 7
  # Substituting x and y in Eqn 2
  # se_ln_risk_ratio = ((x) + (y) - (1/n_intervention) - (1/n_comparator))^0.5 # Eqn 8
  # Taking square on both sides and then rearranging
  # se_ln_risk_ratio^2 = x + y - (1/n_intervention) - (1/n_comparator)
  # y = se_ln_risk_ratio^2 + (1/n_intervention) + (1/n_comparator) - x # Eqn 9
  # Replacing y in Eqn 7 with value in Eqn 9
  # se_ln_risk_ratio^2 + (1/n_intervention) + (1/n_comparator) - x = exp(ln_risk_ratio + log(x) + log(n_intervention) - log(n_comparator))
  # Moving all the terms to left side
  # se_ln_risk_ratio^2  + (1/n_intervention) + (1/n_comparator) - x - exp(ln_risk_ratio + log(x) + log(n_intervention) - log(n_comparator)) = 0
  # Solve for x using uniroot, calculate y using Eqn 9, and take their reciprocal to get the events_intervention
  f <- function(ln_risk_ratio, se_ln_risk_ratio, n_intervention, n_comparator, x) {
    se_ln_risk_ratio^2  + (1/n_intervention) + (1/n_comparator) - x - exp(ln_risk_ratio + log(x) + log(n_intervention) - log(n_comparator))
  }
  events_intervention_reciprocal <- uniroot(f, c(0, 10^80), tol = 0.0001, 
                                            ln_risk_ratio = ln_risk_ratio, 
                                            se_ln_risk_ratio = se_ln_risk_ratio,
                                            n_intervention = n_intervention,
                                            n_comparator = n_comparator
  )$root
  events_comparator_reciprocal <-   se_ln_risk_ratio^2  + (1/n_intervention) + (1/n_comparator) - events_intervention_reciprocal
  events_intervention <- 1/events_intervention_reciprocal
  events_comparator <- 1/events_comparator_reciprocal
  risk_intervention = events_intervention/n_intervention
  risk_comparator = events_comparator/n_comparator
  # Since we are looking to swap the risks between intervention and comparator
  missing_trial_events_intervention = risk_comparator*missing_trial_n_intervention
  missing_trial_events_comparator = risk_intervention*missing_trial_n_comparator
  missing_trial_se = (1/missing_trial_events_intervention + 1/missing_trial_events_comparator - 1/missing_trial_n_intervention - 1/missing_trial_n_comparator)^0.5
  return(missing_trial_se)
}
se_missing_trial_from_risk_difference_se <- function(missing_trial_n_intervention, missing_trial_n_comparator, risk_difference, se_risk_difference, n_intervention, n_comparator) {
  # If missing_trial_n_comparator or n_comparator is missing, the total number of participants is provided
  if(missing(missing_trial_n_comparator)) {
    missing_trial_n_intervention <- missing_trial_n_intervention/2
    missing_trial_n_comparator <- missing_trial_n_intervention/2
  }
  if (missing(n_comparator)) {
    n_intervention <- n_intervention/2
    n_comparator <- n_intervention/2
  }
  # Modified from: https://training.cochrane.org/handbook/current/statistical-methods-revman5
  # risk_difference = (events_intervention/n_intervention) - (events_comparator/n_comparator) # Eqn 1
  # se_risk_difference = (((events_intervention * (n_intervention - events_intervention))/n_intervention^3) + 
  # ((events_comparator * (n_comparator - events_comparator))/n_comparator^3))^0.5 # Eqn 2
  # Attempted various things - simplest and the one that works reasonably well is to do this manually
  absolute_risks <- data.frame(
    risk_comparator = 0:10^ceiling(log10(n_comparator)+2)/10^ceiling(log10(n_comparator)+2)
  )
  absolute_risks$events_comparator <- absolute_risks$risk_comparator*n_comparator
  absolute_risks$risk_intervention <- absolute_risks$risk_comparator + risk_difference
  absolute_risks$events_intervention <- absolute_risks$risk_intervention*n_intervention
  absolute_risks <- absolute_risks[absolute_risks$events_intervention >=0,]
  absolute_risks$se_risk_difference <- suppressWarnings((
    ((absolute_risks$events_intervention * (n_intervention - absolute_risks$events_intervention))/n_intervention^3) + 
      ((absolute_risks$events_comparator * (n_comparator - absolute_risks$events_comparator))/n_comparator^3)
  )^0.5)
  absolute_risks <- absolute_risks[! is.nan(absolute_risks$se_risk_difference),]
  # Not clear why but the risk_comparator is 1-risk_intervention and risk_intervention is 1-risk_comparator
  risk_comparator <- 1 - absolute_risks$risk_intervention[
    which(abs(absolute_risks$se_risk_difference - se_risk_difference) == 
            min(abs(absolute_risks$se_risk_difference - se_risk_difference)))[1]
  ]
  risk_intervention <- 1 - absolute_risks$risk_comparator[
    which(abs(absolute_risks$se_risk_difference - se_risk_difference) == 
            min(abs(absolute_risks$se_risk_difference - se_risk_difference)))[1]
  ]
  # Since we are looking to swap the risk between intervention and comparator
  missing_trial_events_intervention = risk_comparator*missing_trial_n_intervention
  missing_trial_events_comparator = risk_intervention*missing_trial_n_comparator
  missing_trial_se <- 
    (
      ((missing_trial_events_intervention * (missing_trial_n_intervention - missing_trial_events_intervention))/missing_trial_n_intervention^3) + 
        ((missing_trial_events_comparator * (missing_trial_n_comparator - missing_trial_events_comparator))/missing_trial_n_comparator^3)
    )^0.5
  return(missing_trial_se)
}
se_missing_trial_from_mean_difference_se <- function(missing_trial_n_intervention, missing_trial_n_comparator, mean_difference, se_mean_difference, n_intervention, n_comparator) {
  # If missing_trial_n_comparator or n_comparator is missing, the total number of participants is provided
  if(missing(missing_trial_n_comparator)) {
    missing_trial_n_intervention <- missing_trial_n_intervention/2
    missing_trial_n_comparator <- missing_trial_n_intervention/2
  }
  if (missing(n_comparator)) {
    n_intervention <- n_intervention/2
    n_comparator <- n_intervention/2
  }
  # Modified from: https://training.cochrane.org/handbook/current/statistical-methods-revman5
  # se_mean_difference = ((sd_intervention^2/n_intervention) + (sd_comparator^2/n_comparator))^0.5 # Eqn 1
  # Squaring both sides and using a common sd for intervention and comparator
  # se_mean_difference^2 = ((sd_common^2/n_intervention) + (sd_common^2/n_comparator))
  # se_mean_difference^2 = sd_common^2 * (1/n_intervention + 1/n_comparator)
  # Rearranging
  # sd_common^2 = se_mean_difference^2/(1/n_intervention + 1/n_comparator)
  # Taking square root
  # sd_common = se_mean_difference/((1/n_intervention + 1/n_comparator))^0.5
  sd_common <- se_mean_difference/((1/n_intervention + 1/n_comparator))^0.5
  missing_trial_se <- (sd_common^2/missing_trial_n_intervention + sd_common^2/missing_trial_n_comparator)^0.5 
  return(missing_trial_se)
}
se_missing_trial_from_SMD_se <- function(missing_trial_n_intervention, missing_trial_n_comparator, SMD, se_SMD, n_intervention, n_comparator) {
  # If missing_trial_n_comparator or n_comparator is missing, the total number of participants is provided
  if(missing(missing_trial_n_comparator)) {
    missing_trial_n_intervention <- missing_trial_n_intervention/2
    missing_trial_n_comparator <- missing_trial_n_intervention/2
  }
  if (missing(n_comparator)) {
    n_intervention <- n_intervention/2
    n_comparator <- n_intervention/2
  }
  # Modified from: https://training.cochrane.org/handbook/current/statistical-methods-revman5
  # se_SMD = ((n_intervention + n_comparator)/(n_intervention * n_comparator) + SMD^2/(2 * (n_intervention + n_comparator - 3.94)))^0.5
  # Formula can be directly applied for the new study without any calculations involving the se_SMD
  # Since the SMD is squared, there is no need to change the sign
  missing_trial_se <- ((missing_trial_n_intervention + missing_trial_n_comparator)/(missing_trial_n_intervention * missing_trial_n_comparator) + SMD^2/(2 * (missing_trial_n_intervention + missing_trial_n_comparator - 3.94)))^0.5
  return(missing_trial_se)
}
se_missing_trial_from_ln_rate_ratio_se <- function(missing_trial_n_intervention, missing_trial_n_comparator, ln_rate_ratio, se_ln_rate_ratio, n_intervention, n_comparator) {
  # If missing_trial_n_comparator or n_comparator is missing, the total number of participants is provided
  if(missing(missing_trial_n_comparator)) {
    missing_trial_n_intervention <- missing_trial_n_intervention/2
    missing_trial_n_comparator <- missing_trial_n_intervention/2
  }
  if (missing(n_comparator)) {
    n_intervention <- n_intervention/2
    n_comparator <- n_intervention/2
  }
  # Now two equations
  # Modified from: 
  # Higgins JPT, Li T, Deeks JJ (editors). Chapter 6: Choosing effect measures and computing estimates of effect. In: Higgins JPT, Thomas J, Chandler J, Cumpston M, Li T, Page MJ, Welch VA (editors). Cochrane Handbook for Systematic Reviews of Interventions version 6.4 (updated August 2023). Cochrane, 2023. Available from www.training.cochrane.org/handbook
  # ln_rate_ratio = log((events_intervention/n_intervention)/(events_comparator/n_comparator)) # Eqn 1
  # se_ln_rate_ratio = ((1/events_intervention) + (1/events_comparator))^0.5 # Eqn 2
  # Rearranging # Eqn 1
  # ln_rate_ratio = (log(events_intervention) - log(n_intervention)) - (log(events_comparator) - log(n_comparator))
  # ln_rate_ratio = log(events_intervention) - log(n_intervention) - log(events_comparator) + log(n_comparator) # Eqn 3
  # Let
  # x = 1/events_intervention
  # y = 1/events_comparator
  # Substituting in Eqn 3
  # ln_rate_ratio = log(1/x) - log(n_intervention) - log(1/y) + log(n_comparator) # Eqn 4
  # ln_rate_ratio = -log(x) - log(n_intervention) - (-log(y)) + log(n_comparator)
  # ln_rate_ratio = -log(x) - log(n_intervention) + log(y) + log(n_comparator) # Eqn 5
  # Rearranging # Eqn 5 to get log(y)
  # log(y) = ln_rate_ratio + log(x) + log(n_intervention) - log(n_comparator) # Eqn 6
  # Exponential on both sides
  # y = exp(ln_rate_ratio + log(x) + log(n_intervention) - log(n_comparator)) # Eqn 7
  # Substituting x and y in Eqn 2
  # se_ln_rate_ratio = ((x) + (y))^0.5 # Eqn 8
  # Taking square on both sides and then rearranging
  # se_ln_rate_ratio^2 = x + y
  # y = se_ln_rate_ratio^2 - x # Eqn 9
  # Replacing y in Eqn 7 with value in Eqn 9
  # se_ln_rate_ratio^2 - x = exp(ln_rate_ratio + log(x) + log(n_intervention) - log(n_comparator))
  # Moving all the terms to left side
  # se_ln_rate_ratio^2 - x - exp(ln_rate_ratio + log(x) + log(n_intervention) - log(n_comparator)) = 0
  # Solve for x using uniroot, calculate y using Eqn 9, and take their reciprocal to get the events_intervention
  f <- function(ln_rate_ratio, se_ln_rate_ratio, n_intervention, n_comparator, x) {
    se_ln_rate_ratio^2 - x - exp(ln_rate_ratio + log(x) + log(n_intervention) - log(n_comparator))
  }
  events_intervention_reciprocal <- uniroot(f, c(0, 10^80), tol = 0.0001, 
                                            ln_rate_ratio = ln_rate_ratio, 
                                            se_ln_rate_ratio = se_ln_rate_ratio,
                                            n_intervention = n_intervention,
                                            n_comparator = n_comparator
  )$root
  events_comparator_reciprocal <-   se_ln_rate_ratio^2 - events_intervention_reciprocal
  
  events_intervention <- 1/events_intervention_reciprocal
  events_comparator <- 1/events_comparator_reciprocal
  rate_intervention = events_intervention/n_intervention
  rate_comparator = events_comparator/n_comparator
  # Since we are looking to swap the rates between intervention and comparator
  missing_trial_events_intervention = rate_comparator*missing_trial_n_intervention
  missing_trial_events_comparator = rate_intervention*missing_trial_n_comparator
  missing_trial_se = (1/missing_trial_events_intervention + 1/missing_trial_events_comparator)^0.5
  return(missing_trial_se)
}
se_missing_trial_from_ln_hazard_ratio_se <- function(missing_trial_n_intervention, missing_trial_n_comparator, ln_hazard_ratio, se_ln_hazard_ratio, n_intervention, n_comparator) {
  # If missing_trial_n_comparator or n_comparator is missing, the total number of participants is provided
  if(missing(missing_trial_n_comparator)) {
    missing_trial_n_intervention <- missing_trial_n_intervention/2
    missing_trial_n_comparator <- missing_trial_n_intervention/2
  }
  if (missing(n_comparator)) {
    n_intervention <- n_intervention/2
    n_comparator <- n_intervention/2
  }
  # Now two equations
  # Modified from (Equation 13): 
  # First calculate the total observed events
  # Tierney, J.F., Stewart, L.A., Ghersi, D. et al. Practical methods for incorporating summary time-to-event data into meta-analysis. Trials 8, 16 (2007). 
  # https://doi.org/10.1186/1745-6215-8-16
  # se_ln_hazard_ratio = (n_intervention + n_comparator)/(observed_events * n_intervention * n_comparator)^0.5 (Equation 13 provides for V which is 1/se2)
  # Moving all terms to left 
  # se_ln_hazard_ratio - (n_intervention + n_comparator)/(observed_events * n_intervention * n_comparator)^0.5 = 0
  f <- function(se_ln_hazard_ratio, n_intervention, n_comparator, total_observed_events) {
    se_ln_hazard_ratio - (n_intervention + n_comparator)/(total_observed_events * n_intervention * n_comparator)^0.5
  }
  total_observed_events <- uniroot(f, c(0, 10^80), tol = 0.0001, 
                                   se_ln_hazard_ratio = se_ln_hazard_ratio,
                                   n_intervention = n_intervention,
                                   n_comparator = n_comparator
  )$root
  # x[1] = observed_events_intervention
  # x[2] = observed_events_comparator
  # x[3] = log_rank_expected_intervention
  # x[4] = log_rank_expected_comparator
  parms <- c(exp(ln_hazard_ratio), se_ln_hazard_ratio^2, total_observed_events, ln_hazard_ratio/se_ln_hazard_ratio^2)
  equations <- function(x, parms) c(
    F1 = (x[1]/x[2])/(x[3]/x[4]) - parms[1], # Eqn 5
    F2 = 1/x[3] + 1/x[4] - parms[2], # Eqn 6
    F3 = x[1] + x[2] - parms[3], 
    F4 = x[1] - x[3] - parms[4] # Eqn 9
  )
  solved_values <- 
    try(rootSolve::multiroot(f = equations, 
                             start = c(total_observed_events*n_intervention/(n_intervention + n_comparator) * exp(ln_hazard_ratio),total_observed_events*n_comparator/(n_intervention + n_comparator) / exp(ln_hazard_ratio), total_observed_events*n_intervention/(n_intervention + n_comparator),total_observed_events*n_comparator/(n_intervention + n_comparator)), 
                             maxiter = 1000, parms = parms)[[1]])
  if (str_detect(solved_values[[1]], "Error")) {
    # Do approximate calculations of hazard ratio using complementary loglog function
    manual_solution <- data.frame(
      observed_events_intervention = 1:(total_observed_events-1),
      observed_events_comparator = (total_observed_events-1):1
    )
    manual_solution$p1 <- manual_solution$observed_events_intervention/n_intervention
    manual_solution$p0 <- manual_solution$observed_events_comparator/n_comparator
    manual_solution$ln_hazard_ratio <- log(- log(1 - manual_solution$p1)) - log(- log(1 - manual_solution$p0))
    # Find the closest match
    observed_events_intervention <- which(abs(manual_solution$ln_hazard_ratio - ln_hazard_ratio) == 
                                            min(abs(manual_solution$ln_hazard_ratio - ln_hazard_ratio)))[1]
    observed_events_comparator <- total_observed_events - observed_events_intervention
  } else {
    observed_events_intervention <- solved_values[1]
    observed_events_comparator <- solved_values[2]
  }
  # Since we are looking to swap the rates between intervention and comparator
  missing_trial_observed_events_intervention <- observed_events_comparator/n_comparator * missing_trial_n_intervention
  missing_trial_observed_events_comparator <- observed_events_intervention/n_intervention * missing_trial_n_comparator
  missing_trial_total_observed_events <- missing_trial_observed_events_intervention + missing_trial_observed_events_comparator
  missing_trial_se <- 
    (missing_trial_n_intervention + missing_trial_n_comparator) /
    (missing_trial_total_observed_events * missing_trial_n_intervention * missing_trial_n_comparator)^0.5 # Modified from Eqn 13
  return(missing_trial_se)
}
rob_me_4.2_sensitivity_analysis <- function(file_location, meta_analysis_plan_location) {
  rob_me_file <- read.csv(file_location, header = TRUE, na.strings = c("", " ", "  "), check.names = FALSE)
  MA_plan <- read.csv(meta_analysis_plan_location, header = TRUE, na.strings = c("", " ", "  "), check.names = FALSE)
  if ((ncol(rob_me_file) == 14) & 
      (!FALSE %in% (colnames(rob_me_file) == c("Outcome name", "Type of outcome", "Are more events or higher value better or worse for participants?", "Study", "Intervention (total number of participants)", "Control (total number of participants)", "Parameter1", "Parameter2", "Parameter3", "Parameter4", "missing_study", "missing_outcome", "missing_n_intervention", "missing_n_comparator")))
  ) {
    if ((ncol(MA_plan) == 15) & 
        (!FALSE %in% (colnames(MA_plan) == c("Outcome", "Effect measure", "Rare events (continuity correction)", "Rare events (method)", "Fixed-effect", "Prediction interval", "Hartung and Knapp adjustment", "Meta-analysis method", "Main meta-analysis summary", "Minimum studies for tests for funnel plot asymmetry", "Meta-bias method (Any)", "Meta-bias method (Heterogeneity)", "Information Missingness Odds Ratio (IMOR) (Intervention)", "Information Missingness Odds Ratio (IMOR) (Control)", "Moderator variables to be included")))
    ) { 
      if (nrow(rob_me_file) > 0) {
        # Split the file into two parts
        # First 10 columns = data, next four columns = missing outcomes
        data <- rob_me_file[!is.na(rob_me_file$`Outcome name`) & !is.na(rob_me_file$Study),1:10]
        missing_studies <- rob_me_file[!is.na(rob_me_file$missing_outcome) & !is.na(rob_me_file$missing_study),11:14]
        missing_studies <- missing_studies[
          (!is.na(missing_studies$missing_study)) &
            (!is.na(missing_studies$missing_outcome)) &
            (!is.na(missing_studies$missing_n_intervention))
          , ]
        if (nrow(missing_studies) > 0) {
          if (nrow(data) > 0) {
            # Create an outcome list for sensitivity analysis
            outcome_list <- unique(missing_studies$missing_outcome)
            # Select the outcomes with data
            outcome_list_2 <- outcome_list[! is.na(match(outcome_list, unique(data$`Outcome name`)))]
            if (length(outcome_list_2) > 0) {
              # Check that there is a meta-analysis plan for the outcome
              outcome_list_3 <- outcome_list[! is.na(match(outcome_list, unique(MA_plan$Outcome)))]
              if (length(outcome_list_3) > 0) {
                # create effect_measure_converter for reporting
                effect_measure_converter <- data.frame(
                  full_names = c("Odds ratio", "Risk ratio", "Risk difference", 
                                 "Mean difference", "Standardised mean difference","Ratio of means",
                                 "Rate ratio", "Hazard ratio"),
                  abbreviations = c("OR", "RR", "RD", "MD","SMD","ROM", "IRR", "HR")
                )
                # Create a list of outcome types
                outcome_types <- c("Binary", "Count", "Continuous", "Time", "Summary_Ratio", "Summary_Difference")
                results <- lapply(1:length(outcome_list), function(x) {
                  if (! is.na(match(outcome_list[x], unique(data$`Outcome name`)))) {
                    if (! is.na(match(outcome_list[x], unique(MA_plan$Outcome)))) {
                      # First the data
                      data_each_outcome <- data[data$`Outcome name` == outcome_list[x],]
                      if (! is.na(match(data_each_outcome$`Type of outcome`[1], outcome_types))) {
                        if (! is.na(match(data_each_outcome$`Are more events or higher value better or worse for participants?`[1], c("Better", "Worse")))) {
                          # Get the meta_analysis plan
                          MA_plan_each_outcome <- MA_plan[MA_plan$Outcome == outcome_list[x],]
                          if (data_each_outcome$`Type of outcome`[1] == "Binary") {
                            data_each_outcome <- data_each_outcome[(
                              (!is.na(data_each_outcome$`Intervention (total number of participants)`)) & 
                                (!is.na(data_each_outcome$`Control (total number of participants)`)) &
                                (!is.na(data_each_outcome$Parameter1)) &
                                (!is.na(data_each_outcome$Parameter2))
                            ),]
                            if (nrow(data_each_outcome) > 0) {
                              meta_analysis_each_outcome <- {metabin(
                                event.e = data_each_outcome$Parameter1,
                                n.e = data_each_outcome$`Intervention (total number of participants)`,
                                event.c = data_each_outcome$Parameter2,
                                n.c = data_each_outcome$`Control (total number of participants)`,
                                data = data_each_outcome,
                                studlab = data_each_outcome$Study,
                                common = FALSE,
                                sm = MA_plan_each_outcome$`Effect measure`,
                                method = MA_plan_each_outcome$`Meta-analysis method`,
                                method.random.ci = ifelse(MA_plan_each_outcome$`Hartung and Knapp adjustment` != "No","HK","classic"),
                                method.predict = ifelse(MA_plan_each_outcome$`Hartung and Knapp adjustment` != "No","HK","HTS"),
                                prediction = (MA_plan_each_outcome$`Prediction interval` != "No"),
                                outclab = MA_plan_each_outcome$Outcome,
                                label.e = "Intervention",
                                label.c = "Comparator",
                                label.left = ifelse(tolower(data_each_outcome$`Are more events or higher value better or worse for participants?`)[1] == "worse", "Favours Intervention", "Favours Comparator"),
                                label.right = ifelse(tolower(data_each_outcome$`Are more events or higher value better or worse for participants?`)[1] == "worse", "Favours Comparator","Favours Intervention")
                              )}
                              if (MA_plan_each_outcome$`Effect measure` == "RR" | MA_plan_each_outcome$`Effect measure` == "RD"){
                                meta_analysis_each_outcome <- update(
                                  meta_analysis_each_outcome,
                                  RR.Cochrane = (MA_plan_each_outcome$`Rare events (continuity correction)` == "Continuity correction with 0.5 for events and no events"),
                                  method.random.ci = ifelse(MA_plan_each_outcome$`Hartung and Knapp adjustment` != "No","HK","classic"),
                                  adhoc.hakn.ci = "se",
                                  method.predict = ifelse(MA_plan_each_outcome$`Hartung and Knapp adjustment` != "No","HK","HTS"),
                                  adhoc.hakn.pi = "se"
                                )
                              } else {
                                if (!is.null(meta_analysis_each_outcome$sparse) & meta_analysis_each_outcome$sparse == TRUE){
                                  if (MA_plan_each_outcome$`Rare events (method)` == "Generalised Linear Mixed Model (only for odds ratios)"){
                                    # First try GLMM model with exact likelihood
                                    suppressWarnings({
                                      suppressMessages({
                                        meta_analysis_each_outcome <- 
                                          try(
                                            update(
                                              meta_analysis_each_outcome,
                                              method = "GLMM",
                                              model.glmm = "CM.EL",
                                              method.predict = "HTS"
                                            )
                                          )
                                      })
                                    })
                                    # If there is no convergence, then approximate likelihood
                                    # To find if the model worked, check whether meta_analysis_each_outcome contains error
                                    if (grepl("Error",meta_analysis_each_outcome)[1] == TRUE) {
                                      # Use GLMM model with approximate likelihood
                                      meta_analysis_each_outcome <- metabin(
                                        event.e = data_each_outcome$Parameter1,
                                        n.e = data_each_outcome$`Intervention (total number of participants)`,
                                        event.c = data_each_outcome$Parameter2,
                                        n.c = data_each_outcome$`Control (total number of participants)`,
                                        data = data_each_outcome,
                                        studlab = data_each_outcome$Study,
                                        common = FALSE,
                                        sm = "OR",
                                        method = "GLMM",
                                        model.glmm = "CM.AL",
                                        method.random.ci = ifelse(MA_plan_each_outcome$`Hartung and Knapp adjustment` != "No","HK","classic"),
                                        method.predict = "HTS",
                                        prediction = (MA_plan_each_outcome$`Prediction interval` != "No"),
                                        outclab = MA_plan_each_outcome$Outcome,
                                        label.e = "Intervention",
                                        label.c = "Comparator",
                                        label.left = ifelse(tolower(data_each_outcome$`Are more events or higher value better or worse for participants?`)[1] == "worse", "Favours Intervention", "Favours Comparator"),
                                        label.right = ifelse(tolower(data_each_outcome$`Are more events or higher value better or worse for participants?`)[1] == "worse", "Favours Comparator","Favours Intervention")
                                      )
                                    }
                                  } else {
                                    meta_analysis_each_outcome <- update(
                                      meta_analysis_each_outcome,
                                      method = "Peto"
                                    )
                                  }
                                } else {
                                  meta_analysis_each_outcome <- update(
                                    meta_analysis_each_outcome,
                                    method.random.ci = ifelse(MA_plan_each_outcome$`Hartung and Knapp adjustment` != "No","HK","classic"),
                                    adhoc.hakn.ci = "se",
                                    method.predict = ifelse(MA_plan_each_outcome$`Hartung and Knapp adjustment` != "No","HK","HTS"),
                                    adhoc.hakn.pi = "se"
                                  )
                                }
                              }
                              # Store the results
                              meta_analysis_each_outcome_without_missing_studies <- meta_analysis_each_outcome
                              # Get the results from the study with best results for intervention
                              if (data_each_outcome$`Are more events or higher value better or worse for participants?`[1] == "Better") {
                                data_best_study_each_outcome <- data_each_outcome[match(max(meta_analysis_each_outcome$TE),meta_analysis_each_outcome$TE),]
                              } else {
                                data_best_study_each_outcome <- data_each_outcome[match(min(meta_analysis_each_outcome$TE),meta_analysis_each_outcome$TE),]
                              }
                              # Get the proportions in the study with best results
                              risk_intervention <- data_best_study_each_outcome$Parameter1/data_best_study_each_outcome$`Intervention (total number of participants)`
                              risk_comparator <- data_best_study_each_outcome$Parameter2/data_best_study_each_outcome$`Control (total number of participants)`
                              # Calculate the number of events in the missing studies
                              missing_studies_each_outcome <- missing_studies[missing_studies$missing_outcome == outcome_list[x],]
                              missing_studies_each_outcome <- missing_studies_each_outcome[! duplicated(missing_studies_each_outcome$missing_study),]
                              missing_studies_each_outcome[is.na(missing_studies_each_outcome$missing_n_comparator),c("missing_n_intervention", "missing_n_comparator")] <-
                                missing_studies_each_outcome$missing_n_intervention[is.na(missing_studies_each_outcome$missing_n_comparator)]/2
                              missing_studies_each_outcome$parameter_1 <- missing_studies_each_outcome$missing_n_intervention * risk_comparator # Swapping the intervention and comparator risk
                              missing_studies_each_outcome$parameter_2 <- missing_studies_each_outcome$missing_n_comparator * risk_intervention # Swapping the intervention and comparator risk
                              missing_studies_each_outcome$parameter_3 <- NA
                              missing_studies_each_outcome$parameter_4 <- NA
                              # Store the data
                              data_each_outcome <- {rbind.data.frame(
                                data_each_outcome,
                                data.frame(
                                  `Outcome name` = outcome_list[x], 
                                  `Type of outcome` = data_each_outcome$`Type of outcome`[1], 
                                  `Are more events or higher value better or worse for participants?` = data_each_outcome$`Are more events or higher value better or worse for participants?`[1], 
                                  `Study` = missing_studies_each_outcome$missing_study, 
                                  `Intervention (total number of participants)` = missing_studies_each_outcome$missing_n_intervention, 
                                  `Control (total number of participants)` = missing_studies_each_outcome$missing_n_comparator, 
                                  `Parameter1` =  missing_studies_each_outcome$parameter_1,
                                  `Parameter2` =  missing_studies_each_outcome$parameter_2,
                                  `Parameter3` = missing_studies_each_outcome$parameter_3,
                                  `Parameter4` = missing_studies_each_outcome$parameter_4,
                                  check.names = FALSE
                                )
                              )}
                              # Perform the meta-analysis again
                              meta_analysis_each_outcome <- {metabin(
                                event.e = data_each_outcome$Parameter1,
                                n.e = data_each_outcome$`Intervention (total number of participants)`,
                                event.c = data_each_outcome$Parameter2,
                                n.c = data_each_outcome$`Control (total number of participants)`,
                                data = data_each_outcome,
                                studlab = data_each_outcome$Study,
                                common = FALSE,
                                sm = MA_plan_each_outcome$`Effect measure`,
                                method = MA_plan_each_outcome$`Meta-analysis method`,
                                method.random.ci = ifelse(MA_plan_each_outcome$`Hartung and Knapp adjustment` != "No","HK","classic"),
                                method.predict = ifelse(MA_plan_each_outcome$`Hartung and Knapp adjustment` != "No","HK","HTS"),
                                prediction = (MA_plan_each_outcome$`Prediction interval` != "No"),
                                outclab = MA_plan_each_outcome$Outcome,
                                label.e = "Intervention",
                                label.c = "Comparator",
                                label.left = ifelse(tolower(data_each_outcome$`Are more events or higher value better or worse for participants?`)[1] == "worse", "Favours Intervention", "Favours Comparator"),
                                label.right = ifelse(tolower(data_each_outcome$`Are more events or higher value better or worse for participants?`)[1] == "worse", "Favours Comparator","Favours Intervention")
                              )}
                              if (MA_plan_each_outcome$`Effect measure` == "RR" | MA_plan_each_outcome$`Effect measure` == "RD"){
                                meta_analysis_each_outcome <- update(
                                  meta_analysis_each_outcome,
                                  RR.Cochrane = (MA_plan_each_outcome$`Rare events (continuity correction)` == "Continuity correction with 0.5 for events and no events"),
                                  method.random.ci = ifelse(MA_plan_each_outcome$`Hartung and Knapp adjustment` != "No","HK","classic"),
                                  adhoc.hakn.ci = "se",
                                  method.predict = ifelse(MA_plan_each_outcome$`Hartung and Knapp adjustment` != "No","HK","HTS"),
                                  adhoc.hakn.pi = "se"
                                )
                              } else {
                                if (!is.null(meta_analysis_each_outcome$sparse) & meta_analysis_each_outcome$sparse == TRUE){
                                  if (MA_plan_each_outcome$`Rare events (method)` == "Generalised Linear Mixed Model (only for odds ratios)"){
                                    # First try GLMM model with exact likelihood
                                    suppressWarnings({
                                      suppressMessages({
                                        meta_analysis_each_outcome <- 
                                          try(
                                            update(
                                              meta_analysis_each_outcome,
                                              method = "GLMM",
                                              model.glmm = "CM.EL",
                                              method.predict = "HTS"
                                            )
                                          )
                                      })
                                    })
                                    # If there is no convergence, then approximate likelihood
                                    # To find if the model worked, check whether meta_analysis_each_outcome contains error
                                    if (grepl("Error",meta_analysis_each_outcome)[1] == TRUE) {
                                      # Use GLMM model with approximate likelihood
                                      meta_analysis_each_outcome <- metabin(
                                        event.e = data_each_outcome$Parameter1,
                                        n.e = data_each_outcome$`Intervention (total number of participants)`,
                                        event.c = data_each_outcome$Parameter2,
                                        n.c = data_each_outcome$`Control (total number of participants)`,
                                        data = data_each_outcome,
                                        studlab = data_each_outcome$Study,
                                        common = FALSE,
                                        sm = "OR",
                                        method = "GLMM",
                                        model.glmm = "CM.AL",
                                        method.random.ci = ifelse(MA_plan_each_outcome$`Hartung and Knapp adjustment` != "No","HK","classic"),
                                        method.predict = "HTS",
                                        prediction = (MA_plan_each_outcome$`Prediction interval` != "No"),
                                        outclab = MA_plan_each_outcome$Outcome,
                                        label.e = "Intervention",
                                        label.c = "Comparator",
                                        label.left = ifelse(tolower(data_each_outcome$`Are more events or higher value better or worse for participants?`)[1] == "worse", "Favours Intervention", "Favours Comparator"),
                                        label.right = ifelse(tolower(data_each_outcome$`Are more events or higher value better or worse for participants?`)[1] == "worse", "Favours Comparator","Favours Intervention")
                                      )
                                    }
                                  } else {
                                    meta_analysis_each_outcome <- update(
                                      meta_analysis_each_outcome,
                                      method = "Peto"
                                    )
                                  }
                                } else {
                                  meta_analysis_each_outcome <- update(
                                    meta_analysis_each_outcome,
                                    method.random.ci = ifelse(MA_plan_each_outcome$`Hartung and Knapp adjustment` != "No","HK","classic"),
                                    adhoc.hakn.ci = "se",
                                    method.predict = ifelse(MA_plan_each_outcome$`Hartung and Knapp adjustment` != "No","HK","HTS"),
                                    adhoc.hakn.pi = "se"
                                  )
                                }
                              }
                              output_each_outcome <- {paste0(
                                effect_measure_converter$full_names[effect_measure_converter$abbreviations == MA_plan_each_outcome$`Effect measure`], 
                                ": ", 
                                ifelse(MA_plan_each_outcome$`Effect measure` == "RD", 
                                       paste0(
                                         "Results without missing studies: ", sprintf("%.2f", round(meta_analysis_each_outcome_without_missing_studies$TE.random,2)), " (95% CI ", sprintf("%.2f", round(meta_analysis_each_outcome_without_missing_studies$lower.random,2)), " to ", sprintf("%.2f", round(meta_analysis_each_outcome_without_missing_studies$upper.random,2)), ")", "\n",
                                         "Results with missing studies: ", sprintf("%.2f", round(meta_analysis_each_outcome$TE.random,2)), " (95% CI ", sprintf("%.2f", round(meta_analysis_each_outcome$lower.random,2)), " to ", sprintf("%.2f", round(meta_analysis_each_outcome$upper.random,2)), ")"
                                       ),
                                       paste0(
                                         "Results without missing studies: ", sprintf("%.2f", round(exp(meta_analysis_each_outcome_without_missing_studies$TE.random),2)), " (95% CI ", sprintf("%.2f", round(exp(meta_analysis_each_outcome_without_missing_studies$lower.random),2)), " to ", sprintf("%.2f", round(exp(meta_analysis_each_outcome_without_missing_studies$upper.random),2)), ")", "\n",
                                         "Results with missing studies: ", sprintf("%.2f", round(exp(meta_analysis_each_outcome$TE.random),2)), " (95% CI ", sprintf("%.2f", round(exp(meta_analysis_each_outcome$lower.random),2)), " to ", sprintf("%.2f", round(exp(meta_analysis_each_outcome$upper.random),2)), ")")
                                )
                              )}
                            } else {
                              output_each_outcome <- 'There is no data for suitable analysis of data for this outcome.'
                            }
                          } else if (data_each_outcome$`Type of outcome`[1] == "Continuous") {
                            data_each_outcome <- data_each_outcome[(
                              (!is.na(data_each_outcome$`Intervention (total number of participants)`)) & 
                                (!is.na(data_each_outcome$`Control (total number of participants)`)) &
                                (!is.na(data_each_outcome$Parameter1)) &
                                (!is.na(data_each_outcome$Parameter2)) &
                                (!is.na(data_each_outcome$Parameter3)) &
                                (!is.na(data_each_outcome$Parameter4))
                            ),]
                            if (nrow(data_each_outcome) > 0) {
                              meta_analysis_each_outcome <- {metacont(
                                n.e = data_each_outcome$`Intervention (total number of participants)`,
                                mean.e = data_each_outcome$Parameter1,
                                sd.e = data_each_outcome$Parameter2,
                                n.c = data_each_outcome$`Control (total number of participants)`,
                                mean.c = data_each_outcome$Parameter3,
                                sd.c = data_each_outcome$Parameter4,
                                data = data_each_outcome,
                                studlab = data_each_outcome$Study,
                                common = FALSE,
                                sm = MA_plan_each_outcome$`Effect measure`,
                                method.smd = ifelse(MA_plan_each_outcome$`Effect measure` == "SMD",as.character(strsplit(MA_plan_each_outcome$`Meta-analysis method`,"_")[[1]][1]),"Hedges"),
                                exact.smd = ifelse(MA_plan_each_outcome$`Effect measure` == "SMD",as.logical(strsplit(MA_plan_each_outcome$`Meta-analysis method`,"_")[[1]][2]),FALSE),
                                method.random.ci = ifelse(MA_plan_each_outcome$`Hartung and Knapp adjustment` != "No","HK","classic"),
                                adhoc.hakn.ci = "se",
                                method.predict = ifelse(MA_plan_each_outcome$`Hartung and Knapp adjustment` != "No","HK","HTS"),
                                adhoc.hakn.pi = "se",
                                prediction = (MA_plan_each_outcome$`Prediction interval` != "No"),
                                outclab = MA_plan_each_outcome$Outcome,
                                label.e = "Intervention",
                                label.c = "Comparator",
                                label.left = ifelse(tolower(data_each_outcome$`Are more events or higher value better or worse for participants?`)[1] == "worse", "Favours Intervention", "Favours Comparator"),
                                label.right = ifelse(tolower(data_each_outcome$`Are more events or higher value better or worse for participants?`)[1] == "worse", "Favours Comparator","Favours Intervention")
                              )}
                              # Store the results
                              meta_analysis_each_outcome_without_missing_studies <- meta_analysis_each_outcome
                              # Get the results from the study with best results for intervention
                              if (data_each_outcome$`Are more events or higher value better or worse for participants?`[1] == "Better") {
                                data_best_study_each_outcome <- data_each_outcome[match(max(meta_analysis_each_outcome$TE),meta_analysis_each_outcome$TE),]
                              } else {
                                data_best_study_each_outcome <- data_each_outcome[match(min(meta_analysis_each_outcome$TE),meta_analysis_each_outcome$TE),]
                              }
                              missing_studies_each_outcome <- missing_studies[missing_studies$missing_outcome == outcome_list[x],]
                              missing_studies_each_outcome <- missing_studies_each_outcome[! duplicated(missing_studies_each_outcome$missing_study),]
                              missing_studies_each_outcome[is.na(missing_studies_each_outcome$missing_n_comparator),c("missing_n_intervention", "missing_n_comparator")] <-
                                missing_studies_each_outcome$missing_n_intervention[is.na(missing_studies_each_outcome$missing_n_comparator)]/2
                              missing_studies_each_outcome$parameter_1 <- data_best_study_each_outcome$Parameter3 # Swapping the intervention and comparator mean and standard deviations
                              missing_studies_each_outcome$parameter_2 <- data_best_study_each_outcome$Parameter4 # Swapping the intervention and comparator mean and standard deviations
                              missing_studies_each_outcome$parameter_3 <- data_best_study_each_outcome$Parameter1 # Swapping the intervention and comparator mean and standard deviations
                              missing_studies_each_outcome$parameter_4 <- data_best_study_each_outcome$Parameter2 # Swapping the intervention and comparator mean and standard deviations
                              # Store the data
                              data_each_outcome <- {rbind.data.frame(
                                data_each_outcome,
                                data.frame(
                                  `Outcome name` = outcome_list[x], 
                                  `Type of outcome` = data_each_outcome$`Type of outcome`[1], 
                                  `Are more events or higher value better or worse for participants?` = data_each_outcome$`Are more events or higher value better or worse for participants?`[1], 
                                  `Study` = missing_studies_each_outcome$missing_study, 
                                  `Intervention (total number of participants)` = missing_studies_each_outcome$missing_n_intervention, 
                                  `Control (total number of participants)` = missing_studies_each_outcome$missing_n_comparator, 
                                  `Parameter1` =  missing_studies_each_outcome$parameter_1,
                                  `Parameter2` =  missing_studies_each_outcome$parameter_2,
                                  `Parameter3` = missing_studies_each_outcome$parameter_3,
                                  `Parameter4` = missing_studies_each_outcome$parameter_4,
                                  check.names = FALSE
                                )
                              )}
                              # Perform the meta-analysis again
                              meta_analysis_each_outcome <- {metacont(
                                n.e = data_each_outcome$`Intervention (total number of participants)`,
                                mean.e = data_each_outcome$Parameter1,
                                sd.e = data_each_outcome$Parameter2,
                                n.c = data_each_outcome$`Control (total number of participants)`,
                                mean.c = data_each_outcome$Parameter3,
                                sd.c = data_each_outcome$Parameter4,
                                data = data_each_outcome,
                                studlab = data_each_outcome$Study,
                                common = FALSE,
                                sm = MA_plan_each_outcome$`Effect measure`,
                                method.smd = ifelse(MA_plan_each_outcome$`Effect measure` == "SMD",as.character(strsplit(MA_plan_each_outcome$`Meta-analysis method`,"_")[[1]][1]),"Hedges"),
                                exact.smd = ifelse(MA_plan_each_outcome$`Effect measure` == "SMD",as.logical(strsplit(MA_plan_each_outcome$`Meta-analysis method`,"_")[[1]][2]),FALSE),
                                method.random.ci = ifelse(MA_plan_each_outcome$`Hartung and Knapp adjustment` != "No","HK","classic"),
                                adhoc.hakn.ci = "se",
                                method.predict = ifelse(MA_plan_each_outcome$`Hartung and Knapp adjustment` != "No","HK","HTS"),
                                adhoc.hakn.pi = "se",
                                prediction = (MA_plan_each_outcome$`Prediction interval` != "No"),
                                outclab = MA_plan_each_outcome$Outcome,
                                label.e = "Intervention",
                                label.c = "Comparator",
                                label.left = ifelse(tolower(data_each_outcome$`Are more events or higher value better or worse for participants?`)[1] == "worse", "Favours Intervention", "Favours Comparator"),
                                label.right = ifelse(tolower(data_each_outcome$`Are more events or higher value better or worse for participants?`)[1] == "worse", "Favours Comparator","Favours Intervention")
                              )}
                              output_each_outcome <- {paste0(
                                effect_measure_converter$full_names[effect_measure_converter$abbreviations == MA_plan_each_outcome$`Effect measure`], 
                                ": ", 
                                ifelse(MA_plan_each_outcome$`Effect measure` != "ROM", 
                                       paste0(
                                         "Results without missing studies: ", sprintf("%.2f", round(meta_analysis_each_outcome_without_missing_studies$TE.random,2)), " (95% CI ", sprintf("%.2f", round(meta_analysis_each_outcome_without_missing_studies$lower.random,2)), " to ", sprintf("%.2f", round(meta_analysis_each_outcome_without_missing_studies$upper.random,2)), ")", "\n",
                                         "Results with missing studies: ", sprintf("%.2f", round(meta_analysis_each_outcome$TE.random,2)), " (95% CI ", sprintf("%.2f", round(meta_analysis_each_outcome$lower.random,2)), " to ", sprintf("%.2f", round(meta_analysis_each_outcome$upper.random,2)), ")"
                                       ),
                                       paste0(
                                         "Results without missing studies: ", sprintf("%.2f", round(exp(meta_analysis_each_outcome_without_missing_studies$TE.random),2)), " (95% CI ", sprintf("%.2f", round(exp(meta_analysis_each_outcome_without_missing_studies$lower.random),2)), " to ", sprintf("%.2f", round(exp(meta_analysis_each_outcome_without_missing_studies$upper.random),2)), ")", "\n",
                                         "Results with missing studies: ", sprintf("%.2f", round(exp(meta_analysis_each_outcome$TE.random),2)), " (95% CI ", sprintf("%.2f", round(exp(meta_analysis_each_outcome$lower.random),2)), " to ", sprintf("%.2f", round(exp(meta_analysis_each_outcome$upper.random),2)), ")")
                                )
                              )}
                            } else {
                              output_each_outcome <- 'There is no data for suitable analysis of data for this outcome.'
                            }
                          } else {
                            data_each_outcome <- data_each_outcome[(
                              (!is.na(data_each_outcome$`Intervention (total number of participants)`)) & 
                                (!is.na(data_each_outcome$`Control (total number of participants)`)) &
                                (!is.na(data_each_outcome$Parameter1)) &
                                (!is.na(data_each_outcome$Parameter2))
                            ),]
                            if (nrow(data_each_outcome) > 0) {
                              meta_analysis_each_outcome <- {metagen(
                                TE = data_each_outcome$Parameter1,
                                seTE = data_each_outcome$Parameter2,
                                n.e = data_each_outcome$`Intervention (total number of participants)`,
                                n.c = data_each_outcome$`Control (total number of participants)`,
                                data = data_each_outcome,
                                studlab = data_each_outcome$Study,
                                common = FALSE,
                                sm = MA_plan_each_outcome$`Effect measure`,
                                method.random.ci = ifelse(MA_plan_each_outcome$`Hartung and Knapp adjustment` != "No","HK","classic"),
                                method.predict = ifelse(MA_plan_each_outcome$`Hartung and Knapp adjustment` != "No","HK","HTS"),
                                prediction = (MA_plan_each_outcome$`Prediction interval` != "No"),
                                outclab = MA_plan_each_outcome$Outcome,
                                label.e = "Intervention",
                                label.c = "Comparator",
                                label.left = ifelse(tolower(data_each_outcome$`Are more events or higher value better or worse for participants?`)[1] == "worse", "Favours Intervention", "Favours Comparator"),
                                label.right = ifelse(tolower(data_each_outcome$`Are more events or higher value better or worse for participants?`)[1] == "worse", "Favours Comparator","Favours Intervention")
                              )}
                              # Store the results
                              meta_analysis_each_outcome_without_missing_studies <- meta_analysis_each_outcome
                              # Get the results from the study with best results for intervention
                              if (data_each_outcome$`Are more events or higher value better or worse for participants?`[1] == "Better") {
                                data_best_study_each_outcome <- data_each_outcome[match(max(meta_analysis_each_outcome$TE),meta_analysis_each_outcome$TE),]
                              } else {
                                data_best_study_each_outcome <- data_each_outcome[match(min(meta_analysis_each_outcome$TE),meta_analysis_each_outcome$TE),]
                              }
                              missing_studies_each_outcome <- missing_studies[missing_studies$missing_outcome == outcome_list[x],]
                              missing_studies_each_outcome <- missing_studies_each_outcome[! duplicated(missing_studies_each_outcome$missing_study),]
                              missing_studies_each_outcome[is.na(missing_studies_each_outcome$missing_n_comparator),c("missing_n_intervention", "missing_n_comparator")] <-
                                missing_studies_each_outcome$missing_n_intervention[is.na(missing_studies_each_outcome$missing_n_comparator)]/2
                              missing_trial_se <- sapply(1:nrow(missing_studies_each_outcome),function(z){
                                if (MA_plan_each_outcome$`Effect measure` == "OR"){
                                  se_missing_trial_from_ln_odds_ratio_se(missing_studies_each_outcome$missing_n_intervention[z],
                                                                         missing_studies_each_outcome$missing_n_comparator[z], 
                                                                         data_best_study_each_outcome$Parameter1, 
                                                                         data_best_study_each_outcome$Parameter2, 
                                                                         data_best_study_each_outcome$`Intervention (total number of participants)`, 
                                                                         data_best_study_each_outcome$`Control (total number of participants)`
                                  )
                                } else if (MA_plan_each_outcome$`Effect measure` == "RR"){
                                  se_missing_trial_from_ln_risk_ratio_se(missing_studies_each_outcome$missing_n_intervention[z],
                                                                         missing_studies_each_outcome$missing_n_comparator[z], 
                                                                         data_best_study_each_outcome$Parameter1, 
                                                                         data_best_study_each_outcome$Parameter2, 
                                                                         data_best_study_each_outcome$`Intervention (total number of participants)`, 
                                                                         data_best_study_each_outcome$`Control (total number of participants)`
                                  )
                                } else if (MA_plan_each_outcome$`Effect measure` == "RD"){
                                  se_missing_trial_from_risk_difference_se(missing_studies_each_outcome$missing_n_intervention[z],
                                                                           missing_studies_each_outcome$missing_n_comparator[z], 
                                                                           data_best_study_each_outcome$Parameter1, 
                                                                           data_best_study_each_outcome$Parameter2, 
                                                                           data_best_study_each_outcome$`Intervention (total number of participants)`, 
                                                                           data_best_study_each_outcome$`Control (total number of participants)`
                                  )
                                } else if (MA_plan_each_outcome$`Effect measure` == "MD"){
                                  se_missing_trial_from_mean_difference_se(missing_studies_each_outcome$missing_n_intervention[z],
                                                                           missing_studies_each_outcome$missing_n_comparator[z], 
                                                                           data_best_study_each_outcome$Parameter1, 
                                                                           data_best_study_each_outcome$Parameter2, 
                                                                           data_best_study_each_outcome$`Intervention (total number of participants)`, 
                                                                           data_best_study_each_outcome$`Control (total number of participants)`
                                  )
                                } else if (MA_plan_each_outcome$`Effect measure` == "SMD"){
                                  se_missing_trial_from_SMD_se(missing_studies_each_outcome$missing_n_intervention[z],
                                                               missing_studies_each_outcome$missing_n_comparator[z], 
                                                               data_best_study_each_outcome$Parameter1, 
                                                               data_best_study_each_outcome$Parameter2, 
                                                               data_best_study_each_outcome$`Intervention (total number of participants)`, 
                                                               data_best_study_each_outcome$`Control (total number of participants)`
                                  )
                                } else if (MA_plan_each_outcome$`Effect measure` == "IRR"){
                                  se_missing_trial_from_ln_rate_ratio_se(missing_studies_each_outcome$missing_n_intervention[z],
                                                                         missing_studies_each_outcome$missing_n_comparator[z], 
                                                                         data_best_study_each_outcome$Parameter1, 
                                                                         data_best_study_each_outcome$Parameter2, 
                                                                         data_best_study_each_outcome$`Intervention (total number of participants)`, 
                                                                         data_best_study_each_outcome$`Control (total number of participants)`
                                  )
                                } else if (MA_plan_each_outcome$`Effect measure` == "HR"){
                                  se_missing_trial_from_ln_hazard_ratio_se(missing_studies_each_outcome$missing_n_intervention[z],
                                                                           missing_studies_each_outcome$missing_n_comparator[z], 
                                                                           data_best_study_each_outcome$Parameter1, 
                                                                           data_best_study_each_outcome$Parameter2, 
                                                                           data_best_study_each_outcome$`Intervention (total number of participants)`, 
                                                                           data_best_study_each_outcome$`Control (total number of participants)`
                                  )
                                } else {
                                  data_best_study_each_outcome$Parameter2
                                }
                              })
                              missing_studies_each_outcome$parameter_1 <- -(data_best_study_each_outcome$Parameter1) # Just change the signs for the mean effect
                              missing_studies_each_outcome$parameter_2 <- missing_trial_se # This is obtained by functions
                              missing_studies_each_outcome$parameter_3 <- NA
                              missing_studies_each_outcome$parameter_4 <- NA
                              # Store the data
                              data_each_outcome <- {rbind.data.frame(
                                data_each_outcome,
                                data.frame(
                                  `Outcome name` = outcome_list[x], 
                                  `Type of outcome` = data_each_outcome$`Type of outcome`[1], 
                                  `Are more events or higher value better or worse for participants?` = data_each_outcome$`Are more events or higher value better or worse for participants?`[1], 
                                  `Study` = missing_studies_each_outcome$missing_study, 
                                  `Intervention (total number of participants)` = missing_studies_each_outcome$missing_n_intervention, 
                                  `Control (total number of participants)` = missing_studies_each_outcome$missing_n_comparator, 
                                  `Parameter1` =  missing_studies_each_outcome$parameter_1,
                                  `Parameter2` =  missing_studies_each_outcome$parameter_2,
                                  `Parameter3` = missing_studies_each_outcome$parameter_3,
                                  `Parameter4` = missing_studies_each_outcome$parameter_4,
                                  check.names = FALSE
                                )
                              )}
                              # Perform the meta-analysis again
                              meta_analysis_each_outcome <- {metagen(
                                TE = data_each_outcome$Parameter1,
                                seTE = data_each_outcome$Parameter2,
                                n.e = data_each_outcome$`Intervention (total number of participants)`,
                                n.c = data_each_outcome$`Control (total number of participants)`,
                                data = data_each_outcome,
                                studlab = data_each_outcome$Study,
                                common = FALSE,
                                sm = MA_plan_each_outcome$`Effect measure`,
                                method.random.ci = ifelse(MA_plan_each_outcome$`Hartung and Knapp adjustment` != "No","HK","classic"),
                                method.predict = ifelse(MA_plan_each_outcome$`Hartung and Knapp adjustment` != "No","HK","HTS"),
                                prediction = (MA_plan_each_outcome$`Prediction interval` != "No"),
                                outclab = MA_plan_each_outcome$Outcome,
                                label.e = "Intervention",
                                label.c = "Comparator",
                                label.left = ifelse(tolower(data_each_outcome$`Are more events or higher value better or worse for participants?`)[1] == "worse", "Favours Intervention", "Favours Comparator"),
                                label.right = ifelse(tolower(data_each_outcome$`Are more events or higher value better or worse for participants?`)[1] == "worse", "Favours Comparator","Favours Intervention")
                              )}
                              output_each_outcome <- {paste0(
                                effect_measure_converter$full_names[effect_measure_converter$abbreviations == MA_plan_each_outcome$`Effect measure`], 
                                ": ", 
                                ifelse(str_detect(effect_measure_converter$full_names[effect_measure_converter$abbreviations == MA_plan_each_outcome$`Effect measure`], "difference"), 
                                       paste0(
                                         "Results without missing studies: ", sprintf("%.2f", round(meta_analysis_each_outcome_without_missing_studies$TE.random,2)), " (95% CI ", sprintf("%.2f", round(meta_analysis_each_outcome_without_missing_studies$lower.random,2)), " to ", sprintf("%.2f", round(meta_analysis_each_outcome_without_missing_studies$upper.random,2)), ")", "\n",
                                         "Results with missing studies: ", sprintf("%.2f", round(meta_analysis_each_outcome$TE.random,2)), " (95% CI ", sprintf("%.2f", round(meta_analysis_each_outcome$lower.random,2)), " to ", sprintf("%.2f", round(meta_analysis_each_outcome$upper.random,2)), ")"
                                       ),
                                       paste0(
                                         "Results without missing studies: ", sprintf("%.2f", round(exp(meta_analysis_each_outcome_without_missing_studies$TE.random),2)), " (95% CI ", sprintf("%.2f", round(exp(meta_analysis_each_outcome_without_missing_studies$lower.random),2)), " to ", sprintf("%.2f", round(exp(meta_analysis_each_outcome_without_missing_studies$upper.random),2)), ")", "\n",
                                         "Results with missing studies: ", sprintf("%.2f", round(exp(meta_analysis_each_outcome$TE.random),2)), " (95% CI ", sprintf("%.2f", round(exp(meta_analysis_each_outcome$lower.random),2)), " to ", sprintf("%.2f", round(exp(meta_analysis_each_outcome$upper.random),2)), ")")
                                )
                              )}
                              if (MA_plan_each_outcome$`Effect measure` == "ROM") {
                                output_each_outcome <- paste0(output_each_outcome, "\nPlease note that the standard error of missing studies was not adjusted for sample size.")
                              }
                            } else {
                              output_each_outcome <- 'There is no data for suitable analysis of data for this outcome.'
                            }
                          }
                        } else {
                          output_each_outcome <- 'The entry in the "Are more events or higher value better or worse for participants?" is not recognised. The only acceptable values are "Better" and "Worse".'
                        }  
                      } else {
                        output_each_outcome <- 'The outcome type is not recognised. The outcome types should be one of "Binary", "Count", "Continuous", "Time", "Summary_Ratio", or "Summary_Difference".'
                      }
                    } else {
                      output_each_outcome <- "There is no meta-analysis plan for this outcome."
                    }
                  } else {
                    output_each_outcome <- "There is no data for this outcome."
                  }
                  return(output_each_outcome)
                })
                results <- do.call(rbind.data.frame, results)
                results <- cbind.data.frame(
                  outcome = outcome_list,
                  results = results
                )
                colnames(results)[2] <- "results"
                output <- list(
                  results = results,
                  completion_status = "Successful"
                )
              } else {
                output <- list(
                  message = 'There is no meta-analysis plan for the outcomes with studies missing because of the results of the outcome.',
                  completion_status = "Unsuccessful"
                )  
              }
            } else {
              output <- list(
                message = 'There are no outcomes with studies missing because of the results of the outcome.',
                completion_status = "Unsuccessful"
              )  
            }
          } else {
            output <- list(
              message = 'There is no data for meta-analysis.',
              completion_status = "Unsuccessful"
            )
          }
        } else {
          output <- list(
            message = 'There are no studies missing because of the results of the outcome.',
            completion_status = "Unsuccessful"
          )
        }
      } else {
        output <- list(
          message = 'The file uploaded does not have any data.',
          completion_status = "Unsuccessful"
        )
      }
    } else {
      output <- list(
        message = 'The meta-analysis plan uploaded in not in correct format. Please upload a plan prepared using this program.',
        completion_status = "Unsuccessful"
      )    
    }
  } else {
    output <- list(
      message = 'The data file uploaded in not in correct format.
      The column names should be exactly "Outcome name", "Type of outcome", "Are more events or higher value better or worse for participants?", "Study", "Intervention (total number of participants)", "Control (total number of participants)", "Parameter1", "Parameter2", "Parameter3", "Parameter4", "missing_study", "missing_outcome", "missing_n_intervention", and "missing_n_comparator".',
      completion_status = "Unsuccessful"
    )
  }
  return(output)
}
# Choices ####
FirstSelection <- c(
  "View instructions",
  "View Main menu",
  "Instructions (Intervention review)",
  "Upload new data, view, modify, and run meta-analysis (Intervention review)",
  "View and download results (Intervention review)",
  "Combine database searches and highlight keywords",
  "Create data extraction form",
  "Perform optical character recognition (OCR)",
  "Data extraction from plots",
  "Process data (Intervention review)",
  "Interpret data (Intervention review)"
)
MainHeaderSelection <- c(
  '<h2 style = "color:maroon"><b>Instructions</b></h2>',
  '<h2 style = "color:maroon"><b>Main menu</b></h2>',
  '<h2 style = "color:maroon"><b>Meta-analysis in systematic reviews of intervention</b></h2>',
  '<h2 style = "color:maroon"><b>Meta-analysis in systematic reviews of intervention</b></h2>
  <h2 style = "color:darkgreen">Upload new data, view, modify, and run meta-analysis</b></h2>',
  '<h2 style = "color:maroon"><b>Meta-analysis in systematic reviews of intervention</b></h2>
  <h2 style = "color:darkgreen">View and download results</b></h2>',
  '<h2 style = "color:maroon"><b>Combine database searches and highlight keywords</b></h2>',
  '<h2 style = "color:maroon"><b>Create data extraction form</b></h2>',
  '<h2 style = "color:maroon"><b>Perform optical character recognition (OCR)</b></h2>',
  '<h2 style = "color:maroon"><b>Data extraction from plots</b></h2>',
  '<h2 style = "color:maroon"><b>Process data</b></h2>',
  '<h2 style = "color:maroon"><b>Interpret data</b></h2>'
)
DEF_Plan_IntChoice <- c(
  "I want to upload my own Data extraction form plan that I have prepared previously for intervention reviews",
  "I want to create a new Data extraction form plan for intervention reviews"
)
MetaAnalysisPlanChoice_Int <- c(
  "I want to use the default plan for meta-analysis of interventions (available below)",
  "I want to use the RevMan plan for meta-analysis of interventions (available below)",
  "I want to use my own meta-analysis plan that I have prepared previously for intervention reviews using this programme without any modifications",
  "I want to use my own meta-analysis plan that I have prepared previously for intervention reviews using this programme after modifying it",
  "I want to modify the default plan (available below for intervention reviews) and use the modified plan in the future if necessary",
  "I want to modify the RevMan plan (available below for intervention reviews) and use the modified plan in the future if necessary"
)
EffectMeasure_Binary_Choice <- c("Odds ratio", "Risk ratio", "Risk difference")
EffectMeasure_Binary_Choice_Converter <- c("OR", "RR", "RD")
EffectMeasure_Continuous_Choice <- c("Mean difference", "Standardised mean difference","Ratio of means")
EffectMeasure_Continuous_Choice_Converter <- c("MD","SMD","ROM")
EffectMeasure_Count_Choice <- c("Rate ratio")
EffectMeasure_Count_Choice_Converter <- c("IRR")
EffectMeasure_Ratio_Choice <- c("Odds ratio", "Risk ratio", "Rate ratio", "Hazard ratio", "Ratio of means")
EffectMeasure_Ratio_Choice_Converter <- c("OR", "RR", "IRR", "HR", "ROM")
EffectMeasure_Difference_Choice <- c("Mean difference", "Standardised mean difference","Risk difference")
EffectMeasure_Difference_Choice_Converter <- c("MD","SMD","RD")

RareEvents_Correction_Choice <- c("Continuity correction with 0.5 for events and no events", "Continuity correction with 0.5 for events only")
RareEvents_Method_Choice <- c("Generalised Linear Mixed Model (only for odds ratios)", "Peto odds ratio (odds ratio and fixed-effect model only)", "Perform the meta-analysis with continuity correction")
FixedEffect_Choice <- c("Yes","No")
PredictionInterval_Choice <- c("Yes","No")
HKAdjustment_Choice <- c("Yes","No")
MA_Method_Binary_Choice <- c("Mantel-Haenszel","Inverse variance") 
MA_Method_Binary_Choice_Converter <- c("MH","Inverse") 
MA_Method_SMD_Choice <- c("Hedges's g with exact SMD", "Hedges's g with approximate SMD","Cohen's d with exact SMD","Cohen's d with approximate SMD", "Glass' delta with control group standard deviation", "Glass' delta with intervention group standard deviation")
MA_Method_SMD_Choice_Converter <- c("Hedges_TRUE","Hedges_FALSE","Cohen_TRUE","Cohen_FALSE","Glass_sd.c","Glass_sd.e")
Metabias_Any_Choice <- c("Begg", "Egger", "Thompson", "Harbord")
Metabias_Heterogeneity_Choice <- c("Begg", "Egger", "Thompson", "Harbord", "Arcsine-Begg", "Arcsine-Egger", "Arcsine-Thompson")
Metabias_Heterogeneity_Choice_Converter <- c("None_Begg", "None_Egger", "None_Thompson", "None_Harbord", "ASD_Begg", "ASD_Egger", "ASD_Thompson")

# Storage folder
StorageFolder <- tempdir()
SampleData_Int <- read.csv("SampleData_Intervention.csv", header = TRUE, check.names = FALSE)
SampleMetaAnalysisPlan_Int <- read.csv("SampleMetaAnalysisPlan_Intervention.csv", header = TRUE, check.names = FALSE)
# Reference screener
database <- c(
  "PubMed", "MEDLINE", "EMBASE", "WOS", "Cochrane", "CTgov", "ICTRP"
)

# OCR languages
ocr.languages <- data.frame(cbind(
  c("Chinese", "Danish", "German", "English", "Persian", "French", "Italian", "Japanese", "Korean", "Dutch", "Norwegian", "Polish", "Portugese", "Russian", "Spanish", "Thai", "Ukraine"),
  c("chi_sim", "dan", "deu", "eng", "fas", "fra", "ita", "jpn", "kor", "nld", "nor", "pol", "por", "rus", "spa", "swe", "ukr")
))
colnames(ocr.languages) <- c("Language", "Engine")
ocr.languages <- ocr.languages[order(ocr.languages$Language),]

# Lists for extracting data from plots ####
PlotExtract_PlotTypes <- c(
  "Kaplan-Meier Plot in percentages", #1
  "Kaplan-Meier Plot in decimal fractions", #2
  "Box plot", #3
  "Bar plot without error bars", #4
  "Bar plot with error bars", #5
  "Line plot without error bars", #6
  "Line plot with error bars" #7
)
PlotExtract_y_min_y_max_builder_OutputType <- c(
  "sliderInput", #1
  "sliderInput", #2
  "numericInput", #3
  "numericInput", #4
  "numericInput", #5
  "numericInput", #6
  "numericInput" #7
)
PlotExtract_y_min_y_max_builder_min_max_value_min <- c(
  "min = 0, max = 100, value = 0", #1
  "min = 0, max = 1, value = 0", #2
  "value = NA", #3
  "value = NA", #4
  "value = NA", #5
  "value = NA", #6
  "value = NA" #7
)
PlotExtract_y_min_y_max_builder_min_max_value_max <- c(
  "min = 0, max = 100, value = 100", #1
  "min = 0, max = 1, value = 1", #2
  "value = NA", #3
  "value = NA", #4
  "value = NA", #5
  "value = NA", #6
  "value = NA" #7
)
PlotExtract_y_min_y_max_builder_min_max_value_min_change <- c(
  "min = 0, max = 100, value = input$PlotExtract_y_min", #1
  "min = 0, max = 1, value = input$PlotExtract_y_min", #2
  "value = input$PlotExtract_y_min", #3
  "value = input$PlotExtract_y_min", #4
  "value = input$PlotExtract_y_min", #5
  "value = input$PlotExtract_y_min", #6
  "value = input$PlotExtract_y_min" #7
)
PlotExtract_y_min_y_max_builder_min_max_value_max_change <- c(
  "min = 0, max = 100, value = input$PlotExtract_y_max", #1
  "min = 0, max = 1, value = input$PlotExtract_y_max", #2
  "value = input$PlotExtract_y_max", #3
  "value = input$PlotExtract_y_max", #4
  "value = input$PlotExtract_y_max", #5
  "value = input$PlotExtract_y_max", #6
  "value = input$PlotExtract_y_max" #7
)
PlotExtract_y_min_y_max <- paste0(
  'output$PlotExtract_y_min_UI <- renderUI(',
  PlotExtract_y_min_y_max_builder_OutputType,
  '("PlotExtract_y_min", "Choose the minimum y value in the plot",',
  PlotExtract_y_min_y_max_builder_min_max_value_min,
  ')); output$PlotExtract_y_max_UI <- renderUI(',
  PlotExtract_y_min_y_max_builder_OutputType,
  '("PlotExtract_y_max", "Choose the maximum y value in the plot",',
  PlotExtract_y_min_y_max_builder_min_max_value_max,
  '))'
)
PlotExtract_y_min_y_max[c(1:2)] <- paste0(
  'output$PlotExtract_x_min_UI <- renderUI(',
  'numericInput',
  '("PlotExtract_x_min", "Choose the minimum x value in the plot",',
  'min = 0, value = NA',
  ')); output$PlotExtract_x_max_UI <- renderUI(',
  'numericInput',
  '("PlotExtract_x_max", "Choose the maximum x value in the plot",',
  'min = 0, value = NA',
  '))',
  '; ',
  PlotExtract_y_min_y_max[c(1:2)]
) 
PlotExtract_y_min_y_max[c(6:7)] <- paste0(
  'output$PlotExtract_x_min_UI <- renderUI(',
  'numericInput',
  '("PlotExtract_x_min", "Choose the minimum x value in the plot",',
  'value = NA',
  ')); output$PlotExtract_x_max_UI <- renderUI(',
  'numericInput',
  '("PlotExtract_x_max", "Choose the maximum x value in the plot",',
  'value = NA',
  '))',
  '; ',
  PlotExtract_y_min_y_max[c(6:7)]
) 
PlotExtract_y_min_y_max_change <- paste0(
  'output$PlotExtract_y_min_UI <- renderUI(',
  PlotExtract_y_min_y_max_builder_OutputType,
  '("PlotExtract_y_min", "Choose the minimum y value in the plot",',
  PlotExtract_y_min_y_max_builder_min_max_value_min_change,
  ')); output$PlotExtract_y_max_UI <- renderUI(',
  PlotExtract_y_min_y_max_builder_OutputType,
  '("PlotExtract_y_max", "Choose the maximum y value in the plot",',
  PlotExtract_y_min_y_max_builder_min_max_value_max_change,
  '))'
)
# Add x_min and x-max for KM curves and line plots
PlotExtract_y_min_y_max_change[c(1:2)] <- paste0(
  'output$PlotExtract_x_min_UI <- renderUI(',
  'numericInput',
  '("PlotExtract_x_min", "Choose the minimum x value in the plot",',
  'min = 0, value = input$PlotExtract_x_min',
  ')); output$PlotExtract_x_max_UI <- renderUI(',
  'numericInput',
  '("PlotExtract_x_max", "Choose the maximum x value in the plot",',
  'min = 0, value = input$PlotExtract_x_max',
  '))',
  '; ',
  PlotExtract_y_min_y_max_change[c(1:2)]
) 
PlotExtract_y_min_y_max_change[c(6:7)] <- paste0(
  'output$PlotExtract_x_min_UI <- renderUI(',
  'numericInput',
  '("PlotExtract_x_min", "Choose the minimum x value in the plot",',
  'value = input$PlotExtract_x_min',
  ')); output$PlotExtract_x_max_UI <- renderUI(',
  'numericInput',
  '("PlotExtract_x_max", "Choose the maximum x value in the plot",',
  'value = input$PlotExtract_x_max',
  '))',
  '; ',
  PlotExtract_y_min_y_max_change[c(6:7)]
) 

PlotExtract_Points_EachGroup_EachTimePoint <- c(
  1, 1, 3, 1, 3, 1, 3
)
PlotExtract_Points_Names_EachGroup_EachTimePoint <- list(
  c("Proportion survived"),
  c("Proportion survived"),
  c("mean or median","lower quartile", "upper quartile"),
  c("mean"),
  c("mean", "lower limit","upper limit"),
  c("mean"),
  c("mean", "lower limit","upper limit")
)

PlotClick_Yes <- c(
  'output$PlotExtract_UploadedPlot_UI <- renderUI(
        plotOutput("PlotExtract_UploadedPlot", click = "Plot_Click"),
      )
  '  
)
PlotClick_No <- c(
  '    output$PlotExtract_UploadedPlot_UI <- renderUI(
        plotOutput("PlotExtract_UploadedPlot"),
      )
  '  
)
KM_Min_Max_Question_1_Choice <- c(
  "days",
  "months",
  "years"
)
KM_Min_Max_Question_2_Choice <- c(
  "Minimum and maximum follow-up directly reported in the trial",
  "Median follow-up and recruitment duration",
  "Date of analysis, date of first recruitment, and last recruitment",
  "Data of submission, date of first recruitment, and last recruitment",
  "I do not have any of the information above or ticks in the KM curve"
)
KM_Min_Max_Questions_3_5 <- c(
  'output$PlotExtract_KM_Min_Max_Question_3_UI <- renderUI(
      numericInput("PlotExtract_KM_Min_Max_Question_3",
                   "Enter the minimum follow-up",
                   min = 0,
                   value = NA)
    );
    output$PlotExtract_KM_Min_Max_Question_4_UI <- renderUI(
      numericInput("PlotExtract_KM_Min_Max_Question_4",
                   "Enter the maximum follow-up",
                   min = 0,
                   value = NA)
    );
    output$PlotExtract_KM_Min_Max_Question_5_UI <- NULL', # Choice 1 of KM_Min_Max_Question_2_Choice
  'output$PlotExtract_KM_Min_Max_Question_3_UI <- renderUI(
      numericInput("PlotExtract_KM_Min_Max_Question_3",
                   "Enter the median follow-up",
                   min = 0,
                   value = NA)
    );
    output$PlotExtract_KM_Min_Max_Question_4_UI <- renderUI(
      numericInput("PlotExtract_KM_Min_Max_Question_4",
                   "Enter the recruitment duration",
                   min = 0,
                   value = NA)
    ); 
    output$PlotExtract_KM_Min_Max_Question_5_UI <- NULL', # Choice 2 of KM_Min_Max_Question_2_Choice
  'output$PlotExtract_KM_Min_Max_Question_3_UI <- renderUI(
      dateInput("PlotExtract_KM_Min_Max_Question_3",
                   "Enter the date of analysis (if only the month and year are reported, choose 15 as the date)",
                   format = "yyyy-mm-dd",
                   startview = "month",
                   value = Sys.Date(),
                   max = Sys.Date())
    );
    output$PlotExtract_KM_Min_Max_Question_4_UI <- renderUI(
      dateInput("PlotExtract_KM_Min_Max_Question_4",
                   "Enter the date of first recruitment (if only the month and year are reported, choose 15 as the date)",
                   format = "yyyy-mm-dd",
                   startview = "month",
                   value = Sys.Date(),
                   max = Sys.Date())
    ); 
    output$PlotExtract_KM_Min_Max_Question_5_UI <- renderUI(
      dateInput("PlotExtract_KM_Min_Max_Question_5",
                   "Enter the date of last recruitment (if only the month and year are reported, choose 15 as the date)",
                   format = "yyyy-mm-dd",
                   startview = "month",
                   value = Sys.Date(),
                   max = Sys.Date())
    )', # Choice 3 of KM_Min_Max_Question_2_Choice
  'output$PlotExtract_KM_Min_Max_Question_3_UI <- renderUI(
      dateInput("PlotExtract_KM_Min_Max_Question_3",
                   "Enter the date of submission (if only the month and year are reported, choose 15 as the date)",
                   format = "yyyy-mm-dd",
                   startview = "month",
                   value = Sys.Date(),
                   max = Sys.Date())
    );
    output$PlotExtract_KM_Min_Max_Question_4_UI <- renderUI(
      dateInput("PlotExtract_KM_Min_Max_Question_4",
                   "Enter the date of first recruitment (if only the month and year are reported, choose 15 as the date)",
                   format = "yyyy-mm-dd",
                   startview = "month",
                   value = Sys.Date(),
                   max = Sys.Date())
    ); 
    output$PlotExtract_KM_Min_Max_Question_5_UI <- renderUI(
      dateInput("PlotExtract_KM_Min_Max_Question_5",
                   "Enter the date of last recruitment (if only the month and year are reported, choose 15 as the date)",
                   format = "yyyy-mm-dd",
                   startview = "month",
                   value = Sys.Date(),
                   max = Sys.Date())
    )', # Choice 4 of KM_Min_Max_Question_2_Choice
  'output$PlotExtract_KM_Min_Max_Question_3_UI <- NULL; 
    output$PlotExtract_KM_Min_Max_Question_4_UI <- NULL; 
    output$PlotExtract_KM_Min_Max_Question_5_UI <- NULL'# Choice 5 of KM_Min_Max_Question_2_Choice
)

# Lists for processing data ####
Process_Int_Menu_Choice <- list(
  `Make your selection` = c(""),
  `Process data extraction form` = c("",
                                     "Process data extraction form prepared using this program (works only on local version)"),
  `Compare unstructured data` = c("",
                                  "Compare data in data extraction forms NOT prepared using this program"),
  `Convert signalling questions to risk of bias classifications`= c(
    "Risk of bias tool: RoB 2 (Randomised controlled trials)",
    "Risk of bias tool: ROB 2 - Cluster (Cluster randomised controlled trials)",
    "Risk of bias tool: ROB 2 - Cross-over (Cross-over randomised controlled trials)",
    "Risk of bias tool: ROBINS-I (Non-randomised studies of intervention)"
  ),
  `Convert to meta-analysis format (Batch conversions)` = c("",
                                                            "Convert extracted data to a format suitable for meta-analysis"),
  `Convert to meta-analysis format (Single conversions)` = c(
    "Calculate number with event from percentage with event",
    "Calculate standard deviation from standard error",
    "Calculate standard deviation from confidence intervals",
    "Calculate standard deviation from quartiles",
    "Calculate standard deviation from range",
    "Calculate standard deviation from means and p-value",
    "Calculate rate ratio from counts with equal follow-up time in the two groups",
    "Calculate rate ratio from counts with unequal follow-up time in the two groups",
    "Calculate ln ratios and their standard errors from ratios and confidence intervals of effect estimates (ratios including hazard ratios)",
    "Calculate standard errors from confidence intervals of effect estimates (differences)",
    "Calculate standard errors from point estimate and p-value (ratios)",
    "Calculate standard errors from point estimate and p-value (differences)",
    "Calculate ln hazard ratio and its standard error from hazard ratio, number of events in both groups, and number of participants",
    "Calculate ln hazard ratio and its standard error from number of events in both groups, number of participants, and p-value",
    "Calculate minimum and maximum follow-up from median follow-up and recruitment period",
    "Calculate minimum and maximum follow-up from analysis date and recruitment period",
    "Calculate minimum and maximum follow-up from submission date and recruitment period",
    "Calculate ln hazard ratio and its standard error from proportion with no events (descending KM curves)",
    "Calculate ln hazard ratio and its standard error from proportion with events (ascending KM curves)"
  ),
  `Dealing with multi-arm trials` = c(
    "Split intervention (or comparator) into multiple groups in multi-armed trials (binary and count data)",
    "Split intervention (or comparator) into multiple groups in multi-armed trials (continuous data)"    
  ),
  `Processing data from cluster and cross-over trials` = c(
    "Calculate design effect for cluster trials",
    "Adjust for cluster effect (binary outcomes)",
    "Adjust for cluster effect (continuous outcomes)",
    "Adjust for cluster effect (summary measures)",
    "Calculate standard deviation of within-participant differences from individual participant data",
    "Calculate correlation coefficient from standard deviation of within-participant differences and standard deviations of intervention and comparator",
    "Calculate mean difference and standard deviation from correlation coefficient, means and standard deviations of intervention and comparator",
    "Calculate mean difference and its standard error from the standard deviation of within-participant differences, means and standard deviations of intervention and comparator"
  ),
  `Convert between effect measures` = c(
    "Convert odds ratios to risk ratios",
    "Convert risk ratios to odds ratios",
    "Convert odds ratios to standardised mean difference",
    "Convert risk ratios to standardised mean difference"
  )
)
Process_Int_input <- list()
Process_Int_input <- lapply(1:6, function(x) Process_Int_input[[x]] <- NA) 

# Lists for interpreting data ####
Interpret_Int_Menu_Choice <- list(
  `Make your selection` = c(""),
  `Clinical interpretation` = c(
    "From confidence intervals of the effect estimate and the minimal important difference (single outcome: ratios)",
    "From confidence intervals of the effect estimate and the minimal important difference (single outcome: differences)",
    "From confidence intervals of the effect estimate and the minimal important difference (multiple outcomes)"
  ),
  `Help in ICEMAN tool assessments` = c(
    "Is the effect modification similar across studies with within-study data",
    "P-value adjustment for multiple testing"
  ),
  `Risk Of Bias due to Missing Evidence in a synthesis (ROB-ME)`= c(
    "Studies reporting each outcome", 
    "ROB-ME Signalling question 4.2: Find the most favourable results for a study and perform a sensitivity analysis imputing results for missing study",
    "Classifications from signalling questions"
  ),
  `Help in GRADE assessments` = c(
    "Risk of bias of studies included in the meta-analysis (unweighted)",
    "Sample size calculations from study data (binary outcome and continuous outcomes)",
    "Sample size calculations for time-to-event outcomes from hazard ratios",
    "Find if the magnitude of effect was large or very large (for ratios) (single outcome)",
    "Find if the magnitude of effect was large or very large (for ratios) (multiple outcomes)"
  ),
  `Help in calculating means and medians in comparator group` = c("",
                                                                  "Calculate comparator group proportions, rates, and means"
  ),
  `Convert ratios to differences` = c(
    "Convert ratios to differences (meta-analysis results and risk or hazard in comparator group) (single outcome)",
    "Convert ratios to differences (meta-analysis results and rate in comparator group) (single outcome)",
    "Convert ratios to differences (meta-analysis results and risk, hazard, or rate in comparator group) (multiple outcomes)"
  )
)
Interpret_Int_Effect_Estimate <- c("Odds ratio", "Risk ratio", "Risk difference", "Mean difference", "Standardised mean difference", "Rate ratio", "Hazard ratio")
Interpret_Int_input <- list()
Interpret_Int_input <- lapply(1:6, function(x) Interpret_Int_input[[x]] <- NA)
# Instructions ####
Instructions <- ('
<h3 style = "font-size:24px; color:purple;"><b>Instructions</b></h3>
<li>This programme performs the following functions: </li>
<ul>
<li><b>Perform meta-analysis in systematic reviews of interventions.</b></li>
<li><b>Combine search results from databases and highlight keywords.</b></li>
<li><b>Create a customised data extraction form.</b> <i>Because of memory constraints, this is possible only on a local version. 
You can download the program code to run a local version.</i></li>
<li><b>Optical character recognition (OCR) of English and non-English images and pdf files to allow online translation.</b></li>
<li><b>Extract data from plots.</b></li>
<li><b>Process data.</b> This includes comparison of data, conversion of data into a suitable format and converting signalling questions to risk of bias classifications.</li>
<li><b>Interpret data.</b> This includes obtaining information to help with GRADE classifications and interpretation in terms of clinical significance (rather than statistical significance)</li>
</ul>
<li>Click on <strong>"View Main Menu"</strong> on the left side panel to access the different functions of this application.</li>
<li>The instructions for each of these functions can be found under the relevant functions.</li>
')
Instructions_Int <- ('
                     <h3 style = "font-size:24px; color:purple;"><b>Instructions for performing meta-analysis in systematic review of inteventions</b></h3>
This version supports analysis of about 30 outcomes.
<h3><b><i>Preparation of data</i></b></h3>
<p>
<ul>
<p><b><i>Manual preparation of data</i></b></p>
<ul>
<li>The first 28 fields should be in the same order and should have the same field names as the template regardless of which outcomes you want to analyse or which data you have collected. 
For example, even if you do not use continuous outcomes, you should include the field names applicable only for continuous outcomes and in the same order. 
</li>
<li>For each outcome, please indicate the fields below. 
The mandatory fields are indicated as "[Mandatory]". If these fields are not provided in the correct format, the study will be excluded from the analysis. 
The optional fields are indicated as "[Optional]", but may be required for additonal analyses and presentation of information.</li>
<ul>
<li><b>Column 1</b>: Outcome name [Mandatory]: This is any name that you want to give to the outcome.</li>
<li><b>Column 2</b>: Type of outcome [Mandatory]: This should be one of the following six types: "Binary", "Continuous","Count","Time","Summary_Ratio","Summary_Difference". For which type of outcome you should choose, please see here.</li> 
<li><b>Column 3</b>: Are more events or higher value better or worse for participants? [Mandatory]: The choices are "Better", "Worse".</li> 
<li><i>The "Outcome name", "Type of outcome", and "Are more events or higher value better or worse for participants?" need to be specified only for the first row for each new outcome.</i></li>
<li><b>Column 4</b>: Study [Mandatory]: This can be the name of the study. This is usually the last name of the first author and followed by the year of publication indicated as YYYY. 
Year can be used for some aspects of meta-analysis.</li>
<li><b>Column 5</b>: Intervention (total number of participants) [Mandatory for "Binary" and "Continuous" outcomes and optional for remaining outcomes]: This is the total number of participants for the intervention group.</li> 
<li><b>Column 6</b>: Control (total number of participants) [Mandatory for "Binary" and "Continuous" outcomes and optional for remaining outcomes]: This is the total number of participants for the control group.</li>
<li><b>Column 7</b>: Parameter1 [Mandatory]: This varies according to outcomes.</li>
<ul>
<li>"Binary" outcomes: number of participants with outcome (event) in the intervention group</li>
<li>"Continuous" outcomes: Mean in intervention group</li>
<li>"Count" outcomes: Ln (natural logarithm) rate ratio</li>
<li>"Time" outcomes: Ln hazard ratio</li>
<li>"Summary_Ratio" outcomes: Ln odds ratio or Ln risk ratio</li>
<li>"Summary_Difference" outcomes: Mean difference, Standardised mean difference, or risk difference</li>
</ul>
<li><b>Column 8</b>: Parameter2 [Mandatory]: This varies according to outcomes.</li>
<ul>
<li>"Binary" outcomes: number of participants with outcome (event) in the control group</li>
<li>"Continuous" outcomes: Standard deviation in intervention group. 
If standard deviation is missing and cannot be imputed from any information in the trial, please leave this empty. 
If left empty, standard deviation in the study will be imputed as the maximum standard deviation in the remaining trials.</li>
<li>"Count" outcomes: Standard error of Ln rate ratio</li>
<li>"Time" outcomes: Standard error of Ln hazard ratio</li>
<li>"Summary_Ratio" outcomes: Standard error of effect measure used in column 8, i.e., Ln odds ratio or Ln risk ratio</li>
<li>"Summary_Difference" outcomes: Standard error of effect measure used in column 8, i.e., Mean difference, Standardised mean difference, or risk difference</li>
</ul>
<li><b>Column 9</b>: Parameter3 [Mandatory] for "Continuous" outcomes and not applicable for remaining outcome types: Mean in control group </li>
<li><b>Column 10</b>: Parameter4 [Mandatory] for "Continuous" outcomes and not applicable for remaining outcome types: Standard deviation in intervention group.
As for column 9, if standard deviation cannot be imputed and the field is left empty, standard deviation in the study will be imputed as the maximum standard deviation in the remaining trials.
</li>
<li><b>Column 11</b>: Units (Continuous outcomes) [Optional]: As the name indicates, this is applicable only for continuous outcomes. 
There are some continuous outcomes which do not have units.
This needs to be specified only for the first row of each continuous outcome.
</li> 
<li><b>Column 12</b>: Scale (Continuous outcomes) [Optional]: If the Continuous outcome is measured using different scales, then indicate the scale used in the study. 
If different scales are used, standardised mean difference will be calculated. If the same scale is used in all the studies or if left empty, mean difference will be calculated for continuous outcomes as default.
</li>
<li><b>Column 13</b>: Mean or standard deviation imputed (Continuous outcomes) [Optional]: If you have imputed the mean or standard deviation or both from other measures, 
you must perform a sensitivity analysis excluding such studies in which mean or standard deviation are imputed. Enter "1" in the study row if you have imputed the mean or standard deviation.
</li>
<li><b>Column 14</b>: Missing failure (Intervention)	[Optional]: This is applicable only for "Binary" and "Continuous" outcomes.
This indicates exclusion of participants in intervention group from analysis after randomisation because of reasons such as 
lack of therapeutic benefit, relapse, or worsening of symptoms which indicate failure of treatment.
</li>
<li><b>Column 15</b>: Missing success (Intervention)	[Optional]: This is applicable only for "Binary" and "Continuous" outcomes.
This indicates exclusion of participants in intervention group from analysis after randomisation because of reasons such as 
cure or positive response which indicate success of treatment. This is not an usual reason of exclusion from studies.
</li>
<li><b>Column 16</b>: Missing unrelated (Intervention)	[Optional]: This is applicable only for "Binary" and "Continuous" outcomes.
This indicates exclusion of participants in intervention group from analysis after randomisation because of reasons such as 
loss to follow-up or administrative error which are are unrelated to success or failure of treatment.
</li>
<li><b>Column 17</b>: Missing protocol violation (Intervention)	[Optional]: This is applicable only for "Binary" and "Continuous" outcomes.
This indicates exclusion of participants in intervention group from analysis after randomisation because of reasons such as 
protocol violation, non-compliance, adverse events where the excluded participants receive the control.
When the participants do not receive the control (mainly applicable in comparisons where the two groups have different active interventions), use Missing other to record the exclusions.
</li>
<li><b>Column 18</b>: Missing other (Intervention)	[Optional]: This is applicable only for "Binary" and "Continuous" outcomes.
This indicates exclusion of participants in intervention group from reasons not covered in the previous reasons for missing.
</li>
<li><b>Column 19</b>: Missing reasons not stated (Intervention)	[Optional]: This is applicable only for "Binary" and "Continuous" outcomes.
Record the missing data under this category when the reasons for missing in the intervention group are not reported.
</li>
<li><b>Column 20</b>: Missing not stated (Intervention)	[Mandatory]: This is applicable only for "Binary" and "Continuous" outcomes.
When it is not clear whether any participants in the intervention group were excluded from the analysis, indicate "Not stated". 
If it is clear that all participants were included in the analysis, you can enter "0". 
If you leave this column empty or enter any text, this will be treated as "Not stated". 
</li>
<li><b>Column 21</b>: Missing failure (Control)	[Optional]: This is applicable only for "Binary" and "Continuous" outcomes.
This indicates exclusion of participants in control group from analysis after randomisation because of reasons such as 
lack of therapeutic benefit, relapse, or worsening of symptoms which indicate failure of treatment.
</li>
<li><b>Column 22</b>: Missing success (Control)	[Optional]: This is applicable only for "Binary" and "Continuous" outcomes.
This indicates exclusion of participants in control group from analysis after randomisation because of reasons such as 
cure or positive response which indicate success of treatment. This is not an usual reason of exclusion from studies.
</li>
<li><b>Column 23</b>: Missing unrelated (Control)	[Optional]: This is applicable only for "Binary" and "Continuous" outcomes.
This indicates exclusion of participants in control group from analysis after randomisation because of reasons such as 
loss to follow-up or administrative error which are are unrelated to success or failure of treatment.
</li>
<li><b>Column 24</b>: Missing protocol violation (Control)	[Optional]: This is applicable only for "Binary" and "Continuous" outcomes.
This indicates exclusion of participants in intervention group from analysis after randomisation because of reasons such as 
protocol violation, non-compliance, adverse events where the excluded participants receive the intervention.
When the participants do not receive the intervention, use Missing other to record the exclusions.
</li>
<li><b>Column 25</b>: Missing other (Control)	[Optional]: This is applicable only for "Binary" and "Continuous" outcomes.
This indicates exclusion of participants in control group from reasons not covered in the previous reasons for missing.
</li>
<li><b>Column 26</b>: Missing reasons not stated (Control)	[Optional]: This is applicable only for "Binary" and "Continuous" outcomes.
Record the missing data under this category when the reasons for missing in the control group are not reported.
</li>
<li><b>Column 27</b>: Missing not stated (Control)	[Mandatory]: This is applicable only for "Binary" and "Continuous" outcomes.
When it is not clear whether any participants were excluded from the analysis, indicate "Not stated". 
If it is clear that all participants in the control group were included in the analysis, you can enter "0". 
If you leave this column empty or enter any text, this will be treated as "Not stated". 
</li>
<li><b>Column 28</b>: Intervention and control details for graphs [Optional]: Only the first 4 rows (after the heading) will be considered. Please insert the following.</li>
<ul>
<li>Row 1 after heading: Intervention full name</li>
<li>Row 2 after heading: Intervention short name</li>
<li>Row 3 after heading: Control full name</li>
<li>Row 4 after heading: Control short name</li>
</ul>
<li><b>Column 29 onwards</b> Effect modifiers (moderator) [Optional]: Any categorical variables (subgroups) or other quantitative variables (for example, mean age in trials) that you want to use for metaregression. 
Please note that any categorical variables should be entered as text and not as numbers, i.e., enter the subgroups without any coding for this to be treated as categorical variable. 
A maximum of 10 variables are supported.
</li>
</ul>
</ul>
</ul>
<ul>
<p><b><i>Export from data extraction form</i></b></p>
<ul>
<li>You can also export the data in a suitable format from the data extraction form from the sheet "Equal" by clicking on "Export data" and saving it in a suitable folder.</li>
<li>Please consider the following changes to the data that you saved.</li>
<ul>
<li>All the outcomes are labelled as "Worse" in the Column 3.
If higher value of an outcome is better for the participant, then change this to "Better"</li>
<li>If some participants have missing values, please revise columns 14 to 27 as appropriate.</li>
<li>In the meta-analysis plan, please alter the effect measures as appropriate.
Otherwise, default effect measures will be used regardless of what was used in the ReviewManager.</li>
</ul>
</ul>
<p><b><i>Export from Review Manager 5</i></b></p>
<ul>
<li>You can also convert Review Manager 5 (RevMan 5) data into a suitable format by performing the following steps.</li>
<li>First, add an empty outcome at the end of the last comparison. This is to work around a bug in RevMan which exports the last outcome as a subgroup even if there is no subgroup.</li>
<li>Next, from ReviewManager, choose File>Export>Data and analyses</li>
<li>In the resulting screen, ensure that "Data and analyses" box is selected and the "Risk of bias tables" is unselected.</li>
<li>Click Next.</li>
<li>In the resulting screen, select Comparison Number, Outcome Number, and Subgroup Number in addition to the default selection.</li>
<li>Click Next.</li>
<li>Retain the default selections and click "Finish".</li>
<li>In the resulting screen, choose the appropriate folder to save the file.</li>
<li>Now upload this file in the side panel where there is a place to upload the data exported from RevMan 5.</li>
<li>Please download the prepared data and consider the following changes.</li>
<ul>
<li>All the outcomes are labelled as "Worse" in the Column 3.
If higher value of an outcome is better for the participant, then change this to "Better"</li>
<li>If some participants have missing values, please revise columns 14 to 27 as appropriate.</li>
<li>In the meta-analysis plan, please alter the effect measures as appropriate.
Otherwise, default effect measures will be used regardless of what was used in the ReviewManager.</li>
</ul>
</ul>
</p>
<p><b><i>Export from RevMan Web</i></b></p>
<ul>
<li>You can also convert RevMan Web data into a suitable format by performing the following steps.</li>
<li>First, log in to RevMan Web and open the review.</li>
<li>Next, scroll down to "History" and select the version that you want to export data from.</li>
<li>Next, click on "Export" button (the button is just below "History" and becomes active once you select a version to export).</li>
<li>In the resulting screen, select "All analyses CSV" and click on "Generate export package".</li>
<li>If you have the right to download data, an export package is generated and is available under "Downloads".</li>
<li>Download the export package. This is usually available in the "Downloads" folder.</li>
<li>Unzip the export package.</li>
<li>The file that is to be used for import is "CD......-data-rows.csv" (the dots indicate the Cochrane CD number).</li>
<li>Since the export package file has another zip folder, the "CD......-data-rows.csv" file must be stored in a specific location before it can be used.
Therefore, copy the file to an appropriate location.</li>
<li>Now upload this file in the side panel where there is a place to upload the data exported from RevMan Web.</li>
<li>Please download the prepared data and consider the following changes.</li>
<ul>
<li>All the outcomes are labelled as "Worse" in the Column 3.
If higher value of an outcome is better for the participant, then change this to "Better"</li>
<li>If some participants have missing values, please revise columns 14 to 27 as appropriate.</li>
<li>In the meta-analysis plan, please alter the effect measures as appropriate.
Otherwise, default effect measures will be used regardless of what was used in the ReviewManager.</li>
</ul>
</ul>
</p>
<h3><b><i>Meta-analysis plan</i></b></h3>
<p>
<ul>
<li>You can either accept the <b>Default meta-analysis plan</b> (the rationale for this choice is provided here), the <b>RevMan meta-analysis plan</b>, 
or upload your own meta-analysis plan prepared with this program.
</li>
<li>If you change your outcome name, delete or add new outcomes to your data, you need to prepare a new meta-analysis plan</li>
<li>The default effect measures used are as follows: </li>
<ul>
<li>Binary: Odds Ratio</li>
<li>Continuous: Mean difference if single scale is used and standardised mean difference if multiple scales are used</li>
<li>Count: Rate ratio</li>
<li>Time: Hazard ratio</li>
</ul>
<li>The data synthesis methods used for the <b>Default plan</b> are as follows:
<ul>
<li><b>Model</b></li>
<ul>
<li>Random-effects model (normal distribution)</li>
<li>Hartung and Knapp adjusted analysis is used for random-effects model</li>
<li>Fixed-effect model (also called common effects model) is also presented</li>
<li>Prediction interval using Hartung and Knapp adjustment when possible is also presented</li>
</ul>
<li><b>Method</b></li>
<ul>
<li><i>Binary outcomes</i>: Mantel Haenszel method is used as default, 
but if data is sparse (zero event in one or more trials), Generalised Linear Mixed Model (GLMM) with exact likelihood is used.
If there is no convergence with GLMM with exact likelihood, GLMM with approximate likelihood is used.
</li>
<li><i>Continuous outcomes</i>: Inverse variance method is used. 
For standardised mean differences (SMD), Hedges g and exact methods are used for calculation of SMD and its confidence intervals.
</li>
</ul>
<li><b>Funnel plot asymmetry</b></li>
<ul>
<li>Contour enhanced funnel plots are generated for any number of trials.</li> 
<li>The following tests for funnel plot asymmetry are performed when there are 10 or more studies.</li>
<ul>
<i>Binary outcomes</i>: When the tau<sup>2</sup> is < 0.1, Harbord test is used; otherwise Thompson test after arcsine transformation is used.</li>
<li><i>All other outcomes</i>: Egger test is used.</li>
</ul>
</ul>
<li><b>Sensitivity analysis</b></li>
<ul>
<li><i>Binary outcomes</i>: Informative missingness Odds Ratio (IMOR) and best-worst analysis are performed.
The IMOR is calculated based on different reasons.
</li>
<ul>
<li>Missing because of failure: The event is considered not to have happened for a good outcome (more is better for patients)
and to have happened for a bad outcome (less is better for patients).
</li>
<li>Missing because of success: The event is considered to have happened for a good outcome and not happened for a bad outcome.</li>
<li>Missing because of unrelated reasons: The events are considered to happen at the same proportions as the respective groups to which the missing participants belonged.</li>
<li>Missing because of protocol violation (cross-over): The events are considered to happen at the proportions of the oppposite group,
i.e., for missing participants in the intervention group, the event is considered to happen at the same proportion as the control group,
and vice versa.
</li>
<li>Missing because of other reasons: The events are considered to happen at twice the proportions of the respective groups for bad outcomes
and half the proportions of the respective groups for good outcomes.
</li>
<li>Missing with no reasons stated: These are distributed in the same proportions of reasons as in the remaining studies.</li>
<li>Missing unknown: If it is not clear whether participants were excluded, the drop-out proportions in other studies are used to estimate this.</li>
</ul>
<li><i>Continuous outcomes</i>: Missing standard deviations are imputed as the highest standard deviations from the remaining studies. 
Senstivity analysis excluding any studies where mean or standard deviations were imputed from other measures is also performed.
</li>
</ul>
<li><b>Sensitivity analysis</b></li>
<ul>
<li>All moderator variables are included in the analysis.</li>
</ul>
<li><b>Subgroup analysis</b></li>
<ul>
<li>All categorical moderator variables are included in the analysis. 
Only the random-effects model is presented. The variances are allowed to vary by the subgroups.</li>
</ul>
</ul>
<li>The data synthesis methods used for the <b>Revman plan</b> are different from the default plan in the following ways.</li>
<ul>
<li>Dersimonian-Laird model is used for random-effects meta-analysis.</li>
<li>A continuity correction by adding 0.5 to the events and 1 to the number of participants in each group is used when the data is sparse.</li>
<li>For SMD, Hedges d with approximate methods are used for calculating the SMD and confidence intervals.</li>
<li>Prediction intervals are not reported.</li>
</ul>
</ul>
</p>
<h3><b><i>Analysis</i></b></h3>
<p>
<ul>
<li><b>Step 1</b>: Upload the data prepared in the correct format in one of the ways outline previously.</li>
<li><b>Step 2</b>: Use an analysis plan.</li>
<ul>
<li>You can use the <b>Default plan</b> or <b>RevMan plan</b> with or without any modifications 
by choosing the appropriate option once the data has been successfully uploaded.
</li>
<li>We expect majority of the users to use one of these two in-built plans.</li>
<li>Alternatively, you can upload your own plan that you prepared using this program and use it with or without modifications
by choosing the appropriate option once the data has been successfully uploaded.
</li>
<li>If you choose to modify any of these plans, the options for different aspects will appear depending upon the outcome that you choose.</li>
<li>You can modify only the specific outcome or all outcomes that are of the same type as the outcome that you are modifying by clicking on the correct option.</li>
<li>You might want to download the analysis plan, so that you do not need to modify this each time you want to analyse the data.</li>
<li>If you rename, add, or delete outcomes, you will need to create a new plan.</li>
<li>You can run the analysis or choose a different analysis plan at any time.
If you choose this option, any modifications to the plan will be lost.
</li>
</ul>
<li><b>Step 3</b>: Run the analysis.</li>
<ul>
<li>The results are available as results summary and plots which can be downloaded.</li>
</ul>
</ul>
</p>
<h3><b><i>Download the codes to run the analysis in R</i></b></h3>
<p>
<ul>
<li>You can download the codes to run the analysis in R. 
You might want to do this for various reasons, for example, you might want to use the validated R packages to report the analysis in a journal publication.
</li>
<li>You can download the codes at any time (from the left side panel), but only the codes after the analysis is complete will provide you with meaningful codes to run in R.</li>
<li>Once you have run the code in R, the results are organised in the following way.</li>
<ul>
<li>Names of outcomes: Any spaces and special characters such as "(", ")", "!" are replaced by ".". 
For example, if the outcome was "Kidney failure", the altered name will be "Kidney.failure". 
This is to ensure that the outcome names are in a format that makes them compatible with analysis with R software. 
Any reference to outcome name in this section refers to this altered name.
</li>
<li>Main meta-analysis: The main meta-analysis results are stored in a variable formed by combining the term "MetaAnalysis_" with the outcome name. 
For example, "MetaAnalysis_Kidney.failure".</li>
<li>Funnel plot asymmetry (main meta-analysis only): Statistical tests for funnel plot asymmetry are stored in a variable formed by combining the term "Funnel_" with the outcome name. 
For example, "Funnel_Kidney.failure".</li>
<li>Subgroup analysis: The subgroup analysis results are stored in a variable formed by combining the terms "Subgroup_", the moderator variable name (which is also altered in the same way and for the same reasons as for the name of the outcome), and the outcome name.  
For example, for a variable "Age in years" for the outcome kidney failure, 
the results are stored in "Subgroup_Age.in.years_Kidney.failure".</li>
<li>Metagression: The metaregression results are stored in a variable formed by combining the term "Metaregression_" with the outcome name. 
For example, "Metaregression_Kidney.failure".</li>
<li>Sensitivity analysis (binary outcomes): The sensitivity analysis results are stored in a variable formed by combining the terms "SensitivityAnalysis_", the method for imputing data ("IMOR_", "BestWorst_", "WorstBest_"), and the outcome name.
For example, "SensitivityAnalysis_IMOR_Kidney.failure". 
In addition, to allow people to use the validated "metasens" R-package to perform sensitivity analysis of missing data, additional sensitivity analysis results 
are stored in a variable formed by combining the terms "SensitivityAnalysis_MetaMiss", the method for imputing data ("BestWorst_", "WorstBest_"), and the outcome name. 
For example, "SensitivityAnalysis_MetaMiss_BestWorst_Kidney.failure".
</li>
<li>Sensitivity analysis (continuous outcomes): The sensitivity analysis results  (indicating the results after excluding studies in which standard deviations were imputed) are stored in a variable formed by combining the term "SensitivityAnalysis_" with the outcome name.
For example, for an outcome "Health related quality of life", it would be "SensitivityAnalysis_Health.related.quality.of.life".
</li>
<li>Plots: The plots are stored in variables which are formed by combining the prefix "Plot_" before the above the variables. 
For example, "Plot_MetaAnalysis_Kidney.failure".</li>
</ul>
</ul>
</p>
<h3><b><i> References</i></b></h3>
<p><b><i> Package: Meta</i></b></p>
<ul>
<li> Balduzzi S, Rücker G, Schwarzer G. How to perform a meta-analysis with R: a practical tutorial. Evid Based Ment Health. 2019 Nov;22(4):153-160.</li>
</ul>
<p><b><i> Meta-analysis of rare events</i></b></p>
<ul>
<li> Dungang Li. Meta-Analysis of Rare Events. 2019. Wiley StatsRef: Statistics Reference Online. DOI: 10.1002/9781118445112.stat08167</li>
<li>Stijnen, T., Hamza, T.H. and Özdemir, P. (2010), Random effects meta-analysis of event outcome in the framework of the generalized linear mixed model with applications in sparse data. Statist. Med., 29: 3046-3067.</li>
</ul>
<p><b><i> Funnel plot asymmetry</i></b></p>
<ul>
<li> Sterne et al. Recommendations for examining and interpreting funnel plot asymmetry in meta-analyses of randomised controlled trials. BMJ 2011; 343 doi: https://doi.org/10.1136/bmj.d4002</li>
<li> Rücker G, Schwarzer G, Carpenter J. Arcsine test for publication bias in meta-analyses with binary outcomes. Stat Med. 2008 Feb 28;27(5):746-63.</li>
</ul>
<p><b><i> Metaregression</i></b></p>
<ul>
<li> Thompson SG, Higgins JP. How should meta-regression analyses be undertaken and interpreted? Stat Med. 2002 Jun 15;21(11):1559-73.</li>
</ul>
<p><b><i> Dealing with missing data</i></b></p>
<ul>
<li> Mavridis, D, White, IR. Dealing with missing outcome data in meta-analysis. Res Syn Meth. 2020; 11: 2– 13.</li>
<li> Higgins JP, White IR, Wood AM. Imputation methods for missing outcome data in meta‐analysis of clinical trials.Clin Trials.2008;5(3):225‐23.</li>
</ul>
')
Instructions_OCR_1 <- ('
<h3 style = "font-size:24px; color:purple;"><b>Instructions for optical character recognition (OCR)</b></h3>
This function allows optical character recognition (OCR) of the following languages: Chinese, Danish, Dutch, English, French, German, Italian, Japanese, Korean, Norwegian, Persian, Polish, Portugese, Russian, Spanish, Thai, Ukraine.
This means that you can extract text characters of these languages from image files or pdf files and then use an online tool such as Google translate or Microsoft translator to translate the text.
<h3><b><i>Preparation of files</i></b></h3>
<ul>
<li>If you have a pdf article, you can upload the pdf as it is to see how the characters are extracted.</li>
<li>This programme only functions well with chunks of text and not tables. 
Therefore, if the OCR on the pdf does not work well, we recommend taking screenshots of chunks of texts and storing these as image files,
which can then be uploaded into the programme. It also works only with few pages of pdf. 
If you upload a pdf with lots of pages, this may result in error. 
In this situation, we recommend that you split the pdf into pdfs with fewer pages 
(you can simply "print to pdf" a few pages at a time). 
</li>
<li>You may need to use image editing software such as Photos (preinstalled in windows) or other programmes to crop out unnecessary parts of the image, 
tilt the images to make the text appear in straight lines, improve the contrast etc to allow better OCR.</li>
</ul>
<h3><b><i>Uploading the files</i></b></h3>
<ul>
<li>Please scroll below these instructions.</li>
<li>First select from one of the languages from the dropdown menu.</li>
<li>Then upload the pdf or image files.</li>
<li>When the OCR is complete, a download button appears below these instructions.
You can download the output as text file.
You can then copy the text, and use online translators to translate text.
</li>
</ul>
')
Instructions_OCR_2 <- ('
<h3><b><i>Perform OCR by selecting the language and starting the upload below</i></b></h3>
')
# Instructions
Instructions_references_1 <- ('
<h3 style = "font-size:24px; color:purple;"><b>Instructions for combining searches from databases</b></h3>
<p>This function allows you to combine and deduplicate references from the following databases: 
PubMed, Ovid MEDLINE, Ovid EMBASE, 
Web of Science (Conference Proceedings Citation Index), 
Cochrane Library, ClinicalTrials.gov, 
and WHO (World Health Organization) ICTRP (International Clinical Trials Registry Platform).
</p>
<h3><b><i>Formats for downloading the searches</i></b></h3>
<ul>
<li><i>PubMed</i>: "nbib" format</li>
<li><i>Ovid MEDLINE</i>: "Excel sheet" format and "Complete reference" for the fields. 
If there are more than 1000 references, download the files as 1000 references per file.
</li>
<li><i>Ovid EMBASE</i>: "Excel sheet" format and "complete reference" for the field choices. 
If there are more than 1000 references, download the files as 1000 references per file.
</li>
<li><i>Web of Science(Conference Proceedings Citation Index)</i>: "tab delimited" format and "Full record". 
If there are more than 500 or 1000 references (depending on the account), download the files as 500 or 1000 references per file.
</li>
<li><i>Cochrane Library</i>: "CSV (Excel)" format; ensure that "Include abstract" box is checked.</li>
<li><i>ClinicalTrials.gov</i>: "csv" format; select all data fields.</li>
<li><i>WHO ICTRP</i>: "XML" format; if there are more than 100 references, download the files as 100 references in each file.</li>
</ul>
<h3><b><i>Formats for uploading the searches</i></b></h3>
<ul>
<li><i>PubMed</i>: no change to format</li>
<li><i>Ovid MEDLINE</i>: save the "citations" sheet as "csv" format. 
You will receive warnings that csv does not support multiple sheets and certain data formats. 
You can ignore the warnings and save the file as "csv" since we are interested only in the "citations" sheet.
</li>
<li><i>Ovid EMBASE</i>: save the "citations" sheet as csv format as for Ovid MEDLINE ignoring warnings about multiple sheets and formats.</li>
<li><i>Web of Science(Conference Proceedings Citation Index)</i>: no change to format.</li>
<li><i>Cochrane Library</i>: no change to format.</li>
<li><i>ClinicalTrials.gov</i>: no change to format.</li>
<li><i>WHO ICTRP</i>: no change to format.</li>
</ul>
<h3><b><i>Preparing for uploads (store the files in a single folder)</i></b></h3>
<p>All the downloaded search files should be stored in a single folder. 
While you can call this folder by any name, we recommend calling this folder "DatabaseSearches" to allow you to identify the folder which contains the files to be uploaded.
</p>
<h3><b><i>Preparing the "Index file"</i></b></h3>
<ul>
<li><i>Index file format</i>: csv</li>
<li><i>Index file name</i>: Although there is no requirement for the index file to have a specific name, we recommend calling this file "Index" (with extension, it will be "Index.csv")
<li>The index file must have exactly two columns with specific column names. 
All column names are case sensitive and are should not have empty spaces before or after the names.</li>
<li><b>Column 1</b>: "file.name" (without the quotes): enter the file name with the extensions. 
The extension can be obtained by right-clicking the file and selecting the properties. 
If the correct formats were downloaded and then prepared for uploads, then the files extensions in different databases are as follows.</li>
<ul>
<li><i>PubMed</i>: ".nbib"</li>
<li><i>Ovid MEDLINE</i>: ".csv" (after changing format as above)</li>
<li><i>Ovid EMBASE</i>: ".csv" (after changing format as above)</li>
<li><i>Web of Science(Conference Proceedings Citation Index)</i>: ".txt"</li>
<li><i>Cochrane Library</i>: ".csv"</li>
<li><i>ClinicalTrials.gov</i>: ".csv"</li>
<li><i>WHO ICTRP</i>: ".xml"</li>
</ul>
<li>Although there is no requirement to change the names of downloaded searches, for easy management and avoiding errors, we recommend renaming the files to the databases from which they were downloaded. 
If multiple files were downloaded from the same database (for example, because of the maximum limit of the references in each file), you can add a suffix, for example, "_1","_2" and so on. 
For example, if you downloaded 3 files from MEDLINE, you can name these "MEDLINE_1", "MEDLINE_2", "MEDLINE_3" 
(with extensions, the names will be "MEDLINE_1.csv", "MEDLINE_2.csv", "MEDLINE_3.csv").</li>
<li><b>Column 2</b>: "database" (without the quotes): This column should indicate the database from which the file was downloaded. 
These can have one of the following values:
"Pubmed", "Medline", "Embase","WOS", "Cochrane","CTgov", and "ICTRP" corresponding to the seven databases mentioned above. </li>
Each file.name (column 1) should have a corresponding database.
</ul>
<h3><b><i>Preparing the "Keywords file"</i></b></h3>
<ul>
<li><i>Keywords file format</i>: csv</li>
<li><i>Keywords file name</i>: Although there is no requirement for the keywords file to have a specific name, we recommend calling this file "Keywords" (with extension, it will be "Keywords.csv").
<li>The keywords file must have exactly two columns with specific column names. 
All column names are case sensitive and are should not have empty spaces before or after the names.</li>
<li><b>Column 1</b>: "keywords" (without the quotes): enter the keywords.</li>
<li><b>Column 2</b>: "concept" (without the quotes): enter the concept relevant to the keywords. 
Each keyword should be linked to only one concept or sub-concept. 
For example, in an intervention review, the concepts for the search will be: study design, population, intervention, and control. 
Each of the above concepts can be split into sub-concepts as required, for example, intervention 1, intervention 2 etc.
</li>
<li>Note that each concept can have multiple keywords but each keyword should be linked to one concept. 
If there are multiple concepts or subconcepts to which a keyword can be linked, choose the most relevant concept. 
As a result, the number of unique concepts should be fewer or equal to the number of keywords. 
Any keywords not linked to a concept will not be highlighted.
</li>
</ul>
<h3><b><i>Sample files</i></b></h3>
Sample index file and keywords file are available from the left tab under the "Download Training resources". 
You can use this as a template for column headings and specifying the database correctly (for index file).
')
Instructions_references_2 <- ('
<h3><b><i>Combine the searches and highlight the keywords in the references by uploading the index file below</i></b></h3>
')
Instructions_DEF_Int_1 <- ('
<h3 style = "font-size:24px; color:purple;"><b><i>Instructions for creating data extraction form plan (DEF plan)</i></b></h3>
This function allows creation of data extraction.Instructions for data extraction are also provided below, but are also available in the data extraction form.
Because of space restrictions, this function is available only on local version of R or R studio installed on your computer. Additional packages are to be installed as necessary.
<h4 style="text-align:left;"><b><i>General</i></b></h4>
<ul>
<li>When creating the short names, use informative abbreviations. There should be no special characters other than "underscore" in the short names.</li>
<li>The abbreviations will be used in graphs and for automated processing.</li>
<li>An abbreviations list should be provided in the manuscript (and this can be found in the data extraction plan that you created with the software).</li>
<li>The data extraction form design should be saved in the csv format.</li>
</ul>
<h4 style="text-align:left;"><b><i>Customising inclusion and exclusion criteria in studies</i></b></h4>
<ul>
<li>For extracting information on the inclusion and exclusion criteria in the studies, 
the questions should be prepared in the following format.</li>
<ul>
<li><i>Criteria format</i>: csv</li>
<li><i>Criteria file name</i>: Although there is no requirement for the "Criteria" file to have a specific name, we recommend calling this file "Criteria" (with extension, it will be "Criteria.csv").
<li>The Criteria file must have exactly two columns with specific column names. 
All column names are case sensitive and are should not have empty spaces before or after the names.</li>
<li><b>Column 1</b>: "variable_value" (without the quotes): Enter the full question. The full question should be informative (i.e., self-explanatory).</li>
<li><b>Column 2</b>: "short_names" (without the quotes): This should follow the general rules for short names. To allow automated subgroup analysis based on a feature, please enter the feature followed by a underscore and the specific criterion. As an example, if you want to perform a subgroup analysis based on smoking status, you can include the short names of the first criterion to be "Smoking_Non-smoker", the second criterion to be "Smoking_Past smoker", the third criterion to be "Smoking_Current smoker", and the fourth criterion to be "Smoking _Unknown status". This will allow the program to automatically perform a subgroup analysis of studies based on smoking status.</li>
</ul>
<li>If no file is uploaded or the file uploaded is in the wrong format, the data extraction form will have two columns "Other inclusion criteria" and "Other exclusion criteria" to obtain details on the inclusion and exclusion criteria of participants in the study.</li>
</ul>
<h4 style="text-align:left;"><b><i>Customising characteristics</i></b></h4>
<ul>
<li>The data extraction form includes the PROGRESS-PLUS characteristics to capture the disadvantaged groups as default. 
The classifications used for different criteria are available in the references. 
Therefore, there is no need to add these in the "Other characteristics" file.
<li>For extracting information on other characteristics of participants or other characteristics of the study in the studies, 
the questions should be prepared in the following format.</li>
<ul>
<li><i>Other characteristics format</i>: csv</li>
<li><i>Other characteristics file name</i>: Although there is no requirement for the "Other characteristics" file to have a specific name, we recommend calling this file "Other characteristics" (with extension, it will be "Other characteristics.csv").
<li>The Other characteristics file must have exactly four columns with specific column names. 
All column names are case sensitive and are should not have empty spaces before or after the names.</li>
<li><b>Column 1</b>: "variable_value" (without the quotes): Enter the detail that you want to appear in the data extraction form. 
Depending on what you enter in column 3, the following text is added  before the details you enter.</li>
<ul>
<li>number: "Enter the number of "</li>
<li>score: "Enter the mean "</li>
<li>text: "Enter: "</li>
</ul> 
<li><b>Column 2</b>: "short_names" (without the quotes): This should follow the general rules for short names. To allow automated calculation of proportion of participants based on a categorical variable, please enter the categorical variable followed by a underscore and the category. As an example, if you want to calculate the proportion of participants with different smoking status, you can include the first characteristic to be "Smoking_Non-smoker", the second characteristic to be "Smoking_Past smoker", the third characteristic to be "Smoking_Current smoker", and the fourth characteristic to be "Smoking _Unknown status". This will allow the program to automatically calculate the proportion of people who belonged to each smoking category.</li>
<li><b>Column 3</b>: "type_1" (without the quotes): Enter the type of data that this characteristic should capture. The options are "number", "text", "score" without quotes. 
If you want to extract the number of participants with a certain characteristic, say, severe disease, indicate "number". 
If you want to extract the mean value of a certain characteristic, say, Body Mass Index (BMI) or symptom severity score, indicate "score". 
If you want to extract some details that cannot be captured by numbers, say the classification used to record symptom severity (if symptom severity can be measured in multiple ways), indicate "text".</li>
<li><b>Column 4</b>: "study_level_intervention_level" (without the quotes): Enter whether the detail should be captured at study-level or intervention-level. The options are "study_level" and "intervention_level". 
For example, BMI or symptom severity will be at intervention-level and should be recorded as "intervention_level"; 
on the other hand, the classification used to record symptom severity will be at the study-level and should be recorded as "study_level".</li>
</ul>
<li>If no file is uploaded or the file uploaded is in the wrong format, the data extraction form will have only the participant characteristics related to PROGRESS-PLUS.</li>
</ul>
<h4 style="text-align:left;"><b><i>Customising intervention names</i></b></h4>
<ul>
<li>For direct comparison reviews, we recommend using one data extraction form for each comparison. Name the intervention_1 and intervention_2 (and short names) according to the interventions for which the data extraction is required, for example, in a comparison involving aspirin versus "no treatment" for preventing heart attacks in healthy population, intervention_1 will be "aspirin" and intervention_2 will be "no treatment". 
The shortnames of intervention_1 and intervention_2 will be "Aspirin" and "No_treatment". 
If the comparison involves a broader comparison, say platelet inhibitors versus no treatment for preventing heart attacks in healthy population, intervention_1 will be "Platelet inhibitors" and intervention_2 will be "No treatment". 
The respective short names will be "Platelet_inhibitors" and "No_treatment". 
You can request the data extractors to extract the information about the name of the platelet inhibitor in the additional names column of data extraction. 
If you find a trial that compares aspirin versus clopidogrel versus no treatment in healthy population, you can extract information in another row with the exact study name as the previous row. 
In the first row for that study, you should extract information for aspirin versus "no treatment". In the second row for that study, you should extract information for "clopidogrel" only under intervention_1. 
In factorial trials with and without a co-intervention, for example, in a trial of aspirin versus "no treatment" with and without lifestyle advice, we recommend treating these as two different studies and extract information on aspirin versus "no treatment" in people who received lifestyle advice in one row and in people who did not receive lifestyle advice in another row.</li>
<li>For network meta-analysis, name the intervention_1 as intervention_1 and intervention_2 as intervention_2 (for both the full names and short names) to allow NMA (this function is not available currently but is part of planned development). Enter the name and short-name of the intervention_1 and intervention_2. You can obtain the details of the intervention in the additional name of the intervention. A short-name will also be required to allow the graphs to be displayed well. This should follow the general rules for short names.</li>
</ul>
<h4 style="text-align:left;"><b><i>Customising outcome names</i></b></h4>
<ul>
<li>For extracting information on outcomes, the questions should be prepared in the following format.</li>
<ul>
<li><i>Outcomes format</i>: csv</li>
<li><i>Outcomes file name</i>: Although there is no requirement for the "Outcomes" file to have a specific name, we recommend calling this file "Outcomes" (with extension, it will be "Outcomes.csv").
<li>The Outcomes file must have exactly five columns with specific column names. 
All column names are case sensitive and are should not have empty spaces before or after the names.</li>
<li><b>Column 1</b>: "variable_value" (without the quotes): While it is obvious that the outcome names should be informative of what we want to extract, it is useful to indicate the type of outcome. For example, serious adverse events can be both a binary and count outcomes, as the number of people who developed serious adverse events and the number of serious adverse events are both important from a patient and healthcare funder perspective. To avoid confusion as to whether one is looking for the number of people who developed serious adverse events or the number of serious adverse events, one can clearly indicate serious adverse events (proportion) and or even serious adverse events (proportion; binary outcome) and serious adverse events (number; count outcome). 
One can also specify the timing of outcome in the outcome name. For example, health-related quality of life (HRQoL) can be measured at different time points. You might want to collect the short-term HRQoL, say within 3 months of an intervention, medium-term HRQoL between 3 months and 12 months, extended medium-term HRQoL between 1 year and 5 years, and long-term HRQoL beyond 5 years. You might want to specify this in the outcome name. For example, HRQoL (less than 3 months), HRQoL (from 3 months to 12 months), HRQoL (from 1 year to 5 years), and HRQoL (beyond 5 years).</li>
<li><b>Column 2</b>: "short_names" (without the quotes): This should follow the general rules for short names. 
If you are planning advanced meta-analytical techniques, such as multivariate meta-analysis to analyse correlated outcomes (this function is not available but is part of planned development), to allow automated detection that you are looking for performing analysis of correlated outcomes, use a short name that starts with "Correlated_" followed by the correlated outcomes followed by an underscore. For example, if you consider that HRQoL (less than 3 months) and HRQoL (from 3 months to 1 year) are correlated, you can use the short names, "Correlated_HRQoL_less_than_3_months" and "Correlated_HRQoL_from_3_to_12_months" which will allow the data to be prepared and analysis using multivariate meta-analysis.</li>
<li><b>Column 3</b>: "type_1" (without the quotes): Enter the type of data. The options are "binary", "continuous", "count", and "time-to-event".</li>
<li><b>Column 4</b>: "objective_subjective" (without the quotes): Enter whether the outcome is objective or subjective. The options are "objective" and "subjective".</li>
<li><b>Column 5</b>: "additional_text" (without the quotes): Enter any additional instructions related to the outcome. For example, which definitions or scale of outcome are acceptable.</li>
<li><b>Column 6</b>: "better_worse" (without the quotes): Enter whether higher numbers or scores of the outcome indicate better health or worse health. 
The options are "better" and "worse". For example, higher complications indicates worse health; therefore, the entry for complications will be "worse". 
On the other hand, increased health-related quality of life indicates better health; therefore, health-related quality of life will be "better". 
For continuous outcomes with multiple scales measuring the same outcome, for some scales, higher will be "better" and for others, higher will be "worse". 
In such situations, choose the "better" or "worse" that is most intutuitive to interpret. At the time of data entry, it is possible to change this for individual scales. 
This is relevant for data analysis of continuous outcomes.</li>
</ul>
</ul>
<h4 style="text-align:left;"><b><i>Creating the data extraction form</i></b></h4>
<ul>
<li>Once you have designed the data extraction form as above, You can also save the data extraction form plan to avoid having to enter all the details in future.</li>
<li>You can also upload the "1_Import_Summary.csv" and "2_Deduplicated_References.csv" that you generated when the references from different databases were combined. 
If uploaded, the references will automatically be included in the different sheets. Otherwise, the references must be included manually in the "Screening_First" sheet.
The formatting and the automated formulae are completed only for 100 rows.</li>
<li>Once the information is entered, the data extraction form is generated and can be downloaded.</li>
<li>The sheets are protected to prevent any inadvertent changes. There is no password. 
Before you send this to the co-authors, you might want to protect the sheets with a suitable password to prevent inadvertent changes by the co-author. 
Please note that any edits to the headings will cause errors when you use the program to process the data extraction form. Therefore, ensure that you have the headings that match with the data extraction form plan that you created.</li>
</ul>
<h4 style="text-align:left;"><b><i>Sample files</i></b></h4>
Sample criteria file, other characteristics file, outcome file, and overall design file are available from the left tab under the "Download Training resources". 
You can use this as a template for column headings and specifying the information correctly.
<h4 style="text-align:left;"><b><i>References</i></b></h4>
<ul>
<li>PROGRESS-PLUS:ONeill J, Tabish H, Welch V, Petticrew M, Pottie K, Clarke M, Evans T, Pardo Pardo J, Waters E, White H, Tugwell P. Applying an equity lens to interventions: using PROGRESS ensures consideration of socially stratifying factors to illuminate inequities in health. Journal of Clinical Epidemiology. 2014, 67 (1), pg. 56-64. doi:10.1016/j.jclinepi.2013.08.005</li>
<li>Place of residence: Used by PROGRESS-Plus group</li>
<li>Race (Ethnicity) classification: Based on Office of National Statistics 2021 ethnic groups (https://www.ons.gov.uk/peoplepopulationandcommunity/culturalidentity/ethnicity/bulletins/ethnicgroupenglandandwales/census2021#ethnic-groups-in-england-and-wales) and US Census (https://www.census.gov/topics/population/race/about.html). </li>
<li>Occupation classification: Based on International Standard of Classification of Occupations (https://ilostat.ilo.org/resources/concepts-and-definitions/classification-occupation/)</li>
<li>Religion classification: Based on Office of National Statistics 2021 religion (https://www.ons.gov.uk/census/census2021dictionary/variablesbytopic/ethnicgroupnationalidentitylanguageandreligionvariablescensus2021/religion/classifications)</li>
<li>Education: Based on International Standard Classification of Education https://uis.unesco.org/sites/default/files/documents/international-standard-classification-of-education-isced-2011-en.pdf</li> 
<li>Socio-economic status: This is based on household wealth, but even census data bases socio-economic status based on occupational levels (https://www.ons.gov.uk/methodology/classificationsandstandards/otherclassifications/thenationalstatisticssocioeconomicclassificationnssecrebasedonsoc2010#continuity-with-social-class-and-socio-economic-group). Therefore, no separate category was used. </li>
<li>Social capital: This is based on the social network. It is difficult to measure and is largely a surrogate (https://www.socialcapitalresearch.com/social-capital-measurement/). Therefore, no separate category was used. </li>
<li>Intervention characteristics (TIDieR checklist): Hoffmann TC, Glasziou PP, Boutron I, Milne R, Perera R, Moher D, Altman DG, Barbour V, Macdonald H, Johnston M, Lamb SE, Dixon-Woods M, McCulloch P, Wyatt JC, Chan AW, Michie S. Better reporting of interventions: template for intervention description and replication (TIDieR) checklist and guide. BMJ. 2014 Mar 7;348:g1687. doi: 10.1136/bmj.g1687. PMID: 24609605. </li>
<li>Outcome characteristics (Outcome taxonomy): Dodd S, Clarke M, Becker L, Mavergames C, Fish R, Williamson PR. A taxonomy has been developed for outcomes in medical research to help improve knowledge discovery. J Clin Epidemiol. 2018;96:84-92</li>
</ul>
<h3 style = "font-size:24px; color:purple;"><b><i>Instructions for data extraction</i></b></h3>
<h4 style="text-align:left;"><b><i>General</i></b></h4>
<ul>
<li>Do not cut cells or override validation. This will lead to errors when you summarise the data or perform analysis.</li>
<li>For direct comparison reviews, we recommend using one data extraction for each comparison. For network meta-analysis, use the same data extraction for all comparisons.</li>
<li>Cells that are filled with pale yellow or grey are cells that you cannot change.</li>
<li>Alternate rows are filled to allow easy distinction between rows.</li>
<li>Cells in light pink (alternating with white) are cells to be completed by first reviewer and those in light blue (alternating with white) are to be completed by second reviewer. Cells in medium orange (alternating with white) must be completed after agreement between the two reviewers.</li>
<li>Cells with dropdown menus accept only one of the choices from the dropdown menu. Other cells may have restrictions such as whole numbers only or decimal places only.</li>
<li>When information is missing, do not enter 0. Please leave the cells empty.</li>
<li>Certain cells are locked and you will not be able to edit them.</li>
</ul>
<h4 style="text-align:left;"><b><i>Study details</i></b></h4>
<ul>
<li><i>Name of the study</i>: This can be the acronym for the trial, trial ID, or last name of the first author followed by year of publication. This should be a unique ID for each study, for example: Doe 2021. If there was another trial with same name, you can differentiate this by stating Doe 2021 (1), Doe 2021 (2), etc. An alternative is to use numbers for studies, for example, S001, S002, S003, etc. However, for easy identification, even if you use S001, S002, S003, etc, we recommend that you add the trial name, ID, or last name of first author followed by year of publication.</li>
<li>To allow automated comparison of data, we recommend that the first and second reviewers use the same study names/IDs to refer to a study.</li>
<li><i>Record ID</i>: These are automatically generated by the program.</li>
<li>If you find additional references which are not retrieved by searching databases, you can add them to end of the references in "Screening_First" sheet. You must give a record name, and record reference. You can add up to 100 references manually.</li>
</ul>
<h4 style="text-align:left;"><b><i>Inclusion or exclusion of a study</i></b></h4>
<ul>
<li>The first step is screening the titles and abstracts for potential inclusion. You can do this in the sheets "Screening_First" and "Screening_Second" ("First" or "Second" indicating the first or second reviewer). There is no need to provide detailed reasons for exclusion at the level of screening, but you might want to add some comments in the "optional_comment" column if there is a possibility for another reviewer to disagree with your exclusion.</li>
<li>The next step is selection at the level of full text.</li>
<li>You should include all records of a study regardless of whether you find any additional information in the record. For example, you may not include details from a record, say a conference abstract as all the information is available in a more detailed manner in a full journal report. You would still collate all the records of the study and consider this record as included.</li>
<li>You can override your selection in the "FullText_First" or "FullText_Second" sheets. If your choice at the "full text" stage remains the same as "screening" stage, there is no need to complete the "selection_fulltext" column . For example, you might have excluded a record at "screening" stage and the other reviewer may have also done the same: there is no need to complete the "selection_fulltext" column. Similarly, you might have included a record at the "screening" stage and your decision based on "full text" review remains the same: there is no need to complete the "selection_fulltext" column.</li>
<li>If you excluded a study at "full text" stage (and not "screening" stage), you must provide a reason for exclusion. If the reason for exclusion is not within the exclusion list, you can select "Other reasons" and enter the reason in the additional details for exclusion column. Even if you select one of the reasons in the exclusion list, you can optionally include additional details, for example, which record was this record a duplicate of.</li>
</ul>
<h4 style="text-align:left;"><b><i>Data extraction</i></b></h4>
<ul>
<li>Data extraction is performed in the "DataExtractionForm_First" or "DataExtractionForm_Second" sheets.</li>
<li>Only records that have been indicated as "Included" in the "selection_final" column in the" FullText_First" sheet which is based on the selection of the first reviewer at the "screening" stage and "full text" stage will be available for selection in the "Record ID" column in the "DataExtractionForm_First" sheet. Similarly, only records that have been indicated as "Included" in the "selection_final" column in the" FullText_Second" sheet which is based on the selection of the first reviewer at the "screening" stage and "full text" stage will be available for selection in the "Record ID" column in the "DataExtractionForm_Second" sheet.</li>
<li>Enter each outcome in a study in a new row. Please ensure that you complete the "Study name or ID" and the appropriate "Record ID" for the outcome.</li>
<li>Participant characteristics in the first row of a study are used for automated tabulation. Therefore, there is no need to copy these to each row.</li>
<li>Participant flow, follow-up, and risk of bias assessments from the first row of a study are used for automated tabulation. These need to be completed for each outcome only if they are different from the information in the first row. Please also see the instructions under the relevant sections.</li>
</ul>
<h4 style="text-align:left;"><b><i>Study author details</i></b></h4>
<ul>
<li>If corresponding author is not stated, please indicate the first author.</li>
<li>For contact details of corresponding author, enter the email if possible. If this is not possible, enter the institutional or departmental email. If this is not possible, then record the department or institution address and phone number if available.</li>
</ul>
<h4 style="text-align:left;"><b><i>Participant characteristics</i></b></h4>
<ul>
<li>If the participant characteristics are missing for each intervention, please enter the details for all intervention groups under the first intervention group.</li>
</ul>
<h4 style="text-align:left;"><b><i>Participant flow</i></b></h4>
<ul>
<li>Some aspects of participant flow such as number screened and included are at the study-level while other aspects such as number randomised or initially included and missing data numbers are collected at the intervention level.</li>
<li>In many studies, participant flow is similar for most outcomes. While it is possible to enter the information for each outcome, it is probably more efficient to enter this information for most outcomes and complete the information at the outcome level when it is different from the general assessment.</li>
<li>If an intention-to-treat analysis with an appropriate method of imputation (depending on the reason for missing data) was used for all participants initially included in the study was available, such participants should not be considered as missing outcome data.</li>
<li>If the number of participants with missing outcome data is not clear, do not enter "0". Leave this field empty.</li>
</ul>
<h4 style="text-align:left;"><b><i>Intervention</i></b></h4>
<ul>
<li>Additional names are required only when a network meta-analysis is performed or when a broad intervention is used. For example, in a comparison of platelet inhibitors versus no treatment for preventing heart attacks in healthy population, it is useful to know the platelet inhibitor (for example, aspirin or clopidogrel) used in the study. If you have added an additional name, the additional name and short names of the intervention should be harmonised (i.e., the two reviewers use the same additional names and short names) after the data extraction to allow automated comparison of data and analysis of data.</li>
<li>If you find studies which include more treatment arms than what you are comparing, you can include only the arms relevant for your review.</li>
<li>Sometimes, you may find that multiple arms are eligible for a single comparison in the review. For example, in a comparison of platelet inhibitors versus no treatment for preventing heart attacks in healthy population, you may find a trial that compares aspirin versus clopidogrel versus no treatment in healthy population. In this situation, you can extract information in another row with the exact study name as the previous row. In the first row for that study, you should extract information for "aspirin" versus "no treatment". You must add the additional names and short names to indicate that this row refers to "aspirin". In the second row for that study, you should extract information for "clopidogrel" only. You must add the additional names and short names to indicate that this row corresponds to "clopidogrel". You must also ensure that the additional names and short names are under the correct intervention, i.e., aspirin, clopidogrel, or other platelet inhibitors are under platelet inhibitors and not "no treatment". You can add as many interventions as you want for a study, provided that the additional names and short names are under the correct intervention. In network meta-analysis, there is no predefined intervention_1 and intervention_2. Therefore, you can add an intervention under intervention_1 or intervention_2.</li>
<li>Sometimes you may find factorial trials in which the intervention is compared with the comparator in the presence or absence of a co-intervention, for example, a trial of "aspirin" versus "no treatment" with and without lifestyle advice. In such situations, we recommend extracting data for the comparison of "aspirin" versus "no treatment" with lifestyle advice and the comparison of "aspirin" versus "no treatment" without lifestyle advice separately as two different studies (by adding a suffix) and extract information on "aspirin" versus "no treatment" in people who received lifestyle advice in one row and in people who did not receive lifestyle advice in another row.</li>
</ul>
<h4 style="text-align:left;"><b><i>Follow-up</i></b></h4>
<ul>
<li>In many studies, follow-up is similar for most outcomes. While it is possible to enter the information for each outcome, it is probably more efficient to enter this information for most outcomes and complete the information at the outcome level when it is different from the general assessment. Rarely, the follow-up is different for the different intervention and the comparator. In such a situation, you can enter this information separately for each group.</li>
</ul>
<h4 style="text-align:left;"><b><i>Risk of bias</i></b></h4>
<ul>
<li>As for follow-up, in many studies, risk of bias domains which are assessed at outcome level are similar for most outcomes. While it is possible to enter the information for each outcome, it is probably more efficient to enter this information for most outcomes and complete the information at the outcome level when it is different from the general assessment.</li>
<li>If you include randomised controlled trials and observational studies in your review, you need to complete the RoB 2.0 for randomised controlled trials and ROBINS-I for non-randomised studies for intervention. Therefore, you should completely one of them.</li>
<li>If you are including cluster randomised controlled trials or cross-over randomised controlled trials, you need to complete only RoB 2.0 (cluster RCTs) or RoB 2.0 (cross-over RCTs) tools. There is no need to complete the generic RoB 2.0 tool for the specific study.</li>
</ul>
<h4 style="text-align:left;"><b><i>Outcomes</i></b></h4>
<ul>
<li>Add one outcome in each row. Please ensure that you copy the study names and details for each row.</li>
<li>Additional names are required only when a broad outcome is used. For example, Patient Reported Outcome Measures may include a wide range of patient reported outcome measures but you want to analyse different patient reported outcome measures separately. In such a case add an additional name. If you have added an additional name, the additional name and short names of the outcome should be harmonised (i.e., the two reviewers use the same additional names and short names) after the data extraction to allow automated comparison of data and analysis of data.</li>
<li>In randomised controlled trials, the preferred data are as follows.</li>
<ul>
<li><i>Binary outcomes</i>: number of people with event and number included in analysis for each group.</li>
<li><i>Continuous outcomes</i>: mean, standard deviation, and number included in analysis for each group.</li>
<li><i>Count outcomes</i>: number of events and number included in analysis for each group.</li>
<li><i>Time-to-event outcomes</i>: hazard ratio and 95% confidence intervals.</li>
</ul>
</ul>
<ul>
<li>For observational studies (including cohort studies), the effect measure and its confidence interval may be the only information that is available in observational studies and it is useful to obtain the effect measure adjusted for confounders and unadjusted for confounders. Occasionally the effect measure and its standard error may be available, in which case, you can extract this information.</li>
<li>When some of the information is missing, it may be possible to calculate or impute this information from other information in the trials. This information is required only when the preferred information in the previous two points are not available.</li>
<li>Data can be extracted from graph. For guidance, please see guidance under "Data extraction from plots".</li>
<li>There are simple calculators that are available from the "Calculators" sheet. These can be used to show the co-reviewer how you arrived at some numbers and include simple addition, simple subtraction, calculation of months from days, weeks, and years, and calculation of hours from minutes. We have also added a generic calculator which converts multiple values using a conversion factor that you can specify. You can copy and paste pictures after entering the data into the "Calculations_Co_reviewer" sheet. This will avoid the need for discussions between the reviewers as to how some numbers were calculated.</li>
</ul>
')
Instructions_DEF_Int_2 <- ('
<h3><b><i>Create data extraction form by entering the details below</i></b></h3>
')
Instructions_PlotExtract_1 <- ('
<h3 style = "font-size:24px; color:purple;"><b>Instructions for extracting data from plots for inclusion in systematic review of inteventions</b></h3>
This version supports extraction of data from Kaplan-Meier plots, box plots, bar plots, and line plots.
<h3><b><i>Preparation of plots before uploading</i></b></h3>
<ul>
<li>We recommend reducing the size of the plots to less than 700 pixels in both height and width. This is possible in most photo edit software. If you use Windows operating system, MS Paint is pre-installed. You can use MS Paint to decrease the pixels. Uploading very large image files is not supported, but files with more than 700 pixels, it can take long time between selecting the data points.</li>
</ul>
<h3><b><i>General instructions</i></b></h3>
<ul>
<li>You need to enter the minimum and maximum values of y-axis (vertical axis) for all the plots and for the x-axis (horizontal axis) as well for Kaplan-Meier plots and line plots. 
These are for "calibration" purposes,i.e., to convert the pixels to absolute values. 
Therefore, we recommend that you select the points which have numbers next to them, so that it is easy to enter the numbers without any guesswork. 
This might mean that there are datapoints beyond the maximum value. However, there are no problems with that. The absolute values are calculated based on the "calibration".</li>
<li>At each step, the next data point to be selected is indicated in "Next step". Please follow these instructions carefully. Otherwise, this may result in wrong values; sometimes the app may stop working. If this is case, reload the app and select the correct data points as indicated in "Next step". If you are not seeing the "Next step" after entering the time points, please scroll screen to the top. You will be able to see the "Next step".</li>
<li>You are able to remove all the datapoints that you selected in the plot or you are able to remove only the last datapoint. These functions (particularly removing only the last data point) are useful if you notice that you have selected the datapoint(s) wrongly. If you are not seeing the buttons to remove the datapoints after entering the first data point, please scroll screen to the top. You will be able to see the buttons.</li>
<li>Once you have entered the minimum and maximum values in x axis, selected the time points, and selected the minimum and maximum data points for Kaplan-Meier plots and line plots, vertical dotted lines will appear at the specified time points. 
These can help you decide whether you have "calibrated" correctly and also is helpful to guide the selection of the data point corresponding to that time point. 
Once these "vertical guides" appear, you just need to focus on the y-axis. The data point will automatically "bind" to the vertical guide representing the time point indicated. This is difficult to explain by text, try this practically, you can easily see how this works. 
For the remaining plot types, when multiple data points in the same vertical line are required, for example, box plot which requires three data points in a straight line or bar plots with error bars which again require multiple data points in the same vertical line, a vertical dotted line will appear after the first data point is selected. For example, in a box plot if mean (or usually median) is clicked, a vertical line will appear and the lower and upper quartiles will "bind" automatically to this vertical line.</li>
<li>You can select up to 10 groups and 10 time points to extract the data.</li>
<li>You can save the plot with the data points and vertical lines included.</li>
<li>You can download the values corresponding to the data points.</li>
</ul>
<h3><b><i>Kaplan-Meier plots</i></b></h3>
<ul>
<li>At present, only Kaplan-Meier curves with descending curves are supported. If you find the occasional paper with ascending curves, use the "line plot" function to calculate the values at different time points and use the "Process data" function to convert the data to a format that can be used for meta-analysis.</li>
<li>In general, choose time points in such a way that less of 20% of population at risk have developed the event during the interval (i.e., start and end of the interval).</li>
<li>One should not choose time points beyond the maximum follow-up.</li>
<li>One can also choose fixed time points across studies, for example, 12 months, 36 months, 60 months, and so on.</li>
<li>If there are no events in either group during an interval, it does not contribute to the calculations. For example, if you plan to use fixed time intervals, say 12 months, 36 months, and 60 months, but there are no events between 12 months and 36 months, you can simply obtain the values at 12 months and 60 months.</li>
<li>The probability of no events at a time point cannot be higher than the probability of no events at an earlier time point. For example, the probability of no heart attacks at 60 months cannot be higher than the probability of survival at 12 months or 36 months.</li>
<li>If there are no events in one group during an interval, this contributes to the calculations. However, this can mean that when you select the data points for the intervention with no events, as you click the data points, you might have selected a data point which is a fraction higher than the previous data point inadvertently. This will result in non-conversion of the results to a format required for meta-analysis. One option is to click again without moving the pointer. Because of the "binding" function, both the data points will be calculated as having the same values. For example, if there are no events in one of the groups between 12 months and 36 months, you can move the pointer to a level that represents 12 months and click twice. This will calculate the same value for both 12 months and 36 months. Alternatively, you can obtain the datapoint values, make any corrections, and use the "Process data" function to convert the data to a format suitable for meta-analysis.</li>
<li>One needs to enter the minimum and maximum follow-up for the calculation of hazard ratio. This is the preferred option. If this is not available directly available from the report, you can obtain this information or estimate this information from other values. One way is to record the earliest "censoring", indicated usually by small vertical lines in the Kaplan-Meier curves (as in the sample Kaplan-Meier plot) or by crosses. One can click on the earliest "censoring" in any of the groups and the last "censoring" in any of the groups. If this is not available it can be estimated from other parameters such as "Median follow-up and recruitment duration", "Date of analysis, date of first recruitment, and last recruitment", or  "Data of submission, date of first recruitment, and last recruitment" in that order of preference.</li>
<li>One also needs the number of participants in each group for the calculations.</li>
<li>In a direct comparison review, which involves a broad comparison, say platelet inhibitors versus "no treatment", you might find trials which compare two different platelet inhibitors, say aspirin and clopidogrel versus placebo. In such a situation, one option might be to include comparisons of aspirin versus placebo and clopidogrel versus placebo in the same analysis. However, this might mean that the same participans from placebo are included twice in the analysis, which is incorrect. If you are extracting data from Kaplan-Meier plots, you can divide the number of participants in placebo group by the number of intervention groups (i.e., two in this case: aspirin and clopidogrel) while entering the information about the number of participants. For example, if the numbers of participants included in the aspirin, clopidogrel, and placebo groups were 100, 102, and 100, you would extract data points related to aspirin versus placebo first, and enter the number of participants as 100 and 50 (100 divided by 2) to calculate the data in a format suitable for meta-analysis for aspirin versus placebo. In the second extraction, you would extract data points related to clopidogrel versus placebo, and enter the number of participants as 102 and 50 (100 divided by 2)  to calculate the data in a format suitable for meta-analysis for clopidogrel versus placebo. For network meta-analysis, you can select 3 groups, extract the data for all three groups in a single data extraction, and not alter the number of participants.</li>
</ul>
<h3><b><i>References</i></b></h3>
<ul>
<li>Tierney, J.F., Stewart, L.A., Ghersi, D. et al. Practical methods for incorporating summary time-to-event data into meta-analysis. Trials 8, 16 (2007). 
https://doi.org/10.1186/1745-6215-8-16</li>
</ul>
')
Instructions_PlotExtract_2 <- ('
<h3><b><i>Start data extraction from plots by uploading a plot below</i></b></h3>
')
Instructions_Process_Int_1 <- ('
<h3 style = "font-size:24px; color:purple;"><b>Instructions for processing data for intervention reviews</b></h3>
<ul>
<li>This function allows you to compare the data and convert the data into a format suitable for meta-analysis.</li>
<li>You can either perform single conversion or batch conversion.</li>
<li>For single conversion, you need to enter the information for each study manually in the field. 
When you have entered the minimum data required, you will be able to submit the data to perform the calculations. 
Unless you move the slider, the slider input is not included. 
Therefore, if the submit button does not appear, move the slider input.</li>
<li>If do not see the results after clicking the submit button, please scroll up to view the results.</li>
<li>For batch conversions, you need to upload a file with the data prepared in a suitable format. This is the most efficient way to convert data into a format that is suitable for meta-analysis. All the conversions except for calculation of ln hazard ratio and its standard error from a survival table (estimated probability of events or no events at different time points), conversions between units can be done by batch conversions, and calculations of within-participant standard deviation and correlation coefficient in cross-over trials are done automatically when you upload the file.</li>
<li>If you used the data extraction form prepared using the program, you can simply upload the data extraction form. If no sheets have been deleted or headings altered and the data has been extracted in the correct format as per the instructions, the batch conversions will be performed without any requirement for additional data preparation. 
However, this works only on a local version because of the memory required to perform this function.</li>
<li>All file upload options will be restricted to csv format except for the data extraction form. We recommend downloading the sample file from the left panel to view the column names and how data is prepared. The column names should be exactly the same as those in the sample file. The column names are usually self-explanatory. Any additional instructions for preparation of files are shown below.</li>
</ul>
<h3 style = "font-size:24px; color:purple;"><b>Preparation of data for risk of bias tools</b></h3>
<ul>
<li>For signalling questions, the only recognized text are: "Y","PY","N","PN","NI","NA" or "Yes", "Probably Yes", "No", "Probably No", "No Information", "Not Applicable".</li>
<li>There is no schema for domain classifications for ROBINS-I and classifications of risk of bias at the domain level have to be done based on judgement. </li>
<li>For the ROBINS-I domain classifications, the only recognized text are: "low", "moderate", "no information", "ni", "serious", "critical" or "Low risk of bias", "Moderate risk of bias", "No Information", "No Information", "Serious risk of bias", "Critical risk of bias".</li>
<li>Any other text for signalling questions for all tools and domain classifications for ROBINS-I will be removed.</li>
<li>Please see the comments column in the output file to check whether there were any missing answers. If any answers were missing, the classifications may be incorrect. Therefore, complete the answers and repeat the classifications.</li>
</ul>
<h3 style = "font-size:24px; color:purple;"><b>Preparation of data for single conversion of Kaplan-Meier data</b></h3>
<ul>
<li>You can calculate the ln hazard ratio and its standard error for multiple groups in the same file. The last column will be considered the comparator group.</li>
<li>he file should contain only numbers or empty rows. No text should be entered. Even if you are entering the information about survival in the groups in percentages, you should not add "%" to the end of the percentages. The programme will automatically find if you supplied a decimal fraction or percentage as long as you are consistent across every time point. </li>
<li>The file must have at least five columns with the first three specific column names. The subsequent columns can be named in any format, but we recommend calling the intervention, "intervention" and comparator "comparator". If there are multiple interventions compared with the comparator, you can call the columns, "intervention.1", "intervention.2", "intervention.3", etc., or by entering the names of the interventions, for example, "aspirin", "clopidogrel" etc.  </li>
<li>All column names are case sensitive and are should not have empty spaces before or after the names.</li>
<ul>
<li><b>Column 1</b>: "follow_up" (without the quotes): enter the minimum follow-up in the row below the column name and the maximum follow-up in the following row. If the minimum and maximum follow-up are missing, leave the rows empty, but you still need to name the first column, "follow-up".</li>
<li><b>Column 2</b>: "participants" (without the quotes): enter the number of participants in each group. The number of participants should be entered for each group.</li>
<li><b>Column 3</b>: "time_points" (without the quotes): enter the time points. The first time point (i.e., row below the column name row) should always be 0. The subsequent rows should be in the same units as the minimum and maximum follow up. For example, if the minimum follow up was in months, the time points should be in months; if the minimum follow up was in days, the time points should be in days; and so on. The time points should always be in ascending order.</li>
<li><b>Column 4 onwards</b>: If the curve is descending (the usual case), you must enter the proportion without events in each row. If you are entering the data on proportion without events in percentage (0 to 100), the values in all groups should be in percentage; if you are entering the decimal fractions (0 to 1), the values in all groups should be in decimal fractions. For example, at time point 0, the number without event will be 100 if you used percentage and 1 if you used decimal fractions. The subsequent numbers should always be less than or equal to the previous numbers. If the curve is ascending, you must enter the cumulative proportion of people with events (i.e., proportion of people with events by a certain time-point) in percentage or in decimal fractions. The value in all group at time point  0 should be 0. The subsequent numbers should always be more than or equal to the previous numbers.</li>
</ul>
</ul>
')
Instructions_Process_Int_2 <- ('
<h3><b><i>Start data processing by selecting one of the options below</i></b></h3>
')
Instructions_Interpret_Int_1 <- ('
<h3 style = "font-size:24px; color:purple;"><b>Instructions for interpretation of data</b></h3>
<ul>
<li>All the files to be uploaded should be in csv format. The files and data entry are self-explanatory in most instances. Please check the sample data available in the left panel for correct column names. Specific instructions for data preparation are available below.</li>
</ul>
<h3 style = "font-size:24px; color:purple;"><b>Assessment of consistency of effect modification</b></h3>
<ul>
<li>Standard instructions about the file format (".csv") and column names matching those of the sample file apply.</li>
<li>In addition, the file for the assessment of consistency of effect modification should include exactly two subgroups and each study under the outcome must have exactly two rows (one for each subgroup).</li>
<li>The effect estimates for preparation of this file can be obtained from the forest plots of the standard meta-analysis files.</li>
</ul>
<h3 style = "font-size:24px; color:purple;"><b>ROB-ME Signalling question 4.2: Find the most favourable results for a study and perform a sensitivity analysis imputing results for missing study </b></h3>
<ul>
<li>Standard instructions about the file format (".csv") and column names matching those of the sample file apply.</li>
<li>The data for this file are the first 10 columns from the data used for meta-analysis.
In the next four columns, one has to enter the studies where missing data are likely to be because of the outcome results.</li>
<ul>
<li><i>Column 11: </i>Enter the name of the studies. If more than one outcome is missing from the study report because of outcome results, add new row for each missing outcome. A study which does not report any outcome (i.e., does not feature in the outcome data) can also be included here.</li>
<li><i>Column 12: </i>Enter the name of the missing outcome. Only outcomes with some data suitable for meta-analysis in the first 10 columns should be included.</li>
<li><i>Column 13: </i>Enter the number of participants in the intervention group. If the information on the number of participants is not available from the study record, enter the total number of participants in the study. In such a case, an assumption of equal allocation will be made.</li>
<li><i>Column 14: </i>Enter the number of participants in the intervention group. If the information on the number of participants is not available from the study record, enter the total number of participants in the study. In such a case, an assumption of equal allocation will be made.</li>
</ul>
<li>Please note that only the results with number of participants in the data are included for this sensitivity analysis. 
This is because the number of participants in the study with the best results is required for the calculation of the standard error in the new study whose sample size might differ from the study with the best results.</li>
<li>The adjustment of standard error for the studies with missing data is done all measures other than the effect measure "ratio of means" when you use the option "Summary_Ratio" rather than providing the raw data. 
The adjustment of standard error for the studies with missing data is performed even for this measure when the means and standard deviations along with the numbers of participants are provided for each group.</li> 
</ul>
<h3 style = "font-size:24px; color:purple;"><b>ROB-ME classification</b></h3>
<ul>
<li>For signalling questions, the only recognized text are: "Y","PY","N","PN","NI","NA" or "Yes", "Probably Yes", "No", "Probably No", "No Information", "Not Applicable".</li>
</ul>
<h3 style = "font-size:24px; color:purple;"><b>Calculating the means and medians in comparator group</b></h3>
<ul>
<li>This is possible from the data extracted for binary, continuous, and count outcomes only. For continuous outcomes, the control group proportion at a specified time-point has to be obtained from the Kaplan-Meier plot. Only the median control group proportion is available for time-to-event outcomes.</li>
<li>The entry in the study, outcome, and outcome type columns are self-explanatory. Only the entries in parameter1 and parameter2 need further explanation.</li>
<ul>
<li>For binary outcomes, enter the number of participants with events and total number of participants in the comparator group in parameter1 and parameter2.</li>
<li>For continuous outcomes, enter the mean (or median when mean is not available) and total number of participants in the comparator group in parameter1 and parameter2.</li>
<li>For count outcomes, enter the number of events and total number of participants in the comparator group in parameter1 and parameter2.</li>
<li>For time-to-event outcomes, enter the proportion of participants who develop the event. As mentioned above, this can be obtained from the Kaplan-Meier plot and is available in the output file if you used this program to extract the information from Kaplan-Meier plot. When you enter the proportion, please enter the percentage without the "%" symbols. If you enter the "%" at the end, such values will be ignored resulting in errors.</li>
</ul>
</ul>
')
Instructions_Interpret_Int_2 <- ('
<h3><b><i>Start data interpretation by selecting one of the options below</i></b></h3>
')
# User interface ####
ui <- fluidPage(
  # Change background colour and decide alignments spacing etc for headings
  tags$head(
    tags$style(HTML('
        body {background-color: aliceblue;color: black;}
        p {text-align: left; margin-top: 3px; margin-bottom: 2px;line-height: 1.6;font-family:Sans-Serif}
        h1 {text-align: center;font-family:arial bold;}
        h2 {text-align: center; margin-top: 6px;font-family:arial bold;}
        h3 {text-align: left; margin-top: 6px;font-family:arial bold;}
        h4 {text-align: center; margin-top: 3px;font-family:arial bold;}
        table, th, td, tbody {border-collapse: collapse}
        table, th, td {border: 1px solid black}
        th, td {padding-top: 5px;
                padding-bottom: 5px;
                padding-left: 10px;
                padding-right: 10px;}
        th {color: white; background: darkgreen; }
        table.center {margin-left: auto; margin-right: auto;}
        #MA_Int{background-color:darkgreen; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #skip_instructions_Int{background-color:maroon; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #DataUpload_instructions_page_Int{background-color:purple; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #UploadData_Int{background-color:darkviolet; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #Reset_MA{background-color:purple; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #Reset_MetaAnalysisPlan_Int{background-color:purple; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #Reset_MetaAnalysisPlan_Int_2{background-color:purple; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #Modify_MA_Row{background-color:darkgreen; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #Modify_MA_RowsOfSimilarType{background-color:darkviolet; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #ModifyOneMoreMA_Row{background-color:darkgreen; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #Run_MetaAnalysisPlan{background-color:darkblue; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #ReferenceScreener{background-color:darkblue; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #references_one_more{background-color:darkgreen; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #skip_instructions_references{background-color:maroon; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #DEF{background-color:purple; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #skip_instructions_DEF_Int{background-color:maroon; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #DEF_Plan_Int_Change_Choice{background-color:purple; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #DEF_Plan_Int_plan_submit{background-color:darkgreen; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #DEF_ImportSummary_Change_Choice{background-color:darkblue; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #DEF_Create_One_more{background-color:purple; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #OCR{background-color:darkgreen; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #OCR_one_more{background-color:darkgreen; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #skip_instructions_OCR{background-color:maroon; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #PlotExtract{background-color:darkblue; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #PlotExtract_UploadPlot{background-color:darkblue; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #PlotExtract_UploadNewPlot{background-color:darkblue; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #PlotExtract_PlotRotate{background-color:purple; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #PlotExtract_DownloadModifiedPlot{background-color:darkblue; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #PlotExtract_Confirm_DataPoints{background-color:darkgreen; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #PlotExtract_Skip_MinMax{background-color:purple; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #PlotExtract_KM_Submit_Group_Numbers{background-color:darkgreen; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #PlotExtract_DownloadResults{background-color:darkgreen; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #PlotExtract_Confirm_PlotType{background-color:darkgreen; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #PlotExtract_Change_PlotType{background-color:purple; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #PlotExtract_Confirm_y_min_y_max{background-color:darkgreen; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #PlotExtract_Change_y_min_y_max{background-color:purple; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #PlotExtract_Confirm_Groups{background-color:darkgreen; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #PlotExtract_Change_Groups{background-color:purple; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #PlotExtract_Confirm_TimePoints{background-color:darkgreen; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #PlotExtract_Change_TimePoints{background-color:purple; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #PlotExtract_Confirm_KM_TimePoints{background-color:darkgreen; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #PlotExtract_Change_KM_TimePoints{background-color:purple; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #PlotExtract_KM_Min_Max_Reset_Questions{background-color:purple; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #PlotExtract_KM_Min_Max_Submit_Questions{background-color:darkgreen; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #PlotExtract_ResetPlot{background-color:maroon; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #PlotExtract_Remove_Last{background-color:maroon; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #skip_instructions_PlotExtract{background-color:maroon; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #Process_Int{background-color:purple; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #Process_Int_Submit_input{background-color:darkgreen; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #Process_Int_Change_menu{background-color:darkblue; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #skip_instructions_Process_Int{background-color:maroon; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #Interpret_Int{background-color:darkgreen; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #Interpret_Int_Submit_input{background-color:darkgreen; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #Interpret_Int_Change_menu{background-color:darkblue; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
        #skip_instructions_Interpret_Int{background-color:maroon; text-align:center; font-size: 26px; font-family:arial bold; color: white;}
      '))
  ),
  # Title panel
  fluidRow(headerPanel(div(
    column(width = 1, HTML('<p><img src = "Logo.png" width="194.4" height="214.5" /></p>')), 
    column(width = 8, offset= 2, HTML('<h1 style = "color:white; background-color:darkblue; font-family:arial bold;"><b>Meta-analysis in systematic reviews of intervention</b></h1>')),
    column(width = 8, offset= 2, HTML('<h2 style = "color:#254636; font-family:arial bold;"><b>Evidence-Based Healthcare: Best Information for Best Practice</b></h2>')),
    column(width = 8, offset= 2, HTML('<h3 style = "color:#254636; font-family:arial bold;; text-align:center"><b>Developed by: </b><i>Professor Kurinchi Gurusamy, University College London</i></h3>')),
    column(width = 8, offset= 2, HTML('<h2 style = "color:#254636; font-family:arial bold;"><b>EQUity through biomedicAL research (EQUAL) group</b></h2>')),
  ))),
  
  # Split the user interface into two - the sidebar for input and main panel for output
  sidebarLayout(
    # Side panel
    sidebarPanel(
      width = 3,
      radioButtons("Activity", HTML('<p style = "font-size:18px"><b>I want to: </b></p>'), choices = FirstSelection[1:2], inline = FALSE, width = "100%"),
      HTML('<h3><b>Download Training resources</b></h3>'),
      downloadButton("SampleData_Int", HTML("Sample data (intervention review)")),
      HTML('<br><br>'),
      downloadButton("SampleMetaAnalysisPlan_Int", HTML("Sample Meta-analysis plan (interv. review)")),
      HTML('<br><br>'),
      downloadButton("SampleIndex_references", HTML("Sample Index file (references)")),
      HTML('<br><br>'),
      downloadButton("SampleKeywords_references", HTML("Sample Keywords file (references)")),
      HTML('<br><br>'),
      downloadButton("SampleCriteria_DEF", HTML("Sample Criteria file (Data extraction form)")),
      HTML('<br><br>'),
      downloadButton("SampleOther_characteristics_DEF", HTML("Sample Characteristics file (Data extr. form)")),
      HTML('<br><br>'),
      downloadButton("SampleOutcomes_DEF_Int", HTML("Sample Outcomes file (Data extraction form)")),
      HTML('<br><br>'),
      downloadButton("SampleDEF_Plan", HTML("Sample Data extr. plan file (Data extr. form)")),
      HTML('<br><br>'),
      downloadButton("SampleKM_Plot", HTML("Sample Kaplan-Meier plot file (Data extr.)")),
      HTML('<br><br>'),
      downloadButton("SampleBox_Plot", HTML("Sample Box plot file (Data extraction)")),
      HTML('<br><br>'),
      downloadButton("SampleBar_Plot", HTML("Sample Bar plot file (Data extraction)")),
      HTML('<br><br>'),
      downloadButton("SampleLine_Plot", HTML("Sample Line plot file (Data extraction)")),
      HTML('<br><br>'),
      downloadButton("Sample_IPD_cross_over", HTML("Sample cross-over IPD (Data processing)")),
      HTML('<br><br>'),
      downloadButton("Sample_KM_Ascending", HTML("Sample KM ascending (Data processing)")),
      HTML('<br><br>'),
      downloadButton("Sample_KM_Descending", HTML("Sample KM descending (Data processing)")),
      HTML('<br><br>'),
      downloadButton("Sample_Pre_analysis", HTML("Sample pre-analysis (Data processing)")),
      HTML('<br><br>'),
      downloadButton("Sample_rob2", HTML("Sample rob2 (Data processing)")),
      HTML('<br><br>'),
      downloadButton("Sample_rob2_cluster", HTML("Sample rob2-cluster (Data processing)")),
      HTML('<br><br>'),
      downloadButton("Sample_rob2_cross_over", HTML("Sample rob2-cross-over (Data processing)")),
      HTML('<br><br>'),
      downloadButton("Sample_robins_i", HTML("Sample robins-i (Data processing)")),
      HTML('<br><br>'),
      downloadButton("Sample_Clinical_interpretation", HTML("Sample clinical interpretation (Interpretation)")),
      HTML('<br><br>'),
      downloadButton("Sample_Effect_modification_similar", HTML("Sample effect modification (Interpretation)")),
      HTML('<br><br>'),
      downloadButton("Sample_Outcomes_studies", HTML("Sample studies in outcomes (Interpretation)")),
      HTML('<br><br>'),
      downloadButton("Sample_ROB_ME_most_favourable_results", HTML("Sample ROB-ME sens. analysis (Interpretation)")),
      HTML('<br><br>'),
      downloadButton("Sample_ROB_ME_signalling_questions", HTML("Sample ROB-ME signal. quest (Interpretation)")),
      HTML('<br><br>'),
      downloadButton("Sample_Outcomes_risk_of_bias", HTML("Sample bias in outcomes (Interpretation)")),
      HTML('<br><br>'),
      downloadButton("Sample_Minimal_important_difference", HTML("Sample min. important diff. (Interpretation)")),
      HTML('<br><br>'),
      downloadButton("Sample_Large_Very_Large_effect", HTML("Sample large very large effect (Interpretation)")),
      HTML('<br><br>'),
      downloadButton("Sample_Calculate_comparator_group_values", HTML("Sample comparator summary (Interpretation)")),
      HTML('<br><br>'),
      downloadButton("Sample_Convert_to_differences", HTML("Sample ratios to differences (Interpretation)")),
      HTML('<h3><b>Convert Review Manager output into suitable format</b></h3>'),
      fileInput("Upload_RevMan5", "Please upload the RevMan 5 data (Accepted format: txt, csv)",
                multiple = FALSE,
                accept = c(".txt",".csv")
      ),
      fileInput("Upload_RevManWeb", "Please upload the RevMan Web data (Accepted format: txt, csv)",
                multiple = FALSE,
                accept = c(".txt",".csv")
      ),
      downloadButton("ProcessedRevManData_Int", HTML("Download processed RevMan data")),
      HTML('<h3><b>Code to run the analysis in R</b></h3>'),
      downloadButton("Code_Int", HTML("Download R Code to run the analysis")),
      HTML('<h3><b>Download the full programme code</b></h3>'),
      downloadButton("ProgrammeCode", HTML("Download Full programme code")),
    ),
    mainPanel(
      # Create input and output tabs
      fluidRow(
        htmlOutput("htmlTitle")
      ),
      fluidRow(
        column(width=12, 
               tabsetPanel(id = "ActivitySelector",
                           type = "hidden",
                           tabPanelBody("panel1",
                                        column(width = 12,
                                               htmlOutput("htmlInstructions")
                                        ),
                           ),
                           tabPanelBody("panel2",
                                        column(width=12,
                                               tags$div(id = "div_Menu", tags$style("#div_Menu div {margin-bottom: 10px}"),
                                                        fluidRow(
                                                          column(width = 6,
                                                                 actionButton("MA_Int","Perform meta-analysis in systematic reviews of intervention")
                                                          ),
                                                        ),
                                                        fluidRow(
                                                          column(width = 6, 
                                                                 actionButton("ReferenceScreener","Combine database searches and highlight key words")
                                                          ),
                                                        ),
                                                        fluidRow(
                                                          column(width = 6, 
                                                                 actionButton("DEF","Create data extraction form (this does not work online - download the programme code and run this from local computer.")
                                                          ),
                                                        ),
                                                        fluidRow(
                                                          column(width = 6, 
                                                                 actionButton("OCR","Optical character recognition to enable online translation")
                                                          ),
                                                        ),
                                                        fluidRow(
                                                          column(width = 6, 
                                                                 actionButton("PlotExtract","Extract data from plots")
                                                          ),
                                                        ),
                                                        fluidRow(
                                                          column(width = 6, 
                                                                 actionButton("Process_Int","Process data (Intervention review)")
                                                          ),
                                                        ),
                                                        fluidRow(
                                                          column(width = 6, 
                                                                 actionButton("Interpret_Int","Interpret data (Intervention review)")
                                                          ),
                                                        ),
                                               ),
                                        ),
                           ),
                           tabPanelBody("panel3",
                                        column(width = 12,
                                               uiOutput(outputId = "skip_instructions_Int_UI"),
                                               htmlOutput("htmlInstructions_Int"),
                                               actionButton("DataUpload_instructions_page_Int", "Start analysis by uploading data")
                                        ),
                           ),
                           tabPanelBody("panel4",
                                        column(width=12,
                                               tags$div(id = "div_MetaAnalysisPlan_Int", tags$style("#div_MetaAnalysisPlan_Int div {margin-bottom: 10px}"),
                                                        uiOutput(outputId = "UploadData_Int_UI"),
                                                        htmlOutput("htmlMsg1_Int"),
                                                        htmlOutput("htmlMsg2_Int"),
                                                        HTML("<br>"),
                                                        uiOutput(outputId = "Reset_MetaAnalysisPlan_Int_UI"),
                                                        uiOutput(outputId = "Header_Upload_Data_Int_UI"),
                                                        uiOutput(outputId = "Upload_Data_Int_UI"),
                                                        uiOutput(outputId = "Header_MetaAnalysisPlan_Choice_Int_UI"),
                                                        uiOutput(outputId = "MetaAnalysisPlan_Choice_Int_UI"),
                                                        uiOutput(outputId = "Header_Upload_MetaAnalysisPlan_Int_UI"),
                                                        uiOutput(outputId = "Upload_MetaAnalysisPlan_Int_UI"),
                                                        htmlOutput("htmlUpload_MetaAnalysisPlan_Int_Error_Warning"),
                                                        uiOutput(outputId = "MA_Outcome_UI"),
                                                        uiOutput(outputId = "MA_EffectMeasure_UI"),
                                                        uiOutput(outputId = "MA_ContinuityCorrection_UI"),
                                                        uiOutput(outputId = "MA_RareEventsMethod_UI"),
                                                        uiOutput(outputId = "MA_FixedEffect_UI"),
                                                        uiOutput(outputId = "MA_PredictionInterval_UI"),
                                                        uiOutput(outputId = "MA_HKAdjustment_UI"),
                                                        uiOutput(outputId = "MA_Method_UI"),
                                                        uiOutput(outputId = "MA_Summary_UI"),
                                                        uiOutput(outputId = "MA_Minimum_Studies_UI"),
                                                        uiOutput(outputId = "MA_Metabias_Any_UI"),
                                                        uiOutput(outputId = "MA_Metabias_Heterogeneity_UI"),
                                                        uiOutput(outputId = "MA_IMOR1_UI"),
                                                        uiOutput(outputId = "MA_IMOR2_UI"),
                                                        uiOutput(outputId = "MA_SubgroupSelection_UI"),
                                                        fluidRow(
                                                          column(width= 5, uiOutput(outputId = "Modify_MA_Row_UI"),
                                                          ),
                                                          column(width= 7, uiOutput(outputId = "Reset_MA_UI"),
                                                          ),
                                                        ),
                                                        fluidRow(
                                                          column(width = 8, uiOutput(outputId = "Modify_MA_RowsOfSimilarType_UI"),
                                                          ),
                                                        ),
                                                        htmlOutput("htmlMA_Modify_Msg"),
                                                        fluidRow(
                                                          column(width = 8, uiOutput(outputId = "ModifyOneMoreMA_Row_UI"),
                                                          ),
                                                        ),
                                                        fluidRow(
                                                          column(width = 8, uiOutput(outputId = "Run_MetaAnalysisPlan_UI"),
                                                          ),
                                                        ),
                                                        uiOutput(outputId = "Header_SelectedMetaAnalysisPlan_Int_UI"),
                                                        uiOutput(outputId = "Download_SelectedMetaAnalysisPlan_Int_UI"),
                                                        uiOutput(outputId = "SelectedMetaAnalysisPlan_Int_UI"),
                                                        uiOutput(outputId = "Header_DefaultMetaAnalysisPlan_Int_UI"),
                                                        uiOutput(outputId = "Download_DefaultMetaAnalysisPlan_Int_UI"),
                                                        uiOutput(outputId = "DefaultMetaAnalysisPlan_Int_UI"),
                                                        uiOutput(outputId = "Header_RevManMetaAnalysisPlan_Int_UI"),
                                                        uiOutput(outputId = "Download_RevManMetaAnalysisPlan_Int_UI"),
                                                        uiOutput(outputId = "RevManMetaAnalysisPlan_Int_UI"),
                                               )
                                        ),
                           ),
                           tabPanelBody("panel5",
                                        column(width=12,
                                               tags$div(id = "div_Results_Int", tags$style("#div_Results_Int div {margin-bottom: 16px}"),
                                                        uiOutput(outputId = "Reset_MetaAnalysisPlan_Int_UI_2"),
                                                        uiOutput(outputId = "Header_ResultsTable_Int_UI"),
                                                        uiOutput(outputId = "ResultsTableDownload_Int_UI"),
                                                        uiOutput(outputId = "AllPlots_Download_Int_UI"),
                                                        uiOutput(outputId = "OutcomeSummary_Int_UI"),
                                                        uiOutput(outputId = "ResultsTable_Int_UI"),
                                               ),
                                        ),
                           ),
                           tabPanelBody("panel6",
                                        column(width=12,
                                               tags$div(id = "div_references", tags$style("#div_references div {margin-bottom: 16px}"),
                                                        uiOutput(outputId = "skip_instructions_references_UI"),
                                                        htmlOutput("htmlMsg1_references"),
                                                        uiOutput(outputId = "references_one_more_UI"),
                                                        htmlOutput("htmlInstructions1_references"),
                                                        uiOutput(outputId = "references_file1_UI"),
                                                        uiOutput(outputId = "references_file2_UI"),
                                                        uiOutput(outputId = "download_UI_1_references"),
                                                        uiOutput(outputId = "references_file3_UI"),
                                                        uiOutput(outputId = "download_UI_2_references"),
                                                        htmlOutput("htmlInstructions2_references"),
                                               ),
                                        ),
                           ),
                           tabPanelBody("panel7",
                                        column(width=12,
                                               tags$div(id = "div_DEF_Int", tags$style("#div_DEF_Int div {margin-bottom: 16px}"),
                                                        uiOutput(outputId = "skip_instructions_DEF_Int_UI"),
                                                        htmlOutput("htmlMsg1_DEF_Int"),
                                                        htmlOutput("htmlMsg2_DEF_Int"),
                                                        htmlOutput("htmlInstructions1_DEF_Int"),
                                                        htmlOutput("Header_DEF_Int"),
                                                        uiOutput(outputId = "DEF_Plan_Int_Choice_UI"),
                                                        uiOutput(outputId = "DEF_Plan_Int_Change_Choice_UI"),
                                                        uiOutput(outputId = "DEF_ImportSummary_Change_Choice_UI"),
                                                        uiOutput(outputId = "DEF_Plan_Int_NRS_UI"),
                                                        uiOutput(outputId = "DEF_Plan_Int_cluster_UI"),
                                                        uiOutput(outputId = "DEF_Plan_Int_cross_over_UI"),
                                                        uiOutput(outputId = "DEF_Plan_Int_per_protocol_UI"),
                                                        uiOutput(outputId = "DEF_Plan_Int_intervention_1_name_UI"),
                                                        uiOutput(outputId = "DEF_Plan_Int_intervention_1_short_name_UI"),
                                                        uiOutput(outputId = "DEF_Plan_Int_intervention_2_name_UI"),
                                                        uiOutput(outputId = "DEF_Plan_Int_intervention_2_short_name_UI"),
                                                        uiOutput(outputId = "DEF_Plan_Int_criteria_Upload_UI"),
                                                        uiOutput(outputId = "DEF_Plan_Int_other_characteristics_Upload_UI"),
                                                        uiOutput(outputId = "DEF_Plan_Int_outcomes_Upload_UI"),
                                                        uiOutput(outputId = "DEF_Plan_Int_plan_submit_UI"),
                                                        uiOutput(outputId = "DEF_Plan_Int_Upload_UI"),
                                                        uiOutput(outputId = "DEF_ImportSummary_Choice_UI"),
                                                        uiOutput(outputId = "DEF_ImportSummary_Upload_UI"),
                                                        uiOutput(outputId = "DEF_References_Upload_UI"),
                                                        uiOutput(outputId = "DEF_Plan_Download_UI"),
                                                        uiOutput(outputId = "DEF_Download_UI"),
                                                        htmlOutput("htmlInstructions2_DEF_Int"),
                                               ),
                                        ),
                           ),
                           tabPanelBody("panel8",
                                        column(width=12,
                                               tags$div(id = "div_ocr", tags$style("#div_ocr div {margin-bottom: 16px}"),
                                                        uiOutput(outputId = "skip_instructions_OCR_UI"),
                                                        htmlOutput("htmlMsg1_OCR"),
                                                        uiOutput(outputId = "OCR_one_more_UI"),
                                                        uiOutput(outputId = "OCR_text_Download_UI"),
                                                        htmlOutput("Header_OCR"),
                                                        uiOutput(outputId = "OCR_text_UI"),
                                                        htmlOutput("htmlInstructions1_OCR"),
                                                        uiOutput(outputId = "OCR_language_UI"),
                                                        uiOutput(outputId = "OCR_upload_UI"),
                                                        htmlOutput("htmlInstructions2_OCR"),
                                               ),
                                        ),
                           ),
                           tabPanelBody("panel9",
                                        fluidRow(
                                        column(width=12,
                                               tags$div(id = "div_PlotExtract", tags$style("#div_PlotExtract div {margin-bottom: 16px}"),
                                                        uiOutput(outputId = "skip_instructions_PlotExtract_UI"),
                                                        htmlOutput("Header_PlotExtract"),
                                                        htmlOutput("htmlInstructions1_PlotExtract"),
                                                        column(width = 4,
                                                               uiOutput("PlotExtract_UploadPlot_UI"),
                                                               uiOutput("PlotExtract_UploadNewPlot_UI"),
                                                               uiOutput("PlotExtract_PlotRotate_UI"),
                                                               uiOutput("PlotExtract_DownloadModifiedPlot_UI"),
                                                               htmlOutput("PlotExtract_DisplayNextStep"),
                                                               uiOutput("PlotExtract_Confirm_DataPoints_UI"),
                                                               uiOutput("PlotExtract_Skip_MinMax_UI"),
                                                               uiOutput("PlotExtract_KM_Min_Max_Question_1_UI"),
                                                               uiOutput("PlotExtract_KM_Min_Max_Question_2_UI"),
                                                               uiOutput("PlotExtract_KM_Min_Max_Question_3_UI"),
                                                               uiOutput("PlotExtract_KM_Min_Max_Question_4_UI"),
                                                               uiOutput("PlotExtract_KM_Min_Max_Question_5_UI"),
                                                               uiOutput("PlotExtract_KM_Min_Max_Submit_Questions_UI"),
                                                               uiOutput("PlotExtract_KM_Min_Max_Reset_Questions_UI"),
                                                               uiOutput("PlotExtract_KM_Group_Numbers_1_UI"),
                                                               uiOutput("PlotExtract_KM_Group_Numbers_2_UI"),
                                                               uiOutput("PlotExtract_KM_Group_Numbers_3_UI"),
                                                               uiOutput("PlotExtract_KM_Group_Numbers_4_UI"),
                                                               uiOutput("PlotExtract_KM_Group_Numbers_5_UI"),
                                                               uiOutput("PlotExtract_KM_Group_Numbers_6_UI"),
                                                               uiOutput("PlotExtract_KM_Group_Numbers_7_UI"),
                                                               uiOutput("PlotExtract_KM_Group_Numbers_8_UI"),
                                                               uiOutput("PlotExtract_KM_Group_Numbers_9_UI"),
                                                               uiOutput("PlotExtract_KM_Group_Numbers_10_UI"),
                                                               uiOutput("PlotExtract_KM_Submit_Group_Numbers_UI"),
                                                               uiOutput("PlotExtract_DownloadResults_UI"),
                                                               htmlOutput("PlotExtract_DisplaySelection"),
                                                               htmlOutput("PlotExtract_SelectionMessage"),
                                                               htmlOutput("htmlMsg1_PlotExtract"),
                                                               uiOutput("PlotExtract_PlotType_UI"),
                                                               uiOutput("PlotExtract_Confirm_PlotType_UI"),
                                                               uiOutput("PlotExtract_Change_PlotType_UI"),
                                                               uiOutput("PlotExtract_x_min_UI"),
                                                               uiOutput("PlotExtract_x_max_UI"),
                                                               uiOutput("PlotExtract_y_min_UI"),
                                                               uiOutput("PlotExtract_y_max_UI"),
                                                               uiOutput("PlotExtract_Confirm_y_min_y_max_UI"),
                                                               uiOutput("PlotExtract_Change_y_min_y_max_UI"),
                                                               uiOutput("PlotExtract_Groups_UI"),
                                                               uiOutput("PlotExtract_Confirm_Groups_UI"),
                                                               uiOutput("PlotExtract_Change_Groups_UI"),
                                                               uiOutput("PlotExtract_TimePoints_UI"),
                                                               uiOutput("PlotExtract_Confirm_TimePoints_UI"),
                                                               uiOutput("PlotExtract_Change_TimePoints_UI"),
                                                               uiOutput("PlotExtract_KM_TimePoints_1_UI"),
                                                               uiOutput("PlotExtract_KM_TimePoints_2_UI"),
                                                               uiOutput("PlotExtract_KM_TimePoints_3_UI"),
                                                               uiOutput("PlotExtract_KM_TimePoints_4_UI"),
                                                               uiOutput("PlotExtract_KM_TimePoints_5_UI"),
                                                               uiOutput("PlotExtract_KM_TimePoints_6_UI"),
                                                               uiOutput("PlotExtract_KM_TimePoints_7_UI"),
                                                               uiOutput("PlotExtract_KM_TimePoints_8_UI"),
                                                               uiOutput("PlotExtract_KM_TimePoints_9_UI"),
                                                               uiOutput("PlotExtract_KM_TimePoints_10_UI"),
                                                               uiOutput("PlotExtract_Confirm_KM_TimePoints_UI"),
                                                               uiOutput("PlotExtract_Change_KM_TimePoints_UI"),
                                                        ),
                                                        column(width = 8,
                                                               fluidRow(
                                                                 column(width = 6,
                                                                        uiOutput("PlotExtract_ResetPlot_UI"),
                                                                 ),
                                                                 column(width = 6,
                                                                        uiOutput("PlotExtract_Remove_Last_UI"),
                                                                 ),
                                                               ),
                                                               fluidRow(
                                                                 uiOutput("PlotExtract_UploadedPlot_UI"),
                                                               ),
                                                        ),
                                               ),
                                        ),
                                        ),
                                          column(width = 4,
                                                 htmlOutput("htmlInstructions2_PlotExtract"),
                                          ),
                           ),
                           tabPanelBody("panel10",
                                        column(width=12,
                                               tags$div(id = "div_Process_Int", tags$style("#div_Process_Int div {margin-bottom: 16px}"),
                                                        uiOutput(outputId = "skip_instructions_Process_Int_UI"),
                                                        uiOutput("Process_Int_Change_menu_UI"),
                                                        htmlOutput("htmlMsg1_Process_Int"),
                                                        uiOutput("Process_Int_download_UI"),
                                                        htmlOutput("htmlInstructions1_Process_Int"),
                                                        uiOutput("Process_Int_Menu_UI"),
                                                        htmlOutput("Header_Process_Int"),
                                                        uiOutput("Process_Int_input_1_UI"),
                                                        uiOutput("Process_Int_input_2_UI"),
                                                        uiOutput("Process_Int_input_3_UI"),
                                                        uiOutput("Process_Int_input_4_UI"),
                                                        uiOutput("Process_Int_input_5_UI"),
                                                        uiOutput("Process_Int_input_6_UI"),
                                                        uiOutput("Process_Int_Submit_input_UI"),
                                                        htmlOutput("htmlInstructions2_Process_Int"),
                                               ),
                                        ),
                           ),
                           tabPanelBody("panel11",
                                        column(width=12,
                                               tags$div(id = "div_Interpret_Int", tags$style("#div_Interpret_Int div {margin-bottom: 16px}"),
                                                        uiOutput(outputId = "skip_instructions_Interpret_Int_UI"),
                                                        uiOutput("Interpret_Int_Change_menu_UI"),
                                                        htmlOutput("htmlMsg1_Interpret_Int"),
                                                        uiOutput("Interpret_Int_download_UI"),
                                                        htmlOutput("htmlInstructions1_Interpret_Int"),
                                                        uiOutput("Interpret_Int_Menu_UI"),
                                                        htmlOutput("Header_Interpret_Int"),
                                                        uiOutput("Interpret_Int_input_1_UI"),
                                                        uiOutput("Interpret_Int_input_2_UI"),
                                                        uiOutput("Interpret_Int_input_3_UI"),
                                                        uiOutput("Interpret_Int_input_4_UI"),
                                                        uiOutput("Interpret_Int_input_5_UI"),
                                                        uiOutput("Interpret_Int_input_6_UI"),
                                                        uiOutput("Interpret_Int_Submit_input_UI"),
                                                        htmlOutput("htmlInstructions2_Interpret_Int"),
                                               ),
                                        ),
                           ),
               ),
               # tabs end here  
        )          
      )),
  ),
)

# Processing ####
server <- function(input, output, session) {
  # Reactive values and other initial declarations ####
  rv <- reactiveValues(
    InputData = NULL,
    outcome.summary_Int = NULL,
    df_Outcome = NULL,
    MA = NULL,
    MetaBias = NULL,
    SA = NULL,
    MetaReg = NULL,
    Subgroup_1 = NULL,
    Subgroup_2 = NULL,
    Subgroup_3 = NULL,
    Subgroup_4 = NULL,
    Subgroup_5 = NULL,
    Subgroup_6 = NULL,
    Subgroup_7 = NULL,
    Subgroup_8 = NULL,
    Subgroup_9 = NULL,
    Subgroup_10 = NULL,
    Metabias.Min = NULL,
    SelectedCovariates = NULL,
    SelectedCovariatesColumns = NULL,
    SelectedCovariatesColumnsSubgroup = NULL,
    MetaRegText = NULL,
    OldColumnNames = NULL,
    NewColumnNames = NULL,
    DefaultMetaAnalysisPlan = NULL,
    RevManMetaAnalysisPlan_Int = NULL,
    UploadedMetaAnalysisPlan_Int = NULL,
    EffectMeasure = NULL,
    Analysis = NULL,
    UploadPlanCheck = NULL,
    ResetData= NULL,
    ResetPlan = NULL,
    ModifyPlan = NULL,
    RunAnalysis = NULL,
    AcceptModification = NULL,
    RowsForModification = NULL,
    OutcomeRow = NULL,
    plot1 = NULL,
    plot2 = NULL,
    plot3 = NULL,
    plotSA1 = NULL,
    plotSA2 = NULL,
    plotSA3 = NULL,
    plotSubA1 = NULL,
    plotSubA2 = NULL,
    plotSubA3 = NULL,
    plotSubA4 = NULL,
    plotSubA5 = NULL,
    plotSubA6 = NULL,
    plotSubA7 = NULL,
    plotSubA8 = NULL,
    plotSubA9 = NULL,
    plotSubA10 = NULL,
    FinalPlot1 = NULL,
    FinalPlot2 = NULL,
    FinalPlot3 = NULL,
    FinalPlotSA1 = NULL,
    FinalPlotSA2 = NULL,
    FinalPlotSA3 = NULL,
    FinalPlotSubA1 = NULL,
    FinalPlotSubA2 = NULL,
    FinalPlotSubA3 = NULL,
    FinalPlotSubA4 = NULL,
    FinalPlotSubA5 = NULL,
    FinalPlotSubA6 = NULL,
    FinalPlotSubA7 = NULL,
    FinalPlotSubA8 = NULL,
    FinalPlotSubA9 = NULL,
    FinalPlotSubA10 = NULL,
    StorageFolder = StorageFolder,
    RevManData = NULL,
    RevManProcessed = NULL,
    Comparisons1 = NULL,
    Comparisons2 = NULL,
    Comparisons3 = NULL,
    GenerateCode = GenerateCode,
    ColumnNamesForCodes = NULL,
    OutcomeNamesForCodes = NULL,
    # Combine databases and highlight references
    index.file.full.name = NULL,
    reference.files.full.names = NULL,
    index.file.path = NULL, 
    index.file = NULL, 
    references.file = NULL,
    keywords.file.full.name = NULL,
    results = NULL,
    files.list.1 = NULL,
    files.list.2 = NULL,
    DEF_other_characteristics =  NULL,
    DEF_criteria =  NULL,
    DEF_outcomes =  NULL,
    x=NULL,
    y=NULL,
    UploadedPlot = NULL,
    x_pixels = NULL,
    y_pixels = NULL,
    plot_number = NULL,
    x_min = NULL,
    x_max = NULL,
    y_min = NULL,
    y_max = NULL,
    KM_TimePoints = NULL,
    points_max = NULL,
    points_names = NULL,
    points_times_groups = NULL,
    points_colours = NULL,
    points_colours_viridis = NULL,
    points_symbol = NULL,
    points_values = NULL,
    group_numbers = NULL,
    lines_required = NULL,
    KM_Calculations_Step1 = NULL,
    KM_Calculations_Step2 = NULL,
    PlotExtract_FinalResults = NULL,
    Process_Int_submit_button_to_appear = FALSE,
    Process_Int_input =   Process_Int_input,
    Interpret_Int_submit_button_to_appear = FALSE,
    Interpret_Int_input =   Interpret_Int_input
  )
  output$htmlInstructions <- renderUI(HTML(Instructions))
  output$htmlInstructions_Int <- renderUI(HTML(Instructions_Int))
  output$htmlInstructions1_references <- renderUI(HTML(paste0(
    Instructions_references_1,Instructions_references_2
  )))
  output$htmlInstructions1_DEF_Int <- renderUI(HTML(paste0(
    Instructions_DEF_Int_1, Instructions_DEF_Int_2
  )))
  output$htmlInstructions1_OCR <- renderUI(HTML(paste0(
    Instructions_OCR_1, Instructions_OCR_2
  )))
  output$htmlInstructions1_PlotExtract <- renderUI(HTML(paste0(
    Instructions_PlotExtract_1, Instructions_PlotExtract_2
  )))
  output$htmlInstructions1_Process_Int <- renderUI(HTML(paste0(
    Instructions_Process_Int_1, Instructions_Process_Int_2
  )))
  output$htmlInstructions1_Interpret_Int <- renderUI(HTML(paste0(
    Instructions_Interpret_Int_1, Instructions_Interpret_Int_2
  )))
  output$skip_instructions_Int_UI <- renderUI(
    actionButton("skip_instructions_Int", "Skip instructions")
  )
  output$skip_instructions_references_UI <- renderUI(
    actionButton("skip_instructions_references", "Skip instructions")
  )
  output$skip_instructions_DEF_Int_UI <- renderUI(
    actionButton("skip_instructions_DEF_Int", "Skip instructions")
  )
  output$skip_instructions_OCR_UI <- renderUI(
    actionButton("skip_instructions_OCR", "Skip instructions")
  )
  output$skip_instructions_PlotExtract_UI <- renderUI(
    actionButton("skip_instructions_PlotExtract", "Skip instructions")
  )
  output$skip_instructions_Process_Int_UI <- renderUI(
    actionButton("skip_instructions_Process_Int", "Skip instructions")
  )
  output$skip_instructions_Interpret_Int_UI <- renderUI(
    actionButton("skip_instructions_Interpret_Int", "Skip instructions")
  )
  
  rv$ResetData = "No"
  rv$ResetPlan <- NULL
  rv$ModifyPlan <- NULL
  rv$RunAnalysis <- NULL
  rv$AcceptModification <- NULL
  
  # Now for the observe events
  # If the main panel changes
  observeEvent(input$Activity, {
    output$htmlTitle <- renderUI(HTML(MainHeaderSelection[match(input$Activity,FirstSelection)]))
    panelchoice <- paste0("panel", match(input$Activity,FirstSelection))
    updateTabsetPanel(inputId = "ActivitySelector", selected = panelchoice)
  })
  # Reference screener events ####
  observeEvent(input$ReferenceScreener, {
    output$htmlTitle <- renderUI(HTML(MainHeaderSelection[6]))
    panelchoice <- "panel6"
    updateTabsetPanel(inputId = "ActivitySelector", selected = panelchoice)
    updateRadioButtons(inputId = "Activity", choices = FirstSelection[c(1:2,6)], 
                       selected = FirstSelection[6])
    output$htmlMsg1_references <- NULL
  })
  observeEvent(input$skip_instructions_references, {
    output$htmlInstructions1_references <- NULL
    output$htmlInstructions2_references <- renderUI(HTML(Instructions_references_1))
    output$skip_instructions_references_UI <- NULL
  })
  output$download_UI_1_references <- NULL
  output$download_UI_2_references <- NULL
  output$references_file1_UI <- renderUI(
    fileInput(
      inputId = "references_file1", 
      label = "Choose Index File", 
      multiple = FALSE,
      accept = c(".csv")
    )
  )
  output$references_file2_UI <- NULL
  output$references_file3_UI <- NULL
  output$references_one_more_UI <- NULL
  observeEvent(input$references_one_more, {
    output$htmlMsg1_references <- NULL
    output$download_UI_1_references <- NULL
    output$download_UI_2_references <- NULL
    output$references_file1_UI <- renderUI(
      fileInput(
        inputId = "references_file1", 
        label = "Choose Index File", 
        multiple = FALSE,
        accept = c(".csv")
      )
    )
    output$references_file2_UI <- NULL
    output$references_file3_UI <- NULL
    output$references_one_more_UI <- NULL
  })
  observeEvent(input$references_file1, {
    if (input$references_file1$datapath != "") {
      rv$index.file.full.name <- str_replace_all(input$references_file1$datapath,
                                                 fixed("\\"),
                                                 "/")
    }
    output$htmlInstructions1_references <- NULL
    output$htmlInstructions2_references <- renderUI(HTML(Instructions_references_1))
    rv$index.file <- read.csv(rv$index.file.full.name,header = TRUE)
    # Check column names
    if (FALSE %in% (colnames(rv$index.file) == c("file.name", "database"))){
      output$htmlMsg1_references <- renderUI(
        HTML('<h2 style="color:red; background-color:yellow"><b>
      The column names should be "file.name" and "database" (without the quotes). Please see sample download from left side panel for the correct column names.</b></h2>')  
      )
    } else if(nrow(rv$index.file) < 1) {
      output$htmlMsg1_references <- renderUI(
        HTML('<h2 style="color:red; background-color:yellow"><b>
      There is no data in this file. Please upload a file with data.</b></h2>')  
      )
    } else if (FALSE %in% !is.na(match(rv$index.file$database, database))) {
      output$htmlMsg1_references <- renderUI(
        HTML(paste0(
          '<h2 style="color:red; background-color:yellow"><b>
      There are unrecognised databases in the file. 
        The recognised databases are: ', 
          paste0(database, collapse = ", "),
          '. \nPlease ensure that there are no additional spaces. 
        Please note that the database names are case sensitive.
        </b></h2>'
        ))
      )
    } else {
      output$htmlMsg1_references <- renderUI(
        HTML('<h2 style="color:darkgreen; background-color:yellow">
           <b>Index file uploaded.</b><br>
           <i>Please upload the downloaded search results files...</i>
           </h2>')
      )
      output$references_file1_UI <- NULL
      output$references_file2_UI <- renderUI(
        fileInput(
          inputId = "references_file2", 
          label = "Choose downloaded search results files", 
          multiple = TRUE,
          accept = c(".csv", ".txt", ".xml", ".nbib")
        )
      )
    }
  })
  observeEvent(input$references_file2, {
    if (!is.null(rv$index.file.full.name)){
      if (input$references_file2$datapath[1] != ""){
        if (nrow(input$references_file2) <= nrow(rv$index.file)) {
          output$download_UI_1_references <- renderUI(
            HTML('<strong>Download button for csv files will appear once the processing is completed...</strong>')
          )
          references_file2.path <- str_replace_all(input$references_file2$datapath, fixed("\\"),"/")
          rv$reference.files.full.names <- paste0(
            substr(references_file2.path, 1,
                   str_locate_all(references_file2.path, "/")[[1]][nrow(str_locate_all(references_file2.path, "/")[[1]]),1]
            ),
            input$references_file2$name
          )
          file.rename(
            references_file2.path, 
            rv$reference.files.full.names
          )
          rv$index.file$full.file.name <- paste0(
            substr(references_file2.path, 1,
                   str_locate_all(references_file2.path[1], "/")[[1]][nrow(str_locate_all(references_file2.path[1], "/")[[1]]),1]
            ),
            rv$index.file$file.name
          )
          if (!TRUE %in% !is.na(match(rv$index.file$full.file.name, 
                                      rv$reference.files.full.names))){
            output$htmlMsg1_references <- renderUI(
              HTML('<h2 style="color:red; background-color:yellow"><b>
      None of the files indicated in the index file are present. 
                 Please check whether you have uploaded the correct index file 
                 and the database search results files.</b></h2>')
              
            )
            output$references_file2_UI <- NULL
            output$download_UI_1_references <- NULL
            output$references_file1_UI <- renderUI(
              fileInput(
                inputId = "references_file1", 
                label = "Choose Index File", 
                multiple = FALSE,
                accept = c(".csv")
              )
            )
          }else {
            rv$results <- import.references(rv$index.file.full.name, 
                                            rv$reference.files.full.names)
            # Get the file names
            rv$files.list.1 <- 
              dir(paste0(
                substr(rv$index.file.full.name,1,str_locate_all(rv$index.file.full.name, fixed("/"))[[1]][nrow(str_locate_all(rv$index.file.full.name, fixed("/"))[[1]]),1]),
                "FullDetails/"
              ), full.names = TRUE)
            output$references_file2_UI <- NULL
            output$htmlMsg1_references <- renderUI(
              HTML('<h2 style="color:darkgreen; background-color:yellow">
           <b>Searches combined and references deduplicated.</b><br>
           <i>Results are available below.</i><br>
           If you want keywords highligted, you can upload the keywords.<br>
           <i>If you want to combine another set of search results without highlighting keywords, click on <br>"Combine another set of search results"</i>.
           </h2>')
            )
            output$references_one_more_UI <- renderUI(
              actionButton("references_one_more", "Combine another set of search results")
            )
            output$download_UI_1_references <- renderUI(
              downloadButton("download.csv.references", 
                             HTML("Download the references in each database and deduplicated references")
              )
            )
            output$references_file3_UI <- renderUI(
              fileInput(
                inputId = "references_file3", 
                label = "Choose Keywords File", 
                multiple = FALSE,
                accept = c(".csv")
              )
            )
          }
        } else {
          output$htmlMsg1_references <- renderUI(
            HTML('<h2 style="color:red; background-color:yellow"><b>
      The number of files uploaded was more than the number indicated in the index file. 
                 Please check whether you have uploaded the correct index file 
                 and the database search results files.</b></h2>')
            
          )
          output$references_file2_UI <- NULL
          output$download_UI_1_references <- NULL
          output$references_file1_UI <- renderUI(
            fileInput(
              inputId = "references_file1", 
              label = "Choose Index File", 
              multiple = FALSE,
              accept = c(".csv")
            )
          )
        }
      }
    }
  })
  observeEvent(input$references_file3, {
    if (!is.null(rv$results)){
      if (input$references_file3$datapath[1] != "") {
        rv$keywords.file.full.name <- str_replace_all(input$references_file3$datapath, fixed("\\"),"/")
        rv$keywords.file <- read.csv(rv$keywords.file.full.name,header = TRUE)
        # Check column names
        if (ncol(rv$keywords.file) > 3) {
          output$htmlMsg1_references <- renderUI(
            HTML('<h2 style="color:red; background-color:yellow"><b>
            There has to be a maximum of three columns. The column names should be "keywords" and "concept" (without the quotes). You can also provide an optional "weight" column. Please see sample download from left side panel for the correct column names.</b></h2>')  
          )
        } else if (
          (ncol(rv$keywords.file) == 2) &
          (FALSE %in% (colnames(rv$keywords.file) == c("keywords", "concept")))
        ) {
          output$htmlMsg1_references <- renderUI(
            HTML('<h2 style="color:red; background-color:yellow"><b>
      The column names should be "keywords" and "concept" (without the quotes). You can also provide an optional "weight" column. Please see sample download from left side panel for the correct column names.</b></h2>')  
          )
        } else if (
          (ncol(rv$keywords.file) == 3) &
          (FALSE %in% (colnames(rv$keywords.file) == c("keywords", "concept", "weight")))
        ) {
          output$htmlMsg1_references <- renderUI(
            HTML('<h2 style="color:red; background-color:yellow"><b>
      The column names should be "keywords" and "concept" (without the quotes). You can also provide an optional "weight" column. Please see sample download from left side panel for the correct column names.</b></h2>')  
          )
        } else if(nrow(rv$keywords.file) < 1) {
          output$htmlMsg1_references <- renderUI(
            HTML('<h2 style="color:red; background-color:yellow"><b>
      There is no data in this file. Please upload a file with data.</b></h2>')  
          )
        } else {
          output$htmlMsg1_references <- NULL
          output$download_UI_2_references <- renderUI(
            HTML('<strong>Download button for highlighted files will appear once the processing is completed...</strong>')
          )
          output$references_file3_UI <- renderUI(
            HTML('<h2 style="color:darkgreen; background-color:yellow">
               Keywords file uploaded
               </h2>')
          )
          
          highlight.keywords(rv$results[[1]], rv$keywords.file.full.name, rv$results[[2]])
          # Get the file names
          rv$files.list.2 <- 
            dir(paste0(
              substr(rv$index.file.full.name,1,str_locate_all(rv$index.file.full.name, fixed("/"))[[1]][nrow(str_locate_all(rv$index.file.full.name, fixed("/"))[[1]]),1]),
              "References_to_Screen/"
            ), full.names = TRUE)
          output$download_UI_2_references <- renderUI(
            download