#!/bin/bash
set -x
set -e

bash clean.sh
mkdir -p final_outputs

apt install valgrind libreadline-dev libjemalloc-dev texlive-full build-essential make

echo "BUILDING THE INTERPRETERS"
bash build_all.sh

echo "RUNNING SECTION 2.1 EXPERIMENT"
cd paper-examples/pressure
python3 run.py
bash make_plot.sh
cp plot.pdf ../../final_outputs/section.2.1.pdf
cd ../..

echo "RUNNING SECTION 2.2 EXPERIMENT"
cd paper-examples/finalizers
python3 run.py | tee ../../final_outputs/section.2.2.txt
cd ../..

echo "RUNNING TABLE 1 EXPERIMENT"
cd paper-examples/general
python3 run.py
bash make_table.sh
cp table.pdf ../../final_outputs/table.1.pdf
cd ../..
