import subprocess
from collections import defaultdict
import sys

def main():
    print("First, we're going to run the experiments and collect data in results/")
    subprocess.run("mkdir -p results", shell=True)
    subprocess.run("rm -f results/*", shell=True)
    LUAS = ["unmodified", "ett", "syncc"]
    SETTINGS = ["nolimit", "manual", "limit"]
    for lua in LUAS:
        for setting in SETTINGS:
            run(lua, setting)

def run(which, arg):
    cmd = f"../../bins/{which} memory_pressure.lua {arg}"
    print(f"Running '{cmd}'...")
    stdout = subprocess.run(cmd, shell=True, stdout=subprocess.PIPE).stdout.decode("utf-8")

    stages = [defaultdict(list)]
    stages[-1]["0.00"] = [0]
    for line in stdout.split('\n'):
        if not line.strip(): continue
        try:
            time, mem = line.split("@")[1].split("m")
        except:
            print(line)
            sys.exit(1)
        time = float(time.strip())
        mem = int(mem.strip())
        timestr = f"{time:0.2f}"
        stages[-1][timestr].append(mem)

        op = line.split("@")[0].strip()
        if op == "STAGE":
            stages.append(defaultdict(list))
            last_key, last_val = list(stages[-2].items())[-1]
            stages[-1][last_key] = last_val

    for i, time2mem in enumerate(stages):
        times_file = open(f"results/pressure.{which}.{arg}.stage_{i}.csv", "w")
        last_mem = None
        for time, mems in time2mem.items():
            mem = sum(mems) / len(mems)
            if last_mem is not None:
                times_file.write(f"{time},{last_mem:0.3f}\n")
            times_file.write(f"{time},{min(mems):0.3f}\n")
            times_file.write(f"{time},{max(mems):0.3f}\n")
            last_mem = max(mems)

main()
