START_TIME = os.clock()

math.randomseed(24)
TOTAL_ALLOC = 0
N_ITEMS = 1000000

ALLOC_SIZE = 1
ALLOC_BUFFER = 1000

ALLOC_LIMIT = (ALLOC_SIZE * N_ITEMS) + ALLOC_BUFFER
-- arg[1] can be "limit", "nolimit", or "manual"
ENFORCE_LIMIT = (arg[1] ~= "nolimit")
MANUAL_FREE = (arg[1] == "manual")

local function clock(message)
    local time = os.clock()
    local lpad = 20
    if #message < lpad then
        message = string.rep(" ", lpad - #message) .. message
    end
    print(message, "@", time - START_TIME, "m", TOTAL_ALLOC)
    -- update the START_TIME to ignore time taken printing the clock message
    START_TIME = START_TIME + (os.clock() - time)
end

local function collect_blob(self)
    TOTAL_ALLOC = TOTAL_ALLOC - self.fake_alloc_size
    -- clock("Item collected")
end

local function fresh_blob()
    -- simulate an allocation
    if ENFORCE_LIMIT and TOTAL_ALLOC >= ALLOC_LIMIT then
        clock("Start collection")
        collectgarbage("collect")
        clock("End collection")
        if TOTAL_ALLOC >= ALLOC_LIMIT then
            print("OUT OF MEMORY!")
            os.exit(1)
        end
    end
    TOTAL_ALLOC = TOTAL_ALLOC + ALLOC_SIZE
    -- clock("Allocation")
    local res = setmetatable({fake_alloc_size=ALLOC_SIZE}, {__gc=collect_blob})
    return res
end

local function free_blob(blob)
    TOTAL_ALLOC = TOTAL_ALLOC - blob.fake_alloc_size
    blob.fake_alloc_size = 0
    setmetatable(blob, {})
end

local function fetch_item()
    return {data=fresh_blob(), qos=math.random()}
end

local function process_item(item)
    local work_space = fresh_blob()
    if MANUAL_FREE then
        free_blob(work_space)
    end
    return 1
end

local function compare_qos(a, b)
    return a.qos > b.qos
end

-- stage 1: fetch a lot of items to process
local items = {}
for i=1,N_ITEMS do
    items[i] = fetch_item()
    clock("Iter")
end
clock("STAGE")
-- stage 2: process each item
local summary = 0
for i=1,N_ITEMS do
    summary = summary + process_item(items[i])
    clock("Iter")
end
clock("STAGE")
-- Don't bother GC'ing at the end
io.flush()
os.exit(0)
