N_SLOTS=5

local slot_open = {}
for i=1,N_SLOTS do slot_open[i] = true end

local worklist = {}

os.execute("mkdir -p work")
os.execute("rm -f work/*")

local function path_exists(path)
  local f, _, _ = io.open(path, "r")
  if f then
    f:close()
    return true
  end
  return false
end

local function finalize(descriptor)
  os.remove(descriptor.path)
  slot_open[descriptor.i] = true
end

local function poll()
  -- phase 1: poll for more work
  for i=1,N_SLOTS do
    if slot_open[i] then
      local fname = "work/" .. tostring(i) .. ".txt"
      if path_exists(fname) then
        slot_open[i] = false
        table.insert(worklist,setmetatable({i=i,path=fname},{__gc=finalize}))
      end
    end
  end
end

local function process(item)
    print("Processing ... " .. tostring(item.i))
    item = nil
end

local function drain()
  -- phase 2: drain the work queue
  while #worklist > 0 do
    process(table.remove(worklist))
  end
end

while true do
  poll()
  drain()
end
