import time
import subprocess
from collections import defaultdict
import sys

BENCHMARKS = ["server100", "server5"]
LUAS = ["unmodified", "syncc", "ett"]
TIMEOUT = 60

def run(lua, benchmark):
    print(f"CONFIGURATION: {lua}+{benchmark} ...")
    server_cmd = f"../../bins/{lua} {benchmark}.lua"
    server = subprocess.Popen(server_cmd.split(), shell=False, stdout=subprocess.DEVNULL)

    client_cmd = f"timeout {TIMEOUT}s ../../bins/{lua} client.lua"
    start = time.time()
    # stdout = subprocess.run(client_cmd, shell=True, stdout=subprocess.PIPE).stdout.decode("utf-8")
    result = subprocess.run(client_cmd, shell=True, stdout=subprocess.DEVNULL)
    end = time.time()

    server.kill()
    server.wait()

    if result.returncode == 0:  print(f"\tResult: {end - start:2.3}s")
    else:                       print(f"\tResult: Timeout")

print("About to run the server-client benchmarks (Section 2.2).")
print("We expect to see that the unmodified+server100 configuration times out (because finalizers never get called).")
print("We expect to see that all other configurations do not timeout.")
for benchmark in BENCHMARKS:
    for lua in LUAS:
        run(lua, benchmark)
