#pragma once

#ifdef SL_COMPARE
#undef SL_COMPARE
#endif
#define SL_SUFFIX ett
struct ettnode;
#define SL_DATA_T struct ettnode *
#include "splay.h"
#include <stdlib.h>

struct ettnode {
    struct splaynode start, end;
};

// from Linux
#define container_of(ptr, type, member) ({ \
    (type *)( (char *)(ptr) - offsetof(type,member) );\
})

#define SN2ETT(sn) ((sn)->is_start ? (container_of((sn), struct ettnode, start)) \
                                   : (container_of((sn), struct ettnode, end)))

// splice out [node.start, node.end] from the surrounding splay
static void ett_cut(struct ettnode *node) {
    struct splaynode *head_tail = node->start.prev;
    struct splaynode *tail_head = node->end.next;

    splay_split(&(node->start));
    if (tail_head)              splay_split(tail_head);
    if (tail_head && head_tail) splay_join(head_tail, tail_head);
}

// splice *in* [child.start, child.end]. can splice it in to
// right-after-the-front or right-before-the-end, as desired.
static void ett_link(struct ettnode *parent, struct ettnode *child) {
    struct splaynode *parent_head = &(parent->start);
    struct splaynode *parent_penhead = parent->start.next;

    splay_split(parent_penhead);
    splay_join(&(child->end), parent_penhead);

    splay_join(parent_head, &(child->start));
}

// Get the root node of the tree containing @node.
static struct ettnode *ett_root(struct ettnode *node) {
    return container_of(splay_head(&(node->start)), struct ettnode, start);
}

// Create a singleton tree.
static struct ettnode *ett_singleton_inplace(struct ettnode *node) {
    node->start.is_start = 1;
    splay_join(&(node->start), &(node->end));
    return node;
}

// Free the tree rooted at @node.
static void ett_free_all(struct ettnode *node, int offset) {
    for (struct splaynode *n = &(node->start); n;) {
        struct splaynode *skip = n->next;
        if (!(n->is_start)) free((void*)container_of(n, struct ettnode, end) + offset);
        n = skip;
    }
}

// Iterate over the tree rooted at @root.
#define ETT_ITER(root, idx, ...) \
    for (struct splaynode *_ett_i = &((root)->start); _ett_i; _ett_i = _ett_i->next) { \
        if (_ett_i->is_start) { \
            struct ettnode *idx = container_of(_ett_i, struct ettnode, start); \
            __VA_ARGS__ \
        } }
