#!/bin/bash
set -e
for v in unmodified variant_ett variant_syncc
do
    make -B -C $v
    echo "---------------- START TESTING $v ----------------"
    echo "---------------- THESE TESTS SHOULD SUCCEED ----------------"
    for t in tests/should-succeed/*
    do
        echo "===== Test:" $t "====="
        $v/komplott $t
    done
    echo "---------------- THESE TESTS SHOULD RUN OUT OF MEMORY (INFINITE LOOP) ----------------"
    for t in tests/should-fail/*
    do
        echo "===== Test:" $t "====="
        $v/komplott $t || true
    done
    echo "---------------- DONE TESTING $v ----------------"
done
