function codes = mess_log_codes(type)
%% returns the allowed ErrId/WarnId-values for the M-M.E.S.S-Project
%
% Input:
%
%  type   determines the ID types to return:
%           'error'    return only error IDs
%           'err'      as above
%           'warning'  return only warning IDs
%           'warn'     as above
%           'all'      return all valid IDs
%         (optional, defaults to 'all')

%
% This file is part of the M-M.E.S.S. project
% (http://www.mpi-magdeburg.mpg.de/projects/mess).
% Copyright (c) 2009-2025 Jens Saak, Martin Koehler, Peter Benner and others.
% All rights reserved.
% License: BSD 2-Clause License (see COPYING)
%

if nargin < 1
    type = 'all';
end

errors = { ...
          'GP_missing_solver', ...
          'GP_type', ...
          'SMW', ...
          'TEST:accuracy', ...
          'check_data', ...
          'complex_shifts', ...
          'control_data', ...
          'convergence', ...
          'data', ...
          'equation_data', ...
          'equation_type', ...
          'error_arguments', ...
          'error_usage', ...
          'exact_line_search', ...
          'failure', ...
          'framework', ...
          'get_initial_subspace', ...
          'illegal_input', ...
          'inaccurate_result', ...
          'inexact', ...
          'info', ...
          'inputs', ...
          'lrnm', ...
          'mess_para', ...
          'missing_feature', ...
          'missing_solver', ...
          'notimplemented', ...
          'outer_tol', ...
          'relative_error', ...
          'riccati', ...
          'shift_method', ...
          'shifts', ...
          'shifts_improper', ...
          'type', ...
          'unstable'
         };

warnings = { ...
            'BT', ...
            'CARE_NWT_FAC', ...
            'GP_missing_solver', ...
            'OFF|ON', ...
            'antistable_ritz', ...
            'b0', ...
            'care', ...
            'check_data', ...
            'compute_sol_fac', ...
            'control_data', ...
            'convergence', ...
            'dense', ...
            'denseNM_convergence', ...
            'equation_type', ...
            'error_norms', ...
            'exact_line_search', ...
            'exp_action', ...
            'failure', ...
            'galerkin_projection_acceleration', ...
            'ignored', ...
            'illegal_input', ...
            'implicitVtAV', ...
            'inaccurate result', ...
            'invalid_parameter_fallback', ...
            'lrnm', ...
            'lyap_sgn_fac', ...
            'maxiter', ...
            'mess_para', ...
            'missing_solver', ...
            'not_implemented', ...
            'off', ...
            'on', ...
            'proj_sol_semidef', ...
            'projection_shifts', ...
            'unstable', ...
            'usfs_iter', ...
            'warning_arguments'
           };

switch lower(type)
    case {'err', 'error'}
        codes = errors;

    case {'warn', 'warning'}
        codes = warnings;

    case 'all'
        codes = unique(union(errors, warnings));

    otherwise
        error('invalid input ''%s''', type);
end

end
