function U = get_initial_subspace(n, r)
%
%  U = get_initial_subspace(n,r)
%
% Computes an orthogonal basis for the n x r matrix generated by
% putting all ones in the first column, ones in every other entry
% of the second column, ones in every third entry of the third
% column and so on. The first entry is always one.

%
% This file is part of the M-M.E.S.S. project
% (http://www.mpi-magdeburg.mpg.de/projects/mess).
% Copyright (c) 2009-2025 Jens Saak, Martin Koehler, Peter Benner and others.
% All rights reserved.
% License: BSD 2-Clause License (see COPYING)
%
opts = struct;
if not(nargin == 2)

    mess_err(opts, 'get_initial_subspace', ...
             'number of rows n and columns r are mandatory!');
end

V = zeros(n, r);

for k = 1:r
    V(1:k:n, k) = 1.0;
end

[U, ~] = qr(V, 0);
