# Time-series (1909-2024) of forestry measurements and management practices in Hyytiälä Forest Station, Finland

This data bundle contains information from forest measurements and management practises performed in **579** different plots at [**Hyytiälä**](https://deims.org/663dac80-211d-4c19-a356-04ee0da0f0eb) Forest Station in Finland.

------------------------------------------------------------------------

## Author information

-   Allan T. Souza \*
    -   Institution: Institute for Atmospheric and Earth System Research INAR, Forest Sciences, Faculty of Agriculture and Forestry, University of Helsinki
    -   Address: Forest Sciences, Faculty of Agriculture and Forestry, P.O. Box 27, 00014 University of Helsinki, Helsinki, Finland
    -   e-mail: [allan.souza\@helsinki.fi](mailto:allan.souza@helsinki.fi)
    -   ORCID: [0000-0002-1851-681X](https://orcid.org/0000-0002-1851-681X)
-   Silja Vuorenmaa \*
    -   Institution: Hyytiälä Forest Station, University of Helsinki
    -   Address: Hyytiäläntie 124. 35500 Korkeakoski, Finland
    -   e-mail: [silja.vuorenmaa\@helsinki.fi](mailto:silja.vuorenmaa@helsinki.fi)
-   Pekka Kaitaniemi \*
    -   Institution: Hyytiälä Forest Station, University of Helsinki
    -   Address: Hyytiäläntie 124. 35500 Korkeakoski, Finland
    -   e-mail: [pekka.j.kaitaniemi\@helsinki.fi](mailto:pekka.j.kaitaniemi@helsinki.fi)
    -   ORCID: [0000-0002-5162-242X](https://orcid.org/0000-0002-5162-242X)
-   Tanja Lindholm \*
    -   Institution: Research stations, HiLIFE, University of Helsinki
    -   Address: Research stations, HiLIFE, P.O. Box 65, FI-00014 University of Helsinki, Finland
    -   e-mail: [tanja.lindholm\@helsinki.fi](mailto:tanja.lindholm@helsinki.fi)
    -   ORCID: [0000-0001-6115-3359](https://orcid.org/0000-0001-6115-3359)

\**Equal contributors.*

### Contact information

-   Hyytiälä Forest Station
    -   e-mail: [hyytiala-info\@helsinki.fi](mailto:hyytiala-info@helsinki.fi)
    -   Website: [www.helsinki.fi/en/research-stations/hyytiala-forest-station](https://www.helsinki.fi/en/research-stations/hyytiala-forest-station)

------------------------------------------------------------------------

## Temporal coverage

Data on forestry measurements and management practices spans for **115 years**, ranging from the year **1909** to **2024**.

------------------------------------------------------------------------

## Geographic location

-   Finland, Northern Europe.
-   Bounding coordinates: South West [61.7852, 24.1741], North East [61.8868, 24.4006].
-   Projection: WGS84.
-   Site register on DEIMS-SDR:
    -   Name: Hyytiälä SMEAR II LTER
    -   deimsID: <https://deims.org/663dac80-211d-4c19-a356-04ee0da0f0eb>

------------------------------------------------------------------------

## File naming convention

The file naming convention in this repository follows this structure:

-   [**project identifier**]\_[**file type identifier**]\_[**file short description**]\_v[**version**].[**file extension**]

Where:

-   **project identifier**
    -   *hfs*
-   **file type identifier**
    -   *data*; *documentation*; *template*
-   **file short description**
    -   *Briefly describes the contents of the file*
-   **version**
    -   *Follows the [Semantic Versioning](https://semver.org/)*
-   **file extension**
    -   *csv*

------------------------------------------------------------------------

## Files and terms description and structure

There are **9** files in the data bundle:

-   **hfs_data_forest_measurements_v0.1.0.csv**
    -   **Description**: *This is the data with species and other background information and measurements.*
    -   **Terms**: `plotID`, `plotActive`, `geodeticDatum`, `decimalLatitude`, `decimalLongitude`, `plotArea`, `soilType`, `siteType`, `siteFertilityClass`, `plotPurpose`, `eventID`, `eventYear`, `dominantSpecies`, `basalArea`, `numberOfStems`, `standVolume`, `averageTreeDiameter`, `averageTreeHeight`, `dominantHeight`, `measurementDeterminedBy`, `dataQualityLevel`, `class`, `order`, `family`, `genus`, `specificEpithet`, `scientificName`, `taxonRank`,`taxonURI`
    -   **Rows**: *2044*
-   **hfs_data_management_practises_v0.1.0.csv**
    -   **Description**: *This data set displays the information on the management practises applied on the forest plots.*
    -   **Terms**: `plotID`, `eventID`, `eventYear`, `managementMonth`, `managementPracticeL1`, `managementPracticeL2`, `managementPracticeL3`, `managementPracticeL4`
    -   **Rows**: *1753*
-   **hfs_data_forest_plots_geo_coordinates_v0.1.0.csv**
    -   **Description**: *This data set contains the geo coordinates of the plots in 3 different coordinate systems (WGS84, ETRS89 and ETRS-TM35FIN).*
    -   **Terms**: `plotID`, `geodeticDatum`, `decimalLatitude`, `decimalLongitude`
    -   **Rows**: *1737*
-   **hfs_data_forest_measurements_details_v0.1.0.csv**
    -   **Description**: *This data set contains the additional information on data quality and instrumentation employed on the measurements.*
    -   **Terms**: `plotID`, `eventYear`, `eventID`, `treeDiameterInstrument`, `treeHeightInstrument`
    -   **Rows**: *1176*
-   **hfs_data_management_practises_details_v0.1.0.csv**
    -   **Description**: *This file contains the information of the forest management practises and their relation to each other. The information is both in Finnish and English.*
    -   **Terms**: `managementPracticeL1`, `managementPracticeL2`, `managementPracticeL3`, `managementPracticeL4`, `managementPracticeL1Fin`, `managementPracticeL2Fin`, `managementPracticeL3Fin`, `managementPracticeL4Fin`
    -   **Rows**: *37*
-   **hfs_documentation_data_dictionary_v0.1.0.csv**
    -   **Description**: *This file describes all terms used in the data bundle.*
    -   **Terms**: `term`, `description`, `pid`, `vocabularySource`
    -   **Rows**: *87*
-   **hfs_template_forest_measurements_v0.1.0.csv**
    -   **Description**: *This file contains the template for forest measurements data input.*
    -   **Terms**: `plotID`, `plotActive`, `geodeticDatum`, `decimalLatitude`, `decimalLongitude`, `plotArea`, `soilType`, `siteType`, `siteFertilityClass`, `plotPurpose`, `eventID`, `eventYear`, `dominantSpecies`, `basalArea`, `numberOfStems`, `standVolume`, `averageTreeDiameter`, `averageTreeHeight`, `dominantHeight`, `measurementDeterminedBy`, `dataQualityLevel`, `class`, `order`, `family`, `genus`, `specificEpithet`, `scientificName`, `taxonRank`,`taxonURI`
    -   **Rows**: *1*
-   **hfs_template_management_practises_v0.1.0.csv**
    -   **Description**: *This file contains the template for forestry management practises data input.*
    -   **Terms**: `plotID`, `eventID`, `eventYear`, `managementMonth`, `managementPracticeL1`, `managementPracticeL2`, `managementPracticeL3`, `managementPracticeL4`
    -   **Rows**: *1*
-   **hfs_template_controlled_list_of_entries_v0.1.0.csv**
    -   **Description**: *This file contains all possible entries for the data templates.*
    -   **Terms**: `plotID`, `plotActive`, `geodeticDatum`, `decimalLatitude`, `decimalLongitude`, `plotArea`, `soilType`, `siteType`, `siteFertilityClass`, `plotPurpose`, `eventID`, `eventYear`, `dominantSpecies`, `basalArea`, `numberOfStems`, `standVolume`, `averageTreeDiameter`, `averageTreeHeight`, `dominantHeight`, `measurementDeterminedBy`, `dataQualityLevel`, `class`, `order`, `family`, `genus`, `specificEpithet`, `scientificName`, `taxonRank`,`taxonURI`
    -   **Rows**: *579*

### File connections

The data sets in this bundle are interconnected through shared identifiers and structural similarities. The shared connections are identified below:

-   **hfs_data_forest_measurements_v0.1.0.csv** connects to:
    -   **hfs_data_management_practises_v0.1.0.csv** by `plotID` and `eventYear`.
    -   **hfs_data_forest_measurements_details_v0.1.0.csv** by `plotID`, `eventYear` and `eventID`.
    -   **hfs_data_forest_plots_geo_coordinates_v0.1.0.csv** by `plotID`.
-   **hfs_data_management_practises_v0.1.0.csv** connects to:
    -   **hfs_data_forest_measurements_v0.1.0.csv** by `plotID` and `eventYear`.
    -   **hfs_data_management_practises_details_v0.1.0.csv** by `managementPracticeL1`, `managementPracticeL2`, `managementPracticeL3`, `managementPracticeL4`.
-   **hfs_template_forest_measurements_v0.1.0.csv** connects to:
    -   **hfs_template_controlled_list_of_entries_v1.01** by `all variables`.
-   **hfs_template_management_practises_v0.1.0.csv** connects to:
    -   **hfs_data_management_practises_details_v0.1.0.csv** by `managementPracticeL1`, `managementPracticeL2`, `managementPracticeL3`, `managementPracticeL4`.
    -   **hfs_template_controlled_list_of_entries_v1.01** by `plotID`.
    -   **hfs_data_forest_plots_geo_coordinates_v0.1.0.csv** by `plotID`.

------------------------------------------------------------------------

### Terms description

-   `plotID`
    -   **Description**: *Unique identifier code for the plot.*
    -   **Data type**: *character*
-   `plotActive`
    -   **Description**: *Is plot actively maintained (TRUE = yes, FALSE = no).*
    -   **Data type**: *boolean*
-   `geodeticDatum`
    -   **Description**: *Geodetic datum used, WGS84.*
    -   **Data type**: *character*
-   `decimalLatitude`
    -   **Description**: *Latitude in decimal format.*
    -   **Data type**: *numeric*
    -   **Unit**: *º*
-   `decimalLongitude`
    -   **Description**: *Longitude in decimal format.*
    -   **Data type**: *numeric*
    -   **Unit**: *º*
-   `plotArea`
    -   **Description**: *Size of the plot.*
    -   **Data type**: *numeric*
    -   **Unit**: *m^2^*
-   `soilType`
    -   **Description**: *Mineral soil or peatland.*
    -   **Data type**: *character*
-   `siteType`
    -   **Description**: *Principal site class of mineral soil and peatlands.*
    -   **Data type**: *character*
-   `siteFertilityClass`
    -   **Description**: *Site fertility class according to Finnish classification system.*
    -   **Data type**: *character*
-   `plotPurpose`
    -   **Description**: *What is the purpose of each plot.*
    -   **Data type**: *character*
-   `eventID`
    -   **Description**: *Unique identifier code for each record.*
    -   **Data type**: *character*
-   `eventYear`
    -   **Description**: *Year of a measurement.*
    -   **Data type**: *numeric*
    -   **Unit**: *YYYY*
-   `dominantSpecies`
    -   **Description**: *Species with the highest wood volume in the plot. If volume is missing, then the species with the highest stem number.*
    -   **Data type**: *character*
-   `basalArea`
    -   **Description**: *Cross-sectional area of trees at breast height.*
    -   **Data type**: *numeric*
    -   **Unit**: *m^2^/ha*
-   `numberOfStems`
    -   **Description**: *Number of tree stems per hectare.*
    -   **Data type**: *numeric*
    -   **Unit**: *-*
-   `standVolume`
    -   **Description**: *Wood volume per hectare in a stand.*
    -   **Data type**: *numeric*
    -   **Unit**: *m^3^/ha*
-   `averageTreeDiameter`
    -   **Description**: *Basal area weighted mean breast height diameter of trees (no weighing done if basal area is missing).*
    -   **Data type**: *numeric*
    -   **Unit**: *cm*
-   `averageTreeHeight`
    -   **Description**: *Basal area weighted mean height of trees (no weighing done if basal area is missing).*
    -   **Data type**: *numeric*
    -   **Unit**: *m*
-   `dominantHeight`
    -   **Description**: *The average height of the hundred thickest trees per hectare.*
    -   **Data type**: *numeric*
    -   **Unit**: *m*
-   `measurementDeterminedBy`
    -   **Description**: *Measurer (student/staff).*
    -   **Data type**: *character*
-   `dataQualityLevel`
    -   **Description**: *Estimated level of data precision (0 = lowest, 2 = highest).*
    -   **Data type**: *factor*
-   `class`
    -   **Description**: *The full scientific name of the class in which the taxon is classified.*
    -   **Data type**: *character*
-   `order`
    -   **Description**: *The full scientific name of the order in which the taxon is classified.*
    -   **Data type**: *character*
-   `family`
    -   **Description**: *The full scientific name of the family in which the dwc:Taxon is classified.*
    -   **Data type**: *character*
-   `genus`
    -   **Description**: *The full scientific name of the genus in which the taxon is classified.*
    -   **Data type**: *character*
-   `specificEpithet`
    -   **Description**: *The name of the first or species epithet of the scientificName.*
    -   **Data type**: *character*
-   `scientificName`
    -   **Description**: *The full scientific name, with authorship and date information if known.*
    -   **Data type**: *character*
-   `taxonRank`
    -   **Description**: *The taxonomic rank of the most specific name in the scientificName.*
    -   **Data type**: *character*
-   `taxonURI`
    -   **Description**: *An identifier for the set of taxon information. May be a global unique identifier or an identifier specific to the data set.*
    -   **Data type**: *character*
-   `managementMonth`
    -   **Description**: *Month of applying management practice.*
    -   **Data type**: *numeric*
    -   **Unit**: *MM*
-   `managementPracticeL1`
    -   **Description**: *Forest management practice (level 1).*
    -   **Data type**: *character*
-   `managementPracticeL2`
    -   **Description**: *Forest management practice (level 2).*
    -   **Data type**: *character*
-   `managementPracticeL3`
    -   **Description**: *Forest management practice (level 3).*
    -   **Data type**: *character*
-   `managementPracticeL4`
    -   **Description**: *Forest management practice (level 4).*
    -   **Data type**: *character*
-   `treeDiameterInstrument`
    -   **Description**: *Measuring instrument for tree diameter.*
    -   **Data type**: *character*
-   `treeHeightInstrument`
    -   **Description**: *Measuring instrument for tree height.*
    -   **Data type**: *character*

### Missing information

Missing information is denoted as **NA**.

------------------------------------------------------------------------

## Methodological information

The data were collected through systematic forestry measurements and management records. Standard field protocols were used to assess tree characteristics, including diameter at breast height, tree height, basal area, and stand volume.

Management practises were documented based on historical records and direct observations.

Data collection involved both students and staff and this information is reflected on the data quality indication.

------------------------------------------------------------------------

## Links/relationships to ancillary data sets

The data bundle is formed by a collection of information derive from multiple sources listed below.

### Forest data

-   Aaltonen, R. 1997. Metsänhoidon esittelypolku. Edita. (In Finnish)
-   Ekola, E. & Päivänen, J. 1991. Suometsätieteen laitoksen pysyvät koealat Hyytiälän ympäristön ojitetuilla soilla - Metsänhoidolliset koealat ja kasvukoealat. University of Helsinki. Department of Peatland Forestry Publications 10. (In Finnish)
-   Heikurainen, L. & Joensuu, S. 1985. Suojuoksu - suotyyppinäytealojen retkeilyreitti. University of Helsinki. Department of Peatland Forestry Publications 6. (In Finnish)
-   Heikurainen, L. & Mannerkoski, H. 1982. Suometsätieteen laitoksen kenttäkokeet. University of Helsinki. Department of Peatland Forestry Publications 1. (In Finnish)
-   Hotanen, J.-P., Nousiainen, H., Mäkipää, R., Reinikainen, A. & Tonteri, T. 2018. Metsätyypit - kasvupaikkaopas. Metsäkustannus. (In Finnish)
-   Hotanen, J.-P., Nousiainen, H., Mäkipää, R., Reinikainen, A. & Tonteri, T. 2013. Metsätyypit - opas kasvupaikkojen luokitteluun. 2. painos. Metsäkustannus. (In Finnish)
-   Korpela, I. 2024. "Hyytiälän kaukokartoituskoekenttä" - Puusto- ja koealamittauksia vuodesta 1995. Retrieved February 21, 2025 from <https://www.mv.helsinki.fi/home/korpela/HYDE_REF/Plots/Koealat_Hyytialassa.html>
-   Laine, J., Komulainen, V-M., Laiho, R., Minkkinen, K., Rasinmäki, A., Sallantaus, T., Sarkkola, S., Silvan, N., Tolonen, K., Tuittila, E-S., Vasander, H. & Päivänen, J. 2004. Lakkasuo - a guide to mire ecosystem. University of Helsinki. Department of Forest Ecology Publications 31.
-   Laine, J., Komulainen, V-M., Laiho, R., Minkkinen, K., Rasinmäki, A., Sallantaus, T., Sarkkola, S., Silvan, N., Tolonen, K., Tuittila, E-S., Vasander, H. & Päivänen, J. 2002. Lakkasuo - opas suon ekosysteemiin. University of Helsinki. Department of Forest Ecology Publications 26. (In Finnish)
-   Laine, J., Päivänen, J., Schneider, H. & Vasander, H. 1986. Site types at Lakkasuo mire complex. Field guide. University of Helsinki. Department of Peatland Forestry Publications 8. (In Finnish)
-   Laine, J., Vasander, H., Hotanen, J-P., Nousiainen, H., Saarinen, M., Penttila, T. 2021. Suotyypit ja turvekankaat - kasvupaikkaopas. 2. uudistettu painos. Tapio. (In Finnish)
-   Laine, J., Vasander, H., Hotanen, J-P., Nousiainen, H., Saarinen, M., Penttila, T. 2012. Suotyypit ja turvekankaat - opas kasvupaikkojen tunnistamiseen. Metsäkustannus. (In Finnish)
-   Mannerkoski, H. 1979. Peatland path, "Cursus paluster". Excursion route demonstrating peatland site types. University of Helsinki. Department of Peatland Forestry.
-   Mannerkoski, H. 1979. Suojuoksu. Suotyyppialojen retkeilyreitti. University of Helsinki. Department of Peatland Forestry. (In Finnish)
-   Räsänen, P. K., Heiskanen, J., Miettinen, J., Sunden, T. & Torpo, J. 1992. Metsänhoitotieteen opetuskoealat Hyytiälässä. University of Helsinki. Department of Forest Ecology Publications 4. (In Finnish)
-   Räsänen, P. K., Heiskanen, J., Miettinen, J., Sunden, T., Torpo, J. & Johansson J. 1995. Metsänhoitotieteen opetuskoealat Hyytiälässä. University of Helsinki. Department of Forest Ecology Publications 4. (In Finnish)
-   Räsänen, P. K., Heiskanen, J., Miettinen, J., Sunden, T., Torpo, J., Ruokonen, M-L., Johansson J. & Rakemaa, A. 1998. Metsänhoidon opetuskoealat Hyytiälässä. 2. uudistettu painos. University of Helsinki. Department of Forest Ecology Publications 4. 3. uudistettu painos. (In Finnish)
-   Sarkkola, S. & Päivänen, J. 2001. Suopuustojen kehitys kuivatussukkessiossa – Hyytiälän ympäristön pysyvät koealat. University of Helsinki. Department of Forest Ecology Publications 25. (In Finnish)
-   Sarkkola, S. & Päivänen, J. 2016. Suosta turvemaan metsäksi: kuivatussukkessio muutosvoimana. University of Helsinki. Department of Forest Sciences Publications 8. (In Finnish)
-   Sunden, T. 1990. Hyytiälän opetuskoealat. University of Helsinki. Department of Forest Ecology. (In Finnish)
-   Suomen metsäkeskus. 2022. Tuli metsässä -sanasto. Metsäsanasto -sarja, osa 1. Retrieved February 21, 2025 from <https://www.metsakeskus.fi/sites/default/files/document/tuli-metsassa-sanasto.pdf>.
-   Suomen metsäkeskus. 2023. Metsähydrologia ja metsäojitus -sanasto. Metsäsanasto -sarja, osa 2. Retrieved February 21, 2025 from <https://www.metsakeskus.fi/sites/default/files/document/metsahydrologia-ja-ojitus.pdf>.

### The site fertility class classification

-   Heikurainen, L. & Joensuu, S. 1985. Suojuoksu - suotyyppinäytealojen retkeilyreitti. University of Helsinki. Department of Peatland Forestry Publications 6. (In Finnish)
-   Hotanen, J.-P., Nousiainen, H., Mäkipää, R., Reinikainen, A. & Tonteri, T. 2018. Metsätyypit - kasvupaikkaopas. Metsäkustannus. (In Finnish)
-   Hotanen, J.-P., Nousiainen, H., Mäkipää, R., Reinikainen, A. & Tonteri, T. 2013. Metsätyypit - opas kasvupaikkojen luokitteluun. 2. painos. Metsäkustannus. (In Finnish)
-   Laine, J., Komulainen, V-M., Laiho, R., Minkkinen, K., Rasinmäki, A., Sallantaus, T., Sarkkola, S., Silvan, N., Tolonen, K., Tuittila, E-S., Vasander, H. & Päivänen, J. 2004. Lakkasuo - a guide to mire ecosystem. University of Helsinki. Department of Forest Ecology Publications 31.
-   Laine, J., Komulainen, V-M., Laiho, R., Minkkinen, K., Rasinmäki, A., Sallantaus, T., Sarkkola, S., Silvan, N., Tolonen, K., Tuittila, E-S., Vasander, H. & Päivänen, J. 2002. Lakkasuo - opas suon ekosysteemiin. University of Helsinki. Department of Forest Ecology Publications 26. (In Finnish)
-   Laine, J., Päivänen, J., Schneider, H. & Vasander, H. 1986. Site types at Lakkasuo mire complex. Field guide. University of Helsinki. Department of Peatland Forestry Publications 8.
-   Laine, J., Vasander, H., Hotanen, J-P., Nousiainen, H., Saarinen, M., Penttila, T. 2012. Suotyypit ja turvekankaat - opas kasvupaikkojen tunnistamiseen. Metsäkustannus. (In Finnish)
-   Laine, J., Vasander, H., Hotanen, J-P., Nousiainen, H., Saarinen, M., Penttila, T. 2021. Suotyypit ja turvekankaat - kasvupaikkaopas. 2. uudistettu painos. Tapio. (In Finnish)
-   Mannerkoski, H. 1979. Peatland path, "Cursus paluster". Excursion route demonstrating peatland site types. University of Helsinki. Department of Peatland Forestry.
-   Mannerkoski, H. 1979. Suojuoksu. Suotyyppialojen retkeilyreitti. University of Helsinki. Department of Peatland Forestry. (In Finnish)

------------------------------------------------------------------------

## Funding

This project has received funding from the European Union's Horizon 2020 Research and Innovation Programme under grant agreement No 871128 [eLTER PLUS](https://doi.org/10.3030/871128).

------------------------------------------------------------------------

## License

-   This work is licensed under a [CC BY 4.0](https://creativecommons.org/licenses/by/4.0/deed.en) license.

------------------------------------------------------------------------
