-- MariaDB dump 10.17  Distrib 10.4.5-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: localhost    Database: dpeatdecomposition
-- ------------------------------------------------------
-- Server version	10.4.5-MariaDB-1:10.4.5+maria~bionic

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `attributes`
--

DROP TABLE IF EXISTS `attributes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `attributes` (
  `attribute_name` varchar(255) NOT NULL,
  `attribute_definition` mediumtext DEFAULT NULL,
  `id_measurement_scale` int(11) NOT NULL,
  `id_missing_value_code` int(11) DEFAULT NULL,
  PRIMARY KEY (`attribute_name`),
  KEY `fk_attributes_ref_measurement_scales` (`id_measurement_scale`),
  KEY `fk_attributes_ref_missing_value_codes` (`id_missing_value_code`),
  CONSTRAINT `fk_attributes_ref_measurement_scales` FOREIGN KEY (`id_measurement_scale`) REFERENCES `measurement_scales` (`id_measurement_scale`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_attributes_ref_missing_value_codes` FOREIGN KEY (`id_missing_value_code`) REFERENCES `missing_value_codes` (`id_missing_value_code`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attributes`
--

LOCK TABLES `attributes` WRITE;
/*!40000 ALTER TABLE `attributes` DISABLE KEYS */;
INSERT INTO `attributes` VALUES ('4_hydroxyacetophenone_mass_absolute','A numeric value representing the content of 4-hydroxyacetophenone, as described in @Strakova.2010.',20,1),('4_hydroxyacetophenone_mass_relative_mass','A numeric value representing the content of 4-hydroxyacetophenone, as described in @Strakova.2010.',15,1),('4_hydroxybenzaldehyde_mass_absolute','A numeric value representing the content of 4-hydroxybenzaldehyde, as described in @Strakova.2010.',20,1),('4_hydroxybenzaldehyde_mass_relative_mass','A numeric value representing the content of 4-hydroxybenzaldehyde, as described in @Strakova.2010.',15,1),('4_hydroxybenzoic_acid_mass_absolute','A numeric value representing the content of 4-hydroxybenzoic acid, as described in @Strakova.2010.',20,1),('4_hydroxybenzoic_acid_mass_relative_mass','A numeric value representing the content of 4-hydroxybenzoic acid, as described in @Strakova.2010.',15,1),('abbreviation','In table `custom_units`: A string representing an abbreviation for the custom unit.',1,1),('acetone_extractives_mass_absolute','A numeric value representing the content of acetone extractives, as described in @Strakova.2010.',20,1),('acetone_extractives_mass_relative_mass','A numeric value representing the content of acetone extractives, as described in @Strakova.2010.',15,1),('acetosyringone_mass_absolute','A numeric value representing the content of acetosyringone, as described in @Strakova.2010.',20,1),('acetosyringone_mass_relative_mass','A numeric value representing the content of acetosyringone, as described in @Strakova.2010.',15,1),('acetovanillone_mass_absolute','A numeric value representing the content of acetovanillone, as described in @Strakova.2010.',20,1),('acetovanillone_mass_relative_mass','A numeric value representing the content of acetovanillone, as described in @Strakova.2010.',15,1),('Ac_absolute','The absolute mass of Ac in the sample.',20,1),('Ac_relative_mass','The absolute mass of Ac in the sample.',22,1),('Ag_absolute','The absolute mass of Ag in the sample.',20,1),('Ag_relative_mass','The absolute mass of Ag in the sample.',22,1),('Al_absolute','The absolute mass of Al in the sample.',20,1),('Al_relative_mass','The absolute mass of Al in the sample.',22,1),('Am_absolute','The absolute mass of Am in the sample.',20,1),('Am_relative_mass','The absolute mass of Am in the sample.',22,1),('apodisation_function','A string representing the name of the apodisation function.',1,1),('arabinose_mass_absolute','A numeric value representing the content of arabinose, as described in @Strakova.2010.',20,1),('arabinose_mass_relative_mass','A numeric value representing the content of arabinose, as described in @Strakova.2010.',15,1),('Ar_absolute','The absolute mass of Ar in the sample.',20,1),('Ar_relative_mass','The absolute mass of Ar in the sample.',22,1),('ash_mass_absolute','A numeric value representing the content of ash (after burning at 550Â°C).',20,1),('ash_mass_relative_mass','A numeric value representing the content of ash (after burning at 550Â°C).',22,1),('As_absolute','The absolute mass of As in the sample.',20,1),('As_relative_mass','The absolute mass of As in the sample.',22,1),('attribute_definition','A free text field with a textual description of the meaning of attributes in the dpeatdecomposition database.',1,1),('attribute_name','A string describing the names of the attributes in all tables of the dpeatdecomposition database.',1,1),('At_absolute','The absolute mass of At in the sample.',20,1),('At_relative_mass','The absolute mass of At in the sample.',22,1),('Au_absolute','The absolute mass of Au in the sample.',20,1),('Au_relative_mass','The absolute mass of Au in the sample.',22,1),('Ba_absolute','The absolute mass of Ba in the sample.',20,1),('Ba_relative_mass','The absolute mass of Ba in the sample.',22,1),('beamsplitter_name','A string representing the name of the beamsplitter.',1,1),('Be_absolute','The absolute mass of Be in the sample.',20,1),('Be_relative_mass','The absolute mass of Be in the sample.',22,1),('Bh_absolute','The absolute mass of Bh in the sample.',20,1),('Bh_relative_mass','The absolute mass of Bh in the sample.',22,1),('bibtex','A string representing the bibtex code used for a literature reference throughout the dpeatdecomposition database.',1,1),('Bi_absolute','The absolute mass of Bi in the sample.',20,1),('Bi_relative_mass','The absolute mass of Bi in the sample.',22,1),('Bk_absolute','The absolute mass of Bk in the sample.',20,1),('Bk_relative_mass','The absolute mass of Bk in the sample.',22,1),('bounds_maximum','A numeric value representing the minimum possible value for a numeric attribute.',9,1),('bounds_minimum','A numeric value representing the maximum possible value for a numeric attribute.',9,1),('Br_absolute','The absolute mass of Br in the sample.',20,1),('Br_relative_mass','The absolute mass of Br in the sample.',22,1),('bulk_density','A numeric value representing the bulk density of the sample [g cm<sup>-3</sup>].',21,1),('B_absolute','The absolute mass of B in the sample.',20,1),('B_relative_mass','The absolute mass of B in the sample.',22,1),('cation_exchange_capacity_absolute','A numeric value representing the cation exchange capacity.',19,1),('cation_exchange_capacity_relative_mass','A numeric value representing the cation exchange capacity relative to sample mass.',19,1),('Ca_absolute','The absolute mass of Ca in the sample.',20,1),('Ca_relative_mass','The absolute mass of Ca in the sample.',22,1),('Cd_absolute','The absolute mass of Cd in the sample.',20,1),('Cd_relative_mass','The absolute mass of Cd in the sample.',22,1),('cellulose_mass_absolute','A numeric value representing the content of cellulose, as described in @Strakova.2010.',20,1),('cellulose_mass_relative_mass','A numeric value representing the content of cellulose, as described in @Strakova.2010.',15,1),('Ce_absolute','The absolute mass of Ce in the sample.',20,1),('Ce_relative_mass','The absolute mass of Ce in the sample.',22,1),('Cf_absolute','The absolute mass of Cf in the sample.',20,1),('Cf_relative_mass','The absolute mass of Cf in the sample.',22,1),('Cl_absolute','The absolute mass of Cl in the sample.',20,1),('Cl_relative_mass','The absolute mass of Cl in the sample.',22,1),('Cm_absolute','The absolute mass of Cm in the sample.',20,1),('Cm_relative_mass','The absolute mass of Cm in the sample.',22,1),('Cn_absolute','The absolute mass of Cn in the sample.',20,1),('Cn_relative_mass','The absolute mass of Cn in the sample.',22,1),('comments_measurement','A string representing comments on a measurement.',1,1),('comments_measurements','A free text field where you can enter all information related to the sample that is not covered by the remaining fields. For example you could provide information on potential contamination sources, issues with specific parameters, additional information to the sampling site, e.g. present vegetation, past vegetation, specific conditions during sampling, ... .',1,1),('comments_samples','A free text field where you can enter all information related to the sample that is not covered by the remaining fields. For example you could provide information on potential contamination sources, issues with specific parameters, additional information to the sampling site, e.g. present vegetation, past vegetation, specific conditions during sampling, ... .',1,1),('Co_absolute','The absolute mass of Co in the sample.',20,1),('Co_relative_mass','The absolute mass of Co in the sample.',22,1),('Cr_absolute','The absolute mass of Cr in the sample.',20,1),('Cr_relative_mass','The absolute mass of Cr in the sample.',22,1),('Cs_absolute','The absolute mass of Cs in the sample.',20,1),('Cs_relative_mass','The absolute mass of Cs in the sample.',22,1),('Cu_absolute','The absolute mass of Cu in the sample.',20,1),('Cu_relative_mass','The absolute mass of Cu in the sample.',22,1),('C_absolute','The absolute mass of C in the sample.',20,1),('C_relative_mass','The absolute mass of C in the sample.',22,1),('C_to_N','A numeric value representing the C to N ratio of the sample.',22,1),('C_to_P','A numeric value representing the C to P ratio of the sample.',22,1),('d13C','A numeric value representing the <sup>13</sup>C isotope signature of the sample in delta permil relative to the VPDB standard.',29,1),('d15N','A numeric value representing the <sup>15</sup>N isotope signature of the sample in delta permil relative to air.',29,1),('d18O','A numeric value representing the <sup>18</sup>O isotope signature of the sample in delta permil relative to VSMOW.',29,1),('d2H','A numeric value representing the <sup>2</sup>H isotope signature of the sample in delta permil relative to VSMOW.',29,1),('data_point_number','A numeric value representing the number of data points in the spectrum.',10,1),('Db_absolute','The absolute mass of Db in the sample.',20,1),('Db_relative_mass','The absolute mass of Db in the sample.',22,1),('description','A free text field. In table â€œcustom_unitsâ€: A description of a custom unit.',1,1),('detector_gain_factor','A numeric value representing the detection gain factor.',29,1),('detector_name','A string representing the name of the detector.',1,1),('dichloromethane_extractives_mass_absolute','A numeric value representing the content of dichlromethane extractives, as described in @Strakova.2010.',20,1),('dichloromethane_extractives_mass_relative_mass','A numeric value representing the content of dichlromethane extractives, as described in @Strakova.2010.',15,1),('dimension','A string representing the dimension of the unit.',1,1),('Ds_absolute','The absolute mass of Ds in the sample.',20,1),('Ds_relative_mass','The absolute mass of Ds in the sample.',22,1),('Dy_absolute','The absolute mass of Dy in the sample.',20,1),('Dy_relative_mass','The absolute mass of Dy in the sample.',22,1),('electron_accepting_capacity','A numeric value representing the electron accepting capacity (EAC) of the sample [&mu;mol (g C)<sup>-1</sup>].',26,1),('electron_donating_capacity','A numeric value representing the electron donating capacity (EDC) of the sample [&mu;mol (g C)<sup>-1</sup>].',26,1),('enthalpy_of_formation','A numeric value representing the standard enthalpy of formation of the sample (using a molecular formular informed by element measurements of the sample) [kJ mol<sup>-1</sup>].',32,1),('entropy_of_formation','A numeric value representing the standard entropy of formation of the sample [J K<sup>-1</sup> mol<sup>-1</sup>].',30,1),('error','A numeric value representing the error of the measured value. The unit of the error is defined by the corresponding `attribute_name`.',19,1),('error_type','A character representing the type of the error of a measured value (e.g., sd, 95% interval, etc.). ',1,1),('Er_absolute','The absolute mass of Er in the sample.',20,1),('Er_relative_mass','The absolute mass of Er in the sample.',22,1),('Es_absolute','The absolute mass of Es in the sample.',20,1),('Es_relative_mass','The absolute mass of Es in the sample.',22,1),('ethanol_extractives_mass_absolute','A numeric value representing the content of ethanol extractives, as described in @Strakova.2010.',20,1),('ethanol_extractives_mass_relative_mass','A numeric value representing the content of ethanol extractives, as described in @Strakova.2010.',15,1),('Eu_absolute','The absolute mass of Eu in the sample.',20,1),('Eu_relative_mass','The absolute mass of Eu in the sample.',22,1),('experimental_design','A character of the format â€˜x_y_z_â€¦â€™, where x, y, z, â€¦, are integers differentiating hierarchical groups of an experimental design. These groups are explained in table experimental_design_format ',1,1),('experimental_design_description','A string describing the variables in the csv file identified by column `file` in table `experimental_design_format` for each dataset.',1,1),('experimental_design_format','A string decoding the experimental design encoded in `experimental_design`.',1,1),('explanation','In table `missing_value_codes`: A string explaining what the corresponding missing value code means.',1,1),('exponentiation_factor','A numeric value representing the exponentiation factor used for file compression.',3,1),('ferulic_acid_mass_absolute','A numeric value representing the content of ferulic acid, as described in @Strakova.2010.',20,1),('ferulic_acid_mass_relative_mass','A numeric value representing the content of ferulic acid, as described in @Strakova.2010.',15,1),('Fe_absolute','The absolute mass of Fe in the sample.',20,1),('Fe_relative_mass','The absolute mass of Fe in the sample.',22,1),('file','A string representing a path to a file. For table `experimental_design_format`: Path to a csv file providing details on the experimental design and manipulations.',1,1),('Fm_absolute','The absolute mass of Fm in the sample.',20,1),('Fm_relative_mass','The absolute mass of Fm in the sample.',22,1),('format_string','A string defining the format of a nominal variable.',1,1),('Fr_absolute','The absolute mass of Fr in the sample.',20,1),('Fr_relative_mass','The absolute mass of Fr in the sample.',22,1),('F_absolute','The absolute mass of F in the sample.',20,1),('F_relative_mass','The absolute mass of F in the sample.',22,1),('galactose_mass_absolute','A numeric value representing the content of galactose, as described in @Strakova.2010.',20,1),('galactose_mass_relative_mass','A numeric value representing the content of galactose, as described in @Strakova.2010.',15,1),('galacturonic_acid_mass_absolute','A numeric value representing the content of galacturonic acid, as described in @Strakova.2010.',20,1),('galacturonic_acid_mass_relative_mass','A numeric value representing the content of galacturonic acid, as described in @Strakova.2010.',15,1),('Ga_absolute','The absolute mass of Ga in the sample.',20,1),('Ga_relative_mass','The absolute mass of Ga in the sample.',22,1),('Gd_absolute','The absolute mass of Gd in the sample.',20,1),('Gd_relative_mass','The absolute mass of Gd in the sample.',22,1),('Ge_absolute','The absolute mass of Ge in the sample.',20,1),('Ge_relative_mass','The absolute mass of Ge in the sample.',22,1),('Gibbs_energy_of_formation','A numeric value representing the standard Gibbs energy of formation of the sample [kJ mol<sup>-1</sup>].',32,1),('glucose_mass_absolute','A numeric value representing the content of glucose, as described in @Strakova.2010.',20,1),('glucose_mass_relative_mass','A numeric value representing the content of glucose, as described in @Strakova.2010.',15,1),('glucuronic_acid_mass_absolute','A numeric value representing the content of glucuronic acid, as described in @Strakova.2010.',20,1),('glucuronic_acid_mass_relative_mass','A numeric value representing the content of glucuronic acid, as described in @Strakova.2010.',15,1),('ground_slope','The slope of the sample (land surface) as fraction of the vertical distance covered and the horizontal distance.',19,1),('heat_of_combustion','A numeric value representing the heat of combustion of the sample (using a molecular formular informed by element measurements of the sample) [kJ mol<sup>-1</sup>].',32,1),('He_absolute','The absolute mass of He in the sample.',20,1),('He_relative_mass','The absolute mass of He in the sample.',22,1),('Hf_absolute','The absolute mass of Hf in the sample.',20,1),('Hf_relative_mass','The absolute mass of Hf in the sample.',22,1),('Hg_absolute','The absolute mass of Hg in the sample.',20,1),('Hg_relative_mass','The absolute mass of Hg in the sample.',22,1),('holocellulose_mass_absolute','A numeric value representing the absolute holocellulose mass in the sample.',20,1),('holocellulose_mass_relative_mass','A numeric value representing the holocellulose content of the sample [g/g].',15,1),('Ho_absolute','The absolute mass of Ho in the sample.',20,1),('Ho_relative_mass','The absolute mass of Ho in the sample.',22,1),('Hs_absolute','The absolute mass of Hs in the sample.',20,1),('Hs_relative_mass','The absolute mass of Hs in the sample.',22,1),('hydraulic_conductivity','A numeric value representing the saturated hydraulic conductivity (K<sub>s</sub>) of the sample [cm h<sup>-1</sup>].',18,1),('H_absolute','The absolute mass of H in the sample.',20,1),('H_relative_mass','The absolute mass of H in the sample.',22,1),('id_citation','An integer value representing an id for each entry in the table â€œcitationsâ€œ in the dpeatdecomposition database.',6,1),('id_dataset','A numeric id for the dataset (starting with 1 and increasing by 1; for one data contribution, this should be 1 for all samples and the appropriate id is assigned when the data are merged into the database).',6,1),('id_measurement','A numeric id for measurements (starting with 1 and increasing by 1). This means that each measurement gets its own rows and measurements for different attributes are considered independent, i.e. multiple measurement ids for the same sample just count replicate measurements for any attribute. For attributes with less measurements than for a different attribute, just fill measurements starting from smaller id_measurement and leave the cells in the remaining rows empty.',6,1),('id_measurement_denominator','An integer value representing the identifier for the measurement which is used as denominator in computing a relative quantity (e.g. the absolute mass of the initial sample when computing the mass fraction relative to the initial sample).',6,1),('id_measurement_numerator','An integer value representing the identifier for the measurement which is used as numerator in computing a relative quantity (e.g. the absolute mass of the sample when computing the mass fraction relative to the initial sample).',6,1),('id_measurement_scale','An integer value representing an id for each entry in the table â€œmeasurement_scalesâ€œ in the dpeatdecomposition database.',6,1),('id_missing_value_code','An integer value representing an id for each entry in the table â€œmissing_value_codesâ€œ in the dpeatdecomposition database.',6,1),('id_sample','A numeric id for the sample (starting with 1 and increasing by 1).',6,1),('id_sample_child','An integer representing an identifier for the child (resulting) sample of the transition (some change to a sample).',6,1),('id_sample_incubation_start','An integer representing an identifier for the sample which is the sample at the start of the incubation (`incubation_duration == 0`).',6,1),('id_sample_origin','An integer representing an identifier for the sample which is the original sample in a line of transitions of a sample (modifications of a sample).',6,1),('id_sample_parent','An integer representing an identifier for the parent (initial) sample of the transition (some change to a sample).',6,1),('id_unit','An integer value representing an id for each entry in the table â€œunitsâ€œ in the dpeatdecomposition database.',6,1),('incubation_duration','A numeric value representing the number of days over which a sample was incubated.',19,1),('incubation_environment','A character defining the environment in which a litterbag sample was incubated (e.g. \'peat\', \'container\', â€¦).',1,1),('In_absolute','The absolute mass of In in the sample.',20,1),('In_relative_mass','The absolute mass of In in the sample.',22,1),('Ir_absolute','The absolute mass of Ir in the sample.',20,1),('Ir_relative_mass','The absolute mass of Ir in the sample.',22,1),('is_baseline_corrected','A logical value indicating if a spectrum is already baseline corrected (TRUE) or not (FALSE).',1,1),('is_incubated','A logical value indicating whether a sample was collected during the decomposition incubation of a litterbag experiment or not.',1,1),('I_absolute','The absolute mass of I in the sample.',20,1),('I_relative_mass','The absolute mass of I in the sample.',22,1),('Klason_lignin_mass_absolute','A numeric value representing the absolute Klason lignin mass in the sample.',20,1),('Klason_lignin_mass_relative_mass','A numeric value representing the Klason lignin content of the sample [g/g].',15,1),('Kr_absolute','The absolute mass of Kr in the sample.',20,1),('Kr_relative_mass','The absolute mass of Kr in the sample.',22,1),('K_absolute','The absolute mass of K in the sample.',20,1),('K_relative_mass','The absolute mass of K in the sample.',22,1),('lab_code_14C','A string representing a code for the laboratory where the <sup>14</sup>C activities were measured (<sup>14</sup>C ages were determined).',1,1),('La_absolute','The absolute mass of La in the sample.',20,1),('La_relative_mass','The absolute mass of La in the sample.',22,1),('Li_absolute','The absolute mass of Li in the sample.',20,1),('Li_relative_mass','The absolute mass of Li in the sample.',22,1),('loss_on_ignition','A numeric value representing the loss on ignition of the sample [mass-%].',15,1),('Lr_absolute','The absolute mass of Lr in the sample.',20,1),('Lr_relative_mass','The absolute mass of Lr in the sample.',22,1),('Lu_absolute','The absolute mass of Lu in the sample.',20,1),('Lu_relative_mass','The absolute mass of Lu in the sample.',22,1),('macroporosity','A numeric value representing the macroporosity of the sample [volume-%]. Since the term \'macroporosity\' is ambiguous, the term should be defined in the description of the methods if values are available.',13,1),('mannose_mass_absolute','A numeric value representing the content of mannose, as described in @Strakova.2010.',20,1),('mannose_mass_relative_mass','A numeric value representing the content of mannose, as described in @Strakova.2010.',15,1),('mass','A numeric value representing the mass of the sample [g]. This is the mass of the extracted sample and masses of subsets of the sample may differ (for example: A peat layer dried at 105 degree C may have a mass of 200 g. This is the value to be reported. After milling, 10 g may be used to measure the pH value (this value should not be reported here, but in the description of the methods or in column \'comments\'.))',20,1),('mass_absolute','The mass of the sample.',19,1),('mass_relative_mass','The mass of the sample divided by the mass of a sample (e.g. the sample before decomposition).',22,1),('Md_absolute','The absolute mass of Md in the sample.',20,1),('Md_relative_mass','The absolute mass of Md in the sample.',22,1),('measurement_date','A datetime representing the dat and time when the spectrum was measured.',35,1),('measurement_date_reference','A datetime representing the dat and time when the reference (background) spectrum was measured when a separate background spectrum is available in the file.',35,1),('measurement_device','A string representing the name of the measurement device.',1,1),('measurement_scale','A string representing the measurement scale for a value.',1,1),('mesh_size_absolute','The width of the mesh the litterbags are made of.',19,1),('Mg_absolute','The absolute mass of Mg in the sample.',20,1),('Mg_relative_mass','The absolute mass of Mg in the sample.',22,1),('mirs_file','A string representing the path to the file with the mid infrared spectrum for the sample. This is a relative path relative to the root of the database. This field should be left empty upon creating the project because the file path is added automatically when the data are included in the database.',2,1),('mir_co2_contribution_relative','A numeric value representing the relative carbon dioxide contribution to a mid infrared spectrum. This is the slope of an ordinary least squares regression model fitting a reference carbon dioxide spectrum to a specified range of the spectrum.',9,1),('mir_co2_contribution_relative_sd','A numeric value representing an uncertainty estimate for the relative water vapor contribution to a mid infrared spectrum. This is the standard deviation of the slope of an ordinary least squares regression model fitting a reference water vapor spectrum to a specified range of the spectrum.',19,1),('mir_mode','A string representing the measurement mode in which the mid infrared spectra were measured. One of â€œabsorbance_ftirâ€, â€œatr_ftirâ€, â€œdr_ftirâ€.',1,1),('mir_water_vapor_contribution_relative','A numeric value representing the relative water vapor contribution to a mid infrared spectrum. This is the slope of an ordinary least squares regression model fitting a reference water vapor spectrum to a specified range of the spectrum.',9,1),('mir_water_vapor_contribution_relative_sd','A numeric value representing an uncertainty estimate for the relative water vapor contribution to a mid infrared spectrum. This is the standard deviation of the slope of an ordinary least squares regression model fitting a reference water vapor spectrum to a specified range of the spectrum.',19,1),('missing_value_code','A string representing a code for missing value in the tables â€œdataâ€, â€œsamplesâ€œ, â€macrofossilsâ€, and â€mir_metadataâ€ in the dpeatdecomposition database.',1,1),('missing_vlaue_code ','A string representing the value that is entered as mssing value in a table.',1,1),('Mn_absolute','The absolute mass of Mn in the sample.',20,1),('Mn_relative_mass','The absolute mass of Mn in the sample.',22,1),('Mo_absolute','The absolute mass of Mo in the sample.',20,1),('Mo_relative_mass','The absolute mass of Mo in the sample.',22,1),('Mt_absolute','The absolute mass of Mt in the sample.',20,1),('Mt_relative_mass','The absolute mass of Mt in the sample.',22,1),('multiplier_to_si','A numeric value representing the value with which a given value with a certain measurement unit has to be multiplied in order to convert it to a related SI unit.',9,1),('Na_absolute','The absolute mass of Na in the sample.',20,1),('Na_relative_mass','The absolute mass of Na in the sample.',22,1),('Nb_absolute','The absolute mass of Nb in the sample.',20,1),('Nb_relative_mass','The absolute mass of Nb in the sample.',22,1),('Nd_absolute','The absolute mass of Nd in the sample.',20,1),('Nd_relative_mass','The absolute mass of Nd in the sample.',22,1),('Ne_absolute','The absolute mass of Ne in the sample.',20,1),('Ne_relative_mass','The absolute mass of Ne in the sample.',22,1),('Ni_absolute','The absolute mass of Ni in the sample.',20,1),('Ni_relative_mass','The absolute mass of Ni in the sample.',22,1),('noise_level_relative','A numeric value representing the relative noise level of a mid infrared spectrum.',9,1),('No_absolute','The absolute mass of No in the sample.',20,1),('No_relative_mass','The absolute mass of No in the sample.',22,1),('Np_absolute','The absolute mass of Np in the sample.',20,1),('Np_relative_mass','The absolute mass of Np in the sample.',22,1),('number_type','A string representing the number type of a numeric variable.',1,1),('N_absolute','The absolute mass of nitrogen in the sample.',19,1),('N_relative_mass','The mass of the nitrogen in the sample divided by the mass of a sample (e.g. the sample before decomposition).',22,1),('N_relative_volume','The mass of the nitrogen in the sample divided by the volume of a sample (e.g. the volume of the sample).',23,1),('Os_absolute','The absolute mass of Os in the sample.',20,1),('Os_relative_mass','The absolute mass of Os in the sample.',22,1),('O_absolute','The absolute mass of O in the sample.',20,1),('O_relative_mass','The absolute mass of O in the sample.',22,1),('parent_si','A string representing the SI unit from which a certain derived unit is derived.',1,1),('particle_diameter_absolute','The diameter of particles (e.g. individual roots, branches, etc.) in the sample. Note: this is a generalization of `root_diameter_absolute`.',16,1),('Pa_absolute','The absolute mass of Pa in the sample.',20,1),('Pa_relative_mass','The absolute mass of Pa in the sample.',22,1),('Pb_absolute','The absolute mass of Pb in the sample.',20,1),('Pb_relative_mass','The absolute mass of Pb in the sample.',22,1),('Pd_absolute','The absolute mass of Pd in the sample.',20,1),('Pd_relative_mass','The absolute mass of Pd in the sample.',22,1),('pH','A numeric value representing the pH value of the sample.',9,1),('phenolics_PHBA_equivalents_mass_absolute','A numeric value representing the mass content of phenolics (p-hydroxy benzoic acid equivalent).',20,1),('phenolics_PHBA_equivalents_mass_relative_mass','A numeric value representing the mass content of phenolics (p-hydroxy benzoic acid equivalent).',15,1),('phenolics_tannic_acid_equivalents_mass_absolute','A numeric value representing the mass content of phenolics (tannic acid equivalent).',20,1),('phenolics_tannic_acid_equivalents_mass_relative_mass','A numeric value representing the mass content of phenolics (tannic acid equivalent).',15,1),('Pm_absolute','The absolute mass of Pm in the sample.',20,1),('Pm_relative_mass','The absolute mass of Pm in the sample.',22,1),('porosity','A numeric value representing the porosity of the sample [volume-%].',13,1),('power','An integer value. The power to which the dimension is raised.',3,1),('Po_absolute','The absolute mass of Po in the sample.',20,1),('Po_relative_mass','The absolute mass of Po in the sample.',22,1),('Pr_absolute','The absolute mass of Pr in the sample.',20,1),('Pr_relative_mass','The absolute mass of Pr in the sample.',22,1),('Pt_absolute','The absolute mass of Pt in the sample.',20,1),('Pt_relative_mass','The absolute mass of Pt in the sample.',22,1),('pub_date','A string with the year when the dataset was originally published with the format YYYY.',1,1),('purge_delay','A numeric value representing the duration of purge delay before a measurement in seconds.',28,1),('purpose','A free text field dscribing the purpse for which the dataset was created.',1,1),('Pu_absolute','The absolute mass of Pu in the sample.',20,1),('Pu_relative_mass','The absolute mass of Pu in the sample.',22,1),('P_absolute','The absolute mass of P in the sample.',20,1),('p_coumaric_acid_mass_absolute','A numeric value representing the content of p-coumaric acid, as described in @Strakova.2010.',20,1),('p_coumaric_acid_mass_relative_mass','A numeric value representing the content of p-coumaric acid, as described in @Strakova.2010.',15,1),('P_relative_mass','The absolute mass of P in the sample.',22,1),('Ra_absolute','The absolute mass of Ra in the sample.',20,1),('Ra_relative_mass','The absolute mass of Ra in the sample.',22,1),('Rb_absolute','The absolute mass of Rb in the sample.',20,1),('Rb_relative_mass','The absolute mass of Rb in the sample.',22,1),('reference_publication','A string in the bibtex format giving informatio on references which serve as references for data or publication where a certain dataset is described or used.',1,1),('rep_no','An integer value representing the sample repetition number.',34,1),('Re_absolute','The absolute mass of Re in the sample.',20,1),('Re_relative_mass','The absolute mass of Re in the sample.',22,1),('Rf_absolute','The absolute mass of Rf in the sample.',20,1),('Rf_relative_mass','The absolute mass of Rf in the sample.',22,1),('Rg_absolute','The absolute mass of Rg in the sample.',20,1),('Rg_relative_mass','The absolute mass of Rg in the sample.',22,1),('rhamnose_mass_absolute','A numeric value representing the content of rhamnose, as described in @Strakova.2010.',20,1),('rhamnose_mass_relative_mass','A numeric value representing the content of rhamnose, as described in @Strakova.2010.',15,1),('Rh_absolute','The absolute mass of Rh in the sample.',20,1),('Rh_relative_mass','The absolute mass of Rh in the sample.',22,1),('Rn_absolute','The absolute mass of Rn in the sample.',20,1),('Rn_relative_mass','The absolute mass of Rn in the sample.',22,1),('root_diameter_absolute','The diameter of roots in the sample.',27,1),('Ru_absolute','The absolute mass of Ru in the sample.',20,1),('Ru_relative_mass','The absolute mass of Ru in the sample.',22,1),('sample_depth_lower','A numeric value representing the depth of the lower boundary of a sample relative to the land surface (e.g. peat surface) [cm].',8,1),('sample_depth_upper','A numeric value representing the depth of the upper boundary of a sample relative to the land surface (e.g. peat surface) [cm].',8,1),('sample_label','A string representing a label for each sample.',1,1),('sample_microhabitat','A string describing the microhabitat where the sample was collected. For peat, this should be one of \'hummock\', \'hollow\', \'lawn\', \'pond\'. In other cases, a custom value can be used.',1,1),('sample_size','An integer representing the number of individual measurements which were used to compute the value in column `value`.',6,1),('sample_treatment','A string with an description of an experimental tratment if this was applied. By default, this should be \'control\', indicating that there was no manipulation. If there was any experimental manipulation, this can be abbreviated by a label (e.g. by a treatment level) that is defined in the textual description of the project (in the file \'description.docx\').',1,1),('sample_type','A string describing the type of the sample. Must be one of \'peat\', \'dom\', \'vegetation\', \'litter\'.',1,1),('sample_type2','A string describing the type of the sample. Here you can provide individual (own) categories which may provide more details than the column sample_type.',1,1),('sample_wet_mass_absolute','A numeric value representing the mass of the wet sample [g].',20,1),('sampling_altitude','A numeric value representing the altitude of the exact sampling position [m above sea level].',33,1),('sampling_date','A string with the date when the sample was collected (in the field) with the format YYYY-MM-DD.',35,1),('sampling_day','An integer representing the day in which a sample was collected.',5,1),('sampling_description','A free text field where the collection of samples is described (including experimental or sampling design).',1,1),('sampling_latitude','A numeric value representing the latitude coordinates of the exact sampling position (in the EPSG:3857 projection coordinate system --- this is the system used by Google and is based on the WGS 84 reference system) [Â°N].',7,1),('sampling_longitude','A numeric value representing the longitude coordinates of the exact sampling position (in the EPSG:3857 projection coordinate system --- this is the system used by Google and is based on the WGS 84 reference system) [Â°W].',7,1),('sampling_month','An integer representing the month in which a sample was collected.',4,1),('sampling_year','An integer representing the year in which a sample was collected.',6,1),('Sb_absolute','The absolute mass of Sb in the sample.',20,1),('Sb_relative_mass','The absolute mass of Sb in the sample.',22,1),('scan_number','An integer value representing the number of scans. ',11,1),('scan_speed','A numeric value representing the scan speed.',25,1),('Sc_absolute','The absolute mass of Sc in the sample.',20,1),('Sc_relative_mass','The absolute mass of Sc in the sample.',22,1),('Se_absolute','The absolute mass of Se in the sample.',20,1),('Se_relative_mass','The absolute mass of Se in the sample.',22,1),('Sg_absolute','The absolute mass of Sg in the sample.',20,1),('Sg_relative_mass','The absolute mass of Sg in the sample.',22,1),('site_name','A character representing the name of the site where the sample was collected.',1,1),('Si_absolute','The absolute mass of Si in the sample.',20,1),('Si_relative_mass','The absolute mass of Si in the sample.',22,1),('Sm_absolute','The absolute mass of Sm in the sample.',20,1),('Sm_relative_mass','The absolute mass of Sm in the sample.',22,1),('Sn_absolute','The absolute mass of Sn in the sample.',20,1),('Sn_relative_mass','The absolute mass of Sn in the sample.',22,1),('soluble_Klason_lignin_mass_absolute','A numeric value representing the mass content of soluble Klason lignin (following Ehrman 1996).',20,1),('soluble_Klason_lignin_mass_relative_mass','A numeric value representing the mass content of soluble Klason lignin (following Ehrman 1996).',15,1),('soluble_lignin_mass_absolute','A numeric value representing the content of soluble lignin, as described in @Strakova.2010.',20,1),('soluble_lignin_mass_relative_mass','A numeric value representing the content of soluble lignin, as described in @Strakova.2010.',15,1),('source_name','A string representing the name of the infrared radiation source.',1,1),('sphagnan_mass_absolute','A numeric value representing the mass content of sphagnan (Ballance et al., 2007).',20,1),('sphagnan_mass_relative_mass','A numeric value representing the mass content of sphagnan (Ballance et al., 2007).',15,1),('Sr_absolute','The absolute mass of Sr in the sample.',20,1),('Sr_relative_mass','The absolute mass of Sr in the sample.',22,1),('standard_unit','A logical value indicating if the unit is a standard unit of the Ecological Metadata Language or not.',1,1),('syringe_aldehyde_mass_absolute','A numeric value representing the content of syringe aldehyde, as described in @Strakova.2010.',20,1),('syringe_aldehyde_mass_relative_mass','A numeric value representing the content of syringe aldehyde, as described in @Strakova.2010.',15,1),('syringic_acid_mass_absolute','A numeric value representing the content of syringic acid, as described in @Strakova.2010.',20,1),('syringic_acid_mass_relative_mass','A numeric value representing the content of syringic acid, as described in @Strakova.2010.',15,1),('S_absolute','The absolute mass of S in the sample.',20,1),('S_relative_mass','The absolute mass of S in the sample.',22,1),('taxon_organ','A string describing the organ of a taxon the sample represents (if the sample represents a taxon). For example, if the sample is Carex lasiocarpa, this could be \'shoot\', or \'root\', or \'leaves\'.',1,1),('taxon_rank_name','A string describing the taxon rank the value in column taxon_rank_value represents (if the sample can be assigned to a specific taxon). For exampe, if the value in column taxon_rank_value is a species name, then you should enter \'species\' here, or if the value in column taxon_rank_value is a genus name, then you should enter \'genus\' here.',1,1),('taxon_rank_value','A string describing the taxon rank value of the sample (if the sample can be assigned to a taxon). For example, if the sample is a distinct species, enter the scientific species name here, or if the sample can be assigned to a genus, enter the scientific genus name here.',1,1),('Ta_absolute','The absolute mass of Ta in the sample.',20,1),('Ta_relative_mass','The absolute mass of Ta in the sample.',22,1),('Tb_absolute','The absolute mass of Tb in the sample.',20,1),('Tb_relative_mass','The absolute mass of Tb in the sample.',22,1),('Tc_absolute','The absolute mass of Tc in the sample.',20,1),('Tc_relative_mass','The absolute mass of Tc in the sample.',22,1),('temperature','A numeric value representing the temperature of the sample [K].',24,1),('temperature_scanner_reference','A numeric value representing the temperature of the scanner during the measurement of the reference (background).',31,1),('temperature_scanner_sample','A numeric value representing the temperature of the scanner during the measurement of the sample.',31,1),('text_domain_definition','A string representing the text domain for a string.',1,1),('Te_absolute','The absolute mass of Te in the sample.',20,1),('Te_relative_mass','The absolute mass of Te in the sample.',22,1),('Th_absolute','The absolute mass of Th in the sample.',20,1),('Th_relative_mass','The absolute mass of Th in the sample.',22,1),('title','A free text field with the title for a dataset.',1,1),('Ti_absolute','The absolute mass of Ti in the sample.',20,1),('Ti_relative_mass','The absolute mass of Ti in the sample.',22,1),('Tl_absolute','The absolute mass of Tl in the sample.',20,1),('Tl_relative_mass','The absolute mass of Tl in the sample.',22,1),('Tm_absolute','The absolute mass of Tm in the sample.',20,1),('Tm_relative_mass','The absolute mass of Tm in the sample.',22,1),('transition_description','A string representing a description of what happened to a parent sample during its transition to the child sample.',1,1),('udunits_unit','A string representing a measurement unit in the udunits format.',1,1),('unit_type','A string representing the type of a unit.',1,1),('Uuh_absolute','The absolute mass of Uuh in the sample.',20,1),('Uuh_relative_mass','The absolute mass of Uuh in the sample.',22,1),('Uup_absolute','The absolute mass of Uup in the sample.',20,1),('Uup_relative_mass','The absolute mass of Uup in the sample.',22,1),('Uuq_absolute','The absolute mass of Uuq in the sample.',20,1),('Uuq_relative_mass','The absolute mass of Uuq in the sample.',22,1),('Uut_absolute','The absolute mass of Uut in the sample.',20,1),('Uut_relative_mass','The absolute mass of Uut in the sample.',22,1),('U_absolute','The absolute mass of U in the sample.',20,1),('U_relative_mass','The absolute mass of U in the sample.',22,1),('value','A numeric value representing the measured value. The unit of the value is defined by the corresponding `attribute_name`.',19,1),('value_type','A character representing the type of the measured value. One of \'point\' (for a single measurement without uncertainty), or \'mean\' (average of multiple measurements).',1,1),('vanillic_acid_mass_absolute','A numeric value representing the content of vanillic acid, as described in @Strakova.2010.',20,1),('vanillic_acid_mass_relative_mass','A numeric value representing the content of vanillic acid, as described in @Strakova.2010.',15,1),('vanillin_mass_absolute','A numeric value representing the content of vanillin, as described in @Strakova.2010.',20,1),('vanillin_mass_relative_mass','A numeric value representing the content of vanillin, as described in @Strakova.2010.',15,1),('volume','A numeric value representing the volume of the sample [cm<sup>3</sup>].',17,1),('V_absolute','The absolute mass of V in the sample.',20,1),('V_relative_mass','The absolute mass of V in the sample.',22,1),('water_extractives_mass_absolute','A numeric value representing the content of water extractives, as described in @Strakova.2010.',20,1),('water_extractives_mass_relative_mass','A numeric value representing the content of water extractives, as described in @Strakova.2010.',15,1),('water_mass_absolute','A numeric value representing the water mass content of the sample as mass of water divided by the mass of the wet sample [g]',20,1),('water_mass_relative_mass','A numeric value representing the water mass content of the sample as mass of water divided by the mass of the wet sample [g/g]',15,1),('water_mass_relative_volume','A numeric value representing the water mass content of the sample as mass of water divided by the volume of the wet sample  [g cm<sup>-3</sup>].',14,1),('water_table_depth','A numeric value representing the depth to the water table level relative to the position of the sample.',12,1),('W_absolute','The absolute mass of W in the sample.',20,1),('W_relative_mass','The absolute mass of W in the sample.',22,1),('Xe_absolute','The absolute mass of Xe in the sample.',20,1),('Xe_relative_mass','The absolute mass of Xe in the sample.',22,1),('xylose_mass_absolute','A numeric value representing the content of xylose, as described in @Strakova.2010.',20,1),('xylose_mass_relative_mass','A numeric value representing the content of xylose, as described in @Strakova.2010.',15,1),('x_variable_max','A numeric value representing the maximum x variable value of each spectrum.',19,1),('x_variable_min','A numeric value representing the minimum x variable value of each spectrum.',19,1),('x_variable_type','A string representing the type of the x variable.',1,1),('Yb_absolute','The absolute mass of Yb in the sample.',20,1),('Yb_relative_mass','The absolute mass of Yb in the sample.',22,1),('Y_absolute','The absolute mass of Y in the sample.',20,1),('Y_relative_mass','The absolute mass of Y in the sample.',22,1),('y_variable_type','A string representing the type of the y variable.',1,1),('zero_filling_factor','An integer value representing the zero filling factor.',3,1),('Zn_absolute','The absolute mass of Zn in the sample.',20,1),('Zn_relative_mass','The absolute mass of Zn in the sample.',22,1),('Zr_absolute','The absolute mass of Zr in the sample.',20,1),('Zr_relative_mass','The absolute mass of Zr in the sample.',22,1);
/*!40000 ALTER TABLE `attributes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `citations`
--

DROP TABLE IF EXISTS `citations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `citations` (
  `id_citation` varchar(255) NOT NULL,
  `bibtex` mediumtext DEFAULT NULL,
  PRIMARY KEY (`id_citation`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `citations`
--

LOCK TABLES `citations` WRITE;
/*!40000 ALTER TABLE `citations` DISABLE KEYS */;
INSERT INTO `citations` VALUES ('Aerts.1997','@article{Aerts.1997,\n  title = {Nutritional and Plant-Mediated Controls on Leaf Litter Decomposition of {{{\\emph{Carex}}}} Species},\n  author = {Aerts, Rien and {de Caluwe}, Hannie},\n  year = {1997},\n  month = jan,\n  journal = {Ecology},\n  volume = {78},\n  number = {1},\n  pages = {244--260},\n  issn = {0012-9658},\n  doi = {10.1890/0012-9658(1997)078[0244:NAPMCO]2.0.CO;2},\n  urldate = {2021-04-30},\n  langid = {english}\n}'),('Aerts.1999','@article{Aerts.1999,\n  title = {Plant-Mediated Controls on Nutrient Cycling in Temperate Fens and Bogs},\n  author = {Aerts, R. and Verhoeven, J. T A. and Whigham, D. F.},\n  year = {1999},\n  month = oct,\n  journal = {Ecology},\n  volume = {80},\n  number = {7},\n  pages = {2170--2181},\n  issn = {0012-9658},\n  doi = {10.1890/0012-9658(1999)080[2170:PMCONC]2.0.CO;2},\n  urldate = {2021-04-28},\n  langid = {english}\n}'),('Aerts.2006','@article{Aerts.2006,\n  title = {Nitrogen Supply Differentially Affects Litter Decomposition Rates and Nitrogen Dynamics of Sub-Arctic Bog Species},\n  author = {Aerts, R. and van Logtestijn, R. S. P. and Karlsson, P. S.},\n  year = {2006},\n  month = jan,\n  journal = {Oecologia},\n  volume = {146},\n  number = {4},\n  pages = {652--658},\n  issn = {1432-1939},\n  doi = {10.1007/s00442-005-0247-5}\n}'),('Aerts.2012','@article{Aerts.2012,\n  title = {Seasonal Climate Manipulations Have Only Minor Effects on Litter Decomposition Rates and {{N}} Dynamics but Strong Effects on Litter {{P}} Dynamics of Sub-Arctic Bog Species},\n  author = {Aerts, R. and Callaghan, T. V. and Dorrepaal, E. and {van Logtestijn}, R. S. P. and Cornelissen, J. H. C.},\n  year = {2012},\n  month = nov,\n  journal = {Oecologia},\n  volume = {170},\n  number = {3},\n  pages = {809--819},\n  issn = {0029-8549, 1432-1939},\n  doi = {10.1007/s00442-012-2330-z},\n  urldate = {2023-01-12},\n  langid = {english}\n}'),('Andersen.2013','@article{Andersen.2013,\n  title = {Above-Ground Net Primary Production from Vascular Plants Shifts the Balance towards Organic Matter Accumulation in Restored {{{\\emph{Sphagnum}}}} Bogs},\n  author = {Andersen, Roxane and Pouliot, R{\\\'e}my and Rochefort, Line},\n  year = {2013},\n  month = oct,\n  journal = {Wetlands},\n  volume = {33},\n  number = {5},\n  pages = {811--821},\n  issn = {0277-5212, 1943-6246},\n  doi = {10.1007/s13157-013-0438-5},\n  urldate = {2023-01-13},\n  langid = {english}\n}'),('Arp.1999','@article{Arp.1999,\n  title = {The Effects of Acid Rock Drainage on {{{\\emph{Carex}}}}{\\emph{ Aquatilis}} Leaf Litter Decomposition in Rocky {{Mountain}} Fens},\n  author = {Arp, Christopher D. and Cooper, David J. and Stednick, John D.},\n  year = {1999},\n  month = sep,\n  journal = {Wetlands},\n  volume = {19},\n  number = {3},\n  pages = {665--674},\n  issn = {1943-6246},\n  doi = {10.1007/BF03161703}\n}'),('Asada.2004','@article{Asada.2004,\n  title = {{\\emph{Sphagnum}} Invasion after Clear-Cutting and Excavator Mounding in a Hypermaritime Forest of {{British Columbia}}},\n  author = {Asada, Taro and Warner, Barry G and Banner, Allen},\n  year = {2004},\n  month = aug,\n  journal = {Canadian Journal of Forest Research},\n  volume = {34},\n  number = {8},\n  pages = {1730--1746},\n  publisher = {NRC Research Press},\n  issn = {0045-5067},\n  doi = {10.1139/x04-042},\n  urldate = {2023-01-03}\n}'),('Asada.2005b','@article{Asada.2005b,\n  title = {Surface {{Peat Mass}} and {{Carbon Balance}} in a {{Hypermaritime Peatland}}},\n  author = {Asada, Taro and Warner, Barry G.},\n  year = {2005},\n  month = mar,\n  journal = {Soil Science Society of America Journal},\n  volume = {69},\n  number = {2},\n  pages = {549--562},\n  publisher = {John Wiley \\& Sons, Ltd},\n  issn = {0361-5995},\n  doi = {10.2136/sssaj2005.0549},\n  urldate = {2023-01-04}\n}'),('Asif.2021','@article{Asif.2021,\n  title = {Litter Mixing Effects on Decomposition in a Peatland Partially Drained 30 Years Ago},\n  author = {Asif, Talal and Naeem, Iqra and Bu, Zhao-Jun and Mallik, Azim and Ma, Jin-Ze and Rochefort, Line},\n  year = {2021},\n  month = dec,\n  journal = {Wetlands Ecology and Management},\n  volume = {29},\n  number = {6},\n  pages = {883--895},\n  issn = {0923-4861, 1572-9834},\n  doi = {10.1007/s11273-021-09818-4},\n  urldate = {2023-01-17},\n  langid = {english}\n}'),('Babinski.2019','@article{Babinski.2019,\n  title = {Are the Wooden Remains of the {{Lusatian}} Culture Settlement at {{Biskupin}} Safe? {{Decomposition}} of Archaeological Oak Wood Samples during a 10-Year Experiment},\n  shorttitle = {Are the Wooden Remains of the {{Lusatian}} Culture Settlement at {{Biskupin}} Safe?},\n  author = {Babi{\\\'n}ski, Leszek and Zborowska, Magdalena and Fabisiak, Ewa and Pr{\\k a}dzy{\\\'n}ski, W{\\l}odzimierz},\n  year = {2019},\n  month = dec,\n  journal = {Archaeological and Anthropological Sciences},\n  volume = {11},\n  number = {12},\n  pages = {6583--6594},\n  issn = {1866-9557, 1866-9565},\n  doi = {10.1007/s12520-019-00926-0},\n  urldate = {2023-01-13},\n  langid = {english}\n}'),('Bambalov.2007','@article{Bambalov.2007,\n  title = {The Lignin Content in Virgin and Cultivated Peat Soils of {{Belarussian}} Poles\'e},\n  author = {Bambalov, N. N.},\n  year = {2007},\n  month = nov,\n  journal = {Eurasian Soil Science},\n  volume = {40},\n  number = {11},\n  pages = {1175--1180},\n  issn = {1556-195X},\n  doi = {10.1134/S106422930711004X}\n}'),('Barel.2021','@article{Barel.2021,\n  title = {Come Rain, Come Shine: {{Peatland}} Carbon Dynamics Shift under Extreme Precipitation},\n  shorttitle = {Come {{Rain}}, {{Come Shine}}},\n  author = {Barel, Janna M. and Moulia, Vincent and Hamard, Samuel and Sytiuk, Anna and Jassey, Vincent E. J.},\n  year = {2021},\n  month = jun,\n  journal = {Frontiers in Environmental Science},\n  volume = {9},\n  pages = {659953},\n  issn = {2296-665X},\n  doi = {10.3389/fenvs.2021.659953},\n  urldate = {2023-01-13}\n}'),('Bartsch.1985','@article{Bartsch.1985,\n  title = {A Preliminary Investigation of Primary Production and Decomposition in Four Peatlands near {{Schefferville}}, {{Qu{\\\'e}bec}}},\n  author = {Bartsch, I. and Moore, T. R.},\n  year = {1985},\n  month = jul,\n  journal = {Canadian Journal of Botany},\n  volume = {63},\n  number = {7},\n  pages = {1241--1248},\n  publisher = {NRC Research Press},\n  issn = {0008-4026},\n  doi = {10.1139/b85-171},\n  urldate = {2022-12-25}\n}'),('Batistel.2021','@article{Batistel.2021,\n  title = {Salinity Exerted Little Effect on Decomposition of Emergent Macrophytes in Coastal Peatlands},\n  author = {Batistel, Cheryl C. and Jurasinski, Gerald and Schubert, Hendrik},\n  year = {2021},\n  month = oct,\n  journal = {Aquatic Botany},\n  volume = {175},\n  pages = {103446},\n  issn = {03043770},\n  doi = {10.1016/j.aquabot.2021.103446},\n  urldate = {2023-01-13},\n  langid = {english}\n}'),('Bayley.2004','@article{Bayley.2004,\n  title = {Plant Community Structure and Functional Differences between Marshes and Fens in the Southern Boreal Region of {{Alberta}}, {{Canada}}},\n  author = {Bayley, Suzanne E. and Mewhort, Randi L.},\n  year = {2004},\n  month = jun,\n  journal = {Wetlands},\n  volume = {24},\n  number = {2},\n  pages = {277--294},\n  issn = {1943-6246},\n  doi = {10.1672/0277-5212(2004)024[0277:PCSAFD]2.0.CO;2}\n}'),('Bayley.2005','@article{Bayley.2005,\n  title = {Nitrogen Mineralization and Decomposition in Western Boreal Bog and Fen Peat},\n  author = {Bayley, Suzanne E. and Thormann, Markus N. and Szumigalski, Anthony R.},\n  year = {2005},\n  month = jan,\n  journal = {{\\\'E}coscience},\n  volume = {12},\n  number = {4},\n  pages = {455--465},\n  publisher = {Taylor \\& Francis},\n  issn = {1195-6860},\n  doi = {10.2980/i1195-6860-12-4-455.1}\n}'),('Bell.2018','@article{Bell.2018,\n  title = {Sensitivity of Peatland Litter Decomposition to Changes in Temperature and Rainfall},\n  author = {Bell, Michael C. and Ritson, Jonathan P. and Verhoef, Anne and Brazier, Richard E. and Templeton, Michael R. and Graham, Nigel J.D. and Freeman, Chris and Clark, Joanna M.},\n  year = {2018},\n  month = dec,\n  journal = {Geoderma},\n  volume = {331},\n  pages = {29--37},\n  issn = {00167061},\n  doi = {10.1016/j.geoderma.2018.06.002},\n  urldate = {2023-01-13},\n  langid = {english}\n}'),('Bengtsson.2016','@article{Bengtsson.2016,\n  title = {Photosynthesis, Growth, and Decay Traits in {{{\\emph{Sphagnum}}}} -- a Multispecies Comparison},\n  author = {Bengtsson, Fia and Granath, Gustaf and Rydin, H{\\aa}kan},\n  year = {2016},\n  month = may,\n  journal = {Ecology and Evolution},\n  volume = {6},\n  number = {10},\n  pages = {3325--3341},\n  publisher = {John Wiley \\& Sons, Ltd},\n  issn = {2045-7758},\n  doi = {10.1002/ece3.2119},\n  urldate = {2022-12-15}\n}'),('Bengtsson.2017','@misc{Bengtsson.2017,\n  title = {Data from: {{Photosynthesis}}, Growth, and Decay Traits in {{{\\emph{Sphagnum}}}} -- a Multispecies Comparison},\n  shorttitle = {Data From},\n  author = {Bengtsson, Fia and Granath, Gustaf and Rydin, H{\\aa}kan},\n  year = {2017},\n  pages = {83493 bytes},\n  publisher = {Dryad},\n  doi = {10.5061/DRYAD.62054},\n  urldate = {2022-12-15},\n  copyright = {Creative Commons Zero v1.0 Universal},\n  langid = {english}\n}'),('Bengtsson.2018','@article{Bengtsson.2018,\n  title = {Biochemical Determinants of Litter Quality in 15 Species of {{{\\emph{Sphagnum}}}}},\n  author = {Bengtsson, Fia and Rydin, H{\\aa}kan and H{\\\'a}jek, Tom{\\\'a}{\\v s}},\n  year = {2018},\n  month = apr,\n  journal = {Plant and Soil},\n  volume = {425},\n  number = {1-2},\n  pages = {161--176},\n  issn = {0032-079X, 1573-5036},\n  doi = {10.1007/s11104-018-3579-8},\n  urldate = {2021-06-01},\n  langid = {english}\n}'),('Bengtsson.2018a','@misc{Bengtsson.2018a,\n  title = {Data from: {{Biochemical}} Determinants of Litter Quality in 15 Species of {{{\\emph{Sphagnum}}}}},\n  shorttitle = {Data From},\n  author = {Bengtsson, Fia and Rydin, H{\\aa}kan and H{\\\'a}jek, Tom{\\\'a}{\\v s}},\n  year = {2018},\n  pages = {126029 bytes},\n  publisher = {Dryad},\n  doi = {10.5061/DRYAD.4F8D2},\n  urldate = {2022-12-15},\n  copyright = {Creative Commons Zero v1.0 Universal},\n  langid = {english}\n}'),('Bengtsson.2019','@article{Bengtsson.2019,\n  title = {Correction to: {{Biochemical}} Determinants of Litter Quality in 15 Species of {{{\\emph{Sphagnum}}}}},\n  author = {Bengtsson, Fia and Rydin, H{\\aa}kan and H{\\\'a}jek, Tom{\\\'a}{\\v s}},\n  year = {2019},\n  month = jun,\n  journal = {Plant and Soil},\n  volume = {439},\n  number = {1},\n  pages = {569--572},\n  issn = {1573-5036},\n  doi = {10.1007/s11104-019-04046-5}\n}'),('Berg.1984','@article{Berg.1984,\n  title = {Decomposition of Mass Litter in a Mature Scots Pine Forest},\n  author = {Berg, B},\n  year = {1984},\n  journal = {Pedobiologia (Jena)},\n  volume = {26},\n  number = {5},\n  pages = {301--308}\n}'),('Berube.2018','@article{Berube.2018,\n  title = {Production and Decomposition Rates of Different Fen Species as Targets for Restoration},\n  author = {B{\\\'e}rub{\\\'e}, Vicky and Rochefort, Line},\n  year = {2018},\n  month = aug,\n  journal = {Ecological Indicators},\n  volume = {91},\n  pages = {105--115},\n  issn = {1470160X},\n  doi = {10.1016/j.ecolind.2018.03.069},\n  urldate = {2023-01-13},\n  langid = {english}\n}'),('Bhuiyan.2022','@misc{Bhuiyan.2022,\n  title = {Fine-Root Biomass Production, Sedge Root, Sedge Leaf, and Moss Shoot Decomposition, Soil Water-Table Level, and Temperature Data from Two Sedge Fens in {{Finland}}},\n  author = {Bhuiyan, Rabbil and M{\\\"a}kiranta, P{\\\"a}ivi and Strakov{\\\'a}, Petra and Fritze, Hannu and Minkkinen, Kari and Penttil{\\\"a}, Timo and Tuittila, Eeva-Stiina and Laiho, Raija},\n  year = {2022},\n  month = nov,\n  publisher = {Zenodo},\n  doi = {10.5281/ZENODO.7193829},\n  urldate = {2023-01-13},\n  copyright = {Creative Commons Attribution 4.0 International, Open Access}\n}'),('Bona.2018','@article{Bona.2018,\n  title = {A Peatland Productivity and Decomposition Parameter Database},\n  author = {Bona, Kelly Ann and Hilger, Arlene and Burgess, Magdalena and Wozney, Nicole and Shaw, Cindy},\n  year = {2018},\n  month = oct,\n  journal = {Ecology},\n  volume = {99},\n  number = {10},\n  pages = {2406--2406},\n  issn = {00129658},\n  doi = {10.1002/ecy.2462},\n  urldate = {2021-04-28},\n  langid = {english}\n}'),('Braekke.1990','@article{Braekke.1990,\n  title = {Decomposition of Cellulose in Litter Layer and Surface Peat of Low-shrub Pine Bogs},\n  author = {Br{\\ae}kke, Finn H. and Fin{\\\'e}r, Leena},\n  year = {1990},\n  month = jan,\n  journal = {Scandinavian Journal of Forest Research},\n  volume = {5},\n  number = {1-4},\n  pages = {297--310},\n  issn = {0282-7581, 1651-1891},\n  doi = {10.1080/02827589009382614},\n  urldate = {2023-01-17},\n  langid = {english}\n}'),('Bragazza.2007','@article{Bragazza.2007,\n  title = {Mass Loss and Nutrient Release during Litter Decay in Peatland: {{The}} Role of Microbial Adaptability to Litter Chemistry},\n  author = {Bragazza, L and Siffi, C and Iacumin, P and Gerdol, R},\n  year = {2007},\n  journal = {Soil Biology},\n  volume = {39},\n  number = {1},\n  pages = {11},\n  doi = {10.1016/j.soilbio.2006.07.014},\n  langid = {english}\n}'),('Bragazza.2009','@article{Bragazza.2009,\n  title = {Seasonal Variation in Carbon Isotopic Composition of Bog Plant Litter during 3 Years of Field Decomposition},\n  author = {Bragazza, Luca and Iacumin, Paola},\n  year = {2009},\n  month = nov,\n  journal = {Biology and Fertility of Soils},\n  volume = {46},\n  number = {1},\n  pages = {73--77},\n  issn = {0178-2762, 1432-0789},\n  doi = {10.1007/s00374-009-0406-7},\n  urldate = {2022-04-26},\n  langid = {english}\n}'),('Bragazza.2010','@article{Bragazza.2010,\n  title = {Seasonal Variation in Nitrogen Isotopic Composition of Bog Plant Litter during 3 Years of Field Decomposition},\n  author = {Bragazza, Luca and Iacumin, Paola and Siffi, Chiara and Gerdol, Renato},\n  year = {2010},\n  month = oct,\n  journal = {Biology and Fertility of Soils},\n  volume = {46},\n  number = {8},\n  pages = {877--881},\n  issn = {0178-2762, 1432-0789},\n  doi = {10.1007/s00374-010-0483-7},\n  urldate = {2022-04-26},\n  langid = {english}\n}'),('Breeuwer.2008','@article{Breeuwer.2008,\n  title = {The Effect of Increased Temperature and Nitrogen Deposition on Decomposition in Bogs},\n  author = {Breeuwer, Angela and Heijmans, Monique and Robroek, Bjorn J. M. and Limpens, Juul and Berendse, Frank},\n  year = {2008},\n  month = aug,\n  journal = {Oikos},\n  volume = {117},\n  number = {8},\n  pages = {1258--1268},\n  issn = {00301299},\n  doi = {10.1111/j.0030-1299.2008.16518.x},\n  urldate = {2023-01-09},\n  langid = {english}\n}'),('Bridgham.1991','@article{Bridgham.1991,\n  title = {Cellulose Decay in Natural and Disturbed Peatlands in {{North Carolina}}},\n  author = {Bridgham, Scott D. and Richardson, Curtis J. and Maltby, Edward and Faulkner, Stephen P.},\n  year = {1991},\n  month = jul,\n  journal = {Journal of Environmental Quality},\n  volume = {20},\n  number = {3},\n  pages = {695--701},\n  publisher = {John Wiley \\& Sons, Ltd},\n  issn = {0047-2425},\n  doi = {10.2134/jeq1991.00472425002000030032x},\n  urldate = {2022-12-28}\n}'),('Corteselli.2017','@article{Corteselli.2017,\n  title = {Leaf Litter Fuels Methanogenesis throughout Decomposition in a Forested Peatland},\n  author = {Corteselli, Elizabeth M. and Burtis, James C. and Heinz, Alexis K. and Yavitt, Joseph B.},\n  year = {2017},\n  month = sep,\n  journal = {Ecosystems},\n  volume = {20},\n  number = {6},\n  pages = {1217--1232},\n  issn = {1432-9840, 1435-0629},\n  doi = {10.1007/s10021-016-0105-9},\n  urldate = {2023-01-13},\n  langid = {english}\n}'),('Curry.1989','@article{Curry.1989,\n  title = {The Invertebrate Fauna of Reclaimed Cutaway Peat in Central Ireland and Its Influence on Soil Fertility and Plant Growth},\n  author = {Curry, J.P. and Boyle, K.E. and Farrell, E.P.},\n  year = {1989},\n  month = nov,\n  journal = {International Symposium on Agricultural Ecology and Environment},\n  volume = {27},\n  number = {1},\n  pages = {217--225},\n  issn = {0167-8809},\n  doi = {10.1016/0167-8809(89)90087-X}\n}'),('Davis.1986','@article{Davis.1986,\n  title = {Environmental Factors Influencing Decomposition Rates in Two {{Antarctic}} Moss Communities},\n  author = {Davis, R. C.},\n  year = {1986},\n  month = feb,\n  journal = {Polar Biology},\n  volume = {5},\n  number = {2},\n  pages = {95--103},\n  issn = {1432-2056},\n  doi = {10.1007/BF00443381}\n}'),('Dieleman.2016','@article{Dieleman.2016,\n  title = {Climate Change Effects on Peatland Decomposition and Porewater Dissolved Organic Carbon Biogeochemistry},\n  author = {Dieleman, Catherine M. and Lindo, Zo{\\\"e} and McLaughlin, James W. and Craig, Aaron E. and Branfireun, Brian A.},\n  year = {2016},\n  month = jul,\n  journal = {Biogeochemistry},\n  volume = {128},\n  number = {3},\n  pages = {385--396},\n  issn = {0168-2563, 1573-515X},\n  doi = {10.1007/s10533-016-0214-8},\n  urldate = {2023-01-13},\n  langid = {english}\n}'),('Domisch.2006','@article{Domisch.2006,\n  title = {Decomposition and~Nitrogen Dynamics of~Litter in~Peat Soils from Two~Climatic Regions under Different Temperature Regimes},\n  author = {Domisch, Timo and Fin{\\\'e}r, Leena and Laine, Jukka and Laiho, Raija},\n  year = {2006},\n  month = apr,\n  journal = {European Journal of Soil Biology},\n  volume = {42},\n  number = {2},\n  pages = {74--81},\n  issn = {1164-5563},\n  doi = {10.1016/j.ejsobi.2005.09.017}\n}'),('Dorrepaal.2007a','@article{Dorrepaal.2007a,\n  title = {Changing Leaf Litter Feedbacks on Plant Production across Contrasting Sub-Arctic Peatland Species and Growth Forms},\n  author = {Dorrepaal, Ellen and Cornelissen, Johannes H. C. and Aerts, Rien},\n  year = {2007},\n  month = mar,\n  journal = {Oecologia},\n  volume = {151},\n  number = {2},\n  pages = {251--261},\n  issn = {1432-1939},\n  doi = {10.1007/s00442-006-0580-3}\n}'),('Farrish.1985','@article{Farrish.1985,\n  title = {Mass Loss in a Forested Bog: {{Relation}} to Hummock and Hollow Microrelief},\n  author = {Farrish, K. W. and Grigal, D. F.},\n  year = {1985},\n  month = may,\n  journal = {Canadian Journal of Soil Science},\n  volume = {65},\n  number = {2},\n  pages = {375--378},\n  publisher = {NRC Research Press},\n  issn = {0008-4271},\n  doi = {10.4141/cjss85-042},\n  urldate = {2022-12-25}\n}'),('Farrish.1988','@article{Farrish.1988,\n  title = {Decomposition in an Omrotrophic Bog and a Minerotrophic Fen in {{Minnesota}}},\n  shorttitle = {Decomposition in an Omrotrophic Bog and a Minerotrophic Fen in {{Minnesota}}},\n  author = {Farrish, K. W. and Grigal, D. F.},\n  year = {1988},\n  month = may,\n  journal = {Soil Science},\n  volume = {145},\n  number = {5},\n  pages = {353--358},\n  issn = {0038-075X},\n  doi = {10.1097/00010694-198805000-00005},\n  urldate = {2021-04-30},\n  langid = {english}\n}'),('Fernandez.2019','@misc{Fernandez.2019,\n  title = {{{SPRUCE}} Fungal Necromass Litter Bag Decomposition Study in {{SPRUCE}} Experimental Plots, 2016-2018},\n  author = {Fernandez, C.W. and Heckman, K. and Kolka, R. and Kennedy, P.G.},\n  year = {2019},\n  publisher = {Oak Ridge National Laboratory (ORNL), Oak Ridge, TN (United States)},\n  doi = {10.25581/SPRUCE.063/1503589},\n  urldate = {2023-01-13},\n  langid = {english}\n}'),('Fernandez.2019a','@article{Fernandez.2019a,\n  title = {Melanin Mitigates the Accelerated Decay of Mycorrhizal Necromass with Peatland Warming},\n  author = {Fernandez, Christopher W. and Heckman, Katherine and Kolka, Randall and Kennedy, Peter G.},\n  editor = {Klironomos, John},\n  year = {2019},\n  month = mar,\n  journal = {Ecology Letters},\n  volume = {22},\n  number = {3},\n  pages = {498--505},\n  issn = {1461-023X, 1461-0248},\n  doi = {10.1111/ele.13209},\n  urldate = {2023-01-13},\n  langid = {english}\n}'),('Gantes.2005','@article{Gantes.2005,\n  title = {Production and Decomposition in Floating Soils of the {{Iber{\\\'a}}} Wetlands ({{Argentina}})},\n  author = {Gantes, Patricia and Torremorell, Ana},\n  year = {2005},\n  journal = {Limnetica},\n  volume = {24},\n  number = {3-4},\n  pages = {203--210},\n  issn = {0213-8409},\n  urldate = {2023-01-04},\n  langid = {english}\n}'),('Gerdol.2011','@article{Gerdol.2011,\n  title = {Hydrologic Controls on Water Chemistry, Vegetation and Ecological Patterns in Two Mires in the {{South-Eastern Alps}} ({{Italy}})},\n  author = {Gerdol, Renato and Pontin, Alessandro and Tomaselli, Marcello and Bombonato, Laura and Brancaleoni, Lisa and Gualmini, Matteo and Petraglia, Alessandro and Siffi, Chiara and Gargini, Alessandro},\n  year = {2011},\n  month = aug,\n  journal = {CATENA},\n  volume = {86},\n  number = {2},\n  pages = {86--97},\n  issn = {03418162},\n  doi = {10.1016/j.catena.2011.02.008},\n  urldate = {2023-01-11},\n  langid = {english}\n}'),('Gogo.2016','@article{Gogo.2016,\n  title = {In Situ and Laboratory Non-Additive Litter Mixture Effect on {{C}} Dynamics of {{Sphagnum}} Rubellum and {{Molinia}} Caerulea Litters},\n  author = {Gogo, S{\\\'e}bastien and {Laggoun-D{\\\'e}farge}, Fatima and Merzouki, Fatima and Mounier, St{\\\'e}phane and {Guirimand-Dufour}, Audrey and Jozja, Nevila and Huguet, Arnaud and Delarue, Fr{\\\'e}d{\\\'e}ric and D{\\\'e}farge, Christian},\n  year = {2016},\n  month = jan,\n  journal = {Journal of Soils and Sediments},\n  volume = {16},\n  number = {1},\n  pages = {13--27},\n  issn = {1439-0108, 1614-7480},\n  doi = {10.1007/s11368-015-1178-3},\n  urldate = {2023-01-13},\n  langid = {english}\n}'),('Golovatskaya.2017','@article{Golovatskaya.2017,\n  title = {The Influence of the Bog Water Level on the Transformation of Sphagnum Mosses in Peat Soils of Oligotrophic Bogs},\n  author = {Golovatskaya, E. A. and Nikonova, L. G.},\n  year = {2017},\n  month = may,\n  journal = {Eurasian Soil Science},\n  volume = {50},\n  number = {5},\n  pages = {580--588},\n  issn = {1064-2293, 1556-195X},\n  doi = {10.1134/S1064229317030036},\n  urldate = {2023-01-13},\n  langid = {english}\n}'),('Graf.2009','@article{Graf.2009,\n  title = {Examining the Peat-Accumulating Potential of Fen Vegetation in the Context of Fen Restoration of Harvested Peatlands},\n  author = {Graf, Martha and Rochefort, Line},\n  year = {2009},\n  month = jun,\n  journal = {{\\\'E}coscience},\n  volume = {16},\n  number = {2},\n  pages = {158--166},\n  publisher = {Taylor \\& Francis},\n  issn = {1195-6860},\n  doi = {10.2980/16-2-3128}\n}'),('Hagemann.2015','@article{Hagemann.2015,\n  title = {Moss and Lichen Decomposition in Old-Growth and Harvested High-Boreal Forests Estimated Using the Litterbag and Minicontainer Methods},\n  author = {Hagemann, Ulrike and Moroni, Martin T.},\n  year = {2015},\n  month = aug,\n  journal = {Soil Biology and Biochemistry},\n  volume = {87},\n  pages = {10--24},\n  issn = {00380717},\n  doi = {10.1016/j.soilbio.2015.04.002},\n  urldate = {2023-01-13},\n  langid = {english}\n}'),('Hagemann.2016','@misc{Hagemann.2016,\n  title = {Data on Moss and Lichen Decomposition Rates and Nutrient Loss from Old-Growth and Harvested High-Boreal Forests Estimated Using the Litterbag and Minicontainer Methods},\n  author = {Hagemann, Ulrike and Moroni, Martin T.},\n  year = {2016},\n  publisher = {Leibniz-Zentrum f{\\\"u}r Agrarlandschaftsforschung (ZALF) e.V.},\n  doi = {10.4228/ZALF.2007.290},\n  urldate = {2023-01-27},\n  collaborator = {Science, German National Library Of and Sustainability (IBES), Ecosystem Science And, Institute For Biodiversity and Model Forest Of Newfoundland And Labrador and Canada, Forest Management Committee Of District 19a In Labrador and {N{\\\"u}sslein-Volhard-Stiftung}, Christiane and National German Academic Foundation and Government Of Canada and M{\\\"u}ncheberg (Germany), Leibniz-Zentrum F{\\\"u}r Agrarlandschaftsforschung (ZALF) E. V. and Natural Resources Canada, Atlantic Forestry Centre Corner Brook and Dresden University Of Technology, Institute Of Soil Science and Hagemann, Ulrike and Hagemann, Ulrike},\n  copyright = {Creative Commons Attribution Non Commercial 4.0 International},\n  langid = {english}\n}'),('Haraguchi.2002','@article{Haraguchi.2002,\n  title = {Decomposition of Organic Matter in Peat Soil in a Minerotrophic Mire},\n  author = {Haraguchi, Akira and Kojima, Hisaya and Hasegawa, Chiaki and Takahashi, Yukari and Iyobe, Tsutomu},\n  year = {2002},\n  month = feb,\n  journal = {European Journal of Soil Biology},\n  volume = {38},\n  number = {1},\n  pages = {89--95},\n  issn = {1164-5563},\n  doi = {10.1016/S1164-5563(01)01112-8}\n}'),('Haraguchi.2003','@article{Haraguchi.2003,\n  title = {Decomposition Activity of Peat Soils in Geogenous Mires in {{Sasakami}}, Central {{Japan}}},\n  author = {Haraguchi, Akira and Hasegawa, Chiaki and Hirayama, Akiko and Kojima, Hisaya},\n  year = {2003},\n  month = oct,\n  journal = {European Journal of Soil Biology},\n  volume = {39},\n  number = {4},\n  pages = {191--196},\n  issn = {1164-5563},\n  doi = {10.1016/j.ejsobi.2003.05.001}\n}'),('Heal.1978','@incollection{Heal.1978,\n  title = {A Study of the Rates of Decomposition of Organic Matter},\n  booktitle = {Production {{Ecology}} of {{British Moors}} and {{Montane Grasslands}}},\n  author = {Heal, O. W. and Latter, P. M. and Howson, G.},\n  editor = {Billings, W. D. and Golley, F. and Lange, O. L. and Olson, J. S. and Heal, O. W. and Perkins, D. F.},\n  year = {1978},\n  volume = {27},\n  pages = {136--159},\n  publisher = {Springer Berlin Heidelberg},\n  address = {Berlin, Heidelberg},\n  doi = {10.1007/978-3-642-66760-2_7},\n  urldate = {2023-01-17},\n  isbn = {978-3-642-66762-6 978-3-642-66760-2}\n}'),('Hiroki.1996','@article{Hiroki.1996,\n  title = {Microbial Community and Rate of Cellulose Decomposition in Peat Soils in a Mire},\n  author = {Hiroki, Mikiya and Watanabe, Makoto M.},\n  year = {1996},\n  month = dec,\n  journal = {Soil Science and Plant Nutrition},\n  volume = {42},\n  number = {4},\n  pages = {893--903},\n  publisher = {Taylor \\& Francis},\n  issn = {0038-0768},\n  doi = {10.1080/00380768.1996.10416636}\n}'),('Hobbie.1996','@article{Hobbie.1996,\n  title = {Temperature and Plant Species Control over Litter Decomposition in {{Alaskan}} Tundra},\n  author = {Hobbie, Sarah E.},\n  year = {1996},\n  month = nov,\n  journal = {Ecological Monographs},\n  volume = {66},\n  number = {4},\n  pages = {503--522},\n  issn = {0012-9615, 1557-7015},\n  doi = {10.2307/2963492},\n  urldate = {2023-01-17},\n  langid = {english}\n}'),('Hogg.1992','@article{Hogg.1992,\n  title = {Potential Carbon Losses from Peat Profiles: {{Effects}} of Temperature, Drought Cycles, and Fire},\n  author = {Hogg, Edward H. and Lieffers, Victor J. and Wein, Ross W.},\n  year = {1992},\n  month = aug,\n  journal = {Ecological Applications},\n  volume = {2},\n  number = {3},\n  pages = {298--306},\n  publisher = {John Wiley \\& Sons, Ltd},\n  issn = {1051-0761},\n  doi = {10.2307/1941863},\n  urldate = {2022-12-28}\n}'),('Hoorens.2010','@article{Hoorens.2010,\n  title = {Litter Mixture Interactions at the Level of Plant Functional Types Are Additive},\n  author = {Hoorens, Bart and Stroetenga, Martin and Aerts, Rien},\n  year = {2010},\n  month = jan,\n  journal = {Ecosystems},\n  volume = {13},\n  number = {1},\n  pages = {90--98},\n  issn = {1432-9840, 1435-0629},\n  doi = {10.1007/s10021-009-9301-1},\n  urldate = {2023-01-11},\n  langid = {english}\n}'),('Janssen.1984','@article{Janssen.1984,\n  title = {A Simple Method for Calculating Decomposition and Accumulation of `Young\' Soil Organic Matter},\n  author = {Janssen, B. H.},\n  year = {1984},\n  month = feb,\n  journal = {Plant and Soil},\n  volume = {76},\n  number = {1},\n  pages = {297--304},\n  issn = {1573-5036},\n  doi = {10.1007/BF02205588}\n}'),('Jassey.2021','@article{Jassey.2021,\n  title = {Come Rain, Come Shine: {{Peatland}} Carbon Dynamics Shift under Extreme Precipitation},\n  shorttitle = {Come {{Rain}}, {{Come Shine}}},\n  author = {Jassey, Vincent and Barel, Janna M. and Moulia, Vincent and Hamard, Samuel and Sytiuk, Anna},\n  year = {2021},\n  publisher = {figshare},\n  doi = {10.6084/M9.FIGSHARE.C.5468205},\n  urldate = {2023-01-13},\n  copyright = {Creative Commons Attribution 4.0 International}\n}'),('Johnson.1991','@article{Johnson.1991,\n  title = {Species-Controlled {{{\\emph{Sphagnum}}}} Decay on a South {{Swedish}} Raised Bog},\n  author = {Johnson, Loretta C. and Damman, Antoni W. H.},\n  year = {1991},\n  month = jun,\n  journal = {Oikos},\n  volume = {61},\n  number = {2},\n  eprint = {3545341},\n  eprinttype = {jstor},\n  pages = {234},\n  issn = {00301299},\n  doi = {10.2307/3545341},\n  urldate = {2021-04-18},\n  langid = {english}\n}'),('Jones.2019','@techreport{Jones.2019,\n  title = {Ecological Metadata Language Version 2.2.0},\n  author = {Jones, Matthew and O\'Brien, Margaret and Mecum, Bryce and Boettiger, Carl and Schildhauer, Mark and Maier, Mitchell and Whiteaker, Timothy and Earl, Stevan and Chong, Steven},\n  year = {2019},\n  institution = {KNB Data Repository},\n  doi = {10.5063/f11834t2},\n  urldate = {2022-02-08}\n}'),('Koronatova.2010','@article{Koronatova.2010,\n  title = {Change of Peat Mass during Decomposition in Mires of {{Poland}} and {{West Siberia}}},\n  author = {Koronatova, N. G. and Shibareva, S. V.},\n  year = {2010},\n  month = jun,\n  journal = {Contemporary Problems of Ecology},\n  volume = {3},\n  number = {3},\n  pages = {312--317},\n  issn = {1995-4255, 1995-4263},\n  doi = {10.1134/S1995425510030094},\n  urldate = {2023-01-11},\n  langid = {english}\n}'),('Krab.2013','@article{Krab.2013,\n  title = {Vascular Plant Litter Input in Subarctic Peat Bogs Changes {{Collembola}} Diets and Decomposition Patterns},\n  author = {Krab, Eveline J. and Berg, Matty P. and Aerts, Rien and {van Logtestijn}, Richard S.P. and Cornelissen, Johannes H.C.},\n  year = {2013},\n  month = aug,\n  journal = {Soil Biology and Biochemistry},\n  volume = {63},\n  pages = {106--115},\n  issn = {00380717},\n  doi = {10.1016/j.soilbio.2013.03.032},\n  urldate = {2023-01-12},\n  langid = {english}\n}'),('Laiho.2004','@article{Laiho.2004,\n  title = {Scots Pine Litter Decomposition along Drainage Succession and Soil Nutrient Gradients in Peatland Forests, and the Effects of Inter-Annual Weather Variation},\n  author = {Laiho, Raija and Laine, Jukka and Trettin, Carl C. and Fin{\\\'e}r, Leena},\n  year = {2004},\n  month = jul,\n  journal = {Soil Biology and Biochemistry},\n  volume = {36},\n  number = {7},\n  pages = {1095--1109},\n  issn = {0038-0717},\n  doi = {10.1016/j.soilbio.2004.02.020}\n}'),('Lang.2009','@article{Lang.2009,\n  title = {An Experimental Comparison of Chemical Traits and Litter Decomposition Rates in a Diverse Range of Subarctic Bryophyte, Lichen and Vascular Plant Species},\n  author = {Lang, Simone I. and Cornelissen, Johannes H. C. and Klahn, Thorsten and {van Logtestijn}, Richard S. P. and Broekman, Rob and Schweikert, Wenka and Aerts, Rien},\n  year = {2009},\n  month = sep,\n  journal = {Journal of Ecology},\n  volume = {97},\n  number = {5},\n  pages = {886--900},\n  issn = {00220477, 13652745},\n  doi = {10.1111/j.1365-2745.2009.01538.x},\n  urldate = {2021-08-18},\n  langid = {english}\n}'),('Larmola.2006','@article{Larmola.2006,\n  title = {Spatial Patterns of Litter Decomposition in the Littoral Zone of Boreal Lakes},\n  author = {Larmola, Tuula and Alm, Jukka and Juutinen, Sari and Koppisch, Dorothea and Augustin, J{\\\"u}rgen and Martikainen, Pertti J. and Silvola, Jouko},\n  year = {2006},\n  month = dec,\n  journal = {Freshwater Biology},\n  volume = {51},\n  number = {12},\n  pages = {2252--2264},\n  publisher = {John Wiley \\& Sons, Ltd},\n  issn = {0046-5070},\n  doi = {10.1111/j.1365-2427.2006.01649.x},\n  urldate = {2023-01-05}\n}'),('Lavallee.2017','@misc{Lavallee.2017,\n  title = {Replication Data for: {{Effects}} of Simulated Wastewater Nutrient Amendments on {{{\\emph{Sphagnum}}}} Productivity and Decomposition within a Subarctic Ladder Fen},\n  author = {Lavallee, Amanda and Campbell, Daniel},\n  year = {2017},\n  edition = {V1},\n  publisher = {Borealis},\n  doi = {10.5683/SP/AOEXWN},\n  chapter = {2017-10-23 12:50:55.183}\n}'),('Lavallee.2019','@article{Lavallee.2019,\n  title = {Effects of Simulated Treated Domestic Wastewater on {{{\\emph{Sphagnum}}}} Productivity, Decomposition and Nutrient Dynamics in a Subarctic Ladder Fen},\n  author = {Lavallee, Amanda and Campbell, Daniel},\n  year = {2019},\n  month = feb,\n  journal = {Wetlands},\n  volume = {39},\n  number = {1},\n  pages = {29--38},\n  issn = {1943-6246},\n  doi = {10.1007/s13157-018-1058-x}\n}'),('Lepilin.2022','@article{Lepilin.2022,\n  title = {Response of Vegetation and Soil Biological Properties to Soil Deformation in Logging Trails of Drained Boreal Peatland Forests},\n  author = {Lepilin, D. and Laur{\\\'e}n, A. and Uusitalo, J. and Fritze, H. and Laiho, R. and Kimura, B. and Tuittila, E.-S.},\n  year = {2022},\n  month = apr,\n  journal = {Canadian Journal of Forest Research},\n  volume = {52},\n  number = {4},\n  pages = {511--526},\n  issn = {0045-5067, 1208-6037},\n  doi = {10.1139/cjfr-2021-0176},\n  urldate = {2023-01-13},\n  langid = {english}\n}'),('Li.2020','@article{Li.2020,\n  title = {Effects of Microtopography on Absorptive and Transport Fine Root Biomass, Necromass, Production, Mortality and Decomposition in a Coastal Freshwater Forested Wetland, Southeastern {{USA}}},\n  author = {Li, Xuefeng and Minick, Kevan J. and Luff, Jordan and Noormets, Asko and Miao, Guofang and Mitra, Bhaskar and Domec, Jean-Christophe and Sun, Ge and McNulty, Steven and King, John S.},\n  year = {2020},\n  month = sep,\n  journal = {Ecosystems},\n  volume = {23},\n  number = {6},\n  pages = {1294--1308},\n  issn = {1432-9840, 1435-0629},\n  doi = {10.1007/s10021-019-00470-x},\n  urldate = {2023-01-13},\n  langid = {english}\n}'),('Lieffers.1988','@article{Lieffers.1988,\n  title = {{\\emph{Sphagnum}} and Cellulose Decomosition in Drained and Natural Areas of an {{Alberta}} Peatland},\n  author = {Lieffers, V. J.},\n  year = {1988},\n  month = nov,\n  journal = {Canadian Journal of Soil Science},\n  volume = {68},\n  number = {4},\n  pages = {755--761},\n  issn = {0008-4271, 1918-1841},\n  doi = {10.4141/cjss88-073},\n  urldate = {2021-04-30},\n  langid = {english}\n}'),('Limpens.2003','@article{Limpens.2003,\n  title = {How Litter Quality Affects Mass Loss and {{N}} Loss from Decomposing {{{\\emph{Sphagnum}}}}},\n  author = {Limpens, Juul and Berendse, Frank},\n  year = {2003},\n  month = dec,\n  journal = {Oikos},\n  volume = {103},\n  number = {3},\n  pages = {537--547},\n  issn = {00301299},\n  doi = {10.1034/j.1600-0706.2003.12707.x},\n  urldate = {2021-04-19},\n  langid = {english}\n}'),('Makila.2018','@article{Makila.2018,\n  title = {{\\emph{Sphagnum}} Decay Patterns and Bog Microtopography in South-Eastern {{Finland}}},\n  author = {M{\\\"a}kil{\\\"a}, M. and S{\\\"a}{\\\"a}vuori, H. and Grundstr{\\\"o}m, A. and Suomi, T.},\n  year = {2018},\n  month = jul,\n  journal = {Mires and Peat},\n  number = {21},\n  pages = {1--12},\n  issn = {1819-754X},\n  doi = {10.19189/MaP.2017.OMB.283},\n  urldate = {2021-04-30},\n  langid = {english}\n}'),('Malhotra.2018','@article{Malhotra.2018,\n  title = {Post-Thaw Variability in Litter Decomposition Best Explained by Microtopography at an Ice-Rich Permafrost Peatland},\n  author = {Malhotra, Avni and Moore, Tim R. and Limpens, Juul and Roulet, Nigel T.},\n  year = {2018},\n  month = jan,\n  journal = {Arctic, Antarctic, and Alpine Research},\n  volume = {50},\n  number = {1},\n  pages = {e1415622},\n  issn = {1523-0430, 1938-4246},\n  doi = {10.1080/15230430.2017.1415622},\n  urldate = {2023-01-13},\n  langid = {english}\n}'),('Maljanen.2014','@article{Maljanen.2014,\n  title = {The Effect of Granulated Wood-Ash Fertilization on Soil Properties and Greenhouse Gas ({{GHG}}) Emissions in Boreal Peatland Forests},\n  author = {Maljanen, Marja and Liimatainen, Maarit and Hyt{\\\"o}nen, Jyrki and Martikainen, Pertti J.},\n  year = {2014},\n  journal = {Boreal Environmental Research},\n  volume = {19},\n  number = {4},\n  pages = {295--309}\n}'),('Manninen.2016','@article{Manninen.2016,\n  title = {Nitrogen Deposition Does Not Enhance {{{\\emph{Sphagnum}}}} Decomposition},\n  author = {Manninen, S. and Kivim{\\\"a}ki, S. and Leith, I.D. and Leeson, S.R. and Sheppard, L.J.},\n  year = {2016},\n  month = nov,\n  journal = {Science of The Total Environment},\n  volume = {571},\n  pages = {314--322},\n  issn = {00489697},\n  doi = {10.1016/j.scitotenv.2016.07.152},\n  urldate = {2023-01-13},\n  langid = {english}\n}'),('Mao.2020','@misc{Mao.2020,\n  title = {Data for: {{Effects}} of Litter Mixtures on Decomposition Rate and Its Temperature Sensitivity in a Boreal Peatland},\n  shorttitle = {Data For},\n  author = {Mao, Rong},\n  year = {2020},\n  publisher = {Mendeley},\n  doi = {10.17632/VR79PDTBP4.1},\n  urldate = {2023-01-13},\n  collaborator = {Finnegan, Patrick and Zhang, Xinhou and Wang, Xianwei and Tan, Wenwen},\n  copyright = {, Attribution-NonCommercial 3.0 Unported (Embargo: 2020-01-29)}\n}'),('McK.Pegman.2005','@article{McK.Pegman.2005,\n  title = {Productivity-decomposition Dynamics of {{{\\emph{Typha}}}}{\\emph{ Orientalis}} at {{Kaitoke Swamp}}, {{Great Barrier Island}}, {{New Zealand}}},\n  author = {McK. Pegman, Andrew P. and Ogden, J.},\n  year = {2005},\n  month = jan,\n  journal = {New Zealand Journal of Botany},\n  volume = {43},\n  number = {4},\n  pages = {779--789},\n  publisher = {Taylor \\& Francis},\n  issn = {0028-825X},\n  doi = {10.1080/0028825X.2005.9512990}\n}'),('McK.Pegman.2006','@article{McK.Pegman.2006,\n  title = {Productivity-decomposition Dynamics of {{{\\emph{Baumea}}}}{\\emph{ Juncea}} and {{{\\emph{Gleichenia}}}}{\\emph{ Dicarpa}} at {{Kaitoke Swamp}}, {{Great Barrier Island}}, {{New Zealand}}},\n  author = {McK. Pegman, Andrew P. and Ogden, J.},\n  year = {2006},\n  month = jan,\n  journal = {New Zealand Journal of Botany},\n  volume = {44},\n  number = {3},\n  pages = {261--271},\n  publisher = {Taylor \\& Francis},\n  issn = {0028-825X},\n  doi = {10.1080/0028825X.2006.9513023}\n}'),('Moilanen.2002','@article{Moilanen.2002,\n  title = {Effects of Wood-Ash on the Tree Growth, Vegetation and Substrate Quality of a Drained Mire: A Case Study},\n  author = {Moilanen, Mikko and Silfverberg, Klaus and Hokkanen, Timo J},\n  year = {2002},\n  month = nov,\n  journal = {Forest Ecology and Management},\n  volume = {171},\n  number = {3},\n  pages = {321--338},\n  issn = {0378-1127},\n  doi = {10.1016/S0378-1127(01)00789-7}\n}'),('Moore.2005a','@article{Moore.2005a,\n  title = {Patterns of Decomposition and Carbon, Nitrogen, and Phosphorus Dynamics of Litter in Upland Forest and Peatland Sites in Central {{Canada}}},\n  author = {Moore, T R and Trofymow, J A and Siltanen, M and Prescott, C and Group, CIDET Working},\n  year = {2005},\n  month = jan,\n  journal = {Canadian Journal of Forest Research},\n  volume = {35},\n  number = {1},\n  pages = {133--142},\n  publisher = {NRC Research Press},\n  issn = {0045-5067},\n  doi = {10.1139/x04-149},\n  urldate = {2023-01-04}\n}'),('Moore.2007','@article{Moore.2007,\n  title = {Litter Decomposition in Temperate Peatland Ecosystems: {{The}} Effect of Substrate and Site},\n  author = {Moore, Tim R. and Bubier, Jill L. and Bledzki, Leszek},\n  year = {2007},\n  month = sep,\n  journal = {Ecosystems},\n  volume = {10},\n  number = {6},\n  pages = {949--963},\n  issn = {1435-0629},\n  doi = {10.1007/s10021-007-9064-5}\n}'),('Muller.2021a','@misc{Muller.2021a,\n  title = {{{RMariaDB}}: {{Database}} Interface and \'{{MariaDB}}\' Driver},\n  author = {M{\\\"u}ller, Kirill and Ooms, Jeroen and James, David and DebRoy, Saikat and Wickham, Hadley and Horner, Jeffrey},\n  year = {2021}\n}'),('Nikonova.2018','@article{Nikonova.2018,\n  title = {Decomposition Rate of Peat-Forming Plants in the Oligotrophic Peatland at the First Stages of Destruction},\n  author = {Nikonova, L G and Golovatskaya, E A and Terechshenko, N N},\n  year = {2018},\n  month = mar,\n  journal = {IOP Conference Series: Earth and Environmental Science},\n  volume = {138},\n  pages = {012013},\n  issn = {1755-1307, 1755-1315},\n  doi = {10.1088/1755-1315/138/1/012013},\n  urldate = {2023-01-13}\n}'),('Nikonova.2019','@article{Nikonova.2019,\n  title = {Decomposition Rate of Peat-Forming Plants in Oligotrophic Bogs of the Southern {{Taiga}} Subzone of {{Western Siberia}}: {{Assessment}} of the Effect of Water Table Level and Peat Deposit Temperature},\n  shorttitle = {Decomposition {{Rate}} of {{Peat-Forming Plants}} in {{Oligotrophic Bogs}} of the {{Southern Taiga Subzone}} of {{Western Siberia}}},\n  author = {Nikonova, L. G. and Golovatskaya, E. A. and Kur\'ina, I. V. and Kurganova, I. N.},\n  year = {2019},\n  month = sep,\n  journal = {Eurasian Soil Science},\n  volume = {52},\n  number = {9},\n  pages = {1101--1111},\n  issn = {1064-2293, 1556-195X},\n  doi = {10.1134/S1064229319090060},\n  urldate = {2023-01-13},\n  langid = {english}\n}'),('Ogden.1993','@article{Ogden.1993,\n  title = {Climatic Implications of Macro- and Microfossil Assemblages from Late {{Pleistocene}} Deposits in Northern {{New Zealand}}},\n  author = {Ogden, John and Newnham, Rewi M. and Palmer, Jonathan G. and Serra, Richard G. and Mitchell, Neil D.},\n  year = {1993},\n  journal = {Quaternary Research},\n  edition = {2017/01/20},\n  volume = {39},\n  number = {1},\n  pages = {107--119},\n  publisher = {Cambridge University Press},\n  issn = {0033-5894},\n  doi = {10.1006/qres.1993.1013}\n}'),('Ohlson.1987','@article{Ohlson.1987,\n  title = {Spatial Variation in Decomposition Rate of {{{\\emph{Carex}}}}{\\emph{ Rostrata}} Leaves on a {{Swedish}} Mire},\n  author = {Ohlson, M.},\n  year = {1987},\n  month = dec,\n  journal = {The Journal of Ecology},\n  volume = {75},\n  number = {4},\n  eprint = {2260322},\n  eprinttype = {jstor},\n  pages = {1191},\n  issn = {00220477},\n  doi = {10.2307/2260322},\n  urldate = {2023-01-17}\n}'),('Ojanen.2017','@article{Ojanen.2017,\n  title = {Do Logging Residue Piles Trigger Extra Decomposition of Soil Organic Matter?},\n  author = {Ojanen, Paavo and M{\\\"a}kiranta, P{\\\"a}ivi and Penttil{\\\"a}, Timo and Minkkinen, Kari},\n  year = {2017},\n  month = dec,\n  journal = {Forest Ecology and Management},\n  volume = {405},\n  pages = {367--380},\n  issn = {03781127},\n  doi = {10.1016/j.foreco.2017.09.055},\n  urldate = {2023-01-13},\n  langid = {english}\n}'),('Orwin.2012','@article{Orwin.2012,\n  title = {Moss Species Effects on Peatland Carbon Cycling after Fire: {{Moss}} Species Effects on {{C}} Cycling after Fire},\n  shorttitle = {Moss Species Effects on Peatland Carbon Cycling after Fire},\n  author = {Orwin, Kate H. and Ostle, Nicholas J.},\n  year = {2012},\n  month = aug,\n  journal = {Functional Ecology},\n  volume = {26},\n  number = {4},\n  pages = {829--836},\n  issn = {02698463},\n  doi = {10.1111/j.1365-2435.2012.01991.x},\n  urldate = {2023-01-12},\n  langid = {english}\n}'),('Palozzi.2017','@article{Palozzi.2017,\n  title = {Pure and Mixed Litters of {{{\\emph{Sphagnum}}}} and {{{\\emph{Carex}}}} Exhibit a Home-Field Advantage in Boreal Peatlands},\n  author = {Palozzi, Julia E. and Lindo, Zo{\\\"e}},\n  year = {2017},\n  month = dec,\n  journal = {Soil Biology and Biochemistry},\n  volume = {115},\n  pages = {161--168},\n  issn = {00380717},\n  doi = {10.1016/j.soilbio.2017.08.026},\n  urldate = {2023-01-13},\n  langid = {english}\n}'),('Pearson.2017','@article{Pearson.2017,\n  title = {Decay of {{Scots}} Pine Coarse Woody Debris in Boreal Peatland Forests: {{Mass}} Loss and Nutrient Dynamics},\n  shorttitle = {Decay of {{Scots}} Pine Coarse Woody Debris in Boreal Peatland Forests},\n  author = {Pearson, Meeri and Laiho, Raija and Penttil{\\\"a}, Timo},\n  year = {2017},\n  month = oct,\n  journal = {Forest Ecology and Management},\n  volume = {401},\n  pages = {304--318},\n  issn = {03781127},\n  doi = {10.1016/j.foreco.2017.07.021},\n  urldate = {2023-01-13},\n  langid = {english}\n}'),('Peli.2016','@article{Peli.2016,\n  title = {Decomposition Rate, and Carbon and Nitrogen Dynamics of {{{\\emph{Sphagnum}}}} Litter: {{Lessons}} from a Peat Bog},\n  shorttitle = {Decomposition {{Rate}}, and {{Carbon}} and {{Nitrogen Dynamics}} of {{{\\emph{Sphagnum}}}} {{Litter}}},\n  author = {P{\\\'e}li, Evelin Ram{\\\'o}na and Nagy, J{\\\'a}nos and Cserhalmi, D{\\\'a}niel},\n  year = {2016},\n  month = jun,\n  journal = {Polish Journal of Ecology},\n  volume = {64},\n  number = {2},\n  pages = {231--240},\n  issn = {1505-2249, 2450-1395},\n  doi = {10.3161/15052249PJE2016.64.2.007},\n  urldate = {2023-01-13},\n  langid = {english}\n}'),('Peltoniemi.2012','@article{Peltoniemi.2012,\n  title = {How Water-Level Drawdown Modifies Litter-Decomposing Fungal and Actinobacterial Communities in Boreal Peatlands},\n  author = {Peltoniemi, Krista and Strakov{\\\'a}, Petra and Fritze, Hannu and Ir{\\\'a}izoz, Pablo Alvira and Pennanen, Taina and Laiho, Raija},\n  year = {2012},\n  month = aug,\n  journal = {Soil Biology and Biochemistry},\n  volume = {51},\n  pages = {20--34},\n  issn = {00380717},\n  doi = {10.1016/j.soilbio.2012.04.013},\n  urldate = {2023-01-12},\n  langid = {english}\n}'),('Piatkowski.2021','@article{Piatkowski.2021,\n  title = {Natural Selection on a Carbon Cycling Trait Drives Ecosystem Engineering by {{{\\emph{Sphagnum}}}} (Peat Moss)},\n  author = {Piatkowski, Bryan T. and Yavitt, Joseph B. and Turetsky, Merritt R. and Shaw, A. Jonathan},\n  year = {2021},\n  month = aug,\n  journal = {Proceedings of the Royal Society B: Biological Sciences},\n  volume = {288},\n  number = {1957},\n  pages = {20210609},\n  publisher = {Royal Society},\n  doi = {10.1098/rspb.2021.0609},\n  urldate = {2023-01-09}\n}'),('Piatkowski.2021a','@article{Piatkowski.2021a,\n  title = {Online Data for \"{{Natural}} Selection on a Carbon Cycling Trait Drives Ecosystem Engineering by {{{\\emph{Sphagnum}}}} (Peat Moss).\"},\n  author = {Piatkowski, Bryan and Yavitt, Joseph B. and Turetsky, Merritt and Shaw, A. Jonathan},\n  year = {2021},\n  month = aug,\n  doi = {10.6084/m9.figshare.14109725.v2}\n}'),('Pick.2018','@misc{Pick.2018,\n  title = {Reproducible, Flexible and High-Throughput Data Extraction from Primary Literature: {{The}} {{metaDigitise}} {{{\\textbf{R}}}} Package},\n  shorttitle = {Reproducible, Flexible and High-Throughput Data Extraction from Primary Literature},\n  author = {Pick, Joel L. and Nakagawa, Shinichi and Noble, Daniel W.A.},\n  year = {2018},\n  month = jan,\n  doi = {10.1101/247775},\n  urldate = {2024-05-14},\n  langid = {english}\n}'),('Prevost.1997','@article{Prevost.1997,\n  title = {Substrate Conditions in a Treed Peatland: {{Responses}} to Drainage},\n  author = {Prevost, Marcel and Belleau, Pierre and Plamondon, Andr{\\\'e} P.},\n  year = {1997},\n  month = jan,\n  journal = {{\\\'E}coscience},\n  volume = {4},\n  number = {4},\n  pages = {543--554},\n  publisher = {Taylor \\& Francis},\n  issn = {1195-6860},\n  doi = {10.1080/11956860.1997.11682434}\n}'),('RCoreTeam.2022','@manual{RCoreTeam.2022,\n  type = {Manual},\n  title = {R: {{A}} Language and Environment for Statistical Computing},\n  author = {{R Core Team}},\n  year = {2022},\n  address = {Vienna, Austria},\n  institution = {R Foundation for Statistical Computing}\n}'),('Reader.1972','@article{Reader.1972,\n  title = {The Relationship between Net Primary Production and Accumulation for a Peatland in Southeastern {{Manitoba}}},\n  author = {Reader, R. J. and Stewart, J. M.},\n  year = {1972},\n  month = nov,\n  journal = {Ecology},\n  volume = {53},\n  number = {6},\n  pages = {1024--1037},\n  issn = {00129658},\n  doi = {10.2307/1935415},\n  urldate = {2021-04-30},\n  langid = {english}\n}'),('Rochefort.1990','@article{Rochefort.1990,\n  title = {Growth, Production, and Decomposition Dynamics of {{{\\emph{Sphagnum}}}} under Natural and Experimentally Acidified Conditions},\n  author = {Rochefort, Line and Vitt, Dale H. and Bayley, Suzanne E.},\n  year = {1990},\n  month = oct,\n  journal = {Ecology},\n  volume = {71},\n  number = {5},\n  pages = {1986--2000},\n  issn = {00129658},\n  doi = {10.2307/1937607},\n  urldate = {2021-04-30},\n  langid = {english}\n}'),('Rosswall.1975','@incollection{Rosswall.1975,\n  title = {Plant Litter Decomposition at {{Fennoscandian}} Tundra Sites},\n  booktitle = {Fennoscandian {{Tundra Ecosystems}}},\n  author = {Rosswall, T. and Veum, A. K. and K{\\\"a}renlampi, L.},\n  editor = {Billings, W. D. and Golley, F. and Lange, O. L. and Olson, J. S. and Wielgolaski, F. E.},\n  year = {1975},\n  volume = {16},\n  pages = {268--278},\n  publisher = {Springer Berlin Heidelberg},\n  address = {Berlin, Heidelberg},\n  doi = {10.1007/978-3-642-80937-8_31},\n  urldate = {2023-01-17},\n  isbn = {978-3-642-80939-2 978-3-642-80937-8}\n}'),('Sanger.1994','@article{Sanger.1994,\n  title = {The Effects of Acidity on Carbon Fluxes from Ombrotrophic Peat},\n  author = {Sanger, L. J. and Billett, M. F. and Cresser, M. S.},\n  year = {1994},\n  month = jan,\n  journal = {Chemistry and Ecology},\n  volume = {8},\n  number = {4},\n  pages = {249--264},\n  publisher = {Taylor \\& Francis},\n  issn = {0275-7540},\n  doi = {10.1080/02757549408038552}\n}'),('Scheffer.2000','@article{Scheffer.2000,\n  title = {Root Decomposition and Soil Nutrient and Carbon Cycling in Two Temperate Fen Ecosystems},\n  author = {Scheffer, Robbert A. and Aerts, Rien},\n  year = {2000},\n  month = dec,\n  journal = {Oikos},\n  volume = {91},\n  number = {3},\n  pages = {541--549},\n  publisher = {John Wiley \\& Sons, Ltd},\n  issn = {0030-1299},\n  doi = {10.1034/j.1600-0706.2000.910316.x},\n  urldate = {2023-01-02}\n}'),('Scheffer.2001','@article{Scheffer.2001,\n  title = {Decomposition of {{{\\emph{Carex}}}} and {{{\\emph{Sphagnum}}}} Litter in Two Mesotrophic Fens Differing in Dominant Plant Species},\n  author = {Scheffer, R. A. and Van Logtestijn, R. S. P and Verhoeven, J. T. A.},\n  year = {2001},\n  month = jan,\n  journal = {Oikos},\n  volume = {92},\n  number = {1},\n  pages = {44--54},\n  issn = {00301299},\n  doi = {10.1034/j.1600-0706.2001.920106.x},\n  urldate = {2021-04-27},\n  langid = {english}\n}'),('Schieferdecker.2022','@misc{Schieferdecker.2022,\n  title = {{{dm}}: {{Relational}} Data Models},\n  author = {Schieferdecker, Tobias and M{\\\"u}ller, Kirill and Bergant, Darko},\n  year = {2022}\n}'),('Schwieger.2021','@article{Schwieger.2021,\n  title = {Wetter Is Better: {{Rewetting}} of Minerotrophic Peatlands Increases Plant Production and Moves Them towards Carbon Sinks in a Dry Year},\n  shorttitle = {Wetter Is {{Better}}},\n  author = {Schwieger, Sarah and Kreyling, Juergen and Couwenberg, John and Smiljani{\\\'c}, Marko and Weigel, Robert and Wilmking, Martin and {Blume-Werry}, Gesche},\n  year = {2021},\n  month = aug,\n  journal = {Ecosystems},\n  volume = {24},\n  number = {5},\n  pages = {1093--1109},\n  issn = {1432-9840, 1435-0629},\n  doi = {10.1007/s10021-020-00570-z},\n  urldate = {2023-01-13},\n  langid = {english}\n}'),('Siegenthaler.2010','@article{Siegenthaler.2010,\n  title = {Litter- and Ecosystem-Driven Decomposition under Elevated {{CO}}{\\textsubscript{2}} and Enhanced {{N}} Deposition in a {{{\\emph{Sphagnum}}}} Peatland},\n  author = {Siegenthaler, Andy and Buttler, Alexandre and Bragazza, Luca and van der Heijden, Edwin and Grosvernier, Philippe and Gobat, Jean-Michel and Mitchell, Edward A.D.},\n  year = {2010},\n  month = jun,\n  journal = {Soil Biology and Biochemistry},\n  volume = {42},\n  number = {6},\n  pages = {968--977},\n  issn = {00380717},\n  doi = {10.1016/j.soilbio.2010.02.016},\n  urldate = {2023-01-11},\n  langid = {english}\n}'),('Slapokas.1991','@article{Slapokas.1991,\n  title = {Decomposition of Litter in Fertilized Short-Rotation Forests on a Low-Humified Peat Bog},\n  author = {{\\v S}lapokas, Tommy and Granhall, Ulf},\n  year = {1991},\n  month = jun,\n  journal = {Forest Ecology and Management},\n  volume = {41},\n  number = {1},\n  pages = {143--165},\n  issn = {0378-1127},\n  doi = {10.1016/0378-1127(91)90125-F}\n}'),('Smith.1986','@article{Smith.1986,\n  title = {Decomposition of Grass and Moss Litter in Subantarctic Tundra},\n  author = {Smith, {\\relax MJ} and Walton, DW H},\n  year = {1986},\n  journal = {Pedobiologia (Jena)},\n  volume = {29},\n  number = {3},\n  pages = {193--200}\n}'),('Stackpoole.2008','@article{Stackpoole.2008,\n  title = {Nitrogen Conservation Strategies of Cranberry Plants and Ericoid Mycorrhizal Fungi in an Agroecosystem},\n  author = {Stackpoole, Sarah M. and Workmaster, Beth Ann A. and Jackson, Randall D. and Kosola, Kevin R.},\n  year = {2008},\n  month = nov,\n  journal = {Soil Biology and Biochemistry},\n  volume = {40},\n  number = {11},\n  pages = {2736--2742},\n  issn = {0038-0717},\n  doi = {10.1016/j.soilbio.2008.07.017}\n}'),('Strakova.2010','@article{Strakova.2010,\n  title = {Litter Quality and Its Response to Water Level Drawdown in Boreal Peatlands at Plant Species and Community Level},\n  author = {Strakov{\\\'a}, Petra and Anttila, Jani and Spetz, Peter and Kitunen, Veikko and Tapanila, Tarja and Laiho, Raija},\n  year = {2010},\n  month = oct,\n  journal = {Plant and Soil},\n  volume = {335},\n  number = {1-2},\n  pages = {501--520},\n  issn = {0032-079X, 1573-5036},\n  doi = {10.1007/s11104-010-0447-6},\n  urldate = {2021-06-02},\n  langid = {english}\n}'),('Strakova.2012','@article{Strakova.2012,\n  title = {Disentangling Direct and Indirect Effects of Water Table Drawdown on Above- and Belowground Plant Litter Decomposition: Consequences for Accumulation of Organic Matter in Boreal Peatlands},\n  shorttitle = {Disentangling Direct and Indirect Effects of Water Table Drawdown on Above- and Belowground Plant Litter Decomposition},\n  author = {Strakov{\\\'a}, Petra and Penttil{\\\"a}, Timo and Laine, Jukka and Laiho, Raija},\n  year = {2012},\n  month = jan,\n  journal = {Global Change Biology},\n  volume = {18},\n  number = {1},\n  pages = {322--335},\n  issn = {13541013},\n  doi = {10.1111/j.1365-2486.2011.02503.x},\n  urldate = {2023-01-11},\n  langid = {english}\n}'),('Szumigalski.1996','@article{Szumigalski.1996,\n  title = {Decomposition along a Bog to Rich Fen Gradient in Central {{Alberta}}, {{Canada}}},\n  author = {Szumigalski, Anthony R. and Bayley, Suzanne E.},\n  year = {1996},\n  month = apr,\n  journal = {Canadian Journal of Botany},\n  volume = {74},\n  number = {4},\n  pages = {573--581},\n  issn = {0008-4026},\n  doi = {10.1139/b96-073},\n  urldate = {2023-01-01},\n  langid = {english}\n}'),('Tarvainen.2013','@article{Tarvainen.2013,\n  title = {Mineralization and Decomposition Rates in Restored Pine Fens},\n  shorttitle = {Mineralization and {{Decomposition Rates}} in {{Restored Pine Fens}}},\n  author = {Tarvainen, Oili and Laine, Anna M. and Peltonen, Mari and Tolvanen, Anne},\n  year = {2013},\n  month = sep,\n  journal = {Restoration Ecology},\n  volume = {21},\n  number = {5},\n  pages = {592--599},\n  issn = {10612971},\n  doi = {10.1111/j.1526-100X.2012.00930.x},\n  urldate = {2023-01-13},\n  langid = {english}\n}'),('Teickner.2024','@misc{Teickner.2024,\n  title = {A Synthesis of {{{\\emph{Sphagnum}}}} Litterbag Experiments: {{Initial}} Leaching Losses Bias Decomposition Rate Estimates},\n  author = {Teickner, Henning and Pebesma, Edzer and Knorr, Klaus-Holger},\n  year = {2024}\n}'),('Teickner.2024a','@misc{Teickner.2024a,\n  title = {Underestimation of Anaerobic Decomposition Rates in {{{\\emph{Sphagnum}}}} Litterbag Experiments by the {{Holocene Peatland Model}} Depends on Initial Leaching Losses},\n  author = {Teickner, Henning and Pebesma, Edzer and Knorr, Klaus-Holger},\n  year = {2024}\n}'),('Teickner.2024b','@misc{Teickner.2024b,\n  title = {{{hpmdpredict}}: {{Predictions}} with Model {{HPMe-LE-peat-l0}} from {{Teickner}} et al. (2024)},\n  author = {Teickner, Henning and Knorr, Klaus-Holger},\n  year = {2024}\n}'),('Teickner.2024c','@misc{Teickner.2024c,\n  title = {Peatland {{Decomposition Database}} (1.0.0)},\n  author = {Teickner, Henning and Knorr, Klaus-Holger},\n  year = {2024},\n  month = may,\n  publisher = {Zenodo},\n  doi = {10.5281/ZENODO.11276065},\n  urldate = {2024-05-24},\n  copyright = {Creative Commons Attribution 4.0 International},\n  langid = {english}\n}'),('Teickner.2024d','@misc{Teickner.2024d,\n  title = {{{dpeatdecomposition}}: {{R Interface}} to the {{Peatland Decomposition Database}}},\n  author = {Teickner, Henning and Knorr, Klaus-Holger},\n  year = {2024},\n  month = may\n}'),('Thormann.1999','@article{Thormann.1999,\n  title = {Aboveground Peat and Carbon Accumulation Potentials along a Bog-Fen-Marsh Wetland Gradient in Southern Boreal {{Alberta}}, {{Canada}}},\n  author = {Thormann, Markus N. and Szumigalski, Anthony R. and Bayley, Suzanne E.},\n  year = {1999},\n  month = jun,\n  journal = {Wetlands},\n  volume = {19},\n  number = {2},\n  pages = {305--317},\n  issn = {1943-6246},\n  doi = {10.1007/BF03161761}\n}'),('Thormann.1999a','@article{Thormann.1999a,\n  title = {The Mycorrhizal Status of the Dominant Vegetation along a Peatland Gradient in Southern Boreal {{Alberta}}, {{Canada}}},\n  author = {Thormann, Markus N. and Currah, Randolph S. and Bayley, Suzanne E.},\n  year = {1999},\n  month = jun,\n  journal = {Wetlands},\n  volume = {19},\n  number = {2},\n  pages = {438--450},\n  issn = {1943-6246},\n  doi = {10.1007/BF03161775}\n}'),('Thormann.2001','@article{Thormann.2001,\n  title = {Comparison of Decomposition of Belowground and Aboveground Plant Litters in Peatlands of Boreal {{Alberta}}, {{Canada}}},\n  author = {Thormann, Markus N and Bayley, Suzanne E and Currah, Randolph S},\n  year = {2001},\n  month = jan,\n  journal = {Canadian Journal of Botany},\n  volume = {79},\n  number = {1},\n  pages = {9--22},\n  publisher = {NRC Research Press},\n  issn = {0008-4026},\n  doi = {10.1139/b00-138},\n  urldate = {2023-01-04}\n}'),('Thormann.2002','@article{Thormann.2002,\n  title = {The Relative Ability of Fungi from {{{\\emph{Sphagnum}}}}{\\emph{ Fuscum}} to Decompose Selected Carbon Substrates},\n  author = {Thormann, Markus N and Currah, Randolph S and Bayley, Suzanne E},\n  year = {2002},\n  month = mar,\n  journal = {Canadian Journal of Microbiology},\n  volume = {48},\n  number = {3},\n  pages = {204--211},\n  publisher = {NRC Research Press},\n  issn = {0008-4166},\n  doi = {10.1139/w02-010},\n  urldate = {2023-01-03}\n}'),('Thormann.2004','@article{Thormann.2004,\n  title = {Microcosm Tests of the Effects of Temperature and Microbial Species Number on the Decomposition of {{{\\emph{Carex}}}}{\\emph{ Aquatilis}} and {{{\\emph{Sphagnum}}}}{\\emph{ Fuscum}} Litter from Southern Boreal Peatlands},\n  author = {Thormann, Markus N and Bayley, Suzanne E and Currah, Randolph S},\n  year = {2004},\n  month = oct,\n  journal = {Canadian Journal of Microbiology},\n  volume = {50},\n  number = {10},\n  pages = {793--802},\n  issn = {0008-4166, 1480-3275},\n  doi = {10.1139/w04-064},\n  urldate = {2021-04-22},\n  langid = {english}\n}'),('Tolvanen.2020','@article{Tolvanen.2020,\n  title = {Soil and Water Nutrients in Stem-only and Whole-tree Harvest Treatments in Restored Boreal Peatlands},\n  author = {Tolvanen, Anne and Tarvainen, Oili and Laine, Anna M.},\n  year = {2020},\n  month = nov,\n  journal = {Restoration Ecology},\n  volume = {28},\n  number = {6},\n  pages = {1357--1364},\n  issn = {1061-2971, 1526-100X},\n  doi = {10.1111/rec.13261},\n  urldate = {2023-01-13},\n  langid = {english}\n}'),('Trinder.2008','@article{Trinder.2008,\n  title = {Interactions among Fungal Community Structure, Litter Decomposition and Depth of Water Table in a Cutover Peatland},\n  author = {Trinder, Clare J. and Johnson, David and Artz, Rebekka R.E.},\n  year = {2008},\n  month = jun,\n  journal = {FEMS Microbiology Ecology},\n  volume = {64},\n  number = {3},\n  pages = {433--448},\n  issn = {0168-6496},\n  doi = {10.1111/j.1574-6941.2008.00487.x},\n  urldate = {2023-01-06}\n}'),('Trinder.2008a','@article{Trinder.2008a,\n  title = {Temporal Patterns of Litter Production by Vascular Plants and Its Decomposition Rate in Cut-over Peatlands},\n  author = {Trinder, Clare J. and Artz, Rebekka R. E. and Johnson, David},\n  year = {2008},\n  month = mar,\n  journal = {Wetlands},\n  volume = {28},\n  number = {1},\n  pages = {245--250},\n  issn = {1943-6246},\n  doi = {10.1672/07-126.1}\n}'),('Trinder.2009','@article{Trinder.2009,\n  title = {Litter Type, but Not Plant Cover, Regulates Initial Litter Decomposition and Fungal Community Structure in a Recolonising Cutover Peatland},\n  author = {Trinder, Clare J. and Johnson, David and Artz, Rebekka R.E.},\n  year = {2009},\n  month = mar,\n  journal = {Soil Biology and Biochemistry},\n  volume = {41},\n  number = {3},\n  pages = {651--655},\n  issn = {0038-0717},\n  doi = {10.1016/j.soilbio.2008.12.006}\n}'),('Trites.2009','@article{Trites.2009,\n  title = {Organic Matter Accumulation in Western Boreal Saline Wetlands: {{A}} Comparison of Undisturbed and Oil Sands Wetlands},\n  shorttitle = {Organic Matter Accumulation in Western Boreal Saline Wetlands},\n  author = {Trites, Marsha and Bayley, Suzanne E.},\n  year = {2009},\n  month = dec,\n  journal = {Ecological Engineering},\n  volume = {35},\n  number = {12},\n  pages = {1734--1742},\n  issn = {09258574},\n  doi = {10.1016/j.ecoleng.2009.07.011},\n  urldate = {2023-01-10},\n  langid = {english}\n}'),('Turetsky.2008','@article{Turetsky.2008,\n  title = {Trade-Offs in Resource Allocation among Moss Species Control Decomposition in Boreal Peatlands},\n  author = {Turetsky, Merritt R. and Crow, Susan E. and Evans, Robert J. and Vitt, Dale H. and Wieder, R. Kelman},\n  year = {2008},\n  month = nov,\n  journal = {Journal of Ecology},\n  volume = {96},\n  number = {6},\n  pages = {1297--1305},\n  issn = {00220477, 13652745},\n  doi = {10.1111/j.1365-2745.2008.01438.x},\n  urldate = {2021-06-02},\n  langid = {english}\n}'),('Verhoeven.1992','@article{Verhoeven.1992,\n  title = {{\\emph{Carex}} Litter Decomposition and Nutrient Release in Mires with Different Water Chemistry},\n  author = {Verhoeven, J.T.A. and Arts, H.H.M.},\n  year = {1992},\n  month = nov,\n  journal = {Aquatic Botany},\n  volume = {43},\n  number = {4},\n  pages = {365--377},\n  issn = {03043770},\n  doi = {10.1016/0304-3770(92)90048-N},\n  urldate = {2021-04-30},\n  langid = {english}\n}'),('Vitt.1990','@article{Vitt.1990,\n  title = {Growth and Production Dynamics of Boreal Mosses over Climatic, Chemical and Topographic Gradients},\n  author = {Vitt, Dale H.},\n  year = {1990},\n  month = sep,\n  journal = {Botanical Journal of the Linnean Society},\n  volume = {104},\n  number = {1-3},\n  pages = {35--59},\n  issn = {0024-4074},\n  doi = {10.1111/j.1095-8339.1990.tb02210.x},\n  urldate = {2022-12-20}\n}'),('Vitt.2009','@article{Vitt.2009,\n  title = {Decomposition and Peat Accumulation in Rich Fens of Boreal {{Alberta}}, {{Canada}}},\n  author = {Vitt, Dale H. and Wieder, R. Kelman and Scott, Kimberli D. and Faller, Susan},\n  year = {2009},\n  month = apr,\n  journal = {Ecosystems},\n  volume = {12},\n  number = {3},\n  pages = {360--373},\n  issn = {1435-0629},\n  doi = {10.1007/s10021-009-9228-6}\n}'),('Waddington.2003','@article{Waddington.2003,\n  title = {{\\emph{Sphagnum}} Production and Decomposition in a Restored Cutover Peatland},\n  author = {Waddington, J.M. and Rochefort, L. and Campeau, S.},\n  year = {2003},\n  month = feb,\n  journal = {Wetlands Ecology and Management},\n  volume = {11},\n  number = {1},\n  pages = {85--95},\n  issn = {1572-9834},\n  doi = {10.1023/A:1022009621693}\n}'),('Ward.2015','@article{Ward.2015,\n  title = {Vegetation Exerts a Greater Control on Litter Decomposition than Climate Warming in Peatlands},\n  author = {Ward, Susan E. and Orwin, Kate H. and Ostle, Nicholas J. and Briones, Maria J. I. and Thomson, Bruce C. and Griffiths, Robert I. and Oakley, Simon and Quirk, Helen and Bardgett, Richard D.},\n  year = {2015},\n  month = jan,\n  journal = {Ecology},\n  volume = {96},\n  number = {1},\n  pages = {113--123},\n  issn = {0012-9658, 1939-9170},\n  doi = {10.1890/14-0292.1},\n  urldate = {2023-01-13},\n  langid = {english}\n}'),('Ward.2016','@article{Ward.2016,\n  title = {Vegetation Exerts a Greater Control on Litter Decomposition than Climate Warming in Peatlands},\n  author = {Ward, Susan E. and Orwin, Kate H. and Ostle, Nicholas J. and Briones, Maria J. I. and Thomson, Bruce C. and Griffiths, Robert I. and Oakley, Simon and Quirk, Helen and Bardgett, Richard D.},\n  year = {2016},\n  publisher = {Figshare},\n  doi = {10.6084/M9.FIGSHARE.C.3307338.V1},\n  urldate = {2023-01-13},\n  copyright = {CC-BY}\n}'),('Yavitt.2019','@article{Yavitt.2019,\n  title = {Inferring Methane Production by Decomposing Tree, Shrub, and Grass Leaf Litter in Bog and Rich Fen Peatlands},\n  author = {Yavitt, Joseph B. and Kryczka, Anna K. and Huber, Molly E. and Pipes, Gwendolyn T. and Rodriguez, Alex M.},\n  year = {2019},\n  month = nov,\n  journal = {Frontiers in Environmental Science},\n  volume = {7},\n  pages = {182},\n  issn = {2296-665X},\n  doi = {10.3389/fenvs.2019.00182},\n  urldate = {2023-01-13}\n}'),('Zhang.2019','@article{Zhang.2019,\n  title = {Effects of Litter Mixtures on Aerobic Decomposition Rate and Its Temperature Sensitivity in a Boreal Peatland},\n  author = {Zhang, Xinhou and Wang, Xianwei and Finnegan, Patrick M. and Tan, Wenwen and Mao, Rong},\n  year = {2019},\n  month = nov,\n  journal = {Geoderma},\n  volume = {354},\n  pages = {113890},\n  issn = {00167061},\n  doi = {10.1016/j.geoderma.2019.113890},\n  urldate = {2023-01-13},\n  langid = {english}\n}'),('Zhang.2022b','@article{Zhang.2022b,\n  title = {Dominant Species and Evenness Level Co-Regulate Litter Mixture Decomposition in a Boreal Peatland},\n  author = {Zhang, Xinhou and Zhang, Yuanhang and Jiang, Shuangshuang and Song, Changchun and Zhang, Jinbo and Mao, Rong},\n  year = {2022},\n  month = may,\n  journal = {Plant and Soil},\n  volume = {474},\n  number = {1-2},\n  pages = {423--436},\n  issn = {0032-079X, 1573-5036},\n  doi = {10.1007/s11104-022-05346-z},\n  urldate = {2023-01-13},\n  langid = {english}\n}');
/*!40000 ALTER TABLE `citations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `citations_to_datasets`
--

DROP TABLE IF EXISTS `citations_to_datasets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `citations_to_datasets` (
  `id_dataset` int(11) NOT NULL,
  `id_citation` varchar(255) NOT NULL,
  KEY `fk_citations_to_datasets_ref_datasets` (`id_dataset`),
  KEY `fk_citations_to_datasets_ref_citations` (`id_citation`),
  CONSTRAINT `fk_citations_to_datasets_ref_citations` FOREIGN KEY (`id_citation`) REFERENCES `citations` (`id_citation`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_citations_to_datasets_ref_datasets` FOREIGN KEY (`id_dataset`) REFERENCES `datasets` (`id_dataset`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `citations_to_datasets`
--

LOCK TABLES `citations_to_datasets` WRITE;
/*!40000 ALTER TABLE `citations_to_datasets` DISABLE KEYS */;
INSERT INTO `citations_to_datasets` VALUES (1,'Farrish.1985'),(2,'Bartsch.1985'),(3,'Farrish.1988'),(4,'Vitt.1990'),(5,'Hogg.1992'),(6,'Sanger.1994'),(7,'Hiroki.1996'),(8,'Szumigalski.1996'),(9,'Prevost.1997'),(10,'Arp.1999'),(11,'Scheffer.2000'),(12,'Scheffer.2001'),(13,'Limpens.2003'),(14,'Waddington.2003'),(15,'Asada.2004'),(16,'Thormann.2001'),(17,'Trinder.2008'),(18,'Breeuwer.2008'),(19,'Trinder.2009'),(20,'Bragazza.2009'),(21,'Hoorens.2010'),(22,'Strakova.2010'),(22,'Strakova.2012'),(23,'Orwin.2012'),(24,'Lieffers.1988'),(25,'Manninen.2016'),(26,'Johnson.1991'),(27,'Bengtsson.2018a'),(27,'Bengtsson.2018'),(28,'Asada.2005b'),(29,'Bengtsson.2017'),(29,'Bengtsson.2016'),(30,'Hagemann.2015'),(30,'Hagemann.2016'),(31,'Piatkowski.2021a'),(31,'Piatkowski.2021'),(32,'Makila.2018'),(33,'Golovatskaya.2017'),(34,'Golovatskaya.2017');
/*!40000 ALTER TABLE `citations_to_datasets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `custom_units`
--

DROP TABLE IF EXISTS `custom_units`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `custom_units` (
  `id_unit` varchar(300) NOT NULL,
  `unit_type` varchar(300) NOT NULL,
  `parent_si` tinytext DEFAULT NULL,
  `multiplier_to_si` double DEFAULT NULL,
  `abbreviation` tinytext DEFAULT NULL,
  `description` tinytext NOT NULL,
  PRIMARY KEY (`id_unit`),
  CONSTRAINT `fk_custom_units_ref_units` FOREIGN KEY (`id_unit`) REFERENCES `units` (`id_unit`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `custom_units`
--

LOCK TABLES `custom_units` WRITE;
/*!40000 ALTER TABLE `custom_units` DISABLE KEYS */;
/*!40000 ALTER TABLE `custom_units` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `data`
--

DROP TABLE IF EXISTS `data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `data` (
  `id_measurement` int(11) NOT NULL,
  `id_sample` int(11) NOT NULL,
  `attribute_name` varchar(255) NOT NULL,
  `id_measurement_numerator` int(11) DEFAULT NULL,
  `id_measurement_denominator` int(11) DEFAULT NULL,
  `value_type` tinytext DEFAULT NULL,
  `error_type` tinytext DEFAULT NULL,
  `sample_size` int(11) DEFAULT NULL,
  `value` double DEFAULT NULL,
  `error` double DEFAULT NULL,
  `comments_measurement` mediumtext DEFAULT NULL,
  PRIMARY KEY (`id_measurement`),
  KEY `fk_data_ref_samples` (`id_sample`),
  KEY `fk_data_ref_attributes` (`attribute_name`),
  CONSTRAINT `fk_data_ref_attributes` FOREIGN KEY (`attribute_name`) REFERENCES `attributes` (`attribute_name`) ON UPDATE CASCADE,
  CONSTRAINT `fk_data_ref_samples` FOREIGN KEY (`id_sample`) REFERENCES `samples` (`id_sample`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `data`
--

LOCK TABLES `data` WRITE;
/*!40000 ALTER TABLE `data` DISABLE KEYS */;
INSERT INTO `data` VALUES (1,5,'mass_absolute',NULL,NULL,'mean','sd',10,NULL,NULL,NULL),(2,6,'mass_absolute',NULL,NULL,'mean','sd',10,NULL,NULL,NULL),(3,7,'mass_absolute',NULL,NULL,'mean','sd',5,NULL,NULL,NULL),(4,8,'mass_absolute',NULL,NULL,'mean','sd',5,NULL,NULL,NULL),(5,5,'mass_relative_mass',1,1,'mean','sd',10,1,0,NULL),(6,6,'mass_relative_mass',2,2,'mean','sd',10,1,0,NULL),(7,7,'mass_relative_mass',3,3,'mean','sd',5,1,0,NULL),(8,8,'mass_relative_mass',4,4,'mean','sd',5,1,0,NULL),(9,9,'mass_absolute',NULL,NULL,'mean','sd',10,NULL,NULL,NULL),(10,10,'mass_absolute',NULL,NULL,'mean','sd',10,NULL,NULL,NULL),(11,11,'mass_absolute',NULL,NULL,'mean','sd',5,NULL,NULL,NULL),(12,12,'mass_absolute',NULL,NULL,'mean','sd',5,NULL,NULL,NULL),(13,9,'mass_relative_mass',9,1,'mean','sd',10,0.903,NULL,NULL),(14,10,'mass_relative_mass',10,2,'mean','sd',10,0.948,NULL,NULL),(15,11,'mass_relative_mass',11,3,'mean','sd',5,0.599,NULL,NULL),(16,12,'mass_relative_mass',12,4,'mean','sd',5,0.871,NULL,NULL),(17,13,'water_table_depth',NULL,NULL,'mean',NULL,NULL,19.453058042706317,NULL,'Data extracted from plot.'),(18,14,'water_table_depth',NULL,NULL,'mean',NULL,NULL,17.284115559276927,NULL,'Data extracted from plot.'),(19,15,'water_table_depth',NULL,NULL,'mean',NULL,NULL,16.199644317562246,NULL,'Data extracted from plot.'),(20,16,'water_table_depth',NULL,NULL,'mean',NULL,NULL,19.453058042706317,NULL,'Data extracted from plot.'),(21,17,'water_table_depth',NULL,NULL,'mean',NULL,NULL,19.814548456611192,NULL,'Data extracted from plot.'),(22,18,'water_table_depth',NULL,NULL,'mean',NULL,NULL,22.70647176785033,NULL,'Data extracted from plot.'),(23,19,'water_table_depth',NULL,NULL,'mean',NULL,NULL,22.34498135394543,NULL,'Data extracted from plot.'),(24,20,'water_table_depth',NULL,NULL,'mean',NULL,NULL,28.128827976423793,NULL,'Data extracted from plot.'),(25,21,'water_table_depth',NULL,NULL,'mean',NULL,NULL,13.669211420227981,NULL,'Data extracted from plot.'),(26,22,'water_table_depth',NULL,NULL,'mean',NULL,NULL,30.297770459853155,NULL,'Data extracted from plot.'),(27,23,'water_table_depth',NULL,NULL,'mean',NULL,NULL,16.922625145372024,NULL,'Data extracted from plot.'),(28,24,'water_table_depth',NULL,NULL,'mean',NULL,NULL,8.24685521165452,NULL,'Data extracted from plot.'),(29,25,'water_table_depth',NULL,NULL,'mean',NULL,NULL,54.45305804270632,NULL,'Data extracted from plot for hollows. The text says that hummocks were, on average, 35 cm higher than hollows. This distance was added to the water table depth values extracted for hollows.'),(30,26,'water_table_depth',NULL,NULL,'mean',NULL,NULL,52.28411555927693,NULL,'Data extracted from plot for hollows. The text says that hummocks were, on average, 35 cm higher than hollows. This distance was added to the water table depth values extracted for hollows.'),(31,27,'water_table_depth',NULL,NULL,'mean',NULL,NULL,51.199644317562246,NULL,'Data extracted from plot for hollows. The text says that hummocks were, on average, 35 cm higher than hollows. This distance was added to the water table depth values extracted for hollows.'),(32,28,'water_table_depth',NULL,NULL,'mean',NULL,NULL,54.45305804270632,NULL,'Data extracted from plot for hollows. The text says that hummocks were, on average, 35 cm higher than hollows. This distance was added to the water table depth values extracted for hollows.'),(33,29,'water_table_depth',NULL,NULL,'mean',NULL,NULL,54.81454845661119,NULL,'Data extracted from plot for hollows. The text says that hummocks were, on average, 35 cm higher than hollows. This distance was added to the water table depth values extracted for hollows.'),(34,30,'water_table_depth',NULL,NULL,'mean',NULL,NULL,57.70647176785033,NULL,'Data extracted from plot for hollows. The text says that hummocks were, on average, 35 cm higher than hollows. This distance was added to the water table depth values extracted for hollows.'),(35,31,'water_table_depth',NULL,NULL,'mean',NULL,NULL,57.34498135394543,NULL,'Data extracted from plot for hollows. The text says that hummocks were, on average, 35 cm higher than hollows. This distance was added to the water table depth values extracted for hollows.'),(36,32,'water_table_depth',NULL,NULL,'mean',NULL,NULL,63.12882797642379,NULL,'Data extracted from plot for hollows. The text says that hummocks were, on average, 35 cm higher than hollows. This distance was added to the water table depth values extracted for hollows.'),(37,33,'water_table_depth',NULL,NULL,'mean',NULL,NULL,48.66921142022798,NULL,'Data extracted from plot for hollows. The text says that hummocks were, on average, 35 cm higher than hollows. This distance was added to the water table depth values extracted for hollows.'),(38,34,'water_table_depth',NULL,NULL,'mean',NULL,NULL,65.29777045985315,NULL,'Data extracted from plot for hollows. The text says that hummocks were, on average, 35 cm higher than hollows. This distance was added to the water table depth values extracted for hollows.'),(39,35,'water_table_depth',NULL,NULL,'mean',NULL,NULL,51.922625145372024,NULL,'Data extracted from plot for hollows. The text says that hummocks were, on average, 35 cm higher than hollows. This distance was added to the water table depth values extracted for hollows.'),(40,36,'water_table_depth',NULL,NULL,'mean',NULL,NULL,43.24685521165452,NULL,'Data extracted from plot for hollows. The text says that hummocks were, on average, 35 cm higher than hollows. This distance was added to the water table depth values extracted for hollows.'),(41,37,'temperature',NULL,NULL,'mean',NULL,NULL,283.7424170616114,NULL,'Data extracted from plot.'),(42,38,'temperature',NULL,NULL,'mean',NULL,NULL,288.15,NULL,'Data extracted from plot.'),(43,39,'temperature',NULL,NULL,'mean',NULL,NULL,288.36327014218006,NULL,'Data extracted from plot.'),(44,40,'temperature',NULL,NULL,'mean',NULL,NULL,286.8703791469194,NULL,'Data extracted from plot.'),(45,41,'temperature',NULL,NULL,'mean',NULL,NULL,286.9414691943128,NULL,'Data extracted from plot.'),(46,42,'temperature',NULL,NULL,'mean',NULL,NULL,283.8135071090047,NULL,'Data extracted from plot.'),(47,43,'temperature',NULL,NULL,'mean',NULL,NULL,275.92251184834123,NULL,'Data extracted from plot.'),(48,44,'temperature',NULL,NULL,'mean',NULL,NULL,273.7187203791469,NULL,'Data extracted from plot.'),(49,45,'temperature',NULL,NULL,'mean',NULL,NULL,273.5765402843602,NULL,'Data extracted from plot.'),(50,46,'temperature',NULL,NULL,'mean',NULL,NULL,277.3443127962085,NULL,'Data extracted from plot.'),(51,47,'temperature',NULL,NULL,'mean',NULL,NULL,287.72345971563976,NULL,'Data extracted from plot.'),(52,48,'temperature',NULL,NULL,'mean',NULL,NULL,292.1310426540284,NULL,'Data extracted from plot.'),(53,49,'temperature',NULL,NULL,'mean',NULL,NULL,285.0931279620853,NULL,'Data extracted from plot.'),(54,50,'temperature',NULL,NULL,'mean',NULL,NULL,292.1310426540284,NULL,'Data extracted from plot.'),(55,51,'temperature',NULL,NULL,'mean',NULL,NULL,288.78981042654027,NULL,'Data extracted from plot.'),(56,52,'temperature',NULL,NULL,'mean',NULL,NULL,287.2258293838862,NULL,'Data extracted from plot.'),(57,53,'temperature',NULL,NULL,'mean',NULL,NULL,287.15473933649287,NULL,'Data extracted from plot.'),(58,54,'temperature',NULL,NULL,'mean',NULL,NULL,283.2447867298578,NULL,'Data extracted from plot.'),(59,55,'temperature',NULL,NULL,'mean',NULL,NULL,275.3537914691943,NULL,'Data extracted from plot.'),(60,56,'temperature',NULL,NULL,'mean',NULL,NULL,273.5054502369668,NULL,'Data extracted from plot.'),(61,57,'temperature',NULL,NULL,'mean',NULL,NULL,273.8609004739336,NULL,'Data extracted from plot.'),(62,58,'temperature',NULL,NULL,'mean',NULL,NULL,277.7708530805687,NULL,'Data extracted from plot.'),(63,59,'temperature',NULL,NULL,'mean',NULL,NULL,290.3537914691943,NULL,'Data extracted from plot.'),(64,60,'temperature',NULL,NULL,'mean',NULL,NULL,293.19739336492887,NULL,'Data extracted from plot.'),(65,61,'mass_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(66,61,'mass_relative_mass',65,65,'mean',NULL,3,1,NULL,NULL),(67,61,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(68,61,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,'Approximate position of the water table depth at the time samples were inserted into the peat to start the decomposition experiment.'),(69,61,'P_relative_mass',74,65,'point',NULL,NULL,NULL,NULL,NULL),(70,61,'N_relative_mass',75,65,'point',NULL,NULL,NULL,NULL,NULL),(71,61,'K_relative_mass',76,65,'point',NULL,NULL,NULL,NULL,NULL),(72,61,'Ca_relative_mass',77,65,'point',NULL,NULL,NULL,NULL,NULL),(73,61,'Mg_relative_mass',78,65,'point',NULL,NULL,NULL,NULL,NULL),(74,61,'P_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(75,61,'N_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(76,61,'K_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(77,61,'Ca_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(78,61,'Mg_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(79,62,'mass_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(80,62,'mass_relative_mass',79,79,'mean',NULL,3,1,NULL,NULL),(81,62,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(82,62,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,'Approximate position of the water table depth at the time samples were inserted into the peat to start the decomposition experiment.'),(83,62,'P_relative_mass',88,79,'point',NULL,NULL,NULL,NULL,NULL),(84,62,'N_relative_mass',89,79,'point',NULL,NULL,NULL,NULL,NULL),(85,62,'K_relative_mass',90,79,'point',NULL,NULL,NULL,NULL,NULL),(86,62,'Ca_relative_mass',91,79,'point',NULL,NULL,NULL,NULL,NULL),(87,62,'Mg_relative_mass',92,79,'point',NULL,NULL,NULL,NULL,NULL),(88,62,'P_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(89,62,'N_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(90,62,'K_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(91,62,'Ca_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(92,62,'Mg_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(93,63,'mass_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(94,63,'mass_relative_mass',93,93,'mean',NULL,3,1,NULL,NULL),(95,63,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(96,63,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,'Approximate position of the water table depth at the time samples were inserted into the peat to start the decomposition experiment.'),(97,63,'P_relative_mass',102,93,'point',NULL,NULL,NULL,NULL,NULL),(98,63,'N_relative_mass',103,93,'point',NULL,NULL,NULL,NULL,NULL),(99,63,'K_relative_mass',104,93,'point',NULL,NULL,NULL,NULL,NULL),(100,63,'Ca_relative_mass',105,93,'point',NULL,NULL,NULL,NULL,NULL),(101,63,'Mg_relative_mass',106,93,'point',NULL,NULL,NULL,NULL,NULL),(102,63,'P_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(103,63,'N_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(104,63,'K_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(105,63,'Ca_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(106,63,'Mg_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(107,64,'mass_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(108,64,'mass_relative_mass',107,107,'mean',NULL,3,1,NULL,NULL),(109,64,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(110,64,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,'Approximate position of the water table depth at the time samples were inserted into the peat to start the decomposition experiment.'),(111,64,'P_relative_mass',116,107,'point',NULL,NULL,0.0005,NULL,NULL),(112,64,'N_relative_mass',117,107,'point',NULL,NULL,0.0054,NULL,NULL),(113,64,'K_relative_mass',118,107,'point',NULL,NULL,0.004699999999999999,NULL,NULL),(114,64,'Ca_relative_mass',119,107,'point',NULL,NULL,0.0036,NULL,NULL),(115,64,'Mg_relative_mass',120,107,'point',NULL,NULL,0.0016,NULL,NULL),(116,64,'P_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(117,64,'N_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(118,64,'K_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(119,64,'Ca_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(120,64,'Mg_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(121,65,'mass_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(122,65,'mass_relative_mass',121,121,'mean',NULL,3,1,NULL,NULL),(123,65,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(124,65,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,'Approximate position of the water table depth at the time samples were inserted into the peat to start the decomposition experiment.'),(125,65,'P_relative_mass',130,121,'point',NULL,NULL,0.0005,NULL,NULL),(126,65,'N_relative_mass',131,121,'point',NULL,NULL,0.0042,NULL,NULL),(127,65,'K_relative_mass',132,121,'point',NULL,NULL,0.0038,NULL,NULL),(128,65,'Ca_relative_mass',133,121,'point',NULL,NULL,0.0104,NULL,NULL),(129,65,'Mg_relative_mass',134,121,'point',NULL,NULL,0.0033,NULL,NULL),(130,65,'P_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(131,65,'N_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(132,65,'K_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(133,65,'Ca_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(134,65,'Mg_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(135,66,'mass_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(136,66,'mass_relative_mass',135,135,'mean',NULL,3,1,NULL,NULL),(137,66,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(138,66,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,'Approximate position of the water table depth at the time samples were inserted into the peat to start the decomposition experiment.'),(139,66,'P_relative_mass',144,135,'point',NULL,NULL,0.0005,NULL,NULL),(140,66,'N_relative_mass',145,135,'point',NULL,NULL,0.0036,NULL,NULL),(141,66,'K_relative_mass',146,135,'point',NULL,NULL,0.0079,NULL,NULL),(142,66,'Ca_relative_mass',147,135,'point',NULL,NULL,0.0048,NULL,NULL),(143,66,'Mg_relative_mass',148,135,'point',NULL,NULL,0.004,NULL,NULL),(144,66,'P_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(145,66,'N_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(146,66,'K_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(147,66,'Ca_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(148,66,'Mg_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(149,67,'mass_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(150,67,'mass_relative_mass',149,149,'mean',NULL,3,1,NULL,NULL),(151,67,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(152,67,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,'Approximate position of the water table depth at the time samples were inserted into the peat to start the decomposition experiment.'),(153,67,'P_relative_mass',158,149,'point',NULL,NULL,0.0002,NULL,NULL),(154,67,'N_relative_mass',159,149,'point',NULL,NULL,0.0062,NULL,NULL),(155,67,'K_relative_mass',160,149,'point',NULL,NULL,0.0040999999999999995,NULL,NULL),(156,67,'Ca_relative_mass',161,149,'point',NULL,NULL,0.0040999999999999995,NULL,NULL),(157,67,'Mg_relative_mass',162,149,'point',NULL,NULL,0.0014000000000000002,NULL,NULL),(158,67,'P_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(159,67,'N_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(160,67,'K_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(161,67,'Ca_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(162,67,'Mg_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(163,68,'mass_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(164,68,'mass_relative_mass',163,163,'mean',NULL,3,1,NULL,NULL),(165,68,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(166,68,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,'Approximate position of the water table depth at the time samples were inserted into the peat to start the decomposition experiment.'),(167,68,'P_relative_mass',172,163,'point',NULL,NULL,0.0003,NULL,NULL),(168,68,'N_relative_mass',173,163,'point',NULL,NULL,0.0044,NULL,NULL),(169,68,'K_relative_mass',174,163,'point',NULL,NULL,0.0029,NULL,NULL),(170,68,'Ca_relative_mass',175,163,'point',NULL,NULL,0.0060999999999999995,NULL,NULL),(171,68,'Mg_relative_mass',176,163,'point',NULL,NULL,0.0025,NULL,NULL),(172,68,'P_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(173,68,'N_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(174,68,'K_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(175,68,'Ca_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(176,68,'Mg_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(177,69,'mass_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(178,69,'mass_relative_mass',177,177,'mean',NULL,3,1,NULL,NULL),(179,69,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(180,69,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,'Approximate position of the water table depth at the time samples were inserted into the peat to start the decomposition experiment.'),(181,69,'P_relative_mass',186,177,'point',NULL,NULL,0.0003,NULL,NULL),(182,69,'N_relative_mass',187,177,'point',NULL,NULL,0.0052,NULL,NULL),(183,69,'K_relative_mass',188,177,'point',NULL,NULL,0.0027,NULL,NULL),(184,69,'Ca_relative_mass',189,177,'point',NULL,NULL,0.0075,NULL,NULL),(185,69,'Mg_relative_mass',190,177,'point',NULL,NULL,0.0043,NULL,NULL),(186,69,'P_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(187,69,'N_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(188,69,'K_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(189,69,'Ca_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(190,69,'Mg_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(191,70,'mass_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(192,70,'mass_relative_mass',191,191,'mean',NULL,3,1,NULL,NULL),(193,70,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(194,70,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,'Approximate position of the water table depth at the time samples were inserted into the peat to start the decomposition experiment.'),(195,70,'P_relative_mass',200,191,'point',NULL,NULL,0.001,NULL,NULL),(196,70,'N_relative_mass',201,191,'point',NULL,NULL,0.019799999999999998,NULL,NULL),(197,70,'K_relative_mass',202,191,'point',NULL,NULL,0.0063,NULL,NULL),(198,70,'Ca_relative_mass',203,191,'point',NULL,NULL,0.005699999999999999,NULL,NULL),(199,70,'Mg_relative_mass',204,191,'point',NULL,NULL,0.0028000000000000004,NULL,NULL),(200,70,'P_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(201,70,'N_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(202,70,'K_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(203,70,'Ca_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(204,70,'Mg_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(205,71,'mass_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(206,71,'mass_relative_mass',205,205,'mean',NULL,3,1,NULL,NULL),(207,71,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(208,71,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,'Approximate position of the water table depth at the time samples were inserted into the peat to start the decomposition experiment.'),(209,71,'P_relative_mass',214,205,'point',NULL,NULL,0.001,NULL,NULL),(210,71,'N_relative_mass',215,205,'point',NULL,NULL,0.0197,NULL,NULL),(211,71,'K_relative_mass',216,205,'point',NULL,NULL,0.005699999999999999,NULL,NULL),(212,71,'Ca_relative_mass',217,205,'point',NULL,NULL,0.0053,NULL,NULL),(213,71,'Mg_relative_mass',218,205,'point',NULL,NULL,0.0027,NULL,NULL),(214,71,'P_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(215,71,'N_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(216,71,'K_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(217,71,'Ca_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(218,71,'Mg_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(219,72,'mass_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(220,72,'mass_relative_mass',219,219,'mean',NULL,3,1,NULL,NULL),(221,72,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(222,72,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,'Approximate position of the water table depth at the time samples were inserted into the peat to start the decomposition experiment.'),(223,72,'P_relative_mass',228,219,'point',NULL,NULL,0.001,NULL,NULL),(224,72,'N_relative_mass',229,219,'point',NULL,NULL,0.0184,NULL,NULL),(225,72,'K_relative_mass',230,219,'point',NULL,NULL,0.0067,NULL,NULL),(226,72,'Ca_relative_mass',231,219,'point',NULL,NULL,0.005,NULL,NULL),(227,72,'Mg_relative_mass',232,219,'point',NULL,NULL,0.0029,NULL,NULL),(228,72,'P_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(229,72,'N_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(230,72,'K_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(231,72,'Ca_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(232,72,'Mg_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(233,73,'mass_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(234,73,'mass_relative_mass',233,233,'mean',NULL,3,1,NULL,NULL),(235,73,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(236,73,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,'Approximate position of the water table depth at the time samples were inserted into the peat to start the decomposition experiment.'),(237,73,'P_relative_mass',242,233,'point',NULL,NULL,0.0009,NULL,NULL),(238,73,'N_relative_mass',243,233,'point',NULL,NULL,0.0074,NULL,NULL),(239,73,'K_relative_mass',244,233,'point',NULL,NULL,0.0195,NULL,NULL),(240,73,'Ca_relative_mass',245,233,'point',NULL,NULL,0.0018,NULL,NULL),(241,73,'Mg_relative_mass',246,233,'point',NULL,NULL,0.0017000000000000001,NULL,NULL),(242,73,'P_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(243,73,'N_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(244,73,'K_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(245,73,'Ca_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(246,73,'Mg_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(247,74,'mass_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(248,74,'mass_relative_mass',247,247,'mean',NULL,3,1,NULL,NULL),(249,74,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(250,74,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,'Approximate position of the water table depth at the time samples were inserted into the peat to start the decomposition experiment.'),(251,74,'P_relative_mass',256,247,'point',NULL,NULL,0.001,NULL,NULL),(252,74,'N_relative_mass',257,247,'point',NULL,NULL,0.009300000000000001,NULL,NULL),(253,74,'K_relative_mass',258,247,'point',NULL,NULL,0.0172,NULL,NULL),(254,74,'Ca_relative_mass',259,247,'point',NULL,NULL,0.006,NULL,NULL),(255,74,'Mg_relative_mass',260,247,'point',NULL,NULL,0.002,NULL,NULL),(256,74,'P_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(257,74,'N_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(258,74,'K_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(259,74,'Ca_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(260,74,'Mg_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(261,75,'mass_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(262,75,'mass_relative_mass',261,261,'mean',NULL,3,1,NULL,NULL),(263,75,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(264,75,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,'Approximate position of the water table depth at the time samples were inserted into the peat to start the decomposition experiment.'),(265,75,'P_relative_mass',270,261,'point',NULL,NULL,0.0015,NULL,NULL),(266,75,'N_relative_mass',271,261,'point',NULL,NULL,0.018000000000000002,NULL,NULL),(267,75,'K_relative_mass',272,261,'point',NULL,NULL,0.0109,NULL,NULL),(268,75,'Ca_relative_mass',273,261,'point',NULL,NULL,0.0036,NULL,NULL),(269,75,'Mg_relative_mass',274,261,'point',NULL,NULL,0.0025,NULL,NULL),(270,75,'P_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(271,75,'N_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(272,75,'K_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(273,75,'Ca_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(274,75,'Mg_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(275,76,'mass_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(276,76,'mass_relative_mass',275,275,'mean',NULL,3,1,NULL,NULL),(277,76,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(278,76,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,'Approximate position of the water table depth at the time samples were inserted into the peat to start the decomposition experiment.'),(279,76,'P_relative_mass',284,275,'point',NULL,NULL,0.0005,NULL,NULL),(280,76,'N_relative_mass',285,275,'point',NULL,NULL,0.0104,NULL,NULL),(281,76,'K_relative_mass',286,275,'point',NULL,NULL,0.005699999999999999,NULL,NULL),(282,76,'Ca_relative_mass',287,275,'point',NULL,NULL,0.0027,NULL,NULL),(283,76,'Mg_relative_mass',288,275,'point',NULL,NULL,0.0017000000000000001,NULL,NULL),(284,76,'P_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(285,76,'N_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(286,76,'K_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(287,76,'Ca_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(288,76,'Mg_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(289,77,'mass_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(290,77,'mass_relative_mass',289,289,'mean',NULL,3,1,NULL,NULL),(291,77,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(292,77,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,'Approximate position of the water table depth at the time samples were inserted into the peat to start the decomposition experiment.'),(293,77,'P_relative_mass',298,289,'point',NULL,NULL,0.0005,NULL,NULL),(294,77,'N_relative_mass',299,289,'point',NULL,NULL,0.0184,NULL,NULL),(295,77,'K_relative_mass',300,289,'point',NULL,NULL,0.0075,NULL,NULL),(296,77,'Ca_relative_mass',301,289,'point',NULL,NULL,0.0025,NULL,NULL),(297,77,'Mg_relative_mass',302,289,'point',NULL,NULL,0.0025,NULL,NULL),(298,77,'P_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(299,77,'N_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(300,77,'K_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(301,77,'Ca_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(302,77,'Mg_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(303,78,'mass_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(304,78,'mass_relative_mass',303,303,'mean',NULL,3,1,NULL,NULL),(305,78,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(306,78,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,'Approximate position of the water table depth at the time samples were inserted into the peat to start the decomposition experiment.'),(307,78,'P_relative_mass',312,303,'point',NULL,NULL,0.0007000000000000001,NULL,NULL),(308,78,'N_relative_mass',313,303,'point',NULL,NULL,0.0147,NULL,NULL),(309,78,'K_relative_mass',314,303,'point',NULL,NULL,0.0073,NULL,NULL),(310,78,'Ca_relative_mass',315,303,'point',NULL,NULL,0.0034999999999999996,NULL,NULL),(311,78,'Mg_relative_mass',316,303,'point',NULL,NULL,0.0027,NULL,NULL),(312,78,'P_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(313,78,'N_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(314,78,'K_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(315,78,'Ca_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(316,78,'Mg_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(317,79,'mass_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(318,79,'mass_relative_mass',317,317,'mean',NULL,3,1,NULL,NULL),(319,79,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(320,79,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,'Approximate position of the water table depth at the time samples were inserted into the peat to start the decomposition experiment.'),(321,79,'P_relative_mass',326,317,'point',NULL,NULL,0.0011,NULL,NULL),(322,79,'N_relative_mass',327,317,'point',NULL,NULL,0.011000000000000001,NULL,NULL),(323,79,'K_relative_mass',328,317,'point',NULL,NULL,0.0038,NULL,NULL),(324,79,'Ca_relative_mass',329,317,'point',NULL,NULL,0.0032,NULL,NULL),(325,79,'Mg_relative_mass',330,317,'point',NULL,NULL,0.003,NULL,NULL),(326,79,'P_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(327,79,'N_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(328,79,'K_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(329,79,'Ca_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(330,79,'Mg_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(331,80,'mass_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(332,80,'mass_relative_mass',331,331,'mean',NULL,3,1,NULL,NULL),(333,80,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(334,80,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,'Approximate position of the water table depth at the time samples were inserted into the peat to start the decomposition experiment.'),(335,80,'P_relative_mass',340,331,'point',NULL,NULL,0.0005,NULL,NULL),(336,80,'N_relative_mass',341,331,'point',NULL,NULL,0.0092,NULL,NULL),(337,80,'K_relative_mass',342,331,'point',NULL,NULL,0.0084,NULL,NULL),(338,80,'Ca_relative_mass',343,331,'point',NULL,NULL,0.0027,NULL,NULL),(339,80,'Mg_relative_mass',344,331,'point',NULL,NULL,0.0019,NULL,NULL),(340,80,'P_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(341,80,'N_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(342,80,'K_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(343,80,'Ca_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(344,80,'Mg_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(345,81,'mass_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(346,81,'mass_relative_mass',345,345,'mean',NULL,3,1,NULL,NULL),(347,81,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(348,81,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,'Approximate position of the water table depth at the time samples were inserted into the peat to start the decomposition experiment.'),(349,81,'P_relative_mass',354,345,'point',NULL,NULL,0.001,NULL,NULL),(350,81,'N_relative_mass',355,345,'point',NULL,NULL,0.011399999999999999,NULL,NULL),(351,81,'K_relative_mass',356,345,'point',NULL,NULL,0.013600000000000001,NULL,NULL),(352,81,'Ca_relative_mass',357,345,'point',NULL,NULL,0.0025,NULL,NULL),(353,81,'Mg_relative_mass',358,345,'point',NULL,NULL,0.0023,NULL,NULL),(354,81,'P_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(355,81,'N_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(356,81,'K_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(357,81,'Ca_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(358,81,'Mg_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(359,82,'mass_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(360,82,'mass_relative_mass',359,359,'mean',NULL,3,1,NULL,NULL),(361,82,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(362,82,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,'Approximate position of the water table depth at the time samples were inserted into the peat to start the decomposition experiment.'),(363,82,'P_relative_mass',368,359,'point',NULL,NULL,0.0008,NULL,NULL),(364,82,'N_relative_mass',369,359,'point',NULL,NULL,0.0208,NULL,NULL),(365,82,'K_relative_mass',370,359,'point',NULL,NULL,0.0068000000000000005,NULL,NULL),(366,82,'Ca_relative_mass',371,359,'point',NULL,NULL,0.0084,NULL,NULL),(367,82,'Mg_relative_mass',372,359,'point',NULL,NULL,0.0036,NULL,NULL),(368,82,'P_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(369,82,'N_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(370,82,'K_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(371,82,'Ca_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(372,82,'Mg_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(373,83,'mass_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(374,83,'mass_relative_mass',373,373,'mean',NULL,3,1,NULL,NULL),(375,83,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(376,83,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,'Approximate position of the water table depth at the time samples were inserted into the peat to start the decomposition experiment.'),(377,83,'P_relative_mass',382,373,'point',NULL,NULL,0.0009,NULL,NULL),(378,83,'N_relative_mass',383,373,'point',NULL,NULL,0.0204,NULL,NULL),(379,83,'K_relative_mass',384,373,'point',NULL,NULL,0.006500000000000001,NULL,NULL),(380,83,'Ca_relative_mass',385,373,'point',NULL,NULL,0.008100000000000001,NULL,NULL),(381,83,'Mg_relative_mass',386,373,'point',NULL,NULL,0.0033,NULL,NULL),(382,83,'P_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(383,83,'N_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(384,83,'K_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(385,83,'Ca_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(386,83,'Mg_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(387,84,'mass_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(388,84,'mass_relative_mass',387,387,'mean',NULL,3,1,NULL,NULL),(389,84,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(390,84,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,'Approximate position of the water table depth at the time samples were inserted into the peat to start the decomposition experiment.'),(391,84,'P_relative_mass',396,387,'point',NULL,NULL,0.0005,NULL,NULL),(392,84,'N_relative_mass',397,387,'point',NULL,NULL,0.0116,NULL,NULL),(393,84,'K_relative_mass',398,387,'point',NULL,NULL,0.0039000000000000003,NULL,NULL),(394,84,'Ca_relative_mass',399,387,'point',NULL,NULL,0.0027,NULL,NULL),(395,84,'Mg_relative_mass',400,387,'point',NULL,NULL,0.0018,NULL,NULL),(396,84,'P_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(397,84,'N_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(398,84,'K_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(399,84,'Ca_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(400,84,'Mg_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(401,85,'mass_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(402,85,'mass_relative_mass',401,401,'mean',NULL,3,1,NULL,NULL),(403,85,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(404,85,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,'Approximate position of the water table depth at the time samples were inserted into the peat to start the decomposition experiment.'),(405,85,'P_relative_mass',410,401,'point',NULL,NULL,0.0005,NULL,NULL),(406,85,'N_relative_mass',411,401,'point',NULL,NULL,0.0194,NULL,NULL),(407,85,'K_relative_mass',412,401,'point',NULL,NULL,0.004,NULL,NULL),(408,85,'Ca_relative_mass',413,401,'point',NULL,NULL,0.0023,NULL,NULL),(409,85,'Mg_relative_mass',414,401,'point',NULL,NULL,0.0023,NULL,NULL),(410,85,'P_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(411,85,'N_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(412,85,'K_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(413,85,'Ca_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(414,85,'Mg_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(415,86,'mass_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(416,86,'mass_relative_mass',415,415,'mean',NULL,3,1,NULL,NULL),(417,86,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(418,86,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,'Approximate position of the water table depth at the time samples were inserted into the peat to start the decomposition experiment.'),(419,86,'P_relative_mass',424,415,'point',NULL,NULL,0.0005,NULL,NULL),(420,86,'N_relative_mass',425,415,'point',NULL,NULL,0.015,NULL,NULL),(421,86,'K_relative_mass',426,415,'point',NULL,NULL,0.0055000000000000005,NULL,NULL),(422,86,'Ca_relative_mass',427,415,'point',NULL,NULL,0.0025,NULL,NULL),(423,86,'Mg_relative_mass',428,415,'point',NULL,NULL,0.0021,NULL,NULL),(424,86,'P_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(425,86,'N_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(426,86,'K_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(427,86,'Ca_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(428,86,'Mg_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(429,87,'mass_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(430,87,'mass_relative_mass',429,429,'mean',NULL,3,1,NULL,NULL),(431,87,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(432,87,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,'Approximate position of the water table depth at the time samples were inserted into the peat to start the decomposition experiment.'),(433,87,'P_relative_mass',438,429,'point',NULL,NULL,0.0002,NULL,NULL),(434,87,'N_relative_mass',439,429,'point',NULL,NULL,0.0024,NULL,NULL),(435,87,'K_relative_mass',440,429,'point',NULL,NULL,0.0029,NULL,NULL),(436,87,'Ca_relative_mass',441,429,'point',NULL,NULL,0.005,NULL,NULL),(437,87,'Mg_relative_mass',442,429,'point',NULL,NULL,0.002,NULL,NULL),(438,87,'P_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(439,87,'N_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(440,87,'K_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(441,87,'Ca_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(442,87,'Mg_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(443,88,'mass_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(444,88,'mass_relative_mass',443,443,'mean',NULL,3,1,NULL,NULL),(445,88,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(446,88,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,'Approximate position of the water table depth at the time samples were inserted into the peat to start the decomposition experiment.'),(447,88,'P_relative_mass',452,443,'point',NULL,NULL,0.001,NULL,NULL),(448,88,'N_relative_mass',453,443,'point',NULL,NULL,0.006999999999999999,NULL,NULL),(449,88,'K_relative_mass',454,443,'point',NULL,NULL,0.0031,NULL,NULL),(450,88,'Ca_relative_mass',455,443,'point',NULL,NULL,0.0040999999999999995,NULL,NULL),(451,88,'Mg_relative_mass',456,443,'point',NULL,NULL,0.0031,NULL,NULL),(452,88,'P_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(453,88,'N_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(454,88,'K_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(455,88,'Ca_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(456,88,'Mg_absolute',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(457,89,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(458,89,'mass_relative_mass',457,65,'mean',NULL,3,0.94320987654321,NULL,NULL),(459,89,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(460,90,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(461,90,'mass_relative_mass',460,79,'mean',NULL,3,0.9604938271604939,NULL,NULL),(462,90,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(463,91,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(464,91,'mass_relative_mass',463,93,'mean',NULL,3,0.925925925925926,NULL,NULL),(465,91,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(466,92,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(467,92,'mass_relative_mass',466,107,'mean',NULL,3,0.9500000000000003,NULL,NULL),(468,92,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(469,93,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(470,93,'mass_relative_mass',469,121,'mean',NULL,3,0.9175000000000001,NULL,NULL),(471,93,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(472,94,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(473,94,'mass_relative_mass',472,135,'mean',NULL,3,0.9250000000000002,NULL,NULL),(474,94,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(475,95,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(476,95,'mass_relative_mass',475,149,'mean',NULL,3,0.9325301204819277,NULL,NULL),(477,95,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(478,96,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(479,96,'mass_relative_mass',478,163,'mean',NULL,3,0.9349397590361446,NULL,NULL),(480,96,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(481,97,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(482,97,'mass_relative_mass',481,177,'mean',NULL,3,0.9590361445783132,NULL,NULL),(483,97,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(484,98,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(485,98,'mass_relative_mass',484,191,'mean',NULL,3,0.8345679012345683,NULL,NULL),(486,98,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(487,99,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(488,99,'mass_relative_mass',487,205,'mean',NULL,3,0.8864197530864201,NULL,NULL),(489,99,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(490,100,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(491,100,'mass_relative_mass',490,219,'mean',NULL,3,0.8888888888888892,NULL,NULL),(492,100,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(493,101,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(494,101,'mass_relative_mass',493,233,'mean',NULL,3,0.895121951219513,NULL,NULL),(495,101,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(496,102,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(497,102,'mass_relative_mass',496,247,'mean',NULL,3,0.8682926829268299,NULL,NULL),(498,102,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(499,103,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(500,103,'mass_relative_mass',499,261,'mean',NULL,3,0.8800000000000009,NULL,NULL),(501,103,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(502,104,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(503,104,'mass_relative_mass',502,275,'mean',NULL,3,0.8463414634146349,NULL,NULL),(504,104,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(505,105,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(506,105,'mass_relative_mass',505,289,'mean',NULL,3,0.9024390243902445,NULL,NULL),(507,105,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(508,106,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(509,106,'mass_relative_mass',508,303,'mean',NULL,3,0.8634146341463423,NULL,NULL),(510,106,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(511,107,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(512,107,'mass_relative_mass',511,317,'mean',NULL,3,0.8370370370370378,NULL,NULL),(513,107,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(514,108,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(515,108,'mass_relative_mass',514,331,'mean',NULL,3,0.908641975308642,NULL,NULL),(516,108,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(517,109,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(518,109,'mass_relative_mass',517,345,'mean',NULL,3,0.8567901234567907,NULL,NULL),(519,109,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(520,110,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(521,110,'mass_relative_mass',520,359,'mean',NULL,3,0.9219512195121954,NULL,NULL),(522,110,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(523,111,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(524,111,'mass_relative_mass',523,373,'mean',NULL,3,0.878048780487805,NULL,NULL),(525,111,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(526,112,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(527,112,'mass_relative_mass',526,387,'mean',NULL,3,0.9048780487804882,NULL,NULL),(528,112,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(529,113,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(530,113,'mass_relative_mass',529,401,'mean',NULL,3,0.9121951219512195,NULL,NULL),(531,113,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(532,114,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(533,114,'mass_relative_mass',532,415,'mean',NULL,3,0.8975609756097563,NULL,NULL),(534,114,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(535,115,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(536,115,'mass_relative_mass',535,429,'mean',NULL,3,0.9333333333333331,NULL,NULL),(537,115,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(538,116,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(539,116,'mass_relative_mass',538,443,'mean',NULL,3,0.9407407407407407,NULL,NULL),(540,116,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(541,117,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(542,117,'mass_relative_mass',541,65,'mean',NULL,3,0.9111111111111111,NULL,NULL),(543,117,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(544,117,'P_relative_mass',549,74,'mean',NULL,3,NULL,NULL,NULL),(545,117,'N_relative_mass',550,75,'mean',NULL,3,NULL,NULL,NULL),(546,117,'K_relative_mass',551,76,'mean',NULL,3,NULL,NULL,NULL),(547,117,'Ca_relative_mass',552,77,'mean',NULL,3,NULL,NULL,NULL),(548,117,'Mg_relative_mass',553,78,'mean',NULL,3,NULL,NULL,NULL),(549,117,'P_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(550,117,'N_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(551,117,'K_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(552,117,'Ca_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(553,117,'Mg_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(554,118,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(555,118,'mass_relative_mass',554,79,'mean',NULL,3,0.9358024691358026,NULL,NULL),(556,118,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(557,118,'P_relative_mass',562,88,'mean',NULL,3,NULL,NULL,NULL),(558,118,'N_relative_mass',563,89,'mean',NULL,3,NULL,NULL,NULL),(559,118,'K_relative_mass',564,90,'mean',NULL,3,NULL,NULL,NULL),(560,118,'Ca_relative_mass',565,91,'mean',NULL,3,NULL,NULL,NULL),(561,118,'Mg_relative_mass',566,92,'mean',NULL,3,NULL,NULL,NULL),(562,118,'P_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(563,118,'N_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(564,118,'K_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(565,118,'Ca_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(566,118,'Mg_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(567,119,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(568,119,'mass_relative_mass',567,93,'mean',NULL,3,0.9234567901234568,NULL,NULL),(569,119,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(570,119,'P_relative_mass',575,102,'mean',NULL,3,NULL,NULL,NULL),(571,119,'N_relative_mass',576,103,'mean',NULL,3,NULL,NULL,NULL),(572,119,'K_relative_mass',577,104,'mean',NULL,3,NULL,NULL,NULL),(573,119,'Ca_relative_mass',578,105,'mean',NULL,3,NULL,NULL,NULL),(574,119,'Mg_relative_mass',579,106,'mean',NULL,3,NULL,NULL,NULL),(575,119,'P_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(576,119,'N_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(577,119,'K_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(578,119,'Ca_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(579,119,'Mg_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(580,120,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(581,120,'mass_relative_mass',580,107,'mean',NULL,3,0.9300000000000002,NULL,NULL),(582,120,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(583,120,'P_relative_mass',588,116,'mean','sd',3,1.926,0.213,NULL),(584,120,'N_relative_mass',589,117,'mean','sd',3,1.484,0.09,NULL),(585,120,'K_relative_mass',590,118,'mean','sd',3,0.26899999999999996,0.057999999999999996,NULL),(586,120,'Ca_relative_mass',591,119,'mean','sd',3,1.139,0.203,NULL),(587,120,'Mg_relative_mass',592,120,'mean','sd',3,0.953,0.155,NULL),(588,120,'P_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(589,120,'N_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(590,120,'K_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(591,120,'Ca_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(592,120,'Mg_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(593,121,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(594,121,'mass_relative_mass',593,121,'mean',NULL,3,0.8800000000000003,NULL,NULL),(595,121,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(596,121,'P_relative_mass',601,130,'mean','sd',3,1.2570000000000001,0.27899999999999997,NULL),(597,121,'N_relative_mass',602,131,'mean','sd',3,1.659,0.152,NULL),(598,121,'K_relative_mass',603,132,'mean','sd',3,0.267,0.023,NULL),(599,121,'Ca_relative_mass',604,133,'mean','sd',3,0.59,0.024,NULL),(600,121,'Mg_relative_mass',605,134,'mean','sd',3,0.875,0.04,NULL),(601,121,'P_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(602,121,'N_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(603,121,'K_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(604,121,'Ca_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(605,121,'Mg_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(606,122,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(607,122,'mass_relative_mass',606,135,'mean',NULL,3,0.8875000000000003,NULL,NULL),(608,122,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(609,122,'P_relative_mass',614,144,'mean','sd',3,1.796,0.23600000000000002,NULL),(610,122,'N_relative_mass',615,145,'mean','sd',3,1.825,0.23399999999999999,NULL),(611,122,'K_relative_mass',616,146,'mean','sd',3,0.151,0.011000000000000001,NULL),(612,122,'Ca_relative_mass',617,147,'mean','sd',3,1.46,0.121,NULL),(613,122,'Mg_relative_mass',618,148,'mean','sd',3,0.995,0.073,NULL),(614,122,'P_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(615,122,'N_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(616,122,'K_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(617,122,'Ca_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(618,122,'Mg_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(619,123,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(620,123,'mass_relative_mass',619,149,'mean',NULL,3,0.9180722891566265,NULL,NULL),(621,123,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(622,123,'P_relative_mass',627,158,'mean','sd',3,3.1460000000000004,0.732,NULL),(623,123,'N_relative_mass',628,159,'mean','sd',3,0.9670000000000001,0.061,NULL),(624,123,'K_relative_mass',629,160,'mean','sd',3,0.18,0.035,NULL),(625,123,'Ca_relative_mass',630,161,'mean','sd',3,1.845,0.11900000000000001,NULL),(626,123,'Mg_relative_mass',631,162,'mean','sd',3,1.725,0.204,NULL),(627,123,'P_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(628,123,'N_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(629,123,'K_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(630,123,'Ca_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(631,123,'Mg_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(632,124,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(633,124,'mass_relative_mass',632,163,'mean',NULL,3,0.8819277108433735,NULL,NULL),(634,124,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(635,124,'P_relative_mass',640,172,'mean','sd',3,1.864,0.326,NULL),(636,124,'N_relative_mass',641,173,'mean','sd',3,1.8619999999999999,0.6609999999999999,NULL),(637,124,'K_relative_mass',642,174,'mean','sd',3,0.375,0.019,NULL),(638,124,'Ca_relative_mass',643,175,'mean','sd',3,1.08,0.037000000000000005,NULL),(639,124,'Mg_relative_mass',644,176,'mean','sd',3,0.86,0.122,NULL),(640,124,'P_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(641,124,'N_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(642,124,'K_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(643,124,'Ca_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(644,124,'Mg_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(645,125,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(646,125,'mass_relative_mass',645,177,'mean',NULL,3,0.9277108433734941,NULL,NULL),(647,125,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(648,125,'P_relative_mass',653,186,'mean','sd',3,3.082,0.22899999999999998,NULL),(649,125,'N_relative_mass',654,187,'mean','sd',3,1.03,0.629,NULL),(650,125,'K_relative_mass',655,188,'mean','sd',3,0.617,0.063,NULL),(651,125,'Ca_relative_mass',656,189,'mean','sd',3,0.7170000000000001,0.064,NULL),(652,125,'Mg_relative_mass',657,190,'mean','sd',3,0.775,0.062,NULL),(653,125,'P_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(654,125,'N_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(655,125,'K_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(656,125,'Ca_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(657,125,'Mg_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(658,126,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(659,126,'mass_relative_mass',658,191,'mean',NULL,3,0.7802469135802472,NULL,NULL),(660,126,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(661,126,'P_relative_mass',666,200,'mean','sd',3,0.917,0.096,NULL),(662,126,'N_relative_mass',667,201,'mean','sd',3,1.083,0.217,NULL),(663,126,'K_relative_mass',668,202,'mean','sd',3,0.161,0.02,NULL),(664,126,'Ca_relative_mass',669,203,'mean','sd',3,0.768,0.075,NULL),(665,126,'Mg_relative_mass',670,204,'mean','sd',3,0.386,0.11599999999999999,NULL),(666,126,'P_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(667,126,'N_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(668,126,'K_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(669,126,'Ca_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(670,126,'Mg_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(671,127,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(672,127,'mass_relative_mass',671,205,'mean',NULL,3,0.7925925925925928,NULL,NULL),(673,127,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(674,127,'P_relative_mass',679,214,'mean','sd',3,1,0.289,NULL),(675,127,'N_relative_mass',680,215,'mean','sd',3,1.4880000000000002,0.073,NULL),(676,127,'K_relative_mass',681,216,'mean','sd',3,0.23,0.024,NULL),(677,127,'Ca_relative_mass',682,217,'mean','sd',3,1.805,0.061,NULL),(678,127,'Mg_relative_mass',683,218,'mean','sd',3,0.513,0.037000000000000005,NULL),(679,127,'P_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(680,127,'N_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(681,127,'K_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(682,127,'Ca_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(683,127,'Mg_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(684,128,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(685,128,'mass_relative_mass',684,219,'mean',NULL,3,0.8222222222222225,NULL,NULL),(686,128,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(687,128,'P_relative_mass',692,228,'mean','sd',3,0.733,0.18100000000000002,NULL),(688,128,'N_relative_mass',693,229,'mean','sd',3,1.229,0.198,NULL),(689,128,'K_relative_mass',694,230,'mean','sd',3,0.195,0.04,NULL),(690,128,'Ca_relative_mass',695,231,'mean','sd',3,0.943,0.27699999999999997,NULL),(691,128,'Mg_relative_mass',696,232,'mean','sd',3,0.45299999999999996,0.11,NULL),(692,128,'P_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(693,128,'N_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(694,128,'K_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(695,128,'Ca_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(696,128,'Mg_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(697,129,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(698,129,'mass_relative_mass',697,233,'mean',NULL,3,0.8341463414634154,NULL,NULL),(699,129,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(700,129,'P_relative_mass',705,242,'mean','sd',3,0.7559999999999999,0.19899999999999998,NULL),(701,129,'N_relative_mass',706,243,'mean','sd',3,1.2819999999999998,0.6509999999999999,NULL),(702,129,'K_relative_mass',707,244,'mean','sd',3,0.293,0.33799999999999997,NULL),(703,129,'Ca_relative_mass',708,245,'mean','sd',3,0.956,0.35700000000000004,NULL),(704,129,'Mg_relative_mass',709,246,'mean','sd',3,0.228,0.078,NULL),(705,129,'P_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(706,129,'N_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(707,129,'K_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(708,129,'Ca_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(709,129,'Mg_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(710,130,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(711,130,'mass_relative_mass',710,247,'mean',NULL,3,0.7365853658536596,NULL,NULL),(712,130,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(713,130,'P_relative_mass',718,256,'mean','sd',3,0.851,0.08199999999999999,NULL),(714,130,'N_relative_mass',719,257,'mean','sd',3,1.092,0.345,NULL),(715,130,'K_relative_mass',720,258,'mean','sd',3,0.10800000000000001,0.026000000000000002,NULL),(716,130,'Ca_relative_mass',721,259,'mean','sd',3,0.316,0.23600000000000002,NULL),(717,130,'Mg_relative_mass',722,260,'mean','sd',3,0.40700000000000003,0.071,NULL),(718,130,'P_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(719,130,'N_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(720,130,'K_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(721,130,'Ca_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(722,130,'Mg_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(723,131,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(724,131,'mass_relative_mass',723,261,'mean',NULL,3,0.7950000000000006,NULL,NULL),(725,131,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(726,131,'P_relative_mass',731,270,'mean','sd',3,0.574,0.024,NULL),(727,131,'N_relative_mass',732,271,'mean','sd',3,0.728,0.036000000000000004,NULL),(728,131,'K_relative_mass',733,272,'mean','sd',3,0.163,0.017,NULL),(729,131,'Ca_relative_mass',734,273,'mean','sd',3,0.6779999999999999,0.092,NULL),(730,131,'Mg_relative_mass',735,274,'mean','sd',3,0.273,0.035,NULL),(731,131,'P_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(732,131,'N_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(733,131,'K_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(734,131,'Ca_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(735,131,'Mg_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(736,132,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(737,132,'mass_relative_mass',736,275,'mean',NULL,3,0.8219512195121959,NULL,NULL),(738,132,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(739,132,'P_relative_mass',744,284,'mean','sd',3,1.574,0.114,NULL),(740,132,'N_relative_mass',745,285,'mean','sd',3,1.505,0.23,NULL),(741,132,'K_relative_mass',746,286,'mean','sd',3,0.21600000000000003,0.018000000000000002,NULL),(742,132,'Ca_relative_mass',747,287,'mean','sd',3,0.75,0.099,NULL),(743,132,'Mg_relative_mass',748,288,'mean','sd',3,0.402,0.018000000000000002,NULL),(744,132,'P_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(745,132,'N_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(746,132,'K_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(747,132,'Ca_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(748,132,'Mg_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(749,133,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(750,133,'mass_relative_mass',749,289,'mean',NULL,3,0.8341463414634154,NULL,NULL),(751,133,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(752,133,'P_relative_mass',757,298,'mean','sd',3,1.714,0.08199999999999999,NULL),(753,133,'N_relative_mass',758,299,'mean','sd',3,0.8220000000000001,0.054000000000000006,NULL),(754,133,'K_relative_mass',759,300,'mean','sd',3,0.214,0.042,NULL),(755,133,'Ca_relative_mass',760,301,'mean','sd',3,0.971,0.033,NULL),(756,133,'Mg_relative_mass',761,302,'mean','sd',3,0.37200000000000005,0.067,NULL),(757,133,'P_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(758,133,'N_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(759,133,'K_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(760,133,'Ca_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(761,133,'Mg_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(762,134,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(763,134,'mass_relative_mass',762,303,'mean',NULL,3,0.7463414634146353,NULL,NULL),(764,134,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(765,134,'P_relative_mass',770,312,'mean','sd',3,1.3230000000000002,0.45299999999999996,NULL),(766,134,'N_relative_mass',771,313,'mean','sd',3,0.484,0.282,NULL),(767,134,'K_relative_mass',772,314,'mean','sd',3,0.25,0.054000000000000006,NULL),(768,134,'Ca_relative_mass',773,315,'mean','sd',3,0.6859999999999999,0.226,NULL),(769,134,'Mg_relative_mass',774,316,'mean','sd',3,0.41,0.151,NULL),(770,134,'P_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(771,134,'N_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(772,134,'K_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(773,134,'Ca_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(774,134,'Mg_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(775,135,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(776,135,'mass_relative_mass',775,317,'mean',NULL,3,0.7975308641975315,NULL,NULL),(777,135,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(778,135,'P_relative_mass',783,326,'mean','sd',3,0.595,0.10800000000000001,NULL),(779,135,'N_relative_mass',784,327,'mean','sd',3,0.674,0.081,NULL),(780,135,'K_relative_mass',785,328,'mean','sd',3,0.13699999999999998,0.027999999999999997,NULL),(781,135,'Ca_relative_mass',786,329,'mean','sd',3,0.5579999999999999,0.055,NULL),(782,135,'Mg_relative_mass',787,330,'mean','sd',3,0.16899999999999998,0.009000000000000001,NULL),(783,135,'P_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(784,135,'N_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(785,135,'K_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(786,135,'Ca_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(787,135,'Mg_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(788,136,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(789,136,'mass_relative_mass',788,331,'mean',NULL,3,0.8666666666666671,NULL,NULL),(790,136,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(791,136,'P_relative_mass',796,340,'mean','sd',3,1.0659999999999998,0.193,NULL),(792,136,'N_relative_mass',797,341,'mean','sd',3,0.97,0.28,NULL),(793,136,'K_relative_mass',798,342,'mean','sd',3,0.10300000000000001,0.044000000000000004,NULL),(794,136,'Ca_relative_mass',799,343,'mean','sd',3,1.183,0.04,NULL),(795,136,'Mg_relative_mass',800,344,'mean','sd',3,0.361,0.084,NULL),(796,136,'P_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(797,136,'N_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(798,136,'K_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(799,136,'Ca_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(800,136,'Mg_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(801,137,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(802,137,'mass_relative_mass',801,345,'mean',NULL,3,0.7530864197530874,NULL,NULL),(803,137,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(804,137,'P_relative_mass',809,354,'mean','sd',3,0.87,0.065,NULL),(805,137,'N_relative_mass',810,355,'mean','sd',3,0.772,0.037000000000000005,NULL),(806,137,'K_relative_mass',811,356,'mean','sd',3,0.16,0.021,NULL),(807,137,'Ca_relative_mass',812,357,'mean','sd',3,1.093,0.105,NULL),(808,137,'Mg_relative_mass',813,358,'mean','sd',3,0.62,0.015,NULL),(809,137,'P_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(810,137,'N_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(811,137,'K_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(812,137,'Ca_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(813,137,'Mg_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(814,138,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(815,138,'mass_relative_mass',814,359,'mean',NULL,3,0.8560975609756096,NULL,NULL),(816,138,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(817,138,'P_relative_mass',822,368,'mean','sd',3,0.609,0.040999999999999995,NULL),(818,138,'N_relative_mass',823,369,'mean','sd',3,1.515,0.034,NULL),(819,138,'K_relative_mass',824,370,'mean','sd',3,0.107,0.006999999999999999,NULL),(820,138,'Ca_relative_mass',825,371,'mean','sd',3,0.875,0.057999999999999996,NULL),(821,138,'Mg_relative_mass',826,372,'mean','sd',3,0.32799999999999996,0.033,NULL),(822,138,'P_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(823,138,'N_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(824,138,'K_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(825,138,'Ca_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(826,138,'Mg_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(827,139,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(828,139,'mass_relative_mass',827,373,'mean',NULL,3,0.8121951219512195,NULL,NULL),(829,139,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(830,139,'P_relative_mass',835,382,'mean','sd',3,1.079,0.087,NULL),(831,139,'N_relative_mass',836,383,'mean','sd',3,1.319,0.305,NULL),(832,139,'K_relative_mass',837,384,'mean','sd',3,0.205,0.033,NULL),(833,139,'Ca_relative_mass',838,385,'mean','sd',3,0.768,0.025,NULL),(834,139,'Mg_relative_mass',839,386,'mean','sd',3,0.355,0.055999999999999994,NULL),(835,139,'P_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(836,139,'N_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(837,139,'K_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(838,139,'Ca_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(839,139,'Mg_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(840,140,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(841,140,'mass_relative_mass',840,387,'mean',NULL,3,0.8731707317073172,NULL,NULL),(842,140,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(843,140,'P_relative_mass',848,396,'mean','sd',3,0.473,0.299,NULL),(844,140,'N_relative_mass',849,397,'mean','sd',3,0.888,0.034,NULL),(845,140,'K_relative_mass',850,398,'mean','sd',3,0.223,0.018000000000000002,NULL),(846,140,'Ca_relative_mass',851,399,'mean','sd',3,0.7440000000000001,0.1,NULL),(847,140,'Mg_relative_mass',852,400,'mean','sd',3,0.284,0.025,NULL),(848,140,'P_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(849,140,'N_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(850,140,'K_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(851,140,'Ca_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(852,140,'Mg_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(853,141,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(854,141,'mass_relative_mass',853,401,'mean',NULL,3,0.8780487804878051,NULL,NULL),(855,141,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(856,141,'P_relative_mass',861,410,'mean','sd',3,0.414,0.248,NULL),(857,141,'N_relative_mass',862,411,'mean','sd',3,0.606,0.086,NULL),(858,141,'K_relative_mass',863,412,'mean','sd',3,0.332,0.063,NULL),(859,141,'Ca_relative_mass',864,413,'mean','sd',3,0.9,0.133,NULL),(860,141,'Mg_relative_mass',865,414,'mean','sd',3,0.242,0.02,NULL),(861,141,'P_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(862,141,'N_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(863,141,'K_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(864,141,'Ca_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(865,141,'Mg_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(866,142,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(867,142,'mass_relative_mass',866,415,'mean',NULL,3,0.8390243902439027,NULL,NULL),(868,142,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(869,142,'P_relative_mass',874,424,'mean','sd',3,0.284,0.07400000000000001,NULL),(870,142,'N_relative_mass',875,425,'mean','sd',3,0.619,0.114,NULL),(871,142,'K_relative_mass',876,426,'mean','sd',3,0.19399999999999998,0.013999999999999999,NULL),(872,142,'Ca_relative_mass',877,427,'mean','sd',3,0.953,0.134,NULL),(873,142,'Mg_relative_mass',878,428,'mean','sd',3,0.493,0.077,NULL),(874,142,'P_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(875,142,'N_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(876,142,'K_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(877,142,'Ca_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(878,142,'Mg_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(879,143,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(880,143,'mass_relative_mass',879,429,'mean',NULL,3,0.8839506172839505,NULL,NULL),(881,143,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(882,143,'P_relative_mass',887,438,'mean','sd',3,2.073,0.561,NULL),(883,143,'N_relative_mass',888,439,'mean','sd',3,3.4760000000000004,0.124,NULL),(884,143,'K_relative_mass',889,440,'mean','sd',3,0.33799999999999997,0.05,NULL),(885,143,'Ca_relative_mass',890,441,'mean','sd',3,1.405,0.08900000000000001,NULL),(886,143,'Mg_relative_mass',891,442,'mean','sd',3,1.145,0.083,NULL),(887,143,'P_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(888,143,'N_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(889,143,'K_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(890,143,'Ca_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(891,143,'Mg_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(892,144,'mass_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(893,144,'mass_relative_mass',892,443,'mean',NULL,3,0.9160493827160492,NULL,NULL),(894,144,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1.4,NULL,NULL),(895,144,'P_relative_mass',900,452,'mean','sd',3,0.833,0.099,NULL),(896,144,'N_relative_mass',901,453,'mean','sd',3,1.082,0.613,NULL),(897,144,'K_relative_mass',902,454,'mean','sd',3,0.467,0.039,NULL),(898,144,'Ca_relative_mass',903,455,'mean','sd',3,1.057,0.11699999999999999,NULL),(899,144,'Mg_relative_mass',904,456,'mean','sd',3,1.1179999999999999,0.132,NULL),(900,144,'P_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(901,144,'N_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(902,144,'K_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(903,144,'Ca_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(904,144,'Mg_absolute',NULL,NULL,'mean',NULL,3,NULL,NULL,NULL),(905,145,'pH',NULL,NULL,'min',NULL,NULL,4.6,NULL,NULL),(906,146,'pH',NULL,NULL,'min',NULL,NULL,5.2,NULL,NULL),(907,147,'pH',NULL,NULL,'min',NULL,NULL,5.4,NULL,NULL),(908,148,'pH',NULL,NULL,'min',NULL,NULL,7,NULL,NULL),(909,149,'pH',NULL,NULL,'max',NULL,NULL,5.5,NULL,NULL),(910,150,'pH',NULL,NULL,'max',NULL,NULL,7.4,NULL,NULL),(911,151,'pH',NULL,NULL,'max',NULL,NULL,7.5,NULL,NULL),(912,152,'pH',NULL,NULL,'max',NULL,NULL,7.5,NULL,NULL),(913,153,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(914,153,'mass_relative_mass',913,913,'mean',NULL,NULL,1,NULL,NULL),(915,153,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(916,154,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(917,154,'mass_relative_mass',916,916,'mean',NULL,NULL,1,NULL,NULL),(918,154,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(919,155,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(920,155,'mass_relative_mass',919,919,'mean',NULL,NULL,1,NULL,NULL),(921,155,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(922,156,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(923,156,'mass_relative_mass',922,922,'mean',NULL,NULL,1,NULL,NULL),(924,156,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(925,157,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(926,157,'mass_relative_mass',925,925,'mean',NULL,NULL,1,NULL,NULL),(927,157,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(928,158,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(929,158,'mass_relative_mass',928,928,'mean',NULL,NULL,1,NULL,NULL),(930,158,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(931,159,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(932,159,'mass_relative_mass',931,931,'mean',NULL,NULL,1,NULL,NULL),(933,159,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(934,160,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(935,160,'mass_relative_mass',934,934,'mean',NULL,NULL,1,NULL,NULL),(936,160,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(937,161,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(938,161,'mass_relative_mass',937,937,'mean',NULL,NULL,1,NULL,NULL),(939,161,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(940,162,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(941,162,'mass_relative_mass',940,940,'mean',NULL,NULL,1,NULL,NULL),(942,162,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(943,163,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(944,163,'mass_relative_mass',943,943,'mean',NULL,NULL,1,NULL,NULL),(945,163,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(946,164,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(947,164,'mass_relative_mass',946,946,'mean',NULL,NULL,1,NULL,NULL),(948,164,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(949,165,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(950,165,'mass_relative_mass',949,949,'mean',NULL,NULL,1,NULL,NULL),(951,165,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(952,166,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(953,166,'mass_relative_mass',952,952,'mean',NULL,NULL,1,NULL,NULL),(954,166,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(955,167,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(956,167,'mass_relative_mass',955,955,'mean',NULL,NULL,1,NULL,NULL),(957,167,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(958,168,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(959,168,'mass_relative_mass',958,958,'mean',NULL,NULL,1,NULL,NULL),(960,168,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(961,169,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(962,169,'mass_relative_mass',961,961,'mean',NULL,NULL,1,NULL,NULL),(963,169,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(964,170,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(965,170,'mass_relative_mass',964,964,'mean',NULL,NULL,1,NULL,NULL),(966,170,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(967,171,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(968,171,'mass_relative_mass',967,967,'mean',NULL,NULL,1,NULL,NULL),(969,171,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(970,172,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(971,172,'mass_relative_mass',970,970,'mean',NULL,NULL,1,NULL,NULL),(972,172,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(973,173,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(974,173,'mass_relative_mass',973,973,'mean',NULL,NULL,1,NULL,NULL),(975,173,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(976,174,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(977,174,'mass_relative_mass',976,976,'mean',NULL,NULL,1,NULL,NULL),(978,174,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(979,175,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(980,175,'mass_relative_mass',979,979,'mean',NULL,NULL,1,NULL,NULL),(981,175,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(982,176,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(983,176,'mass_relative_mass',982,982,'mean',NULL,NULL,1,NULL,NULL),(984,176,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(985,177,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(986,177,'mass_relative_mass',985,985,'mean',NULL,NULL,1,NULL,NULL),(987,177,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(988,178,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(989,178,'mass_relative_mass',988,988,'mean',NULL,NULL,1,NULL,NULL),(990,178,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(991,179,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(992,179,'mass_relative_mass',991,991,'mean',NULL,NULL,1,NULL,NULL),(993,179,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(994,180,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(995,180,'mass_relative_mass',994,994,'mean',NULL,NULL,1,NULL,NULL),(996,180,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(997,181,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(998,181,'mass_relative_mass',997,997,'mean',NULL,NULL,1,NULL,NULL),(999,181,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1000,182,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1001,182,'mass_relative_mass',1000,1000,'mean',NULL,NULL,1,NULL,NULL),(1002,182,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1003,183,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1004,183,'mass_relative_mass',1003,1003,'mean',NULL,NULL,1,NULL,NULL),(1005,183,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1006,184,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1007,184,'mass_relative_mass',1006,1006,'mean',NULL,NULL,1,NULL,NULL),(1008,184,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1009,185,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1010,185,'mass_relative_mass',1009,1009,'mean',NULL,NULL,1,NULL,NULL),(1011,185,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1012,186,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1013,186,'mass_relative_mass',1012,1012,'mean',NULL,NULL,1,NULL,NULL),(1014,186,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1015,187,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1016,187,'mass_relative_mass',1015,1015,'mean',NULL,NULL,1,NULL,NULL),(1017,187,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1018,188,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1019,188,'mass_relative_mass',1018,1018,'mean',NULL,NULL,1,NULL,NULL),(1020,188,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1021,189,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1022,189,'mass_relative_mass',1021,1021,'mean',NULL,NULL,1,NULL,NULL),(1023,189,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1024,190,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1025,190,'mass_relative_mass',1024,1024,'mean',NULL,NULL,1,NULL,NULL),(1026,190,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1027,191,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1028,191,'mass_relative_mass',1027,1027,'mean',NULL,NULL,1,NULL,NULL),(1029,191,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1030,192,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1031,192,'mass_relative_mass',1030,1030,'mean',NULL,NULL,1,NULL,NULL),(1032,192,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1033,193,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1034,193,'mass_relative_mass',1033,913,'mean',NULL,NULL,0.57,NULL,NULL),(1035,193,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1036,194,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1037,194,'mass_relative_mass',1036,916,'mean',NULL,NULL,0.46,NULL,NULL),(1038,194,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1039,195,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1040,195,'mass_relative_mass',1039,919,'mean',NULL,NULL,0.55,NULL,NULL),(1041,195,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1042,196,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1043,196,'mass_relative_mass',1042,922,'mean',NULL,NULL,0.65,NULL,NULL),(1044,196,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1045,197,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1046,197,'mass_relative_mass',1045,925,'mean',NULL,NULL,0.77,NULL,NULL),(1047,197,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1048,198,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1049,198,'mass_relative_mass',1048,928,'mean',NULL,NULL,0.89,NULL,NULL),(1050,198,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1051,199,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1052,199,'mass_relative_mass',1051,931,'mean',NULL,NULL,0.2,NULL,NULL),(1053,199,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1054,200,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1055,200,'mass_relative_mass',1054,934,'mean',NULL,NULL,0.97,NULL,NULL),(1056,200,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1057,201,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1058,201,'mass_relative_mass',1057,937,'mean',NULL,NULL,0.93,NULL,NULL),(1059,201,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1060,202,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1061,202,'mass_relative_mass',1060,940,'mean',NULL,NULL,0.95,NULL,NULL),(1062,202,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1063,203,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1064,203,'mass_relative_mass',1063,943,'mean',NULL,NULL,0.72,NULL,NULL),(1065,203,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1066,204,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1067,204,'mass_relative_mass',1066,946,'mean',NULL,NULL,0.84,NULL,NULL),(1068,204,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1069,205,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1070,205,'mass_relative_mass',1069,949,'mean',NULL,NULL,0.91,NULL,NULL),(1071,205,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1072,206,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1073,206,'mass_relative_mass',1072,952,'mean',NULL,NULL,0.95,NULL,NULL),(1074,206,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1075,207,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1076,207,'mass_relative_mass',1075,955,'mean',NULL,NULL,0.95,NULL,NULL),(1077,207,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1078,208,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1079,208,'mass_relative_mass',1078,958,'mean',NULL,NULL,0.95,NULL,NULL),(1080,208,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1081,209,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1082,209,'mass_relative_mass',1081,961,'mean',NULL,NULL,0.95,NULL,NULL),(1083,209,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1084,210,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1085,210,'mass_relative_mass',1084,964,'mean',NULL,NULL,0.97,NULL,NULL),(1086,210,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1087,211,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1088,211,'mass_relative_mass',1087,967,'mean',NULL,NULL,0.98,NULL,NULL),(1089,211,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1090,212,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1091,212,'mass_relative_mass',1090,970,'mean',NULL,NULL,0.98,NULL,NULL),(1092,212,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1093,213,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1094,213,'mass_relative_mass',1093,973,'mean',NULL,NULL,0.32,NULL,NULL),(1095,213,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1096,214,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1097,214,'mass_relative_mass',1096,976,'mean',NULL,NULL,0.38,NULL,NULL),(1098,214,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1099,215,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1100,215,'mass_relative_mass',1099,979,'mean',NULL,NULL,0.52,NULL,NULL),(1101,215,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1102,216,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1103,216,'mass_relative_mass',1102,982,'mean',NULL,NULL,0.61,NULL,NULL),(1104,216,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1105,217,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1106,217,'mass_relative_mass',1105,985,'mean',NULL,NULL,0.71,NULL,NULL),(1107,217,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1108,218,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1109,218,'mass_relative_mass',1108,988,'mean',NULL,NULL,0.79,NULL,NULL),(1110,218,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1111,219,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1112,219,'mass_relative_mass',1111,991,'mean',NULL,NULL,0.84,NULL,NULL),(1113,219,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1114,220,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1115,220,'mass_relative_mass',1114,994,'mean',NULL,NULL,0.89,NULL,NULL),(1116,220,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1117,221,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1118,221,'mass_relative_mass',1117,997,'mean',NULL,NULL,0.94,NULL,NULL),(1119,221,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1120,222,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1121,222,'mass_relative_mass',1120,1000,'mean',NULL,NULL,0.95,NULL,NULL),(1122,222,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1123,223,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1124,223,'mass_relative_mass',1123,1003,'mean',NULL,NULL,0.95,NULL,NULL),(1125,223,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1126,224,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1127,224,'mass_relative_mass',1126,1006,'mean',NULL,NULL,0.98,NULL,NULL),(1128,224,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1129,225,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1130,225,'mass_relative_mass',1129,1009,'mean',NULL,NULL,0.97,NULL,NULL),(1131,225,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1132,226,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1133,226,'mass_relative_mass',1132,1012,'mean',NULL,NULL,0.97,NULL,NULL),(1134,226,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1135,227,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1136,227,'mass_relative_mass',1135,1015,'mean',NULL,NULL,0.99,NULL,NULL),(1137,227,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1138,228,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1139,228,'mass_relative_mass',1138,1018,'mean',NULL,NULL,0.95,NULL,NULL),(1140,228,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1141,229,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1142,229,'mass_relative_mass',1141,1021,'mean',NULL,NULL,0.97,NULL,NULL),(1143,229,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1144,230,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1145,230,'mass_relative_mass',1144,1024,'mean',NULL,NULL,0.99,NULL,NULL),(1146,230,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1147,231,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1148,231,'mass_relative_mass',1147,1027,'mean',NULL,NULL,0.97,NULL,NULL),(1149,231,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1150,232,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1151,232,'mass_relative_mass',1150,1030,'mean',NULL,NULL,0.99,NULL,NULL),(1152,232,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.55,NULL,NULL),(1153,233,'water_table_depth',NULL,NULL,'mean',NULL,41,44,NULL,'Approximate position of the water table depth defined as sulfide horizon. Computed by adding the average height of hummocks to the value for hollows.'),(1154,234,'water_table_depth',NULL,NULL,'mean',NULL,41,11,NULL,'Approximate position of the water table depth defined as sulfide horizon.'),(1155,235,'water_table_depth',NULL,NULL,'mean',NULL,47,10,NULL,NULL),(1156,236,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1157,236,'mass_relative_mass',1156,1156,'mean',NULL,NULL,1,NULL,NULL),(1158,236,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(1159,237,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1160,237,'mass_relative_mass',1159,1159,'mean',NULL,NULL,1,NULL,NULL),(1161,237,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(1162,238,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1163,238,'mass_relative_mass',1162,1162,'mean',NULL,NULL,1,NULL,NULL),(1164,238,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(1165,239,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1166,239,'mass_relative_mass',1165,1165,'mean',NULL,NULL,1,NULL,NULL),(1167,239,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(1168,240,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1169,240,'mass_relative_mass',1168,1168,'mean',NULL,NULL,1,NULL,NULL),(1170,240,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(1171,241,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1172,241,'mass_relative_mass',1171,1171,'mean',NULL,NULL,1,NULL,NULL),(1173,241,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(1174,242,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1175,242,'mass_relative_mass',1174,1174,'mean',NULL,NULL,1,NULL,NULL),(1176,242,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(1177,243,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1178,243,'mass_relative_mass',1177,1156,'mean',NULL,NULL,0.9088607594936708,NULL,NULL),(1179,243,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(1180,244,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1181,244,'mass_relative_mass',1180,1159,'mean',NULL,NULL,0.9025316455696202,NULL,NULL),(1182,244,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(1183,245,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1184,245,'mass_relative_mass',1183,1162,'mean',NULL,NULL,0.8,NULL,NULL),(1185,245,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(1186,246,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1187,246,'mass_relative_mass',1186,1156,'mean',NULL,NULL,0.8772151898734176,NULL,NULL),(1188,246,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(1189,247,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1190,247,'mass_relative_mass',1189,1159,'mean',NULL,NULL,0.8177215189873417,NULL,NULL),(1191,247,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(1192,248,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1193,248,'mass_relative_mass',1192,1162,'mean',NULL,NULL,0.7481012658227847,NULL,NULL),(1194,248,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(1195,249,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1196,249,'mass_relative_mass',1195,1156,'mean',NULL,NULL,0.8594936708860759,NULL,NULL),(1197,249,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(1198,250,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1199,250,'mass_relative_mass',1198,1159,'mean',NULL,NULL,0.8,NULL,NULL),(1200,250,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(1201,251,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1202,251,'mass_relative_mass',1201,1162,'mean',NULL,NULL,0.7392405063291139,NULL,NULL),(1203,251,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(1204,252,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1205,252,'mass_relative_mass',1204,1165,'mean',NULL,NULL,0.9025316455696202,NULL,NULL),(1206,252,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(1207,253,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1208,253,'mass_relative_mass',1207,1168,'mean',NULL,NULL,0.8594936708860759,NULL,NULL),(1209,253,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(1210,254,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1211,254,'mass_relative_mass',1210,1171,'mean',NULL,NULL,0.8924050632911391,NULL,NULL),(1212,254,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(1213,255,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1214,255,'mass_relative_mass',1213,1174,'mean',NULL,NULL,0.860759493670886,NULL,NULL),(1215,255,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(1216,256,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1217,256,'mass_relative_mass',1216,1165,'mean',NULL,NULL,0.6683544303797468,NULL,NULL),(1218,256,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(1219,257,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1220,257,'mass_relative_mass',1219,1168,'mean',NULL,NULL,0.6582278481012659,NULL,NULL),(1221,257,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(1222,258,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1223,258,'mass_relative_mass',1222,1171,'mean',NULL,NULL,0.6772151898734177,NULL,NULL),(1224,258,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(1225,259,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1226,259,'mass_relative_mass',1225,1174,'mean',NULL,NULL,0.6075949367088608,NULL,NULL),(1227,259,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(1228,260,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,0.1607142857142918,NULL),(1229,260,'bulk_density',NULL,NULL,'mean',NULL,NULL,0.067,0.1607142857142918,NULL),(1230,260,'ash_mass_relative_mass',1231,1228,'mean',NULL,NULL,0.076,0.1607142857142918,NULL),(1231,260,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,0.1607142857142918,NULL),(1232,260,'P_relative_mass',1236,1228,'mean',NULL,NULL,0.001,0.1607142857142918,NULL),(1233,260,'N_relative_mass',1237,1228,'mean',NULL,NULL,0.01,0.1607142857142918,NULL),(1234,260,'K_relative_mass',1238,1228,'mean',NULL,NULL,0.0021,0.1607142857142918,NULL),(1235,260,'C_relative_mass',1239,1228,'mean',NULL,NULL,0.406,0.1607142857142918,NULL),(1236,260,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,0.1607142857142918,NULL),(1237,260,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,0.1607142857142918,NULL),(1238,260,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,0.1607142857142918,NULL),(1239,260,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,0.1607142857142918,NULL),(1240,261,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,0.3214285714285694,NULL),(1241,261,'bulk_density',NULL,NULL,'mean',NULL,NULL,0.102,0.3214285714285694,NULL),(1242,261,'ash_mass_relative_mass',1243,1240,'mean',NULL,NULL,0.051,0.3214285714285694,NULL),(1243,261,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,0.3214285714285694,NULL),(1244,261,'P_relative_mass',1248,1240,'mean',NULL,NULL,0.0009,0.3214285714285694,NULL),(1245,261,'N_relative_mass',1249,1240,'mean',NULL,NULL,0.016,0.3214285714285694,NULL),(1246,261,'K_relative_mass',1250,1240,'mean',NULL,NULL,0.001,0.3214285714285694,NULL),(1247,261,'C_relative_mass',1251,1240,'mean',NULL,NULL,0.414,0.3214285714285694,NULL),(1248,261,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,0.3214285714285694,NULL),(1249,261,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,0.3214285714285694,NULL),(1250,261,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,0.3214285714285694,NULL),(1251,261,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,0.3214285714285694,NULL),(1252,262,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,0.21428571428571885,NULL),(1253,262,'bulk_density',NULL,NULL,'mean',NULL,NULL,0.083,0.21428571428571885,NULL),(1254,262,'ash_mass_relative_mass',1255,1252,'mean',NULL,NULL,0.054000000000000006,0.21428571428571885,NULL),(1255,262,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,0.21428571428571885,NULL),(1256,262,'P_relative_mass',1260,1252,'mean',NULL,NULL,0.0004,0.21428571428571885,NULL),(1257,262,'N_relative_mass',1261,1252,'mean',NULL,NULL,0.013000000000000001,0.21428571428571885,NULL),(1258,262,'K_relative_mass',1262,1252,'mean',NULL,NULL,0.0004,0.21428571428571885,NULL),(1259,262,'C_relative_mass',1263,1252,'mean',NULL,NULL,0.415,0.21428571428571885,NULL),(1260,262,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,0.21428571428571885,NULL),(1261,262,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,0.21428571428571885,NULL),(1262,262,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,0.21428571428571885,NULL),(1263,262,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,0.21428571428571885,NULL),(1264,263,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,0.1607142857142918,NULL),(1265,263,'mass_relative_mass',1264,1264,'mean',NULL,6,1,0.1607142857142918,NULL),(1266,263,'temperature',NULL,NULL,'point',NULL,NULL,281.15,0.1607142857142918,NULL),(1267,263,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,0.1607142857142918,NULL),(1268,264,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,0.3214285714285694,NULL),(1269,264,'mass_relative_mass',1268,1268,'mean',NULL,6,1,0.3214285714285694,NULL),(1270,264,'temperature',NULL,NULL,'point',NULL,NULL,281.15,0.3214285714285694,NULL),(1271,264,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,0.3214285714285694,NULL),(1272,265,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,0.21428571428571885,NULL),(1273,265,'mass_relative_mass',1272,1272,'mean',NULL,6,1,0.21428571428571885,NULL),(1274,265,'temperature',NULL,NULL,'point',NULL,NULL,281.15,0.21428571428571885,NULL),(1275,265,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,0.21428571428571885,NULL),(1276,266,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,0.8571428571428505,NULL),(1277,266,'mass_relative_mass',1276,1276,'mean',NULL,6,1,0.8571428571428505,NULL),(1278,266,'temperature',NULL,NULL,'point',NULL,NULL,289.15,0.8571428571428505,NULL),(1279,266,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,0.8571428571428505,NULL),(1280,267,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,0.48214285714285765,NULL),(1281,267,'mass_relative_mass',1280,1280,'mean',NULL,6,1,0.48214285714285765,NULL),(1282,267,'temperature',NULL,NULL,'point',NULL,NULL,289.15,0.48214285714285765,NULL),(1283,267,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,0.48214285714285765,NULL),(1284,268,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,0.21428571428571885,NULL),(1285,268,'mass_relative_mass',1284,1284,'mean',NULL,6,1,0.21428571428571885,NULL),(1286,268,'temperature',NULL,NULL,'point',NULL,NULL,289.15,0.21428571428571885,NULL),(1287,268,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,0.21428571428571885,NULL),(1288,269,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,0.37499999999999645,NULL),(1289,269,'mass_relative_mass',1288,1288,'mean',NULL,6,1,0.37499999999999645,NULL),(1290,269,'temperature',NULL,NULL,'point',NULL,NULL,297.15,0.37499999999999645,NULL),(1291,269,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,0.37499999999999645,NULL),(1292,270,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,0.5357142857142847,NULL),(1293,270,'mass_relative_mass',1292,1292,'mean',NULL,6,1,0.5357142857142847,NULL),(1294,270,'temperature',NULL,NULL,'point',NULL,NULL,297.15,0.5357142857142847,NULL),(1295,270,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,0.5357142857142847,NULL),(1296,271,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,0.1607142857142847,NULL),(1297,271,'mass_relative_mass',1296,1296,'mean',NULL,6,1,0.1607142857142847,NULL),(1298,271,'temperature',NULL,NULL,'point',NULL,NULL,297.15,0.1607142857142847,NULL),(1299,271,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,0.1607142857142847,NULL),(1300,272,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,1.427312775330396,NULL),(1301,272,'mass_relative_mass',1300,1300,'mean',NULL,6,1,1.427312775330396,NULL),(1302,272,'temperature',NULL,NULL,'point',NULL,NULL,281.15,1.427312775330396,NULL),(1303,272,'water_table_depth',NULL,NULL,'point',NULL,NULL,NULL,1.427312775330396,NULL),(1304,273,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,0.5814977973568283,NULL),(1305,273,'mass_relative_mass',1304,1304,'mean',NULL,6,1,0.5814977973568283,NULL),(1306,273,'temperature',NULL,NULL,'point',NULL,NULL,281.15,0.5814977973568283,NULL),(1307,273,'water_table_depth',NULL,NULL,'point',NULL,NULL,NULL,0.5814977973568283,NULL),(1308,274,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,0.4229074889867874,NULL),(1309,274,'mass_relative_mass',1308,1308,'mean',NULL,6,1,0.4229074889867874,NULL),(1310,274,'temperature',NULL,NULL,'point',NULL,NULL,281.15,0.4229074889867874,NULL),(1311,274,'water_table_depth',NULL,NULL,'point',NULL,NULL,NULL,0.4229074889867874,NULL),(1312,275,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,0.4757709251101332,NULL),(1313,275,'mass_relative_mass',1312,1312,'mean',NULL,6,1,0.4757709251101332,NULL),(1314,275,'temperature',NULL,NULL,'point',NULL,NULL,289.15,0.4757709251101332,NULL),(1315,275,'water_table_depth',NULL,NULL,'point',NULL,NULL,NULL,0.4757709251101332,NULL),(1316,276,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,0.42290748898678565,NULL),(1317,276,'mass_relative_mass',1316,1316,'mean',NULL,6,1,0.42290748898678565,NULL),(1318,276,'temperature',NULL,NULL,'point',NULL,NULL,289.15,0.42290748898678565,NULL),(1319,276,'water_table_depth',NULL,NULL,'point',NULL,NULL,NULL,0.42290748898678565,NULL),(1320,277,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,0.2643171806167395,NULL),(1321,277,'mass_relative_mass',1320,1320,'mean',NULL,6,1,0.2643171806167395,NULL),(1322,277,'temperature',NULL,NULL,'point',NULL,NULL,289.15,0.2643171806167395,NULL),(1323,277,'water_table_depth',NULL,NULL,'point',NULL,NULL,NULL,0.2643171806167395,NULL),(1324,278,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,1.3215859030836974,NULL),(1325,278,'mass_relative_mass',1324,1324,'mean',NULL,6,1,1.3215859030836974,NULL),(1326,278,'temperature',NULL,NULL,'point',NULL,NULL,297.15,1.3215859030836974,NULL),(1327,278,'water_table_depth',NULL,NULL,'point',NULL,NULL,NULL,1.3215859030836974,NULL),(1328,279,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,0.7400881057268744,NULL),(1329,279,'mass_relative_mass',1328,1328,'mean',NULL,6,1,0.7400881057268744,NULL),(1330,279,'temperature',NULL,NULL,'point',NULL,NULL,297.15,0.7400881057268744,NULL),(1331,279,'water_table_depth',NULL,NULL,'point',NULL,NULL,NULL,0.7400881057268744,NULL),(1332,280,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,0.3700440528634328,NULL),(1333,280,'mass_relative_mass',1332,1332,'mean',NULL,6,1,0.3700440528634328,NULL),(1334,280,'temperature',NULL,NULL,'point',NULL,NULL,297.15,0.3700440528634328,NULL),(1335,280,'water_table_depth',NULL,NULL,'point',NULL,NULL,NULL,0.3700440528634328,NULL),(1336,281,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,NULL,NULL),(1337,281,'mass_relative_mass',1336,1264,'mean','se',6,0.9748214285714285,0.1607142857142918,NULL),(1338,281,'temperature',NULL,NULL,'point',NULL,NULL,281.15,NULL,NULL),(1339,281,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,NULL),(1340,282,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,NULL,NULL),(1341,282,'mass_relative_mass',1340,1268,'mean','se',6,0.9876785714285714,0.3214285714285694,NULL),(1342,282,'temperature',NULL,NULL,'point',NULL,NULL,281.15,NULL,NULL),(1343,282,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,NULL),(1344,283,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,NULL,NULL),(1345,283,'mass_relative_mass',1344,1272,'mean','se',6,0.9978571428571428,0.21428571428571885,NULL),(1346,283,'temperature',NULL,NULL,'point',NULL,NULL,281.15,NULL,NULL),(1347,283,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,NULL),(1348,284,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,NULL,NULL),(1349,284,'mass_relative_mass',1348,1276,'mean','se',6,0.9496428571428569,0.8571428571428505,NULL),(1350,284,'temperature',NULL,NULL,'point',NULL,NULL,289.15,NULL,NULL),(1351,284,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,NULL),(1352,285,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,NULL,NULL),(1353,285,'mass_relative_mass',1352,1280,'mean','se',6,0.9775,0.48214285714285765,NULL),(1354,285,'temperature',NULL,NULL,'point',NULL,NULL,289.15,NULL,NULL),(1355,285,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,NULL),(1356,286,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,NULL,NULL),(1357,286,'mass_relative_mass',1356,1284,'mean','se',6,0.99625,0.21428571428571885,NULL),(1358,286,'temperature',NULL,NULL,'point',NULL,NULL,289.15,NULL,NULL),(1359,286,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,NULL),(1360,287,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,NULL,NULL),(1361,287,'mass_relative_mass',1360,1288,'mean','se',6,0.9571428571428571,0.37499999999999645,NULL),(1362,287,'temperature',NULL,NULL,'point',NULL,NULL,297.15,NULL,NULL),(1363,287,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,NULL),(1364,288,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,NULL,NULL),(1365,288,'mass_relative_mass',1364,1292,'mean','se',6,0.9817857142857142,0.5357142857142847,NULL),(1366,288,'temperature',NULL,NULL,'point',NULL,NULL,297.15,NULL,NULL),(1367,288,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,NULL),(1368,289,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,NULL,NULL),(1369,289,'mass_relative_mass',1368,1296,'mean','se',6,0.994642857142857,0.1607142857142847,NULL),(1370,289,'temperature',NULL,NULL,'point',NULL,NULL,297.15,NULL,NULL),(1371,289,'water_table_depth',NULL,NULL,'point',NULL,NULL,0,NULL,NULL),(1372,290,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,NULL,NULL),(1373,290,'mass_relative_mass',1372,1300,'mean','se',6,0.9629955947136564,1.427312775330396,NULL),(1374,290,'temperature',NULL,NULL,'point',NULL,NULL,281.15,NULL,NULL),(1375,290,'water_table_depth',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(1376,291,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,NULL,NULL),(1377,291,'mass_relative_mass',1376,1304,'mean','se',6,0.9841409691629955,0.5814977973568283,NULL),(1378,291,'temperature',NULL,NULL,'point',NULL,NULL,281.15,NULL,NULL),(1379,291,'water_table_depth',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(1380,292,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,NULL,NULL),(1381,292,'mass_relative_mass',1380,1308,'mean','se',6,0.9973568281938325,0.4229074889867874,NULL),(1382,292,'temperature',NULL,NULL,'point',NULL,NULL,281.15,NULL,NULL),(1383,292,'water_table_depth',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(1384,293,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,NULL,NULL),(1385,293,'mass_relative_mass',1384,1312,'mean','se',6,0.9312775330396476,0.4757709251101332,NULL),(1386,293,'temperature',NULL,NULL,'point',NULL,NULL,289.15,NULL,NULL),(1387,293,'water_table_depth',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(1388,294,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,NULL,NULL),(1389,294,'mass_relative_mass',1388,1316,'mean','se',6,0.9836123348017621,0.42290748898678565,NULL),(1390,294,'temperature',NULL,NULL,'point',NULL,NULL,289.15,NULL,NULL),(1391,294,'water_table_depth',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(1392,295,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,NULL,NULL),(1393,295,'mass_relative_mass',1392,1320,'mean','se',6,0.9941850220264317,0.2643171806167395,NULL),(1394,295,'temperature',NULL,NULL,'point',NULL,NULL,289.15,NULL,NULL),(1395,295,'water_table_depth',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(1396,296,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,NULL,NULL),(1397,296,'mass_relative_mass',1396,1324,'mean','se',6,0.8963876651982379,1.3215859030836974,NULL),(1398,296,'temperature',NULL,NULL,'point',NULL,NULL,297.15,NULL,NULL),(1399,296,'water_table_depth',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(1400,297,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,NULL,NULL),(1401,297,'mass_relative_mass',1400,1328,'mean','se',6,0.9608810572687224,0.7400881057268744,NULL),(1402,297,'temperature',NULL,NULL,'point',NULL,NULL,297.15,NULL,NULL),(1403,297,'water_table_depth',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(1404,298,'mass_absolute',NULL,NULL,'mean',NULL,6,NULL,NULL,NULL),(1405,298,'mass_relative_mass',1404,1332,'mean','se',6,0.9931277533039647,0.3700440528634328,NULL),(1406,298,'temperature',NULL,NULL,'point',NULL,NULL,297.15,NULL,NULL),(1407,298,'water_table_depth',NULL,NULL,'point',NULL,NULL,NULL,NULL,NULL),(1408,299,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1409,299,'mass_relative_mass',1408,1408,'point',NULL,1,1,NULL,NULL),(1410,300,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1411,300,'mass_relative_mass',1410,1410,'point',NULL,1,1,NULL,NULL),(1412,301,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1413,301,'mass_relative_mass',1412,1412,'point',NULL,1,1,NULL,NULL),(1414,302,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1415,302,'mass_relative_mass',1414,1414,'point',NULL,1,1,NULL,NULL),(1416,303,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1417,303,'mass_relative_mass',1416,1416,'point',NULL,1,1,NULL,NULL),(1418,304,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1419,304,'mass_relative_mass',1418,1418,'point',NULL,1,1,NULL,NULL),(1420,305,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1421,305,'mass_relative_mass',1420,1420,'point',NULL,1,1,NULL,NULL),(1422,306,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1423,306,'mass_relative_mass',1422,1422,'point',NULL,1,1,NULL,NULL),(1424,307,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1425,307,'mass_relative_mass',1424,1424,'point',NULL,1,1,NULL,NULL),(1426,308,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1427,308,'mass_relative_mass',1426,1426,'point',NULL,1,1,NULL,NULL),(1428,309,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1429,309,'mass_relative_mass',1428,1428,'point',NULL,1,1,NULL,NULL),(1430,310,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1431,310,'mass_relative_mass',1430,1430,'point',NULL,1,1,NULL,NULL),(1432,311,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1433,311,'mass_relative_mass',1432,1432,'point',NULL,1,1,NULL,NULL),(1434,312,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1435,312,'mass_relative_mass',1434,1434,'point',NULL,1,1,NULL,NULL),(1436,313,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1437,313,'mass_relative_mass',1436,1436,'point',NULL,1,1,NULL,NULL),(1438,314,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1439,314,'mass_relative_mass',1438,1438,'point',NULL,1,1,NULL,NULL),(1440,315,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1441,315,'mass_relative_mass',1440,1440,'point',NULL,1,1,NULL,NULL),(1442,316,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1443,316,'mass_relative_mass',1442,1442,'point',NULL,1,1,NULL,NULL),(1444,317,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1445,317,'mass_relative_mass',1444,1444,'point',NULL,1,1,NULL,NULL),(1446,318,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1447,318,'mass_relative_mass',1446,1446,'point',NULL,1,1,NULL,NULL),(1448,319,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1449,319,'mass_relative_mass',1448,1448,'point',NULL,1,1,NULL,NULL),(1450,320,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1451,320,'mass_relative_mass',1450,1450,'point',NULL,1,1,NULL,NULL),(1452,321,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1453,321,'mass_relative_mass',1452,1452,'point',NULL,1,1,NULL,NULL),(1454,322,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1455,322,'mass_relative_mass',1454,1454,'point',NULL,1,1,NULL,NULL),(1456,323,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1457,323,'mass_relative_mass',1456,1456,'point',NULL,1,1,NULL,NULL),(1458,324,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1459,324,'mass_relative_mass',1458,1458,'point',NULL,1,1,NULL,NULL),(1460,325,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1461,325,'mass_relative_mass',1460,1460,'point',NULL,1,1,NULL,NULL),(1462,326,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1463,326,'mass_relative_mass',1462,1462,'point',NULL,1,1,NULL,NULL),(1464,327,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1465,327,'mass_relative_mass',1464,1464,'point',NULL,1,1,NULL,NULL),(1466,328,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1467,328,'mass_relative_mass',1466,1466,'point',NULL,1,1,NULL,NULL),(1468,329,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1469,329,'mass_relative_mass',1468,1468,'point',NULL,1,1,NULL,NULL),(1470,330,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1471,330,'mass_relative_mass',1470,1470,'point',NULL,1,1,NULL,NULL),(1472,331,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1473,331,'mass_relative_mass',1472,1472,'point',NULL,1,1,NULL,NULL),(1474,332,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1475,332,'mass_relative_mass',1474,1474,'point',NULL,1,1,NULL,NULL),(1476,333,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1477,333,'mass_relative_mass',1476,1476,'point',NULL,1,1,NULL,NULL),(1478,334,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1479,334,'mass_relative_mass',1478,1478,'point',NULL,1,1,NULL,NULL),(1480,335,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1481,335,'mass_relative_mass',1480,1480,'point',NULL,1,1,NULL,NULL),(1482,336,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1483,336,'mass_relative_mass',1482,1482,'point',NULL,1,1,NULL,NULL),(1484,337,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1485,337,'mass_relative_mass',1484,1484,'point',NULL,1,1,NULL,NULL),(1486,338,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1487,338,'mass_relative_mass',1486,1486,'point',NULL,1,1,NULL,NULL),(1488,339,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1489,339,'mass_relative_mass',1488,1488,'point',NULL,1,1,NULL,NULL),(1490,340,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1491,340,'mass_relative_mass',1490,1490,'point',NULL,1,1,NULL,NULL),(1492,341,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1493,341,'mass_relative_mass',1492,1492,'point',NULL,1,1,NULL,NULL),(1494,342,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1495,342,'mass_relative_mass',1494,1494,'point',NULL,1,1,NULL,NULL),(1496,343,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1497,343,'mass_relative_mass',1496,1496,'point',NULL,1,1,NULL,NULL),(1498,344,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1499,344,'mass_relative_mass',1498,1498,'point',NULL,1,1,NULL,NULL),(1500,345,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1501,345,'mass_relative_mass',1500,1500,'point',NULL,1,1,NULL,NULL),(1502,346,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1503,346,'mass_relative_mass',1502,1502,'point',NULL,1,1,NULL,NULL),(1504,347,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1505,347,'mass_relative_mass',1504,1504,'point',NULL,1,1,NULL,NULL),(1506,348,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1507,348,'mass_relative_mass',1506,1506,'point',NULL,1,1,NULL,NULL),(1508,349,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1509,349,'mass_relative_mass',1508,1508,'point',NULL,1,1,NULL,NULL),(1510,350,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1511,350,'mass_relative_mass',1510,1510,'point',NULL,1,1,NULL,NULL),(1512,351,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1513,351,'mass_relative_mass',1512,1512,'point',NULL,1,1,NULL,NULL),(1514,352,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1515,352,'mass_relative_mass',1514,1514,'point',NULL,1,1,NULL,NULL),(1516,353,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1517,353,'mass_relative_mass',1516,1516,'point',NULL,1,1,NULL,NULL),(1518,354,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1519,354,'mass_relative_mass',1518,1518,'point',NULL,1,1,NULL,NULL),(1520,355,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1521,355,'mass_relative_mass',1520,1520,'point',NULL,1,1,NULL,NULL),(1522,356,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1523,356,'mass_relative_mass',1522,1522,'point',NULL,1,1,NULL,NULL),(1524,357,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1525,357,'mass_relative_mass',1524,1524,'point',NULL,1,1,NULL,NULL),(1526,358,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1527,358,'mass_relative_mass',1526,1526,'point',NULL,1,1,NULL,NULL),(1528,359,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1529,359,'mass_relative_mass',1528,1528,'point',NULL,1,1,NULL,NULL),(1530,360,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1531,360,'mass_relative_mass',1530,1530,'point',NULL,1,1,NULL,NULL),(1532,361,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1533,361,'mass_relative_mass',1532,1532,'point',NULL,1,1,NULL,NULL),(1534,362,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1535,362,'mass_relative_mass',1534,1534,'point',NULL,1,1,NULL,NULL),(1536,363,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1537,363,'mass_relative_mass',1536,1536,'point',NULL,1,1,NULL,NULL),(1538,364,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1539,364,'mass_relative_mass',1538,1538,'point',NULL,1,1,NULL,NULL),(1540,365,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1541,365,'mass_relative_mass',1540,1540,'point',NULL,1,1,NULL,NULL),(1542,366,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1543,366,'mass_relative_mass',1542,1542,'point',NULL,1,1,NULL,NULL),(1544,367,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1545,367,'mass_relative_mass',1544,1544,'point',NULL,1,1,NULL,NULL),(1546,368,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1547,368,'mass_relative_mass',1546,1546,'point',NULL,1,1,NULL,NULL),(1548,369,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1549,369,'mass_relative_mass',1548,1548,'point',NULL,1,1,NULL,NULL),(1550,370,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1551,370,'mass_relative_mass',1550,1550,'point',NULL,1,1,NULL,NULL),(1552,371,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1553,371,'mass_relative_mass',1552,1408,'point',NULL,1,0.10326086956521752,NULL,NULL),(1554,372,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1555,372,'mass_relative_mass',1554,1410,'point',NULL,1,0.15760869565217406,NULL,NULL),(1556,373,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1557,373,'mass_relative_mass',1556,1412,'point',NULL,1,0.4184782608695652,NULL,NULL),(1558,374,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1559,374,'mass_relative_mass',1558,1414,'point',NULL,1,0.23369565217391297,NULL,NULL),(1560,375,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1561,375,'mass_relative_mass',1560,1416,'point',NULL,1,0.032608695652173836,NULL,NULL),(1562,376,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1563,376,'mass_relative_mass',1562,1418,'point',NULL,1,0.04347826086956519,NULL,NULL),(1564,377,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1565,377,'mass_relative_mass',1564,1420,'point',NULL,1,0.07608695652173902,NULL,NULL),(1566,378,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1567,378,'mass_relative_mass',1566,1422,'point',NULL,1,0.1086956521739132,NULL,NULL),(1568,379,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1569,379,'mass_relative_mass',1568,1424,'point',NULL,1,0.21195652173913038,NULL,NULL),(1570,380,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1571,380,'mass_relative_mass',1570,1426,'point',NULL,1,0.27717391304347827,NULL,NULL),(1572,381,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1573,381,'mass_relative_mass',1572,1428,'point',NULL,1,0.20108695652173914,NULL,NULL),(1574,382,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1575,382,'mass_relative_mass',1574,1430,'point',NULL,1,0.19565217391304368,NULL,NULL),(1576,383,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1577,383,'mass_relative_mass',1576,1432,'point',NULL,1,0.2826086956521734,NULL,NULL),(1578,384,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1579,384,'mass_relative_mass',1578,1434,'point',NULL,1,0.39673913043478304,NULL,NULL),(1580,385,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1581,385,'mass_relative_mass',1580,1436,'point',NULL,1,0.3695652173913042,NULL,NULL),(1582,386,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1583,386,'mass_relative_mass',1582,1438,'point',NULL,1,0.42934782608695665,NULL,NULL),(1584,387,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1585,387,'mass_relative_mass',1584,1440,'point',NULL,1,0.21739130434782616,NULL,NULL),(1586,388,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1587,388,'mass_relative_mass',1586,1442,'point',NULL,1,0.23913043478260843,NULL,NULL),(1588,389,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1589,389,'mass_relative_mass',1588,1444,'point',NULL,1,0.24456521739130466,NULL,NULL),(1590,390,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1591,390,'mass_relative_mass',1590,1446,'point',NULL,1,0.2717391304347826,NULL,NULL),(1592,391,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1593,391,'mass_relative_mass',1592,1448,'point',NULL,1,0.11956521739130443,NULL,NULL),(1594,392,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1595,392,'mass_relative_mass',1594,1450,'point',NULL,1,0.30978260869565233,NULL,NULL),(1596,393,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1597,393,'mass_relative_mass',1596,1452,'point',NULL,1,0.16304347826086962,NULL,NULL),(1598,394,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1599,394,'mass_relative_mass',1598,1454,'point',NULL,1,0.09239130434782605,NULL,NULL),(1600,395,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1601,395,'mass_relative_mass',1600,1456,'point',NULL,1,0.125,NULL,NULL),(1602,396,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1603,396,'mass_relative_mass',1602,1458,'point',NULL,1,0.048913043478260754,NULL,NULL),(1604,397,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1605,397,'mass_relative_mass',1604,1460,'point',NULL,1,0.09782608695652195,NULL,NULL),(1606,398,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1607,398,'mass_relative_mass',1606,1462,'point',NULL,1,0.11956521739130432,NULL,NULL),(1608,399,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1609,399,'mass_relative_mass',1608,1464,'point',NULL,1,0.17934782608695676,NULL,NULL),(1610,400,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1611,400,'mass_relative_mass',1610,1466,'point',NULL,1,0.1576086956521736,NULL,NULL),(1612,401,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1613,401,'mass_relative_mass',1612,1468,'point',NULL,1,0.11413043478260876,NULL,NULL),(1614,402,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1615,402,'mass_relative_mass',1614,1470,'point',NULL,1,0.07608695652173925,NULL,NULL),(1616,403,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1617,403,'mass_relative_mass',1616,1472,'point',NULL,1,0.30434782608695654,NULL,NULL),(1618,404,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1619,404,'mass_relative_mass',1618,1474,'point',NULL,1,0.09782608695652195,NULL,NULL),(1620,405,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1621,405,'mass_relative_mass',1620,1476,'point',NULL,1,0.13586956521739124,NULL,NULL),(1622,406,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1623,406,'mass_relative_mass',1622,1478,'point',NULL,1,0.09782608695652173,NULL,NULL),(1624,407,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1625,407,'mass_relative_mass',1624,1480,'point',NULL,1,0.25240384615384626,NULL,NULL),(1626,408,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1627,408,'mass_relative_mass',1626,1482,'point',NULL,1,0.1694711538461538,NULL,NULL),(1628,409,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1629,409,'mass_relative_mass',1628,1484,'point',NULL,1,0.15504807692307687,NULL,NULL),(1630,410,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1631,410,'mass_relative_mass',1630,1486,'point',NULL,1,0.2379807692307691,NULL,NULL),(1632,411,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1633,411,'mass_relative_mass',1632,1488,'point',NULL,1,0.025240384615384692,NULL,NULL),(1634,412,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1635,412,'mass_relative_mass',1634,1490,'point',NULL,1,0.03245192307692296,NULL,NULL),(1636,413,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1637,413,'mass_relative_mass',1636,1492,'point',NULL,1,0.02163461538461542,NULL,NULL),(1638,414,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1639,414,'mass_relative_mass',1638,1494,'point',NULL,1,0.061298076923076816,NULL,NULL),(1640,415,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1641,415,'mass_relative_mass',1640,1496,'point',NULL,1,0.23437500000000017,NULL,NULL),(1642,416,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1643,416,'mass_relative_mass',1642,1498,'point',NULL,1,0.12620192307692313,NULL,NULL),(1644,417,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1645,417,'mass_relative_mass',1644,1500,'point',NULL,1,0.09014423076923067,NULL,NULL),(1646,418,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1647,418,'mass_relative_mass',1646,1502,'point',NULL,1,0.20552884615384603,NULL,NULL),(1648,419,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1649,419,'mass_relative_mass',1648,1504,'point',NULL,1,0.07572115384615374,NULL,NULL),(1650,420,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1651,420,'mass_relative_mass',1650,1506,'point',NULL,1,0.23076923076923078,NULL,NULL),(1652,421,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1653,421,'mass_relative_mass',1652,1508,'point',NULL,1,0.2776442307692309,NULL,NULL),(1654,422,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1655,422,'mass_relative_mass',1654,1510,'point',NULL,1,0.20552884615384603,NULL,NULL),(1656,423,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1657,423,'mass_relative_mass',1656,1512,'point',NULL,1,0.234375,NULL,NULL),(1658,424,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1659,424,'mass_relative_mass',1658,1514,'point',NULL,1,0.14423076923076922,NULL,NULL),(1660,425,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1661,425,'mass_relative_mass',1660,1516,'point',NULL,1,0.2524038461538462,NULL,NULL),(1662,426,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1663,426,'mass_relative_mass',1662,1518,'point',NULL,1,0.10456730769230749,NULL,NULL),(1664,427,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1665,427,'mass_relative_mass',1664,1520,'point',NULL,1,0.18028846153846145,NULL,NULL),(1666,428,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1667,428,'mass_relative_mass',1666,1522,'point',NULL,1,0.12620192307692318,NULL,NULL),(1668,429,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1669,429,'mass_relative_mass',1668,1524,'point',NULL,1,0.046874999999999944,NULL,NULL),(1670,430,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1671,430,'mass_relative_mass',1670,1526,'point',NULL,1,0.12620192307692296,NULL,NULL),(1672,431,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1673,431,'mass_relative_mass',1672,1528,'point',NULL,1,0.04326923076923078,NULL,NULL),(1674,432,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1675,432,'mass_relative_mass',1674,1530,'point',NULL,1,0.01081730769230771,NULL,NULL),(1676,433,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1677,433,'mass_relative_mass',1676,1532,'point',NULL,1,0.057692307692307654,NULL,NULL),(1678,434,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1679,434,'mass_relative_mass',1678,1534,'point',NULL,1,0.14783653846153838,NULL,NULL),(1680,435,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1681,435,'mass_relative_mass',1680,1536,'point',NULL,1,0.07211538461538469,NULL,NULL),(1682,436,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1683,436,'mass_relative_mass',1682,1538,'point',NULL,1,0.0288461538461538,NULL,NULL),(1684,437,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1685,437,'mass_relative_mass',1684,1540,'point',NULL,1,0.07932692307692313,NULL,NULL),(1686,438,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1687,438,'mass_relative_mass',1686,1542,'point',NULL,1,0.007211538461538269,NULL,NULL),(1688,439,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1689,439,'mass_relative_mass',1688,1544,'point',NULL,1,0.15144230769230793,NULL,NULL),(1690,440,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1691,440,'mass_relative_mass',1690,1546,'point',NULL,1,0.09014423076923062,NULL,NULL),(1692,441,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1693,441,'mass_relative_mass',1692,1548,'point',NULL,1,0.04326923076923084,NULL,NULL),(1694,442,'mass_absolute',NULL,NULL,'point',NULL,1,NULL,NULL,NULL),(1695,442,'mass_relative_mass',1694,1550,'point',NULL,1,0.20192307692307682,NULL,NULL),(1696,443,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1697,443,'mass_relative_mass',1696,1696,'mean',NULL,NULL,1,NULL,NULL),(1698,444,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1699,444,'mass_relative_mass',1698,1698,'mean',NULL,NULL,1,NULL,NULL),(1700,445,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1701,445,'mass_relative_mass',1700,1700,'mean',NULL,NULL,1,NULL,NULL),(1702,446,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1703,446,'mass_relative_mass',1702,1702,'mean',NULL,NULL,1,NULL,NULL),(1704,447,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1705,447,'mass_relative_mass',1704,1704,'mean',NULL,NULL,1,NULL,NULL),(1706,448,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1707,448,'mass_relative_mass',1706,1706,'mean',NULL,NULL,1,NULL,NULL),(1708,449,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1709,449,'mass_relative_mass',1708,1708,'mean',NULL,NULL,1,NULL,NULL),(1710,450,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1711,450,'mass_relative_mass',1710,1710,'mean',NULL,NULL,1,NULL,NULL),(1712,451,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1713,451,'mass_relative_mass',1712,1712,'mean',NULL,NULL,1,NULL,NULL),(1714,452,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1715,452,'mass_relative_mass',1714,1714,'mean',NULL,NULL,1,NULL,NULL),(1716,453,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1717,453,'mass_relative_mass',1716,1716,'mean',NULL,NULL,1,NULL,NULL),(1718,454,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1719,454,'mass_relative_mass',1718,1718,'mean',NULL,NULL,1,NULL,NULL),(1720,455,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1721,455,'mass_relative_mass',1720,1720,'mean',NULL,NULL,1,NULL,NULL),(1722,456,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1723,456,'mass_relative_mass',1722,1722,'mean',NULL,NULL,1,NULL,NULL),(1724,457,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1725,457,'mass_relative_mass',1724,1696,'mean',NULL,NULL,NULL,NULL,NULL),(1726,458,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1727,458,'mass_relative_mass',1726,1698,'mean',NULL,NULL,0.42000000000000004,NULL,NULL),(1728,459,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1729,459,'mass_relative_mass',1728,1700,'mean',NULL,NULL,0.73,NULL,NULL),(1730,460,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1731,460,'mass_relative_mass',1730,1702,'mean',NULL,NULL,0.48,NULL,NULL),(1732,461,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1733,461,'mass_relative_mass',1732,1704,'mean',NULL,NULL,0.6599999999999999,NULL,NULL),(1734,462,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1735,462,'mass_relative_mass',1734,1706,'mean',NULL,NULL,0.47,NULL,NULL),(1736,463,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1737,463,'mass_relative_mass',1736,1708,'mean',NULL,NULL,0.5700000000000001,NULL,NULL),(1738,464,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1739,464,'mass_relative_mass',1738,1710,'mean',NULL,NULL,0.25,NULL,NULL),(1740,465,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1741,465,'mass_relative_mass',1740,1712,'mean',NULL,NULL,0.41000000000000003,NULL,NULL),(1742,466,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1743,466,'mass_relative_mass',1742,1714,'mean',NULL,NULL,0.63,NULL,NULL),(1744,467,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1745,467,'mass_relative_mass',1744,1716,'mean',NULL,NULL,0.6699999999999999,NULL,NULL),(1746,468,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1747,468,'mass_relative_mass',1746,1718,'mean',NULL,NULL,0.97,NULL,NULL),(1748,469,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1749,469,'mass_relative_mass',1748,1720,'mean',NULL,NULL,0.36,NULL,NULL),(1750,470,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1751,470,'mass_relative_mass',1750,1722,'mean',NULL,NULL,0.9299999999999999,NULL,NULL),(1752,471,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1753,471,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1754,471,'water_mass_relative_mass',1755,1753,'mean',NULL,NULL,0.9342560553633218,NULL,NULL),(1755,471,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1756,471,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1757,471,'C_relative_mass',1760,1752,'mean',NULL,NULL,NULL,NULL,NULL),(1758,471,'N_relative_mass',1761,1752,'mean',NULL,NULL,NULL,NULL,NULL),(1759,471,'ash_mass_relative_mass',1762,1752,'mean',NULL,NULL,NULL,NULL,NULL),(1760,471,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1761,471,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1762,471,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1763,472,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1764,472,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1765,472,'water_mass_relative_mass',1766,1764,'mean',NULL,NULL,0.9363217427733557,NULL,NULL),(1766,472,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1767,472,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1768,472,'C_relative_mass',1771,1763,'mean',NULL,NULL,NULL,NULL,NULL),(1769,472,'N_relative_mass',1772,1763,'mean',NULL,NULL,NULL,NULL,NULL),(1770,472,'ash_mass_relative_mass',1773,1763,'mean',NULL,NULL,NULL,NULL,NULL),(1771,472,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1772,472,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1773,472,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1774,473,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1775,473,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1776,473,'water_mass_relative_mass',1777,1775,'mean',NULL,NULL,0.9565341721475551,NULL,NULL),(1777,473,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1778,473,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1779,473,'C_relative_mass',1782,1774,'mean',NULL,NULL,NULL,NULL,NULL),(1780,473,'N_relative_mass',1783,1774,'mean',NULL,NULL,NULL,NULL,NULL),(1781,473,'ash_mass_relative_mass',1784,1774,'mean',NULL,NULL,NULL,NULL,NULL),(1782,473,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1783,473,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1784,473,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1785,474,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1786,474,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1787,474,'water_mass_relative_mass',1788,1786,'mean',NULL,NULL,0.9393697646589549,NULL,NULL),(1788,474,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1789,474,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1790,474,'C_relative_mass',1793,1785,'mean',NULL,NULL,NULL,NULL,NULL),(1791,474,'N_relative_mass',1794,1785,'mean',NULL,NULL,NULL,NULL,NULL),(1792,474,'ash_mass_relative_mass',1795,1785,'mean',NULL,NULL,NULL,NULL,NULL),(1793,474,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1794,474,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1795,474,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1796,475,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1797,475,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1798,475,'water_mass_relative_mass',1799,1797,'mean',NULL,NULL,0.9574468085106383,NULL,NULL),(1799,475,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1800,475,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1801,475,'C_relative_mass',1804,1796,'mean',NULL,NULL,NULL,NULL,NULL),(1802,475,'N_relative_mass',1805,1796,'mean',NULL,NULL,NULL,NULL,NULL),(1803,475,'ash_mass_relative_mass',1806,1796,'mean',NULL,NULL,NULL,NULL,NULL),(1804,475,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1805,475,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1806,475,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1807,476,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1808,476,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1809,476,'water_mass_relative_mass',1810,1808,'mean',NULL,NULL,0.9582204477399116,NULL,NULL),(1810,476,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1811,476,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1812,476,'C_relative_mass',1815,1807,'mean',NULL,NULL,NULL,NULL,NULL),(1813,476,'N_relative_mass',1816,1807,'mean',NULL,NULL,NULL,NULL,NULL),(1814,476,'ash_mass_relative_mass',1817,1807,'mean',NULL,NULL,NULL,NULL,NULL),(1815,476,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1816,476,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1817,476,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1818,477,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1819,477,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1820,477,'water_mass_relative_mass',1821,1819,'mean',NULL,NULL,0.9520693603795191,NULL,NULL),(1821,477,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1822,477,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1823,477,'C_relative_mass',1826,1818,'mean',NULL,NULL,NULL,NULL,NULL),(1824,477,'N_relative_mass',1827,1818,'mean',NULL,NULL,NULL,NULL,NULL),(1825,477,'ash_mass_relative_mass',1828,1818,'mean',NULL,NULL,NULL,NULL,NULL),(1826,477,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1827,477,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1828,477,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1829,478,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1830,478,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1831,478,'water_mass_relative_mass',1832,1830,'mean',NULL,NULL,0.945366399403319,NULL,NULL),(1832,478,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1833,478,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1834,478,'C_relative_mass',1837,1829,'mean',NULL,NULL,NULL,NULL,NULL),(1835,478,'N_relative_mass',1838,1829,'mean',NULL,NULL,NULL,NULL,NULL),(1836,478,'ash_mass_relative_mass',1839,1829,'mean',NULL,NULL,NULL,NULL,NULL),(1837,478,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1838,478,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1839,478,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1840,479,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1841,479,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1842,479,'water_mass_relative_mass',1843,1841,'mean',NULL,NULL,0.9352199867344683,NULL,NULL),(1843,479,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1844,479,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1845,479,'C_relative_mass',1848,1840,'mean',NULL,NULL,NULL,NULL,NULL),(1846,479,'N_relative_mass',1849,1840,'mean',NULL,NULL,NULL,NULL,NULL),(1847,479,'ash_mass_relative_mass',1850,1840,'mean',NULL,NULL,NULL,NULL,NULL),(1848,479,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1849,479,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1850,479,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1851,480,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1852,480,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1853,480,'water_mass_relative_mass',1854,1852,'mean',NULL,NULL,0.9299732381801963,NULL,NULL),(1854,480,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1855,480,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1856,480,'C_relative_mass',1859,1851,'mean',NULL,NULL,NULL,NULL,NULL),(1857,480,'N_relative_mass',1860,1851,'mean',NULL,NULL,NULL,NULL,NULL),(1858,480,'ash_mass_relative_mass',1861,1851,'mean',NULL,NULL,NULL,NULL,NULL),(1859,480,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1860,480,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1861,480,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1862,481,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1863,481,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1864,481,'water_mass_relative_mass',1865,1863,'mean',NULL,NULL,0.9069353882631891,NULL,NULL),(1865,481,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1866,481,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1867,481,'C_relative_mass',1870,1862,'mean',NULL,NULL,NULL,NULL,NULL),(1868,481,'N_relative_mass',1871,1862,'mean',NULL,NULL,NULL,NULL,NULL),(1869,481,'ash_mass_relative_mass',1872,1862,'mean',NULL,NULL,NULL,NULL,NULL),(1870,481,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1871,481,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1872,481,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1873,482,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1874,482,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1875,482,'water_mass_relative_mass',1876,1874,'mean',NULL,NULL,0.9270446096654275,NULL,NULL),(1876,482,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1877,482,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1878,482,'C_relative_mass',1881,1873,'mean',NULL,NULL,NULL,NULL,NULL),(1879,482,'N_relative_mass',1882,1873,'mean',NULL,NULL,NULL,NULL,NULL),(1880,482,'ash_mass_relative_mass',1883,1873,'mean',NULL,NULL,NULL,NULL,NULL),(1881,482,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1882,482,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1883,482,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1884,483,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1885,483,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1886,483,'water_mass_relative_mass',1887,1885,'mean',NULL,NULL,0.9221616261774913,NULL,NULL),(1887,483,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1888,483,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1889,483,'C_relative_mass',1892,1884,'mean',NULL,NULL,NULL,NULL,NULL),(1890,483,'N_relative_mass',1893,1884,'mean',NULL,NULL,NULL,NULL,NULL),(1891,483,'ash_mass_relative_mass',1894,1884,'mean',NULL,NULL,NULL,NULL,NULL),(1892,483,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1893,483,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1894,483,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1895,484,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1896,484,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1897,484,'water_mass_relative_mass',1898,1896,'mean',NULL,NULL,0.9280476626947753,NULL,NULL),(1898,484,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1899,484,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1900,484,'C_relative_mass',1903,1895,'mean',NULL,NULL,NULL,NULL,NULL),(1901,484,'N_relative_mass',1904,1895,'mean',NULL,NULL,NULL,NULL,NULL),(1902,484,'ash_mass_relative_mass',1905,1895,'mean',NULL,NULL,NULL,NULL,NULL),(1903,484,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1904,484,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1905,484,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1906,485,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1907,485,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1908,485,'water_mass_relative_mass',1909,1907,'mean',NULL,NULL,0.9627633512983832,NULL,NULL),(1909,485,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1910,485,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1911,485,'C_relative_mass',1914,1906,'mean',NULL,NULL,NULL,NULL,NULL),(1912,485,'N_relative_mass',1915,1906,'mean',NULL,NULL,NULL,NULL,NULL),(1913,485,'ash_mass_relative_mass',1916,1906,'mean',NULL,NULL,NULL,NULL,NULL),(1914,485,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1915,485,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1916,485,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1917,486,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1918,486,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1919,486,'water_mass_relative_mass',1920,1918,'mean',NULL,NULL,0.9491128222296619,NULL,NULL),(1920,486,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1921,486,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1922,486,'C_relative_mass',1925,1917,'mean',NULL,NULL,NULL,NULL,NULL),(1923,486,'N_relative_mass',1926,1917,'mean',NULL,NULL,NULL,NULL,NULL),(1924,486,'ash_mass_relative_mass',1927,1917,'mean',NULL,NULL,NULL,NULL,NULL),(1925,486,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1926,486,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1927,486,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1928,487,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1929,487,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1930,487,'water_mass_relative_mass',1931,1929,'mean',NULL,NULL,0.963302752293578,NULL,NULL),(1931,487,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1932,487,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1933,487,'C_relative_mass',1936,1928,'mean',NULL,NULL,NULL,NULL,NULL),(1934,487,'N_relative_mass',1937,1928,'mean',NULL,NULL,NULL,NULL,NULL),(1935,487,'ash_mass_relative_mass',1938,1928,'mean',NULL,NULL,NULL,NULL,NULL),(1936,487,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1937,487,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1938,487,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1939,488,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1940,488,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1941,488,'water_mass_relative_mass',1942,1940,'mean',NULL,NULL,0.9594882729211087,NULL,NULL),(1942,488,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1943,488,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1944,488,'C_relative_mass',1947,1939,'mean',NULL,NULL,NULL,NULL,NULL),(1945,488,'N_relative_mass',1948,1939,'mean',NULL,NULL,NULL,NULL,NULL),(1946,488,'ash_mass_relative_mass',1949,1939,'mean',NULL,NULL,NULL,NULL,NULL),(1947,488,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1948,488,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1949,488,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1950,489,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1951,489,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1952,489,'water_mass_relative_mass',1953,1951,'mean',NULL,NULL,0.9607438016528925,NULL,NULL),(1953,489,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1954,489,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1955,489,'C_relative_mass',1958,1950,'mean',NULL,NULL,NULL,NULL,NULL),(1956,489,'N_relative_mass',1959,1950,'mean',NULL,NULL,NULL,NULL,NULL),(1957,489,'ash_mass_relative_mass',1960,1950,'mean',NULL,NULL,NULL,NULL,NULL),(1958,489,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1959,489,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1960,489,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1961,490,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1962,490,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1963,490,'water_mass_relative_mass',1964,1962,'mean',NULL,NULL,0.9612074672315636,NULL,NULL),(1964,490,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1965,490,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1966,490,'C_relative_mass',1969,1961,'mean',NULL,NULL,NULL,NULL,NULL),(1967,490,'N_relative_mass',1970,1961,'mean',NULL,NULL,NULL,NULL,NULL),(1968,490,'ash_mass_relative_mass',1971,1961,'mean',NULL,NULL,NULL,NULL,NULL),(1969,490,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1970,490,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1971,490,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1972,491,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1973,491,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1974,491,'water_mass_relative_mass',1975,1973,'mean',NULL,NULL,0.9126155681479272,NULL,NULL),(1975,491,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1976,491,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1977,491,'C_relative_mass',1980,1972,'mean',NULL,NULL,NULL,NULL,NULL),(1978,491,'N_relative_mass',1981,1972,'mean',NULL,NULL,NULL,NULL,NULL),(1979,491,'ash_mass_relative_mass',1982,1972,'mean',NULL,NULL,NULL,NULL,NULL),(1980,491,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1981,491,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1982,491,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1983,492,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1984,492,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1985,492,'water_mass_relative_mass',1986,1984,'mean',NULL,NULL,0.9580409566089073,NULL,NULL),(1986,492,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1987,492,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1988,492,'C_relative_mass',1991,1983,'mean',NULL,NULL,NULL,NULL,NULL),(1989,492,'N_relative_mass',1992,1983,'mean',NULL,NULL,NULL,NULL,NULL),(1990,492,'ash_mass_relative_mass',1993,1983,'mean',NULL,NULL,NULL,NULL,NULL),(1991,492,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1992,492,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1993,492,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1994,493,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1995,493,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1996,493,'water_mass_relative_mass',1997,1995,'mean',NULL,NULL,0.9329979419163046,NULL,NULL),(1997,493,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1998,493,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(1999,493,'C_relative_mass',2002,1994,'mean',NULL,NULL,NULL,NULL,NULL),(2000,493,'N_relative_mass',2003,1994,'mean',NULL,NULL,NULL,NULL,NULL),(2001,493,'ash_mass_relative_mass',2004,1994,'mean',NULL,NULL,NULL,NULL,NULL),(2002,493,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2003,493,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2004,493,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2005,494,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2006,494,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2007,494,'water_mass_relative_mass',2008,2006,'mean',NULL,NULL,0.9467254835425857,NULL,NULL),(2008,494,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2009,494,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2010,494,'C_relative_mass',2013,2005,'mean',NULL,NULL,NULL,NULL,NULL),(2011,494,'N_relative_mass',2014,2005,'mean',NULL,NULL,NULL,NULL,NULL),(2012,494,'ash_mass_relative_mass',2015,2005,'mean',NULL,NULL,NULL,NULL,NULL),(2013,494,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2014,494,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2015,494,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2016,495,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2017,495,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2018,495,'water_mass_relative_mass',2019,2017,'mean',NULL,NULL,0.9093533487297921,NULL,NULL),(2019,495,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2020,495,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2021,495,'C_relative_mass',2024,2016,'mean',NULL,NULL,NULL,NULL,NULL),(2022,495,'N_relative_mass',2025,2016,'mean',NULL,NULL,NULL,NULL,NULL),(2023,495,'ash_mass_relative_mass',2026,2016,'mean',NULL,NULL,NULL,NULL,NULL),(2024,495,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2025,495,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2026,495,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2027,496,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2028,496,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2029,496,'water_mass_relative_mass',2030,2028,'mean',NULL,NULL,0.9382376081825334,NULL,NULL),(2030,496,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2031,496,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2032,496,'C_relative_mass',2035,2027,'mean',NULL,NULL,NULL,NULL,NULL),(2033,496,'N_relative_mass',2036,2027,'mean',NULL,NULL,NULL,NULL,NULL),(2034,496,'ash_mass_relative_mass',2037,2027,'mean',NULL,NULL,NULL,NULL,NULL),(2035,496,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2036,496,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2037,496,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2038,497,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2039,497,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2040,497,'water_mass_relative_mass',2041,2039,'mean',NULL,NULL,0.9322399654725939,NULL,NULL),(2041,497,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2042,497,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2043,497,'C_relative_mass',2046,2038,'mean',NULL,NULL,NULL,NULL,NULL),(2044,497,'N_relative_mass',2047,2038,'mean',NULL,NULL,NULL,NULL,NULL),(2045,497,'ash_mass_relative_mass',2048,2038,'mean',NULL,NULL,NULL,NULL,NULL),(2046,497,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2047,497,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2048,497,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2049,498,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2050,498,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2051,498,'water_mass_relative_mass',2052,2050,'mean',NULL,NULL,0.9209864116758932,NULL,NULL),(2052,498,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2053,498,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2054,498,'C_relative_mass',2057,2049,'mean',NULL,NULL,NULL,NULL,NULL),(2055,498,'N_relative_mass',2058,2049,'mean',NULL,NULL,NULL,NULL,NULL),(2056,498,'ash_mass_relative_mass',2059,2049,'mean',NULL,NULL,NULL,NULL,NULL),(2057,498,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2058,498,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2059,498,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2060,499,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2061,499,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2062,499,'water_mass_relative_mass',2063,2061,'mean',NULL,NULL,0.9371121224658668,NULL,NULL),(2063,499,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2064,499,'pH',NULL,NULL,'mean',NULL,NULL,3.810457516339869,NULL,NULL),(2065,499,'C_relative_mass',2068,2060,'mean',NULL,NULL,0.48420144614393196,NULL,NULL),(2066,499,'N_relative_mass',2069,2060,'mean',NULL,NULL,0.008309178743961356,NULL,NULL),(2067,499,'ash_mass_relative_mass',2070,2060,'mean',NULL,NULL,0.04099378881987581,NULL,NULL),(2068,499,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2069,499,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2070,499,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2071,500,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2072,500,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2073,500,'water_mass_relative_mass',2074,2072,'mean',NULL,NULL,0.9079903147699758,NULL,NULL),(2074,500,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2075,500,'pH',NULL,NULL,'mean',NULL,NULL,3.8627450980392157,NULL,NULL),(2076,500,'C_relative_mass',2079,2071,'mean',NULL,NULL,0.4871723905915353,NULL,NULL),(2077,500,'N_relative_mass',2080,2071,'mean',NULL,NULL,0.013526570048309185,NULL,NULL),(2078,500,'ash_mass_relative_mass',2081,2071,'mean',NULL,NULL,0.06894409937888202,NULL,NULL),(2079,500,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2080,500,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2081,500,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2082,501,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2083,501,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2084,501,'water_mass_relative_mass',2085,2083,'mean',NULL,NULL,0.9209157127991675,NULL,NULL),(2085,501,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2086,501,'pH',NULL,NULL,'mean',NULL,NULL,4.052287581699346,NULL,NULL),(2087,501,'C_relative_mass',2090,2082,'mean',NULL,NULL,0.4791508405830063,NULL,NULL),(2088,501,'N_relative_mass',2091,2082,'mean',NULL,NULL,0.008212560386473434,NULL,NULL),(2089,501,'ash_mass_relative_mass',2092,2082,'mean',NULL,NULL,0.04472049689440996,NULL,NULL),(2090,501,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2091,501,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2092,501,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2093,502,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2094,502,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2095,502,'water_mass_relative_mass',2096,2094,'mean',NULL,NULL,0.9526774595267746,NULL,NULL),(2096,502,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2097,502,'pH',NULL,NULL,'mean',NULL,NULL,3.8627450980392157,NULL,NULL),(2098,502,'C_relative_mass',2101,2093,'mean',NULL,NULL,0.4785566516934856,NULL,NULL),(2099,502,'N_relative_mass',2102,2093,'mean',NULL,NULL,0.008115942028985515,NULL,NULL),(2100,502,'ash_mass_relative_mass',2103,2093,'mean',NULL,NULL,0.042236024844720554,NULL,NULL),(2101,502,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2102,502,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2103,502,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2104,503,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2105,503,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2106,503,'water_mass_relative_mass',2107,2105,'mean',NULL,NULL,0.908523259444271,NULL,NULL),(2107,503,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2108,503,'pH',NULL,NULL,'mean',NULL,NULL,3.764705882352941,NULL,NULL),(2109,503,'C_relative_mass',2112,2104,'mean',NULL,NULL,0.4723176683535186,NULL,NULL),(2110,503,'N_relative_mass',2113,2104,'mean',NULL,NULL,0.011111111111111117,NULL,NULL),(2111,503,'ash_mass_relative_mass',2114,2104,'mean',NULL,NULL,0.10248447204968952,NULL,NULL),(2112,503,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2113,503,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2114,503,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2115,504,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2116,504,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2117,504,'water_mass_relative_mass',2118,2116,'mean',NULL,NULL,0.9403623040911866,NULL,NULL),(2118,504,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2119,504,'pH',NULL,NULL,'mean',NULL,NULL,3.8627450980392157,NULL,NULL),(2120,504,'C_relative_mass',2123,2115,'mean',NULL,NULL,0.46696996834783255,NULL,NULL),(2121,504,'N_relative_mass',2124,2115,'mean',NULL,NULL,0.015169082125603871,NULL,NULL),(2122,504,'ash_mass_relative_mass',2125,2115,'mean',NULL,NULL,0.08136645962732925,NULL,NULL),(2123,504,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2124,504,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2125,504,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2126,505,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2127,505,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2128,505,'water_mass_relative_mass',2129,2127,'mean',NULL,NULL,0.936483849989161,NULL,NULL),(2129,505,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2130,505,'pH',NULL,NULL,'mean',NULL,NULL,4,NULL,NULL),(2131,505,'C_relative_mass',2134,2126,'mean',NULL,NULL,0.4687525350163946,NULL,NULL),(2132,505,'N_relative_mass',2135,2126,'mean',NULL,NULL,0.013816425120772951,NULL,NULL),(2133,505,'ash_mass_relative_mass',2136,2126,'mean',NULL,NULL,0.0776397515527951,NULL,NULL),(2134,505,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2135,505,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2136,505,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2137,506,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2138,506,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2139,506,'water_mass_relative_mass',2140,2138,'mean',NULL,NULL,0.925312261024726,NULL,NULL),(2140,506,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2141,506,'pH',NULL,NULL,'mean',NULL,NULL,3.8235294117647056,NULL,NULL),(2142,506,'C_relative_mass',2145,2137,'mean',NULL,NULL,0.4601367961183449,NULL,NULL),(2143,506,'N_relative_mass',2146,2137,'mean',NULL,NULL,0.015265700483091792,NULL,NULL),(2144,506,'ash_mass_relative_mass',2147,2137,'mean',NULL,NULL,0.08260869565217399,NULL,NULL),(2145,506,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2146,506,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2147,506,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2148,507,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2149,507,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2150,507,'water_mass_relative_mass',2151,2149,'mean',NULL,NULL,0.9541873358622702,NULL,NULL),(2151,507,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2152,507,'pH',NULL,NULL,'mean',NULL,NULL,3.869281045751634,NULL,NULL),(2153,507,'C_relative_mass',2156,2148,'mean',NULL,NULL,0.47291185724303925,NULL,NULL),(2154,507,'N_relative_mass',2157,2148,'mean',NULL,NULL,0.020386473429951698,NULL,NULL),(2155,507,'ash_mass_relative_mass',2158,2148,'mean',NULL,NULL,0.14658385093167706,NULL,NULL),(2156,507,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2157,507,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2158,507,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2159,508,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2160,508,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2161,508,'water_mass_relative_mass',2162,2160,'mean',NULL,NULL,0.8903631284916201,NULL,NULL),(2162,508,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2163,508,'pH',NULL,NULL,'mean',NULL,NULL,4.352941176470588,NULL,NULL),(2164,508,'C_relative_mass',2167,2159,'mean',NULL,NULL,0.44498497943556786,NULL,NULL),(2165,508,'N_relative_mass',2168,2159,'mean',NULL,NULL,0.02946859903381643,NULL,NULL),(2166,508,'ash_mass_relative_mass',2169,2159,'mean',NULL,NULL,0.18881987577639756,NULL,NULL),(2167,508,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2168,508,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2169,508,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2170,509,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2171,509,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2172,509,'water_mass_relative_mass',2173,2171,'mean',NULL,NULL,0.9178870292887029,NULL,NULL),(2173,509,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2174,509,'pH',NULL,NULL,'mean',NULL,NULL,3.9673202614379086,NULL,NULL),(2175,509,'C_relative_mass',2178,2170,'mean',NULL,NULL,0.44141984609844387,NULL,NULL),(2176,509,'N_relative_mass',2179,2170,'mean',NULL,NULL,0.021062801932367158,NULL,NULL),(2177,509,'ash_mass_relative_mass',2180,2170,'mean',NULL,NULL,0.1931677018633541,NULL,NULL),(2178,509,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2179,509,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2180,509,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2181,510,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2182,510,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2183,510,'water_mass_relative_mass',2184,2182,'mean',NULL,NULL,0.9385999217833398,NULL,NULL),(2184,510,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2185,510,'pH',NULL,NULL,'mean',NULL,NULL,3.96078431372549,NULL,NULL),(2186,510,'C_relative_mass',2189,2181,'mean',NULL,NULL,0.44141984609844387,NULL,NULL),(2187,510,'N_relative_mass',2190,2181,'mean',NULL,NULL,0.023381642512077295,NULL,NULL),(2188,510,'ash_mass_relative_mass',2191,2181,'mean',NULL,NULL,0.19068322981366467,NULL,NULL),(2189,510,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2190,510,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2191,510,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2192,511,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2193,511,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2194,511,'water_mass_relative_mass',2195,2193,'mean',NULL,NULL,0.9322399654725939,NULL,NULL),(2195,511,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2196,511,'pH',NULL,NULL,'mean',NULL,NULL,4.450980392156863,NULL,NULL),(2197,511,'C_relative_mass',2200,2192,'mean',NULL,NULL,0.43726052387179914,NULL,NULL),(2198,511,'N_relative_mass',2201,2192,'mean',NULL,NULL,0.022415458937198072,NULL,NULL),(2199,511,'ash_mass_relative_mass',2202,2192,'mean',NULL,NULL,0.22732919254658387,NULL,NULL),(2200,511,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2201,511,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2202,511,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2203,512,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2204,512,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2205,512,'water_mass_relative_mass',2206,2204,'mean',NULL,NULL,NULL,NULL,NULL),(2206,512,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2207,512,'pH',NULL,NULL,'mean',NULL,NULL,4.052287581699346,NULL,NULL),(2208,512,'C_relative_mass',2211,2203,'mean',NULL,NULL,0.48420144614393196,NULL,NULL),(2209,512,'N_relative_mass',2212,2203,'mean',NULL,NULL,0.006763285024154594,NULL,NULL),(2210,512,'ash_mass_relative_mass',2213,2203,'mean',NULL,NULL,0.0428571428571429,NULL,NULL),(2211,512,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2212,512,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2213,512,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2214,513,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2215,513,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2216,513,'water_mass_relative_mass',2217,2215,'mean',NULL,NULL,0.9543817527010804,NULL,NULL),(2217,513,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2218,513,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2219,513,'C_relative_mass',2222,2214,'mean',NULL,NULL,NULL,NULL,NULL),(2220,513,'N_relative_mass',2223,2214,'mean',NULL,NULL,NULL,NULL,NULL),(2221,513,'ash_mass_relative_mass',2224,2214,'mean',NULL,NULL,NULL,NULL,NULL),(2222,513,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2223,513,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2224,513,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2225,514,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2226,514,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2227,514,'water_mass_relative_mass',2228,2226,'mean',NULL,NULL,0.9446669093556608,NULL,NULL),(2228,514,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2229,514,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2230,514,'C_relative_mass',2233,2225,'mean',NULL,NULL,NULL,NULL,NULL),(2231,514,'N_relative_mass',2234,2225,'mean',NULL,NULL,NULL,NULL,NULL),(2232,514,'ash_mass_relative_mass',2235,2225,'mean',NULL,NULL,NULL,NULL,NULL),(2233,514,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2234,514,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2235,514,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2236,515,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2237,515,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2238,515,'water_mass_relative_mass',2239,2237,'mean',NULL,NULL,0.9533312864599325,NULL,NULL),(2239,515,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2240,515,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2241,515,'C_relative_mass',2244,2236,'mean',NULL,NULL,NULL,NULL,NULL),(2242,515,'N_relative_mass',2245,2236,'mean',NULL,NULL,NULL,NULL,NULL),(2243,515,'ash_mass_relative_mass',2246,2236,'mean',NULL,NULL,NULL,NULL,NULL),(2244,515,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2245,515,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2246,515,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2247,516,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2248,516,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2249,516,'water_mass_relative_mass',2250,2248,'mean',NULL,NULL,0.9421393224210126,NULL,NULL),(2250,516,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2251,516,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2252,516,'C_relative_mass',2255,2247,'mean',NULL,NULL,NULL,NULL,NULL),(2253,516,'N_relative_mass',2256,2247,'mean',NULL,NULL,NULL,NULL,NULL),(2254,516,'ash_mass_relative_mass',2257,2247,'mean',NULL,NULL,NULL,NULL,NULL),(2255,516,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2256,516,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2257,516,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2258,517,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2259,517,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2260,517,'water_mass_relative_mass',2261,2259,'mean',NULL,NULL,0.9467040673211782,NULL,NULL),(2261,517,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2262,517,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2263,517,'C_relative_mass',2266,2258,'mean',NULL,NULL,NULL,NULL,NULL),(2264,517,'N_relative_mass',2267,2258,'mean',NULL,NULL,NULL,NULL,NULL),(2265,517,'ash_mass_relative_mass',2268,2258,'mean',NULL,NULL,NULL,NULL,NULL),(2266,517,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2267,517,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2268,517,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2269,518,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2270,518,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2271,518,'water_mass_relative_mass',2272,2270,'mean',NULL,NULL,0.9485332864921834,NULL,NULL),(2272,518,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2273,518,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2274,518,'C_relative_mass',2277,2269,'mean',NULL,NULL,NULL,NULL,NULL),(2275,518,'N_relative_mass',2278,2269,'mean',NULL,NULL,NULL,NULL,NULL),(2276,518,'ash_mass_relative_mass',2279,2269,'mean',NULL,NULL,NULL,NULL,NULL),(2277,518,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2278,518,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2279,518,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2280,519,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2281,519,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2282,519,'water_mass_relative_mass',2283,2281,'mean',NULL,NULL,0.9428069490532891,NULL,NULL),(2283,519,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2284,519,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2285,519,'C_relative_mass',2288,2280,'mean',NULL,NULL,NULL,NULL,NULL),(2286,519,'N_relative_mass',2289,2280,'mean',NULL,NULL,NULL,NULL,NULL),(2287,519,'ash_mass_relative_mass',2290,2280,'mean',NULL,NULL,NULL,NULL,NULL),(2288,519,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2289,519,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2290,519,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2291,520,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2292,520,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2293,520,'water_mass_relative_mass',2294,2292,'mean',NULL,NULL,0.9384841486458114,NULL,NULL),(2294,520,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2295,520,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2296,520,'C_relative_mass',2299,2291,'mean',NULL,NULL,NULL,NULL,NULL),(2297,520,'N_relative_mass',2300,2291,'mean',NULL,NULL,NULL,NULL,NULL),(2298,520,'ash_mass_relative_mass',2301,2291,'mean',NULL,NULL,NULL,NULL,NULL),(2299,520,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2300,520,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2301,520,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2302,521,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2303,521,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2304,521,'water_mass_relative_mass',2305,2303,'mean',NULL,NULL,0.94143513891665,NULL,NULL),(2305,521,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2306,521,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2307,521,'C_relative_mass',2310,2302,'mean',NULL,NULL,NULL,NULL,NULL),(2308,521,'N_relative_mass',2311,2302,'mean',NULL,NULL,NULL,NULL,NULL),(2309,521,'ash_mass_relative_mass',2312,2302,'mean',NULL,NULL,NULL,NULL,NULL),(2310,521,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2311,521,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2312,521,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2313,522,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2314,522,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2315,522,'water_mass_relative_mass',2316,2314,'mean',NULL,NULL,0.9347735770668882,NULL,NULL),(2316,522,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2317,522,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2318,522,'C_relative_mass',2321,2313,'mean',NULL,NULL,NULL,NULL,NULL),(2319,522,'N_relative_mass',2322,2313,'mean',NULL,NULL,NULL,NULL,NULL),(2320,522,'ash_mass_relative_mass',2323,2313,'mean',NULL,NULL,NULL,NULL,NULL),(2321,522,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2322,522,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2323,522,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2324,523,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2325,523,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2326,523,'water_mass_relative_mass',2327,2325,'mean',NULL,NULL,0.915907873594001,NULL,NULL),(2327,523,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2328,523,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2329,523,'C_relative_mass',2332,2324,'mean',NULL,NULL,NULL,NULL,NULL),(2330,523,'N_relative_mass',2333,2324,'mean',NULL,NULL,NULL,NULL,NULL),(2331,523,'ash_mass_relative_mass',2334,2324,'mean',NULL,NULL,NULL,NULL,NULL),(2332,523,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2333,523,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2334,523,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2335,524,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2336,524,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2337,524,'water_mass_relative_mass',2338,2336,'mean',NULL,NULL,0.9238603297769156,NULL,NULL),(2338,524,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2339,524,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2340,524,'C_relative_mass',2343,2335,'mean',NULL,NULL,NULL,NULL,NULL),(2341,524,'N_relative_mass',2344,2335,'mean',NULL,NULL,NULL,NULL,NULL),(2342,524,'ash_mass_relative_mass',2345,2335,'mean',NULL,NULL,NULL,NULL,NULL),(2343,524,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2344,524,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2345,524,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2346,525,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2347,525,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2348,525,'water_mass_relative_mass',2349,2347,'mean',NULL,NULL,0.919775166070516,NULL,NULL),(2349,525,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2350,525,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2351,525,'C_relative_mass',2354,2346,'mean',NULL,NULL,NULL,NULL,NULL),(2352,525,'N_relative_mass',2355,2346,'mean',NULL,NULL,NULL,NULL,NULL),(2353,525,'ash_mass_relative_mass',2356,2346,'mean',NULL,NULL,NULL,NULL,NULL),(2354,525,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2355,525,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2356,525,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2357,526,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2358,526,'sample_wet_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2359,526,'water_mass_relative_mass',2360,2358,'mean',NULL,NULL,0.9322399654725939,NULL,NULL),(2360,526,'water_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2361,526,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2362,526,'C_relative_mass',2365,2357,'mean',NULL,NULL,NULL,NULL,NULL),(2363,526,'N_relative_mass',2366,2357,'mean',NULL,NULL,NULL,NULL,NULL),(2364,526,'ash_mass_relative_mass',2367,2357,'mean',NULL,NULL,NULL,NULL,NULL),(2365,526,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2366,526,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2367,526,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(2368,537,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2369,537,'mass_relative_mass',2368,2368,'mean','se',5,1,0,NULL),(2370,537,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2371,537,'C_to_N',2373,2372,'mean','se',3,52,2.7,NULL),(2372,537,'N_relative_mass',2375,2368,'mean','se',3,0.0066,0.0004,NULL),(2373,537,'C_relative_mass',2374,2368,'mean','se',NULL,NULL,NULL,NULL),(2374,537,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2375,537,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2376,538,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2377,538,'mass_relative_mass',2376,2376,'mean','se',5,1,0,NULL),(2378,538,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2379,538,'C_to_N',2381,2380,'mean','se',3,33,1.3,NULL),(2380,538,'N_relative_mass',2383,2376,'mean','se',3,0.0108,0.0002,NULL),(2381,538,'C_relative_mass',2382,2376,'mean','se',NULL,NULL,NULL,NULL),(2382,538,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2383,538,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2384,539,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2385,539,'mass_relative_mass',2384,2384,'mean','se',5,1,0,NULL),(2386,539,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2387,539,'C_to_N',2389,2388,'mean','se',3,44.8,NULL,NULL),(2388,539,'N_relative_mass',2391,2384,'mean','se',3,0.009399999999999999,NULL,NULL),(2389,539,'C_relative_mass',2390,2384,'mean','se',NULL,NULL,NULL,NULL),(2390,539,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2391,539,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2392,540,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2393,540,'mass_relative_mass',2392,2392,'mean','se',5,1,0,NULL),(2394,540,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2395,540,'C_to_N',2397,2396,'mean','se',3,44.3,0.8,NULL),(2396,540,'N_relative_mass',2399,2392,'mean','se',3,0.0078000000000000005,0.0001,NULL),(2397,540,'C_relative_mass',2398,2392,'mean','se',NULL,NULL,NULL,NULL),(2398,540,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2399,540,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2400,541,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2401,541,'mass_relative_mass',2400,2400,'mean','se',5,1,0,NULL),(2402,541,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2403,541,'C_to_N',2405,2404,'mean','se',3,34.4,1.1,NULL),(2404,541,'N_relative_mass',2407,2400,'mean','se',3,0.011000000000000001,0.0003,NULL),(2405,541,'C_relative_mass',2406,2400,'mean','se',NULL,NULL,NULL,NULL),(2406,541,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2407,541,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2408,542,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2409,542,'mass_relative_mass',2408,2408,'mean','se',5,1,0,NULL),(2410,542,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2411,542,'C_to_N',2413,2412,'mean','se',3,44,3,NULL),(2412,542,'N_relative_mass',2415,2408,'mean','se',3,0.006500000000000001,0.0008,NULL),(2413,542,'C_relative_mass',2414,2408,'mean','se',NULL,NULL,NULL,NULL),(2414,542,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2415,542,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2416,543,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2417,543,'mass_relative_mass',2416,2416,'mean','se',5,1,0,NULL),(2418,543,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2419,543,'C_to_N',2421,2420,'mean','se',3,32.7,1.3,NULL),(2420,543,'N_relative_mass',2423,2416,'mean','se',3,0.0113,0.0008,NULL),(2421,543,'C_relative_mass',2422,2416,'mean','se',NULL,NULL,NULL,NULL),(2422,543,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2423,543,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2424,544,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2425,544,'mass_relative_mass',2424,2424,'mean','se',5,1,0,NULL),(2426,544,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2427,544,'C_to_N',2429,2428,'mean','se',3,43.9,NULL,NULL),(2428,544,'N_relative_mass',2431,2424,'mean','se',3,0.009399999999999999,NULL,NULL),(2429,544,'C_relative_mass',2430,2424,'mean','se',NULL,NULL,NULL,NULL),(2430,544,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2431,544,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2432,545,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2433,545,'mass_relative_mass',2432,2432,'mean','se',5,1,0,NULL),(2434,545,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2435,545,'C_to_N',2437,2436,'mean','se',3,NULL,NULL,NULL),(2436,545,'N_relative_mass',2439,2432,'mean','se',3,NULL,NULL,NULL),(2437,545,'C_relative_mass',2438,2432,'mean','se',NULL,NULL,NULL,NULL),(2438,545,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2439,545,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2440,546,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2441,546,'mass_relative_mass',2440,2440,'mean','se',5,1,0,NULL),(2442,546,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2443,546,'C_to_N',2445,2444,'mean','se',3,48.6,2.3,NULL),(2444,546,'N_relative_mass',2447,2440,'mean','se',3,0.0076,0.0012,NULL),(2445,546,'C_relative_mass',2446,2440,'mean','se',NULL,NULL,NULL,NULL),(2446,546,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2447,546,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2448,547,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2449,547,'mass_relative_mass',2448,2448,'mean','se',5,1,0,NULL),(2450,547,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2451,547,'C_to_N',2453,2452,'mean','se',3,48.6,2.3,NULL),(2452,547,'N_relative_mass',2455,2448,'mean','se',3,0.0076,0.0012,NULL),(2453,547,'C_relative_mass',2454,2448,'mean','se',NULL,NULL,NULL,NULL),(2454,547,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2455,547,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2456,548,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2457,548,'mass_relative_mass',2456,2456,'mean','se',5,1,0,NULL),(2458,548,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2459,548,'C_to_N',2461,2460,'mean','se',3,48.6,2.3,NULL),(2460,548,'N_relative_mass',2463,2456,'mean','se',3,0.0076,0.0012,NULL),(2461,548,'C_relative_mass',2462,2456,'mean','se',NULL,NULL,NULL,NULL),(2462,548,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2463,548,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2464,549,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2465,549,'mass_relative_mass',2464,2464,'mean','se',5,1,0,NULL),(2466,549,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2467,549,'C_to_N',2469,2468,'mean','se',3,48.6,2.3,NULL),(2468,549,'N_relative_mass',2471,2464,'mean','se',3,0.0076,0.0012,NULL),(2469,549,'C_relative_mass',2470,2464,'mean','se',NULL,NULL,NULL,NULL),(2470,549,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2471,549,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2472,550,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2473,550,'mass_relative_mass',2472,2472,'mean','se',5,1,0,NULL),(2474,550,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2475,550,'C_to_N',2477,2476,'mean','se',3,48.6,2.3,NULL),(2476,550,'N_relative_mass',2479,2472,'mean','se',3,0.0076,0.0012,NULL),(2477,550,'C_relative_mass',2478,2472,'mean','se',NULL,NULL,NULL,NULL),(2478,550,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2479,550,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2480,551,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2481,551,'mass_relative_mass',2480,2368,'mean','se',5,0.8621359223300971,0.011650485436893234,NULL),(2482,551,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2483,551,'C_to_N',2485,2484,'mean','se',3,56.3,2.1,NULL),(2484,551,'N_relative_mass',2487,2480,'mean','se',3,0.0066,0.0002,NULL),(2485,551,'C_relative_mass',2486,2480,'mean','se',NULL,NULL,NULL,NULL),(2486,551,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2487,551,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2488,552,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2489,552,'mass_relative_mass',2488,2368,'mean','se',5,0.8349514563106797,0.021359223300970884,NULL),(2490,552,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2491,552,'C_to_N',2493,2492,'mean','se',3,54.2,1.6,NULL),(2492,552,'N_relative_mass',2495,2488,'mean','se',3,0.006500000000000001,0.0002,NULL),(2493,552,'C_relative_mass',2494,2488,'mean','se',NULL,NULL,NULL,NULL),(2494,552,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2495,552,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2496,553,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2497,553,'mass_relative_mass',2496,2376,'mean','se',5,0.5041975308641975,0.015802469135802397,NULL),(2498,553,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2499,553,'C_to_N',2501,2500,'mean','se',3,25.3,0.6,NULL),(2500,553,'N_relative_mass',2503,2496,'mean','se',3,0.0143,0.0005,NULL),(2501,553,'C_relative_mass',2502,2496,'mean','se',NULL,NULL,NULL,NULL),(2502,553,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2503,553,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2504,554,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2505,554,'mass_relative_mass',2504,2384,'mean','se',5,0.6483950617283949,0.009876543209876586,NULL),(2506,554,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2507,554,'C_to_N',2509,2508,'mean','se',3,36.6,3,NULL),(2508,554,'N_relative_mass',2511,2504,'mean','se',3,0.0128,0.0012,NULL),(2509,554,'C_relative_mass',2510,2504,'mean','se',NULL,NULL,NULL,NULL),(2510,554,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2511,554,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2512,555,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2513,555,'mass_relative_mass',2512,2384,'mean','se',5,0.5160493827160493,0.023703703703703668,NULL),(2514,555,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2515,555,'C_to_N',2517,2516,'mean','se',3,28.3,1.2,NULL),(2516,555,'N_relative_mass',2519,2512,'mean','se',3,0.013600000000000001,0.0009,NULL),(2517,555,'C_relative_mass',2518,2512,'mean','se',NULL,NULL,NULL,NULL),(2518,555,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2519,555,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2520,556,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2521,556,'mass_relative_mass',2520,2392,'mean','se',5,0.8459259259259259,0.0019753086419753174,NULL),(2522,556,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2523,556,'C_to_N',2525,2524,'mean','se',3,47.3,1.8,NULL),(2524,556,'N_relative_mass',2527,2520,'mean','se',3,0.0075,0.0003,NULL),(2525,556,'C_relative_mass',2526,2520,'mean','se',NULL,NULL,NULL,NULL),(2526,556,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2527,556,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2528,557,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2529,557,'mass_relative_mass',2528,2392,'mean','se',5,0.8380246913580245,0.011851851851851763,NULL),(2530,557,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2531,557,'C_to_N',2533,2532,'mean','se',3,52.6,2.1,NULL),(2532,557,'N_relative_mass',2535,2528,'mean','se',3,0.0066,0.0003,NULL),(2533,557,'C_relative_mass',2534,2528,'mean','se',NULL,NULL,NULL,NULL),(2534,557,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2535,557,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2536,558,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2537,558,'mass_relative_mass',2536,2400,'mean','se',5,0.504516129032258,0.01892473118279568,NULL),(2538,558,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2539,558,'C_to_N',2541,2540,'mean','se',3,32.3,1.4,NULL),(2540,558,'N_relative_mass',2543,2536,'mean','se',3,0.0128,0.0006,NULL),(2541,558,'C_relative_mass',2542,2536,'mean','se',NULL,NULL,NULL,NULL),(2542,558,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2543,558,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2544,559,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2545,559,'mass_relative_mass',2544,2400,'mean','se',5,0.3531182795698924,0.0258064516129032,NULL),(2546,559,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2547,559,'C_to_N',2549,2548,'mean','se',3,28,0.8,NULL),(2548,559,'N_relative_mass',2551,2544,'mean','se',3,0.0143,0.0013,NULL),(2549,559,'C_relative_mass',2550,2544,'mean','se',NULL,NULL,NULL,NULL),(2550,559,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2551,559,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2552,560,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2553,560,'mass_relative_mass',2552,2408,'mean','se',5,0.8984946236559139,0.013763440860215042,NULL),(2554,560,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2555,560,'C_to_N',2557,2556,'mean','se',3,37.1,1.7,NULL),(2556,560,'N_relative_mass',2559,2552,'mean','se',3,0.0095,0.0004,NULL),(2557,560,'C_relative_mass',2558,2552,'mean','se',NULL,NULL,NULL,NULL),(2558,560,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2559,560,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2560,561,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2561,561,'mass_relative_mass',2560,2408,'mean','se',5,0.8004301075268816,0.029247311827957104,NULL),(2562,561,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2563,561,'C_to_N',2565,2564,'mean','se',3,33.5,1.3,NULL),(2564,561,'N_relative_mass',2567,2560,'mean','se',3,0.0109,0.0006,NULL),(2565,561,'C_relative_mass',2566,2560,'mean','se',NULL,NULL,NULL,NULL),(2566,561,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2567,561,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2568,562,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2569,562,'mass_relative_mass',2568,2416,'mean','se',5,0.4172631578947369,0.023578947368421053,NULL),(2570,562,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2571,562,'C_to_N',2573,2572,'mean','se',3,29.9,2.5,NULL),(2572,562,'N_relative_mass',2575,2568,'mean','se',3,0.0134,0.0011,NULL),(2573,562,'C_relative_mass',2574,2568,'mean','se',NULL,NULL,NULL,NULL),(2574,562,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2575,562,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2576,563,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2577,563,'mass_relative_mass',2576,2416,'mean','se',5,0.2623157894736843,0.008421052631578939,NULL),(2578,563,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2579,563,'C_to_N',2581,2580,'mean','se',3,28.1,3.2,NULL),(2580,563,'N_relative_mass',2583,2576,'mean','se',3,0.0139,0.0013,NULL),(2581,563,'C_relative_mass',2582,2576,'mean','se',NULL,NULL,NULL,NULL),(2582,563,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2583,563,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2584,564,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2585,564,'mass_relative_mass',2584,2424,'mean','se',5,0.6261052631578948,0.013473684210526216,NULL),(2586,564,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2587,564,'C_to_N',2589,2588,'mean','se',3,33.8,1.3,NULL),(2588,564,'N_relative_mass',2591,2584,'mean','se',3,0.0115,0.0005,NULL),(2589,564,'C_relative_mass',2590,2584,'mean','se',NULL,NULL,NULL,NULL),(2590,564,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2591,564,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2592,565,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2593,565,'mass_relative_mass',2592,2424,'mean','se',5,0.5671578947368422,0.013473684210526216,NULL),(2594,565,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2595,565,'C_to_N',2597,2596,'mean','se',3,37.6,2.4,NULL),(2596,565,'N_relative_mass',2599,2592,'mean','se',3,0.011200000000000002,0.0004,NULL),(2597,565,'C_relative_mass',2598,2592,'mean','se',NULL,NULL,NULL,NULL),(2598,565,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2599,565,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2600,566,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2601,566,'mass_relative_mass',2600,2432,'mean','se',5,0.7827368421052633,0.0370526315789472,NULL),(2602,566,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2603,566,'C_to_N',2605,2604,'mean','se',3,NULL,NULL,NULL),(2604,566,'N_relative_mass',2607,2600,'mean','se',3,NULL,NULL,NULL),(2605,566,'C_relative_mass',2606,2600,'mean','se',NULL,NULL,NULL,NULL),(2606,566,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2607,566,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2608,567,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2609,567,'mass_relative_mass',2608,2432,'mean','se',5,0.6783157894736843,0.03200000000000003,NULL),(2610,567,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2611,567,'C_to_N',2613,2612,'mean','se',3,NULL,NULL,NULL),(2612,567,'N_relative_mass',2615,2608,'mean','se',3,NULL,NULL,NULL),(2613,567,'C_relative_mass',2614,2608,'mean','se',NULL,NULL,NULL,NULL),(2614,567,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2615,567,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2616,568,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2617,568,'mass_relative_mass',2616,2440,'mean','se',5,0.549091595845137,0.026024551463644983,NULL),(2618,568,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2619,568,'C_to_N',2621,2620,'mean','se',3,33.5,1.8,NULL),(2620,568,'N_relative_mass',2623,2616,'mean','se',3,0.0116,0.0006,NULL),(2621,568,'C_relative_mass',2622,2616,'mean','se',NULL,NULL,NULL,NULL),(2622,568,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2623,568,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2624,569,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2625,569,'mass_relative_mass',2624,2440,'mean','se',5,0.5430859301227575,0.016015108593012143,NULL),(2626,569,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2627,569,'C_to_N',2629,2628,'mean','se',3,33.1,2,NULL),(2628,569,'N_relative_mass',2631,2624,'mean','se',3,0.011399999999999999,0.0005,NULL),(2629,569,'C_relative_mass',2630,2624,'mean','se',NULL,NULL,NULL,NULL),(2630,569,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2631,569,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2632,570,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2633,570,'mass_relative_mass',2632,2448,'mean','se',5,0.5510934844192635,0.038035882908404164,NULL),(2634,570,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2635,570,'C_to_N',2637,2636,'mean','se',3,31.5,3.2,NULL),(2636,570,'N_relative_mass',2639,2632,'mean','se',3,0.0129,0.0012,NULL),(2637,570,'C_relative_mass',2638,2632,'mean','se',NULL,NULL,NULL,NULL),(2638,570,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2639,570,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2640,571,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2641,571,'mass_relative_mass',2640,2448,'mean','se',5,0.37692917847025503,0.03002832861189802,NULL),(2642,571,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2643,571,'C_to_N',2645,2644,'mean','se',3,29.8,0.8,NULL),(2644,571,'N_relative_mass',2647,2640,'mean','se',3,0.0124,0.0003,NULL),(2645,571,'C_relative_mass',2646,2640,'mean','se',NULL,NULL,NULL,NULL),(2646,571,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2647,571,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2648,572,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2649,572,'mass_relative_mass',2648,2456,'mean','se',5,0.6752105760151088,0.016015108593012285,NULL),(2650,572,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2651,572,'C_to_N',2653,2652,'mean','se',3,36.4,1.5,NULL),(2652,572,'N_relative_mass',2655,2648,'mean','se',3,0.011000000000000001,0.0005,NULL),(2653,572,'C_relative_mass',2654,2648,'mean','se',NULL,NULL,NULL,NULL),(2654,572,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2655,572,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2656,573,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2657,573,'mass_relative_mass',2656,2456,'mean','se',5,0.5631048158640228,0.020018885741265324,NULL),(2658,573,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2659,573,'C_to_N',2661,2660,'mean','se',3,33.5,1,NULL),(2660,573,'N_relative_mass',2663,2656,'mean','se',3,0.013300000000000001,0.0006,NULL),(2661,573,'C_relative_mass',2662,2656,'mean','se',NULL,NULL,NULL,NULL),(2662,573,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2663,573,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2664,574,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2665,574,'mass_relative_mass',2664,2464,'mean','se',5,0.5811218130311616,0.016015108593012216,NULL),(2666,574,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2667,574,'C_to_N',2669,2668,'mean','se',3,38.2,1.8,NULL),(2668,574,'N_relative_mass',2671,2664,'mean','se',3,0.0103,0.0005,NULL),(2669,574,'C_relative_mass',2670,2664,'mean','se',NULL,NULL,NULL,NULL),(2670,574,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2671,574,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2672,575,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2673,575,'mass_relative_mass',2672,2464,'mean','se',5,0.4970424929178472,0.03002832861189802,NULL),(2674,575,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2675,575,'C_to_N',2677,2676,'mean','se',3,30.6,1,NULL),(2676,575,'N_relative_mass',2679,2672,'mean','se',3,0.0127,0.0008,NULL),(2677,575,'C_relative_mass',2678,2672,'mean','se',NULL,NULL,NULL,NULL),(2678,575,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2679,575,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2680,576,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2681,576,'mass_relative_mass',2680,2472,'mean','se',5,0.6932275731822475,0.012011331444759321,NULL),(2682,576,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2683,576,'C_to_N',2685,2684,'mean','se',3,37.8,1.5,NULL),(2684,576,'N_relative_mass',2687,2680,'mean','se',3,0.011399999999999999,0.0008,NULL),(2685,576,'C_relative_mass',2686,2680,'mean','se',NULL,NULL,NULL,NULL),(2686,576,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2687,576,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2688,577,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2689,577,'mass_relative_mass',2688,2472,'mean','se',5,0.5891293673276677,0.026024551463644983,NULL),(2690,577,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2691,577,'C_to_N',2693,2692,'mean','se',3,28.4,2.2,NULL),(2692,577,'N_relative_mass',2695,2688,'mean','se',3,0.015300000000000001,0.0012,NULL),(2693,577,'C_relative_mass',2694,2688,'mean','se',NULL,NULL,NULL,NULL),(2694,577,'C_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2695,577,'N_absolute',NULL,NULL,'mean','se',NULL,NULL,NULL,NULL),(2696,578,'water_table_depth',NULL,NULL,'mean',NULL,NULL,39.728260869565204,NULL,NULL),(2697,579,'water_table_depth',NULL,NULL,'mean',NULL,NULL,27.010869565217398,NULL,NULL),(2698,580,'water_table_depth',NULL,NULL,'mean',NULL,NULL,22.60869565217392,NULL,NULL),(2699,581,'water_table_depth',NULL,NULL,'mean',NULL,NULL,5.815217391304358,NULL,NULL),(2700,582,'water_table_depth',NULL,NULL,'mean',NULL,NULL,-6.90217391304347,NULL,NULL),(2701,583,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2702,583,'mass_relative_mass',2701,2701,'mean','se',5,1,NULL,NULL),(2703,583,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2704,584,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2705,584,'mass_relative_mass',2704,2704,'mean','se',5,1,NULL,NULL),(2706,584,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2707,585,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2708,585,'mass_relative_mass',2707,2707,'mean','se',5,1,NULL,NULL),(2709,585,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2710,586,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2711,586,'mass_relative_mass',2710,2710,'mean','se',5,1,NULL,NULL),(2712,586,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2713,587,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2714,587,'mass_relative_mass',2713,2713,'mean','se',5,1,NULL,NULL),(2715,587,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2716,588,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2717,588,'mass_relative_mass',2716,2716,'mean','se',5,1,NULL,NULL),(2718,588,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2719,589,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2720,589,'mass_relative_mass',2719,2719,'mean','se',5,1,NULL,NULL),(2721,589,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2722,590,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2723,590,'mass_relative_mass',2722,2722,'mean','se',5,1,NULL,NULL),(2724,590,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2725,591,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2726,591,'mass_relative_mass',2725,2725,'mean','se',5,1,NULL,NULL),(2727,591,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2728,592,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2729,592,'mass_relative_mass',2728,2728,'mean','se',5,1,NULL,NULL),(2730,592,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2731,593,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2732,593,'mass_relative_mass',2731,2731,'mean','se',5,1,NULL,NULL),(2733,593,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2734,594,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2735,594,'mass_relative_mass',2734,2734,'mean','se',5,1,NULL,NULL),(2736,594,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2737,595,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2738,595,'mass_relative_mass',2737,2737,'mean','se',5,1,NULL,NULL),(2739,595,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2740,596,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2741,596,'mass_relative_mass',2740,2740,'mean','se',5,1,NULL,NULL),(2742,596,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2743,597,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2744,597,'mass_relative_mass',2743,2743,'mean','se',5,1,NULL,NULL),(2745,597,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2746,598,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2747,598,'mass_relative_mass',2746,2746,'mean','se',5,1,NULL,NULL),(2748,598,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2749,599,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2750,599,'mass_relative_mass',2749,2749,'mean','se',5,1,NULL,NULL),(2751,599,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2752,600,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2753,600,'mass_relative_mass',2752,2752,'mean','se',5,1,NULL,NULL),(2754,600,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2755,601,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2756,601,'mass_relative_mass',2755,2755,'mean','se',5,1,NULL,NULL),(2757,601,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2758,602,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2759,602,'mass_relative_mass',2758,2758,'mean','se',5,1,NULL,NULL),(2760,602,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2761,603,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2762,603,'mass_relative_mass',2761,2761,'mean','se',5,1,NULL,NULL),(2763,603,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2764,604,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2765,604,'mass_relative_mass',2764,2764,'mean','se',5,1,NULL,NULL),(2766,604,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2767,605,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2768,605,'mass_relative_mass',2767,2767,'mean','se',5,1,NULL,NULL),(2769,605,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2770,606,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2771,606,'mass_relative_mass',2770,2770,'mean','se',5,1,NULL,NULL),(2772,606,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2773,607,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2774,607,'mass_relative_mass',2773,2773,'mean','se',5,1,NULL,NULL),(2775,607,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2776,608,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2777,608,'mass_relative_mass',2776,2776,'mean','se',5,1,NULL,NULL),(2778,608,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2779,609,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2780,609,'mass_relative_mass',2779,2779,'mean','se',5,1,NULL,NULL),(2781,609,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2782,610,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2783,610,'mass_relative_mass',2782,2782,'mean','se',5,1,NULL,NULL),(2784,610,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2785,611,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2786,611,'mass_relative_mass',2785,2785,'mean','se',5,1,NULL,NULL),(2787,611,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2788,612,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2789,612,'mass_relative_mass',2788,2788,'mean','se',5,1,NULL,NULL),(2790,612,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2791,613,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2792,613,'mass_relative_mass',2791,2701,'mean','se',5,0.9021276595744677,NULL,NULL),(2793,613,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2794,614,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2795,614,'mass_relative_mass',2794,2791,'mean','se',5,0.880851063829787,NULL,NULL),(2796,614,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2797,615,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2798,615,'mass_relative_mass',2797,2794,'mean','se',5,0.8595744680851064,NULL,NULL),(2799,615,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2800,616,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2801,616,'mass_relative_mass',2800,2704,'mean','se',5,0.9021276595744677,NULL,NULL),(2802,616,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2803,617,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2804,617,'mass_relative_mass',2803,2800,'mean','se',5,0.9021276595744677,NULL,NULL),(2805,617,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2806,618,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2807,618,'mass_relative_mass',2806,2803,'mean','se',5,0.872340425531915,NULL,NULL),(2808,618,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2809,619,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2810,619,'mass_relative_mass',2809,2707,'mean','se',5,0.9319148936170214,NULL,NULL),(2811,619,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2812,620,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2813,620,'mass_relative_mass',2812,2809,'mean','se',5,0.9106382978723405,NULL,NULL),(2814,620,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2815,621,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2816,621,'mass_relative_mass',2815,2812,'mean','se',5,0.880851063829787,NULL,NULL),(2817,621,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2818,622,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2819,622,'mass_relative_mass',2818,2710,'mean','se',5,0.9319148936170214,NULL,NULL),(2820,622,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2821,623,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2822,623,'mass_relative_mass',2821,2818,'mean','se',5,0.9106382978723405,NULL,NULL),(2823,623,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2824,624,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2825,624,'mass_relative_mass',2824,2821,'mean','se',5,0.8851063829787239,NULL,NULL),(2826,624,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2827,625,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2828,625,'mass_relative_mass',2827,2713,'mean','se',5,0.9404255319148933,NULL,NULL),(2829,625,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2830,626,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2831,626,'mass_relative_mass',2830,2827,'mean','se',5,0.9148936170212767,NULL,NULL),(2832,626,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2833,627,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2834,627,'mass_relative_mass',2833,2830,'mean','se',5,0.9063829787234045,NULL,NULL),(2835,627,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2836,628,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2837,628,'mass_relative_mass',2836,2716,'mean','se',5,0.9478260869565218,NULL,NULL),(2838,628,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2839,629,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2840,629,'mass_relative_mass',2839,2836,'mean','se',5,0.9130434782608694,NULL,NULL),(2841,629,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2842,630,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2843,630,'mass_relative_mass',2842,2839,'mean','se',5,0.8217391304347825,NULL,NULL),(2844,630,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2845,631,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2846,631,'mass_relative_mass',2845,2719,'mean','se',5,0.9478260869565218,NULL,NULL),(2847,631,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2848,632,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2849,632,'mass_relative_mass',2848,2845,'mean','se',5,0.9391304347826085,NULL,NULL),(2850,632,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2851,633,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2852,633,'mass_relative_mass',2851,2848,'mean','se',5,0.8695652173913041,NULL,NULL),(2853,633,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2854,634,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2855,634,'mass_relative_mass',2854,2722,'mean','se',5,0.9652173913043476,NULL,NULL),(2856,634,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2857,635,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2858,635,'mass_relative_mass',2857,2854,'mean','se',5,0.9565217391304347,NULL,NULL),(2859,635,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2860,636,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2861,636,'mass_relative_mass',2860,2857,'mean','se',5,0.9217391304347822,NULL,NULL),(2862,636,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2863,637,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2864,637,'mass_relative_mass',2863,2725,'mean','se',5,0.9739130434782609,NULL,NULL),(2865,637,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2866,638,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2867,638,'mass_relative_mass',2866,2863,'mean','se',5,0.960869565217391,NULL,NULL),(2868,638,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2869,639,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2870,639,'mass_relative_mass',2869,2866,'mean','se',5,0.9217391304347822,NULL,NULL),(2871,639,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2872,640,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2873,640,'mass_relative_mass',2872,2728,'mean','se',5,0.9695652173913046,NULL,NULL),(2874,640,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2875,641,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2876,641,'mass_relative_mass',2875,2872,'mean','se',5,0.960869565217391,NULL,NULL),(2877,641,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2878,642,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2879,642,'mass_relative_mass',2878,2875,'mean','se',5,0.9217391304347822,NULL,NULL),(2880,642,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2881,643,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2882,643,'mass_relative_mass',2881,2731,'mean','se',5,0.9173913043478253,NULL,NULL),(2883,643,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2884,644,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2885,644,'mass_relative_mass',2884,2881,'mean','se',5,0.8478260869565216,NULL,NULL),(2886,644,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2887,645,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2888,645,'mass_relative_mass',2887,2884,'mean','se',5,0.7782608695652175,NULL,NULL),(2889,645,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2890,646,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2891,646,'mass_relative_mass',2890,2734,'mean','se',5,0.8565217391304342,NULL,NULL),(2892,646,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2893,647,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2894,647,'mass_relative_mass',2893,2890,'mean','se',5,0.7695652173913041,NULL,NULL),(2895,647,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2896,648,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2897,648,'mass_relative_mass',2896,2893,'mean','se',5,0.756521739130435,NULL,NULL),(2898,648,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2899,649,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2900,649,'mass_relative_mass',2899,2737,'mean','se',5,0.921739130434782,NULL,NULL),(2901,649,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2902,650,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2903,650,'mass_relative_mass',2902,2899,'mean','se',5,0.8521739130434779,NULL,NULL),(2904,650,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2905,651,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2906,651,'mass_relative_mass',2905,2902,'mean','se',5,0.8173913043478254,NULL,NULL),(2907,651,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2908,652,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2909,652,'mass_relative_mass',2908,2740,'mean','se',5,0.9260869565217384,NULL,NULL),(2910,652,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2911,653,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2912,653,'mass_relative_mass',2911,2908,'mean','se',5,0.8826086956521735,NULL,NULL),(2913,653,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2914,654,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2915,654,'mass_relative_mass',2914,2911,'mean','se',5,0.8391304347826085,NULL,NULL),(2916,654,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2917,655,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2918,655,'mass_relative_mass',2917,2743,'mean','se',5,0.921739130434782,NULL,NULL),(2919,655,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2920,656,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2921,656,'mass_relative_mass',2920,2917,'mean','se',5,0.8130434782608691,NULL,NULL),(2922,656,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2923,657,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2924,657,'mass_relative_mass',2923,2920,'mean','se',5,0.7521739130434778,NULL,NULL),(2925,657,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2926,658,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2927,658,'mass_relative_mass',2926,2746,'mean','se',5,0.8652173913043475,NULL,NULL),(2928,658,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2929,659,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2930,659,'mass_relative_mass',2929,2926,'mean','se',5,0.7695652173913041,NULL,NULL),(2931,659,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2932,660,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2933,660,'mass_relative_mass',2932,2929,'mean','se',5,0.7130434782608697,NULL,NULL),(2934,660,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2935,661,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2936,661,'mass_relative_mass',2935,2749,'mean','se',5,0.8956521739130429,NULL,NULL),(2937,661,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2938,662,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2939,662,'mass_relative_mass',2938,2935,'mean','se',5,0.8260869565217388,NULL,NULL),(2940,662,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2941,663,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2942,663,'mass_relative_mass',2941,2938,'mean','se',5,0.6782608695652175,NULL,NULL),(2943,663,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2944,664,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2945,664,'mass_relative_mass',2944,2752,'mean','se',5,0.9173913043478253,NULL,NULL),(2946,664,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2947,665,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2948,665,'mass_relative_mass',2947,2944,'mean','se',5,0.8565217391304342,NULL,NULL),(2949,665,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2950,666,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2951,666,'mass_relative_mass',2950,2947,'mean','se',5,0.7130434782608697,NULL,NULL),(2952,666,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2953,667,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2954,667,'mass_relative_mass',2953,2755,'mean','se',5,0.9130434782608691,NULL,NULL),(2955,667,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2956,668,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2957,668,'mass_relative_mass',2956,2953,'mean','se',5,0.8347826086956516,NULL,NULL),(2958,668,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2959,669,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2960,669,'mass_relative_mass',2959,2956,'mean','se',5,0.8,NULL,NULL),(2961,669,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2962,670,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2963,670,'mass_relative_mass',2962,2758,'mean','se',5,0.9173913043478253,NULL,NULL),(2964,670,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2965,671,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2966,671,'mass_relative_mass',2965,2962,'mean','se',5,0.921739130434782,NULL,NULL),(2967,671,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2968,672,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2969,672,'mass_relative_mass',2968,2965,'mean','se',5,0.9260869565217384,NULL,NULL),(2970,672,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2971,673,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2972,673,'mass_relative_mass',2971,2761,'mean','se',5,0.7347826086956522,NULL,NULL),(2973,673,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2974,674,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2975,674,'mass_relative_mass',2974,2971,'mean','se',5,0.6521739130434782,NULL,NULL),(2976,674,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2977,675,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2978,675,'mass_relative_mass',2977,2974,'mean','se',5,0.23913043478260904,NULL,NULL),(2979,675,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2980,676,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2981,676,'mass_relative_mass',2980,2764,'mean','se',5,0.843478260869565,NULL,NULL),(2982,676,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2983,677,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2984,677,'mass_relative_mass',2983,2980,'mean','se',5,0.5304347826086958,NULL,NULL),(2985,677,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2986,678,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2987,678,'mass_relative_mass',2986,2983,'mean','se',5,0.5086956521739132,NULL,NULL),(2988,678,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2989,679,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2990,679,'mass_relative_mass',2989,2767,'mean','se',5,0.860869565217391,NULL,NULL),(2991,679,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2992,680,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2993,680,'mass_relative_mass',2992,2989,'mean','se',5,0.7086956521739132,NULL,NULL),(2994,680,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2995,681,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2996,681,'mass_relative_mass',2995,2992,'mean','se',5,0.26956521739130435,NULL,NULL),(2997,681,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(2998,682,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(2999,682,'mass_relative_mass',2998,2770,'mean','se',5,0.8913043478260869,NULL,NULL),(3000,682,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3001,683,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(3002,683,'mass_relative_mass',3001,2998,'mean','se',5,0.34782608695652156,NULL,NULL),(3003,683,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3004,684,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(3005,684,'mass_relative_mass',3004,3001,'mean','se',5,0.056521739130434984,NULL,NULL),(3006,684,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3007,685,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(3008,685,'mass_relative_mass',3007,2773,'mean','se',5,0.6260869565217392,NULL,NULL),(3009,685,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3010,686,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(3011,686,'mass_relative_mass',3010,3007,'mean','se',5,0.4391304347826088,NULL,NULL),(3012,686,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3013,687,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(3014,687,'mass_relative_mass',3013,3010,'mean','se',5,0.3217391304347828,NULL,NULL),(3015,687,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3016,688,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(3017,688,'mass_relative_mass',3016,2776,'mean','se',5,0.9254385964912278,NULL,NULL),(3018,688,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3019,689,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(3020,689,'mass_relative_mass',3019,3016,'mean','se',5,0.837719298245614,NULL,NULL),(3021,689,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3022,690,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(3023,690,'mass_relative_mass',3022,3019,'mean','se',5,0.7456140350877192,NULL,NULL),(3024,690,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3025,691,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(3026,691,'mass_relative_mass',3025,2779,'mean','se',5,0.9561403508771928,NULL,NULL),(3027,691,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3028,692,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(3029,692,'mass_relative_mass',3028,3025,'mean','se',5,0.9649122807017539,NULL,NULL),(3030,692,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3031,693,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(3032,693,'mass_relative_mass',3031,3028,'mean','se',5,0.469298245614035,NULL,NULL),(3033,693,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3034,694,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(3035,694,'mass_relative_mass',3034,2782,'mean','se',5,0.9736842105263156,NULL,NULL),(3036,694,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3037,695,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(3038,695,'mass_relative_mass',3037,3034,'mean','se',5,0.8157894736842104,NULL,NULL),(3039,695,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3040,696,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(3041,696,'mass_relative_mass',3040,3037,'mean','se',5,0.45175438596491224,NULL,NULL),(3042,696,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3043,697,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(3044,697,'mass_relative_mass',3043,2785,'mean','se',5,0.9912280701754383,NULL,NULL),(3045,697,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3046,698,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(3047,698,'mass_relative_mass',3046,3043,'mean','se',5,0.9736842105263156,NULL,NULL),(3048,698,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3049,699,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(3050,699,'mass_relative_mass',3049,3046,'mean','se',5,0.9692982456140348,NULL,NULL),(3051,699,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3052,700,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(3053,700,'mass_relative_mass',3052,2788,'mean','se',5,0.9956140350877191,NULL,NULL),(3054,700,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3055,701,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(3056,701,'mass_relative_mass',3055,3052,'mean','se',5,0.864035087719298,NULL,NULL),(3057,701,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3058,702,'mass_absolute',NULL,NULL,'mean',NULL,5,NULL,NULL,NULL),(3059,702,'mass_relative_mass',3058,3055,'mean','se',5,0.7456140350877192,NULL,NULL),(3060,702,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3061,730,'water_table_depth',NULL,NULL,'mean',NULL,NULL,15.447154471544764,NULL,NULL),(3062,740,'water_table_depth',NULL,NULL,'mean',NULL,NULL,18.032786885245855,NULL,NULL),(3063,741,'water_table_depth',NULL,NULL,'mean',NULL,NULL,26.19047619047609,NULL,NULL),(3064,742,'water_table_depth',NULL,NULL,'mean',NULL,NULL,25.806451612903174,NULL,NULL),(3065,743,'water_table_depth',NULL,NULL,'mean',NULL,NULL,36.88524590163928,NULL,NULL),(3066,744,'water_table_depth',NULL,NULL,'mean',NULL,NULL,24.590163934426187,NULL,NULL),(3067,745,'water_table_depth',NULL,NULL,'mean',NULL,NULL,28.5714285714285,NULL,NULL),(3068,746,'water_table_depth',NULL,NULL,'mean',NULL,NULL,30.645161290322562,NULL,NULL),(3069,747,'water_table_depth',NULL,NULL,'mean',NULL,NULL,36.88524590163928,NULL,NULL),(3070,749,'water_table_depth',NULL,NULL,'mean',NULL,NULL,17.213114754098456,NULL,NULL),(3071,750,'water_table_depth',NULL,NULL,'mean',NULL,NULL,23.0158730158729,NULL,NULL),(3072,751,'water_table_depth',NULL,NULL,'mean',NULL,NULL,21.774193548387075,NULL,NULL),(3073,752,'water_table_depth',NULL,NULL,'mean',NULL,NULL,33.60655737704923,NULL,NULL),(3074,753,'water_table_depth',NULL,NULL,'mean',NULL,NULL,33.606557377049114,NULL,NULL),(3075,754,'water_table_depth',NULL,NULL,'mean',NULL,NULL,35.714285714285666,NULL,NULL),(3076,755,'water_table_depth',NULL,NULL,'mean',NULL,NULL,33.06451612903214,NULL,NULL),(3077,756,'water_table_depth',NULL,NULL,'mean',NULL,NULL,41.80327868852447,NULL,NULL),(3078,761,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3079,761,'mass_relative_mass',3078,3078,'mean','se',5,1,0,NULL),(3080,761,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3081,761,'N_relative_mass',3086,3078,'mean',NULL,NULL,0.93,NULL,NULL),(3082,761,'Ca_relative_mass',3087,3078,'mean',NULL,NULL,0.07,NULL,NULL),(3083,761,'C_to_N',3085,3086,'mean',NULL,NULL,47,NULL,NULL),(3084,761,'C_relative_mass',3085,3078,'mean',NULL,NULL,NULL,NULL,NULL),(3085,761,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3086,761,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3087,761,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3088,762,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3089,762,'mass_relative_mass',3088,3088,'mean','se',5,1,0,NULL),(3090,762,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3091,762,'N_relative_mass',3096,3088,'mean',NULL,NULL,0.85,NULL,NULL),(3092,762,'Ca_relative_mass',3097,3088,'mean',NULL,NULL,0.05,NULL,NULL),(3093,762,'C_to_N',3095,3096,'mean',NULL,NULL,50,NULL,NULL),(3094,762,'C_relative_mass',3095,3088,'mean',NULL,NULL,NULL,NULL,NULL),(3095,762,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3096,762,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3097,762,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3098,763,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3099,763,'mass_relative_mass',3098,3098,'mean','se',5,1,0,NULL),(3100,763,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3101,763,'N_relative_mass',3106,3098,'mean',NULL,NULL,0.95,NULL,NULL),(3102,763,'Ca_relative_mass',3107,3098,'mean',NULL,NULL,0.02,NULL,NULL),(3103,763,'C_to_N',3105,3106,'mean',NULL,NULL,46,NULL,NULL),(3104,763,'C_relative_mass',3105,3098,'mean',NULL,NULL,NULL,NULL,NULL),(3105,763,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3106,763,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3107,763,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3108,764,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3109,764,'mass_relative_mass',3108,3108,'mean','se',5,1,0,NULL),(3110,764,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3111,764,'N_relative_mass',3116,3108,'mean',NULL,NULL,1.19,NULL,NULL),(3112,764,'Ca_relative_mass',3117,3108,'mean',NULL,NULL,0.05,NULL,NULL),(3113,764,'C_to_N',3115,3116,'mean',NULL,NULL,35,NULL,NULL),(3114,764,'C_relative_mass',3115,3108,'mean',NULL,NULL,NULL,NULL,NULL),(3115,764,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3116,764,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3117,764,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3118,765,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3119,765,'mass_relative_mass',3118,3118,'mean','se',5,1,0,NULL),(3120,765,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3121,765,'N_relative_mass',3126,3118,'mean',NULL,NULL,1.19,NULL,NULL),(3122,765,'Ca_relative_mass',3127,3118,'mean',NULL,NULL,0.05,NULL,NULL),(3123,765,'C_to_N',3125,3126,'mean',NULL,NULL,35,NULL,NULL),(3124,765,'C_relative_mass',3125,3118,'mean',NULL,NULL,NULL,NULL,NULL),(3125,765,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3126,765,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3127,765,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3128,766,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3129,766,'mass_relative_mass',3128,3128,'mean','se',5,1,0,NULL),(3130,766,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3131,766,'N_relative_mass',3136,3128,'mean',NULL,NULL,1.19,NULL,NULL),(3132,766,'Ca_relative_mass',3137,3128,'mean',NULL,NULL,0.05,NULL,NULL),(3133,766,'C_to_N',3135,3136,'mean',NULL,NULL,35,NULL,NULL),(3134,766,'C_relative_mass',3135,3128,'mean',NULL,NULL,NULL,NULL,NULL),(3135,766,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3136,766,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3137,766,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3138,767,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3139,767,'mass_relative_mass',3138,3138,'mean','se',5,1,0,NULL),(3140,767,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3141,767,'N_relative_mass',3146,3138,'mean',NULL,NULL,1.19,NULL,NULL),(3142,767,'Ca_relative_mass',3147,3138,'mean',NULL,NULL,0.05,NULL,NULL),(3143,767,'C_to_N',3145,3146,'mean',NULL,NULL,35,NULL,NULL),(3144,767,'C_relative_mass',3145,3138,'mean',NULL,NULL,NULL,NULL,NULL),(3145,767,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3146,767,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3147,767,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3148,768,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3149,768,'mass_relative_mass',3148,3078,'mean','se',5,0.622907488986784,0.010572687224669641,NULL),(3150,768,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3151,768,'N_relative_mass',3156,3148,'mean',NULL,NULL,NULL,NULL,NULL),(3152,768,'Ca_relative_mass',3157,3148,'mean',NULL,NULL,NULL,NULL,NULL),(3153,768,'C_to_N',3155,3156,'mean',NULL,NULL,NULL,NULL,NULL),(3154,768,'C_relative_mass',3155,3148,'mean',NULL,NULL,NULL,NULL,NULL),(3155,768,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3156,768,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3157,768,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3158,769,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3159,769,'mass_relative_mass',3158,3078,'mean','se',5,0.5400881057268723,0.00528634361233471,NULL),(3160,769,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3161,769,'N_relative_mass',3166,3158,'mean',NULL,NULL,NULL,NULL,NULL),(3162,769,'Ca_relative_mass',3167,3158,'mean',NULL,NULL,NULL,NULL,NULL),(3163,769,'C_to_N',3165,3166,'mean',NULL,NULL,NULL,NULL,NULL),(3164,769,'C_relative_mass',3165,3158,'mean',NULL,NULL,NULL,NULL,NULL),(3165,769,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3166,769,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3167,769,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3168,770,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3169,770,'mass_relative_mass',3168,3078,'mean','se',5,0.42555066079295156,0.03348017621145377,NULL),(3170,770,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3171,770,'N_relative_mass',3176,3168,'mean',NULL,NULL,NULL,NULL,NULL),(3172,770,'Ca_relative_mass',3177,3168,'mean',NULL,NULL,NULL,NULL,NULL),(3173,770,'C_to_N',3175,3176,'mean',NULL,NULL,NULL,NULL,NULL),(3174,770,'C_relative_mass',3175,3168,'mean',NULL,NULL,NULL,NULL,NULL),(3175,770,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3176,770,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3177,770,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3178,771,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3179,771,'mass_relative_mass',3178,3078,'mean','se',5,0.2458149779735683,0.02466960352422906,NULL),(3180,771,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3181,771,'N_relative_mass',3186,3178,'mean',NULL,NULL,NULL,NULL,NULL),(3182,771,'Ca_relative_mass',3187,3178,'mean',NULL,NULL,NULL,NULL,NULL),(3183,771,'C_to_N',3185,3186,'mean',NULL,NULL,NULL,NULL,NULL),(3184,771,'C_relative_mass',3185,3178,'mean',NULL,NULL,NULL,NULL,NULL),(3185,771,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3186,771,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3187,771,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3188,772,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3189,772,'mass_relative_mass',3188,3088,'mean','se',5,0.8185022026431718,0.021145374449339283,NULL),(3190,772,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3191,772,'N_relative_mass',3196,3188,'mean',NULL,NULL,NULL,NULL,NULL),(3192,772,'Ca_relative_mass',3197,3188,'mean',NULL,NULL,NULL,NULL,NULL),(3193,772,'C_to_N',3195,3196,'mean',NULL,NULL,NULL,NULL,NULL),(3194,772,'C_relative_mass',3195,3188,'mean',NULL,NULL,NULL,NULL,NULL),(3195,772,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3196,772,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3197,772,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3198,773,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3199,773,'mass_relative_mass',3198,3088,'mean','se',5,0.788546255506608,0.047577092511013164,NULL),(3200,773,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3201,773,'N_relative_mass',3206,3198,'mean',NULL,NULL,NULL,NULL,NULL),(3202,773,'Ca_relative_mass',3207,3198,'mean',NULL,NULL,NULL,NULL,NULL),(3203,773,'C_to_N',3205,3206,'mean',NULL,NULL,NULL,NULL,NULL),(3204,773,'C_relative_mass',3205,3198,'mean',NULL,NULL,NULL,NULL,NULL),(3205,773,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3206,773,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3207,773,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3208,774,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3209,774,'mass_relative_mass',3208,3088,'mean','se',5,0.7162995594713656,0.005286343612334821,NULL),(3210,774,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3211,774,'N_relative_mass',3216,3208,'mean',NULL,NULL,NULL,NULL,NULL),(3212,774,'Ca_relative_mass',3217,3208,'mean',NULL,NULL,NULL,NULL,NULL),(3213,774,'C_to_N',3215,3216,'mean',NULL,NULL,NULL,NULL,NULL),(3214,774,'C_relative_mass',3215,3208,'mean',NULL,NULL,NULL,NULL,NULL),(3215,774,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3216,774,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3217,774,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3218,775,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3219,775,'mass_relative_mass',3218,3088,'mean','se',5,0.6405286343612335,0.01585903083700435,NULL),(3220,775,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3221,775,'N_relative_mass',3226,3218,'mean',NULL,NULL,NULL,NULL,NULL),(3222,775,'Ca_relative_mass',3227,3218,'mean',NULL,NULL,NULL,NULL,NULL),(3223,775,'C_to_N',3225,3226,'mean',NULL,NULL,NULL,NULL,NULL),(3224,775,'C_relative_mass',3225,3218,'mean',NULL,NULL,NULL,NULL,NULL),(3225,775,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3226,775,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3227,775,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3228,776,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3229,776,'mass_relative_mass',3228,3098,'mean','se',5,0.6704845814977973,0.012334801762114544,NULL),(3230,776,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3231,776,'N_relative_mass',3236,3228,'mean',NULL,NULL,NULL,NULL,NULL),(3232,776,'Ca_relative_mass',3237,3228,'mean',NULL,NULL,NULL,NULL,NULL),(3233,776,'C_to_N',3235,3236,'mean',NULL,NULL,NULL,NULL,NULL),(3234,776,'C_relative_mass',3235,3228,'mean',NULL,NULL,NULL,NULL,NULL),(3235,776,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3236,776,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3237,776,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3238,777,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3239,777,'mass_relative_mass',3238,3098,'mean','se',5,0.5806167400881057,0.012334801762114433,NULL),(3240,777,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3241,777,'N_relative_mass',3246,3238,'mean',NULL,NULL,NULL,NULL,NULL),(3242,777,'Ca_relative_mass',3247,3238,'mean',NULL,NULL,NULL,NULL,NULL),(3243,777,'C_to_N',3245,3246,'mean',NULL,NULL,NULL,NULL,NULL),(3244,777,'C_relative_mass',3245,3238,'mean',NULL,NULL,NULL,NULL,NULL),(3245,777,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3246,777,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3247,777,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3248,778,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3249,778,'mass_relative_mass',3248,3098,'mean','se',5,0.5682819383259912,0.008810572687224627,NULL),(3250,778,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3251,778,'N_relative_mass',3256,3248,'mean',NULL,NULL,NULL,NULL,NULL),(3252,778,'Ca_relative_mass',3257,3248,'mean',NULL,NULL,NULL,NULL,NULL),(3253,778,'C_to_N',3255,3256,'mean',NULL,NULL,NULL,NULL,NULL),(3254,778,'C_relative_mass',3255,3248,'mean',NULL,NULL,NULL,NULL,NULL),(3255,778,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3256,778,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3257,778,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3258,779,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3259,779,'mass_relative_mass',3258,3098,'mean','se',5,0.4766519823788547,0.02114537444933917,NULL),(3260,779,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3261,779,'N_relative_mass',3266,3258,'mean',NULL,NULL,NULL,NULL,NULL),(3262,779,'Ca_relative_mass',3267,3258,'mean',NULL,NULL,NULL,NULL,NULL),(3263,779,'C_to_N',3265,3266,'mean',NULL,NULL,NULL,NULL,NULL),(3264,779,'C_relative_mass',3265,3258,'mean',NULL,NULL,NULL,NULL,NULL),(3265,779,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3266,779,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3267,779,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3268,780,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3269,780,'mass_relative_mass',3268,3108,'mean','se',5,0.5524229074889868,0.008810572687224516,NULL),(3270,780,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3271,780,'N_relative_mass',3276,3268,'mean',NULL,NULL,NULL,NULL,NULL),(3272,780,'Ca_relative_mass',3277,3268,'mean',NULL,NULL,NULL,NULL,NULL),(3273,780,'C_to_N',3275,3276,'mean',NULL,NULL,NULL,NULL,NULL),(3274,780,'C_relative_mass',3275,3268,'mean',NULL,NULL,NULL,NULL,NULL),(3275,780,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3276,780,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3277,780,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3278,781,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3279,781,'mass_relative_mass',3278,3108,'mean','se',5,0.5083700440528635,0.014096916299559337,NULL),(3280,781,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3281,781,'N_relative_mass',3286,3278,'mean',NULL,NULL,NULL,NULL,NULL),(3282,781,'Ca_relative_mass',3287,3278,'mean',NULL,NULL,NULL,NULL,NULL),(3283,781,'C_to_N',3285,3286,'mean',NULL,NULL,NULL,NULL,NULL),(3284,781,'C_relative_mass',3285,3278,'mean',NULL,NULL,NULL,NULL,NULL),(3285,781,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3286,781,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3287,781,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3288,782,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3289,782,'mass_relative_mass',3288,3118,'mean','se',5,0.5956989247311829,0.006881720430107485,NULL),(3290,782,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3291,782,'N_relative_mass',3296,3288,'mean',NULL,NULL,NULL,NULL,NULL),(3292,782,'Ca_relative_mass',3297,3288,'mean',NULL,NULL,NULL,NULL,NULL),(3293,782,'C_to_N',3295,3296,'mean',NULL,NULL,NULL,NULL,NULL),(3294,782,'C_relative_mass',3295,3288,'mean',NULL,NULL,NULL,NULL,NULL),(3295,782,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3296,782,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3297,782,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3298,783,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3299,783,'mass_relative_mass',3298,3118,'mean','se',5,0.45290322580645176,0.010322580645161172,NULL),(3300,783,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3301,783,'N_relative_mass',3306,3298,'mean',NULL,NULL,NULL,NULL,NULL),(3302,783,'Ca_relative_mass',3307,3298,'mean',NULL,NULL,NULL,NULL,NULL),(3303,783,'C_to_N',3305,3306,'mean',NULL,NULL,NULL,NULL,NULL),(3304,783,'C_relative_mass',3305,3298,'mean',NULL,NULL,NULL,NULL,NULL),(3305,783,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3306,783,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3307,783,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3308,784,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3309,784,'mass_relative_mass',3308,3118,'mean','se',5,0.346236559139785,0.022365591397849494,NULL),(3310,784,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3311,784,'N_relative_mass',3316,3308,'mean',NULL,NULL,NULL,NULL,NULL),(3312,784,'Ca_relative_mass',3317,3308,'mean',NULL,NULL,NULL,NULL,NULL),(3313,784,'C_to_N',3315,3316,'mean',NULL,NULL,NULL,NULL,NULL),(3314,784,'C_relative_mass',3315,3308,'mean',NULL,NULL,NULL,NULL,NULL),(3315,784,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3316,784,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3317,784,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3318,785,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3319,785,'mass_relative_mass',3318,3118,'mean','se',5,0.2464516129032258,0.06021505376344091,NULL),(3320,785,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3321,785,'N_relative_mass',3326,3318,'mean',NULL,NULL,NULL,NULL,NULL),(3322,785,'Ca_relative_mass',3327,3318,'mean',NULL,NULL,NULL,NULL,NULL),(3323,785,'C_to_N',3325,3326,'mean',NULL,NULL,NULL,NULL,NULL),(3324,785,'C_relative_mass',3325,3318,'mean',NULL,NULL,NULL,NULL,NULL),(3325,785,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3326,785,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3327,785,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3328,786,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3329,786,'mass_relative_mass',3328,3128,'mean','se',5,0.6490322580645161,0.015483870967741953,NULL),(3330,786,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3331,786,'N_relative_mass',3336,3328,'mean',NULL,NULL,NULL,NULL,NULL),(3332,786,'Ca_relative_mass',3337,3328,'mean',NULL,NULL,NULL,NULL,NULL),(3333,786,'C_to_N',3335,3336,'mean',NULL,NULL,NULL,NULL,NULL),(3334,786,'C_relative_mass',3335,3328,'mean',NULL,NULL,NULL,NULL,NULL),(3335,786,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3336,786,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3337,786,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3338,787,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3339,787,'mass_relative_mass',3338,3128,'mean','se',5,0.5630107526881721,0.008602150537634357,NULL),(3340,787,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3341,787,'N_relative_mass',3346,3338,'mean',NULL,NULL,NULL,NULL,NULL),(3342,787,'Ca_relative_mass',3347,3338,'mean',NULL,NULL,NULL,NULL,NULL),(3343,787,'C_to_N',3345,3346,'mean',NULL,NULL,NULL,NULL,NULL),(3344,787,'C_relative_mass',3345,3338,'mean',NULL,NULL,NULL,NULL,NULL),(3345,787,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3346,787,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3347,787,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3348,788,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3349,788,'mass_relative_mass',3348,3128,'mean','se',5,0.5440860215053764,0.0120430107526881,NULL),(3350,788,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3351,788,'N_relative_mass',3356,3348,'mean',NULL,NULL,NULL,NULL,NULL),(3352,788,'Ca_relative_mass',3357,3348,'mean',NULL,NULL,NULL,NULL,NULL),(3353,788,'C_to_N',3355,3356,'mean',NULL,NULL,NULL,NULL,NULL),(3354,788,'C_relative_mass',3355,3348,'mean',NULL,NULL,NULL,NULL,NULL),(3355,788,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3356,788,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3357,788,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3358,789,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3359,789,'mass_relative_mass',3358,3128,'mean','se',5,0.48731182795698935,0.0120430107526881,NULL),(3360,789,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3361,789,'N_relative_mass',3366,3358,'mean',NULL,NULL,NULL,NULL,NULL),(3362,789,'Ca_relative_mass',3367,3358,'mean',NULL,NULL,NULL,NULL,NULL),(3363,789,'C_to_N',3365,3366,'mean',NULL,NULL,NULL,NULL,NULL),(3364,789,'C_relative_mass',3365,3358,'mean',NULL,NULL,NULL,NULL,NULL),(3365,789,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3366,789,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3367,789,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3368,790,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3369,790,'mass_relative_mass',3368,3138,'mean','se',5,0.6043010752688172,0.008602150537634579,NULL),(3370,790,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3371,790,'N_relative_mass',3376,3368,'mean',NULL,NULL,NULL,NULL,NULL),(3372,790,'Ca_relative_mass',3377,3368,'mean',NULL,NULL,NULL,NULL,NULL),(3373,790,'C_to_N',3375,3376,'mean',NULL,NULL,NULL,NULL,NULL),(3374,790,'C_relative_mass',3375,3368,'mean',NULL,NULL,NULL,NULL,NULL),(3375,790,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3376,790,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3377,790,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3378,791,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3379,791,'mass_relative_mass',3378,3138,'mean','se',5,0.5595698924731184,0.022365591397849327,NULL),(3380,791,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3381,791,'N_relative_mass',3386,3378,'mean',NULL,NULL,NULL,NULL,NULL),(3382,791,'Ca_relative_mass',3387,3378,'mean',NULL,NULL,NULL,NULL,NULL),(3383,791,'C_to_N',3385,3386,'mean',NULL,NULL,NULL,NULL,NULL),(3384,791,'C_relative_mass',3385,3378,'mean',NULL,NULL,NULL,NULL,NULL),(3385,791,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3386,791,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3387,791,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3388,792,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3389,792,'mass_relative_mass',3388,3138,'mean','se',5,0.5079569892473118,0.01204301075268821,NULL),(3390,792,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3391,792,'N_relative_mass',3396,3388,'mean',NULL,NULL,NULL,NULL,NULL),(3392,792,'Ca_relative_mass',3397,3388,'mean',NULL,NULL,NULL,NULL,NULL),(3393,792,'C_to_N',3395,3396,'mean',NULL,NULL,NULL,NULL,NULL),(3394,792,'C_relative_mass',3395,3388,'mean',NULL,NULL,NULL,NULL,NULL),(3395,792,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3396,792,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3397,792,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3398,793,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3399,793,'mass_relative_mass',3398,3138,'mean','se',5,0.43397849462365595,0.012043010752688155,NULL),(3400,793,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(3401,793,'N_relative_mass',3406,3398,'mean',NULL,NULL,NULL,NULL,NULL),(3402,793,'Ca_relative_mass',3407,3398,'mean',NULL,NULL,NULL,NULL,NULL),(3403,793,'C_to_N',3405,3406,'mean',NULL,NULL,NULL,NULL,NULL),(3404,793,'C_relative_mass',3405,3398,'mean',NULL,NULL,NULL,NULL,NULL),(3405,793,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3406,793,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3407,793,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3408,794,'water_table_depth',NULL,NULL,'mean',NULL,NULL,5.5,NULL,NULL),(3409,795,'water_table_depth',NULL,NULL,'mean',NULL,NULL,-5.1,NULL,NULL),(3410,796,'water_table_depth',NULL,NULL,'mean',NULL,NULL,-3.6,NULL,NULL),(3411,797,'water_table_depth',NULL,NULL,'mean',NULL,NULL,-1.5,NULL,NULL),(3412,798,'pH',NULL,NULL,'mean',NULL,NULL,6.2,NULL,NULL),(3413,799,'pH',NULL,NULL,'mean',NULL,NULL,6.7,NULL,NULL),(3414,800,'pH',NULL,NULL,'mean',NULL,NULL,3.8,NULL,NULL),(3415,801,'pH',NULL,NULL,'mean',NULL,NULL,3.9,NULL,NULL),(3416,805,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3417,805,'mass_relative_mass',3416,3416,'mean','se',8,1,0,NULL),(3418,805,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3419,805,'C_to_N',3421,3420,'mean','se',8,54,1,NULL),(3420,805,'N_relative_mass',3424,3416,'mean','se',8,0.009,0.0002,NULL),(3421,805,'C_relative_mass',3423,3416,'mean',NULL,NULL,NULL,NULL,NULL),(3422,805,'P_relative_mass',3425,3416,'mean','se',8,0.00053,0.000029999999999999997,NULL),(3423,805,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3424,805,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3425,805,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3426,805,'N_relative_mass',3424,3424,'mean',NULL,NULL,NULL,NULL,NULL),(3427,805,'P_relative_mass',3425,3425,'mean',NULL,NULL,NULL,NULL,NULL),(3428,805,'temperature',NULL,NULL,'mean',NULL,NULL,284.54999999999995,NULL,NULL),(3429,805,'water_table_depth',NULL,NULL,'mean',NULL,NULL,5,NULL,NULL),(3430,806,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3431,806,'mass_relative_mass',3430,3430,'mean','se',8,1,0,NULL),(3432,806,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3433,806,'C_to_N',3435,3434,'mean','se',8,63,1,NULL),(3434,806,'N_relative_mass',3438,3430,'mean','se',8,0.008,0.0001,NULL),(3435,806,'C_relative_mass',3437,3430,'mean',NULL,NULL,NULL,NULL,NULL),(3436,806,'P_relative_mass',3439,3430,'mean','se',8,0.00064,0.00004,NULL),(3437,806,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3438,806,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3439,806,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3440,806,'N_relative_mass',3438,3438,'mean',NULL,NULL,NULL,NULL,NULL),(3441,806,'P_relative_mass',3439,3439,'mean',NULL,NULL,NULL,NULL,NULL),(3442,806,'temperature',NULL,NULL,'mean',NULL,NULL,284.54999999999995,NULL,NULL),(3443,806,'water_table_depth',NULL,NULL,'mean',NULL,NULL,5,NULL,NULL),(3444,807,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3445,807,'mass_relative_mass',3444,3444,'mean','se',6,1,0,NULL),(3446,807,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3447,807,'C_to_N',3449,3448,'mean','se',6,49,2,NULL),(3448,807,'N_relative_mass',3452,3444,'mean','se',6,0.0099,0.0003,NULL),(3449,807,'C_relative_mass',3451,3444,'mean',NULL,NULL,NULL,NULL,NULL),(3450,807,'P_relative_mass',3453,3444,'mean','se',6,0.00094,0.00011999999999999999,NULL),(3451,807,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3452,807,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3453,807,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3454,807,'N_relative_mass',3452,3452,'mean',NULL,NULL,NULL,NULL,NULL),(3455,807,'P_relative_mass',3453,3453,'mean',NULL,NULL,NULL,NULL,NULL),(3456,807,'temperature',NULL,NULL,'mean',NULL,NULL,284.54999999999995,NULL,NULL),(3457,807,'water_table_depth',NULL,NULL,'mean',NULL,NULL,5,NULL,NULL),(3458,808,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3459,808,'mass_relative_mass',3458,3458,'mean','se',8,1,0,NULL),(3460,808,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3461,808,'C_to_N',3463,3462,'mean','se',8,54,1,NULL),(3462,808,'N_relative_mass',3466,3458,'mean','se',8,0.009,0.0002,NULL),(3463,808,'C_relative_mass',3465,3458,'mean',NULL,NULL,NULL,NULL,NULL),(3464,808,'P_relative_mass',3467,3458,'mean','se',8,0.00053,0.000029999999999999997,NULL),(3465,808,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3466,808,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3467,808,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3468,808,'N_relative_mass',3466,3466,'mean',NULL,NULL,NULL,NULL,NULL),(3469,808,'P_relative_mass',3467,3467,'mean',NULL,NULL,NULL,NULL,NULL),(3470,808,'temperature',NULL,NULL,'mean',NULL,NULL,284.54999999999995,NULL,NULL),(3471,808,'water_table_depth',NULL,NULL,'mean',NULL,NULL,5,NULL,NULL),(3472,809,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3473,809,'mass_relative_mass',3472,3472,'mean','se',8,1,0,NULL),(3474,809,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3475,809,'C_to_N',3477,3476,'mean','se',8,63,1,NULL),(3476,809,'N_relative_mass',3480,3472,'mean','se',8,0.008,0.0001,NULL),(3477,809,'C_relative_mass',3479,3472,'mean',NULL,NULL,NULL,NULL,NULL),(3478,809,'P_relative_mass',3481,3472,'mean','se',8,0.00064,0.00004,NULL),(3479,809,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3480,809,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3481,809,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3482,809,'N_relative_mass',3480,3480,'mean',NULL,NULL,NULL,NULL,NULL),(3483,809,'P_relative_mass',3481,3481,'mean',NULL,NULL,NULL,NULL,NULL),(3484,809,'temperature',NULL,NULL,'mean',NULL,NULL,284.54999999999995,NULL,NULL),(3485,809,'water_table_depth',NULL,NULL,'mean',NULL,NULL,5,NULL,NULL),(3486,810,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3487,810,'mass_relative_mass',3486,3486,'mean','se',6,1,0,NULL),(3488,810,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3489,810,'C_to_N',3491,3490,'mean','se',6,49,2,NULL),(3490,810,'N_relative_mass',3494,3486,'mean','se',6,0.0099,0.0003,NULL),(3491,810,'C_relative_mass',3493,3486,'mean',NULL,NULL,NULL,NULL,NULL),(3492,810,'P_relative_mass',3495,3486,'mean','se',6,0.00094,0.00011999999999999999,NULL),(3493,810,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3494,810,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3495,810,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3496,810,'N_relative_mass',3494,3494,'mean',NULL,NULL,NULL,NULL,NULL),(3497,810,'P_relative_mass',3495,3495,'mean',NULL,NULL,NULL,NULL,NULL),(3498,810,'temperature',NULL,NULL,'mean',NULL,NULL,284.54999999999995,NULL,NULL),(3499,810,'water_table_depth',NULL,NULL,'mean',NULL,NULL,5,NULL,NULL),(3500,811,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3501,811,'mass_relative_mass',3500,3416,'mean','se',8,0.9,0.01,NULL),(3502,811,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3503,811,'C_to_N',3505,3504,'mean',NULL,NULL,NULL,NULL,NULL),(3504,811,'N_relative_mass',3508,3500,'mean',NULL,NULL,NULL,NULL,NULL),(3505,811,'C_relative_mass',3507,3500,'mean',NULL,NULL,NULL,NULL,NULL),(3506,811,'P_relative_mass',3509,3500,'mean',NULL,NULL,NULL,NULL,NULL),(3507,811,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3508,811,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3509,811,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3510,811,'N_relative_mass',3508,3424,'mean','se',8,0.67,0.03,NULL),(3511,811,'P_relative_mass',3509,3425,'mean','se',8,0.51,0.01,NULL),(3512,811,'temperature',NULL,NULL,'mean',NULL,NULL,284.54999999999995,NULL,NULL),(3513,811,'water_table_depth',NULL,NULL,'mean',NULL,NULL,5,NULL,NULL),(3514,812,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3515,812,'mass_relative_mass',3514,3430,'mean','se',8,0.89,0.02,NULL),(3516,812,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3517,812,'C_to_N',3519,3518,'mean',NULL,NULL,NULL,NULL,NULL),(3518,812,'N_relative_mass',3522,3514,'mean',NULL,NULL,NULL,NULL,NULL),(3519,812,'C_relative_mass',3521,3514,'mean',NULL,NULL,NULL,NULL,NULL),(3520,812,'P_relative_mass',3523,3514,'mean',NULL,NULL,NULL,NULL,NULL),(3521,812,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3522,812,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3523,812,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3524,812,'N_relative_mass',3522,3438,'mean','se',8,0.74,0.02,NULL),(3525,812,'P_relative_mass',3523,3439,'mean','se',8,0.41,0.02,NULL),(3526,812,'temperature',NULL,NULL,'mean',NULL,NULL,284.54999999999995,NULL,NULL),(3527,812,'water_table_depth',NULL,NULL,'mean',NULL,NULL,5,NULL,NULL),(3528,813,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3529,813,'mass_relative_mass',3528,3444,'mean','se',6,0.79,0.03,NULL),(3530,813,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3531,813,'C_to_N',3533,3532,'mean',NULL,NULL,NULL,NULL,NULL),(3532,813,'N_relative_mass',3536,3528,'mean',NULL,NULL,NULL,NULL,NULL),(3533,813,'C_relative_mass',3535,3528,'mean',NULL,NULL,NULL,NULL,NULL),(3534,813,'P_relative_mass',3537,3528,'mean',NULL,NULL,NULL,NULL,NULL),(3535,813,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3536,813,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3537,813,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3538,813,'N_relative_mass',3536,3452,'mean','se',6,0.46,0.01,NULL),(3539,813,'P_relative_mass',3537,3453,'mean','se',6,0.23,0.01,NULL),(3540,813,'temperature',NULL,NULL,'mean',NULL,NULL,284.54999999999995,NULL,NULL),(3541,813,'water_table_depth',NULL,NULL,'mean',NULL,NULL,5,NULL,NULL),(3542,814,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3543,814,'mass_relative_mass',3542,3416,'mean','se',8,0.85,0.01,NULL),(3544,814,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3545,814,'C_to_N',3547,3546,'mean',NULL,NULL,NULL,NULL,NULL),(3546,814,'N_relative_mass',3550,3542,'mean',NULL,NULL,NULL,NULL,NULL),(3547,814,'C_relative_mass',3549,3542,'mean',NULL,NULL,NULL,NULL,NULL),(3548,814,'P_relative_mass',3551,3542,'mean',NULL,NULL,NULL,NULL,NULL),(3549,814,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3550,814,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3551,814,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3552,814,'N_relative_mass',3550,3424,'mean','se',8,0.61,0.01,NULL),(3553,814,'P_relative_mass',3551,3425,'mean','se',8,0.42,0.02,NULL),(3554,814,'temperature',NULL,NULL,'mean',NULL,NULL,284.54999999999995,NULL,NULL),(3555,814,'water_table_depth',NULL,NULL,'mean',NULL,NULL,5,NULL,NULL),(3556,815,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3557,815,'mass_relative_mass',3556,3430,'mean','se',8,0.77,0.01,NULL),(3558,815,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3559,815,'C_to_N',3561,3560,'mean',NULL,NULL,NULL,NULL,NULL),(3560,815,'N_relative_mass',3564,3556,'mean',NULL,NULL,NULL,NULL,NULL),(3561,815,'C_relative_mass',3563,3556,'mean',NULL,NULL,NULL,NULL,NULL),(3562,815,'P_relative_mass',3565,3556,'mean',NULL,NULL,NULL,NULL,NULL),(3563,815,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3564,815,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3565,815,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3566,815,'N_relative_mass',3564,3438,'mean','se',8,0.63,0.02,NULL),(3567,815,'P_relative_mass',3565,3439,'mean','se',8,0.33,0.01,NULL),(3568,815,'temperature',NULL,NULL,'mean',NULL,NULL,284.54999999999995,NULL,NULL),(3569,815,'water_table_depth',NULL,NULL,'mean',NULL,NULL,5,NULL,NULL),(3570,816,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3571,816,'mass_relative_mass',3570,3444,'mean','se',6,0.71,0.03,NULL),(3572,816,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3573,816,'C_to_N',3575,3574,'mean',NULL,NULL,NULL,NULL,NULL),(3574,816,'N_relative_mass',3578,3570,'mean',NULL,NULL,NULL,NULL,NULL),(3575,816,'C_relative_mass',3577,3570,'mean',NULL,NULL,NULL,NULL,NULL),(3576,816,'P_relative_mass',3579,3570,'mean',NULL,NULL,NULL,NULL,NULL),(3577,816,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3578,816,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3579,816,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3580,816,'N_relative_mass',3578,3452,'mean','se',6,0.4,0.03,NULL),(3581,816,'P_relative_mass',3579,3453,'mean','se',6,0.18,0.03,NULL),(3582,816,'temperature',NULL,NULL,'mean',NULL,NULL,284.54999999999995,NULL,NULL),(3583,816,'water_table_depth',NULL,NULL,'mean',NULL,NULL,5,NULL,NULL),(3584,817,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3585,817,'mass_relative_mass',3584,3458,'mean','se',8,0.98,0.01,NULL),(3586,817,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3587,817,'C_to_N',3589,3588,'mean',NULL,NULL,NULL,NULL,NULL),(3588,817,'N_relative_mass',3592,3584,'mean',NULL,NULL,NULL,NULL,NULL),(3589,817,'C_relative_mass',3591,3584,'mean',NULL,NULL,NULL,NULL,NULL),(3590,817,'P_relative_mass',3593,3584,'mean',NULL,NULL,NULL,NULL,NULL),(3591,817,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3592,817,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3593,817,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3594,817,'N_relative_mass',3592,3466,'mean','se',8,0.65,0.03,NULL),(3595,817,'P_relative_mass',3593,3467,'mean','se',8,0.52,0.04,NULL),(3596,817,'temperature',NULL,NULL,'mean',NULL,NULL,284.54999999999995,NULL,NULL),(3597,817,'water_table_depth',NULL,NULL,'mean',NULL,NULL,5,NULL,NULL),(3598,818,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3599,818,'mass_relative_mass',3598,3472,'mean','se',8,0.96,0.01,NULL),(3600,818,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3601,818,'C_to_N',3603,3602,'mean',NULL,NULL,NULL,NULL,NULL),(3602,818,'N_relative_mass',3606,3598,'mean',NULL,NULL,NULL,NULL,NULL),(3603,818,'C_relative_mass',3605,3598,'mean',NULL,NULL,NULL,NULL,NULL),(3604,818,'P_relative_mass',3607,3598,'mean',NULL,NULL,NULL,NULL,NULL),(3605,818,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3606,818,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3607,818,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3608,818,'N_relative_mass',3606,3480,'mean','se',8,0.7,0.02,NULL),(3609,818,'P_relative_mass',3607,3481,'mean','se',8,0.39,0.03,NULL),(3610,818,'temperature',NULL,NULL,'mean',NULL,NULL,284.54999999999995,NULL,NULL),(3611,818,'water_table_depth',NULL,NULL,'mean',NULL,NULL,5,NULL,NULL),(3612,819,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3613,819,'mass_relative_mass',3612,3486,'mean','se',6,0.9,0.03,NULL),(3614,819,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3615,819,'C_to_N',3617,3616,'mean',NULL,NULL,NULL,NULL,NULL),(3616,819,'N_relative_mass',3620,3612,'mean',NULL,NULL,NULL,NULL,NULL),(3617,819,'C_relative_mass',3619,3612,'mean',NULL,NULL,NULL,NULL,NULL),(3618,819,'P_relative_mass',3621,3612,'mean',NULL,NULL,NULL,NULL,NULL),(3619,819,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3620,819,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3621,819,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3622,819,'N_relative_mass',3620,3494,'mean','se',6,0.45,0.01,NULL),(3623,819,'P_relative_mass',3621,3495,'mean','se',6,0.23,0.02,NULL),(3624,819,'temperature',NULL,NULL,'mean',NULL,NULL,284.54999999999995,NULL,NULL),(3625,819,'water_table_depth',NULL,NULL,'mean',NULL,NULL,5,NULL,NULL),(3626,820,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3627,820,'mass_relative_mass',3626,3458,'mean','se',8,0.91,0,NULL),(3628,820,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3629,820,'C_to_N',3631,3630,'mean',NULL,NULL,NULL,NULL,NULL),(3630,820,'N_relative_mass',3634,3626,'mean',NULL,NULL,NULL,NULL,NULL),(3631,820,'C_relative_mass',3633,3626,'mean',NULL,NULL,NULL,NULL,NULL),(3632,820,'P_relative_mass',3635,3626,'mean',NULL,NULL,NULL,NULL,NULL),(3633,820,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3634,820,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3635,820,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3636,820,'N_relative_mass',3634,3466,'mean','se',8,0.55,0.03,NULL),(3637,820,'P_relative_mass',3635,3467,'mean','se',8,0.37,0.02,NULL),(3638,820,'temperature',NULL,NULL,'mean',NULL,NULL,284.54999999999995,NULL,NULL),(3639,820,'water_table_depth',NULL,NULL,'mean',NULL,NULL,5,NULL,NULL),(3640,821,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3641,821,'mass_relative_mass',3640,3472,'mean','se',8,0.87,0.01,NULL),(3642,821,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3643,821,'C_to_N',3645,3644,'mean',NULL,NULL,NULL,NULL,NULL),(3644,821,'N_relative_mass',3648,3640,'mean',NULL,NULL,NULL,NULL,NULL),(3645,821,'C_relative_mass',3647,3640,'mean',NULL,NULL,NULL,NULL,NULL),(3646,821,'P_relative_mass',3649,3640,'mean',NULL,NULL,NULL,NULL,NULL),(3647,821,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3648,821,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3649,821,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3650,821,'N_relative_mass',3648,3480,'mean','se',8,0.69,0.02,NULL),(3651,821,'P_relative_mass',3649,3481,'mean','se',8,0.41,0.03,NULL),(3652,821,'temperature',NULL,NULL,'mean',NULL,NULL,284.54999999999995,NULL,NULL),(3653,821,'water_table_depth',NULL,NULL,'mean',NULL,NULL,5,NULL,NULL),(3654,822,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3655,822,'mass_relative_mass',3654,3486,'mean','se',6,0.77,0.01,NULL),(3656,822,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3657,822,'C_to_N',3659,3658,'mean',NULL,NULL,NULL,NULL,NULL),(3658,822,'N_relative_mass',3662,3654,'mean',NULL,NULL,NULL,NULL,NULL),(3659,822,'C_relative_mass',3661,3654,'mean',NULL,NULL,NULL,NULL,NULL),(3660,822,'P_relative_mass',3663,3654,'mean',NULL,NULL,NULL,NULL,NULL),(3661,822,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3662,822,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3663,822,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3664,822,'N_relative_mass',3662,3494,'mean','se',6,0.37,0.01,NULL),(3665,822,'P_relative_mass',3663,3495,'mean','se',6,0.18,0.02,NULL),(3666,822,'temperature',NULL,NULL,'mean',NULL,NULL,284.54999999999995,NULL,NULL),(3667,822,'water_table_depth',NULL,NULL,'mean',NULL,NULL,5,NULL,NULL),(3668,827,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3669,827,'mass_relative_mass',3668,3668,'mean','se',5,1,0,NULL),(3670,827,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3671,827,'C_to_N',3673,3672,'mean','se',10,44.8,1,NULL),(3672,827,'N_relative_mass',3676,3668,'mean','se',10,0.0104,0.0002,NULL),(3673,827,'C_relative_mass',3675,3668,'mean',NULL,NULL,NULL,NULL,NULL),(3674,827,'P_relative_mass',3677,3668,'mean','se',10,0.00032,0.00001,NULL),(3675,827,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3676,827,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3677,827,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3678,828,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3679,828,'mass_relative_mass',3678,3678,'mean','se',5,1,0,NULL),(3680,828,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3681,828,'C_to_N',3683,3682,'mean','se',10,57.7,1.4,NULL),(3682,828,'N_relative_mass',3686,3678,'mean','se',10,0.0079,0.0002,NULL),(3683,828,'C_relative_mass',3685,3678,'mean',NULL,NULL,NULL,NULL,NULL),(3684,828,'P_relative_mass',3687,3678,'mean','se',10,0.0005600000000000001,0.000029999999999999997,NULL),(3685,828,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3686,828,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3687,828,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3688,829,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3689,829,'mass_relative_mass',3688,3688,'mean','se',5,1,0,NULL),(3690,829,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3691,829,'C_to_N',3693,3692,'mean','se',10,36.5,0.9,NULL),(3692,829,'N_relative_mass',3696,3688,'mean','se',10,0.013,0.0003,NULL),(3693,829,'C_relative_mass',3695,3688,'mean',NULL,NULL,NULL,NULL,NULL),(3694,829,'P_relative_mass',3697,3688,'mean','se',10,0.00046,0.00002,NULL),(3695,829,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3696,829,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3697,829,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3698,830,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3699,830,'mass_relative_mass',3698,3698,'mean','se',5,1,0,NULL),(3700,830,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3701,830,'C_to_N',3703,3702,'mean','se',10,64.5,1.1,NULL),(3702,830,'N_relative_mass',3706,3698,'mean','se',10,0.0076,0.0001,NULL),(3703,830,'C_relative_mass',3705,3698,'mean',NULL,NULL,NULL,NULL,NULL),(3704,830,'P_relative_mass',3707,3698,'mean','se',10,0.00017,0.00001,NULL),(3705,830,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3706,830,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3707,830,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3708,831,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3709,831,'mass_relative_mass',3708,3708,'mean','se',5,1,0,NULL),(3710,831,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3711,831,'C_to_N',3713,3712,'mean','se',10,44.8,1,NULL),(3712,831,'N_relative_mass',3716,3708,'mean','se',10,0.0104,0.0002,NULL),(3713,831,'C_relative_mass',3715,3708,'mean',NULL,NULL,NULL,NULL,NULL),(3714,831,'P_relative_mass',3717,3708,'mean','se',10,0.00032,0.00001,NULL),(3715,831,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3716,831,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3717,831,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3718,832,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3719,832,'mass_relative_mass',3718,3718,'mean','se',5,1,0,NULL),(3720,832,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3721,832,'C_to_N',3723,3722,'mean','se',10,57.7,1.4,NULL),(3722,832,'N_relative_mass',3726,3718,'mean','se',10,0.0079,0.0002,NULL),(3723,832,'C_relative_mass',3725,3718,'mean',NULL,NULL,NULL,NULL,NULL),(3724,832,'P_relative_mass',3727,3718,'mean','se',10,0.0005600000000000001,0.000029999999999999997,NULL),(3725,832,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3726,832,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3727,832,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3728,833,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3729,833,'mass_relative_mass',3728,3728,'mean','se',5,1,0,NULL),(3730,833,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3731,833,'C_to_N',3733,3732,'mean','se',10,36.5,0.9,NULL),(3732,833,'N_relative_mass',3736,3728,'mean','se',10,0.013,0.0003,NULL),(3733,833,'C_relative_mass',3735,3728,'mean',NULL,NULL,NULL,NULL,NULL),(3734,833,'P_relative_mass',3737,3728,'mean','se',10,0.00046,0.00002,NULL),(3735,833,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3736,833,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3737,833,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3738,834,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3739,834,'mass_relative_mass',3738,3738,'mean','se',5,1,0,NULL),(3740,834,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3741,834,'C_to_N',3743,3742,'mean','se',10,64.5,1.1,NULL),(3742,834,'N_relative_mass',3746,3738,'mean','se',10,0.0076,0.0001,NULL),(3743,834,'C_relative_mass',3745,3738,'mean',NULL,NULL,NULL,NULL,NULL),(3744,834,'P_relative_mass',3747,3738,'mean','se',10,0.00017,0.00001,NULL),(3745,834,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3746,834,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3747,834,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3748,835,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3749,835,'mass_relative_mass',3748,3668,'mean','se',5,0.9264108352144469,0.03521444695259603,NULL),(3750,835,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3751,835,'C_to_N',3753,3752,'mean','se',5,37.705735660847864,1.5960099750623442,NULL),(3752,835,'N_relative_mass',3756,3748,'mean','se',5,0.011559251559251561,0.0003326403326403291,NULL),(3753,835,'C_relative_mass',3755,3748,'mean',NULL,NULL,NULL,NULL,NULL),(3754,835,'P_relative_mass',3757,3748,'mean','se',5,0.00045141700404858316,0.00003441295546558698,NULL),(3755,835,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3756,835,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3757,835,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3758,836,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3759,836,'mass_relative_mass',3758,3668,'mean','se',10,1.1133182844243792,0.021670428893905296,NULL),(3760,836,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3761,836,'C_to_N',3763,3762,'mean','se',10,30.922693266832898,1.5960099750623549,NULL),(3762,836,'N_relative_mass',3766,3758,'mean','se',10,0.017671517671517672,0.0006652806652806653,NULL),(3763,836,'C_relative_mass',3765,3758,'mean',NULL,NULL,NULL,NULL,NULL),(3764,836,'P_relative_mass',3767,3758,'mean','se',10,0.0007226720647773283,0.00004655870445344101,NULL),(3765,836,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3766,836,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3767,836,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3768,837,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3769,837,'mass_relative_mass',3768,3668,'mean','se',10,1.0645598194130923,0.03792325056433413,NULL),(3770,837,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3771,837,'C_to_N',3773,3772,'mean','se',10,29.725685785536147,1.3965087281795405,NULL),(3772,837,'N_relative_mass',3776,3768,'mean','se',10,0.017588357588357587,0.0008731808731808712,NULL),(3773,837,'C_relative_mass',3775,3768,'mean',NULL,NULL,NULL,NULL,NULL),(3774,837,'P_relative_mass',3777,3768,'mean','se',10,0.0007995951417004048,0.0000506072874493928,NULL),(3775,837,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3776,837,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3777,837,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3778,838,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3779,838,'mass_relative_mass',3778,3678,'mean','se',5,0.9128668171557561,0.024379232505643528,NULL),(3780,838,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3781,838,'C_to_N',3783,3782,'mean','se',5,43.49127182044886,1.7955112219451337,NULL),(3782,838,'N_relative_mass',3786,3778,'mean','se',5,0.009646569646569647,0.00037422037422037667,NULL),(3783,838,'C_relative_mass',3785,3778,'mean',NULL,NULL,NULL,NULL,NULL),(3784,838,'P_relative_mass',3787,3778,'mean','se',5,0.0005748987854251013,0.000038461538461538544,NULL),(3785,838,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3786,838,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3787,838,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3788,839,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3789,839,'mass_relative_mass',3788,3678,'mean','se',10,1.1674943566591423,0.018961625282167063,NULL),(3790,839,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3791,839,'C_to_N',3793,3792,'mean','se',10,30.922693266832898,1.5960099750623549,NULL),(3792,839,'N_relative_mass',3796,3788,'mean','se',10,0.01754677754677755,0.0008316008316008308,NULL),(3793,839,'C_relative_mass',3795,3788,'mean',NULL,NULL,NULL,NULL,NULL),(3794,839,'P_relative_mass',3797,3788,'mean','se',10,0.0008825910931174091,0.00007085020242914986,NULL),(3795,839,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3796,839,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3797,839,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3798,840,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3799,840,'mass_relative_mass',3798,3678,'mean','se',10,0.9589164785553049,0.02167042889390487,NULL),(3800,840,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3801,840,'C_to_N',3803,3802,'mean','se',10,29.925187032418936,1.197007481296751,NULL),(3802,840,'N_relative_mass',3806,3798,'mean','se',10,0.015717255717255716,0.0009147609147609153,NULL),(3803,840,'C_relative_mass',3805,3798,'mean',NULL,NULL,NULL,NULL,NULL),(3804,840,'P_relative_mass',3807,3798,'mean','se',10,0.0008582995951417004,0.00006275303643724683,NULL),(3805,840,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3806,840,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3807,840,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3808,841,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3809,841,'mass_relative_mass',3808,3688,'mean','se',5,0.8126410835214447,0.02979683972911957,NULL),(3810,841,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3811,841,'C_to_N',3813,3812,'mean','se',5,33.11720698254362,0.9975062344139616,NULL),(3812,841,'N_relative_mass',3816,3808,'mean','se',5,0.011725571725571727,0.0006237006237006231,NULL),(3813,841,'C_relative_mass',3815,3808,'mean',NULL,NULL,NULL,NULL,NULL),(3814,841,'P_relative_mass',3817,3808,'mean','se',5,0.00033805668016194347,0.00002024291497975711,NULL),(3815,841,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3816,841,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3817,841,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3818,842,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3819,842,'mass_relative_mass',3818,3688,'mean','se',10,0.6555304740406319,0.018961625282167063,NULL),(3820,842,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3821,842,'C_to_N',3823,3822,'mean','se',10,26.33416458852866,1.3965087281795476,NULL),(3822,842,'N_relative_mass',3826,3818,'mean','se',10,0.01318087318087318,0.00037422037422037667,NULL),(3823,842,'C_relative_mass',3825,3818,'mean',NULL,NULL,NULL,NULL,NULL),(3824,842,'P_relative_mass',3827,3818,'mean','se',10,0.0003603238866396763,0.00003643724696356271,NULL),(3825,842,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3826,842,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3827,842,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3828,843,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3829,843,'mass_relative_mass',3828,3688,'mean','se',10,0.49571106094808115,0.02979683972911971,NULL),(3830,843,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3831,843,'C_to_N',3833,3832,'mean','se',10,23.740648379052356,0.9975062344139616,NULL),(3832,843,'N_relative_mass',3836,3828,'mean','se',10,0.010893970893970895,0.0012474012474012444,NULL),(3833,843,'C_relative_mass',3835,3828,'mean',NULL,NULL,NULL,NULL,NULL),(3834,843,'P_relative_mass',3837,3828,'mean','se',10,0.0003178137651821864,0.00005870445344129549,NULL),(3835,843,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3836,843,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3837,843,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3838,844,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3839,844,'mass_relative_mass',3838,3698,'mean','se',5,0.8559819413092551,0.051467268623024864,NULL),(3840,844,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3841,844,'C_to_N',3843,3842,'mean','se',5,62.044887780548606,1.9950124688279232,NULL),(3842,844,'N_relative_mass',3846,3838,'mean','se',5,0.0065696465696465705,0.0002910602910602904,NULL),(3843,844,'C_relative_mass',3845,3838,'mean',NULL,NULL,NULL,NULL,NULL),(3844,844,'P_relative_mass',3847,3838,'mean','se',5,0.00008704453441295561,0.000014170040485829981,NULL),(3845,844,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3846,844,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3847,844,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3848,845,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3849,845,'mass_relative_mass',3848,3698,'mean','se',10,0.65823927765237,0.016252821670428973,NULL),(3850,845,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3851,845,'C_to_N',3853,3852,'mean','se',10,36.30922693266831,1.5960099750623442,NULL),(3852,845,'N_relative_mass',3856,3848,'mean','se',10,0.009563409563409562,0.0006237006237006248,NULL),(3853,845,'C_relative_mass',3855,3848,'mean',NULL,NULL,NULL,NULL,NULL),(3854,845,'P_relative_mass',3857,3848,'mean','se',10,0.0001902834008097168,0.00003238866396761136,NULL),(3855,845,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3856,845,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3857,845,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3858,846,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3859,846,'mass_relative_mass',3858,3698,'mean','se',10,0.47674943566591393,0.021670428893905438,NULL),(3860,846,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3861,846,'C_to_N',3863,3862,'mean','se',10,29.52618453865335,2.194513715710727,NULL),(3862,846,'N_relative_mass',3866,3858,'mean','se',10,0.00819126819126819,0.0006237006237006248,NULL),(3863,846,'C_relative_mass',3865,3858,'mean',NULL,NULL,NULL,NULL,NULL),(3864,846,'P_relative_mass',3867,3858,'mean','se',10,0.00021457489878542524,0.00003036437246963558,NULL),(3865,846,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3866,846,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3867,846,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3868,847,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3869,847,'mass_relative_mass',3868,3708,'mean','se',5,0.8807095343680704,0.021286031042128853,NULL),(3870,847,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3871,847,'C_to_N',3873,3872,'mean','se',5,40.925449871465304,0.8226221079691527,NULL),(3872,847,'N_relative_mass',3876,3868,'mean','se',5,0.009724409448818897,0.0002755905511811019,NULL),(3873,847,'C_relative_mass',3875,3868,'mean',NULL,NULL,NULL,NULL,NULL),(3874,847,'P_relative_mass',3877,3868,'mean','se',5,0.0004571428571428571,0.00001836734693877562,NULL),(3875,847,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3876,847,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3877,847,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3878,848,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3879,848,'mass_relative_mass',3878,3708,'mean','se',10,0.9472283813747228,0.015964523281596428,NULL),(3880,848,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3881,848,'C_to_N',3883,3882,'mean','se',10,54.49871465295631,1.0282776349614409,NULL),(3882,848,'N_relative_mass',3886,3878,'mean','se',10,0.00838582677165354,0.0005511811023622073,NULL),(3883,848,'C_relative_mass',3885,3878,'mean',NULL,NULL,NULL,NULL,NULL),(3884,848,'P_relative_mass',3887,3878,'mean','se',10,0.000336734693877551,0.0000387755102040816,NULL),(3885,848,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3886,848,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3887,848,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3888,849,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3889,849,'mass_relative_mass',3888,3708,'mean','se',10,0.9179600886917956,0.010643015521064426,NULL),(3890,849,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3891,849,'C_to_N',3893,3892,'mean','se',10,61.69665809768638,2.2622107969151983,NULL),(3892,849,'N_relative_mass',3896,3888,'mean','se',10,0.007244094488188975,0.0004724409448818907,NULL),(3893,849,'C_relative_mass',3895,3888,'mean',NULL,NULL,NULL,NULL,NULL),(3894,849,'P_relative_mass',3897,3888,'mean','se',10,0.0003081632653061224,0.000030612244897959216,NULL),(3895,849,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3896,849,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3897,849,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3898,850,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3899,850,'mass_relative_mass',3898,3718,'mean','se',5,0.8381374722838134,0.03458980044345907,NULL),(3900,850,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3901,850,'C_to_N',3903,3902,'mean','se',5,52.85347043701802,1.0282776349614409,NULL),(3902,850,'N_relative_mass',3906,3898,'mean','se',5,0.007125984251968503,0.0003149606299212593,NULL),(3903,850,'C_relative_mass',3905,3898,'mean',NULL,NULL,NULL,NULL,NULL),(3904,850,'P_relative_mass',3907,3898,'mean','se',5,0.0005081632653061224,0.000030612244897959216,NULL),(3905,850,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3906,850,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3907,850,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3908,851,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3909,851,'mass_relative_mass',3908,3718,'mean','se',10,0.9445676274944564,0.015964523281596713,NULL),(3910,851,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3911,851,'C_to_N',3913,3912,'mean','se',10,64.78149100257069,2.6735218508997605,NULL),(3912,851,'N_relative_mass',3916,3908,'mean','se',10,0.006732283464566927,0.00027559055118110367,NULL),(3913,851,'C_relative_mass',3915,3908,'mean',NULL,NULL,NULL,NULL,NULL),(3914,851,'P_relative_mass',3917,3908,'mean','se',10,0.00037346938775510203,0.000032653061224489746,NULL),(3915,851,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3916,851,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3917,851,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3918,852,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3919,852,'mass_relative_mass',3918,3718,'mean','se',10,0.8620842572062082,0.015964523281596286,NULL),(3920,852,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3921,852,'C_to_N',3923,3922,'mean','se',10,81.43958868894603,4.1131105398457635,NULL),(3922,852,'N_relative_mass',3926,3918,'mean','se',10,0.005275590551181101,0.0005511811023622055,NULL),(3923,852,'C_relative_mass',3925,3918,'mean',NULL,NULL,NULL,NULL,NULL),(3924,852,'P_relative_mass',3927,3918,'mean','se',10,0.00027959183673469383,0.000030612244897959216,NULL),(3925,852,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3926,852,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3927,852,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3928,853,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3929,853,'mass_relative_mass',3928,3728,'mean','se',5,0.7822616407982259,0.04523281596452307,NULL),(3930,853,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3931,853,'C_to_N',3933,3932,'mean','se',5,31.05398457583548,1.0282776349614409,NULL),(3932,853,'N_relative_mass',3936,3928,'mean','se',5,0.012165354330708662,0.0003543307086614149,NULL),(3933,853,'C_relative_mass',3935,3928,'mean',NULL,NULL,NULL,NULL,NULL),(3934,853,'P_relative_mass',3937,3928,'mean','se',5,0.0004877551020408164,0.00002244897959183667,NULL),(3935,853,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3936,853,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3937,853,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3938,854,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3939,854,'mass_relative_mass',3938,3728,'mean','se',10,0.5560975609756096,0.05853658536585371,NULL),(3940,854,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3941,854,'C_to_N',3943,3942,'mean','se',10,31.46529562982007,1.6452442159383054,NULL),(3942,854,'N_relative_mass',3946,3938,'mean','se',10,0.008779527559055119,0.0009448818897637778,NULL),(3943,854,'C_relative_mass',3945,3938,'mean',NULL,NULL,NULL,NULL,NULL),(3944,854,'P_relative_mass',3947,3938,'mean','se',10,0.0003081632653061224,0.0000326530612244898,NULL),(3945,854,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3946,854,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3947,854,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3948,855,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3949,855,'mass_relative_mass',3948,3728,'mean','se',10,0.5002217294900221,0.05853658536585357,NULL),(3950,855,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3951,855,'C_to_N',3953,3952,'mean','se',10,31.67095115681235,1.8508997429305865,NULL),(3952,855,'N_relative_mass',3956,3948,'mean','se',10,0.007716535433070866,0.0010629921259842528,NULL),(3953,855,'C_relative_mass',3955,3948,'mean',NULL,NULL,NULL,NULL,NULL),(3954,855,'P_relative_mass',3957,3948,'mean','se',10,0.00024897959183673465,0.00003673469387755099,NULL),(3955,855,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3956,855,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3957,855,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3958,856,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3959,856,'mass_relative_mass',3958,3738,'mean','se',5,0.8487804878048779,0.03458980044345907,NULL),(3960,856,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3961,856,'C_to_N',3963,3962,'mean','se',5,57.789203084832906,1.4395886889460314,NULL),(3962,856,'N_relative_mass',3966,3958,'mean','se',5,0.007125984251968503,0.0003149606299212593,NULL),(3963,856,'C_relative_mass',3965,3958,'mean',NULL,NULL,NULL,NULL,NULL),(3964,856,'P_relative_mass',3967,3958,'mean','se',5,0.00017142857142857137,0.00004693877551020412,NULL),(3965,856,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3966,856,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3967,856,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3968,857,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3969,857,'mass_relative_mass',3968,3738,'mean','se',10,0.6093126385809312,0.047893569844789284,NULL),(3970,857,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3971,857,'C_to_N',3973,3972,'mean','se',10,49.768637532133695,1.439588688946003,NULL),(3972,857,'N_relative_mass',3976,3968,'mean','se',10,0.006141732283464566,0.0004724409448818889,NULL),(3973,857,'C_relative_mass',3975,3968,'mean',NULL,NULL,NULL,NULL,NULL),(3974,857,'P_relative_mass',3977,3968,'mean','se',10,0.00017755102040816325,0.000012244897959183598,NULL),(3975,857,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3976,857,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3977,857,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3978,858,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3979,858,'mass_relative_mass',3978,3738,'mean','se',10,0.4337028824833702,0.055875831485587495,NULL),(3980,858,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.3,NULL,NULL),(3981,858,'C_to_N',3983,3982,'mean','se',10,42.7763496143959,2.26221079691517,NULL),(3982,858,'N_relative_mass',3986,3978,'mean','se',10,0.005196850393700787,0.0005511811023622038,NULL),(3983,858,'C_relative_mass',3985,3978,'mean',NULL,NULL,NULL,NULL,NULL),(3984,858,'P_relative_mass',3987,3978,'mean','se',10,0.00017959183673469382,0.000030612244897959135,NULL),(3985,858,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3986,858,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3987,858,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3988,865,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3989,865,'mass_relative_mass',3988,3988,'mean','se',10,1,0,NULL),(3990,865,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(3991,866,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3992,866,'mass_relative_mass',3991,3991,'mean','se',10,1,0,NULL),(3993,866,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(3994,867,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3995,867,'mass_relative_mass',3994,3994,'mean','se',10,1,0,NULL),(3996,867,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(3997,868,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(3998,868,'mass_relative_mass',3997,3997,'mean','se',10,1,0,NULL),(3999,868,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4000,869,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4001,869,'mass_relative_mass',4000,4000,'mean','se',10,1,0,NULL),(4002,869,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4003,870,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4004,870,'mass_relative_mass',4003,4003,'mean','se',10,1,0,NULL),(4005,870,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4006,871,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4007,871,'mass_relative_mass',4006,3988,'mean','se',10,0.9144628099173553,0.018595041322314074,NULL),(4008,871,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4009,872,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4010,872,'mass_relative_mass',4009,3991,'mean','se',10,0.9256198347107437,0.01797520661157023,NULL),(4011,872,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4012,873,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4013,873,'mass_relative_mass',4012,3994,'mean','se',10,0.8760330578512397,0.021694214876033086,NULL),(4014,873,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4015,874,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4016,874,'mass_relative_mass',4015,3997,'mean','se',10,0.9194214876033058,0.01177685950413224,NULL),(4017,874,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4018,875,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4019,875,'mass_relative_mass',4018,4000,'mean','se',10,0.8766528925619835,0.014876033057851252,NULL),(4020,875,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4021,876,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4022,876,'mass_relative_mass',4021,4003,'mean','se',10,0.8766528925619835,0.017975206611570264,NULL),(4023,876,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4024,885,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4025,885,'mass_relative_mass',4024,4024,'mean','se',10,1,0,NULL),(4026,885,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4027,886,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4028,886,'mass_relative_mass',4027,4027,'mean','se',10,1,0,NULL),(4029,886,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4030,887,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4031,887,'mass_relative_mass',4030,4030,'mean','se',10,1,0,NULL),(4032,887,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4033,888,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4034,888,'mass_relative_mass',4033,4033,'mean','se',10,1,0,NULL),(4035,888,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4036,889,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4037,889,'mass_relative_mass',4036,4036,'mean','se',10,1,0,NULL),(4038,889,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4039,890,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4040,890,'mass_relative_mass',4039,4039,'mean','se',10,1,0,NULL),(4041,890,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4042,891,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4043,891,'mass_relative_mass',4042,4042,'mean','se',10,1,0,NULL),(4044,891,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4045,892,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4046,892,'mass_relative_mass',4045,4045,'mean','se',10,1,0,NULL),(4047,892,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4048,893,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4049,893,'mass_relative_mass',4048,4024,'mean','se',10,0.931159420289855,0.005434782608695628,NULL),(4050,893,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4051,894,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4052,894,'mass_relative_mass',4051,4027,'mean','se',10,0.973731884057971,0.005434782608695592,NULL),(4053,894,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4054,895,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4055,895,'mass_relative_mass',4054,4030,'mean','se',10,0.9474637681159419,0.008152173913043405,NULL),(4056,895,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4057,896,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4058,896,'mass_relative_mass',4057,4033,'mean','se',10,0.9547101449275363,0.005434782608695699,NULL),(4059,896,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4060,897,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4061,897,'mass_relative_mass',4060,4036,'mean','se',10,0.8297101449275363,0.006340579710144923,NULL),(4062,897,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4063,898,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4064,898,'mass_relative_mass',4063,4039,'mean','se',10,0.9492753623188405,0.005434782608695628,NULL),(4065,898,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4066,899,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4067,899,'mass_relative_mass',4066,4042,'mean','se',10,0.7871376811594203,0.009963768115942032,NULL),(4068,899,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4069,900,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4070,900,'mass_relative_mass',4069,4045,'mean','se',10,0.9130434782608695,0.014492753623188505,NULL),(4071,900,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4072,911,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4073,911,'mass_relative_mass',4072,4072,'mean','se',10,1,0,NULL),(4074,911,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4075,912,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4076,912,'mass_relative_mass',4075,4075,'mean','se',10,1,0,NULL),(4077,912,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4078,913,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4079,913,'mass_relative_mass',4078,4078,'mean','se',10,1,0,NULL),(4080,913,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4081,914,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4082,914,'mass_relative_mass',4081,4081,'mean','se',10,1,0,NULL),(4083,914,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4084,915,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4085,915,'mass_relative_mass',4084,4084,'mean','se',10,1,0,NULL),(4086,915,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4087,916,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4088,916,'mass_relative_mass',4087,4087,'mean','se',10,1,0,NULL),(4089,916,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4090,917,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4091,917,'mass_relative_mass',4090,4090,'mean','se',10,1,0,NULL),(4092,917,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4093,918,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4094,918,'mass_relative_mass',4093,4093,'mean','se',10,1,0,NULL),(4095,918,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4096,919,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4097,919,'mass_relative_mass',4096,4096,'mean','se',10,1,0,NULL),(4098,919,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4099,920,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4100,920,'mass_relative_mass',4099,4099,'mean','se',10,1,0,NULL),(4101,920,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4102,921,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4103,921,'mass_relative_mass',4102,4072,'mean','se',10,0.8440154440154437,0.012355212355212189,NULL),(4104,921,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4105,922,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4106,922,'mass_relative_mass',4105,4075,'mean','se',10,0.8393822393822393,0.016988416988417184,NULL),(4107,922,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4108,923,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4109,923,'mass_relative_mass',4108,4078,'mean','se',10,0.9181467181467178,0.013899613899613925,NULL),(4110,923,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4111,924,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4112,924,'mass_relative_mass',4111,4081,'mean','se',10,0.9397683397683394,0.007722007722007689,NULL),(4113,924,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4114,925,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4115,925,'mass_relative_mass',4114,4084,'mean','se',10,0.7312741312741311,0.013899613899613854,NULL),(4116,925,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4117,926,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4118,926,'mass_relative_mass',4117,4087,'mean','se',10,0.836293436293436,0.030888030888030757,NULL),(4119,926,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4120,927,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4121,927,'mass_relative_mass',4120,4090,'mean','se',10,0.8223938223938221,0.013899613899613854,NULL),(4122,927,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4123,928,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4124,928,'mass_relative_mass',4123,4093,'mean','se',10,0.8749034749034746,0.013899613899613925,NULL),(4125,928,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4126,929,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4127,929,'mass_relative_mass',4126,4096,'mean','se',10,0.7451737451737449,0.0169884169884169,NULL),(4128,929,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4129,930,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4130,930,'mass_relative_mass',4129,4099,'mean','se',10,0.6957528957528958,0.015444015444015519,NULL),(4131,930,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4132,931,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4133,931,'mass_relative_mass',4132,4132,'mean','se',5,1,0,NULL),(4134,931,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4135,931,'water_table_depth',NULL,NULL,'mean',NULL,NULL,8,NULL,NULL),(4136,932,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4137,932,'mass_relative_mass',4136,4136,'mean','se',5,1,0,NULL),(4138,932,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4139,932,'water_table_depth',NULL,NULL,'mean',NULL,NULL,8,NULL,NULL),(4140,933,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4141,933,'mass_relative_mass',4140,4140,'mean','se',5,1,0,NULL),(4142,933,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4143,933,'water_table_depth',NULL,NULL,'mean',NULL,NULL,8,NULL,NULL),(4144,934,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4145,934,'mass_relative_mass',4144,4144,'mean','se',5,1,0,NULL),(4146,934,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4147,934,'water_table_depth',NULL,NULL,'mean',NULL,NULL,8,NULL,NULL),(4148,935,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4149,935,'mass_relative_mass',4148,4148,'mean','se',5,1,0,NULL),(4150,935,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4151,935,'water_table_depth',NULL,NULL,'mean',NULL,NULL,8,NULL,NULL),(4152,936,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4153,936,'mass_relative_mass',4152,4152,'mean','se',5,1,0,NULL),(4154,936,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4155,936,'water_table_depth',NULL,NULL,'mean',NULL,NULL,8,NULL,NULL),(4156,937,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4157,937,'mass_relative_mass',4156,4156,'mean','se',5,1,0,NULL),(4158,937,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4159,937,'water_table_depth',NULL,NULL,'mean',NULL,NULL,8,NULL,NULL),(4160,938,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4161,938,'mass_relative_mass',4160,4160,'mean','se',5,1,0,NULL),(4162,938,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4163,938,'water_table_depth',NULL,NULL,'mean',NULL,NULL,8,NULL,NULL),(4164,939,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4165,939,'mass_relative_mass',4164,4164,'mean','se',5,1,0,NULL),(4166,939,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4167,939,'water_table_depth',NULL,NULL,'mean',NULL,NULL,8,NULL,NULL),(4168,940,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4169,940,'mass_relative_mass',4168,4168,'mean','se',5,1,0,NULL),(4170,940,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4171,940,'water_table_depth',NULL,NULL,'mean',NULL,NULL,8,NULL,NULL),(4172,941,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4173,941,'mass_relative_mass',4172,4172,'mean','se',5,1,0,NULL),(4174,941,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4175,941,'water_table_depth',NULL,NULL,'mean',NULL,NULL,8,NULL,NULL),(4176,942,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4177,942,'mass_relative_mass',4176,4176,'mean','se',5,1,0,NULL),(4178,942,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4179,942,'water_table_depth',NULL,NULL,'mean',NULL,NULL,8,NULL,NULL),(4180,943,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4181,943,'mass_relative_mass',4180,4132,'mean','se',5,0.8848708487084871,0.008856088560885666,NULL),(4182,943,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4183,943,'water_table_depth',NULL,NULL,'mean',NULL,NULL,8,NULL,NULL),(4184,944,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4185,944,'mass_relative_mass',4184,4136,'mean','se',5,0.8560885608856087,0.015498154981549703,NULL),(4186,944,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4187,944,'water_table_depth',NULL,NULL,'mean',NULL,NULL,8,NULL,NULL),(4188,945,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4189,945,'mass_relative_mass',4188,4140,'mean','se',5,0.8538745387453873,0.013284132841328358,NULL),(4190,945,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4191,945,'water_table_depth',NULL,NULL,'mean',NULL,NULL,8,NULL,NULL),(4192,946,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4193,946,'mass_relative_mass',4192,4144,'mean','se',5,0.6435424354243544,0.06199261992619938,NULL),(4194,946,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4195,946,'water_table_depth',NULL,NULL,'mean',NULL,NULL,8,NULL,NULL),(4196,947,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4197,947,'mass_relative_mass',4196,4148,'mean','se',5,0.707749077490775,0.01107011070110687,NULL),(4198,947,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4199,947,'water_table_depth',NULL,NULL,'mean',NULL,NULL,8,NULL,NULL),(4200,948,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4201,948,'mass_relative_mass',4200,4152,'mean','se',5,0.692250922509225,0.017712177121771047,NULL),(4202,948,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4203,948,'water_table_depth',NULL,NULL,'mean',NULL,NULL,8,NULL,NULL),(4204,949,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4205,949,'mass_relative_mass',4204,4156,'mean','se',5,0.836162361623616,0.008856088560885383,NULL),(4206,949,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4207,949,'water_table_depth',NULL,NULL,'mean',NULL,NULL,8,NULL,NULL),(4208,950,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4209,950,'mass_relative_mass',4208,4160,'mean','se',5,0.8450184501845017,0.015498154981549703,NULL),(4210,950,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4211,950,'water_table_depth',NULL,NULL,'mean',NULL,NULL,8,NULL,NULL),(4212,951,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4213,951,'mass_relative_mass',4212,4164,'mean','se',5,0.8317343173431734,0.026568265682656717,NULL),(4214,951,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4215,951,'water_table_depth',NULL,NULL,'mean',NULL,NULL,8,NULL,NULL),(4216,952,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4217,952,'mass_relative_mass',4216,4168,'mean','se',5,0.5682656826568266,0.12398523985239834,NULL),(4218,952,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4219,952,'water_table_depth',NULL,NULL,'mean',NULL,NULL,8,NULL,NULL),(4220,953,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4221,953,'mass_relative_mass',4220,4172,'mean','se',5,0.6081180811808119,0.019926199261992537,NULL),(4222,953,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4223,953,'water_table_depth',NULL,NULL,'mean',NULL,NULL,8,NULL,NULL),(4224,954,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4225,954,'mass_relative_mass',4224,4176,'mean','se',5,0.5173431734317343,0.07084870848708462,NULL),(4226,954,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.074,NULL,NULL),(4227,954,'water_table_depth',NULL,NULL,'mean',NULL,NULL,8,NULL,NULL),(4228,956,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4229,956,'mass_relative_mass',4228,4228,'mean','se',60,1,0,NULL),(4230,956,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.9,NULL,NULL),(4231,957,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4232,957,'mass_relative_mass',4231,4228,'mean','se',55,0.8690000000000001,0.006999999999999999,NULL),(4233,957,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.9,NULL,NULL),(4234,958,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4235,958,'mass_relative_mass',4234,4234,'mean','se',60,1,0,NULL),(4236,958,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.9,NULL,NULL),(4237,959,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4238,959,'mass_relative_mass',4237,4234,'mean','se',50,0.8290000000000001,0.011000000000000001,NULL),(4239,959,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.9,NULL,NULL),(4240,961,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4241,961,'mass_relative_mass',4240,4240,'mean','se',6,1,0,NULL),(4242,961,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.2,NULL,NULL),(4243,962,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4244,962,'mass_relative_mass',4243,4243,'mean','se',20,1,0,NULL),(4245,962,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.2,NULL,NULL),(4246,963,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4247,963,'mass_relative_mass',4246,4246,'mean','se',14,1,0,NULL),(4248,963,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.2,NULL,NULL),(4249,964,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4250,964,'mass_relative_mass',4249,4249,'mean','se',6,1,0,NULL),(4251,964,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.2,NULL,NULL),(4252,965,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4253,965,'mass_relative_mass',4252,4252,'mean','se',2,1,0,NULL),(4254,965,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.2,NULL,NULL),(4255,966,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4256,966,'mass_relative_mass',4255,4255,'mean','se',4,1,0,NULL),(4257,966,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.2,NULL,NULL),(4258,967,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4259,967,'mass_relative_mass',4258,4258,'mean','se',6,1,0,NULL),(4260,967,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.2,NULL,NULL),(4261,968,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4262,968,'mass_relative_mass',4261,4261,'mean','se',12,1,0,NULL),(4263,968,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.2,NULL,NULL),(4264,969,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4265,969,'mass_relative_mass',4264,4264,'mean','se',3,1,0,NULL),(4266,969,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.2,NULL,NULL),(4267,970,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4268,970,'mass_relative_mass',4267,4267,'mean','se',13,1,0,NULL),(4269,970,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.2,NULL,NULL),(4270,971,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4271,971,'mass_relative_mass',4270,4270,'mean','se',9,1,0,NULL),(4272,971,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.2,NULL,NULL),(4273,972,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4274,972,'mass_relative_mass',4273,4273,'mean','se',10,1,0,NULL),(4275,972,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.2,NULL,NULL),(4276,973,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4277,973,'mass_relative_mass',4276,4276,'mean','se',6,1,0,NULL),(4278,973,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.2,NULL,NULL),(4279,974,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4280,974,'mass_relative_mass',4279,4240,'mean','se',6,0.826,0.023,NULL),(4281,974,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.2,NULL,NULL),(4282,975,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4283,975,'mass_relative_mass',4282,4243,'mean','se',20,0.84,0.011000000000000001,NULL),(4284,975,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.2,NULL,NULL),(4285,976,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4286,976,'mass_relative_mass',4285,4246,'mean','se',14,0.823,0.006,NULL),(4287,976,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.2,NULL,NULL),(4288,977,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4289,977,'mass_relative_mass',4288,4249,'mean','se',6,0.843,0.012,NULL),(4290,977,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.2,NULL,NULL),(4291,978,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4292,978,'mass_relative_mass',4291,4252,'mean','se',2,0.865,0.004,NULL),(4293,978,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.2,NULL,NULL),(4294,979,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4295,979,'mass_relative_mass',4294,4255,'mean','se',4,0.79,0.003,NULL),(4296,979,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.2,NULL,NULL),(4297,980,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4298,980,'mass_relative_mass',4297,4258,'mean','se',6,0.8290000000000001,0.006,NULL),(4299,980,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.2,NULL,NULL),(4300,981,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4301,981,'mass_relative_mass',4300,4261,'mean','se',12,0.856,0.015,NULL),(4302,981,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.2,NULL,NULL),(4303,982,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4304,982,'mass_relative_mass',4303,4264,'mean','se',3,0.763,0.009000000000000001,NULL),(4305,982,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.2,NULL,NULL),(4306,983,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4307,983,'mass_relative_mass',4306,4267,'mean','se',13,0.835,0.013000000000000001,NULL),(4308,983,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.2,NULL,NULL),(4309,984,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4310,984,'mass_relative_mass',4309,4270,'mean','se',9,0.838,0.012,NULL),(4311,984,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.2,NULL,NULL),(4312,985,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4313,985,'mass_relative_mass',4312,4273,'mean','se',10,0.871,0.013000000000000001,NULL),(4314,985,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.2,NULL,NULL),(4315,986,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4316,986,'mass_relative_mass',4315,4276,'mean','se',6,0.835,0.011000000000000001,NULL),(4317,986,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.2,NULL,NULL),(4318,987,'water_table_depth',NULL,NULL,'mean','se',4,12,6.5,NULL),(4319,987,'ground_slope',NULL,NULL,'mean','se',4,0.08199999999999999,0.06,NULL),(4320,988,'water_table_depth',NULL,NULL,'mean','se',20,15.1,2.3,NULL),(4321,988,'ground_slope',NULL,NULL,'mean','se',21,0.068,0.018000000000000002,NULL),(4322,989,'water_table_depth',NULL,NULL,'mean','se',14,21.8,3.6,NULL),(4323,989,'ground_slope',NULL,NULL,'mean','se',14,0.124,0.055,NULL),(4324,990,'water_table_depth',NULL,NULL,'mean','se',7,2.7,3.2,NULL),(4325,990,'ground_slope',NULL,NULL,'mean','se',7,0.24,0.055999999999999994,NULL),(4326,991,'water_table_depth',NULL,NULL,'mean','se',NULL,-3.1,NULL,NULL),(4327,991,'ground_slope',NULL,NULL,'mean','se',NULL,0,NULL,NULL),(4328,992,'water_table_depth',NULL,NULL,'mean','se',NULL,1.4,NULL,NULL),(4329,992,'ground_slope',NULL,NULL,'mean','se',NULL,0,NULL,NULL),(4330,993,'water_table_depth',NULL,NULL,'mean','se',NULL,2.9,NULL,NULL),(4331,993,'ground_slope',NULL,NULL,'mean','se',NULL,0.04,NULL,NULL),(4332,994,'water_table_depth',NULL,NULL,'mean','se',NULL,13.5,NULL,NULL),(4333,994,'ground_slope',NULL,NULL,'mean','se',NULL,0.03,NULL,NULL),(4334,995,'water_table_depth',NULL,NULL,'mean','se',NULL,24.3,NULL,NULL),(4335,995,'ground_slope',NULL,NULL,'mean','se',NULL,0.06,NULL,NULL),(4336,996,'water_table_depth',NULL,NULL,'mean','se',NULL,14.6,NULL,NULL),(4337,996,'ground_slope',NULL,NULL,'mean','se',NULL,0.06,NULL,NULL),(4338,997,'water_table_depth',NULL,NULL,'mean','se',NULL,19.7,NULL,NULL),(4339,997,'ground_slope',NULL,NULL,'mean','se',NULL,0.09,NULL,NULL),(4340,998,'water_table_depth',NULL,NULL,'mean','se',NULL,22.8,NULL,NULL),(4341,998,'ground_slope',NULL,NULL,'mean','se',NULL,0.25,NULL,NULL),(4342,999,'water_table_depth',NULL,NULL,'mean','se',NULL,73.4,NULL,NULL),(4343,999,'ground_slope',NULL,NULL,'mean','se',NULL,0.45,NULL,NULL),(4344,1000,'pH',NULL,NULL,'mean','se',4,4.3,0.2,NULL),(4345,1001,'pH',NULL,NULL,'mean','se',18,4.4,0.1,NULL),(4346,1002,'pH',NULL,NULL,'mean','se',12,4.5,0.1,NULL),(4347,1003,'pH',NULL,NULL,'mean','se',7,4.2,0.1,NULL),(4348,1004,'pH',NULL,NULL,'mean','se',NULL,4.7,NULL,NULL),(4349,1005,'pH',NULL,NULL,'mean','se',NULL,4.5,NULL,NULL),(4350,1006,'pH',NULL,NULL,'mean','se',NULL,4.6,NULL,NULL),(4351,1007,'pH',NULL,NULL,'mean','se',NULL,4.5,NULL,NULL),(4352,1008,'pH',NULL,NULL,'mean','se',NULL,4.4,NULL,NULL),(4353,1009,'pH',NULL,NULL,'mean','se',NULL,4.7,NULL,NULL),(4354,1010,'pH',NULL,NULL,'mean','se',NULL,4.5,NULL,NULL),(4355,1011,'pH',NULL,NULL,'mean','se',NULL,5,NULL,NULL),(4356,1012,'pH',NULL,NULL,'mean','se',NULL,5.8,NULL,NULL),(4357,1018,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4358,1018,'mass_relative_mass',4357,4357,'mean','se',4,1,0,NULL),(4359,1018,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(4360,1018,'N_relative_mass',4364,4357,'mean','se',4,0.006764705882352938,0.00039215686274509667,NULL),(4361,1018,'C_relative_mass',4363,4357,'mean','se',4,0.46023715415019756,0.03794466403162056,NULL),(4362,1018,'P_relative_mass',4365,4357,'mean','se',4,0.0049203187250996035,0.00039840637450199346,NULL),(4363,1018,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4364,1018,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4365,1018,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4366,1018,'root_diameter_absolute',NULL,NULL,'minimum',NULL,NULL,NULL,NULL,NULL),(4367,1019,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4368,1019,'mass_relative_mass',4367,4367,'mean','se',4,1,0,NULL),(4369,1019,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(4370,1019,'N_relative_mass',4374,4367,'mean','se',4,0.012647058823529409,0.0013725490196078436,NULL),(4371,1019,'C_relative_mass',4373,4367,'mean','se',4,0.4502766798418972,0.04885375494071144,NULL),(4372,1019,'P_relative_mass',4375,4367,'mean','se',4,0.016713147410358568,0.00031872509960159337,NULL),(4373,1019,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4374,1019,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4375,1019,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4376,1019,'root_diameter_absolute',NULL,NULL,'minimum',NULL,NULL,3,NULL,NULL),(4377,1020,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4378,1020,'mass_relative_mass',4377,4377,'mean','se',4,1,0,NULL),(4379,1020,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(4380,1020,'N_relative_mass',4384,4377,'mean','se',4,0.01225490196078431,0.0016666666666666696,NULL),(4381,1020,'C_relative_mass',4383,4377,'mean','se',4,0.47067193675889324,0.02845849802371538,NULL),(4382,1020,'P_relative_mass',4385,4377,'mean','se',4,0.010737051792828689,0.00039840637450198814,NULL),(4383,1020,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4384,1020,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4385,1020,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4386,1020,'root_diameter_absolute',NULL,NULL,'minimum',NULL,NULL,NULL,NULL,NULL),(4387,1021,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4388,1021,'mass_relative_mass',4387,4387,'mean','se',4,1,0,NULL),(4389,1021,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(4390,1021,'N_relative_mass',4394,4387,'mean','se',4,0.007352941176470587,0.0004901960784313708,NULL),(4391,1021,'C_relative_mass',4393,4387,'mean','se',4,0.43130434782608695,0.023715415019762816,NULL),(4392,1021,'P_relative_mass',4395,4387,'mean','se',4,0.021175298804780873,0.00031872509960160047,NULL),(4393,1021,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4394,1021,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4395,1021,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4396,1021,'root_diameter_absolute',NULL,NULL,'minimum',NULL,NULL,0,NULL,NULL),(4397,1022,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4398,1022,'mass_relative_mass',4397,4397,'mean','se',4,1,0,NULL),(4399,1022,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(4400,1022,'N_relative_mass',4404,4397,'mean','se',4,0.020098039215686266,0.00019607843137254833,NULL),(4401,1022,'C_relative_mass',4403,4397,'mean','se',4,0.4502766798418972,0.04885375494071144,NULL),(4402,1022,'P_relative_mass',4405,4397,'mean','se',4,0.018147410358565742,0.00023904382470119146,NULL),(4403,1022,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4404,1022,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4405,1022,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4406,1022,'root_diameter_absolute',NULL,NULL,'minimum',NULL,NULL,NULL,NULL,NULL),(4407,1023,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4408,1023,'mass_relative_mass',4407,4357,'mean','se',4,0.8497854077253217,0.0321888412017168,NULL),(4409,1023,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(4410,1023,'N_relative_mass',4414,4407,'mean','se',4,0.0062745098039215675,0.00039215686274509667,NULL),(4411,1023,'C_relative_mass',4413,4407,'mean','se',4,0.4607114624505928,0.031304347826086994,NULL),(4412,1023,'P_relative_mass',4415,4407,'mean','se',4,0.003964143426294823,0.00023904382470119677,NULL),(4413,1023,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4414,1023,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4415,1023,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4416,1023,'root_diameter_absolute',NULL,NULL,'minimum',NULL,NULL,NULL,NULL,NULL),(4417,1024,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4418,1024,'mass_relative_mass',4417,4357,'mean','se',4,0.8412017167381972,0.04506437768240346,NULL),(4419,1024,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(4420,1024,'N_relative_mass',4424,4417,'mean','se',4,0.006764705882352938,0.00039215686274509667,NULL),(4421,1024,'C_relative_mass',4423,4417,'mean','se',4,0.46023715415019756,0.005691699604743122,NULL),(4422,1024,'P_relative_mass',4425,4417,'mean','se',4,0.004043824701195221,0.0005577689243027902,NULL),(4423,1024,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4424,1024,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4425,1024,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4426,1024,'root_diameter_absolute',NULL,NULL,'minimum',NULL,NULL,NULL,NULL,NULL),(4427,1025,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4428,1025,'mass_relative_mass',4427,4357,'mean','se',4,0.854077253218884,0.015021459227467915,NULL),(4429,1025,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(4430,1025,'N_relative_mass',4434,4427,'mean','se',4,0.006960784313725487,0.0004901960784313744,NULL),(4431,1025,'C_relative_mass',4433,4427,'mean','se',4,0.4711462450592885,0.0009486166007905012,NULL),(4432,1025,'P_relative_mass',4435,4427,'mean','se',4,0.00364541832669323,0.000239043824701195,NULL),(4433,1025,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4434,1025,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4435,1025,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4436,1025,'root_diameter_absolute',NULL,NULL,'minimum',NULL,NULL,NULL,NULL,NULL),(4437,1026,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4438,1026,'mass_relative_mass',4437,4357,'mean','se',4,0.8197424892703863,0.015021459227467773,NULL),(4439,1026,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(4440,1026,'N_relative_mass',4444,4437,'mean','se',4,0.00656862745098039,0.0002941176470588225,NULL),(4441,1026,'C_relative_mass',4443,4437,'mean','se',4,0.48110671936758886,0.0018972332015810593,NULL),(4442,1026,'P_relative_mass',4445,4437,'mean','se',4,0.004123505976095624,0.0003187250996015916,NULL),(4443,1026,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4444,1026,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4445,1026,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4446,1026,'root_diameter_absolute',NULL,NULL,'minimum',NULL,NULL,NULL,NULL,NULL),(4447,1027,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4448,1027,'mass_relative_mass',4447,4357,'mean','se',4,0.5278969957081544,0.09656652360515025,NULL),(4449,1027,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(4450,1027,'N_relative_mass',4454,4447,'mean','se',4,0.007549019607843135,0.0002941176470588225,NULL),(4451,1027,'C_relative_mass',4453,4447,'mean','se',4,0.4801581027667984,0.002845849802371561,NULL),(4452,1027,'P_relative_mass',4455,4447,'mean','se',4,0.006115537848605581,0.0003187250996015951,NULL),(4453,1027,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4454,1027,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4455,1027,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4456,1027,'root_diameter_absolute',NULL,NULL,'minimum',NULL,NULL,NULL,NULL,NULL),(4457,1028,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4458,1028,'mass_relative_mass',4457,4357,'mean','se',4,0.7939914163090129,0.040772532188841096,NULL),(4459,1028,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(4460,1028,'N_relative_mass',4464,4457,'mean','se',4,0.006960784313725487,0.00029411764705882605,NULL),(4461,1028,'C_relative_mass',4463,4457,'mean','se',4,0.470197628458498,0.011383399209486129,NULL),(4462,1028,'P_relative_mass',4465,4457,'mean','se',4,0.005079681274900402,0.0005577689243027883,NULL),(4463,1028,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4464,1028,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4465,1028,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4466,1028,'root_diameter_absolute',NULL,NULL,'minimum',NULL,NULL,NULL,NULL,NULL),(4467,1029,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4468,1029,'mass_relative_mass',4467,4367,'mean','se',4,0.8533057851239668,0.006198347107438167,NULL),(4469,1029,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(4470,1029,'N_relative_mass',4474,4467,'mean','se',4,0.012941176470588234,0.0006862745098039227,NULL),(4471,1029,'C_relative_mass',4473,4467,'mean','se',4,0.49154150197628454,0.028932806324110685,NULL),(4472,1029,'P_relative_mass',4475,4467,'mean','se',4,0.009223107569721115,0.0003187250996015969,NULL),(4473,1029,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4474,1029,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4475,1029,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4476,1029,'root_diameter_absolute',NULL,NULL,'minimum',NULL,NULL,3,NULL,NULL),(4477,1030,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4478,1030,'mass_relative_mass',4477,4367,'mean','se',4,0.8491735537190082,0.010330578512396897,NULL),(4479,1030,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(4480,1030,'N_relative_mass',4484,4477,'mean','se',4,0.013725490196078431,0.0010784313725490176,NULL),(4481,1030,'C_relative_mass',4483,4477,'mean','se',4,0.48110671936758886,0.0014229249011857518,NULL),(4482,1030,'P_relative_mass',4485,4477,'mean','se',4,0.008824701195219126,0.0005577689243027883,NULL),(4483,1030,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4484,1030,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4485,1030,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4486,1030,'root_diameter_absolute',NULL,NULL,'minimum',NULL,NULL,3,NULL,NULL),(4487,1031,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4488,1031,'mass_relative_mass',4487,4367,'mean','se',4,0.8119834710743801,0.045454545454545324,NULL),(4489,1031,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(4490,1031,'N_relative_mass',4494,4487,'mean','se',4,0.014019607843137253,0.0006862745098039191,NULL),(4491,1031,'C_relative_mass',4493,4487,'mean','se',4,0.5005533596837944,0.002845849802371561,NULL),(4492,1031,'P_relative_mass',4495,4487,'mean','se',4,0.009382470119521915,0.00047808764940239,NULL),(4493,1031,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4494,1031,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4495,1031,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4496,1031,'root_diameter_absolute',NULL,NULL,'minimum',NULL,NULL,3,NULL,NULL),(4497,1032,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4498,1032,'mass_relative_mass',4497,4367,'mean','se',4,0.7975206611570246,0.010330578512396897,NULL),(4499,1032,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(4500,1032,'N_relative_mass',4504,4497,'mean','se',4,0.015784313725490193,0.00039215686274509667,NULL),(4501,1032,'C_relative_mass',4503,4497,'mean','se',4,0.5000790513833991,0.0023715415019763667,NULL),(4502,1032,'P_relative_mass',4505,4497,'mean','se',4,0.010418326693227096,0.00047808764940238644,NULL),(4503,1032,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4504,1032,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4505,1032,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4506,1032,'root_diameter_absolute',NULL,NULL,'minimum',NULL,NULL,3,NULL,NULL),(4507,1033,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4508,1033,'mass_relative_mass',4507,4367,'mean','se',4,0.7665289256198345,0.006198347107438167,NULL),(4509,1033,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(4510,1033,'N_relative_mass',4514,4507,'mean','se',4,0.017941176470588228,0.00039215686274510377,NULL),(4511,1033,'C_relative_mass',4513,4507,'mean','se',4,0.4910671936758893,0.0033201581027667544,NULL),(4512,1033,'P_relative_mass',4515,4507,'mean','se',4,0.014083665338645423,0.00039840637450199167,NULL),(4513,1033,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4514,1033,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4515,1033,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4516,1033,'root_diameter_absolute',NULL,NULL,'minimum',NULL,NULL,3,NULL,NULL),(4517,1034,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4518,1034,'mass_relative_mass',4517,4367,'mean','se',4,0.7066115702479339,0.03719008264462815,NULL),(4519,1034,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(4520,1034,'N_relative_mass',4524,4517,'mean','se',4,0.016960784313725486,0.0008823529411764675,NULL),(4521,1034,'C_relative_mass',4523,4517,'mean','se',4,0.4910671936758893,0.002371541501976253,NULL),(4522,1034,'P_relative_mass',4525,4517,'mean','se',4,0.012171314741035858,0.000717131474103585,NULL),(4523,1034,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4524,1034,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4525,1034,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4526,1034,'root_diameter_absolute',NULL,NULL,'minimum',NULL,NULL,3,NULL,NULL),(4527,1035,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4528,1035,'mass_relative_mass',4527,4377,'mean','se',4,0.6880165289256199,0.0041322314049585885,NULL),(4529,1035,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(4530,1035,'N_relative_mass',4534,4527,'mean','se',4,0.015294117647058823,0.0003921568627450949,NULL),(4531,1035,'C_relative_mass',4533,4527,'mean','se',4,0.49154150197628454,0.029407114624505938,NULL),(4532,1035,'P_relative_mass',4535,4527,'mean','se',4,0.009302788844621518,0.00047808764940239,NULL),(4533,1035,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4534,1035,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4535,1035,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4536,1035,'root_diameter_absolute',NULL,NULL,'minimum',NULL,NULL,NULL,NULL,NULL),(4537,1036,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4538,1036,'mass_relative_mass',4537,4377,'mean','se',4,0.6776859504132231,0.022727272727272662,NULL),(4539,1036,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(4540,1036,'N_relative_mass',4544,4537,'mean','se',4,0.015588235294117642,0.0004901960784313691,NULL),(4541,1036,'C_relative_mass',4543,4537,'mean','se',4,0.49059288537549406,0.002371541501976253,NULL),(4542,1036,'P_relative_mass',4545,4537,'mean','se',4,0.00906374501992032,0.00039840637450199346,NULL),(4543,1036,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4544,1036,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4545,1036,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4546,1036,'root_diameter_absolute',NULL,NULL,'minimum',NULL,NULL,NULL,NULL,NULL),(4547,1037,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4548,1037,'mass_relative_mass',4547,4377,'mean','se',4,0.7128099173553718,0.024793388429751956,NULL),(4549,1037,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(4550,1037,'N_relative_mass',4554,4547,'mean','se',4,0.017843137254901956,0.00019607843137255544,NULL),(4551,1037,'C_relative_mass',4553,4547,'mean','se',4,0.4901185770750988,0.004268774703557255,NULL),(4552,1037,'P_relative_mass',4555,4547,'mean','se',4,0.012011952191235065,0.001354581673306768,NULL),(4553,1037,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4554,1037,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4555,1037,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4556,1037,'root_diameter_absolute',NULL,NULL,'minimum',NULL,NULL,NULL,NULL,NULL),(4557,1038,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4558,1038,'mass_relative_mass',4557,4377,'mean','se',4,0.5661157024793387,0.026859504132231465,NULL),(4559,1038,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(4560,1038,'N_relative_mass',4564,4557,'mean','se',4,0.02558823529411764,0.0010784313725490228,NULL),(4561,1038,'C_relative_mass',4563,4557,'mean','se',4,0.49059288537549406,0.005691699604743064,NULL),(4562,1038,'P_relative_mass',4565,4557,'mean','se',4,0.017350597609561754,0.00031872509960159337,NULL),(4563,1038,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4564,1038,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4565,1038,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4566,1038,'root_diameter_absolute',NULL,NULL,'minimum',NULL,NULL,NULL,NULL,NULL),(4567,1039,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4568,1039,'mass_relative_mass',4567,4377,'mean','se',4,0.4855371900826445,0.02892561983471076,NULL),(4569,1039,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(4570,1039,'N_relative_mass',4574,4567,'mean','se',4,0.02872549019607843,0.0010784313725490122,NULL),(4571,1039,'C_relative_mass',4573,4567,'mean','se',4,0.5010276679841897,0.004268774703557313,NULL),(4572,1039,'P_relative_mass',4575,4567,'mean','se',4,0.02308764940239044,0.00047808764940239,NULL),(4573,1039,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4574,1039,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4575,1039,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4576,1039,'root_diameter_absolute',NULL,NULL,'minimum',NULL,NULL,NULL,NULL,NULL),(4577,1040,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4578,1040,'mass_relative_mass',4577,4377,'mean','se',4,0.5206611570247932,0.030991735537190125,NULL),(4579,1040,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(4580,1040,'N_relative_mass',4584,4577,'mean','se',4,0.02794117647058823,0.0002941176470588296,NULL),(4581,1040,'C_relative_mass',4583,4577,'mean','se',4,0.47067193675889324,0.010909090909090879,NULL),(4582,1040,'P_relative_mass',4585,4577,'mean','se',4,0.019183266932270918,0.0007968127490039833,NULL),(4583,1040,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4584,1040,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4585,1040,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4586,1040,'root_diameter_absolute',NULL,NULL,'minimum',NULL,NULL,NULL,NULL,NULL),(4587,1041,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4588,1041,'mass_relative_mass',4587,4387,'mean','se',4,0.6062801932367148,0.07246376811594217,NULL),(4589,1041,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(4590,1041,'N_relative_mass',4594,4587,'mean','se',4,0.005784313725490192,0.0005882352941176494,NULL),(4591,1041,'C_relative_mass',4593,4587,'mean','se',4,0.44980237154150193,0.0037944664031620617,NULL),(4592,1041,'P_relative_mass',4595,4587,'mean','se',4,0.011215139442231075,0.0011155378486055803,NULL),(4593,1041,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4594,1041,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4595,1041,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4596,1041,'root_diameter_absolute',NULL,NULL,'minimum',NULL,NULL,0,NULL,NULL),(4597,1042,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4598,1042,'mass_relative_mass',4597,4387,'mean','se',4,0.6763285024154588,0.043478260869565306,NULL),(4599,1042,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(4600,1042,'N_relative_mass',4604,4597,'mean','se',4,0.006176470588235294,0.000588235294117645,NULL),(4601,1042,'C_relative_mass',4603,4597,'mean','se',4,0.4398418972332015,0.002845849802371561,NULL),(4602,1042,'P_relative_mass',4605,4597,'mean','se',4,0.011533864541832669,0.0016733067729083687,NULL),(4603,1042,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4604,1042,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4605,1042,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4606,1042,'root_diameter_absolute',NULL,NULL,'minimum',NULL,NULL,0,NULL,NULL),(4607,1043,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4608,1043,'mass_relative_mass',4607,4387,'mean','se',4,0.5096618357487922,0.019323671497584485,NULL),(4609,1043,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(4610,1043,'N_relative_mass',4614,4607,'mean','se',4,0.006862745098039213,0.0002941176470588225,NULL),(4611,1043,'C_relative_mass',4613,4607,'mean','se',4,0.4607114624505928,0.008537549407114682,NULL),(4612,1043,'P_relative_mass',4615,4607,'mean','se',4,0.012091633466135464,0.0011952191235059715,NULL),(4613,1043,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4614,1043,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4615,1043,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4616,1043,'root_diameter_absolute',NULL,NULL,'minimum',NULL,NULL,0,NULL,NULL),(4617,1044,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4618,1044,'mass_relative_mass',4617,4387,'mean','se',4,0.4323671497584543,0.0797101449275361,NULL),(4619,1044,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(4620,1044,'N_relative_mass',4624,4617,'mean','se',4,0.007156862745098035,0.0003921568627451002,NULL),(4621,1044,'C_relative_mass',4623,4617,'mean','se',4,0.470197628458498,0.009486166007905127,NULL),(4622,1044,'P_relative_mass',4625,4617,'mean','se',4,0.009780876494023908,0.00023904382470119322,NULL),(4623,1044,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4624,1044,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4625,1044,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4626,1044,'root_diameter_absolute',NULL,NULL,'minimum',NULL,NULL,0,NULL,NULL),(4627,1045,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4628,1045,'mass_relative_mass',4627,4387,'mean','se',4,0.36231884057971014,0.026570048309178845,NULL),(4629,1045,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(4630,1045,'N_relative_mass',4634,4627,'mean','se',4,0.007156862745098035,0.0006862745098039227,NULL),(4631,1045,'C_relative_mass',4633,4627,'mean','se',4,0.4616600790513834,0.002371541501976253,NULL),(4632,1045,'P_relative_mass',4635,4627,'mean','se',4,0.012091633466135464,0.0013545816733067646,NULL),(4633,1045,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4634,1045,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4635,1045,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4636,1045,'root_diameter_absolute',NULL,NULL,'minimum',NULL,NULL,0,NULL,NULL),(4637,1046,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4638,1046,'mass_relative_mass',4637,4387,'mean','se',4,0.2512077294685991,0.01690821256038653,NULL),(4639,1046,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(4640,1046,'N_relative_mass',4644,4637,'mean','se',4,0.010098039215686274,0.0004901960784313708,NULL),(4641,1046,'C_relative_mass',4643,4637,'mean','se',4,0.46023715415019756,0.01422924901185769,NULL),(4642,1046,'P_relative_mass',4645,4637,'mean','se',4,0.015199203187250996,0.0010358565737051872,NULL),(4643,1046,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4644,1046,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4645,1046,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4646,1046,'root_diameter_absolute',NULL,NULL,'minimum',NULL,NULL,0,NULL,NULL),(4647,1047,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4648,1047,'mass_relative_mass',4647,4397,'mean','se',4,0.8236714975845412,0.0193236714975842,NULL),(4649,1047,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(4650,1047,'N_relative_mass',4654,4647,'mean','se',4,0.020490196078431364,0.0011764705882353005,NULL),(4651,1047,'C_relative_mass',4653,4647,'mean','se',4,0.47067193675889324,0.002371541501976253,NULL),(4652,1047,'P_relative_mass',4655,4647,'mean','se',4,0.010498007968127493,0.00191235059760956,NULL),(4653,1047,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4654,1047,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4655,1047,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4656,1047,'root_diameter_absolute',NULL,NULL,'minimum',NULL,NULL,NULL,NULL,NULL),(4657,1048,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4658,1048,'mass_relative_mass',4657,4397,'mean','se',4,0.8357487922705311,0.02898550724637701,NULL),(4659,1048,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(4660,1048,'N_relative_mass',4664,4657,'mean','se',4,0.022156862745098035,0.001176470588235297,NULL),(4661,1048,'C_relative_mass',4663,4657,'mean','se',4,0.4716205533596838,0.0009486166007905012,NULL),(4662,1048,'P_relative_mass',4665,4657,'mean','se',4,0.010258964143426296,0.0010358565737051783,NULL),(4663,1048,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4664,1048,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4665,1048,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4666,1048,'root_diameter_absolute',NULL,NULL,'minimum',NULL,NULL,NULL,NULL,NULL),(4667,1049,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4668,1049,'mass_relative_mass',4667,4397,'mean','se',4,0.8985507246376809,0.050724637681159805,NULL),(4669,1049,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(4670,1049,'N_relative_mass',4674,4667,'mean','se',4,0.022058823529411763,0.0006862745098039191,NULL),(4671,1049,'C_relative_mass',4673,4667,'mean','se',4,0.46118577075098804,0.007588932806324181,NULL),(4672,1049,'P_relative_mass',4675,4667,'mean','se',4,0.01655378486055777,0.0017529880478087635,NULL),(4673,1049,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4674,1049,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4675,1049,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4676,1049,'root_diameter_absolute',NULL,NULL,'minimum',NULL,NULL,NULL,NULL,NULL),(4677,1050,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4678,1050,'mass_relative_mass',4677,4397,'mean','se',4,0.6231884057971016,0.06521739130434767,NULL),(4679,1050,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(4680,1050,'N_relative_mass',4684,4677,'mean','se',4,0.02127450980392157,0.001764705882352935,NULL),(4681,1050,'C_relative_mass',4683,4677,'mean','se',4,0.47067193675889324,0.009011857707509875,NULL),(4682,1050,'P_relative_mass',4685,4677,'mean','se',4,0.01846613545816733,0.0015139442231075718,NULL),(4683,1050,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4684,1050,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4685,1050,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4686,1050,'root_diameter_absolute',NULL,NULL,'minimum',NULL,NULL,NULL,NULL,NULL),(4687,1051,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4688,1051,'mass_relative_mass',4687,4397,'mean','se',4,0.5096618357487922,0.06038647342995162,NULL),(4689,1051,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(4690,1051,'N_relative_mass',4694,4687,'mean','se',4,0.02441176470588235,0.002156862745098035,NULL),(4691,1051,'C_relative_mass',4693,4687,'mean','se',4,0.4512252964426877,0.0033201581027668113,NULL),(4692,1051,'P_relative_mass',4695,4687,'mean','se',4,0.025079681274900394,0.0018326693227091653,NULL),(4693,1051,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4694,1051,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4695,1051,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4696,1051,'root_diameter_absolute',NULL,NULL,'minimum',NULL,NULL,NULL,NULL,NULL),(4697,1052,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4698,1052,'mass_relative_mass',4697,4397,'mean','se',4,0.4613526570048309,0.02657004830917856,NULL),(4699,1052,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(4700,1052,'N_relative_mass',4704,4697,'mean','se',4,0.020882352941176466,0.0025490196078431387,NULL),(4701,1052,'C_relative_mass',4703,4697,'mean','se',4,0.46023715415019756,0.013280632411067188,NULL),(4702,1052,'P_relative_mass',4705,4697,'mean','se',4,0.025159362549800796,0.0016733067729083687,NULL),(4703,1052,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4704,1052,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4705,1052,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4706,1052,'root_diameter_absolute',NULL,NULL,'minimum',NULL,NULL,NULL,NULL,NULL),(4707,1053,'water_table_depth',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4708,1053,'pH',NULL,NULL,'mean','se',21,3.8,0.03,NULL),(4709,1054,'water_table_depth',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4710,1054,'pH',NULL,NULL,'mean','se',21,6.9,0.1,NULL),(4711,1055,'water_table_depth',NULL,NULL,'mean','se',21,37,6,NULL),(4712,1055,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4713,1056,'water_table_depth',NULL,NULL,'mean','se',21,1,5,NULL),(4714,1056,'pH',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4715,1062,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4716,1062,'mass_relative_mass',4715,4715,'mean','se',6,1,0,NULL),(4717,1062,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(4718,1062,'N_relative_mass',4722,4722,'mean','se',6,1,0,NULL),(4719,1062,'C_relative_mass',4721,4721,'mean','se',6,1,0,NULL),(4720,1062,'P_relative_mass',4723,4723,'mean','se',6,1,0,NULL),(4721,1062,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4722,1062,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4723,1062,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4724,1063,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4725,1063,'mass_relative_mass',4724,4724,'mean','se',6,1,0,NULL),(4726,1063,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(4727,1063,'N_relative_mass',4731,4731,'mean','se',6,1,0,NULL),(4728,1063,'C_relative_mass',4730,4730,'mean','se',6,1,0,NULL),(4729,1063,'P_relative_mass',4732,4732,'mean','se',6,1,0,NULL),(4730,1063,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4731,1063,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4732,1063,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4733,1064,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4734,1064,'mass_relative_mass',4733,4733,'mean','se',6,1,0,NULL),(4735,1064,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(4736,1064,'N_relative_mass',4740,4740,'mean','se',6,1,0,NULL),(4737,1064,'C_relative_mass',4739,4739,'mean','se',6,1,0,NULL),(4738,1064,'P_relative_mass',4741,4741,'mean','se',6,1,0,NULL),(4739,1064,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4740,1064,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4741,1064,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4742,1065,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4743,1065,'mass_relative_mass',4742,4715,'mean','se',6,0.848,0.011000000000000001,NULL),(4744,1065,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(4745,1065,'N_relative_mass',4749,4722,'mean',NULL,NULL,NULL,NULL,NULL),(4746,1065,'C_relative_mass',4748,4721,'mean',NULL,NULL,NULL,NULL,NULL),(4747,1065,'P_relative_mass',4750,4723,'mean',NULL,NULL,NULL,NULL,NULL),(4748,1065,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4749,1065,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4750,1065,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4751,1066,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4752,1066,'mass_relative_mass',4751,4724,'mean','se',6,0.871,0.011000000000000001,NULL),(4753,1066,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(4754,1066,'N_relative_mass',4758,4731,'mean',NULL,NULL,NULL,NULL,NULL),(4755,1066,'C_relative_mass',4757,4730,'mean',NULL,NULL,NULL,NULL,NULL),(4756,1066,'P_relative_mass',4759,4732,'mean',NULL,NULL,NULL,NULL,NULL),(4757,1066,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4758,1066,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4759,1066,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4760,1067,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4761,1067,'mass_relative_mass',4760,4733,'mean','se',6,0.986,0.021,NULL),(4762,1067,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(4763,1067,'N_relative_mass',4767,4740,'mean',NULL,NULL,NULL,NULL,NULL),(4764,1067,'C_relative_mass',4766,4739,'mean',NULL,NULL,NULL,NULL,NULL),(4765,1067,'P_relative_mass',4768,4741,'mean',NULL,NULL,NULL,NULL,NULL),(4766,1067,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4767,1067,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4768,1067,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4769,1068,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4770,1068,'mass_relative_mass',4769,4715,'mean','se',6,0.696,0.023,NULL),(4771,1068,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(4772,1068,'N_relative_mass',4776,4722,'mean',NULL,NULL,NULL,NULL,NULL),(4773,1068,'C_relative_mass',4775,4721,'mean',NULL,NULL,NULL,NULL,NULL),(4774,1068,'P_relative_mass',4777,4723,'mean',NULL,NULL,NULL,NULL,NULL),(4775,1068,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4776,1068,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4777,1068,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4778,1069,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4779,1069,'mass_relative_mass',4778,4724,'mean','se',6,0.713,0.044000000000000004,NULL),(4780,1069,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(4781,1069,'N_relative_mass',4785,4731,'mean',NULL,NULL,NULL,NULL,NULL),(4782,1069,'C_relative_mass',4784,4730,'mean',NULL,NULL,NULL,NULL,NULL),(4783,1069,'P_relative_mass',4786,4732,'mean',NULL,NULL,NULL,NULL,NULL),(4784,1069,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4785,1069,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4786,1069,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4787,1070,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4788,1070,'mass_relative_mass',4787,4733,'mean','se',6,0.9109999999999999,0.01,NULL),(4789,1070,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(4790,1070,'N_relative_mass',4794,4740,'mean',NULL,NULL,NULL,NULL,NULL),(4791,1070,'C_relative_mass',4793,4739,'mean',NULL,NULL,NULL,NULL,NULL),(4792,1070,'P_relative_mass',4795,4741,'mean',NULL,NULL,NULL,NULL,NULL),(4793,1070,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4794,1070,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4795,1070,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4796,1071,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4797,1071,'mass_relative_mass',4796,4715,'mean','se',6,0.604,0.03,NULL),(4798,1071,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(4799,1071,'N_relative_mass',4803,4722,'mean',NULL,NULL,NULL,NULL,NULL),(4800,1071,'C_relative_mass',4802,4721,'mean',NULL,NULL,NULL,NULL,NULL),(4801,1071,'P_relative_mass',4804,4723,'mean',NULL,NULL,NULL,NULL,NULL),(4802,1071,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4803,1071,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4804,1071,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4805,1072,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4806,1072,'mass_relative_mass',4805,4724,'mean','se',6,0.6509999999999999,0.012,NULL),(4807,1072,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(4808,1072,'N_relative_mass',4812,4731,'mean',NULL,NULL,NULL,NULL,NULL),(4809,1072,'C_relative_mass',4811,4730,'mean',NULL,NULL,NULL,NULL,NULL),(4810,1072,'P_relative_mass',4813,4732,'mean',NULL,NULL,NULL,NULL,NULL),(4811,1072,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4812,1072,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4813,1072,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4814,1073,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4815,1073,'mass_relative_mass',4814,4733,'mean','se',6,0.8759999999999999,0.015,NULL),(4816,1073,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(4817,1073,'N_relative_mass',4821,4740,'mean',NULL,NULL,NULL,NULL,NULL),(4818,1073,'C_relative_mass',4820,4739,'mean',NULL,NULL,NULL,NULL,NULL),(4819,1073,'P_relative_mass',4822,4741,'mean',NULL,NULL,NULL,NULL,NULL),(4820,1073,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4821,1073,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4822,1073,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4823,1074,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4824,1074,'mass_relative_mass',4823,4823,'mean','se',6,1,0,NULL),(4825,1074,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(4826,1074,'N_relative_mass',4830,4830,'mean','se',6,1,0,NULL),(4827,1074,'C_relative_mass',4829,4829,'mean','se',6,1,0,NULL),(4828,1074,'P_relative_mass',4831,4831,'mean','se',6,1,0,NULL),(4829,1074,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4830,1074,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4831,1074,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4832,1075,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4833,1075,'mass_relative_mass',4832,4832,'mean','se',6,1,0,NULL),(4834,1075,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(4835,1075,'N_relative_mass',4839,4839,'mean','se',6,1,0,NULL),(4836,1075,'C_relative_mass',4838,4838,'mean','se',6,1,0,NULL),(4837,1075,'P_relative_mass',4840,4840,'mean','se',6,1,0,NULL),(4838,1075,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4839,1075,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4840,1075,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4841,1076,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4842,1076,'mass_relative_mass',4841,4841,'mean','se',6,1,0,NULL),(4843,1076,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(4844,1076,'N_relative_mass',4848,4848,'mean','se',6,1,0,NULL),(4845,1076,'C_relative_mass',4847,4847,'mean','se',6,1,0,NULL),(4846,1076,'P_relative_mass',4849,4849,'mean','se',6,1,0,NULL),(4847,1076,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4848,1076,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4849,1076,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4850,1077,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4851,1077,'mass_relative_mass',4850,4823,'mean','se',6,0.862,0.004,NULL),(4852,1077,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(4853,1077,'N_relative_mass',4857,4830,'mean',NULL,NULL,NULL,NULL,NULL),(4854,1077,'C_relative_mass',4856,4829,'mean',NULL,NULL,NULL,NULL,NULL),(4855,1077,'P_relative_mass',4858,4831,'mean',NULL,NULL,NULL,NULL,NULL),(4856,1077,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4857,1077,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4858,1077,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4859,1078,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4860,1078,'mass_relative_mass',4859,4832,'mean','se',6,0.899,0.016,NULL),(4861,1078,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(4862,1078,'N_relative_mass',4866,4839,'mean',NULL,NULL,NULL,NULL,NULL),(4863,1078,'C_relative_mass',4865,4838,'mean',NULL,NULL,NULL,NULL,NULL),(4864,1078,'P_relative_mass',4867,4840,'mean',NULL,NULL,NULL,NULL,NULL),(4865,1078,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4866,1078,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4867,1078,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4868,1079,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4869,1079,'mass_relative_mass',4868,4841,'mean','se',6,0.9790000000000001,0.021,NULL),(4870,1079,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(4871,1079,'N_relative_mass',4875,4848,'mean',NULL,NULL,NULL,NULL,NULL),(4872,1079,'C_relative_mass',4874,4847,'mean',NULL,NULL,NULL,NULL,NULL),(4873,1079,'P_relative_mass',4876,4849,'mean',NULL,NULL,NULL,NULL,NULL),(4874,1079,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4875,1079,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4876,1079,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4877,1080,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4878,1080,'mass_relative_mass',4877,4823,'mean','se',6,0.725,0.038,NULL),(4879,1080,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(4880,1080,'N_relative_mass',4884,4830,'mean',NULL,NULL,NULL,NULL,NULL),(4881,1080,'C_relative_mass',4883,4829,'mean',NULL,NULL,NULL,NULL,NULL),(4882,1080,'P_relative_mass',4885,4831,'mean',NULL,NULL,NULL,NULL,NULL),(4883,1080,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4884,1080,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4885,1080,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4886,1081,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4887,1081,'mass_relative_mass',4886,4832,'mean','se',6,0.716,0.028999999999999998,NULL),(4888,1081,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(4889,1081,'N_relative_mass',4893,4839,'mean',NULL,NULL,NULL,NULL,NULL),(4890,1081,'C_relative_mass',4892,4838,'mean',NULL,NULL,NULL,NULL,NULL),(4891,1081,'P_relative_mass',4894,4840,'mean',NULL,NULL,NULL,NULL,NULL),(4892,1081,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4893,1081,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4894,1081,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4895,1082,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4896,1082,'mass_relative_mass',4895,4841,'mean','se',6,0.935,0.015,NULL),(4897,1082,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(4898,1082,'N_relative_mass',4902,4848,'mean',NULL,NULL,NULL,NULL,NULL),(4899,1082,'C_relative_mass',4901,4847,'mean',NULL,NULL,NULL,NULL,NULL),(4900,1082,'P_relative_mass',4903,4849,'mean',NULL,NULL,NULL,NULL,NULL),(4901,1082,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4902,1082,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4903,1082,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4904,1083,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4905,1083,'mass_relative_mass',4904,4823,'mean','se',6,0.688,0.046,NULL),(4906,1083,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(4907,1083,'N_relative_mass',4911,4830,'mean',NULL,NULL,NULL,NULL,NULL),(4908,1083,'C_relative_mass',4910,4829,'mean',NULL,NULL,NULL,NULL,NULL),(4909,1083,'P_relative_mass',4912,4831,'mean',NULL,NULL,NULL,NULL,NULL),(4910,1083,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4911,1083,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4912,1083,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4913,1084,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4914,1084,'mass_relative_mass',4913,4832,'mean','se',6,0.6809999999999999,0.009000000000000001,NULL),(4915,1084,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(4916,1084,'N_relative_mass',4920,4839,'mean',NULL,NULL,NULL,NULL,NULL),(4917,1084,'C_relative_mass',4919,4838,'mean',NULL,NULL,NULL,NULL,NULL),(4918,1084,'P_relative_mass',4921,4840,'mean',NULL,NULL,NULL,NULL,NULL),(4919,1084,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4920,1084,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4921,1084,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4922,1085,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4923,1085,'mass_relative_mass',4922,4841,'mean','se',6,0.8390000000000001,0.011000000000000001,NULL),(4924,1085,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(4925,1085,'N_relative_mass',4929,4848,'mean',NULL,NULL,NULL,NULL,NULL),(4926,1085,'C_relative_mass',4928,4847,'mean',NULL,NULL,NULL,NULL,NULL),(4927,1085,'P_relative_mass',4930,4849,'mean',NULL,NULL,NULL,NULL,NULL),(4928,1085,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4929,1085,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4930,1085,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4931,1086,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4932,1086,'mass_relative_mass',4931,4931,'mean','se',6,1,0,NULL),(4933,1086,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(4934,1086,'N_relative_mass',4938,4938,'mean','se',6,1,0,NULL),(4935,1086,'C_relative_mass',4937,4937,'mean','se',6,1,0,NULL),(4936,1086,'P_relative_mass',4939,4939,'mean','se',6,1,0,NULL),(4937,1086,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4938,1086,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4939,1086,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4940,1087,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4941,1087,'mass_relative_mass',4940,4940,'mean','se',6,1,0,NULL),(4942,1087,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(4943,1087,'N_relative_mass',4947,4947,'mean','se',6,1,0,NULL),(4944,1087,'C_relative_mass',4946,4946,'mean','se',6,1,0,NULL),(4945,1087,'P_relative_mass',4948,4948,'mean','se',6,1,0,NULL),(4946,1087,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4947,1087,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4948,1087,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4949,1088,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4950,1088,'mass_relative_mass',4949,4949,'mean','se',6,1,0,NULL),(4951,1088,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(4952,1088,'N_relative_mass',4956,4956,'mean','se',6,1,0,NULL),(4953,1088,'C_relative_mass',4955,4955,'mean','se',6,1,0,NULL),(4954,1088,'P_relative_mass',4957,4957,'mean','se',6,1,0,NULL),(4955,1088,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4956,1088,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4957,1088,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4958,1089,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4959,1089,'mass_relative_mass',4958,4931,'mean','se',6,0.8540000000000001,0.011000000000000001,NULL),(4960,1089,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(4961,1089,'N_relative_mass',4965,4938,'mean',NULL,NULL,NULL,NULL,NULL),(4962,1089,'C_relative_mass',4964,4937,'mean',NULL,NULL,NULL,NULL,NULL),(4963,1089,'P_relative_mass',4966,4939,'mean',NULL,NULL,NULL,NULL,NULL),(4964,1089,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4965,1089,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4966,1089,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4967,1090,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4968,1090,'mass_relative_mass',4967,4940,'mean','se',6,0.8740000000000001,0.017,NULL),(4969,1090,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(4970,1090,'N_relative_mass',4974,4947,'mean',NULL,NULL,NULL,NULL,NULL),(4971,1090,'C_relative_mass',4973,4946,'mean',NULL,NULL,NULL,NULL,NULL),(4972,1090,'P_relative_mass',4975,4948,'mean',NULL,NULL,NULL,NULL,NULL),(4973,1090,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4974,1090,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4975,1090,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4976,1091,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4977,1091,'mass_relative_mass',4976,4949,'mean','se',6,0.99,0.028999999999999998,NULL),(4978,1091,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(4979,1091,'N_relative_mass',4983,4956,'mean',NULL,NULL,NULL,NULL,NULL),(4980,1091,'C_relative_mass',4982,4955,'mean',NULL,NULL,NULL,NULL,NULL),(4981,1091,'P_relative_mass',4984,4957,'mean',NULL,NULL,NULL,NULL,NULL),(4982,1091,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4983,1091,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4984,1091,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4985,1092,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4986,1092,'mass_relative_mass',4985,4931,'mean','se',6,0.7040000000000001,0.037000000000000005,NULL),(4987,1092,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(4988,1092,'N_relative_mass',4992,4938,'mean',NULL,NULL,NULL,NULL,NULL),(4989,1092,'C_relative_mass',4991,4937,'mean',NULL,NULL,NULL,NULL,NULL),(4990,1092,'P_relative_mass',4993,4939,'mean',NULL,NULL,NULL,NULL,NULL),(4991,1092,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4992,1092,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4993,1092,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4994,1093,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(4995,1093,'mass_relative_mass',4994,4940,'mean','se',6,0.716,0.016,NULL),(4996,1093,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(4997,1093,'N_relative_mass',5001,4947,'mean',NULL,NULL,NULL,NULL,NULL),(4998,1093,'C_relative_mass',5000,4946,'mean',NULL,NULL,NULL,NULL,NULL),(4999,1093,'P_relative_mass',5002,4948,'mean',NULL,NULL,NULL,NULL,NULL),(5000,1093,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5001,1093,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5002,1093,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5003,1094,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5004,1094,'mass_relative_mass',5003,4949,'mean','se',6,0.922,0.013999999999999999,NULL),(5005,1094,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(5006,1094,'N_relative_mass',5010,4956,'mean',NULL,NULL,NULL,NULL,NULL),(5007,1094,'C_relative_mass',5009,4955,'mean',NULL,NULL,NULL,NULL,NULL),(5008,1094,'P_relative_mass',5011,4957,'mean',NULL,NULL,NULL,NULL,NULL),(5009,1094,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5010,1094,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5011,1094,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5012,1095,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5013,1095,'mass_relative_mass',5012,4931,'mean','se',6,0.664,0.032,NULL),(5014,1095,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(5015,1095,'N_relative_mass',5019,4938,'mean',NULL,NULL,NULL,NULL,NULL),(5016,1095,'C_relative_mass',5018,4937,'mean',NULL,NULL,NULL,NULL,NULL),(5017,1095,'P_relative_mass',5020,4939,'mean',NULL,NULL,NULL,NULL,NULL),(5018,1095,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5019,1095,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5020,1095,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5021,1096,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5022,1096,'mass_relative_mass',5021,4940,'mean','se',6,0.833,0.017,NULL),(5023,1096,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(5024,1096,'N_relative_mass',5028,4947,'mean',NULL,NULL,NULL,NULL,NULL),(5025,1096,'C_relative_mass',5027,4946,'mean',NULL,NULL,NULL,NULL,NULL),(5026,1096,'P_relative_mass',5029,4948,'mean',NULL,NULL,NULL,NULL,NULL),(5027,1096,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5028,1096,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5029,1096,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5030,1097,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5031,1097,'mass_relative_mass',5030,4949,'mean','se',6,0.833,0.017,NULL),(5032,1097,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(5033,1097,'N_relative_mass',5037,4956,'mean',NULL,NULL,NULL,NULL,NULL),(5034,1097,'C_relative_mass',5036,4955,'mean',NULL,NULL,NULL,NULL,NULL),(5035,1097,'P_relative_mass',5038,4957,'mean',NULL,NULL,NULL,NULL,NULL),(5036,1097,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5037,1097,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5038,1097,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5039,1098,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5040,1098,'mass_relative_mass',5039,5039,'mean','se',6,1,0,NULL),(5041,1098,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(5042,1098,'N_relative_mass',5046,5046,'mean','se',6,1,0,NULL),(5043,1098,'C_relative_mass',5045,5045,'mean','se',6,1,0,NULL),(5044,1098,'P_relative_mass',5047,5047,'mean','se',6,1,0,NULL),(5045,1098,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5046,1098,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5047,1098,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5048,1099,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5049,1099,'mass_relative_mass',5048,5048,'mean','se',6,1,0,NULL),(5050,1099,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(5051,1099,'N_relative_mass',5055,5055,'mean','se',6,1,0,NULL),(5052,1099,'C_relative_mass',5054,5054,'mean','se',6,1,0,NULL),(5053,1099,'P_relative_mass',5056,5056,'mean','se',6,1,0,NULL),(5054,1099,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5055,1099,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5056,1099,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5057,1100,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5058,1100,'mass_relative_mass',5057,5057,'mean','se',6,1,0,NULL),(5059,1100,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(5060,1100,'N_relative_mass',5064,5064,'mean','se',6,1,0,NULL),(5061,1100,'C_relative_mass',5063,5063,'mean','se',6,1,0,NULL),(5062,1100,'P_relative_mass',5065,5065,'mean','se',6,1,0,NULL),(5063,1100,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5064,1100,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5065,1100,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5066,1101,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5067,1101,'mass_relative_mass',5066,5039,'mean','se',6,0.652,0.01,NULL),(5068,1101,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(5069,1101,'N_relative_mass',5073,5046,'mean',NULL,NULL,NULL,NULL,NULL),(5070,1101,'C_relative_mass',5072,5045,'mean',NULL,NULL,NULL,NULL,NULL),(5071,1101,'P_relative_mass',5074,5047,'mean',NULL,NULL,NULL,NULL,NULL),(5072,1101,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5073,1101,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5074,1101,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5075,1102,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5076,1102,'mass_relative_mass',5075,5048,'mean','se',6,0.6779999999999999,0.02,NULL),(5077,1102,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(5078,1102,'N_relative_mass',5082,5055,'mean',NULL,NULL,NULL,NULL,NULL),(5079,1102,'C_relative_mass',5081,5054,'mean',NULL,NULL,NULL,NULL,NULL),(5080,1102,'P_relative_mass',5083,5056,'mean',NULL,NULL,NULL,NULL,NULL),(5081,1102,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5082,1102,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5083,1102,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5084,1103,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5085,1103,'mass_relative_mass',5084,5057,'mean','se',6,0.818,0.006,NULL),(5086,1103,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(5087,1103,'N_relative_mass',5091,5064,'mean',NULL,NULL,NULL,NULL,NULL),(5088,1103,'C_relative_mass',5090,5063,'mean',NULL,NULL,NULL,NULL,NULL),(5089,1103,'P_relative_mass',5092,5065,'mean',NULL,NULL,NULL,NULL,NULL),(5090,1103,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5091,1103,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5092,1103,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5093,1104,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5094,1104,'mass_relative_mass',5093,5039,'mean','se',6,0.706,0.026000000000000002,NULL),(5095,1104,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(5096,1104,'N_relative_mass',5100,5046,'mean',NULL,NULL,NULL,NULL,NULL),(5097,1104,'C_relative_mass',5099,5045,'mean',NULL,NULL,NULL,NULL,NULL),(5098,1104,'P_relative_mass',5101,5047,'mean',NULL,NULL,NULL,NULL,NULL),(5099,1104,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5100,1104,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5101,1104,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5102,1105,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5103,1105,'mass_relative_mass',5102,5048,'mean','se',6,0.706,0.02,NULL),(5104,1105,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(5105,1105,'N_relative_mass',5109,5055,'mean',NULL,NULL,NULL,NULL,NULL),(5106,1105,'C_relative_mass',5108,5054,'mean',NULL,NULL,NULL,NULL,NULL),(5107,1105,'P_relative_mass',5110,5056,'mean',NULL,NULL,NULL,NULL,NULL),(5108,1105,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5109,1105,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5110,1105,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5111,1106,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5112,1106,'mass_relative_mass',5111,5057,'mean','se',6,0.778,0.009000000000000001,NULL),(5113,1106,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(5114,1106,'N_relative_mass',5118,5064,'mean',NULL,NULL,NULL,NULL,NULL),(5115,1106,'C_relative_mass',5117,5063,'mean',NULL,NULL,NULL,NULL,NULL),(5116,1106,'P_relative_mass',5119,5065,'mean',NULL,NULL,NULL,NULL,NULL),(5117,1106,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5118,1106,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5119,1106,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5120,1107,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5121,1107,'mass_relative_mass',5120,5039,'mean','se',6,0.612,0.021,NULL),(5122,1107,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(5123,1107,'N_relative_mass',5127,5046,'mean',NULL,NULL,NULL,NULL,NULL),(5124,1107,'C_relative_mass',5126,5045,'mean',NULL,NULL,NULL,NULL,NULL),(5125,1107,'P_relative_mass',5128,5047,'mean',NULL,NULL,NULL,NULL,NULL),(5126,1107,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5127,1107,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5128,1107,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5129,1108,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5130,1108,'mass_relative_mass',5129,5048,'mean','se',6,0.623,0.009000000000000001,NULL),(5131,1108,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(5132,1108,'N_relative_mass',5136,5055,'mean',NULL,NULL,NULL,NULL,NULL),(5133,1108,'C_relative_mass',5135,5054,'mean',NULL,NULL,NULL,NULL,NULL),(5134,1108,'P_relative_mass',5137,5056,'mean',NULL,NULL,NULL,NULL,NULL),(5135,1108,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5136,1108,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5137,1108,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5138,1109,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5139,1109,'mass_relative_mass',5138,5057,'mean','se',6,0.755,0.01,NULL),(5140,1109,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(5141,1109,'N_relative_mass',5145,5064,'mean',NULL,NULL,NULL,NULL,NULL),(5142,1109,'C_relative_mass',5144,5063,'mean',NULL,NULL,NULL,NULL,NULL),(5143,1109,'P_relative_mass',5146,5065,'mean',NULL,NULL,NULL,NULL,NULL),(5144,1109,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5145,1109,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5146,1109,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5147,1110,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5148,1110,'mass_relative_mass',5147,5147,'mean','se',6,1,0,NULL),(5149,1110,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(5150,1110,'N_relative_mass',5154,5154,'mean','se',6,1,0,NULL),(5151,1110,'C_relative_mass',5153,5153,'mean','se',6,1,0,NULL),(5152,1110,'P_relative_mass',5155,5155,'mean','se',6,1,0,NULL),(5153,1110,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5154,1110,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5155,1110,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5156,1111,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5157,1111,'mass_relative_mass',5156,5156,'mean','se',6,1,0,NULL),(5158,1111,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(5159,1111,'N_relative_mass',5163,5163,'mean','se',6,1,0,NULL),(5160,1111,'C_relative_mass',5162,5162,'mean','se',6,1,0,NULL),(5161,1111,'P_relative_mass',5164,5164,'mean','se',6,1,0,NULL),(5162,1111,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5163,1111,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5164,1111,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5165,1112,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5166,1112,'mass_relative_mass',5165,5165,'mean','se',6,1,0,NULL),(5167,1112,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(5168,1112,'N_relative_mass',5172,5172,'mean','se',6,1,0,NULL),(5169,1112,'C_relative_mass',5171,5171,'mean','se',6,1,0,NULL),(5170,1112,'P_relative_mass',5173,5173,'mean','se',6,1,0,NULL),(5171,1112,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5172,1112,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5173,1112,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5174,1113,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5175,1113,'mass_relative_mass',5174,5147,'mean','se',6,1.04,0.036000000000000004,NULL),(5176,1113,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(5177,1113,'N_relative_mass',5181,5154,'mean',NULL,NULL,NULL,NULL,NULL),(5178,1113,'C_relative_mass',5180,5153,'mean',NULL,NULL,NULL,NULL,NULL),(5179,1113,'P_relative_mass',5182,5155,'mean',NULL,NULL,NULL,NULL,NULL),(5180,1113,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5181,1113,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5182,1113,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5183,1114,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5184,1114,'mass_relative_mass',5183,5156,'mean','se',6,1.04,0.031,NULL),(5185,1114,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(5186,1114,'N_relative_mass',5190,5163,'mean',NULL,NULL,NULL,NULL,NULL),(5187,1114,'C_relative_mass',5189,5162,'mean',NULL,NULL,NULL,NULL,NULL),(5188,1114,'P_relative_mass',5191,5164,'mean',NULL,NULL,NULL,NULL,NULL),(5189,1114,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5190,1114,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5191,1114,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5192,1115,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5193,1115,'mass_relative_mass',5192,5165,'mean','se',6,1.11,0.017,NULL),(5194,1115,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(5195,1115,'N_relative_mass',5199,5172,'mean',NULL,NULL,NULL,NULL,NULL),(5196,1115,'C_relative_mass',5198,5171,'mean',NULL,NULL,NULL,NULL,NULL),(5197,1115,'P_relative_mass',5200,5173,'mean',NULL,NULL,NULL,NULL,NULL),(5198,1115,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5199,1115,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5200,1115,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5201,1116,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5202,1116,'mass_relative_mass',5201,5147,'mean','se',6,1.02,0.033,NULL),(5203,1116,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(5204,1116,'N_relative_mass',5208,5154,'mean',NULL,NULL,NULL,NULL,NULL),(5205,1116,'C_relative_mass',5207,5153,'mean',NULL,NULL,NULL,NULL,NULL),(5206,1116,'P_relative_mass',5209,5155,'mean',NULL,NULL,NULL,NULL,NULL),(5207,1116,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5208,1116,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5209,1116,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5210,1117,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5211,1117,'mass_relative_mass',5210,5156,'mean','se',6,0.9470000000000001,0.025,NULL),(5212,1117,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(5213,1117,'N_relative_mass',5217,5163,'mean',NULL,NULL,NULL,NULL,NULL),(5214,1117,'C_relative_mass',5216,5162,'mean',NULL,NULL,NULL,NULL,NULL),(5215,1117,'P_relative_mass',5218,5164,'mean',NULL,NULL,NULL,NULL,NULL),(5216,1117,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5217,1117,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5218,1117,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5219,1118,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5220,1118,'mass_relative_mass',5219,5165,'mean','se',6,1.08,0.036000000000000004,NULL),(5221,1118,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(5222,1118,'N_relative_mass',5226,5172,'mean',NULL,NULL,NULL,NULL,NULL),(5223,1118,'C_relative_mass',5225,5171,'mean',NULL,NULL,NULL,NULL,NULL),(5224,1118,'P_relative_mass',5227,5173,'mean',NULL,NULL,NULL,NULL,NULL),(5225,1118,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5226,1118,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5227,1118,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5228,1119,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5229,1119,'mass_relative_mass',5228,5147,'mean','se',6,1.04,0.038,NULL),(5230,1119,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(5231,1119,'N_relative_mass',5235,5154,'mean',NULL,NULL,NULL,NULL,NULL),(5232,1119,'C_relative_mass',5234,5153,'mean',NULL,NULL,NULL,NULL,NULL),(5233,1119,'P_relative_mass',5236,5155,'mean',NULL,NULL,NULL,NULL,NULL),(5234,1119,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5235,1119,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5236,1119,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5237,1120,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5238,1120,'mass_relative_mass',5237,5156,'mean','se',6,0.943,0.025,NULL),(5239,1120,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(5240,1120,'N_relative_mass',5244,5163,'mean',NULL,NULL,NULL,NULL,NULL),(5241,1120,'C_relative_mass',5243,5162,'mean',NULL,NULL,NULL,NULL,NULL),(5242,1120,'P_relative_mass',5245,5164,'mean',NULL,NULL,NULL,NULL,NULL),(5243,1120,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5244,1120,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5245,1120,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5246,1121,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5247,1121,'mass_relative_mass',5246,5165,'mean','se',6,0.971,0.013000000000000001,NULL),(5248,1121,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(5249,1121,'N_relative_mass',5253,5172,'mean',NULL,NULL,NULL,NULL,NULL),(5250,1121,'C_relative_mass',5252,5171,'mean',NULL,NULL,NULL,NULL,NULL),(5251,1121,'P_relative_mass',5254,5173,'mean',NULL,NULL,NULL,NULL,NULL),(5252,1121,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5253,1121,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5254,1121,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5255,1122,'water_table_depth',NULL,NULL,'mean','se',NULL,-10,2.5,NULL),(5256,1123,'water_table_depth',NULL,NULL,'mean','se',NULL,9,2,NULL),(5257,1124,'water_table_depth',NULL,NULL,'mean','se',NULL,18,3,NULL),(5258,1133,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5259,1133,'mass_relative_mass',5258,5258,'mean','se',8,1,0,NULL),(5260,1133,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5261,1133,'N_relative_mass',5267,5258,'mean','se',10,0.009,0.0002,NULL),(5262,1133,'C_relative_mass',5266,5258,'mean',NULL,NULL,NULL,NULL,NULL),(5263,1133,'P_relative_mass',5268,5258,'mean','se',10,0.00033,0.00001,NULL),(5264,1133,'K_relative_mass',5269,5258,'mean','se',10,0.0011,0,NULL),(5265,1133,'N_relative_mass',5267,5267,'mean','se',8,1,0,NULL),(5266,1133,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5267,1133,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5268,1133,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5269,1133,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5270,1134,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5271,1134,'mass_relative_mass',5270,5270,'mean','se',8,1,0,NULL),(5272,1134,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5273,1134,'N_relative_mass',5279,5270,'mean','se',10,0.009,0.0002,NULL),(5274,1134,'C_relative_mass',5278,5270,'mean',NULL,NULL,NULL,NULL,NULL),(5275,1134,'P_relative_mass',5280,5270,'mean','se',10,0.00033,0.00001,NULL),(5276,1134,'K_relative_mass',5281,5270,'mean','se',10,0.0011,0,NULL),(5277,1134,'N_relative_mass',5279,5279,'mean','se',8,1,0,NULL),(5278,1134,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5279,1134,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5280,1134,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5281,1134,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5282,1135,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5283,1135,'mass_relative_mass',5282,5282,'mean','se',8,1,0,NULL),(5284,1135,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5285,1135,'N_relative_mass',5291,5282,'mean','se',10,0.009,0.0002,NULL),(5286,1135,'C_relative_mass',5290,5282,'mean',NULL,NULL,NULL,NULL,NULL),(5287,1135,'P_relative_mass',5292,5282,'mean','se',10,0.00033,0.00001,NULL),(5288,1135,'K_relative_mass',5293,5282,'mean','se',10,0.0011,0,NULL),(5289,1135,'N_relative_mass',5291,5291,'mean','se',8,1,0,NULL),(5290,1135,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5291,1135,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5292,1135,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5293,1135,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5294,1136,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5295,1136,'mass_relative_mass',5294,5294,'mean','se',8,1,0,NULL),(5296,1136,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5297,1136,'N_relative_mass',5303,5294,'mean','se',10,0.009,0.0002,NULL),(5298,1136,'C_relative_mass',5302,5294,'mean',NULL,NULL,NULL,NULL,NULL),(5299,1136,'P_relative_mass',5304,5294,'mean','se',10,0.00033,0.00001,NULL),(5300,1136,'K_relative_mass',5305,5294,'mean','se',10,0.0011,0,NULL),(5301,1136,'N_relative_mass',5303,5303,'mean','se',8,1,0,NULL),(5302,1136,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5303,1136,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5304,1136,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5305,1136,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5306,1137,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5307,1137,'mass_relative_mass',5306,5306,'mean','se',8,1,0,NULL),(5308,1137,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5309,1137,'N_relative_mass',5315,5306,'mean','se',10,0.0072,0.0001,NULL),(5310,1137,'C_relative_mass',5314,5306,'mean',NULL,NULL,NULL,NULL,NULL),(5311,1137,'P_relative_mass',5316,5306,'mean','se',10,0.00019,0.00001,NULL),(5312,1137,'K_relative_mass',5317,5306,'mean','se',10,0.0008,0.0001,NULL),(5313,1137,'N_relative_mass',5315,5315,'mean','se',8,1,0,NULL),(5314,1137,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5315,1137,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5316,1137,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5317,1137,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5318,1138,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5319,1138,'mass_relative_mass',5318,5318,'mean','se',8,1,0,NULL),(5320,1138,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5321,1138,'N_relative_mass',5327,5318,'mean','se',10,0.0072,0.0001,NULL),(5322,1138,'C_relative_mass',5326,5318,'mean',NULL,NULL,NULL,NULL,NULL),(5323,1138,'P_relative_mass',5328,5318,'mean','se',10,0.00019,0.00001,NULL),(5324,1138,'K_relative_mass',5329,5318,'mean','se',10,0.0008,0.0001,NULL),(5325,1138,'N_relative_mass',5327,5327,'mean','se',8,1,0,NULL),(5326,1138,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5327,1138,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5328,1138,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5329,1138,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5330,1139,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5331,1139,'mass_relative_mass',5330,5330,'mean','se',8,1,0,NULL),(5332,1139,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5333,1139,'N_relative_mass',5339,5330,'mean','se',10,0.0072,0.0001,NULL),(5334,1139,'C_relative_mass',5338,5330,'mean',NULL,NULL,NULL,NULL,NULL),(5335,1139,'P_relative_mass',5340,5330,'mean','se',10,0.00019,0.00001,NULL),(5336,1139,'K_relative_mass',5341,5330,'mean','se',10,0.0008,0.0001,NULL),(5337,1139,'N_relative_mass',5339,5339,'mean','se',8,1,0,NULL),(5338,1139,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5339,1139,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5340,1139,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5341,1139,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5342,1140,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5343,1140,'mass_relative_mass',5342,5342,'mean','se',8,1,0,NULL),(5344,1140,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5345,1140,'N_relative_mass',5351,5342,'mean','se',10,0.0072,0.0001,NULL),(5346,1140,'C_relative_mass',5350,5342,'mean',NULL,NULL,NULL,NULL,NULL),(5347,1140,'P_relative_mass',5352,5342,'mean','se',10,0.00019,0.00001,NULL),(5348,1140,'K_relative_mass',5353,5342,'mean','se',10,0.0008,0.0001,NULL),(5349,1140,'N_relative_mass',5351,5351,'mean','se',8,1,0,NULL),(5350,1140,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5351,1140,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5352,1140,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5353,1140,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5354,1141,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5355,1141,'mass_relative_mass',5354,5354,'mean','se',8,1,0,NULL),(5356,1141,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5357,1141,'N_relative_mass',5363,5354,'mean','se',10,0.0086,0.0003,NULL),(5358,1141,'C_relative_mass',5362,5354,'mean',NULL,NULL,NULL,NULL,NULL),(5359,1141,'P_relative_mass',5364,5354,'mean','se',10,0.00023,0.00001,NULL),(5360,1141,'K_relative_mass',5365,5354,'mean','se',10,0.0006,0,NULL),(5361,1141,'N_relative_mass',5363,5363,'mean','se',8,1,0,NULL),(5362,1141,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5363,1141,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5364,1141,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5365,1141,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5366,1142,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5367,1142,'mass_relative_mass',5366,5366,'mean','se',8,1,0,NULL),(5368,1142,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5369,1142,'N_relative_mass',5375,5366,'mean','se',10,0.0086,0.0003,NULL),(5370,1142,'C_relative_mass',5374,5366,'mean',NULL,NULL,NULL,NULL,NULL),(5371,1142,'P_relative_mass',5376,5366,'mean','se',10,0.00023,0.00001,NULL),(5372,1142,'K_relative_mass',5377,5366,'mean','se',10,0.0006,0,NULL),(5373,1142,'N_relative_mass',5375,5375,'mean','se',8,1,0,NULL),(5374,1142,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5375,1142,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5376,1142,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5377,1142,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5378,1143,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5379,1143,'mass_relative_mass',5378,5378,'mean','se',8,1,0,NULL),(5380,1143,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5381,1143,'N_relative_mass',5387,5378,'mean','se',10,0.0086,0.0003,NULL),(5382,1143,'C_relative_mass',5386,5378,'mean',NULL,NULL,NULL,NULL,NULL),(5383,1143,'P_relative_mass',5388,5378,'mean','se',10,0.00023,0.00001,NULL),(5384,1143,'K_relative_mass',5389,5378,'mean','se',10,0.0006,0,NULL),(5385,1143,'N_relative_mass',5387,5387,'mean','se',8,1,0,NULL),(5386,1143,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5387,1143,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5388,1143,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5389,1143,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5390,1144,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5391,1144,'mass_relative_mass',5390,5390,'mean','se',8,1,0,NULL),(5392,1144,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5393,1144,'N_relative_mass',5399,5390,'mean','se',10,0.0086,0.0003,NULL),(5394,1144,'C_relative_mass',5398,5390,'mean',NULL,NULL,NULL,NULL,NULL),(5395,1144,'P_relative_mass',5400,5390,'mean','se',10,0.00023,0.00001,NULL),(5396,1144,'K_relative_mass',5401,5390,'mean','se',10,0.0006,0,NULL),(5397,1144,'N_relative_mass',5399,5399,'mean','se',8,1,0,NULL),(5398,1144,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5399,1144,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5400,1144,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5401,1144,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5402,1145,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5403,1145,'mass_relative_mass',5402,5402,'mean','se',8,1,0,NULL),(5404,1145,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5405,1145,'N_relative_mass',5411,5402,'mean','se',10,0.0066,0.0002,NULL),(5406,1145,'C_relative_mass',5410,5402,'mean',NULL,NULL,NULL,NULL,NULL),(5407,1145,'P_relative_mass',5412,5402,'mean','se',10,0.0002,0.00002,NULL),(5408,1145,'K_relative_mass',5413,5402,'mean','se',10,0.0017,0.0001,NULL),(5409,1145,'N_relative_mass',5411,5411,'mean','se',8,1,0,NULL),(5410,1145,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5411,1145,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5412,1145,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5413,1145,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5414,1146,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5415,1146,'mass_relative_mass',5414,5414,'mean','se',8,1,0,NULL),(5416,1146,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5417,1146,'N_relative_mass',5423,5414,'mean','se',10,0.0066,0.0002,NULL),(5418,1146,'C_relative_mass',5422,5414,'mean',NULL,NULL,NULL,NULL,NULL),(5419,1146,'P_relative_mass',5424,5414,'mean','se',10,0.0002,0.00002,NULL),(5420,1146,'K_relative_mass',5425,5414,'mean','se',10,0.0017,0.0001,NULL),(5421,1146,'N_relative_mass',5423,5423,'mean','se',8,1,0,NULL),(5422,1146,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5423,1146,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5424,1146,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5425,1146,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5426,1147,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5427,1147,'mass_relative_mass',5426,5426,'mean','se',8,1,0,NULL),(5428,1147,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5429,1147,'N_relative_mass',5435,5426,'mean','se',10,0.0066,0.0002,NULL),(5430,1147,'C_relative_mass',5434,5426,'mean',NULL,NULL,NULL,NULL,NULL),(5431,1147,'P_relative_mass',5436,5426,'mean','se',10,0.0002,0.00002,NULL),(5432,1147,'K_relative_mass',5437,5426,'mean','se',10,0.0017,0.0001,NULL),(5433,1147,'N_relative_mass',5435,5435,'mean','se',8,1,0,NULL),(5434,1147,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5435,1147,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5436,1147,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5437,1147,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5438,1148,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5439,1148,'mass_relative_mass',5438,5438,'mean','se',8,1,0,NULL),(5440,1148,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5441,1148,'N_relative_mass',5447,5438,'mean','se',10,0.0066,0.0002,NULL),(5442,1148,'C_relative_mass',5446,5438,'mean',NULL,NULL,NULL,NULL,NULL),(5443,1148,'P_relative_mass',5448,5438,'mean','se',10,0.0002,0.00002,NULL),(5444,1148,'K_relative_mass',5449,5438,'mean','se',10,0.0017,0.0001,NULL),(5445,1148,'N_relative_mass',5447,5447,'mean','se',8,1,0,NULL),(5446,1148,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5447,1148,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5448,1148,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5449,1148,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5450,1149,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5451,1149,'mass_relative_mass',5450,5450,'mean','se',9,1,0,NULL),(5452,1149,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5453,1149,'N_relative_mass',5459,5450,'mean','se',10,0.0062,0.0001,NULL),(5454,1149,'C_relative_mass',5458,5450,'mean',NULL,NULL,NULL,NULL,NULL),(5455,1149,'P_relative_mass',5460,5450,'mean','se',10,0.00033,0.00001,NULL),(5456,1149,'K_relative_mass',5461,5450,'mean','se',10,0.0029,0.0003,NULL),(5457,1149,'N_relative_mass',5459,5459,'mean','se',9,1,0,NULL),(5458,1149,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5459,1149,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5460,1149,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5461,1149,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5462,1150,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5463,1150,'mass_relative_mass',5462,5462,'mean','se',9,1,0,NULL),(5464,1150,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5465,1150,'N_relative_mass',5471,5462,'mean','se',10,0.0062,0.0001,NULL),(5466,1150,'C_relative_mass',5470,5462,'mean',NULL,NULL,NULL,NULL,NULL),(5467,1150,'P_relative_mass',5472,5462,'mean','se',10,0.00033,0.00001,NULL),(5468,1150,'K_relative_mass',5473,5462,'mean','se',10,0.0029,0.0003,NULL),(5469,1150,'N_relative_mass',5471,5471,'mean','se',9,1,0,NULL),(5470,1150,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5471,1150,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5472,1150,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5473,1150,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5474,1151,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5475,1151,'mass_relative_mass',5474,5474,'mean','se',9,1,0,NULL),(5476,1151,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5477,1151,'N_relative_mass',5483,5474,'mean','se',10,0.0062,0.0001,NULL),(5478,1151,'C_relative_mass',5482,5474,'mean',NULL,NULL,NULL,NULL,NULL),(5479,1151,'P_relative_mass',5484,5474,'mean','se',10,0.00033,0.00001,NULL),(5480,1151,'K_relative_mass',5485,5474,'mean','se',10,0.0029,0.0003,NULL),(5481,1151,'N_relative_mass',5483,5483,'mean','se',9,1,0,NULL),(5482,1151,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5483,1151,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5484,1151,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5485,1151,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5486,1152,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5487,1152,'mass_relative_mass',5486,5486,'mean','se',9,1,0,NULL),(5488,1152,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5489,1152,'N_relative_mass',5495,5486,'mean','se',10,0.0062,0.0001,NULL),(5490,1152,'C_relative_mass',5494,5486,'mean',NULL,NULL,NULL,NULL,NULL),(5491,1152,'P_relative_mass',5496,5486,'mean','se',10,0.00033,0.00001,NULL),(5492,1152,'K_relative_mass',5497,5486,'mean','se',10,0.0029,0.0003,NULL),(5493,1152,'N_relative_mass',5495,5495,'mean','se',9,1,0,NULL),(5494,1152,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5495,1152,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5496,1152,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5497,1152,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5498,1153,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5499,1153,'mass_relative_mass',5498,5498,'mean','se',9,1,0,NULL),(5500,1153,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5501,1153,'N_relative_mass',5507,5498,'mean','se',10,0.004,0.0001,NULL),(5502,1153,'C_relative_mass',5506,5498,'mean',NULL,NULL,NULL,NULL,NULL),(5503,1153,'P_relative_mass',5508,5498,'mean','se',10,0.00015,0.00001,NULL),(5504,1153,'K_relative_mass',5509,5498,'mean','se',10,0.002,0.0002,NULL),(5505,1153,'N_relative_mass',5507,5507,'mean','se',9,1,0,NULL),(5506,1153,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5507,1153,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5508,1153,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5509,1153,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5510,1154,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5511,1154,'mass_relative_mass',5510,5510,'mean','se',9,1,0,NULL),(5512,1154,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5513,1154,'N_relative_mass',5519,5510,'mean','se',10,0.004,0.0001,NULL),(5514,1154,'C_relative_mass',5518,5510,'mean',NULL,NULL,NULL,NULL,NULL),(5515,1154,'P_relative_mass',5520,5510,'mean','se',10,0.00015,0.00001,NULL),(5516,1154,'K_relative_mass',5521,5510,'mean','se',10,0.002,0.0002,NULL),(5517,1154,'N_relative_mass',5519,5519,'mean','se',9,1,0,NULL),(5518,1154,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5519,1154,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5520,1154,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5521,1154,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5522,1155,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5523,1155,'mass_relative_mass',5522,5522,'mean','se',9,1,0,NULL),(5524,1155,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5525,1155,'N_relative_mass',5531,5522,'mean','se',10,0.004,0.0001,NULL),(5526,1155,'C_relative_mass',5530,5522,'mean',NULL,NULL,NULL,NULL,NULL),(5527,1155,'P_relative_mass',5532,5522,'mean','se',10,0.00015,0.00001,NULL),(5528,1155,'K_relative_mass',5533,5522,'mean','se',10,0.002,0.0002,NULL),(5529,1155,'N_relative_mass',5531,5531,'mean','se',9,1,0,NULL),(5530,1155,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5531,1155,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5532,1155,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5533,1155,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5534,1156,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5535,1156,'mass_relative_mass',5534,5534,'mean','se',9,1,0,NULL),(5536,1156,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5537,1156,'N_relative_mass',5543,5534,'mean','se',10,0.004,0.0001,NULL),(5538,1156,'C_relative_mass',5542,5534,'mean',NULL,NULL,NULL,NULL,NULL),(5539,1156,'P_relative_mass',5544,5534,'mean','se',10,0.00015,0.00001,NULL),(5540,1156,'K_relative_mass',5545,5534,'mean','se',10,0.002,0.0002,NULL),(5541,1156,'N_relative_mass',5543,5543,'mean','se',9,1,0,NULL),(5542,1156,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5543,1156,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5544,1156,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5545,1156,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5546,1157,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5547,1157,'mass_relative_mass',5546,5546,'mean','se',9,1,0,NULL),(5548,1157,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5549,1157,'N_relative_mass',5555,5546,'mean','se',10,0.0062,0.0002,NULL),(5550,1157,'C_relative_mass',5554,5546,'mean',NULL,NULL,NULL,NULL,NULL),(5551,1157,'P_relative_mass',5556,5546,'mean','se',10,0.00027,0.00002,NULL),(5552,1157,'K_relative_mass',5557,5546,'mean','se',10,0.0022,0.0004,NULL),(5553,1157,'N_relative_mass',5555,5555,'mean','se',9,1,0,NULL),(5554,1157,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5555,1157,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5556,1157,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5557,1157,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5558,1158,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5559,1158,'mass_relative_mass',5558,5558,'mean','se',9,1,0,NULL),(5560,1158,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5561,1158,'N_relative_mass',5567,5558,'mean','se',10,0.0062,0.0002,NULL),(5562,1158,'C_relative_mass',5566,5558,'mean',NULL,NULL,NULL,NULL,NULL),(5563,1158,'P_relative_mass',5568,5558,'mean','se',10,0.00027,0.00002,NULL),(5564,1158,'K_relative_mass',5569,5558,'mean','se',10,0.0022,0.0004,NULL),(5565,1158,'N_relative_mass',5567,5567,'mean','se',9,1,0,NULL),(5566,1158,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5567,1158,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5568,1158,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5569,1158,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5570,1159,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5571,1159,'mass_relative_mass',5570,5570,'mean','se',9,1,0,NULL),(5572,1159,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5573,1159,'N_relative_mass',5579,5570,'mean','se',10,0.0062,0.0002,NULL),(5574,1159,'C_relative_mass',5578,5570,'mean',NULL,NULL,NULL,NULL,NULL),(5575,1159,'P_relative_mass',5580,5570,'mean','se',10,0.00027,0.00002,NULL),(5576,1159,'K_relative_mass',5581,5570,'mean','se',10,0.0022,0.0004,NULL),(5577,1159,'N_relative_mass',5579,5579,'mean','se',9,1,0,NULL),(5578,1159,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5579,1159,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5580,1159,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5581,1159,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5582,1160,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5583,1160,'mass_relative_mass',5582,5582,'mean','se',9,1,0,NULL),(5584,1160,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5585,1160,'N_relative_mass',5591,5582,'mean','se',10,0.0062,0.0002,NULL),(5586,1160,'C_relative_mass',5590,5582,'mean',NULL,NULL,NULL,NULL,NULL),(5587,1160,'P_relative_mass',5592,5582,'mean','se',10,0.00027,0.00002,NULL),(5588,1160,'K_relative_mass',5593,5582,'mean','se',10,0.0022,0.0004,NULL),(5589,1160,'N_relative_mass',5591,5591,'mean','se',9,1,0,NULL),(5590,1160,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5591,1160,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5592,1160,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5593,1160,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5594,1161,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5595,1161,'mass_relative_mass',5594,5594,'mean','se',9,1,0,NULL),(5596,1161,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5597,1161,'N_relative_mass',5603,5594,'mean','se',10,0.0035,0.0001,NULL),(5598,1161,'C_relative_mass',5602,5594,'mean',NULL,NULL,NULL,NULL,NULL),(5599,1161,'P_relative_mass',5604,5594,'mean','se',10,0.00013000000000000002,0.00001,NULL),(5600,1161,'K_relative_mass',5605,5594,'mean','se',10,0.0032,0.0004,NULL),(5601,1161,'N_relative_mass',5603,5603,'mean','se',9,1,0,NULL),(5602,1161,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5603,1161,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5604,1161,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5605,1161,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5606,1162,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5607,1162,'mass_relative_mass',5606,5606,'mean','se',9,1,0,NULL),(5608,1162,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5609,1162,'N_relative_mass',5615,5606,'mean','se',10,0.0035,0.0001,NULL),(5610,1162,'C_relative_mass',5614,5606,'mean',NULL,NULL,NULL,NULL,NULL),(5611,1162,'P_relative_mass',5616,5606,'mean','se',10,0.00013000000000000002,0.00001,NULL),(5612,1162,'K_relative_mass',5617,5606,'mean','se',10,0.0032,0.0004,NULL),(5613,1162,'N_relative_mass',5615,5615,'mean','se',9,1,0,NULL),(5614,1162,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5615,1162,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5616,1162,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5617,1162,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5618,1163,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5619,1163,'mass_relative_mass',5618,5618,'mean','se',9,1,0,NULL),(5620,1163,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5621,1163,'N_relative_mass',5627,5618,'mean','se',10,0.0035,0.0001,NULL),(5622,1163,'C_relative_mass',5626,5618,'mean',NULL,NULL,NULL,NULL,NULL),(5623,1163,'P_relative_mass',5628,5618,'mean','se',10,0.00013000000000000002,0.00001,NULL),(5624,1163,'K_relative_mass',5629,5618,'mean','se',10,0.0032,0.0004,NULL),(5625,1163,'N_relative_mass',5627,5627,'mean','se',9,1,0,NULL),(5626,1163,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5627,1163,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5628,1163,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5629,1163,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5630,1164,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5631,1164,'mass_relative_mass',5630,5630,'mean','se',9,1,0,NULL),(5632,1164,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5633,1164,'N_relative_mass',5639,5630,'mean','se',10,0.0035,0.0001,NULL),(5634,1164,'C_relative_mass',5638,5630,'mean',NULL,NULL,NULL,NULL,NULL),(5635,1164,'P_relative_mass',5640,5630,'mean','se',10,0.00013000000000000002,0.00001,NULL),(5636,1164,'K_relative_mass',5641,5630,'mean','se',10,0.0032,0.0004,NULL),(5637,1164,'N_relative_mass',5639,5639,'mean','se',9,1,0,NULL),(5638,1164,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5639,1164,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5640,1164,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5641,1164,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5642,1165,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5643,1165,'mass_relative_mass',5642,5258,'mean','se',8,0.7737288135593221,0.00381355932203391,NULL),(5644,1165,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5645,1165,'N_relative_mass',5651,5642,'mean',NULL,NULL,NULL,NULL,NULL),(5646,1165,'C_relative_mass',5650,5642,'mean',NULL,NULL,NULL,NULL,NULL),(5647,1165,'P_relative_mass',5652,5642,'mean',NULL,NULL,NULL,NULL,NULL),(5648,1165,'K_relative_mass',5653,5642,'mean',NULL,NULL,NULL,NULL,NULL),(5649,1165,'N_relative_mass',5651,5267,'mean',NULL,NULL,NULL,NULL,NULL),(5650,1165,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5651,1165,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5652,1165,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5653,1165,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5654,1166,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5655,1166,'mass_relative_mass',5654,5258,'mean','se',8,0.6542372881355932,0.010169491525423808,NULL),(5656,1166,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5657,1166,'N_relative_mass',5663,5654,'mean',NULL,NULL,NULL,NULL,NULL),(5658,1166,'C_relative_mass',5662,5654,'mean',NULL,NULL,NULL,NULL,NULL),(5659,1166,'P_relative_mass',5664,5654,'mean',NULL,NULL,NULL,NULL,NULL),(5660,1166,'K_relative_mass',5665,5654,'mean',NULL,NULL,NULL,NULL,NULL),(5661,1166,'N_relative_mass',5663,5267,'mean',NULL,NULL,NULL,NULL,NULL),(5662,1166,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5663,1166,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5664,1166,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5665,1166,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5666,1167,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5667,1167,'mass_relative_mass',5666,5258,'mean','se',8,0.6046610169491526,0.01144067796610166,NULL),(5668,1167,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5669,1167,'N_relative_mass',5675,5666,'mean',NULL,NULL,NULL,NULL,NULL),(5670,1167,'C_relative_mass',5674,5666,'mean',NULL,NULL,NULL,NULL,NULL),(5671,1167,'P_relative_mass',5676,5666,'mean',NULL,NULL,NULL,NULL,NULL),(5672,1167,'K_relative_mass',5677,5666,'mean',NULL,NULL,NULL,NULL,NULL),(5673,1167,'N_relative_mass',5675,5267,'mean',NULL,NULL,NULL,NULL,NULL),(5674,1167,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5675,1167,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5676,1167,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5677,1167,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5678,1168,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5679,1168,'mass_relative_mass',5678,5270,'mean','se',8,0.7533898305084746,0.005084745762711833,NULL),(5680,1168,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5681,1168,'N_relative_mass',5687,5678,'mean',NULL,NULL,NULL,NULL,NULL),(5682,1168,'C_relative_mass',5686,5678,'mean',NULL,NULL,NULL,NULL,NULL),(5683,1168,'P_relative_mass',5688,5678,'mean',NULL,NULL,NULL,NULL,NULL),(5684,1168,'K_relative_mass',5689,5678,'mean',NULL,NULL,NULL,NULL,NULL),(5685,1168,'N_relative_mass',5687,5279,'mean',NULL,NULL,NULL,NULL,NULL),(5686,1168,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5687,1168,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5688,1168,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5689,1168,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5690,1169,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5691,1169,'mass_relative_mass',5690,5270,'mean','se',8,0.6567796610169492,0.008898305084745744,NULL),(5692,1169,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5693,1169,'N_relative_mass',5699,5690,'mean',NULL,NULL,NULL,NULL,NULL),(5694,1169,'C_relative_mass',5698,5690,'mean',NULL,NULL,NULL,NULL,NULL),(5695,1169,'P_relative_mass',5700,5690,'mean',NULL,NULL,NULL,NULL,NULL),(5696,1169,'K_relative_mass',5701,5690,'mean',NULL,NULL,NULL,NULL,NULL),(5697,1169,'N_relative_mass',5699,5279,'mean',NULL,NULL,NULL,NULL,NULL),(5698,1169,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5699,1169,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5700,1169,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5701,1169,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5702,1170,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5703,1170,'mass_relative_mass',5702,5270,'mean','se',8,0.5995762711864407,0.010169491525423808,NULL),(5704,1170,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5705,1170,'N_relative_mass',5711,5702,'mean',NULL,NULL,NULL,NULL,NULL),(5706,1170,'C_relative_mass',5710,5702,'mean',NULL,NULL,NULL,NULL,NULL),(5707,1170,'P_relative_mass',5712,5702,'mean',NULL,NULL,NULL,NULL,NULL),(5708,1170,'K_relative_mass',5713,5702,'mean',NULL,NULL,NULL,NULL,NULL),(5709,1170,'N_relative_mass',5711,5279,'mean',NULL,NULL,NULL,NULL,NULL),(5710,1170,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5711,1170,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5712,1170,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5713,1170,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5714,1171,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5715,1171,'mass_relative_mass',5714,5282,'mean','se',8,0.7114406779661018,0.026694915254237374,NULL),(5716,1171,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5717,1171,'N_relative_mass',5723,5714,'mean',NULL,NULL,NULL,NULL,NULL),(5718,1171,'C_relative_mass',5722,5714,'mean',NULL,NULL,NULL,NULL,NULL),(5719,1171,'P_relative_mass',5724,5714,'mean',NULL,NULL,NULL,NULL,NULL),(5720,1171,'K_relative_mass',5725,5714,'mean',NULL,NULL,NULL,NULL,NULL),(5721,1171,'N_relative_mass',5723,5291,'mean',NULL,NULL,NULL,NULL,NULL),(5722,1171,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5723,1171,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5724,1171,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5725,1171,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5726,1172,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5727,1172,'mass_relative_mass',5726,5282,'mean','se',8,0.6364406779661017,0.010169491525423666,NULL),(5728,1172,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5729,1172,'N_relative_mass',5735,5726,'mean',NULL,NULL,NULL,NULL,NULL),(5730,1172,'C_relative_mass',5734,5726,'mean',NULL,NULL,NULL,NULL,NULL),(5731,1172,'P_relative_mass',5736,5726,'mean',NULL,NULL,NULL,NULL,NULL),(5732,1172,'K_relative_mass',5737,5726,'mean',NULL,NULL,NULL,NULL,NULL),(5733,1172,'N_relative_mass',5735,5291,'mean',NULL,NULL,NULL,NULL,NULL),(5734,1172,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5735,1172,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5736,1172,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5737,1172,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5738,1173,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5739,1173,'mass_relative_mass',5738,5282,'mean','se',8,0.5588983050847457,0.01525423728813564,NULL),(5740,1173,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5741,1173,'N_relative_mass',5747,5738,'mean',NULL,NULL,NULL,NULL,NULL),(5742,1173,'C_relative_mass',5746,5738,'mean',NULL,NULL,NULL,NULL,NULL),(5743,1173,'P_relative_mass',5748,5738,'mean',NULL,NULL,NULL,NULL,NULL),(5744,1173,'K_relative_mass',5749,5738,'mean',NULL,NULL,NULL,NULL,NULL),(5745,1173,'N_relative_mass',5747,5291,'mean',NULL,NULL,NULL,NULL,NULL),(5746,1173,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5747,1173,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5748,1173,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5749,1173,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5750,1174,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5751,1174,'mass_relative_mass',5750,5294,'mean','se',8,0.6783898305084746,0.02288135593220332,NULL),(5752,1174,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5753,1174,'N_relative_mass',5759,5750,'mean',NULL,NULL,NULL,NULL,NULL),(5754,1174,'C_relative_mass',5758,5750,'mean',NULL,NULL,NULL,NULL,NULL),(5755,1174,'P_relative_mass',5760,5750,'mean',NULL,NULL,NULL,NULL,NULL),(5756,1174,'K_relative_mass',5761,5750,'mean',NULL,NULL,NULL,NULL,NULL),(5757,1174,'N_relative_mass',5759,5303,'mean',NULL,NULL,NULL,NULL,NULL),(5758,1174,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5759,1174,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5760,1174,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5761,1174,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5762,1175,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5763,1175,'mass_relative_mass',5762,5294,'mean','se',8,0.5754237288135593,0.03177966101694921,NULL),(5764,1175,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5765,1175,'N_relative_mass',5771,5762,'mean',NULL,NULL,NULL,NULL,NULL),(5766,1175,'C_relative_mass',5770,5762,'mean',NULL,NULL,NULL,NULL,NULL),(5767,1175,'P_relative_mass',5772,5762,'mean',NULL,NULL,NULL,NULL,NULL),(5768,1175,'K_relative_mass',5773,5762,'mean',NULL,NULL,NULL,NULL,NULL),(5769,1175,'N_relative_mass',5771,5303,'mean',NULL,NULL,NULL,NULL,NULL),(5770,1175,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5771,1175,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5772,1175,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5773,1175,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5774,1176,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5775,1176,'mass_relative_mass',5774,5294,'mean','se',8,0.5055084745762712,0.03686440677966097,NULL),(5776,1176,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5777,1176,'N_relative_mass',5783,5774,'mean',NULL,NULL,NULL,NULL,NULL),(5778,1176,'C_relative_mass',5782,5774,'mean',NULL,NULL,NULL,NULL,NULL),(5779,1176,'P_relative_mass',5784,5774,'mean',NULL,NULL,NULL,NULL,NULL),(5780,1176,'K_relative_mass',5785,5774,'mean',NULL,NULL,NULL,NULL,NULL),(5781,1176,'N_relative_mass',5783,5303,'mean',NULL,NULL,NULL,NULL,NULL),(5782,1176,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5783,1176,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5784,1176,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5785,1176,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5786,1177,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5787,1177,'mass_relative_mass',5786,5306,'mean','se',8,0.6982387475538161,0.012915851272015715,NULL),(5788,1177,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5789,1177,'N_relative_mass',5795,5786,'mean',NULL,NULL,NULL,NULL,NULL),(5790,1177,'C_relative_mass',5794,5786,'mean',NULL,NULL,NULL,NULL,NULL),(5791,1177,'P_relative_mass',5796,5786,'mean',NULL,NULL,NULL,NULL,NULL),(5792,1177,'K_relative_mass',5797,5786,'mean',NULL,NULL,NULL,NULL,NULL),(5793,1177,'N_relative_mass',5795,5315,'mean',NULL,NULL,NULL,NULL,NULL),(5794,1177,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5795,1177,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5796,1177,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5797,1177,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5798,1178,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5799,1178,'mass_relative_mass',5798,5306,'mean','se',8,0.6230919765166341,0.019960861056751468,NULL),(5800,1178,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5801,1178,'N_relative_mass',5807,5798,'mean',NULL,NULL,NULL,NULL,NULL),(5802,1178,'C_relative_mass',5806,5798,'mean',NULL,NULL,NULL,NULL,NULL),(5803,1178,'P_relative_mass',5808,5798,'mean',NULL,NULL,NULL,NULL,NULL),(5804,1178,'K_relative_mass',5809,5798,'mean',NULL,NULL,NULL,NULL,NULL),(5805,1178,'N_relative_mass',5807,5315,'mean',NULL,NULL,NULL,NULL,NULL),(5806,1178,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5807,1178,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5808,1178,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5809,1178,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5810,1179,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5811,1179,'mass_relative_mass',5810,5306,'mean','se',8,0.5350293542074365,0.018786692759295464,NULL),(5812,1179,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5813,1179,'N_relative_mass',5819,5810,'mean',NULL,NULL,NULL,NULL,NULL),(5814,1179,'C_relative_mass',5818,5810,'mean',NULL,NULL,NULL,NULL,NULL),(5815,1179,'P_relative_mass',5820,5810,'mean',NULL,NULL,NULL,NULL,NULL),(5816,1179,'K_relative_mass',5821,5810,'mean',NULL,NULL,NULL,NULL,NULL),(5817,1179,'N_relative_mass',5819,5315,'mean',NULL,NULL,NULL,NULL,NULL),(5818,1179,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5819,1179,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5820,1179,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5821,1179,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5822,1180,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5823,1180,'mass_relative_mass',5822,5318,'mean','se',8,0.6935420743639922,0.0176125244618396,NULL),(5824,1180,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5825,1180,'N_relative_mass',5831,5822,'mean',NULL,NULL,NULL,NULL,NULL),(5826,1180,'C_relative_mass',5830,5822,'mean',NULL,NULL,NULL,NULL,NULL),(5827,1180,'P_relative_mass',5832,5822,'mean',NULL,NULL,NULL,NULL,NULL),(5828,1180,'K_relative_mass',5833,5822,'mean',NULL,NULL,NULL,NULL,NULL),(5829,1180,'N_relative_mass',5831,5327,'mean',NULL,NULL,NULL,NULL,NULL),(5830,1180,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5831,1180,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5832,1180,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5833,1180,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5834,1181,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5835,1181,'mass_relative_mass',5834,5318,'mean','se',8,0.6148727984344423,0.015264187866927657,NULL),(5836,1181,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5837,1181,'N_relative_mass',5843,5834,'mean',NULL,NULL,NULL,NULL,NULL),(5838,1181,'C_relative_mass',5842,5834,'mean',NULL,NULL,NULL,NULL,NULL),(5839,1181,'P_relative_mass',5844,5834,'mean',NULL,NULL,NULL,NULL,NULL),(5840,1181,'K_relative_mass',5845,5834,'mean',NULL,NULL,NULL,NULL,NULL),(5841,1181,'N_relative_mass',5843,5327,'mean',NULL,NULL,NULL,NULL,NULL),(5842,1181,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5843,1181,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5844,1181,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5845,1181,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5846,1182,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5847,1182,'mass_relative_mass',5846,5318,'mean','se',8,0.5197651663405088,0.018786692759295533,NULL),(5848,1182,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5849,1182,'N_relative_mass',5855,5846,'mean',NULL,NULL,NULL,NULL,NULL),(5850,1182,'C_relative_mass',5854,5846,'mean',NULL,NULL,NULL,NULL,NULL),(5851,1182,'P_relative_mass',5856,5846,'mean',NULL,NULL,NULL,NULL,NULL),(5852,1182,'K_relative_mass',5857,5846,'mean',NULL,NULL,NULL,NULL,NULL),(5853,1182,'N_relative_mass',5855,5327,'mean',NULL,NULL,NULL,NULL,NULL),(5854,1182,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5855,1182,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5856,1182,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5857,1182,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5858,1183,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5859,1183,'mass_relative_mass',5858,5330,'mean','se',8,0.6818003913894326,0.019960861056751468,NULL),(5860,1183,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5861,1183,'N_relative_mass',5867,5858,'mean',NULL,NULL,NULL,NULL,NULL),(5862,1183,'C_relative_mass',5866,5858,'mean',NULL,NULL,NULL,NULL,NULL),(5863,1183,'P_relative_mass',5868,5858,'mean',NULL,NULL,NULL,NULL,NULL),(5864,1183,'K_relative_mass',5869,5858,'mean',NULL,NULL,NULL,NULL,NULL),(5865,1183,'N_relative_mass',5867,5339,'mean',NULL,NULL,NULL,NULL,NULL),(5866,1183,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5867,1183,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5868,1183,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5869,1183,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5870,1184,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5871,1184,'mass_relative_mass',5870,5330,'mean','se',8,0.5397260273972603,0.03287671232876718,NULL),(5872,1184,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5873,1184,'N_relative_mass',5879,5870,'mean',NULL,NULL,NULL,NULL,NULL),(5874,1184,'C_relative_mass',5878,5870,'mean',NULL,NULL,NULL,NULL,NULL),(5875,1184,'P_relative_mass',5880,5870,'mean',NULL,NULL,NULL,NULL,NULL),(5876,1184,'K_relative_mass',5881,5870,'mean',NULL,NULL,NULL,NULL,NULL),(5877,1184,'N_relative_mass',5879,5339,'mean',NULL,NULL,NULL,NULL,NULL),(5878,1184,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5879,1184,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5880,1184,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5881,1184,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5882,1185,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5883,1185,'mass_relative_mass',5882,5330,'mean','se',8,0.4927592954990216,0.02230919765166341,NULL),(5884,1185,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5885,1185,'N_relative_mass',5891,5882,'mean',NULL,NULL,NULL,NULL,NULL),(5886,1185,'C_relative_mass',5890,5882,'mean',NULL,NULL,NULL,NULL,NULL),(5887,1185,'P_relative_mass',5892,5882,'mean',NULL,NULL,NULL,NULL,NULL),(5888,1185,'K_relative_mass',5893,5882,'mean',NULL,NULL,NULL,NULL,NULL),(5889,1185,'N_relative_mass',5891,5339,'mean',NULL,NULL,NULL,NULL,NULL),(5890,1185,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5891,1185,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5892,1185,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5893,1185,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5894,1186,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5895,1186,'mass_relative_mass',5894,5342,'mean','se',8,0.6571428571428573,0.019960861056751468,NULL),(5896,1186,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5897,1186,'N_relative_mass',5903,5894,'mean',NULL,NULL,NULL,NULL,NULL),(5898,1186,'C_relative_mass',5902,5894,'mean',NULL,NULL,NULL,NULL,NULL),(5899,1186,'P_relative_mass',5904,5894,'mean',NULL,NULL,NULL,NULL,NULL),(5900,1186,'K_relative_mass',5905,5894,'mean',NULL,NULL,NULL,NULL,NULL),(5901,1186,'N_relative_mass',5903,5351,'mean',NULL,NULL,NULL,NULL,NULL),(5902,1186,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5903,1186,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5904,1186,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5905,1186,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5906,1187,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5907,1187,'mass_relative_mass',5906,5342,'mean','se',8,0.49041095890410963,0.02583170254403136,NULL),(5908,1187,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5909,1187,'N_relative_mass',5915,5906,'mean',NULL,NULL,NULL,NULL,NULL),(5910,1187,'C_relative_mass',5914,5906,'mean',NULL,NULL,NULL,NULL,NULL),(5911,1187,'P_relative_mass',5916,5906,'mean',NULL,NULL,NULL,NULL,NULL),(5912,1187,'K_relative_mass',5917,5906,'mean',NULL,NULL,NULL,NULL,NULL),(5913,1187,'N_relative_mass',5915,5351,'mean',NULL,NULL,NULL,NULL,NULL),(5914,1187,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5915,1187,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5916,1187,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5917,1187,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5918,1188,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5919,1188,'mass_relative_mass',5918,5342,'mean','se',8,0.4622309197651664,0.037573385518591,NULL),(5920,1188,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5921,1188,'N_relative_mass',5927,5918,'mean',NULL,NULL,NULL,NULL,NULL),(5922,1188,'C_relative_mass',5926,5918,'mean',NULL,NULL,NULL,NULL,NULL),(5923,1188,'P_relative_mass',5928,5918,'mean',NULL,NULL,NULL,NULL,NULL),(5924,1188,'K_relative_mass',5929,5918,'mean',NULL,NULL,NULL,NULL,NULL),(5925,1188,'N_relative_mass',5927,5351,'mean',NULL,NULL,NULL,NULL,NULL),(5926,1188,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5927,1188,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5928,1188,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5929,1188,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5930,1189,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5931,1189,'mass_relative_mass',5930,5354,'mean','se',8,0.8356347438752785,0.006681514476614723,NULL),(5932,1189,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5933,1189,'N_relative_mass',5939,5930,'mean',NULL,NULL,NULL,NULL,NULL),(5934,1189,'C_relative_mass',5938,5930,'mean',NULL,NULL,NULL,NULL,NULL),(5935,1189,'P_relative_mass',5940,5930,'mean',NULL,NULL,NULL,NULL,NULL),(5936,1189,'K_relative_mass',5941,5930,'mean',NULL,NULL,NULL,NULL,NULL),(5937,1189,'N_relative_mass',5939,5363,'mean',NULL,NULL,NULL,NULL,NULL),(5938,1189,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5939,1189,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5940,1189,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5941,1189,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5942,1190,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5943,1190,'mass_relative_mass',5942,5354,'mean','se',8,0.7728285077951003,0.017371937639198337,NULL),(5944,1190,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5945,1190,'N_relative_mass',5951,5942,'mean',NULL,NULL,NULL,NULL,NULL),(5946,1190,'C_relative_mass',5950,5942,'mean',NULL,NULL,NULL,NULL,NULL),(5947,1190,'P_relative_mass',5952,5942,'mean',NULL,NULL,NULL,NULL,NULL),(5948,1190,'K_relative_mass',5953,5942,'mean',NULL,NULL,NULL,NULL,NULL),(5949,1190,'N_relative_mass',5951,5363,'mean',NULL,NULL,NULL,NULL,NULL),(5950,1190,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5951,1190,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5952,1190,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5953,1190,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5954,1191,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5955,1191,'mass_relative_mass',5954,5354,'mean','se',8,0.6939866369710469,0.021380846325166944,NULL),(5956,1191,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5957,1191,'N_relative_mass',5963,5954,'mean',NULL,NULL,NULL,NULL,NULL),(5958,1191,'C_relative_mass',5962,5954,'mean',NULL,NULL,NULL,NULL,NULL),(5959,1191,'P_relative_mass',5964,5954,'mean',NULL,NULL,NULL,NULL,NULL),(5960,1191,'K_relative_mass',5965,5954,'mean',NULL,NULL,NULL,NULL,NULL),(5961,1191,'N_relative_mass',5963,5363,'mean',NULL,NULL,NULL,NULL,NULL),(5962,1191,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5963,1191,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5964,1191,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5965,1191,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5966,1192,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5967,1192,'mass_relative_mass',5966,5366,'mean','se',8,0.7808463251670381,0.01469933184855222,NULL),(5968,1192,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5969,1192,'N_relative_mass',5975,5966,'mean',NULL,NULL,NULL,NULL,NULL),(5970,1192,'C_relative_mass',5974,5966,'mean',NULL,NULL,NULL,NULL,NULL),(5971,1192,'P_relative_mass',5976,5966,'mean',NULL,NULL,NULL,NULL,NULL),(5972,1192,'K_relative_mass',5977,5966,'mean',NULL,NULL,NULL,NULL,NULL),(5973,1192,'N_relative_mass',5975,5375,'mean',NULL,NULL,NULL,NULL,NULL),(5974,1192,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5975,1192,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5976,1192,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5977,1192,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5978,1193,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5979,1193,'mass_relative_mass',5978,5366,'mean','se',8,0.712694877505568,0.010690423162583472,NULL),(5980,1193,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5981,1193,'N_relative_mass',5987,5978,'mean',NULL,NULL,NULL,NULL,NULL),(5982,1193,'C_relative_mass',5986,5978,'mean',NULL,NULL,NULL,NULL,NULL),(5983,1193,'P_relative_mass',5988,5978,'mean',NULL,NULL,NULL,NULL,NULL),(5984,1193,'K_relative_mass',5989,5978,'mean',NULL,NULL,NULL,NULL,NULL),(5985,1193,'N_relative_mass',5987,5375,'mean',NULL,NULL,NULL,NULL,NULL),(5986,1193,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5987,1193,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5988,1193,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5989,1193,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5990,1194,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5991,1194,'mass_relative_mass',5990,5366,'mean','se',8,0.6832962138084633,0.013363028953229446,NULL),(5992,1194,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(5993,1194,'N_relative_mass',5999,5990,'mean',NULL,NULL,NULL,NULL,NULL),(5994,1194,'C_relative_mass',5998,5990,'mean',NULL,NULL,NULL,NULL,NULL),(5995,1194,'P_relative_mass',6000,5990,'mean',NULL,NULL,NULL,NULL,NULL),(5996,1194,'K_relative_mass',6001,5990,'mean',NULL,NULL,NULL,NULL,NULL),(5997,1194,'N_relative_mass',5999,5375,'mean',NULL,NULL,NULL,NULL,NULL),(5998,1194,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(5999,1194,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6000,1194,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6001,1194,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6002,1195,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6003,1195,'mass_relative_mass',6002,5378,'mean','se',8,0.7287305122494433,0.025389755011135832,NULL),(6004,1195,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6005,1195,'N_relative_mass',6011,6002,'mean',NULL,NULL,NULL,NULL,NULL),(6006,1195,'C_relative_mass',6010,6002,'mean',NULL,NULL,NULL,NULL,NULL),(6007,1195,'P_relative_mass',6012,6002,'mean',NULL,NULL,NULL,NULL,NULL),(6008,1195,'K_relative_mass',6013,6002,'mean',NULL,NULL,NULL,NULL,NULL),(6009,1195,'N_relative_mass',6011,5387,'mean',NULL,NULL,NULL,NULL,NULL),(6010,1195,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6011,1195,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6012,1195,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6013,1195,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6014,1196,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6015,1196,'mass_relative_mass',6014,5378,'mean','se',8,0.5964365256124722,0.036080178173719446,NULL),(6016,1196,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6017,1196,'N_relative_mass',6023,6014,'mean',NULL,NULL,NULL,NULL,NULL),(6018,1196,'C_relative_mass',6022,6014,'mean',NULL,NULL,NULL,NULL,NULL),(6019,1196,'P_relative_mass',6024,6014,'mean',NULL,NULL,NULL,NULL,NULL),(6020,1196,'K_relative_mass',6025,6014,'mean',NULL,NULL,NULL,NULL,NULL),(6021,1196,'N_relative_mass',6023,5387,'mean',NULL,NULL,NULL,NULL,NULL),(6022,1196,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6023,1196,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6024,1196,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6025,1196,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6026,1197,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6027,1197,'mass_relative_mass',6026,5378,'mean','se',8,0.5750556792873052,0.037416481069042364,NULL),(6028,1197,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6029,1197,'N_relative_mass',6035,6026,'mean',NULL,NULL,NULL,NULL,NULL),(6030,1197,'C_relative_mass',6034,6026,'mean',NULL,NULL,NULL,NULL,NULL),(6031,1197,'P_relative_mass',6036,6026,'mean',NULL,NULL,NULL,NULL,NULL),(6032,1197,'K_relative_mass',6037,6026,'mean',NULL,NULL,NULL,NULL,NULL),(6033,1197,'N_relative_mass',6035,5387,'mean',NULL,NULL,NULL,NULL,NULL),(6034,1197,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6035,1197,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6036,1197,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6037,1197,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6038,1198,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6039,1198,'mass_relative_mass',6038,5390,'mean','se',8,0.6939866369710469,0.04276169265033403,NULL),(6040,1198,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6041,1198,'N_relative_mass',6047,6038,'mean',NULL,NULL,NULL,NULL,NULL),(6042,1198,'C_relative_mass',6046,6038,'mean',NULL,NULL,NULL,NULL,NULL),(6043,1198,'P_relative_mass',6048,6038,'mean',NULL,NULL,NULL,NULL,NULL),(6044,1198,'K_relative_mass',6049,6038,'mean',NULL,NULL,NULL,NULL,NULL),(6045,1198,'N_relative_mass',6047,5399,'mean',NULL,NULL,NULL,NULL,NULL),(6046,1198,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6047,1198,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6048,1198,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6049,1198,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6050,1199,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6051,1199,'mass_relative_mass',6050,5390,'mean','se',8,0.6124721603563476,0.032071269487750555,NULL),(6052,1199,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6053,1199,'N_relative_mass',6059,6050,'mean',NULL,NULL,NULL,NULL,NULL),(6054,1199,'C_relative_mass',6058,6050,'mean',NULL,NULL,NULL,NULL,NULL),(6055,1199,'P_relative_mass',6060,6050,'mean',NULL,NULL,NULL,NULL,NULL),(6056,1199,'K_relative_mass',6061,6050,'mean',NULL,NULL,NULL,NULL,NULL),(6057,1199,'N_relative_mass',6059,5399,'mean',NULL,NULL,NULL,NULL,NULL),(6058,1199,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6059,1199,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6060,1199,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6061,1199,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6062,1200,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6063,1200,'mass_relative_mass',6062,5390,'mean','se',8,0.5483296213808464,0.02271714922049,NULL),(6064,1200,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6065,1200,'N_relative_mass',6071,6062,'mean',NULL,NULL,NULL,NULL,NULL),(6066,1200,'C_relative_mass',6070,6062,'mean',NULL,NULL,NULL,NULL,NULL),(6067,1200,'P_relative_mass',6072,6062,'mean',NULL,NULL,NULL,NULL,NULL),(6068,1200,'K_relative_mass',6073,6062,'mean',NULL,NULL,NULL,NULL,NULL),(6069,1200,'N_relative_mass',6071,5399,'mean',NULL,NULL,NULL,NULL,NULL),(6070,1200,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6071,1200,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6072,1200,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6073,1200,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6074,1201,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6075,1201,'mass_relative_mass',6074,5402,'mean','se',8,0.7858093126385809,0.023946784922394784,NULL),(6076,1201,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6077,1201,'N_relative_mass',6083,6074,'mean',NULL,NULL,NULL,NULL,NULL),(6078,1201,'C_relative_mass',6082,6074,'mean',NULL,NULL,NULL,NULL,NULL),(6079,1201,'P_relative_mass',6084,6074,'mean',NULL,NULL,NULL,NULL,NULL),(6080,1201,'K_relative_mass',6085,6074,'mean',NULL,NULL,NULL,NULL,NULL),(6081,1201,'N_relative_mass',6083,5411,'mean',NULL,NULL,NULL,NULL,NULL),(6082,1201,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6083,1201,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6084,1201,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6085,1201,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6086,1202,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6087,1202,'mass_relative_mass',6086,5402,'mean','se',8,0.6541019955654103,0.04656319290465632,NULL),(6088,1202,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6089,1202,'N_relative_mass',6095,6086,'mean',NULL,NULL,NULL,NULL,NULL),(6090,1202,'C_relative_mass',6094,6086,'mean',NULL,NULL,NULL,NULL,NULL),(6091,1202,'P_relative_mass',6096,6086,'mean',NULL,NULL,NULL,NULL,NULL),(6092,1202,'K_relative_mass',6097,6086,'mean',NULL,NULL,NULL,NULL,NULL),(6093,1202,'N_relative_mass',6095,5411,'mean',NULL,NULL,NULL,NULL,NULL),(6094,1202,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6095,1202,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6096,1202,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6097,1202,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6098,1203,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6099,1203,'mass_relative_mass',6098,5402,'mean','se',8,0.6620842572062086,0.034589800443458926,NULL),(6100,1203,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6101,1203,'N_relative_mass',6107,6098,'mean',NULL,NULL,NULL,NULL,NULL),(6102,1203,'C_relative_mass',6106,6098,'mean',NULL,NULL,NULL,NULL,NULL),(6103,1203,'P_relative_mass',6108,6098,'mean',NULL,NULL,NULL,NULL,NULL),(6104,1203,'K_relative_mass',6109,6098,'mean',NULL,NULL,NULL,NULL,NULL),(6105,1203,'N_relative_mass',6107,5411,'mean',NULL,NULL,NULL,NULL,NULL),(6106,1203,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6107,1203,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6108,1203,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6109,1203,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6110,1204,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6111,1204,'mass_relative_mass',6110,5414,'mean','se',8,0.7711751662971176,0.01596452328159657,NULL),(6112,1204,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6113,1204,'N_relative_mass',6119,6110,'mean',NULL,NULL,NULL,NULL,NULL),(6114,1204,'C_relative_mass',6118,6110,'mean',NULL,NULL,NULL,NULL,NULL),(6115,1204,'P_relative_mass',6120,6110,'mean',NULL,NULL,NULL,NULL,NULL),(6116,1204,'K_relative_mass',6121,6110,'mean',NULL,NULL,NULL,NULL,NULL),(6117,1204,'N_relative_mass',6119,5423,'mean',NULL,NULL,NULL,NULL,NULL),(6118,1204,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6119,1204,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6120,1204,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6121,1204,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6122,1205,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6123,1205,'mass_relative_mass',6122,5414,'mean','se',8,0.7232815964523283,0.010643015521064286,NULL),(6124,1205,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6125,1205,'N_relative_mass',6131,6122,'mean',NULL,NULL,NULL,NULL,NULL),(6126,1205,'C_relative_mass',6130,6122,'mean',NULL,NULL,NULL,NULL,NULL),(6127,1205,'P_relative_mass',6132,6122,'mean',NULL,NULL,NULL,NULL,NULL),(6128,1205,'K_relative_mass',6133,6122,'mean',NULL,NULL,NULL,NULL,NULL),(6129,1205,'N_relative_mass',6131,5423,'mean',NULL,NULL,NULL,NULL,NULL),(6130,1205,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6131,1205,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6132,1205,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6133,1205,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6134,1206,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6135,1206,'mass_relative_mass',6134,5414,'mean','se',8,0.6647450110864745,0.031929046563192856,NULL),(6136,1206,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6137,1206,'N_relative_mass',6143,6134,'mean',NULL,NULL,NULL,NULL,NULL),(6138,1206,'C_relative_mass',6142,6134,'mean',NULL,NULL,NULL,NULL,NULL),(6139,1206,'P_relative_mass',6144,6134,'mean',NULL,NULL,NULL,NULL,NULL),(6140,1206,'K_relative_mass',6145,6134,'mean',NULL,NULL,NULL,NULL,NULL),(6141,1206,'N_relative_mass',6143,5423,'mean',NULL,NULL,NULL,NULL,NULL),(6142,1206,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6143,1206,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6144,1206,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6145,1206,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6146,1207,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6147,1207,'mass_relative_mass',6146,5426,'mean','se',8,0.7858093126385809,0.023946784922394784,NULL),(6148,1207,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6149,1207,'N_relative_mass',6155,6146,'mean',NULL,NULL,NULL,NULL,NULL),(6150,1207,'C_relative_mass',6154,6146,'mean',NULL,NULL,NULL,NULL,NULL),(6151,1207,'P_relative_mass',6156,6146,'mean',NULL,NULL,NULL,NULL,NULL),(6152,1207,'K_relative_mass',6157,6146,'mean',NULL,NULL,NULL,NULL,NULL),(6153,1207,'N_relative_mass',6155,5435,'mean',NULL,NULL,NULL,NULL,NULL),(6154,1207,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6155,1207,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6156,1207,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6157,1207,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6158,1208,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6159,1208,'mass_relative_mass',6158,5426,'mean','se',8,0.7179600886917961,0.017294900221729536,NULL),(6160,1208,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6161,1208,'N_relative_mass',6167,6158,'mean',NULL,NULL,NULL,NULL,NULL),(6162,1208,'C_relative_mass',6166,6158,'mean',NULL,NULL,NULL,NULL,NULL),(6163,1208,'P_relative_mass',6168,6158,'mean',NULL,NULL,NULL,NULL,NULL),(6164,1208,'K_relative_mass',6169,6158,'mean',NULL,NULL,NULL,NULL,NULL),(6165,1208,'N_relative_mass',6167,5435,'mean',NULL,NULL,NULL,NULL,NULL),(6166,1208,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6167,1208,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6168,1208,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6169,1208,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6170,1209,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6171,1209,'mass_relative_mass',6170,5426,'mean','se',8,0.6634146341463415,0.03059866962305989,NULL),(6172,1209,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6173,1209,'N_relative_mass',6179,6170,'mean',NULL,NULL,NULL,NULL,NULL),(6174,1209,'C_relative_mass',6178,6170,'mean',NULL,NULL,NULL,NULL,NULL),(6175,1209,'P_relative_mass',6180,6170,'mean',NULL,NULL,NULL,NULL,NULL),(6176,1209,'K_relative_mass',6181,6170,'mean',NULL,NULL,NULL,NULL,NULL),(6177,1209,'N_relative_mass',6179,5435,'mean',NULL,NULL,NULL,NULL,NULL),(6178,1209,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6179,1209,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6180,1209,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6181,1209,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6182,1210,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6183,1210,'mass_relative_mass',6182,5438,'mean','se',8,0.7698447893569846,0.018625277161862498,NULL),(6184,1210,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6185,1210,'N_relative_mass',6191,6182,'mean',NULL,NULL,NULL,NULL,NULL),(6186,1210,'C_relative_mass',6190,6182,'mean',NULL,NULL,NULL,NULL,NULL),(6187,1210,'P_relative_mass',6192,6182,'mean',NULL,NULL,NULL,NULL,NULL),(6188,1210,'K_relative_mass',6193,6182,'mean',NULL,NULL,NULL,NULL,NULL),(6189,1210,'N_relative_mass',6191,5447,'mean',NULL,NULL,NULL,NULL,NULL),(6190,1210,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6191,1210,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6192,1210,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6193,1210,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6194,1211,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6195,1211,'mass_relative_mass',6194,5438,'mean','se',8,0.6940133037694014,0.023946784922394642,NULL),(6196,1211,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6197,1211,'N_relative_mass',6203,6194,'mean',NULL,NULL,NULL,NULL,NULL),(6198,1211,'C_relative_mass',6202,6194,'mean',NULL,NULL,NULL,NULL,NULL),(6199,1211,'P_relative_mass',6204,6194,'mean',NULL,NULL,NULL,NULL,NULL),(6200,1211,'K_relative_mass',6205,6194,'mean',NULL,NULL,NULL,NULL,NULL),(6201,1211,'N_relative_mass',6203,5447,'mean',NULL,NULL,NULL,NULL,NULL),(6202,1211,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6203,1211,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6204,1211,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6205,1211,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6206,1212,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6207,1212,'mass_relative_mass',6206,5438,'mean','se',8,0.6181818181818183,0.014634146341463462,NULL),(6208,1212,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6209,1212,'N_relative_mass',6215,6206,'mean',NULL,NULL,NULL,NULL,NULL),(6210,1212,'C_relative_mass',6214,6206,'mean',NULL,NULL,NULL,NULL,NULL),(6211,1212,'P_relative_mass',6216,6206,'mean',NULL,NULL,NULL,NULL,NULL),(6212,1212,'K_relative_mass',6217,6206,'mean',NULL,NULL,NULL,NULL,NULL),(6213,1212,'N_relative_mass',6215,5447,'mean',NULL,NULL,NULL,NULL,NULL),(6214,1212,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6215,1212,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6216,1212,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6217,1212,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6218,1213,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6219,1213,'mass_relative_mass',6218,5450,'mean','se',9,0.8401639344262296,0.00491803278688522,NULL),(6220,1213,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6221,1213,'N_relative_mass',6227,6218,'mean',NULL,NULL,NULL,NULL,NULL),(6222,1213,'C_relative_mass',6226,6218,'mean',NULL,NULL,NULL,NULL,NULL),(6223,1213,'P_relative_mass',6228,6218,'mean',NULL,NULL,NULL,NULL,NULL),(6224,1213,'K_relative_mass',6229,6218,'mean',NULL,NULL,NULL,NULL,NULL),(6225,1213,'N_relative_mass',6227,5459,'mean',NULL,NULL,NULL,NULL,NULL),(6226,1213,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6227,1213,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6228,1213,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6229,1213,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6230,1214,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6231,1214,'mass_relative_mass',6230,5450,'mean','se',9,0.814344262295082,0.018442622950819613,NULL),(6232,1214,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6233,1214,'N_relative_mass',6239,6230,'mean',NULL,NULL,NULL,NULL,NULL),(6234,1214,'C_relative_mass',6238,6230,'mean',NULL,NULL,NULL,NULL,NULL),(6235,1214,'P_relative_mass',6240,6230,'mean',NULL,NULL,NULL,NULL,NULL),(6236,1214,'K_relative_mass',6241,6230,'mean',NULL,NULL,NULL,NULL,NULL),(6237,1214,'N_relative_mass',6239,5459,'mean',NULL,NULL,NULL,NULL,NULL),(6238,1214,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6239,1214,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6240,1214,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6241,1214,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6242,1215,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6243,1215,'mass_relative_mass',6242,5450,'mean','se',9,0.7651639344262295,0.015983606557377072,NULL),(6244,1215,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6245,1215,'N_relative_mass',6251,6242,'mean',NULL,NULL,NULL,NULL,NULL),(6246,1215,'C_relative_mass',6250,6242,'mean',NULL,NULL,NULL,NULL,NULL),(6247,1215,'P_relative_mass',6252,6242,'mean',NULL,NULL,NULL,NULL,NULL),(6248,1215,'K_relative_mass',6253,6242,'mean',NULL,NULL,NULL,NULL,NULL),(6249,1215,'N_relative_mass',6251,5459,'mean',NULL,NULL,NULL,NULL,NULL),(6250,1215,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6251,1215,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6252,1215,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6253,1215,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6254,1216,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6255,1216,'mass_relative_mass',6254,5462,'mean','se',9,0.8327868852459016,0.011065573770491853,NULL),(6256,1216,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6257,1216,'N_relative_mass',6263,6254,'mean',NULL,NULL,NULL,NULL,NULL),(6258,1216,'C_relative_mass',6262,6254,'mean',NULL,NULL,NULL,NULL,NULL),(6259,1216,'P_relative_mass',6264,6254,'mean',NULL,NULL,NULL,NULL,NULL),(6260,1216,'K_relative_mass',6265,6254,'mean',NULL,NULL,NULL,NULL,NULL),(6261,1216,'N_relative_mass',6263,5471,'mean',NULL,NULL,NULL,NULL,NULL),(6262,1216,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6263,1216,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6264,1216,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6265,1216,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6266,1217,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6267,1217,'mass_relative_mass',6266,5462,'mean','se',9,0.8278688524590164,0.006147540983606632,NULL),(6268,1217,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6269,1217,'N_relative_mass',6275,6266,'mean',NULL,NULL,NULL,NULL,NULL),(6270,1217,'C_relative_mass',6274,6266,'mean',NULL,NULL,NULL,NULL,NULL),(6271,1217,'P_relative_mass',6276,6266,'mean',NULL,NULL,NULL,NULL,NULL),(6272,1217,'K_relative_mass',6277,6266,'mean',NULL,NULL,NULL,NULL,NULL),(6273,1217,'N_relative_mass',6275,5471,'mean',NULL,NULL,NULL,NULL,NULL),(6274,1217,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6275,1217,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6276,1217,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6277,1217,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6278,1218,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6279,1218,'mass_relative_mass',6278,5462,'mean','se',9,0.7737704918032787,0.015983606557377072,NULL),(6280,1218,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6281,1218,'N_relative_mass',6287,6278,'mean',NULL,NULL,NULL,NULL,NULL),(6282,1218,'C_relative_mass',6286,6278,'mean',NULL,NULL,NULL,NULL,NULL),(6283,1218,'P_relative_mass',6288,6278,'mean',NULL,NULL,NULL,NULL,NULL),(6284,1218,'K_relative_mass',6289,6278,'mean',NULL,NULL,NULL,NULL,NULL),(6285,1218,'N_relative_mass',6287,5471,'mean',NULL,NULL,NULL,NULL,NULL),(6286,1218,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6287,1218,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6288,1218,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6289,1218,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6290,1219,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6291,1219,'mass_relative_mass',6290,5474,'mean','se',9,0.8106557377049181,0.0036885245901639506,NULL),(6292,1219,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6293,1219,'N_relative_mass',6299,6290,'mean',NULL,NULL,NULL,NULL,NULL),(6294,1219,'C_relative_mass',6298,6290,'mean',NULL,NULL,NULL,NULL,NULL),(6295,1219,'P_relative_mass',6300,6290,'mean',NULL,NULL,NULL,NULL,NULL),(6296,1219,'K_relative_mass',6301,6290,'mean',NULL,NULL,NULL,NULL,NULL),(6297,1219,'N_relative_mass',6299,5483,'mean',NULL,NULL,NULL,NULL,NULL),(6298,1219,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6299,1219,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6300,1219,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6301,1219,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6302,1220,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6303,1220,'mass_relative_mass',6302,5474,'mean','se',9,0.7922131147540984,0.007377049180327901,NULL),(6304,1220,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6305,1220,'N_relative_mass',6311,6302,'mean',NULL,NULL,NULL,NULL,NULL),(6306,1220,'C_relative_mass',6310,6302,'mean',NULL,NULL,NULL,NULL,NULL),(6307,1220,'P_relative_mass',6312,6302,'mean',NULL,NULL,NULL,NULL,NULL),(6308,1220,'K_relative_mass',6313,6302,'mean',NULL,NULL,NULL,NULL,NULL),(6309,1220,'N_relative_mass',6311,5483,'mean',NULL,NULL,NULL,NULL,NULL),(6310,1220,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6311,1220,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6312,1220,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6313,1220,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6314,1221,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6315,1221,'mass_relative_mass',6314,5474,'mean','se',9,0.715983606557377,0.00983606557377044,NULL),(6316,1221,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6317,1221,'N_relative_mass',6323,6314,'mean',NULL,NULL,NULL,NULL,NULL),(6318,1221,'C_relative_mass',6322,6314,'mean',NULL,NULL,NULL,NULL,NULL),(6319,1221,'P_relative_mass',6324,6314,'mean',NULL,NULL,NULL,NULL,NULL),(6320,1221,'K_relative_mass',6325,6314,'mean',NULL,NULL,NULL,NULL,NULL),(6321,1221,'N_relative_mass',6323,5483,'mean',NULL,NULL,NULL,NULL,NULL),(6322,1221,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6323,1221,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6324,1221,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6325,1221,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6326,1222,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6327,1222,'mass_relative_mass',6326,5486,'mean','se',9,0.8254098360655737,0.0049180327868853626,NULL),(6328,1222,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6329,1222,'N_relative_mass',6335,6326,'mean',NULL,NULL,NULL,NULL,NULL),(6330,1222,'C_relative_mass',6334,6326,'mean',NULL,NULL,NULL,NULL,NULL),(6331,1222,'P_relative_mass',6336,6326,'mean',NULL,NULL,NULL,NULL,NULL),(6332,1222,'K_relative_mass',6337,6326,'mean',NULL,NULL,NULL,NULL,NULL),(6333,1222,'N_relative_mass',6335,5495,'mean',NULL,NULL,NULL,NULL,NULL),(6334,1222,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6335,1222,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6336,1222,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6337,1222,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6338,1223,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6339,1223,'mass_relative_mass',6338,5486,'mean','se',9,0.8094262295081966,0.013524590163934534,NULL),(6340,1223,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6341,1223,'N_relative_mass',6347,6338,'mean',NULL,NULL,NULL,NULL,NULL),(6342,1223,'C_relative_mass',6346,6338,'mean',NULL,NULL,NULL,NULL,NULL),(6343,1223,'P_relative_mass',6348,6338,'mean',NULL,NULL,NULL,NULL,NULL),(6344,1223,'K_relative_mass',6349,6338,'mean',NULL,NULL,NULL,NULL,NULL),(6345,1223,'N_relative_mass',6347,5495,'mean',NULL,NULL,NULL,NULL,NULL),(6346,1223,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6347,1223,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6348,1223,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6349,1223,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6350,1224,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6351,1224,'mass_relative_mass',6350,5486,'mean','se',9,0.7885245901639345,0.02950819672131132,NULL),(6352,1224,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6353,1224,'N_relative_mass',6359,6350,'mean',NULL,NULL,NULL,NULL,NULL),(6354,1224,'C_relative_mass',6358,6350,'mean',NULL,NULL,NULL,NULL,NULL),(6355,1224,'P_relative_mass',6360,6350,'mean',NULL,NULL,NULL,NULL,NULL),(6356,1224,'K_relative_mass',6361,6350,'mean',NULL,NULL,NULL,NULL,NULL),(6357,1224,'N_relative_mass',6359,5495,'mean',NULL,NULL,NULL,NULL,NULL),(6358,1224,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6359,1224,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6360,1224,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6361,1224,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6362,1225,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6363,1225,'mass_relative_mass',6362,5498,'mean','se',9,0.8679764243614931,0.015324165029469441,NULL),(6364,1225,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6365,1225,'N_relative_mass',6371,6362,'mean',NULL,NULL,NULL,NULL,NULL),(6366,1225,'C_relative_mass',6370,6362,'mean',NULL,NULL,NULL,NULL,NULL),(6367,1225,'P_relative_mass',6372,6362,'mean',NULL,NULL,NULL,NULL,NULL),(6368,1225,'K_relative_mass',6373,6362,'mean',NULL,NULL,NULL,NULL,NULL),(6369,1225,'N_relative_mass',6371,5507,'mean',NULL,NULL,NULL,NULL,NULL),(6370,1225,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6371,1225,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6372,1225,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6373,1225,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6374,1226,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6375,1226,'mass_relative_mass',6374,5498,'mean','se',9,0.8609037328094302,0.016502946954813354,NULL),(6376,1226,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6377,1226,'N_relative_mass',6383,6374,'mean',NULL,NULL,NULL,NULL,NULL),(6378,1226,'C_relative_mass',6382,6374,'mean',NULL,NULL,NULL,NULL,NULL),(6379,1226,'P_relative_mass',6384,6374,'mean',NULL,NULL,NULL,NULL,NULL),(6380,1226,'K_relative_mass',6385,6374,'mean',NULL,NULL,NULL,NULL,NULL),(6381,1226,'N_relative_mass',6383,5507,'mean',NULL,NULL,NULL,NULL,NULL),(6382,1226,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6383,1226,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6384,1226,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6385,1226,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6386,1227,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6387,1227,'mass_relative_mass',6386,5498,'mean','se',9,0.8055009823182712,0.04007858546168961,NULL),(6388,1227,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6389,1227,'N_relative_mass',6395,6386,'mean',NULL,NULL,NULL,NULL,NULL),(6390,1227,'C_relative_mass',6394,6386,'mean',NULL,NULL,NULL,NULL,NULL),(6391,1227,'P_relative_mass',6396,6386,'mean',NULL,NULL,NULL,NULL,NULL),(6392,1227,'K_relative_mass',6397,6386,'mean',NULL,NULL,NULL,NULL,NULL),(6393,1227,'N_relative_mass',6395,5507,'mean',NULL,NULL,NULL,NULL,NULL),(6394,1227,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6395,1227,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6396,1227,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6397,1227,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6398,1228,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6399,1228,'mass_relative_mass',6398,5510,'mean','se',9,0.8667976424361492,0.016502946954813354,NULL),(6400,1228,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6401,1228,'N_relative_mass',6407,6398,'mean',NULL,NULL,NULL,NULL,NULL),(6402,1228,'C_relative_mass',6406,6398,'mean',NULL,NULL,NULL,NULL,NULL),(6403,1228,'P_relative_mass',6408,6398,'mean',NULL,NULL,NULL,NULL,NULL),(6404,1228,'K_relative_mass',6409,6398,'mean',NULL,NULL,NULL,NULL,NULL),(6405,1228,'N_relative_mass',6407,5519,'mean',NULL,NULL,NULL,NULL,NULL),(6406,1228,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6407,1228,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6408,1228,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6409,1228,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6410,1229,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6411,1229,'mass_relative_mass',6410,5510,'mean','se',9,0.8691552062868371,0.009430255402750448,NULL),(6412,1229,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6413,1229,'N_relative_mass',6419,6410,'mean',NULL,NULL,NULL,NULL,NULL),(6414,1229,'C_relative_mass',6418,6410,'mean',NULL,NULL,NULL,NULL,NULL),(6415,1229,'P_relative_mass',6420,6410,'mean',NULL,NULL,NULL,NULL,NULL),(6416,1229,'K_relative_mass',6421,6410,'mean',NULL,NULL,NULL,NULL,NULL),(6417,1229,'N_relative_mass',6419,5519,'mean',NULL,NULL,NULL,NULL,NULL),(6418,1229,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6419,1229,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6420,1229,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6421,1229,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6422,1230,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6423,1230,'mass_relative_mass',6422,5510,'mean','se',9,0.8349705304518664,0.01178781925343813,NULL),(6424,1230,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6425,1230,'N_relative_mass',6431,6422,'mean',NULL,NULL,NULL,NULL,NULL),(6426,1230,'C_relative_mass',6430,6422,'mean',NULL,NULL,NULL,NULL,NULL),(6427,1230,'P_relative_mass',6432,6422,'mean',NULL,NULL,NULL,NULL,NULL),(6428,1230,'K_relative_mass',6433,6422,'mean',NULL,NULL,NULL,NULL,NULL),(6429,1230,'N_relative_mass',6431,5519,'mean',NULL,NULL,NULL,NULL,NULL),(6430,1230,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6431,1230,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6432,1230,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6433,1230,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6434,1231,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6435,1231,'mass_relative_mass',6434,5522,'mean','se',9,0.8491159135559921,0.004715127701375224,NULL),(6436,1231,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6437,1231,'N_relative_mass',6443,6434,'mean',NULL,NULL,NULL,NULL,NULL),(6438,1231,'C_relative_mass',6442,6434,'mean',NULL,NULL,NULL,NULL,NULL),(6439,1231,'P_relative_mass',6444,6434,'mean',NULL,NULL,NULL,NULL,NULL),(6440,1231,'K_relative_mass',6445,6434,'mean',NULL,NULL,NULL,NULL,NULL),(6441,1231,'N_relative_mass',6443,5531,'mean',NULL,NULL,NULL,NULL,NULL),(6442,1231,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6443,1231,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6444,1231,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6445,1231,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6446,1232,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6447,1232,'mass_relative_mass',6446,5522,'mean','se',9,0.8326129666011788,0.024754420432220172,NULL),(6448,1232,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6449,1232,'N_relative_mass',6455,6446,'mean',NULL,NULL,NULL,NULL,NULL),(6450,1232,'C_relative_mass',6454,6446,'mean',NULL,NULL,NULL,NULL,NULL),(6451,1232,'P_relative_mass',6456,6446,'mean',NULL,NULL,NULL,NULL,NULL),(6452,1232,'K_relative_mass',6457,6446,'mean',NULL,NULL,NULL,NULL,NULL),(6453,1232,'N_relative_mass',6455,5531,'mean',NULL,NULL,NULL,NULL,NULL),(6454,1232,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6455,1232,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6456,1232,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6457,1232,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6458,1233,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6459,1233,'mass_relative_mass',6458,5522,'mean','se',9,0.7724950884086446,0.016502946954813354,NULL),(6460,1233,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6461,1233,'N_relative_mass',6467,6458,'mean',NULL,NULL,NULL,NULL,NULL),(6462,1233,'C_relative_mass',6466,6458,'mean',NULL,NULL,NULL,NULL,NULL),(6463,1233,'P_relative_mass',6468,6458,'mean',NULL,NULL,NULL,NULL,NULL),(6464,1233,'K_relative_mass',6469,6458,'mean',NULL,NULL,NULL,NULL,NULL),(6465,1233,'N_relative_mass',6467,5531,'mean',NULL,NULL,NULL,NULL,NULL),(6466,1233,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6467,1233,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6468,1233,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6469,1233,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6470,1234,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6471,1234,'mass_relative_mass',6470,5534,'mean','se',9,0.8797642436149311,0.012966601178782185,NULL),(6472,1234,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6473,1234,'N_relative_mass',6479,6470,'mean',NULL,NULL,NULL,NULL,NULL),(6474,1234,'C_relative_mass',6478,6470,'mean',NULL,NULL,NULL,NULL,NULL),(6475,1234,'P_relative_mass',6480,6470,'mean',NULL,NULL,NULL,NULL,NULL),(6476,1234,'K_relative_mass',6481,6470,'mean',NULL,NULL,NULL,NULL,NULL),(6477,1234,'N_relative_mass',6479,5543,'mean',NULL,NULL,NULL,NULL,NULL),(6478,1234,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6479,1234,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6480,1234,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6481,1234,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6482,1235,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6483,1235,'mass_relative_mass',6482,5534,'mean','se',9,0.8337917485265228,0.022396856581532062,NULL),(6484,1235,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6485,1235,'N_relative_mass',6491,6482,'mean',NULL,NULL,NULL,NULL,NULL),(6486,1235,'C_relative_mass',6490,6482,'mean',NULL,NULL,NULL,NULL,NULL),(6487,1235,'P_relative_mass',6492,6482,'mean',NULL,NULL,NULL,NULL,NULL),(6488,1235,'K_relative_mass',6493,6482,'mean',NULL,NULL,NULL,NULL,NULL),(6489,1235,'N_relative_mass',6491,5543,'mean',NULL,NULL,NULL,NULL,NULL),(6490,1235,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6491,1235,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6492,1235,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6493,1235,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6494,1236,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6495,1236,'mass_relative_mass',6494,5534,'mean','se',9,0.8055009823182712,0.04125736738703338,NULL),(6496,1236,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6497,1236,'N_relative_mass',6503,6494,'mean',NULL,NULL,NULL,NULL,NULL),(6498,1236,'C_relative_mass',6502,6494,'mean',NULL,NULL,NULL,NULL,NULL),(6499,1236,'P_relative_mass',6504,6494,'mean',NULL,NULL,NULL,NULL,NULL),(6500,1236,'K_relative_mass',6505,6494,'mean',NULL,NULL,NULL,NULL,NULL),(6501,1236,'N_relative_mass',6503,5543,'mean',NULL,NULL,NULL,NULL,NULL),(6502,1236,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6503,1236,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6504,1236,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6505,1236,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6506,1237,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6507,1237,'mass_relative_mass',6506,5546,'mean','se',9,0.8927601809954752,0.009502262443438951,NULL),(6508,1237,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6509,1237,'N_relative_mass',6515,6506,'mean',NULL,NULL,NULL,NULL,NULL),(6510,1237,'C_relative_mass',6514,6506,'mean',NULL,NULL,NULL,NULL,NULL),(6511,1237,'P_relative_mass',6516,6506,'mean',NULL,NULL,NULL,NULL,NULL),(6512,1237,'K_relative_mass',6517,6506,'mean',NULL,NULL,NULL,NULL,NULL),(6513,1237,'N_relative_mass',6515,5555,'mean',NULL,NULL,NULL,NULL,NULL),(6514,1237,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6515,1237,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6516,1237,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6517,1237,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6518,1238,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6519,1238,'mass_relative_mass',6518,5546,'mean','se',9,0.879185520361991,0.010859728506787292,NULL),(6520,1238,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6521,1238,'N_relative_mass',6527,6518,'mean',NULL,NULL,NULL,NULL,NULL),(6522,1238,'C_relative_mass',6526,6518,'mean',NULL,NULL,NULL,NULL,NULL),(6523,1238,'P_relative_mass',6528,6518,'mean',NULL,NULL,NULL,NULL,NULL),(6524,1238,'K_relative_mass',6529,6518,'mean',NULL,NULL,NULL,NULL,NULL),(6525,1238,'N_relative_mass',6527,5555,'mean',NULL,NULL,NULL,NULL,NULL),(6526,1238,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6527,1238,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6528,1238,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6529,1238,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6530,1239,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6531,1239,'mass_relative_mass',6530,5546,'mean','se',9,0.8357466063348418,0.008144796380090469,NULL),(6532,1239,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6533,1239,'N_relative_mass',6539,6530,'mean',NULL,NULL,NULL,NULL,NULL),(6534,1239,'C_relative_mass',6538,6530,'mean',NULL,NULL,NULL,NULL,NULL),(6535,1239,'P_relative_mass',6540,6530,'mean',NULL,NULL,NULL,NULL,NULL),(6536,1239,'K_relative_mass',6541,6530,'mean',NULL,NULL,NULL,NULL,NULL),(6537,1239,'N_relative_mass',6539,5555,'mean',NULL,NULL,NULL,NULL,NULL),(6538,1239,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6539,1239,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6540,1239,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6541,1239,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6542,1240,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6543,1240,'mass_relative_mass',6542,5558,'mean','se',9,0.8941176470588236,0.010859728506787292,NULL),(6544,1240,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6545,1240,'N_relative_mass',6551,6542,'mean',NULL,NULL,NULL,NULL,NULL),(6546,1240,'C_relative_mass',6550,6542,'mean',NULL,NULL,NULL,NULL,NULL),(6547,1240,'P_relative_mass',6552,6542,'mean',NULL,NULL,NULL,NULL,NULL),(6548,1240,'K_relative_mass',6553,6542,'mean',NULL,NULL,NULL,NULL,NULL),(6549,1240,'N_relative_mass',6551,5567,'mean',NULL,NULL,NULL,NULL,NULL),(6550,1240,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6551,1240,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6552,1240,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6553,1240,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6554,1241,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6555,1241,'mass_relative_mass',6554,5558,'mean','se',9,0.8914027149321267,0.006787330316741986,NULL),(6556,1241,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6557,1241,'N_relative_mass',6563,6554,'mean',NULL,NULL,NULL,NULL,NULL),(6558,1241,'C_relative_mass',6562,6554,'mean',NULL,NULL,NULL,NULL,NULL),(6559,1241,'P_relative_mass',6564,6554,'mean',NULL,NULL,NULL,NULL,NULL),(6560,1241,'K_relative_mass',6565,6554,'mean',NULL,NULL,NULL,NULL,NULL),(6561,1241,'N_relative_mass',6563,5567,'mean',NULL,NULL,NULL,NULL,NULL),(6562,1241,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6563,1241,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6564,1241,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6565,1241,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6566,1242,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6567,1242,'mass_relative_mass',6566,5558,'mean','se',9,0.8574660633484164,0.008144796380090611,NULL),(6568,1242,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6569,1242,'N_relative_mass',6575,6566,'mean',NULL,NULL,NULL,NULL,NULL),(6570,1242,'C_relative_mass',6574,6566,'mean',NULL,NULL,NULL,NULL,NULL),(6571,1242,'P_relative_mass',6576,6566,'mean',NULL,NULL,NULL,NULL,NULL),(6572,1242,'K_relative_mass',6577,6566,'mean',NULL,NULL,NULL,NULL,NULL),(6573,1242,'N_relative_mass',6575,5567,'mean',NULL,NULL,NULL,NULL,NULL),(6574,1242,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6575,1242,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6576,1242,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6577,1242,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6578,1243,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6579,1243,'mass_relative_mass',6578,5570,'mean','se',9,0.8805429864253393,0.008144796380090469,NULL),(6580,1243,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6581,1243,'N_relative_mass',6587,6578,'mean',NULL,NULL,NULL,NULL,NULL),(6582,1243,'C_relative_mass',6586,6578,'mean',NULL,NULL,NULL,NULL,NULL),(6583,1243,'P_relative_mass',6588,6578,'mean',NULL,NULL,NULL,NULL,NULL),(6584,1243,'K_relative_mass',6589,6578,'mean',NULL,NULL,NULL,NULL,NULL),(6585,1243,'N_relative_mass',6587,5579,'mean',NULL,NULL,NULL,NULL,NULL),(6586,1243,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6587,1243,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6588,1243,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6589,1243,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6590,1244,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6591,1244,'mass_relative_mass',6590,5570,'mean','se',9,0.8900452488687783,0.009502262443438951,NULL),(6592,1244,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6593,1244,'N_relative_mass',6599,6590,'mean',NULL,NULL,NULL,NULL,NULL),(6594,1244,'C_relative_mass',6598,6590,'mean',NULL,NULL,NULL,NULL,NULL),(6595,1244,'P_relative_mass',6600,6590,'mean',NULL,NULL,NULL,NULL,NULL),(6596,1244,'K_relative_mass',6601,6590,'mean',NULL,NULL,NULL,NULL,NULL),(6597,1244,'N_relative_mass',6599,5579,'mean',NULL,NULL,NULL,NULL,NULL),(6598,1244,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6599,1244,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6600,1244,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6601,1244,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6602,1245,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6603,1245,'mass_relative_mass',6602,5570,'mean','se',9,0.8343891402714934,0.008144796380090469,NULL),(6604,1245,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6605,1245,'N_relative_mass',6611,6602,'mean',NULL,NULL,NULL,NULL,NULL),(6606,1245,'C_relative_mass',6610,6602,'mean',NULL,NULL,NULL,NULL,NULL),(6607,1245,'P_relative_mass',6612,6602,'mean',NULL,NULL,NULL,NULL,NULL),(6608,1245,'K_relative_mass',6613,6602,'mean',NULL,NULL,NULL,NULL,NULL),(6609,1245,'N_relative_mass',6611,5579,'mean',NULL,NULL,NULL,NULL,NULL),(6610,1245,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6611,1245,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6612,1245,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6613,1245,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6614,1246,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6615,1246,'mass_relative_mass',6614,5582,'mean','se',9,0.9266968325791854,0.009502262443438951,NULL),(6616,1246,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6617,1246,'N_relative_mass',6623,6614,'mean',NULL,NULL,NULL,NULL,NULL),(6618,1246,'C_relative_mass',6622,6614,'mean',NULL,NULL,NULL,NULL,NULL),(6619,1246,'P_relative_mass',6624,6614,'mean',NULL,NULL,NULL,NULL,NULL),(6620,1246,'K_relative_mass',6625,6614,'mean',NULL,NULL,NULL,NULL,NULL),(6621,1246,'N_relative_mass',6623,5591,'mean',NULL,NULL,NULL,NULL,NULL),(6622,1246,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6623,1246,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6624,1246,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6625,1246,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6626,1247,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6627,1247,'mass_relative_mass',6626,5582,'mean','se',9,0.9131221719457013,0.024434389140271406,NULL),(6628,1247,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6629,1247,'N_relative_mass',6635,6626,'mean',NULL,NULL,NULL,NULL,NULL),(6630,1247,'C_relative_mass',6634,6626,'mean',NULL,NULL,NULL,NULL,NULL),(6631,1247,'P_relative_mass',6636,6626,'mean',NULL,NULL,NULL,NULL,NULL),(6632,1247,'K_relative_mass',6637,6626,'mean',NULL,NULL,NULL,NULL,NULL),(6633,1247,'N_relative_mass',6635,5591,'mean',NULL,NULL,NULL,NULL,NULL),(6634,1247,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6635,1247,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6636,1247,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6637,1247,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6638,1248,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6639,1248,'mass_relative_mass',6638,5582,'mean','se',9,0.9104072398190045,0.010859728506787434,NULL),(6640,1248,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6641,1248,'N_relative_mass',6647,6638,'mean',NULL,NULL,NULL,NULL,NULL),(6642,1248,'C_relative_mass',6646,6638,'mean',NULL,NULL,NULL,NULL,NULL),(6643,1248,'P_relative_mass',6648,6638,'mean',NULL,NULL,NULL,NULL,NULL),(6644,1248,'K_relative_mass',6649,6638,'mean',NULL,NULL,NULL,NULL,NULL),(6645,1248,'N_relative_mass',6647,5591,'mean',NULL,NULL,NULL,NULL,NULL),(6646,1248,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6647,1248,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6648,1248,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6649,1248,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6650,1249,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6651,1249,'mass_relative_mass',6650,5594,'mean','se',9,0.9478841870824053,0.006681514476614723,NULL),(6652,1249,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6653,1249,'N_relative_mass',6659,6650,'mean',NULL,NULL,NULL,NULL,NULL),(6654,1249,'C_relative_mass',6658,6650,'mean',NULL,NULL,NULL,NULL,NULL),(6655,1249,'P_relative_mass',6660,6650,'mean',NULL,NULL,NULL,NULL,NULL),(6656,1249,'K_relative_mass',6661,6650,'mean',NULL,NULL,NULL,NULL,NULL),(6657,1249,'N_relative_mass',6659,5603,'mean',NULL,NULL,NULL,NULL,NULL),(6658,1249,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6659,1249,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6660,1249,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6661,1249,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6662,1250,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6663,1250,'mass_relative_mass',6662,5594,'mean','se',9,0.9599109131403119,0.017371937639198053,NULL),(6664,1250,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6665,1250,'N_relative_mass',6671,6662,'mean',NULL,NULL,NULL,NULL,NULL),(6666,1250,'C_relative_mass',6670,6662,'mean',NULL,NULL,NULL,NULL,NULL),(6667,1250,'P_relative_mass',6672,6662,'mean',NULL,NULL,NULL,NULL,NULL),(6668,1250,'K_relative_mass',6673,6662,'mean',NULL,NULL,NULL,NULL,NULL),(6669,1250,'N_relative_mass',6671,5603,'mean',NULL,NULL,NULL,NULL,NULL),(6670,1250,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6671,1250,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6672,1250,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6673,1250,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6674,1251,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6675,1251,'mass_relative_mass',6674,5594,'mean','se',9,0.8971046770601336,0.008017817371937496,NULL),(6676,1251,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6677,1251,'N_relative_mass',6683,6674,'mean',NULL,NULL,NULL,NULL,NULL),(6678,1251,'C_relative_mass',6682,6674,'mean',NULL,NULL,NULL,NULL,NULL),(6679,1251,'P_relative_mass',6684,6674,'mean',NULL,NULL,NULL,NULL,NULL),(6680,1251,'K_relative_mass',6685,6674,'mean',NULL,NULL,NULL,NULL,NULL),(6681,1251,'N_relative_mass',6683,5603,'mean',NULL,NULL,NULL,NULL,NULL),(6682,1251,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6683,1251,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6684,1251,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6685,1251,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6686,1252,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6687,1252,'mass_relative_mass',6686,5606,'mean','se',9,0.9492204899777282,0.005345211581291806,NULL),(6688,1252,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6689,1252,'N_relative_mass',6695,6686,'mean',NULL,NULL,NULL,NULL,NULL),(6690,1252,'C_relative_mass',6694,6686,'mean',NULL,NULL,NULL,NULL,NULL),(6691,1252,'P_relative_mass',6696,6686,'mean',NULL,NULL,NULL,NULL,NULL),(6692,1252,'K_relative_mass',6697,6686,'mean',NULL,NULL,NULL,NULL,NULL),(6693,1252,'N_relative_mass',6695,5615,'mean',NULL,NULL,NULL,NULL,NULL),(6694,1252,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6695,1252,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6696,1252,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6697,1252,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6698,1253,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6699,1253,'mass_relative_mass',6698,5606,'mean','se',9,0.951893095768374,0.010690423162583612,NULL),(6700,1253,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6701,1253,'N_relative_mass',6707,6698,'mean',NULL,NULL,NULL,NULL,NULL),(6702,1253,'C_relative_mass',6706,6698,'mean',NULL,NULL,NULL,NULL,NULL),(6703,1253,'P_relative_mass',6708,6698,'mean',NULL,NULL,NULL,NULL,NULL),(6704,1253,'K_relative_mass',6709,6698,'mean',NULL,NULL,NULL,NULL,NULL),(6705,1253,'N_relative_mass',6707,5615,'mean',NULL,NULL,NULL,NULL,NULL),(6706,1253,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6707,1253,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6708,1253,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6709,1253,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6710,1254,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6711,1254,'mass_relative_mass',6710,5606,'mean','se',9,0.9278396436525612,0.009354120267260554,NULL),(6712,1254,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6713,1254,'N_relative_mass',6719,6710,'mean',NULL,NULL,NULL,NULL,NULL),(6714,1254,'C_relative_mass',6718,6710,'mean',NULL,NULL,NULL,NULL,NULL),(6715,1254,'P_relative_mass',6720,6710,'mean',NULL,NULL,NULL,NULL,NULL),(6716,1254,'K_relative_mass',6721,6710,'mean',NULL,NULL,NULL,NULL,NULL),(6717,1254,'N_relative_mass',6719,5615,'mean',NULL,NULL,NULL,NULL,NULL),(6718,1254,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6719,1254,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6720,1254,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6721,1254,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6722,1255,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6723,1255,'mass_relative_mass',6722,5618,'mean','se',9,0.9492204899777282,0.006681514476614723,NULL),(6724,1255,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6725,1255,'N_relative_mass',6731,6722,'mean',NULL,NULL,NULL,NULL,NULL),(6726,1255,'C_relative_mass',6730,6722,'mean',NULL,NULL,NULL,NULL,NULL),(6727,1255,'P_relative_mass',6732,6722,'mean',NULL,NULL,NULL,NULL,NULL),(6728,1255,'K_relative_mass',6733,6722,'mean',NULL,NULL,NULL,NULL,NULL),(6729,1255,'N_relative_mass',6731,5627,'mean',NULL,NULL,NULL,NULL,NULL),(6730,1255,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6731,1255,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6732,1255,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6733,1255,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6734,1256,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6735,1256,'mass_relative_mass',6734,5618,'mean','se',9,0.9559020044543429,0.022717149220489858,NULL),(6736,1256,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6737,1256,'N_relative_mass',6743,6734,'mean',NULL,NULL,NULL,NULL,NULL),(6738,1256,'C_relative_mass',6742,6734,'mean',NULL,NULL,NULL,NULL,NULL),(6739,1256,'P_relative_mass',6744,6734,'mean',NULL,NULL,NULL,NULL,NULL),(6740,1256,'K_relative_mass',6745,6734,'mean',NULL,NULL,NULL,NULL,NULL),(6741,1256,'N_relative_mass',6743,5627,'mean',NULL,NULL,NULL,NULL,NULL),(6742,1256,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6743,1256,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6744,1256,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6745,1256,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6746,1257,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6747,1257,'mass_relative_mass',6746,5618,'mean','se',9,0.8944320712694878,0.009354120267260554,NULL),(6748,1257,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6749,1257,'N_relative_mass',6755,6746,'mean',NULL,NULL,NULL,NULL,NULL),(6750,1257,'C_relative_mass',6754,6746,'mean',NULL,NULL,NULL,NULL,NULL),(6751,1257,'P_relative_mass',6756,6746,'mean',NULL,NULL,NULL,NULL,NULL),(6752,1257,'K_relative_mass',6757,6746,'mean',NULL,NULL,NULL,NULL,NULL),(6753,1257,'N_relative_mass',6755,5627,'mean',NULL,NULL,NULL,NULL,NULL),(6754,1257,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6755,1257,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6756,1257,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6757,1257,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6758,1258,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6759,1258,'mass_relative_mass',6758,5630,'mean','se',9,0.9786191536748328,0.005345211581291806,NULL),(6760,1258,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6761,1258,'N_relative_mass',6767,6758,'mean',NULL,NULL,NULL,NULL,NULL),(6762,1258,'C_relative_mass',6766,6758,'mean',NULL,NULL,NULL,NULL,NULL),(6763,1258,'P_relative_mass',6768,6758,'mean',NULL,NULL,NULL,NULL,NULL),(6764,1258,'K_relative_mass',6769,6758,'mean',NULL,NULL,NULL,NULL,NULL),(6765,1258,'N_relative_mass',6767,5639,'mean',NULL,NULL,NULL,NULL,NULL),(6766,1258,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6767,1258,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6768,1258,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6769,1258,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6770,1259,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6771,1259,'mass_relative_mass',6770,5630,'mean','se',9,0.9612472160356347,0.017371937639198053,NULL),(6772,1259,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6773,1259,'N_relative_mass',6779,6770,'mean',NULL,NULL,NULL,NULL,NULL),(6774,1259,'C_relative_mass',6778,6770,'mean',NULL,NULL,NULL,NULL,NULL),(6775,1259,'P_relative_mass',6780,6770,'mean',NULL,NULL,NULL,NULL,NULL),(6776,1259,'K_relative_mass',6781,6770,'mean',NULL,NULL,NULL,NULL,NULL),(6777,1259,'N_relative_mass',6779,5639,'mean',NULL,NULL,NULL,NULL,NULL),(6778,1259,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6779,1259,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6780,1259,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6781,1259,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6782,1260,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6783,1260,'mass_relative_mass',6782,5630,'mean','se',9,1.0080178173719376,0.01069042316258333,NULL),(6784,1260,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.1,NULL,NULL),(6785,1260,'N_relative_mass',6791,6782,'mean',NULL,NULL,NULL,NULL,NULL),(6786,1260,'C_relative_mass',6790,6782,'mean',NULL,NULL,NULL,NULL,NULL),(6787,1260,'P_relative_mass',6792,6782,'mean',NULL,NULL,NULL,NULL,NULL),(6788,1260,'K_relative_mass',6793,6782,'mean',NULL,NULL,NULL,NULL,NULL),(6789,1260,'N_relative_mass',6791,5639,'mean',NULL,NULL,NULL,NULL,NULL),(6790,1260,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6791,1260,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6792,1260,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6793,1260,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6794,1265,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6795,1265,'mass_relative_mass',6794,6794,'mean','se',5,1,0,NULL),(6796,1265,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(6797,1265,'N_relative_mass',6801,6794,'mean','se',5,0.009194805194805195,0.00035064935064935197,NULL),(6798,1265,'C_relative_mass',6800,6794,'mean','se',5,0.3852867830423939,0.008728179551122196,NULL),(6799,1265,'P_relative_mass',6802,6794,'mean','se',5,0.00041826923076923085,0.00005192307692307707,NULL),(6800,1265,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6801,1265,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6802,1265,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6803,1265,'water_table_depth',NULL,NULL,'mean',NULL,NULL,19,NULL,NULL),(6804,1266,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6805,1266,'mass_relative_mass',6804,6804,'mean','se',5,1,0,NULL),(6806,1266,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(6807,1266,'N_relative_mass',6811,6804,'mean','se',5,0.009350649350649349,0.0001948051948051983,NULL),(6808,1266,'C_relative_mass',6810,6804,'mean','se',5,0.3827930174563591,0.00748129675810469,NULL),(6809,1266,'P_relative_mass',6812,6804,'mean','se',5,0.00038365384615384645,0.000028846153846153744,NULL),(6810,1266,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6811,1266,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6812,1266,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6813,1266,'water_table_depth',NULL,NULL,'mean',NULL,NULL,19,NULL,NULL),(6814,1267,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6815,1267,'mass_relative_mass',6814,6814,'mean','se',5,1,0,NULL),(6816,1267,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(6817,1267,'N_relative_mass',6821,6814,'mean','se',5,0.009506493506493506,0.0002727272727272734,NULL),(6818,1267,'C_relative_mass',6820,6814,'mean','se',5,0.39027431421446374,0.0062344139650872986,NULL),(6819,1267,'P_relative_mass',6822,6814,'mean','se',5,0.0004932692307692309,0.000043269230769230726,NULL),(6820,1267,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6821,1267,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6822,1267,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6823,1267,'water_table_depth',NULL,NULL,'mean',NULL,NULL,19,NULL,NULL),(6824,1268,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6825,1268,'mass_relative_mass',6824,6824,'mean','se',5,1,0,NULL),(6826,1268,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(6827,1268,'N_relative_mass',6831,6824,'mean','se',5,0.01009090909090909,0.00035064935064935197,NULL),(6828,1268,'C_relative_mass',6830,6824,'mean','se',5,0.38778054862842887,0.013715710723192047,NULL),(6829,1268,'P_relative_mass',6832,6824,'mean','se',5,0.0004326923076923079,0.00002596153846153837,NULL),(6830,1268,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6831,1268,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6832,1268,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6833,1268,'water_table_depth',NULL,NULL,'mean',NULL,NULL,19,NULL,NULL),(6834,1269,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6835,1269,'mass_relative_mass',6834,6834,'mean','se',5,1,0,NULL),(6836,1269,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(6837,1269,'N_relative_mass',6841,6834,'mean','se',5,0.006467532467532468,0.00019480519480519475,NULL),(6838,1269,'C_relative_mass',6840,6834,'mean','se',5,0.3940149625935161,0.0062344139650872986,NULL),(6839,1269,'P_relative_mass',6842,6834,'mean','se',5,0.00011538461538461545,0.000017307692307692303,NULL),(6840,1269,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6841,1269,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6842,1269,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6843,1269,'water_table_depth',NULL,NULL,'mean',NULL,NULL,19,NULL,NULL),(6844,1270,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6845,1270,'mass_relative_mass',6844,6844,'mean','se',5,1,0,NULL),(6846,1270,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(6847,1270,'N_relative_mass',6851,6844,'mean','se',5,0.006701298701298702,0.00003896103896103842,NULL),(6848,1270,'C_relative_mass',6850,6844,'mean','se',5,0.39152119700748117,0.006234413965087242,NULL),(6849,1270,'P_relative_mass',6852,6844,'mean','se',5,0.00013846153846153856,0.00002596153846153848,NULL),(6850,1270,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6851,1270,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6852,1270,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6853,1270,'water_table_depth',NULL,NULL,'mean',NULL,NULL,19,NULL,NULL),(6854,1271,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6855,1271,'mass_relative_mass',6854,6854,'mean','se',5,1,0,NULL),(6856,1271,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(6857,1271,'N_relative_mass',6861,6854,'mean','se',5,0.006467532467532468,0.00015584415584415546,NULL),(6858,1271,'C_relative_mass',6860,6854,'mean','se',5,0.39775561097256845,0.004987531172069908,NULL),(6859,1271,'P_relative_mass',6862,6854,'mean','se',5,0.00011826923076923088,0.000017307692307692303,NULL),(6860,1271,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6861,1271,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6862,1271,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6863,1271,'water_table_depth',NULL,NULL,'mean',NULL,NULL,19,NULL,NULL),(6864,1272,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6865,1272,'mass_relative_mass',6864,6864,'mean','se',5,1,0,NULL),(6866,1272,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(6867,1272,'N_relative_mass',6871,6864,'mean','se',5,0.006857142857142858,0.00011688311688311614,NULL),(6868,1272,'C_relative_mass',6870,6864,'mean','se',5,0.3827930174563591,0.00748129675810469,NULL),(6869,1272,'P_relative_mass',6872,6864,'mean','se',5,0.00009230769230769245,0.000011538461538461497,NULL),(6870,1272,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6871,1272,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6872,1272,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6873,1272,'water_table_depth',NULL,NULL,'mean',NULL,NULL,19,NULL,NULL),(6874,1273,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6875,1273,'mass_relative_mass',6874,6874,'mean','se',5,1,0,NULL),(6876,1273,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(6877,1273,'N_relative_mass',6881,6874,'mean','se',5,0.012272727272727274,0.00046753246753246814,NULL),(6878,1273,'C_relative_mass',6880,6874,'mean','se',5,0.2892768079800498,0.017456359102244447,NULL),(6879,1273,'P_relative_mass',6882,6874,'mean','se',5,0.0009230769230769232,0.00007500000000000018,NULL),(6880,1273,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6881,1273,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6882,1273,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6883,1273,'water_table_depth',NULL,NULL,'mean',NULL,NULL,19,NULL,NULL),(6884,1274,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6885,1274,'mass_relative_mass',6884,6884,'mean','se',5,1,0,NULL),(6886,1274,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(6887,1274,'N_relative_mass',6891,6884,'mean','se',5,0.012077922077922078,0.0005064935064935057,NULL),(6888,1274,'C_relative_mass',6890,6884,'mean','se',5,0.28054862842892764,0.017456359102244336,NULL),(6889,1274,'P_relative_mass',6892,6884,'mean','se',5,0.0011192307692307695,0.00007788461538461532,NULL),(6890,1274,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6891,1274,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6892,1274,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6893,1274,'water_table_depth',NULL,NULL,'mean',NULL,NULL,19,NULL,NULL),(6894,1275,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6895,1275,'mass_relative_mass',6894,6894,'mean','se',5,1,0,NULL),(6896,1275,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(6897,1275,'N_relative_mass',6901,6894,'mean','se',5,0.012740259740259741,0.00046753246753246814,NULL),(6898,1275,'C_relative_mass',6900,6894,'mean','se',5,0.298004987531172,0.016209476309226943,NULL),(6899,1275,'P_relative_mass',6902,6894,'mean','se',5,0.001055769230769231,0.00011250000000000005,NULL),(6900,1275,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6901,1275,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6902,1275,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6903,1275,'water_table_depth',NULL,NULL,'mean',NULL,NULL,19,NULL,NULL),(6904,1276,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6905,1276,'mass_relative_mass',6904,6904,'mean','se',5,1,0,NULL),(6906,1276,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(6907,1276,'N_relative_mass',6911,6904,'mean','se',5,0.012857142857142857,0.0011298701298701292,NULL),(6908,1276,'C_relative_mass',6910,6904,'mean','se',5,0.29675810473815456,0.02992518703241893,NULL),(6909,1276,'P_relative_mass',6912,6904,'mean','se',5,0.0009548076923076927,0.00010673076923076908,NULL),(6910,1276,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6911,1276,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6912,1276,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6913,1276,'water_table_depth',NULL,NULL,'mean',NULL,NULL,19,NULL,NULL),(6914,1277,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6915,1277,'mass_relative_mass',6914,6914,'mean','se',5,1,0,NULL),(6916,1277,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(6917,1277,'N_relative_mass',6921,6914,'mean','se',5,0.005376623376623376,0.00023376623376623407,NULL),(6918,1277,'C_relative_mass',6920,6914,'mean','se',5,0.46134663341645876,0.008728179551122196,NULL),(6919,1277,'P_relative_mass',6922,6914,'mean','se',5,0.00017596153846153852,0.000023076923076923106,NULL),(6920,1277,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6921,1277,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6922,1277,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6923,1277,'water_table_depth',NULL,NULL,'mean',NULL,NULL,19,NULL,NULL),(6924,1278,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6925,1278,'mass_relative_mass',6924,6924,'mean','se',5,1,0,NULL),(6926,1278,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(6927,1278,'N_relative_mass',6931,6924,'mean','se',5,0.005220779220779221,0.0003506493506493511,NULL),(6928,1278,'C_relative_mass',6930,6924,'mean','se',5,0.46009975062344133,0.008728179551122253,NULL),(6929,1278,'P_relative_mass',6932,6924,'mean','se',5,0.00014134615384615387,0.00002307692307692316,NULL),(6930,1278,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6931,1278,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6932,1278,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6933,1278,'water_table_depth',NULL,NULL,'mean',NULL,NULL,19,NULL,NULL),(6934,1279,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6935,1279,'mass_relative_mass',6934,6934,'mean','se',5,1,0,NULL),(6936,1279,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(6937,1279,'N_relative_mass',6941,6934,'mean','se',5,0.004753246753246753,0.0007012987012987022,NULL),(6938,1279,'C_relative_mass',6940,6934,'mean','se',5,0.45635910224438897,0.012468827930174597,NULL),(6939,1279,'P_relative_mass',6942,6934,'mean','se',5,0.00021346153846153856,0.000037500000000000003,NULL),(6940,1279,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6941,1279,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6942,1279,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6943,1279,'water_table_depth',NULL,NULL,'mean',NULL,NULL,19,NULL,NULL),(6944,1280,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6945,1280,'mass_relative_mass',6944,6944,'mean','se',5,1,0,NULL),(6946,1280,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(6947,1280,'N_relative_mass',6951,6944,'mean','se',5,0.005259740259740259,0.00027272727272727247,NULL),(6948,1280,'C_relative_mass',6950,6944,'mean','se',5,0.4588528678304238,0.029925187032419046,NULL),(6949,1280,'P_relative_mass',6952,6944,'mean','se',5,0.00010961538461538475,0.000023076923076922994,NULL),(6950,1280,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6951,1280,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6952,1280,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6953,1280,'water_table_depth',NULL,NULL,'mean',NULL,NULL,19,NULL,NULL),(6954,1281,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6955,1281,'mass_relative_mass',6954,6794,'mean','se',5,0.7514285714285713,0.03142857142857153,NULL),(6956,1281,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(6957,1281,'N_relative_mass',6961,6954,'mean','se',5,0.009194805194805195,0.00035064935064935197,NULL),(6958,1281,'C_relative_mass',6960,6954,'mean','se',5,0.3852867830423939,0.008728179551122196,NULL),(6959,1281,'P_relative_mass',6962,6954,'mean','se',5,0.00041826923076923085,0.00005192307692307707,NULL),(6960,1281,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6961,1281,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6962,1281,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6963,1281,'water_table_depth',NULL,NULL,'mean',NULL,NULL,19,NULL,NULL),(6964,1282,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6965,1282,'mass_relative_mass',6964,6804,'mean','se',5,0.7514285714285713,0.07714285714285708,NULL),(6966,1282,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(6967,1282,'N_relative_mass',6971,6964,'mean','se',5,0.009350649350649349,0.0001948051948051983,NULL),(6968,1282,'C_relative_mass',6970,6964,'mean','se',5,0.3827930174563591,0.00748129675810469,NULL),(6969,1282,'P_relative_mass',6972,6964,'mean','se',5,0.00038365384615384645,0.000028846153846153744,NULL),(6970,1282,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6971,1282,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6972,1282,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6973,1282,'water_table_depth',NULL,NULL,'mean',NULL,NULL,19,NULL,NULL),(6974,1283,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6975,1283,'mass_relative_mass',6974,6814,'mean','se',5,0.7057142857142857,0.04000000000000014,NULL),(6976,1283,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(6977,1283,'N_relative_mass',6981,6974,'mean','se',5,0.009506493506493506,0.0002727272727272734,NULL),(6978,1283,'C_relative_mass',6980,6974,'mean','se',5,0.39027431421446374,0.0062344139650872986,NULL),(6979,1283,'P_relative_mass',6982,6974,'mean','se',5,0.0004932692307692309,0.000043269230769230726,NULL),(6980,1283,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6981,1283,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6982,1283,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6983,1283,'water_table_depth',NULL,NULL,'mean',NULL,NULL,19,NULL,NULL),(6984,1284,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6985,1284,'mass_relative_mass',6984,6824,'mean','se',5,0.7714285714285714,0.022857142857142777,NULL),(6986,1284,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(6987,1284,'N_relative_mass',6991,6984,'mean','se',5,0.01009090909090909,0.00035064935064935197,NULL),(6988,1284,'C_relative_mass',6990,6984,'mean','se',5,0.38778054862842887,0.013715710723192047,NULL),(6989,1284,'P_relative_mass',6992,6984,'mean','se',5,0.0004326923076923079,0.00002596153846153837,NULL),(6990,1284,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6991,1284,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6992,1284,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6993,1284,'water_table_depth',NULL,NULL,'mean',NULL,NULL,19,NULL,NULL),(6994,1285,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(6995,1285,'mass_relative_mass',6994,6834,'mean','se',5,0.8171428571428572,0.01714285714285708,NULL),(6996,1285,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(6997,1285,'N_relative_mass',7001,6994,'mean','se',5,0.006467532467532468,0.00019480519480519475,NULL),(6998,1285,'C_relative_mass',7000,6994,'mean','se',5,0.3940149625935161,0.0062344139650872986,NULL),(6999,1285,'P_relative_mass',7002,6994,'mean','se',5,0.00011538461538461545,0.000017307692307692303,NULL),(7000,1285,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7001,1285,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7002,1285,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7003,1285,'water_table_depth',NULL,NULL,'mean',NULL,NULL,19,NULL,NULL),(7004,1286,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7005,1286,'mass_relative_mass',7004,6844,'mean','se',5,0.8457142857142859,0.042857142857142635,NULL),(7006,1286,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7007,1286,'N_relative_mass',7011,7004,'mean','se',5,0.006701298701298702,0.00003896103896103842,NULL),(7008,1286,'C_relative_mass',7010,7004,'mean','se',5,0.39152119700748117,0.006234413965087242,NULL),(7009,1286,'P_relative_mass',7012,7004,'mean','se',5,0.00013846153846153856,0.00002596153846153848,NULL),(7010,1286,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7011,1286,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7012,1286,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7013,1286,'water_table_depth',NULL,NULL,'mean',NULL,NULL,19,NULL,NULL),(7014,1287,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7015,1287,'mass_relative_mass',7014,6854,'mean','se',5,0.8057142857142857,0.025714285714285693,NULL),(7016,1287,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7017,1287,'N_relative_mass',7021,7014,'mean','se',5,0.006467532467532468,0.00015584415584415546,NULL),(7018,1287,'C_relative_mass',7020,7014,'mean','se',5,0.39775561097256845,0.004987531172069908,NULL),(7019,1287,'P_relative_mass',7022,7014,'mean','se',5,0.00011826923076923088,0.000017307692307692303,NULL),(7020,1287,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7021,1287,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7022,1287,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7023,1287,'water_table_depth',NULL,NULL,'mean',NULL,NULL,19,NULL,NULL),(7024,1288,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7025,1288,'mass_relative_mass',7024,6864,'mean','se',5,0.8685714285714284,0.02,NULL),(7026,1288,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7027,1288,'N_relative_mass',7031,7024,'mean','se',5,0.006857142857142858,0.00011688311688311614,NULL),(7028,1288,'C_relative_mass',7030,7024,'mean','se',5,0.3827930174563591,0.00748129675810469,NULL),(7029,1288,'P_relative_mass',7032,7024,'mean','se',5,0.00009230769230769245,0.000011538461538461497,NULL),(7030,1288,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7031,1288,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7032,1288,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7033,1288,'water_table_depth',NULL,NULL,'mean',NULL,NULL,19,NULL,NULL),(7034,1289,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7035,1289,'mass_relative_mass',7034,6874,'mean','se',5,0.6257142857142857,0.057142857142857294,NULL),(7036,1289,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7037,1289,'N_relative_mass',7041,7034,'mean','se',5,0.012272727272727274,0.00046753246753246814,NULL),(7038,1289,'C_relative_mass',7040,7034,'mean','se',5,0.2892768079800498,0.017456359102244447,NULL),(7039,1289,'P_relative_mass',7042,7034,'mean','se',5,0.0009230769230769232,0.00007500000000000018,NULL),(7040,1289,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7041,1289,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7042,1289,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7043,1289,'water_table_depth',NULL,NULL,'mean',NULL,NULL,19,NULL,NULL),(7044,1290,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7045,1290,'mass_relative_mass',7044,6884,'mean','se',5,0.6657142857142857,0.05714285714285708,NULL),(7046,1290,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7047,1290,'N_relative_mass',7051,7044,'mean','se',5,0.012077922077922078,0.0005064935064935057,NULL),(7048,1290,'C_relative_mass',7050,7044,'mean','se',5,0.28054862842892764,0.017456359102244336,NULL),(7049,1290,'P_relative_mass',7052,7044,'mean','se',5,0.0011192307692307695,0.00007788461538461532,NULL),(7050,1290,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7051,1290,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7052,1290,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7053,1290,'water_table_depth',NULL,NULL,'mean',NULL,NULL,19,NULL,NULL),(7054,1291,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7055,1291,'mass_relative_mass',7054,6894,'mean','se',5,0.5114285714285715,0.05714285714285708,NULL),(7056,1291,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7057,1291,'N_relative_mass',7061,7054,'mean','se',5,0.012740259740259741,0.00046753246753246814,NULL),(7058,1291,'C_relative_mass',7060,7054,'mean','se',5,0.298004987531172,0.016209476309226943,NULL),(7059,1291,'P_relative_mass',7062,7054,'mean','se',5,0.001055769230769231,0.00011250000000000005,NULL),(7060,1291,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7061,1291,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7062,1291,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7063,1291,'water_table_depth',NULL,NULL,'mean',NULL,NULL,19,NULL,NULL),(7064,1292,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7065,1292,'mass_relative_mass',7064,6904,'mean','se',5,0.6314285714285715,0.045714285714285624,NULL),(7066,1292,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7067,1292,'N_relative_mass',7071,7064,'mean','se',5,0.012857142857142857,0.0011298701298701292,NULL),(7068,1292,'C_relative_mass',7070,7064,'mean','se',5,0.29675810473815456,0.02992518703241893,NULL),(7069,1292,'P_relative_mass',7072,7064,'mean','se',5,0.0009548076923076927,0.00010673076923076908,NULL),(7070,1292,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7071,1292,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7072,1292,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7073,1292,'water_table_depth',NULL,NULL,'mean',NULL,NULL,19,NULL,NULL),(7074,1293,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7075,1293,'mass_relative_mass',7074,6914,'mean','se',5,1.062857142857143,0.057142857142857224,NULL),(7076,1293,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7077,1293,'N_relative_mass',7081,7074,'mean','se',5,0.005376623376623376,0.00023376623376623407,NULL),(7078,1293,'C_relative_mass',7080,7074,'mean','se',5,0.46134663341645876,0.008728179551122196,NULL),(7079,1293,'P_relative_mass',7082,7074,'mean','se',5,0.00017596153846153852,0.000023076923076923106,NULL),(7080,1293,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7081,1293,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7082,1293,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7083,1293,'water_table_depth',NULL,NULL,'mean',NULL,NULL,19,NULL,NULL),(7084,1294,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7085,1294,'mass_relative_mass',7084,6924,'mean','se',5,1.0571428571428572,0.03714285714285708,NULL),(7086,1294,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7087,1294,'N_relative_mass',7091,7084,'mean','se',5,0.005220779220779221,0.0003506493506493511,NULL),(7088,1294,'C_relative_mass',7090,7084,'mean','se',5,0.46009975062344133,0.008728179551122253,NULL),(7089,1294,'P_relative_mass',7092,7084,'mean','se',5,0.00014134615384615387,0.00002307692307692316,NULL),(7090,1294,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7091,1294,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7092,1294,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7093,1294,'water_table_depth',NULL,NULL,'mean',NULL,NULL,19,NULL,NULL),(7094,1295,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7095,1295,'mass_relative_mass',7094,6934,'mean','se',5,1.0599999999999998,0.037142857142857366,NULL),(7096,1295,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7097,1295,'N_relative_mass',7101,7094,'mean','se',5,0.004753246753246753,0.0007012987012987022,NULL),(7098,1295,'C_relative_mass',7100,7094,'mean','se',5,0.45635910224438897,0.012468827930174597,NULL),(7099,1295,'P_relative_mass',7102,7094,'mean','se',5,0.00021346153846153856,0.000037500000000000003,NULL),(7100,1295,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7101,1295,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7102,1295,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7103,1295,'water_table_depth',NULL,NULL,'mean',NULL,NULL,19,NULL,NULL),(7104,1296,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7105,1296,'mass_relative_mass',7104,6944,'mean','se',5,1.042857142857143,0.02571428571428555,NULL),(7106,1296,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7107,1296,'N_relative_mass',7111,7104,'mean','se',5,0.005259740259740259,0.00027272727272727247,NULL),(7108,1296,'C_relative_mass',7110,7104,'mean','se',5,0.4588528678304238,0.029925187032419046,NULL),(7109,1296,'P_relative_mass',7112,7104,'mean','se',5,0.00010961538461538475,0.000023076923076922994,NULL),(7110,1296,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7111,1296,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7112,1296,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7113,1296,'water_table_depth',NULL,NULL,'mean',NULL,NULL,19,NULL,NULL),(7114,1303,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7115,1303,'mass_relative_mass',7114,7114,'mean','sd',5,1,0,NULL),(7116,1303,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7117,1303,'C_relative_mass',7118,7114,'mean','sd',5,0.433,0.008,NULL),(7118,1303,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7119,1304,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7120,1304,'mass_relative_mass',7119,7119,'mean','sd',5,1,0,NULL),(7121,1304,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7122,1304,'C_relative_mass',7123,7119,'mean','sd',5,0.442,0.009000000000000001,NULL),(7123,1304,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7124,1305,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7125,1305,'mass_relative_mass',7124,7124,'mean','sd',5,1,0,NULL),(7126,1305,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7127,1305,'C_relative_mass',7128,7124,'mean','sd',5,0.47100000000000003,0.027000000000000003,NULL),(7128,1305,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7129,1306,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7130,1306,'mass_relative_mass',7129,7129,'mean','sd',5,1,0,NULL),(7131,1306,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7132,1306,'C_relative_mass',7133,7129,'mean','sd',5,0.484,0.027000000000000003,NULL),(7133,1306,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7134,1307,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7135,1307,'mass_relative_mass',7134,7134,'mean','sd',5,1,0,NULL),(7136,1307,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7137,1307,'C_relative_mass',7138,7134,'mean','sd',5,0.519,0.018000000000000002,NULL),(7138,1307,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7139,1308,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7140,1308,'mass_relative_mass',7139,7139,'mean','sd',5,1,0,NULL),(7141,1308,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7142,1308,'C_relative_mass',7143,7139,'mean','sd',5,0.45399999999999996,0.008,NULL),(7143,1308,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7144,1309,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7145,1309,'mass_relative_mass',7144,7114,'mean','sd',3,0.892,0.011000000000000001,NULL),(7146,1309,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7147,1309,'C_relative_mass',7148,7144,'mean','sd',3,0.39899999999999997,0.006999999999999999,NULL),(7148,1309,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7149,1310,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7150,1310,'mass_relative_mass',7149,7119,'mean','sd',3,0.831,0.015,NULL),(7151,1310,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7152,1310,'C_relative_mass',7153,7149,'mean','sd',3,0.39799999999999996,0.006999999999999999,NULL),(7153,1310,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7154,1311,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7155,1311,'mass_relative_mass',7154,7124,'mean','sd',3,0.371,0.013999999999999999,NULL),(7156,1311,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7157,1311,'C_relative_mass',7158,7154,'mean','sd',3,0.43,0.012,NULL),(7158,1311,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7159,1312,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7160,1312,'mass_relative_mass',7159,7129,'mean','sd',3,0.39,0.024,NULL),(7161,1312,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7162,1312,'C_relative_mass',7163,7159,'mean','sd',3,0.44799999999999995,0.027000000000000003,NULL),(7163,1312,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7164,1313,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7165,1313,'mass_relative_mass',7164,7134,'mean','sd',3,0.302,0.024,NULL),(7166,1313,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7167,1313,'C_relative_mass',7168,7164,'mean','sd',3,0.49,0.036000000000000004,NULL),(7168,1313,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7169,1314,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7170,1314,'mass_relative_mass',7169,7139,'mean','sd',3,0.08199999999999999,0.016,NULL),(7171,1314,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7172,1314,'C_relative_mass',7173,7169,'mean','sd',3,0.446,0.017,NULL),(7173,1314,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7174,1330,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7175,1330,'mass_relative_mass',7174,7174,'mean','sd',7,1,0,NULL),(7176,1330,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7177,1330,'N_relative_mass',7181,7174,'mean',NULL,NULL,0.011,NULL,NULL),(7178,1330,'C_relative_mass',7180,7174,'mean',NULL,NULL,0.4447,NULL,NULL),(7179,1330,'P_relative_mass',7182,7174,'mean',NULL,NULL,0.00044,NULL,NULL),(7180,1330,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7181,1330,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7182,1330,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7183,1331,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7184,1331,'mass_relative_mass',7183,7183,'mean','sd',7,1,0,NULL),(7185,1331,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7186,1331,'N_relative_mass',7190,7183,'mean',NULL,NULL,0.0156,NULL,NULL),(7187,1331,'C_relative_mass',7189,7183,'mean',NULL,NULL,0.45289999999999997,NULL,NULL),(7188,1331,'P_relative_mass',7191,7183,'mean',NULL,NULL,0.00082,NULL,NULL),(7189,1331,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7190,1331,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7191,1331,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7192,1332,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7193,1332,'mass_relative_mass',7192,7192,'mean','sd',7,1,0,NULL),(7194,1332,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7195,1332,'N_relative_mass',7199,7192,'mean',NULL,NULL,0.0167,NULL,NULL),(7196,1332,'C_relative_mass',7198,7192,'mean',NULL,NULL,0.4582,NULL,NULL),(7197,1332,'P_relative_mass',7200,7192,'mean',NULL,NULL,0.00093,NULL,NULL),(7198,1332,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7199,1332,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7200,1332,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7201,1333,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7202,1333,'mass_relative_mass',7201,7201,'mean','sd',7,1,0,NULL),(7203,1333,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7204,1333,'N_relative_mass',7208,7201,'mean',NULL,NULL,0.0115,NULL,NULL),(7205,1333,'C_relative_mass',7207,7201,'mean',NULL,NULL,0.4572,NULL,NULL),(7206,1333,'P_relative_mass',7209,7201,'mean',NULL,NULL,0.00075,NULL,NULL),(7207,1333,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7208,1333,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7209,1333,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7210,1334,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7211,1334,'mass_relative_mass',7210,7210,'mean','sd',7,1,0,NULL),(7212,1334,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7213,1334,'N_relative_mass',7217,7210,'mean',NULL,NULL,0.0066,NULL,NULL),(7214,1334,'C_relative_mass',7216,7210,'mean',NULL,NULL,0.4581,NULL,NULL),(7215,1334,'P_relative_mass',7218,7210,'mean',NULL,NULL,0.0005,NULL,NULL),(7216,1334,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7217,1334,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7218,1334,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7219,1335,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7220,1335,'mass_relative_mass',7219,7219,'mean','sd',7,1,0,NULL),(7221,1335,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7222,1335,'N_relative_mass',7226,7219,'mean',NULL,NULL,0.0088,NULL,NULL),(7223,1335,'C_relative_mass',7225,7219,'mean',NULL,NULL,0.4776,NULL,NULL),(7224,1335,'P_relative_mass',7227,7219,'mean',NULL,NULL,0.00039,NULL,NULL),(7225,1335,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7226,1335,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7227,1335,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7228,1336,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7229,1336,'mass_relative_mass',7228,7228,'mean','sd',7,1,0,NULL),(7230,1336,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7231,1336,'N_relative_mass',7235,7228,'mean',NULL,NULL,0.0066,NULL,NULL),(7232,1336,'C_relative_mass',7234,7228,'mean',NULL,NULL,0.48,NULL,NULL),(7233,1336,'P_relative_mass',7236,7228,'mean',NULL,NULL,0.00016,NULL,NULL),(7234,1336,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7235,1336,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7236,1336,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7237,1337,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7238,1337,'mass_relative_mass',7237,7237,'mean','sd',7,1,0,NULL),(7239,1337,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7240,1337,'N_relative_mass',7244,7237,'mean',NULL,NULL,0.0057,NULL,NULL),(7241,1337,'C_relative_mass',7243,7237,'mean',NULL,NULL,0.4602,NULL,NULL),(7242,1337,'P_relative_mass',7245,7237,'mean',NULL,NULL,0.00031,NULL,NULL),(7243,1337,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7244,1337,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7245,1337,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7246,1338,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7247,1338,'mass_relative_mass',7246,7246,'mean','sd',7,1,0,NULL),(7248,1338,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7249,1338,'N_relative_mass',7253,7246,'mean',NULL,NULL,0.0074,NULL,NULL),(7250,1338,'C_relative_mass',7252,7246,'mean',NULL,NULL,0.481,NULL,NULL),(7251,1338,'P_relative_mass',7254,7246,'mean',NULL,NULL,0.00028000000000000003,NULL,NULL),(7252,1338,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7253,1338,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7254,1338,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7255,1339,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7256,1339,'mass_relative_mass',7255,7255,'mean','sd',7,1,0,NULL),(7257,1339,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7258,1339,'N_relative_mass',7262,7255,'mean',NULL,NULL,0.0088,NULL,NULL),(7259,1339,'C_relative_mass',7261,7255,'mean',NULL,NULL,0.4682,NULL,NULL),(7260,1339,'P_relative_mass',7263,7255,'mean',NULL,NULL,0.00051,NULL,NULL),(7261,1339,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7262,1339,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7263,1339,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7264,1340,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7265,1340,'mass_relative_mass',7264,7264,'mean','sd',7,1,0,NULL),(7266,1340,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7267,1340,'N_relative_mass',7271,7264,'mean',NULL,NULL,0.0145,NULL,NULL),(7268,1340,'C_relative_mass',7270,7264,'mean',NULL,NULL,0.4818,NULL,NULL),(7269,1340,'P_relative_mass',7272,7264,'mean',NULL,NULL,0.0007,NULL,NULL),(7270,1340,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7271,1340,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7272,1340,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7273,1341,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7274,1341,'mass_relative_mass',7273,7273,'mean','sd',7,1,0,NULL),(7275,1341,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7276,1341,'N_relative_mass',7280,7273,'mean',NULL,NULL,0.0062,NULL,NULL),(7277,1341,'C_relative_mass',7279,7273,'mean',NULL,NULL,0.4632,NULL,NULL),(7278,1341,'P_relative_mass',7281,7273,'mean',NULL,NULL,0.00046,NULL,NULL),(7279,1341,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7280,1341,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7281,1341,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7282,1342,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7283,1342,'mass_relative_mass',7282,7282,'mean','sd',7,1,0,NULL),(7284,1342,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7285,1342,'N_relative_mass',7289,7282,'mean',NULL,NULL,0.009,NULL,NULL),(7286,1342,'C_relative_mass',7288,7282,'mean',NULL,NULL,0.4648,NULL,NULL),(7287,1342,'P_relative_mass',7290,7282,'mean',NULL,NULL,0.00062,NULL,NULL),(7288,1342,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7289,1342,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7290,1342,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7291,1343,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7292,1343,'mass_relative_mass',7291,7291,'mean','sd',7,1,0,NULL),(7293,1343,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7294,1343,'N_relative_mass',7298,7291,'mean',NULL,NULL,0.0111,NULL,NULL),(7295,1343,'C_relative_mass',7297,7291,'mean',NULL,NULL,0.4123,NULL,NULL),(7296,1343,'P_relative_mass',7299,7291,'mean',NULL,NULL,0.00068,NULL,NULL),(7297,1343,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7298,1343,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7299,1343,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7300,1344,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7301,1344,'mass_relative_mass',7300,7300,'mean','sd',7,1,0,NULL),(7302,1344,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7303,1344,'N_relative_mass',7307,7300,'mean',NULL,NULL,0.0252,NULL,NULL),(7304,1344,'C_relative_mass',7306,7300,'mean',NULL,NULL,0.517,NULL,NULL),(7305,1344,'P_relative_mass',7308,7300,'mean',NULL,NULL,0.0007199999999999999,NULL,NULL),(7306,1344,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7307,1344,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7308,1344,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7309,1345,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7310,1345,'mass_relative_mass',7309,7174,'mean','sd',7,0.8183962264150941,0.058962264150943466,NULL),(7311,1345,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7312,1345,'N_relative_mass',7316,7309,'mean',NULL,NULL,NULL,NULL,NULL),(7313,1345,'C_relative_mass',7315,7309,'mean',NULL,NULL,NULL,NULL,NULL),(7314,1345,'P_relative_mass',7317,7309,'mean',NULL,NULL,NULL,NULL,NULL),(7315,1345,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7316,1345,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7317,1345,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7318,1346,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7319,1346,'mass_relative_mass',7318,7183,'mean','sd',7,0.7995283018867922,0.028301886792452678,NULL),(7320,1346,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7321,1346,'N_relative_mass',7325,7318,'mean',NULL,NULL,NULL,NULL,NULL),(7322,1346,'C_relative_mass',7324,7318,'mean',NULL,NULL,NULL,NULL,NULL),(7323,1346,'P_relative_mass',7326,7318,'mean',NULL,NULL,NULL,NULL,NULL),(7324,1346,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7325,1346,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7326,1346,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7327,1347,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7328,1347,'mass_relative_mass',7327,7192,'mean','sd',7,0.7806603773584904,0.03773584905660371,NULL),(7329,1347,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7330,1347,'N_relative_mass',7334,7327,'mean',NULL,NULL,NULL,NULL,NULL),(7331,1347,'C_relative_mass',7333,7327,'mean',NULL,NULL,NULL,NULL,NULL),(7332,1347,'P_relative_mass',7335,7327,'mean',NULL,NULL,NULL,NULL,NULL),(7333,1347,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7334,1347,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7335,1347,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7336,1348,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7337,1348,'mass_relative_mass',7336,7201,'mean','sd',7,0.7759433962264147,0.03537735849056617,NULL),(7338,1348,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7339,1348,'N_relative_mass',7343,7336,'mean',NULL,NULL,NULL,NULL,NULL),(7340,1348,'C_relative_mass',7342,7336,'mean',NULL,NULL,NULL,NULL,NULL),(7341,1348,'P_relative_mass',7344,7336,'mean',NULL,NULL,NULL,NULL,NULL),(7342,1348,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7343,1348,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7344,1348,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7345,1349,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7346,1349,'mass_relative_mass',7345,7210,'mean','sd',7,0.7452830188679244,0.05896226415094333,NULL),(7347,1349,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7348,1349,'N_relative_mass',7352,7345,'mean',NULL,NULL,NULL,NULL,NULL),(7349,1349,'C_relative_mass',7351,7345,'mean',NULL,NULL,NULL,NULL,NULL),(7350,1349,'P_relative_mass',7353,7345,'mean',NULL,NULL,NULL,NULL,NULL),(7351,1349,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7352,1349,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7353,1349,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7354,1350,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7355,1350,'mass_relative_mass',7354,7219,'mean','sd',7,0.6061320754716979,0.1391509433962264,NULL),(7356,1350,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7357,1350,'N_relative_mass',7361,7354,'mean',NULL,NULL,NULL,NULL,NULL),(7358,1350,'C_relative_mass',7360,7354,'mean',NULL,NULL,NULL,NULL,NULL),(7359,1350,'P_relative_mass',7362,7354,'mean',NULL,NULL,NULL,NULL,NULL),(7360,1350,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7361,1350,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7362,1350,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7363,1351,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7364,1351,'mass_relative_mass',7363,7228,'mean','sd',7,0.55188679245283,0.02594339622641513,NULL),(7365,1351,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7366,1351,'N_relative_mass',7370,7363,'mean',NULL,NULL,NULL,NULL,NULL),(7367,1351,'C_relative_mass',7369,7363,'mean',NULL,NULL,NULL,NULL,NULL),(7368,1351,'P_relative_mass',7371,7363,'mean',NULL,NULL,NULL,NULL,NULL),(7369,1351,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7370,1351,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7371,1351,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7372,1352,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7373,1352,'mass_relative_mass',7372,7237,'mean','sd',7,0.5047169811320754,0.08962264150943383,NULL),(7374,1352,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7375,1352,'N_relative_mass',7379,7372,'mean',NULL,NULL,NULL,NULL,NULL),(7376,1352,'C_relative_mass',7378,7372,'mean',NULL,NULL,NULL,NULL,NULL),(7377,1352,'P_relative_mass',7380,7372,'mean',NULL,NULL,NULL,NULL,NULL),(7378,1352,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7379,1352,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7380,1352,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7381,1353,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7382,1353,'mass_relative_mass',7381,7246,'mean','sd',7,0.48349056603773577,0.12028301886792449,NULL),(7383,1353,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7384,1353,'N_relative_mass',7388,7381,'mean',NULL,NULL,NULL,NULL,NULL),(7385,1353,'C_relative_mass',7387,7381,'mean',NULL,NULL,NULL,NULL,NULL),(7386,1353,'P_relative_mass',7389,7381,'mean',NULL,NULL,NULL,NULL,NULL),(7387,1353,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7388,1353,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7389,1353,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7390,1354,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7391,1354,'mass_relative_mass',7390,7255,'mean','sd',7,0.4787735849056601,0.06132075471698115,NULL),(7392,1354,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7393,1354,'N_relative_mass',7397,7390,'mean',NULL,NULL,NULL,NULL,NULL),(7394,1354,'C_relative_mass',7396,7390,'mean',NULL,NULL,NULL,NULL,NULL),(7395,1354,'P_relative_mass',7398,7390,'mean',NULL,NULL,NULL,NULL,NULL),(7396,1354,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7397,1354,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7398,1354,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7399,1355,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7400,1355,'mass_relative_mass',7399,7264,'mean','sd',7,0.26415094339622625,0.04009433962264154,NULL),(7401,1355,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7402,1355,'N_relative_mass',7406,7399,'mean',NULL,NULL,NULL,NULL,NULL),(7403,1355,'C_relative_mass',7405,7399,'mean',NULL,NULL,NULL,NULL,NULL),(7404,1355,'P_relative_mass',7407,7399,'mean',NULL,NULL,NULL,NULL,NULL),(7405,1355,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7406,1355,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7407,1355,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7408,1356,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7409,1356,'mass_relative_mass',7408,7273,'mean','sd',7,0.2334905660377357,0.04716981132075475,NULL),(7410,1356,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7411,1356,'N_relative_mass',7415,7408,'mean',NULL,NULL,NULL,NULL,NULL),(7412,1356,'C_relative_mass',7414,7408,'mean',NULL,NULL,NULL,NULL,NULL),(7413,1356,'P_relative_mass',7416,7408,'mean',NULL,NULL,NULL,NULL,NULL),(7414,1356,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7415,1356,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7416,1356,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7417,1357,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7418,1357,'mass_relative_mass',7417,7282,'mean','sd',7,0.15330188679245269,0.037735849056603786,NULL),(7419,1357,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7420,1357,'N_relative_mass',7424,7417,'mean',NULL,NULL,NULL,NULL,NULL),(7421,1357,'C_relative_mass',7423,7417,'mean',NULL,NULL,NULL,NULL,NULL),(7422,1357,'P_relative_mass',7425,7417,'mean',NULL,NULL,NULL,NULL,NULL),(7423,1357,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7424,1357,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7425,1357,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7426,1358,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7427,1358,'mass_relative_mass',7426,7291,'mean','sd',7,0.08726415094339607,0.018867924528301855,NULL),(7428,1358,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7429,1358,'N_relative_mass',7433,7426,'mean',NULL,NULL,NULL,NULL,NULL),(7430,1358,'C_relative_mass',7432,7426,'mean',NULL,NULL,NULL,NULL,NULL),(7431,1358,'P_relative_mass',7434,7426,'mean',NULL,NULL,NULL,NULL,NULL),(7432,1358,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7433,1358,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7434,1358,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7435,1359,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7436,1359,'mass_relative_mass',7435,7300,'mean','sd',7,0.4551886792452828,0.06132075471698115,NULL),(7437,1359,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,0.5,NULL,NULL),(7438,1359,'N_relative_mass',7442,7435,'mean',NULL,NULL,NULL,NULL,NULL),(7439,1359,'C_relative_mass',7441,7435,'mean',NULL,NULL,NULL,NULL,NULL),(7440,1359,'P_relative_mass',7443,7435,'mean',NULL,NULL,NULL,NULL,NULL),(7441,1359,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7442,1359,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7443,1359,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7444,1484,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7445,1484,'mass_relative_mass',7444,7444,'mean','se',NULL,1,0,NULL),(7446,1484,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(7447,1484,'ash_mass_relative_mass',7484,7444,'mean',NULL,NULL,NULL,NULL,NULL),(7448,1484,'N_relative_mass',7485,7444,'mean',NULL,NULL,NULL,NULL,NULL),(7449,1484,'P_relative_mass',7486,7444,'mean',NULL,NULL,NULL,NULL,NULL),(7450,1484,'Ca_relative_mass',7487,7444,'mean',NULL,NULL,NULL,NULL,NULL),(7451,1484,'K_relative_mass',7488,7444,'mean',NULL,NULL,NULL,NULL,NULL),(7452,1484,'Mg_relative_mass',7489,7444,'mean',NULL,NULL,NULL,NULL,NULL),(7453,1484,'Mn_relative_mass',7490,7444,'mean',NULL,NULL,NULL,NULL,NULL),(7454,1484,'C_relative_mass',7491,7444,'mean',NULL,NULL,NULL,NULL,NULL),(7455,1484,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7456,1484,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7457,1484,'dichloromethane_extractives_mass_relative_mass',7492,7444,'mean',NULL,NULL,NULL,NULL,NULL),(7458,1484,'acetone_extractives_mass_relative_mass',7493,7444,'mean',NULL,NULL,NULL,NULL,NULL),(7459,1484,'ethanol_extractives_mass_relative_mass',7494,7444,'mean',NULL,NULL,NULL,NULL,NULL),(7460,1484,'water_extractives_mass_relative_mass',7495,7444,'mean',NULL,NULL,NULL,NULL,NULL),(7461,1484,'cellulose_mass_relative_mass',7496,7444,'mean',NULL,NULL,NULL,NULL,NULL),(7462,1484,'arabinose_mass_relative_mass',7497,7444,'mean',NULL,NULL,NULL,NULL,NULL),(7463,1484,'rhamnose_mass_relative_mass',7498,7444,'mean',NULL,NULL,NULL,NULL,NULL),(7464,1484,'xylose_mass_relative_mass',7499,7444,'mean',NULL,NULL,NULL,NULL,NULL),(7465,1484,'mannose_mass_relative_mass',7500,7444,'mean',NULL,NULL,NULL,NULL,NULL),(7466,1484,'galactose_mass_relative_mass',7501,7444,'mean',NULL,NULL,NULL,NULL,NULL),(7467,1484,'glucose_mass_relative_mass',7502,7444,'mean',NULL,NULL,NULL,NULL,NULL),(7468,1484,'glucuronic_acid_mass_relative_mass',7503,7444,'mean',NULL,NULL,NULL,NULL,NULL),(7469,1484,'galacturonic_acid_mass_relative_mass',7504,7444,'mean',NULL,NULL,NULL,NULL,NULL),(7470,1484,'holocellulose_mass_relative_mass',7505,7444,'mean',NULL,NULL,NULL,NULL,NULL),(7471,1484,'4_hydroxybenzaldehyde_mass_relative_mass',7506,7444,'mean',NULL,NULL,NULL,NULL,NULL),(7472,1484,'4_hydroxyacetophenone_mass_relative_mass',7507,7444,'mean',NULL,NULL,NULL,NULL,NULL),(7473,1484,'4_hydroxybenzoic_acid_mass_relative_mass',7508,7444,'mean',NULL,NULL,NULL,NULL,NULL),(7474,1484,'vanillin_mass_relative_mass',7509,7444,'mean',NULL,NULL,NULL,NULL,NULL),(7475,1484,'vanillic_acid_mass_relative_mass',7510,7444,'mean',NULL,NULL,NULL,NULL,NULL),(7476,1484,'acetovanillone_mass_relative_mass',7511,7444,'mean',NULL,NULL,NULL,NULL,NULL),(7477,1484,'syringe_aldehyde_mass_relative_mass',7512,7444,'mean',NULL,NULL,NULL,NULL,NULL),(7478,1484,'acetosyringone_mass_relative_mass',7513,7444,'mean',NULL,NULL,NULL,NULL,NULL),(7479,1484,'syringic_acid_mass_relative_mass',7514,7444,'mean',NULL,NULL,NULL,NULL,NULL),(7480,1484,'p_coumaric_acid_mass_relative_mass',7515,7444,'mean',NULL,NULL,NULL,NULL,NULL),(7481,1484,'ferulic_acid_mass_relative_mass',7516,7444,'mean',NULL,NULL,NULL,NULL,NULL),(7482,1484,'Klason_lignin_mass_relative_mass',7517,7444,'mean',NULL,NULL,NULL,NULL,NULL),(7483,1484,'soluble_lignin_mass_relative_mass',7518,7444,'mean',NULL,NULL,NULL,NULL,NULL),(7484,1484,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7485,1484,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7486,1484,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7487,1484,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7488,1484,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7489,1484,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7490,1484,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7491,1484,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7492,1484,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7493,1484,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7494,1484,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7495,1484,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7496,1484,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7497,1484,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7498,1484,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7499,1484,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7500,1484,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7501,1484,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7502,1484,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7503,1484,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7504,1484,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7505,1484,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7506,1484,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7507,1484,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7508,1484,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7509,1484,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7510,1484,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7511,1484,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7512,1484,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7513,1484,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7514,1484,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7515,1484,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7516,1484,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7517,1484,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7518,1484,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7519,1485,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7520,1485,'mass_relative_mass',7519,7519,'mean','se',NULL,1,0,NULL),(7521,1485,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(7522,1485,'ash_mass_relative_mass',7559,7519,'mean',NULL,NULL,NULL,NULL,NULL),(7523,1485,'N_relative_mass',7560,7519,'mean',NULL,NULL,NULL,NULL,NULL),(7524,1485,'P_relative_mass',7561,7519,'mean',NULL,NULL,NULL,NULL,NULL),(7525,1485,'Ca_relative_mass',7562,7519,'mean',NULL,NULL,NULL,NULL,NULL),(7526,1485,'K_relative_mass',7563,7519,'mean',NULL,NULL,NULL,NULL,NULL),(7527,1485,'Mg_relative_mass',7564,7519,'mean',NULL,NULL,NULL,NULL,NULL),(7528,1485,'Mn_relative_mass',7565,7519,'mean',NULL,NULL,NULL,NULL,NULL),(7529,1485,'C_relative_mass',7566,7519,'mean',NULL,NULL,NULL,NULL,NULL),(7530,1485,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7531,1485,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7532,1485,'dichloromethane_extractives_mass_relative_mass',7567,7519,'mean',NULL,NULL,NULL,NULL,NULL),(7533,1485,'acetone_extractives_mass_relative_mass',7568,7519,'mean',NULL,NULL,NULL,NULL,NULL),(7534,1485,'ethanol_extractives_mass_relative_mass',7569,7519,'mean',NULL,NULL,NULL,NULL,NULL),(7535,1485,'water_extractives_mass_relative_mass',7570,7519,'mean',NULL,NULL,NULL,NULL,NULL),(7536,1485,'cellulose_mass_relative_mass',7571,7519,'mean',NULL,NULL,NULL,NULL,NULL),(7537,1485,'arabinose_mass_relative_mass',7572,7519,'mean',NULL,NULL,NULL,NULL,NULL),(7538,1485,'rhamnose_mass_relative_mass',7573,7519,'mean',NULL,NULL,NULL,NULL,NULL),(7539,1485,'xylose_mass_relative_mass',7574,7519,'mean',NULL,NULL,NULL,NULL,NULL),(7540,1485,'mannose_mass_relative_mass',7575,7519,'mean',NULL,NULL,NULL,NULL,NULL),(7541,1485,'galactose_mass_relative_mass',7576,7519,'mean',NULL,NULL,NULL,NULL,NULL),(7542,1485,'glucose_mass_relative_mass',7577,7519,'mean',NULL,NULL,NULL,NULL,NULL),(7543,1485,'glucuronic_acid_mass_relative_mass',7578,7519,'mean',NULL,NULL,NULL,NULL,NULL),(7544,1485,'galacturonic_acid_mass_relative_mass',7579,7519,'mean',NULL,NULL,NULL,NULL,NULL),(7545,1485,'holocellulose_mass_relative_mass',7580,7519,'mean',NULL,NULL,NULL,NULL,NULL),(7546,1485,'4_hydroxybenzaldehyde_mass_relative_mass',7581,7519,'mean',NULL,NULL,NULL,NULL,NULL),(7547,1485,'4_hydroxyacetophenone_mass_relative_mass',7582,7519,'mean',NULL,NULL,NULL,NULL,NULL),(7548,1485,'4_hydroxybenzoic_acid_mass_relative_mass',7583,7519,'mean',NULL,NULL,NULL,NULL,NULL),(7549,1485,'vanillin_mass_relative_mass',7584,7519,'mean',NULL,NULL,NULL,NULL,NULL),(7550,1485,'vanillic_acid_mass_relative_mass',7585,7519,'mean',NULL,NULL,NULL,NULL,NULL),(7551,1485,'acetovanillone_mass_relative_mass',7586,7519,'mean',NULL,NULL,NULL,NULL,NULL),(7552,1485,'syringe_aldehyde_mass_relative_mass',7587,7519,'mean',NULL,NULL,NULL,NULL,NULL),(7553,1485,'acetosyringone_mass_relative_mass',7588,7519,'mean',NULL,NULL,NULL,NULL,NULL),(7554,1485,'syringic_acid_mass_relative_mass',7589,7519,'mean',NULL,NULL,NULL,NULL,NULL),(7555,1485,'p_coumaric_acid_mass_relative_mass',7590,7519,'mean',NULL,NULL,NULL,NULL,NULL),(7556,1485,'ferulic_acid_mass_relative_mass',7591,7519,'mean',NULL,NULL,NULL,NULL,NULL),(7557,1485,'Klason_lignin_mass_relative_mass',7592,7519,'mean',NULL,NULL,NULL,NULL,NULL),(7558,1485,'soluble_lignin_mass_relative_mass',7593,7519,'mean',NULL,NULL,NULL,NULL,NULL),(7559,1485,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7560,1485,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7561,1485,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7562,1485,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7563,1485,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7564,1485,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7565,1485,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7566,1485,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7567,1485,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7568,1485,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7569,1485,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7570,1485,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7571,1485,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7572,1485,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7573,1485,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7574,1485,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7575,1485,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7576,1485,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7577,1485,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7578,1485,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7579,1485,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7580,1485,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7581,1485,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7582,1485,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7583,1485,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7584,1485,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7585,1485,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7586,1485,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7587,1485,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7588,1485,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7589,1485,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7590,1485,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7591,1485,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7592,1485,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7593,1485,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7594,1486,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7595,1486,'mass_relative_mass',7594,7594,'mean','se',NULL,1,0,NULL),(7596,1486,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(7597,1486,'ash_mass_relative_mass',7634,7594,'mean',NULL,NULL,NULL,NULL,NULL),(7598,1486,'N_relative_mass',7635,7594,'mean',NULL,NULL,NULL,NULL,NULL),(7599,1486,'P_relative_mass',7636,7594,'mean',NULL,NULL,NULL,NULL,NULL),(7600,1486,'Ca_relative_mass',7637,7594,'mean',NULL,NULL,NULL,NULL,NULL),(7601,1486,'K_relative_mass',7638,7594,'mean',NULL,NULL,NULL,NULL,NULL),(7602,1486,'Mg_relative_mass',7639,7594,'mean',NULL,NULL,NULL,NULL,NULL),(7603,1486,'Mn_relative_mass',7640,7594,'mean',NULL,NULL,NULL,NULL,NULL),(7604,1486,'C_relative_mass',7641,7594,'mean',NULL,NULL,NULL,NULL,NULL),(7605,1486,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7606,1486,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7607,1486,'dichloromethane_extractives_mass_relative_mass',7642,7594,'mean',NULL,NULL,NULL,NULL,NULL),(7608,1486,'acetone_extractives_mass_relative_mass',7643,7594,'mean',NULL,NULL,NULL,NULL,NULL),(7609,1486,'ethanol_extractives_mass_relative_mass',7644,7594,'mean',NULL,NULL,NULL,NULL,NULL),(7610,1486,'water_extractives_mass_relative_mass',7645,7594,'mean',NULL,NULL,NULL,NULL,NULL),(7611,1486,'cellulose_mass_relative_mass',7646,7594,'mean',NULL,NULL,NULL,NULL,NULL),(7612,1486,'arabinose_mass_relative_mass',7647,7594,'mean',NULL,NULL,NULL,NULL,NULL),(7613,1486,'rhamnose_mass_relative_mass',7648,7594,'mean',NULL,NULL,NULL,NULL,NULL),(7614,1486,'xylose_mass_relative_mass',7649,7594,'mean',NULL,NULL,NULL,NULL,NULL),(7615,1486,'mannose_mass_relative_mass',7650,7594,'mean',NULL,NULL,NULL,NULL,NULL),(7616,1486,'galactose_mass_relative_mass',7651,7594,'mean',NULL,NULL,NULL,NULL,NULL),(7617,1486,'glucose_mass_relative_mass',7652,7594,'mean',NULL,NULL,NULL,NULL,NULL),(7618,1486,'glucuronic_acid_mass_relative_mass',7653,7594,'mean',NULL,NULL,NULL,NULL,NULL),(7619,1486,'galacturonic_acid_mass_relative_mass',7654,7594,'mean',NULL,NULL,NULL,NULL,NULL),(7620,1486,'holocellulose_mass_relative_mass',7655,7594,'mean',NULL,NULL,NULL,NULL,NULL),(7621,1486,'4_hydroxybenzaldehyde_mass_relative_mass',7656,7594,'mean',NULL,NULL,NULL,NULL,NULL),(7622,1486,'4_hydroxyacetophenone_mass_relative_mass',7657,7594,'mean',NULL,NULL,NULL,NULL,NULL),(7623,1486,'4_hydroxybenzoic_acid_mass_relative_mass',7658,7594,'mean',NULL,NULL,NULL,NULL,NULL),(7624,1486,'vanillin_mass_relative_mass',7659,7594,'mean',NULL,NULL,NULL,NULL,NULL),(7625,1486,'vanillic_acid_mass_relative_mass',7660,7594,'mean',NULL,NULL,NULL,NULL,NULL),(7626,1486,'acetovanillone_mass_relative_mass',7661,7594,'mean',NULL,NULL,NULL,NULL,NULL),(7627,1486,'syringe_aldehyde_mass_relative_mass',7662,7594,'mean',NULL,NULL,NULL,NULL,NULL),(7628,1486,'acetosyringone_mass_relative_mass',7663,7594,'mean',NULL,NULL,NULL,NULL,NULL),(7629,1486,'syringic_acid_mass_relative_mass',7664,7594,'mean',NULL,NULL,NULL,NULL,NULL),(7630,1486,'p_coumaric_acid_mass_relative_mass',7665,7594,'mean',NULL,NULL,NULL,NULL,NULL),(7631,1486,'ferulic_acid_mass_relative_mass',7666,7594,'mean',NULL,NULL,NULL,NULL,NULL),(7632,1486,'Klason_lignin_mass_relative_mass',7667,7594,'mean',NULL,NULL,NULL,NULL,NULL),(7633,1486,'soluble_lignin_mass_relative_mass',7668,7594,'mean',NULL,NULL,NULL,NULL,NULL),(7634,1486,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7635,1486,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7636,1486,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7637,1486,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7638,1486,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7639,1486,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7640,1486,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7641,1486,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7642,1486,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7643,1486,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7644,1486,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7645,1486,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7646,1486,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7647,1486,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7648,1486,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7649,1486,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7650,1486,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7651,1486,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7652,1486,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7653,1486,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7654,1486,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7655,1486,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7656,1486,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7657,1486,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7658,1486,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7659,1486,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7660,1486,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7661,1486,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7662,1486,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7663,1486,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7664,1486,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7665,1486,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7666,1486,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7667,1486,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7668,1486,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7669,1487,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7670,1487,'mass_relative_mass',7669,7669,'mean','se',NULL,1,0,NULL),(7671,1487,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(7672,1487,'ash_mass_relative_mass',7709,7669,'mean',NULL,NULL,NULL,NULL,NULL),(7673,1487,'N_relative_mass',7710,7669,'mean',NULL,NULL,NULL,NULL,NULL),(7674,1487,'P_relative_mass',7711,7669,'mean',NULL,NULL,NULL,NULL,NULL),(7675,1487,'Ca_relative_mass',7712,7669,'mean',NULL,NULL,NULL,NULL,NULL),(7676,1487,'K_relative_mass',7713,7669,'mean',NULL,NULL,NULL,NULL,NULL),(7677,1487,'Mg_relative_mass',7714,7669,'mean',NULL,NULL,NULL,NULL,NULL),(7678,1487,'Mn_relative_mass',7715,7669,'mean',NULL,NULL,NULL,NULL,NULL),(7679,1487,'C_relative_mass',7716,7669,'mean',NULL,NULL,NULL,NULL,NULL),(7680,1487,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7681,1487,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7682,1487,'dichloromethane_extractives_mass_relative_mass',7717,7669,'mean',NULL,NULL,NULL,NULL,NULL),(7683,1487,'acetone_extractives_mass_relative_mass',7718,7669,'mean',NULL,NULL,NULL,NULL,NULL),(7684,1487,'ethanol_extractives_mass_relative_mass',7719,7669,'mean',NULL,NULL,NULL,NULL,NULL),(7685,1487,'water_extractives_mass_relative_mass',7720,7669,'mean',NULL,NULL,NULL,NULL,NULL),(7686,1487,'cellulose_mass_relative_mass',7721,7669,'mean',NULL,NULL,NULL,NULL,NULL),(7687,1487,'arabinose_mass_relative_mass',7722,7669,'mean',NULL,NULL,NULL,NULL,NULL),(7688,1487,'rhamnose_mass_relative_mass',7723,7669,'mean',NULL,NULL,NULL,NULL,NULL),(7689,1487,'xylose_mass_relative_mass',7724,7669,'mean',NULL,NULL,NULL,NULL,NULL),(7690,1487,'mannose_mass_relative_mass',7725,7669,'mean',NULL,NULL,NULL,NULL,NULL),(7691,1487,'galactose_mass_relative_mass',7726,7669,'mean',NULL,NULL,NULL,NULL,NULL),(7692,1487,'glucose_mass_relative_mass',7727,7669,'mean',NULL,NULL,NULL,NULL,NULL),(7693,1487,'glucuronic_acid_mass_relative_mass',7728,7669,'mean',NULL,NULL,NULL,NULL,NULL),(7694,1487,'galacturonic_acid_mass_relative_mass',7729,7669,'mean',NULL,NULL,NULL,NULL,NULL),(7695,1487,'holocellulose_mass_relative_mass',7730,7669,'mean',NULL,NULL,NULL,NULL,NULL),(7696,1487,'4_hydroxybenzaldehyde_mass_relative_mass',7731,7669,'mean',NULL,NULL,NULL,NULL,NULL),(7697,1487,'4_hydroxyacetophenone_mass_relative_mass',7732,7669,'mean',NULL,NULL,NULL,NULL,NULL),(7698,1487,'4_hydroxybenzoic_acid_mass_relative_mass',7733,7669,'mean',NULL,NULL,NULL,NULL,NULL),(7699,1487,'vanillin_mass_relative_mass',7734,7669,'mean',NULL,NULL,NULL,NULL,NULL),(7700,1487,'vanillic_acid_mass_relative_mass',7735,7669,'mean',NULL,NULL,NULL,NULL,NULL),(7701,1487,'acetovanillone_mass_relative_mass',7736,7669,'mean',NULL,NULL,NULL,NULL,NULL),(7702,1487,'syringe_aldehyde_mass_relative_mass',7737,7669,'mean',NULL,NULL,NULL,NULL,NULL),(7703,1487,'acetosyringone_mass_relative_mass',7738,7669,'mean',NULL,NULL,NULL,NULL,NULL),(7704,1487,'syringic_acid_mass_relative_mass',7739,7669,'mean',NULL,NULL,NULL,NULL,NULL),(7705,1487,'p_coumaric_acid_mass_relative_mass',7740,7669,'mean',NULL,NULL,NULL,NULL,NULL),(7706,1487,'ferulic_acid_mass_relative_mass',7741,7669,'mean',NULL,NULL,NULL,NULL,NULL),(7707,1487,'Klason_lignin_mass_relative_mass',7742,7669,'mean',NULL,NULL,NULL,NULL,NULL),(7708,1487,'soluble_lignin_mass_relative_mass',7743,7669,'mean',NULL,NULL,NULL,NULL,NULL),(7709,1487,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7710,1487,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7711,1487,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7712,1487,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7713,1487,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7714,1487,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7715,1487,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7716,1487,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7717,1487,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7718,1487,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7719,1487,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7720,1487,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7721,1487,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7722,1487,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7723,1487,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7724,1487,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7725,1487,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7726,1487,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7727,1487,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7728,1487,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7729,1487,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7730,1487,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7731,1487,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7732,1487,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7733,1487,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7734,1487,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7735,1487,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7736,1487,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7737,1487,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7738,1487,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7739,1487,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7740,1487,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7741,1487,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7742,1487,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7743,1487,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7744,1488,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7745,1488,'mass_relative_mass',7744,7744,'mean','se',NULL,1,0,NULL),(7746,1488,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(7747,1488,'ash_mass_relative_mass',7784,7744,'mean',NULL,NULL,NULL,NULL,NULL),(7748,1488,'N_relative_mass',7785,7744,'mean',NULL,NULL,NULL,NULL,NULL),(7749,1488,'P_relative_mass',7786,7744,'mean',NULL,NULL,NULL,NULL,NULL),(7750,1488,'Ca_relative_mass',7787,7744,'mean',NULL,NULL,NULL,NULL,NULL),(7751,1488,'K_relative_mass',7788,7744,'mean',NULL,NULL,NULL,NULL,NULL),(7752,1488,'Mg_relative_mass',7789,7744,'mean',NULL,NULL,NULL,NULL,NULL),(7753,1488,'Mn_relative_mass',7790,7744,'mean',NULL,NULL,NULL,NULL,NULL),(7754,1488,'C_relative_mass',7791,7744,'mean',NULL,NULL,NULL,NULL,NULL),(7755,1488,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7756,1488,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7757,1488,'dichloromethane_extractives_mass_relative_mass',7792,7744,'mean',NULL,NULL,NULL,NULL,NULL),(7758,1488,'acetone_extractives_mass_relative_mass',7793,7744,'mean',NULL,NULL,NULL,NULL,NULL),(7759,1488,'ethanol_extractives_mass_relative_mass',7794,7744,'mean',NULL,NULL,NULL,NULL,NULL),(7760,1488,'water_extractives_mass_relative_mass',7795,7744,'mean',NULL,NULL,NULL,NULL,NULL),(7761,1488,'cellulose_mass_relative_mass',7796,7744,'mean',NULL,NULL,NULL,NULL,NULL),(7762,1488,'arabinose_mass_relative_mass',7797,7744,'mean',NULL,NULL,NULL,NULL,NULL),(7763,1488,'rhamnose_mass_relative_mass',7798,7744,'mean',NULL,NULL,NULL,NULL,NULL),(7764,1488,'xylose_mass_relative_mass',7799,7744,'mean',NULL,NULL,NULL,NULL,NULL),(7765,1488,'mannose_mass_relative_mass',7800,7744,'mean',NULL,NULL,NULL,NULL,NULL),(7766,1488,'galactose_mass_relative_mass',7801,7744,'mean',NULL,NULL,NULL,NULL,NULL),(7767,1488,'glucose_mass_relative_mass',7802,7744,'mean',NULL,NULL,NULL,NULL,NULL),(7768,1488,'glucuronic_acid_mass_relative_mass',7803,7744,'mean',NULL,NULL,NULL,NULL,NULL),(7769,1488,'galacturonic_acid_mass_relative_mass',7804,7744,'mean',NULL,NULL,NULL,NULL,NULL),(7770,1488,'holocellulose_mass_relative_mass',7805,7744,'mean',NULL,NULL,NULL,NULL,NULL),(7771,1488,'4_hydroxybenzaldehyde_mass_relative_mass',7806,7744,'mean',NULL,NULL,NULL,NULL,NULL),(7772,1488,'4_hydroxyacetophenone_mass_relative_mass',7807,7744,'mean',NULL,NULL,NULL,NULL,NULL),(7773,1488,'4_hydroxybenzoic_acid_mass_relative_mass',7808,7744,'mean',NULL,NULL,NULL,NULL,NULL),(7774,1488,'vanillin_mass_relative_mass',7809,7744,'mean',NULL,NULL,NULL,NULL,NULL),(7775,1488,'vanillic_acid_mass_relative_mass',7810,7744,'mean',NULL,NULL,NULL,NULL,NULL),(7776,1488,'acetovanillone_mass_relative_mass',7811,7744,'mean',NULL,NULL,NULL,NULL,NULL),(7777,1488,'syringe_aldehyde_mass_relative_mass',7812,7744,'mean',NULL,NULL,NULL,NULL,NULL),(7778,1488,'acetosyringone_mass_relative_mass',7813,7744,'mean',NULL,NULL,NULL,NULL,NULL),(7779,1488,'syringic_acid_mass_relative_mass',7814,7744,'mean',NULL,NULL,NULL,NULL,NULL),(7780,1488,'p_coumaric_acid_mass_relative_mass',7815,7744,'mean',NULL,NULL,NULL,NULL,NULL),(7781,1488,'ferulic_acid_mass_relative_mass',7816,7744,'mean',NULL,NULL,NULL,NULL,NULL),(7782,1488,'Klason_lignin_mass_relative_mass',7817,7744,'mean',NULL,NULL,NULL,NULL,NULL),(7783,1488,'soluble_lignin_mass_relative_mass',7818,7744,'mean',NULL,NULL,NULL,NULL,NULL),(7784,1488,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7785,1488,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7786,1488,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7787,1488,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7788,1488,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7789,1488,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7790,1488,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7791,1488,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7792,1488,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7793,1488,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7794,1488,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7795,1488,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7796,1488,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7797,1488,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7798,1488,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7799,1488,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7800,1488,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7801,1488,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7802,1488,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7803,1488,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7804,1488,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7805,1488,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7806,1488,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7807,1488,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7808,1488,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7809,1488,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7810,1488,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7811,1488,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7812,1488,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7813,1488,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7814,1488,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7815,1488,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7816,1488,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7817,1488,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7818,1488,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7819,1489,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7820,1489,'mass_relative_mass',7819,7819,'mean','se',NULL,1,0,NULL),(7821,1489,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(7822,1489,'ash_mass_relative_mass',7859,7819,'mean',NULL,NULL,NULL,NULL,NULL),(7823,1489,'N_relative_mass',7860,7819,'mean',NULL,NULL,NULL,NULL,NULL),(7824,1489,'P_relative_mass',7861,7819,'mean',NULL,NULL,NULL,NULL,NULL),(7825,1489,'Ca_relative_mass',7862,7819,'mean',NULL,NULL,NULL,NULL,NULL),(7826,1489,'K_relative_mass',7863,7819,'mean',NULL,NULL,NULL,NULL,NULL),(7827,1489,'Mg_relative_mass',7864,7819,'mean',NULL,NULL,NULL,NULL,NULL),(7828,1489,'Mn_relative_mass',7865,7819,'mean',NULL,NULL,NULL,NULL,NULL),(7829,1489,'C_relative_mass',7866,7819,'mean',NULL,NULL,NULL,NULL,NULL),(7830,1489,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7831,1489,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7832,1489,'dichloromethane_extractives_mass_relative_mass',7867,7819,'mean',NULL,NULL,NULL,NULL,NULL),(7833,1489,'acetone_extractives_mass_relative_mass',7868,7819,'mean',NULL,NULL,NULL,NULL,NULL),(7834,1489,'ethanol_extractives_mass_relative_mass',7869,7819,'mean',NULL,NULL,NULL,NULL,NULL),(7835,1489,'water_extractives_mass_relative_mass',7870,7819,'mean',NULL,NULL,NULL,NULL,NULL),(7836,1489,'cellulose_mass_relative_mass',7871,7819,'mean',NULL,NULL,NULL,NULL,NULL),(7837,1489,'arabinose_mass_relative_mass',7872,7819,'mean',NULL,NULL,NULL,NULL,NULL),(7838,1489,'rhamnose_mass_relative_mass',7873,7819,'mean',NULL,NULL,NULL,NULL,NULL),(7839,1489,'xylose_mass_relative_mass',7874,7819,'mean',NULL,NULL,NULL,NULL,NULL),(7840,1489,'mannose_mass_relative_mass',7875,7819,'mean',NULL,NULL,NULL,NULL,NULL),(7841,1489,'galactose_mass_relative_mass',7876,7819,'mean',NULL,NULL,NULL,NULL,NULL),(7842,1489,'glucose_mass_relative_mass',7877,7819,'mean',NULL,NULL,NULL,NULL,NULL),(7843,1489,'glucuronic_acid_mass_relative_mass',7878,7819,'mean',NULL,NULL,NULL,NULL,NULL),(7844,1489,'galacturonic_acid_mass_relative_mass',7879,7819,'mean',NULL,NULL,NULL,NULL,NULL),(7845,1489,'holocellulose_mass_relative_mass',7880,7819,'mean',NULL,NULL,NULL,NULL,NULL),(7846,1489,'4_hydroxybenzaldehyde_mass_relative_mass',7881,7819,'mean',NULL,NULL,NULL,NULL,NULL),(7847,1489,'4_hydroxyacetophenone_mass_relative_mass',7882,7819,'mean',NULL,NULL,NULL,NULL,NULL),(7848,1489,'4_hydroxybenzoic_acid_mass_relative_mass',7883,7819,'mean',NULL,NULL,NULL,NULL,NULL),(7849,1489,'vanillin_mass_relative_mass',7884,7819,'mean',NULL,NULL,NULL,NULL,NULL),(7850,1489,'vanillic_acid_mass_relative_mass',7885,7819,'mean',NULL,NULL,NULL,NULL,NULL),(7851,1489,'acetovanillone_mass_relative_mass',7886,7819,'mean',NULL,NULL,NULL,NULL,NULL),(7852,1489,'syringe_aldehyde_mass_relative_mass',7887,7819,'mean',NULL,NULL,NULL,NULL,NULL),(7853,1489,'acetosyringone_mass_relative_mass',7888,7819,'mean',NULL,NULL,NULL,NULL,NULL),(7854,1489,'syringic_acid_mass_relative_mass',7889,7819,'mean',NULL,NULL,NULL,NULL,NULL),(7855,1489,'p_coumaric_acid_mass_relative_mass',7890,7819,'mean',NULL,NULL,NULL,NULL,NULL),(7856,1489,'ferulic_acid_mass_relative_mass',7891,7819,'mean',NULL,NULL,NULL,NULL,NULL),(7857,1489,'Klason_lignin_mass_relative_mass',7892,7819,'mean',NULL,NULL,NULL,NULL,NULL),(7858,1489,'soluble_lignin_mass_relative_mass',7893,7819,'mean',NULL,NULL,NULL,NULL,NULL),(7859,1489,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7860,1489,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7861,1489,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7862,1489,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7863,1489,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7864,1489,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7865,1489,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7866,1489,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7867,1489,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7868,1489,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7869,1489,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7870,1489,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7871,1489,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7872,1489,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7873,1489,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7874,1489,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7875,1489,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7876,1489,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7877,1489,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7878,1489,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7879,1489,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7880,1489,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7881,1489,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7882,1489,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7883,1489,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7884,1489,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7885,1489,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7886,1489,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7887,1489,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7888,1489,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7889,1489,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7890,1489,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7891,1489,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7892,1489,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7893,1489,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7894,1490,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7895,1490,'mass_relative_mass',7894,7894,'mean','se',NULL,1,0,NULL),(7896,1490,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(7897,1490,'ash_mass_relative_mass',7934,7894,'mean',NULL,NULL,NULL,NULL,NULL),(7898,1490,'N_relative_mass',7935,7894,'mean',NULL,NULL,NULL,NULL,NULL),(7899,1490,'P_relative_mass',7936,7894,'mean',NULL,NULL,NULL,NULL,NULL),(7900,1490,'Ca_relative_mass',7937,7894,'mean',NULL,NULL,NULL,NULL,NULL),(7901,1490,'K_relative_mass',7938,7894,'mean',NULL,NULL,NULL,NULL,NULL),(7902,1490,'Mg_relative_mass',7939,7894,'mean',NULL,NULL,NULL,NULL,NULL),(7903,1490,'Mn_relative_mass',7940,7894,'mean',NULL,NULL,NULL,NULL,NULL),(7904,1490,'C_relative_mass',7941,7894,'mean',NULL,NULL,NULL,NULL,NULL),(7905,1490,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7906,1490,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7907,1490,'dichloromethane_extractives_mass_relative_mass',7942,7894,'mean',NULL,NULL,NULL,NULL,NULL),(7908,1490,'acetone_extractives_mass_relative_mass',7943,7894,'mean',NULL,NULL,NULL,NULL,NULL),(7909,1490,'ethanol_extractives_mass_relative_mass',7944,7894,'mean',NULL,NULL,NULL,NULL,NULL),(7910,1490,'water_extractives_mass_relative_mass',7945,7894,'mean',NULL,NULL,NULL,NULL,NULL),(7911,1490,'cellulose_mass_relative_mass',7946,7894,'mean',NULL,NULL,NULL,NULL,NULL),(7912,1490,'arabinose_mass_relative_mass',7947,7894,'mean',NULL,NULL,NULL,NULL,NULL),(7913,1490,'rhamnose_mass_relative_mass',7948,7894,'mean',NULL,NULL,NULL,NULL,NULL),(7914,1490,'xylose_mass_relative_mass',7949,7894,'mean',NULL,NULL,NULL,NULL,NULL),(7915,1490,'mannose_mass_relative_mass',7950,7894,'mean',NULL,NULL,NULL,NULL,NULL),(7916,1490,'galactose_mass_relative_mass',7951,7894,'mean',NULL,NULL,NULL,NULL,NULL),(7917,1490,'glucose_mass_relative_mass',7952,7894,'mean',NULL,NULL,NULL,NULL,NULL),(7918,1490,'glucuronic_acid_mass_relative_mass',7953,7894,'mean',NULL,NULL,NULL,NULL,NULL),(7919,1490,'galacturonic_acid_mass_relative_mass',7954,7894,'mean',NULL,NULL,NULL,NULL,NULL),(7920,1490,'holocellulose_mass_relative_mass',7955,7894,'mean',NULL,NULL,NULL,NULL,NULL),(7921,1490,'4_hydroxybenzaldehyde_mass_relative_mass',7956,7894,'mean',NULL,NULL,NULL,NULL,NULL),(7922,1490,'4_hydroxyacetophenone_mass_relative_mass',7957,7894,'mean',NULL,NULL,NULL,NULL,NULL),(7923,1490,'4_hydroxybenzoic_acid_mass_relative_mass',7958,7894,'mean',NULL,NULL,NULL,NULL,NULL),(7924,1490,'vanillin_mass_relative_mass',7959,7894,'mean',NULL,NULL,NULL,NULL,NULL),(7925,1490,'vanillic_acid_mass_relative_mass',7960,7894,'mean',NULL,NULL,NULL,NULL,NULL),(7926,1490,'acetovanillone_mass_relative_mass',7961,7894,'mean',NULL,NULL,NULL,NULL,NULL),(7927,1490,'syringe_aldehyde_mass_relative_mass',7962,7894,'mean',NULL,NULL,NULL,NULL,NULL),(7928,1490,'acetosyringone_mass_relative_mass',7963,7894,'mean',NULL,NULL,NULL,NULL,NULL),(7929,1490,'syringic_acid_mass_relative_mass',7964,7894,'mean',NULL,NULL,NULL,NULL,NULL),(7930,1490,'p_coumaric_acid_mass_relative_mass',7965,7894,'mean',NULL,NULL,NULL,NULL,NULL),(7931,1490,'ferulic_acid_mass_relative_mass',7966,7894,'mean',NULL,NULL,NULL,NULL,NULL),(7932,1490,'Klason_lignin_mass_relative_mass',7967,7894,'mean',NULL,NULL,NULL,NULL,NULL),(7933,1490,'soluble_lignin_mass_relative_mass',7968,7894,'mean',NULL,NULL,NULL,NULL,NULL),(7934,1490,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7935,1490,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7936,1490,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7937,1490,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7938,1490,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7939,1490,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7940,1490,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7941,1490,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7942,1490,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7943,1490,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7944,1490,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7945,1490,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7946,1490,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7947,1490,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7948,1490,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7949,1490,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7950,1490,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7951,1490,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7952,1490,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7953,1490,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7954,1490,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7955,1490,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7956,1490,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7957,1490,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7958,1490,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7959,1490,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7960,1490,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7961,1490,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7962,1490,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7963,1490,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7964,1490,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7965,1490,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7966,1490,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7967,1490,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7968,1490,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7969,1491,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7970,1491,'mass_relative_mass',7969,7969,'mean','se',NULL,1,0,NULL),(7971,1491,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(7972,1491,'ash_mass_relative_mass',8009,7969,'mean',NULL,NULL,NULL,NULL,NULL),(7973,1491,'N_relative_mass',8010,7969,'mean',NULL,NULL,NULL,NULL,NULL),(7974,1491,'P_relative_mass',8011,7969,'mean',NULL,NULL,NULL,NULL,NULL),(7975,1491,'Ca_relative_mass',8012,7969,'mean',NULL,NULL,NULL,NULL,NULL),(7976,1491,'K_relative_mass',8013,7969,'mean',NULL,NULL,NULL,NULL,NULL),(7977,1491,'Mg_relative_mass',8014,7969,'mean',NULL,NULL,NULL,NULL,NULL),(7978,1491,'Mn_relative_mass',8015,7969,'mean',NULL,NULL,NULL,NULL,NULL),(7979,1491,'C_relative_mass',8016,7969,'mean',NULL,NULL,NULL,NULL,NULL),(7980,1491,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7981,1491,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(7982,1491,'dichloromethane_extractives_mass_relative_mass',8017,7969,'mean',NULL,NULL,NULL,NULL,NULL),(7983,1491,'acetone_extractives_mass_relative_mass',8018,7969,'mean',NULL,NULL,NULL,NULL,NULL),(7984,1491,'ethanol_extractives_mass_relative_mass',8019,7969,'mean',NULL,NULL,NULL,NULL,NULL),(7985,1491,'water_extractives_mass_relative_mass',8020,7969,'mean',NULL,NULL,NULL,NULL,NULL),(7986,1491,'cellulose_mass_relative_mass',8021,7969,'mean',NULL,NULL,NULL,NULL,NULL),(7987,1491,'arabinose_mass_relative_mass',8022,7969,'mean',NULL,NULL,NULL,NULL,NULL),(7988,1491,'rhamnose_mass_relative_mass',8023,7969,'mean',NULL,NULL,NULL,NULL,NULL),(7989,1491,'xylose_mass_relative_mass',8024,7969,'mean',NULL,NULL,NULL,NULL,NULL),(7990,1491,'mannose_mass_relative_mass',8025,7969,'mean',NULL,NULL,NULL,NULL,NULL),(7991,1491,'galactose_mass_relative_mass',8026,7969,'mean',NULL,NULL,NULL,NULL,NULL),(7992,1491,'glucose_mass_relative_mass',8027,7969,'mean',NULL,NULL,NULL,NULL,NULL),(7993,1491,'glucuronic_acid_mass_relative_mass',8028,7969,'mean',NULL,NULL,NULL,NULL,NULL),(7994,1491,'galacturonic_acid_mass_relative_mass',8029,7969,'mean',NULL,NULL,NULL,NULL,NULL),(7995,1491,'holocellulose_mass_relative_mass',8030,7969,'mean',NULL,NULL,NULL,NULL,NULL),(7996,1491,'4_hydroxybenzaldehyde_mass_relative_mass',8031,7969,'mean',NULL,NULL,NULL,NULL,NULL),(7997,1491,'4_hydroxyacetophenone_mass_relative_mass',8032,7969,'mean',NULL,NULL,NULL,NULL,NULL),(7998,1491,'4_hydroxybenzoic_acid_mass_relative_mass',8033,7969,'mean',NULL,NULL,NULL,NULL,NULL),(7999,1491,'vanillin_mass_relative_mass',8034,7969,'mean',NULL,NULL,NULL,NULL,NULL),(8000,1491,'vanillic_acid_mass_relative_mass',8035,7969,'mean',NULL,NULL,NULL,NULL,NULL),(8001,1491,'acetovanillone_mass_relative_mass',8036,7969,'mean',NULL,NULL,NULL,NULL,NULL),(8002,1491,'syringe_aldehyde_mass_relative_mass',8037,7969,'mean',NULL,NULL,NULL,NULL,NULL),(8003,1491,'acetosyringone_mass_relative_mass',8038,7969,'mean',NULL,NULL,NULL,NULL,NULL),(8004,1491,'syringic_acid_mass_relative_mass',8039,7969,'mean',NULL,NULL,NULL,NULL,NULL),(8005,1491,'p_coumaric_acid_mass_relative_mass',8040,7969,'mean',NULL,NULL,NULL,NULL,NULL),(8006,1491,'ferulic_acid_mass_relative_mass',8041,7969,'mean',NULL,NULL,NULL,NULL,NULL),(8007,1491,'Klason_lignin_mass_relative_mass',8042,7969,'mean',NULL,NULL,NULL,NULL,NULL),(8008,1491,'soluble_lignin_mass_relative_mass',8043,7969,'mean',NULL,NULL,NULL,NULL,NULL),(8009,1491,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8010,1491,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8011,1491,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8012,1491,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8013,1491,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8014,1491,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8015,1491,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8016,1491,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8017,1491,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8018,1491,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8019,1491,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8020,1491,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8021,1491,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8022,1491,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8023,1491,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8024,1491,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8025,1491,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8026,1491,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8027,1491,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8028,1491,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8029,1491,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8030,1491,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8031,1491,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8032,1491,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8033,1491,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8034,1491,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8035,1491,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8036,1491,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8037,1491,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8038,1491,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8039,1491,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8040,1491,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8041,1491,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8042,1491,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8043,1491,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8044,1492,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8045,1492,'mass_relative_mass',8044,8044,'mean','se',NULL,1,0,NULL),(8046,1492,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(8047,1492,'ash_mass_relative_mass',8084,8044,'mean',NULL,NULL,NULL,NULL,NULL),(8048,1492,'N_relative_mass',8085,8044,'mean',NULL,NULL,NULL,NULL,NULL),(8049,1492,'P_relative_mass',8086,8044,'mean',NULL,NULL,NULL,NULL,NULL),(8050,1492,'Ca_relative_mass',8087,8044,'mean',NULL,NULL,NULL,NULL,NULL),(8051,1492,'K_relative_mass',8088,8044,'mean',NULL,NULL,NULL,NULL,NULL),(8052,1492,'Mg_relative_mass',8089,8044,'mean',NULL,NULL,NULL,NULL,NULL),(8053,1492,'Mn_relative_mass',8090,8044,'mean',NULL,NULL,NULL,NULL,NULL),(8054,1492,'C_relative_mass',8091,8044,'mean',NULL,NULL,NULL,NULL,NULL),(8055,1492,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8056,1492,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8057,1492,'dichloromethane_extractives_mass_relative_mass',8092,8044,'mean',NULL,NULL,NULL,NULL,NULL),(8058,1492,'acetone_extractives_mass_relative_mass',8093,8044,'mean',NULL,NULL,NULL,NULL,NULL),(8059,1492,'ethanol_extractives_mass_relative_mass',8094,8044,'mean',NULL,NULL,NULL,NULL,NULL),(8060,1492,'water_extractives_mass_relative_mass',8095,8044,'mean',NULL,NULL,NULL,NULL,NULL),(8061,1492,'cellulose_mass_relative_mass',8096,8044,'mean',NULL,NULL,NULL,NULL,NULL),(8062,1492,'arabinose_mass_relative_mass',8097,8044,'mean',NULL,NULL,NULL,NULL,NULL),(8063,1492,'rhamnose_mass_relative_mass',8098,8044,'mean',NULL,NULL,NULL,NULL,NULL),(8064,1492,'xylose_mass_relative_mass',8099,8044,'mean',NULL,NULL,NULL,NULL,NULL),(8065,1492,'mannose_mass_relative_mass',8100,8044,'mean',NULL,NULL,NULL,NULL,NULL),(8066,1492,'galactose_mass_relative_mass',8101,8044,'mean',NULL,NULL,NULL,NULL,NULL),(8067,1492,'glucose_mass_relative_mass',8102,8044,'mean',NULL,NULL,NULL,NULL,NULL),(8068,1492,'glucuronic_acid_mass_relative_mass',8103,8044,'mean',NULL,NULL,NULL,NULL,NULL),(8069,1492,'galacturonic_acid_mass_relative_mass',8104,8044,'mean',NULL,NULL,NULL,NULL,NULL),(8070,1492,'holocellulose_mass_relative_mass',8105,8044,'mean',NULL,NULL,NULL,NULL,NULL),(8071,1492,'4_hydroxybenzaldehyde_mass_relative_mass',8106,8044,'mean',NULL,NULL,NULL,NULL,NULL),(8072,1492,'4_hydroxyacetophenone_mass_relative_mass',8107,8044,'mean',NULL,NULL,NULL,NULL,NULL),(8073,1492,'4_hydroxybenzoic_acid_mass_relative_mass',8108,8044,'mean',NULL,NULL,NULL,NULL,NULL),(8074,1492,'vanillin_mass_relative_mass',8109,8044,'mean',NULL,NULL,NULL,NULL,NULL),(8075,1492,'vanillic_acid_mass_relative_mass',8110,8044,'mean',NULL,NULL,NULL,NULL,NULL),(8076,1492,'acetovanillone_mass_relative_mass',8111,8044,'mean',NULL,NULL,NULL,NULL,NULL),(8077,1492,'syringe_aldehyde_mass_relative_mass',8112,8044,'mean',NULL,NULL,NULL,NULL,NULL),(8078,1492,'acetosyringone_mass_relative_mass',8113,8044,'mean',NULL,NULL,NULL,NULL,NULL),(8079,1492,'syringic_acid_mass_relative_mass',8114,8044,'mean',NULL,NULL,NULL,NULL,NULL),(8080,1492,'p_coumaric_acid_mass_relative_mass',8115,8044,'mean',NULL,NULL,NULL,NULL,NULL),(8081,1492,'ferulic_acid_mass_relative_mass',8116,8044,'mean',NULL,NULL,NULL,NULL,NULL),(8082,1492,'Klason_lignin_mass_relative_mass',8117,8044,'mean',NULL,NULL,NULL,NULL,NULL),(8083,1492,'soluble_lignin_mass_relative_mass',8118,8044,'mean',NULL,NULL,NULL,NULL,NULL),(8084,1492,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8085,1492,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8086,1492,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8087,1492,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8088,1492,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8089,1492,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8090,1492,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8091,1492,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8092,1492,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8093,1492,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8094,1492,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8095,1492,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8096,1492,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8097,1492,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8098,1492,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8099,1492,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8100,1492,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8101,1492,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8102,1492,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8103,1492,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8104,1492,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8105,1492,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8106,1492,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8107,1492,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8108,1492,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8109,1492,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8110,1492,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8111,1492,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8112,1492,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8113,1492,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8114,1492,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8115,1492,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8116,1492,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8117,1492,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8118,1492,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8119,1493,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8120,1493,'mass_relative_mass',8119,8119,'mean','se',NULL,1,0,NULL),(8121,1493,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(8122,1493,'ash_mass_relative_mass',8159,8119,'mean',NULL,NULL,NULL,NULL,NULL),(8123,1493,'N_relative_mass',8160,8119,'mean',NULL,NULL,NULL,NULL,NULL),(8124,1493,'P_relative_mass',8161,8119,'mean',NULL,NULL,NULL,NULL,NULL),(8125,1493,'Ca_relative_mass',8162,8119,'mean',NULL,NULL,NULL,NULL,NULL),(8126,1493,'K_relative_mass',8163,8119,'mean',NULL,NULL,NULL,NULL,NULL),(8127,1493,'Mg_relative_mass',8164,8119,'mean',NULL,NULL,NULL,NULL,NULL),(8128,1493,'Mn_relative_mass',8165,8119,'mean',NULL,NULL,NULL,NULL,NULL),(8129,1493,'C_relative_mass',8166,8119,'mean',NULL,NULL,NULL,NULL,NULL),(8130,1493,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8131,1493,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8132,1493,'dichloromethane_extractives_mass_relative_mass',8167,8119,'mean',NULL,NULL,NULL,NULL,NULL),(8133,1493,'acetone_extractives_mass_relative_mass',8168,8119,'mean',NULL,NULL,NULL,NULL,NULL),(8134,1493,'ethanol_extractives_mass_relative_mass',8169,8119,'mean',NULL,NULL,NULL,NULL,NULL),(8135,1493,'water_extractives_mass_relative_mass',8170,8119,'mean',NULL,NULL,NULL,NULL,NULL),(8136,1493,'cellulose_mass_relative_mass',8171,8119,'mean',NULL,NULL,NULL,NULL,NULL),(8137,1493,'arabinose_mass_relative_mass',8172,8119,'mean',NULL,NULL,NULL,NULL,NULL),(8138,1493,'rhamnose_mass_relative_mass',8173,8119,'mean',NULL,NULL,NULL,NULL,NULL),(8139,1493,'xylose_mass_relative_mass',8174,8119,'mean',NULL,NULL,NULL,NULL,NULL),(8140,1493,'mannose_mass_relative_mass',8175,8119,'mean',NULL,NULL,NULL,NULL,NULL),(8141,1493,'galactose_mass_relative_mass',8176,8119,'mean',NULL,NULL,NULL,NULL,NULL),(8142,1493,'glucose_mass_relative_mass',8177,8119,'mean',NULL,NULL,NULL,NULL,NULL),(8143,1493,'glucuronic_acid_mass_relative_mass',8178,8119,'mean',NULL,NULL,NULL,NULL,NULL),(8144,1493,'galacturonic_acid_mass_relative_mass',8179,8119,'mean',NULL,NULL,NULL,NULL,NULL),(8145,1493,'holocellulose_mass_relative_mass',8180,8119,'mean',NULL,NULL,NULL,NULL,NULL),(8146,1493,'4_hydroxybenzaldehyde_mass_relative_mass',8181,8119,'mean',NULL,NULL,NULL,NULL,NULL),(8147,1493,'4_hydroxyacetophenone_mass_relative_mass',8182,8119,'mean',NULL,NULL,NULL,NULL,NULL),(8148,1493,'4_hydroxybenzoic_acid_mass_relative_mass',8183,8119,'mean',NULL,NULL,NULL,NULL,NULL),(8149,1493,'vanillin_mass_relative_mass',8184,8119,'mean',NULL,NULL,NULL,NULL,NULL),(8150,1493,'vanillic_acid_mass_relative_mass',8185,8119,'mean',NULL,NULL,NULL,NULL,NULL),(8151,1493,'acetovanillone_mass_relative_mass',8186,8119,'mean',NULL,NULL,NULL,NULL,NULL),(8152,1493,'syringe_aldehyde_mass_relative_mass',8187,8119,'mean',NULL,NULL,NULL,NULL,NULL),(8153,1493,'acetosyringone_mass_relative_mass',8188,8119,'mean',NULL,NULL,NULL,NULL,NULL),(8154,1493,'syringic_acid_mass_relative_mass',8189,8119,'mean',NULL,NULL,NULL,NULL,NULL),(8155,1493,'p_coumaric_acid_mass_relative_mass',8190,8119,'mean',NULL,NULL,NULL,NULL,NULL),(8156,1493,'ferulic_acid_mass_relative_mass',8191,8119,'mean',NULL,NULL,NULL,NULL,NULL),(8157,1493,'Klason_lignin_mass_relative_mass',8192,8119,'mean',NULL,NULL,NULL,NULL,NULL),(8158,1493,'soluble_lignin_mass_relative_mass',8193,8119,'mean',NULL,NULL,NULL,NULL,NULL),(8159,1493,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8160,1493,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8161,1493,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8162,1493,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8163,1493,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8164,1493,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8165,1493,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8166,1493,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8167,1493,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8168,1493,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8169,1493,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8170,1493,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8171,1493,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8172,1493,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8173,1493,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8174,1493,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8175,1493,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8176,1493,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8177,1493,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8178,1493,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8179,1493,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8180,1493,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8181,1493,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8182,1493,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8183,1493,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8184,1493,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8185,1493,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8186,1493,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8187,1493,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8188,1493,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8189,1493,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8190,1493,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8191,1493,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8192,1493,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8193,1493,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8194,1494,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8195,1494,'mass_relative_mass',8194,8194,'mean','se',NULL,1,0,NULL),(8196,1494,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(8197,1494,'ash_mass_relative_mass',8234,8194,'mean',NULL,NULL,NULL,NULL,NULL),(8198,1494,'N_relative_mass',8235,8194,'mean',NULL,NULL,NULL,NULL,NULL),(8199,1494,'P_relative_mass',8236,8194,'mean',NULL,NULL,NULL,NULL,NULL),(8200,1494,'Ca_relative_mass',8237,8194,'mean',NULL,NULL,NULL,NULL,NULL),(8201,1494,'K_relative_mass',8238,8194,'mean',NULL,NULL,NULL,NULL,NULL),(8202,1494,'Mg_relative_mass',8239,8194,'mean',NULL,NULL,NULL,NULL,NULL),(8203,1494,'Mn_relative_mass',8240,8194,'mean',NULL,NULL,NULL,NULL,NULL),(8204,1494,'C_relative_mass',8241,8194,'mean',NULL,NULL,NULL,NULL,NULL),(8205,1494,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8206,1494,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8207,1494,'dichloromethane_extractives_mass_relative_mass',8242,8194,'mean',NULL,NULL,NULL,NULL,NULL),(8208,1494,'acetone_extractives_mass_relative_mass',8243,8194,'mean',NULL,NULL,NULL,NULL,NULL),(8209,1494,'ethanol_extractives_mass_relative_mass',8244,8194,'mean',NULL,NULL,NULL,NULL,NULL),(8210,1494,'water_extractives_mass_relative_mass',8245,8194,'mean',NULL,NULL,NULL,NULL,NULL),(8211,1494,'cellulose_mass_relative_mass',8246,8194,'mean',NULL,NULL,NULL,NULL,NULL),(8212,1494,'arabinose_mass_relative_mass',8247,8194,'mean',NULL,NULL,NULL,NULL,NULL),(8213,1494,'rhamnose_mass_relative_mass',8248,8194,'mean',NULL,NULL,NULL,NULL,NULL),(8214,1494,'xylose_mass_relative_mass',8249,8194,'mean',NULL,NULL,NULL,NULL,NULL),(8215,1494,'mannose_mass_relative_mass',8250,8194,'mean',NULL,NULL,NULL,NULL,NULL),(8216,1494,'galactose_mass_relative_mass',8251,8194,'mean',NULL,NULL,NULL,NULL,NULL),(8217,1494,'glucose_mass_relative_mass',8252,8194,'mean',NULL,NULL,NULL,NULL,NULL),(8218,1494,'glucuronic_acid_mass_relative_mass',8253,8194,'mean',NULL,NULL,NULL,NULL,NULL),(8219,1494,'galacturonic_acid_mass_relative_mass',8254,8194,'mean',NULL,NULL,NULL,NULL,NULL),(8220,1494,'holocellulose_mass_relative_mass',8255,8194,'mean',NULL,NULL,NULL,NULL,NULL),(8221,1494,'4_hydroxybenzaldehyde_mass_relative_mass',8256,8194,'mean',NULL,NULL,NULL,NULL,NULL),(8222,1494,'4_hydroxyacetophenone_mass_relative_mass',8257,8194,'mean',NULL,NULL,NULL,NULL,NULL),(8223,1494,'4_hydroxybenzoic_acid_mass_relative_mass',8258,8194,'mean',NULL,NULL,NULL,NULL,NULL),(8224,1494,'vanillin_mass_relative_mass',8259,8194,'mean',NULL,NULL,NULL,NULL,NULL),(8225,1494,'vanillic_acid_mass_relative_mass',8260,8194,'mean',NULL,NULL,NULL,NULL,NULL),(8226,1494,'acetovanillone_mass_relative_mass',8261,8194,'mean',NULL,NULL,NULL,NULL,NULL),(8227,1494,'syringe_aldehyde_mass_relative_mass',8262,8194,'mean',NULL,NULL,NULL,NULL,NULL),(8228,1494,'acetosyringone_mass_relative_mass',8263,8194,'mean',NULL,NULL,NULL,NULL,NULL),(8229,1494,'syringic_acid_mass_relative_mass',8264,8194,'mean',NULL,NULL,NULL,NULL,NULL),(8230,1494,'p_coumaric_acid_mass_relative_mass',8265,8194,'mean',NULL,NULL,NULL,NULL,NULL),(8231,1494,'ferulic_acid_mass_relative_mass',8266,8194,'mean',NULL,NULL,NULL,NULL,NULL),(8232,1494,'Klason_lignin_mass_relative_mass',8267,8194,'mean',NULL,NULL,NULL,NULL,NULL),(8233,1494,'soluble_lignin_mass_relative_mass',8268,8194,'mean',NULL,NULL,NULL,NULL,NULL),(8234,1494,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8235,1494,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8236,1494,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8237,1494,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8238,1494,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8239,1494,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8240,1494,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8241,1494,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8242,1494,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8243,1494,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8244,1494,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8245,1494,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8246,1494,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8247,1494,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8248,1494,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8249,1494,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8250,1494,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8251,1494,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8252,1494,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8253,1494,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8254,1494,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8255,1494,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8256,1494,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8257,1494,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8258,1494,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8259,1494,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8260,1494,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8261,1494,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8262,1494,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8263,1494,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8264,1494,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8265,1494,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8266,1494,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8267,1494,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8268,1494,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8269,1495,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8270,1495,'mass_relative_mass',8269,8269,'mean','se',NULL,1,0,NULL),(8271,1495,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(8272,1495,'ash_mass_relative_mass',8309,8269,'mean',NULL,NULL,NULL,NULL,NULL),(8273,1495,'N_relative_mass',8310,8269,'mean',NULL,NULL,NULL,NULL,NULL),(8274,1495,'P_relative_mass',8311,8269,'mean',NULL,NULL,NULL,NULL,NULL),(8275,1495,'Ca_relative_mass',8312,8269,'mean',NULL,NULL,NULL,NULL,NULL),(8276,1495,'K_relative_mass',8313,8269,'mean',NULL,NULL,NULL,NULL,NULL),(8277,1495,'Mg_relative_mass',8314,8269,'mean',NULL,NULL,NULL,NULL,NULL),(8278,1495,'Mn_relative_mass',8315,8269,'mean',NULL,NULL,NULL,NULL,NULL),(8279,1495,'C_relative_mass',8316,8269,'mean',NULL,NULL,NULL,NULL,NULL),(8280,1495,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8281,1495,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8282,1495,'dichloromethane_extractives_mass_relative_mass',8317,8269,'mean',NULL,NULL,NULL,NULL,NULL),(8283,1495,'acetone_extractives_mass_relative_mass',8318,8269,'mean',NULL,NULL,NULL,NULL,NULL),(8284,1495,'ethanol_extractives_mass_relative_mass',8319,8269,'mean',NULL,NULL,NULL,NULL,NULL),(8285,1495,'water_extractives_mass_relative_mass',8320,8269,'mean',NULL,NULL,NULL,NULL,NULL),(8286,1495,'cellulose_mass_relative_mass',8321,8269,'mean',NULL,NULL,NULL,NULL,NULL),(8287,1495,'arabinose_mass_relative_mass',8322,8269,'mean',NULL,NULL,NULL,NULL,NULL),(8288,1495,'rhamnose_mass_relative_mass',8323,8269,'mean',NULL,NULL,NULL,NULL,NULL),(8289,1495,'xylose_mass_relative_mass',8324,8269,'mean',NULL,NULL,NULL,NULL,NULL),(8290,1495,'mannose_mass_relative_mass',8325,8269,'mean',NULL,NULL,NULL,NULL,NULL),(8291,1495,'galactose_mass_relative_mass',8326,8269,'mean',NULL,NULL,NULL,NULL,NULL),(8292,1495,'glucose_mass_relative_mass',8327,8269,'mean',NULL,NULL,NULL,NULL,NULL),(8293,1495,'glucuronic_acid_mass_relative_mass',8328,8269,'mean',NULL,NULL,NULL,NULL,NULL),(8294,1495,'galacturonic_acid_mass_relative_mass',8329,8269,'mean',NULL,NULL,NULL,NULL,NULL),(8295,1495,'holocellulose_mass_relative_mass',8330,8269,'mean',NULL,NULL,NULL,NULL,NULL),(8296,1495,'4_hydroxybenzaldehyde_mass_relative_mass',8331,8269,'mean',NULL,NULL,NULL,NULL,NULL),(8297,1495,'4_hydroxyacetophenone_mass_relative_mass',8332,8269,'mean',NULL,NULL,NULL,NULL,NULL),(8298,1495,'4_hydroxybenzoic_acid_mass_relative_mass',8333,8269,'mean',NULL,NULL,NULL,NULL,NULL),(8299,1495,'vanillin_mass_relative_mass',8334,8269,'mean',NULL,NULL,NULL,NULL,NULL),(8300,1495,'vanillic_acid_mass_relative_mass',8335,8269,'mean',NULL,NULL,NULL,NULL,NULL),(8301,1495,'acetovanillone_mass_relative_mass',8336,8269,'mean',NULL,NULL,NULL,NULL,NULL),(8302,1495,'syringe_aldehyde_mass_relative_mass',8337,8269,'mean',NULL,NULL,NULL,NULL,NULL),(8303,1495,'acetosyringone_mass_relative_mass',8338,8269,'mean',NULL,NULL,NULL,NULL,NULL),(8304,1495,'syringic_acid_mass_relative_mass',8339,8269,'mean',NULL,NULL,NULL,NULL,NULL),(8305,1495,'p_coumaric_acid_mass_relative_mass',8340,8269,'mean',NULL,NULL,NULL,NULL,NULL),(8306,1495,'ferulic_acid_mass_relative_mass',8341,8269,'mean',NULL,NULL,NULL,NULL,NULL),(8307,1495,'Klason_lignin_mass_relative_mass',8342,8269,'mean',NULL,NULL,NULL,NULL,NULL),(8308,1495,'soluble_lignin_mass_relative_mass',8343,8269,'mean',NULL,NULL,NULL,NULL,NULL),(8309,1495,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8310,1495,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8311,1495,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8312,1495,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8313,1495,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8314,1495,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8315,1495,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8316,1495,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8317,1495,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8318,1495,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8319,1495,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8320,1495,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8321,1495,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8322,1495,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8323,1495,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8324,1495,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8325,1495,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8326,1495,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8327,1495,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8328,1495,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8329,1495,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8330,1495,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8331,1495,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8332,1495,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8333,1495,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8334,1495,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8335,1495,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8336,1495,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8337,1495,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8338,1495,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8339,1495,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8340,1495,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8341,1495,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8342,1495,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8343,1495,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8344,1496,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8345,1496,'mass_relative_mass',8344,8344,'mean','se',NULL,1,0,NULL),(8346,1496,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(8347,1496,'ash_mass_relative_mass',8384,8344,'mean',NULL,NULL,NULL,NULL,NULL),(8348,1496,'N_relative_mass',8385,8344,'mean',NULL,NULL,NULL,NULL,NULL),(8349,1496,'P_relative_mass',8386,8344,'mean',NULL,NULL,NULL,NULL,NULL),(8350,1496,'Ca_relative_mass',8387,8344,'mean',NULL,NULL,NULL,NULL,NULL),(8351,1496,'K_relative_mass',8388,8344,'mean',NULL,NULL,NULL,NULL,NULL),(8352,1496,'Mg_relative_mass',8389,8344,'mean',NULL,NULL,NULL,NULL,NULL),(8353,1496,'Mn_relative_mass',8390,8344,'mean',NULL,NULL,NULL,NULL,NULL),(8354,1496,'C_relative_mass',8391,8344,'mean',NULL,NULL,NULL,NULL,NULL),(8355,1496,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8356,1496,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8357,1496,'dichloromethane_extractives_mass_relative_mass',8392,8344,'mean',NULL,NULL,NULL,NULL,NULL),(8358,1496,'acetone_extractives_mass_relative_mass',8393,8344,'mean',NULL,NULL,NULL,NULL,NULL),(8359,1496,'ethanol_extractives_mass_relative_mass',8394,8344,'mean',NULL,NULL,NULL,NULL,NULL),(8360,1496,'water_extractives_mass_relative_mass',8395,8344,'mean',NULL,NULL,NULL,NULL,NULL),(8361,1496,'cellulose_mass_relative_mass',8396,8344,'mean',NULL,NULL,NULL,NULL,NULL),(8362,1496,'arabinose_mass_relative_mass',8397,8344,'mean',NULL,NULL,NULL,NULL,NULL),(8363,1496,'rhamnose_mass_relative_mass',8398,8344,'mean',NULL,NULL,NULL,NULL,NULL),(8364,1496,'xylose_mass_relative_mass',8399,8344,'mean',NULL,NULL,NULL,NULL,NULL),(8365,1496,'mannose_mass_relative_mass',8400,8344,'mean',NULL,NULL,NULL,NULL,NULL),(8366,1496,'galactose_mass_relative_mass',8401,8344,'mean',NULL,NULL,NULL,NULL,NULL),(8367,1496,'glucose_mass_relative_mass',8402,8344,'mean',NULL,NULL,NULL,NULL,NULL),(8368,1496,'glucuronic_acid_mass_relative_mass',8403,8344,'mean',NULL,NULL,NULL,NULL,NULL),(8369,1496,'galacturonic_acid_mass_relative_mass',8404,8344,'mean',NULL,NULL,NULL,NULL,NULL),(8370,1496,'holocellulose_mass_relative_mass',8405,8344,'mean',NULL,NULL,NULL,NULL,NULL),(8371,1496,'4_hydroxybenzaldehyde_mass_relative_mass',8406,8344,'mean',NULL,NULL,NULL,NULL,NULL),(8372,1496,'4_hydroxyacetophenone_mass_relative_mass',8407,8344,'mean',NULL,NULL,NULL,NULL,NULL),(8373,1496,'4_hydroxybenzoic_acid_mass_relative_mass',8408,8344,'mean',NULL,NULL,NULL,NULL,NULL),(8374,1496,'vanillin_mass_relative_mass',8409,8344,'mean',NULL,NULL,NULL,NULL,NULL),(8375,1496,'vanillic_acid_mass_relative_mass',8410,8344,'mean',NULL,NULL,NULL,NULL,NULL),(8376,1496,'acetovanillone_mass_relative_mass',8411,8344,'mean',NULL,NULL,NULL,NULL,NULL),(8377,1496,'syringe_aldehyde_mass_relative_mass',8412,8344,'mean',NULL,NULL,NULL,NULL,NULL),(8378,1496,'acetosyringone_mass_relative_mass',8413,8344,'mean',NULL,NULL,NULL,NULL,NULL),(8379,1496,'syringic_acid_mass_relative_mass',8414,8344,'mean',NULL,NULL,NULL,NULL,NULL),(8380,1496,'p_coumaric_acid_mass_relative_mass',8415,8344,'mean',NULL,NULL,NULL,NULL,NULL),(8381,1496,'ferulic_acid_mass_relative_mass',8416,8344,'mean',NULL,NULL,NULL,NULL,NULL),(8382,1496,'Klason_lignin_mass_relative_mass',8417,8344,'mean',NULL,NULL,NULL,NULL,NULL),(8383,1496,'soluble_lignin_mass_relative_mass',8418,8344,'mean',NULL,NULL,NULL,NULL,NULL),(8384,1496,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8385,1496,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8386,1496,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8387,1496,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8388,1496,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8389,1496,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8390,1496,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8391,1496,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8392,1496,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8393,1496,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8394,1496,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8395,1496,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8396,1496,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8397,1496,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8398,1496,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8399,1496,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8400,1496,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8401,1496,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8402,1496,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8403,1496,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8404,1496,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8405,1496,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8406,1496,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8407,1496,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8408,1496,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8409,1496,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8410,1496,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8411,1496,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8412,1496,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8413,1496,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8414,1496,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8415,1496,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8416,1496,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8417,1496,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8418,1496,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8419,1497,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8420,1497,'mass_relative_mass',8419,8419,'mean','se',NULL,1,0,NULL),(8421,1497,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(8422,1497,'ash_mass_relative_mass',8459,8419,'mean',NULL,NULL,NULL,NULL,NULL),(8423,1497,'N_relative_mass',8460,8419,'mean',NULL,NULL,NULL,NULL,NULL),(8424,1497,'P_relative_mass',8461,8419,'mean',NULL,NULL,NULL,NULL,NULL),(8425,1497,'Ca_relative_mass',8462,8419,'mean',NULL,NULL,NULL,NULL,NULL),(8426,1497,'K_relative_mass',8463,8419,'mean',NULL,NULL,NULL,NULL,NULL),(8427,1497,'Mg_relative_mass',8464,8419,'mean',NULL,NULL,NULL,NULL,NULL),(8428,1497,'Mn_relative_mass',8465,8419,'mean',NULL,NULL,NULL,NULL,NULL),(8429,1497,'C_relative_mass',8466,8419,'mean',NULL,NULL,NULL,NULL,NULL),(8430,1497,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8431,1497,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8432,1497,'dichloromethane_extractives_mass_relative_mass',8467,8419,'mean',NULL,NULL,NULL,NULL,NULL),(8433,1497,'acetone_extractives_mass_relative_mass',8468,8419,'mean',NULL,NULL,NULL,NULL,NULL),(8434,1497,'ethanol_extractives_mass_relative_mass',8469,8419,'mean',NULL,NULL,NULL,NULL,NULL),(8435,1497,'water_extractives_mass_relative_mass',8470,8419,'mean',NULL,NULL,NULL,NULL,NULL),(8436,1497,'cellulose_mass_relative_mass',8471,8419,'mean',NULL,NULL,NULL,NULL,NULL),(8437,1497,'arabinose_mass_relative_mass',8472,8419,'mean',NULL,NULL,NULL,NULL,NULL),(8438,1497,'rhamnose_mass_relative_mass',8473,8419,'mean',NULL,NULL,NULL,NULL,NULL),(8439,1497,'xylose_mass_relative_mass',8474,8419,'mean',NULL,NULL,NULL,NULL,NULL),(8440,1497,'mannose_mass_relative_mass',8475,8419,'mean',NULL,NULL,NULL,NULL,NULL),(8441,1497,'galactose_mass_relative_mass',8476,8419,'mean',NULL,NULL,NULL,NULL,NULL),(8442,1497,'glucose_mass_relative_mass',8477,8419,'mean',NULL,NULL,NULL,NULL,NULL),(8443,1497,'glucuronic_acid_mass_relative_mass',8478,8419,'mean',NULL,NULL,NULL,NULL,NULL),(8444,1497,'galacturonic_acid_mass_relative_mass',8479,8419,'mean',NULL,NULL,NULL,NULL,NULL),(8445,1497,'holocellulose_mass_relative_mass',8480,8419,'mean',NULL,NULL,NULL,NULL,NULL),(8446,1497,'4_hydroxybenzaldehyde_mass_relative_mass',8481,8419,'mean',NULL,NULL,NULL,NULL,NULL),(8447,1497,'4_hydroxyacetophenone_mass_relative_mass',8482,8419,'mean',NULL,NULL,NULL,NULL,NULL),(8448,1497,'4_hydroxybenzoic_acid_mass_relative_mass',8483,8419,'mean',NULL,NULL,NULL,NULL,NULL),(8449,1497,'vanillin_mass_relative_mass',8484,8419,'mean',NULL,NULL,NULL,NULL,NULL),(8450,1497,'vanillic_acid_mass_relative_mass',8485,8419,'mean',NULL,NULL,NULL,NULL,NULL),(8451,1497,'acetovanillone_mass_relative_mass',8486,8419,'mean',NULL,NULL,NULL,NULL,NULL),(8452,1497,'syringe_aldehyde_mass_relative_mass',8487,8419,'mean',NULL,NULL,NULL,NULL,NULL),(8453,1497,'acetosyringone_mass_relative_mass',8488,8419,'mean',NULL,NULL,NULL,NULL,NULL),(8454,1497,'syringic_acid_mass_relative_mass',8489,8419,'mean',NULL,NULL,NULL,NULL,NULL),(8455,1497,'p_coumaric_acid_mass_relative_mass',8490,8419,'mean',NULL,NULL,NULL,NULL,NULL),(8456,1497,'ferulic_acid_mass_relative_mass',8491,8419,'mean',NULL,NULL,NULL,NULL,NULL),(8457,1497,'Klason_lignin_mass_relative_mass',8492,8419,'mean',NULL,NULL,NULL,NULL,NULL),(8458,1497,'soluble_lignin_mass_relative_mass',8493,8419,'mean',NULL,NULL,NULL,NULL,NULL),(8459,1497,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8460,1497,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8461,1497,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8462,1497,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8463,1497,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8464,1497,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8465,1497,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8466,1497,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8467,1497,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8468,1497,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8469,1497,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8470,1497,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8471,1497,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8472,1497,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8473,1497,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8474,1497,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8475,1497,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8476,1497,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8477,1497,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8478,1497,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8479,1497,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8480,1497,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8481,1497,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8482,1497,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8483,1497,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8484,1497,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8485,1497,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8486,1497,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8487,1497,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8488,1497,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8489,1497,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8490,1497,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8491,1497,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8492,1497,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8493,1497,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8494,1498,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8495,1498,'mass_relative_mass',8494,8494,'mean','se',NULL,1,0,NULL),(8496,1498,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(8497,1498,'ash_mass_relative_mass',8534,8494,'mean',NULL,NULL,NULL,NULL,NULL),(8498,1498,'N_relative_mass',8535,8494,'mean',NULL,NULL,NULL,NULL,NULL),(8499,1498,'P_relative_mass',8536,8494,'mean',NULL,NULL,NULL,NULL,NULL),(8500,1498,'Ca_relative_mass',8537,8494,'mean',NULL,NULL,NULL,NULL,NULL),(8501,1498,'K_relative_mass',8538,8494,'mean',NULL,NULL,NULL,NULL,NULL),(8502,1498,'Mg_relative_mass',8539,8494,'mean',NULL,NULL,NULL,NULL,NULL),(8503,1498,'Mn_relative_mass',8540,8494,'mean',NULL,NULL,NULL,NULL,NULL),(8504,1498,'C_relative_mass',8541,8494,'mean',NULL,NULL,NULL,NULL,NULL),(8505,1498,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8506,1498,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8507,1498,'dichloromethane_extractives_mass_relative_mass',8542,8494,'mean',NULL,NULL,NULL,NULL,NULL),(8508,1498,'acetone_extractives_mass_relative_mass',8543,8494,'mean',NULL,NULL,NULL,NULL,NULL),(8509,1498,'ethanol_extractives_mass_relative_mass',8544,8494,'mean',NULL,NULL,NULL,NULL,NULL),(8510,1498,'water_extractives_mass_relative_mass',8545,8494,'mean',NULL,NULL,NULL,NULL,NULL),(8511,1498,'cellulose_mass_relative_mass',8546,8494,'mean',NULL,NULL,NULL,NULL,NULL),(8512,1498,'arabinose_mass_relative_mass',8547,8494,'mean',NULL,NULL,NULL,NULL,NULL),(8513,1498,'rhamnose_mass_relative_mass',8548,8494,'mean',NULL,NULL,NULL,NULL,NULL),(8514,1498,'xylose_mass_relative_mass',8549,8494,'mean',NULL,NULL,NULL,NULL,NULL),(8515,1498,'mannose_mass_relative_mass',8550,8494,'mean',NULL,NULL,NULL,NULL,NULL),(8516,1498,'galactose_mass_relative_mass',8551,8494,'mean',NULL,NULL,NULL,NULL,NULL),(8517,1498,'glucose_mass_relative_mass',8552,8494,'mean',NULL,NULL,NULL,NULL,NULL),(8518,1498,'glucuronic_acid_mass_relative_mass',8553,8494,'mean',NULL,NULL,NULL,NULL,NULL),(8519,1498,'galacturonic_acid_mass_relative_mass',8554,8494,'mean',NULL,NULL,NULL,NULL,NULL),(8520,1498,'holocellulose_mass_relative_mass',8555,8494,'mean',NULL,NULL,NULL,NULL,NULL),(8521,1498,'4_hydroxybenzaldehyde_mass_relative_mass',8556,8494,'mean',NULL,NULL,NULL,NULL,NULL),(8522,1498,'4_hydroxyacetophenone_mass_relative_mass',8557,8494,'mean',NULL,NULL,NULL,NULL,NULL),(8523,1498,'4_hydroxybenzoic_acid_mass_relative_mass',8558,8494,'mean',NULL,NULL,NULL,NULL,NULL),(8524,1498,'vanillin_mass_relative_mass',8559,8494,'mean',NULL,NULL,NULL,NULL,NULL),(8525,1498,'vanillic_acid_mass_relative_mass',8560,8494,'mean',NULL,NULL,NULL,NULL,NULL),(8526,1498,'acetovanillone_mass_relative_mass',8561,8494,'mean',NULL,NULL,NULL,NULL,NULL),(8527,1498,'syringe_aldehyde_mass_relative_mass',8562,8494,'mean',NULL,NULL,NULL,NULL,NULL),(8528,1498,'acetosyringone_mass_relative_mass',8563,8494,'mean',NULL,NULL,NULL,NULL,NULL),(8529,1498,'syringic_acid_mass_relative_mass',8564,8494,'mean',NULL,NULL,NULL,NULL,NULL),(8530,1498,'p_coumaric_acid_mass_relative_mass',8565,8494,'mean',NULL,NULL,NULL,NULL,NULL),(8531,1498,'ferulic_acid_mass_relative_mass',8566,8494,'mean',NULL,NULL,NULL,NULL,NULL),(8532,1498,'Klason_lignin_mass_relative_mass',8567,8494,'mean',NULL,NULL,NULL,NULL,NULL),(8533,1498,'soluble_lignin_mass_relative_mass',8568,8494,'mean',NULL,NULL,NULL,NULL,NULL),(8534,1498,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8535,1498,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8536,1498,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8537,1498,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8538,1498,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8539,1498,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8540,1498,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8541,1498,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8542,1498,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8543,1498,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8544,1498,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8545,1498,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8546,1498,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8547,1498,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8548,1498,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8549,1498,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8550,1498,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8551,1498,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8552,1498,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8553,1498,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8554,1498,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8555,1498,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8556,1498,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8557,1498,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8558,1498,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8559,1498,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8560,1498,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8561,1498,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8562,1498,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8563,1498,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8564,1498,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8565,1498,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8566,1498,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8567,1498,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8568,1498,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8569,1499,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8570,1499,'mass_relative_mass',8569,8569,'mean','se',NULL,1,0,NULL),(8571,1499,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(8572,1499,'ash_mass_relative_mass',8609,8569,'mean',NULL,NULL,NULL,NULL,NULL),(8573,1499,'N_relative_mass',8610,8569,'mean',NULL,NULL,NULL,NULL,NULL),(8574,1499,'P_relative_mass',8611,8569,'mean',NULL,NULL,NULL,NULL,NULL),(8575,1499,'Ca_relative_mass',8612,8569,'mean',NULL,NULL,NULL,NULL,NULL),(8576,1499,'K_relative_mass',8613,8569,'mean',NULL,NULL,NULL,NULL,NULL),(8577,1499,'Mg_relative_mass',8614,8569,'mean',NULL,NULL,NULL,NULL,NULL),(8578,1499,'Mn_relative_mass',8615,8569,'mean',NULL,NULL,NULL,NULL,NULL),(8579,1499,'C_relative_mass',8616,8569,'mean',NULL,NULL,NULL,NULL,NULL),(8580,1499,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8581,1499,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8582,1499,'dichloromethane_extractives_mass_relative_mass',8617,8569,'mean',NULL,NULL,NULL,NULL,NULL),(8583,1499,'acetone_extractives_mass_relative_mass',8618,8569,'mean',NULL,NULL,NULL,NULL,NULL),(8584,1499,'ethanol_extractives_mass_relative_mass',8619,8569,'mean',NULL,NULL,NULL,NULL,NULL),(8585,1499,'water_extractives_mass_relative_mass',8620,8569,'mean',NULL,NULL,NULL,NULL,NULL),(8586,1499,'cellulose_mass_relative_mass',8621,8569,'mean',NULL,NULL,NULL,NULL,NULL),(8587,1499,'arabinose_mass_relative_mass',8622,8569,'mean',NULL,NULL,NULL,NULL,NULL),(8588,1499,'rhamnose_mass_relative_mass',8623,8569,'mean',NULL,NULL,NULL,NULL,NULL),(8589,1499,'xylose_mass_relative_mass',8624,8569,'mean',NULL,NULL,NULL,NULL,NULL),(8590,1499,'mannose_mass_relative_mass',8625,8569,'mean',NULL,NULL,NULL,NULL,NULL),(8591,1499,'galactose_mass_relative_mass',8626,8569,'mean',NULL,NULL,NULL,NULL,NULL),(8592,1499,'glucose_mass_relative_mass',8627,8569,'mean',NULL,NULL,NULL,NULL,NULL),(8593,1499,'glucuronic_acid_mass_relative_mass',8628,8569,'mean',NULL,NULL,NULL,NULL,NULL),(8594,1499,'galacturonic_acid_mass_relative_mass',8629,8569,'mean',NULL,NULL,NULL,NULL,NULL),(8595,1499,'holocellulose_mass_relative_mass',8630,8569,'mean',NULL,NULL,NULL,NULL,NULL),(8596,1499,'4_hydroxybenzaldehyde_mass_relative_mass',8631,8569,'mean',NULL,NULL,NULL,NULL,NULL),(8597,1499,'4_hydroxyacetophenone_mass_relative_mass',8632,8569,'mean',NULL,NULL,NULL,NULL,NULL),(8598,1499,'4_hydroxybenzoic_acid_mass_relative_mass',8633,8569,'mean',NULL,NULL,NULL,NULL,NULL),(8599,1499,'vanillin_mass_relative_mass',8634,8569,'mean',NULL,NULL,NULL,NULL,NULL),(8600,1499,'vanillic_acid_mass_relative_mass',8635,8569,'mean',NULL,NULL,NULL,NULL,NULL),(8601,1499,'acetovanillone_mass_relative_mass',8636,8569,'mean',NULL,NULL,NULL,NULL,NULL),(8602,1499,'syringe_aldehyde_mass_relative_mass',8637,8569,'mean',NULL,NULL,NULL,NULL,NULL),(8603,1499,'acetosyringone_mass_relative_mass',8638,8569,'mean',NULL,NULL,NULL,NULL,NULL),(8604,1499,'syringic_acid_mass_relative_mass',8639,8569,'mean',NULL,NULL,NULL,NULL,NULL),(8605,1499,'p_coumaric_acid_mass_relative_mass',8640,8569,'mean',NULL,NULL,NULL,NULL,NULL),(8606,1499,'ferulic_acid_mass_relative_mass',8641,8569,'mean',NULL,NULL,NULL,NULL,NULL),(8607,1499,'Klason_lignin_mass_relative_mass',8642,8569,'mean',NULL,NULL,NULL,NULL,NULL),(8608,1499,'soluble_lignin_mass_relative_mass',8643,8569,'mean',NULL,NULL,NULL,NULL,NULL),(8609,1499,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8610,1499,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8611,1499,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8612,1499,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8613,1499,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8614,1499,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8615,1499,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8616,1499,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8617,1499,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8618,1499,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8619,1499,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8620,1499,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8621,1499,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8622,1499,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8623,1499,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8624,1499,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8625,1499,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8626,1499,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8627,1499,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8628,1499,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8629,1499,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8630,1499,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8631,1499,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8632,1499,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8633,1499,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8634,1499,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8635,1499,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8636,1499,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8637,1499,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8638,1499,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8639,1499,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8640,1499,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8641,1499,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8642,1499,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8643,1499,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8644,1500,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8645,1500,'mass_relative_mass',8644,8644,'mean','se',NULL,1,0,NULL),(8646,1500,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(8647,1500,'ash_mass_relative_mass',8684,8644,'mean',NULL,NULL,NULL,NULL,NULL),(8648,1500,'N_relative_mass',8685,8644,'mean',NULL,NULL,NULL,NULL,NULL),(8649,1500,'P_relative_mass',8686,8644,'mean',NULL,NULL,NULL,NULL,NULL),(8650,1500,'Ca_relative_mass',8687,8644,'mean',NULL,NULL,NULL,NULL,NULL),(8651,1500,'K_relative_mass',8688,8644,'mean',NULL,NULL,NULL,NULL,NULL),(8652,1500,'Mg_relative_mass',8689,8644,'mean',NULL,NULL,NULL,NULL,NULL),(8653,1500,'Mn_relative_mass',8690,8644,'mean',NULL,NULL,NULL,NULL,NULL),(8654,1500,'C_relative_mass',8691,8644,'mean',NULL,NULL,NULL,NULL,NULL),(8655,1500,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8656,1500,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8657,1500,'dichloromethane_extractives_mass_relative_mass',8692,8644,'mean',NULL,NULL,NULL,NULL,NULL),(8658,1500,'acetone_extractives_mass_relative_mass',8693,8644,'mean',NULL,NULL,NULL,NULL,NULL),(8659,1500,'ethanol_extractives_mass_relative_mass',8694,8644,'mean',NULL,NULL,NULL,NULL,NULL),(8660,1500,'water_extractives_mass_relative_mass',8695,8644,'mean',NULL,NULL,NULL,NULL,NULL),(8661,1500,'cellulose_mass_relative_mass',8696,8644,'mean',NULL,NULL,NULL,NULL,NULL),(8662,1500,'arabinose_mass_relative_mass',8697,8644,'mean',NULL,NULL,NULL,NULL,NULL),(8663,1500,'rhamnose_mass_relative_mass',8698,8644,'mean',NULL,NULL,NULL,NULL,NULL),(8664,1500,'xylose_mass_relative_mass',8699,8644,'mean',NULL,NULL,NULL,NULL,NULL),(8665,1500,'mannose_mass_relative_mass',8700,8644,'mean',NULL,NULL,NULL,NULL,NULL),(8666,1500,'galactose_mass_relative_mass',8701,8644,'mean',NULL,NULL,NULL,NULL,NULL),(8667,1500,'glucose_mass_relative_mass',8702,8644,'mean',NULL,NULL,NULL,NULL,NULL),(8668,1500,'glucuronic_acid_mass_relative_mass',8703,8644,'mean',NULL,NULL,NULL,NULL,NULL),(8669,1500,'galacturonic_acid_mass_relative_mass',8704,8644,'mean',NULL,NULL,NULL,NULL,NULL),(8670,1500,'holocellulose_mass_relative_mass',8705,8644,'mean',NULL,NULL,NULL,NULL,NULL),(8671,1500,'4_hydroxybenzaldehyde_mass_relative_mass',8706,8644,'mean',NULL,NULL,NULL,NULL,NULL),(8672,1500,'4_hydroxyacetophenone_mass_relative_mass',8707,8644,'mean',NULL,NULL,NULL,NULL,NULL),(8673,1500,'4_hydroxybenzoic_acid_mass_relative_mass',8708,8644,'mean',NULL,NULL,NULL,NULL,NULL),(8674,1500,'vanillin_mass_relative_mass',8709,8644,'mean',NULL,NULL,NULL,NULL,NULL),(8675,1500,'vanillic_acid_mass_relative_mass',8710,8644,'mean',NULL,NULL,NULL,NULL,NULL),(8676,1500,'acetovanillone_mass_relative_mass',8711,8644,'mean',NULL,NULL,NULL,NULL,NULL),(8677,1500,'syringe_aldehyde_mass_relative_mass',8712,8644,'mean',NULL,NULL,NULL,NULL,NULL),(8678,1500,'acetosyringone_mass_relative_mass',8713,8644,'mean',NULL,NULL,NULL,NULL,NULL),(8679,1500,'syringic_acid_mass_relative_mass',8714,8644,'mean',NULL,NULL,NULL,NULL,NULL),(8680,1500,'p_coumaric_acid_mass_relative_mass',8715,8644,'mean',NULL,NULL,NULL,NULL,NULL),(8681,1500,'ferulic_acid_mass_relative_mass',8716,8644,'mean',NULL,NULL,NULL,NULL,NULL),(8682,1500,'Klason_lignin_mass_relative_mass',8717,8644,'mean',NULL,NULL,NULL,NULL,NULL),(8683,1500,'soluble_lignin_mass_relative_mass',8718,8644,'mean',NULL,NULL,NULL,NULL,NULL),(8684,1500,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8685,1500,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8686,1500,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8687,1500,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8688,1500,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8689,1500,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8690,1500,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8691,1500,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8692,1500,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8693,1500,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8694,1500,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8695,1500,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8696,1500,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8697,1500,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8698,1500,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8699,1500,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8700,1500,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8701,1500,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8702,1500,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8703,1500,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8704,1500,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8705,1500,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8706,1500,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8707,1500,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8708,1500,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8709,1500,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8710,1500,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8711,1500,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8712,1500,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8713,1500,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8714,1500,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8715,1500,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8716,1500,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8717,1500,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8718,1500,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8719,1501,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8720,1501,'mass_relative_mass',8719,8719,'mean','se',NULL,1,0,NULL),(8721,1501,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(8722,1501,'ash_mass_relative_mass',8759,8719,'mean',NULL,NULL,NULL,NULL,NULL),(8723,1501,'N_relative_mass',8760,8719,'mean',NULL,NULL,NULL,NULL,NULL),(8724,1501,'P_relative_mass',8761,8719,'mean',NULL,NULL,NULL,NULL,NULL),(8725,1501,'Ca_relative_mass',8762,8719,'mean',NULL,NULL,NULL,NULL,NULL),(8726,1501,'K_relative_mass',8763,8719,'mean',NULL,NULL,NULL,NULL,NULL),(8727,1501,'Mg_relative_mass',8764,8719,'mean',NULL,NULL,NULL,NULL,NULL),(8728,1501,'Mn_relative_mass',8765,8719,'mean',NULL,NULL,NULL,NULL,NULL),(8729,1501,'C_relative_mass',8766,8719,'mean',NULL,NULL,NULL,NULL,NULL),(8730,1501,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8731,1501,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8732,1501,'dichloromethane_extractives_mass_relative_mass',8767,8719,'mean',NULL,NULL,NULL,NULL,NULL),(8733,1501,'acetone_extractives_mass_relative_mass',8768,8719,'mean',NULL,NULL,NULL,NULL,NULL),(8734,1501,'ethanol_extractives_mass_relative_mass',8769,8719,'mean',NULL,NULL,NULL,NULL,NULL),(8735,1501,'water_extractives_mass_relative_mass',8770,8719,'mean',NULL,NULL,NULL,NULL,NULL),(8736,1501,'cellulose_mass_relative_mass',8771,8719,'mean',NULL,NULL,NULL,NULL,NULL),(8737,1501,'arabinose_mass_relative_mass',8772,8719,'mean',NULL,NULL,NULL,NULL,NULL),(8738,1501,'rhamnose_mass_relative_mass',8773,8719,'mean',NULL,NULL,NULL,NULL,NULL),(8739,1501,'xylose_mass_relative_mass',8774,8719,'mean',NULL,NULL,NULL,NULL,NULL),(8740,1501,'mannose_mass_relative_mass',8775,8719,'mean',NULL,NULL,NULL,NULL,NULL),(8741,1501,'galactose_mass_relative_mass',8776,8719,'mean',NULL,NULL,NULL,NULL,NULL),(8742,1501,'glucose_mass_relative_mass',8777,8719,'mean',NULL,NULL,NULL,NULL,NULL),(8743,1501,'glucuronic_acid_mass_relative_mass',8778,8719,'mean',NULL,NULL,NULL,NULL,NULL),(8744,1501,'galacturonic_acid_mass_relative_mass',8779,8719,'mean',NULL,NULL,NULL,NULL,NULL),(8745,1501,'holocellulose_mass_relative_mass',8780,8719,'mean',NULL,NULL,NULL,NULL,NULL),(8746,1501,'4_hydroxybenzaldehyde_mass_relative_mass',8781,8719,'mean',NULL,NULL,NULL,NULL,NULL),(8747,1501,'4_hydroxyacetophenone_mass_relative_mass',8782,8719,'mean',NULL,NULL,NULL,NULL,NULL),(8748,1501,'4_hydroxybenzoic_acid_mass_relative_mass',8783,8719,'mean',NULL,NULL,NULL,NULL,NULL),(8749,1501,'vanillin_mass_relative_mass',8784,8719,'mean',NULL,NULL,NULL,NULL,NULL),(8750,1501,'vanillic_acid_mass_relative_mass',8785,8719,'mean',NULL,NULL,NULL,NULL,NULL),(8751,1501,'acetovanillone_mass_relative_mass',8786,8719,'mean',NULL,NULL,NULL,NULL,NULL),(8752,1501,'syringe_aldehyde_mass_relative_mass',8787,8719,'mean',NULL,NULL,NULL,NULL,NULL),(8753,1501,'acetosyringone_mass_relative_mass',8788,8719,'mean',NULL,NULL,NULL,NULL,NULL),(8754,1501,'syringic_acid_mass_relative_mass',8789,8719,'mean',NULL,NULL,NULL,NULL,NULL),(8755,1501,'p_coumaric_acid_mass_relative_mass',8790,8719,'mean',NULL,NULL,NULL,NULL,NULL),(8756,1501,'ferulic_acid_mass_relative_mass',8791,8719,'mean',NULL,NULL,NULL,NULL,NULL),(8757,1501,'Klason_lignin_mass_relative_mass',8792,8719,'mean',NULL,NULL,NULL,NULL,NULL),(8758,1501,'soluble_lignin_mass_relative_mass',8793,8719,'mean',NULL,NULL,NULL,NULL,NULL),(8759,1501,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8760,1501,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8761,1501,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8762,1501,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8763,1501,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8764,1501,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8765,1501,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8766,1501,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8767,1501,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8768,1501,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8769,1501,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8770,1501,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8771,1501,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8772,1501,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8773,1501,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8774,1501,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8775,1501,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8776,1501,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8777,1501,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8778,1501,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8779,1501,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8780,1501,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8781,1501,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8782,1501,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8783,1501,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8784,1501,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8785,1501,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8786,1501,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8787,1501,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8788,1501,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8789,1501,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8790,1501,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8791,1501,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8792,1501,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8793,1501,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8794,1502,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8795,1502,'mass_relative_mass',8794,8794,'mean','se',NULL,1,0,NULL),(8796,1502,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(8797,1502,'ash_mass_relative_mass',8834,8794,'mean',NULL,NULL,NULL,NULL,NULL),(8798,1502,'N_relative_mass',8835,8794,'mean',NULL,NULL,NULL,NULL,NULL),(8799,1502,'P_relative_mass',8836,8794,'mean',NULL,NULL,NULL,NULL,NULL),(8800,1502,'Ca_relative_mass',8837,8794,'mean',NULL,NULL,NULL,NULL,NULL),(8801,1502,'K_relative_mass',8838,8794,'mean',NULL,NULL,NULL,NULL,NULL),(8802,1502,'Mg_relative_mass',8839,8794,'mean',NULL,NULL,NULL,NULL,NULL),(8803,1502,'Mn_relative_mass',8840,8794,'mean',NULL,NULL,NULL,NULL,NULL),(8804,1502,'C_relative_mass',8841,8794,'mean',NULL,NULL,NULL,NULL,NULL),(8805,1502,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8806,1502,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8807,1502,'dichloromethane_extractives_mass_relative_mass',8842,8794,'mean',NULL,NULL,NULL,NULL,NULL),(8808,1502,'acetone_extractives_mass_relative_mass',8843,8794,'mean',NULL,NULL,NULL,NULL,NULL),(8809,1502,'ethanol_extractives_mass_relative_mass',8844,8794,'mean',NULL,NULL,NULL,NULL,NULL),(8810,1502,'water_extractives_mass_relative_mass',8845,8794,'mean',NULL,NULL,NULL,NULL,NULL),(8811,1502,'cellulose_mass_relative_mass',8846,8794,'mean',NULL,NULL,NULL,NULL,NULL),(8812,1502,'arabinose_mass_relative_mass',8847,8794,'mean',NULL,NULL,NULL,NULL,NULL),(8813,1502,'rhamnose_mass_relative_mass',8848,8794,'mean',NULL,NULL,NULL,NULL,NULL),(8814,1502,'xylose_mass_relative_mass',8849,8794,'mean',NULL,NULL,NULL,NULL,NULL),(8815,1502,'mannose_mass_relative_mass',8850,8794,'mean',NULL,NULL,NULL,NULL,NULL),(8816,1502,'galactose_mass_relative_mass',8851,8794,'mean',NULL,NULL,NULL,NULL,NULL),(8817,1502,'glucose_mass_relative_mass',8852,8794,'mean',NULL,NULL,NULL,NULL,NULL),(8818,1502,'glucuronic_acid_mass_relative_mass',8853,8794,'mean',NULL,NULL,NULL,NULL,NULL),(8819,1502,'galacturonic_acid_mass_relative_mass',8854,8794,'mean',NULL,NULL,NULL,NULL,NULL),(8820,1502,'holocellulose_mass_relative_mass',8855,8794,'mean',NULL,NULL,NULL,NULL,NULL),(8821,1502,'4_hydroxybenzaldehyde_mass_relative_mass',8856,8794,'mean',NULL,NULL,NULL,NULL,NULL),(8822,1502,'4_hydroxyacetophenone_mass_relative_mass',8857,8794,'mean',NULL,NULL,NULL,NULL,NULL),(8823,1502,'4_hydroxybenzoic_acid_mass_relative_mass',8858,8794,'mean',NULL,NULL,NULL,NULL,NULL),(8824,1502,'vanillin_mass_relative_mass',8859,8794,'mean',NULL,NULL,NULL,NULL,NULL),(8825,1502,'vanillic_acid_mass_relative_mass',8860,8794,'mean',NULL,NULL,NULL,NULL,NULL),(8826,1502,'acetovanillone_mass_relative_mass',8861,8794,'mean',NULL,NULL,NULL,NULL,NULL),(8827,1502,'syringe_aldehyde_mass_relative_mass',8862,8794,'mean',NULL,NULL,NULL,NULL,NULL),(8828,1502,'acetosyringone_mass_relative_mass',8863,8794,'mean',NULL,NULL,NULL,NULL,NULL),(8829,1502,'syringic_acid_mass_relative_mass',8864,8794,'mean',NULL,NULL,NULL,NULL,NULL),(8830,1502,'p_coumaric_acid_mass_relative_mass',8865,8794,'mean',NULL,NULL,NULL,NULL,NULL),(8831,1502,'ferulic_acid_mass_relative_mass',8866,8794,'mean',NULL,NULL,NULL,NULL,NULL),(8832,1502,'Klason_lignin_mass_relative_mass',8867,8794,'mean',NULL,NULL,NULL,NULL,NULL),(8833,1502,'soluble_lignin_mass_relative_mass',8868,8794,'mean',NULL,NULL,NULL,NULL,NULL),(8834,1502,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8835,1502,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8836,1502,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8837,1502,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8838,1502,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8839,1502,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8840,1502,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8841,1502,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8842,1502,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8843,1502,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8844,1502,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8845,1502,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8846,1502,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8847,1502,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8848,1502,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8849,1502,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8850,1502,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8851,1502,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8852,1502,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8853,1502,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8854,1502,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8855,1502,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8856,1502,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8857,1502,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8858,1502,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8859,1502,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8860,1502,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8861,1502,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8862,1502,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8863,1502,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8864,1502,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8865,1502,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8866,1502,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8867,1502,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8868,1502,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8869,1503,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8870,1503,'mass_relative_mass',8869,8869,'mean','se',NULL,1,0,NULL),(8871,1503,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(8872,1503,'ash_mass_relative_mass',8909,8869,'mean',NULL,NULL,NULL,NULL,NULL),(8873,1503,'N_relative_mass',8910,8869,'mean',NULL,NULL,NULL,NULL,NULL),(8874,1503,'P_relative_mass',8911,8869,'mean',NULL,NULL,NULL,NULL,NULL),(8875,1503,'Ca_relative_mass',8912,8869,'mean',NULL,NULL,NULL,NULL,NULL),(8876,1503,'K_relative_mass',8913,8869,'mean',NULL,NULL,NULL,NULL,NULL),(8877,1503,'Mg_relative_mass',8914,8869,'mean',NULL,NULL,NULL,NULL,NULL),(8878,1503,'Mn_relative_mass',8915,8869,'mean',NULL,NULL,NULL,NULL,NULL),(8879,1503,'C_relative_mass',8916,8869,'mean',NULL,NULL,NULL,NULL,NULL),(8880,1503,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8881,1503,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8882,1503,'dichloromethane_extractives_mass_relative_mass',8917,8869,'mean',NULL,NULL,NULL,NULL,NULL),(8883,1503,'acetone_extractives_mass_relative_mass',8918,8869,'mean',NULL,NULL,NULL,NULL,NULL),(8884,1503,'ethanol_extractives_mass_relative_mass',8919,8869,'mean',NULL,NULL,NULL,NULL,NULL),(8885,1503,'water_extractives_mass_relative_mass',8920,8869,'mean',NULL,NULL,NULL,NULL,NULL),(8886,1503,'cellulose_mass_relative_mass',8921,8869,'mean',NULL,NULL,NULL,NULL,NULL),(8887,1503,'arabinose_mass_relative_mass',8922,8869,'mean',NULL,NULL,NULL,NULL,NULL),(8888,1503,'rhamnose_mass_relative_mass',8923,8869,'mean',NULL,NULL,NULL,NULL,NULL),(8889,1503,'xylose_mass_relative_mass',8924,8869,'mean',NULL,NULL,NULL,NULL,NULL),(8890,1503,'mannose_mass_relative_mass',8925,8869,'mean',NULL,NULL,NULL,NULL,NULL),(8891,1503,'galactose_mass_relative_mass',8926,8869,'mean',NULL,NULL,NULL,NULL,NULL),(8892,1503,'glucose_mass_relative_mass',8927,8869,'mean',NULL,NULL,NULL,NULL,NULL),(8893,1503,'glucuronic_acid_mass_relative_mass',8928,8869,'mean',NULL,NULL,NULL,NULL,NULL),(8894,1503,'galacturonic_acid_mass_relative_mass',8929,8869,'mean',NULL,NULL,NULL,NULL,NULL),(8895,1503,'holocellulose_mass_relative_mass',8930,8869,'mean',NULL,NULL,NULL,NULL,NULL),(8896,1503,'4_hydroxybenzaldehyde_mass_relative_mass',8931,8869,'mean',NULL,NULL,NULL,NULL,NULL),(8897,1503,'4_hydroxyacetophenone_mass_relative_mass',8932,8869,'mean',NULL,NULL,NULL,NULL,NULL),(8898,1503,'4_hydroxybenzoic_acid_mass_relative_mass',8933,8869,'mean',NULL,NULL,NULL,NULL,NULL),(8899,1503,'vanillin_mass_relative_mass',8934,8869,'mean',NULL,NULL,NULL,NULL,NULL),(8900,1503,'vanillic_acid_mass_relative_mass',8935,8869,'mean',NULL,NULL,NULL,NULL,NULL),(8901,1503,'acetovanillone_mass_relative_mass',8936,8869,'mean',NULL,NULL,NULL,NULL,NULL),(8902,1503,'syringe_aldehyde_mass_relative_mass',8937,8869,'mean',NULL,NULL,NULL,NULL,NULL),(8903,1503,'acetosyringone_mass_relative_mass',8938,8869,'mean',NULL,NULL,NULL,NULL,NULL),(8904,1503,'syringic_acid_mass_relative_mass',8939,8869,'mean',NULL,NULL,NULL,NULL,NULL),(8905,1503,'p_coumaric_acid_mass_relative_mass',8940,8869,'mean',NULL,NULL,NULL,NULL,NULL),(8906,1503,'ferulic_acid_mass_relative_mass',8941,8869,'mean',NULL,NULL,NULL,NULL,NULL),(8907,1503,'Klason_lignin_mass_relative_mass',8942,8869,'mean',NULL,NULL,NULL,NULL,NULL),(8908,1503,'soluble_lignin_mass_relative_mass',8943,8869,'mean',NULL,NULL,NULL,NULL,NULL),(8909,1503,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8910,1503,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8911,1503,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8912,1503,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8913,1503,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8914,1503,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8915,1503,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8916,1503,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8917,1503,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8918,1503,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8919,1503,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8920,1503,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8921,1503,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8922,1503,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8923,1503,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8924,1503,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8925,1503,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8926,1503,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8927,1503,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8928,1503,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8929,1503,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8930,1503,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8931,1503,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8932,1503,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8933,1503,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8934,1503,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8935,1503,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8936,1503,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8937,1503,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8938,1503,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8939,1503,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8940,1503,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8941,1503,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8942,1503,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8943,1503,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8944,1504,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8945,1504,'mass_relative_mass',8944,8944,'mean','se',NULL,1,0,NULL),(8946,1504,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(8947,1504,'ash_mass_relative_mass',8984,8944,'mean',NULL,NULL,NULL,NULL,NULL),(8948,1504,'N_relative_mass',8985,8944,'mean',NULL,NULL,NULL,NULL,NULL),(8949,1504,'P_relative_mass',8986,8944,'mean',NULL,NULL,NULL,NULL,NULL),(8950,1504,'Ca_relative_mass',8987,8944,'mean',NULL,NULL,NULL,NULL,NULL),(8951,1504,'K_relative_mass',8988,8944,'mean',NULL,NULL,NULL,NULL,NULL),(8952,1504,'Mg_relative_mass',8989,8944,'mean',NULL,NULL,NULL,NULL,NULL),(8953,1504,'Mn_relative_mass',8990,8944,'mean',NULL,NULL,NULL,NULL,NULL),(8954,1504,'C_relative_mass',8991,8944,'mean',NULL,NULL,NULL,NULL,NULL),(8955,1504,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8956,1504,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8957,1504,'dichloromethane_extractives_mass_relative_mass',8992,8944,'mean',NULL,NULL,NULL,NULL,NULL),(8958,1504,'acetone_extractives_mass_relative_mass',8993,8944,'mean',NULL,NULL,NULL,NULL,NULL),(8959,1504,'ethanol_extractives_mass_relative_mass',8994,8944,'mean',NULL,NULL,NULL,NULL,NULL),(8960,1504,'water_extractives_mass_relative_mass',8995,8944,'mean',NULL,NULL,NULL,NULL,NULL),(8961,1504,'cellulose_mass_relative_mass',8996,8944,'mean',NULL,NULL,NULL,NULL,NULL),(8962,1504,'arabinose_mass_relative_mass',8997,8944,'mean',NULL,NULL,NULL,NULL,NULL),(8963,1504,'rhamnose_mass_relative_mass',8998,8944,'mean',NULL,NULL,NULL,NULL,NULL),(8964,1504,'xylose_mass_relative_mass',8999,8944,'mean',NULL,NULL,NULL,NULL,NULL),(8965,1504,'mannose_mass_relative_mass',9000,8944,'mean',NULL,NULL,NULL,NULL,NULL),(8966,1504,'galactose_mass_relative_mass',9001,8944,'mean',NULL,NULL,NULL,NULL,NULL),(8967,1504,'glucose_mass_relative_mass',9002,8944,'mean',NULL,NULL,NULL,NULL,NULL),(8968,1504,'glucuronic_acid_mass_relative_mass',9003,8944,'mean',NULL,NULL,NULL,NULL,NULL),(8969,1504,'galacturonic_acid_mass_relative_mass',9004,8944,'mean',NULL,NULL,NULL,NULL,NULL),(8970,1504,'holocellulose_mass_relative_mass',9005,8944,'mean',NULL,NULL,NULL,NULL,NULL),(8971,1504,'4_hydroxybenzaldehyde_mass_relative_mass',9006,8944,'mean',NULL,NULL,NULL,NULL,NULL),(8972,1504,'4_hydroxyacetophenone_mass_relative_mass',9007,8944,'mean',NULL,NULL,NULL,NULL,NULL),(8973,1504,'4_hydroxybenzoic_acid_mass_relative_mass',9008,8944,'mean',NULL,NULL,NULL,NULL,NULL),(8974,1504,'vanillin_mass_relative_mass',9009,8944,'mean',NULL,NULL,NULL,NULL,NULL),(8975,1504,'vanillic_acid_mass_relative_mass',9010,8944,'mean',NULL,NULL,NULL,NULL,NULL),(8976,1504,'acetovanillone_mass_relative_mass',9011,8944,'mean',NULL,NULL,NULL,NULL,NULL),(8977,1504,'syringe_aldehyde_mass_relative_mass',9012,8944,'mean',NULL,NULL,NULL,NULL,NULL),(8978,1504,'acetosyringone_mass_relative_mass',9013,8944,'mean',NULL,NULL,NULL,NULL,NULL),(8979,1504,'syringic_acid_mass_relative_mass',9014,8944,'mean',NULL,NULL,NULL,NULL,NULL),(8980,1504,'p_coumaric_acid_mass_relative_mass',9015,8944,'mean',NULL,NULL,NULL,NULL,NULL),(8981,1504,'ferulic_acid_mass_relative_mass',9016,8944,'mean',NULL,NULL,NULL,NULL,NULL),(8982,1504,'Klason_lignin_mass_relative_mass',9017,8944,'mean',NULL,NULL,NULL,NULL,NULL),(8983,1504,'soluble_lignin_mass_relative_mass',9018,8944,'mean',NULL,NULL,NULL,NULL,NULL),(8984,1504,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8985,1504,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8986,1504,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8987,1504,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8988,1504,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8989,1504,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8990,1504,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8991,1504,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8992,1504,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8993,1504,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8994,1504,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8995,1504,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8996,1504,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8997,1504,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8998,1504,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(8999,1504,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9000,1504,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9001,1504,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9002,1504,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9003,1504,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9004,1504,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9005,1504,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9006,1504,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9007,1504,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9008,1504,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9009,1504,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9010,1504,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9011,1504,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9012,1504,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9013,1504,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9014,1504,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9015,1504,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9016,1504,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9017,1504,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9018,1504,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9019,1505,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9020,1505,'mass_relative_mass',9019,9019,'mean','se',NULL,1,0,NULL),(9021,1505,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(9022,1505,'ash_mass_relative_mass',9059,9019,'mean',NULL,NULL,NULL,NULL,NULL),(9023,1505,'N_relative_mass',9060,9019,'mean',NULL,NULL,NULL,NULL,NULL),(9024,1505,'P_relative_mass',9061,9019,'mean',NULL,NULL,NULL,NULL,NULL),(9025,1505,'Ca_relative_mass',9062,9019,'mean',NULL,NULL,NULL,NULL,NULL),(9026,1505,'K_relative_mass',9063,9019,'mean',NULL,NULL,NULL,NULL,NULL),(9027,1505,'Mg_relative_mass',9064,9019,'mean',NULL,NULL,NULL,NULL,NULL),(9028,1505,'Mn_relative_mass',9065,9019,'mean',NULL,NULL,NULL,NULL,NULL),(9029,1505,'C_relative_mass',9066,9019,'mean',NULL,NULL,NULL,NULL,NULL),(9030,1505,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9031,1505,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9032,1505,'dichloromethane_extractives_mass_relative_mass',9067,9019,'mean',NULL,NULL,NULL,NULL,NULL),(9033,1505,'acetone_extractives_mass_relative_mass',9068,9019,'mean',NULL,NULL,NULL,NULL,NULL),(9034,1505,'ethanol_extractives_mass_relative_mass',9069,9019,'mean',NULL,NULL,NULL,NULL,NULL),(9035,1505,'water_extractives_mass_relative_mass',9070,9019,'mean',NULL,NULL,NULL,NULL,NULL),(9036,1505,'cellulose_mass_relative_mass',9071,9019,'mean',NULL,NULL,NULL,NULL,NULL),(9037,1505,'arabinose_mass_relative_mass',9072,9019,'mean',NULL,NULL,NULL,NULL,NULL),(9038,1505,'rhamnose_mass_relative_mass',9073,9019,'mean',NULL,NULL,NULL,NULL,NULL),(9039,1505,'xylose_mass_relative_mass',9074,9019,'mean',NULL,NULL,NULL,NULL,NULL),(9040,1505,'mannose_mass_relative_mass',9075,9019,'mean',NULL,NULL,NULL,NULL,NULL),(9041,1505,'galactose_mass_relative_mass',9076,9019,'mean',NULL,NULL,NULL,NULL,NULL),(9042,1505,'glucose_mass_relative_mass',9077,9019,'mean',NULL,NULL,NULL,NULL,NULL),(9043,1505,'glucuronic_acid_mass_relative_mass',9078,9019,'mean',NULL,NULL,NULL,NULL,NULL),(9044,1505,'galacturonic_acid_mass_relative_mass',9079,9019,'mean',NULL,NULL,NULL,NULL,NULL),(9045,1505,'holocellulose_mass_relative_mass',9080,9019,'mean',NULL,NULL,NULL,NULL,NULL),(9046,1505,'4_hydroxybenzaldehyde_mass_relative_mass',9081,9019,'mean',NULL,NULL,NULL,NULL,NULL),(9047,1505,'4_hydroxyacetophenone_mass_relative_mass',9082,9019,'mean',NULL,NULL,NULL,NULL,NULL),(9048,1505,'4_hydroxybenzoic_acid_mass_relative_mass',9083,9019,'mean',NULL,NULL,NULL,NULL,NULL),(9049,1505,'vanillin_mass_relative_mass',9084,9019,'mean',NULL,NULL,NULL,NULL,NULL),(9050,1505,'vanillic_acid_mass_relative_mass',9085,9019,'mean',NULL,NULL,NULL,NULL,NULL),(9051,1505,'acetovanillone_mass_relative_mass',9086,9019,'mean',NULL,NULL,NULL,NULL,NULL),(9052,1505,'syringe_aldehyde_mass_relative_mass',9087,9019,'mean',NULL,NULL,NULL,NULL,NULL),(9053,1505,'acetosyringone_mass_relative_mass',9088,9019,'mean',NULL,NULL,NULL,NULL,NULL),(9054,1505,'syringic_acid_mass_relative_mass',9089,9019,'mean',NULL,NULL,NULL,NULL,NULL),(9055,1505,'p_coumaric_acid_mass_relative_mass',9090,9019,'mean',NULL,NULL,NULL,NULL,NULL),(9056,1505,'ferulic_acid_mass_relative_mass',9091,9019,'mean',NULL,NULL,NULL,NULL,NULL),(9057,1505,'Klason_lignin_mass_relative_mass',9092,9019,'mean',NULL,NULL,NULL,NULL,NULL),(9058,1505,'soluble_lignin_mass_relative_mass',9093,9019,'mean',NULL,NULL,NULL,NULL,NULL),(9059,1505,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9060,1505,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9061,1505,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9062,1505,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9063,1505,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9064,1505,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9065,1505,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9066,1505,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9067,1505,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9068,1505,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9069,1505,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9070,1505,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9071,1505,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9072,1505,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9073,1505,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9074,1505,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9075,1505,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9076,1505,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9077,1505,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9078,1505,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9079,1505,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9080,1505,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9081,1505,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9082,1505,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9083,1505,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9084,1505,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9085,1505,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9086,1505,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9087,1505,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9088,1505,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9089,1505,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9090,1505,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9091,1505,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9092,1505,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9093,1505,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9094,1506,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9095,1506,'mass_relative_mass',9094,9094,'mean','se',NULL,1,0,NULL),(9096,1506,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(9097,1506,'ash_mass_relative_mass',9134,9094,'mean',NULL,NULL,NULL,NULL,NULL),(9098,1506,'N_relative_mass',9135,9094,'mean',NULL,NULL,NULL,NULL,NULL),(9099,1506,'P_relative_mass',9136,9094,'mean',NULL,NULL,NULL,NULL,NULL),(9100,1506,'Ca_relative_mass',9137,9094,'mean',NULL,NULL,NULL,NULL,NULL),(9101,1506,'K_relative_mass',9138,9094,'mean',NULL,NULL,NULL,NULL,NULL),(9102,1506,'Mg_relative_mass',9139,9094,'mean',NULL,NULL,NULL,NULL,NULL),(9103,1506,'Mn_relative_mass',9140,9094,'mean',NULL,NULL,NULL,NULL,NULL),(9104,1506,'C_relative_mass',9141,9094,'mean',NULL,NULL,NULL,NULL,NULL),(9105,1506,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9106,1506,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9107,1506,'dichloromethane_extractives_mass_relative_mass',9142,9094,'mean',NULL,NULL,NULL,NULL,NULL),(9108,1506,'acetone_extractives_mass_relative_mass',9143,9094,'mean',NULL,NULL,NULL,NULL,NULL),(9109,1506,'ethanol_extractives_mass_relative_mass',9144,9094,'mean',NULL,NULL,NULL,NULL,NULL),(9110,1506,'water_extractives_mass_relative_mass',9145,9094,'mean',NULL,NULL,NULL,NULL,NULL),(9111,1506,'cellulose_mass_relative_mass',9146,9094,'mean',NULL,NULL,NULL,NULL,NULL),(9112,1506,'arabinose_mass_relative_mass',9147,9094,'mean',NULL,NULL,NULL,NULL,NULL),(9113,1506,'rhamnose_mass_relative_mass',9148,9094,'mean',NULL,NULL,NULL,NULL,NULL),(9114,1506,'xylose_mass_relative_mass',9149,9094,'mean',NULL,NULL,NULL,NULL,NULL),(9115,1506,'mannose_mass_relative_mass',9150,9094,'mean',NULL,NULL,NULL,NULL,NULL),(9116,1506,'galactose_mass_relative_mass',9151,9094,'mean',NULL,NULL,NULL,NULL,NULL),(9117,1506,'glucose_mass_relative_mass',9152,9094,'mean',NULL,NULL,NULL,NULL,NULL),(9118,1506,'glucuronic_acid_mass_relative_mass',9153,9094,'mean',NULL,NULL,NULL,NULL,NULL),(9119,1506,'galacturonic_acid_mass_relative_mass',9154,9094,'mean',NULL,NULL,NULL,NULL,NULL),(9120,1506,'holocellulose_mass_relative_mass',9155,9094,'mean',NULL,NULL,NULL,NULL,NULL),(9121,1506,'4_hydroxybenzaldehyde_mass_relative_mass',9156,9094,'mean',NULL,NULL,NULL,NULL,NULL),(9122,1506,'4_hydroxyacetophenone_mass_relative_mass',9157,9094,'mean',NULL,NULL,NULL,NULL,NULL),(9123,1506,'4_hydroxybenzoic_acid_mass_relative_mass',9158,9094,'mean',NULL,NULL,NULL,NULL,NULL),(9124,1506,'vanillin_mass_relative_mass',9159,9094,'mean',NULL,NULL,NULL,NULL,NULL),(9125,1506,'vanillic_acid_mass_relative_mass',9160,9094,'mean',NULL,NULL,NULL,NULL,NULL),(9126,1506,'acetovanillone_mass_relative_mass',9161,9094,'mean',NULL,NULL,NULL,NULL,NULL),(9127,1506,'syringe_aldehyde_mass_relative_mass',9162,9094,'mean',NULL,NULL,NULL,NULL,NULL),(9128,1506,'acetosyringone_mass_relative_mass',9163,9094,'mean',NULL,NULL,NULL,NULL,NULL),(9129,1506,'syringic_acid_mass_relative_mass',9164,9094,'mean',NULL,NULL,NULL,NULL,NULL),(9130,1506,'p_coumaric_acid_mass_relative_mass',9165,9094,'mean',NULL,NULL,NULL,NULL,NULL),(9131,1506,'ferulic_acid_mass_relative_mass',9166,9094,'mean',NULL,NULL,NULL,NULL,NULL),(9132,1506,'Klason_lignin_mass_relative_mass',9167,9094,'mean',NULL,NULL,NULL,NULL,NULL),(9133,1506,'soluble_lignin_mass_relative_mass',9168,9094,'mean',NULL,NULL,NULL,NULL,NULL),(9134,1506,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9135,1506,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9136,1506,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9137,1506,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9138,1506,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9139,1506,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9140,1506,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9141,1506,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9142,1506,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9143,1506,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9144,1506,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9145,1506,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9146,1506,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9147,1506,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9148,1506,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9149,1506,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9150,1506,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9151,1506,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9152,1506,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9153,1506,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9154,1506,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9155,1506,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9156,1506,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9157,1506,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9158,1506,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9159,1506,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9160,1506,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9161,1506,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9162,1506,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9163,1506,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9164,1506,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9165,1506,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9166,1506,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9167,1506,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9168,1506,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9169,1507,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9170,1507,'mass_relative_mass',9169,9169,'mean','se',NULL,1,0,NULL),(9171,1507,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(9172,1507,'ash_mass_relative_mass',9209,9169,'mean',NULL,NULL,NULL,NULL,NULL),(9173,1507,'N_relative_mass',9210,9169,'mean',NULL,NULL,NULL,NULL,NULL),(9174,1507,'P_relative_mass',9211,9169,'mean',NULL,NULL,NULL,NULL,NULL),(9175,1507,'Ca_relative_mass',9212,9169,'mean',NULL,NULL,NULL,NULL,NULL),(9176,1507,'K_relative_mass',9213,9169,'mean',NULL,NULL,NULL,NULL,NULL),(9177,1507,'Mg_relative_mass',9214,9169,'mean',NULL,NULL,NULL,NULL,NULL),(9178,1507,'Mn_relative_mass',9215,9169,'mean',NULL,NULL,NULL,NULL,NULL),(9179,1507,'C_relative_mass',9216,9169,'mean',NULL,NULL,NULL,NULL,NULL),(9180,1507,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9181,1507,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9182,1507,'dichloromethane_extractives_mass_relative_mass',9217,9169,'mean',NULL,NULL,NULL,NULL,NULL),(9183,1507,'acetone_extractives_mass_relative_mass',9218,9169,'mean',NULL,NULL,NULL,NULL,NULL),(9184,1507,'ethanol_extractives_mass_relative_mass',9219,9169,'mean',NULL,NULL,NULL,NULL,NULL),(9185,1507,'water_extractives_mass_relative_mass',9220,9169,'mean',NULL,NULL,NULL,NULL,NULL),(9186,1507,'cellulose_mass_relative_mass',9221,9169,'mean',NULL,NULL,NULL,NULL,NULL),(9187,1507,'arabinose_mass_relative_mass',9222,9169,'mean',NULL,NULL,NULL,NULL,NULL),(9188,1507,'rhamnose_mass_relative_mass',9223,9169,'mean',NULL,NULL,NULL,NULL,NULL),(9189,1507,'xylose_mass_relative_mass',9224,9169,'mean',NULL,NULL,NULL,NULL,NULL),(9190,1507,'mannose_mass_relative_mass',9225,9169,'mean',NULL,NULL,NULL,NULL,NULL),(9191,1507,'galactose_mass_relative_mass',9226,9169,'mean',NULL,NULL,NULL,NULL,NULL),(9192,1507,'glucose_mass_relative_mass',9227,9169,'mean',NULL,NULL,NULL,NULL,NULL),(9193,1507,'glucuronic_acid_mass_relative_mass',9228,9169,'mean',NULL,NULL,NULL,NULL,NULL),(9194,1507,'galacturonic_acid_mass_relative_mass',9229,9169,'mean',NULL,NULL,NULL,NULL,NULL),(9195,1507,'holocellulose_mass_relative_mass',9230,9169,'mean',NULL,NULL,NULL,NULL,NULL),(9196,1507,'4_hydroxybenzaldehyde_mass_relative_mass',9231,9169,'mean',NULL,NULL,NULL,NULL,NULL),(9197,1507,'4_hydroxyacetophenone_mass_relative_mass',9232,9169,'mean',NULL,NULL,NULL,NULL,NULL),(9198,1507,'4_hydroxybenzoic_acid_mass_relative_mass',9233,9169,'mean',NULL,NULL,NULL,NULL,NULL),(9199,1507,'vanillin_mass_relative_mass',9234,9169,'mean',NULL,NULL,NULL,NULL,NULL),(9200,1507,'vanillic_acid_mass_relative_mass',9235,9169,'mean',NULL,NULL,NULL,NULL,NULL),(9201,1507,'acetovanillone_mass_relative_mass',9236,9169,'mean',NULL,NULL,NULL,NULL,NULL),(9202,1507,'syringe_aldehyde_mass_relative_mass',9237,9169,'mean',NULL,NULL,NULL,NULL,NULL),(9203,1507,'acetosyringone_mass_relative_mass',9238,9169,'mean',NULL,NULL,NULL,NULL,NULL),(9204,1507,'syringic_acid_mass_relative_mass',9239,9169,'mean',NULL,NULL,NULL,NULL,NULL),(9205,1507,'p_coumaric_acid_mass_relative_mass',9240,9169,'mean',NULL,NULL,NULL,NULL,NULL),(9206,1507,'ferulic_acid_mass_relative_mass',9241,9169,'mean',NULL,NULL,NULL,NULL,NULL),(9207,1507,'Klason_lignin_mass_relative_mass',9242,9169,'mean',NULL,NULL,NULL,NULL,NULL),(9208,1507,'soluble_lignin_mass_relative_mass',9243,9169,'mean',NULL,NULL,NULL,NULL,NULL),(9209,1507,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9210,1507,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9211,1507,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9212,1507,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9213,1507,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9214,1507,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9215,1507,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9216,1507,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9217,1507,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9218,1507,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9219,1507,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9220,1507,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9221,1507,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9222,1507,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9223,1507,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9224,1507,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9225,1507,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9226,1507,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9227,1507,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9228,1507,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9229,1507,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9230,1507,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9231,1507,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9232,1507,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9233,1507,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9234,1507,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9235,1507,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9236,1507,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9237,1507,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9238,1507,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9239,1507,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9240,1507,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9241,1507,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9242,1507,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9243,1507,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9244,1508,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9245,1508,'mass_relative_mass',9244,9244,'mean','se',NULL,1,0,NULL),(9246,1508,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(9247,1508,'ash_mass_relative_mass',9284,9244,'mean',NULL,NULL,NULL,NULL,NULL),(9248,1508,'N_relative_mass',9285,9244,'mean',NULL,NULL,NULL,NULL,NULL),(9249,1508,'P_relative_mass',9286,9244,'mean',NULL,NULL,NULL,NULL,NULL),(9250,1508,'Ca_relative_mass',9287,9244,'mean',NULL,NULL,NULL,NULL,NULL),(9251,1508,'K_relative_mass',9288,9244,'mean',NULL,NULL,NULL,NULL,NULL),(9252,1508,'Mg_relative_mass',9289,9244,'mean',NULL,NULL,NULL,NULL,NULL),(9253,1508,'Mn_relative_mass',9290,9244,'mean',NULL,NULL,NULL,NULL,NULL),(9254,1508,'C_relative_mass',9291,9244,'mean',NULL,NULL,NULL,NULL,NULL),(9255,1508,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9256,1508,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9257,1508,'dichloromethane_extractives_mass_relative_mass',9292,9244,'mean',NULL,NULL,NULL,NULL,NULL),(9258,1508,'acetone_extractives_mass_relative_mass',9293,9244,'mean',NULL,NULL,NULL,NULL,NULL),(9259,1508,'ethanol_extractives_mass_relative_mass',9294,9244,'mean',NULL,NULL,NULL,NULL,NULL),(9260,1508,'water_extractives_mass_relative_mass',9295,9244,'mean',NULL,NULL,NULL,NULL,NULL),(9261,1508,'cellulose_mass_relative_mass',9296,9244,'mean',NULL,NULL,NULL,NULL,NULL),(9262,1508,'arabinose_mass_relative_mass',9297,9244,'mean',NULL,NULL,NULL,NULL,NULL),(9263,1508,'rhamnose_mass_relative_mass',9298,9244,'mean',NULL,NULL,NULL,NULL,NULL),(9264,1508,'xylose_mass_relative_mass',9299,9244,'mean',NULL,NULL,NULL,NULL,NULL),(9265,1508,'mannose_mass_relative_mass',9300,9244,'mean',NULL,NULL,NULL,NULL,NULL),(9266,1508,'galactose_mass_relative_mass',9301,9244,'mean',NULL,NULL,NULL,NULL,NULL),(9267,1508,'glucose_mass_relative_mass',9302,9244,'mean',NULL,NULL,NULL,NULL,NULL),(9268,1508,'glucuronic_acid_mass_relative_mass',9303,9244,'mean',NULL,NULL,NULL,NULL,NULL),(9269,1508,'galacturonic_acid_mass_relative_mass',9304,9244,'mean',NULL,NULL,NULL,NULL,NULL),(9270,1508,'holocellulose_mass_relative_mass',9305,9244,'mean',NULL,NULL,NULL,NULL,NULL),(9271,1508,'4_hydroxybenzaldehyde_mass_relative_mass',9306,9244,'mean',NULL,NULL,NULL,NULL,NULL),(9272,1508,'4_hydroxyacetophenone_mass_relative_mass',9307,9244,'mean',NULL,NULL,NULL,NULL,NULL),(9273,1508,'4_hydroxybenzoic_acid_mass_relative_mass',9308,9244,'mean',NULL,NULL,NULL,NULL,NULL),(9274,1508,'vanillin_mass_relative_mass',9309,9244,'mean',NULL,NULL,NULL,NULL,NULL),(9275,1508,'vanillic_acid_mass_relative_mass',9310,9244,'mean',NULL,NULL,NULL,NULL,NULL),(9276,1508,'acetovanillone_mass_relative_mass',9311,9244,'mean',NULL,NULL,NULL,NULL,NULL),(9277,1508,'syringe_aldehyde_mass_relative_mass',9312,9244,'mean',NULL,NULL,NULL,NULL,NULL),(9278,1508,'acetosyringone_mass_relative_mass',9313,9244,'mean',NULL,NULL,NULL,NULL,NULL),(9279,1508,'syringic_acid_mass_relative_mass',9314,9244,'mean',NULL,NULL,NULL,NULL,NULL),(9280,1508,'p_coumaric_acid_mass_relative_mass',9315,9244,'mean',NULL,NULL,NULL,NULL,NULL),(9281,1508,'ferulic_acid_mass_relative_mass',9316,9244,'mean',NULL,NULL,NULL,NULL,NULL),(9282,1508,'Klason_lignin_mass_relative_mass',9317,9244,'mean',NULL,NULL,NULL,NULL,NULL),(9283,1508,'soluble_lignin_mass_relative_mass',9318,9244,'mean',NULL,NULL,NULL,NULL,NULL),(9284,1508,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9285,1508,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9286,1508,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9287,1508,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9288,1508,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9289,1508,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9290,1508,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9291,1508,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9292,1508,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9293,1508,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9294,1508,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9295,1508,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9296,1508,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9297,1508,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9298,1508,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9299,1508,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9300,1508,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9301,1508,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9302,1508,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9303,1508,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9304,1508,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9305,1508,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9306,1508,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9307,1508,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9308,1508,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9309,1508,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9310,1508,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9311,1508,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9312,1508,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9313,1508,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9314,1508,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9315,1508,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9316,1508,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9317,1508,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9318,1508,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9319,1509,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9320,1509,'mass_relative_mass',9319,7444,'mean','se',NULL,0.3796610169491526,0.07118644067796602,NULL),(9321,1509,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(9322,1509,'ash_mass_relative_mass',9359,9319,'mean',NULL,NULL,NULL,NULL,NULL),(9323,1509,'N_relative_mass',9360,9319,'mean',NULL,NULL,NULL,NULL,NULL),(9324,1509,'P_relative_mass',9361,9319,'mean',NULL,NULL,NULL,NULL,NULL),(9325,1509,'Ca_relative_mass',9362,9319,'mean',NULL,NULL,NULL,NULL,NULL),(9326,1509,'K_relative_mass',9363,9319,'mean',NULL,NULL,NULL,NULL,NULL),(9327,1509,'Mg_relative_mass',9364,9319,'mean',NULL,NULL,NULL,NULL,NULL),(9328,1509,'Mn_relative_mass',9365,9319,'mean',NULL,NULL,NULL,NULL,NULL),(9329,1509,'C_relative_mass',9366,9319,'mean',NULL,NULL,NULL,NULL,NULL),(9330,1509,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9331,1509,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9332,1509,'dichloromethane_extractives_mass_relative_mass',9367,9319,'mean',NULL,NULL,NULL,NULL,NULL),(9333,1509,'acetone_extractives_mass_relative_mass',9368,9319,'mean',NULL,NULL,NULL,NULL,NULL),(9334,1509,'ethanol_extractives_mass_relative_mass',9369,9319,'mean',NULL,NULL,NULL,NULL,NULL),(9335,1509,'water_extractives_mass_relative_mass',9370,9319,'mean',NULL,NULL,NULL,NULL,NULL),(9336,1509,'cellulose_mass_relative_mass',9371,9319,'mean',NULL,NULL,NULL,NULL,NULL),(9337,1509,'arabinose_mass_relative_mass',9372,9319,'mean',NULL,NULL,NULL,NULL,NULL),(9338,1509,'rhamnose_mass_relative_mass',9373,9319,'mean',NULL,NULL,NULL,NULL,NULL),(9339,1509,'xylose_mass_relative_mass',9374,9319,'mean',NULL,NULL,NULL,NULL,NULL),(9340,1509,'mannose_mass_relative_mass',9375,9319,'mean',NULL,NULL,NULL,NULL,NULL),(9341,1509,'galactose_mass_relative_mass',9376,9319,'mean',NULL,NULL,NULL,NULL,NULL),(9342,1509,'glucose_mass_relative_mass',9377,9319,'mean',NULL,NULL,NULL,NULL,NULL),(9343,1509,'glucuronic_acid_mass_relative_mass',9378,9319,'mean',NULL,NULL,NULL,NULL,NULL),(9344,1509,'galacturonic_acid_mass_relative_mass',9379,9319,'mean',NULL,NULL,NULL,NULL,NULL),(9345,1509,'holocellulose_mass_relative_mass',9380,9319,'mean',NULL,NULL,NULL,NULL,NULL),(9346,1509,'4_hydroxybenzaldehyde_mass_relative_mass',9381,9319,'mean',NULL,NULL,NULL,NULL,NULL),(9347,1509,'4_hydroxyacetophenone_mass_relative_mass',9382,9319,'mean',NULL,NULL,NULL,NULL,NULL),(9348,1509,'4_hydroxybenzoic_acid_mass_relative_mass',9383,9319,'mean',NULL,NULL,NULL,NULL,NULL),(9349,1509,'vanillin_mass_relative_mass',9384,9319,'mean',NULL,NULL,NULL,NULL,NULL),(9350,1509,'vanillic_acid_mass_relative_mass',9385,9319,'mean',NULL,NULL,NULL,NULL,NULL),(9351,1509,'acetovanillone_mass_relative_mass',9386,9319,'mean',NULL,NULL,NULL,NULL,NULL),(9352,1509,'syringe_aldehyde_mass_relative_mass',9387,9319,'mean',NULL,NULL,NULL,NULL,NULL),(9353,1509,'acetosyringone_mass_relative_mass',9388,9319,'mean',NULL,NULL,NULL,NULL,NULL),(9354,1509,'syringic_acid_mass_relative_mass',9389,9319,'mean',NULL,NULL,NULL,NULL,NULL),(9355,1509,'p_coumaric_acid_mass_relative_mass',9390,9319,'mean',NULL,NULL,NULL,NULL,NULL),(9356,1509,'ferulic_acid_mass_relative_mass',9391,9319,'mean',NULL,NULL,NULL,NULL,NULL),(9357,1509,'Klason_lignin_mass_relative_mass',9392,9319,'mean',NULL,NULL,NULL,NULL,NULL),(9358,1509,'soluble_lignin_mass_relative_mass',9393,9319,'mean',NULL,NULL,NULL,NULL,NULL),(9359,1509,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9360,1509,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9361,1509,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9362,1509,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9363,1509,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9364,1509,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9365,1509,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9366,1509,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9367,1509,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9368,1509,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9369,1509,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9370,1509,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9371,1509,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9372,1509,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9373,1509,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9374,1509,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9375,1509,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9376,1509,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9377,1509,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9378,1509,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9379,1509,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9380,1509,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9381,1509,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9382,1509,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9383,1509,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9384,1509,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9385,1509,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9386,1509,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9387,1509,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9388,1509,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9389,1509,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9390,1509,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9391,1509,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9392,1509,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9393,1509,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9394,1510,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9395,1510,'mass_relative_mass',9394,7444,'mean','se',NULL,0.10169491525423732,0.02711864406779661,NULL),(9396,1510,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(9397,1510,'ash_mass_relative_mass',9434,9394,'mean',NULL,NULL,NULL,NULL,NULL),(9398,1510,'N_relative_mass',9435,9394,'mean',NULL,NULL,NULL,NULL,NULL),(9399,1510,'P_relative_mass',9436,9394,'mean',NULL,NULL,NULL,NULL,NULL),(9400,1510,'Ca_relative_mass',9437,9394,'mean',NULL,NULL,NULL,NULL,NULL),(9401,1510,'K_relative_mass',9438,9394,'mean',NULL,NULL,NULL,NULL,NULL),(9402,1510,'Mg_relative_mass',9439,9394,'mean',NULL,NULL,NULL,NULL,NULL),(9403,1510,'Mn_relative_mass',9440,9394,'mean',NULL,NULL,NULL,NULL,NULL),(9404,1510,'C_relative_mass',9441,9394,'mean',NULL,NULL,NULL,NULL,NULL),(9405,1510,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9406,1510,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9407,1510,'dichloromethane_extractives_mass_relative_mass',9442,9394,'mean',NULL,NULL,NULL,NULL,NULL),(9408,1510,'acetone_extractives_mass_relative_mass',9443,9394,'mean',NULL,NULL,NULL,NULL,NULL),(9409,1510,'ethanol_extractives_mass_relative_mass',9444,9394,'mean',NULL,NULL,NULL,NULL,NULL),(9410,1510,'water_extractives_mass_relative_mass',9445,9394,'mean',NULL,NULL,NULL,NULL,NULL),(9411,1510,'cellulose_mass_relative_mass',9446,9394,'mean',NULL,NULL,NULL,NULL,NULL),(9412,1510,'arabinose_mass_relative_mass',9447,9394,'mean',NULL,NULL,NULL,NULL,NULL),(9413,1510,'rhamnose_mass_relative_mass',9448,9394,'mean',NULL,NULL,NULL,NULL,NULL),(9414,1510,'xylose_mass_relative_mass',9449,9394,'mean',NULL,NULL,NULL,NULL,NULL),(9415,1510,'mannose_mass_relative_mass',9450,9394,'mean',NULL,NULL,NULL,NULL,NULL),(9416,1510,'galactose_mass_relative_mass',9451,9394,'mean',NULL,NULL,NULL,NULL,NULL),(9417,1510,'glucose_mass_relative_mass',9452,9394,'mean',NULL,NULL,NULL,NULL,NULL),(9418,1510,'glucuronic_acid_mass_relative_mass',9453,9394,'mean',NULL,NULL,NULL,NULL,NULL),(9419,1510,'galacturonic_acid_mass_relative_mass',9454,9394,'mean',NULL,NULL,NULL,NULL,NULL),(9420,1510,'holocellulose_mass_relative_mass',9455,9394,'mean',NULL,NULL,NULL,NULL,NULL),(9421,1510,'4_hydroxybenzaldehyde_mass_relative_mass',9456,9394,'mean',NULL,NULL,NULL,NULL,NULL),(9422,1510,'4_hydroxyacetophenone_mass_relative_mass',9457,9394,'mean',NULL,NULL,NULL,NULL,NULL),(9423,1510,'4_hydroxybenzoic_acid_mass_relative_mass',9458,9394,'mean',NULL,NULL,NULL,NULL,NULL),(9424,1510,'vanillin_mass_relative_mass',9459,9394,'mean',NULL,NULL,NULL,NULL,NULL),(9425,1510,'vanillic_acid_mass_relative_mass',9460,9394,'mean',NULL,NULL,NULL,NULL,NULL),(9426,1510,'acetovanillone_mass_relative_mass',9461,9394,'mean',NULL,NULL,NULL,NULL,NULL),(9427,1510,'syringe_aldehyde_mass_relative_mass',9462,9394,'mean',NULL,NULL,NULL,NULL,NULL),(9428,1510,'acetosyringone_mass_relative_mass',9463,9394,'mean',NULL,NULL,NULL,NULL,NULL),(9429,1510,'syringic_acid_mass_relative_mass',9464,9394,'mean',NULL,NULL,NULL,NULL,NULL),(9430,1510,'p_coumaric_acid_mass_relative_mass',9465,9394,'mean',NULL,NULL,NULL,NULL,NULL),(9431,1510,'ferulic_acid_mass_relative_mass',9466,9394,'mean',NULL,NULL,NULL,NULL,NULL),(9432,1510,'Klason_lignin_mass_relative_mass',9467,9394,'mean',NULL,NULL,NULL,NULL,NULL),(9433,1510,'soluble_lignin_mass_relative_mass',9468,9394,'mean',NULL,NULL,NULL,NULL,NULL),(9434,1510,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9435,1510,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9436,1510,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9437,1510,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9438,1510,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9439,1510,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9440,1510,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9441,1510,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9442,1510,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9443,1510,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9444,1510,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9445,1510,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9446,1510,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9447,1510,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9448,1510,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9449,1510,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9450,1510,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9451,1510,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9452,1510,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9453,1510,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9454,1510,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9455,1510,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9456,1510,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9457,1510,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9458,1510,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9459,1510,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9460,1510,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9461,1510,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9462,1510,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9463,1510,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9464,1510,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9465,1510,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9466,1510,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9467,1510,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9468,1510,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9469,1511,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9470,1511,'mass_relative_mass',9469,7519,'mean','se',NULL,0.6779661016949154,0.04067796610169495,NULL),(9471,1511,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(9472,1511,'ash_mass_relative_mass',9509,9469,'mean',NULL,NULL,NULL,NULL,NULL),(9473,1511,'N_relative_mass',9510,9469,'mean',NULL,NULL,NULL,NULL,NULL),(9474,1511,'P_relative_mass',9511,9469,'mean',NULL,NULL,NULL,NULL,NULL),(9475,1511,'Ca_relative_mass',9512,9469,'mean',NULL,NULL,NULL,NULL,NULL),(9476,1511,'K_relative_mass',9513,9469,'mean',NULL,NULL,NULL,NULL,NULL),(9477,1511,'Mg_relative_mass',9514,9469,'mean',NULL,NULL,NULL,NULL,NULL),(9478,1511,'Mn_relative_mass',9515,9469,'mean',NULL,NULL,NULL,NULL,NULL),(9479,1511,'C_relative_mass',9516,9469,'mean',NULL,NULL,NULL,NULL,NULL),(9480,1511,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9481,1511,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9482,1511,'dichloromethane_extractives_mass_relative_mass',9517,9469,'mean',NULL,NULL,NULL,NULL,NULL),(9483,1511,'acetone_extractives_mass_relative_mass',9518,9469,'mean',NULL,NULL,NULL,NULL,NULL),(9484,1511,'ethanol_extractives_mass_relative_mass',9519,9469,'mean',NULL,NULL,NULL,NULL,NULL),(9485,1511,'water_extractives_mass_relative_mass',9520,9469,'mean',NULL,NULL,NULL,NULL,NULL),(9486,1511,'cellulose_mass_relative_mass',9521,9469,'mean',NULL,NULL,NULL,NULL,NULL),(9487,1511,'arabinose_mass_relative_mass',9522,9469,'mean',NULL,NULL,NULL,NULL,NULL),(9488,1511,'rhamnose_mass_relative_mass',9523,9469,'mean',NULL,NULL,NULL,NULL,NULL),(9489,1511,'xylose_mass_relative_mass',9524,9469,'mean',NULL,NULL,NULL,NULL,NULL),(9490,1511,'mannose_mass_relative_mass',9525,9469,'mean',NULL,NULL,NULL,NULL,NULL),(9491,1511,'galactose_mass_relative_mass',9526,9469,'mean',NULL,NULL,NULL,NULL,NULL),(9492,1511,'glucose_mass_relative_mass',9527,9469,'mean',NULL,NULL,NULL,NULL,NULL),(9493,1511,'glucuronic_acid_mass_relative_mass',9528,9469,'mean',NULL,NULL,NULL,NULL,NULL),(9494,1511,'galacturonic_acid_mass_relative_mass',9529,9469,'mean',NULL,NULL,NULL,NULL,NULL),(9495,1511,'holocellulose_mass_relative_mass',9530,9469,'mean',NULL,NULL,NULL,NULL,NULL),(9496,1511,'4_hydroxybenzaldehyde_mass_relative_mass',9531,9469,'mean',NULL,NULL,NULL,NULL,NULL),(9497,1511,'4_hydroxyacetophenone_mass_relative_mass',9532,9469,'mean',NULL,NULL,NULL,NULL,NULL),(9498,1511,'4_hydroxybenzoic_acid_mass_relative_mass',9533,9469,'mean',NULL,NULL,NULL,NULL,NULL),(9499,1511,'vanillin_mass_relative_mass',9534,9469,'mean',NULL,NULL,NULL,NULL,NULL),(9500,1511,'vanillic_acid_mass_relative_mass',9535,9469,'mean',NULL,NULL,NULL,NULL,NULL),(9501,1511,'acetovanillone_mass_relative_mass',9536,9469,'mean',NULL,NULL,NULL,NULL,NULL),(9502,1511,'syringe_aldehyde_mass_relative_mass',9537,9469,'mean',NULL,NULL,NULL,NULL,NULL),(9503,1511,'acetosyringone_mass_relative_mass',9538,9469,'mean',NULL,NULL,NULL,NULL,NULL),(9504,1511,'syringic_acid_mass_relative_mass',9539,9469,'mean',NULL,NULL,NULL,NULL,NULL),(9505,1511,'p_coumaric_acid_mass_relative_mass',9540,9469,'mean',NULL,NULL,NULL,NULL,NULL),(9506,1511,'ferulic_acid_mass_relative_mass',9541,9469,'mean',NULL,NULL,NULL,NULL,NULL),(9507,1511,'Klason_lignin_mass_relative_mass',9542,9469,'mean',NULL,NULL,NULL,NULL,NULL),(9508,1511,'soluble_lignin_mass_relative_mass',9543,9469,'mean',NULL,NULL,NULL,NULL,NULL),(9509,1511,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9510,1511,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9511,1511,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9512,1511,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9513,1511,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9514,1511,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9515,1511,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9516,1511,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9517,1511,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9518,1511,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9519,1511,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9520,1511,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9521,1511,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9522,1511,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9523,1511,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9524,1511,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9525,1511,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9526,1511,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9527,1511,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9528,1511,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9529,1511,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9530,1511,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9531,1511,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9532,1511,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9533,1511,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9534,1511,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9535,1511,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9536,1511,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9537,1511,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9538,1511,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9539,1511,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9540,1511,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9541,1511,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9542,1511,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9543,1511,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9544,1512,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9545,1512,'mass_relative_mass',9544,7519,'mean','se',NULL,0.41355932203389834,0.04745762711864408,NULL),(9546,1512,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(9547,1512,'ash_mass_relative_mass',9584,9544,'mean',NULL,NULL,NULL,NULL,NULL),(9548,1512,'N_relative_mass',9585,9544,'mean',NULL,NULL,NULL,NULL,NULL),(9549,1512,'P_relative_mass',9586,9544,'mean',NULL,NULL,NULL,NULL,NULL),(9550,1512,'Ca_relative_mass',9587,9544,'mean',NULL,NULL,NULL,NULL,NULL),(9551,1512,'K_relative_mass',9588,9544,'mean',NULL,NULL,NULL,NULL,NULL),(9552,1512,'Mg_relative_mass',9589,9544,'mean',NULL,NULL,NULL,NULL,NULL),(9553,1512,'Mn_relative_mass',9590,9544,'mean',NULL,NULL,NULL,NULL,NULL),(9554,1512,'C_relative_mass',9591,9544,'mean',NULL,NULL,NULL,NULL,NULL),(9555,1512,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9556,1512,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9557,1512,'dichloromethane_extractives_mass_relative_mass',9592,9544,'mean',NULL,NULL,NULL,NULL,NULL),(9558,1512,'acetone_extractives_mass_relative_mass',9593,9544,'mean',NULL,NULL,NULL,NULL,NULL),(9559,1512,'ethanol_extractives_mass_relative_mass',9594,9544,'mean',NULL,NULL,NULL,NULL,NULL),(9560,1512,'water_extractives_mass_relative_mass',9595,9544,'mean',NULL,NULL,NULL,NULL,NULL),(9561,1512,'cellulose_mass_relative_mass',9596,9544,'mean',NULL,NULL,NULL,NULL,NULL),(9562,1512,'arabinose_mass_relative_mass',9597,9544,'mean',NULL,NULL,NULL,NULL,NULL),(9563,1512,'rhamnose_mass_relative_mass',9598,9544,'mean',NULL,NULL,NULL,NULL,NULL),(9564,1512,'xylose_mass_relative_mass',9599,9544,'mean',NULL,NULL,NULL,NULL,NULL),(9565,1512,'mannose_mass_relative_mass',9600,9544,'mean',NULL,NULL,NULL,NULL,NULL),(9566,1512,'galactose_mass_relative_mass',9601,9544,'mean',NULL,NULL,NULL,NULL,NULL),(9567,1512,'glucose_mass_relative_mass',9602,9544,'mean',NULL,NULL,NULL,NULL,NULL),(9568,1512,'glucuronic_acid_mass_relative_mass',9603,9544,'mean',NULL,NULL,NULL,NULL,NULL),(9569,1512,'galacturonic_acid_mass_relative_mass',9604,9544,'mean',NULL,NULL,NULL,NULL,NULL),(9570,1512,'holocellulose_mass_relative_mass',9605,9544,'mean',NULL,NULL,NULL,NULL,NULL),(9571,1512,'4_hydroxybenzaldehyde_mass_relative_mass',9606,9544,'mean',NULL,NULL,NULL,NULL,NULL),(9572,1512,'4_hydroxyacetophenone_mass_relative_mass',9607,9544,'mean',NULL,NULL,NULL,NULL,NULL),(9573,1512,'4_hydroxybenzoic_acid_mass_relative_mass',9608,9544,'mean',NULL,NULL,NULL,NULL,NULL),(9574,1512,'vanillin_mass_relative_mass',9609,9544,'mean',NULL,NULL,NULL,NULL,NULL),(9575,1512,'vanillic_acid_mass_relative_mass',9610,9544,'mean',NULL,NULL,NULL,NULL,NULL),(9576,1512,'acetovanillone_mass_relative_mass',9611,9544,'mean',NULL,NULL,NULL,NULL,NULL),(9577,1512,'syringe_aldehyde_mass_relative_mass',9612,9544,'mean',NULL,NULL,NULL,NULL,NULL),(9578,1512,'acetosyringone_mass_relative_mass',9613,9544,'mean',NULL,NULL,NULL,NULL,NULL),(9579,1512,'syringic_acid_mass_relative_mass',9614,9544,'mean',NULL,NULL,NULL,NULL,NULL),(9580,1512,'p_coumaric_acid_mass_relative_mass',9615,9544,'mean',NULL,NULL,NULL,NULL,NULL),(9581,1512,'ferulic_acid_mass_relative_mass',9616,9544,'mean',NULL,NULL,NULL,NULL,NULL),(9582,1512,'Klason_lignin_mass_relative_mass',9617,9544,'mean',NULL,NULL,NULL,NULL,NULL),(9583,1512,'soluble_lignin_mass_relative_mass',9618,9544,'mean',NULL,NULL,NULL,NULL,NULL),(9584,1512,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9585,1512,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9586,1512,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9587,1512,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9588,1512,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9589,1512,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9590,1512,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9591,1512,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9592,1512,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9593,1512,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9594,1512,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9595,1512,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9596,1512,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9597,1512,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9598,1512,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9599,1512,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9600,1512,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9601,1512,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9602,1512,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9603,1512,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9604,1512,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9605,1512,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9606,1512,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9607,1512,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9608,1512,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9609,1512,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9610,1512,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9611,1512,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9612,1512,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9613,1512,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9614,1512,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9615,1512,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9616,1512,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9617,1512,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9618,1512,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9619,1513,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9620,1513,'mass_relative_mass',9619,7594,'mean','se',NULL,0.7932203389830509,0.013559322033898553,NULL),(9621,1513,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(9622,1513,'ash_mass_relative_mass',9659,9619,'mean',NULL,NULL,NULL,NULL,NULL),(9623,1513,'N_relative_mass',9660,9619,'mean',NULL,NULL,NULL,NULL,NULL),(9624,1513,'P_relative_mass',9661,9619,'mean',NULL,NULL,NULL,NULL,NULL),(9625,1513,'Ca_relative_mass',9662,9619,'mean',NULL,NULL,NULL,NULL,NULL),(9626,1513,'K_relative_mass',9663,9619,'mean',NULL,NULL,NULL,NULL,NULL),(9627,1513,'Mg_relative_mass',9664,9619,'mean',NULL,NULL,NULL,NULL,NULL),(9628,1513,'Mn_relative_mass',9665,9619,'mean',NULL,NULL,NULL,NULL,NULL),(9629,1513,'C_relative_mass',9666,9619,'mean',NULL,NULL,NULL,NULL,NULL),(9630,1513,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9631,1513,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9632,1513,'dichloromethane_extractives_mass_relative_mass',9667,9619,'mean',NULL,NULL,NULL,NULL,NULL),(9633,1513,'acetone_extractives_mass_relative_mass',9668,9619,'mean',NULL,NULL,NULL,NULL,NULL),(9634,1513,'ethanol_extractives_mass_relative_mass',9669,9619,'mean',NULL,NULL,NULL,NULL,NULL),(9635,1513,'water_extractives_mass_relative_mass',9670,9619,'mean',NULL,NULL,NULL,NULL,NULL),(9636,1513,'cellulose_mass_relative_mass',9671,9619,'mean',NULL,NULL,NULL,NULL,NULL),(9637,1513,'arabinose_mass_relative_mass',9672,9619,'mean',NULL,NULL,NULL,NULL,NULL),(9638,1513,'rhamnose_mass_relative_mass',9673,9619,'mean',NULL,NULL,NULL,NULL,NULL),(9639,1513,'xylose_mass_relative_mass',9674,9619,'mean',NULL,NULL,NULL,NULL,NULL),(9640,1513,'mannose_mass_relative_mass',9675,9619,'mean',NULL,NULL,NULL,NULL,NULL),(9641,1513,'galactose_mass_relative_mass',9676,9619,'mean',NULL,NULL,NULL,NULL,NULL),(9642,1513,'glucose_mass_relative_mass',9677,9619,'mean',NULL,NULL,NULL,NULL,NULL),(9643,1513,'glucuronic_acid_mass_relative_mass',9678,9619,'mean',NULL,NULL,NULL,NULL,NULL),(9644,1513,'galacturonic_acid_mass_relative_mass',9679,9619,'mean',NULL,NULL,NULL,NULL,NULL),(9645,1513,'holocellulose_mass_relative_mass',9680,9619,'mean',NULL,NULL,NULL,NULL,NULL),(9646,1513,'4_hydroxybenzaldehyde_mass_relative_mass',9681,9619,'mean',NULL,NULL,NULL,NULL,NULL),(9647,1513,'4_hydroxyacetophenone_mass_relative_mass',9682,9619,'mean',NULL,NULL,NULL,NULL,NULL),(9648,1513,'4_hydroxybenzoic_acid_mass_relative_mass',9683,9619,'mean',NULL,NULL,NULL,NULL,NULL),(9649,1513,'vanillin_mass_relative_mass',9684,9619,'mean',NULL,NULL,NULL,NULL,NULL),(9650,1513,'vanillic_acid_mass_relative_mass',9685,9619,'mean',NULL,NULL,NULL,NULL,NULL),(9651,1513,'acetovanillone_mass_relative_mass',9686,9619,'mean',NULL,NULL,NULL,NULL,NULL),(9652,1513,'syringe_aldehyde_mass_relative_mass',9687,9619,'mean',NULL,NULL,NULL,NULL,NULL),(9653,1513,'acetosyringone_mass_relative_mass',9688,9619,'mean',NULL,NULL,NULL,NULL,NULL),(9654,1513,'syringic_acid_mass_relative_mass',9689,9619,'mean',NULL,NULL,NULL,NULL,NULL),(9655,1513,'p_coumaric_acid_mass_relative_mass',9690,9619,'mean',NULL,NULL,NULL,NULL,NULL),(9656,1513,'ferulic_acid_mass_relative_mass',9691,9619,'mean',NULL,NULL,NULL,NULL,NULL),(9657,1513,'Klason_lignin_mass_relative_mass',9692,9619,'mean',NULL,NULL,NULL,NULL,NULL),(9658,1513,'soluble_lignin_mass_relative_mass',9693,9619,'mean',NULL,NULL,NULL,NULL,NULL),(9659,1513,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9660,1513,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9661,1513,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9662,1513,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9663,1513,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9664,1513,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9665,1513,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9666,1513,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9667,1513,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9668,1513,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9669,1513,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9670,1513,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9671,1513,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9672,1513,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9673,1513,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9674,1513,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9675,1513,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9676,1513,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9677,1513,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9678,1513,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9679,1513,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9680,1513,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9681,1513,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9682,1513,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9683,1513,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9684,1513,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9685,1513,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9686,1513,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9687,1513,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9688,1513,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9689,1513,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9690,1513,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9691,1513,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9692,1513,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9693,1513,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9694,1514,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9695,1514,'mass_relative_mass',9694,7594,'mean','se',NULL,0.7084745762711866,0.023728813559322076,NULL),(9696,1514,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(9697,1514,'ash_mass_relative_mass',9734,9694,'mean',NULL,NULL,NULL,NULL,NULL),(9698,1514,'N_relative_mass',9735,9694,'mean',NULL,NULL,NULL,NULL,NULL),(9699,1514,'P_relative_mass',9736,9694,'mean',NULL,NULL,NULL,NULL,NULL),(9700,1514,'Ca_relative_mass',9737,9694,'mean',NULL,NULL,NULL,NULL,NULL),(9701,1514,'K_relative_mass',9738,9694,'mean',NULL,NULL,NULL,NULL,NULL),(9702,1514,'Mg_relative_mass',9739,9694,'mean',NULL,NULL,NULL,NULL,NULL),(9703,1514,'Mn_relative_mass',9740,9694,'mean',NULL,NULL,NULL,NULL,NULL),(9704,1514,'C_relative_mass',9741,9694,'mean',NULL,NULL,NULL,NULL,NULL),(9705,1514,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9706,1514,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9707,1514,'dichloromethane_extractives_mass_relative_mass',9742,9694,'mean',NULL,NULL,NULL,NULL,NULL),(9708,1514,'acetone_extractives_mass_relative_mass',9743,9694,'mean',NULL,NULL,NULL,NULL,NULL),(9709,1514,'ethanol_extractives_mass_relative_mass',9744,9694,'mean',NULL,NULL,NULL,NULL,NULL),(9710,1514,'water_extractives_mass_relative_mass',9745,9694,'mean',NULL,NULL,NULL,NULL,NULL),(9711,1514,'cellulose_mass_relative_mass',9746,9694,'mean',NULL,NULL,NULL,NULL,NULL),(9712,1514,'arabinose_mass_relative_mass',9747,9694,'mean',NULL,NULL,NULL,NULL,NULL),(9713,1514,'rhamnose_mass_relative_mass',9748,9694,'mean',NULL,NULL,NULL,NULL,NULL),(9714,1514,'xylose_mass_relative_mass',9749,9694,'mean',NULL,NULL,NULL,NULL,NULL),(9715,1514,'mannose_mass_relative_mass',9750,9694,'mean',NULL,NULL,NULL,NULL,NULL),(9716,1514,'galactose_mass_relative_mass',9751,9694,'mean',NULL,NULL,NULL,NULL,NULL),(9717,1514,'glucose_mass_relative_mass',9752,9694,'mean',NULL,NULL,NULL,NULL,NULL),(9718,1514,'glucuronic_acid_mass_relative_mass',9753,9694,'mean',NULL,NULL,NULL,NULL,NULL),(9719,1514,'galacturonic_acid_mass_relative_mass',9754,9694,'mean',NULL,NULL,NULL,NULL,NULL),(9720,1514,'holocellulose_mass_relative_mass',9755,9694,'mean',NULL,NULL,NULL,NULL,NULL),(9721,1514,'4_hydroxybenzaldehyde_mass_relative_mass',9756,9694,'mean',NULL,NULL,NULL,NULL,NULL),(9722,1514,'4_hydroxyacetophenone_mass_relative_mass',9757,9694,'mean',NULL,NULL,NULL,NULL,NULL),(9723,1514,'4_hydroxybenzoic_acid_mass_relative_mass',9758,9694,'mean',NULL,NULL,NULL,NULL,NULL),(9724,1514,'vanillin_mass_relative_mass',9759,9694,'mean',NULL,NULL,NULL,NULL,NULL),(9725,1514,'vanillic_acid_mass_relative_mass',9760,9694,'mean',NULL,NULL,NULL,NULL,NULL),(9726,1514,'acetovanillone_mass_relative_mass',9761,9694,'mean',NULL,NULL,NULL,NULL,NULL),(9727,1514,'syringe_aldehyde_mass_relative_mass',9762,9694,'mean',NULL,NULL,NULL,NULL,NULL),(9728,1514,'acetosyringone_mass_relative_mass',9763,9694,'mean',NULL,NULL,NULL,NULL,NULL),(9729,1514,'syringic_acid_mass_relative_mass',9764,9694,'mean',NULL,NULL,NULL,NULL,NULL),(9730,1514,'p_coumaric_acid_mass_relative_mass',9765,9694,'mean',NULL,NULL,NULL,NULL,NULL),(9731,1514,'ferulic_acid_mass_relative_mass',9766,9694,'mean',NULL,NULL,NULL,NULL,NULL),(9732,1514,'Klason_lignin_mass_relative_mass',9767,9694,'mean',NULL,NULL,NULL,NULL,NULL),(9733,1514,'soluble_lignin_mass_relative_mass',9768,9694,'mean',NULL,NULL,NULL,NULL,NULL),(9734,1514,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9735,1514,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9736,1514,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9737,1514,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9738,1514,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9739,1514,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9740,1514,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9741,1514,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9742,1514,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9743,1514,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9744,1514,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9745,1514,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9746,1514,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9747,1514,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9748,1514,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9749,1514,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9750,1514,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9751,1514,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9752,1514,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9753,1514,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9754,1514,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9755,1514,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9756,1514,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9757,1514,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9758,1514,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9759,1514,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9760,1514,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9761,1514,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9762,1514,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9763,1514,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9764,1514,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9765,1514,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9766,1514,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9767,1514,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9768,1514,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9769,1515,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9770,1515,'mass_relative_mass',9769,7669,'mean','se',NULL,0.874576271186441,0.023728813559321934,NULL),(9771,1515,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(9772,1515,'ash_mass_relative_mass',9809,9769,'mean',NULL,NULL,NULL,NULL,NULL),(9773,1515,'N_relative_mass',9810,9769,'mean',NULL,NULL,NULL,NULL,NULL),(9774,1515,'P_relative_mass',9811,9769,'mean',NULL,NULL,NULL,NULL,NULL),(9775,1515,'Ca_relative_mass',9812,9769,'mean',NULL,NULL,NULL,NULL,NULL),(9776,1515,'K_relative_mass',9813,9769,'mean',NULL,NULL,NULL,NULL,NULL),(9777,1515,'Mg_relative_mass',9814,9769,'mean',NULL,NULL,NULL,NULL,NULL),(9778,1515,'Mn_relative_mass',9815,9769,'mean',NULL,NULL,NULL,NULL,NULL),(9779,1515,'C_relative_mass',9816,9769,'mean',NULL,NULL,NULL,NULL,NULL),(9780,1515,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9781,1515,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9782,1515,'dichloromethane_extractives_mass_relative_mass',9817,9769,'mean',NULL,NULL,NULL,NULL,NULL),(9783,1515,'acetone_extractives_mass_relative_mass',9818,9769,'mean',NULL,NULL,NULL,NULL,NULL),(9784,1515,'ethanol_extractives_mass_relative_mass',9819,9769,'mean',NULL,NULL,NULL,NULL,NULL),(9785,1515,'water_extractives_mass_relative_mass',9820,9769,'mean',NULL,NULL,NULL,NULL,NULL),(9786,1515,'cellulose_mass_relative_mass',9821,9769,'mean',NULL,NULL,NULL,NULL,NULL),(9787,1515,'arabinose_mass_relative_mass',9822,9769,'mean',NULL,NULL,NULL,NULL,NULL),(9788,1515,'rhamnose_mass_relative_mass',9823,9769,'mean',NULL,NULL,NULL,NULL,NULL),(9789,1515,'xylose_mass_relative_mass',9824,9769,'mean',NULL,NULL,NULL,NULL,NULL),(9790,1515,'mannose_mass_relative_mass',9825,9769,'mean',NULL,NULL,NULL,NULL,NULL),(9791,1515,'galactose_mass_relative_mass',9826,9769,'mean',NULL,NULL,NULL,NULL,NULL),(9792,1515,'glucose_mass_relative_mass',9827,9769,'mean',NULL,NULL,NULL,NULL,NULL),(9793,1515,'glucuronic_acid_mass_relative_mass',9828,9769,'mean',NULL,NULL,NULL,NULL,NULL),(9794,1515,'galacturonic_acid_mass_relative_mass',9829,9769,'mean',NULL,NULL,NULL,NULL,NULL),(9795,1515,'holocellulose_mass_relative_mass',9830,9769,'mean',NULL,NULL,NULL,NULL,NULL),(9796,1515,'4_hydroxybenzaldehyde_mass_relative_mass',9831,9769,'mean',NULL,NULL,NULL,NULL,NULL),(9797,1515,'4_hydroxyacetophenone_mass_relative_mass',9832,9769,'mean',NULL,NULL,NULL,NULL,NULL),(9798,1515,'4_hydroxybenzoic_acid_mass_relative_mass',9833,9769,'mean',NULL,NULL,NULL,NULL,NULL),(9799,1515,'vanillin_mass_relative_mass',9834,9769,'mean',NULL,NULL,NULL,NULL,NULL),(9800,1515,'vanillic_acid_mass_relative_mass',9835,9769,'mean',NULL,NULL,NULL,NULL,NULL),(9801,1515,'acetovanillone_mass_relative_mass',9836,9769,'mean',NULL,NULL,NULL,NULL,NULL),(9802,1515,'syringe_aldehyde_mass_relative_mass',9837,9769,'mean',NULL,NULL,NULL,NULL,NULL),(9803,1515,'acetosyringone_mass_relative_mass',9838,9769,'mean',NULL,NULL,NULL,NULL,NULL),(9804,1515,'syringic_acid_mass_relative_mass',9839,9769,'mean',NULL,NULL,NULL,NULL,NULL),(9805,1515,'p_coumaric_acid_mass_relative_mass',9840,9769,'mean',NULL,NULL,NULL,NULL,NULL),(9806,1515,'ferulic_acid_mass_relative_mass',9841,9769,'mean',NULL,NULL,NULL,NULL,NULL),(9807,1515,'Klason_lignin_mass_relative_mass',9842,9769,'mean',NULL,NULL,NULL,NULL,NULL),(9808,1515,'soluble_lignin_mass_relative_mass',9843,9769,'mean',NULL,NULL,NULL,NULL,NULL),(9809,1515,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9810,1515,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9811,1515,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9812,1515,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9813,1515,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9814,1515,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9815,1515,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9816,1515,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9817,1515,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9818,1515,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9819,1515,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9820,1515,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9821,1515,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9822,1515,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9823,1515,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9824,1515,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9825,1515,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9826,1515,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9827,1515,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9828,1515,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9829,1515,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9830,1515,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9831,1515,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9832,1515,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9833,1515,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9834,1515,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9835,1515,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9836,1515,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9837,1515,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9838,1515,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9839,1515,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9840,1515,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9841,1515,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9842,1515,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9843,1515,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9844,1516,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9845,1516,'mass_relative_mass',9844,7669,'mean','se',NULL,0.7593220338983052,0.01694915254237287,NULL),(9846,1516,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(9847,1516,'ash_mass_relative_mass',9884,9844,'mean',NULL,NULL,NULL,NULL,NULL),(9848,1516,'N_relative_mass',9885,9844,'mean',NULL,NULL,NULL,NULL,NULL),(9849,1516,'P_relative_mass',9886,9844,'mean',NULL,NULL,NULL,NULL,NULL),(9850,1516,'Ca_relative_mass',9887,9844,'mean',NULL,NULL,NULL,NULL,NULL),(9851,1516,'K_relative_mass',9888,9844,'mean',NULL,NULL,NULL,NULL,NULL),(9852,1516,'Mg_relative_mass',9889,9844,'mean',NULL,NULL,NULL,NULL,NULL),(9853,1516,'Mn_relative_mass',9890,9844,'mean',NULL,NULL,NULL,NULL,NULL),(9854,1516,'C_relative_mass',9891,9844,'mean',NULL,NULL,NULL,NULL,NULL),(9855,1516,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9856,1516,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9857,1516,'dichloromethane_extractives_mass_relative_mass',9892,9844,'mean',NULL,NULL,NULL,NULL,NULL),(9858,1516,'acetone_extractives_mass_relative_mass',9893,9844,'mean',NULL,NULL,NULL,NULL,NULL),(9859,1516,'ethanol_extractives_mass_relative_mass',9894,9844,'mean',NULL,NULL,NULL,NULL,NULL),(9860,1516,'water_extractives_mass_relative_mass',9895,9844,'mean',NULL,NULL,NULL,NULL,NULL),(9861,1516,'cellulose_mass_relative_mass',9896,9844,'mean',NULL,NULL,NULL,NULL,NULL),(9862,1516,'arabinose_mass_relative_mass',9897,9844,'mean',NULL,NULL,NULL,NULL,NULL),(9863,1516,'rhamnose_mass_relative_mass',9898,9844,'mean',NULL,NULL,NULL,NULL,NULL),(9864,1516,'xylose_mass_relative_mass',9899,9844,'mean',NULL,NULL,NULL,NULL,NULL),(9865,1516,'mannose_mass_relative_mass',9900,9844,'mean',NULL,NULL,NULL,NULL,NULL),(9866,1516,'galactose_mass_relative_mass',9901,9844,'mean',NULL,NULL,NULL,NULL,NULL),(9867,1516,'glucose_mass_relative_mass',9902,9844,'mean',NULL,NULL,NULL,NULL,NULL),(9868,1516,'glucuronic_acid_mass_relative_mass',9903,9844,'mean',NULL,NULL,NULL,NULL,NULL),(9869,1516,'galacturonic_acid_mass_relative_mass',9904,9844,'mean',NULL,NULL,NULL,NULL,NULL),(9870,1516,'holocellulose_mass_relative_mass',9905,9844,'mean',NULL,NULL,NULL,NULL,NULL),(9871,1516,'4_hydroxybenzaldehyde_mass_relative_mass',9906,9844,'mean',NULL,NULL,NULL,NULL,NULL),(9872,1516,'4_hydroxyacetophenone_mass_relative_mass',9907,9844,'mean',NULL,NULL,NULL,NULL,NULL),(9873,1516,'4_hydroxybenzoic_acid_mass_relative_mass',9908,9844,'mean',NULL,NULL,NULL,NULL,NULL),(9874,1516,'vanillin_mass_relative_mass',9909,9844,'mean',NULL,NULL,NULL,NULL,NULL),(9875,1516,'vanillic_acid_mass_relative_mass',9910,9844,'mean',NULL,NULL,NULL,NULL,NULL),(9876,1516,'acetovanillone_mass_relative_mass',9911,9844,'mean',NULL,NULL,NULL,NULL,NULL),(9877,1516,'syringe_aldehyde_mass_relative_mass',9912,9844,'mean',NULL,NULL,NULL,NULL,NULL),(9878,1516,'acetosyringone_mass_relative_mass',9913,9844,'mean',NULL,NULL,NULL,NULL,NULL),(9879,1516,'syringic_acid_mass_relative_mass',9914,9844,'mean',NULL,NULL,NULL,NULL,NULL),(9880,1516,'p_coumaric_acid_mass_relative_mass',9915,9844,'mean',NULL,NULL,NULL,NULL,NULL),(9881,1516,'ferulic_acid_mass_relative_mass',9916,9844,'mean',NULL,NULL,NULL,NULL,NULL),(9882,1516,'Klason_lignin_mass_relative_mass',9917,9844,'mean',NULL,NULL,NULL,NULL,NULL),(9883,1516,'soluble_lignin_mass_relative_mass',9918,9844,'mean',NULL,NULL,NULL,NULL,NULL),(9884,1516,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9885,1516,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9886,1516,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9887,1516,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9888,1516,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9889,1516,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9890,1516,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9891,1516,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9892,1516,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9893,1516,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9894,1516,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9895,1516,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9896,1516,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9897,1516,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9898,1516,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9899,1516,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9900,1516,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9901,1516,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9902,1516,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9903,1516,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9904,1516,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9905,1516,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9906,1516,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9907,1516,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9908,1516,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9909,1516,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9910,1516,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9911,1516,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9912,1516,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9913,1516,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9914,1516,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9915,1516,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9916,1516,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9917,1516,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9918,1516,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9919,1517,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9920,1517,'mass_relative_mass',9919,7744,'mean','se',NULL,0.23809523809523814,0.07482993197278916,NULL),(9921,1517,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(9922,1517,'ash_mass_relative_mass',9959,9919,'mean',NULL,NULL,NULL,NULL,NULL),(9923,1517,'N_relative_mass',9960,9919,'mean',NULL,NULL,NULL,NULL,NULL),(9924,1517,'P_relative_mass',9961,9919,'mean',NULL,NULL,NULL,NULL,NULL),(9925,1517,'Ca_relative_mass',9962,9919,'mean',NULL,NULL,NULL,NULL,NULL),(9926,1517,'K_relative_mass',9963,9919,'mean',NULL,NULL,NULL,NULL,NULL),(9927,1517,'Mg_relative_mass',9964,9919,'mean',NULL,NULL,NULL,NULL,NULL),(9928,1517,'Mn_relative_mass',9965,9919,'mean',NULL,NULL,NULL,NULL,NULL),(9929,1517,'C_relative_mass',9966,9919,'mean',NULL,NULL,NULL,NULL,NULL),(9930,1517,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9931,1517,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9932,1517,'dichloromethane_extractives_mass_relative_mass',9967,9919,'mean',NULL,NULL,NULL,NULL,NULL),(9933,1517,'acetone_extractives_mass_relative_mass',9968,9919,'mean',NULL,NULL,NULL,NULL,NULL),(9934,1517,'ethanol_extractives_mass_relative_mass',9969,9919,'mean',NULL,NULL,NULL,NULL,NULL),(9935,1517,'water_extractives_mass_relative_mass',9970,9919,'mean',NULL,NULL,NULL,NULL,NULL),(9936,1517,'cellulose_mass_relative_mass',9971,9919,'mean',NULL,NULL,NULL,NULL,NULL),(9937,1517,'arabinose_mass_relative_mass',9972,9919,'mean',NULL,NULL,NULL,NULL,NULL),(9938,1517,'rhamnose_mass_relative_mass',9973,9919,'mean',NULL,NULL,NULL,NULL,NULL),(9939,1517,'xylose_mass_relative_mass',9974,9919,'mean',NULL,NULL,NULL,NULL,NULL),(9940,1517,'mannose_mass_relative_mass',9975,9919,'mean',NULL,NULL,NULL,NULL,NULL),(9941,1517,'galactose_mass_relative_mass',9976,9919,'mean',NULL,NULL,NULL,NULL,NULL),(9942,1517,'glucose_mass_relative_mass',9977,9919,'mean',NULL,NULL,NULL,NULL,NULL),(9943,1517,'glucuronic_acid_mass_relative_mass',9978,9919,'mean',NULL,NULL,NULL,NULL,NULL),(9944,1517,'galacturonic_acid_mass_relative_mass',9979,9919,'mean',NULL,NULL,NULL,NULL,NULL),(9945,1517,'holocellulose_mass_relative_mass',9980,9919,'mean',NULL,NULL,NULL,NULL,NULL),(9946,1517,'4_hydroxybenzaldehyde_mass_relative_mass',9981,9919,'mean',NULL,NULL,NULL,NULL,NULL),(9947,1517,'4_hydroxyacetophenone_mass_relative_mass',9982,9919,'mean',NULL,NULL,NULL,NULL,NULL),(9948,1517,'4_hydroxybenzoic_acid_mass_relative_mass',9983,9919,'mean',NULL,NULL,NULL,NULL,NULL),(9949,1517,'vanillin_mass_relative_mass',9984,9919,'mean',NULL,NULL,NULL,NULL,NULL),(9950,1517,'vanillic_acid_mass_relative_mass',9985,9919,'mean',NULL,NULL,NULL,NULL,NULL),(9951,1517,'acetovanillone_mass_relative_mass',9986,9919,'mean',NULL,NULL,NULL,NULL,NULL),(9952,1517,'syringe_aldehyde_mass_relative_mass',9987,9919,'mean',NULL,NULL,NULL,NULL,NULL),(9953,1517,'acetosyringone_mass_relative_mass',9988,9919,'mean',NULL,NULL,NULL,NULL,NULL),(9954,1517,'syringic_acid_mass_relative_mass',9989,9919,'mean',NULL,NULL,NULL,NULL,NULL),(9955,1517,'p_coumaric_acid_mass_relative_mass',9990,9919,'mean',NULL,NULL,NULL,NULL,NULL),(9956,1517,'ferulic_acid_mass_relative_mass',9991,9919,'mean',NULL,NULL,NULL,NULL,NULL),(9957,1517,'Klason_lignin_mass_relative_mass',9992,9919,'mean',NULL,NULL,NULL,NULL,NULL),(9958,1517,'soluble_lignin_mass_relative_mass',9993,9919,'mean',NULL,NULL,NULL,NULL,NULL),(9959,1517,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9960,1517,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9961,1517,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9962,1517,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9963,1517,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9964,1517,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9965,1517,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9966,1517,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9967,1517,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9968,1517,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9969,1517,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9970,1517,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9971,1517,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9972,1517,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9973,1517,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9974,1517,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9975,1517,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9976,1517,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9977,1517,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9978,1517,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9979,1517,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9980,1517,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9981,1517,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9982,1517,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9983,1517,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9984,1517,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9985,1517,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9986,1517,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9987,1517,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9988,1517,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9989,1517,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9990,1517,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9991,1517,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9992,1517,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9993,1517,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9994,1518,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(9995,1518,'mass_relative_mass',9994,7744,'mean','se',NULL,0.07142857142857145,0.05782312925170064,NULL),(9996,1518,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(9997,1518,'ash_mass_relative_mass',10034,9994,'mean',NULL,NULL,NULL,NULL,NULL),(9998,1518,'N_relative_mass',10035,9994,'mean',NULL,NULL,NULL,NULL,NULL),(9999,1518,'P_relative_mass',10036,9994,'mean',NULL,NULL,NULL,NULL,NULL),(10000,1518,'Ca_relative_mass',10037,9994,'mean',NULL,NULL,NULL,NULL,NULL),(10001,1518,'K_relative_mass',10038,9994,'mean',NULL,NULL,NULL,NULL,NULL),(10002,1518,'Mg_relative_mass',10039,9994,'mean',NULL,NULL,NULL,NULL,NULL),(10003,1518,'Mn_relative_mass',10040,9994,'mean',NULL,NULL,NULL,NULL,NULL),(10004,1518,'C_relative_mass',10041,9994,'mean',NULL,NULL,NULL,NULL,NULL),(10005,1518,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10006,1518,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10007,1518,'dichloromethane_extractives_mass_relative_mass',10042,9994,'mean',NULL,NULL,NULL,NULL,NULL),(10008,1518,'acetone_extractives_mass_relative_mass',10043,9994,'mean',NULL,NULL,NULL,NULL,NULL),(10009,1518,'ethanol_extractives_mass_relative_mass',10044,9994,'mean',NULL,NULL,NULL,NULL,NULL),(10010,1518,'water_extractives_mass_relative_mass',10045,9994,'mean',NULL,NULL,NULL,NULL,NULL),(10011,1518,'cellulose_mass_relative_mass',10046,9994,'mean',NULL,NULL,NULL,NULL,NULL),(10012,1518,'arabinose_mass_relative_mass',10047,9994,'mean',NULL,NULL,NULL,NULL,NULL),(10013,1518,'rhamnose_mass_relative_mass',10048,9994,'mean',NULL,NULL,NULL,NULL,NULL),(10014,1518,'xylose_mass_relative_mass',10049,9994,'mean',NULL,NULL,NULL,NULL,NULL),(10015,1518,'mannose_mass_relative_mass',10050,9994,'mean',NULL,NULL,NULL,NULL,NULL),(10016,1518,'galactose_mass_relative_mass',10051,9994,'mean',NULL,NULL,NULL,NULL,NULL),(10017,1518,'glucose_mass_relative_mass',10052,9994,'mean',NULL,NULL,NULL,NULL,NULL),(10018,1518,'glucuronic_acid_mass_relative_mass',10053,9994,'mean',NULL,NULL,NULL,NULL,NULL),(10019,1518,'galacturonic_acid_mass_relative_mass',10054,9994,'mean',NULL,NULL,NULL,NULL,NULL),(10020,1518,'holocellulose_mass_relative_mass',10055,9994,'mean',NULL,NULL,NULL,NULL,NULL),(10021,1518,'4_hydroxybenzaldehyde_mass_relative_mass',10056,9994,'mean',NULL,NULL,NULL,NULL,NULL),(10022,1518,'4_hydroxyacetophenone_mass_relative_mass',10057,9994,'mean',NULL,NULL,NULL,NULL,NULL),(10023,1518,'4_hydroxybenzoic_acid_mass_relative_mass',10058,9994,'mean',NULL,NULL,NULL,NULL,NULL),(10024,1518,'vanillin_mass_relative_mass',10059,9994,'mean',NULL,NULL,NULL,NULL,NULL),(10025,1518,'vanillic_acid_mass_relative_mass',10060,9994,'mean',NULL,NULL,NULL,NULL,NULL),(10026,1518,'acetovanillone_mass_relative_mass',10061,9994,'mean',NULL,NULL,NULL,NULL,NULL),(10027,1518,'syringe_aldehyde_mass_relative_mass',10062,9994,'mean',NULL,NULL,NULL,NULL,NULL),(10028,1518,'acetosyringone_mass_relative_mass',10063,9994,'mean',NULL,NULL,NULL,NULL,NULL),(10029,1518,'syringic_acid_mass_relative_mass',10064,9994,'mean',NULL,NULL,NULL,NULL,NULL),(10030,1518,'p_coumaric_acid_mass_relative_mass',10065,9994,'mean',NULL,NULL,NULL,NULL,NULL),(10031,1518,'ferulic_acid_mass_relative_mass',10066,9994,'mean',NULL,NULL,NULL,NULL,NULL),(10032,1518,'Klason_lignin_mass_relative_mass',10067,9994,'mean',NULL,NULL,NULL,NULL,NULL),(10033,1518,'soluble_lignin_mass_relative_mass',10068,9994,'mean',NULL,NULL,NULL,NULL,NULL),(10034,1518,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10035,1518,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10036,1518,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10037,1518,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10038,1518,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10039,1518,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10040,1518,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10041,1518,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10042,1518,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10043,1518,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10044,1518,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10045,1518,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10046,1518,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10047,1518,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10048,1518,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10049,1518,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10050,1518,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10051,1518,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10052,1518,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10053,1518,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10054,1518,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10055,1518,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10056,1518,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10057,1518,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10058,1518,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10059,1518,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10060,1518,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10061,1518,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10062,1518,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10063,1518,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10064,1518,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10065,1518,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10066,1518,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10067,1518,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10068,1518,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10069,1519,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10070,1519,'mass_relative_mass',10069,7819,'mean','se',NULL,0.42517006802721086,0.04421768707483011,NULL),(10071,1519,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(10072,1519,'ash_mass_relative_mass',10109,10069,'mean',NULL,NULL,NULL,NULL,NULL),(10073,1519,'N_relative_mass',10110,10069,'mean',NULL,NULL,NULL,NULL,NULL),(10074,1519,'P_relative_mass',10111,10069,'mean',NULL,NULL,NULL,NULL,NULL),(10075,1519,'Ca_relative_mass',10112,10069,'mean',NULL,NULL,NULL,NULL,NULL),(10076,1519,'K_relative_mass',10113,10069,'mean',NULL,NULL,NULL,NULL,NULL),(10077,1519,'Mg_relative_mass',10114,10069,'mean',NULL,NULL,NULL,NULL,NULL),(10078,1519,'Mn_relative_mass',10115,10069,'mean',NULL,NULL,NULL,NULL,NULL),(10079,1519,'C_relative_mass',10116,10069,'mean',NULL,NULL,NULL,NULL,NULL),(10080,1519,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10081,1519,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10082,1519,'dichloromethane_extractives_mass_relative_mass',10117,10069,'mean',NULL,NULL,NULL,NULL,NULL),(10083,1519,'acetone_extractives_mass_relative_mass',10118,10069,'mean',NULL,NULL,NULL,NULL,NULL),(10084,1519,'ethanol_extractives_mass_relative_mass',10119,10069,'mean',NULL,NULL,NULL,NULL,NULL),(10085,1519,'water_extractives_mass_relative_mass',10120,10069,'mean',NULL,NULL,NULL,NULL,NULL),(10086,1519,'cellulose_mass_relative_mass',10121,10069,'mean',NULL,NULL,NULL,NULL,NULL),(10087,1519,'arabinose_mass_relative_mass',10122,10069,'mean',NULL,NULL,NULL,NULL,NULL),(10088,1519,'rhamnose_mass_relative_mass',10123,10069,'mean',NULL,NULL,NULL,NULL,NULL),(10089,1519,'xylose_mass_relative_mass',10124,10069,'mean',NULL,NULL,NULL,NULL,NULL),(10090,1519,'mannose_mass_relative_mass',10125,10069,'mean',NULL,NULL,NULL,NULL,NULL),(10091,1519,'galactose_mass_relative_mass',10126,10069,'mean',NULL,NULL,NULL,NULL,NULL),(10092,1519,'glucose_mass_relative_mass',10127,10069,'mean',NULL,NULL,NULL,NULL,NULL),(10093,1519,'glucuronic_acid_mass_relative_mass',10128,10069,'mean',NULL,NULL,NULL,NULL,NULL),(10094,1519,'galacturonic_acid_mass_relative_mass',10129,10069,'mean',NULL,NULL,NULL,NULL,NULL),(10095,1519,'holocellulose_mass_relative_mass',10130,10069,'mean',NULL,NULL,NULL,NULL,NULL),(10096,1519,'4_hydroxybenzaldehyde_mass_relative_mass',10131,10069,'mean',NULL,NULL,NULL,NULL,NULL),(10097,1519,'4_hydroxyacetophenone_mass_relative_mass',10132,10069,'mean',NULL,NULL,NULL,NULL,NULL),(10098,1519,'4_hydroxybenzoic_acid_mass_relative_mass',10133,10069,'mean',NULL,NULL,NULL,NULL,NULL),(10099,1519,'vanillin_mass_relative_mass',10134,10069,'mean',NULL,NULL,NULL,NULL,NULL),(10100,1519,'vanillic_acid_mass_relative_mass',10135,10069,'mean',NULL,NULL,NULL,NULL,NULL),(10101,1519,'acetovanillone_mass_relative_mass',10136,10069,'mean',NULL,NULL,NULL,NULL,NULL),(10102,1519,'syringe_aldehyde_mass_relative_mass',10137,10069,'mean',NULL,NULL,NULL,NULL,NULL),(10103,1519,'acetosyringone_mass_relative_mass',10138,10069,'mean',NULL,NULL,NULL,NULL,NULL),(10104,1519,'syringic_acid_mass_relative_mass',10139,10069,'mean',NULL,NULL,NULL,NULL,NULL),(10105,1519,'p_coumaric_acid_mass_relative_mass',10140,10069,'mean',NULL,NULL,NULL,NULL,NULL),(10106,1519,'ferulic_acid_mass_relative_mass',10141,10069,'mean',NULL,NULL,NULL,NULL,NULL),(10107,1519,'Klason_lignin_mass_relative_mass',10142,10069,'mean',NULL,NULL,NULL,NULL,NULL),(10108,1519,'soluble_lignin_mass_relative_mass',10143,10069,'mean',NULL,NULL,NULL,NULL,NULL),(10109,1519,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10110,1519,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10111,1519,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10112,1519,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10113,1519,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10114,1519,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10115,1519,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10116,1519,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10117,1519,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10118,1519,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10119,1519,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10120,1519,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10121,1519,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10122,1519,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10123,1519,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10124,1519,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10125,1519,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10126,1519,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10127,1519,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10128,1519,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10129,1519,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10130,1519,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10131,1519,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10132,1519,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10133,1519,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10134,1519,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10135,1519,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10136,1519,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10137,1519,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10138,1519,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10139,1519,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10140,1519,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10141,1519,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10142,1519,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10143,1519,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10144,1520,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10145,1520,'mass_relative_mass',10144,7819,'mean','se',NULL,0.18027210884353742,0.030612244897959186,NULL),(10146,1520,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(10147,1520,'ash_mass_relative_mass',10184,10144,'mean',NULL,NULL,NULL,NULL,NULL),(10148,1520,'N_relative_mass',10185,10144,'mean',NULL,NULL,NULL,NULL,NULL),(10149,1520,'P_relative_mass',10186,10144,'mean',NULL,NULL,NULL,NULL,NULL),(10150,1520,'Ca_relative_mass',10187,10144,'mean',NULL,NULL,NULL,NULL,NULL),(10151,1520,'K_relative_mass',10188,10144,'mean',NULL,NULL,NULL,NULL,NULL),(10152,1520,'Mg_relative_mass',10189,10144,'mean',NULL,NULL,NULL,NULL,NULL),(10153,1520,'Mn_relative_mass',10190,10144,'mean',NULL,NULL,NULL,NULL,NULL),(10154,1520,'C_relative_mass',10191,10144,'mean',NULL,NULL,NULL,NULL,NULL),(10155,1520,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10156,1520,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10157,1520,'dichloromethane_extractives_mass_relative_mass',10192,10144,'mean',NULL,NULL,NULL,NULL,NULL),(10158,1520,'acetone_extractives_mass_relative_mass',10193,10144,'mean',NULL,NULL,NULL,NULL,NULL),(10159,1520,'ethanol_extractives_mass_relative_mass',10194,10144,'mean',NULL,NULL,NULL,NULL,NULL),(10160,1520,'water_extractives_mass_relative_mass',10195,10144,'mean',NULL,NULL,NULL,NULL,NULL),(10161,1520,'cellulose_mass_relative_mass',10196,10144,'mean',NULL,NULL,NULL,NULL,NULL),(10162,1520,'arabinose_mass_relative_mass',10197,10144,'mean',NULL,NULL,NULL,NULL,NULL),(10163,1520,'rhamnose_mass_relative_mass',10198,10144,'mean',NULL,NULL,NULL,NULL,NULL),(10164,1520,'xylose_mass_relative_mass',10199,10144,'mean',NULL,NULL,NULL,NULL,NULL),(10165,1520,'mannose_mass_relative_mass',10200,10144,'mean',NULL,NULL,NULL,NULL,NULL),(10166,1520,'galactose_mass_relative_mass',10201,10144,'mean',NULL,NULL,NULL,NULL,NULL),(10167,1520,'glucose_mass_relative_mass',10202,10144,'mean',NULL,NULL,NULL,NULL,NULL),(10168,1520,'glucuronic_acid_mass_relative_mass',10203,10144,'mean',NULL,NULL,NULL,NULL,NULL),(10169,1520,'galacturonic_acid_mass_relative_mass',10204,10144,'mean',NULL,NULL,NULL,NULL,NULL),(10170,1520,'holocellulose_mass_relative_mass',10205,10144,'mean',NULL,NULL,NULL,NULL,NULL),(10171,1520,'4_hydroxybenzaldehyde_mass_relative_mass',10206,10144,'mean',NULL,NULL,NULL,NULL,NULL),(10172,1520,'4_hydroxyacetophenone_mass_relative_mass',10207,10144,'mean',NULL,NULL,NULL,NULL,NULL),(10173,1520,'4_hydroxybenzoic_acid_mass_relative_mass',10208,10144,'mean',NULL,NULL,NULL,NULL,NULL),(10174,1520,'vanillin_mass_relative_mass',10209,10144,'mean',NULL,NULL,NULL,NULL,NULL),(10175,1520,'vanillic_acid_mass_relative_mass',10210,10144,'mean',NULL,NULL,NULL,NULL,NULL),(10176,1520,'acetovanillone_mass_relative_mass',10211,10144,'mean',NULL,NULL,NULL,NULL,NULL),(10177,1520,'syringe_aldehyde_mass_relative_mass',10212,10144,'mean',NULL,NULL,NULL,NULL,NULL),(10178,1520,'acetosyringone_mass_relative_mass',10213,10144,'mean',NULL,NULL,NULL,NULL,NULL),(10179,1520,'syringic_acid_mass_relative_mass',10214,10144,'mean',NULL,NULL,NULL,NULL,NULL),(10180,1520,'p_coumaric_acid_mass_relative_mass',10215,10144,'mean',NULL,NULL,NULL,NULL,NULL),(10181,1520,'ferulic_acid_mass_relative_mass',10216,10144,'mean',NULL,NULL,NULL,NULL,NULL),(10182,1520,'Klason_lignin_mass_relative_mass',10217,10144,'mean',NULL,NULL,NULL,NULL,NULL),(10183,1520,'soluble_lignin_mass_relative_mass',10218,10144,'mean',NULL,NULL,NULL,NULL,NULL),(10184,1520,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10185,1520,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10186,1520,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10187,1520,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10188,1520,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10189,1520,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10190,1520,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10191,1520,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10192,1520,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10193,1520,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10194,1520,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10195,1520,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10196,1520,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10197,1520,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10198,1520,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10199,1520,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10200,1520,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10201,1520,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10202,1520,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10203,1520,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10204,1520,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10205,1520,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10206,1520,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10207,1520,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10208,1520,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10209,1520,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10210,1520,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10211,1520,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10212,1520,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10213,1520,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10214,1520,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10215,1520,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10216,1520,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10217,1520,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10218,1520,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10219,1521,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10220,1521,'mass_relative_mass',10219,7894,'mean','se',NULL,0.6802721088435374,0.034013605442177096,NULL),(10221,1521,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(10222,1521,'ash_mass_relative_mass',10259,10219,'mean',NULL,NULL,NULL,NULL,NULL),(10223,1521,'N_relative_mass',10260,10219,'mean',NULL,NULL,NULL,NULL,NULL),(10224,1521,'P_relative_mass',10261,10219,'mean',NULL,NULL,NULL,NULL,NULL),(10225,1521,'Ca_relative_mass',10262,10219,'mean',NULL,NULL,NULL,NULL,NULL),(10226,1521,'K_relative_mass',10263,10219,'mean',NULL,NULL,NULL,NULL,NULL),(10227,1521,'Mg_relative_mass',10264,10219,'mean',NULL,NULL,NULL,NULL,NULL),(10228,1521,'Mn_relative_mass',10265,10219,'mean',NULL,NULL,NULL,NULL,NULL),(10229,1521,'C_relative_mass',10266,10219,'mean',NULL,NULL,NULL,NULL,NULL),(10230,1521,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10231,1521,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10232,1521,'dichloromethane_extractives_mass_relative_mass',10267,10219,'mean',NULL,NULL,NULL,NULL,NULL),(10233,1521,'acetone_extractives_mass_relative_mass',10268,10219,'mean',NULL,NULL,NULL,NULL,NULL),(10234,1521,'ethanol_extractives_mass_relative_mass',10269,10219,'mean',NULL,NULL,NULL,NULL,NULL),(10235,1521,'water_extractives_mass_relative_mass',10270,10219,'mean',NULL,NULL,NULL,NULL,NULL),(10236,1521,'cellulose_mass_relative_mass',10271,10219,'mean',NULL,NULL,NULL,NULL,NULL),(10237,1521,'arabinose_mass_relative_mass',10272,10219,'mean',NULL,NULL,NULL,NULL,NULL),(10238,1521,'rhamnose_mass_relative_mass',10273,10219,'mean',NULL,NULL,NULL,NULL,NULL),(10239,1521,'xylose_mass_relative_mass',10274,10219,'mean',NULL,NULL,NULL,NULL,NULL),(10240,1521,'mannose_mass_relative_mass',10275,10219,'mean',NULL,NULL,NULL,NULL,NULL),(10241,1521,'galactose_mass_relative_mass',10276,10219,'mean',NULL,NULL,NULL,NULL,NULL),(10242,1521,'glucose_mass_relative_mass',10277,10219,'mean',NULL,NULL,NULL,NULL,NULL),(10243,1521,'glucuronic_acid_mass_relative_mass',10278,10219,'mean',NULL,NULL,NULL,NULL,NULL),(10244,1521,'galacturonic_acid_mass_relative_mass',10279,10219,'mean',NULL,NULL,NULL,NULL,NULL),(10245,1521,'holocellulose_mass_relative_mass',10280,10219,'mean',NULL,NULL,NULL,NULL,NULL),(10246,1521,'4_hydroxybenzaldehyde_mass_relative_mass',10281,10219,'mean',NULL,NULL,NULL,NULL,NULL),(10247,1521,'4_hydroxyacetophenone_mass_relative_mass',10282,10219,'mean',NULL,NULL,NULL,NULL,NULL),(10248,1521,'4_hydroxybenzoic_acid_mass_relative_mass',10283,10219,'mean',NULL,NULL,NULL,NULL,NULL),(10249,1521,'vanillin_mass_relative_mass',10284,10219,'mean',NULL,NULL,NULL,NULL,NULL),(10250,1521,'vanillic_acid_mass_relative_mass',10285,10219,'mean',NULL,NULL,NULL,NULL,NULL),(10251,1521,'acetovanillone_mass_relative_mass',10286,10219,'mean',NULL,NULL,NULL,NULL,NULL),(10252,1521,'syringe_aldehyde_mass_relative_mass',10287,10219,'mean',NULL,NULL,NULL,NULL,NULL),(10253,1521,'acetosyringone_mass_relative_mass',10288,10219,'mean',NULL,NULL,NULL,NULL,NULL),(10254,1521,'syringic_acid_mass_relative_mass',10289,10219,'mean',NULL,NULL,NULL,NULL,NULL),(10255,1521,'p_coumaric_acid_mass_relative_mass',10290,10219,'mean',NULL,NULL,NULL,NULL,NULL),(10256,1521,'ferulic_acid_mass_relative_mass',10291,10219,'mean',NULL,NULL,NULL,NULL,NULL),(10257,1521,'Klason_lignin_mass_relative_mass',10292,10219,'mean',NULL,NULL,NULL,NULL,NULL),(10258,1521,'soluble_lignin_mass_relative_mass',10293,10219,'mean',NULL,NULL,NULL,NULL,NULL),(10259,1521,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10260,1521,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10261,1521,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10262,1521,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10263,1521,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10264,1521,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10265,1521,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10266,1521,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10267,1521,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10268,1521,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10269,1521,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10270,1521,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10271,1521,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10272,1521,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10273,1521,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10274,1521,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10275,1521,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10276,1521,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10277,1521,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10278,1521,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10279,1521,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10280,1521,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10281,1521,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10282,1521,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10283,1521,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10284,1521,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10285,1521,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10286,1521,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10287,1521,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10288,1521,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10289,1521,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10290,1521,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10291,1521,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10292,1521,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10293,1521,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10294,1522,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10295,1522,'mass_relative_mass',10294,7894,'mean','se',NULL,0.6326530612244899,0.04081632653061206,NULL),(10296,1522,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(10297,1522,'ash_mass_relative_mass',10334,10294,'mean',NULL,NULL,NULL,NULL,NULL),(10298,1522,'N_relative_mass',10335,10294,'mean',NULL,NULL,NULL,NULL,NULL),(10299,1522,'P_relative_mass',10336,10294,'mean',NULL,NULL,NULL,NULL,NULL),(10300,1522,'Ca_relative_mass',10337,10294,'mean',NULL,NULL,NULL,NULL,NULL),(10301,1522,'K_relative_mass',10338,10294,'mean',NULL,NULL,NULL,NULL,NULL),(10302,1522,'Mg_relative_mass',10339,10294,'mean',NULL,NULL,NULL,NULL,NULL),(10303,1522,'Mn_relative_mass',10340,10294,'mean',NULL,NULL,NULL,NULL,NULL),(10304,1522,'C_relative_mass',10341,10294,'mean',NULL,NULL,NULL,NULL,NULL),(10305,1522,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10306,1522,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10307,1522,'dichloromethane_extractives_mass_relative_mass',10342,10294,'mean',NULL,NULL,NULL,NULL,NULL),(10308,1522,'acetone_extractives_mass_relative_mass',10343,10294,'mean',NULL,NULL,NULL,NULL,NULL),(10309,1522,'ethanol_extractives_mass_relative_mass',10344,10294,'mean',NULL,NULL,NULL,NULL,NULL),(10310,1522,'water_extractives_mass_relative_mass',10345,10294,'mean',NULL,NULL,NULL,NULL,NULL),(10311,1522,'cellulose_mass_relative_mass',10346,10294,'mean',NULL,NULL,NULL,NULL,NULL),(10312,1522,'arabinose_mass_relative_mass',10347,10294,'mean',NULL,NULL,NULL,NULL,NULL),(10313,1522,'rhamnose_mass_relative_mass',10348,10294,'mean',NULL,NULL,NULL,NULL,NULL),(10314,1522,'xylose_mass_relative_mass',10349,10294,'mean',NULL,NULL,NULL,NULL,NULL),(10315,1522,'mannose_mass_relative_mass',10350,10294,'mean',NULL,NULL,NULL,NULL,NULL),(10316,1522,'galactose_mass_relative_mass',10351,10294,'mean',NULL,NULL,NULL,NULL,NULL),(10317,1522,'glucose_mass_relative_mass',10352,10294,'mean',NULL,NULL,NULL,NULL,NULL),(10318,1522,'glucuronic_acid_mass_relative_mass',10353,10294,'mean',NULL,NULL,NULL,NULL,NULL),(10319,1522,'galacturonic_acid_mass_relative_mass',10354,10294,'mean',NULL,NULL,NULL,NULL,NULL),(10320,1522,'holocellulose_mass_relative_mass',10355,10294,'mean',NULL,NULL,NULL,NULL,NULL),(10321,1522,'4_hydroxybenzaldehyde_mass_relative_mass',10356,10294,'mean',NULL,NULL,NULL,NULL,NULL),(10322,1522,'4_hydroxyacetophenone_mass_relative_mass',10357,10294,'mean',NULL,NULL,NULL,NULL,NULL),(10323,1522,'4_hydroxybenzoic_acid_mass_relative_mass',10358,10294,'mean',NULL,NULL,NULL,NULL,NULL),(10324,1522,'vanillin_mass_relative_mass',10359,10294,'mean',NULL,NULL,NULL,NULL,NULL),(10325,1522,'vanillic_acid_mass_relative_mass',10360,10294,'mean',NULL,NULL,NULL,NULL,NULL),(10326,1522,'acetovanillone_mass_relative_mass',10361,10294,'mean',NULL,NULL,NULL,NULL,NULL),(10327,1522,'syringe_aldehyde_mass_relative_mass',10362,10294,'mean',NULL,NULL,NULL,NULL,NULL),(10328,1522,'acetosyringone_mass_relative_mass',10363,10294,'mean',NULL,NULL,NULL,NULL,NULL),(10329,1522,'syringic_acid_mass_relative_mass',10364,10294,'mean',NULL,NULL,NULL,NULL,NULL),(10330,1522,'p_coumaric_acid_mass_relative_mass',10365,10294,'mean',NULL,NULL,NULL,NULL,NULL),(10331,1522,'ferulic_acid_mass_relative_mass',10366,10294,'mean',NULL,NULL,NULL,NULL,NULL),(10332,1522,'Klason_lignin_mass_relative_mass',10367,10294,'mean',NULL,NULL,NULL,NULL,NULL),(10333,1522,'soluble_lignin_mass_relative_mass',10368,10294,'mean',NULL,NULL,NULL,NULL,NULL),(10334,1522,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10335,1522,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10336,1522,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10337,1522,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10338,1522,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10339,1522,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10340,1522,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10341,1522,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10342,1522,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10343,1522,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10344,1522,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10345,1522,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10346,1522,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10347,1522,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10348,1522,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10349,1522,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10350,1522,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10351,1522,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10352,1522,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10353,1522,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10354,1522,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10355,1522,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10356,1522,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10357,1522,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10358,1522,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10359,1522,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10360,1522,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10361,1522,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10362,1522,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10363,1522,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10364,1522,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10365,1522,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10366,1522,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10367,1522,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10368,1522,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10369,1523,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10370,1523,'mass_relative_mass',10369,7969,'mean','se',NULL,0.8843537414965986,0.02721088435374142,NULL),(10371,1523,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(10372,1523,'ash_mass_relative_mass',10409,10369,'mean',NULL,NULL,NULL,NULL,NULL),(10373,1523,'N_relative_mass',10410,10369,'mean',NULL,NULL,NULL,NULL,NULL),(10374,1523,'P_relative_mass',10411,10369,'mean',NULL,NULL,NULL,NULL,NULL),(10375,1523,'Ca_relative_mass',10412,10369,'mean',NULL,NULL,NULL,NULL,NULL),(10376,1523,'K_relative_mass',10413,10369,'mean',NULL,NULL,NULL,NULL,NULL),(10377,1523,'Mg_relative_mass',10414,10369,'mean',NULL,NULL,NULL,NULL,NULL),(10378,1523,'Mn_relative_mass',10415,10369,'mean',NULL,NULL,NULL,NULL,NULL),(10379,1523,'C_relative_mass',10416,10369,'mean',NULL,NULL,NULL,NULL,NULL),(10380,1523,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10381,1523,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10382,1523,'dichloromethane_extractives_mass_relative_mass',10417,10369,'mean',NULL,NULL,NULL,NULL,NULL),(10383,1523,'acetone_extractives_mass_relative_mass',10418,10369,'mean',NULL,NULL,NULL,NULL,NULL),(10384,1523,'ethanol_extractives_mass_relative_mass',10419,10369,'mean',NULL,NULL,NULL,NULL,NULL),(10385,1523,'water_extractives_mass_relative_mass',10420,10369,'mean',NULL,NULL,NULL,NULL,NULL),(10386,1523,'cellulose_mass_relative_mass',10421,10369,'mean',NULL,NULL,NULL,NULL,NULL),(10387,1523,'arabinose_mass_relative_mass',10422,10369,'mean',NULL,NULL,NULL,NULL,NULL),(10388,1523,'rhamnose_mass_relative_mass',10423,10369,'mean',NULL,NULL,NULL,NULL,NULL),(10389,1523,'xylose_mass_relative_mass',10424,10369,'mean',NULL,NULL,NULL,NULL,NULL),(10390,1523,'mannose_mass_relative_mass',10425,10369,'mean',NULL,NULL,NULL,NULL,NULL),(10391,1523,'galactose_mass_relative_mass',10426,10369,'mean',NULL,NULL,NULL,NULL,NULL),(10392,1523,'glucose_mass_relative_mass',10427,10369,'mean',NULL,NULL,NULL,NULL,NULL),(10393,1523,'glucuronic_acid_mass_relative_mass',10428,10369,'mean',NULL,NULL,NULL,NULL,NULL),(10394,1523,'galacturonic_acid_mass_relative_mass',10429,10369,'mean',NULL,NULL,NULL,NULL,NULL),(10395,1523,'holocellulose_mass_relative_mass',10430,10369,'mean',NULL,NULL,NULL,NULL,NULL),(10396,1523,'4_hydroxybenzaldehyde_mass_relative_mass',10431,10369,'mean',NULL,NULL,NULL,NULL,NULL),(10397,1523,'4_hydroxyacetophenone_mass_relative_mass',10432,10369,'mean',NULL,NULL,NULL,NULL,NULL),(10398,1523,'4_hydroxybenzoic_acid_mass_relative_mass',10433,10369,'mean',NULL,NULL,NULL,NULL,NULL),(10399,1523,'vanillin_mass_relative_mass',10434,10369,'mean',NULL,NULL,NULL,NULL,NULL),(10400,1523,'vanillic_acid_mass_relative_mass',10435,10369,'mean',NULL,NULL,NULL,NULL,NULL),(10401,1523,'acetovanillone_mass_relative_mass',10436,10369,'mean',NULL,NULL,NULL,NULL,NULL),(10402,1523,'syringe_aldehyde_mass_relative_mass',10437,10369,'mean',NULL,NULL,NULL,NULL,NULL),(10403,1523,'acetosyringone_mass_relative_mass',10438,10369,'mean',NULL,NULL,NULL,NULL,NULL),(10404,1523,'syringic_acid_mass_relative_mass',10439,10369,'mean',NULL,NULL,NULL,NULL,NULL),(10405,1523,'p_coumaric_acid_mass_relative_mass',10440,10369,'mean',NULL,NULL,NULL,NULL,NULL),(10406,1523,'ferulic_acid_mass_relative_mass',10441,10369,'mean',NULL,NULL,NULL,NULL,NULL),(10407,1523,'Klason_lignin_mass_relative_mass',10442,10369,'mean',NULL,NULL,NULL,NULL,NULL),(10408,1523,'soluble_lignin_mass_relative_mass',10443,10369,'mean',NULL,NULL,NULL,NULL,NULL),(10409,1523,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10410,1523,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10411,1523,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10412,1523,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10413,1523,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10414,1523,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10415,1523,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10416,1523,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10417,1523,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10418,1523,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10419,1523,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10420,1523,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10421,1523,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10422,1523,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10423,1523,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10424,1523,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10425,1523,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10426,1523,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10427,1523,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10428,1523,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10429,1523,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10430,1523,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10431,1523,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10432,1523,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10433,1523,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10434,1523,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10435,1523,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10436,1523,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10437,1523,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10438,1523,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10439,1523,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10440,1523,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10441,1523,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10442,1523,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10443,1523,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10444,1524,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10445,1524,'mass_relative_mass',10444,7969,'mean','se',NULL,0.8299319727891158,0.027210884353741277,NULL),(10446,1524,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(10447,1524,'ash_mass_relative_mass',10484,10444,'mean',NULL,NULL,NULL,NULL,NULL),(10448,1524,'N_relative_mass',10485,10444,'mean',NULL,NULL,NULL,NULL,NULL),(10449,1524,'P_relative_mass',10486,10444,'mean',NULL,NULL,NULL,NULL,NULL),(10450,1524,'Ca_relative_mass',10487,10444,'mean',NULL,NULL,NULL,NULL,NULL),(10451,1524,'K_relative_mass',10488,10444,'mean',NULL,NULL,NULL,NULL,NULL),(10452,1524,'Mg_relative_mass',10489,10444,'mean',NULL,NULL,NULL,NULL,NULL),(10453,1524,'Mn_relative_mass',10490,10444,'mean',NULL,NULL,NULL,NULL,NULL),(10454,1524,'C_relative_mass',10491,10444,'mean',NULL,NULL,NULL,NULL,NULL),(10455,1524,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10456,1524,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10457,1524,'dichloromethane_extractives_mass_relative_mass',10492,10444,'mean',NULL,NULL,NULL,NULL,NULL),(10458,1524,'acetone_extractives_mass_relative_mass',10493,10444,'mean',NULL,NULL,NULL,NULL,NULL),(10459,1524,'ethanol_extractives_mass_relative_mass',10494,10444,'mean',NULL,NULL,NULL,NULL,NULL),(10460,1524,'water_extractives_mass_relative_mass',10495,10444,'mean',NULL,NULL,NULL,NULL,NULL),(10461,1524,'cellulose_mass_relative_mass',10496,10444,'mean',NULL,NULL,NULL,NULL,NULL),(10462,1524,'arabinose_mass_relative_mass',10497,10444,'mean',NULL,NULL,NULL,NULL,NULL),(10463,1524,'rhamnose_mass_relative_mass',10498,10444,'mean',NULL,NULL,NULL,NULL,NULL),(10464,1524,'xylose_mass_relative_mass',10499,10444,'mean',NULL,NULL,NULL,NULL,NULL),(10465,1524,'mannose_mass_relative_mass',10500,10444,'mean',NULL,NULL,NULL,NULL,NULL),(10466,1524,'galactose_mass_relative_mass',10501,10444,'mean',NULL,NULL,NULL,NULL,NULL),(10467,1524,'glucose_mass_relative_mass',10502,10444,'mean',NULL,NULL,NULL,NULL,NULL),(10468,1524,'glucuronic_acid_mass_relative_mass',10503,10444,'mean',NULL,NULL,NULL,NULL,NULL),(10469,1524,'galacturonic_acid_mass_relative_mass',10504,10444,'mean',NULL,NULL,NULL,NULL,NULL),(10470,1524,'holocellulose_mass_relative_mass',10505,10444,'mean',NULL,NULL,NULL,NULL,NULL),(10471,1524,'4_hydroxybenzaldehyde_mass_relative_mass',10506,10444,'mean',NULL,NULL,NULL,NULL,NULL),(10472,1524,'4_hydroxyacetophenone_mass_relative_mass',10507,10444,'mean',NULL,NULL,NULL,NULL,NULL),(10473,1524,'4_hydroxybenzoic_acid_mass_relative_mass',10508,10444,'mean',NULL,NULL,NULL,NULL,NULL),(10474,1524,'vanillin_mass_relative_mass',10509,10444,'mean',NULL,NULL,NULL,NULL,NULL),(10475,1524,'vanillic_acid_mass_relative_mass',10510,10444,'mean',NULL,NULL,NULL,NULL,NULL),(10476,1524,'acetovanillone_mass_relative_mass',10511,10444,'mean',NULL,NULL,NULL,NULL,NULL),(10477,1524,'syringe_aldehyde_mass_relative_mass',10512,10444,'mean',NULL,NULL,NULL,NULL,NULL),(10478,1524,'acetosyringone_mass_relative_mass',10513,10444,'mean',NULL,NULL,NULL,NULL,NULL),(10479,1524,'syringic_acid_mass_relative_mass',10514,10444,'mean',NULL,NULL,NULL,NULL,NULL),(10480,1524,'p_coumaric_acid_mass_relative_mass',10515,10444,'mean',NULL,NULL,NULL,NULL,NULL),(10481,1524,'ferulic_acid_mass_relative_mass',10516,10444,'mean',NULL,NULL,NULL,NULL,NULL),(10482,1524,'Klason_lignin_mass_relative_mass',10517,10444,'mean',NULL,NULL,NULL,NULL,NULL),(10483,1524,'soluble_lignin_mass_relative_mass',10518,10444,'mean',NULL,NULL,NULL,NULL,NULL),(10484,1524,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10485,1524,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10486,1524,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10487,1524,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10488,1524,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10489,1524,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10490,1524,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10491,1524,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10492,1524,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10493,1524,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10494,1524,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10495,1524,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10496,1524,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10497,1524,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10498,1524,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10499,1524,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10500,1524,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10501,1524,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10502,1524,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10503,1524,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10504,1524,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10505,1524,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10506,1524,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10507,1524,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10508,1524,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10509,1524,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10510,1524,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10511,1524,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10512,1524,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10513,1524,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10514,1524,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10515,1524,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10516,1524,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10517,1524,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10518,1524,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10519,1525,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10520,1525,'mass_relative_mass',10519,8044,'mean','se',NULL,0.4591836734693879,0.05782312925170075,NULL),(10521,1525,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(10522,1525,'ash_mass_relative_mass',10559,10519,'mean',NULL,NULL,NULL,NULL,NULL),(10523,1525,'N_relative_mass',10560,10519,'mean',NULL,NULL,NULL,NULL,NULL),(10524,1525,'P_relative_mass',10561,10519,'mean',NULL,NULL,NULL,NULL,NULL),(10525,1525,'Ca_relative_mass',10562,10519,'mean',NULL,NULL,NULL,NULL,NULL),(10526,1525,'K_relative_mass',10563,10519,'mean',NULL,NULL,NULL,NULL,NULL),(10527,1525,'Mg_relative_mass',10564,10519,'mean',NULL,NULL,NULL,NULL,NULL),(10528,1525,'Mn_relative_mass',10565,10519,'mean',NULL,NULL,NULL,NULL,NULL),(10529,1525,'C_relative_mass',10566,10519,'mean',NULL,NULL,NULL,NULL,NULL),(10530,1525,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10531,1525,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10532,1525,'dichloromethane_extractives_mass_relative_mass',10567,10519,'mean',NULL,NULL,NULL,NULL,NULL),(10533,1525,'acetone_extractives_mass_relative_mass',10568,10519,'mean',NULL,NULL,NULL,NULL,NULL),(10534,1525,'ethanol_extractives_mass_relative_mass',10569,10519,'mean',NULL,NULL,NULL,NULL,NULL),(10535,1525,'water_extractives_mass_relative_mass',10570,10519,'mean',NULL,NULL,NULL,NULL,NULL),(10536,1525,'cellulose_mass_relative_mass',10571,10519,'mean',NULL,NULL,NULL,NULL,NULL),(10537,1525,'arabinose_mass_relative_mass',10572,10519,'mean',NULL,NULL,NULL,NULL,NULL),(10538,1525,'rhamnose_mass_relative_mass',10573,10519,'mean',NULL,NULL,NULL,NULL,NULL),(10539,1525,'xylose_mass_relative_mass',10574,10519,'mean',NULL,NULL,NULL,NULL,NULL),(10540,1525,'mannose_mass_relative_mass',10575,10519,'mean',NULL,NULL,NULL,NULL,NULL),(10541,1525,'galactose_mass_relative_mass',10576,10519,'mean',NULL,NULL,NULL,NULL,NULL),(10542,1525,'glucose_mass_relative_mass',10577,10519,'mean',NULL,NULL,NULL,NULL,NULL),(10543,1525,'glucuronic_acid_mass_relative_mass',10578,10519,'mean',NULL,NULL,NULL,NULL,NULL),(10544,1525,'galacturonic_acid_mass_relative_mass',10579,10519,'mean',NULL,NULL,NULL,NULL,NULL),(10545,1525,'holocellulose_mass_relative_mass',10580,10519,'mean',NULL,NULL,NULL,NULL,NULL),(10546,1525,'4_hydroxybenzaldehyde_mass_relative_mass',10581,10519,'mean',NULL,NULL,NULL,NULL,NULL),(10547,1525,'4_hydroxyacetophenone_mass_relative_mass',10582,10519,'mean',NULL,NULL,NULL,NULL,NULL),(10548,1525,'4_hydroxybenzoic_acid_mass_relative_mass',10583,10519,'mean',NULL,NULL,NULL,NULL,NULL),(10549,1525,'vanillin_mass_relative_mass',10584,10519,'mean',NULL,NULL,NULL,NULL,NULL),(10550,1525,'vanillic_acid_mass_relative_mass',10585,10519,'mean',NULL,NULL,NULL,NULL,NULL),(10551,1525,'acetovanillone_mass_relative_mass',10586,10519,'mean',NULL,NULL,NULL,NULL,NULL),(10552,1525,'syringe_aldehyde_mass_relative_mass',10587,10519,'mean',NULL,NULL,NULL,NULL,NULL),(10553,1525,'acetosyringone_mass_relative_mass',10588,10519,'mean',NULL,NULL,NULL,NULL,NULL),(10554,1525,'syringic_acid_mass_relative_mass',10589,10519,'mean',NULL,NULL,NULL,NULL,NULL),(10555,1525,'p_coumaric_acid_mass_relative_mass',10590,10519,'mean',NULL,NULL,NULL,NULL,NULL),(10556,1525,'ferulic_acid_mass_relative_mass',10591,10519,'mean',NULL,NULL,NULL,NULL,NULL),(10557,1525,'Klason_lignin_mass_relative_mass',10592,10519,'mean',NULL,NULL,NULL,NULL,NULL),(10558,1525,'soluble_lignin_mass_relative_mass',10593,10519,'mean',NULL,NULL,NULL,NULL,NULL),(10559,1525,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10560,1525,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10561,1525,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10562,1525,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10563,1525,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10564,1525,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10565,1525,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10566,1525,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10567,1525,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10568,1525,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10569,1525,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10570,1525,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10571,1525,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10572,1525,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10573,1525,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10574,1525,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10575,1525,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10576,1525,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10577,1525,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10578,1525,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10579,1525,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10580,1525,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10581,1525,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10582,1525,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10583,1525,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10584,1525,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10585,1525,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10586,1525,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10587,1525,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10588,1525,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10589,1525,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10590,1525,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10591,1525,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10592,1525,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10593,1525,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10594,1526,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10595,1526,'mass_relative_mass',10594,8044,'mean','se',NULL,0.11904761904761933,0.03401360544217681,NULL),(10596,1526,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(10597,1526,'ash_mass_relative_mass',10634,10594,'mean',NULL,NULL,NULL,NULL,NULL),(10598,1526,'N_relative_mass',10635,10594,'mean',NULL,NULL,NULL,NULL,NULL),(10599,1526,'P_relative_mass',10636,10594,'mean',NULL,NULL,NULL,NULL,NULL),(10600,1526,'Ca_relative_mass',10637,10594,'mean',NULL,NULL,NULL,NULL,NULL),(10601,1526,'K_relative_mass',10638,10594,'mean',NULL,NULL,NULL,NULL,NULL),(10602,1526,'Mg_relative_mass',10639,10594,'mean',NULL,NULL,NULL,NULL,NULL),(10603,1526,'Mn_relative_mass',10640,10594,'mean',NULL,NULL,NULL,NULL,NULL),(10604,1526,'C_relative_mass',10641,10594,'mean',NULL,NULL,NULL,NULL,NULL),(10605,1526,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10606,1526,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10607,1526,'dichloromethane_extractives_mass_relative_mass',10642,10594,'mean',NULL,NULL,NULL,NULL,NULL),(10608,1526,'acetone_extractives_mass_relative_mass',10643,10594,'mean',NULL,NULL,NULL,NULL,NULL),(10609,1526,'ethanol_extractives_mass_relative_mass',10644,10594,'mean',NULL,NULL,NULL,NULL,NULL),(10610,1526,'water_extractives_mass_relative_mass',10645,10594,'mean',NULL,NULL,NULL,NULL,NULL),(10611,1526,'cellulose_mass_relative_mass',10646,10594,'mean',NULL,NULL,NULL,NULL,NULL),(10612,1526,'arabinose_mass_relative_mass',10647,10594,'mean',NULL,NULL,NULL,NULL,NULL),(10613,1526,'rhamnose_mass_relative_mass',10648,10594,'mean',NULL,NULL,NULL,NULL,NULL),(10614,1526,'xylose_mass_relative_mass',10649,10594,'mean',NULL,NULL,NULL,NULL,NULL),(10615,1526,'mannose_mass_relative_mass',10650,10594,'mean',NULL,NULL,NULL,NULL,NULL),(10616,1526,'galactose_mass_relative_mass',10651,10594,'mean',NULL,NULL,NULL,NULL,NULL),(10617,1526,'glucose_mass_relative_mass',10652,10594,'mean',NULL,NULL,NULL,NULL,NULL),(10618,1526,'glucuronic_acid_mass_relative_mass',10653,10594,'mean',NULL,NULL,NULL,NULL,NULL),(10619,1526,'galacturonic_acid_mass_relative_mass',10654,10594,'mean',NULL,NULL,NULL,NULL,NULL),(10620,1526,'holocellulose_mass_relative_mass',10655,10594,'mean',NULL,NULL,NULL,NULL,NULL),(10621,1526,'4_hydroxybenzaldehyde_mass_relative_mass',10656,10594,'mean',NULL,NULL,NULL,NULL,NULL),(10622,1526,'4_hydroxyacetophenone_mass_relative_mass',10657,10594,'mean',NULL,NULL,NULL,NULL,NULL),(10623,1526,'4_hydroxybenzoic_acid_mass_relative_mass',10658,10594,'mean',NULL,NULL,NULL,NULL,NULL),(10624,1526,'vanillin_mass_relative_mass',10659,10594,'mean',NULL,NULL,NULL,NULL,NULL),(10625,1526,'vanillic_acid_mass_relative_mass',10660,10594,'mean',NULL,NULL,NULL,NULL,NULL),(10626,1526,'acetovanillone_mass_relative_mass',10661,10594,'mean',NULL,NULL,NULL,NULL,NULL),(10627,1526,'syringe_aldehyde_mass_relative_mass',10662,10594,'mean',NULL,NULL,NULL,NULL,NULL),(10628,1526,'acetosyringone_mass_relative_mass',10663,10594,'mean',NULL,NULL,NULL,NULL,NULL),(10629,1526,'syringic_acid_mass_relative_mass',10664,10594,'mean',NULL,NULL,NULL,NULL,NULL),(10630,1526,'p_coumaric_acid_mass_relative_mass',10665,10594,'mean',NULL,NULL,NULL,NULL,NULL),(10631,1526,'ferulic_acid_mass_relative_mass',10666,10594,'mean',NULL,NULL,NULL,NULL,NULL),(10632,1526,'Klason_lignin_mass_relative_mass',10667,10594,'mean',NULL,NULL,NULL,NULL,NULL),(10633,1526,'soluble_lignin_mass_relative_mass',10668,10594,'mean',NULL,NULL,NULL,NULL,NULL),(10634,1526,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10635,1526,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10636,1526,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10637,1526,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10638,1526,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10639,1526,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10640,1526,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10641,1526,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10642,1526,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10643,1526,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10644,1526,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10645,1526,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10646,1526,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10647,1526,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10648,1526,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10649,1526,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10650,1526,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10651,1526,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10652,1526,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10653,1526,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10654,1526,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10655,1526,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10656,1526,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10657,1526,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10658,1526,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10659,1526,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10660,1526,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10661,1526,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10662,1526,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10663,1526,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10664,1526,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10665,1526,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10666,1526,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10667,1526,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10668,1526,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10669,1527,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10670,1527,'mass_relative_mass',10669,8119,'mean','se',NULL,0.5272108843537416,0.07142857142857138,NULL),(10671,1527,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(10672,1527,'ash_mass_relative_mass',10709,10669,'mean',NULL,NULL,NULL,NULL,NULL),(10673,1527,'N_relative_mass',10710,10669,'mean',NULL,NULL,NULL,NULL,NULL),(10674,1527,'P_relative_mass',10711,10669,'mean',NULL,NULL,NULL,NULL,NULL),(10675,1527,'Ca_relative_mass',10712,10669,'mean',NULL,NULL,NULL,NULL,NULL),(10676,1527,'K_relative_mass',10713,10669,'mean',NULL,NULL,NULL,NULL,NULL),(10677,1527,'Mg_relative_mass',10714,10669,'mean',NULL,NULL,NULL,NULL,NULL),(10678,1527,'Mn_relative_mass',10715,10669,'mean',NULL,NULL,NULL,NULL,NULL),(10679,1527,'C_relative_mass',10716,10669,'mean',NULL,NULL,NULL,NULL,NULL),(10680,1527,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10681,1527,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10682,1527,'dichloromethane_extractives_mass_relative_mass',10717,10669,'mean',NULL,NULL,NULL,NULL,NULL),(10683,1527,'acetone_extractives_mass_relative_mass',10718,10669,'mean',NULL,NULL,NULL,NULL,NULL),(10684,1527,'ethanol_extractives_mass_relative_mass',10719,10669,'mean',NULL,NULL,NULL,NULL,NULL),(10685,1527,'water_extractives_mass_relative_mass',10720,10669,'mean',NULL,NULL,NULL,NULL,NULL),(10686,1527,'cellulose_mass_relative_mass',10721,10669,'mean',NULL,NULL,NULL,NULL,NULL),(10687,1527,'arabinose_mass_relative_mass',10722,10669,'mean',NULL,NULL,NULL,NULL,NULL),(10688,1527,'rhamnose_mass_relative_mass',10723,10669,'mean',NULL,NULL,NULL,NULL,NULL),(10689,1527,'xylose_mass_relative_mass',10724,10669,'mean',NULL,NULL,NULL,NULL,NULL),(10690,1527,'mannose_mass_relative_mass',10725,10669,'mean',NULL,NULL,NULL,NULL,NULL),(10691,1527,'galactose_mass_relative_mass',10726,10669,'mean',NULL,NULL,NULL,NULL,NULL),(10692,1527,'glucose_mass_relative_mass',10727,10669,'mean',NULL,NULL,NULL,NULL,NULL),(10693,1527,'glucuronic_acid_mass_relative_mass',10728,10669,'mean',NULL,NULL,NULL,NULL,NULL),(10694,1527,'galacturonic_acid_mass_relative_mass',10729,10669,'mean',NULL,NULL,NULL,NULL,NULL),(10695,1527,'holocellulose_mass_relative_mass',10730,10669,'mean',NULL,NULL,NULL,NULL,NULL),(10696,1527,'4_hydroxybenzaldehyde_mass_relative_mass',10731,10669,'mean',NULL,NULL,NULL,NULL,NULL),(10697,1527,'4_hydroxyacetophenone_mass_relative_mass',10732,10669,'mean',NULL,NULL,NULL,NULL,NULL),(10698,1527,'4_hydroxybenzoic_acid_mass_relative_mass',10733,10669,'mean',NULL,NULL,NULL,NULL,NULL),(10699,1527,'vanillin_mass_relative_mass',10734,10669,'mean',NULL,NULL,NULL,NULL,NULL),(10700,1527,'vanillic_acid_mass_relative_mass',10735,10669,'mean',NULL,NULL,NULL,NULL,NULL),(10701,1527,'acetovanillone_mass_relative_mass',10736,10669,'mean',NULL,NULL,NULL,NULL,NULL),(10702,1527,'syringe_aldehyde_mass_relative_mass',10737,10669,'mean',NULL,NULL,NULL,NULL,NULL),(10703,1527,'acetosyringone_mass_relative_mass',10738,10669,'mean',NULL,NULL,NULL,NULL,NULL),(10704,1527,'syringic_acid_mass_relative_mass',10739,10669,'mean',NULL,NULL,NULL,NULL,NULL),(10705,1527,'p_coumaric_acid_mass_relative_mass',10740,10669,'mean',NULL,NULL,NULL,NULL,NULL),(10706,1527,'ferulic_acid_mass_relative_mass',10741,10669,'mean',NULL,NULL,NULL,NULL,NULL),(10707,1527,'Klason_lignin_mass_relative_mass',10742,10669,'mean',NULL,NULL,NULL,NULL,NULL),(10708,1527,'soluble_lignin_mass_relative_mass',10743,10669,'mean',NULL,NULL,NULL,NULL,NULL),(10709,1527,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10710,1527,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10711,1527,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10712,1527,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10713,1527,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10714,1527,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10715,1527,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10716,1527,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10717,1527,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10718,1527,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10719,1527,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10720,1527,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10721,1527,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10722,1527,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10723,1527,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10724,1527,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10725,1527,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10726,1527,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10727,1527,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10728,1527,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10729,1527,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10730,1527,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10731,1527,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10732,1527,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10733,1527,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10734,1527,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10735,1527,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10736,1527,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10737,1527,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10738,1527,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10739,1527,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10740,1527,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10741,1527,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10742,1527,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10743,1527,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10744,1528,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10745,1528,'mass_relative_mass',10744,8119,'mean','se',NULL,0.15646258503401392,0.023809523809523725,NULL),(10746,1528,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(10747,1528,'ash_mass_relative_mass',10784,10744,'mean',NULL,NULL,NULL,NULL,NULL),(10748,1528,'N_relative_mass',10785,10744,'mean',NULL,NULL,NULL,NULL,NULL),(10749,1528,'P_relative_mass',10786,10744,'mean',NULL,NULL,NULL,NULL,NULL),(10750,1528,'Ca_relative_mass',10787,10744,'mean',NULL,NULL,NULL,NULL,NULL),(10751,1528,'K_relative_mass',10788,10744,'mean',NULL,NULL,NULL,NULL,NULL),(10752,1528,'Mg_relative_mass',10789,10744,'mean',NULL,NULL,NULL,NULL,NULL),(10753,1528,'Mn_relative_mass',10790,10744,'mean',NULL,NULL,NULL,NULL,NULL),(10754,1528,'C_relative_mass',10791,10744,'mean',NULL,NULL,NULL,NULL,NULL),(10755,1528,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10756,1528,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10757,1528,'dichloromethane_extractives_mass_relative_mass',10792,10744,'mean',NULL,NULL,NULL,NULL,NULL),(10758,1528,'acetone_extractives_mass_relative_mass',10793,10744,'mean',NULL,NULL,NULL,NULL,NULL),(10759,1528,'ethanol_extractives_mass_relative_mass',10794,10744,'mean',NULL,NULL,NULL,NULL,NULL),(10760,1528,'water_extractives_mass_relative_mass',10795,10744,'mean',NULL,NULL,NULL,NULL,NULL),(10761,1528,'cellulose_mass_relative_mass',10796,10744,'mean',NULL,NULL,NULL,NULL,NULL),(10762,1528,'arabinose_mass_relative_mass',10797,10744,'mean',NULL,NULL,NULL,NULL,NULL),(10763,1528,'rhamnose_mass_relative_mass',10798,10744,'mean',NULL,NULL,NULL,NULL,NULL),(10764,1528,'xylose_mass_relative_mass',10799,10744,'mean',NULL,NULL,NULL,NULL,NULL),(10765,1528,'mannose_mass_relative_mass',10800,10744,'mean',NULL,NULL,NULL,NULL,NULL),(10766,1528,'galactose_mass_relative_mass',10801,10744,'mean',NULL,NULL,NULL,NULL,NULL),(10767,1528,'glucose_mass_relative_mass',10802,10744,'mean',NULL,NULL,NULL,NULL,NULL),(10768,1528,'glucuronic_acid_mass_relative_mass',10803,10744,'mean',NULL,NULL,NULL,NULL,NULL),(10769,1528,'galacturonic_acid_mass_relative_mass',10804,10744,'mean',NULL,NULL,NULL,NULL,NULL),(10770,1528,'holocellulose_mass_relative_mass',10805,10744,'mean',NULL,NULL,NULL,NULL,NULL),(10771,1528,'4_hydroxybenzaldehyde_mass_relative_mass',10806,10744,'mean',NULL,NULL,NULL,NULL,NULL),(10772,1528,'4_hydroxyacetophenone_mass_relative_mass',10807,10744,'mean',NULL,NULL,NULL,NULL,NULL),(10773,1528,'4_hydroxybenzoic_acid_mass_relative_mass',10808,10744,'mean',NULL,NULL,NULL,NULL,NULL),(10774,1528,'vanillin_mass_relative_mass',10809,10744,'mean',NULL,NULL,NULL,NULL,NULL),(10775,1528,'vanillic_acid_mass_relative_mass',10810,10744,'mean',NULL,NULL,NULL,NULL,NULL),(10776,1528,'acetovanillone_mass_relative_mass',10811,10744,'mean',NULL,NULL,NULL,NULL,NULL),(10777,1528,'syringe_aldehyde_mass_relative_mass',10812,10744,'mean',NULL,NULL,NULL,NULL,NULL),(10778,1528,'acetosyringone_mass_relative_mass',10813,10744,'mean',NULL,NULL,NULL,NULL,NULL),(10779,1528,'syringic_acid_mass_relative_mass',10814,10744,'mean',NULL,NULL,NULL,NULL,NULL),(10780,1528,'p_coumaric_acid_mass_relative_mass',10815,10744,'mean',NULL,NULL,NULL,NULL,NULL),(10781,1528,'ferulic_acid_mass_relative_mass',10816,10744,'mean',NULL,NULL,NULL,NULL,NULL),(10782,1528,'Klason_lignin_mass_relative_mass',10817,10744,'mean',NULL,NULL,NULL,NULL,NULL),(10783,1528,'soluble_lignin_mass_relative_mass',10818,10744,'mean',NULL,NULL,NULL,NULL,NULL),(10784,1528,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10785,1528,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10786,1528,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10787,1528,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10788,1528,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10789,1528,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10790,1528,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10791,1528,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10792,1528,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10793,1528,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10794,1528,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10795,1528,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10796,1528,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10797,1528,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10798,1528,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10799,1528,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10800,1528,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10801,1528,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10802,1528,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10803,1528,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10804,1528,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10805,1528,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10806,1528,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10807,1528,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10808,1528,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10809,1528,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10810,1528,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10811,1528,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10812,1528,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10813,1528,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10814,1528,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10815,1528,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10816,1528,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10817,1528,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10818,1528,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10819,1529,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10820,1529,'mass_relative_mass',10819,8194,'mean','se',NULL,0.534013605442177,0.07142857142857138,NULL),(10821,1529,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(10822,1529,'ash_mass_relative_mass',10859,10819,'mean',NULL,NULL,NULL,NULL,NULL),(10823,1529,'N_relative_mass',10860,10819,'mean',NULL,NULL,NULL,NULL,NULL),(10824,1529,'P_relative_mass',10861,10819,'mean',NULL,NULL,NULL,NULL,NULL),(10825,1529,'Ca_relative_mass',10862,10819,'mean',NULL,NULL,NULL,NULL,NULL),(10826,1529,'K_relative_mass',10863,10819,'mean',NULL,NULL,NULL,NULL,NULL),(10827,1529,'Mg_relative_mass',10864,10819,'mean',NULL,NULL,NULL,NULL,NULL),(10828,1529,'Mn_relative_mass',10865,10819,'mean',NULL,NULL,NULL,NULL,NULL),(10829,1529,'C_relative_mass',10866,10819,'mean',NULL,NULL,NULL,NULL,NULL),(10830,1529,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10831,1529,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10832,1529,'dichloromethane_extractives_mass_relative_mass',10867,10819,'mean',NULL,NULL,NULL,NULL,NULL),(10833,1529,'acetone_extractives_mass_relative_mass',10868,10819,'mean',NULL,NULL,NULL,NULL,NULL),(10834,1529,'ethanol_extractives_mass_relative_mass',10869,10819,'mean',NULL,NULL,NULL,NULL,NULL),(10835,1529,'water_extractives_mass_relative_mass',10870,10819,'mean',NULL,NULL,NULL,NULL,NULL),(10836,1529,'cellulose_mass_relative_mass',10871,10819,'mean',NULL,NULL,NULL,NULL,NULL),(10837,1529,'arabinose_mass_relative_mass',10872,10819,'mean',NULL,NULL,NULL,NULL,NULL),(10838,1529,'rhamnose_mass_relative_mass',10873,10819,'mean',NULL,NULL,NULL,NULL,NULL),(10839,1529,'xylose_mass_relative_mass',10874,10819,'mean',NULL,NULL,NULL,NULL,NULL),(10840,1529,'mannose_mass_relative_mass',10875,10819,'mean',NULL,NULL,NULL,NULL,NULL),(10841,1529,'galactose_mass_relative_mass',10876,10819,'mean',NULL,NULL,NULL,NULL,NULL),(10842,1529,'glucose_mass_relative_mass',10877,10819,'mean',NULL,NULL,NULL,NULL,NULL),(10843,1529,'glucuronic_acid_mass_relative_mass',10878,10819,'mean',NULL,NULL,NULL,NULL,NULL),(10844,1529,'galacturonic_acid_mass_relative_mass',10879,10819,'mean',NULL,NULL,NULL,NULL,NULL),(10845,1529,'holocellulose_mass_relative_mass',10880,10819,'mean',NULL,NULL,NULL,NULL,NULL),(10846,1529,'4_hydroxybenzaldehyde_mass_relative_mass',10881,10819,'mean',NULL,NULL,NULL,NULL,NULL),(10847,1529,'4_hydroxyacetophenone_mass_relative_mass',10882,10819,'mean',NULL,NULL,NULL,NULL,NULL),(10848,1529,'4_hydroxybenzoic_acid_mass_relative_mass',10883,10819,'mean',NULL,NULL,NULL,NULL,NULL),(10849,1529,'vanillin_mass_relative_mass',10884,10819,'mean',NULL,NULL,NULL,NULL,NULL),(10850,1529,'vanillic_acid_mass_relative_mass',10885,10819,'mean',NULL,NULL,NULL,NULL,NULL),(10851,1529,'acetovanillone_mass_relative_mass',10886,10819,'mean',NULL,NULL,NULL,NULL,NULL),(10852,1529,'syringe_aldehyde_mass_relative_mass',10887,10819,'mean',NULL,NULL,NULL,NULL,NULL),(10853,1529,'acetosyringone_mass_relative_mass',10888,10819,'mean',NULL,NULL,NULL,NULL,NULL),(10854,1529,'syringic_acid_mass_relative_mass',10889,10819,'mean',NULL,NULL,NULL,NULL,NULL),(10855,1529,'p_coumaric_acid_mass_relative_mass',10890,10819,'mean',NULL,NULL,NULL,NULL,NULL),(10856,1529,'ferulic_acid_mass_relative_mass',10891,10819,'mean',NULL,NULL,NULL,NULL,NULL),(10857,1529,'Klason_lignin_mass_relative_mass',10892,10819,'mean',NULL,NULL,NULL,NULL,NULL),(10858,1529,'soluble_lignin_mass_relative_mass',10893,10819,'mean',NULL,NULL,NULL,NULL,NULL),(10859,1529,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10860,1529,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10861,1529,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10862,1529,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10863,1529,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10864,1529,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10865,1529,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10866,1529,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10867,1529,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10868,1529,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10869,1529,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10870,1529,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10871,1529,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10872,1529,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10873,1529,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10874,1529,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10875,1529,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10876,1529,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10877,1529,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10878,1529,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10879,1529,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10880,1529,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10881,1529,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10882,1529,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10883,1529,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10884,1529,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10885,1529,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10886,1529,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10887,1529,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10888,1529,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10889,1529,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10890,1529,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10891,1529,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10892,1529,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10893,1529,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10894,1530,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10895,1530,'mass_relative_mass',10894,8194,'mean','se',NULL,0.285714285714286,0.08503401360544217,NULL),(10896,1530,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(10897,1530,'ash_mass_relative_mass',10934,10894,'mean',NULL,NULL,NULL,NULL,NULL),(10898,1530,'N_relative_mass',10935,10894,'mean',NULL,NULL,NULL,NULL,NULL),(10899,1530,'P_relative_mass',10936,10894,'mean',NULL,NULL,NULL,NULL,NULL),(10900,1530,'Ca_relative_mass',10937,10894,'mean',NULL,NULL,NULL,NULL,NULL),(10901,1530,'K_relative_mass',10938,10894,'mean',NULL,NULL,NULL,NULL,NULL),(10902,1530,'Mg_relative_mass',10939,10894,'mean',NULL,NULL,NULL,NULL,NULL),(10903,1530,'Mn_relative_mass',10940,10894,'mean',NULL,NULL,NULL,NULL,NULL),(10904,1530,'C_relative_mass',10941,10894,'mean',NULL,NULL,NULL,NULL,NULL),(10905,1530,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10906,1530,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10907,1530,'dichloromethane_extractives_mass_relative_mass',10942,10894,'mean',NULL,NULL,NULL,NULL,NULL),(10908,1530,'acetone_extractives_mass_relative_mass',10943,10894,'mean',NULL,NULL,NULL,NULL,NULL),(10909,1530,'ethanol_extractives_mass_relative_mass',10944,10894,'mean',NULL,NULL,NULL,NULL,NULL),(10910,1530,'water_extractives_mass_relative_mass',10945,10894,'mean',NULL,NULL,NULL,NULL,NULL),(10911,1530,'cellulose_mass_relative_mass',10946,10894,'mean',NULL,NULL,NULL,NULL,NULL),(10912,1530,'arabinose_mass_relative_mass',10947,10894,'mean',NULL,NULL,NULL,NULL,NULL),(10913,1530,'rhamnose_mass_relative_mass',10948,10894,'mean',NULL,NULL,NULL,NULL,NULL),(10914,1530,'xylose_mass_relative_mass',10949,10894,'mean',NULL,NULL,NULL,NULL,NULL),(10915,1530,'mannose_mass_relative_mass',10950,10894,'mean',NULL,NULL,NULL,NULL,NULL),(10916,1530,'galactose_mass_relative_mass',10951,10894,'mean',NULL,NULL,NULL,NULL,NULL),(10917,1530,'glucose_mass_relative_mass',10952,10894,'mean',NULL,NULL,NULL,NULL,NULL),(10918,1530,'glucuronic_acid_mass_relative_mass',10953,10894,'mean',NULL,NULL,NULL,NULL,NULL),(10919,1530,'galacturonic_acid_mass_relative_mass',10954,10894,'mean',NULL,NULL,NULL,NULL,NULL),(10920,1530,'holocellulose_mass_relative_mass',10955,10894,'mean',NULL,NULL,NULL,NULL,NULL),(10921,1530,'4_hydroxybenzaldehyde_mass_relative_mass',10956,10894,'mean',NULL,NULL,NULL,NULL,NULL),(10922,1530,'4_hydroxyacetophenone_mass_relative_mass',10957,10894,'mean',NULL,NULL,NULL,NULL,NULL),(10923,1530,'4_hydroxybenzoic_acid_mass_relative_mass',10958,10894,'mean',NULL,NULL,NULL,NULL,NULL),(10924,1530,'vanillin_mass_relative_mass',10959,10894,'mean',NULL,NULL,NULL,NULL,NULL),(10925,1530,'vanillic_acid_mass_relative_mass',10960,10894,'mean',NULL,NULL,NULL,NULL,NULL),(10926,1530,'acetovanillone_mass_relative_mass',10961,10894,'mean',NULL,NULL,NULL,NULL,NULL),(10927,1530,'syringe_aldehyde_mass_relative_mass',10962,10894,'mean',NULL,NULL,NULL,NULL,NULL),(10928,1530,'acetosyringone_mass_relative_mass',10963,10894,'mean',NULL,NULL,NULL,NULL,NULL),(10929,1530,'syringic_acid_mass_relative_mass',10964,10894,'mean',NULL,NULL,NULL,NULL,NULL),(10930,1530,'p_coumaric_acid_mass_relative_mass',10965,10894,'mean',NULL,NULL,NULL,NULL,NULL),(10931,1530,'ferulic_acid_mass_relative_mass',10966,10894,'mean',NULL,NULL,NULL,NULL,NULL),(10932,1530,'Klason_lignin_mass_relative_mass',10967,10894,'mean',NULL,NULL,NULL,NULL,NULL),(10933,1530,'soluble_lignin_mass_relative_mass',10968,10894,'mean',NULL,NULL,NULL,NULL,NULL),(10934,1530,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10935,1530,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10936,1530,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10937,1530,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10938,1530,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10939,1530,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10940,1530,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10941,1530,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10942,1530,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10943,1530,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10944,1530,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10945,1530,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10946,1530,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10947,1530,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10948,1530,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10949,1530,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10950,1530,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10951,1530,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10952,1530,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10953,1530,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10954,1530,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10955,1530,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10956,1530,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10957,1530,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10958,1530,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10959,1530,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10960,1530,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10961,1530,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10962,1530,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10963,1530,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10964,1530,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10965,1530,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10966,1530,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10967,1530,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10968,1530,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10969,1531,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10970,1531,'mass_relative_mass',10969,8269,'mean','se',NULL,0.7006802721088436,0.06122448979591866,NULL),(10971,1531,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(10972,1531,'ash_mass_relative_mass',11009,10969,'mean',NULL,NULL,NULL,NULL,NULL),(10973,1531,'N_relative_mass',11010,10969,'mean',NULL,NULL,NULL,NULL,NULL),(10974,1531,'P_relative_mass',11011,10969,'mean',NULL,NULL,NULL,NULL,NULL),(10975,1531,'Ca_relative_mass',11012,10969,'mean',NULL,NULL,NULL,NULL,NULL),(10976,1531,'K_relative_mass',11013,10969,'mean',NULL,NULL,NULL,NULL,NULL),(10977,1531,'Mg_relative_mass',11014,10969,'mean',NULL,NULL,NULL,NULL,NULL),(10978,1531,'Mn_relative_mass',11015,10969,'mean',NULL,NULL,NULL,NULL,NULL),(10979,1531,'C_relative_mass',11016,10969,'mean',NULL,NULL,NULL,NULL,NULL),(10980,1531,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10981,1531,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(10982,1531,'dichloromethane_extractives_mass_relative_mass',11017,10969,'mean',NULL,NULL,NULL,NULL,NULL),(10983,1531,'acetone_extractives_mass_relative_mass',11018,10969,'mean',NULL,NULL,NULL,NULL,NULL),(10984,1531,'ethanol_extractives_mass_relative_mass',11019,10969,'mean',NULL,NULL,NULL,NULL,NULL),(10985,1531,'water_extractives_mass_relative_mass',11020,10969,'mean',NULL,NULL,NULL,NULL,NULL),(10986,1531,'cellulose_mass_relative_mass',11021,10969,'mean',NULL,NULL,NULL,NULL,NULL),(10987,1531,'arabinose_mass_relative_mass',11022,10969,'mean',NULL,NULL,NULL,NULL,NULL),(10988,1531,'rhamnose_mass_relative_mass',11023,10969,'mean',NULL,NULL,NULL,NULL,NULL),(10989,1531,'xylose_mass_relative_mass',11024,10969,'mean',NULL,NULL,NULL,NULL,NULL),(10990,1531,'mannose_mass_relative_mass',11025,10969,'mean',NULL,NULL,NULL,NULL,NULL),(10991,1531,'galactose_mass_relative_mass',11026,10969,'mean',NULL,NULL,NULL,NULL,NULL),(10992,1531,'glucose_mass_relative_mass',11027,10969,'mean',NULL,NULL,NULL,NULL,NULL),(10993,1531,'glucuronic_acid_mass_relative_mass',11028,10969,'mean',NULL,NULL,NULL,NULL,NULL),(10994,1531,'galacturonic_acid_mass_relative_mass',11029,10969,'mean',NULL,NULL,NULL,NULL,NULL),(10995,1531,'holocellulose_mass_relative_mass',11030,10969,'mean',NULL,NULL,NULL,NULL,NULL),(10996,1531,'4_hydroxybenzaldehyde_mass_relative_mass',11031,10969,'mean',NULL,NULL,NULL,NULL,NULL),(10997,1531,'4_hydroxyacetophenone_mass_relative_mass',11032,10969,'mean',NULL,NULL,NULL,NULL,NULL),(10998,1531,'4_hydroxybenzoic_acid_mass_relative_mass',11033,10969,'mean',NULL,NULL,NULL,NULL,NULL),(10999,1531,'vanillin_mass_relative_mass',11034,10969,'mean',NULL,NULL,NULL,NULL,NULL),(11000,1531,'vanillic_acid_mass_relative_mass',11035,10969,'mean',NULL,NULL,NULL,NULL,NULL),(11001,1531,'acetovanillone_mass_relative_mass',11036,10969,'mean',NULL,NULL,NULL,NULL,NULL),(11002,1531,'syringe_aldehyde_mass_relative_mass',11037,10969,'mean',NULL,NULL,NULL,NULL,NULL),(11003,1531,'acetosyringone_mass_relative_mass',11038,10969,'mean',NULL,NULL,NULL,NULL,NULL),(11004,1531,'syringic_acid_mass_relative_mass',11039,10969,'mean',NULL,NULL,NULL,NULL,NULL),(11005,1531,'p_coumaric_acid_mass_relative_mass',11040,10969,'mean',NULL,NULL,NULL,NULL,NULL),(11006,1531,'ferulic_acid_mass_relative_mass',11041,10969,'mean',NULL,NULL,NULL,NULL,NULL),(11007,1531,'Klason_lignin_mass_relative_mass',11042,10969,'mean',NULL,NULL,NULL,NULL,NULL),(11008,1531,'soluble_lignin_mass_relative_mass',11043,10969,'mean',NULL,NULL,NULL,NULL,NULL),(11009,1531,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11010,1531,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11011,1531,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11012,1531,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11013,1531,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11014,1531,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11015,1531,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11016,1531,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11017,1531,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11018,1531,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11019,1531,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11020,1531,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11021,1531,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11022,1531,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11023,1531,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11024,1531,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11025,1531,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11026,1531,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11027,1531,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11028,1531,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11029,1531,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11030,1531,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11031,1531,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11032,1531,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11033,1531,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11034,1531,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11035,1531,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11036,1531,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11037,1531,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11038,1531,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11039,1531,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11040,1531,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11041,1531,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11042,1531,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11043,1531,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11044,1532,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11045,1532,'mass_relative_mass',11044,8269,'mean','se',NULL,0.5510204081632655,0.0884353741496598,NULL),(11046,1532,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(11047,1532,'ash_mass_relative_mass',11084,11044,'mean',NULL,NULL,NULL,NULL,NULL),(11048,1532,'N_relative_mass',11085,11044,'mean',NULL,NULL,NULL,NULL,NULL),(11049,1532,'P_relative_mass',11086,11044,'mean',NULL,NULL,NULL,NULL,NULL),(11050,1532,'Ca_relative_mass',11087,11044,'mean',NULL,NULL,NULL,NULL,NULL),(11051,1532,'K_relative_mass',11088,11044,'mean',NULL,NULL,NULL,NULL,NULL),(11052,1532,'Mg_relative_mass',11089,11044,'mean',NULL,NULL,NULL,NULL,NULL),(11053,1532,'Mn_relative_mass',11090,11044,'mean',NULL,NULL,NULL,NULL,NULL),(11054,1532,'C_relative_mass',11091,11044,'mean',NULL,NULL,NULL,NULL,NULL),(11055,1532,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11056,1532,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11057,1532,'dichloromethane_extractives_mass_relative_mass',11092,11044,'mean',NULL,NULL,NULL,NULL,NULL),(11058,1532,'acetone_extractives_mass_relative_mass',11093,11044,'mean',NULL,NULL,NULL,NULL,NULL),(11059,1532,'ethanol_extractives_mass_relative_mass',11094,11044,'mean',NULL,NULL,NULL,NULL,NULL),(11060,1532,'water_extractives_mass_relative_mass',11095,11044,'mean',NULL,NULL,NULL,NULL,NULL),(11061,1532,'cellulose_mass_relative_mass',11096,11044,'mean',NULL,NULL,NULL,NULL,NULL),(11062,1532,'arabinose_mass_relative_mass',11097,11044,'mean',NULL,NULL,NULL,NULL,NULL),(11063,1532,'rhamnose_mass_relative_mass',11098,11044,'mean',NULL,NULL,NULL,NULL,NULL),(11064,1532,'xylose_mass_relative_mass',11099,11044,'mean',NULL,NULL,NULL,NULL,NULL),(11065,1532,'mannose_mass_relative_mass',11100,11044,'mean',NULL,NULL,NULL,NULL,NULL),(11066,1532,'galactose_mass_relative_mass',11101,11044,'mean',NULL,NULL,NULL,NULL,NULL),(11067,1532,'glucose_mass_relative_mass',11102,11044,'mean',NULL,NULL,NULL,NULL,NULL),(11068,1532,'glucuronic_acid_mass_relative_mass',11103,11044,'mean',NULL,NULL,NULL,NULL,NULL),(11069,1532,'galacturonic_acid_mass_relative_mass',11104,11044,'mean',NULL,NULL,NULL,NULL,NULL),(11070,1532,'holocellulose_mass_relative_mass',11105,11044,'mean',NULL,NULL,NULL,NULL,NULL),(11071,1532,'4_hydroxybenzaldehyde_mass_relative_mass',11106,11044,'mean',NULL,NULL,NULL,NULL,NULL),(11072,1532,'4_hydroxyacetophenone_mass_relative_mass',11107,11044,'mean',NULL,NULL,NULL,NULL,NULL),(11073,1532,'4_hydroxybenzoic_acid_mass_relative_mass',11108,11044,'mean',NULL,NULL,NULL,NULL,NULL),(11074,1532,'vanillin_mass_relative_mass',11109,11044,'mean',NULL,NULL,NULL,NULL,NULL),(11075,1532,'vanillic_acid_mass_relative_mass',11110,11044,'mean',NULL,NULL,NULL,NULL,NULL),(11076,1532,'acetovanillone_mass_relative_mass',11111,11044,'mean',NULL,NULL,NULL,NULL,NULL),(11077,1532,'syringe_aldehyde_mass_relative_mass',11112,11044,'mean',NULL,NULL,NULL,NULL,NULL),(11078,1532,'acetosyringone_mass_relative_mass',11113,11044,'mean',NULL,NULL,NULL,NULL,NULL),(11079,1532,'syringic_acid_mass_relative_mass',11114,11044,'mean',NULL,NULL,NULL,NULL,NULL),(11080,1532,'p_coumaric_acid_mass_relative_mass',11115,11044,'mean',NULL,NULL,NULL,NULL,NULL),(11081,1532,'ferulic_acid_mass_relative_mass',11116,11044,'mean',NULL,NULL,NULL,NULL,NULL),(11082,1532,'Klason_lignin_mass_relative_mass',11117,11044,'mean',NULL,NULL,NULL,NULL,NULL),(11083,1532,'soluble_lignin_mass_relative_mass',11118,11044,'mean',NULL,NULL,NULL,NULL,NULL),(11084,1532,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11085,1532,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11086,1532,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11087,1532,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11088,1532,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11089,1532,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11090,1532,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11091,1532,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11092,1532,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11093,1532,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11094,1532,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11095,1532,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11096,1532,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11097,1532,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11098,1532,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11099,1532,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11100,1532,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11101,1532,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11102,1532,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11103,1532,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11104,1532,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11105,1532,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11106,1532,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11107,1532,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11108,1532,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11109,1532,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11110,1532,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11111,1532,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11112,1532,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11113,1532,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11114,1532,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11115,1532,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11116,1532,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11117,1532,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11118,1532,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11119,1533,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11120,1533,'mass_relative_mass',11119,8344,'mean','se',NULL,0.7363896848137537,0.042979942693409615,NULL),(11121,1533,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(11122,1533,'ash_mass_relative_mass',11159,11119,'mean',NULL,NULL,NULL,NULL,NULL),(11123,1533,'N_relative_mass',11160,11119,'mean',NULL,NULL,NULL,NULL,NULL),(11124,1533,'P_relative_mass',11161,11119,'mean',NULL,NULL,NULL,NULL,NULL),(11125,1533,'Ca_relative_mass',11162,11119,'mean',NULL,NULL,NULL,NULL,NULL),(11126,1533,'K_relative_mass',11163,11119,'mean',NULL,NULL,NULL,NULL,NULL),(11127,1533,'Mg_relative_mass',11164,11119,'mean',NULL,NULL,NULL,NULL,NULL),(11128,1533,'Mn_relative_mass',11165,11119,'mean',NULL,NULL,NULL,NULL,NULL),(11129,1533,'C_relative_mass',11166,11119,'mean',NULL,NULL,NULL,NULL,NULL),(11130,1533,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11131,1533,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11132,1533,'dichloromethane_extractives_mass_relative_mass',11167,11119,'mean',NULL,NULL,NULL,NULL,NULL),(11133,1533,'acetone_extractives_mass_relative_mass',11168,11119,'mean',NULL,NULL,NULL,NULL,NULL),(11134,1533,'ethanol_extractives_mass_relative_mass',11169,11119,'mean',NULL,NULL,NULL,NULL,NULL),(11135,1533,'water_extractives_mass_relative_mass',11170,11119,'mean',NULL,NULL,NULL,NULL,NULL),(11136,1533,'cellulose_mass_relative_mass',11171,11119,'mean',NULL,NULL,NULL,NULL,NULL),(11137,1533,'arabinose_mass_relative_mass',11172,11119,'mean',NULL,NULL,NULL,NULL,NULL),(11138,1533,'rhamnose_mass_relative_mass',11173,11119,'mean',NULL,NULL,NULL,NULL,NULL),(11139,1533,'xylose_mass_relative_mass',11174,11119,'mean',NULL,NULL,NULL,NULL,NULL),(11140,1533,'mannose_mass_relative_mass',11175,11119,'mean',NULL,NULL,NULL,NULL,NULL),(11141,1533,'galactose_mass_relative_mass',11176,11119,'mean',NULL,NULL,NULL,NULL,NULL),(11142,1533,'glucose_mass_relative_mass',11177,11119,'mean',NULL,NULL,NULL,NULL,NULL),(11143,1533,'glucuronic_acid_mass_relative_mass',11178,11119,'mean',NULL,NULL,NULL,NULL,NULL),(11144,1533,'galacturonic_acid_mass_relative_mass',11179,11119,'mean',NULL,NULL,NULL,NULL,NULL),(11145,1533,'holocellulose_mass_relative_mass',11180,11119,'mean',NULL,NULL,NULL,NULL,NULL),(11146,1533,'4_hydroxybenzaldehyde_mass_relative_mass',11181,11119,'mean',NULL,NULL,NULL,NULL,NULL),(11147,1533,'4_hydroxyacetophenone_mass_relative_mass',11182,11119,'mean',NULL,NULL,NULL,NULL,NULL),(11148,1533,'4_hydroxybenzoic_acid_mass_relative_mass',11183,11119,'mean',NULL,NULL,NULL,NULL,NULL),(11149,1533,'vanillin_mass_relative_mass',11184,11119,'mean',NULL,NULL,NULL,NULL,NULL),(11150,1533,'vanillic_acid_mass_relative_mass',11185,11119,'mean',NULL,NULL,NULL,NULL,NULL),(11151,1533,'acetovanillone_mass_relative_mass',11186,11119,'mean',NULL,NULL,NULL,NULL,NULL),(11152,1533,'syringe_aldehyde_mass_relative_mass',11187,11119,'mean',NULL,NULL,NULL,NULL,NULL),(11153,1533,'acetosyringone_mass_relative_mass',11188,11119,'mean',NULL,NULL,NULL,NULL,NULL),(11154,1533,'syringic_acid_mass_relative_mass',11189,11119,'mean',NULL,NULL,NULL,NULL,NULL),(11155,1533,'p_coumaric_acid_mass_relative_mass',11190,11119,'mean',NULL,NULL,NULL,NULL,NULL),(11156,1533,'ferulic_acid_mass_relative_mass',11191,11119,'mean',NULL,NULL,NULL,NULL,NULL),(11157,1533,'Klason_lignin_mass_relative_mass',11192,11119,'mean',NULL,NULL,NULL,NULL,NULL),(11158,1533,'soluble_lignin_mass_relative_mass',11193,11119,'mean',NULL,NULL,NULL,NULL,NULL),(11159,1533,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11160,1533,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11161,1533,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11162,1533,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11163,1533,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11164,1533,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11165,1533,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11166,1533,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11167,1533,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11168,1533,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11169,1533,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11170,1533,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11171,1533,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11172,1533,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11173,1533,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11174,1533,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11175,1533,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11176,1533,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11177,1533,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11178,1533,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11179,1533,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11180,1533,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11181,1533,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11182,1533,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11183,1533,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11184,1533,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11185,1533,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11186,1533,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11187,1533,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11188,1533,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11189,1533,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11190,1533,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11191,1533,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11192,1533,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11193,1533,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11194,1534,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11195,1534,'mass_relative_mass',11194,8344,'mean','se',NULL,0.5128939828080231,0.06876790830945538,NULL),(11196,1534,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(11197,1534,'ash_mass_relative_mass',11234,11194,'mean',NULL,NULL,NULL,NULL,NULL),(11198,1534,'N_relative_mass',11235,11194,'mean',NULL,NULL,NULL,NULL,NULL),(11199,1534,'P_relative_mass',11236,11194,'mean',NULL,NULL,NULL,NULL,NULL),(11200,1534,'Ca_relative_mass',11237,11194,'mean',NULL,NULL,NULL,NULL,NULL),(11201,1534,'K_relative_mass',11238,11194,'mean',NULL,NULL,NULL,NULL,NULL),(11202,1534,'Mg_relative_mass',11239,11194,'mean',NULL,NULL,NULL,NULL,NULL),(11203,1534,'Mn_relative_mass',11240,11194,'mean',NULL,NULL,NULL,NULL,NULL),(11204,1534,'C_relative_mass',11241,11194,'mean',NULL,NULL,NULL,NULL,NULL),(11205,1534,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11206,1534,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11207,1534,'dichloromethane_extractives_mass_relative_mass',11242,11194,'mean',NULL,NULL,NULL,NULL,NULL),(11208,1534,'acetone_extractives_mass_relative_mass',11243,11194,'mean',NULL,NULL,NULL,NULL,NULL),(11209,1534,'ethanol_extractives_mass_relative_mass',11244,11194,'mean',NULL,NULL,NULL,NULL,NULL),(11210,1534,'water_extractives_mass_relative_mass',11245,11194,'mean',NULL,NULL,NULL,NULL,NULL),(11211,1534,'cellulose_mass_relative_mass',11246,11194,'mean',NULL,NULL,NULL,NULL,NULL),(11212,1534,'arabinose_mass_relative_mass',11247,11194,'mean',NULL,NULL,NULL,NULL,NULL),(11213,1534,'rhamnose_mass_relative_mass',11248,11194,'mean',NULL,NULL,NULL,NULL,NULL),(11214,1534,'xylose_mass_relative_mass',11249,11194,'mean',NULL,NULL,NULL,NULL,NULL),(11215,1534,'mannose_mass_relative_mass',11250,11194,'mean',NULL,NULL,NULL,NULL,NULL),(11216,1534,'galactose_mass_relative_mass',11251,11194,'mean',NULL,NULL,NULL,NULL,NULL),(11217,1534,'glucose_mass_relative_mass',11252,11194,'mean',NULL,NULL,NULL,NULL,NULL),(11218,1534,'glucuronic_acid_mass_relative_mass',11253,11194,'mean',NULL,NULL,NULL,NULL,NULL),(11219,1534,'galacturonic_acid_mass_relative_mass',11254,11194,'mean',NULL,NULL,NULL,NULL,NULL),(11220,1534,'holocellulose_mass_relative_mass',11255,11194,'mean',NULL,NULL,NULL,NULL,NULL),(11221,1534,'4_hydroxybenzaldehyde_mass_relative_mass',11256,11194,'mean',NULL,NULL,NULL,NULL,NULL),(11222,1534,'4_hydroxyacetophenone_mass_relative_mass',11257,11194,'mean',NULL,NULL,NULL,NULL,NULL),(11223,1534,'4_hydroxybenzoic_acid_mass_relative_mass',11258,11194,'mean',NULL,NULL,NULL,NULL,NULL),(11224,1534,'vanillin_mass_relative_mass',11259,11194,'mean',NULL,NULL,NULL,NULL,NULL),(11225,1534,'vanillic_acid_mass_relative_mass',11260,11194,'mean',NULL,NULL,NULL,NULL,NULL),(11226,1534,'acetovanillone_mass_relative_mass',11261,11194,'mean',NULL,NULL,NULL,NULL,NULL),(11227,1534,'syringe_aldehyde_mass_relative_mass',11262,11194,'mean',NULL,NULL,NULL,NULL,NULL),(11228,1534,'acetosyringone_mass_relative_mass',11263,11194,'mean',NULL,NULL,NULL,NULL,NULL),(11229,1534,'syringic_acid_mass_relative_mass',11264,11194,'mean',NULL,NULL,NULL,NULL,NULL),(11230,1534,'p_coumaric_acid_mass_relative_mass',11265,11194,'mean',NULL,NULL,NULL,NULL,NULL),(11231,1534,'ferulic_acid_mass_relative_mass',11266,11194,'mean',NULL,NULL,NULL,NULL,NULL),(11232,1534,'Klason_lignin_mass_relative_mass',11267,11194,'mean',NULL,NULL,NULL,NULL,NULL),(11233,1534,'soluble_lignin_mass_relative_mass',11268,11194,'mean',NULL,NULL,NULL,NULL,NULL),(11234,1534,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11235,1534,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11236,1534,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11237,1534,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11238,1534,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11239,1534,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11240,1534,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11241,1534,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11242,1534,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11243,1534,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11244,1534,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11245,1534,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11246,1534,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11247,1534,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11248,1534,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11249,1534,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11250,1534,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11251,1534,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11252,1534,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11253,1534,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11254,1534,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11255,1534,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11256,1534,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11257,1534,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11258,1534,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11259,1534,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11260,1534,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11261,1534,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11262,1534,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11263,1534,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11264,1534,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11265,1534,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11266,1534,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11267,1534,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11268,1534,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11269,1535,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11270,1535,'mass_relative_mass',11269,8419,'mean','se',NULL,0.8538681948424071,0.07449856733524371,NULL),(11271,1535,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(11272,1535,'ash_mass_relative_mass',11309,11269,'mean',NULL,NULL,NULL,NULL,NULL),(11273,1535,'N_relative_mass',11310,11269,'mean',NULL,NULL,NULL,NULL,NULL),(11274,1535,'P_relative_mass',11311,11269,'mean',NULL,NULL,NULL,NULL,NULL),(11275,1535,'Ca_relative_mass',11312,11269,'mean',NULL,NULL,NULL,NULL,NULL),(11276,1535,'K_relative_mass',11313,11269,'mean',NULL,NULL,NULL,NULL,NULL),(11277,1535,'Mg_relative_mass',11314,11269,'mean',NULL,NULL,NULL,NULL,NULL),(11278,1535,'Mn_relative_mass',11315,11269,'mean',NULL,NULL,NULL,NULL,NULL),(11279,1535,'C_relative_mass',11316,11269,'mean',NULL,NULL,NULL,NULL,NULL),(11280,1535,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11281,1535,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11282,1535,'dichloromethane_extractives_mass_relative_mass',11317,11269,'mean',NULL,NULL,NULL,NULL,NULL),(11283,1535,'acetone_extractives_mass_relative_mass',11318,11269,'mean',NULL,NULL,NULL,NULL,NULL),(11284,1535,'ethanol_extractives_mass_relative_mass',11319,11269,'mean',NULL,NULL,NULL,NULL,NULL),(11285,1535,'water_extractives_mass_relative_mass',11320,11269,'mean',NULL,NULL,NULL,NULL,NULL),(11286,1535,'cellulose_mass_relative_mass',11321,11269,'mean',NULL,NULL,NULL,NULL,NULL),(11287,1535,'arabinose_mass_relative_mass',11322,11269,'mean',NULL,NULL,NULL,NULL,NULL),(11288,1535,'rhamnose_mass_relative_mass',11323,11269,'mean',NULL,NULL,NULL,NULL,NULL),(11289,1535,'xylose_mass_relative_mass',11324,11269,'mean',NULL,NULL,NULL,NULL,NULL),(11290,1535,'mannose_mass_relative_mass',11325,11269,'mean',NULL,NULL,NULL,NULL,NULL),(11291,1535,'galactose_mass_relative_mass',11326,11269,'mean',NULL,NULL,NULL,NULL,NULL),(11292,1535,'glucose_mass_relative_mass',11327,11269,'mean',NULL,NULL,NULL,NULL,NULL),(11293,1535,'glucuronic_acid_mass_relative_mass',11328,11269,'mean',NULL,NULL,NULL,NULL,NULL),(11294,1535,'galacturonic_acid_mass_relative_mass',11329,11269,'mean',NULL,NULL,NULL,NULL,NULL),(11295,1535,'holocellulose_mass_relative_mass',11330,11269,'mean',NULL,NULL,NULL,NULL,NULL),(11296,1535,'4_hydroxybenzaldehyde_mass_relative_mass',11331,11269,'mean',NULL,NULL,NULL,NULL,NULL),(11297,1535,'4_hydroxyacetophenone_mass_relative_mass',11332,11269,'mean',NULL,NULL,NULL,NULL,NULL),(11298,1535,'4_hydroxybenzoic_acid_mass_relative_mass',11333,11269,'mean',NULL,NULL,NULL,NULL,NULL),(11299,1535,'vanillin_mass_relative_mass',11334,11269,'mean',NULL,NULL,NULL,NULL,NULL),(11300,1535,'vanillic_acid_mass_relative_mass',11335,11269,'mean',NULL,NULL,NULL,NULL,NULL),(11301,1535,'acetovanillone_mass_relative_mass',11336,11269,'mean',NULL,NULL,NULL,NULL,NULL),(11302,1535,'syringe_aldehyde_mass_relative_mass',11337,11269,'mean',NULL,NULL,NULL,NULL,NULL),(11303,1535,'acetosyringone_mass_relative_mass',11338,11269,'mean',NULL,NULL,NULL,NULL,NULL),(11304,1535,'syringic_acid_mass_relative_mass',11339,11269,'mean',NULL,NULL,NULL,NULL,NULL),(11305,1535,'p_coumaric_acid_mass_relative_mass',11340,11269,'mean',NULL,NULL,NULL,NULL,NULL),(11306,1535,'ferulic_acid_mass_relative_mass',11341,11269,'mean',NULL,NULL,NULL,NULL,NULL),(11307,1535,'Klason_lignin_mass_relative_mass',11342,11269,'mean',NULL,NULL,NULL,NULL,NULL),(11308,1535,'soluble_lignin_mass_relative_mass',11343,11269,'mean',NULL,NULL,NULL,NULL,NULL),(11309,1535,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11310,1535,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11311,1535,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11312,1535,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11313,1535,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11314,1535,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11315,1535,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11316,1535,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11317,1535,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11318,1535,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11319,1535,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11320,1535,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11321,1535,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11322,1535,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11323,1535,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11324,1535,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11325,1535,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11326,1535,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11327,1535,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11328,1535,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11329,1535,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11330,1535,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11331,1535,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11332,1535,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11333,1535,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11334,1535,'vanillin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11335,1535,'vanillic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11336,1535,'acetovanillone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11337,1535,'syringe_aldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11338,1535,'acetosyringone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11339,1535,'syringic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11340,1535,'p_coumaric_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11341,1535,'ferulic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11342,1535,'Klason_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11343,1535,'soluble_lignin_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11344,1536,'mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11345,1536,'mass_relative_mass',11344,8419,'mean','se',NULL,0.6332378223495703,0.06303724928366769,NULL),(11346,1536,'mesh_size_absolute',NULL,NULL,'point',NULL,NULL,1,NULL,NULL),(11347,1536,'ash_mass_relative_mass',11384,11344,'mean',NULL,NULL,NULL,NULL,NULL),(11348,1536,'N_relative_mass',11385,11344,'mean',NULL,NULL,NULL,NULL,NULL),(11349,1536,'P_relative_mass',11386,11344,'mean',NULL,NULL,NULL,NULL,NULL),(11350,1536,'Ca_relative_mass',11387,11344,'mean',NULL,NULL,NULL,NULL,NULL),(11351,1536,'K_relative_mass',11388,11344,'mean',NULL,NULL,NULL,NULL,NULL),(11352,1536,'Mg_relative_mass',11389,11344,'mean',NULL,NULL,NULL,NULL,NULL),(11353,1536,'Mn_relative_mass',11390,11344,'mean',NULL,NULL,NULL,NULL,NULL),(11354,1536,'C_relative_mass',11391,11344,'mean',NULL,NULL,NULL,NULL,NULL),(11355,1536,'C_to_N',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11356,1536,'C_to_P',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11357,1536,'dichloromethane_extractives_mass_relative_mass',11392,11344,'mean',NULL,NULL,NULL,NULL,NULL),(11358,1536,'acetone_extractives_mass_relative_mass',11393,11344,'mean',NULL,NULL,NULL,NULL,NULL),(11359,1536,'ethanol_extractives_mass_relative_mass',11394,11344,'mean',NULL,NULL,NULL,NULL,NULL),(11360,1536,'water_extractives_mass_relative_mass',11395,11344,'mean',NULL,NULL,NULL,NULL,NULL),(11361,1536,'cellulose_mass_relative_mass',11396,11344,'mean',NULL,NULL,NULL,NULL,NULL),(11362,1536,'arabinose_mass_relative_mass',11397,11344,'mean',NULL,NULL,NULL,NULL,NULL),(11363,1536,'rhamnose_mass_relative_mass',11398,11344,'mean',NULL,NULL,NULL,NULL,NULL),(11364,1536,'xylose_mass_relative_mass',11399,11344,'mean',NULL,NULL,NULL,NULL,NULL),(11365,1536,'mannose_mass_relative_mass',11400,11344,'mean',NULL,NULL,NULL,NULL,NULL),(11366,1536,'galactose_mass_relative_mass',11401,11344,'mean',NULL,NULL,NULL,NULL,NULL),(11367,1536,'glucose_mass_relative_mass',11402,11344,'mean',NULL,NULL,NULL,NULL,NULL),(11368,1536,'glucuronic_acid_mass_relative_mass',11403,11344,'mean',NULL,NULL,NULL,NULL,NULL),(11369,1536,'galacturonic_acid_mass_relative_mass',11404,11344,'mean',NULL,NULL,NULL,NULL,NULL),(11370,1536,'holocellulose_mass_relative_mass',11405,11344,'mean',NULL,NULL,NULL,NULL,NULL),(11371,1536,'4_hydroxybenzaldehyde_mass_relative_mass',11406,11344,'mean',NULL,NULL,NULL,NULL,NULL),(11372,1536,'4_hydroxyacetophenone_mass_relative_mass',11407,11344,'mean',NULL,NULL,NULL,NULL,NULL),(11373,1536,'4_hydroxybenzoic_acid_mass_relative_mass',11408,11344,'mean',NULL,NULL,NULL,NULL,NULL),(11374,1536,'vanillin_mass_relative_mass',11409,11344,'mean',NULL,NULL,NULL,NULL,NULL),(11375,1536,'vanillic_acid_mass_relative_mass',11410,11344,'mean',NULL,NULL,NULL,NULL,NULL),(11376,1536,'acetovanillone_mass_relative_mass',11411,11344,'mean',NULL,NULL,NULL,NULL,NULL),(11377,1536,'syringe_aldehyde_mass_relative_mass',11412,11344,'mean',NULL,NULL,NULL,NULL,NULL),(11378,1536,'acetosyringone_mass_relative_mass',11413,11344,'mean',NULL,NULL,NULL,NULL,NULL),(11379,1536,'syringic_acid_mass_relative_mass',11414,11344,'mean',NULL,NULL,NULL,NULL,NULL),(11380,1536,'p_coumaric_acid_mass_relative_mass',11415,11344,'mean',NULL,NULL,NULL,NULL,NULL),(11381,1536,'ferulic_acid_mass_relative_mass',11416,11344,'mean',NULL,NULL,NULL,NULL,NULL),(11382,1536,'Klason_lignin_mass_relative_mass',11417,11344,'mean',NULL,NULL,NULL,NULL,NULL),(11383,1536,'soluble_lignin_mass_relative_mass',11418,11344,'mean',NULL,NULL,NULL,NULL,NULL),(11384,1536,'ash_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11385,1536,'N_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11386,1536,'P_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11387,1536,'Ca_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11388,1536,'K_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11389,1536,'Mg_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11390,1536,'Mn_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11391,1536,'C_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11392,1536,'dichloromethane_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11393,1536,'acetone_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11394,1536,'ethanol_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11395,1536,'water_extractives_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11396,1536,'cellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11397,1536,'arabinose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11398,1536,'rhamnose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11399,1536,'xylose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11400,1536,'mannose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11401,1536,'galactose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11402,1536,'glucose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11403,1536,'glucuronic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11404,1536,'galacturonic_acid_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11405,1536,'holocellulose_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11406,1536,'4_hydroxybenzaldehyde_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11407,1536,'4_hydroxyacetophenone_mass_absolute',NULL,NULL,'mean',NULL,NULL,NULL,NULL,NULL),(11408,1536,'4_hydroxybenzoic_acid_mass_absolute',NULL,NULL,'mean',