## Manuscript "Trends in global biodiversity scenarios" - February 2025
## Aschi et al. 
## Supporting code for creation of figure 5 and table 2

#Load packages
library(readxl)
library(dplyr)
library(ggplot2)
library(tidyr)
library(openxlsx)
library(Hmisc)


##### BDI - Aboundance

aboundance <-read.csv("BDIs_projections/Figure5/Abundance/Aboundance_pivotlonger.csv")

#check number of papers 
count_id<- unique(aboundance$Record_id)

#check number of papers plotted per class
aboundance %>% 
  filter(!aboundance$Record_id=="9999") %>%
  group_by(Class) %>%
  count(Record_id) %>%
  count(Class)

# create median and percentile 
stats_abundance <- aboundance %>%
  group_by(Year, Class) %>%
  summarise(
    median = median(ind_value, na.rm = TRUE),
    p16 = quantile(ind_value, 0.16, na.rm = TRUE),
    p84 = quantile(ind_value, 0.84, na.rm = TRUE),
    .groups = "drop"
  )

#plot
ggplot(stats_abundance, aes(x = Year, color = Class, fill = Class)) +
  geom_ribbon(aes(ymin = p16, ymax = p84), alpha = 0.3, color = NA ) +
  geom_line(aes(y = median), size = 1.2) +
  labs(title = "BDIs Abundance",
       subtitle = "[papers=11]",
       x = "year",
       y = "BDIs change compared to base year 2015") +
  scale_color_manual(values = c("Baseline" = "goldenrod1","Worst Case" = "#D55E00", "BtC" = "lightseagreen",
                                "Reduce Loss" = "darkblue", "Net Zero Loss" = "darkorchid"))+
  theme(
    plot.title = element_text(face = "bold", size = 16),
    plot.subtitle = element_text(size = 12, color = "gray"),
    axis.title = element_text(face = "bold", size = 14),
    axis.text = element_text(size = 12),
    legend.title = element_text(face = "bold", size = 12),
    legend.text = element_text(size = 10)
  )
#------------------------------------------------------------------------------

##### BDI - Diversity (richness and eveness)

#Import csv with new "Class" column (BtC / Net zero/ reduce/ project / worst)
diversity <-read.csv("BDIs_projections/Figure5/Diversity/diversity_pivotlonger.csv") # after talking to D. - for now the best one

#check number of papers
count_id<- unique(diversity$Record_id)

#check number of papers plotted per class
diversity %>% 
  filter(!diversity$Record_id=="9999") %>%
  group_by(Class) %>%
  count(Record_id) %>%
  count(Class)


# create median and percentile 
stats_diversity <- diversity %>%
  group_by(Year, Class) %>%
  summarise(
    median = median(ind_value, na.rm = TRUE),
    p16 = quantile(ind_value, 0.16, na.rm = TRUE),
    p84 = quantile(ind_value, 0.84, na.rm = TRUE),
    .groups = "drop"
  )

#plot
ggplot(stats_diversity, aes(x = Year, color = Class, fill = Class)) +
  geom_ribbon(aes(ymin = p16, ymax = p84), alpha = 0.3, color = NA) +
  geom_line(aes(y = median), size = 1.2) +
  labs(title = "BDIs Sp. Diversity",
       subtitle = "[papers=5]",
       x = "year",
       y = "BDIs change compared to base year 2015") +
  scale_color_manual(values = c("Baseline" = "goldenrod1","Worst Case" = "#D55E00", "BtC" = "lightseagreen",
                                "Reduce Loss" = "darkblue", "Net Zero Loss" = "darkorchid"))

theme(
  plot.title = element_text(face = "bold", size = 16),
  plot.subtitle = element_text(size = 12, color = "gray"),
  axis.title = element_text(face = "bold", size = 14),
  axis.text = element_text(size = 12),
  legend.title = element_text(face = "bold", size = 12),
  legend.text = element_text(size = 10)
)

#------------------------------------------------------------------------------
### BDI - Species Distribution

#Import csv with new "Class" columa (BtC / Net zero/ reduce / worst)
sp_distribution <-read.csv("BDIs_projections/Figure5/Species Distribution/speciesdistribution_pivotlonger.csv") 

#check number of papers
count_id<- unique(sp_distribution$Record_id)

#check number of papers plotted per class
sp_distribution %>% 
  filter(!sp_distribution$Record_id=="9999") %>%
  group_by(Class) %>%
  count(Record_id) %>%
  count(Class)


# create median and percentile 
stats_distribution <- sp_distribution %>%
  group_by(Year, Class) %>%
  summarise(
    median = median(ind_value, na.rm = TRUE),
    p16 = quantile(ind_value, 0.16, na.rm = TRUE),
    p84 = quantile(ind_value, 0.84, na.rm = TRUE),
    .groups = "drop"
  )

#plot
ggplot(stats_distribution, aes(x = Year, color = Class, fill = Class)) +
  geom_ribbon(aes(ymin = p16, ymax = p84), alpha = 0.3, color = NA) +
  geom_line(aes(y = median), size = 1.2) +
  labs(title = "BDIs - Sp. Distirbution",
       subtitle = ,
       x = "year",
       y = "BDIs change compared to base year 2015") +
  scale_color_manual(values = c("Baseline" = "goldenrod1","Worst Case" = "#D55E00", "BtC" = "lightseagreen",
                                "Reduce Loss" = "darkblue", "Net Zero Loss" = "darkorchid"))

theme(
  plot.title = element_text(face = "bold", size = 16),
  plot.subtitle = element_text(size = 12, color = "gray"),
  axis.title = element_text(face = "bold", size = 14),
  axis.text = element_text(size = 12),
  legend.title = element_text(face = "bold", size = 12),
  legend.text = element_text(size = 10)
)
#------------------------------------------------------------------------------
### BDI - Extintions

#Import csv with new "Class" columa (BtC / Net zero / reduce/ worst)
exctinct <-read.csv("BDIs_projections/Figure5/Risk of Extinction/exctinction_pivotlonger.csv") 
       
#check number of papers
unique(exctinct$Record_id)

#check number of papers plotted per class
exctinct %>% 
  filter(!exctinct$Record_id=="9999") %>%
  group_by(Class) %>%
  count(Record_id) %>%
  count(Class)


# create median and percentile 
stats_exctinct <- exctinct %>%
  group_by(Year, Class) %>%
  summarise(
    median = median(ind_value, na.rm = TRUE),
    p16 = quantile(ind_value, 0.16, na.rm = TRUE),
    p84 = quantile(ind_value, 0.84, na.rm = TRUE),
    .groups = "drop"
  )

#plot
ggplot(stats_exctinct, aes(x = Year, color = Class, fill = Class)) +
  geom_ribbon(aes(ymin = p16, ymax = p84), alpha = 0.3, color = NA) +
  geom_line(aes(y = median), size = 1.2) +
  labs(title = "BDIs Extinction Risk",
       subtitle = "[papers=11]",
       x = "year",
       y = "BDIs change compared to base year 2015") +
  scale_color_manual(values = c("Baseline" = "goldenrod1","Worst Case" = "#D55E00", "BtC" = "lightseagreen",
                                "Reduce Loss" = "darkblue", "Net Zero Loss" = "darkorchid"))

theme(
  plot.title = element_text(face = "bold", size = 16),
  plot.subtitle = element_text(size = 12, color = "gray"),
  axis.title = element_text(face = "bold", size = 14),
  axis.text = element_text(size = 12),
  legend.title = element_text(face = "bold", size = 12),
  legend.text = element_text(size = 10)
))
#------------------------------------------------------------------------------
### BDI - Habitat Transformartion 

#Import csv with new "Class" columa (BtC / Net zero/ reduce / worst)
habitat_transf <-read.csv("BDIs_projections/Figure5/Habitat Transformation/habtrans_pivotlonger.csv") 

#check number of papers
unique(habitat_transf$Record_id)

#check number of papers plotted per class
habitat_transf %>% 
  filter(!habitat_transf$Record_id=="9999") %>%
  group_by(Class) %>%
  count(Record_id) %>%
  count(Class)


# create median and percentile 
stats_habitat_transf <- habitat_transf %>%
  group_by(Year, Class) %>%
  summarise(
    median = median(ind_value, na.rm = TRUE),
    p16 = quantile(ind_value, 0.16, na.rm = TRUE),
    p84 = quantile(ind_value, 0.84, na.rm = TRUE),
    .groups = "drop"
  )

#plot
ggplot(stats_habitat_transf, aes(x = Year, color = Class, fill = Class)) +
  geom_ribbon(aes(ymin = p16, ymax = p84), alpha = 0.3, color = NA) +
  geom_line(aes(y = median), size = 1.2) +
  labs(title = "BDIs Habitat Transformation",
       subtitle = ,
       x = "year",
       y = "BDIs change compared to base year 2015") +
  scale_color_manual(values = c("Baseline" = "goldenrod1","Worst Case" = "#D55E00", "BtC" = "lightseagreen",
                                "Reduce Loss" = "darkblue", "Net Zero Loss" = "darkorchid"))

theme(
  plot.title = element_text(face = "bold", size = 16),
  plot.subtitle = element_text(size = 12, color = "gray"),
  axis.title = element_text(face = "bold", size = 14),
  axis.text = element_text(size = 12),
  legend.title = element_text(face = "bold", size = 12),
  legend.text = element_text(size = 10)
))


