This artifact contains the implementation of SeBS-Flow, data, and analysis scripts. We provide the following components:

* sebs-flow-artifact: Benchmarking results obtained for the paper together with Python plotting and analysis scripts used for data analysis. See separate README. 
* sebs-flow-implementation: We provide the implementation of SeBS-Flow integrated within the serverless benchmarking suite SeBS. To setup SeBS, please refer to information given in the original README inside the implementation folder. Our workflow benchmarks are provided in the benchmarks folder (`benchmarks/600.workflows`). Please refer to `docs/workflows.md` regarding the required setup for workflow execution. 

We obtained the results presented in the paper using the `perf-cost` experiment. To execute the experiment, set the desired properties in the config json and execute the following command: 

```
./sebs.py experiment invoke perf-cost --config {path/to/config.json} --workflow True --output-dir {path/to/output-dir} --verbose
```

We provide the configurations used for execution of the benchmarks as in the paper for each platform as part of the artifact (`sebs-flow-artifact/benchmark-configs`). 

To execute the selfish-detour benchmark:
1. execute `bash package.sh` and copy the resulting file `selfish-detour.so` in the `benchmarks/wrappers/{platform}/python` folder. 
2. Modify `config/system.json` by adding `selfish-detour.so` to the `{platform} - languages - python - deployment - files` list. 
