#!/bin/sh -f
#SBATCH -N 3
#SBATCH -p RM
#SBATCH --time=6-00:00:00
#SBATCH --ntasks-per-node=128
#SBATCH --mail-type=END,FAIL
#SBATCH --mail-user=mcmic@uw.edu
#SBATCH --job-name=S12_CGILS

# type 'man sbatch' for more information and options
# this job will ask for 1 full RM node (128 cores) for 5 hours
# this job would potentially charge 640 RM SUs

#echo commands to stdout
set -x

scriptdir=/ocean/projects/ees210020p/lmcmicha/S12_CGILS_72722
case=S12_CTLmod
subcase=lc
jobfile=$case/mcmic_SAM.sh
logfile=log_$case$subcase
prmfile=$case/prm.$subcase
prmloc=$case/prm
SAMname=./SAM_ADV_UM5_SGS_TKE_RAD_RRTM4PBL_MICRO_M2005_PA

# Change to correct directory
\cd $scriptdir
\cp $case/CaseName ./
\cp $prmfile $prmloc

if [ ! -e $SAMname ]
    then
    echo Could not find $SAMname
    echo Executable does not exist
    exit 9
fi

# load modules for intel setup
module purge
module load allocations intel/20.4 hdf5/1.12.0-intel20.4 openmpi/4.0.2-intel20.4

time mpiexec $SAMname >> $logfile

exitstatus=$?
echo SAM stopped with exit status $exitstatus

cat timing.0 >> $logfile

#### Check to see if model is ready for a restart

str1=`fgrep TRUE ReadyForRestart`

if [ "$str1" == "TRUE" ]
    then
    echo It appears the previous run ended properly and job not yet finished.                         
    echo Resubmitting $jobfile                                                                        
    cat $prmfile | sed s/nrestart.\*=.\*0/nrestart\ =\ 1/ > temp.namelist
    \mv temp.namelist $prmfile
    cat $prmfile | sed s/nrestart.\*=.\*2/nrestart\ =\ 1/ > temp.namelist
    \mv temp.namelist $prmfile
    \cp $prmfile $prmloc

    whoami

    # Bridges2 -- no ssh                                                                              
    sleep 15
    cd $scriptdir; sbatch $jobfile

    # Remove the file that permits restarts to be submitted                                           
    rm -f ReadyForRestart

else
   echo "No restart required (or desired if the run failed)"                                          
fi

exit 0
