/*
 * MicroHH
 * Copyright (c) 2011-2024 Chiel van Heerwaarden
 * Copyright (c) 2011-2024 Thijs Heus
 * Copyright (c) 2014-2024 Bart van Stratum
 *
 * This file is part of MicroHH
 *
 * MicroHH is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * MicroHH is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with MicroHH.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef BUDGET_DISABLED_H
#define BUDGET_DISABLED_H

#include "budget.h"

/**
 * Derived class for disabled budget statistics
 */
template<typename TF>
class Budget_disabled : public Budget<TF>
{
    public:
        Budget_disabled(
                Master&, Grid<TF>&, Fields<TF>&,
                Thermo<TF>&, Diff<TF>&, Advec<TF>&, Force<TF>&, Input&);
        ~Budget_disabled();

        void init();
        void create(Stats<TF>&);
        void exec_stats(Stats<TF>&);
};
#endif
