# Overview of cases

## Dynamical core validation
* `conservation`: Random noise advection for checking mass, momentum, and energy conservation.
* `taylorgreen`: Convergence test for spatial discretizations in Taylor-Green vortex.

## Atmospheric LES
* `andren1994`: LES of neutral boundary layer (Andren et al. 1994).
* `arm`: Shallow cumulus over land (Brown et al., 2002).
* `bomex`: BOMEX trade wind cumulus case (Siebesma et al., 2003).
* `drycblles`: Dry convective boundary layer growing against linear stratification.
* `dycoms`: DYCOMS stratocumulus case.
* `eady`: Eady's baroclinic instability on an f-plane.
* `gabls1`: GABLS1 LES intercomparison (Beare et al. 2006).
* `gabls4s3`: GABLS4 LES intercomparison (Couvreux et al. 2020).
* `lasso`: LASSO cases, based on ARM observations 2015.
* `rcemip`: RCEMIP radiative convective equilibrium case (Wing et al., 2018).
* `rico`: RICO precipitating cumulus case (van Zanten et al., 2013).
* `sullivan2011`: Dry convective boundary layer following Sullivan and Patton (2011).

## DNS
* `ekman`: Ekman spiral with constant viscosity.
* `moser180`: Turbulent channel flow at Re_tau = 180 (Moser et al., 1999).
* `moser590`: Turbulent channel flow at Re_tau = 590 (Moser et al., 1999).
* `taylorgreen`: Taylor-Greene vortex case to test spatial accuracy of schemes.
* `vanHeerwaarden2016`: Dry convective boundary layer over surface with constant temperature (van Heerwaarden and Mellado, 2016).
