clear; close all;

%% Load data files

STRAIN = 'Yeast1'; % Yeast1; Yeast2; Yeast3; Yeast4; Yeast5
delimiterIn = " ";
data = importdata(fullfile(pwd,STRAIN,['DATA_2GLX_CALIBRATION_TEMP.xlsx']),delimiterIn);

load_data

%% Define STRAIN and paths


inputs.pathd.results_folder='DTWine_Final_codes';
inputs.pathd.short_name=STRAIN;
inputs.pathd.runident=['test_run1'];


%% ODE model
inputs.model.n_st=13;
inputs.model.st_names=char('X','YAN','Glucose','Fructose','Ethanol','CO2','Glycerol',...
    'Acetate','Succinate','gene','IsoamylAlcohol','Isobutanol','PhenEtoh');

inputs.model.n_stimulus=3;
inputs.model.stimulus_names=char('TEMPERATURE','tadd','DAP');

PAR_DATA=importdata(fullfile(pwd,STRAIN,'parsmodel_2GLX_TEMP_GENERALIZATION_gene.csv'),',');
inputs.model.par_names=char({PAR_DATA.textdata{2:end,1}}');
isOpt=PAR_DATA.data(:,end);
inputs.model.par=PAR_DATA.data(:,1)';
inputs.model.n_par=length(inputs.model.par);


%% Parameter estimation GLOBAL UNKNOWNS (SAME VALUES FOR DIFFERENT EXPERIMENTS)
inputs.PEsol.id_global_theta=inputs.model.par_names(find(isOpt),:);
inputs.PEsol.global_theta_guess=PAR_DATA.data(find(isOpt),1)';
inputs.PEsol.global_theta_max=PAR_DATA.data(find(isOpt),3)';
inputs.PEsol.global_theta_min=PAR_DATA.data(find(isOpt),2)';

 
% Open bounds sugars 

% inputs.PEsol.global_theta_max(1:end)=inputs.PEsol.global_theta_guess(1:end)+0.5.*abs(inputs.PEsol.global_theta_guess(1:end));
% inputs.PEsol.global_theta_min(1:end)=inputs.PEsol.global_theta_guess(1:end)-0.5.*abs(inputs.PEsol.global_theta_guess(1:end));



%% Model
 
load_model_equations = fullfile(pwd,STRAIN,'ModelEquations_TEMP_gene.m');
run(load_model_equations);

%% Error model 
inputs.exps.data_type='real';
inputs.exps.noise_type='homo';
inputs.PEsol.PEcost_type='lsq'; %'llk';
inputs.PEsol.lsq_type='Q_expmax';
inputs.model.input_model_type='charmodelC';
inputs.model.names_type='custom'; 

%% SOLVER SETTINGS

inputs.nlpsol.nlpsolver='ess';                        % [] NLP solver: 
%                                                       % LOCAL: 'local_fmincon'|'local_n2fb'|'local_dn2fb'|'local_dhc'|
%                                                       %        'local_ipopt'|'local_solnp'|'local_nomad'||'local_nl2sol'
%                                                       %        'local_lsqnonlin'
%                                                       % MULTISTART:'multi_fmincon'|'multi_n2fb'|'multi_dn2fb'|'multi_dhc'|
%                                                       %            'multi_ipopt'|'multi_solnp'|'multi_nomad'|'multi_nl2sol'
%                                                       %            'multi_lsqnonlin'
%                                                       % GLOBAL: 'de'|'sres'
%                                                       % HYBRID: 'hyb_de_fmincon'|'hyb_de_n2fb'|'hyb_de_dn2fb'|'hyb_de_dhc'|'hyp_de_ipopt'|
%                                                       %         'hyb_de_solnp'|'hyb_de_nomad'|
%                                                       %         'hyb_sres_fmincon'|'hyb_sres_n2fb'|'hyb_sres_dn2fb'|'hyb_sres_dhc'|
%                                                       %         'hyp_sres_ipopt'|'hyb_sres_solnp'|'hyb_sres_nomad'
%                                                       % METAHEURISTICS:
%                                                       % 'ess' or 'eSS' (default)
%                                                       % Note that the corresponding defaults are in files: 
%                                                       % OPT_solvers\DE\de_options.m; OPT_solvers\SRES\sres_options.m; 
%                                                       % OPT_solvers\eSS_**\ess_options.m
%                                                       
inputs.nlpsol.eSS.log_var = [1:length(inputs.PEsol.global_theta_guess(1:end-18))]; %+length(inputs.PEsol.local_theta_guess(1:end))
inputs.nlpsol.eSS.maxeval = 150000;
inputs.nlpsol.eSS.maxtime =5*60;
inputs.nlpsol.eSS.local.solver = 'nl2sol';
inputs.nlpsol.eSS.local.finish = 'fminsearch';
% inputs.nlpsol.DE.itermax=100;


inputs.nlpsol.multi_starts=200; 
inputs.nlpsol.multistart.maxtime=5*60;

%% ODE settings
inputs.ivpsol.ivpsolver='cvodes';
inputs.ivpsol.senssolver='cvodes';
inputs.ivpsol.rtol=1.0D-7;
inputs.ivpsol.atol=1.0D-7;
inputs.ivpsol.ivp_maxnumsteps=1e4;

%% PLOT settings

inputs.plotd.n_t_plot=300;                           % [] Number of times to be used for observables and states plots

for iexp=1:inputs.exps.n_exp

bio_0 = inputs.exps.exp_data{iexp}(1,1);
init_sugar{1}=105; init_sugar{2}=125;

if strfind(exps_name{iexp},'250')
    IS=125;
else
    IS=105;
    
end


Y_0{iexp} = [bio_0 ...
             0.178 ... %+YAN{iexp}(1)*0 ...
             IS ... %105 g/L Glx ----> MS=210g/L inputs.exps.exp_data{iexp}(1,4)
             IS ... %105 g/L F ----> MS=210g/L inputs.exps.exp_data{iexp}(1,5)
             0 ... %inputs.exps.exp_data{iexp}(1,7).*0 ...
             0 ... %CO2 values inputs.exps.exp_data{iexp}(1,48).*0 ... 
             0 ... %inputs.exps.exp_data{iexp}(1,11).*0 ...
             0 ... %inputs.exps.exp_data{iexp}(1,8).*0 ...
             0 ... %inputs.exps.exp_data{iexp}(1,16).*0 ...
             0 ...
             0 ...
             0 ...
             0];


   inputs.exps.n_obs{iexp}=11;                          
   inputs.exps.obs_names{iexp}=char('YAN_o','Glucose_o',...
    'Fructose_o','Ethanol_o','CO2_o','Glycerol_o','Acetate_o','Succinate_o','IsoamylAlcohol_o',...
    'Isobutanol_o','PhenEtoh_o');

   inputs.exps.obs{iexp}=char('YAN_o=YAN',...
    'Glucose_o=Glucose','Fructose_o=Fructose','Ethanol_o=Ethanol','CO2_o=CO2',...
    'Glycerol_o=Glycerol','Acetate_o=Acetate' ,'Succinate_o=Succinate','IsoamylAlcohol_o=IsoamylAlcohol',...
    'Isobutanol_o=Isobutanol','PhenEtoh_o=PhenEtoh');


    inputs.exps.exp_y0{iexp}=Y_0{iexp};

    
    dummy= nan(size(inputs.exps.exp_data{iexp}(:,1),1),1);
    
    inputs.exps.exp_data{iexp}=[...
    YAN{iexp}' ...
    inputs.exps.exp_data{iexp}(:,2)   ...
    inputs.exps.exp_data{iexp}(:,3)   ...
    inputs.exps.exp_data{iexp}(:,5)   ...
    inputs.exps.exp_data{iexp}(:,31)  ...
    inputs.exps.exp_data{iexp}(:,4)   ...
    inputs.exps.exp_data{iexp}(:,6)   ...
    inputs.exps.exp_data{iexp}(:,7)  ...
    inputs.exps.exp_data{iexp}(:,29)  ...
    inputs.exps.exp_data{iexp}(:,28)  ...
    inputs.exps.exp_data{iexp}(:,30)];


%% WARNING plot error bars!!!
inputs.exps.error_data{iexp}=[         ...
    YAN_error{iexp}'                   ...
    inputs.exps.error_data{iexp}(:,2)  ...
    inputs.exps.error_data{iexp}(:,3)  ...
    inputs.exps.error_data{iexp}(:,5)  ...
    inputs.exps.error_data{iexp}(:,31) ...
	inputs.exps.error_data{iexp}(:,4)  ...
    inputs.exps.error_data{iexp}(:,6)  ...
    inputs.exps.error_data{iexp}(:,7)  ...
    inputs.exps.exp_data{iexp}(:,9).*0.5 ...%Error of 50% en isoamylol data
    inputs.exps.exp_data{iexp}(:,10).*0.45 ... %Error of 45% en isobutanol data
    inputs.exps.exp_data{iexp}(:,11).*0.28]; %Error of 28% en pheEtoh data


end

%% Filter INF

for iexp=1:inputs.exps.n_exp

inputs.exps.error_data{iexp}(isnan(inputs.exps.error_data{iexp}))=nan;
% inputs.exps.error_data{iexp}(inputs.exps.error_data{iexp}==Inf)=nan;
% 
% ID_val{iexp} = find(isnan(inputs.exps.exp_data{iexp}) ~= isnan(inputs.exps.error_data{iexp}));

ID_val{iexp} = find(isnan(inputs.exps.error_data{iexp}));

inputs.exps.error_data{iexp}(ID_val{iexp})=1e-7;
bound_error = inputs.exps.exp_data{iexp}./inputs.exps.error_data{iexp};
inputs.exps.error_data{iexp}(bound_error>1000 | isnan(bound_error)) = 1e-7;
% inputs.exps.error_data{iexp}(ID_val_0{iexp})=0.001;

end

inputs.model.mexfile='test_CALIBRATION';
inputs.model.odes_file='test_CALIBRATION.c';
inputs.plotd.plotlevel='min';  


%% 
