% %% Load data files
% 
% delimiterIn = " ";
% data = importdata(fullfile(pwd,STRAIN,'DATA_2GLX_CALIBRATION_TEMP.xlsx'),delimiterIn);

%% Preprocesing information

Time = data.data(:,4);
strain1 = char({data.textdata{2:size(data.textdata,1),1}});
COLNAMES = {data.textdata{1,:}};
exp_type = char({data.textdata{2:size(data.textdata,1),3}});


Temperature = data.data(:,5);
Init_sugar = data.data(:,6);
replicates = data.data(:,1);

NVARS = length({COLNAMES{8:end}});

COLNAMES = {COLNAMES{8:end}}; %Adjust NVARS with COLNAMES

time_vec = sort(unique(Time));
init_sugar_vec = sort(unique(Init_sugar));

% exps_names=[char(strain1) repmat(' -',length(strain1),1) repmat(' Type=', length(strain1),1) char(exp_type) repmat(' T=',length(strain1),1) num2str(Temperature) ...
%             repmat(' -',length(strain1),1) repmat(' Init Sugar=',length(strain1),1) num2str(Init_sugar)];

exps_names=[char(strain1) repmat(' -',length(strain1),1) repmat(' Type=', length(strain1),1) repmat(' -',length(strain1),1) char(exp_type)  ...
            repmat(' -',length(strain1),1) repmat(' Init Sugar=',length(strain1),1) num2str(Init_sugar)];


exps_names=regexprep(cellstr(exps_names),'NaN','single');    %replace in exps_name NaN by single and transform with cellstr    

exps_name = unique(exps_names);

obs_names=COLNAMES;
obs_funcs=COLNAMES;

DATA_PREP = data.data(:,7:end);  %New Variable to store data needed to inputs.exps.exp_data

%% Preprocesing data

inputs.exps.n_exp=length(exps_name);

for i=1:inputs.exps.n_exp

    
    inputs.exps.exp_data{i} = nan(length(time_vec),NVARS);
    inputs.exps.error_data{i} = nan(length(time_vec),NVARS);
    temperature = nan;
    init_sugar_stimuli = nan;
    
    for j=1:length(time_vec)
        
       vec = (Time == time_vec(j) & strcmp(exps_names,exps_name{i}) );
       
       if(isnan(temperature))
          temperature = mean(Temperature(vec),'omitnan');
       end
       
       if(isnan(init_sugar_stimuli))
          init_sugar_stimuli = mean(Init_sugar(vec),'omitnan');
       end
       
       for k=1:NVARS
          
           inputs.exps.exp_data{i}(j,k) = mean(DATA_PREP(vec,k),'omitnan');
           inputs.exps.error_data{i}(j,k) = std(DATA_PREP(vec,k),'omitnan');
           
       end
       
       
    end
    
    
    %% Define all inputs
    inputs.exps.n_s{i} = length(time_vec);
    inputs.exps.obs_names{i} = char(obs_names);
    inputs.exps.obs{i} = char(obs_funcs);
    inputs.exps.n_obs{i} = NVARS;
    inputs.exps.t_s{i} = time_vec';
    inputs.exps.t_in{i} = time_vec(1);
    inputs.exps.t_f{i} = time_vec(end);

    %% Define Nadd and tadd stimuli

    Nadd = 0.028; %gN/L
    tadd = [47.5 72.25 47 71];

    %% Modify stimuli for experiment variable

        %General case
        inputs.exps.u_interp{i}='step'; %
        inputs.exps.n_steps{i}=2;
        inputs.exps.u{i}=[temperature temperature; tadd(1) tadd(1) ;Nadd Nadd];
        inputs.exps.t_con{i}=[time_vec(1) tadd(1) time_vec(end)];


          if i==2 || i==4 || i==6  
            
        inputs.exps.u{i}=[temperature temperature; tadd(3) tadd(3) ;Nadd Nadd];
        inputs.exps.t_con{i}=[time_vec(1) tadd(3) time_vec(end)];
                
          end
    
    %% Conversion Units
    
    % CFU/mL -----> CFU/L
    
    inputs.exps.exp_data{i}(:,1) = inputs.exps.exp_data{i}(:,1).*1000;
    inputs.exps.error_data{i}(:,1) = inputs.exps.error_data{i}(:,1).*1000;
    
    
    % Ethanol %v/v --------> g/L
    
    inputs.exps.exp_data{i}(:,5) = inputs.exps.exp_data{i}(:,5).*(789/100);
    inputs.exps.error_data{i}(:,5) = inputs.exps.error_data{i}(:,5).*(789/100);
    
    % Convert compunds in mg/L to g/L
    
    inputs.exps.exp_data{i}(:,8:end) = inputs.exps.exp_data{i}(:,8:end)./1000;
    inputs.exps.error_data{i}(:,8:end) = inputs.exps.error_data{i}(:,8:end)./1000;   
    
%     % Preprocessing CO2 values. WARNING *1000 to recover g/L
% 
    inputs.exps.exp_data{i}(:,end) = inputs.exps.exp_data{i}(:,end).*1000;
    inputs.exps.error_data{i}(:,end) = inputs.exps.error_data{i}(:,end).*1000;
    


    %% Preprocessing nitrogen data
    
    %%MW  Alanine	Arginine	Aspartate	Cystein	   Glutamate	Glutamine	Glysine	Histidine	Ile     Leucine	 Lysine	 Methionine	NH4	     Phenylalanine	Serine	Threonine	Tryptophan	Tyrosine	Valine	
    MW=[  89.09     174.2       133.11       121.16     147.13       146.14     75.07   155.15      131.17  131.17   146.19  149.21     53.491   165.19         105.09  119.1192    204.23      181.19      117.151];
    NN=[  1         4           2            1           1           2          1        3           1      1        2       1          1        1              1       1           2           1           1      ];


    NitrogenData{i} = inputs.exps.exp_data{i}(:,8:27); NitrogenData{i}(:,15) = []; %Exclude proline
    NitrogenData_error{i} = inputs.exps.error_data{i}(:,8:27); NitrogenData_error{i}(:,15) = [];
    
    Original{i}=NitrogenData{i}; % Aminoacids data in g/L
    Original_error{i}=NitrogenData_error{i};

    for counter=1:size(NitrogenData{i},2)
        Original{i}(:,counter)=NN(counter).*NitrogenData{i}(:,counter)./MW(counter);
        Original_error{i}(:,counter)=NN(counter).*NitrogenData_error{i}(:,counter)./MW(counter);
    end
        
    YAN{i}=(sum(Original{i}')).*14.0067; %Nitrogen 
    inputs.exps.exp_data{i}(:,end+1)=YAN{i};
    YAN_error{i}=(sum(Original_error{i}')).*14.0067;
    inputs.exps.error_data{i}(:,end+1)=YAN_error{i};
    
      
end
