
% clear; close all;
SUGAR_IC = [105];
YAN_IC = [0.250];
temperature_process  = [12:25];

icount = length(SUGAR_IC);
jcount = length(YAN_IC);
kcount = length(temperature_process);

for  i=1:icount
    for j=1:jcount
        for k=1:kcount

%% Define STRAIN and paths
STRAIN = 'Yeast1'; % Yeast1; Yeast2; Yeast3; Yeast4; Yeast5
inputs.pathd.results_folder='DTWine_Final_codes';
inputs.pathd.short_name=STRAIN;
inputs.pathd.runident=['sugarCI' num2str(2*SUGAR_IC(i)) '_YANCI' num2str(YAN_IC(j)) '_temperature' num2str(temperature_process(k)) '_run1'];


%% ODE model
inputs.model.input_model_type='charmodelC'; 
inputs.model.n_st=13;
inputs.model.st_names=char('X','YAN','Glucose','Fructose','Ethanol','CO2','Glycerol',...
    'Acetate','Succinate','gene','IsoamylAlcohol','Isobutanol','PhenEtoh');

inputs.model.n_stimulus=3;
inputs.model.stimulus_names=char('TEMPERATURE','tadd','DAP');

PAR_DATA=importdata(fullfile(pwd,STRAIN,'parsmodel_2GLX_TEMP_GENERALIZATION_gene.csv'),',');
inputs.model.par_names=char({PAR_DATA.textdata{2:end,1}}');
isOpt=PAR_DATA.data(:,end);
inputs.model.par=PAR_DATA.data(:,1)';
inputs.model.n_par=length(inputs.model.par);

%% Model
 
load_model_equations = fullfile(pwd,STRAIN,'ModelEquations_TEMP_gene.m');
run(load_model_equations);


%% ODE settings
inputs.ivpsol.ivpsolver='cvodes';
inputs.ivpsol.senssolver='cvodes';
inputs.ivpsol.rtol=1.0D-7;
inputs.ivpsol.atol=1.0D-7;
inputs.ivpsol.ivp_maxnumsteps=1e4;

%% PLOT settings

inputs.plotd.n_t_plot=300;                           % [] Number of times to be used for observables and states plots


inputs.exps.n_exp=1; 

bio_0 = 1e9;
inputs.exps.exp_y0{1}=[bio_0 YAN_IC(j) SUGAR_IC(i) SUGAR_IC(i) ...
             0 ... %inputs.exps.exp_data{iexp}(1,7).*0 ...
             0 ... %CO2 values inputs.exps.exp_data{iexp}(1,48).*0 ... 
             0 ... %inputs.exps.exp_data{iexp}(1,11).*0 ...
             0 ... %inputs.exps.exp_data{iexp}(1,8).*0 ...
             0 ... %inputs.exps.exp_data{iexp}(1,16).*0 ...
             0 ...
             0 ...
             0 ...
             0];


inputs.exps.t_f{1} = 900;
    Nadd = 0; %gN/L
    tadd = [47.5 72.25 47 71];
        inputs.exps.u_interp{1}='step'; %
        inputs.exps.n_steps{1}=2;
        inputs.exps.u{1}=[temperature_process(k) temperature_process(k); tadd(3) tadd(3) ;Nadd Nadd];
        inputs.exps.t_con{1}=[0 tadd(3) 900];



% inputs.model.mexfile='test_CALIBRATION';
% inputs.model.odes_file='test_CALIBRATION.c';


AMIGO_Prep(inputs);
AMIGO_SModel(inputs);

        end
    end
end

