#include <amigoRHS.h>

#include <math.h>

#include <amigoJAC.h>

#include <amigoSensRHS.h>

#include <amigo_terminate.h>


	/* *** Definition of the states *** */

#define	X              Ith(y,0)
#define	YAN            Ith(y,1)
#define	Glucose        Ith(y,2)
#define	Fructose       Ith(y,3)
#define	Ethanol        Ith(y,4)
#define	CO2            Ith(y,5)
#define	Glycerol       Ith(y,6)
#define	Acetate        Ith(y,7)
#define	Succinate      Ith(y,8)
#define	gene           Ith(y,9)
#define	IsoamylAlcohol Ith(y,10)
#define	Isobutanol     Ith(y,11)
#define	PhenEtoh       Ith(y,12)
#define iexp amigo_model->exp_num

	/* *** Definition of the sates derivative *** */

#define	dX              Ith(ydot,0)
#define	dYAN            Ith(ydot,1)
#define	dGlucose        Ith(ydot,2)
#define	dFructose       Ith(ydot,3)
#define	dEthanol        Ith(ydot,4)
#define	dCO2            Ith(ydot,5)
#define	dGlycerol       Ith(ydot,6)
#define	dAcetate        Ith(ydot,7)
#define	dSuccinate      Ith(ydot,8)
#define	dgene           Ith(ydot,9)
#define	dIsoamylAlcohol Ith(ydot,10)
#define	dIsobutanol     Ith(ydot,11)
#define	dPhenEtoh       Ith(ydot,12)

	/* *** Definition of the parameters *** */

#define	YxN        (*amigo_model).pars[0]
#define	ksGlx      (*amigo_model).pars[1]
#define	ksF        (*amigo_model).pars[2]
#define	krN        (*amigo_model).pars[3]
#define	kd         (*amigo_model).pars[4]
#define	muMaxA     (*amigo_model).pars[5]
#define	muMaxB     (*amigo_model).pars[6]
#define	muMaxC     (*amigo_model).pars[7]
#define	vMaxGlxC   (*amigo_model).pars[8]
#define	vMaxFC     (*amigo_model).pars[9]
#define	vMaxGlxA   (*amigo_model).pars[10]
#define	vMaxGlxB   (*amigo_model).pars[11]
#define	vMaxFA     (*amigo_model).pars[12]
#define	vMaxFB     (*amigo_model).pars[13]
#define	YEthC      (*amigo_model).pars[14]
#define	tauA       (*amigo_model).pars[15]
#define	krS        (*amigo_model).pars[16]
#define	YSuccA     (*amigo_model).pars[17]
#define	YSuccB     (*amigo_model).pars[18]
#define	YSuccC     (*amigo_model).pars[19]
#define	YglyA      (*amigo_model).pars[20]
#define	YglyB      (*amigo_model).pars[21]
#define	YglyC      (*amigo_model).pars[22]
#define	YAceA      (*amigo_model).pars[23]
#define	YAceB      (*amigo_model).pars[24]
#define	YAceC      (*amigo_model).pars[25]
#define	YIsoamolA  (*amigo_model).pars[26]
#define	YIsoamolB  (*amigo_model).pars[27]
#define	YIsoamolC  (*amigo_model).pars[28]
#define	YIsobutolA (*amigo_model).pars[29]
#define	YIsobutolB (*amigo_model).pars[30]
#define	YIsobutolC (*amigo_model).pars[31]
#define	YPhenEthA  (*amigo_model).pars[32]
#define	YPhenEthB  (*amigo_model).pars[33]
#define	YPhenEthC  (*amigo_model).pars[34]
#define	kN         (*amigo_model).pars[35]
#define	tauB       (*amigo_model).pars[36]
#define	tauC       (*amigo_model).pars[37]
#define	YCO2       (*amigo_model).pars[38]
#define	YEthA      (*amigo_model).pars[39]
#define	YEthB      (*amigo_model).pars[40]
#define TEMPERATURE	((*amigo_model).controls_v[0][(*amigo_model).index_t_stim]+(t-(*amigo_model).tlast)*(*amigo_model).slope[0][(*amigo_model).index_t_stim])
#define tadd       	((*amigo_model).controls_v[1][(*amigo_model).index_t_stim]+(t-(*amigo_model).tlast)*(*amigo_model).slope[1][(*amigo_model).index_t_stim])
#define DAP        	((*amigo_model).controls_v[2][(*amigo_model).index_t_stim]+(t-(*amigo_model).tlast)*(*amigo_model).slope[2][(*amigo_model).index_t_stim])

	/* *** Definition of the algebraic variables *** */

	double	muMaxN;
	double	vMaxF;
	double	vMaxGlx;
	double	y_glycerol_f;
	double	YAce;
	double	YSuccinate;
	double	YIsoamylAlcohol;
	double	YIsobutanol;
	double	YPhenEtoh;
	double	phiNS;
	double	muN;
	double	tau_gene;
	double	phiSugar;
	double	YEthf;
/* Right hand side of the system (f(t,x,p))*/
int amigoRHS(realtype t, N_Vector y, N_Vector ydot, void *data){
	AMIGO_model* amigo_model=(AMIGO_model*)data;
	ctrlcCheckPoint(__FILE__, __LINE__);


	/* *** Equations *** */

	muMaxN=muMaxA+muMaxB*exp(-muMaxC/TEMPERATURE);
	vMaxF=vMaxFA*pow(TEMPERATURE,2)-vMaxFB*TEMPERATURE+vMaxFC;
	vMaxGlx=vMaxGlxA*pow(TEMPERATURE,2)-vMaxGlxB*TEMPERATURE+vMaxGlxC;
	y_glycerol_f=YglyA*pow(TEMPERATURE,2)+YglyB*TEMPERATURE+YglyC;
	YAce=YAceA*pow(TEMPERATURE,2)+YAceB*TEMPERATURE+YAceC;
	YSuccinate=YSuccA*pow(TEMPERATURE,2)+YSuccB*TEMPERATURE+YSuccC;
	YIsoamylAlcohol=YIsoamolA*pow(TEMPERATURE,2)+YIsoamolB*TEMPERATURE+YIsoamolC;
	YIsobutanol=YIsobutolA*pow(TEMPERATURE,2)+YIsobutolB*TEMPERATURE+YIsobutolC;
	YPhenEtoh=YPhenEthA*pow(TEMPERATURE,2)+YPhenEthB*TEMPERATURE+YPhenEthC;
	phiNS=1-(YAN/(YAN+krN));
	muN=muMaxN*YAN/(YAN+kN);
	dX=muN*X-kd*X;
	tau_gene=tauA+tauB*exp(-tauC/TEMPERATURE);
	phiSugar=1-((Glucose+Fructose)/((Glucose+Fructose)+krS));
	dgene=(phiSugar*phiNS-gene)*tau_gene;
	dYAN=-muN*X/(YxN*1e10);
	if(t==tadd){YAN=YAN+DAP;}
	dGlucose=-vMaxGlx*X*1e-10*Glucose/(Glucose+ksGlx);
	dFructose=-vMaxF*X*1e-10*Fructose/(Fructose+ksF);
	YEthf=YEthA*pow(TEMPERATURE,2)-YEthB*TEMPERATURE+YEthC;
	if(y_glycerol_f>=0){dEthanol=-YEthf*(dGlucose+dFructose);}else{dEthanol=0;}
	if(YAce>=0){dCO2=-YCO2*YEthf*(dGlucose+dFructose);}else{dCO2=0;}
	if(YSuccinate>=0){dGlycerol=-y_glycerol_f*(dGlucose+dFructose)*(1-gene);}else{dGlycerol=0;}
	if(YIsoamylAlcohol>=0){dAcetate=-YAce*(dGlucose+dFructose)*(1-gene);}else{dAcetate=0;}
	if(YIsobutanol>=0){dIsoamylAlcohol=-YIsoamylAlcohol*(dGlucose+dFructose);}else{dIsoamylAlcohol=0;}
	if(YPhenEtoh>=0){dIsobutanol=-YIsobutanol*(dGlucose+dFructose);}else{dIsobutanol=0;}
	dSuccinate=-YSuccinate*(dGlucose+dFructose);
	dIsoamylAlcohol=-YIsoamylAlcohol*(dGlucose+dFructose);
	dIsobutanol=-YIsobutanol*(dGlucose+dFructose);
	dPhenEtoh=-YPhenEtoh*(dGlucose+dFructose)*(1-gene);

	return(0);

}


/* Jacobian of the system (dfdx)*/
int amigoJAC(long int N, realtype t, N_Vector y, N_Vector fy, DlsMat J, void *user_data, N_Vector tmp1, N_Vector tmp2, N_Vector tmp3){
	AMIGO_model* amigo_model=(AMIGO_model*)user_data;
	ctrlcCheckPoint(__FILE__, __LINE__);


	return(0);
}

/* R.H.S of the sensitivity dsi/dt = (df/dx)*si + df/dp_i */
int amigoSensRHS(int Ns, realtype t, N_Vector y, N_Vector ydot, int iS, N_Vector yS, N_Vector ySdot, void *data, N_Vector tmp1, N_Vector tmp2){
	AMIGO_model* amigo_model=(AMIGO_model*)data;

	return(0);

}