function [] = plot_ForceDisplacement(U_EXP, A_EXP, WallMass, WallThick, U_NUM, F_NUM, failure, i_end, name, where_to_save, model, tt)

        switch model
            case 'Doherty'
                colore = 'b';
                leggenda = 'Doherty et al.';
            case 'PresentModel'
                colore = 'r';
                leggenda = 'present model';
        end

        %% plot force displacement curves

        % settings
        figure7 = figure(1); hold on
        grid on
        box on
        hold on
        axis square
        x0=10;
        y0=10;
        width=9;
        height=width;
        set(gcf,'units','Centimeters','position',[x0,y0,width,height])
        set(gca,'FontSize',14,'FontName','Times','FontAngle','italic','linewidth',1);
        set(gca,'PlotBoxAspectRatio',[1 1 1]);
        set(gcf,'PaperPositionMode','auto');
        xlabel('$ \Delta/t\rm_w  $','interpreter','latex', 'FontSize', 16)
        ylabel('$ F/W  $','interpreter','latex', 'FontSize', 16)
        xlim([-1, 1])

        switch tt
            case {1,2,3,4,5,6,7,8,9,10,11,12,13}
                ymin = -0.4;
                ymax =  0.4;
            otherwise
                ymin = -0.6;
                ymax =  0.6;
        end

        ylim([ymin, ymax])
        yticks([ymin ymin/2  0  ymax/2 ymax])
        xtickformat('%,.1f')
        ytickformat('%,.1f')

        % experimental
        gravity = 9.81;
        sweigth = WallMass*gravity;
        F_EXP_2 = 2*(WallMass/2*A_EXP/2);
        g3 = plot(U_EXP/WallThick, -F_EXP_2/sweigth,  'color','k','linewidth',1.);

        % tri-linear model
        g2 = plot(U_NUM(1:i_end)/WallThick, F_NUM(1:i_end)/sweigth/(3/2), 'color',colore,'linewidth',1.,'linestyle','-.'); hold on
        if failure == 1
            plot(U_NUM(i_end)/WallThick,F_NUM(i_end)/sweigth/(3/2), strcat(colore,'x'),'linewidth',1.)
        end

        % legend
        lg = legend([g3 g2], {'experimental', leggenda});
        lg.Interpreter = 'latex';
        lg.FontSize = 14;
        lg.Box = 'off';
        lg.Position = [0.63 0.8 0.0 0.0];

        % save
        print(figure7, strcat(where_to_save,name,'_FD_',model),   '-dpng')
        saveas(figure7, strcat(where_to_save,name,'_FD_',model),   'fig')

        close all

end