function [ ] = plot_DisplacementHistory( l1, l2, U_EXP, time_EXP, ...
    U_num, time_num, failure, i_end, ...
    tw, where_to_save, name, model, tt )

        switch model
            case 'Doherty'
                colore = 'b';
                leggenda = 'Doherty et al.';
            case 'PresentModel'
                colore = 'r';
                leggenda = 'present model';
        end

        switch name
            case    'Nahanni_100%'
                xmin = 0;
                xmax = 12;
                ymin = -0.3;
                ymax= 0.3;
            case    'Nahanni_200%'
                xmin = 0;
                xmax = 12;
                ymin = -0.3;
                ymax= 0.3;
            case    'Nahanni_400%'
                xmin = 0;
                xmax = 12;
                ymin = -0.3;
                ymax= 0.3;
            case    'Elcentro_66%'
                xmin = 0;
                xmax = 20;
                ymin = -1.;
                ymax= 1.;
            case    'Pacoima_66%'
                xmin = 0;
                xmax = 20;
                ymin = -1.;
                ymax= 1.;
            case    'Pacoima_80%'
                xmin = 0;
                xmax = 20;
                ymin = -1.;
                ymax= 1.;
            otherwise
                xmin = 20;
                xmax = 50;
                ymin = -1.;
                ymax =  1.;
        end

        %% plot displacement histories

        % settings
        figure3 = figure(1); hold on
        grid on
        box on
        hold on
        axis square
        set(gca,'FontSize',14,'FontName','Times','FontAngle','italic','linewidth',1);
        set(gcf,'Units','Centimeters');
        set(gca,'PlotBoxAspectRatio',[1.3 .5 1]);
        set(gcf,'PaperPositionMode','auto');
        xlabel('$ t \left[ \rm s \right] $','interpreter','latex', 'FontSize', 16)
        ylabel('$ \Delta/t\rm_w $','interpreter','latex', 'FontSize', 16)
        ylim([ymin, ymax])
        xlim([xmin, xmax])
        yticks([ymin ymin/2 0 ymax/2 ymax])
        xtickformat('%,.0f')
        ytickformat('%,.1f')

        % experimental wall response
        g1 = plot(time_EXP(l1:l2), U_EXP(l1:l2)/tw, 'color','k','linewidth',1.); hold on
        if tt == 4
            plot(time_EXP(l2:length(time_EXP)), U_EXP(l2:length(time_EXP))/tw, 'color',[0.5 0.5 0.5],'linestyle','-.','linewidth',1.);
            text(4.5,.8,'wall hits support','interpreter','latex', 'FontSize', 14)
            h = line([0,20],[.98,0.98]);
            h.LineStyle = '--';
            h.Color = 'k';
        end

        % tri-linear model response
        g2 = plot(time_num(1:i_end), U_num(1:i_end)/tw, 'color',colore,'linewidth',1.,'linestyle','-.'); hold on
        
        if failure == 1
            plot(time_num(i_end),U_num(i_end)/tw, strcat(colore,'x'),'linewidth',1.)
        end
        
        % add legend
        lg = legend([g1 g2], {'experimental', leggenda});
        lg.Interpreter = 'latex';
        lg.FontSize = 14;
        lg.Box = 'off';
        
        %% save plots
        print(figure3, strcat(where_to_save,name,'_U_',model),   '-dpng')
        saveas(figure3, strcat(where_to_save,name,'_U_',model),   'fig')

        close all

end