function [average_WME20_error, min_WME20] = compute_WME20_error(TRL, WALL, TRL_tstep)

        % dispatch
        for tt = 1:6
            U_NUM{tt} = TRL{tt}.U;
            U_EXP{tt} = WALL{tt}.MidDisp2;
        end

        % compute WME(20) error
        for tt = 1:6

            %compute the largest oscillation in the time history (whether experimental or numerical)
            max_disp_NUM = max(abs(U_NUM{tt}));
            max_disp_EXP = max(abs(U_EXP{tt}));
            max_disp     = max(max_disp_NUM,max_disp_EXP);

            %modify time history in such a way that only the oscillations larger
            %than 20% of the largest are considered

            for ii = 1:length(U_NUM{tt})

                %num
                if  abs(U_NUM{tt}(ii)) < 0.20*max_disp
                    U_NUM{tt}(ii) = 0;
                else

                    if U_NUM{tt}(ii) >= 0
                        U_NUM{tt}(ii) = U_NUM{tt}(ii) - 0.20*max_disp;
                    else
                        U_NUM{tt}(ii) = U_NUM{tt}(ii) + 0.20*max_disp;
                    end

                end

                %exp
                if  abs(U_EXP{tt}(ii)) < 0.20*max_disp
                    U_EXP{tt}(ii) = 0;
                else

                    if U_EXP{tt}(ii) >= 0
                        U_EXP{tt}(ii) = U_EXP{tt}(ii) - 0.20*max_disp;
                    else
                        U_EXP{tt}(ii) = U_EXP{tt}(ii) + 0.20*max_disp;
                    end

                end
            end

            %compute WME
            min_WME20{tt} = 1000;
            for dd = 1 : 160

                delta_t  = -0.5 + (dd-1)*1/160;

                num = 0;
                den = 0;

                if delta_t < 0
                    %maximum lower bound
                    ll_begin = 1 + round(abs(delta_t)/TRL_tstep{tt},0);
                    %minimum upper bound
                    ll_end   = length(U_NUM{tt});

                elseif delta_t > 0
                    %maximum lower bound
                    ll_begin = 1;
                    %minimum upper bound
                    ll_end   = length(U_NUM{tt}) - round(abs(delta_t)/TRL_tstep{tt},0);

                elseif delta_t == 0
                    %maximum lower bound
                    ll_begin = 1;
                    %minimum upper bound
                    ll_end   = length(U_NUM{tt});

                end

                for ll = ll_begin : ll_end
                    num = num + abs(U_EXP{tt}(ll) - U_NUM{tt}(ll + round(delta_t/TRL_tstep{tt},0)))*TRL_tstep{tt};
                    den = den + abs(U_EXP{tt}(ll))*TRL_tstep{tt};
                end

                WME = num/den;

                if dd == 1
                    min_WME20{tt} = WME;
                else
                    if WME < min_WME20{tt}
                        min_WME20{tt} = WME;
                        delta_t_min{tt} = delta_t;
                    end
                end

            end

        end

        %average WME(20) error
        average_WME20_error = 0;
        count = 0;
        for tt = 1:6
            average_WME20_error = average_WME20_error + min_WME20{tt};
            count = count + 1;
        end
        average_WME20_error = average_WME20_error/count;

end