function [average_RMS_error, RMS_error] = compute_RMS_error(TRL,WALL)

        % dispatch
        for tt = 1:6
            U_NUM{tt} = TRL{tt}.U;
            U_EXP{tt} = WALL{tt}.MidDisp2;
        end

        %compute RMS (root mean square) based error
        for tt = 1:6
            HRMS = dsp.RMS;
            RMS_exp{tt} = step(HRMS,transpose(U_EXP{tt}));
            RMS_anl{tt} = step(HRMS,transpose(U_NUM{tt}));
            RMS_error{tt} = abs(RMS_exp{tt} - RMS_anl{tt})/abs(RMS_exp{tt});
        end

        %average RMS error
        average_RMS_error = 0;
        count = 0;
        for tt = 1:6
            average_RMS_error = average_RMS_error + RMS_error{tt};
            count = count + 1;
        end
        average_RMS_error = average_RMS_error/count;

end