switch wish_to_build_TRL
    case 1
        fprintf('\n Model by Godio & Beyer\n')
    case 0
        fprintf('\n Model by Doherty \n')
end

% loop over the 6 tests considered for validation
for tt = 1:6
    
    clear tmp_U_dd tmp_U_dd_N tmp_time
    
    %1) definition of the TRL model
    
    % damping ratio (in this work this value is fixed at 5%)
    TRL{tt}.Zeta = 0.05;
    
    % mass of the tri-linear SDOF system
    TRL{tt}.Mass = WALL{tt}.Mass;
    
    % define force and displacement parameters of the tri-linear model
    %
    % notation:
    %
    % d_1     = first corner displacement
    % d_2     = second corner displacement
    % d_U     = ultimate displacement
    % d_0     = displacement from limit analysis
    % Delta_1 = first corner displacement (= d_1/d_0)
    % Delta_2 = normalized second corner displacement (= d_2/d_0)
    % Delta_U = normalized ultimate displacement (= d_U/d_0)
    % F_1     = max force of the tri-linear model (multiplied by factor 3/2)
    % F_0     = force from limit analysis (multiplied by factor 3/2)
    
    % define model parameters using the equations contained in the paper
    if wish_to_build_TRL == 1
        
        model = 'PresentModel';
        
        fprintf('Simulation of shake table test %s \n', WALL{tt}.TestLab)
        
        % to impose middle crack at wall mid-height, select 'fix_MHH = 1'
        % to derive middle crack position from limit analysis, see section
        % S1 of the Supplemental material, select 'fix_MHH = 1'
        % in these tests, the walls were pre-cracked at mid-height
        fix_MHH = 1;
        
        % calculate tri-linear model parameters from the wall properties
        [TRL{tt}.d_1, TRL{tt}.d_2, TRL{tt}.d_U, TRL{tt}.Delta_1, ...
            TRL{tt}.Delta_2, TRL{tt}.Delta_U, ...
            TRL{tt}.F_1, TRL{tt}.F_0, TRL{tt}.d_0] = build_TRL( ...
            [WALL{tt}.Height; WALL{tt}.Thickness; WALL{tt}.Length; ...
            WALL{tt}.PLoad; WALL{tt}.EModulus; WALL{tt}.Mass], fix_MHH );
        
        % define model parameters based on Doherty et al 2002
    else
        
        model = 'Doherty';
        
        fprintf('Simulation of shake table test %s \n', WALL{tt}.TestLab)
        
        % define joint conditions
        switch tt
            case {1,2,3}
                joint_condition = 1;
            case {4,5,6}
                joint_condition = 2;
        end
        
        % define properties from Doherty et al., 2002
        switch joint_condition
            %new joints
            case 1
                TRL{tt}.Delta_1 = 0.06;
                TRL{tt}.Delta_2 = 0.28;
                TRL{tt}.d_0     = WALL{tt}.Thickness;
                TRL{tt}.d_U     = WALL{tt}.Thickness;
                TRL{tt}.Delta_U = 1;
                %moderately degraded joints
            case 2
                TRL{tt}.Delta_1 = 0.13;
                TRL{tt}.Delta_2 = 0.40;
                TRL{tt}.d_0     = WALL{tt}.Thickness;
                TRL{tt}.d_U     = WALL{tt}.Thickness;
                TRL{tt}.Delta_U = 1;
                %severly degraded joints
            case 3
                TRL{tt}.Delta_1 = 0.20;
                TRL{tt}.Delta_2 = 0.50;
                TRL{tt}.d_0     = WALL{tt}.Thickness;
                TRL{tt}.d_U     = WALL{tt}.Thickness;
                TRL{tt}.Delta_U = 1;
        end
        
        TRL{tt}.d_1     = TRL{tt}.Delta_1*TRL{tt}.d_0;
        TRL{tt}.d_2     = TRL{tt}.Delta_2*TRL{tt}.d_0;
        TRL{tt}.F_0     = 8*WALL{tt}.PLoad*WALL{tt}.Thickness/WALL{tt}.Height;
        TRL{tt}.F_1     = (1 - TRL{tt}.Delta_2)*TRL{tt}.F_0;
        % scale by factor 3/2 for time integration
        TRL{tt}.F_0     = 3/2*TRL{tt}.F_0;
        TRL{tt}.F_1     = 3/2*TRL{tt}.F_1;
        
    end
    
    % 2) integrate the tri-linear model
    
    % trim time-histories
    if tt == 4
        l1 = 1;
        l2 = ceil(4.00/(WALL{tt}.Time(2) - WALL{tt}.Time(1)));
    else
        l1 = 1;
        l2 = length(WALL{tt}.Time);
    end
    
    % time vector used for time integration
    tha_time  = WALL{tt}.Time(l1:1:l2);
    
    % acceleration vector used for time integration
    tha_U_dd  = 3/2*WALL{tt}.BaseAcc(l1:1:l2);
    
    % initial conditions used for time integration
    tha_u0        = 0;
    tha_ud0       = 0;
    tha_udd0      = 3/2*WALL{tt}.BaseAcc(1);
    
    % integration of the model
    %
    % this function gives as outputs:
    %
    % U     = displacement history of the tri-linear model
    % V     = velocity history of the tri-linear model
    % A     = acceleration history of the tri-linear model
    % Fstat = restoring force of the tri-linear model
    % Fdyn  = total inertia force of the tri-linear model
    % T     = time vector of the integrated tri-linear model
    % Fail  = 1, if the wall has failed; = 0, otherwise
    % End   = index where the simulation has stopped at wall failure
    
    [TRL{tt}.U, TRL{tt}.V, TRL{tt}.A, TRL{tt}.Fstat, TRL{tt}.Fdyn, TRL{tt}.T, ...
        TRL{tt}.Fail, TRL{tt}.End] = integration_SDOF( tha_U_dd(l1:l2), ...
        tha_u0, tha_ud0, tha_udd0, tha_time(l1:l2), TRL{tt}.Mass, TRL{tt}.Zeta, ...
        [TRL{tt}.d_1; TRL{tt}.d_2; TRL{tt}.d_U; TRL{tt}.F_1; TRL{tt}.F_0]);
    
    % 3) plot time histories
    % and compare tri-linear model vs. experimental wall behavior
    plot_DisplacementHistory(l1, l2, WALL{tt}.MidDisp,  WALL{tt}.Time,  ...
        TRL{tt}.U, TRL{tt}.T,  TRL{tt}.Fail, TRL{tt}.End, ...
        WALL{tt}.Thickness, saveFig, WALL{tt}.TestLab, model, tt )
    
    % 4) plot dynamic F-D diagrams
    % and compare tri-linear model vs. experimental wall behavior
    plot_ForceDisplacement(WALL{tt}.MidDisp, WALL{tt}.MidAcc, ...
        WALL{tt}.Mass, WALL{tt}.Thickness, TRL{tt}.U, TRL{tt}.Fdyn, ...
        TRL{tt}.Fail, TRL{tt}.End, WALL{tt}.TestLab, saveFig, model, tt)
    
end

fprintf('Figures are available in the following folder: %s \n', saveFig)

clearvars tha_time tha_u0 tha_U_dd tha_ud0 tha_udd0 fix_MHH tt
