fprintf('Compute error estimates \n')

% resample the experimental time history to match the dimension of the 
% tri-linear model output
for tt = 1:6
    TRL_tstep{tt} = TRL{tt}.T(2) - TRL{tt}.T(1);
    for ll = 1:length(TRL{tt}.T)
        WALL{tt}.MidDisp2(ll) = interp1(WALL{tt}.Time,WALL{tt}.MidDisp,TRL{tt}.T(ll));
    end
end

% compute RMS based error
[average_RMS_error_trl, RMS_error_trl] = compute_RMS_error(...
    TRL, WALL);

% compute WME error (definition in Al Sahwa et al 2012) considering all
% oscillations
[average_WME_error_trl, WME_error_trl] = compute_WME_error( ...
    TRL, WALL, TRL_tstep);

% compute WME error (definition in Al Sahwa et al 2012) considering only
% oscillations larger than 20% the maximum one
[average_WME20_error_trl,  WME20_error_trl] = compute_WME20_error( ...
    TRL, WALL, TRL_tstep);

% ratio between displacement peaks
[average_peak_ratio, peak_ratio] = compute_peaks( ...
    TRL, WALL);

% print in txt file
if wish_to_build_TRL == 1
    model = 'PresentModel';
else
    model = 'Doherty';
end

% add labels
label = {'Specimen 12 (a)', 'Specimen 12 (c)', 'Specimen 12 (e)', 'Specimen 13 (b)', 'Specimen 13 (d)', 'Specimen 13 (f)'};

% print
fid = fopen( strcat(saveFig,'ERROR_ESTIMATORS_',model,'.txt'), 'wt' );
for tt = 1:6
    jj = tt;
    fprintf( fid, strcat(label{jj}, '& %.3f & %.3f & %.3f & %.3f \\\\ \n'),peak_ratio{1,tt}, RMS_error_trl{1,tt},WME_error_trl{1,tt},WME20_error_trl{1,tt});
end
fprintf( fid, '\\');
fprintf( fid, 'hline');
fprintf( fid, strcat('\n Mean value' , '& %.3f & %.3f & %.3f & %.3f \\\\ \n'), average_peak_ratio,average_RMS_error_trl, average_WME_error_trl, average_WME20_error_trl);

fclose(fid);

clearvars WME20_error_trl WME_error_trl RMS_error_trl peak_ratio 
clearvars average_peak_ratio average_RMS_error_trl average_WME20_error_trl average_WME_error_trl

fprintf('Error estimates can be found in %s \n', strcat(saveFig,'ERROR_ESTIMATORS_',model,'.txt'))
