function  [d_1, d_2, d_U, Delta_1, Delta_2, Delta_U, F_1, F_0, d_0] = build_TRL( model_param, want_to_fix_MHH )

        % model parameters
        HW = model_param(1,1); %  wall height
        TW = model_param(2,1); %  wall thickness
        LW = model_param(3,1); %  wall width
        PW = model_param(4,1); %  effective top load (W/2 + O)
        EM = model_param(5,1); %  masonry young modulus
        MW = model_param(6,1); %  masonry mass density

        % properties
        JM  = (TW^3*LW)/12.;
        Mu = sqrt(PW/(EM*JM));
        WW = MW*9.81;

        OW = PW - WW/2;

        if want_to_fix_MHH == 1

            %middle hinge position from the ground normalized to the height
            Xi_0    = 1/2;
            % force from rigid body analysis
            F_0     = 8*PW*TW/HW;
            % displacement from rigid body analysis
            d_0 = TW;

        else

            % force from rigid body analysis
            F_0     = 2*TW*(2*OW + WW + 2*sqrt(OW*(OW + WW)))/HW;
            % displacement from rigid body analysis
            d_0 = TW*(OW + WW + sqrt(OW*(OW + WW)))/(2*(OW + WW));
            %middle hinge position from the ground normalized to the height
            Xi_0    = 1 - (-OW + sqrt(OW*(OW + WW)))/WW;

        end

        % critical load
        k_E  = 0.5;
        PE   = pi^2*EM*JM/(k_E*HW)^2;

        % initial stiffness from ANL model
        K_ratio_CC = 1 - PW/PE;
        K_lin = 384*JM*EM/HW^3;
        kini = K_lin*K_ratio_CC;

        % 3/2 is for the scaling factor to be used in the equation of motion (Griffith 2003)
        f_0  = 3/2;

        % initial stiffness K1 of TRL model
        k_1  =0.7*kini;

        % F_1
        beta_1 = (1 - (PW/PE)^(0.4));
        F_1  = beta_1*F_0;

        % F_1 and F_0 (scaled)
        F_1  = f_0*F_1;
        F_0  = f_0*F_0;

        % initial stiffness (scaled)
        k_1  = f_0*k_1;

        % ds are displacements
        % DELTAS are ratios

        % DELTA-1 (unscaled)
        d_1     = F_1/k_1;
        Delta_1 = d_1/d_0;

        % DELTA_U (unscaled)
        Delta_U = 1;
        d_U     = Delta_U*d_0;

        % DELTA 2 (unscaled)
        Delta_2 = (PW/PE)^(0.4) - 1 + Delta_U;
        d_2     = Delta_2*d_0;

end