function[sig,param_var] = Trilinear_Mat_model(eps_c,eps_prev,sig_prev,param)

% Fixed parameters: [Delta_1 Delta_2 d_U F_0]'
% Variable parameters: K_T

%   eps_c 	 = displacement at the current time step
%   eps_prev = displacement at previous time step
%   sig_prev = force at previous time step
%   sig      = force at current time step
%   K_T      = tangent stiffness

%model parameters
D_1 = param(1,1);   %positive
D_2 = param(2,1);   %positive
d_U = param(3,1);   %positive
F_1 = param(4,1);   %positive
F_0 = param(5,1);   %positive

d_1 = D_1;      %positive
d_2 = D_2;      %positive

K_1 =  F_1/d_1;         %stiffness of the first branch, positive
K_2 = -F_0/d_U;         %stiffness of the third branch, negative

d_c = abs(eps_c);
d_p = abs(eps_prev);

%check on displacement step
d_inc = d_c - d_p;
if any([d_inc > d_1, d_inc > (d_2-d_1)/2.])
     error('Displacement step to large, decrease the time step')
    return
end

if sign(eps_c) == sign(eps_prev)
    
    %positive or negative deflections
    if eps_c > 0
        %positive deflections
        p_label =  1;
    else
        %negative deflections
        p_label = -1;
    end
    %
    
    d_inc = d_c - d_p;
    d_inc_M = d_inc/d_c*100;
    %
    
    if d_inc_M > 0
        %deflections with growing amplitude (both positive and negative)
        a_label =  1;
    elseif d_inc_M < 0
        %deflections with decreasing amplitude (both positive and negative)
        a_label = -1; 
    elseif all([d_inc_M >= -0.0001, d_inc_M <= 0.0001])
        %stationary point
        a_label = 0;
    end
    
    K_1_a = K_1;
    K_2_a = K_2;
    
    switch a_label
        case 0 %stationary point, e.g. point on which direction changes
            sig = sig_prev;
            K_T = 0.;   %*-* should be the previous one
            %K_T = K_prev
        case 1    %deflections with growing amplitude (both positive and negative)  
            %failure condition
            if d_c >= d_U
                eps_c = p_label*d_U;
                sig   = 0.;
                K_T   = 0.;
            %1->1
            elseif all([d_p < d_1, d_c < d_1])
                sig = K_1_a*eps_c; %sig_prev + p_label*(K_1_a*d_inc);
                K_T = K_1_a;
            %1->2
            elseif all([d_p < d_1, d_c == d_1])
                sig = p_label*F_1;
                K_T = 0;
            elseif all([d_p <= d_1, d_1 < d_c, d_c < d_2])
                sig = p_label*F_1;
                K_T = 0.;  
            %2->2
            elseif all([d_1 <= d_p, d_p < d_2, d_1 <= d_c, d_c < d_2])
                sig = p_label*F_1;
                K_T = 0.;
            %2->3    
            elseif all([d_1 <= d_p, d_p < d_2, d_c == d_2])
                sig = p_label*F_1;
                K_T = 1*K_2_a;                            
            elseif all([d_1 < d_p , d_p <= d_2, d_2 < d_c , d_c < d_U])
                sig = sig_prev + p_label*(K_2_a*(d_c - d_2));
                K_T = 1*K_2_a;
            %3->3
            elseif all([d_p > d_2, d_2 <= d_c ,d_c < d_U])
                sig = sig_prev + p_label*(K_2_a*d_inc);
                K_T = 1*K_2_a;
            end    
        case -1
            %failure condition
            if d_c >= d_U
                eps_c = p_label*d_U;
                sig   = 0.;
                K_T   = 0.;
            %1->1
            elseif all([d_c <= d_1, d_p <= d_1])
                sig = K_1_a*eps_c; %sig_prev + p_label*(K_1_a*d_inc);
                K_T = 1*K_1_a;
            %2->1
            elseif all([d_c < d_1, d_1 <= d_p, d_p  < d_2])
                sig = K_1_a*eps_c; %sig_prev + p_label*(K_1_a*d_inc);
                K_T = 1*K_1_a;  
            elseif all([d_1 == d_c, d_1 < d_p, d_p <= d_2])
                sig = p_label*F_1;
                K_T = 1*K_1_a;                
            %2->2
            elseif all([d_1 < d_c, d_c <= d_2, d_1 < d_p, d_p <= d_2])
                sig = p_label*F_1;
                K_T = 0.;
            %3->2
            elseif all([d_1 < d_c ,d_c < d_2, d_2 < d_p ,d_p  < d_U])
                sig = p_label*F_1;
                K_T = 0.;
            elseif all([d_c == d_2, d_2 <= d_p , d_p < d_U])
                sig = p_label*F_1;
                K_T = 0.;                 
            %3->3           
            elseif all([d_c > d_2, d_2 < d_p , d_p < d_U])
                sig = sig_prev + p_label*(K_2_a*d_inc);
                K_T = 1*K_2_a;
            end    
    end
else
    %passing through position at rest
    %only possible form branch 1 to branch 1
    %cause time step will be smaller
    %positive or negative deflections
    if eps_c > 0
        %system moves to positive deflections
        p_label =  1;
    else
        %system moves to negative deflections
        p_label = -1;
    end
    eps_inc = eps_c - eps_prev;
    d_c = abs(eps_c);
    d_p = abs(eps_prev);
    
    %conditions
    if d_c < d_1
        sig = sig_prev + K_1*eps_inc; 
        K_T = K_1;
    elseif d_c >= d_1
        sig = p_label*F_1;
        K_T = 0;
    end    
    
end

param_var(1,1) = K_T;

end

