% initialize things
clear all; clc; close all

% define directory containing matlab functions 
current_folder = pwd;
root_functions = '\MATLAB_FUNCTIONS';
addpath(strcat([cd, root_functions]))

% define working directory
mainroot = 'C:\Users\godio\Downloads\TRI-LINEAR_MODEL\TRI-LINEAR_MODEL\';                               

% define directory to save figures
saveFig = strcat(mainroot,'RESULTS\');

%% IMPORT DATASET 

% this section imports the file WALL.mat containing the dataset from the
% shake table tests performed by Griffith et al., 2004; Doherty, 2000. 

% notation:
% 
% WALL.TestLab   = test name
% WALL.Mass      = wall mass
% WALL.Height    = wall height
% WALL.Thickness = wall thickness
% WALL.Length    = wall length
% WALL.PLoad     = effective axial load applied to the wall (see Eq.(5))
% WALL.EModulus  = wall E-modulus
% WALL.Time      = time array (s)
% WALL.BaseAcc   = table acceleration
% WALL.MidDisp   = mid-height wall displacement
% WALL.MidAcc    = mid-height wall acceleration

load(strcat(mainroot, 'TEST_DATA\WALL.mat'))

%% RUN THE NEW TRI-LINEAR MODEL by Godio and Beyer, 2018

% this section runs the tri-linear model presented in the paper 
% to simulate the shake table tests by Griffith et al., 2004  

% this runs the tri-linear model and gives as output the 
% plots of Fig. 5 and 6; these plots can be found in the directory 'saveFig'
wish_to_build_TRL = 1;
c_run_TRL_model
 
% this computes the error estimates and, as output, it saves them in the 
% directory 'saveFig' in .txt format
c_compute_error_estimators

%% RUN THE TRI-LINEAR MODEL BY Doherty et al., 2002 

% this section runs the tri-linear model proposed by Dhoherty et al., 2002
% to simulate the shake table tests by Griffith et al., 2004 

% this runs the tri-linear model and gives as output the 
% plots of Fig. 5 and 6; these plots can be found in the directory 'saveFig'
clearvars TRL
wish_to_build_TRL = 0;
c_run_TRL_model

% this computes the error estimates and, as output, it saves them in the 
% directory 'saveFig' in .txt format
c_compute_error_estimators
