#setwd("C:/Users/kejima/Dropbox/Andrew_murine/JAX/power")
library(scales)
x=1:7
y=c(3,4,5,8,12,16,20)
name_test = c("Student's t test","Welch's t test","Wilcoxon rank sum test","Permutation test","Bootstrap test")
name_strain = c(expression(italic(A^y)*'(B6), female'), expression(italic(tub)*'(B6), female'), expression(italic(Lep^ob)*'(B6), female'),
    expression(italic(Cpe^fat)*'(BK), female'), expression(italic(Lepr^db)*'(BK), female'),
    expression(italic(A^y)*'(B6), male'), expression(italic(tub)*'(B6), male'), expression(italic(Lep^ob)*'(B6), male'), expression(italic(Lepr^db)*'(B6), male'),
    expression(italic(Cpe^fat)*'(BK), male'), expression(italic(Lepr^db)*'(BK), male'))
cols = rainbow(12)
for(d in c(1.0,1.5,3.0)){ # Cohen's d
    if(d==1.0) Y=c(0.0,1); if(d==1.5) Y=c(0.0,1); if(d==3.0) Y=c(0.0,1)
    tiff(paste("figure2_power_strain",format(d,nsmall=1),".tif",sep=""), res = 300, width = 7, height = 5, units = 'in')
    par(mgp=c(2.0,0.5,0.0), mai=c(0.4,0.6,0.2,0.2), ps=10); layout(matrix(1:6, 2, 3, byrow = T))  
    for(test in 1:5){ # Test
        data = NULL
        ref = NULL
        for(n in y){ # sample size
            ref = rbind(ref, read.csv(paste(format(d,nsmall=1),"-",n,"-power.csv",sep=""),header=F))
            for(s in c('f','m')){ # sex
                for(stid in c(140,142,141,144,143,162)){ # strain
                    if(s=='f'&stid==144) next
                    data = rbind(data, read.csv(paste(stid,"-",n,"-",s,"-",format(d,nsmall=1),"-power.csv",sep=""),header=F))
                }
            }
        } 
        mu <- data[,seq(1,13,3)]; lc <- data[,seq(2,14,3)]; uc <- data[,seq(3,15,3)]
        mu_ref <- ref[,seq(1,13,3)]; lc_ref <- ref[,seq(2,14,3)]; uc_ref <- ref[,seq(3,15,3)]

        # Draw different strains #
        for(i in 1:11){ # strain*sex
            plot(y[1:7],mu[matrix(1:77,11,7)[i,],test],xlim=c(min(y),max(y)),pch=i+2,type="o",lwd=1,axes=F, ylim=Y, xlab="", ylab="",col=alpha(cols[i],0.3),cex=1.3)
            arrows(y[1:7], lc[matrix(1:77,11,7)[i,],test], y[1:7], uc[matrix(1:77,11,7)[i,],test], angle = 90, length = 0.02,col=alpha(cols[i],0.3))
            arrows(y[1:7], uc[matrix(1:77,11,7)[i,],test], y[1:7], lc[matrix(1:77,11,7)[i,],test], angle = 90, length = 0.02,col=alpha(cols[i],0.3))
            par(new=T)
        }
        # Draw reference #
        plot(y[1:7],mu_ref[,test],xlim=c(min(y),max(y)),pch=1,lty=1,type="o",lwd=1.5,axes=F, ylim=Y, xlab="", ylab="",col=1,main=name_test[test],cex=1.3)
        par(new=T)
        if(test!=1) plot(y[1:7],mu_ref[,1],xlim=c(min(y),max(y)),pch=2,lty=3,type="o",lwd=1.5,axes=F, ylim=Y, xlab="", ylab="",col=1,main=NULL,cex=1.3)
        mtext("Power", side=2, line=3.5, las=0, col=1)
        mtext("Sample size", side=1, line=1, las=1, col=1)
        arrows(y[1:7], lc_ref[,test], y[1:7], uc_ref[,test], angle = 90, length = 0.02,col=1)
        arrows(y[1:7], uc_ref[,test], y[1:7], lc_ref[,test], angle = 90, length = 0.02,col=1)
        arrows(y[1:7], lc_ref[,1], y[1:7], uc_ref[,1], angle = 90, length = 0.02,col=1)
        arrows(y[1:7], uc_ref[,1], y[1:7], lc_ref[,1], angle = 90, length = 0.02,col=1)
        mtext(y[1:7], side=1, at=y[1:7], line=0) # x axis
        axis(2, pos = 0, at = seq(min(Y),max(Y),max(Y)/5), adj = 0, las = 2, cex.axis=1.5) # y axis
        abline(h=0.8, lty=2);
    }
    par(mgp=c(2.0,0.5,0.0), mai=c(0.0,0.0,0.0,0.0), ps=11)
    plot(y[1:7],mu_ref[,test],xlim=c(min(y),max(y)),pch=1,type="n",lwd=1,axes=F, ylim=Y, xlab="", ylab="",col=1,main=NULL)
    legend(5.0,1.0, legend = c("Reference (each test)","Reference (Student's)",name_strain), lwd=c(1.5,1.5,rep(1,11)),col=c(1,1,alpha(cols[1:11],0.3)), pch=c(1:13), lty=c(1,3,rep(1,11)), ncol = 1, cex=1.3)
    dev.off()
}



for(d in c(1.0,1.5,3.0)){ # Cohen's d
    if(d==1.0) Y=c(0.0,1); if(d==1.5) Y=c(0.0,1); if(d==3.0) Y=c(0.0,1)
    tiff(paste("figure2_power_test",format(d,nsmall=1),".tif",sep=""), res = 300, width = 7, height = 10, units = 'in')
    par(mgp=c(2.0,0.5,0.0), mai=c(0.3,0.6,0.2,0.1), ps=11); layout(matrix(1:12, 6, 2, byrow = FALSE))  
    for(strain in 1:11){ # strain*sex
        data = NULL
        ref = NULL
        for(n in y){ # sample size
            ref = rbind(ref, read.csv(paste(format(d,nsmall=1),"-",n,"-power.csv",sep=""),header=F))
            for(s in c('f','m')){ # sex
                for(stid in c(140,142,141,144,143,162)){ # strain
                    if(s=='f'&stid==144) next
                    data = rbind(data, read.csv(paste(stid,"-",n,"-",s,"-",format(d,nsmall=1),"-power.csv",sep=""),header=F))
                }
            }
        } 
        mu <- data[,seq(1,13,3)]; lc <- data[,seq(2,14,3)]; uc <- data[,seq(3,15,3)]
        mu_ref <- ref[,seq(1,13,3)]; lc_ref <- ref[,seq(2,14,3)]; uc_ref <- ref[,seq(3,15,3)]


        if(strain==4){
            par(mgp=c(2.0,0.5,0.0), mai=c(0.0,0.0,0.0,0.0), ps=11)
            plot(y[1:7],mu_ref[,1],xlim=c(min(y),max(y)),pch=1,type="n",lwd=1,axes=F, ylim=Y, xlab="", ylab="", col=2)
            legend(8.0,1.0, legend = c("Reference (Student's)","Student's","Welch's","Wilcoxon","Permutation","Bootstrap"),  lwd=c(1.5,rep(1,5)), col = c(1,alpha(2:6,0.3)), pch=c(1:6), lty=c(3,rep(1,5)), cex=1.5)
        }
        par(mgp=c(2.0,0.5,0.0), mai=c(0.3,0.6,0.2,0.1), ps=11)
        # Draw different tests #
        for(i in 1:5){ # test
            plot(y[1:7],mu[matrix(1:77,11,7)[strain,],i],xlim=c(min(y),max(y)),pch=i+1,type="o",lwd=1,axes=F, ylim=Y, xlab="", ylab="",col=alpha(i+1,0.3),cex=1.3)
            arrows(y[1:7], lc[matrix(1:77,11,7)[strain,],i], y[1:7], uc[matrix(1:77,11,7)[strain,],i], angle = 90, length = 0.02,col=alpha(i+1,0.3))
            arrows(y[1:7], uc[matrix(1:77,11,7)[strain,],i], y[1:7], lc[matrix(1:77,11,7)[strain,],i], angle = 90, length = 0.02,col=alpha(i+1,0.3))
            par(new=T)
        }
        # Draw reference (Student's t test) #
        plot(y[1:7],mu_ref[,1],xlim=c(min(y),max(y)),pch=1,type="o",lty=3,lwd=1.5,axes=F, ylim=Y, xlab="", ylab="",col=1,main="",cex=1.3)
        mtext("Power", side=2, line=3.0, las=0, col=1)
        mtext("Sample size", side=1, line=1, las=1, col=1)
        mtext(name_strain[strain], side=3, line=0, las=1, col=1)
        arrows(y[1:7], lc_ref[,1], y[1:7], uc_ref[,1], angle = 90, length = 0.02, col=1)
        arrows(y[1:7], uc_ref[,1], y[1:7], lc_ref[,1], angle = 90, length = 0.02, col=1)
        mtext(y[1:7], side=1, at=y[1:7], line=0) # x axis
        axis(2, pos = 2, at = seq(min(Y),max(Y),max(Y)/5), adj = 0, las = 2, cex.axis=1.5) # y axis
        abline(h=0.8, lty=2);
    }
    dev.off()
}