#setwd("C:/Users/kejima/Dropbox/Andrew_murine/JAX/power")
#setwd("/gpfs/home/k/e/kejima/Karst/thindrives/Andrew_murine/JAX/power")

library(openxlsx)
library(coin)
library(doParallel)
registerDoParallel(cores=2)
source("boot_perm.R")

cl <- makePSOCKcluster(4)
registerDoParallel(cl)
simu = 1000
set.seed(07202018) #arbitrarily set seed (date of first analysis)
for(d in c(1,1.5,3)){ # Cohen's D
	for(n in c(3,4,5,8,12,16,20)){ # sample size
		r <- foreach(icount(simu), .combine='rbind', .packages='coin') %dopar% {
			sample_w=rnorm(n,0,1)
			sample_m=rnorm(n,d,1)
			temp = NULL
			temp$val = c(sample_w, sample_m)
			temp$grp = factor(c(rep(1, length(sample_w)),rep(2, length(sample_m))))

			pval_t_regular = t.test(sample_w, sample_m,var.equal=T)$p.value
			pval_t_welch = t.test(sample_w, sample_m)$p.value
			pval_wil = pvalue(wilcox_test(val~grp, data=temp,distribution = "exact"))
			pval_perm = Permutation(sample_w, sample_m)
			pval_boot = Bootstrap(sample_w, sample_m)
			c(pval_t_regular, pval_t_welch, pval_wil, pval_perm, pval_boot)
		}
		write.table(r, append=F, paste(format(d,nsmall=1),"-",n,".csv",sep=""), row.names = F, col.names = F, sep=',')
	}
}
stopCluster(cl)
