#setwd("C:/Users/kejima/Dropbox/Andrew_murine/JAX")
rm(list = ls())
install.packages(c("openxlsx","plotrix","exactRankTests","effsize"))
library(openxlsx)
library(plotrix)
library(exactRankTests)
library(effsize)
source("boot_perm.R")
set.seed(5222017) #arbitrarily set seed (date of first analysis)

#### Read data ####
data = read.xlsx("data.xlsx",sheet=1)

##########
## Male ##
##########
s="m" # sex
#### B6 ####
wild = subset(data,strainid==7&sex==s) # control group (B6)
write.table(cbind(dim(wild)[1], mean(wild$value), sd(wild$value)),sep=',', "descriptivestat.csv",append=F,row.names=F,col.names=F)
for(stid in c(140,142,141,144)){
	mutant = subset(data,strainid==stid&sex==s) # mutant group
	write.table(cbind(dim(mutant)[1], mean(mutant$value), sd(mutant$value), t.test(wild$value, mutant$value,var.equal=T)$p.value, t.test(wild$value, mutant$value,var.equal=F)$p.value, wilcox.exact(wild$value, mutant$value,conf.int=T)$p.value, Permutation(wild$value, mutant$value), Bootstrap(wild$value, mutant$value), (mean(mutant$value)-mean(wild$value))/sqrt((sd(mutant$value)^2+sd(wild$value)^2)/2), var.test(wild$value, mutant$value)$p.value),
				sep=',', "descriptivestat.csv",append=T,row.names=F,col.names=F)
}
#### BK ####
wild = subset(data,strainid==35&sex==s) # control group (B6)
write.table(cbind(dim(wild)[1], mean(wild$value), sd(wild$value)),sep=',', "descriptivestat.csv",append=T,row.names=F,col.names=F)
for(stid in c(143,162)){
	mutant = subset(data,strainid==stid&sex==s) # mutant group
	write.table(cbind(dim(mutant)[1], mean(mutant$value), sd(mutant$value), t.test(wild$value, mutant$value,var.equal=T)$p.value, t.test(wild$value, mutant$value,var.equal=F)$p.value, wilcox.exact(wild$value, mutant$value,conf.int=T)$p.value, Permutation(wild$value, mutant$value), Bootstrap(wild$value, mutant$value), (mean(mutant$value)-mean(wild$value))/sqrt((sd(mutant$value)^2+sd(wild$value)^2)/2), var.test(wild$value, mutant$value)$p.value),
				sep=',', "descriptivestat.csv",append=T,row.names=F,col.names=F)
}
############
## Female ##
############
s='f' # sex
#### B6 ####
wild = subset(data,strainid==7&sex==s) # control group (BK)
write.table(cbind(dim(wild)[1], mean(wild$value), sd(wild$value)),sep=',', "descriptivestat.csv",append=T,row.names=F,col.names=F)
for(stid in c(140,142,141)){
	mutant = subset(data,strainid==stid&sex==s) # mutant group
	write.table(cbind(dim(mutant)[1], mean(mutant$value), sd(mutant$value), t.test(wild$value, mutant$value,var.equal=T)$p.value, t.test(wild$value, mutant$value,var.equal=F)$p.value, wilcox.exact(wild$value, mutant$value,conf.int=T)$p.value, Permutation(wild$value, mutant$value), Bootstrap(wild$value, mutant$value), (mean(mutant$value)-mean(wild$value))/sqrt((sd(mutant$value)^2+sd(wild$value)^2)/2), var.test(wild$value, mutant$value)$p.value),
				sep=',', "descriptivestat.csv",append=T,row.names=F,col.names=F)
}
#### BK ####
wild = subset(data,strainid==35&sex==s) # control group (BK)
write.table(cbind(dim(wild)[1], mean(wild$value), sd(wild$value)),sep=',', "descriptivestat.csv",append=T,row.names=F,col.names=F)
for(stid in c(143,162)){
	mutant = subset(data,strainid==stid&sex==s) # mutant group
	write.table(cbind(dim(mutant)[1], mean(mutant$value), sd(mutant$value), t.test(wild$value, mutant$value,var.equal=T)$p.value, t.test(wild$value, mutant$value,var.equal=F)$p.value, wilcox.exact(wild$value, mutant$value,conf.int=T)$p.value, Permutation(wild$value, mutant$value), Bootstrap(wild$value, mutant$value), (mean(mutant$value)-mean(wild$value))/sqrt((sd(mutant$value)^2+sd(wild$value)^2)/2), var.test(wild$value, mutant$value)$p.value),
				sep=',', "descriptivestat.csv",append=T,row.names=F,col.names=F)
}





##########
## Plot ##
##########
#### B6 ####
tiff(paste("figure_descriptive.tif",sep=""), res = 300, width = 8, height = 6, units = 'in')
par(ps = 10, cex = 1, mgp=c(2.0,1.0,0), mai=c(0.5,0.7,0.0,0.1))
wild = subset(data,strainid==7&sex=='f') # control group (B6)
plot(jitter(rep(0,dim(wild)[1]),amount=0.2), wild$value, xlim=range(-0.5,15.5), ylim=range(0,65), axes=FALSE, xlab='', ylab='Weight at baseline (grams/mouse)', col=2)
arrows(0, mean(wild$value)-1.96*sd(wild$value), 0, mean(wild$value)+1.96*sd(wild$value), angle = 90, length = 0.02, col=2,pch=1)
arrows(0, mean(wild$value)+1.96*sd(wild$value), 0, mean(wild$value)-1.96*sd(wild$value), angle = 90, length = 0.02, col=2,pch=1)
segments(-0.25, mean(wild$value), 0.25, mean(wild$value), col=2,pch=1)
wild = subset(data,strainid==7&sex=='m') # control group (B6)
points(jitter(rep(1,dim(wild)[1]),amount=0.2), wild$value, col=1,pch=16)
arrows(1, mean(wild$value)-1.96*sd(wild$value), 1, mean(wild$value)+1.96*sd(wild$value), angle = 90, length = 0.02, col=1,pch=16)
arrows(1, mean(wild$value)+1.96*sd(wild$value), 1, mean(wild$value)-1.96*sd(wild$value), angle = 90, length = 0.02, col=1,pch=16)
segments(0.75, mean(wild$value), 1.25, mean(wild$value), col=1,pch=16)

i=2
for(stid in c(140,142,141,144)){
	if(stid!=144){
		mutant = subset(data,strainid==stid&sex=='f') # mutant group
		points(jitter(rep(i,dim(mutant)[1]),amount=0.2), mutant$value, col=2,pch=1)
		arrows(i, mean(mutant$value)-1.96*sd(mutant$value), i, mean(mutant$value)+1.96*sd(mutant$value), angle = 90, length = 0.02, col=2)
		arrows(i, mean(mutant$value)+1.96*sd(mutant$value), i, mean(mutant$value)-1.96*sd(mutant$value), angle = 90, length = 0.02, col=2)
		segments(i-0.25, mean(mutant$value), i+0.25, mean(mutant$value), col=2,pch=1)
	}
	i=i+1
	mutant = subset(data,strainid==stid&sex=='m') # mutant group
	points(jitter(rep(i,dim(mutant)[1]),amount=0.2), mutant$value, col=1,pch=16)
	arrows(i, mean(mutant$value)-1.96*sd(mutant$value), i, mean(mutant$value)+1.96*sd(mutant$value), angle = 90, length = 0.02, col=1)
	arrows(i, mean(mutant$value)+1.96*sd(mutant$value), i, mean(mutant$value)-1.96*sd(mutant$value), angle = 90, length = 0.02, col=1)
	segments(i-0.25, mean(mutant$value), i+0.25, mean(mutant$value), col=1,pch=16)
	i=i+1
}

#### BK ####
wild = subset(data,strainid==35&sex=='f') # control group (BK)
points(jitter(rep(10,dim(wild)[1]),amount=0.2), wild$value, col=2)
arrows(10, mean(wild$value)-1.96*sd(wild$value), 10, mean(wild$value)+1.96*sd(wild$value), angle = 90, length = 0.02, col=2)
arrows(10, mean(wild$value)+1.96*sd(wild$value), 10, mean(wild$value)-1.96*sd(wild$value), angle = 90, length = 0.02, col=2)
segments(10-0.25, mean(wild$value), 10-0.25, mean(wild$value), col=2,pch=1)
wild = subset(data,strainid==35&sex=='m') # control group (BK)
points(jitter(rep(11,dim(wild)[1]),amount=0.2), wild$value, col=1,pch=16)
arrows(11, mean(wild$value)-1.96*sd(wild$value), 11, mean(wild$value)+1.96*sd(wild$value), angle = 90, length = 0.02, col=1)
arrows(11, mean(wild$value)+1.96*sd(wild$value), 11, mean(wild$value)-1.96*sd(wild$value), angle = 90, length = 0.02, col=1)
segments(11-0.25, mean(wild$value), 11-0.25, mean(wild$value), col=1,pch=16)

i=12
for(stid in c(143,162)){
	mutant = subset(data,strainid==stid&sex=='f') # mutant group
	points(jitter(rep(i,dim(mutant)[1]),amount=0.2), mutant$value, col=2,pch=1)
	arrows(i, mean(mutant$value)-1.96*sd(mutant$value), i, mean(mutant$value)+1.96*sd(mutant$value), angle = 90, length = 0.02, col=2)
	arrows(i, mean(mutant$value)+1.96*sd(mutant$value), i, mean(mutant$value)-1.96*sd(mutant$value), angle = 90, length = 0.02, col=2)
	segments(i-0.25, mean(mutant$value), i+0.25, mean(mutant$value), col=2,pch=1)
	i=i+1
	mutant = subset(data,strainid==stid&sex=='m') # mutant group
	points(jitter(rep(i,dim(mutant)[1]),amount=0.2), mutant$value, col=1,pch=16)
	arrows(i, mean(mutant$value)-1.96*sd(mutant$value), i, mean(mutant$value)+1.96*sd(mutant$value), angle = 90, length = 0.02, col=1)
	arrows(i, mean(mutant$value)+1.96*sd(mutant$value), i, mean(mutant$value)-1.96*sd(mutant$value), angle = 90, length = 0.02, col=1)
	segments(i-0.25, mean(mutant$value), i+0.25, mean(mutant$value), col=1,pch=16)
	i=i+1
}
axis(2, seq(0,65,by=5), las = 2)
name_strain = c("B6 (Control)", expression(italic(A^y)*'(B6)'),expression(italic(tub)*'(B6)'),expression(italic(Lep^ob)*'(B6)'),expression(italic(Lepr^db)*'(B6)'),
	"BK (Control)",expression(italic(Cpe^fat)*'(BK)'),expression(italic(Lepr^db)*'(BK)'))
num_animal = c(expression(n[f]*'=20'), expression(n[m]*'=20'),expression(n[f]*'=25'), expression(n[m]*'=34'),expression(n[f]*'=25'), expression(n[m]*'=26'),expression(n[f]*'=22'), expression(n[m]*'=30'),"",expression(n[m]*'=30'),
	expression(n[f]*'=27'), expression(n[m]*'=29'),expression(n[f]*'=19'), expression(n[m]*'=22'),expression(n[f]*'=28'), expression(n[m]*'=23'))
axis(1, at=seq(0,14,2)+0.5, name_strain, las = 1)
text(num_animal, x=seq(0,15,1), y=c(14,20,18,20,15,20,40,37,0,30,13,18,10,13,30,27), cex=0.9)
legend(0, 55, c("Female", "Male"), col=c(2,1), pch=c(1,16))
dev.off()








temp=NULL
D=1.0
##########
## Male ##
##########
s="m" # sex
#### B6 ####
wild = subset(data,strainid==7&sex==s) # control group (B6)
wild_plus = wild
for(stid in c(140,142,141,144)){
	mutant = subset(data,strainid==stid&sex==s) # mutant group
	## Mean weight difference with Cohen's D=1
	d = (mean(mutant$value)-mean(wild$value))/sqrt((sd(mutant$value)^2+sd(wild$value)^2)/2)
	incr = 0.0001
	while(abs(d-D)>0.0001){
		if(d>D){
			wild_plus$value = wild_plus$value + incr # shifting distribution
			d = (mean(mutant$value)-mean(wild_plus$value))/sqrt((sd(mutant$value)^2+sd(wild_plus$value)^2)/2)
		}
		if(d<D){
			wild_plus$value = wild_plus$value - incr # shifting distribution
			d = (mean(mutant$value)-mean(wild_plus$value))/sqrt((sd(mutant$value)^2+sd(wild_plus$value)^2)/2)
		}
	}
	temp=c(temp,mean(mutant$value)-mean(wild_plus$value))
}
#### BK ####
wild = subset(data,strainid==35&sex==s) # control group (BK)
wild_plus = wild
for(stid in c(143,162)){
	mutant = subset(data,strainid==stid&sex==s) # mutant group
	d = (mean(mutant$value)-mean(wild$value))/sqrt((sd(mutant$value)^2+sd(wild$value)^2)/2)
	incr = 0.0001
	while(abs(d-D)>0.0001){
		if(d>D){
			wild_plus$value = wild_plus$value + incr # shifting distribution
			d = (mean(mutant$value)-mean(wild_plus$value))/sqrt((sd(mutant$value)^2+sd(wild_plus$value)^2)/2)
		}
		if(d<D){
			wild_plus$value = wild_plus$value - incr # shifting distribution
			d = (mean(mutant$value)-mean(wild_plus$value))/sqrt((sd(mutant$value)^2+sd(wild_plus$value)^2)/2)
		}
	}
	temp=c(temp,mean(mutant$value)-mean(wild_plus$value))
}
############
## Female ##
############
s='f' # sex
#### B6 ####
wild = subset(data,strainid==7&sex==s) # control group (B6)
wild_plus = wild
for(stid in c(140,142,141)){
	mutant = subset(data,strainid==stid&sex==s) # mutant group
	d = (mean(mutant$value)-mean(wild$value))/sqrt((sd(mutant$value)^2+sd(wild$value)^2)/2)
	incr = 0.0001
	while(abs(d-D)>0.0001){
		if(d>D){
			wild_plus$value = wild_plus$value + incr # shifting distribution
			d = (mean(mutant$value)-mean(wild_plus$value))/sqrt((sd(mutant$value)^2+sd(wild_plus$value)^2)/2)
		}
		if(d<D){
			wild_plus$value = wild_plus$value - incr # shifting distribution
			d = (mean(mutant$value)-mean(wild_plus$value))/sqrt((sd(mutant$value)^2+sd(wild_plus$value)^2)/2)
		}
	}
	temp=c(temp,mean(mutant$value)-mean(wild_plus$value))
}
#### BK ####
wild = subset(data,strainid==35&sex==s) # control group (BK)
wild_plus = wild
for(stid in c(143,162)){
	mutant = subset(data,strainid==stid&sex==s) # mutant group
	d = (mean(mutant$value)-mean(wild$value))/sqrt((sd(mutant$value)^2+sd(wild$value)^2)/2)
	incr = 0.0001
	while(abs(d-D)>0.0001){
		if(d>D){
			wild_plus$value = wild_plus$value + incr # shifting distribution
			d = (mean(mutant$value)-mean(wild_plus$value))/sqrt((sd(mutant$value)^2+sd(wild_plus$value)^2)/2)
		}
		if(d<D){
			wild_plus$value = wild_plus$value - incr # shifting distribution
			d = (mean(mutant$value)-mean(wild_plus$value))/sqrt((sd(mutant$value)^2+sd(wild_plus$value)^2)/2)
		}
	}
	temp=c(temp,mean(mutant$value)-mean(wild_plus$value))
}

D=1.5
##########
## Male ##
##########
s="m" # sex
#### B6 ####
wild = subset(data,strainid==7&sex==s) # control group (B6)
wild_plus = wild
for(stid in c(140,142,141,144)){
	mutant = subset(data,strainid==stid&sex==s) # mutant group
	d = (mean(mutant$value)-mean(wild$value))/sqrt((sd(mutant$value)^2+sd(wild$value)^2)/2)
	incr = 0.0001
	while(abs(d-D)>0.0001){
		if(d>D){
			wild_plus$value = wild_plus$value + incr # shifting distribution
			d = (mean(mutant$value)-mean(wild_plus$value))/sqrt((sd(mutant$value)^2+sd(wild_plus$value)^2)/2)
		}
		if(d<D){
			wild_plus$value = wild_plus$value - incr # shifting distribution
			d = (mean(mutant$value)-mean(wild_plus$value))/sqrt((sd(mutant$value)^2+sd(wild_plus$value)^2)/2)
		}
	}
	temp=c(temp,mean(mutant$value)-mean(wild_plus$value))
}
#### BK ####
wild = subset(data,strainid==35&sex==s) # control group (BK)
wild_plus = wild
for(stid in c(143,162)){
	mutant = subset(data,strainid==stid&sex==s) # mutant group
	d = (mean(mutant$value)-mean(wild$value))/sqrt((sd(mutant$value)^2+sd(wild$value)^2)/2)
	incr = 0.0001
	while(abs(d-D)>0.0001){
		if(d>D){
			wild_plus$value = wild_plus$value + incr # shifting distribution
			d = (mean(mutant$value)-mean(wild_plus$value))/sqrt((sd(mutant$value)^2+sd(wild_plus$value)^2)/2)
		}
		if(d<D){
			wild_plus$value = wild_plus$value - incr # shifting distribution
			d = (mean(mutant$value)-mean(wild_plus$value))/sqrt((sd(mutant$value)^2+sd(wild_plus$value)^2)/2)
		}
	}
	temp=c(temp,mean(mutant$value)-mean(wild_plus$value))
}
############
## Female ##
############
s='f' # sex
#### B6 ####
wild = subset(data,strainid==7&sex==s) # control group (B6)
wild_plus = wild
for(stid in c(140,142,141)){
	mutant = subset(data,strainid==stid&sex==s) # mutant group
	d = (mean(mutant$value)-mean(wild$value))/sqrt((sd(mutant$value)^2+sd(wild$value)^2)/2)
	incr = 0.0001
	while(abs(d-D)>0.0001){
		if(d>D){
			wild_plus$value = wild_plus$value + incr # shifting distribution
			d = (mean(mutant$value)-mean(wild_plus$value))/sqrt((sd(mutant$value)^2+sd(wild_plus$value)^2)/2)
		}
		if(d<D){
			wild_plus$value = wild_plus$value - incr # shifting distribution
			d = (mean(mutant$value)-mean(wild_plus$value))/sqrt((sd(mutant$value)^2+sd(wild_plus$value)^2)/2)
		}
	}
	temp=c(temp,mean(mutant$value)-mean(wild_plus$value))
}
#### BK ####
wild = subset(data,strainid==35&sex==s) # control group (BK)
wild_plus = wild
for(stid in c(143,162)){
	mutant = subset(data,strainid==stid&sex==s) # mutant group
	d = (mean(mutant$value)-mean(wild$value))/sqrt((sd(mutant$value)^2+sd(wild$value)^2)/2)
	incr = 0.0001
	while(abs(d-D)>0.0001){
		if(d>D){
			wild_plus$value = wild_plus$value + incr # shifting distribution
			d = (mean(mutant$value)-mean(wild_plus$value))/sqrt((sd(mutant$value)^2+sd(wild_plus$value)^2)/2)
		}
		if(d<D){
			wild_plus$value = wild_plus$value - incr # shifting distribution
			d = (mean(mutant$value)-mean(wild_plus$value))/sqrt((sd(mutant$value)^2+sd(wild_plus$value)^2)/2)
		}
	}
	temp=c(temp,mean(mutant$value)-mean(wild_plus$value))
}


D=3.0
##########
## Male ##
##########
s="m" # sex
#### B6 ####
wild = subset(data,strainid==7&sex==s) # control group (B6)
wild_plus = wild
for(stid in c(140,142,141,144)){
	mutant = subset(data,strainid==stid&sex==s) # mutant group
	d = (mean(mutant$value)-mean(wild$value))/sqrt((sd(mutant$value)^2+sd(wild$value)^2)/2)
	incr = 0.0001
	while(abs(d-D)>0.0001){
		if(d>D){
			wild_plus$value = wild_plus$value + incr # shifting distribution
			d = (mean(mutant$value)-mean(wild_plus$value))/sqrt((sd(mutant$value)^2+sd(wild_plus$value)^2)/2)
		}
		if(d<D){
			wild_plus$value = wild_plus$value - incr # shifting distribution
			d = (mean(mutant$value)-mean(wild_plus$value))/sqrt((sd(mutant$value)^2+sd(wild_plus$value)^2)/2)
		}
	}
	temp=c(temp,mean(mutant$value)-mean(wild_plus$value))
}
#### BK ####
wild = subset(data,strainid==35&sex==s) # control group (BK)
wild_plus = wild
for(stid in c(143,162)){
	mutant = subset(data,strainid==stid&sex==s) # mutant group
	d = (mean(mutant$value)-mean(wild$value))/sqrt((sd(mutant$value)^2+sd(wild$value)^2)/2)
	incr = 0.0001
	while(abs(d-D)>0.0001){
		if(d>D){
			wild_plus$value = wild_plus$value + incr # shifting distribution
			d = (mean(mutant$value)-mean(wild_plus$value))/sqrt((sd(mutant$value)^2+sd(wild_plus$value)^2)/2)
		}
		if(d<D){
			wild_plus$value = wild_plus$value - incr # shifting distribution
			d = (mean(mutant$value)-mean(wild_plus$value))/sqrt((sd(mutant$value)^2+sd(wild_plus$value)^2)/2)
		}
	}
	temp=c(temp,mean(mutant$value)-mean(wild_plus$value))
}
############
## Female ##
############
s='f' # sex
#### B6 ####
wild = subset(data,strainid==7&sex==s) # control group (B6)
wild_plus = wild
for(stid in c(140,142,141)){
	mutant = subset(data,strainid==stid&sex==s) # mutant group
	d = (mean(mutant$value)-mean(wild$value))/sqrt((sd(mutant$value)^2+sd(wild$value)^2)/2)
	incr = 0.0001
	while(abs(d-D)>0.0001){
		if(d>D){
			wild_plus$value = wild_plus$value + incr # shifting distribution
			d = (mean(mutant$value)-mean(wild_plus$value))/sqrt((sd(mutant$value)^2+sd(wild_plus$value)^2)/2)
		}
		if(d<D){
			wild_plus$value = wild_plus$value - incr # shifting distribution
			d = (mean(mutant$value)-mean(wild_plus$value))/sqrt((sd(mutant$value)^2+sd(wild_plus$value)^2)/2)
		}
	}
	temp=c(temp,mean(mutant$value)-mean(wild_plus$value))
}
#### BK ####
wild = subset(data,strainid==35&sex==s) # control group (BK)
wild_plus = wild
for(stid in c(143,162)){
	mutant = subset(data,strainid==stid&sex==s) # mutant group
	d = (mean(mutant$value)-mean(wild$value))/sqrt((sd(mutant$value)^2+sd(wild$value)^2)/2)
	incr = 0.0001
	while(abs(d-D)>0.0001){
		if(d>D){
			wild_plus$value = wild_plus$value + incr # shifting distribution
			d = (mean(mutant$value)-mean(wild_plus$value))/sqrt((sd(mutant$value)^2+sd(wild_plus$value)^2)/2)
		}
		if(d<D){
			wild_plus$value = wild_plus$value - incr # shifting distribution
			d = (mean(mutant$value)-mean(wild_plus$value))/sqrt((sd(mutant$value)^2+sd(wild_plus$value)^2)/2)
		}
	}
	temp=c(temp,mean(mutant$value)-mean(wild_plus$value))
}
write.table(temp, sep=',', "weight-change.csv",append=F,row.names=F,col.names=F)