### Bootstrap test ###
Bootstrap <- function(a,b){
  n <- ifelse(max(length(a),length(b))<=4, 199, 999) # number of bootstrap samples
  t_boots <- NULL # new object to hold vector of t statistic
  t_obs <- t.test(a,b)$statistic # observed t statistic for inputs
  a.index <- c(1:length(a))
  b.index <- c(1:length(b))
  pooled.data <- c(a,b)
  a_null <- a - mean(a) + mean(pooled.data)
  b_null <- b - mean(b) + mean(pooled.data)
  for(i in 1:n){
    boot.index1 <- sample(a.index,length(a),replace=TRUE)
    boot.index2 <- sample(b.index,length(b),replace=TRUE)
    b1 <- a_null[boot.index1]
    b2 <- b_null[boot.index2]
    if(var(b1)==0 && var(b2)==0){
      if(b1[1]==b2[1]){ # if all the samples are same, t statistic is zero
        t_boots <- rbind(t_boots, 0)
      }else{ # if all the samples of each group are same but different between groups, t statistic is Inf
        t_boots <- rbind(t_boots, Inf)
      }
		}else{
      t_star <- t.test(b1,b2)$statistic
      t_boots <- rbind(t_boots, t_star)
    }
  }
  Boots_p <- (sum(abs(t_boots) >= abs(t_obs))+1)/(n+1)
  return(Boots_p)
}

### Permutation test ###
Permutation <- function(a,b){
  n <- ifelse(max(length(a),length(b))<=4, 199, 999) # number of permutation samples
  t_boots <- NULL # new object to hold vector of t statistic
  t_obs <- t.test(a,b)$statistic # observed t statistic for inputs
  index <- c(1:length(c(a,b)))
  pooled.data <- c(a,b)
  a_null <- a - mean(a) + mean(pooled.data)
  b_null <- b - mean(b) + mean(pooled.data)
  pool_null <- c(a_null,b_null)
  for(i in 1:n){
    boot.index1 <- sample(index,length(a),replace=FALSE)
    boot.index2 <- setdiff(index, boot.index1)
    b1 <- pool_null[boot.index1]
    b2 <- pool_null[boot.index2]
    if(var(b1)==0 && var(b2)==0){
      if(b1[1]==b2[1]){ # if all the samples are same, t statistic is zero
        t_boots <- rbind(t_boots, 0)
      }else{ # if all the samples of each group are same but different between groups, t statistic is Inf
        t_boots <- rbind(t_boots, Inf)
      }
		}else{
      t_star <- t.test(b1,b2)$statistic
      t_boots <- rbind(t_boots, t_star)
    }
  }
  Boots_p <- (sum(abs(t_boots) >= abs(t_obs))+1)/(n+1)
  return(Boots_p)
}
