# Example 17_angr_arbitrary_jump
## Context

## Script

1. Load the file and initialize memory with zero
```
load '17_angr_arbitrary_jump'
unconstrained_fill True
```
2. Since scanf is not supported, we start the execution after the scanf call, create 3 symex symbols and assign the symbols to the registers containing the scanf result.
```
add_symbol input 100

keep_unconstrained

set_entry_state stdin=&sym.input


```
3. Add an address filter to break on 'Good Job' and exclude states that output 'Try again'
```
def not_ready():
    list_states 'active'
    
while (not_ready):
    step
    unc = list_states 'unconstrained'
    if unc:
        print "found"
        break
```

4. Obtain the results
```
select_state 0 'unconstrained'

add_constraint &reg.eip == 0x4d435250

chops = chop_symbol &sym.input 8
for c in chops :
    add_constraint c >= b'A' && c <= b'Z'

to_str (evaluate &sym.input)
```