# Example 16_angr_arbitrary_write

## Context

## Script

1. Load the file and initialize memory with zero
```
load '16_angr_arbitrary_write'
unconstrained_fill True
```
2. Since scanf is not supported, we start the execution after the scanf call, create 3 symex symbols and assign the symbols to the registers containing the scanf result.
```

def scanf(format_string, address0, address1):
    add_symbol scanf0 4
    add_symbol scanf1 20
    chops = &(chop_symbol &sym.scanf1 8)
    for c in chops :
        add_constraint c >= 48 && c <= 96
    set_memory address0 &sym.scanf0 endness=MEMORY
    set_memory address1 &sym.scanf1
    add_to_state solution0 &sym.scanf0
    add_to_state solution1 &sym.scanf1

hook_function  "scanf" "__isoc99_scanf" 

def check_strncpy():
    dst = get_memory (&reg.esp+4) 4 endness=MEMORY
    src = get_memory (&reg.esp+8) 4 endness=MEMORY
    length = get_memory (&reg.esp+12) 4 endness=MEMORY
    contents = get_memory src length
    if (is_symbolic contents):
        if (is_symbolic dst):
            !print(&vars.src)
            pwd = b'NEDVTNOP'
            buffer = 0x4d43523c
            c1 = contents[-1:-64] == pwd
            c2 = dst == buffer
            !print(&vars.c1)
            if (satisfiable c1 && c2):
                add_constraint c1 && c2
                return True
    return False

```
3. Add an address filter to break on 'Good Job' and exclude states that output 'Try again'
```
fcp = make_filter check_strncpy
af = by_address 0x8048410
breakpoint af fcp
run
```

4. Obtain the results
```
sol0 = get_from_state solution0
sol1 = get_from_state solution1
s0 = to_int (evaluate sol0)
s1 = to_str (evaluate sol1)
!("{} {}".format(&vars.s0,&vars.s1))
```