# Example 15_angr_arbitrary_read
## Context

## Script

1. Load the file and initialize memory with zero
```
load '15_angr_arbitrary_read'
unconstrained_fill True
```
2. Since scanf is not supported, we start the execution after the scanf call, create 3 symex symbols and assign the symbols to the registers containing the scanf result.
```

def scanf(format_string, address0, address1):
    add_symbol scanf0 4
    add_symbol scanf1 20
    chops = &(chop_symbol &sym.scanf1 8)
    for c in chops:
        add_constraint c >= b'A'
        add_constraint c <= b'Z'
    set_memory address0 &sym.scanf0 endness=MEMORY
    set_memory address1 &sym.scanf1
    add_to_state solution0 &sym.scanf0
    add_to_state solution1 &sym.scanf1

hook_function  "scanf" "__isoc99_scanf" 

def check_puts():
    esp4 = &reg.esp + 4
    puts = get_memory esp4 4 endness=MEMORY
    if (is_symbolic puts):
        if (satisfiable puts == 0x4f534957):
            add_constraint puts == 0x4f534957
            return True
    return False

```
3. Add an address filter to break on 'Good Job' and exclude states that output 'Try again'
```
breakpoint (by_address 0x8048370) (make_filter check_puts)
run
```

4. Obtain the results
```
sol0 = get_from_state solution0
sol1 = get_from_state solution1
s0 = to_int sol0!
s1 = to_bytes sol1!
!("{} {}".format(&vars.s0,&vars.s1))
```