# Example 14_angr_shared_library
## Context

## Script

1. Load the file and initialize memory with zero
```
base = 0x4000000
load "lib14_angr_shared_library.so" base_addr=base
```
2. Since scanf is not supported, we start the execution after the scanf call, create 3 symex symbols and assign the symbols to the registers containing the scanf result.
```

validate_function_address = base + 0x670

set_call_state validate_function_address 0x3000000 8

add_symbol "password" 8

set_memory 0x3000000 &sym.password

```
3. Add an address filter to break on 'Good Job' and exclude states that output 'Try again'
```
check_constraint_address = base + 0x71c

breakpoint (by_address check_constraint_address)

run

# since we break at the end of the basic block/function, we go to the next state (and hence, execute the block containing the address 0x400071c)

step
```

4. Obtain the results
```
add_constraint &reg.eax != 0

to_str (evaluate &sym.password)

```